/**************************************************************************
*
*                  Copyright (c) 2013 ZTE Corporation.
*
***************************************************************************
* ģ   : psm_297520V2.c
*    : psm_2975V2.c
* ļ : 
* ʵֹ : ʡ(power save manager)
*      : ߻
*      : V0.1
*  : 2013.11.15
* ˵ : 
**************************************************************************/

#ifdef _USE_PSM

/**************************************************************************
* #include
**************************************************************************/
#include "oss_api.h"
#include "drvs_pow.h"
#include "drvs_pwr.h"
#include "drvs_ret.h"
#include "sup.h"
#include "osa.h"
#ifdef _USE_PSM_TEST
#include "sys_func_atcfg.h"
#endif
#ifdef _OS_LINUX
#include <linux/time.h>
#include <linux/sched.h>
#endif

/**************************************************************************
* 궨
**************************************************************************/
#define ZOSS_PSM_THREAD_TOTAL_TIME_MIN          3000
#define ZOSS_PSM_IGNORE_THREAD_TOTAL_TIME_MIN   1000
#define ZOSS_PSM_IDLE_CPU_LOAD                  70

/**************************************************************************
* ⲿͱ
**************************************************************************/
//gsml1 ṩĺ
extern BOOL   zGsml1_AttemptSleep(UINT32 mode);
extern UINT32 zGsml1_PsmGetSleepTime(VOID);
extern BOOL   zGsml1_PsmIdleFlag(VOID);
extern BOOL   zGsml1_PsmGetCampon(VOID);

//Эջṩĺ
extern BYTE   zPs_IsGsmMasterMode(VOID);
extern BOOL   zPs_PsmIdleFlag(VOID);
extern BOOL   zAti2_PsIsInFlyMode(VOID);
extern BOOL   zAti2_PsRfNotOpen(VOID);
extern BYTE   zPS_umm_IsLossOfCoverage(VOID);

//ṩĺ
extern BOOL   zDrvPow_PsmGetCampon(VOID);
extern BOOL   zDrvPow_PsmIdleFlag(VOID);

extern UINT64 gTimer_CurTime;

/**************************************************************************
* ݽṹ
**************************************************************************/
/*ʱ䲹ṹ*/
typedef struct
{
    T_ZOss_Node         node;
    psm_CompensateHook  psm_CompensateHook;
} T_zPsm_CompensateNode;

#ifdef _USE_CPU_DFM
typedef enum
{
    PSM_PULL_CPUFREQ,   /* Ƶ */
    PSM_UP_CPUFREQ,     /* Ƶһ */
    PSM_DOWN_CPUFREQ    /* Ƶ     */
} T_zPsm_FmScope;
#endif

/**************************************************************************
* ֲԭ
**************************************************************************/
static VOID   psm_IdleThreadEntry(SINT32 ignore);
static BOOL   psm_CampOnSleepCheck(VOID);
static VOID   psm_CampOnSleep(VOID);
static VOID   psm_LossCoverageSleep(VOID);
static VOID   psm_AirplaneSleep(VOID);
static VOID   psm_NoCfunSleep(VOID);
static BOOL   psm_CampOnCheck(VOID);
static VOID   psm_SleepTimeCompensate(UINT32 sleepTime);
static VOID   psm_PowerOnSleep(VOID);
static VOID   psm_BootSleep(VOID);
static BOOL   psm_CheckSleepTime(BOOL modeHaveGsm);
static BOOL   psm_CheckSleepFlag(VOID);              
static BOOL   psm_SleepCheck(VOID);
static VOID   psm_CompensateTicks(UINT32 sleepTime);
static VOID   psm_CompensateTimer(UINT32 sleepTime);
#ifdef _OS_LINUX
static VOID   psm_CompensateTimeKeeper(UINT32 sleepTime);
#endif
static BOOL   psm_AppIdleFlag(VOID);
static UINT32 psm_GetPreSleepTime(VOID);
static BOOL   Psm_PlatIdleFlag(VOID);

#ifdef _USE_CPU_DFM
static UINT32 psm_GetIgnoreThreadTime(VOID);
static VOID   psm_GetIdleCpuLoad(UINT32 *pIdleCpuLoad);
static VOID   psm_ClearIIT(VOID);
static UINT32 psm_GetDesCpuFreq(UINT32 curCpuFreq, UINT32 dfmFlag);
static UINT32 psm_FindDesCpuFreq(UINT32 cpuload, UINT32 curCpuFreq);
static UINT32 psm_FindMinCpuFreq(VOID);
static VOID   psm_InterruptRoutine(SINT32 args);
static VOID   psm_SetIgnoreThread(VOID);
static UINT32 psm_GetCpuFreq(UINT32 ait);
static UINT32 psm_GetAIT(UINT32 idleThreadCpu);
static VOID   psm_ClearThreadCpu(VOID);
static VOID   psm_DfmWakeUpReset(VOID);
#endif

/**************************************************************************
* ȫֳ/
**************************************************************************/
T_zPsm_Param    *g_zPsmCfg               = NULL;
UINT32          g_zPsm_SleepTime         = 0;   /* ϵͳʱ                 */
UINT32          g_zPsm_CurCpuFreq        = 0;   /* ǰƵ                     */

#ifdef _USE_CPU_DFM
static  UINT32  g_zPsm_SwapLastTime      = 0;
UINT32          g_zPsm_SumCpuTime        = 0;        
ZOSS_THREAD_ID  g_zPsm_CurThread         = NULL;
ZOSS_THREAD_ID  *g_zPsm_IgnoreThreadId   = NULL;
#endif

static UINT32   g_zPsm_AppIdleFlag       = 0;   /* Ӧÿб־˯ */
static UINT32   g_zPsm_PreSleeptime      = 0;   /* Ԥڵ˯ʱ           */
static ZOSS_THREAD_ID g_zPsm_PsmThreadId = NULL;
static UINT32   g_zPsm_SleepTicksTime    = 0;   /* ڲticksֵ˯ʱ    */
static T_ZOss_List g_zPsm_CmpnstFuncList = {0}; /* ģ鲹         */
static psm_SleepInitHook   g_zPsm_SleepInitHook         = NULL;
static psm_SleepFinishHook g_zPsm_SleepFinishHook       = NULL;
static psm_SleepBeforeHook g_zPsm_SleepBeforeHook       = NULL;
static psm_SleepAfterHook  g_zPsm_SleepAfterHook        = NULL;
static volatile T_zPsm_BootStage g_zPsm_BootStateFlag   = PSM_BOOT_DEFAULT; /* ϵͳ׶α־λ */

#ifdef _USE_CPU_DFM
static BOOL     g_zPsm_DfmFlag              = FALSE;
static UINT32   g_zPsm_IITCnt               = 0;
static UINT32   g_zPsm_DfmCnt               = 0;
static UINT32   g_zPsm_SumIIT               = 0;
static UINT32   g_zPsm_MinCpuFreq           = 0;
static BOOL     g_zPsm_DfmFinishFlag        = FALSE;
static SINT32   *g_zPsm_IIT                 = NULL;
static FLOAT    g_zPsm_IgnoreThreadTimeRate = 0.6;
static UINT32   g_zPsm_IgnoreThreadIndex    = 0;
#endif

#ifdef _OS_LINUX
static BOOL     g_zPsm_BooTSleepFlag = FALSE;
#endif

/**************************************************************************
* ֲʵ
**************************************************************************/

/**************************************************************************
* ƣpsm_IdleThreadEntry
* ʡ߳
* ˵(IN)
*               
*           (OUT)
*               
*   ֵ
* ˵
**************************************************************************/
static VOID psm_IdleThreadEntry(SINT32 ignore)
{
    if (g_zPsm_SleepInitHook != NULL)
        g_zPsm_SleepInitHook();
    
    psm_BootSleep();
    
    for( ; ; )
    {
#ifdef _USE_PSM_TEST
        if(!zSys_SetR7SleepType(R7_PLAT_NO_SLEEP))
#endif
        {
            if (psm_CampOnSleepCheck())               // ˯;
            {
                psm_CampOnSleep();
            }
            else if(zPS_umm_IsLossOfCoverage())       // ʧ˯;
            {
                psm_LossCoverageSleep();
            }
            else if(zAti2_PsIsInFlyMode())            // ģʽ˯̣                
            {
                psm_AirplaneSleep();
            }
            else if(zAti2_PsRfNotOpen())             // ϵ粻˯
            {
                psm_NoCfunSleep();
            }
        
            zDrvPow_Sleep_Func(KERNEL_SLEEP_MODE, 0); // ģʽ뵽ںʡ;
        }

        if (g_zPsm_SleepFinishHook != NULL)
            g_zPsm_SleepFinishHook();
    }
}

/**************************************************************************
* ƣpsm_GetPreSleepTime
* Ԥڵ˯ʱ
* ˵(IN)
*               
*           (OUT)
*               
*   ֵ 
* ˵ʹжϣ
************************************************************************/
static UINT32 psm_GetPreSleepTime(VOID)   
{
    return g_zPsm_PreSleeptime;
}

/**************************************************************************
* ƣpsm_BootSleep
* ǰʡ紦
* ˵(IN)
*               
*           (OUT)
*               
*   ֵ
* ˵idle̵߳ãg_zPsmBootStateFlagʹó豣
**************************************************************************/
static VOID psm_BootSleep(VOID) 
{   
    while (g_zPsm_BootStateFlag == PSM_BOOT_DEFAULT)
        ;

    while (!psm_CampOnCheck() && g_zPsm_BootStateFlag != PSM_BOOT_FINISH)
    {
        psm_PowerOnSleep();
    }

    g_zPsm_BootStateFlag = PSM_BOOT_FINISH;
}

/**************************************************************************
* ƣpsm_CampOnSleepCheck
* Сפ˯жϺ
* ˵(IN)
*               
*           (OUT)
*                        
*   ֵTRUEʾԽ˯,FALSEʾܽ˯;
* ˵
**************************************************************************/
static BOOL psm_CampOnSleepCheck(VOID)
{   
    if (psm_CampOnCheck())
    {
        return psm_SleepCheck();
    }

    return FALSE;
}

/**************************************************************************
* ƣpsm_CampOnCheck
* жǷפɹ
* ˵(IN)
*               
*           (OUT)
*               
*   ֵTRUE:ԽߣFALSE:ܽ
* ˵ 
**************************************************************************/
static BOOL psm_CampOnCheck(VOID)   
{
    return (zDrvPow_PsmGetCampon() || zGsml1_PsmGetCampon());
}

/**************************************************************************
* ƣpsm_SleepCheck
* жܷ Լģʽ
* ˵(IN)
*               
*           (OUT)
*               
*   ֵTRUE:ԽߣFALSE:ܽ
* ˵
**************************************************************************/
static BOOL psm_SleepCheck(VOID)
{
    if (zGsml1_AttemptSleep(FALSE) && zPs_PsmIdleFlag() && Psm_PlatIdleFlag() && psm_AppIdleFlag() && zDrvPow_PsmIdleFlag())
    {
        return TRUE;
    }
    return FALSE;
}

/**************************************************************************
* ƣpsm_BootSleepCheck
* жܷ Լģʽ
* ˵(IN)
*               
*           (OUT)
*               
*   ֵTRUE:ԽߣFALSE:ܽ
* ˵
**************************************************************************/
static BOOL psm_BootSleepCheck(VOID)
{
    if (Psm_PlatIdleFlag() && psm_AppIdleFlag() && zDrvPow_PsmIdleFlag())
    {
        return TRUE;
    }
    return FALSE;
}

/**************************************************************************
* ƣpsm_CheckSleepTime
* ж˯ʱǷģʽ
* ˵(IN)
*               modeHaveGsm : ǰϵͳģʽǷGSM,TRUEʾУFALSE
*                             ʾûУ
*           (OUT)
*               
*   ֵ TRUE:˯ߣFALSE:ܽ
* ˵ жʹãҪ
**************************************************************************/
static BOOL psm_CheckSleepTime(BOOL modeHaveGsm)
{
    g_zPsm_PreSleeptime = min(zGsml1_PsmGetSleepTime(), zOss_GetPs_SleepTimer());
    return (g_zPsm_PreSleeptime > g_zPsmCfg->deepSleepTimeThreshold);
}

/**************************************************************************
* ƣpsm_SleepMode
* ȡʡ˯ģʽ
* ˵(IN)
*               
*           (OUT)
*                        
*   ֵTURE:˯ˣFALSE:˯ߣ
* ˵жʹãҪ
**************************************************************************/
static BOOL psm_SleepMode(VOID)
{
    return (psm_CheckSleepTime(FALSE) && psm_CheckSleepFlag());
}

/**************************************************************************
* ƣpsm_CheckSleepFlag
* жܷߵȴ
* ˵(IN)
*               
*           (OUT)
*               
*   ֵTRUE:ԽߵȴFALSE:ܽߵȴ
* ˵
**************************************************************************/
static BOOL psm_CheckSleepFlag(VOID)
{
    return (!zGsml1_PsmIdleFlag() && zDrvPow_PsmIdleFlag() && Psm_PlatIdleFlag() && psm_AppIdleFlag() && zPs_PsmIdleFlag());
}

/**************************************************************************
* ƣpsm_BootCheckSleepFlag
* BOOT sleep˯߷ʽжܷߵȴ
* ˵(IN)
*               
*           (OUT)
*               
*   ֵTRUE:ԽߵȴFALSE:ܽߵȴ
* ˵
**************************************************************************/
static BOOL psm_BootCheckSleepFlag(VOID)
{
    return (!zGsml1_PsmIdleFlag() && zDrvPow_PsmIdleFlag() && Psm_PlatIdleFlag() && psm_AppIdleFlag());
}

/**************************************************************************
* ƣpsm_SleepTimeCompensate
* ˯ʱ䲹
* ˵(IN)
*               sleepTime : ʱ
*           (OUT)
*               
*   ֵ
* ˵жжУʲжϱ
**************************************************************************/
static VOID psm_SleepTimeCompensate(UINT32 sleepTime)
{
    T_zPsm_CompensateNode *pCmpnstNode = (T_zPsm_CompensateNode *)zOss_ListFirst(&g_zPsm_CmpnstFuncList);

    while(pCmpnstNode != NULL)
    {
        pCmpnstNode->psm_CompensateHook(sleepTime);
        pCmpnstNode = (T_zPsm_CompensateNode *)zOss_ListNext(&(pCmpnstNode->node));
    }
}

/**************************************************************************
* ƣpsm_PowerOnSleep
* ǰʡ紦
* ˵(IN)
*               
*           (OUT)
*               
*   ֵ
* ˵
**************************************************************************/
static VOID psm_PowerOnSleep(VOID)
{ 
    ZOSS_INTR old_intr;
  
    if (!psm_BootSleepCheck())
        return;
    
    ZOSS_SAVE_IRQ(old_intr);
        
#ifdef _OS_LINUX
    if (need_resched())
    {
        ZOSS_RESTORE_IRQ(old_intr);  
        return;
    }        
#endif


    if (g_zPsm_SleepBeforeHook != NULL)
        g_zPsm_SleepBeforeHook();
    
    if ((g_zPsm_BootStateFlag == PSM_SYSINIT_FINISH) && psm_BootCheckSleepFlag())
    {
        UINT32 sleepTime   = zOss_GetPs_SleepTimer();  
        if(sleepTime > g_zPsmCfg->deepSleepTimeThreshold)
        {
            g_zPsm_SleepTime = zDrvPow_Sleep_Func(BOOT_SLEEP_MODE, sleepTime);
            psm_SleepTimeCompensate(g_zPsm_SleepTime);
#ifdef _USE_CPU_DFM
            psm_DfmWakeUpReset();
#endif            
        }
    }

    if (g_zPsm_SleepAfterHook != NULL)
        g_zPsm_SleepAfterHook();
    
    ZOSS_RESTORE_IRQ(old_intr);  
    
    if ((g_zPsmCfg->bootOverClk!= 0) && (g_zPsmCfg->bootOverClk != g_zPsm_CurCpuFreq))
    {
        zDrvPow_SetArmPsCoreFreq(g_zPsmCfg->bootOverClk);
    }

    zDrvPow_Sleep_Func(KERNEL_SLEEP_MODE, 0);
}

/**************************************************************************
* ƣpsm_AirplaneSleep 
* ģʽ˯
* ˵(IN)
*               
*           (OUT)
*                                     
*   ֵ
* ˵
**************************************************************************/
static VOID psm_AirplaneSleep(VOID)
{
    ZOSS_INTR old_intr;

    if(!psm_SleepCheck())
        return;

    ZOSS_SAVE_IRQ(old_intr); 
        
#ifdef _OS_LINUX
    if (need_resched())
    {
        ZOSS_RESTORE_IRQ(old_intr);  
        return;
    }        
#endif

    if (g_zPsm_SleepBeforeHook != NULL)
        g_zPsm_SleepBeforeHook();
    
    if(psm_CheckSleepFlag() && zAti2_PsIsInFlyMode())
    {
        UINT32 timeLen   = min(g_zPsmCfg->airPlaneSleepTime, zOss_GetPs_SleepTimer());
        g_zPsm_SleepTime = zDrvPow_Sleep_Func(AIRPLANE_SLEEP_MODE, timeLen);
        psm_SleepTimeCompensate(g_zPsm_SleepTime);
#ifdef _USE_CPU_DFM                    
        psm_DfmWakeUpReset();
#endif
    }
    
    if (g_zPsm_SleepAfterHook != NULL)
        g_zPsm_SleepAfterHook();
    
    ZOSS_RESTORE_IRQ(old_intr);
}

/**************************************************************************
* ƣpsm_NoCfunSleep 
* ϵ粻״̬˯
* ˵(IN)
*               
*           (OUT)
*                                     
*   ֵ
* ˵
**************************************************************************/
static VOID psm_NoCfunSleep(VOID)
{
    ZOSS_INTR old_intr;
    UINT32 timeLen   = 0;
    
    if(zOss_GetTickCount() >= 5000)    //ϵ粻5s˯
    {
        if(!psm_SleepCheck())
            return;

        ZOSS_SAVE_IRQ(old_intr); 
            
        #ifdef _OS_LINUX
        if (need_resched())
        {
            ZOSS_RESTORE_IRQ(old_intr);  
            return;
        }        
        #endif

        if (g_zPsm_SleepBeforeHook != NULL)
            g_zPsm_SleepBeforeHook();
        
        if(psm_CheckSleepFlag()&& zAti2_PsRfNotOpen()) 
        {
            timeLen = zOss_GetPs_SleepTimer();
            g_zPsm_SleepTime = zDrvPow_Sleep_Func(DEEP_SLEEP_MODE, timeLen);
            psm_SleepTimeCompensate(g_zPsm_SleepTime);
            #ifdef _USE_CPU_DFM                    
            psm_DfmWakeUpReset();
            #endif
        }
        
        if (g_zPsm_SleepAfterHook != NULL)
            g_zPsm_SleepAfterHook();
        
        ZOSS_RESTORE_IRQ(old_intr);
    }
}

/**************************************************************************
* ƣpsm_CampOnSleep
* פ˯
* ˵(IN)
*               
*           (OUT)
*               
*   ֵ
* ˵
**************************************************************************/
static VOID psm_CampOnSleep(VOID)
{
    ZOSS_INTR old_intr;
    
    ZOSS_SAVE_IRQ(old_intr); 
    
#ifdef _OS_LINUX
    if (need_resched())
    {
        ZOSS_RESTORE_IRQ(old_intr);  
        return;
    }        
#endif

    if (g_zPsm_SleepBeforeHook != NULL)
        g_zPsm_SleepBeforeHook();
    
    if (psm_SleepMode())  
    {
        g_zPsm_SleepTime = zDrvPow_Sleep_Func(DEEP_SLEEP_MODE, psm_GetPreSleepTime());
        psm_SleepTimeCompensate(g_zPsm_SleepTime);                  
#ifdef _USE_CPU_DFM
        psm_DfmWakeUpReset();
#endif
    }
    
    if (g_zPsm_SleepAfterHook != NULL)
        g_zPsm_SleepAfterHook();
    
    ZOSS_RESTORE_IRQ(old_intr);      
}

/**************************************************************************
* ƣpsm_LossCoverageSleep
* ʧ˯
* ˵(IN)
*               
*           (OUT)
*               
*   ֵ
* ˵
**************************************************************************/
static VOID psm_LossCoverageSleep(VOID)
{
    ZOSS_INTR old_intr;

    if(!psm_SleepCheck())
        return;
   
    ZOSS_SAVE_IRQ(old_intr); 
        
#ifdef _OS_LINUX
    if (need_resched())
    {
        ZOSS_RESTORE_IRQ(old_intr);  
        return;
    }        
#endif

    if (g_zPsm_SleepBeforeHook != NULL)
        g_zPsm_SleepBeforeHook();
    
    if(psm_CheckSleepFlag())
    {
        UINT32 sleepTime   = zOss_GetPs_SleepTimer();    

        if (zPS_umm_IsLossOfCoverage() && (sleepTime > g_zPsmCfg->deepSleepTimeThreshold))
        {
            g_zPsm_SleepTime = zDrvPow_Sleep_Func(LOSSCOVERAGE_SLEEP_MODE, sleepTime);
            psm_SleepTimeCompensate(g_zPsm_SleepTime);
#ifdef _USE_CPU_DFM                      
            psm_DfmWakeUpReset();
#endif
        }
    }
    
    if (g_zPsm_SleepAfterHook != NULL)
        g_zPsm_SleepAfterHook();
    
    ZOSS_RESTORE_IRQ(old_intr);
}

/**************************************************************************
* ƣpsm_CompensateOssSleepTime 
* ƽ̨֧ticksֵ
* ˵(IN)
*               sleepTime: ʱ,λ:ms
*           (OUT)
*               
*   ֵ
* ˵жʹãҪ
**************************************************************************/
static VOID psm_CompensateTicks(UINT32 sleepTime)
{
#ifdef _OS_TOS
    cyg_add_current_time(sleepTime/ZOSS_MS_PER_TICK);
#else
    g_zPsm_SleepTicksTime += sleepTime;    
#endif
}

/**************************************************************************
* ƣpsm_CompensateOssSleepTime 
* ƽ̨֧Ŷʱ
* ˵(IN)
*               sleepTime: ʱ,λ:ms
*           (OUT)
*               
*   ֵ
* ˵жʹãҪ
**************************************************************************/
static VOID psm_CompensateTimer(UINT32 sleepTime)
{
    gTimer_CurTime += sleepTime;
}

#ifdef _OS_LINUX
/**************************************************************************
* ƣpsm_CompensateTimeKeeper 
* TimeKeeper
* ˵(IN)
*               sleepTime: ʱ,λ:ms
*           (OUT)
*               
*   ֵ
* ˵жʹãҪ
**************************************************************************/

static VOID psm_CompensateTimeKeeper(UINT32 sleepTime)
{
    struct timespec timesleep = {0};
    
    timesleep.tv_sec = sleepTime/1000;
    timesleep.tv_nsec = 1000000 *(sleepTime%1000);
    timekeeping_inject_sleeptime(&timesleep);  
}
#endif

/**************************************************************************
* ƣpsm_AppIdleFlag 
* жӦǷУ
* ˵(IN)
*               
*           (OUT)
*               
*   ֵӦñ־λ
* ˵жʹãҪ
**************************************************************************/
static BOOL psm_AppIdleFlag(VOID)
{
    return (g_zPsm_AppIdleFlag == 0);
}

/**************************************************************************
* ƣPsm_PlatIdleFlag 
* жƽ̨Ƿ˯
* ˵(IN)
*               
*           (OUT)
*               
*   ֵӦñ־λ
* ˵жʹãҪ 
**************************************************************************/
static BOOL Psm_PlatIdleFlag(VOID)
{
    return (g_zPsm_SleepTime == 0);
}

/**************************************************************************
* ƣPsm_CompensateInit 
* ʡ粹ʼ
* ˵(IN)
*               
*           (OUT)
*               
*   ֵ
* ˵ 
**************************************************************************/
static VOID Psm_CompensateInit(VOID)
{
    zOss_ListInit(&g_zPsm_CmpnstFuncList);
    zOss_RegSleepCompensateFunc(psm_CompensateTicks);
    zOss_RegSleepCompensateFunc(psm_CompensateTimer);
#ifdef _OS_LINUX
    zOss_RegSleepCompensateFunc(psm_CompensateTimeKeeper);
#endif
}

#ifdef _USE_CPU_DFM

/**************************************************************************
* ƣPsm_DfmInit 
* ̬Ƶʼ
* ˵(IN)
*               
*           (OUT)
*               
*   ֵ
* ˵ 
**************************************************************************/
static VOID Psm_DfmInit(VOID)
{
    g_zPsm_CurCpuFreq = zDrvPow_GetPsCoreFreq();
    g_zPsm_IIT = (SINT32 *)zOss_Malloc(sizeof(SINT32) * g_zPsmCfg->dfmCnt);
    zOss_AssertExN(g_zPsm_IIT != NULL);
    zOss_Memset(g_zPsm_IIT, 0, (sizeof(SINT32) * g_zPsmCfg->dfmCnt));
    g_zPsm_IgnoreThreadId = (ZOSS_THREAD_ID *)zOss_Malloc(g_zPsmCfg->ignoreThreadCnt * sizeof(ZOSS_THREAD_ID));
    zOss_AssertExN(g_zPsm_IgnoreThreadId != NULL);
    zOss_Memset(g_zPsm_IgnoreThreadId, 0, g_zPsmCfg->ignoreThreadCnt * sizeof(ZOSS_THREAD_ID));   
#ifdef _OS_OSE
    start(create_process(OS_TI_PROC, "PSM_TIMER_ISR", (OSENTRYPOINT *)psm_InterruptRoutine, (OSADDRESS)1024 * 20,
          (OSPRIORITY)g_zPsmCfg->dfmThrdPri, (OSTIME)g_zPsmCfg->dfmPeriod, (PROCESS)0, (struct OS_redir_entry *)NULL, (OSVECTOR)0, (OSUSER)0));
#endif
}

/**************************************************************************
* ƣpsm_DfmWakeUpReset
* ˯ҪҪ¼gPsm_AIT
* ˵(IN)
*               
*           (OUT)
*               
*   ֵ
* ˵жʹãҪ
**************************************************************************/
static VOID psm_DfmWakeUpReset(VOID) 
{
    g_zPsm_CurCpuFreq = zDrvPow_GetPsCoreFreq();
    psm_ClearThreadCpu();
    psm_ClearIIT();
    g_zPsm_SumCpuTime   = 0;
    g_zPsm_DfmFlag      = FALSE;
    g_zPsm_SwapLastTime = Osa_HwTimeRead();
}

/**************************************************************************
* ƣpsm_GetIgnoreThreadTime
* ȡ̵߳ʱ
* ˵(IN)
*               
*           (OUT)
*               
*   ֵ
* ˵
**************************************************************************/
static UINT32 psm_GetIgnoreThreadTime(VOID)
{
    UINT32 psmIgnoreTime                = 0;
    T_ZOsa_ThreadUserArea *pPsmThreadUa = NULL;
    SINT32              i               = 0;
    
    for (i = 0; i < g_zPsm_IgnoreThreadIndex; i++)
    {
        pPsmThreadUa = zOss_GetThreadUserArea(g_zPsm_IgnoreThreadId[i]);
        if (pPsmThreadUa != NULL)
        {
            psmIgnoreTime += pPsmThreadUa->psmCpuTime;
        }
    }
    
    return psmIgnoreTime;
}

/**************************************************************************
* ƣpsm_GetIdleCpuLoad
* ȡϵͳиأ
* ˵(IN)
*               
*           (OUT)
*               idlecpuLoad: cpuʣ
*   ֵ
* ˵
**************************************************************************/
static VOID psm_GetIdleCpuLoad(UINT32 *pIdleCpuLoad)
{
    SINT32 psmIgnoreTime                = 0; 
    SINT32 totaltime                    = 0; 
    SINT32 psmIdleTime                  = 0; 
    SINT32 tmpIIT                       = 0; 
    T_ZOsa_ThreadUserArea *pPsmThreadUa = NULL;
    SINT32 tmpPsmTime                   = Osa_HwTimeRead() - g_zPsm_SwapLastTime;
    
    totaltime = g_zPsm_SumCpuTime + tmpPsmTime;
    
    if (totaltime < ZOSS_PSM_THREAD_TOTAL_TIME_MIN)
    {
        *pIdleCpuLoad = ZOSS_PSM_IDLE_CPU_LOAD;
    }
    else
    {
        if (g_zPsm_CurThread != NULL)
        {
            pPsmThreadUa =  zOss_GetThreadUserArea(g_zPsm_CurThread);
            if (pPsmThreadUa != NULL)
            {
                pPsmThreadUa->psmCpuTime += tmpPsmTime ;
            }
        }
        
        pPsmThreadUa  = zOss_GetThreadUserArea(g_zPsm_PsmThreadId);
        psmIdleTime   = pPsmThreadUa->psmCpuTime;
        psmIgnoreTime = psm_GetIgnoreThreadTime();
        if ((psmIgnoreTime > ZOSS_PSM_IGNORE_THREAD_TOTAL_TIME_MIN) || (psmIdleTime < psmIgnoreTime) || (totaltime - psmIgnoreTime == 0))
        {
            tmpIIT = (psmIdleTime + psmIgnoreTime * g_zPsm_IgnoreThreadTimeRate);
            tmpIIT = (tmpIIT * 100) / totaltime;
        }
        else
        {
            tmpIIT = (psmIdleTime - psmIgnoreTime);
            tmpIIT = (tmpIIT * 100) / (totaltime - psmIgnoreTime);
        }
        *pIdleCpuLoad = tmpIIT;
    }
}

/**************************************************************************
* ƣpsm_ClearThreadCpu
* ̵߳cpuļʱʱ
* ˵(IN)
*               
*           (OUT)
*               
*   ֵ
* ˵
**************************************************************************/
static VOID psm_ClearThreadCpu(VOID)
{
    UINT32                i             = 0;
    T_ZOsa_ThreadUserArea *pPsmThreadUa = NULL;
    
    pPsmThreadUa             = zOss_GetThreadUserArea(g_zPsm_PsmThreadId);
    pPsmThreadUa->psmCpuTime = 0;
    for (i= 0; i < g_zPsm_IgnoreThreadIndex; i++)
    {
        pPsmThreadUa = zOss_GetThreadUserArea(g_zPsm_IgnoreThreadId[i]);
        if (pPsmThreadUa != NULL)
        {
            pPsmThreadUa->psmCpuTime = 0;
        }
    }
}

/**************************************************************************
* ƣpsm_ClearIITTime
* ̵߳cpuļʱʱ
* ˵(IN)
*               
*           (OUT)
*               
*   ֵ
* ˵жʹãҪ
**************************************************************************/
static VOID psm_ClearIIT(VOID)
{
    g_zPsm_DfmCnt   = 0;
    g_zPsm_SumIIT   = 0;
    g_zPsm_DfmFlag  = FALSE;
    zOss_Memset(g_zPsm_IIT, 0, (sizeof(SINT32) * g_zPsmCfg->dfmCnt));
}

/**************************************************************************
* ƣpsm_GetDesCpuFreq
* 
* ˵(IN)
*               curCpuFreq:     ǰϵͳƵ
*               dfmFlag:        Ƶȼ
*           (OUT)
*               
*   ֵcpuĿƵ
* ˵
**************************************************************************/
static UINT32 psm_GetDesCpuFreq(UINT32 curCpuFreq, UINT32 dfmFlag)
{
    UINT32 i = 0;
    
    for (i= 0; i < g_zPsmCfg->desClkNum; i++)
    {
        if (g_zPsmCfg->desClk[i].curCpuFreq == curCpuFreq)
        {
            switch (dfmFlag)
            {
            case PSM_UP_CPUFREQ:
                {
                    return g_zPsmCfg->desClk[i].upCpuFreq;
                }
            case PSM_DOWN_CPUFREQ:
                {
                    return g_zPsmCfg->desClk[i].downCpuFreq;
                }
            case PSM_PULL_CPUFREQ:
                {
                    return  g_zPsmCfg->desClk[i].pullCpuFreq;
                }
            default:
                break;
            }
        }
    }
    
    return  curCpuFreq;
}

/**************************************************************************
* ƣpsm_FindDesCpuFreq
* ȡĿCPUƵ
* ˵(IN)
*               cpuload:    cpuʹ
*               curCpuFreq: ǰƵ
*           (OUT)
*               
*   ֵcpu̬Ƶ
* ˵жʹãҪ
**************************************************************************/
static UINT32 psm_FindDesCpuFreq(UINT32 cpuload, UINT32 curCpuFreq)
{
    UINT32 desCpuFreq = 0;

    if ((cpuload >= g_zPsmCfg->scaleCpuPcnt.downCpuPercent) && (cpuload < g_zPsmCfg->scaleCpuPcnt.upCpuPercent))
    {
        desCpuFreq = curCpuFreq;
    }
    else if (cpuload >= g_zPsmCfg->scaleCpuPcnt.pullCpuPercent)
    {
        desCpuFreq = psm_GetDesCpuFreq(curCpuFreq, PSM_PULL_CPUFREQ);
    }
    else if (cpuload >= g_zPsmCfg->scaleCpuPcnt.upCpuPercent)
    {
        desCpuFreq = psm_GetDesCpuFreq(curCpuFreq, PSM_UP_CPUFREQ);
    }
    else
    {
        desCpuFreq = psm_GetDesCpuFreq(curCpuFreq, PSM_DOWN_CPUFREQ);
    }
    
    return desCpuFreq;
}

/**************************************************************************
* ƣPSM_FindMinCpuClk
* жCPUƵǷƵ
* ˵(IN)
*               
*           (OUT)
*               
*   ֵҪƵ
* ˵жʹãҪ
**************************************************************************/
static UINT32 psm_FindMinCpuFreq(VOID)
{
    SINT32 i = 0;
    
    for (i = 0; i < g_zPsmCfg->sysClkNum; i++)
    {
        if (g_zPsm_MinCpuFreq > g_zPsmCfg->sysClk[i])
        {
            continue;
        }
        
        return g_zPsmCfg->sysClk[i];
    }
    
    return g_zPsmCfg->sysClk[g_zPsmCfg->sysClkNum - 1];
}

/**************************************************************************
* ƣpsm_GetCpuFreq
* ȡϵͳƵ
* ˵(IN)  
*               ait: ƽ
*           (OUT)
*               
*   ֵ ϵͳƵ
* ˵ жʹãҪ
**************************************************************************/
static UINT32 psm_GetCpuFreq(UINT32 ait)
{
    UINT32 desCpuFreq  = 0;
    UINT32 minCpuFreq  = 0;
    
    if (g_zPsm_DfmFlag)
    {
        desCpuFreq = psm_FindDesCpuFreq((100 - ait), g_zPsm_CurCpuFreq);
    }
    else
    {
        desCpuFreq = g_zPsm_CurCpuFreq;
    }
    
    minCpuFreq = psm_FindMinCpuFreq();
    
    return max(desCpuFreq,minCpuFreq);
}

/**************************************************************************
* ƣpsm_GetAIT
* ȡAIT(ƽ)
* ˵(IN)
*               idleThreadCpu: cpuʣ
*           (OUT)
*               ޣ
*   ֵAIT
* ˵ڵһ߳УҪ
**************************************************************************/
static UINT32 psm_GetAIT(UINT32 idleThreadCpu)
{
    g_zPsm_SumIIT               += idleThreadCpu - g_zPsm_IIT[g_zPsm_IITCnt];
    g_zPsm_IIT[g_zPsm_IITCnt++] = idleThreadCpu;

    if(g_zPsm_IITCnt >= g_zPsmCfg->dfmCnt)
    {
        g_zPsm_IITCnt = 0;
    }
    
    return g_zPsm_SumIIT/g_zPsm_DfmCnt;
}

/**************************************************************************
* ƣpsm_InterruptRoutine
* жϷ
* ˵(IN)
*               args: ߳ںĲ
*   ֵ
* ˵ڸúвҪʹԺ
**************************************************************************/
static VOID psm_InterruptRoutine(SINT32 args)
{
    UINT32 idleCpuLoad  = 0;
    UINT32 ait          = 0;
    UINT32 cpuFreq      = 0;
    
    if (g_zPsm_DfmFinishFlag)
    {
        if ( g_zPsm_DfmCnt >= g_zPsmCfg->dfmCnt)
        {
            g_zPsm_DfmFlag = TRUE;          
        }
        else
        {
            g_zPsm_DfmCnt++;
        }
        psm_GetIdleCpuLoad(&idleCpuLoad);
        ait     = psm_GetAIT(idleCpuLoad);
        cpuFreq = psm_GetCpuFreq(ait);
        if (cpuFreq != g_zPsm_CurCpuFreq)
        {
            SINT32 retCode = zDrvPow_SetArmPsCoreFreq(cpuFreq);
            zOss_AssertExN(retCode == DRV_SUCCESS);
            psm_ClearIIT();
            g_zPsm_CurCpuFreq = cpuFreq;
        }
        psm_ClearThreadCpu();  
        g_zPsm_SumCpuTime   = 0;
        g_zPsm_SwapLastTime = Osa_HwTimeRead();
    }
}

/**************************************************************************
* ƣpsm_SetIgnoreThread
* ú߳
* ˵
*   ֵ
* ˵
**************************************************************************/
static VOID psm_SetIgnoreThread(VOID)
{
    UINT32  i  = 0;
    
    g_zPsm_IgnoreThreadIndex = 0;    
    for (i = 0; i < g_zPsmCfg->ignoreThreadCnt; i++)
    {
        zOss_SetIgnoreThread(zOss_GetThreadIDByName(g_zPsmCfg->pIgnoreThreadNameArry[i]));
    }
}

#endif //_USE_CPU_DFM

/**************************************************************************
* ȫֺʵ
**************************************************************************/

/**************************************************************************
* ƣzOss_PsmInit
* ʡʼ
* ˵(IN)
*               
*           (OUT)
*               
*   ֵɹZOSS_SUCCESS,ʧܷZOSS_ERROR
* ˵
**************************************************************************/
UINT32 zOss_PsmInit(VOID)
{
    g_zPsmCfg          = &(zOss_GetOssCfg()->PsmCfg);

#ifndef _OS_LINUX
    g_zPsm_PsmThreadId = zOss_CreateThread("zOss_ThreadPsm", psm_IdleThreadEntry, 0, 2 * 1024, 31, 1, 1);
    zOss_AssertEx(g_zPsm_PsmThreadId != NULL, ZOSS_ERROR);
    
#ifdef _OS_TOS
    zOss_SuspendThread((ZOSS_THREAD_ID)cyg_thread_idle_thread());
#endif

#endif /* _OS_LINUX */

    Psm_CompensateInit();

#ifdef _USE_CPU_DFM  
    Psm_DfmInit();
#endif

    return ZOSS_SUCCESS;
}

/**************************************************************************
* ƣzOss_SetBootStage
* ϵͳʼɱ־λ
* ˵(IN)
*               stage:ɱ־
*           (OUT)
*               
*   ֵ
* ˵
**************************************************************************/
VOID zOss_SetBootStage(T_zPsm_BootStage stage)
{
    ZOSS_INTR old_intr;
    
    ZOSS_SAVE_IRQ(old_intr); 
    g_zPsm_BootStateFlag = stage;
    ZOSS_RESTORE_IRQ(old_intr);
}

/**************************************************************************
* ƣzOss_GetBootStage
* ȡϵͳʼɱ־λ
* ˵(IN)
*               
*           (OUT)
*               
*   ֵϵͳʼɱ־λ
* ˵
**************************************************************************/
T_zPsm_BootStage zOss_GetBootStage(void)
{
    ZOSS_INTR old_intr;
    T_zPsm_BootStage stage;
    
    ZOSS_SAVE_IRQ(old_intr);
    stage = g_zPsm_BootStateFlag;
    ZOSS_RESTORE_IRQ(old_intr);
    
    return stage;
}

/**************************************************************************
* ƣzOss_SetPSMAppIdle
* ָ˯ӦΪ״̬Կ32Ӧã
* ˵(IN)
*               appId:ӦеӦid
*           (OUT)
*               
*   ֵɹZOSS_SUCCESS
* ˵
**************************************************************************/
UINT32 zOss_SetPSMAppIdle(UINT32 appId)
{
    ZOSS_INTR old_intr;
    
    ZOSS_SAVE_IRQ(old_intr); 
    g_zPsm_AppIdleFlag = g_zPsm_AppIdleFlag & (~ (1 << appId));
    ZOSS_RESTORE_IRQ(old_intr);
    
    return ZOSS_SUCCESS;
}

/**************************************************************************
* ƣzOss_SetPSMAppActive
* ָ˯ӦΪæ״̬Կ32Ӧ
* ˵(IN)
*               appId:ӦæӦid
*           (OUT)
*               
*   ֵɹZOSS_SUCCESS
* ˵
**************************************************************************/
UINT32 zOss_SetPSMAppActive(UINT32 appId)
{
    ZOSS_INTR old_intr;
    
    ZOSS_SAVE_IRQ(old_intr); 
    g_zPsm_AppIdleFlag = g_zPsm_AppIdleFlag | (1 << appId);
    ZOSS_RESTORE_IRQ(old_intr);
    
    return ZOSS_SUCCESS;
}

/**************************************************************************
* ƣzOss_SetSleepFuncOpt 
* ˯߹Ӻ
* ˵(IN)
*               beforeHook: ˯ǰӺ
*               afterHook:  ˯ߺӺ
*           (OUT)
*   ֵ
* ˵ûʹõĹӺעΪNULL 
**************************************************************************/
VOID zOss_SetSleepHookOpt(psm_SleepInitHook  initHook, psm_SleepFinishHook  finishHook, psm_SleepBeforeHook  beforeHook, psm_SleepAfterHook afterHook)
{
    if (initHook != NULL)
        g_zPsm_SleepInitHook    = initHook;

    if (finishHook != NULL)
        g_zPsm_SleepFinishHook  = finishHook;   
    
    if (beforeHook != NULL)
        g_zPsm_SleepBeforeHook  = beforeHook;

    if (afterHook != NULL)
        g_zPsm_SleepAfterHook   = afterHook;    
}

/**************************************************************************
* ƣzOss_RegSleepCompensateFunc 
* ˯ʱ䲹עắ
* ˵(IN)
*               funcOpt: עᲹ
*           (OUT)
*               
*   ֵʡ粹ID;
* ˵ 
**************************************************************************/
ZOSS_COMPENSATE_ID zOss_RegSleepCompensateFunc(psm_CompensateHook funcOpt)
{
    ZOSS_INTR old_intr;
    T_zPsm_CompensateNode *pCmpnstNode = (T_zPsm_CompensateNode *)zOss_Malloc(sizeof(T_zPsm_CompensateNode));

    zOss_AssertEx(pCmpnstNode != NULL, NULL);
    zOss_Memset(pCmpnstNode, 0, sizeof(T_zPsm_CompensateNode));
    ZOSS_SAVE_IRQ(old_intr);  
    pCmpnstNode->psm_CompensateHook = funcOpt;
    zOss_ListAdd(&g_zPsm_CmpnstFuncList, &(pCmpnstNode->node));
    ZOSS_RESTORE_IRQ(old_intr); 

    return (ZOSS_COMPENSATE_ID )pCmpnstNode;
}

/**************************************************************************
* ƣzOss_DeregSleepCompensateFunc 
* ˯ʱ䲹ע
* ˵(IN)
*               pPsmCmpnstID: ʡ粹ID;
*           (OUT)
*               
*   ֵ
* ˵
**************************************************************************/
VOID zOss_DeregSleepCompensateFunc(ZOSS_COMPENSATE_ID psmCmpnstId)
{
    ZOSS_INTR old_intr;
    T_zPsm_CompensateNode *pCmpnstNode = (T_zPsm_CompensateNode *)psmCmpnstId;

    ZOSS_SAVE_IRQ(old_intr); 
    zOss_ListDelete(&g_zPsm_CmpnstFuncList, &(pCmpnstNode->node));
    ZOSS_RESTORE_IRQ(old_intr); 
    zOss_Free(psmCmpnstId);
}

/**************************************************************************
* ƣzOss_CompensateTicks
* ϵͳticksֵλ:tick
* ˵(IN)
*               
*           (OUT)
*               
*   ֵزticksֵ
* ˵
**************************************************************************/
UINT32 zOss_CompensateTicks(VOID)
{
    ZOSS_INTR old_intr;
    UINT32 ticks = 0;
    
    ZOSS_SAVE_IRQ(old_intr); 
    ticks = g_zPsm_SleepTicksTime/ZOSS_MS_PER_TICK;
    ZOSS_RESTORE_IRQ(old_intr);
    
    return ticks;     
}

/**************************************************************************
* ƣzOss_ClearSleepTime
* ˯ʱ䣻
* ˵(IN)
*               
*           (OUT)
*               
*   ֵ
* ˵
**************************************************************************/
VOID zOss_ClearSleepTime(VOID)
{
    ZOSS_INTR old_intr;
    
    ZOSS_SAVE_IRQ(old_intr);
    g_zPsm_SleepTime = 0;
    ZOSS_RESTORE_IRQ(old_intr);
}

/**************************************************************************
* ƣzOss_PsmAdjustFreq312M
* ϵͳڶ̬̲߳˳߳ʱARMƵΪ78M£ose_heapd߳
*           жϴ400usµGP0⣬ڷʱ򣬰Ƶ312M,
*           Ȼɶ̬Ƶģ鸺Ƶȥ
* ˵(IN)
*               
*           (OUT)
*               
*   ֵ ZOSS_SUCCESS
* ˵ úzOss_ExitThreadʹ
************************************************************************/
#ifdef _OS_OSE
UINT32 zOss_PsmAdjustFreq312M(VOID)
{
    if (zDrvPow_GetPsCoreFreq() < CLK312M)
    {
        zDrvPow_SetArmPsCoreFreq(CLK312M);
        
#ifdef _USE_CPU_DFM
        psm_DfmWakeUpReset();
#endif
        g_zPsm_CurCpuFreq = CLK312M;
    }

    return ZOSS_SUCCESS;
}
#endif

#ifdef _OS_LINUX
/**************************************************************************
* ƣzOss_PsmInitHook
* ˯߳ʼӺ
* ˵(IN)
*               
*           (OUT)
*               
*   ֵ 
* ˵ 
**************************************************************************/
VOID zOss_PsmInitHook(VOID)
{ 
    if (g_zPsm_SleepInitHook != NULL)
        g_zPsm_SleepInitHook();
}

/**************************************************************************
* ƣzOss_PsmFinshHook
* ˯߽Ӻ
* ˵(IN)
*               
*           (OUT)
*               
*   ֵ 
* ˵ 
**************************************************************************/
VOID zOss_PsmFinshHook(VOID)
{ 
    if (g_zPsm_SleepFinishHook != NULL)
        g_zPsm_SleepFinishHook();
}
/**************************************************************************
* ƣzOss_PsmBootSleep
* boot˯ں
* ˵(IN)
*               
*           (OUT)
*               
*   ֵ 
* ˵ 
**************************************************************************/
VOID zOss_PsmBootSleep(VOID)
{
    if(!g_zPsm_BooTSleepFlag)
    {
        if (g_zPsm_SleepInitHook != NULL)
            g_zPsm_SleepInitHook();
    
         psm_BootSleep();  
        
        g_zPsm_BooTSleepFlag = TRUE;
        printk("psm_BootSleep");
    }
}

/**************************************************************************
* ƣzOss_IdleEnter
* ˯ߴں
* ˵(IN)
*               
*           (OUT)
*               
*   ֵ 
* ˵ 
**************************************************************************/
VOID zOss_PsmEnter(VOID)
{ 
#ifdef _USE_PSM_TEST
    if(zSys_SetR7SleepType(R7_PLAT_NO_SLEEP))
		return;
#endif

    if (psm_CampOnSleepCheck())                   // ˯;
    {
        psm_CampOnSleep();
    }
    else if(zPS_umm_IsLossOfCoverage())           // ʧ˯;
    {
        psm_LossCoverageSleep();
    }
    else if(zAti2_PsIsInFlyMode())                // ģʽ˯;                
    {
        psm_AirplaneSleep();
    }
	else
	    zDrvPow_Sleep_Func(KERNEL_SLEEP_MODE, 0); //ģʽ뵽ںʡ
}

#endif

/**************************************************************************
* ƣ zOss_PsmTraceInfo
*  psmĵϢ
* ˵ 
*   ֵ 
* ˵
**************************************************************************/
VOID zOss_PsmTraceInfo(VOID)
{
    zOss_Printf(SUBMDL_SHELL, PRINT_LEVEL_ABNORMAL,"GsmAttemptFlag = %d, GsmFlag = %d, PsFlag = %d, PlatFlag = %d, AppFlag = %d, DrvFlag = %d",
                zGsml1_AttemptSleep(FALSE), !zGsml1_PsmIdleFlag(), zPs_PsmIdleFlag(), Psm_PlatIdleFlag(), psm_AppIdleFlag(), zDrvPow_PsmIdleFlag());
    zOss_Printf(SUBMDL_SHELL, PRINT_LEVEL_ABNORMAL,"GsmSleepTime = %d, PsSleepTime = %d", zGsml1_PsmGetSleepTime(), zOss_GetPs_SleepTimer());
    zOss_Printf(SUBMDL_SHELL, PRINT_LEVEL_ABNORMAL,"SleepTicks = %d", g_zPsm_SleepTicksTime);
    zOss_Printf(SUBMDL_SHELL, PRINT_LEVEL_ABNORMAL,"CampON = %d, LossOfCoverage = %d, FlyMode = %d", psm_CampOnCheck(), zPS_umm_IsLossOfCoverage(),
                zAti2_PsIsInFlyMode());
    zOss_Printf(SUBMDL_SHELL, PRINT_LEVEL_ABNORMAL,"TickCnt = %d", zOss_GetTickCount());
}
#ifdef _USE_CPU_DFM

/******************************************************************
* ƣzOss_ApplyCpuFreq
* Ƶ
* ˵(IN)         
*               appid:ƵID;
*               isUsed:TRUEʱƵFALSEʱнƵ;
*           (OUT)
*               
*   ֵɹZOSS_SUCCESSʧܷZOSS_ERROR
* ˵߳ʹã
**************************************************************************/
UINT32 zOss_ApplyCpuFreq(UINT32 appId, BOOL isUsed)
{
    ZOSS_INTR old_intr;
    
    ZOSS_SAVE_IRQ(old_intr); 
    if (isUsed)
    {
        if (!g_zPsmCfg->minClk[appId].isUsed)
        {
            g_zPsm_MinCpuFreq += g_zPsmCfg->minClk[appId].cpuClk;
        }
    }
    else
    {
        if (g_zPsmCfg->minClk[appId].isUsed)
        {
            g_zPsm_MinCpuFreq -= g_zPsmCfg->minClk[appId].cpuClk;
        }
    }
    
    g_zPsmCfg->minClk[appId].isUsed = isUsed;
    if (g_zPsm_MinCpuFreq > g_zPsm_CurCpuFreq)
    {
        SINT32 retCode    = DRV_SUCCESS; 

        g_zPsm_CurCpuFreq = psm_FindMinCpuFreq();
        retCode           = zDrvPow_SetArmPsCoreFreq(g_zPsm_CurCpuFreq);
        zOss_AssertEx(retCode == DRV_SUCCESS, ZOSS_ERROR);
        psm_ClearIIT();
    } 
    ZOSS_RESTORE_IRQ(old_intr);
    
    return ZOSS_SUCCESS;
}

/**************************************************************************
* ƣzOss_SetIgnoreThreadTimeRate 
* ú߳ʱ(̵ִ߳ʱΪidle̵߳ʱ)
* ˵(IN)
*               timeRate: ʱ
*           (OUT)
*               
*   ֵ
* ˵ 
**************************************************************************/
VOID zOss_SetIgnoreThreadTimeRate(FLOAT timeRate)
{
    ZOSS_INTR old_intr;
    
    ZOSS_SAVE_IRQ(old_intr); 
    g_zPsm_IgnoreThreadTimeRate = timeRate;
    ZOSS_RESTORE_IRQ(old_intr); 
}

/**************************************************************************
* ƣzOss_ThreadSwapInPsmHook 
* : ߳ʱʡ繳 
* ˵: (IN)  
*               user_area:  ̵߳ûָ
*           (OUT)
*               
*   ֵ:     
* ˵:     
**************************************************************************/
VOID zOss_ThreadSwapInPsmHook(T_ZOsa_ThreadUserArea *user_area)
{
    ZOSS_INTR   old_intr;
    UINT32      past_time       = 0;
    UINT32      current_time    = 0;
    
    zOss_AssertExN(user_area != NULL);
    ZOSS_SAVE_IRQ(old_intr);
    current_time          = Osa_HwTimeRead();
    past_time             = current_time - g_zPsm_SwapLastTime;
    g_zPsm_SumCpuTime     += past_time;
    user_area->psmCpuTime += past_time;
    g_zPsm_CurThread      = user_area->threadid;
    g_zPsm_SwapLastTime   = current_time;
    ZOSS_RESTORE_IRQ(old_intr);
}

/**************************************************************************
* ƣzOss_THreadSwapOutPsmHook 
* : ߳гʱʡ繳
* ˵: (IN)  
*               user_area:  ̵߳ûָ
*           (OUT)  
*               
*   ֵ:     
* ˵:     
**************************************************************************/
VOID zOss_ThreadSwapOutPsmHook(T_ZOsa_ThreadUserArea *user_area)
{
    ZOSS_INTR   old_intr;
    UINT32      past_time       = 0;
    UINT32      current_time    = 0;

    zOss_AssertExN(user_area != NULL);
    ZOSS_SAVE_IRQ(old_intr);
    current_time          = Osa_HwTimeRead();
    past_time             = current_time - g_zPsm_SwapLastTime;
    g_zPsm_SumCpuTime     += past_time;
    user_area->psmCpuTime += past_time;
    g_zPsm_CurThread      = NULL;
    g_zPsm_SwapLastTime   = current_time;
    ZOSS_RESTORE_IRQ(old_intr);
}

/**************************************************************************
* ƣzOss_RecordPsmLastSwapTime 
* : ¼ʡһ߳лʱ䣻
* ˵: (IN)  
*                   
*           (OUT)
*               
*   ֵ:     
* ˵:     
**************************************************************************/
VOID zOss_RecordPsmLastSwapTime(VOID)
{
    ZOSS_INTR old_intr  = 0;
    
    ZOSS_SAVE_IRQ(old_intr);
    g_zPsm_SwapLastTime = Osa_HwTimeRead();
    ZOSS_RESTORE_IRQ(old_intr);
}

/**************************************************************************
* : zOss_DfmSettingInit
* : ̬Ƶʼ
* ˵(IN)
*               
*           (OUT)
*                
*   ֵ: 
* ˵: 
**************************************************************************/
VOID zOss_DfmSettingInit(VOID)
{   
    ZOSS_INTR old_intr;
                    
    ZOSS_SAVE_IRQ(old_intr);
    g_zPsm_DfmFinishFlag = FALSE; 
    ZOSS_RESTORE_IRQ(old_intr); 
    
    psm_SetIgnoreThread();
    
    ZOSS_SAVE_IRQ(old_intr); 
    psm_ClearThreadCpu();
    g_zPsm_SumCpuTime    = 0;
    g_zPsm_DfmFinishFlag = TRUE; 
    g_zPsm_SwapLastTime  = Osa_HwTimeRead();
    ZOSS_RESTORE_IRQ(old_intr); 
}

/**************************************************************************
* ƣzOss_SetIgnoreThread
* ú߳
* ˵(IN)
                thread : ߳ID;
            (OUT)
*   ֵ
* ˵
**************************************************************************/
VOID zOss_SetIgnoreThread(ZOSS_THREAD_ID threadId)
{
    ZOSS_INTR old_intr;  

    if (threadId == NULL)
        return;
    ZOSS_SAVE_IRQ(old_intr);
    g_zPsm_IgnoreThreadId[g_zPsm_IgnoreThreadIndex++] = threadId;
    ZOSS_RESTORE_IRQ(old_intr); 
}

/**************************************************************************
* ƣ PSM_CpuIntRoutine
*  cpu̬Ƶɼ
* ˵ 
*   ֵ 
* ˵
**************************************************************************/
#ifdef _OS_TOS
VOID zOss_DfmIntRoutine(VOID)
{
    static UINT32 psmCpuCount = 0;
    
    if(g_zPsm_DfmFinishFlag)
    {
        if(++psmCpuCount >= g_zPsmCfg->dfmPeriod)
        {
           psmCpuCount = 0;
           psm_InterruptRoutine(1);
        }
    }
}
#endif

/**************************************************************************
* ƣ zOss_Dfm_TraceInfo
*  dfmĵϢ
* ˵ 
*   ֵ 
* ˵
**************************************************************************/
VOID zOss_DfmTraceInfo(VOID)
{
    zOss_Printf(SUBMDL_SHELL, PRINT_LEVEL_ABNORMAL, "CurFreq = %d, DfmCnt = %d", g_zPsm_CurCpuFreq, g_zPsm_DfmCnt);
    if (g_zPsm_DfmCnt > 0)
    {
        zOss_Printf(SUBMDL_SHELL, PRINT_LEVEL_ABNORMAL, "ait = %d, DesFreq = %d, MinFreq = %d", g_zPsm_SumIIT/g_zPsm_DfmCnt, psm_FindDesCpuFreq((100 - g_zPsm_SumIIT/g_zPsm_DfmCnt), g_zPsm_CurCpuFreq),
                    psm_FindMinCpuFreq());
    }
}

#endif  // #ifdef _USE_CPU_DFM

#endif  // #ifdef _USE_PSM

