/*******************************************************************************
* Ȩ (C)2016, ͨѶɷ޹˾
* 
* ļ:     ramdump_oss.c
* ļʶ:     ramdump_oss.c
* ժҪ:     ramdumpϵͳӿ/ݽṹͷļ
* ʹ÷:     ϵͳͷļڽӿڻݶҪ
* 
* ޸        汾      ޸ı        ޸          ޸
* ------------------------------------------------------------------------------
* 2016/6/10      V1.0        Create           Ծ          
* 
*******************************************************************************/

/*******************************************************************************
*                                   ͷļ                                     *
*******************************************************************************/
#include "ramdump_pub.h"
#include "ramdump_oss.h"

#ifdef __cplusplus
extern "C" {
#endif

/*******************************************************************************
*                                ⲿ                                  *
*******************************************************************************/

/*******************************************************************************
*                                   궨                                     *
*******************************************************************************/

/*******************************************************************************
*                                Ͷ                                  *
*******************************************************************************/

/*******************************************************************************
*                                ȫֱ                                  *
*******************************************************************************/

/*******************************************************************************
*                                ȫֺ                                  *
*******************************************************************************/

#ifdef _OS_LINUX 
/* icp api */  
extern int zDrvRpMsg_CreateChannel(
              T_ZDrvRpMsg_ActorID actorID, 
              T_ZDrvRpMsg_ChID chID, 
              unsigned int size);
extern int zDrvRpMsg_RegCallBack(
              T_ZDrvRpMsg_ActorID actorID, 
              unsigned int chID, 
              T_ZDrvRpMsg_CallbackFunction callback);
extern int zDrvRpMsg_WriteLockIrq(const T_ZDrvRpMsg_Msg *pMsg);
extern void panic(const char *fmt, ...);

extern int zDrvUsbPoll_Init(void);
extern int zDrvUsbPoll_Isr(void);
extern bool zDrvUsbPoll_isConnect(void);
extern int zDrvUsbPoll_Read(unsigned char* pBuf,unsigned long length);
extern int zDrvUsbPoll_Write(unsigned char* pBuf,unsigned long length);
#elif defined (_OS_TOS)

extern char *ramdump_error_log_exp(char *mem);
#endif //#ifdef _OS_LINUX 

/*******************************************************************************
*                                ȫֺʵ                                  *
*******************************************************************************/

/*******************************************************************************
* :     ramdump_oss_create_thread
* ˵:     
*   ()  void
*   ()  void
*   ֵ:     void
* ˵:    
*******************************************************************************/
void ramdump_oss_create_thread (
        char *name, 
        ramdump_oss_thread_entry_t entry)
{
#ifdef _OS_TOS
#define RAMDUMP_THREAD_STACK_DEF_SIZE 2048
#define RAMDUMP_THREAD_DEF_PRIO 20
#define RAMDUMP_THREAD_DEF_ARG 0
#define RAMDUMP_THREAD_AUTORUN 1
#define RAMDUMP_THREAD_PREEMPT 1

    zOss_CreateThread(
        name,entry, 
        RAMDUMP_THREAD_DEF_ARG,
        RAMDUMP_THREAD_STACK_DEF_SIZE,
        RAMDUMP_THREAD_DEF_PRIO,
        RAMDUMP_THREAD_PREEMPT,
        RAMDUMP_THREAD_AUTORUN);
#endif
}

/*******************************************************************************
* :     ramdump_oss_mmap
* ˵:     
*   ()  void
*   ()  void
*   ֵ:     void
* ˵:    
*******************************************************************************/
unsigned long ramdump_oss_mmap (unsigned long addr, unsigned long size)
{
#ifdef _OS_LINUX
    return ioremap(addr,size);
#elif defined (_OS_TOS)

#ifdef __USE_MMU__
    T_zTos_MmuRamdumpTable mmuTable = {0};
    zTos_MmuGetMappingRegion(addr, size, &mmuTable);
    /* 
     * TODO!
     * current tos mmap one to one
     * need new API like ioremap realize
     */
    return addr;
#endif

#endif
}

/*******************************************************************************
* :    ramdump_oss_icp_send
* ˵:     
*   () icp_msg: msg info
               client_id: client id
               ch_id: channel id
*   () void 
*   ֵ:    int: if msg send success 
* ˵:    This function is used for server to send msg to client
*******************************************************************************/
int ramdump_oss_icp_send(ramdump_oss_msg_t *icp_msg, unsigned int client_id, unsigned int ch_id)
{
    int ret;
    ramdump_oss_icp_msg rpmsg = {0};

    rpmsg.actorID = client_id;
    rpmsg.chID = ch_id;
    rpmsg.flag = 1;
    rpmsg.buf = icp_msg;
    rpmsg.len = sizeof(*icp_msg);

    /*
     * clean all the caches to make sure all data in ddr 
     */
    ramdump_arch_clean_caches();

    ret = ramdump_oss_icp_write(&rpmsg);

    if (ret != rpmsg.len)
    {
#ifdef _OS_LINUX
        OSS_PRINTF(
            "[ramdump] icpmsg send fail, ret != rpmsg.len[ret:%d], [client_id:%d]\n", 
            ret, 
            client_id);
#elif defined (_OS_TOS)
        OSS_PRINTF(
            "[ramdump] icpmsg send fail, ret != rpmsg.len[ret:%d], [client_id:%d]\n", 
            ret,
            client_id);
#endif
        return ret;
    }

    return RAMDUMP_ICP_SUCCESS;
}

/*******************************************************************************
* :     ramdump_oss_error_log_creat
* ˵:     
*   ()  buf : addr point
*   ()  void
*   ֵ:     void
* ˵:    
*******************************************************************************/
void ramdump_oss_error_log_creat(char *buf)
{
#ifdef _OS_LINUX
    if (current->mm != NULL)
        sprintf(
            buf, 
            " dump at user, app name is: %s, load addr is: %lu \n", 
            current->comm, 
            current->mm->start_code);
    else
        sprintf(
            buf,
            " dump at kernel, app name is: %s \n", 
            current->comm);
#elif defined (_OS_TOS)
	ramdump_error_log_exp(buf);
#endif
}

/*******************************************************************************
* :    ramdump_oss_icp_create_channel
* ˵:     
*   () actorID: icp send core id
               chID:    icp channel id
               size:    icp channel size
*   () void 
*   ֵ:    int: if msg send success 
* ˵:    
*******************************************************************************/
int ramdump_oss_icp_create_channel(
        ramdump_oss_icp_actorid actorID, 
        ramdump_oss_icp_channelid chID, 
        unsigned int size)
{
    return zDrvRpMsg_CreateChannel(actorID, chID, size);
}

/*******************************************************************************
* :    ramdump_oss_icp_regcallback
* ˵:     
*   () actorID: icp send core id
               chID:    icp channel id
               callback:icp callback fun
*   () void 
*   ֵ:    int: if msg send success 
* ˵:    
*******************************************************************************/
int ramdump_oss_icp_regcallback (
        ramdump_oss_icp_actorid actorID, 
        unsigned int chID, 
        ramdump_oss_icp_callback callback)
{
    return zDrvRpMsg_RegCallBack(actorID,chID,callback);
}

/*******************************************************************************
* :    ramdump_oss_icp_write
* ˵:     
*   () pMsg: icp send msg
*   () void 
*   ֵ:    int: if msg send success 
* ˵:    
*******************************************************************************/
int ramdump_oss_icp_write(const ramdump_oss_icp_msg *pMsg)
{
#ifdef _OS_LINUX
    return zDrvRpMsg_Write(pMsg);
#elif defined (_OS_TOS)
    if (pMsg->actorID == ramdump_cpu_id[RAMDUMP_CPU_2])
    {
        switch (((ramdump_msg_t *)(pMsg->buf))->msg_id)
        {
            case RAMDUMP_MSG_EXCEPT:
            {
                return zDrvRpMsg_WriteLockIrq(pMsg);
            }
            case RAMDUMP_MSG_SYNC:
            default:
                return pMsg->len;
        }
    }
    else
        return zDrvRpMsg_WriteLockIrq(pMsg);
#endif
}

/*******************************************************************************
* :     ramdump_oss_data_trans_init
* ˵:     
*   ()  void
*   ()  void
*   ֵ:     void
* ˵:    
*******************************************************************************/
void ramdump_oss_data_trans_init(void)
{
#ifdef _OS_LINUX 
    zDrvUsbPoll_Init();                 /* ʼUSB        */
    while (!zDrvUsbPoll_isConnect()) ;  /* ѯUSBǷ  */
#endif
}

/*******************************************************************************
* :     ramdump_oss_data_trans_read
* ˵:     
*   () buffer: data buff
               size:   data size
*   () void 
*   ֵ:    void
* ˵:    
*******************************************************************************/
void ramdump_oss_data_trans_read(unsigned char *buffer, unsigned int size)
{
#ifdef _OS_LINUX 
    unsigned int count = 0;

    do
    {
        zDrvUsbPoll_Isr();
        count = (unsigned int)zDrvUsbPoll_Read(buffer, size);
        if ( size <= count)
        {
            break;
        }        
        buffer += count;
        size -=count;
    }
    while (size > 0);
#endif
}

/*******************************************************************************
* :     ramdump_oss_data_trans_write
* ˵:     
*   () buffer: data buff
               size:   data size
*   () void 
*   ֵ:    void
* ˵:    
*******************************************************************************/
void ramdump_oss_data_trans_write(unsigned char *buffer, unsigned int size)
{
#ifdef _OS_LINUX 
    unsigned int count = 0;

    while (size > 0)
    {
        zDrvUsbPoll_Isr();
        count = (unsigned int)zDrvUsbPoll_Write(buffer, size);
        if ( size <= count)
        {
            break;
        }
        
        buffer += count;
        size -=count;
    }
#endif
}

/*******************************************************************************
* :     ramdump_oss_data_trans_done
* ˵:     
*   ()  void
*   ()  void
*   ֵ:     void
* ˵:    
*******************************************************************************/
void ramdump_oss_data_trans_done(void)
{
#ifdef _OS_LINUX     
    /* ȴݷ */
    zDrvUsbPoll_Isr();
#endif
}

#ifdef __cplusplus
}
#endif

