/*******************************************************************************
* Ȩ (C)2016, ͨѶɷ޹˾
* 
* ļ:     ramdump_v7.c
* ļʶ:     ramdump_v7.c
* ժҪ:     ramdump armv7ʵ
* 
* ޸        汾      ޸ı        ޸          ޸
* ------------------------------------------------------------------------------
* 2016/6/10      V1.0        Create           Ծ          
* 
*******************************************************************************/

/*******************************************************************************
*                                   ͷļ                                     *
*******************************************************************************/
#include "ramdump_pub.h"
#include "ramdump_oss.h"

#ifdef __cplusplus
extern "C" {
#endif

/*******************************************************************************
*                                ⲿ                                  *
*******************************************************************************/
#ifdef _OS_LINUX
extern void armv7_clean_dcache_all(void);
#endif

/*******************************************************************************
*                                                                      *
*******************************************************************************/

/*******************************************************************************
*                                   궨                                     *
*******************************************************************************/
#define RAMDUMP_REG_NR              (15)    /* R0-R14 */
#define RAMDUMP_FIQ_REG_START       (8)     /* R8     */
#define RAMDUMP_FIQ_REG_END         (13)    /* R12    */

#define RAMDUMP_ARM_USR_MOD         (0xd0)
#define RAMDUMP_ARM_SVC_MOD         (0xd3)

/* code & data done instr */
#define ramdump_dsb()   asm volatile("dsb" : : : "memory")

#ifndef __stringify
#define __stringify_1(x...) #x
#define __stringify(x...)   __stringify_1(x)
#endif

/* CP15 */
#ifndef __ACCESS_CP15
#define __ACCESS_CP15(CRn, Op1, CRm, Op2)   p15, Op1, %0, CRn, CRm, Op2
#endif

#ifdef __USE_MMU__
/* mmu control regs */
#define MMU_SCTLR   __ACCESS_CP15(c1, 0, c0, 0)
#define MMU_TTBCR   __ACCESS_CP15(c2, 0, c0, 2)
#define MMU_DACR    __ACCESS_CP15(c3, 0, c0, 0)
#define MMU_TTBR0   __ACCESS_CP15(c2, 0, c0, 0)
#define MMU_TTBR1   __ACCESS_CP15(c2, 0, c0, 1) 
#elif defined (__USE_MPU__) //#ifdef __USE_MMU__
/* mpu control regs */
#define MPU_TYPE_REGISTER_DREGION_POS (8)

#define MPU_REGION_NUM      __ACCESS_CP15(c6, 0, c2, 0)
#define MPU_REGION_BASE     __ACCESS_CP15(c6, 0, c1, 0)
#define MPU_REGION_ATTR     __ACCESS_CP15(c6, 0, c1, 4)
#define MPU_REGION_SIZE     __ACCESS_CP15(c6, 0, c1, 2)
#define MPU_REGION_MAXNUM   __ACCESS_CP15(c0, 0, c0, 4)
#define MPU_DFSR            __ACCESS_CP15(c5, 0, c0, 0)
#define MPU_DFAR            __ACCESS_CP15(c6, 0, c0, 0)
#define MPU_IFSR            __ACCESS_CP15(c5, 0, c0, 1)
#define MPU_IFAR            __ACCESS_CP15(c6, 0, c0, 2)
#endif //#ifdef __USE_MMU__

/*******************************************************************************
*                                Ͷ                                  *
*******************************************************************************/
/*
 * arm cpu mode pub regs
 */
typedef struct 
{
    unsigned long   sp;
    unsigned long   lr;
    unsigned long   spsr;
} ramdump_arm_com_regs; 
/*
 * arm fiq mode regs
 */
typedef struct
{
    unsigned long           fiq_r8;
    unsigned long           fiq_r9;
    unsigned long           fiq_r10;
    unsigned long           fiq_r11;
    unsigned long           fiq_r12;
    ramdump_arm_com_regs    fiq_com;
} ramdump_arm_fiq_regs;
/*
 * arm cpu modes info record
 */
typedef struct 
{
    unsigned long regs[13]; /* r0-r12*/

    ramdump_arm_com_regs    sys;
    ramdump_arm_com_regs    svc;
    ramdump_arm_com_regs    abt;
    ramdump_arm_com_regs    udf;
    ramdump_arm_com_regs    irq;
    ramdump_arm_fiq_regs    fiq;
} ramdump_arm_regs;

/*******************************************************************************
*                              ֲ̬                                *
*******************************************************************************/
/*
 * arm cpu sys mod, except usr, we have special handle
 */
static const unsigned long arm_sys_modes[] = 
{
    0xdf,   /* SYS */
    0xd3,   /* SVC */
    0xd7,   /* ABT */
    0xdb,   /* UND */
    0xd2,   /* IRQ */
    0xd1,   /* FIQ */
};

/*******************************************************************************
*                                ȫֱ                                  *
*******************************************************************************/
ramdump_arm_regs arm_all_modes_regs;

/*******************************************************************************
*                                ֲʵ                                  *
*******************************************************************************/

#ifdef __USE_MMU__

/*******************************************************************************
* :     armv7_get_SCTLR
* ˵:     
*   ()  void
*   ()  void
*   ֵ:     void
* ˵:     armv7 mmu SCTLR registers recover
*******************************************************************************/
static unsigned long armv7_get_SCTLR(void)
{
    unsigned long scrtlr_reg;

    asm volatile("mrc " __stringify(MMU_SCTLR) : "=r" (scrtlr_reg));

    return scrtlr_reg;
}

/*******************************************************************************
* :     armv7_get_TTBCR
* ˵:     
*   ()  void
*   ()  void
*   ֵ:     unsigned long: ttbcr value
* ˵:     armv7 mmu Control registers recover
*******************************************************************************/
static unsigned long armv7_get_TTBCR(void)
{
    unsigned long ttbcr_reg;

    asm volatile("mrc " __stringify(MMU_TTBCR) : "=r" (ttbcr_reg));

    return ttbcr_reg;
}

/*******************************************************************************
* :     armv7_get_DACR
* ˵:     
*   ()  void
*   ()  void
*   ֵ:     unsigned long: dacr value
* ˵:     armv7 mmu Domain registers recover
*******************************************************************************/
static unsigned long armv7_get_DACR(void)
{
    unsigned long dacr_reg;

    asm volatile("mrc " __stringify(MMU_DACR) : "=r" (dacr_reg));

    return dacr_reg;
}

/*******************************************************************************
* :     armv7_get_TTBR0
* ˵:     
*   ()  void
*   ()  void
*   ֵ:     unsigned long: ttbr0 value
* ˵:     armv7 mmu TTBR0 registers recover
*******************************************************************************/
static unsigned long armv7_get_TTBR0(void)
{
    unsigned long ttbr0_reg;

    asm volatile("mrc " __stringify(MMU_TTBR0) : "=r" (ttbr0_reg));

    return ttbr0_reg;
}

/*******************************************************************************
* :     armv7_get_TTBR1
* ˵:     
*   ()  void
*   ()  void
*   ֵ:     unsigned long: ttbr1 value
* ˵:     armv7 mmu TTBR1 registers recover
*******************************************************************************/
static unsigned long armv7_get_TTBR1(void)
{
    unsigned long ttbr1_reg;

    asm volatile("mrc " __stringify(MMU_TTBR1) : "=r" (ttbr1_reg));

    return ttbr1_reg;
}

#elif defined (__USE_MPU__)     // #ifdef __USE_MMU__

/*******************************************************************************
* :     armr7_mpu_set_RegionNum
* ˵:     
*   ()  nr: number
*   ()  void
*   ֵ:     unsigned long: region set nr
* ˵:     armv7 mpu set region number, select region
*******************************************************************************/
static  void armr7_mpu_region_set_nr(unsigned long nr)
{
    unsigned long region_num;

    asm volatile("mrc " __stringify(MPU_REGION_NUM) : "=r" (region_num));

    return region_num;
}

/*******************************************************************************
* :     armr7_mpu_get_RegionBase
* ˵:     
*   ()  void
*   ()  void
*   ֵ:     unsigned long: region base
* ˵:     armv7 mpu get region base address
*******************************************************************************/
static  unsigned long armr7_mpu_region_get_base(void)
{
    unsigned long region_base;

    asm volatile("mrc " __stringify(MPU_REGION_BASE) : "=r" (region_base));

    return region_base;
}

/*******************************************************************************
* :     armr7_mpu_get_RegionAttr
* ˵:     
*   ()  void
*   ()  void
*   ֵ:     unsigned long: region attr
* ˵:     armv7 mpu get region attribution 
*******************************************************************************/
static  unsigned long armr7_mpu_region_get_attr(void)
{
    unsigned long region_attr;

    asm volatile("mrc " __stringify(MPU_REGION_ATTR) : "=r" (region_attr));

    return region_attr;
}

/*******************************************************************************
* :     armr7_mpu_get_RegionSize
* ˵:     
*   ()  void
*   ()  void
*   ֵ:     unsigned long: region size
* ˵:     armv7 mpu get region size and enable reg
*******************************************************************************/
static  unsigned long armr7_mpu_region_get_size(void)
{
    unsigned long region_size;

    asm volatile("mrc " __stringify(MPU_REGION_SIZE) : "=r" (region_size));

    return region_size;
}

/*******************************************************************************
* :     armr7_mpu_get_RegionMaxNum
* ˵:     
*   ()  void
*   ()  void
*   ֵ:     unsigned long: region max number
* ˵:     armv7 mpu get region max num
*******************************************************************************/
static  unsigned long armr7_mpu_region_get_max_nr(void)
{
    unsigned long region_max_num;

    asm volatile("mrc " __stringify(MPU_REGION_MAXNUM) : "=r" (region_max_num));

    return (region_max_num >> 8);
}

/*******************************************************************************
* :     armr7_mpu_get_DFSR
* ˵:     
*   ()  void
*   ()  void
*   ֵ:     unsigned long: dfsr value
* ˵:     armv7 mpu get DFSR
*******************************************************************************/
static  unsigned long armr7_mpu_get_DFSR(void)
{
    unsigned long dfsr_reg;

    asm volatile("mrc " __stringify(MPU_DFSR) : "=r" (dfsr_reg));

    return dfsr_reg;
}

/*******************************************************************************
* :     armr7_mpu_get_DFAR
* ˵:     
*   ()  void
*   ()  void
*   ֵ:     unsigned long: dfar value
* ˵:     armv7 mpu get DFAR
*******************************************************************************/
static  unsigned long armr7_mpu_get_DFAR(void)
{
    unsigned long dfar_reg;

    asm volatile("mrc " __stringify(MPU_DFAR) : "=r" (dfar_reg));

    return dfar_reg;
}

/*******************************************************************************
* :     armr7_mpu_get_IFSR
* ˵:     
*   ()  void
*   ()  void
*   ֵ:     unsigned long: ifsr value
* ˵:     armv7 mpu get IFSR
*******************************************************************************/
static unsigned long armr7_mpu_get_IFSR(void)
{
    unsigned long ifsr_reg;

    asm volatile("mrc " __stringify(MPU_IFSR) : "=r" (ifsr_reg));

    return ifsr_reg;
}

/*******************************************************************************
* :     armr7_mpu_get_IFAR
* ˵:     
*   ()  void
*   ()  void
*   ֵ:     unsigned long: ifar value
* ˵:     armv7 mpu get IFAR
*******************************************************************************/
static unsigned long armr7_mpu_get_IFAR(void)
{
    unsigned long ifar_reg;

    asm volatile("mrc " __stringify(MPU_IFAR) : "=r" (ifar_reg));

    return ifar_reg;
}

#endif  // #ifdef __USE_MMU__

/*******************************************************************************
* :    arm_store_sys_regs
* ˵:     
*   () mem: addr points to buf start
*   () void 
*   ֵ:    addr: changed addr 
* ˵:    
*******************************************************************************/
static char *arm_store_sys_regs(char *mem)
{
    unsigned long           *fiq_regs       = NULL;
    ramdump_arm_com_regs	*ptr_mode_regs  = NULL;
    unsigned long            fiq_regs_nr     = RAMDUMP_FIQ_REG_START;
    unsigned long            arm_sys_mode_nr = 0;

    //SYS/SVC/ABT/UND/IRQ
    ptr_mode_regs = (ramdump_arm_com_regs*)(&arm_all_modes_regs.sys);
    do {
        mem += sprintf(mem, "r.s cpsr 0x%lx\n", (unsigned long)arm_sys_modes[arm_sys_mode_nr]);
        mem += sprintf(mem, "r.s r13 0x%lx\n", (unsigned long)(ptr_mode_regs->sp));
        mem += sprintf(mem, "r.s r14 0x%lx\n", (unsigned long)(ptr_mode_regs->lr));
        mem += sprintf(mem, "r.s spsr 0x%lx\n", (unsigned long)(ptr_mode_regs->spsr));
        ptr_mode_regs++;
        arm_sys_mode_nr++;
    } while (arm_sys_mode_nr < (RAMDUMP_ARRAY_NR(arm_sys_modes) - 1));

    //FIQ r8-r12
    mem += sprintf(mem, "r.s cpsr 0x%lx\n", (unsigned long)arm_sys_modes[arm_sys_mode_nr]);
    fiq_regs = ((unsigned long*)&arm_all_modes_regs.fiq.fiq_r8);
    do {
        mem += sprintf(mem, "r.s r%lu 0x%lx\n", fiq_regs_nr, *(fiq_regs));
        fiq_regs++;
        fiq_regs_nr++;
    } while (fiq_regs_nr < RAMDUMP_FIQ_REG_END);

    //FIQ r13-r14/cpsr
    ptr_mode_regs = &arm_all_modes_regs.fiq.fiq_com;
    mem += sprintf(mem, "r.s r13 0x%lx\n", (unsigned long)(ptr_mode_regs->sp));
    mem += sprintf(mem, "r.s r14 0x%lx\n", (unsigned long)(ptr_mode_regs->lr));
    mem += sprintf(mem, "r.s spsr 0x%lx\n", (unsigned long)(ptr_mode_regs->spsr));

    return mem;
}

/*******************************************************************************
* :    arm_store_cur_regs
* ˵:     
*   () mem: addr points to buf start
*   () void
*   ֵ:    addr: changed addr 
* ˵:    
*******************************************************************************/
static char *arm_store_cur_regs(char *mem)
{
    unsigned long  cnt;
    unsigned long *svc_regs = (unsigned long *)arm_all_modes_regs.regs;

    mem += sprintf(mem, "r.s cpsr 0x%lx\n", (unsigned long)RAMDUMP_ARM_SVC_MOD);
    for (cnt = 0x00; cnt < RAMDUMP_ARRAY_NR(arm_all_modes_regs.regs); cnt++)
        mem += sprintf(mem, "r.s r%lu 0x%lx\n", cnt, *svc_regs++);
    mem += sprintf(mem, "r.s r13 0x%lx\n", arm_all_modes_regs.svc.sp);
    mem += sprintf(mem, "r.s r14 0x%lx\n", arm_all_modes_regs.svc.lr);
    mem += sprintf(mem, "r.s pc 0x%lx\n", arm_all_modes_regs.svc.lr);
    mem += sprintf(mem, "r.s spsr 0x%lx\n", arm_all_modes_regs.svc.spsr);

    return mem;
}

/*******************************************************************************
*                                ȫֺʵ                                  *
*******************************************************************************/
/*******************************************************************************
* :    ramdump_arch_clean_and_invalid_caches
* ˵:     
*   () void
*   () void
*   ֵ:    void
* ˵:    This function is used for arm clean and invalid caches
*******************************************************************************/
void ramdump_arch_clean_and_invalid_caches(void)
{
#ifdef _OS_TOS
    tos_cache_clean_invalidate_all();
#endif 
}

/*******************************************************************************
* :    ramdump_arch_clean_caches
* ˵:     
*   () void
*   () void
*   ֵ:    void
* ˵:    This function is used for arm clean caches
*******************************************************************************/
void ramdump_arch_clean_caches(void)
{
#ifdef _OS_LINUX
    armv7_clean_dcache_all();
#elif defined (_OS_TOS)
    tos_cache_clean_all();
#endif   
}

/*******************************************************************************
* :    ramdump_arch_store_modes_regs
* ˵:     
*   () mem: addr points to buf start
*   () void
*   ֵ:    addr: changed addr   
* ˵:    This function is used for linux clean caches
*******************************************************************************/
char *ramdump_arch_store_modes_regs(char *mem)
{
    // store privileged regs
    mem = arm_store_sys_regs(mem);

    // store usr regs, user app is running in svc mod
    mem = arm_store_cur_regs(mem);

    return mem;
}

/*******************************************************************************
* :    ramdump_arch_store_mm_regs
* ˵:     
*   () mem: addr points to buf start
*   () void
*   ֵ:    addr: changed addr  
* ˵:    This function is used for linux clean caches
*******************************************************************************/
char *ramdump_arch_store_mm_regs(char *mem)
{
#ifdef __USE_MMU__

    mem += sprintf(mem, "per.s c15:0x1 %%long %#lx\r\n", armv7_get_SCTLR());
    mem += sprintf(mem, "per.s c15:0x2 %%long %#lx\r\n", armv7_get_TTBR0());
    mem += sprintf(mem, "per.s c15:0x102 %%long %#lx\r\n", armv7_get_TTBR1());
    mem += sprintf(mem, "per.s c15:0x202 %%long %#lx\r\n", armv7_get_TTBCR());
    mem += sprintf(mem, "per.s c15:0x3 %%long %#lx\r\n", armv7_get_DACR());
    
#elif defined (__USE_MPU__) //#ifdef __USE_MMU__

    unsigned long i = 0;

    mem += sprintf(mem, "per.s c15:0x4 %%long %#lx\r\n", (unsigned long)((armr7_mpu_region_get_max_nr() << MPU_TYPE_REGISTER_DREGION_POS))); 
    for(i = 0; i < armr7_mpu_region_get_max_nr(); i++)
    {
        mem += sprintf(mem, "per.s c15:0x26 %%long %#lx\r\n",  (unsigned long)i); 
        armr7_mpu_region_set_nr(i);
        mem += sprintf(mem, "per.s c15:0x16 %%long %#lx\r\n",  (unsigned long)(armr7_mpu_region_get_base())); 
        mem += sprintf(mem, "per.s c15:0x216 %%long %#lx\r\n", (unsigned long)(armr7_mpu_region_get_size())); 
        mem += sprintf(mem, "per.s c15:0x416 %%long %#lx\r\n", (unsigned long)(armr7_mpu_region_get_attr())); 
    }

    /* DFSR/DFAR IFSR/IFAR */
    mem += sprintf(mem, "per.s c15:0x5 %%long %#lx\r\n",   (unsigned long)(armr7_mpu_get_DFSR())); 
    mem += sprintf(mem, "per.s c15:0x6 %%long %#lx\r\n",   (unsigned long)(armr7_mpu_get_DFAR())); 
    mem += sprintf(mem, "per.s c15:0x105 %%long %#lx\r\n", (unsigned long)(armr7_mpu_get_IFSR())); 
    mem += sprintf(mem, "per.s c15:0x206 %%long %#lx\r\n", (unsigned long)(armr7_mpu_get_IFAR())); 

#endif //#ifdef __USE_MMU__

    return mem;
}

unsigned long ramdump_arch_get_pc(unsigned int mode)
{
	unsigned long pc;
#ifdef _OS_TOS 

	switch (mode){
	case CYGNUM_HAL_VECTOR_UNDEF_INSTRUCTION:
		pc = arm_all_modes_regs.udf.lr;
		break;
	case CYGNUM_HAL_VECTOR_ABORT_PREFETCH:
		pc = arm_all_modes_regs.abt.lr;
		break;
	case CYGNUM_HAL_VECTOR_ABORT_DATA:
		pc = arm_all_modes_regs.abt.lr;
		break;
	default:
		pc = arm_all_modes_regs.svc.lr;
		break;
	}
#endif	
	return pc;
}

#ifdef __cplusplus
}
#endif

