/**************************************************************************************************
*
*                       Copyright(c) 2012 ZTE Corporation 
*
***************************************************************************************************
* 汾: ͨѶɷ޹˾ ֻҵ 
* ģ  : OSٹUE
*   :
* ļʶ:
* ļ:
* ʵֹ:
*     :
*     :
* :
* ˵:
***************************************************************************************************/

/**************************************************************************************************
* ޸ļ¼:
*     :
*   :
*   :
*     :
***************************************************************************************************/

#ifdef _USE_MONITOR
/**************************************************************************************************
* include
***************************************************************************************************/
#include "sup_agent_status.h"
#include "sup_agent.h"

/**************************************************************************************************
* ݽṹ
***************************************************************************************************/
typedef struct
{
    UINT32 msgId;
    UINT32 count;

}T_OsAgt_Status;

typedef struct
{
    UINT32 pcMsgId;
    UINT32 ueMsgId;

}T_OsAgt_MsgIdMap;

/**************************************************************************************************
* 
***************************************************************************************************/
#define INVLID_STATUS_VALUE  0xFFFFFFFF
#define INVLID_MESSAGE_ID    0xFFFFFFFF

static T_OsAgt_MsgIdMap g_MsgIdMap[] = 
{
    { PC_TOOL_WINDOW_CPU,       OSS_MON_VERSION}, 

    { PC_TOOL_WINDOW_THREAD,    OSS_MON_THREAD},     
    { PC_TOOL_WINDOW_EVENT,     OSS_MON_EVENT},
    { PC_TOOL_WINDOW_TIMER,     OSS_MON_TIMER},      
    { PC_TOOL_WINDOW_TASK,      OSS_MON_TASK},       
    { PC_TOOL_WINDOW_RAMLOG,    OSS_MON_RAMLOG},          
    { PC_TOOL_WINDOW_POOL,      OSS_MON_POOL_ALLOC},            
    { PC_TOOL_WINDOW_MMU,       OSS_MON_MMU},        
    { PC_TOOL_WINDOW_MSG,       OSS_MON_MSG},        
    { PC_TOOL_WINDOW_POOLLEAK,  OSS_MON_POOL_LEAK},
    { PC_TOOL_WINDOW_VARIABLE,  OSS_MON_GET_VAR_ACK},  

    { PC_TOOL_WINDOW_MEM,       OSS_MON_HEAP},   
    { PC_TOOL_WINDOW_MEM,       OSS_MON_POOL}, 

    { PC_TOOL_WINDOW_CPU,       OSS_MON_CPU_LOAD},        
    { PC_TOOL_WINDOW_CPU,       OSS_MON_CPU_FREQUENCY}
};

#define UE_MSG_NUM (sizeof(g_MsgIdMap)/sizeof(T_OsAgt_MsgIdMap))

/**************************************************************************************************
* static
***************************************************************************************************/
static UINT32 zOss_MonitorAgt_GetStatusCount(UINT32 msgId);
static VOID zOss_MonitorAgt_SetStatusCount(UINT32 msgId);

/**************************************************************************************************
* ȫֱ
***************************************************************************************************/
static T_OsAgt_Status g_Status[PC_WINDOW_NUM] = 
{
    { PC_TOOL_WINDOW_THREAD,   0}, //1     
    { PC_TOOL_WINDOW_EVENT,    0}, //1
    { PC_TOOL_WINDOW_TIMER,    0}, //1      
    { PC_TOOL_WINDOW_TASK,     0}, //1       
    { PC_TOOL_WINDOW_RAMLOG,   0}, //1          
    { PC_TOOL_WINDOW_POOL,     0}, //1            
    { PC_TOOL_WINDOW_MMU,      0}, //1       
    { PC_TOOL_WINDOW_MSG,      0}, //1       
    { PC_TOOL_WINDOW_POOLLEAK, 0}, //1
    { PC_TOOL_WINDOW_VARIABLE, 0}, //1  
    { PC_TOOL_WINDOW_MEM,      0}, //2    
    { PC_TOOL_WINDOW_CPU,      0}, //2      
};

/**************************************************************************************************
* ʵ
***************************************************************************************************/
static UINT32 zOss_MonitorAgt_GetUeMessageNum(UINT32 msgId)
{
    UINT32 i = 0;
    UINT32 count = 0;
    for(i = 0; i < UE_MSG_NUM; i++)
    {
        if(g_MsgIdMap[i].pcMsgId == msgId)
        {
            count++;
        }
    }

    return count;
}

static UINT32 zOss_MonitorAgt_GetPcMessageId(UINT32 ueMsgId)
{
    UINT32 pcMsgId = INVLID_MESSAGE_ID; 
    UINT32 i = 0;
    for(i = 0; i < UE_MSG_NUM; i++)
    {
        if(g_MsgIdMap[i].ueMsgId == ueMsgId)
        {  
            pcMsgId = g_MsgIdMap[i].pcMsgId; 
            break;
        }
    }

return pcMsgId;
}

static VOID zOss_MonitorAgt_ReduceStatusCount(UINT32 msgId)
{
    int i = 0;
    for(i = 0; i < PC_WINDOW_NUM; i++)
    {
        if(g_Status[i].msgId == msgId)
        {
            g_Status[i].count--;
            break;
        }
    }
}

static VOID zOss_MonitorAgt_SetStatusCount(UINT32 msgId)
{
    int i = 0;
    UINT32 count = zOss_MonitorAgt_GetUeMessageNum(msgId);

    for(i = 0; i < PC_WINDOW_NUM; i++)
    {
        if(g_Status[i].msgId == msgId)
        {
            g_Status[i].count = count;
            break;
        }
    }
}

static UINT32 zOss_MonitorAgt_GetStatusCount(UINT32 msgId)
{
    int i = 0;

    for(i = 0; i < PC_WINDOW_NUM; i++)
    {
        if(g_Status[i].msgId == msgId)
        {
            return g_Status[i].count;
        }
    }
 
    return INVLID_STATUS_VALUE;
}

OsAgt_Status zOss_MonitorAgt_CheckReceiveMessage(UINT32 msgId)
{
    if(zOss_MonitorAgt_GetStatusCount(msgId) == 0)
    {
        zOss_MonitorAgt_SetStatusCount(msgId);
        return OsAgt_Status_Ok;
    }
    else
    {
        //discard received pc message
        return OsAgt_Status_Error;
    }
}

OsAgt_Status zOss_MonitorAgt_CheckReplyMessage(UINT32 ueMsgId)
{
    UINT32 pcMsgId = zOss_MonitorAgt_GetPcMessageId(ueMsgId);

    zOss_MonitorAgt_ReduceStatusCount(pcMsgId);
    if(zOss_MonitorAgt_GetStatusCount(pcMsgId) == 0)
    {
        //send message to pc
        return OsAgt_Status_Ok;
    }
    else
    {
        return OsAgt_Status_Error;
    }
}
#endif

