/**************************************************************************
*
*                  Copyright (c) 2012 ZTE Corporation.
*
***************************************************************************
* ģ   : ֧Ųģ
*    : oss_monitor.c
* ļ : 
* ʵֹ : ֧Ųݵռٹߴн
*      : 
*      : V1.0
*  : 2012/12/12
* ˵ : 
**************************************************************************/

/**************************************************************************
* ޸ļ¼
**************************************************************************/
/**************************************************************************
* ޸ı : 
*    : 
* ޸ : 
* ޸ : 
**************************************************************************/

#ifdef _USE_MONITOR
/**************************************************************************
* #include
**************************************************************************/
#include "oss_api.h"
#include "osa.h"
#include "sup_except.h"
#include "oss_irq.h"
#include "oss_trace.h"

/**************************************************************************
* 궨
**************************************************************************/
#if (defined _USE_ZX297550_HARDWARE)
# define OSS_MON_VERSION_TYPE   "7550"
#elif (defined _USE_ZX297520_HARDWARE)
# define OSS_MON_VERSION_TYPE   "7520"
#elif (defined _USE_ZX297510_HARDWARE)
# define OSS_MON_VERSION_TYPE   "7510"
#elif (defined _USE_ZX297502_HARDWARE)
# define OSS_MON_VERSION_TYPE   "7502"
#else
# define OSS_MON_VERSION_TYPE   "unkown"
#endif

#define OSS_MON_AGT_NAME        "OsAgt"

/**************************************************************************
* ݽṹ
**************************************************************************/
typedef struct
{
    UINT32  msgId;
    UINT32  (*func)(UINT8 *ptr);
} oss_mon_func_t;

typedef struct
{
    T_ZOss_Mon_Version        monVersionInfo;
    T_ZOss_Mon_Cpu_Frequency  monCpuFrequency;
    T_ZOss_Mon_Cpu_Load       monCpuLoad;
    T_ZOss_Mon_Pool           monPoolInfo;
    T_ZOss_Mon_Pool_Alloc     monPoolAlloc;
    T_ZOss_Mon_Pool_Leak      monPoolLeak;
    T_ZOss_Mon_Heap           monHeapInfo;
    T_ZOss_Mon_Thread         monThreadInfo;
    T_ZOss_Mon_Task           monTaskInfo;
    T_ZOss_Mon_Event          monEventInfo;
    T_ZOss_Mon_Msg            monMsgInfo;
    T_ZOss_Mon_Ramlog         monRamlogInfo;
    T_ZOss_Mon_Get_Var_Ack    monGetVarInfo;
    T_ZOss_Mon_Timer          monTimerInfo;
    T_ZOss_Mon_Mmu            monMmuInfo;
} oss_mon_ele_ptr_t;

/**************************************************************************
* ֲԭ
**************************************************************************/
static UINT32 monitor_MessageDisposeHandler(UINT32 msg_id, UINT8 *buf);
static UINT32 monitor_VersionInfo(UINT8 *buf);
static UINT32 monitor_CpuFrequencyInfo(UINT8 *buf);
static UINT32 monitor_CpuLoadInfo(UINT8 *buf);
static UINT32 monitor_PoolInfo(UINT8 *buf);
static UINT32 monitor_PoolAllocInfo(UINT8 *buf);
static UINT32 monitor_PoolLeakInfo(UINT8 *buf);
static UINT32 monitor_HeapInfo(UINT8 *buf);
static UINT32 monitor_ThreadInfo(UINT8 *buf);
static UINT32 monitor_TaskInfo(UINT8 *buf);
static UINT32 monitor_EventInfo(UINT8 *buf);
static UINT32 monitor_MsgInfo(UINT8 *buf);
static UINT32 monitor_RamlogInfo(UINT8 *buf);
static UINT32 monitor_TimerInfo(UINT8 *buf);
static UINT32 monitor_MmuInfo(UINT8 *buf);
static UINT32 monitor_GetVarInfo(UINT8 *buf);
static UINT32 monitor_SetVarInfo(UINT8 *buf);
static UINT32 monitor_SetMonFlag(UINT8 *buf);

/**************************************************************************
* ȫֳ/
**************************************************************************/
UINT32                      gOsa_MonitorFlag        = FALSE;
static ZOSS_TASK_ID         gMon_OsAgtID            = NULL;       
static oss_mon_ele_ptr_t    oss_mon_ele_ptr         = {0};
static oss_mon_func_t       oss_mon_id_to_func[]    =
{
    {OSS_MON_VERSION,       monitor_VersionInfo     },
    {OSS_MON_CPU_FREQUENCY, monitor_CpuFrequencyInfo},
    {OSS_MON_CPU_LOAD,      monitor_CpuLoadInfo     },
    {OSS_MON_POOL,          monitor_PoolInfo        },
    {OSS_MON_POOL_ALLOC,    monitor_PoolAllocInfo   },
    {OSS_MON_POOL_LEAK,     monitor_PoolLeakInfo    },
    {OSS_MON_HEAP,          monitor_HeapInfo        },
    {OSS_MON_THREAD,        monitor_ThreadInfo      },
    {OSS_MON_TASK,          monitor_TaskInfo        },
    {OSS_MON_EVENT,         monitor_EventInfo       },
    {OSS_MON_MSG,           monitor_MsgInfo         },
    {OSS_MON_RAMLOG,        monitor_RamlogInfo      },
    {OSS_MON_GET_VAR_REQ,   monitor_GetVarInfo      },  
    {OSS_MON_SET_VAR,       monitor_SetVarInfo      },
    {OSS_MON_TIMER,         monitor_TimerInfo       },
    {OSS_MON_MMU,           monitor_MmuInfo         },
};

/**************************************************************************
* ȫֺʵ
**************************************************************************/

/**************************************************************************
* ƣMonitor_TaskEntry
* ʼعģں
* ˵(IN)
*           state:   ״̬
*           msg_id:  ϢID
*           buf:     Ϣbuf  
*           msg_len: Ϣ
*           private: ˽
*           (OUT)
*   ֵ
* ˵
**************************************************************************/
VOID Monitor_TaskEntry(UINT8 state, UINT32 msg_id, UINT8 *buf, UINT16 msg_len, UINT8 *private_data)
{
    UINT32 status = ZOSS_ERROR;

    switch(state)
    {
    case ZOSS_STATUS_INIT:
        {
            switch(msg_id)
            {
            case EV_INIT:
                {
                    break;
                }
                
            case EV_POWERON:
                {
                    gMon_OsAgtID = zOss_GetTaskID(OSS_MON_AGT_NAME);
                    #ifdef CYGOPT_HAL_ARM_MMU
                    zTos_GetMmuConfigTable(&oss_mon_ele_ptr.monMmuInfo);
                    #endif
                    status = zOss_SetState(ZOSS_STATUS_WORK);
                    if (status != ZOSS_SUCCESS)
                    {
                        zOss_Printf(SUBMDL_SHELL, PRINT_LEVEL_ABNORMAL, "OSS_MONITOR_POWERON:Fail to set state!");
                    }
                    break;
                }
                
            default:
                {
                    zOss_Printf(SUBMDL_SHELL, PRINT_LEVEL_ABNORMAL, "OSS_MONITOR:Receive a invalid message!");
                    break;
                }
            }
            break;
        }
        
    case ZOSS_STATUS_WORK:  
        {
            switch(msg_id)
            {
            case OSS_MON_SET_FLAG:
                {
                    status = monitor_SetMonFlag(buf);
                    if (status != ZOSS_SUCCESS)
                    {
                        zOss_Printf(SUBMDL_SHELL, PRINT_LEVEL_ABNORMAL, "OSS_MONITOR:Fail to set Monitor flag!");
                    }
                    break;
                }
                
            default:
                {           
                    status = monitor_MessageDisposeHandler(msg_id, buf);
                    if (status != ZOSS_SUCCESS)
                    {
                        zOss_Printf(SUBMDL_SHELL, PRINT_LEVEL_ABNORMAL, "OSS_MONITOR:Fail to dispose message!");
                    }
                    break;
                }
            }
            break;
        }
        
    default:
        {
            break;
        }
    }	
}

/**************************************************************************
* ֲʵ
**************************************************************************/

/**************************************************************************
* ƣmonitor_MessageDisposeHandler
* عģϢ
* ˵(IN)
*           msg_id: ϢID 
*           buf:    Ϣbuf           
*           (OUT)
*   ֵɹZOSS_SUCCESSʧܷZOSS_ERROR
* ˵
**************************************************************************/
static UINT32 monitor_MessageDisposeHandler(UINT32 msg_id, UINT8 *buf)
{
    UINT32 cnt = 0;

    if (!gOsa_MonitorFlag)
    {
        zOss_Printf(SUBMDL_SHELL, PRINT_LEVEL_ABNORMAL, "OSS_MONITOR: Monitor flag is off!");
        return ZOSS_ERROR;
    }

    for (cnt = 0; cnt < ARRAY_SIZE(oss_mon_id_to_func); cnt++)
    {
        if (msg_id == oss_mon_id_to_func[cnt].msgId)
        {
            return (oss_mon_id_to_func[cnt].func(buf));
        }
    }

    return ZOSS_ERROR;
}

/**************************************************************************
* ƣmonitor_VersionInfo
* ṩصİ汾Ϣ
* ˵(IN) buf: Ϣbuf
*           (OUT)
*   ֵɹZOSS_SUCCESSʧܷZOSS_ERROR
* ˵
**************************************************************************/
static UINT32 monitor_VersionInfo(UINT8 *buf)
{
    oss_mon_ele_ptr.monVersionInfo.version = (char *)OSS_MON_VERSION_TYPE;

    return zOss_TaskSendData(OSS_MON_VERSION,
                             &oss_mon_ele_ptr.monVersionInfo,
                             sizeof(T_ZOss_Mon_Version),
                             gMon_OsAgtID);
}

/**************************************************************************
* ƣmonitor_CpuFrequencyInfo
* ṩCPUƵϢ
* ˵(IN) buf: Ϣbuf
*           (OUT)
*   ֵɹZOSS_SUCCESSʧܷZOSS_ERROR
* ˵
**************************************************************************/
static UINT32 monitor_CpuFrequencyInfo(UINT8 *buf)
{
    oss_mon_ele_ptr.monCpuFrequency.frequency = 128;//zDrvSysClk_GetArmCoreFreq();
    
    return zOss_TaskSendData(OSS_MON_CPU_FREQUENCY,
                             &oss_mon_ele_ptr.monCpuFrequency,
                             sizeof(T_ZOss_Mon_Cpu_Frequency),
                             gMon_OsAgtID);
}

/**************************************************************************
* ƣmonitor_CpuLoadInfo
* ṩCPU
* ˵(IN) buf: Ϣbuf
*           (OUT)
*   ֵɹZOSS_SUCCESSʧܷZOSS_ERROR
* ˵
**************************************************************************/
static UINT32 monitor_CpuLoadInfo(UINT8 *buf)
{
    oss_mon_ele_ptr.monCpuLoad.load = 
        (unsigned short)( (OSS_MON_PERCENT_RADIO - Osa_GetProcessCPU(zOss_GetThreadIDByName(EXCEP_IDLETHREADNAME)))
        * OSS_MON_PERCENT_RADIO);

    return zOss_TaskSendData(OSS_MON_CPU_LOAD,
                             &oss_mon_ele_ptr.monCpuLoad,
                             sizeof(T_ZOss_Mon_Cpu_Load),
                             gMon_OsAgtID);
}

/**************************************************************************
* ƣmonitor_PoolInfo
* ṩڴصʹ
* ˵(IN) buf: Ϣbuf
*           (OUT)
*   ֵɹZOSS_SUCCESSʧܷZOSS_ERROR
* ˵ڴصǰͳϢΪsizeʹø
**************************************************************************/
static UINT32 monitor_PoolInfo(UINT8 *buf)
{
    pool_used_info(&oss_mon_ele_ptr.monPoolInfo);
    
#ifdef POOL_DEBUG
    return zOss_TaskSendData(OSS_MON_POOL,
                             &oss_mon_ele_ptr.monPoolInfo,
                             sizeof(T_ZOss_Mon_Pool),
                             gMon_OsAgtID);
#else
    return ZOSS_SUCCESS;
#endif
}
  
/**************************************************************************
* ƣmonitor_PoolAllocInfo
* ṩڴصʹ
* ˵(IN) buf: Ϣbuf
*           (OUT)
*   ֵɹZOSS_SUCCESSʧܷZOSS_ERROR
* ˵ڴҪٹߴ(Ϣշ)ͷ
**************************************************************************/
static UINT32 monitor_PoolAllocInfo(UINT8 *buf)
{
    pool_alloc_info(&oss_mon_ele_ptr.monPoolAlloc);

#ifdef POOL_DEBUG
    return zOss_TaskSendData(OSS_MON_POOL_ALLOC,
                             &oss_mon_ele_ptr.monPoolAlloc,
                             sizeof(T_ZOss_Mon_Pool_Alloc),
                             gMon_OsAgtID);
#else
    return ZOSS_SUCCESS;
#endif
}

/**************************************************************************
* ƣmonitor_PoolLeakInfo
* ṩڴصʹй¶
* ˵(IN) buf: Ϣbuf
*           (OUT)
*   ֵɹZOSS_SUCCESSʧܷZOSS_ERROR
* ˵ڴҪٹߴ(Ϣշ)ͷ
**************************************************************************/
static UINT32 monitor_PoolLeakInfo(UINT8 *buf)
{
    pool_leak_info(&oss_mon_ele_ptr.monPoolLeak);
    
#ifdef POOL_DEBUG
    return zOss_TaskSendData(OSS_MON_POOL_LEAK,
                             &oss_mon_ele_ptr.monPoolLeak,
                             sizeof(T_ZOss_Mon_Pool_Leak),
                             gMon_OsAgtID);
#else
    return ZOSS_SUCCESS;
#endif
}

/**************************************************************************
* ƣmonitor_HeapInfo
* ṩڴʹ
* ˵(IN) buf: Ϣbuf
*           (OUT)
*   ֵɹZOSS_SUCCESSʧܷZOSS_ERROR
* ˵
**************************************************************************/
static UINT32 monitor_HeapInfo(UINT8 *buf)
{
    z0ss_GetHeapInfo(&oss_mon_ele_ptr.monHeapInfo);
    
    return zOss_TaskSendData(OSS_MON_HEAP, 
                             &oss_mon_ele_ptr.monHeapInfo, 
                             sizeof(T_ZOss_Mon_Heap), 
                             gMon_OsAgtID); 
}

/**************************************************************************
* ƣmonitor_ThreadInfo
* ṩ̵߳״̬Ϣ
* ˵(IN) buf: Ϣbuf
*           (OUT)
*   ֵɹZOSS_SUCCESSʧܷZOSS_ERROR
* ˵ڴҪٹߴ(Ϣշ)ͷ
**************************************************************************/
static UINT32 monitor_ThreadInfo(UINT8 *buf)
{
    z0ss_GetAllThreadInfo(&oss_mon_ele_ptr.monThreadInfo);
    
    return zOss_TaskSendData(OSS_MON_THREAD,
                             &oss_mon_ele_ptr.monThreadInfo,
                             sizeof(T_ZOss_Mon_Thread),
                             gMon_OsAgtID); 
}

/**************************************************************************
* ƣmonitor_TaskInfo
* ṩ״̬Ϣ
* ˵(IN) buf: Ϣbuf
*           (OUT)
*   ֵɹZOSS_SUCCESSʧܷZOSS_ERROR
* ˵ڴҪٹߴ(Ϣշ)ͷ
**************************************************************************/
static UINT32 monitor_TaskInfo(UINT8 *buf)
{       
    zOss_GetAllTaskInfo(&oss_mon_ele_ptr.monTaskInfo);

    return zOss_TaskSendData(OSS_MON_TASK, 
                             &oss_mon_ele_ptr.monTaskInfo, 
                             sizeof(T_ZOss_Mon_Task), 
                             gMon_OsAgtID);
}

/**************************************************************************
* ƣmonitor_EventInfo
* ṩϵͳ¼Ϣ
* ˵(IN) buf: Ϣbuf
*           (OUT)
*   ֵɹZOSS_SUCCESSʧܷZOSS_ERROR
* ˵
**************************************************************************/
static UINT32 monitor_EventInfo(UINT8 *buf)
{
    z0ss_GetEventInfo(&oss_mon_ele_ptr.monEventInfo);
    
    return zOss_TaskSendData(OSS_MON_EVENT,
                             &oss_mon_ele_ptr.monEventInfo,
                             sizeof(T_ZOss_Mon_Event),
                             gMon_OsAgtID);
}

/**************************************************************************
* ƣmonitor_MsgInfo
* ṩϢշϢ
* ˵(IN) buf: Ϣbuf
*           (OUT)
*   ֵɹZOSS_SUCCESSʧܷZOSS_ERROR
* ˵
**************************************************************************/
static UINT32 monitor_MsgInfo(UINT8 *buf)
{
    z0ss_GetMsgInfo(&oss_mon_ele_ptr.monMsgInfo);
    
    return zOss_TaskSendData(OSS_MON_MSG,
                             &oss_mon_ele_ptr.monMsgInfo,
                             sizeof(T_ZOss_Mon_Msg),
                             gMon_OsAgtID);
}

/**************************************************************************
* ƣmonitor_RamlogInfo
* ṩRamlogϢ
* ˵(IN) buf: Ϣbuf
*           (OUT)
*   ֵɹZOSS_SUCCESSʧܷZOSS_ERROR
* ˵
**************************************************************************/
static UINT32 monitor_RamlogInfo(UINT8 *buf)
{    
    z0ss_GetRamlogInfo(&oss_mon_ele_ptr.monRamlogInfo);

    return zOss_TaskSendData(OSS_MON_RAMLOG,
                             &oss_mon_ele_ptr.monRamlogInfo,
                             sizeof(T_ZOss_Mon_Ramlog),
                             gMon_OsAgtID);
}

/**************************************************************************
* ƣmonitor_PrivodeVarInfo
* ṩָϢ
* ˵(IN) buf: Ϣbuf
*           (OUT)
*   ֵɹZOSS_SUCCESSʧܷZOSS_ERROR
* ˵ڴҪٹߴ(Ϣշ)ͷ
**************************************************************************/
static UINT32 monitor_GetVarInfo(UINT8 *buf)
{
    T_ZOss_Mon_Get_Var_Req *varInfo = NULL;

    if (buf == NULL)
    {
        return ZOSS_ERROR;
    }

    varInfo = (T_ZOss_Mon_Get_Var_Req *)buf;
    if (varInfo->base == 0 || varInfo->size == 0)
    {
        return ZOSS_ERROR;
    }

    oss_mon_ele_ptr.monGetVarInfo.size  = varInfo->size;
    oss_mon_ele_ptr.monGetVarInfo.value = (unsigned char *)zOss_GetUB(oss_mon_ele_ptr.monGetVarInfo.size);
    zOss_AssertEx(oss_mon_ele_ptr.monGetVarInfo.value != NULL, ZOSS_ERROR);
        
    zOss_Memcpy((VOID *)oss_mon_ele_ptr.monGetVarInfo.value, (const VOID *)varInfo->base, varInfo->size); 
    zOss_RetUB((VOID *)varInfo);
    varInfo = NULL;
    return zOss_TaskSendData(OSS_MON_GET_VAR_ACK,
                             &oss_mon_ele_ptr.monGetVarInfo,
                             sizeof(T_ZOss_Mon_Get_Var_Ack),
                             gMon_OsAgtID);
}

/**************************************************************************
* ƣmonitor_SetVarInfo
* ޸ָڴεֵ
* ˵(IN) buf: Ϣbuf
*           (OUT)
*   ֵɹZOSS_SUCCESSʧܷZOSS_ERROR
* ˵
**************************************************************************/
static UINT32 monitor_SetVarInfo(UINT8 *buf)
{    
    T_ZOss_Mon_Set_Var   *varInfo   = NULL;
    ZOSS_INTR           old_intr    = 0;

    if (buf == NULL)
    {
        return ZOSS_ERROR;
    }
    varInfo = (T_ZOss_Mon_Set_Var *)buf;
    if (varInfo->base == 0 || varInfo->size == 0)
    {
        return ZOSS_ERROR;
    } 
    
    ZOSS_SAVE_IRQ(old_intr);
    zOss_Memcpy((VOID *)varInfo->base, (const VOID *)varInfo->value, varInfo->size);
    ZOSS_RESTORE_IRQ(old_intr);
    
    zOss_RetUB((VOID *)varInfo->value);
    zOss_RetUB((VOID *)varInfo);
    return ZOSS_SUCCESS;
}

/**************************************************************************
* ƣmonitor_TimerInfo
* ṩTimerʹ
* ˵(IN) buf: Ϣbuf
*           (OUT)
*   ֵɹZOSS_SUCCESSʧܷZOSS_ERROR
* ˵ڴҪٹߴ(Ϣշ)ͷ
**************************************************************************/
static UINT32 monitor_TimerInfo(UINT8 *buf)
{  
    zOss_GetTimerInfo(&oss_mon_ele_ptr.monTimerInfo);
    
    return zOss_TaskSendData(OSS_MON_TIMER,
                             &oss_mon_ele_ptr.monTimerInfo,
                             sizeof(T_ZOss_Mon_Timer),
                             gMon_OsAgtID); 
}

/**************************************************************************
* ƣmonitor_MmuInfo
* ṩMMUڴӳϢ
* ˵(IN) buf: Ϣbuf
*           (OUT)
*   ֵɹZOSS_SUCCESSʧܷZOSS_ERROR
* ˵
**************************************************************************/
static UINT32 monitor_MmuInfo(UINT8 *buf)
{
    return zOss_TaskSendData(OSS_MON_MMU,
                             &oss_mon_ele_ptr.monMmuInfo,
                             sizeof(T_ZOss_Mon_Mmu),
                             gMon_OsAgtID);
}

/**************************************************************************
* ƣmonitor_MonFlagInfo
* ޸ļģ־λ
* ˵(IN) buf: Ϣbuf
*           (OUT)
*   ֵɹZOSS_SUCCESSʧܷZOSS_ERROR
* ˵
**************************************************************************/
static UINT32 monitor_SetMonFlag(UINT8 *buf)
{
    T_ZOss_Mon_Set_Flag *flagInfo = NULL;

    if (buf)
    {
        flagInfo = (T_ZOss_Mon_Set_Flag *)buf;
        if (flagInfo->flag)
        {
#ifdef OSS_TRACE_THREAD
            oss_trace_thread_open();
#endif

#ifdef TOS_STATISTIC_IRQ
            tos_statistic_irq_open();
#endif

#ifdef TOS_TRACE_IRQ
            tos_trace_irq_open();
#endif
        }
        else
        {
#ifdef TOS_TRACE_IRQ        
            tos_trace_irq_close();
#endif

#ifdef TOS_STATISTIC_IRQ
            tos_statistic_irq_close();
#endif

#ifdef OSS_TRACE_THREAD
            oss_trace_thread_close();
#endif
        }
        gOsa_MonitorFlag = flagInfo->flag;
        zOss_RetUB((VOID *)flagInfo);
        return ZOSS_SUCCESS;
    } 
    return ZOSS_ERROR;
}

#endif

