/**************************************************************************
*
*                  Copyright (c) 2012 ZTE Corporation.
*
***************************************************************************
* ģ   : P98_NVM
*    : nvm.c
* ļ : 
* ʵֹ : nvݹӿ
*      : ¬л
*      : V1.0
*  : 2009-08-06
* ˵ : 
**************************************************************************/

/**************************************************************************
* ޸ļ¼
**************************************************************************/
/**************************************************************************
* ޸ı : 0001
*    : wuzhengjun
* ޸ : 2012-09-17
* ޸ : ʽ淶PC-LINT߲  EC:617001781798
**************************************************************************/
/**************************************************************************
* ޸ı : 0002
*    : wuzhengjun
* ޸ : 2012-09-27
* ޸ : ߲   EC:617001781846 
**************************************************************************/
/**************************************************************************
* ޸ı : 0003
*    : wangqing
* ޸ : 2018-08-27
* ޸ : Ϊļϵͳʵ
**************************************************************************/

/**************************************************************************
* #include
**************************************************************************/
#include "sup_nvm.h"
#include "drv_api.h"
#include "drvs_gpio.h"
#include "oss_cfg.h"
#include "RWNvConfig.h"
#include "sys_func_atcfg.h"
#ifdef _OS_LINUX
#include <linux/unistd.h>
#include <linux/ctype.h>
#include <linux/syscalls.h>
#include <linux/statfs.h>
#include <linux/fs.h>
#include <linux/uaccess.h>
#endif

#ifdef __cplusplus
extern "C"
{
#endif

#ifdef USE_CPPS_KO
#define CPPS_KO_FUNC(func) kernel_##func
#else
#define CPPS_KO_FUNC(func) func
#endif

/**************************************************************************
* ⲿͱ
**************************************************************************/
extern void msleep(unsigned int msecs);

/**************************************************************************
* 궨
**************************************************************************/
#define NV_SYMBOL_DOWN   	0xA2        /* unused */
#define NV_SYMBOL_NORMAL    0xB3        /* ±־λֵ */
#define NV_SYMBOL_WRITE     0xC4        /* дNV±־λֵ */
#define NV_SYMBOL_FACTORY   0xD5        /* ָ־λֵ   */

#define NV_WORK_AREA        0x01        /* ʶ           */
#define NV_BACKUP_AREA      0x02        /* ʶ           */

#define NVM_FS_RO_FAC_PATH         	"/mnt/nvrofs/nvroall.bin"
#define NVM_FS_ROW_FAC_PATH         "/mnt/nvrofs/nvrowall.bin"
#define NVM_FS_ROW_C0_FAC_PATH      "/mnt/nvrofs/nvroc0wall.bin"
#define NVM_FS_RWO_FAC_PATH         "/mnt/imagefs/nvrwoall.bin"
#define NVM_FS_RW_FAC_PATH         	"/mnt/imagefs/nvrwall.bin"
#define NVM_FS_RW_HASH_FAC_PATH     "/mnt/imagefs/nvrwall.hash"

#define NVM_FS_RW_DIR        		"/etc_rw/psnv"
#define NVM_FS_RW_MAIN_PATH         "/etc_rw/psnv/rw_work"
#define NVM_FS_RW_BACKUP_PATH       "/etc_rw/psnv/rw_backup"

#define NVM_FS_FAC_SYMBOL_PATH    		"/etc_rw/psnv/fac_flag"
#define NVM_FS_RW_MAIN_SYMBOL_PATH    	"/etc_rw/psnv/work_flag"
#define NVM_FS_RW_BACKUP_SYMBOL_PATH    "/etc_rw/psnv/backup_flag"
#define NVM_FS_RW_HASH_WORK_PATH        "/etc_rw/psnv/nvrwall.hash"

#define NVRWO_CONVERT_OFFSET   (OS_FLASH_AMT_RW_USER_GGE_SIZE + OS_FLASH_AMT_RW_USER_WCDMA_SIZE + OS_FLASH_AMT_RW_USER_LTEA_SIZE + OS_FLASH_RFCOM_RW_NONFAC_SIZE)
#define NVRWO_CONVERT_OFFSET1  (OS_FLASH_RFCOM_RW_NONFAC_SIZE)
#define NVRWO_CONVERT_OFFSET2  (OS_FLASH_RFCOM_RW_NONFAC_BASE_ADDR + OS_FLASH_RFCOM_RW_NONFAC_SIZE + NVRWO_CONVERT_OFFSET1 - OS_FLASH_AMT_RW_USER_GGE_BASE_ADDR)
#define NVRWO_CONVERT_START    (OS_FLASH_RFCOM_RW_NONFAC_BASE_ADDR + OS_FLASH_RFCOM_RW_NONFAC_SIZE - OS_FLASH_RWO_OFFSET_FROM_NV)
#define NVRWO_CONVERT_MAX_END ((OS_FLASH_RFCOM_RW_NONFAC_BASE_ADDR + OS_FLASH_RFCOM_RW_NONFAC_SIZE) + 8 * (NVRWO_CONVERT_OFFSET) - OS_FLASH_RWO_OFFSET_FROM_NV)

/**************************************************************************
* ݽṹ
**************************************************************************/
typedef struct
{
    UINT32 start;
    UINT32 len;
    UINT32 offset;
} T_zOss_NvRwoConvert;

/**************************************************************************
* ֲԭ
**************************************************************************/
static BOOL   Nvram_Check_Data(VOID);
static UINT32 Nvram_WriteWithFlag(UINT32 NvItemID, UINT8 *NvItemData, UINT32 NvItemLen, UINT8 iNvm);
static UINT32 Nvram_WriteRO(const CHAR *part_name, UINT32 NvItemID, UINT8 *NvItemData, UINT32 NvItemLen);
static UINT32 Nvram_FsRead(const CHAR *part_name, UINT32 dwStart, UINT32 dwLen, UINT8 *to);
static UINT32 Nvram_FsWrite(const CHAR *part_name, UINT32 dwStart, UINT32 dwLen, UINT8 *from);
static UINT32 Nvram_Remount(CHAR *DevName, CHAR *DirName, CHAR *Type, UINT32 Flag);
static UINT32 Nvram_CopyFile(const CHAR *pDstFile, const CHAR *pSrcFile);
static UINT32 Nvram_CmpFile(const CHAR *pDstFile, const CHAR *pSrcFile);
static UINT32 Nvram_DirInit(VOID);
static UINT32 Nvram_RoInit(VOID);
static UINT32 Nvram_RwInit(VOID);
static SINT32 Nvram_WriteFile(const CHAR *pFile, UINT8 *pBuf, UINT32 len);
static UINT8  *Nvram_ReadFile(const CHAR *pFile, UINT32 *len);
static UINT32 Nvram_RwoConvert(UINT32 NvItemID, UINT32 NvItemLen);

/**************************************************************************
* ȫֳ/
**************************************************************************/
static ZOSS_MUTEX_ID	gNV_Mutex	= NULL;   	   /* Flash   */
static BOOL             gNV_Inited 	= FALSE;       /* NVдʹ        */
const T_zOss_NvRwoConvert g_NvRwoConInfo[] = 
{
    {OS_FLASH_RFCOM_RW_NONFAC_BASE_ADDR, OS_FLASH_RFCOM_RW_NONFAC_SIZE, NVRWO_CONVERT_OFFSET1},
    {OS_FLASH_AMT_RW_USER_GGE_BASE_ADDR, OS_FLASH_AMT_RW_USER_GGE_SIZE + OS_FLASH_AMT_RW_USER_WCDMA_SIZE + OS_FLASH_AMT_RW_USER_LTEA_SIZE, NVRWO_CONVERT_OFFSET2},
};

/**************************************************************************
* ȫֺʵ
**************************************************************************/
/**************************************************************************
* ƣ NV_Init
*  NVʼ
* ˵ 
*   ֵ ɹZOSS_SUCCESS, 򷵻ZOSS_ERROR
* ˵
**************************************************************************/
UINT32 NV_Init(VOID)
{
    T_OSS_PARAM *pOssParam = NULL;

    if (gNV_Inited)
        return ZOSS_SUCCESS;

    /* NV */
    gNV_Mutex = zOss_CreateMutex("NV_Mutex", ZOSS_INHERIT);
    if (gNV_Mutex == NULL)
        return ZOSS_ERROR;

	/* 鿴ͱǷЧЧָ */
    Nvram_Check_Data();

	gNV_Inited = TRUE;
	
    return ZOSS_SUCCESS;
}

/**************************************************************************
* ƣ zOss_NvItemRead
*  һNV
* ˵ (IN)
*            NvItemID:     NVƫƵַ(NVʼַƫ)
*            NvItemData:   
*            NvItemLen:    ݳ
*            (OUT)
*   ֵ ɹZOSS_SUCCESS, 򷵻ZOSS_ERROR
* ˵
**************************************************************************/
UINT32 zOss_NvItemRead(UINT32 NvItemID, UINT8 *NvItemData, UINT32 NvItemLen)
{
    SINT32 status = -1;
	SINT8 *pNvFile = NULL;

    if (gNV_Inited == FALSE || NvItemLen == 0 || NvItemData == NULL)
        return ZOSS_ERROR;

	if(NvItemID >= OS_FLASH_RO_OFFSET_FROM_NV && (NvItemID + NvItemLen) <= (OS_FLASH_RO_OFFSET_FROM_NV + OS_FLASH_RO_NVRAM_SIZE))
	{
		pNvFile = NVM_FS_RO_FAC_PATH;
		NvItemID -= OS_FLASH_RO_OFFSET_FROM_NV;
	}
	else if(NvItemID >= OS_FLASH_LOCKNET_ROW_OFFSET_FROM_NV && (NvItemID + NvItemLen) <= (OS_FLASH_LOCKNET_ROW_OFFSET_FROM_NV + OS_FLASH_LOCKNET_ROW_SIZE))
	{
		pNvFile = NVM_FS_ROW_FAC_PATH;
		NvItemID -= OS_FLASH_LOCKNET_ROW_OFFSET_FROM_NV;
	}
	else if(NvItemID >= OS_FLASH_C0CALIINFO_ROW_OFFSET_FROM_NV && (NvItemID + NvItemLen) <= (OS_FLASH_C0CALIINFO_ROW_OFFSET_FROM_NV + OS_FLASH_C0CALIINFO_ROW_SIZE))
	{
		pNvFile = NVM_FS_ROW_C0_FAC_PATH;
		NvItemID -= OS_FLASH_C0CALIINFO_ROW_OFFSET_FROM_NV;
	}
	else if(NvItemID >= OS_FLASH_RWO_OFFSET_FROM_NV && (NvItemID + NvItemLen) <= (OS_FLASH_RWO_OFFSET_FROM_NV + OS_FLASH_RWO_NVRAM_SIZE))
	{
		pNvFile = NVM_FS_RWO_FAC_PATH;
        NvItemID = Nvram_RwoConvert(NvItemID, NvItemLen);
		NvItemID -= OS_FLASH_RWO_OFFSET_FROM_NV;
	}
	else if(NvItemID >= OS_FLASH_RW_OFFSET_FROM_NV && (NvItemID + NvItemLen) <= (OS_FLASH_RW_OFFSET_FROM_NV + OS_FLASH_RW_NVRAM_SIZE))
	{
		pNvFile = NVM_FS_RW_MAIN_PATH;
		NvItemID -= OS_FLASH_RW_OFFSET_FROM_NV;
	}
	else
		return ZOSS_ERROR;

    /* ȡNV */
    zOss_GetMutex(gNV_Mutex, ZOSS_WAIT_FOREVER);
	status = Nvram_FsRead(pNvFile, NvItemID, NvItemLen, NvItemData);
    zOss_PutMutex(gNV_Mutex);

    return status;
}

/**************************************************************************
* ƣ zOss_NvItemWrite
*  дһNV
* ˵ (IN)
*            NvItemID:    NVƫƵַ(NVʼַƫ)
*            NvItemData:  д
*            NvItemLen:   ݳ
*            (OUT)
*   ֵ ɹZOSS_SUCCESS, 򷵻ZOSS_ERROR
* ˵
**************************************************************************/
UINT32 zOss_NvItemWrite(UINT32 NvItemID, UINT8 *NvItemData, UINT32 NvItemLen)
{
    UINT32 status = ZOSS_ERROR;

    if (gNV_Inited == FALSE || NvItemLen == 0 || NvItemData == NULL)
        return ZOSS_ERROR;

	zOss_GetMutex(gNV_Mutex, ZOSS_WAIT_FOREVER);  

	if(NvItemID >= OS_FLASH_RW_OFFSET_FROM_NV && (NvItemID + NvItemLen) <= (OS_FLASH_RW_OFFSET_FROM_NV + OS_FLASH_RW_NVRAM_SIZE))
	{//rw
		NvItemID -= OS_FLASH_RW_OFFSET_FROM_NV;
	    status = Nvram_WriteWithFlag(NvItemID, NvItemData, NvItemLen, NV_WORK_AREA);/* д빤 */
	    if (status == ZOSS_SUCCESS)
	        status = Nvram_WriteWithFlag(NvItemID, NvItemData, NvItemLen, NV_BACKUP_AREA);/* д뱸 */
	}
	else if(NvItemID >= OS_FLASH_RO_OFFSET_FROM_NV && (NvItemID + NvItemLen) <= (OS_FLASH_RO_OFFSET_FROM_NV + OS_FLASH_RO_NVRAM_SIZE))
	{// ro
		NvItemID -= OS_FLASH_RO_OFFSET_FROM_NV;
		status = Nvram_FsWrite(NVM_FS_RO_FAC_PATH, NvItemID, NvItemLen, NvItemData);
	}
	else if(NvItemID >= OS_FLASH_LOCKNET_ROW_OFFSET_FROM_NV && (NvItemID + NvItemLen) <= (OS_FLASH_LOCKNET_ROW_OFFSET_FROM_NV + OS_FLASH_LOCKNET_ROW_SIZE))
	{// row_locknet
		NvItemID -= OS_FLASH_LOCKNET_ROW_OFFSET_FROM_NV;
		status = Nvram_FsWrite(NVM_FS_ROW_FAC_PATH, NvItemID, NvItemLen, NvItemData);
	}
	else if(NvItemID >= OS_FLASH_C0CALIINFO_ROW_OFFSET_FROM_NV && (NvItemID + NvItemLen) <= (OS_FLASH_C0CALIINFO_ROW_OFFSET_FROM_NV + OS_FLASH_C0CALIINFO_ROW_SIZE))
	{// ro_c0cail
		NvItemID -= OS_FLASH_C0CALIINFO_ROW_OFFSET_FROM_NV;
		status = Nvram_FsWrite(NVM_FS_ROW_C0_FAC_PATH, NvItemID, NvItemLen, NvItemData);
	}
 
    zOss_PutMutex(gNV_Mutex);

    return status;
}

/**************************************************************************
* ƣ zOss_ResetNVFactory
*  ָ(Ч)
* ˵ 
*   ֵ ɹZOSS_SUCCESS, 򷵻ZOSS_ERROR
* ˵
**************************************************************************/
UINT32 zOss_ResetNVFactory(VOID)
{
    UINT8   Symbol = NV_SYMBOL_FACTORY;
    UINT32  status = ZOSS_ERROR;

	status = Nvram_FsWrite(NVM_FS_FAC_SYMBOL_PATH, 0, 1, &Symbol);

    return (status == 0) ? ZOSS_SUCCESS : ZOSS_ERROR;
}

/**************************************************************************
* ƣ zOss_NvInResume
*  ǷNVָ
* ˵ 
*   ֵ TRUE:ڻָ̣FLASE:ڻָ
* ˵ ʹ
**************************************************************************/
BOOL zOss_NvInResume(VOID)
{
    return 0;
}

/**************************************************************************
* ƣ zOss_NvramFlush
*  дNV
* ˵ 
*   ֵ ɹZOSS_SUCCESS, 򷵻ZOSS_ERROR
* ˵
**************************************************************************/
UINT32 zOss_NvramFlush(VOID)
{
    return Nvram_Flush();
}

/**************************************************************************
* ƣ zOss_NvCheck
*  NV־лָ
* ˵ 
*   ֵ 
* ˵ ʹ
**************************************************************************/
VOID zOss_NvCheck(VOID)
{   
    return;
}

/**************************************************************************
* ƣ zOss_NvItemWriteFactory
*  дһNV 
* ˵ (IN)
*            NvItemID:    NVƫƵַ(NVʼַƫ)
*            NvItemData:  д
*            NvItemLen:   ݳ
*            (OUT)
*   ֵ ɹZOSS_SUCCESS, 򷵻ZOSS_ERROR
* ˵ жϼִ
**************************************************************************/
UINT32 zOss_NvItemWriteFactory(UINT32 NvItemID, UINT8 *NvItemData, UINT32 NvItemLen)
{
    UINT32  status = ZOSS_ERROR;
	mm_segment_t old_fs = get_fs();
	
    if (gNV_Inited == FALSE || NvItemLen == 0 || NvItemData == NULL)
		return ZOSS_ERROR;

	if(NvItemID >= OS_FLASH_RW_OFFSET_FROM_NV && (NvItemID + NvItemLen) <= (OS_FLASH_RW_OFFSET_FROM_NV + OS_FLASH_RW_NVRAM_SIZE))
		NvItemID -= OS_FLASH_RW_OFFSET_FROM_NV;
	else
		return ZOSS_ERROR;

	zOss_GetMutex(gNV_Mutex, ZOSS_WAIT_FOREVER); 
	
	//status = Nvram_Remount("mtd:imagefs", "/mnt/imagefs", "jffs2", MS_REMOUNT |MS_VERBOSE);
	//if(ZOSS_SUCCESS != status)
	//{
	//	zOss_PutMutex(gNV_Mutex);
	//	return ZOSS_ERROR;
	//}
	
	status = Nvram_FsWrite(NVM_FS_RW_FAC_PATH, NvItemID, NvItemLen, NvItemData);
	//status |= Nvram_Remount("mtd:imagefs", "/mnt/imagefs", "jffs2", MS_REMOUNT |MS_VERBOSE | MS_RDONLY);

	zOss_PutMutex(gNV_Mutex);
	return status;
}

/**************************************************************************
* ƣ zOss_NvGetEccLogInfo
*  ȡECC LogϢ
* ˵ 
*   ֵ
* ˵
**************************************************************************/
UINT32 zOss_NvGetEccLogInfo(T_ZOss_NvEccLog *logInfo)
{
    return ZOSS_ERROR;
}

/**************************************************************************
* ƣ zOss_ChangeNvroAttr
*  ıNVRO
* ˵ 
*   ֵ
* ˵
**************************************************************************/
UINT32 zOss_ChangeNvroAttr(int writable)
{
	if (cpnv_ChangeNvroAttr(writable) < 0)
		return ZOSS_ERROR;

	return ZOSS_SUCCESS;
}

/**************************************************************************
* ƣ Nvram_Finish
*  NVдNV
* ˵ 
*   ֵ ɹZOSS_SUCCESS, 򷵻ZOSS_ERROR
* ˵
**************************************************************************/
UINT32 Nvram_Finish(VOID)
{
    return ZOSS_SUCCESS;
}

/**************************************************************************
* ƣ Nvram_Flush
*  дNV
* ˵ 
*   ֵ ɹZOSS_SUCCESS, 򷵻ZOSS_ERROR
* ˵
**************************************************************************/
UINT32 Nvram_Flush(VOID)
{
	return ZOSS_SUCCESS;
}
/**************************************************************************
* ֲʵ
**************************************************************************/

/**************************************************************************
* ƣ Nvram_DirInit
*  ʼnvmĿ¼
* ˵ (IN)
*            (OUT)
*   ֵɹZOSS_SUCCESS, 򷵻ZOSS_ERROR
* ˵
**************************************************************************/
static UINT32 Nvram_DirInit(VOID)
{
	if(CPPS_KO_FUNC(sys_access)(NVM_FS_RW_DIR, 0) != 0)
	{
		if(CPPS_KO_FUNC(sys_mkdir)(NVM_FS_RW_DIR, 0755) != 0)
		{
			printk("cpnv mkdir %s fali\n", NVM_FS_RW_DIR);
			return ZOSS_ERROR;
		}
	}

	return ZOSS_SUCCESS;
}

/**************************************************************************
* ƣ Nvram_RoInit
*  ʼRo nv
* ˵ (IN)
*            (OUT)
*   ֵɹZOSS_SUCCESS, 򷵻ZOSS_ERROR
* ˵
**************************************************************************/
static UINT32 Nvram_RoInit(VOID)
{
	UINT8 *pNvdata;
	UINT32  status = ZOSS_ERROR;
	
	if(CPPS_KO_FUNC(sys_open)(NVM_FS_RO_FAC_PATH, O_RDONLY, 0) == -ENOENT)
	{
		pNvdata = zOss_GetUB(OS_FLASH_RO_NVRAM_SIZE);
		if (pNvdata == NULL)
		{
			printk("cpnv malloc rodata fail\n");
			return ZOSS_ERROR;
		}

		memset(pNvdata, 0xff, OS_FLASH_RO_NVRAM_SIZE);
		
		status = Nvram_WriteRO(NVM_FS_RO_FAC_PATH, 0, pNvdata, OS_FLASH_RO_NVRAM_SIZE);
		zOss_RetUB(pNvdata);
		if(status != ZOSS_SUCCESS)
			return ZOSS_ERROR;
		else
			printk("cpnv clean ro fs success!\n");
	}

	if(CPPS_KO_FUNC(sys_open)(NVM_FS_ROW_FAC_PATH, O_RDONLY, 0) == -ENOENT)
	{
		pNvdata = zOss_Malloc(OS_FLASH_LOCKNET_ROW_SIZE);
		if (pNvdata == NULL)
		{
			printk("cpnv malloc rowdata fail\n");
			return ZOSS_ERROR;
		}

		memset(pNvdata, 0xff, OS_FLASH_LOCKNET_ROW_SIZE);
		status = Nvram_WriteRO(NVM_FS_ROW_FAC_PATH, 0, pNvdata, OS_FLASH_LOCKNET_ROW_SIZE);
		zOss_Free(pNvdata);
		if(status != ZOSS_SUCCESS)
			return ZOSS_ERROR;
		else
			printk("cpnv clean row_locknet fs success!\n");
	}

	if(CPPS_KO_FUNC(sys_open)(NVM_FS_ROW_C0_FAC_PATH, O_RDONLY, 0) == -ENOENT)
	{
		pNvdata = zOss_Malloc(OS_FLASH_C0CALIINFO_ROW_SIZE);
		if (pNvdata == NULL)
		{
			printk("cpnv malloc rowdata fail\n");
			return ZOSS_ERROR;
		}

		memset(pNvdata, 0xff, OS_FLASH_C0CALIINFO_ROW_SIZE);
		status = Nvram_WriteRO(NVM_FS_ROW_C0_FAC_PATH, 0, pNvdata, OS_FLASH_C0CALIINFO_ROW_SIZE);
		zOss_Free(pNvdata);
		if(status != ZOSS_SUCCESS)
			return ZOSS_ERROR;
		else
			printk("cpnv clean row_cocail fs success!\n");
	}

	return ZOSS_SUCCESS;
}

/**************************************************************************
* ƣ Nvram_RwInit
*  ʼRo nv
* ˵ (IN)
*            (OUT)
*   ֵɹZOSS_SUCCESS, 򷵻ZOSS_ERROR
* ˵
**************************************************************************/
static UINT32 Nvram_RwInit(VOID)
{
    UINT8   WorkArea_Symbol = 0;
    UINT8   BackUp_Symbol   = 0;
    UINT8   Factory_Symbol  = 0;
    SINT32  WorkArea_Status = -1;
    SINT32  BackUp_Status   = -1;
    UINT32  status          = ZOSS_ERROR;

factory_check:

    /* 汾 */ /* ָ */ /* Fota */
    status = Nvram_FsRead(NVM_FS_FAC_SYMBOL_PATH, 0, 1, &Factory_Symbol);
    if(status || Factory_Symbol == NV_SYMBOL_FACTORY || Nvram_CmpFile(NVM_FS_RW_HASH_FAC_PATH, NVM_FS_RW_HASH_WORK_PATH))
    {
        status = Nvram_CopyFile(NVM_FS_RW_MAIN_PATH, NVM_FS_RW_FAC_PATH);
        zOss_ASSERT(status == ZOSS_SUCCESS);
        status = Nvram_CopyFile(NVM_FS_RW_BACKUP_PATH, NVM_FS_RW_FAC_PATH);
        zOss_ASSERT(status == ZOSS_SUCCESS);
        status = Nvram_CopyFile(NVM_FS_RW_HASH_WORK_PATH, NVM_FS_RW_HASH_FAC_PATH);
        zOss_ASSERT(status == ZOSS_SUCCESS);

        WorkArea_Symbol = NV_SYMBOL_NORMAL;
        status = Nvram_FsWrite(NVM_FS_RW_MAIN_SYMBOL_PATH, 0, 1, &WorkArea_Symbol);
        zOss_ASSERT(status == ZOSS_SUCCESS);
        BackUp_Symbol = NV_SYMBOL_NORMAL;
        status = Nvram_FsWrite(NVM_FS_RW_BACKUP_SYMBOL_PATH, 0, 1, &BackUp_Symbol);
        zOss_ASSERT(status == ZOSS_SUCCESS);

        Factory_Symbol = NV_SYMBOL_NORMAL;
        status = Nvram_FsWrite(NVM_FS_FAC_SYMBOL_PATH, 0, 1, &Factory_Symbol);
        zOss_ASSERT(status == ZOSS_SUCCESS);

        printk("cpnv version download or restore fac or fota update!\n");
        return ZOSS_SUCCESS;
    }

    /* ȡͱеı־λ */
    WorkArea_Status = Nvram_FsRead(NVM_FS_RW_MAIN_SYMBOL_PATH, 0, 1, &WorkArea_Symbol);
    BackUp_Status   = Nvram_FsRead(NVM_FS_RW_BACKUP_SYMBOL_PATH, 0, 1, &BackUp_Symbol);
    if(WorkArea_Status != 0 || WorkArea_Symbol != NV_SYMBOL_NORMAL) 
    {
        /* work area check fail */
        if(BackUp_Status == 0 && BackUp_Symbol == NV_SYMBOL_NORMAL)
        {
            /* backup area check ok */
            WorkArea_Symbol = NV_SYMBOL_WRITE;
            status = Nvram_FsWrite(NVM_FS_RW_MAIN_SYMBOL_PATH, 0, 1, &WorkArea_Symbol);
            zOss_ASSERT(status == ZOSS_SUCCESS);

            status = Nvram_CopyFile(NVM_FS_RW_MAIN_PATH, NVM_FS_RW_BACKUP_PATH);
            zOss_ASSERT(status == ZOSS_SUCCESS);

            WorkArea_Symbol = NV_SYMBOL_NORMAL;
            status = Nvram_FsWrite(NVM_FS_RW_MAIN_SYMBOL_PATH, 0, 1, &WorkArea_Symbol);
            zOss_ASSERT(status == ZOSS_SUCCESS);

            printk("cpnv restore backup to main!\n");
        }
        else
        {
            /* backup and work area check both fail */
            Factory_Symbol = NV_SYMBOL_FACTORY;
            status = Nvram_FsWrite(NVM_FS_FAC_SYMBOL_PATH, 0, 1, &Factory_Symbol);
            zOss_ASSERT(status == ZOSS_SUCCESS);

            printk("cpnv work and backup both fail restore fac!\n");
            goto factory_check;
        }
    }
    else
    {
        /* WorkArea ok*/
        if(BackUp_Status != 0 || BackUp_Symbol != NV_SYMBOL_NORMAL)
        {
            /* backup area check fail */
            BackUp_Symbol = NV_SYMBOL_WRITE;
            status = Nvram_FsWrite(NVM_FS_RW_BACKUP_SYMBOL_PATH, 0, 1, &BackUp_Symbol);
            zOss_ASSERT(status == ZOSS_SUCCESS);

            status = Nvram_CopyFile(NVM_FS_RW_BACKUP_PATH, NVM_FS_RW_MAIN_PATH);
            zOss_ASSERT(status == ZOSS_SUCCESS);

            BackUp_Symbol = NV_SYMBOL_NORMAL;
            status = Nvram_FsWrite(NVM_FS_RW_BACKUP_SYMBOL_PATH, 0, 1, &BackUp_Symbol);
            zOss_ASSERT(status == ZOSS_SUCCESS);

            printk("cpnv restore main to backup!\n");
        }
        else
        {
            /* WorkArea and Backup Area both ok */
            if(ZOSS_ERROR == Nvram_CmpFile(NVM_FS_RW_BACKUP_PATH, NVM_FS_RW_MAIN_PATH))
            {
                Factory_Symbol = NV_SYMBOL_FACTORY;
                status = Nvram_FsWrite(NVM_FS_FAC_SYMBOL_PATH, 0, 1, &Factory_Symbol);
                zOss_ASSERT(status == ZOSS_SUCCESS);

                printk("cpnv cmp wrong!, restore fac!\n");

                goto factory_check;
            }
        }
    }

	return ZOSS_SUCCESS;
}

/**************************************************************************
* ƣ Nvram_WriteRO
*  дһNV RO
* ˵ (IN)
*            part_name:   ļ
*            NvItemID:    NVƫƵַ(NVʼַƫ)
*            NvItemData:  д
*            NvItemLen:   ݳ
*            (OUT)
*   ֵ ɹZOSS_SUCCESS, 򷵻ZOSS_ERROR
* ˵ ʱãɾ
**************************************************************************/
static UINT32 Nvram_WriteRO(const CHAR *part_name, UINT32 NvItemID, UINT8 *NvItemData, UINT32 NvItemLen)
{
    UINT32  status = ZOSS_ERROR;

	status = Nvram_Remount("mtd:nvrofs", "/mnt/nvrofs", "jffs2", MS_REMOUNT |MS_VERBOSE);
	if(ZOSS_SUCCESS != status)
		return ZOSS_ERROR;
	
	status = Nvram_FsWrite(part_name, NvItemID, NvItemLen, NvItemData);
	status |= Nvram_Remount("mtd:nvrofs", "/mnt/nvrofs", "jffs2", MS_REMOUNT |MS_VERBOSE|MS_RDONLY);
		
	return status;
}

/**************************************************************************
* ƣ Nvram_Check_Data
*  鿴ͱǷЧЧָ
* ˵ 
*   ֵ ɹTRUE, 򷵻FALSE
* ˵
**************************************************************************/
static BOOL Nvram_Check_Data(VOID)
{
	if(Nvram_DirInit() != ZOSS_SUCCESS)
	{
		printk("cpnv Nvram_DirInit fail!\n");
		zOss_ASSERT(0);
	}

	 if(Nvram_RoInit() != ZOSS_SUCCESS)
	 {
		 printk("cpnv Nvram_RoInit fail!\n");
		 zOss_ASSERT(0);
	 }

	 if(Nvram_RwInit() != ZOSS_SUCCESS)
	 {
		 printk("cpnv Nvram_RwInit fail!\n");
		 zOss_ASSERT(0);
	 }

    return TRUE;
}

/**************************************************************************
* ƣ Nvram_WriteWithFlag
*  дһNV RW־
* ˵ (IN)
*            NvItemID:    NVƫƵַ(NVʼַƫ)
*            NvItemData:  д
*            NvItemLen:   ݳ
*            iNvm:   	  Ǳ
*            (OUT)
*   ֵ ɹZOSS_SUCCESS, 򷵻ZOSS_ERROR
* ˵ 
**************************************************************************/
static UINT32 Nvram_WriteWithFlag(UINT32 NvItemID, UINT8 *NvItemData, UINT32 NvItemLen, UINT8 iNvm)
{
    CHAR          	*pSymbol_File   = NULL;
	CHAR          	*pWrite_File   	= NULL;
    UINT32          Start_Addr      = 0;
    UINT8           NV_Symbol       = 0;
    UINT32          status          = ZOSS_ERROR;

    if (iNvm == NV_WORK_AREA)
    {
        pSymbol_File = NVM_FS_RW_MAIN_SYMBOL_PATH;
		pWrite_File = NVM_FS_RW_MAIN_PATH;
    }
    else if (iNvm == NV_BACKUP_AREA)
    {
        pSymbol_File = NVM_FS_RW_BACKUP_SYMBOL_PATH;
		pWrite_File = NVM_FS_RW_BACKUP_PATH;
    }
    else
        return ZOSS_ERROR;

    NV_Symbol   = NV_SYMBOL_WRITE;
	status 		= Nvram_FsWrite(pSymbol_File, 0, 1, &NV_Symbol);
    if (status != ZOSS_SUCCESS)
        return ZOSS_ERROR;
   
	status = Nvram_FsWrite(pWrite_File, NvItemID, NvItemLen, NvItemData);
    if (status != ZOSS_SUCCESS)
        return ZOSS_ERROR;

    NV_Symbol   = NV_SYMBOL_NORMAL;
	
    return Nvram_FsWrite(pSymbol_File, 0, 1, &NV_Symbol);
}

/**************************************************************************
* ƣ Nvram_FsRead
*  ļ
* ˵ (IN)ȡnv
*            part_name: ļ
*            dwStart:   NVƫƵַ(NVʼַƫ)
*            from:  	д
*            dwLen:   	ݳ
*            (OUT)
*   ֵ ɹZOSS_SUCCESS, 򷵻ZOSS_ERROR
* ˵ ʱãɾ
**************************************************************************/
static UINT32 Nvram_FsRead(const CHAR *part_name, UINT32 dwStart, UINT32 dwLen, UINT8 *to)
{
	SINT32 ret = 0;
	SINT32 fd = 0;
	mm_segment_t old_fs = get_fs();

	if((part_name == NULL) || (to == NULL))
		return ZOSS_ERROR;

	set_fs(KERNEL_DS);
	fd = CPPS_KO_FUNC(sys_open)(part_name, O_RDONLY, 0);
	if(fd < 0) 
	{
		printk("cpnv open %s fail,errno = %d\n", part_name, fd);
		set_fs(old_fs);
		return ZOSS_ERROR;
	}
	
	ret = CPPS_KO_FUNC(sys_lseek)(fd, dwStart, 0);
	if(ret < 0) 
	{
		printk("cpnv lseek %s fail,errno = %d\n", part_name, ret);
		CPPS_KO_FUNC(sys_close)(fd);
		set_fs(old_fs);
		return ZOSS_ERROR;
	}
	
	ret = CPPS_KO_FUNC(sys_read)(fd, to, dwLen);
	if(ret != dwLen) 
	{
		printk("cpnv read %s fail, len = %d, errno = %d\n", part_name, dwLen, ret);
		CPPS_KO_FUNC(sys_close)(fd);
		set_fs(old_fs);
		if ((strncmp(part_name, NVM_FS_RWO_FAC_PATH, strlen(NVM_FS_RWO_FAC_PATH)) == 0) && (dwStart > NVRWO_CONVERT_START) && ((dwStart + dwLen) <= NVRWO_CONVERT_MAX_END))
			return ZOSS_SUCCESS;
		else
			return ZOSS_ERROR;
	}

	CPPS_KO_FUNC(sys_close)(fd);
	set_fs(old_fs);
	return ZOSS_SUCCESS;
}

/**************************************************************************
* ƣ Nvram_FsWrite
*  дNVݵļ
* ˵ (IN)
*            part_name: ļ
*            dwStart:   NVƫƵַ(NVʼַƫ)
*            from:  	д
*            dwLen:   	ݳ
*            (OUT)
*   ֵ ɹZOSS_SUCCESS, 򷵻ZOSS_ERROR
* ˵ ʱãɾ
**************************************************************************/
static UINT32 Nvram_FsWrite(const CHAR *part_name, UINT32 dwStart, UINT32 dwLen, UINT8 *from)
{
	SINT32 ret = 0;
	SINT32 fd = 0;
	mm_segment_t old_fs = get_fs();;

	if(part_name == NULL || from == NULL)
		return ZOSS_ERROR;
	
	set_fs(KERNEL_DS);
	fd = CPPS_KO_FUNC(sys_open)(part_name, O_SYNC | O_RDWR | O_CREAT , 0);
	if(fd < 0) 
	{
		printk("cpnv open %s fail,errno = %d\n", part_name, fd);
		set_fs(old_fs);
		return ZOSS_ERROR;
	}
	
	ret = CPPS_KO_FUNC(sys_lseek)(fd, dwStart, 0);
	if(ret < 0) 
	{
		printk("cpnv lseek %s fail,errno = %d\n", part_name, ret);
		CPPS_KO_FUNC(sys_close)(fd);
		set_fs(old_fs);
		return ZOSS_ERROR;
	}
	
	ret = CPPS_KO_FUNC(sys_write)(fd, from, dwLen);
	if(ret != dwLen) 
	{
		printk("cpnv write %s fail,errno = %d\n", part_name, ret);
		CPPS_KO_FUNC(sys_close)(fd);
		set_fs(old_fs);
		return ZOSS_ERROR;
	}
	
	CPPS_KO_FUNC(sys_fsync)(fd);
	CPPS_KO_FUNC(sys_close)(fd);
	set_fs(old_fs);
	
    return ZOSS_SUCCESS;
}

/**************************************************************************
* ƣ Nvram_Remount
*  ¹ط
* ˵ (IN)
*            DevName:   豸
*            DirName:  	·
*            Type:   	ļ
*            Flag:   	־
*            (OUT)
*   ֵ ɹZOSS_SUCCESS, 򷵻ZOSS_ERROR
* ˵ жϼִ
**************************************************************************/
UINT32 Nvram_Remount(CHAR *DevName, CHAR *DirName, CHAR *Type, UINT32 Flag)
{
	int ret = 0;
	mm_segment_t old_fs = get_fs();

	set_fs(KERNEL_DS);
retry1:	
	ret = CPPS_KO_FUNC(sys_mount)(DevName, DirName, Type, Flag , 0);
	if(ret == EBUSY)
	{
		msleep(10);
		goto retry1;
	}
	set_fs(old_fs);
	
	if(ret < 0) 
	{
		printk("cpnv sys_mount fail,errno = %d\n", ret);
		return ZOSS_ERROR;
	}

	return ZOSS_SUCCESS;
}

/**************************************************************************
* ƣ Nvram_CopyFile
*  ȽϹͱ
* ˵ (IN)
*            pDstFile:  Ŀļ
*            pSrcFile:  Դļ
*            (OUT)
*   ֵɹZOSS_SUCCESS, 򷵻ZOSS_ERROR
* ˵
**************************************************************************/
static UINT32 Nvram_CopyFile(const CHAR *pDstFile, const CHAR *pSrcFile)
{
	UINT8 *pBuf;
	UINT32 len;
	UINT32 ret;
	
	if(pDstFile == NULL || pSrcFile == NULL)
		return ZOSS_ERROR;

	pBuf = Nvram_ReadFile(pSrcFile, &len);
	if(!pBuf)
		return ZOSS_ERROR;

	ret = Nvram_FsWrite(pDstFile, 0, len, pBuf);

	zOss_Free(pBuf);
	
    return ret;
}

/**************************************************************************
* ƣ Nvram_CmpFile
*  ȽϹͱ
* ˵ (IN)
*            pDstFile:  Ŀļ
*            pSrcFile:  Դļ
*            (OUT)
*   ֵɹZOSS_SUCCESS, 򷵻ZOSS_ERROR
* ˵
**************************************************************************/
static UINT32 Nvram_CmpFile(const CHAR *pDstFile, const CHAR *pSrcFile)
{
	UINT8 *pDst;
	UINT8 *pSrc;
	UINT32 DstLen;
	UINT32 SrcLen;

	if(pDstFile == NULL || pSrcFile == NULL)
		return ZOSS_ERROR;

	pDst = Nvram_ReadFile(pDstFile, &DstLen);
	if(!pDst)
		return ZOSS_ERROR;
	
	pSrc = Nvram_ReadFile(pSrcFile, &SrcLen);
	if(!pSrc)
	{
		zOss_Free(pDst);
		return ZOSS_ERROR;
	}
	
	if(DstLen != SrcLen)
	{
		zOss_Free(pSrc);
		zOss_Free(pDst);
		
		printk("Nvram_CmpFile Dstbuf = %d, Srcbuf = %d\n", DstLen, SrcLen);
		return ZOSS_ERROR;
	}

	if(memcmp(pSrc, pDst, SrcLen) != 0)
	{
		zOss_Free(pSrc);
		zOss_Free(pDst);
		return ZOSS_ERROR;
	}

	zOss_Free(pSrc);
	zOss_Free(pDst);
	
    return ZOSS_SUCCESS;
}

/**************************************************************************
* ƣ Nvram_ReadFile
*  ȡnvļ
* ˵ (IN)
*            pFile:  ļ
*            len:    
*            (OUT)
*   ֵɹZOSS_SUCCESS, 򷵻ZOSS_ERROR
* ˵ֵͷ
**************************************************************************/
static UINT8 *Nvram_ReadFile(const CHAR *pFile, UINT32 *len)
{
	SINT32 fd  		= 0;
	SINT32 ret 		= 0;
    struct stat buf = {0};
	UINT8 *pBuf 		= {0};

	if(pFile == NULL)
		return NULL;

	fd = CPPS_KO_FUNC(sys_open)(pFile, O_RDONLY, 0);
	if(fd < 0) 
	{
		printk("cpnv open %s fail,errno = %d\n", pFile, fd);
		return NULL;
	}
	
	ret = CPPS_KO_FUNC(sys_newfstat)(fd, &buf);
    if(0 != ret)
    {
    	printk("cpnv stat %s fail,errno = %d\n", pFile, ret);
		CPPS_KO_FUNC(sys_close)(fd);
        return NULL;
    }
	
	pBuf = zOss_Malloc(buf.st_size);
	if (pBuf == NULL)
	{
		printk("cpnv malloc fail\n");
		CPPS_KO_FUNC(sys_close)(fd);
		return NULL;
	}

	ret = CPPS_KO_FUNC(sys_read)(fd, pBuf, buf.st_size);
	if(ret != buf.st_size) 
	{
		printk("cpnv read %s fail,errno = %d\n", pFile, ret);
		CPPS_KO_FUNC(sys_close)(fd);
		zOss_Free(pBuf);
		return NULL;
	}
	CPPS_KO_FUNC(sys_close)(fd);
	*len = buf.st_size;
	
    return pBuf;
}

/**************************************************************************
* ƣ Nvram_WriteFile
*  дnvļ
* ˵ (IN)
*            pFile:  ļ
*            len:    
*            (OUT)
*   ֵɹZOSS_SUCCESS, 򷵻ZOSS_ERROR
* ˵ֵͷ
**************************************************************************/
/*
static SINT32 Nvram_WriteFile(const CHAR *pFile, UINT8 *pBuf, UINT32 len)
{
	SINT32 fd  		= 0;
	SINT32 ret 		= 0;

	fd = CPPS_KO_FUNC(sys_open)(pFile, O_SYNC | O_RDWR | O_CREAT | O_TRUNC, 0);
	if(fd < 0) 
	{
		printk("cpnv11 open %s fail,errno = %d\n", pFile, fd);
		return 0;
	}

	ret = CPPS_KO_FUNC(sys_write)(fd, pBuf, len);
	if(ret != len) 
	{
		printk("cpnv write %s fail,errno = %d\n", pFile, ret);
		CPPS_KO_FUNC(sys_close)(fd);
		return ret;
	}
	
	CPPS_KO_FUNC(sys_fsync)(fd);
	CPPS_KO_FUNC(sys_close)(fd);

    return ret;
}
*/

/**************************************************************************
* ƣ Nvram_GetRwoIndex
*  һݶƵNVʵ(ȡGPIO϶Ӧֵ)
* ˵ (IN)
*            index:  ֵ
*            (OUT)
*   ֵTRUE: ɹȡֵFALSE: ùδʹܣGPIOô
* ˵
**************************************************************************/
static BOOL Nvram_GetRwoIndex(UINT32 *index)
{
    BOOL   enable;
    UINT32 gpio_id;
    UINT32 gpio_val;
    gpio_func_id func_id;

    if (index == NULL)
        return FALSE;

    enable = zOss_GetMultiRfFlag();
    if (!enable)
        return FALSE;

    gpio_id = zOss_GetMultiRfGpio0();
    if (gpio_id > ZX29_GPIO_MAX)
    {
        printk("multi rf enable, but gpio0 set error!!!\n");
        return FALSE; //GPIOô
    }

    *index = 0;
    func_id = zx29_gpio_get_gpiofunc_id(gpio_id);
    zx29_gpio_pd_pu_set(gpio_id, IO_CFG_PULL_DISABLE);
    zx29_gpio_set_direction(gpio_id, 0);
    zx29_gpio_config(gpio_id, func_id);
    gpio_val = zx29_gpio_input_data(gpio_id);
    if (gpio_val == 1)
		*index = 1 << 0;

    gpio_id = zOss_GetMultiRfGpio1();
    if (gpio_id > ZX29_GPIO_MAX)
        return TRUE;
    func_id = zx29_gpio_get_gpiofunc_id(gpio_id);
    zx29_gpio_pd_pu_set(gpio_id, IO_CFG_PULL_DISABLE);
    zx29_gpio_set_direction(gpio_id, 0);
    zx29_gpio_config(gpio_id, func_id);
    gpio_val = zx29_gpio_input_data(gpio_id);
    if (gpio_val == 1)
		*index |= 1 << 1;

    gpio_id = zOss_GetMultiRfGpio2();
    if (gpio_id > ZX29_GPIO_MAX)
        return TRUE;
    func_id = zx29_gpio_get_gpiofunc_id(gpio_id);
    zx29_gpio_pd_pu_set(gpio_id, IO_CFG_PULL_DISABLE);
    zx29_gpio_set_direction(gpio_id, 0);
    zx29_gpio_config(gpio_id, func_id);
    gpio_val = zx29_gpio_input_data(gpio_id);
    if (gpio_val == 1)
		*index |= 1 << 2;

    return TRUE;
}

/**************************************************************************
* ƣ Nvram_RwoConvert
*  һݶƵNVʵ(NVRWOĵַת)
* ˵ (IN)
*            NvItemID:  ƫ
*            NvItemLen: 
*            (OUT)
*   ֵֵתĵַ
* ˵
**************************************************************************/
UINT32 g_NvRwoConIndex = ZOSS_ERROR;
static UINT32 Nvram_RwoConvert(UINT32 NvItemID, UINT32 NvItemLen)
{
    UINT32 i;
    UINT32 start;
    UINT32 end;

    if (g_NvRwoConIndex == ZOSS_ERROR)
    {
        if (!Nvram_GetRwoIndex(&g_NvRwoConIndex))
            return NvItemID;
        printk("multi rf enable, gpios index = %u!!!\n", g_NvRwoConIndex);
    }

    for (i = 0; i < ARRAY_SIZE(g_NvRwoConInfo); i++)
    {
        start = g_NvRwoConInfo[i].start;
        end   = g_NvRwoConInfo[i].start + g_NvRwoConInfo[i].len;

        if ((NvItemID >= start) && (NvItemID < end) && (NvItemID + NvItemLen > end))
            zOss_ASSERT(0);
        if ((NvItemID >= start) && (NvItemID < end) && (NvItemID + NvItemLen <= end))
        {
            printk("befor mod NvItemID = %u, after mod NvItemID = %u\n", NvItemID, NvItemID + g_NvRwoConInfo[i].offset + (NVRWO_CONVERT_OFFSET * g_NvRwoConIndex));
            return NvItemID + g_NvRwoConInfo[i].offset + (NVRWO_CONVERT_OFFSET * g_NvRwoConIndex);
        }
    }
	return NvItemID;
}

#ifdef __cplusplus
}
#endif

