/**************************************************************************
*
*                  Copyright (c) 2012 ZTE Corporation.
*
***************************************************************************
* ģ   : 
*    : sup_ramdump_arm.c
* ļ : ramdumparmv6armv5ϵṹcmműļ
* ʵֹ : 
*      : 
*      : 1.0
*  : 2013/10/19
* ˵ : 
**************************************************************************/

/**************************************************************************
* ޸ļ¼
**************************************************************************/
/**************************************************************************
* ޸ı : 0001
*    : ߻
* ޸ : 2012/10/10
* ޸ : ߲              
**************************************************************************/

/**************************************************************************
* #include
**************************************************************************/
#include "sup_ramdump.h"
#ifdef _OS_TOS
#include "tos_except_arm.h"
#elif defined (_OS_LINUX)
#include "linux_except_arm.h"
#endif

#ifdef __cplusplus
extern "C"
{
#endif

/**************************************************************************
* 궨
**************************************************************************/
#define ZOSS_ARM_MODE_NUM               6
#define ZOSS_BANK_REG_NUM               3
#define ZOSS_NORMAL_REG_NUM             15

#define ZOSS_EXCEPT_UNDEF_INSTRUTION    0x04 
#define ZOSS_EXCEPT_PREFETCH_ABORT      0x0C
#define ZOSS_EXCEPT_DATA_ABORT          0x10
#define ZOSS_EXCEPT_IRQ                 0x18
#define ZOSS_EXCEPT_FIQ                 0x1C

/**************************************************************************
* ݽṹ
**************************************************************************/
/**************************************************************************
*ⲿ
**************************************************************************/
#ifdef _OS_TOS
extern char *zTos_MpuDisplayCp15(char *addr);
extern char *zTos_MmuDisplayCp15(char *addr);
#elif defined (_OS_LINUX)
extern char *ramdump_mpu_cp15(char *addr);
extern char *ramdump_mmu_cp15(char *addr);
#endif

/**************************************************************************
* ֲԭ
**************************************************************************/
static CHAR *ramdump_CreateCpsrCmmFile(CHAR *address);
static CHAR *ramdump_CreateRegsitersCmmFile(CHAR *address);

/**************************************************************************
* ȫֳ/
**************************************************************************/
struct cpu_core Osa_CoreRegisters   = {0}; 
static struct cpu_regdump *g_zRadmumpRegInfo        = NULL;
static UINT8 g_zRamdump_ArmMode[ZOSS_ARM_MODE_NUM]  =   /* ˳struc coreе˳һ£ܸ */
{
    0xdf,   /* SYS */
    0xd3,   /* SVC */
    0xd7,   /* ABT */
    0xdb,   /* UND */
    0xd2,   /* IRQ */
    0xd1,   /* FIQ */
}; 
static CHAR *g_zRamdumpBankReg[ZOSS_BANK_REG_NUM]   = {(CHAR *)"r13", (CHAR *)"r14", (CHAR *)"spsr"};

/**************************************************************************
* ֲʵ
**************************************************************************/

/**************************************************************************
 * ƣramdump_CreateCpsrCmmFile
 * cpsrű
 * ˵(IN):
 *                cmmAddress : űĵַָ룻
 *           (OUT):
 *   ֵ   
 * ˵ ؽűַ
**************************************************************************/
static CHAR *ramdump_CreateCpsrCmmFile(CHAR *cmmAddress)
{
    UINT32  value       = 0;
    
    /* cpsr */
    if(g_zRadmumpRegInfo != NULL)
    {
        switch(g_zRadmumpRegInfo->vector)
        {
        case ZOSS_EXCEPT_UNDEF_INSTRUTION:  /* undefined instruction */
            {
                value = Osa_CoreRegisters.undefined.psr;
                break;
            }
        case ZOSS_EXCEPT_PREFETCH_ABORT:    /* prefetch abort */
            {
                value = Osa_CoreRegisters.abort.psr;
                break;
            }
        case ZOSS_EXCEPT_DATA_ABORT:        /* data abort */
            {
                value = Osa_CoreRegisters.abort.psr;
                break;
            }
        case ZOSS_EXCEPT_IRQ:               /* IRQ */
            {
                value = Osa_CoreRegisters.irq.psr;
                break;
            }
        case ZOSS_EXCEPT_FIQ:               /* FIQ */
            {
                value = Osa_CoreRegisters.fiq.psr;
                break;
            }
        default:
            {
                break;
            }
        }
    }
    else
    {
        value =zOss_ReadCpsr();
    }
    
    return cmmAddress += (UINT32)sprintf(cmmAddress, "r.s cpsr %#lx\r\n", value);
}

/**************************************************************************
 * ƣramdump_CreateRegsitersCmmFile
 * cpsrű
 * ˵(IN):
 *                  cmmAddress: űĵַָ룻
 *           (OUT):
 *   ֵؽűַ   
 * ˵ 
**************************************************************************/
static CHAR *ramdump_CreateRegsitersCmmFile(CHAR *cmmAddress)
{
    UINT32  value       = 0;
    UINT32  *paddress   = NULL; 
    UINT32  i           = 0;
    UINT32  j           = 0;

    zOss_ASSERT(cmmAddress != NULL);
    if(g_zRadmumpRegInfo != NULL)
    {
        value = g_zRadmumpRegInfo->pc;
    }
    else
    {
        value = Osa_CoreRegisters.supervisor.lr;
    }
    cmmAddress += sprintf(cmmAddress, "r.s pc %#lx\r\n", value);
    
    /* лsvcģʽԭr0-r12 */
    cmmAddress += sprintf(cmmAddress, "r.s cpsr %#lx\r\n", (UINT32)g_zRamdump_ArmMode[0]);

    for(i = 0; i < ZOSS_NORMAL_REG_NUM-2; i++)
    {
        cmmAddress += sprintf(cmmAddress, "r.s r%d %#lx\r\n",(int)i, Osa_CoreRegisters.r[i]);
    }
    paddress = (UINT32 *)(&Osa_CoreRegisters.user.sp);
    /* fiq֮ģʽݼĴ */
    for(i = 0; i < ZOSS_ARM_MODE_NUM-1; i++)
    {
        cmmAddress += sprintf(cmmAddress, "r.s cpsr %#lx\r\n", (UINT32)g_zRamdump_ArmMode[i]);
        for(j = 0; j < ZOSS_BANK_REG_NUM; j++)
        {
            cmmAddress += sprintf(cmmAddress, "r.s %s %#lx\r\n", g_zRamdumpBankReg[j], *paddress);
            paddress++; 
        }
    }  
    /* FIQ r8-r14 */
    cmmAddress += sprintf(cmmAddress, "r.s cpsr %#lx\r\n", (UINT32)g_zRamdump_ArmMode[5]);
    for(i = 8; i < ZOSS_NORMAL_REG_NUM; i++)
    {
        cmmAddress += sprintf(cmmAddress, "r.s r%d %#lx\r\n", (int)i, *paddress);
        paddress++;
    }
    /* FIQ spsr */
    cmmAddress += sprintf(cmmAddress, "r.s spsr %#lx\r\n", *paddress);
    /* cpsrű */
    return  ramdump_CreateCpsrCmmFile(cmmAddress);
}

/**************************************************************************
* ȫֺʵ
**************************************************************************/

/*******************************************************************************
 * ƣ zOss_RamdumpCreateCmmFile
 *  ɻָջT32ű
 * ˵ (IN):
 *                  pCmmFileInfo: űļϢָ룻
 *            (OUT):
 *   ֵ
 * ˵
 ******************************************************************************/
VOID zOss_RamdumpCreateCmmFile(T_zOss_RamdumpCmmFileInfo  *pCmmFileInfo)
{
    CHAR    *cmmAddress = NULL;
   
    cmmAddress  =  pCmmFileInfo->cmmFileBuffer; 
    cmmAddress  += sprintf(cmmAddress, "ENTRY &%s\r\n", ZOSS_RAMDUMP_DIR_NAME);
    /*Ĵű */
    cmmAddress  =  ramdump_CreateRegsitersCmmFile(cmmAddress);
    /* ֹMMUMPU */   
    cmmAddress  += sprintf(cmmAddress, "per.s c15:0x1 %%long %#lx\r\n", (zOss_Cp15ReadControlRegister() & 0xfffffffe));  
    /* region ű */
    cmmAddress  =  zOss_RamdumpCreateRegionsCmmFile(cmmAddress);
    /* cp15 c1 ƼĴ */
    cmmAddress  += sprintf(cmmAddress, "per.s c15:0x1 %%long %#lx\r\n", zOss_Cp15ReadControlRegister());

#ifdef _OS_TOS
# ifdef CYGOPT_HAL_ARM_MMU
    /* mmuصļĴ */
    cmmAddress = zTos_MmuDisplayCp15(cmmAddress);
# endif

# ifdef CYGOPT_HAL_ARM_MPU
    /* mpuصļĴ */
    cmmAddress = zTos_MpuDisplayCp15(cmmAddress);
# endif
#elif defined (_OS_LINUX)
# ifdef CONFIG_MMU
    /* mmuصļĴ */
    cmmAddress = ramdump_mmu_cp15(cmmAddress);
# else
    /* mpuصļĴ */
    cmmAddress = ramdump_mpu_cp15(cmmAddress);
# endif
#endif
    
    /*  */
    cmmAddress  += sprintf(cmmAddress, "ENDDO\r\n");
    
    pCmmFileInfo->cmmFileSize = (UINT32)(cmmAddress - pCmmFileInfo->cmmFileBuffer);
    zOss_AssertExN(pCmmFileInfo->cmmFileSize <= pCmmFileInfo->cmmFileMaxSize);
}

#ifdef __cplusplus
}
#endif

