/*******************************************************************************
*
*                  Copyright (c) 2012 ZTE Corporation.
*
********************************************************************************
* ģ   : 
*    : sup_ramdump_m0_adapt.c
* ļ : sup_ramdump_m0_adapt.c
* ʵֹ : ʵm0汾ȱٵc⺯
*      : ߻
*      : 1.0
*  : 2013/10/17 
* ˵ : 
*******************************************************************************/

/*******************************************************************************
* ޸ļ¼
*******************************************************************************/

/*******************************************************************************
* #include
*******************************************************************************/
#include <stdarg.h>
#include "oss_api.h"
#include "sup_ramdump.h"

#ifdef __cplusplus
extern "C"
{
#endif

/*******************************************************************************
* 궨
*******************************************************************************/
#define ZOSS_VSNFORMAT_BUFF_SIZE        100
#define ZOSS_VSNFORMAT_TOCHAR(n)        ((n) + '0')
#define ZOSS_VSNFORMAT__DECIMAL         10
#define ZOSS_VSNFORMAT_HEX              16
#define ZOSS_VSNFORMAT_HEXPREFIX_LEN    2
#define ZOSS_VSNFORMAT_LONG             0X0
#define ZOSS_VSNFORMAT_PREFIX           0X1
#define ZOSS_VSNFORMAT_HEXPREFIX        0X4
#define ZOSS_INT_MAX                    0xFF

/*******************************************************************************
* ݽṹ
*******************************************************************************/
/* ʽֵ */
typedef enum
{
    FORMAT_TYPE_CONTINUE,
    FORMAT_TYPE_PUTFMTSTR,
    FORMAT_TYPE_INTVALUE,
    FORMAT_TYPE_ERROR,
    FORMAT_TYPE_MAX    
}T_zOss_FormatTypeRet;

/*******************************************************************************
* ֲԭ
*******************************************************************************/
static SINT32 vsnformat(CHAR *pcBuffer, UINT32 dwMaxCount, const CHAR *pcParamFormat, va_list vaList);
static SINT32 getVareIntValue(UINT32 *pFormatType, SINT32 swBase, va_list *vaList);
static CHAR   *translateNumberToStr(CHAR *pAcBuf, SINT32 dwVal, SINT32 swBase, SINT32 *sdwSize);
static CHAR   *getStrLen(va_list *vaList, SINT32 *pSdwSize);
static T_zOss_FormatTypeRet  getFormatType(SINT32 swCh, UINT32 *pFormatType, SINT32 *pSwBase);

/*******************************************************************************
* ȫֳ/
*******************************************************************************/
static  CHAR BIG_HEX_DIGIT[]    = "0123456789ABCDEF";
static  CHAR NULLSTRING[]       = "(null)";

/*******************************************************************************
* ֲʵ
*******************************************************************************/

/*******************************************************************************
 * ƣ getVareIntValue
 *  ȡεֵ
 * ˵ (IN):
 *              pFormatType: ʽͣ
 *            (OUT):
 *              swBase: ʽ
 *              vaList: ɱ
 *   ֵ رеֵ
 * ˵
 ******************************************************************************/
static SINT32 getVareIntValue(UINT32 *pFormatType, SINT32 swBase, va_list *vaList)
{
    SINT32 dwVal    = 0;
    
    if (*pFormatType & (1 << ZOSS_VSNFORMAT_LONG))
    {
        dwVal = va_arg(*vaList, unsigned long);
    }
    else
    {
        dwVal = va_arg(*vaList, unsigned int);
    }

    if ((*pFormatType & (1 << ZOSS_VSNFORMAT_PREFIX)) && (ZOSS_VSNFORMAT_HEX == swBase) && (0 != dwVal))
    {
        *pFormatType = *pFormatType | (1<< ZOSS_VSNFORMAT_HEXPREFIX);
    }
    
    return dwVal;    
}

/*******************************************************************************
 * ƣ translateNumberToStr
 *  תΪַ
 * ˵ (IN):
 *              pAcBuf: ָ룻
 *              dwVal: ֵ
 *              swBase: ʽ
 *            (OUT):
 *              sdwSize: תֵĴС
 *   ֵ ֵŵĵַ
 * ˵
 ******************************************************************************/
static CHAR *translateNumberToStr(CHAR *pAcBuf, SINT32 dwVal, SINT32 swBase, SINT32 *sdwSize)
{
    CHAR *pch = pAcBuf + ZOSS_VSNFORMAT_BUFF_SIZE;
    
    switch (swBase)
    {
    case ZOSS_VSNFORMAT__DECIMAL:                      /* 10 */
        {
            while (dwVal >= ZOSS_VSNFORMAT__DECIMAL)
            {
                *--pch = (CHAR)ZOSS_VSNFORMAT_TOCHAR(dwVal % ZOSS_VSNFORMAT__DECIMAL);
                dwVal /= ZOSS_VSNFORMAT__DECIMAL;
            }
            *--pch = (CHAR)ZOSS_VSNFORMAT_TOCHAR(dwVal);
            break;
        }
    case ZOSS_VSNFORMAT_HEX:                            /* 16 */
        {
            do
            {
                *--pch = BIG_HEX_DIGIT[dwVal & 15];
                dwVal >>= 4;
            }
            while (dwVal);
            break;
        }       
    default:
        break;
    }
    *sdwSize = pAcBuf + ZOSS_VSNFORMAT_BUFF_SIZE - pch;
    return pch;
}

/*******************************************************************************
 * ƣ getStrLen
 *  ȡɱַĳȣ
 * ˵ (IN):
 *              vaList: ɱ
 *              pSdwSize: ɱĳȣ
 *            (OUT):
 *   ֵ %ַλã
 * ˵
 ******************************************************************************/
CHAR *getStrLen(va_list *vaList, SINT32 *pSdwSize)
{
    CHAR *pch  = (CHAR *)va_arg(*vaList, CHAR *);
    
    if (pch == NULL)
    {
        pch = NULLSTRING;
    }
    *pSdwSize = (SINT32)strlen((char *)pch);
    return pch;
}

/*******************************************************************************
 * ƣ getFormatType
 *  תΪַ
 * ˵ (IN):
 *              swCh: ʽַ
 *            (OUT):
 *              pFormatType: ʽͣ
 *              pSwBase: ݵʽ
 *   ֵ ʽķֵͣ
 * ˵
 ******************************************************************************/
static T_zOss_FormatTypeRet getFormatType(SINT32 swCh, UINT32 *pFormatType, SINT32 *pSwBase)
{
    T_zOss_FormatTypeRet retType = FORMAT_TYPE_MAX;
    
    switch (swCh)
    {
    case '#':
        {
            *pFormatType = *pFormatType | (1 << ZOSS_VSNFORMAT_PREFIX);
            retType = FORMAT_TYPE_CONTINUE;
            break;
        }
    case 'l': 
        {
            *pFormatType = *pFormatType | (1 << ZOSS_VSNFORMAT_LONG);
            retType = FORMAT_TYPE_CONTINUE;
            break;
        }
    case 's':
        {
            retType = FORMAT_TYPE_PUTFMTSTR;
            break;
        }
    case 'X':
    case 'x':
        {
            *pSwBase    = ZOSS_VSNFORMAT_HEX;
            retType     = FORMAT_TYPE_INTVALUE;
        }
        break;
    case 'd':
    case 'i':
        {
            *pSwBase = ZOSS_VSNFORMAT__DECIMAL;
            retType = FORMAT_TYPE_INTVALUE;
            break;
        }
    default:
        {
            break;
        }
    }
    return retType;
}

/*******************************************************************************
 * ƣ vsnformat
 *  ʽַ
 * ˵ (IN):
 *                  dwMaxCountСNULL
 *                  format    Ҫʹõĸʽ
 *                  vaList    ɱб
 *            (OUT):
 *                   pcBuffer  
 *   ֵ -1  ʵҪֽС,ʵֽ
 * ˵ ΪM0汾ƶĹܣֺ֧ܶvsnformatܣ
 ******************************************************************************/
static SINT32 vsnformat(CHAR *pcBuffer, UINT32 dwMaxCount, const CHAR *pcParamFormat, va_list vaList)
{
    SINT16      swCh;                                           /* ȡpcParamFormatַ */
    CHAR        *pch;                                           /* ַָ */
    SINT32      dwVal;                                          /*  %[diouxX] */
    SINT32      sdwSize;                                        /* Ҫĳ */
    SINT32      sdwRealSize;                                    /* ʵ */
    CHAR        acBuf[ZOSS_VSNFORMAT_BUFF_SIZE];                /* Ļ */
    SINT32      sdwRet              = 0;                        /*  */
    SINT32      swBase              = ZOSS_VSNFORMAT__DECIMAL;  /* βĽ */
    SINT32      dwCount             = 0;                        /* ͳǰֽ */
    CHAR        *pcOut              = pcBuffer;                 /* ָ */
    UINT32      formatType          = 0;
    T_zOss_FormatTypeRet retFmtType = FORMAT_TYPE_MAX;

    zOss_ASSERT((NULL != pcBuffer) || (NULL != pcParamFormat));
    for (;;)                                        /* ɨʽе%ַ */
    {
        for (pch = (CHAR *)pcParamFormat; ((swCh = *pcParamFormat) != '\0') && (swCh != '%');
                  pcParamFormat++) ;                /* %ַ */     

        /* %ǰַ */ 
        dwCount += pcParamFormat - pch;
        memcpy(pcOut, pch, (UINT32)(pcParamFormat - pch));
        pcOut +=  pcParamFormat - pch;
        sdwRet +=  pcParamFormat - pch;
        if ('\0' == swCh)
        {
            *pcOut = '\0';                          /* NULL */
            return sdwRet;
        }
        pcParamFormat++;                            /*  '%' */
        /* ѭǰ%ʽ */   
        for (;;)
        {
            swCh = *pcParamFormat++;
            retFmtType = getFormatType(swCh,&formatType,&swBase);
            if ((retFmtType == FORMAT_TYPE_INTVALUE) || (retFmtType == FORMAT_TYPE_PUTFMTSTR))
            {
                break;
            }
        }
        if ((retFmtType == FORMAT_TYPE_INTVALUE))   /* ȡеͲ */    
        {
            dwVal   = getVareIntValue(&formatType, swBase, &vaList);
            pch     = translateNumberToStr(acBuf, dwVal, swBase, &sdwSize);
        }
        if (retFmtType == FORMAT_TYPE_PUTFMTSTR)
            pch = getStrLen(&vaList, &sdwSize);
        sdwRealSize = sdwSize;
        if ( formatType & (1 << ZOSS_VSNFORMAT_HEXPREFIX))
        {
            sdwRealSize += ZOSS_VSNFORMAT_HEXPREFIX_LEN;
            dwCount     += ZOSS_VSNFORMAT_HEXPREFIX_LEN;
            *pcOut++    = '0';
            *pcOut++    = (CHAR)swCh;
        }
        /* ʵʵĸʽ */
        dwCount += (UINT32)sdwSize;
        zOss_ASSERT(dwCount < dwMaxCount);
        memcpy(pcOut, pch, (UINT32)sdwSize);
        pcOut += sdwSize;
        sdwRet += sdwRealSize;
    }
}

/*******************************************************************************
* ȫֺʵ
*******************************************************************************/

/*******************************************************************************
 * ƣ sprintf
 *  ʵcsprintfܣ
 * ˵ (IN):
 *              s:      ָ룻
 *              format: ʽַ
 *              ...   : ʽݣ
 *            (OUT):
 *   ֵ
 * ˵ Ϊm0汾ƣ
 ******************************************************************************/
int sprintf(char *s, const char *format, ...)
{
    int rc;      
    va_list ap;  

    va_start(ap, format); 
    rc = vsnformat(s, ZOSS_INT_MAX, format, ap);
    va_end(ap); 

    return rc;
} 

/*******************************************************************************
 * ƣ memcpy
 *  ʵcmemcpyܣ
 * ˵ (IN):
 *              pDst: Ŀַ
 *              pSrc: Դַ
 *              n   : ȣ
 *            (OUT):
 *   ֵ ĿַpDst
 * ˵
 ******************************************************************************/
void *memcpy(void *pDst, const void *pSrc, size_t n)
{
    char *pTmpDst = (char *)pDst;
    const char *pTmpSrc = (const char *)pSrc;
    
    while (n--)
    {
        *pTmpDst++ = *pTmpSrc++;
    } 
    return pDst;
}

/*******************************************************************************
 * ƣ memchr
 *  ʵcmemcpyܣ
 * ˵ (IN):
 *              pStr: Ŀַָ룻
 *              c   : ַ
 *              n   : ȣ
 *            (OUT):
 *   ֵ ҵַĵַ
 * ˵
 ******************************************************************************/
void *memchr(const void *pStr, int c, size_t n)
{
    const unsigned char *pTmpStr = (const unsigned char *)pStr;   
    
    c &= 0xff;
    while (n--)
    {
        if (*pTmpStr == c)
        {
            return (void *)pTmpStr;
        }
        pTmpStr++;
    }
    return NULL;
}

/*******************************************************************************
 * ƣ memset
 *  ʵcmemsetܣ
 * ˵ (IN):
 *              pStr: bufferָ룻
 *              c   : ţ
 *              n   : ַĳȣ
 *            (OUT):
 *   ֵ pStrָ룻
 * ˵
 ******************************************************************************/
void *memset(void *pStr, int c, size_t n)
{
    char *pTmpStr = (char *)pStr;
    
    while (n-- != 0)
    {
        *pTmpStr++ = (char)c;
    }
    return pStr;
}

#ifdef __cplusplus
}
#endif

