/**************************************************************************
*
*                  Copyright (c) 2012 ZTE Corporation.
*
***************************************************************************
* ģ   : 
*    : sup_ramdump_server.c
* ļ : 
* ʵֹ : 
*      : 
*      : 1.0
*  : 2013/07/19
* ˵ : 
**************************************************************************/

/**************************************************************************
* ޸ļ¼
**************************************************************************/
/**************************************************************************
* #include
**************************************************************************/
#include "sup_ramdump.h"
#include "sys_func_atcfg.h"
#include "sys_com.h"
#include "drvs_usbPoll.h"
#include "ram_config.h"
#include "drvs_icp.h"

#if defined (_USE_ARM1_RAMDUMP) || defined (_USE_ZSP_RAMDUMP)
#include "ps_ephy_interface.h"
#include "drv_api.h"
#endif

#ifdef _OS_TOS
#include <cyg/hal/tos_cache.h>
#include <cyg/hal/tos_arm_mmu.h>
#endif

#ifdef __cplusplus
extern "C"
{
#endif

/**************************************************************************
* ⲿͱ
**************************************************************************/
#ifdef __GNUC__
# ifdef _OS_LINUX
#define _ramdump_size 0x6000
char _ramdump_array[_ramdump_size];
#define _ramdump_start (_ramdump_array)
# else
extern char _ramdump_start[];
extern char _ramdump_size[];
# endif
#elif defined (__ARMCC_VERSION)
extern  char Image$$RAMDUMP$$ZI$$Base[];    
extern  char Image$$RAMDUMP$$ZI$$Limit[];   

#define _ramdump_start  Image$$RAMDUMP$$ZI$$Base                              
#define _ramdump_size   (Image$$RAMDUMP$$ZI$$Limit - Image$$RAMDUMP$$ZI$$Base)
#endif

extern SINT32 zDrvIcp_ClearState(T_HalIcp_MsgActor actor, T_HalIcp_Dword bit_map);

/**************************************************************************
* ȫֳ/
**************************************************************************/
T_zOss_RamdumpOpt           g_zRamdump_Optfunc       = {NULL,NULL};
T_zOss_RamdumpServerInfo    g_zRamdump_ServerInfo    = {0};

#define ZRAMDUMP_SERVER_FILE    "sup_ramdump_server.con"
#define ZRAMDUMP_CLIENT_ICP_TABLE(srcModId,desModId,low_word,high_word)
#define ZRAMDUMP_AGENT_ICP_TABLE(srcModId,desModId,low_word,high_word)
#define ZRAMDUMP_SERVER_MEM_TABLE(identifier,pRamdumpStartAddr,ramdumpSize)
#undef  ZRAMDUMP_CLIENT_ICP_TABLE
#define ZRAMDUMP_CLIENT_ICP_TABLE(srcModId,desModId,low_word,high_word)                  \
                      {(srcModId),(desModId),{low_word,high_word}},
T_zOss_RamdumpIcpInfo g_zRamdump_ClientIcpInfo[] = 
{
    #include ZRAMDUMP_SERVER_FILE
};

#undef  ZRAMDUMP_CLIENT_ICP_TABLE
#define ZRAMDUMP_CLIENT_ICP_TABLE(srcModId,desModId,low_word,high_word)
#undef  ZRAMDUMP_AGENT_ICP_TABLE
#define ZRAMDUMP_AGENT_ICP_TABLE(srcModId,desModId,low_word,high_word)                   \
                      {(srcModId),(desModId),{low_word,high_word}},
static T_zOss_RamdumpIcpInfo   s_zRamdump_AgentIcpInfo[] = 
{
    #include ZRAMDUMP_SERVER_FILE
};

#undef  ZRAMDUMP_AGENT_ICP_TABLE
#define ZRAMDUMP_AGENT_ICP_TABLE(srcModId,desModId,low_word,high_word)
#undef  ZRAMDUMP_SERVER_MEM_TABLE
#define ZRAMDUMP_SERVER_MEM_TABLE(identifier,pRamdumpStartAddr,ramdumpSize)     \
                              (UINT32)(identifier), (CHAR*)(pRamdumpStartAddr), \
                              (UINT32)(ramdumpSize)
static T_zOss_RamdumpServerConInfo  s_zRamdump_ServerCfgInfo = 
{
    #include ZRAMDUMP_SERVER_FILE
};
#undef  ZRAMDUMP_SERVER_MEM_TABLE
#define ZRAMDUMP_SERVER_MEM_TABLE(identifier,pRamdumpStartAddr,ramdumpSize)
static T_zOss_RamdumpClientInfo **s_zRamdump_ClientInfo = NULL;
static T_zOss_RamdumpExceptInfo s_zRamdump_ExceptCore   = {FALSE, 0};
static BOOL                     s_zRamdump_InitFlag     = FALSE;
#ifdef _USE_ARM1_RAMDUMP
static BOOL                     s_zRamdump_Arm1WaitFlag = FALSE;
#endif

static T_zOss_RamdumpIoOpt  g_zRamdumpIoOpt;

/**************************************************************************
* 궨
**************************************************************************/
/* io read/write buffer: [msg][data] */
#define ZOSS_RAMDUMP_IO_DATA_BASE(addr)         ((UINT32)addr + 4)
#define ZOSS_RAMDUMP_ICP_CLIENT_SIZE            0X24
#define ZOSS_RAMDUMP_ICP_AGENT_SIZE             0X24
#define ZOSS_RAMDUMP_DELAYTIME_CNT              2500   

#ifdef _USE_ARM1_RAMDUMP
#define ZOSS_RAMDUNP_PHY_INFO_BASE              0x24A60000
#define ZOSS_RAMDUMP_PHY_COREDID                0XFF
#define ZOSS_RAMDUMP_FLAG_ARM02ARM1_SIZE        4
#define ZOSS_RAMDUMP_FLAG_ARM12ARM0_SIZE        4
#define ZOSS_RAMDUMP_CMM_BUFFER_SIZE            4096
#define ZOSS_RAMDUMP_CFG_REGIONS_SIZE           4096
#define ZOSS_RAMDUMP_PARSED_REGIONS_SIZE        4096
#define ZOSS_RAMDUMP_FILE_SIZE                  2048
#define ZOSS_RAMDUMP_ERROR_FILE_SIZE            1024
#define ZOSS_RAMDUMP_ARM1_NAME                  "arm1_memory.bin"
#define ZOSS_RAMDUMP_ARM1_CMM_INFO_BASE         0x24A60000
#define ZOSS_RAMDUMP_CFG_REGION_BASE            (ZOSS_RAMDUMP_ARM1_CMM_INFO_BASE + ZOSS_RAMDUMP_CMM_BUFFER_SIZE)
#define ZOSS_RAMDUMP_ARM1_PARSED_REGION_BASE    (ZOSS_RAMDUMP_CFG_REGION_BASE + ZOSS_RAMDUMP_CFG_REGIONS_SIZE)
#define ZOSS_RADMUMP_ARM1_ERROR_FILE_BASE       (ZOSS_RAMDUMP_ARM1_PARSED_REGION_BASE + ZOSS_RAMDUMP_PARSED_REGIONS_SIZE)
#define ZOSS_RAMDUMP_ARM1_FLAG_ARM02ARM1_BASE   (ZOSS_RADMUMP_ARM1_ERROR_FILE_BASE + ZOSS_RAMDUMP_ERROR_FILE_SIZE)
#define ZOSS_RAMDUMP_ARM1_FLAG_ARM12ARM0_BASE   (ZOSS_RAMDUMP_ARM1_FLAG_ARM02ARM1_BASE + ZOSS_RAMDUMP_FLAG_ARM02ARM1_SIZE)
#define ZOSS_RAMDUMP_CMM_FILE_BUF_SIZE(addr)    (*(UINT32 *)addr)
#define ZOSS_RAMDUMP_CMM_FILE_BUF_BASE(addr)    ((UINT32)addr + 4)
#endif

/**************************************************************************
* ݽṹ
**************************************************************************/

/**************************************************************************
* ֲԭ
**************************************************************************/
static VOID ramdump_TransferData(VOID);
static VOID ramdump_GetAvailableRegion(T_zOss_RamdumpRegion *pCfgInfo, T_zOss_RamdumpRegionInfo *pParsedInfo);
static VOID ramdump_ParseRegionInfo(T_zOss_RamdumpRegionInfo *pCfgInfo, T_zOss_RamdumpRegionInfo *pParsedInfo);
static VOID ramdump_SaveFileInfo(const CHAR *name, UINT32 baseServer, UINT32 size);
static VOID ramdump_SaveRegionFileInfo(T_zOss_RamdumpRegionInfo *pRegionInfo, const CHAR *pFileName);
static VOID ramdump_SaveAgentFileInfo(const CHAR *name, UINT32 baseServer, UINT32 size );
static VOID ramdump_SaveAllFilesInfo(VOID);
static VOID ramdump_Main(VOID);
#if defined (_OS_TOS) && defined (CYGOPT_HAL_ARM_MMU)
static VOID ramdump_GetConfigRegion(VOID);
#endif
static VOID ramdump_SetPartition(VOID);
static VOID except_RecordExceptInfo(UINT32 exceptCoreID);
static BOOL ramdump_delay(UINT32 ms, volatile UINT32 *addr, UINT32 flag);

/**************************************************************************
* ֲʵ
**************************************************************************/

#ifdef _USE_ARM1_RAMDUMP
/**************************************************************************
 * ƣramdump_CheckArm1InitFinish
 * жarm1ʼǷʼɣ
 * ˵(IN):
 *           (OUT):
 *   ֵ   
 * ˵ 
**************************************************************************/
static BOOL ramdump_CheckArm1InitFinish(VOID)
{
    return (*(volatile UINT32 *)ZOSS_RAMDUMP_ARM1_FLAG_ARM12ARM0_BASE == 0);
}

/**************************************************************************
 * ƣramdump_ProcessMsgFromArm1
 * server arm1ICPϢ
 * ˵(IN):
 *           (OUT):
 *   ֵ   
 * ˵ 
**************************************************************************/
static VOID ramdump_ProcessMsgFromArm1(const T_HalIcp_Msg *pMsg)
{
    T_HalIcp_Dword state = { 0 };
   
    zDrvIcp_GetState(ICP_MSG_ACTOR_ARM, &state);
    zDrvIcp_ClearState(ICP_MSG_ACTOR_ARM, state);
    except_RecordExceptInfo(ZOSS_RAMDUMP_PHY_COREDID);
    sprintf((char *)g_zRamdump_ServerInfo.pErrInfo->pBuff, "%d_s_core: force error!\n", (int)s_zRamdump_ServerCfgInfo.serverId);
#ifdef _OS_LINUX
    linux_ramdump_entry();
#else
    zOss_RamdumpHandle(1, 1, 1);
#endif
}

/**************************************************************************
 * ƣramdump_Arm1Init
 * arm1ʼ
 * ˵(IN):
 *           (OUT):
 *   ֵ   
 * ˵ 
**************************************************************************/
static VOID ramdump_Arm1Init(VOID)
{
    *(volatile UINT32 *)ZOSS_RAMDUMP_ARM1_FLAG_ARM02ARM1_BASE = 0;
#ifdef _OS_TOS
    TOS_CACHE_CLEAN_ALL();
#endif
    zDrvIcp_RegCallback(ICP_ARM0_MODULE_ID_OS, ICP_ARM1_MODULE_ID_OS, ramdump_ProcessMsgFromArm1, ICP_ISR_CALLBACK); 
}

/**************************************************************************
 * ƣramdump_SendMsgToArm1
 * arm1ICPϢ
 * ˵(IN):
 *           (OUT):
 *   ֵ   
 * ˵ 
**************************************************************************/
static VOID ramdump_SendMsgToArm1(UINT32 exceptType)
{
    T_HalIcp_Msg icpMsg = { 0 };
   
    icpMsg.SrcModId          = ICP_ARM0_MODULE_ID_OS;
    icpMsg.desModId          = ICP_ARM1_MODULE_ID_OS;
    icpMsg.len               = exceptType;
    icpMsg.IntInfo.high_word = ZPLAT_PS2PHY_RAMDUMP_INT_ICP_CF;
    zDrvIcp_SendMsg( (const T_HalIcp_Msg *)&icpMsg );
}

/**************************************************************************
 * ƣramdump_GetArm1AvailableRegion
 * ĬõڴMMUڴݶԱȣ
             ɵڴ
 * ˵(IN): 
 *              pCfgInfo:    õĵַϢָ룻
 *              pParsedInfo: ĵַϢָ룻
 *           (OUT):
 *   ֵ   
 * ˵ 
**************************************************************************/
static VOID ramdump_GetArm1AvailableRegion(T_zOss_RamdumpArm1Region *pCfgInfo, T_zOss_RadmumpArm1RegionInfo *pParsedInfo)
{
    UINT32                   i             = 0;
    T_zTos_MmuRamdumpTable   mmuTable      = { 0 };
    T_zOss_RamdumpArm1Region *pParseRegion = &(pParsedInfo->regions[0]);
    
    if (zTos_MmuGetMappingRegion(pCfgInfo->startAddr, (pCfgInfo->endAddr - pCfgInfo->startAddr + 1), &mmuTable))
    {
        for (i= 0; i < mmuTable.count; i++, pParsedInfo->regionNum++)
        {
            pParseRegion[pParsedInfo->regionNum].startAddr = mmuTable.item[i].virBase;
            pParseRegion[pParsedInfo->regionNum].mapAddr   = pCfgInfo->startAddr != pCfgInfo->mapAddr ?
                                                             (pCfgInfo->mapAddr + mmuTable.item[i].phyBase - pCfgInfo->startAddr) : mmuTable.item[i].virBase;
            pParseRegion[pParsedInfo->regionNum].copyAddr  = pCfgInfo->copyAddr != 0 ? (pCfgInfo->copyAddr + mmuTable.item[i].phyBase - pCfgInfo->startAddr) : 0;
            pParseRegion[pParsedInfo->regionNum].endAddr   = mmuTable.item[i].virBase + mmuTable.item[i].size - 1;  
        }
    } 
}

/**************************************************************************
 * ƣramdump_ParseArm1RegionInfo
 * ڴļ
 * ˵(IN): 
 *              pCfgInfo:    Ϣָ룻
 *              pParsedInfo: Ϣָ룻
 *           (OUT):
 *   ֵ   
 * ˵ 
**************************************************************************/
static VOID ramdump_ParseArm1RegionInfo(T_zOss_RadmumpArm1RegionInfo *pCfgInfo, T_zOss_RadmumpArm1RegionInfo *pParsedInfo)
{   
    UINT32  i = 0;

    for (i = 0; i < pCfgInfo->regionNum; i++)
    {
        ramdump_GetArm1AvailableRegion(&(pCfgInfo->regions[i]), pParsedInfo);
    }
}

/**************************************************************************
 * ƣramdump_SaveArm1RegionFileInfo
 * arm1 RegionļϢ
 * ˵(IN):
 *              pRegionInfo: ݶεָ룻
 *              pFileName  : ļ֣
 *           (OUT):
 *   ֵ   
 * ˵ 
**************************************************************************/
static VOID ramdump_SaveArm1RegionFileInfo(T_zOss_RadmumpArm1RegionInfo *pRegionInfo, const CHAR *pFileName)
{
    UINT32               i                               = 0;
    CHAR                 name[ZOSS_RAMDUMP_FILENAME_LEN] = {0};
    T_zOss_RamdumpRegion serverRegion                    = { 0 };
   
    for (i = 0; i < pRegionInfo->regionNum; i++)
    {
        serverRegion.baseForServer = pRegionInfo->regions[i].startAddr;
        serverRegion.baseForSelf   = pRegionInfo->regions[i].mapAddr;
        serverRegion.baseForCopy   = pRegionInfo->regions[i].copyAddr;
        serverRegion.size          = pRegionInfo->regions[i].endAddr - pRegionInfo->regions[i].startAddr + 1;
        sprintf(name, "%s_%d", pFileName, (int)i);
        ramdump_SaveFileInfo(name, serverRegion.baseForServer, serverRegion.size);
        ramdump_SaveAgentFileInfo(name, serverRegion.baseForServer, serverRegion.size);
    }
}

/**************************************************************************
 * ƣramdump_SaveArm1FilesInfo
 * arm1 ļϢ
 * ˵(IN):
 *           (OUT):
 *   ֵ   
 * ˵ 
**************************************************************************/
static VOID ramdump_SaveArm1FilesInfo(VOID)
{
    if (s_zRamdump_Arm1WaitFlag)
    {
        ramdump_SaveArm1RegionFileInfo((T_zOss_RadmumpArm1RegionInfo *)ZOSS_RAMDUMP_ARM1_PARSED_REGION_BASE, ZOSS_RAMDUMP_ARM1_NAME);
        ramdump_SaveFileInfo("arm1_targetstate.cmm", ZOSS_RAMDUMP_CMM_FILE_BUF_BASE(ZOSS_RAMDUMP_ARM1_CMM_INFO_BASE), 
                             ZOSS_RAMDUMP_CMM_FILE_BUF_SIZE(ZOSS_RAMDUMP_ARM1_CMM_INFO_BASE));
    }
}

/**************************************************************************
 * ƣramdump_ProcessArm1Exception
 * Arm1쳣
 * ˵(IN):
 *           (OUT):
 *   ֵ   
 * ˵ 
**************************************************************************/
static VOID ramdump_ProcessArm1Exception(VOID)
{
    if (ramdump_CheckArm1InitFinish())
    {
        UINT32 delayTimeLen = 1000;      /* ʱԼ1s*/
        ramdump_ParseArm1RegionInfo((T_zOss_RadmumpArm1RegionInfo *)ZOSS_RAMDUMP_CFG_REGION_BASE, (T_zOss_RadmumpArm1RegionInfo *)ZOSS_RAMDUMP_ARM1_PARSED_REGION_BASE);
        *(volatile UINT32 *)ZOSS_RAMDUMP_ARM1_FLAG_ARM02ARM1_BASE = ZOSS_RAMDUMP_FLAG_SECOND_VALUE;    
#ifdef _OS_TOS
        TOS_CACHE_CLEAN_ALL();
#endif
        s_zRamdump_Arm1WaitFlag = ramdump_delay(delayTimeLen, (UINT32 *)ZOSS_RAMDUMP_ARM1_FLAG_ARM12ARM0_BASE, ZOSS_RAMDUMP_FLAG_SECOND_VALUE);
    }
}

#endif

#ifdef _USE_ZSP_RAMDUMP
/**************************************************************************
 * ƣramdump_ZspRegionCfg
 * zsp ã
 * ˵(IN):
 *           (OUT):
 *   ֵ   
 * ˵ 
**************************************************************************/
static VOID ramdump_ZspRegionCfg(VOID)
{
    T_ZDrvSys_PowerOn_Type powOnType;

    powOnType = zDrvComm_GetPowerOnState();
    if(POWER_ON_FOTA == powOnType || POWER_ON_CHARGING == powOnType)
        return;   

    ramdump_SaveFileInfo("DTCM.bin", RAMDUMP_ZSP_DTCM_BASE, RAMDUMP_ZSP_DTCM_SIZE);
    ramdump_SaveFileInfo("DDDR.bin", RAMDUMP_ZSP_DDDR_BASE, RAMDUMP_ZSP_DDDR_SIZE);
}

/**************************************************************************
 * ƣramdump_SendMsgToZsp
 * zspICPϢ
 * ˵(IN):
 *           (OUT):
 *   ֵ   
 * ˵ icpϢ֪ͨzspҪߣԷ˯zspʱڴ治ܷʣ
**************************************************************************/
static VOID ramdump_SendMsgToZsp(VOID)
{
    T_HalIcp_Msg icpMsg = { 0 };
   
    icpMsg.SrcModId          = ICP_ARM0_MODULE_ID_OS;
    icpMsg.desModId          = ICP_ARM1_MODULE_ID_OS;
 //   icpMsg.len               = exceptType;
    icpMsg.IntInfo.high_word = ZPLAT_PS2PHY_RAMDUMP_INT_ICP_CF;
    zDrvIcp_SendMsg((const T_HalIcp_Msg *)&icpMsg);
}

/**************************************************************************
 * ƣramdump_ProcessMsgFromZsp
 * server zspICPϢ
 * ˵(IN):
 *           (OUT):
 *   ֵ   
 * ˵ 
**************************************************************************/
static VOID ramdump_ProcessMsgFromZsp(const T_HalIcp_Msg *pMsg)
{
    T_HalIcp_Dword  state   = { 0 };

    zDrvIcp_GetState(ICP_MSG_ACTOR_ARM, &state);
    zDrvIcp_ClearState(ICP_MSG_ACTOR_ARM, state);
    sprintf((char *)g_zRamdump_ServerInfo.pErrInfo->pBuff, "zsp: exact error!\n");
#ifdef _OS_LINUX
    linux_ramdump_entry();
#else
    zOss_RamdumpHandle(1, 1, 1);
#endif
}

/**************************************************************************
 * ƣramdump_ZspInit
 * zspʼ
 * ˵(IN):
 *           (OUT):
 *   ֵ   
 * ˵ 
**************************************************************************/
static VOID ramdump_ZspInit(VOID)
{
    zDrvIcp_RegCallback(ICP_ARM0_MODULE_ID_OS, ICP_ARM1_MODULE_ID_OS, ramdump_ProcessMsgFromZsp, ICP_ISR_CALLBACK); 
}

#endif

/******************************************************************************
 * ƣramdump_TransferData
 * PC๤߽нҪ
 * ˵(IN):
 *           (OUT):
 *   ֵ
 * ˵
 *******************************************************************************/
static VOID ramdump_TransferData(VOID)
{
    UINT32             rspDataLen = 0;            
    CHAR               *reqBuffer = (CHAR *)g_zRamdump_ServerInfo.pIoReadbuf->pBuff;
    CHAR               *rspBuffer = (CHAR *)g_zRamdump_ServerInfo.pIoWritebuf->pBuff;
    UINT32             *reqCmd    = (UINT32 *)reqBuffer;
    UINT32             *rspCmd    = (UINT32 *)rspBuffer;
    T_zOss_RamdumpFile *fileInfo  = g_zRamdump_ServerInfo.pFileInfo->fileInfo;
    
    g_zRamdumpIoOpt.init();

    for(;;)
    {
        g_zRamdumpIoOpt.read((UINT8 *)reqBuffer, ZOSS_RAMDUMP_CMD_BUFFER_LEN);      
        switch (*reqCmd)
        {
        case ZOSS_RAMDUMP_FILE_LINK_REQ:            /* ͬ */
            {
                T_zOss_RamumpFileLinkRsp *rspMsg = (T_zOss_RamumpFileLinkRsp *)ZOSS_RAMDUMP_IO_DATA_BASE(rspBuffer);
                *rspCmd = ZOSS_RAMDUMP_FILE_LINK_RSP;
                
                rspMsg->fileNum = g_zRamdump_ServerInfo.pFileInfo->fileNum;
                rspDataLen = sizeof(*rspCmd) + sizeof(T_zOss_RamumpFileLinkRsp);
                break;
            }
        case ZOSS_RAMDUMP_FILE_FILE_REQ:            /* ȡļϢʼļ */
            {
                T_zOss_RamdumpFileFileReq *reqMsg = (T_zOss_RamdumpFileFileReq *)ZOSS_RAMDUMP_IO_DATA_BASE(reqBuffer);
                T_zOss_RamdumpFileFileRsp *rspMsg = (T_zOss_RamdumpFileFileRsp *)ZOSS_RAMDUMP_IO_DATA_BASE(rspBuffer);

                zOss_AssertExN(reqMsg->fileNo < g_zRamdump_ServerInfo.pFileInfo->fileNum);
                *rspCmd = ZOSS_RAMDUMP_FILE_FILE_RSP;
                strcpy((char *)rspMsg->fileName, (char *)fileInfo[reqMsg->fileNo].fileName);
                rspMsg->size = fileInfo[reqMsg->fileNo].size;
                rspDataLen = sizeof(*rspCmd) + sizeof(T_zOss_RamdumpFileFileRsp);            
                break;
            }
        case ZOSS_RAMDUMP_FILE_READ_REQ:            /* ȡļ */
            {
                T_zOss_RamdumpFileReadReq *reqMsg = (T_zOss_RamdumpFileReadReq *)ZOSS_RAMDUMP_IO_DATA_BASE(reqBuffer);
                *rspCmd = ZOSS_RAMDUMP_FILE_READ_RSP;
                
                zOss_AssertExN(reqMsg->fileNo <= g_zRamdump_ServerInfo.pFileInfo->fileNum);  
                zOss_AssertExN(reqMsg->offset + reqMsg->length <= fileInfo[reqMsg->fileNo].size);                
                g_zRamdumpIoOpt.write((UINT8 *)rspBuffer, sizeof(*rspCmd));
                g_zRamdumpIoOpt.write((UINT8 *)(fileInfo[reqMsg->fileNo].baseforServer + reqMsg->offset), reqMsg->length);
                continue;                           /* ִһζ */
            }
        case ZOSS_RAMDUMP_FILE_END_REQ:             /*  */
            {
                *rspCmd = ZOSS_RAMDUMP_FILE_END_RSP;
                g_zRamdumpIoOpt.write((UINT8 *)rspBuffer, sizeof(*rspCmd));
                g_zRamdumpIoOpt.finish();
                return;
            }
        default:                /* ָ */
            {
                *rspCmd = ZOSS_RAMDUMP_FILE_CMD_FAIL;
                rspDataLen = sizeof(*rspCmd);
                break;
            }
        } 
        zOss_AssertExN(rspDataLen < g_zRamdump_ServerInfo.pIoWritebuf->buffLen);
        g_zRamdumpIoOpt.write((UINT8 *)rspBuffer, rspDataLen);
    }
}

/**************************************************************************
 * ƣramdump_get_available_region
 * ĬõڴMMUڴݶԱȣ
             ɵڴ
 * ˵(IN): 
 *              pCfgInfo:     õĵַϢָ룻
 *              pParsedInfo:  ĵַϢָ룻
 *           (OUT):
 *   ֵ   
 * ˵ 
**************************************************************************/
#if defined (_OS_TOS) && defined (CYGOPT_HAL_ARM_MMU)
static VOID ramdump_GetAvailableRegion(T_zOss_RamdumpRegion *pCfgInfo, T_zOss_RamdumpRegionInfo *pParsedInfo)
{
    UINT32                 i             = 0;
    T_zTos_MmuRamdumpTable mmuTable      = { 0 };
    T_zOss_RamdumpRegion   *pParseRegion = &(pParsedInfo->regions[0]);
    
    if (zTos_MmuGetMappingRegion(pCfgInfo->baseForServer, pCfgInfo->size, &mmuTable))
    {
        zOss_AssertExN((pParsedInfo->regionMaxNum - pParsedInfo->regionNum) >= mmuTable.count);
        for (i= 0; i < mmuTable.count; i++, pParsedInfo->regionNum++)
        {
            pParseRegion[pParsedInfo->regionNum].baseForServer = mmuTable.item[i].virBase;
            pParseRegion[pParsedInfo->regionNum].baseForSelf   = pCfgInfo->baseForServer != pCfgInfo->baseForSelf ?
                                                                  (pCfgInfo->baseForSelf + mmuTable.item[i].phyBase - pCfgInfo->baseForServer) : mmuTable.item[i].virBase;
            pParseRegion[pParsedInfo->regionNum].baseForCopy   = pCfgInfo->baseForCopy != 0 ? (pCfgInfo->baseForCopy + mmuTable.item[i].phyBase - pCfgInfo->baseForServer) : 0;
            pParseRegion[pParsedInfo->regionNum].size          = mmuTable.item[i].size;  
        }
    } 
}
#else
static VOID ramdump_GetAvailableRegion(T_zOss_RamdumpRegion *pCfgInfo, T_zOss_RamdumpRegionInfo *pParsedInfo)
{
    T_zOss_RamdumpRegion *pParseRegion = &(pParsedInfo->regions[0]);

    pParseRegion[pParsedInfo->regionNum].baseForServer = pCfgInfo->baseForServer;
    pParseRegion[pParsedInfo->regionNum].baseForSelf   = pCfgInfo->baseForSelf;
    pParseRegion[pParsedInfo->regionNum].baseForCopy   = pCfgInfo->baseForCopy;
    pParseRegion[pParsedInfo->regionNum].size          = pCfgInfo->size;
    pParsedInfo->regionNum++;
}
#endif

/**************************************************************************
 * ƣramdump_ParseRegioInfo
 * ڴļ
 * ˵(IN): 
 *              pCfgInfo:    Ϣָ룻
 *              pParsedInfo: Ϣָ룻
 *           (OUT):
 *   ֵ   
 * ˵ 
**************************************************************************/
static VOID ramdump_ParseRegionInfo(T_zOss_RamdumpRegionInfo *pCfgInfo, T_zOss_RamdumpRegionInfo *pParsedInfo)
{   
    UINT32  i = 0;

    for (i = 0; i < pCfgInfo->regionNum; i++)
    {
        ramdump_GetAvailableRegion(&(pCfgInfo->regions[i]), pParsedInfo);
    }
}

/**************************************************************************
 * ƣramdump_SaveAgentFileInfo
 * ļϢ߶ڴ,ںAGENTͨţ
 * ˵(IN):
 *              name: ļ֣
 *              baseServer:ַ
 *              size: ݴС
 *           (OUT):
 *   ֵ   
 * ˵ 
**************************************************************************/
static VOID ramdump_SaveAgentFileInfo(const CHAR *name, UINT32 baseServer, UINT32 size )
{
    T_zOss_RamdumpFile *pFileInfo = g_zRamdump_ServerInfo.pAgentFileInfo->fileInfo + g_zRamdump_ServerInfo.pAgentFileInfo->fileNum;

    strcpy((char *)pFileInfo->fileName, name);
#ifdef _OS_TOS
# ifdef CYGOPT_HAL_ARM_MMU
    zTos_MmuGetPaddrByVaddr(baseServer,(cyg_uint32 *)&(pFileInfo->baseforServer));
# elif defined (CYGOPT_HAL_ARM_MPU)
    pFileInfo->baseforServer = baseServer;
# endif
#elif defined (_OS_LINUX)
# ifdef CONFIG_MMU
    /* FIXME */
# else
    pFileInfo->baseforServer = baseServer;
# endif
#endif
    pFileInfo->size = size;
    g_zRamdump_ServerInfo.pAgentFileInfo->fileNum++;
    zOss_AssertExN(g_zRamdump_ServerInfo.pAgentFileInfo->fileNum < g_zRamdump_ServerInfo.pAgentFileInfo->fileMaxNum); 
}

/**************************************************************************
 * ƣramdump_SaveFileInfo
 * ļϢ߶ڴ
 * ˵(IN):
 *              name: ֣
 *              baseServer: ַ
 *              size: ݴС
 *           (OUT):
 *   ֵ   
 * ˵ 
**************************************************************************/
static VOID ramdump_SaveFileInfo(const CHAR *name, UINT32 baseServer, UINT32 size )
{
    T_zOss_RamdumpFile *pFileInfo = g_zRamdump_ServerInfo.pFileInfo->fileInfo + g_zRamdump_ServerInfo.pFileInfo->fileNum;

    strcpy((char *)pFileInfo->fileName, name);
    pFileInfo->baseforServer = baseServer;
    pFileInfo->size          = size;
    g_zRamdump_ServerInfo.pFileInfo->fileNum++;
    zOss_AssertExN(g_zRamdump_ServerInfo.pFileInfo->fileNum < g_zRamdump_ServerInfo.pFileInfo->fileMaxNum); 
}

/**************************************************************************
 * ƣramdump_SaveRegionFileInfo
 * ڴ鵼ļ
 * ˵(IN):
 *              p_region_info: ݶεָ룻
 *              file_name    : ļ֣
 *           (OUT):
 *   ֵ   
 * ˵ 
**************************************************************************/
static VOID ramdump_SaveRegionFileInfo(T_zOss_RamdumpRegionInfo *pRegionInfo, const CHAR *pFileName)
{
    UINT32  i                               = 0;
    CHAR    name[ZOSS_RAMDUMP_FILENAME_LEN] = {0};
    
    for (i = 0; i < pRegionInfo->regionNum; i++)
    {
        sprintf(name, "%d_%s", (int)i, pFileName);
        ramdump_SaveFileInfo(name, pRegionInfo->regions[i].baseForServer, pRegionInfo->regions[i].size);
        ramdump_SaveAgentFileInfo(name, pRegionInfo->regions[i].baseForServer, pRegionInfo->regions[i].size);
    }
}

/**************************************************************************
 * ƣramdump_SaveServerFilesInfo
 * serverļ
 * ˵ (IN):
 *            (OUT):
 *   ֵ   
 * ˵ 
**************************************************************************/
static VOID ramdump_SaveServerFilesInfo(VOID)
{
    CHAR                      binName[ZOSS_RAMDUMP_FILENAME_LEN] = {0};
    CHAR                      cmmName[ZOSS_RAMDUMP_FILENAME_LEN] = {0};
    T_zOss_RamdumpCmmFileInfo *pCmmInfo   = g_zRamdump_ServerInfo.pCmmInfo;
    
    sprintf(binName, "%d_s_mem.bin", (int)s_zRamdump_ServerCfgInfo.serverId);
    ramdump_SaveRegionFileInfo(g_zRamdump_ServerInfo.pParsedInfo, binName);
    sprintf(cmmName, "%d_s_targetstate.cmm", (int)s_zRamdump_ServerCfgInfo.serverId);
    ramdump_SaveFileInfo(cmmName, (UINT32)pCmmInfo->cmmFileBuffer, pCmmInfo->cmmFileSize);
    ramdump_SaveAgentFileInfo(cmmName, (UINT32)pCmmInfo->cmmFileBuffer, pCmmInfo->cmmFileSize);
}

/**************************************************************************
 * ƣramdump_SaveClientFilesInfo
 * clientļ
 * ˵(IN):
 *           (OUT):
 *   ֵ   
 * ˵ 
**************************************************************************/
static VOID ramdump_SaveClientFilesInfo(VOID)
{
    CHAR    binName[ZOSS_RAMDUMP_FILENAME_LEN] = {0};
    CHAR    cmmName[ZOSS_RAMDUMP_FILENAME_LEN] = {0};
    UINT32  cnt                                = 0;
    
    for (cnt = 0; cnt < sizeof(g_zRamdump_ClientIcpInfo)/sizeof(T_zOss_RamdumpIcpInfo); cnt++)
    {    
        if ((s_zRamdump_ClientInfo[cnt] != NULL) && g_zRamdump_ServerInfo.pWaitMsgFlag[cnt])
        {
            T_zOss_RamdumpCmmFileInfo *pCmmInfo = s_zRamdump_ClientInfo[cnt]->pCmmInfo;
            
            sprintf(binName, "%d_c_mem.bin", (int)s_zRamdump_ClientInfo[cnt]->clientId);
            ramdump_SaveRegionFileInfo(s_zRamdump_ClientInfo[cnt]->pParsedInfo, binName);
            sprintf(cmmName, "%d_c_targetstate.cmm",(int)s_zRamdump_ClientInfo[cnt]->clientId);
            ramdump_SaveFileInfo(cmmName, (UINT32)pCmmInfo->cmmFileBuffer, pCmmInfo->cmmFileSize);
            ramdump_SaveAgentFileInfo(cmmName, (UINT32)pCmmInfo->cmmFileBuffer, pCmmInfo->cmmFileSize);
        }
    }
    
#ifdef _USE_ARM1_RAMDUMP
    ramdump_SaveArm1FilesInfo();
#endif

#ifdef _USE_ZSP_RAMDUMP
    ramdump_ZspRegionCfg();
#endif
}

/**************************************************************************
 * ƣramdump_SaveErrorFileInfo
 * Ϣļ
 * ˵(IN):
 *           (OUT):
 *   ֵ   
 * ˵ 
**************************************************************************/
static VOID ramdump_SaveErrorFileInfo(VOID)
{
    T_zOss_RamdumpBuffInfo *pErrInfo  = g_zRamdump_ServerInfo.pErrInfo;
    UINT32                  cnt       = 0;
    UINT32                  len       = 0;
    UINT32                  errLogLen = strlen((const char *)pErrInfo->pBuff);

    for (cnt = 0; cnt < sizeof(g_zRamdump_ClientIcpInfo)/sizeof(T_zOss_RamdumpIcpInfo); cnt++)
    {    
        if ((s_zRamdump_ClientInfo[cnt] != NULL) && g_zRamdump_ServerInfo.pWaitMsgFlag[cnt])
        {
            len       =  errLogLen;
            errLogLen += strlen(s_zRamdump_ClientInfo[cnt]->pErrInfo->pBuff);
            zOss_AssertExN(errLogLen < pErrInfo->buffLen);
            strcpy((char *)(pErrInfo->pBuff+ len), (char *)s_zRamdump_ClientInfo[cnt]->pErrInfo->pBuff);
        }
    }
    
#ifdef _USE_ARM1_RAMDUMP    
    if (s_zRamdump_Arm1WaitFlag)
    {
        len       =  errLogLen;
        errLogLen += strlen((char *)ZOSS_RADMUMP_ARM1_ERROR_FILE_BASE);
        zOss_AssertExN(errLogLen < pErrInfo->buffLen);
        strcpy((char *)(pErrInfo->pBuff+ len), (char *)ZOSS_RADMUMP_ARM1_ERROR_FILE_BASE);
    }
#endif 

    ramdump_SaveFileInfo("err_log.txt", (UINT32)pErrInfo->pBuff, errLogLen); 
    ramdump_SaveAgentFileInfo("err_log.txt", (UINT32)pErrInfo->pBuff, errLogLen);
}

/**************************************************************************
 * ƣramdump_SaveAllFilesInfo
 * ļ
 * ˵ (IN):
 *            (OUT):
 *   ֵ   
 * ˵ 
**************************************************************************/
static VOID ramdump_SaveAllFilesInfo(VOID)
{
    ramdump_SaveServerFilesInfo();
    ramdump_SaveClientFilesInfo();
    ramdump_SaveErrorFileInfo();
}

/**************************************************************************
 * ƣramdump_ServerSendMsg
 * ˼ͨѶϢͽӿ
 * ˵(IN):
 *              pIcpInfo: ICPϢָ룻
 *              pMsgInfo: Ϣָ룻
 *           (OUT):
 *   ֵ   
 * ˵ 
**************************************************************************/
static VOID ramdump_ServerSendMsg(T_zOss_RamdumpIcpInfo *pIcpInfo ,T_zOss_RamdumpServerMsgInfo *pMsgInfo)
{
    T_HalIcp_Msg icpMsg;  
    icpMsg.SrcModId            = pIcpInfo->srcModId;
    icpMsg.desModId            = pIcpInfo->desModId;
    icpMsg.IntInfo.high_word   = pIcpInfo->intInfo.high_word;
    icpMsg.pBuf                = pMsgInfo;
    icpMsg.len                 = sizeof(T_zOss_RamdumpServerMsgInfo);
    zDrvIcp_SendMsg((const T_HalIcp_Msg *)&icpMsg);
}

/**************************************************************************
 * ƣexcept_RecordExceptInfo
 * ¼쳣Ϣ
 * ˵(IN):
 *              exceptCore: 쳣ID
 *           (OUT):
 *   ֵ   
 * ˵ 
**************************************************************************/
static VOID except_RecordExceptInfo(UINT32 exceptCoreID)
{
    if(!s_zRamdump_ExceptCore.exceptFlag)
    {
        s_zRamdump_ExceptCore.exceptFlag = TRUE;
        s_zRamdump_ExceptCore.exceptCore = exceptCoreID;
    }
}

/**************************************************************************
 * ƣramdump_ServerProcessClientMsg
 * ˼ͨѶclientϢӿ
 * ˵(IN):
 *              pBuff: Ϣbuffָ룻
 *              len  : ϢС
 *           (OUT):
 *   ֵ   
 * ˵ 
**************************************************************************/
static VOID ramdump_ServerProcessClientMsg(const T_HalIcp_Msg *pMsg)
{
    UINT32                      cnt         = 0;
    T_zOss_RamdumpClientMsgInfo *ramdumpMsg = (T_zOss_RamdumpClientMsgInfo *)pMsg->pBuf;

    switch(ramdumpMsg->msgType)
    {    
    case ZOSS_RAMDUMP_INIT_TYPE:
        {
            for (cnt = 0; cnt < sizeof(g_zRamdump_ClientIcpInfo)/sizeof(T_zOss_RamdumpIcpInfo); cnt++)
            {
                if (ramdumpMsg->srcModId == g_zRamdump_ClientIcpInfo[cnt].srcModId)
                    s_zRamdump_ClientInfo[cnt] = (T_zOss_RamdumpClientInfo *)ramdumpMsg->pRamdumpStartAddr;
            }   
            break;
        }  
    case ZOSS_RAMDUMP_EXCPT_TYPE:
        {
            except_RecordExceptInfo(ramdumpMsg->srcModId);
            sprintf((char *)g_zRamdump_ServerInfo.pErrInfo->pBuff, "%d_s_core: force error!\n", (int)s_zRamdump_ServerCfgInfo.serverId); 
            zOss_RamdumpHandle(1, 1, 1);
            break;
        }
    default:
        {
            break;
        }
    }
}

/**************************************************************************
 * ƣramdump_ServerProcessAgentMsg
 * ˼ͨѶagentϢӿ
 * ˵(IN):
 *              pBuff: Ϣbufferָ룻
 *              len  : ϢС
 *           (OUT):
 *   ֵ   
 * ˵ 
**************************************************************************/
static VOID ramdump_ServerProcessAgentMsg(const T_HalIcp_Msg *pMsg)
{
    T_zOss_RamdumpAgentMsgInfo *ramdumpMsg = (T_zOss_RamdumpAgentMsgInfo *)pMsg->pBuf;

    switch(ramdumpMsg->msgType)
    {
    
    default:
        {
            break;
        }
    }
}

/**************************************************************************
 * ƣramdump_delay
 * ʱȴж϶ramdumpͬ־
 * ˵(IN):
 *                ms  : 550MhzƵµλ1ms
 *                addr: ַ
 *                falg: ȴ־
 *           (OUT):
 *   ֵ   
 * ˵ 
**************************************************************************/
static BOOL ramdump_delay(UINT32 ms, volatile UINT32 *addr, UINT32 flag)
{
    UINT32 i, j;
    
    for (j = 0; j < ZOSS_RAMDUMP_DELAYTIME_CNT; j++)
    {
        for (i = 0; i < ms; i++)
        {
            if (*addr == flag)
                return TRUE;
        } 
    }
    return FALSE;
}

/**************************************************************************
 * ƣramdump_GetConfigRegion
 * ȡradmumpҪ
 * ˵(IN):
 *           (OUT):
 *   ֵ   
 * ˵ 
**************************************************************************/
#if defined (_OS_TOS) && defined (CYGOPT_HAL_ARM_MMU)
static VOID ramdump_GetConfigRegion(VOID)
{
    T_zOss_RamdumpRegion regionInfo = {0};
    UINT32 cnt                      = 0;
    T_zTos_MmuConfigItem *pItem     = NULL;
    
    for (cnt = 0; cnt < g_zTos_MmuConfigTable.count; cnt++)
    {   
        pItem = &g_zTos_MmuConfigTable.item[cnt];
        if (pItem->attr & ZTOS_MMU_REGION_DUMP)
        {
            regionInfo.baseForServer = pItem->server_base;
            regionInfo.baseForSelf   = pItem->physical_base;
            regionInfo.size          = pItem->size;
            regionInfo.baseForCopy   = (pItem->attr & ZTOS_MMU_REGION_COPY) ? pItem->server_base : 0;
            zOss_RamdumpConfigureMem(&regionInfo);
        }
    }
}
#endif

/**************************************************************************
 * ƣramdump_SetPartition
 * ramdumpռ仮֣
 * ˵(IN):
 *           (OUT):
 *   ֵ   
 * ˵ 
**************************************************************************/
static VOID ramdump_SetPartition(VOID)
{
    UINT32 size     = 0;
    UINT32 sizeUnit = s_zRamdump_ServerCfgInfo.ramdumpSize/ZOSS_RAMDUMP_SERVER_TOTAL_RATE;
    
    g_zRamdump_ServerInfo.pCmmInfo = (T_zOss_RamdumpCmmFileInfo *)(((UINT32)s_zRamdump_ServerCfgInfo.pRamdumpStartAddr + sizeof(UINT32) - 1) & ~(sizeof(UINT32) - 1));
    g_zRamdump_ServerInfo.pCmmInfo->cmmFileSize = 0;
    size = (sizeUnit * ZOSS_RAMDUMP_CMM_INFO_RATE - sizeof(UINT32) + 1) & ~(sizeof(UINT32) - 1);
    g_zRamdump_ServerInfo.pCmmInfo->cmmFileMaxSize = size - sizeof(T_zOss_RamdumpCmmFileInfo);
  
    g_zRamdump_ServerInfo.pConfigureInfo = (T_zOss_RamdumpRegionInfo *)((CHAR*)g_zRamdump_ServerInfo.pCmmInfo + size);
    g_zRamdump_ServerInfo.pConfigureInfo->regionNum = 0;
    size = (sizeUnit * ZOSS_RAMDUMP_CONFIGURED_REGION_RATE - sizeof(UINT32) + 1) & ~(sizeof(UINT32) - 1);
    g_zRamdump_ServerInfo.pConfigureInfo->regionMaxNum = (size - sizeof(T_zOss_RamdumpRegionInfo)) / sizeof(T_zOss_RamdumpRegion);

    g_zRamdump_ServerInfo.pParsedInfo = (T_zOss_RamdumpRegionInfo *)((CHAR*)g_zRamdump_ServerInfo.pConfigureInfo+size);
    g_zRamdump_ServerInfo.pParsedInfo->regionNum = 0;
    size = (sizeUnit * ZOSS_RAMDUMP_PARSED_REGION_RATE - sizeof(UINT32) + 1) & ~(sizeof(UINT32) - 1);
    g_zRamdump_ServerInfo.pParsedInfo->regionMaxNum = (size - sizeof(T_zOss_RamdumpRegionInfo)) / sizeof(T_zOss_RamdumpRegion);

    g_zRamdump_ServerInfo.pFileInfo  = (T_zOss_RamdumpFileInfo*)((CHAR*)g_zRamdump_ServerInfo.pParsedInfo + size);
    g_zRamdump_ServerInfo.pFileInfo->fileNum = 0;
    size = (sizeUnit * ZOSS_RAMDUMP_FILE_INFO_RATE - sizeof(UINT32) + 1) & ~(sizeof(UINT32) - 1);
    g_zRamdump_ServerInfo.pFileInfo->fileMaxNum = (size - sizeof(T_zOss_RamdumpFileInfo)) / sizeof(T_zOss_RamdumpFile);

    g_zRamdump_ServerInfo.pAgentFileInfo = (T_zOss_RamdumpFileInfo*)((CHAR*)g_zRamdump_ServerInfo.pFileInfo + size);
    g_zRamdump_ServerInfo.pAgentFileInfo->fileNum = 0;
    size = (sizeUnit * ZOSS_RAMDUMP_FILE_INFO_RATE - sizeof(UINT32) + 1) & ~(sizeof(UINT32) - 1);
    g_zRamdump_ServerInfo.pAgentFileInfo->fileMaxNum = (size - sizeof(T_zOss_RamdumpFileInfo)) / sizeof(T_zOss_RamdumpFile);

    g_zRamdump_ServerInfo.pErrInfo = (T_zOss_RamdumpBuffInfo *)((CHAR*)g_zRamdump_ServerInfo.pAgentFileInfo + size);
    size = (sizeUnit * ZOSS_RAMDUMP_ERR_INFO_RATE - sizeof(UINT32) + 1) & ~(sizeof(UINT32) - 1);
    g_zRamdump_ServerInfo.pErrInfo->pBuff = (CHAR*)g_zRamdump_ServerInfo.pErrInfo + sizeof(T_zOss_RamdumpBuffInfo); 
    g_zRamdump_ServerInfo.pErrInfo->buffLen = size - sizeof(T_zOss_RamdumpBuffInfo);  
    sprintf( (char *)g_zRamdump_ServerInfo.pErrInfo->pBuff, "%d_s_core: exact error!\n", (int)s_zRamdump_ServerCfgInfo.serverId); 

    g_zRamdump_ServerInfo.pIoReadbuf = (T_zOss_RamdumpBuffInfo *)((CHAR *)g_zRamdump_ServerInfo.pErrInfo + size);
    size = (sizeUnit * ZOSS_RAMDUMP_IO_READBUF_RATE - sizeof(UINT32) + 1) & ~(sizeof(UINT32) - 1);
    g_zRamdump_ServerInfo.pIoReadbuf->pBuff = (CHAR*)g_zRamdump_ServerInfo.pIoReadbuf + sizeof(T_zOss_RamdumpBuffInfo);
    g_zRamdump_ServerInfo.pIoReadbuf->buffLen = size - sizeof(T_zOss_RamdumpBuffInfo);  
    
    g_zRamdump_ServerInfo.pIoWritebuf = (T_zOss_RamdumpBuffInfo *)((CHAR *)g_zRamdump_ServerInfo.pIoReadbuf + size);
    size = (sizeUnit * ZOSS_RAMDUMP_IO_WRITEBUF_RATE - sizeof(UINT32) + 1) & ~(sizeof(UINT32) - 1);
    g_zRamdump_ServerInfo.pIoWritebuf->pBuff = (CHAR*)g_zRamdump_ServerInfo.pIoWritebuf + sizeof(T_zOss_RamdumpBuffInfo);
    g_zRamdump_ServerInfo.pIoWritebuf->buffLen = size - sizeof(T_zOss_RamdumpBuffInfo); 
    
    zOss_AssertExN(((CHAR *)g_zRamdump_ServerInfo.pIoWritebuf + size) <= 
                    (s_zRamdump_ServerCfgInfo.pRamdumpStartAddr + s_zRamdump_ServerCfgInfo.ramdumpSize));
}

/**************************************************************************
 * ƣramdump_ClientIcpInit
 * client ICP ʼ
 * ˵(IN):
 *           (OUT):
 *   ֵ   
 * ˵ 
**************************************************************************/
static VOID ramdump_ClientIcpInit(VOID)
{
    UINT32 cnt       = 0;
    UINT32 clientNum = sizeof(g_zRamdump_ClientIcpInfo)/sizeof(T_zOss_RamdumpIcpInfo);

    if(clientNum != 0)
    {
        s_zRamdump_ClientInfo  = (T_zOss_RamdumpClientInfo **)zOss_Malloc(sizeof(VOID *) * clientNum);
        zOss_Memset(s_zRamdump_ClientInfo, 0, sizeof(VOID *) * clientNum);
        g_zRamdump_ServerInfo.pWaitMsgFlag= (BOOL *)zOss_Malloc(sizeof(BOOL) * clientNum);
        zOss_Memset(g_zRamdump_ServerInfo.pWaitMsgFlag, 0, sizeof(BOOL) * clientNum);
    }
    
    for (cnt = 0; cnt < clientNum; cnt++)
    {         
        zDrvIcp_RegCallback(g_zRamdump_ClientIcpInfo[cnt].srcModId, g_zRamdump_ClientIcpInfo[cnt].desModId, ramdump_ServerProcessClientMsg, ICP_ISR_CALLBACK); 
    } 
    
#ifdef _USE_ARM1_RAMDUMP
    ramdump_Arm1Init(); 
#endif

#ifdef _USE_ZSP_RAMDUMP
    ramdump_ZspInit();
#endif

}

/**************************************************************************
 * ƣramdump_NotifyClientExceptionOccur
 * ֪ͨclient쳣
 * ˵(IN):
 *           (OUT):
 *   ֵ   
 * ˵ 
**************************************************************************/
static VOID ramdump_NotifyClientExceptionOccur(VOID)
{
    UINT32                      cnt     = 0;
    T_zOss_RamdumpServerMsgInfo msgInfo = {0};
    
    for (cnt = 0; cnt < sizeof(g_zRamdump_ClientIcpInfo)/sizeof(T_zOss_RamdumpIcpInfo); cnt++)
    {        
        msgInfo.msgType         = ZOSS_RAMDUMP_EXCPT_TYPE;
        msgInfo.pServerConInfo  = NULL;
        ramdump_ServerSendMsg(g_zRamdump_ClientIcpInfo, &msgInfo);
    }
    
#ifdef _USE_ARM1_RAMDUMP
    if (ramdump_CheckArm1InitFinish())
        ramdump_SendMsgToArm1(ZOSS_RAMDUMP_EXCPT_TYPE);
#endif

#ifdef _USE_ZSP_RAMDUMP
    ramdump_SendMsgToZsp();
#endif

}

/**************************************************************************
 * ƣramdump_ProcessClientException
 * client쳣
 * ˵(IN):
 *           (OUT):
 *   ֵ   
 * ˵ 
**************************************************************************/
static VOID ramdump_ProcessClientException(VOID)
{
    UINT32 cnt          = 0;
    UINT32 delayTimeLen = 1000;     /* ʱԼ1s*/
    
    for (cnt = 0; cnt < sizeof(g_zRamdump_ClientIcpInfo)/sizeof(T_zOss_RamdumpIcpInfo); cnt++)
    {
        if (s_zRamdump_ClientInfo[cnt] != NULL)
        {
            g_zRamdump_ServerInfo.pWaitMsgFlag[cnt] = ramdump_delay(delayTimeLen, (volatile UINT32 *)(s_zRamdump_ClientInfo[cnt]->clientFlagBase), ZOSS_RAMDUMP_FLAG_SECOND_VALUE);
            if (g_zRamdump_ServerInfo.pWaitMsgFlag[cnt])
            {
                ramdump_ParseRegionInfo(s_zRamdump_ClientInfo[cnt]->pConfigureInfo, s_zRamdump_ClientInfo[cnt]->pParsedInfo);
                *(UINT32 *)s_zRamdump_ClientInfo[cnt]->clientFlagBase = ZOSS_RAMDUMP_FLAG_THIRD_VALUE;
#ifdef _OS_TOS
                TOS_CACHE_CLEAN_ALL();
#endif
                g_zRamdump_ServerInfo.pWaitMsgFlag[cnt] = ramdump_delay(delayTimeLen, (volatile UINT32 *)(s_zRamdump_ClientInfo[cnt]->clientFlagBase), ZOSS_RAMDUMP_FLAG_FOUR_VALUE);            
            }
        }
    }

#ifdef _USE_ARM1_RAMDUMP
    ramdump_ProcessArm1Exception();
#endif
}

/**************************************************************************
 * ƣramdump_AgentIcpInit
 * AGENT ICP Դʼ
 * ˵(IN):
 *           (OUT):
 *   ֵ   
 * ˵ 
**************************************************************************/
static VOID ramdump_AgentIcpInit(VOID)
{
    UINT32 cnt = 0;
    
    for (cnt = 0; cnt < sizeof(s_zRamdump_AgentIcpInfo)/sizeof(T_zOss_RamdumpIcpInfo); cnt++)
    {
        zDrvIcp_RegCallback(s_zRamdump_AgentIcpInfo[cnt].srcModId, s_zRamdump_AgentIcpInfo[cnt].desModId, ramdump_ServerProcessAgentMsg, ICP_ISR_CALLBACK);     
    } 
}

/**************************************************************************
 * ƣramdump_NotifyAgentExceptionOccur
 * ֪ͨagent쳣
 * ˵(IN):
 *           (OUT):
 *   ֵ   
 * ˵ 
**************************************************************************/
static VOID ramdump_NotifyAgentExceptionOccur(VOID)
{
    UINT32                      cnt     = 0;
    T_zOss_RamdumpServerMsgInfo msgInfo = {0};
    
    for (cnt = 0; cnt < sizeof(s_zRamdump_AgentIcpInfo)/sizeof(T_zOss_RamdumpIcpInfo); cnt++)
    {       
        msgInfo.msgType         = ZOSS_RAMDUMP_EXCPT_TYPE;
        msgInfo.pServerConInfo  = NULL;
        ramdump_ServerSendMsg(&s_zRamdump_AgentIcpInfo[cnt], &msgInfo);
    }
}

/**************************************************************************
 * ƣramdump_NotifyAgentSaveData
 * ֪ͨAGENTԱݣ
 * ˵(IN):
 *           (OUT):
 *   ֵ   
 * ˵ 
**************************************************************************/
static VOID ramdump_NotifyAgentSaveData(VOID)
{
    UINT32                      cnt     = 0;
    T_zOss_RamdumpServerMsgInfo msgInfo = {0};

    for (cnt = 0; cnt < sizeof(s_zRamdump_AgentIcpInfo)/sizeof(T_zOss_RamdumpIcpInfo); cnt++)
    {        
        msgInfo.msgType         = ZOSS_RAMDUMP_DATA_READY_TYPE;
#ifdef _OS_TOS
        zTos_MmuGetPaddrByVaddr((cyg_uint32)g_zRamdump_ServerInfo.pAgentFileInfo,(cyg_uint32 *)&(msgInfo.pServerConInfo));
#endif
        ramdump_ServerSendMsg(&s_zRamdump_AgentIcpInfo[cnt], &msgInfo);
    }
}

/*****************************************************************************
 * ƣ ramdump_Main
 *  ִramdumpPC๤ԼнҪ
 * ˵ (IN):
 *            (OUT):
 *   ֵ
 * ˵
 ****************************************************************************/
static VOID ramdump_Main(VOID)
{
    ramdump_ParseRegionInfo(g_zRamdump_ServerInfo.pConfigureInfo, g_zRamdump_ServerInfo.pParsedInfo);
    zOss_RamdumpCreateCmmFile(g_zRamdump_ServerInfo.pCmmInfo);
    ramdump_NotifyAgentExceptionOccur();
    ramdump_NotifyClientExceptionOccur();
    ramdump_ProcessClientException();
    ramdump_SaveAllFilesInfo();
    ramdump_NotifyAgentSaveData();

    if (g_zRamdump_Optfunc.ramdump_Process_AftHook != NULL)
    {
        g_zRamdump_Optfunc.ramdump_Process_AftHook();
    }
    ramdump_TransferData();
}

/**************************************************************************
* ȫֺʵ
**************************************************************************/

/**************************************************************************
 * ƣ zOss_RamdumpHandle
 *  Ramdump
 * ˵ (IN)
 *               ser_called:Ϊʱ,ʾû,Ϊʱ,ʾں
 *               ecode:
 *               extra:󸽼
 *            (OUT)
 *               ޣ
 *   ֵ
 * ˵ TOSϵͳûʵ;
 **************************************************************************/
VOID zOss_RamdumpHandle(UINT16 user_called, UINT16 ecode, UINT16 extra)
{
    static UINT32  excepNum = 0;
    ZOSS_INTR      old_intr;

    ZOSS_SAVE_IRQ(old_intr); 
    if(++excepNum > 1 || !s_zRamdump_InitFlag)          /* ֻһγֳ */
    {
        for ( ; ; ) ;
    }

    if (zOss_GetExceptResetFlag() != EXCEPT_RESET_ENABLE)
    {
        zOss_RamdumpEncodeError(g_zRamdump_ServerInfo.pErrInfo->pBuff, user_called, ecode, extra);
        /* ִramdump쳣 */
        ramdump_Main();
        if(zOss_GetRamdumpResetFlag() == 0)
        {
            for ( ; ; ) ;
        }
        else
        {
            zSys_ExceptReboot(s_zRamdump_ExceptCore.exceptCore);
        }
    }
    else
    {
        except_RecordExceptInfo(s_zRamdump_ServerCfgInfo.serverId);
        zSys_ExceptReboot(s_zRamdump_ExceptCore.exceptCore);
    }
    
    ZOSS_RESTORE_IRQ(old_intr);
}

/**************************************************************************
 * ƣramdump_RegionsCmmFile
 * T32cmműڴд
 * ˵(IN):
 *              address: cmműָ룻
 *           (OUT):
 *   ֵؽűָ룻
 * ˵ 
**************************************************************************/
CHAR *zOss_RamdumpCreateRegionsCmmFile(CHAR *address)
{
    CHAR    fileName[ZOSS_RAMDUMP_FILENAME_LEN] = {0};
    UINT32  i                                   = 0;  
   
    sprintf(fileName, "%d_s_mem.bin", (int)s_zRamdump_ServerCfgInfo.serverId);
    /* ramdump ڴļ */
    for (i = 0; i < g_zRamdump_ServerInfo.pParsedInfo->regionNum; i++)
    {
        T_zOss_RamdumpRegion *pRegion =  &g_zRamdump_ServerInfo.pParsedInfo->regions[i];   
        address += sprintf(address, "data.load.binary &%s\\%d_%s %#lx--%#lx /noclear\r\n", ZOSS_RAMDUMP_DIR_NAME, 
                           (int)i, fileName, pRegion->baseForSelf, pRegion->baseForSelf + pRegion->size - 1);
    }
    return address;
}

/**************************************************************************
 * ƣzOss_RamdumpConfigureMem
 * ڴϢ
 * ˵(IN):
 *             regionInfo: 
 *           (OUT):
 *   ֵ   
 * ˵ 
**************************************************************************/
VOID zOss_RamdumpConfigureMem(T_zOss_RamdumpRegion *regionInfo)
{
    T_zOss_RamdumpRegionInfo *pCfgInfo = g_zRamdump_ServerInfo.pConfigureInfo;

    if (regionInfo->size == 0)
        return;
    zOss_AssertExN(pCfgInfo->regionNum < pCfgInfo->regionMaxNum);
    pCfgInfo->regions[pCfgInfo->regionNum].baseForServer =  regionInfo->baseForServer;
    pCfgInfo->regions[pCfgInfo->regionNum].baseForSelf   =  regionInfo->baseForSelf;
    pCfgInfo->regions[pCfgInfo->regionNum].baseForCopy   =  regionInfo->baseForCopy;
    pCfgInfo->regions[pCfgInfo->regionNum].size          =  regionInfo->size;
    (pCfgInfo->regionNum)++;
}

/**************************************************************************
 * ƣzOss_RamdumpSetOperation
 * ramdumpûעӿڣ
 * ˵(IN): 
 *              funcObjPtr: صָ룻
 *           (OUT):
 *   ֵ   
 * ˵ 
**************************************************************************/
VOID zOss_RamdumpSetOperation(T_zOss_RamdumpOpt *funcObjPtr)
{
    zOss_AssertExN(funcObjPtr != NULL);
    
    if (funcObjPtr->ramdump_Process_PreHook != NULL)
    {
        g_zRamdump_Optfunc.ramdump_Process_PreHook = funcObjPtr->ramdump_Process_PreHook;
    }
    if (funcObjPtr->ramdump_Process_AftHook != NULL)
    {
        g_zRamdump_Optfunc.ramdump_Process_AftHook = funcObjPtr->ramdump_Process_AftHook;
    }
}

/**************************************************************************
 * ƣzOss_RamdumpInit
 * ramdumpʼ
 * ˵
 *   ֵ
 * ˵
 ***************************************************************************/
VOID zOss_RamdumpInit(VOID)
{
    ramdump_SetPartition();
#if defined (_OS_TOS) && defined (CYGOPT_HAL_ARM_MMU)
    ramdump_GetConfigRegion();
#endif
    ramdump_ClientIcpInit();
    ramdump_AgentIcpInit();

#ifdef _USE_CP_USB
    zOss_RamdumpSetUsbOpt();
#else
    zOss_RamdumpSetIcpOpt();
#endif
    
    s_zRamdump_InitFlag = TRUE;
}

/**************************************************************************
 * ƣzOss_RamdumpForceClientException
 * client
 * ˵(IN)
 *              coreId: client ID
 *           (OUT)
 *              
 *   ֵ
 * ˵ҪҪȷǸclientҪÿclient˿
 ***************************************************************************/
UINT32 zOss_RamdumpForceClientException(UINT32 coreId)
{ 
#ifdef _USE_ARM1_RAMDUMP
    if (coreId == ZOSS_RAMDUMP_PHY_COREDID)
    {
       ramdump_SendMsgToArm1(ZOSS_RAMDUMP_TEST_EXCPT_TYPE);     
    }
    else
#endif
    {
        T_zOss_RamdumpServerMsgInfo msgInfo = {0};
        
        zOss_AssertEx(coreId <= sizeof(g_zRamdump_ClientIcpInfo)/sizeof(T_zOss_RamdumpIcpInfo), ZOSS_ERROR);
        msgInfo.msgType         = ZOSS_RAMDUMP_TEST_EXCPT_TYPE;
        msgInfo.pServerConInfo  = NULL;
        ramdump_ServerSendMsg(&g_zRamdump_ClientIcpInfo[coreId-1], &msgInfo);
    }
    return ZOSS_SUCCESS;
}

/**************************************************************************
 * ƣOsa_SysErrHndInit
 * ַȫֱʼ,ȡramdumpڴĬ
 *           arm0arm1ͬ
 * ˵
 *   ֵ
 * ˵׮Ϊ˼osecskyramdumpܣ
 ***************************************************************************/
VOID Osa_SysErrHndInit(VOID)
{

}

/**************************************************************************
 * ƣ zOss_RamdumpSetIoOpt
 *  ramdump Io ͨ
 * ˵ (IN): 
 *           (OUT):
 *   ֵ   
 * ˵ 
**************************************************************************/
VOID zOss_RamdumpSetIoOpt(T_zOss_RamdumpIoOpt hook)
{
    g_zRamdumpIoOpt.init    = hook.init;
    g_zRamdumpIoOpt.read    = hook.read;
    g_zRamdumpIoOpt.write   = hook.write;
    g_zRamdumpIoOpt.finish  = hook.finish;    
}

/**************************************************************************
 * ƣzOss_RamdumpGetParsedRegions
 * ȡMMU
 * 
 * ˵
 *   ֵ
 * ˵ΪT32 CMMűʹã
 ***************************************************************************/
VOID zOss_RamdumpGetParsedRegions(VOID)
{
    if(s_zRamdump_InitFlag)
    {
        g_zRamdump_ServerInfo.pParsedInfo->regionNum = 0;
        ramdump_ParseRegionInfo(g_zRamdump_ServerInfo.pConfigureInfo, g_zRamdump_ServerInfo.pParsedInfo);
        for ( ; ; ) ;
    }
    else
    {
        for ( ; ; ) ;    
    }
}

#ifdef __cplusplus
}
#endif

