/**************************************************************************
*
*                  Copyright (c) 2012 ZTE Corporation.
*
***************************************************************************
* ģ   : P98C_OSS
*    : sup_shell_mem.c
* ļ : 
* ʵֹ : ڴصshell
*      : 
*      : V1.0
*  : 2019-01-10
* ˵ : 
**************************************************************************/

/**************************************************************************
* #include
**************************************************************************/
#include "sup_shell.h"
#include "sup_shell_cmd.h"
#include "sup_except.h"
#include "osa.h"

#ifdef __cplusplus
extern "C"
{
#endif

/**************************************************************************
* 궨
**************************************************************************/
#ifdef _DEBUG
#define UBLEAKNUM   10000

/**************************************************************************
* ݽṹ
**************************************************************************/
typedef struct 
{
	BOOL			isUsed; 							/* ʹñ 		*/
	UINT32			usingSize;							/* ʵռôС 	*/
	CHAR			name[ZOSS_UBHEAD_FILENAME_LEN + 1]; /* λļ	*/
	UINT32			line;								/* λк 	*/
	ZOSS_THREAD_ID	threadId;							/* ߳ID		*/
	ZOSS_TASK_ID	taskId; 							/* 		*/
	UINT32			applyTimeTick;						/* ʱ(TICK)	*/
	UINT32			use_num;							/* ʹô 		*/
	UINT32			block_size; 						/* ubĴС		*/
}T_DbgMem_UBHead;										/* ڴͷ			*/
#endif

/**************************************************************************
* ֲԭ
**************************************************************************/
 
/**************************************************************************
* ȫֳ/
**************************************************************************/
#ifdef _DEBUG
extern UINT32           gMem_UBStart;
extern T_ZOss_UBPOOL    *gMem_UBPoolCfg;
extern UINT32           gMem_UBPoolNum;
extern UINT32           gUBSuperviseSitch;
#endif

#ifdef _OS_TOS
extern cyg_bool zTos_MmuGetReadableRegion(cyg_uint32 start, cyg_uint32 end, cyg_uint32 *p_start, cyg_uint32 *p_end);
extern cyg_bool zTos_MmuIsPageCanWrite(cyg_uint32 addr);
#endif
#ifdef _OS_OSE
extern void list_pools(void);
extern void list_all_sig_info(void);
extern void list_proc_sig_info(PROCESS pid, OSBOOLEAN listDetail);
extern BOOL mmu_get_readable_region( UINT32 begin, UINT32 end , UINT32 *p_begin, UINT32 *p_end );
extern BOOL mmu_is_writeable(UINT32 v_addr);
extern VOID mmu_generate_info(VOID);
#endif

/**************************************************************************
* ֲʵ
**************************************************************************/
#ifdef _USE_HEAP_DEBUG
static VOID shellSetMemTimeLeak(CHAR *cmd);
#endif

/**************************************************************************
* : shellSetUBDebugFlag
* : Ϣ
* ˵: (IN) 
			cmd:shell
			(OUT)
*   ֵ:
* ˵:
**************************************************************************/
#ifndef _OS_TOS
static VOID shellSetUBDebugFlag(CHAR *cmd)
{
	zOss_Printf(SUBMDL_TEST, PRINT_LEVEL_NORMAL, "\t÷:%s   n", cmd);
	zOss_Printf(SUBMDL_TEST, PRINT_LEVEL_NORMAL, "\t nȡֵ");
	zOss_Printf(SUBMDL_TEST, PRINT_LEVEL_NORMAL, "\t0ʾرUB Կ");
	zOss_Printf(SUBMDL_TEST, PRINT_LEVEL_NORMAL, "\tֵʾUB Կ");
}
#endif

/**************************************************************************
* : shellSetMemTimeLeak
* : Ϣ
* ˵: (IN)
			cmd:shell
			(OUT)
*   ֵ:
* ˵:
**************************************************************************/
#ifdef _USE_HEAP_DEBUG
static VOID shellSetMemTimeLeak(CHAR *cmd)
{	 
	zOss_AssertExN(cmd != NULL);

	zOss_Printf(SUBMDL_TEST, PRINT_LEVEL_NORMAL, "\t÷:%s  \n", cmd);
	zOss_Printf(SUBMDL_TEST, PRINT_LEVEL_NORMAL, "\tʼʱ %s	 leakstart	  й¶ķֵ", cmd);
	zOss_Printf(SUBMDL_TEST, PRINT_LEVEL_NORMAL, "\tʱ %s	 leakend  ", cmd);
	zOss_Printf(SUBMDL_TEST, PRINT_LEVEL_NORMAL, "\tй¶ķֵָ೤ʱmemûͷž͵й¶");
}
#endif

/**************************************************************************
* ȫֺʵ
**************************************************************************/

/* ڴ۲ */
VOID OSS_DbgShowMemInfo(T_Shell_CommandMessage *CmdMsg)
{
	T_Mem_MemInfo	meminfo = {0};
	UINT32			status	= ZOSS_ERROR;
	
	zOss_AssertExN(CmdMsg != NULL);

	if (1 == CmdMsg->paraCount && 0 == strcmp((char *)CmdMsg->para[0], "help"))
	{
		zOss_Printf(SUBMDL_TEST, PRINT_LEVEL_NORMAL, "\t%s:ʾڴϢ", CmdMsg->cmd);
		return;
	}
	zOss_Printf(SUBMDL_TEST, PRINT_LEVEL_NORMAL, "\t=====================================");
	zOss_Printf(SUBMDL_TEST, PRINT_LEVEL_NORMAL, "\t%10s %10s\t %10s","TotalMem","UsedMem","MaxFreeMem");
	
	zOss_Memset(&meminfo, 0, sizeof(meminfo));
	status = zOss_GetSysMemInfo(&meminfo);
	if (ZOSS_SUCCESS == status)
	{
		zOss_Printf(SUBMDL_TEST, PRINT_LEVEL_NORMAL, "\t%10d %10d\t %10d", meminfo.nMemTotal, meminfo.nMemUsed, meminfo.nMemMaxFree);
	}
	else
	{
		zOss_Printf(SUBMDL_TEST, PRINT_LEVEL_NORMAL, "\tGet mem info error!");
	}
	
	zOss_Printf(SUBMDL_TEST, PRINT_LEVEL_NORMAL, "\t=====================================");
	return;
}

VOID OSS_DbgShowUbInfo(T_Shell_CommandMessage *CmdMsg)
{
#ifdef _DEBUG
	
	zOss_AssertExN(CmdMsg != NULL);
	
	if (1 == CmdMsg->paraCount && 0 == strcmp((char *)CmdMsg->para[0], "help"))
	{
		zOss_Printf(SUBMDL_TEST, PRINT_LEVEL_NORMAL, "\t%s:ʾڴػϢ,tosƽ̨ʵʹ", CmdMsg->cmd);
		zOss_Printf(SUBMDL_TEST, PRINT_LEVEL_NORMAL, "\t%s leak:ʾڴй¶Ϣ,oseƽ̨ʵʹ", CmdMsg->cmd);
		zOss_Printf(SUBMDL_TEST, PRINT_LEVEL_NORMAL, "\t%s stat:ʾڴͳϢ,oseƽ̨ʵʹ", CmdMsg->cmd);
		return;
	}
# if defined (_OS_TOS) || defined (_OS_LINUX)
	if (0 == CmdMsg->paraCount)
	{
		zOss_Printf(SUBMDL_TEST, PRINT_LEVEL_NORMAL, "\t%s:tosƽ̨ʵʹ", CmdMsg->cmd);
	}
	else if (1 == CmdMsg->paraCount && 0 == strcmp((char *)CmdMsg->para[0], "leak"))
	{
#ifdef _UB_USE_POOL
		pool_print_leak(0);
#endif
	}
	else if (1 == CmdMsg->paraCount && 0 == strcmp((char *)CmdMsg->para[0], "stat"))
	{
#ifdef _UB_USE_POOL
		pool_print_alloc_fail();
		pool_print_free();
		pool_print_alloc_statistic();
#endif
	}
	else
	{
		zOss_Printf(SUBMDL_TEST, PRINT_LEVEL_NORMAL, "\t%s helpѯ÷", CmdMsg->cmd);
	}
	
	return;
# else

	if(0 == gUBSuperviseSitch)
	{
		zOss_Printf(SUBMDL_TEST, PRINT_LEVEL_NORMAL, "\tubԿδ򿪣˹ܽ");
		return;
	}

	if(0 == CmdMsg->paraCount)
	{
		T_Mem_UBPoolGrpInfo ub_pool_grp_info	= {0};
		UINT32				i					= 0;
		
		zOss_Printf(SUBMDL_TEST, PRINT_LEVEL_NORMAL, "\t	С				ʹĿ	ʹ÷ֵ");
		zOss_Printf(SUBMDL_TEST, PRINT_LEVEL_NORMAL, "\t===============================================");
		if (ZOSS_SUCCESS == Mem_GetUBUseInfo(&ub_pool_grp_info, 1))
		{
			for (i = 0; i < ub_pool_grp_info.pool_num; i++)
			{
				zOss_Printf(SUBMDL_TEST, PRINT_LEVEL_NORMAL, "\t%10d %10d %10d %10d", 
							ub_pool_grp_info.pool_info[i].pool_size, ub_pool_grp_info.pool_info[i].total_block_num,
							ub_pool_grp_info.pool_info[i].total_block_num - ub_pool_grp_info.pool_info[i].free_block_num,
							ub_pool_grp_info.pool_info[i].peak_value);
			}
		}
		else
		{
			zOss_Printf(SUBMDL_TEST, PRINT_LEVEL_SEVERE,"\tGet UB info error!");
		}
		
		zOss_Printf(SUBMDL_TEST, PRINT_LEVEL_NORMAL, "\t===============================================");
	}
	else if (1 == CmdMsg->paraCount && (0 == strcmp((char *)CmdMsg->para[0], "leak") || 0 == strcmp((char *)CmdMsg->para[0], "stat")))
	{
		zOss_Printf(SUBMDL_TEST, PRINT_LEVEL_NORMAL, "\t%s:oseƽ̨ʵʹ", CmdMsg->cmd);
	}
	else
	{
		zOss_Printf(SUBMDL_TEST, PRINT_LEVEL_NORMAL, "\t%s helpѯ÷", CmdMsg->cmd);
	}
# endif    
#else
	zOss_Printf(SUBMDL_TEST, PRINT_LEVEL_ABNORMAL, "\tǰΪrelease汾˹ܽ");
	return;
#endif
}

VOID OSS_DbgShowThreadUbInfo(T_Shell_CommandMessage *CmdMsg)
{
#ifdef _DEBUG
	zOss_AssertExN(CmdMsg != NULL);

# if defined (_OS_TOS) || defined (_OS_LINUX)
	zOss_Printf(SUBMDL_TEST, PRINT_LEVEL_NORMAL, "\t%s:tosƽ̨ʵʹ", CmdMsg->cmd);
	return;
# else

	if (0 != gUBSuperviseSitch)
	{
		if (1 == CmdMsg->paraCount && 0 == strcmp((char *)CmdMsg->para[0], "help"))
		{
			zOss_Printf(SUBMDL_TEST, PRINT_LEVEL_NORMAL, "\t%s:ʾָ߳UB", CmdMsg->cmd);
			zOss_Printf(SUBMDL_TEST, PRINT_LEVEL_NORMAL, "\t%s	[thread_id][ubNum][poolNum]", CmdMsg->cmd);
			zOss_Printf(SUBMDL_TEST, PRINT_LEVEL_NORMAL, "\t\tthread_idΪָ߳idΪ");
			zOss_Printf(SUBMDL_TEST, PRINT_LEVEL_NORMAL, "\t\tubNumѯ߳ubĿ");
			zOss_Printf(SUBMDL_TEST, PRINT_LEVEL_NORMAL, "\t\tpoolNumΪҪѯڴغţЧƽ̨ĬΪ1");
			zOss_Printf(SUBMDL_TEST, PRINT_LEVEL_NORMAL, "\tʾ˵:");
			zOss_Printf(SUBMDL_TEST, PRINT_LEVEL_NORMAL, "\t\tNum:UB");
			zOss_Printf(SUBMDL_TEST, PRINT_LEVEL_NORMAL, "\t\tUbSize:ռUBĴС");
			zOss_Printf(SUBMDL_TEST, PRINT_LEVEL_NORMAL, "\t\tUbUsingSize:ʵռôС");
			zOss_Printf(SUBMDL_TEST, PRINT_LEVEL_NORMAL, "\t\tName:UBļ");
			zOss_Printf(SUBMDL_TEST, PRINT_LEVEL_NORMAL, "\t\tLine:UBк");
			zOss_Printf(SUBMDL_TEST, PRINT_LEVEL_NORMAL, "\t\tUbBlockAdd:UBַ");
			return;
		}
		else if (3 == CmdMsg->paraCount)
		{
			T_Mem_UBBlockInfo	*threadUbInfo	= NULL;
			T_Mem_UBBlockInfo	*pUbInfoStart	= NULL;
			ZOSS_THREAD_ID		threadId		= NULL;
			UINT32				threadUbRealNum = 0;
			UINT32				i				= 0;
			UINT32				maxNum			= 0;
			UINT8				poolNum 		= 1;
			zOss_Printf(SUBMDL_TEST, PRINT_LEVEL_NORMAL, "\t===========================================================================");
			zOss_Printf(SUBMDL_TEST, PRINT_LEVEL_NORMAL, "\t%-10s%-10s%10s%10s%10s%20s","Num","UbSize", "UbUsingSize","Name","Line","UbBlockAdd");
			zOss_Printf(SUBMDL_TEST, PRINT_LEVEL_NORMAL, "\t===========================================================================");
			
			if (-1 == Shell_StrisNumber(CmdMsg->para[0]))
			{
				zOss_Printf(SUBMDL_TEST, PRINT_LEVEL_NORMAL, "\tthread_idμ%s help\n", CmdMsg->cmd);
				return;
			}									  
			threadId = (ZOSS_THREAD_ID)strtoul((char *)CmdMsg->para[0], NULL, 0);
			if (NULL == threadId)
			{
				zOss_Printf(SUBMDL_TEST, PRINT_LEVEL_NORMAL, "\tthread_idμ%s help\n", CmdMsg->cmd);
				return;
			}
			
			maxNum = (UINT32)atoi((const char *)CmdMsg->para[1]);
			if(0 == maxNum)
			{
				zOss_Printf(SUBMDL_TEST, PRINT_LEVEL_NORMAL, "\tmaxNumμ%s help\n", CmdMsg->cmd);
				return;
			}
			
			threadUbInfo = (T_Mem_UBBlockInfo *)zOss_Malloc(maxNum * sizeof(T_Mem_UBBlockInfo));
			zOss_AssertExN(threadUbInfo != NULL);
			pUbInfoStart = threadUbInfo;
			
			threadUbRealNum = Mem_ThreadUBInfo(threadId, threadUbInfo, maxNum, poolNum);
			if (0 == threadUbRealNum)
			{
				zOss_Printf(SUBMDL_TEST, PRINT_LEVEL_NORMAL, "\t߳0x%X%dڴصUBΪ0", threadId, poolNum);
			}
			else
			{
				for (i = 0; i < threadUbRealNum; i++)
				{
					zOss_Printf(SUBMDL_TEST, PRINT_LEVEL_NORMAL, "\t%-10d%-10d%10d%10s%10d%10X", i + 1, 
								threadUbInfo->ubBlockSize, threadUbInfo->usingSize,
								threadUbInfo->name, threadUbInfo->line, threadUbInfo->ubBlock);
					threadUbInfo++;
				}
			}
			zOss_Free(pUbInfoStart);
			pUbInfoStart = NULL;
		}
		else
		{
			zOss_Printf(SUBMDL_TEST, PRINT_LEVEL_NORMAL, "\tμ%s help\n", CmdMsg->cmd);
		}
	}
	else
	{
		zOss_Printf(SUBMDL_TEST, PRINT_LEVEL_ABNORMAL, "\tubԿδ򿪣˹ܽ");
		return;
	}
# endif    
#else
	zOss_Printf(SUBMDL_TEST, PRINT_LEVEL_ABNORMAL, "\tǰΪrelease汾˹ܽ");
	return;
#endif
}

VOID OSS_DbgShowTaskUbInfo(T_Shell_CommandMessage *CmdMsg)
{
#ifdef _DEBUG

	zOss_AssertExN(CmdMsg != NULL);

# if defined (_OS_TOS) || defined (_OS_LINUX)
	zOss_Printf(SUBMDL_TEST, PRINT_LEVEL_NORMAL, "\t%s:tosƽ̨ʵʹ", CmdMsg->cmd);
	return;
# else

	if (0 != gUBSuperviseSitch)
	{
		if (1 == CmdMsg->paraCount && 0 == strcmp((char *)CmdMsg->para[0], "help"))
		{
			zOss_Printf(SUBMDL_TEST, PRINT_LEVEL_NORMAL, "\t%s:ʾָUB", CmdMsg->cmd);
			zOss_Printf(SUBMDL_TEST, PRINT_LEVEL_NORMAL, "\t%s	[task_id][ubNum][poolNum]", CmdMsg->cmd);
			zOss_Printf(SUBMDL_TEST, PRINT_LEVEL_NORMAL, "\t\ttask_idΪָidΪ");
			zOss_Printf(SUBMDL_TEST, PRINT_LEVEL_NORMAL, "\t\tubNumѯubĿ");
			zOss_Printf(SUBMDL_TEST, PRINT_LEVEL_NORMAL, "\t\tpoolNumΪҪѯڴغţЧƽ̨ĬΪ1");
			zOss_Printf(SUBMDL_TEST, PRINT_LEVEL_NORMAL, "\tʾ˵:");
			zOss_Printf(SUBMDL_TEST, PRINT_LEVEL_NORMAL, "\t\tUBNumber:UB");
			zOss_Printf(SUBMDL_TEST, PRINT_LEVEL_NORMAL, "\t\tUBsize:ռUBĴС");
			zOss_Printf(SUBMDL_TEST, PRINT_LEVEL_NORMAL, "\t\tUBsize:ʵռôС");
			zOss_Printf(SUBMDL_TEST, PRINT_LEVEL_NORMAL, "\t\tUBsize:UBļ");
			zOss_Printf(SUBMDL_TEST, PRINT_LEVEL_NORMAL, "\t\tUBsize:UBк");
			zOss_Printf(SUBMDL_TEST, PRINT_LEVEL_NORMAL, "\t\tUBsize:UBַ");
			return;
		}
		else if (3 == CmdMsg->paraCount)
		{
			T_Mem_UBBlockInfo	*taskUbInfo 		= NULL;
			T_Mem_UBBlockInfo	*pTaskUbInfoStart	= NULL;
			ZOSS_TASK_ID		taskId				= NULL;
			UINT32				taskUbRealNum		= 0;
			UINT32				i					= 0;
			UINT32				maxNum				= 0;
			UINT8				poolNum 			= 1;
			zOss_Printf(SUBMDL_TEST, PRINT_LEVEL_NORMAL, "\t===========================================================================");
			zOss_Printf(SUBMDL_TEST, PRINT_LEVEL_NORMAL, "\t%-10s%-10s%10s%10s%10s%20s", "Num", "UbSize", "UbUsingSize", "Name", "Line", "UbBlockAdd");
			zOss_Printf(SUBMDL_TEST, PRINT_LEVEL_NORMAL, "\t===========================================================================");
			
			if (-1 == Shell_StrisNumber(CmdMsg->para[0]))
			{
				zOss_Printf(SUBMDL_TEST, PRINT_LEVEL_NORMAL, "\ttaskIdμ%s help\n", CmdMsg->cmd);
				return;
			}									  
			taskId = (ZOSS_TASK_ID)strtoul((char *)CmdMsg->para[0], NULL, 0);
			if (NULL == taskId)
			{
				zOss_Printf(SUBMDL_TEST, PRINT_LEVEL_NORMAL, "\ttaskIdμ%s help\n", CmdMsg->cmd);
				return;
			}
			
			maxNum = (UINT32)atoi((const char *)CmdMsg->para[1]);
			if(0 == maxNum)
			{
				zOss_Printf(SUBMDL_TEST, PRINT_LEVEL_NORMAL, "\tmaxNumμ%s help\n", CmdMsg->cmd);
				return;
			}

			taskUbInfo = (T_Mem_UBBlockInfo *)zOss_Malloc(maxNum * sizeof(T_Mem_UBBlockInfo));
			zOss_AssertExN(taskUbInfo != NULL);
			pTaskUbInfoStart = taskUbInfo;
			
			taskUbRealNum = Mem_TaskUBInfo(taskId, taskUbInfo ,maxNum, poolNum);
			if (taskUbRealNum == 0)
			{
				zOss_Printf(SUBMDL_TEST, PRINT_LEVEL_NORMAL, "\t0x%X%dڴصUBΪ0", taskId, poolNum);
			}
			else
			{
				for (i = 0; i < taskUbRealNum; i++)
				{
					zOss_Printf(SUBMDL_TEST, PRINT_LEVEL_NORMAL, "\t%-10d%-10d%10d%10s%10d%10X", i + 1, taskUbInfo->ubBlockSize, taskUbInfo->usingSize,
								taskUbInfo->name, taskUbInfo->line, taskUbInfo->ubBlock);
					
					taskUbInfo++;
				}
			}
			zOss_Free(pTaskUbInfoStart);
			pTaskUbInfoStart = NULL;
		}
		else
		{
			zOss_Printf(SUBMDL_TEST, PRINT_LEVEL_NORMAL, "\tμ%s help\n", CmdMsg->cmd);
		}
	}
	else
	{
		zOss_Printf(SUBMDL_TEST, PRINT_LEVEL_ABNORMAL, "\tubԿδ򿪣˹ܽ\n");
		return;
	}
# endif    
#else
	zOss_Printf(SUBMDL_TEST, PRINT_LEVEL_ABNORMAL, "\tǰΪrelease汾˹ܽ\n");
	return;
#endif
}

/* ײָ */
VOID OSS_DbgGetMem(T_Shell_CommandMessage *CmdMsg)
{
    UINT8   *pData      = NULL;
    UINT32  len         = 0;
    UINT32  i           = 0;
    CHAR    *pbuf       = NULL;
#if (defined _OS_TOS && defined CYGOPT_HAL_ARM_MMU) || defined _OS_OSE
    UINT32  end         = 0;
    UINT32  regionStart = 0;
    UINT32  regionEnd   = 0;
#endif    
    zOss_AssertExN(CmdMsg != NULL);

    if (1 == CmdMsg->paraCount && 0 == strcmp((char *)CmdMsg->para[0], "help"))
    {
        zOss_Printf(SUBMDL_TEST, PRINT_LEVEL_NORMAL, "\tshowMem  ַ(ܹ4)  [1-256], δ֪ܵ쳣, ʹ!");
        return;
    }
    else
    {
        if (2 == CmdMsg->paraCount)
        {
            if (0 != Shell_StrisNumber(CmdMsg->para[0]))
            {
                zOss_Printf(SUBMDL_TEST, PRINT_LEVEL_ABNORMAL, "\t%sȡֵֻ(10ƻ16)", CmdMsg->para[0]);
                return;
            }
            pData = (UINT8 *)(strtoul((char *)CmdMsg->para[0], (char **)NULL, 0));
            if (0 != ((UINT32)pData) % 4)
            {
                zOss_Printf(SUBMDL_TEST, PRINT_LEVEL_ABNORMAL, "\tַ0x%x(%u)ܱ4!", pData, pData);
                return;
            }
            if (0 != Shell_StrisNumber(CmdMsg->para[1]))
            {
                zOss_Printf(SUBMDL_TEST, PRINT_LEVEL_ABNORMAL, "\t%sȡֵֻ(10ƻ16)", CmdMsg->para[1]);
                return;
            }
            
            len = strtoul((char *)CmdMsg->para[1], (char **)NULL, 0);
            if (!(len > 0 && len <= 256))
            {
                zOss_Printf(SUBMDL_TEST, PRINT_LEVEL_ABNORMAL, "\t0x%x(%u)Χ[1-256]!", len, len);
                return;
            }
#if defined _OS_TOS && defined CYGOPT_HAL_ARM_MMU
            end = (UINT32)pData + ((len - 1) / 16 + 1) * 16 - 1;
            zTos_MmuGetReadableRegion((UINT32)pData, end, (cyg_uint32 *)&regionStart, (cyg_uint32 *)&regionEnd);
            if((UINT32)pData != regionStart || end > regionEnd)
            {
                zOss_Printf(SUBMDL_TEST, PRINT_LEVEL_ABNORMAL, "\tַ0x%x(%u)~0x%x(%u)!", pData, pData, end, end);
                return;                   
            }
#endif
#ifdef _OS_OSE
            end = (UINT32)pData + ((len - 1) / 16 + 1) * 16 - 1;
            mmu_generate_info();
            mmu_get_readable_region((UINT32)pData, end, &regionStart, &regionEnd);
            if((UINT32)pData != regionStart || end != regionEnd)
            {
                zOss_Printf(SUBMDL_TEST, PRINT_LEVEL_ABNORMAL, "\tַ0x%x(%u)~0x%x(%u)!", pData, pData, end, end);
                return;                   
            }
#endif
            pbuf = (CHAR *)zOss_Malloc(256);
            if (NULL == pbuf)
            {
                zOss_Printf(SUBMDL_TEST, PRINT_LEVEL_ABNORMAL, "\tzOss_Mallocʧ");
                return;
            }
            zOss_Printf(SUBMDL_TEST, PRINT_LEVEL_NORMAL, "\t==============================");
            zOss_Printf(SUBMDL_TEST, PRINT_LEVEL_NORMAL, "\tַ                     ");
            zOss_Printf(SUBMDL_TEST, PRINT_LEVEL_NORMAL, "\t               0  1  2  3  4  5  6  7  8  9  A  B  C  D  E  F");
            zOss_Printf(SUBMDL_TEST, PRINT_LEVEL_NORMAL, "\t==============================");
            for (i = 0; i < len; i += 16)
            {
                sprintf((char *)pbuf, "\t0x%08x     %02x %02x %02x %02x %02x %02x %02x %02x %02x %02x %02x %02x %02x %02x %02x %02x  :  %c%c%c%c%c%c%c%c%c%c%c%c%c%c%c%c", 
                        (int)pData, pData[0], pData[1], pData[2], pData[3], pData[4], pData[5], pData[6], pData[7], pData[8], pData[9], pData[10], pData[11], pData[12], pData[13], pData[14], pData[15],
                        CHAR_PRT(pData[0]), CHAR_PRT(pData[1]), CHAR_PRT(pData[2]), CHAR_PRT(pData[3]), CHAR_PRT(pData[4]), CHAR_PRT(pData[5]), CHAR_PRT(pData[6]), CHAR_PRT(pData[7]), 
                        CHAR_PRT(pData[8]), CHAR_PRT(pData[9]), CHAR_PRT(pData[10]), CHAR_PRT(pData[11]), CHAR_PRT(pData[12]), CHAR_PRT(pData[13]), CHAR_PRT(pData[14]), CHAR_PRT(pData[15]));
                zOss_Printf(SUBMDL_TEST, PRINT_LEVEL_NORMAL, "%s", pbuf);
                pData += 16;
            }
            zOss_Printf(SUBMDL_TEST, PRINT_LEVEL_NORMAL, "\t==============================");
        }
        else
        {
            zOss_Printf(SUBMDL_TEST, PRINT_LEVEL_ABNORMAL, "\t!showMem help鿴");
        }
    }
    
    if (NULL != pbuf)
    {
        zOss_Free(pbuf);
    }
}

VOID OSS_DbgSetMem(T_Shell_CommandMessage *CmdMsg)
{
    UINT32 *pData   = NULL;
    UINT32 data     = 0;

    zOss_AssertExN(CmdMsg != NULL);

    if (1 == CmdMsg->paraCount && 0 == strcmp((char *)CmdMsg->para[0], "help"))
    {
        zOss_Printf(SUBMDL_TEST, PRINT_LEVEL_NORMAL, "\tsetMem  ַ(ܹ4)  ֵ(޷ͷΧ), δ֪ܵ쳣, ʹ!");
        return;
    }
    else
    {
        if (2 == CmdMsg->paraCount)
        {
            if (0 != Shell_StrisNumber(CmdMsg->para[0]))
            {
                zOss_Printf(SUBMDL_TEST, PRINT_LEVEL_ABNORMAL, "\t%sȡֵֻ(10ƻ16)", CmdMsg->para[0]);
                return;
            }
            pData = (UINT32 *)(strtoul((char *)CmdMsg->para[0], (char **)NULL, 0));
            if (0 != ((UINT32)pData) % 4)
            {
                zOss_Printf(SUBMDL_TEST, PRINT_LEVEL_ABNORMAL, "\tַ0x%x(%u)ܱ4!", pData, pData);
                return;
            }
#if defined (_OS_TOS) && defined (CYGOPT_HAL_ARM_MMU)
            if(!zTos_MmuIsPageCanWrite((UINT32)pData))
            {
                zOss_Printf(SUBMDL_TEST, PRINT_LEVEL_ABNORMAL, "\tַ0x%x(%u)д!", pData, pData);
                return;
            }
#endif
#ifdef _OS_OSE
            if(!mmu_is_writeable((UINT32)pData))
            {
                zOss_Printf(SUBMDL_TEST, PRINT_LEVEL_ABNORMAL, "\tַ0x%x(%u)д!", pData, pData);
                return;
            }
#endif
            if (0 != Shell_StrisNumber(CmdMsg->para[1]))
            {
                zOss_Printf(SUBMDL_TEST, PRINT_LEVEL_ABNORMAL, "\t%sȡֵֻ(10ƻ16)", CmdMsg->para[1]);
                return;
            }
            data = strtoul((char *)CmdMsg->para[1], (char **)NULL, 0);
            *pData = data;
            zOss_Printf(SUBMDL_TEST, PRINT_LEVEL_NORMAL, "\t޸ĵַ0x%x(%u)Ϊ0x%x(%u)ɹ", pData, pData, data, data);
        }
        else
        {
            zOss_Printf(SUBMDL_TEST, PRINT_LEVEL_ABNORMAL, "\t!setMem help鿴");
        }
    }
}

VOID Shell_ShowPoolInfo(T_Shell_CommandMessage *CmdMsg)
{
    zOss_AssertExN(CmdMsg != NULL);

#ifdef _OS_TOS
    zOss_Printf(SUBMDL_TEST, PRINT_LEVEL_NORMAL, "\t%s:tosƽ̨ʵʹ", CmdMsg->cmd);
#endif

#ifdef _OS_OSE    
    switch (CmdMsg->paraCount)
    {
    case 0:
        {
            zOss_Printf(SUBMDL_TEST,PRINT_LEVEL_NORMAL, "\t===============================================================================");
            list_pools();
            zOss_Printf(SUBMDL_TEST,PRINT_LEVEL_NORMAL, "===============================================================================");
            break;
        }
    default:
        {
            if (1 == CmdMsg->paraCount && 0 == strcmp((char *)CmdMsg->para[0], "help"))
            { 
                zOss_Printf(SUBMDL_TEST, PRINT_LEVEL_NORMAL, "\t÷:%s", CmdMsg->cmd);
            }
            else
            {
                zOss_Printf(SUBMDL_TEST, PRINT_LEVEL_NORMAL, "\t%s help鿴˵", CmdMsg->cmd);
            }
            break;
        }
    }
#endif

}

/**************************************************************************
* : OSS_SetMenDbgFlag
* : ubԿ
* ˵: (IN)
            CmdMsg:shell 
            (OUT)
*   ֵ:
* ˵:
**************************************************************************/
VOID OSA_SetUBDbgSwitch(T_Shell_CommandMessage *CmdMsg)
{
#ifdef _OS_TOS
    zOss_AssertExN(CmdMsg != NULL);
    zOss_Printf(SUBMDL_TEST, PRINT_LEVEL_NORMAL, "\t%s:tosƽ̨ʵʹ", CmdMsg->cmd);
    return;
#elif defined (_OS_LINUX)

#else
    UINT32 tmp = 0;

    zOss_AssertExN(CmdMsg != NULL);

    if (1 != CmdMsg->paraCount)
    {
        shellSetUBDebugFlag(CmdMsg->cmd);
        return;
    }
    if (-1 == Shell_StrisNumber(CmdMsg->para[0]))
    {
        shellSetUBDebugFlag(CmdMsg->cmd);
        return;
    }
    
    tmp = strtoul((char*)CmdMsg->para[0], NULL, 0);
    zOss_SetUbDbgSwitch(tmp);
    if (tmp)
    {
        zOss_Printf(SUBMDL_TEST, PRINT_LEVEL_NORMAL, "\tɹubĵԿ");
    }
    else
    {
        zOss_Printf(SUBMDL_TEST, PRINT_LEVEL_NORMAL, "\tɹرubĵԿ");
    }
#endif
}

/**************************************************************************
* : OSA_DbgMemInfo
* : memʹϢ(й¶Խ)
* ˵: (IN)
            CmdMsg:shell
            (OUT)
*   ֵ:
* ˵:
**************************************************************************/
VOID OSA_DbgMemInfo(T_Shell_CommandMessage *CmdMsg)
{
#ifdef _USE_HEAP_DEBUG
    zOss_AssertExN(CmdMsg != NULL);
      
    if(CmdMsg->paraCount == 0)
    {
        zOss_CheckMem();
    }
    else if (CmdMsg->paraCount == 1 && 0 == strcmp((char *)CmdMsg->para[0], "help"))
    {
        zOss_Printf(SUBMDL_TEST, PRINT_LEVEL_NORMAL, "\t÷:%s", CmdMsg->cmd);
    }
    else
    {
        zOss_Printf(SUBMDL_TEST, PRINT_LEVEL_NORMAL, "\t %s help 鿴÷", CmdMsg->cmd);
    }
#else
    zOss_Printf(SUBMDL_TEST, PRINT_LEVEL_ABNORMAL, "\t_USE_HEAP_DEBUGδ򿪣˹ܽ");
    return;
#endif
}

/**************************************************************************
* : OSA_DbgMemTimeLeakInfo
* : ĳʱMemй¶Ϣ
* ˵: (IN)
            CmdMsg:shell
            (OUT)
*   ֵ:
* ˵:
**************************************************************************/
VOID OSA_DbgMemTimeLeakInfo(T_Shell_CommandMessage *CmdMsg)
{
#ifdef _USE_HEAP_DEBUG
    UINT32 tmp = 0;

    zOss_AssertExN(CmdMsg != NULL);

    if ((CmdMsg->paraCount == 2) && (0 == strcmp((const char *)CmdMsg->para[0], "leakstart")))
    {
        if (-1 == Shell_StrisNumber(CmdMsg->para[1]))
        {
            zOss_Printf(SUBMDL_TEST, PRINT_LEVEL_NORMAL, "\t");
            return;
        }
        tmp = strtoul((char*)CmdMsg->para[1], NULL, 0);
        zOss_MemLeakStart(tmp);
    }
    else if ((CmdMsg->paraCount == 1) && (0 == strcmp((const char *)CmdMsg->para[0], "leakend")))
    {
        zOss_MemLeakEnd();
    }
    else
    {
        shellSetMemTimeLeak(CmdMsg->cmd);
    }
#else
    zOss_Printf(SUBMDL_TEST, PRINT_LEVEL_ABNORMAL, "\t_USE_HEAP_DEBUGδ򿪣˹ܽ");
    return;
#endif
}

/**************************************************************************
* : OSA_UBLeakInfo
* : ڴͳڴصʹ
* ˵: (IN)
            poolNum:ڴغ
            (OUT)
*   ֵ:
* ˵:
**************************************************************************/
VOID OSA_UBLeakInfo(UINT32 poolNum)
{
#if defined (_OS_OSE) || defined (_OS_WIN)
#if defined (_DEBUG)
    T_Mem_UBPoolCtl     *pUbControlStart    = NULL;
    T_Mem_UBListNode    *pUbListNodeStart   = NULL;
    UINT32              i                   = 0;
    UINT32              j                   = 0;
    UINT32              k                   = 0;
    UINT32              tmpPoolNum          = 0;
    T_Mem_UBListNode    *pUbListNodeTemp    = NULL;
    T_DbgMem_UBHead     *pUBDbgLeakInfo     = NULL;
    T_DbgMem_UBHead     *pTmpUBDbgLeakInfo  = NULL;
    UINT32              UBLeakNum           = 0;
    UINT32              tmpSize             = 0;
    
    tmpPoolNum = poolNum;
    pUbControlStart = (T_Mem_UBPoolCtl *)gMem_UBStart;
    pUbListNodeStart = (T_Mem_UBListNode *)(pUbControlStart + gMem_UBPoolNum); 
    pUbListNodeTemp = pUbListNodeStart;
    tmpSize = sizeof(T_DbgMem_UBHead) * gMem_UBPoolCfg[tmpPoolNum].total_block_num;
    
    pUBDbgLeakInfo = (T_DbgMem_UBHead *)zOss_Malloc(tmpSize);
    
    zOss_AssertExN(NULL != pUBDbgLeakInfo);
    
    zOss_Memset(pUBDbgLeakInfo, 0, tmpSize);
    pTmpUBDbgLeakInfo = pUBDbgLeakInfo;
    for (i = 0; i < tmpPoolNum; i++)
    {
        pUbListNodeTemp = pUbListNodeTemp + gMem_UBPoolCfg[i].total_block_num;
    }
    
    for (j = 0; j < gMem_UBPoolCfg[tmpPoolNum].total_block_num; j++)
    {
        if (pUbListNodeTemp->ubBlockHeader.isUsed == TRUE)
        {
            for (k = 0; k < UBLeakNum; k++)
            {
                pTmpUBDbgLeakInfo = pUBDbgLeakInfo + k;
                if ((0 == strcmp((char *)pTmpUBDbgLeakInfo->name, (char *)pUbListNodeTemp->ubBlockHeader.name)) && 
                                (pTmpUBDbgLeakInfo->line == pUbListNodeTemp->ubBlockHeader.line) &&
                                (pTmpUBDbgLeakInfo->usingSize == pUbListNodeTemp->ubBlockHeader.usingSize) && 
                                (pTmpUBDbgLeakInfo->taskId == pUbListNodeTemp->ubBlockHeader.taskId) && 
                                (pTmpUBDbgLeakInfo->threadId == pUbListNodeTemp->ubBlockHeader.threadId))
                {
                    ++pTmpUBDbgLeakInfo->use_num;
                    break;
                }
                
            }
            if (k >= UBLeakNum)
            {
                pTmpUBDbgLeakInfo = pUBDbgLeakInfo + UBLeakNum;
                zOss_Memcpy(pTmpUBDbgLeakInfo, (char *)pUbListNodeTemp, sizeof(T_Mem_UBListNode) - 4);  /* ڴͷ */
                pTmpUBDbgLeakInfo->use_num = 1;
                ++UBLeakNum;
            }
        }
        pUbListNodeTemp++;
    }
    
    for (i = 0; i < UBLeakNum; i++)
    {
        pTmpUBDbgLeakInfo = pUBDbgLeakInfo + i;
        zOss_Printf(SUBMDL_OSA, PRINT_LEVEL_SEVERE, "\tڴʹôС:%-8d й©ļ:%-30s к:%-8d  ߳ID :0x%08x      ID :0x%08x      ʹô:%-8d", 
                    pTmpUBDbgLeakInfo->usingSize, pTmpUBDbgLeakInfo->name, pTmpUBDbgLeakInfo->line, pTmpUBDbgLeakInfo->threadId, 
                    pTmpUBDbgLeakInfo->taskId, pTmpUBDbgLeakInfo->use_num);
    }
    
    zOss_Sleep(1000);
    zOss_Free(pUBDbgLeakInfo);
#endif  // #if defined (_DEBUG)
#endif  // #if defined (_OS_OSE) || defined (_OS_WIN)
}

/**************************************************************************
* : OSA_DbgUbInfo
* : ubϢ
* ˵: (IN)
            CmdMsg:shell
            (OUT)
*   ֵ:
* ˵:
**************************************************************************/
VOID OSA_DbgUbInfo(T_Shell_CommandMessage *CmdMsg)
{
#ifdef _DEBUG
    zOss_AssertExN(CmdMsg != NULL);    
# if defined (_OS_TOS) || defined (_OS_LINUX)
    zOss_Printf(SUBMDL_TEST, PRINT_LEVEL_NORMAL, "\t%s:tosƽ̨ʵʹ", CmdMsg->cmd);
    return;
# else

    if(0 == gUBSuperviseSitch)
    {
        zOss_Printf(SUBMDL_TEST, PRINT_LEVEL_ABNORMAL, "\tubԿδ򿪣˹ܽ");
        return;
    }

    if(CmdMsg->paraCount == 0)
    {
        UINT32 pool_num = 0;  
        for (pool_num = 0; pool_num < gMem_UBPoolNum; pool_num++)
        {
            OSA_UBLeakInfo(pool_num);
        }
    }
    else if (CmdMsg->paraCount == 1 && 0 == strcmp((char *)CmdMsg->para[0], "help"))
    {
        zOss_Printf(SUBMDL_TEST, PRINT_LEVEL_NORMAL, "\t÷:%s", CmdMsg->cmd);
    }
    else
    {
        zOss_Printf(SUBMDL_TEST, PRINT_LEVEL_NORMAL, "\t %s help 鿴÷", CmdMsg->cmd);
    }
# endif
#endif
}

#ifdef __cplusplus
}
#endif

