/**************************************************************************
*
*                  Copyright (c) 2012 ZTE Corporation.
*
***************************************************************************
* ģ   : P98C_OSS
*    : sup_shell_misc.c
* ļ : 
* ʵֹ : misc shell
*      : 
*      : V1.0
*  : 2019-01-10
* ˵ : 
**************************************************************************/

/**************************************************************************
* #include
**************************************************************************/
#include "sup_shell.h"
#include "sup_shell_cmd.h"
#include "sup_except.h"
#include "osa.h"

#ifdef _USE_MULTI_CORE_RAMDUMP
#include "sup_ramdump.h"
#else
#include "osa_ramdump.h"
#endif

#ifdef _OS_LINUX
#include <linux/kernel.h>
#else
#include <stdio.h>
#include <stdlib.h>
#endif

#ifdef __cplusplus
extern "C"
{
#endif

/**************************************************************************
* ⲿ
**************************************************************************/
#ifdef _OS_LINUX
extern UINT32 zOss_SetProcessPri(VOID *thread_id, UINT32 priority);
extern UINT32 zOss_GetProcessPri(VOID *thread_id, UINT32 priority);
#endif

/**************************************************************************
* 궨
**************************************************************************/
#ifdef _OS_TOS
# define GMON_OUT_FILE  "/c/gmon.out"
#endif

/**************************************************************************
* ݽṹ
**************************************************************************/
 
/**************************************************************************
* ֲԭ
**************************************************************************/
 
/**************************************************************************
* ȫֳ/
**************************************************************************/

/**************************************************************************
* ֲʵ
**************************************************************************/

/**************************************************************************
* ƣShell_SetIrqLogFlag
* жϵϢflag
* ˵(IN)
				flag:򿪻رյı־;
			(OUT)
				;
*   ֵ
* ˵
**************************************************************************/
static VOID Shell_SetIrqLogFlag(UINT32 flag)
{
#ifdef TOS_STATISTIC_IRQ
	if (flag == 0)
	{
		tos_statistic_irq_close();
		zOss_Printf(SUBMDL_TEST, PRINT_LEVEL_NORMAL, "\t ɹرжͳƹ;");
	}
	else
	{
		tos_statistic_irq_open();
		zOss_Printf(SUBMDL_TEST, PRINT_LEVEL_NORMAL, "\t ɹжͳƹ;");
	}		 
#else
	zOss_Printf(SUBMDL_TEST, PRINT_LEVEL_NORMAL, "\t TOS_STATISTIC_IRQûд;");
#endif

#ifdef TOS_TRACE_IRQ
	if (flag == 0)
	{
		tos_trace_irq_close();
		zOss_Printf(SUBMDL_TEST, PRINT_LEVEL_NORMAL, "\t ɹرжϸٹ;");
	}
	else
	{
		tos_trace_irq_open();
		zOss_Printf(SUBMDL_TEST, PRINT_LEVEL_NORMAL, "\t ɹжϸٹ;");
	}
#else
	zOss_Printf(SUBMDL_TEST, PRINT_LEVEL_NORMAL, "\t TOS_TRACE_IRQûд;");
#endif       
}

/**************************************************************************
* ƣShell_SetThreadLogFlag
* ̵߳Ϣflag
* ˵(IN)
				flag:򿪻رյı־;
			(OUT)
				;
*   ֵ
* ˵
**************************************************************************/
static VOID Shell_SetThreadLogFlag(UINT32 flag)
{
#ifdef OSS_TRACE_THREAD
	if (flag == 0)
	{
		oss_trace_thread_close();
		zOss_Printf(SUBMDL_TEST, PRINT_LEVEL_NORMAL, "\t ɹر̸߳ٹ;");
	}
	else
	{
		oss_trace_thread_open();
		zOss_Printf(SUBMDL_TEST, PRINT_LEVEL_NORMAL, "\t ɹ̸߳ٹ;");
	}
#else
	zOss_Printf(SUBMDL_TEST, PRINT_LEVEL_NORMAL, "\t OSS_TRACE_THREADûд;");
#endif   
}

/**************************************************************************
* ȫֺʵ
**************************************************************************/

/*  */
VOID OSS_DbgShowBootInfo(T_Shell_CommandMessage *CmdMsg)
{ 
	zOss_AssertExN(CmdMsg != NULL);

	if (1 == CmdMsg->paraCount && 0 == strcmp((char *)CmdMsg->para[0], "help"))
	{
		zOss_Printf(SUBMDL_TEST, PRINT_LEVEL_NORMAL, "\t%s:ӡϢ", CmdMsg->cmd);
		return;
	}

	zOss_RamPrintf();
}

VOID OSS_DbgSetWintracePrintFlag(T_Shell_CommandMessage *CmdMsg)
{
	UINT32 type = 0;
	
	zOss_AssertExN(CmdMsg != NULL);
	if (1 == CmdMsg->paraCount && 0 == strcmp((char *)CmdMsg->para[0], "help"))
	{
		zOss_Printf(SUBMDL_TEST, PRINT_LEVEL_NORMAL, "\t%s	type", CmdMsg->cmd);
		zOss_Printf(SUBMDL_TEST, PRINT_LEVEL_NORMAL, "\ttype:ȡֵ011ʾ򿪣0ʾر");
		return;
	}
	else
	{
		if (1 == CmdMsg->paraCount)
		{
			if (0 != Shell_StrisNumber(CmdMsg->para[0]))
			{
				zOss_Printf(SUBMDL_TEST, PRINT_LEVEL_ABNORMAL, "\ttypeֻȡֵ");
				return;
			}
			type = strtoul((char *)CmdMsg->para[0], (char **)NULL, 0);
			if (type < 2)
			{
				Shell_SetPrintFlag(type);
			}
			else
			{
				zOss_Printf(SUBMDL_TEST, PRINT_LEVEL_ABNORMAL, "\ttype:ȡֵ011ʾ򿪣0ʾر");
			}
		}
		else
		{
			zOss_Printf(SUBMDL_TEST, PRINT_LEVEL_ABNORMAL, "\t%s helpð", CmdMsg->cmd);
		}
	}
}

VOID OSS_DbgRamdumpConfigRegionInfo (T_Shell_CommandMessage *CmdMsg)
{    
#ifdef _USE_MULTI_CORE_RAMDUMP
    T_zOss_RamdumpRegion regionInfo = {0};
#else
    UINT32  base        = 0;
    UINT32  size        = 0;
    UINT32  map_base    = 0;
    UINT32  copy_base   = 0;
#endif
    zOss_AssertExN(CmdMsg != NULL);
    
    switch (CmdMsg->paraCount)
    {
    case 1:
        {
            if (0 == strcmp((char *)CmdMsg->para[0], "help"))
            {
                zOss_Printf(SUBMDL_TEST, PRINT_LEVEL_NORMAL, 
                            "\tõڴ16ʽڴʼַڴδСмÿո");
            }
            else
            {
                zOss_Printf(SUBMDL_TEST, PRINT_LEVEL_NORMAL, "\tramdumpConfigRegion helpѯ÷");
            }           
            break;
        }
    case 2:
        {
            if (-1 == Shell_StrisNumber(CmdMsg->para[0]) || -1 == Shell_StrisNumber(CmdMsg->para[1]))
            {
                zOss_Printf(SUBMDL_TEST, PRINT_LEVEL_NORMAL, "\tramdumpConfigRegion helpѯ÷");
                break;
            }            
#ifdef _USE_MULTI_CORE_RAMDUMP
            regionInfo.baseForServer = strtoul((char *)CmdMsg->para[0], NULL, 16);
            regionInfo.size          = strtoul((char *)CmdMsg->para[1], NULL, 16);
            regionInfo.baseForSelf   = regionInfo.baseForServer;
            regionInfo.baseForCopy   = 0;
            
            zOss_RamdumpConfigureMem(&regionInfo);
#else
            base = strtoul((char *)CmdMsg->para[0], NULL, 16);
            size = strtoul((char *)CmdMsg->para[1], NULL, 16);
            map_base    = base;
            copy_base   = 0;
            
            zOss_RamdumpConfigureMem(base, size, map_base, copy_base);
#endif
            break;
        }
    default:
        {
            zOss_Printf(SUBMDL_TEST, PRINT_LEVEL_NORMAL, "\tramdumpConfigRegion helpѯ÷");
            break;
        }
    }
}

VOID OSS_DbgShowMsg(T_Shell_CommandMessage *CmdMsg)
{
    zOss_Printf(SUBMDL_TEST, PRINT_LEVEL_NORMAL, "\tδʵ");
}

#if defined(__ARMCC_VERSION) && __ARMCC_VERSION > 220000
__asm shell_GetR11(VOID)
{
    mov r0, r11
    bx lr
}
#endif

VOID OSS_DbgShowRegInfo(T_Shell_CommandMessage *CmdMsg)
{
#if defined(__ARMCC_VERSION) && __ARMCC_VERSION > 220000
    UINT32 Reg11    = 0;
    UINT32 spReg    = 0;
    UINT32 pcReg    = 0;
    UINT32 lrReg    = 0;
    UINT32 cReg     = 0;
    UINT32 sReg     = 0;
#endif

    zOss_AssertExN(CmdMsg != NULL);

    if (1 == CmdMsg->paraCount && 0 == strcmp((char *)CmdMsg->para[0], "help"))
    {
        zOss_Printf(SUBMDL_TEST, PRINT_LEVEL_NORMAL, "\t÷:%s", CmdMsg->cmd);
        return;
    }

#if defined(__ARMCC_VERSION) && __ARMCC_VERSION > 220000
    Reg11 = shell_GetR11();
    __asm
    {
        MOV spReg, __current_sp()
        MOV pcReg, __current_pc()
        MOV lrReg, __return_address()
        MRS cReg, CPSR
        MRS sReg, SPSR
    }
    zOss_Printf(SUBMDL_TEST, PRINT_LEVEL_NORMAL, "\tfp:0x%08x", Reg11);
    zOss_Printf(SUBMDL_TEST, PRINT_LEVEL_NORMAL, "\tsp:0x%08x", spReg);
    zOss_Printf(SUBMDL_TEST, PRINT_LEVEL_NORMAL, "\tpc:0x%08x", pcReg);
    zOss_Printf(SUBMDL_TEST, PRINT_LEVEL_NORMAL, "\tlr:0x%08x", lrReg);
    zOss_Printf(SUBMDL_TEST, PRINT_LEVEL_NORMAL, "\tcpsr:0x%08x", cReg);
    zOss_Printf(SUBMDL_TEST, PRINT_LEVEL_NORMAL, "\tspsr:0x%08x", sReg);
#else
    zOss_Printf(SUBMDL_TEST, PRINT_LEVEL_ABNORMAL, "\tùδʵ");
#endif
}

VOID OSS_DbgReboot(T_Shell_CommandMessage *CmdMsg)
{
    UINT32 type = 0;
    
    zOss_AssertExN(CmdMsg != NULL);

    if (1 == CmdMsg->paraCount && 0 == strcmp((char *)CmdMsg->para[0], "help"))
    {
        zOss_Printf(SUBMDL_TEST, PRINT_LEVEL_NORMAL, "\treboot  type");
        zOss_Printf(SUBMDL_TEST, PRINT_LEVEL_NORMAL, "\ttype:ȡֵ121ʾ2ʾӲ");
        return;
    }
    else
    {
        if (1 == CmdMsg->paraCount)
        {
            if (0 != Shell_StrisNumber(CmdMsg->para[0]))
            {
                zOss_Printf(SUBMDL_TEST, PRINT_LEVEL_ABNORMAL, "\ttypeֻȡֵ");
                return;
            }
            type = strtoul((char *)CmdMsg->para[0], (char **)NULL, 0);
            switch (type)
            {
            case 1:
                {
                    zOss_SysSoftReset(SYS_RESET_TO_NORMAL);
                    break;
                }
            case 2:
                {
                    zOss_Printf(SUBMDL_TEST, PRINT_LEVEL_ABNORMAL, "\tӿڻδʵ");
                    break;
                }
            default:
                {
                    zOss_Printf(SUBMDL_TEST, PRINT_LEVEL_ABNORMAL, "\ttype:0x%x(%u)ȡֵreboot helpð", type, type);
                    break;
                }
            }
        }
        else
        {
            zOss_Printf(SUBMDL_TEST, PRINT_LEVEL_ABNORMAL, "\treboot helpð");
        }
    }
}

/**************************************************************************
* :     ȡprofile
* ˵:     
*   ()  void
*   ()  void
*				void
*   ֵ:     void
* ˵:     void
**************************************************************************/
VOID Shell_ProfileRecords(VOID)
{
#if defined (_OS_TOS) && defined (CYGPKG_PROFILE_GPROF) 
	FILE *file                              = NULL;
	UINT32 bucket                           = 0;
	UINT32 size                             = 0;
	CHAR* buf                               = NULL;
	CHAR* hist_data_start                   = NULL;
    profile_records_t *profile_records_ptr  = NULL;

	profile_records_ptr = cyg_profile_get_records();
    size =  sizeof(struct gmon_hdr)+
            sizeof(profile_records_ptr->profile_tags[0])+
            sizeof(struct gmon_hist_hdr)+
            profile_records_ptr->profile_hist_hdr.hist_size*sizeof(profile_time_t);

    buf = (CHAR *)zOss_Malloc(size);
    if (!buf)
    {
        zOss_Printf(SUBMDL_TEST, PRINT_LEVEL_NORMAL, "\t\tռʧ!");
        return;
    }

    hist_data_start = buf + sizeof(struct gmon_hdr)
                          + sizeof(profile_records_ptr->profile_tags[0])
                          + sizeof(struct gmon_hist_hdr);

    zOss_Memset(buf, 0, size);
    zOss_Memcpy(buf, &profile_records_ptr->profile_gmon_hdr, sizeof(struct gmon_hdr));
    zOss_Memcpy(buf+sizeof(struct gmon_hdr), 
                &profile_records_ptr->profile_tags[0], 
                sizeof(profile_records_ptr->profile_tags[0]));
    zOss_Memcpy(buf+sizeof(struct gmon_hdr) + sizeof(profile_records_ptr->profile_tags[0]),
                &profile_records_ptr->profile_hist_hdr,
                sizeof(struct gmon_hist_hdr));
#ifdef CYGPKG_PROFILE_HIST_HOOK
    for (bucket = 0; bucket < profile_records_ptr->profile_hist_hdr.hist_size; bucket++)
    {
        if (profile_records_ptr->profile_hist_data_ptr[bucket].sum_time)
            zOss_Memcpy((hist_data_start + sizeof(profile_time_t)*bucket),
                        &(profile_records_ptr->profile_hist_data_ptr[bucket].sum_time),
                        sizeof(profile_time_t));
    }
#else
    zOss_Memcpy(hist_data_start, profile_records_ptr->profile_hist_data_ptr,
                profile_records_ptr->profile_hist_hdr.hist_size*sizeof(profile_time_t));
#endif

	if ((file = zOss_FOpen(GMON_OUT_FILE, "wb")) == NULL)
    {
        zOss_Printf(SUBMDL_TEST, PRINT_LEVEL_NORMAL, "\t\tgmon.outļʧ!");
        zOss_Free((VOID *)buf);
        return;
    }

	size = zOss_FWrite(buf, size, 1, file);
    zOss_Printf(SUBMDL_TEST, PRINT_LEVEL_NORMAL, size ? "\t\t ɹдgmon.outļ!" : "\t\tдgmon.outļʧ!");
    zOss_FClose(file);
    zOss_Free((VOID *)buf);
#endif	// #if defined (_OS_TOS) && defined (CYGPKG_PROFILE_GPROF)
}

/**************************************************************************
* :     ϵͳʱprofileϢ
* ˵:     
*   ()  CmdMsg: shellϢָ
*   ()  void
*   ֵ:     void
* ˵:     void
**************************************************************************/
VOID OSS_DbgProfile(T_Shell_CommandMessage *CmdMsg)
{
#if defined (_OS_TOS) && defined (CYGPKG_PROFILE_GPROF)
    zOss_AssertExN(CmdMsg != NULL);

    Shell_ProfileRecords();
#endif  // #if defined (_OS_TOS) && defined (CYGPKG_PROFILE_GPROF)
}

VOID Shell_ShowProcSig(T_Shell_CommandMessage *CmdMsg)
{
    zOss_AssertExN(CmdMsg != NULL);

#ifdef _OS_TOS
    zOss_Printf(SUBMDL_TEST, PRINT_LEVEL_NORMAL, "\t%s:tosƽ̨ʵʹ", CmdMsg->cmd);
#endif

#ifdef _OS_OSE
    switch (CmdMsg->paraCount)
    {
    case 0:
        {
            zOss_Printf(SUBMDL_TEST, PRINT_LEVEL_NORMAL, "===============================================================================");
            list_all_sig_info();
            zOss_Printf(SUBMDL_TEST, PRINT_LEVEL_NORMAL, "===============================================================================");
            break;
        }
    default:
        {
            if (CmdMsg->paraCount == 1)
            {
                if (0 == strcmp((char *)CmdMsg->para[0], "help"))
                {
                    zOss_Printf(SUBMDL_TEST, PRINT_LEVEL_NORMAL, "\t%s : ʾ߳signalϢ", CmdMsg->cmd);
                    zOss_Printf(SUBMDL_TEST, PRINT_LEVEL_NORMAL, "\t %s  [thread_id]", CmdMsg->cmd);
                    zOss_Printf(SUBMDL_TEST, PRINT_LEVEL_NORMAL, "\t\t thread_idΪָ߳id,ָ,ʾ߳signalϢ");
                }
                else
                {
                    ZOSS_THREAD_ID pid = NULL;
                    if (-1 == Shell_StrisNumber(CmdMsg->para[0]))
                    {
                        zOss_Printf(SUBMDL_TEST, PRINT_LEVEL_NORMAL, "\tthread_idμ%s help\n", CmdMsg->cmd);
                        return;
                    }                         
                    pid = (ZOSS_THREAD_ID)strtoul((char *)CmdMsg->para[0], NULL, 0);
                    if (NULL == pid)
                    {
                        zOss_Printf(SUBMDL_TEST, PRINT_LEVEL_NORMAL, "\tthread_idμ%s help\n", CmdMsg->cmd);
                        return;
                    }

                    if (OSA_IdentifyThread(pid) != ZOSS_SUCCESS)
                    {
                        zOss_Printf(SUBMDL_TEST, PRINT_LEVEL_NORMAL, "\t:߳%#lx", pid);
                    }
                    else
                    {
                        list_proc_sig_info((PROCESS)pid, 1);
                    }
                }
            }
            else
            {
                zOss_Printf(SUBMDL_TEST, PRINT_LEVEL_NORMAL, "\t%s help鿴˵", CmdMsg->cmd);
            }
            break;
        }
    }
#endif

}

/**************************************************************************
* : OSS_OpenTraceSwitch
* ˵:     
*           (IN)  CmdMsg: shellϢָ
*           (OUT) 
*   ֵ: 
* ˵: 
**************************************************************************/
VOID OSS_OpenTraceSwitch(T_Shell_CommandMessage *CmdMsg)
{
#ifdef _OS_TOS
    zOss_AssertExN(CmdMsg != NULL);

    if(0 == strcmp(CmdMsg->para[0], "help") && CmdMsg->paraCount == 1)
    {
        zOss_Printf(SUBMDL_TEST, PRINT_LEVEL_NORMAL, "\t irq:򿪻߹رжͳƺ͸ٹ; thread: 򿪻ر̸߳ٹ;");
        zOss_Printf(SUBMDL_TEST, PRINT_LEVEL_NORMAL, "\t 0:رӦĹ, 1:ӦĹ;");
        zOss_Printf(SUBMDL_TEST, PRINT_LEVEL_NORMAL, "\t :openTraceSwitch irq 1openTraceSwitch irq 0򿪻߹رжͳƺ͸ٹ;");
        return;
    }

    if(CmdMsg->paraCount == 2 && -1 != Shell_StrisNumber(CmdMsg->para[1]))
    {
        UINT32 type = strtoul((char *)CmdMsg->para[1], NULL, 0);
        if(type == 0 || type == 1)
        {
            if(0 == strcmp(CmdMsg->para[0], "irq"))
            {
                Shell_SetIrqLogFlag(type);
                return;
            }            
            if(0 == strcmp(CmdMsg->para[0], "thread"))
            {
                Shell_SetThreadLogFlag(type);
                return;
            }
        }
    }
    zOss_Printf(SUBMDL_TEST, PRINT_LEVEL_NORMAL, "\t ;");
    zOss_Printf(SUBMDL_TEST, PRINT_LEVEL_NORMAL, "\t %s help鿴Ĺ;", CmdMsg->cmd);
#else
    zOss_Printf(SUBMDL_TEST, PRINT_LEVEL_NORMAL, "\t%s:ֻTOSƽ̨ʵʹ", CmdMsg->cmd);
#endif
}

/**************************************************************************
* : OSS_SetAssertLevel
* ˵:     
*           (IN)  CmdMsg: shellϢָ
*           (OUT) 
*   ֵ: 
* ˵: 
**************************************************************************/
VOID OSS_SetAssertLevel(T_Shell_CommandMessage *CmdMsg)
{
#ifdef _OS_TOS
    UINT32 level = 0;
    zOss_AssertExN(CmdMsg != NULL);
    
    if(0 == strcmp(CmdMsg->para[0], "help") && CmdMsg->paraCount == 1)
    {
        zOss_Printf(SUBMDL_TEST, PRINT_LEVEL_NORMAL, "\t ں˶Եȼ1: 2: һ 3: ;");
        return;
    }
    if ((CmdMsg->paraCount != 1) || (-1 == Shell_StrisNumber(CmdMsg->para[0])))
    {
        zOss_Printf(SUBMDL_TEST, PRINT_LEVEL_NORMAL, "\t ;");
        zOss_Printf(SUBMDL_TEST, PRINT_LEVEL_NORMAL, "\t %s help鿴Ĺ;", CmdMsg->cmd);
        return;
    }
    level = strtoul((char *)CmdMsg->para[0], NULL, 0);
    if(level >= 1 && level <= 3)
    {
        cyg_set_dbg_level(level);
        zOss_Printf(SUBMDL_TEST, PRINT_LEVEL_NORMAL, "\t%s:óɹ", CmdMsg->cmd);
    }
    else
    {
        zOss_Printf(SUBMDL_TEST, PRINT_LEVEL_NORMAL, "\t ;");
        zOss_Printf(SUBMDL_TEST, PRINT_LEVEL_NORMAL, "\t %s help鿴Ĺ;", CmdMsg->cmd);
    }
#else
    zOss_Printf(SUBMDL_TEST, PRINT_LEVEL_NORMAL, "\t%s:ֻTOSƽ̨ʵʹ", CmdMsg->cmd);
#endif
}

/**************************************************************************
* : OSS_DbgSuspendThread
* :
* ˵: (IN)
            CmdMsg:shell
            (OUT)
*   ֵ:
* ˵:
**************************************************************************/
VOID OSS_DbgSuspendThread(T_Shell_CommandMessage *CmdMsg)
{
    ZOSS_THREAD_ID  thread_id   = NULL;
    UINT32          result      = 0;
    UINT8           i           = 0;
   
    zOss_AssertExN(CmdMsg != NULL);
    
    switch (CmdMsg->paraCount)
    {
    case 0:
        {
            zOss_Printf(SUBMDL_TEST, PRINT_LEVEL_NORMAL, "\tsuspend_thread:no followed by thread_id!");
            break;
        }
    default:
        {
            if (CmdMsg->paraCount == 1 && 0 == strcmp((char *)CmdMsg->para[0], "help"))
            {
                zOss_Printf(SUBMDL_TEST, PRINT_LEVEL_NORMAL, "\tsuspend_thread:followed by the specified thread ID to suspend the thread!");
            }
            else
            {
                for (i = 0; i < CmdMsg->paraCount; i++)
                {
                    thread_id = (ZOSS_THREAD_ID)strtoul((char *)CmdMsg->para[i], NULL, 0);
                    
                    if (thread_id == NULL)
                    {
                        zOss_Printf(SUBMDL_TEST, PRINT_LEVEL_NORMAL, "\twrong thread_id!");
                        break;
                    }
                    if (OSA_IdentifyThread(thread_id) == ZOSS_ERROR)
                    {
                        zOss_Printf(SUBMDL_TEST, PRINT_LEVEL_NORMAL, "\twrong thread_id!");
                        break;
                    }

                    result = zOss_SuspendThread(thread_id);
                    
                    if (result != ZOSS_SUCCESS)
                    {
                        zOss_Printf(SUBMDL_TEST, PRINT_LEVEL_NORMAL, "\tSuspend Thread Fail!");
                    }
                    else
                    {
                        zOss_Printf(SUBMDL_TEST, PRINT_LEVEL_NORMAL, "\tSuspend Thread OK!");
                    }
                }
            }
            break;
        }
    }
}

/**************************************************************************
* : OSS_DbgResumeThread
* :
* ˵: (IN)
            CmdMsg:shell
            (OUT)
*   ֵ:
* ˵:
**************************************************************************/
VOID OSS_DbgResumeThread(T_Shell_CommandMessage *CmdMsg)
{
    ZOSS_THREAD_ID  thread_id   = NULL;
    UINT32          result      = 0;
    UINT8           i           = 0;
   
    zOss_AssertExN(CmdMsg != NULL);
    
    switch (CmdMsg->paraCount)
    {
    case 0:
        {
            zOss_Printf(SUBMDL_TEST, PRINT_LEVEL_NORMAL, "\tresum_thread:no followed by thread_id!");
            break;
        }
    default:
        {
            if (CmdMsg->paraCount == 1 && 0 == strcmp((char *)CmdMsg->para[0], "help"))
            {
                zOss_Printf(SUBMDL_TEST, PRINT_LEVEL_NORMAL, "\tresum_thread:followed by the specified thread ID to resume the thread!");
            }
            else
            {
                for (i = 0; i < CmdMsg->paraCount; i++)
                {
                    thread_id = (ZOSS_THREAD_ID)strtoul((char *)CmdMsg->para[i], NULL, 0);
                    
                    if (thread_id == NULL)
                    {
                        zOss_Printf(SUBMDL_TEST, PRINT_LEVEL_NORMAL, "\twrong thread_id!");
                        break;
                    }
                    if (OSA_IdentifyThread(thread_id) == ZOSS_ERROR)
                    {
                        zOss_Printf(SUBMDL_TEST, PRINT_LEVEL_NORMAL, "\twrong thread_id!");
                        break;
                    }

                    result = zOss_ResumeThread(thread_id);
                    
                    if (result != ZOSS_SUCCESS)
                    {
                        zOss_Printf(SUBMDL_TEST, PRINT_LEVEL_NORMAL, "\tResume Thread Fail!");
                    }
                    else
                    {
                        zOss_Printf(SUBMDL_TEST, PRINT_LEVEL_NORMAL, "\tResume Thread OK!");
                    }
                }
            }
            break;
        }
    }
}

/**************************************************************************
* : OSS_DbgSetThreadPri
* :
* ˵: (IN)
            CmdMsg:shell
            (OUT)
*   ֵ:
* ˵:
**************************************************************************/
VOID OSS_DbgSetThreadPri(T_Shell_CommandMessage *CmdMsg)
{
    ZOSS_THREAD_ID  thread_id   = NULL;
    UINT32          result      = 0;
    UINT32          pre_prio    = 0;
    UINT32          priority    = 0;
    
    zOss_AssertExN(CmdMsg != NULL);

    switch (CmdMsg->paraCount)
    {
    case 0:
        {
            zOss_Printf(SUBMDL_TEST, PRINT_LEVEL_NORMAL, "\tset_thread_pri:no followed by thread_id and priority!");
        }
        break;
    case 1:
        {
            if (CmdMsg->paraCount == 1 && 0 == strcmp((char *)CmdMsg->para[0], "help"))
            {
                zOss_Printf(SUBMDL_TEST, PRINT_LEVEL_NORMAL, "\tset_thread_pri:followed by the specified thread ID and priority to set priority of the thread!");
            }
        }
        break;
    default:
        {
            thread_id = (ZOSS_THREAD_ID)strtoul((char *)CmdMsg->para[0], NULL, 0);
            
            if (thread_id == NULL)
            {
                zOss_Printf(SUBMDL_TEST, PRINT_LEVEL_NORMAL, "\twrong thread_id!");
                break;
            }
#ifdef _OS_LINUX
            priority = strtoul((char *)CmdMsg->para[1], NULL, 0);
            if (priority > 99 || priority <= 0)
            {
                zOss_Printf(SUBMDL_TEST, PRINT_LEVEL_NORMAL, "\twrong priority! now can only set RT prio 1~99");
                break;
            }
            result = zOss_GetProcessPri((VOID *)thread_id, &pre_prio);
            if (result != ZOSS_SUCCESS)
            {
                zOss_Printf(SUBMDL_TEST, PRINT_LEVEL_NORMAL, "\twrong thread_id!");
            }
            result = zOss_SetProcessPri(thread_id, priority);
#else
            if (OSA_IdentifyThread(thread_id) != ZOSS_SUCCESS)
            {
                zOss_Printf(SUBMDL_TEST, PRINT_LEVEL_ABNORMAL, " The thread 0x%08x is not exist!",thread_id);
                break;
            }

            priority = strtoul((char *)CmdMsg->para[1], NULL, 0);
            if (priority > 31)
            {
                zOss_Printf(SUBMDL_TEST, PRINT_LEVEL_NORMAL, "\twrong priority!");
                break;
            }
            
            result = zOss_GetThreadPri(thread_id, &pre_prio);
            if (result != ZOSS_SUCCESS)
            {
                zOss_Printf(SUBMDL_TEST, PRINT_LEVEL_NORMAL, "\twrong thread_id!");
            }
            result = zOss_SetThreadPri(thread_id, priority);
#endif
            
            if (result == ZOSS_SUCCESS)
            {
                zOss_Printf(SUBMDL_TEST, PRINT_LEVEL_NORMAL, "\tPrior Set From %u to %u OK!",  pre_prio, priority);
            }
            else
            {
                zOss_Printf(SUBMDL_TEST, PRINT_LEVEL_NORMAL, "\tPrior Set  From %u to %u Fail!", pre_prio, priority);
            }
        }
        break;
    }
}

/**************************************************************************
* : OSA_ForceRamdump
* : ǿƲ쳣,Աramdump
* ˵: (IN)
            CmdMsg:shell
            (OUT)
*   ֵ:
* ˵:
**************************************************************************/
VOID OSA_ForceRamdump(T_Shell_CommandMessage *CmdMsg)
{
    UINT32 ret = 0;
    
    zOss_AssertExN(CmdMsg != NULL);

    if (1 == CmdMsg->paraCount)
    {
        if (0 == strcmp((char *)CmdMsg->para[0], "help"))
        {
#ifdef _USE_MULTI_CORE_RAMDUMP
#ifdef _USE_ARM1_RAMDUMP
            zOss_Printf(SUBMDL_TEST, PRINT_LEVEL_NORMAL, "\t0:serverǿ, ֵ:clientǿ(NclientӦ1:N),Arm1Ӧ255");
#else
            zOss_Printf(SUBMDL_TEST, PRINT_LEVEL_NORMAL, "\t0:serverǿ, ֵ:clientǿ(NclientӦ1:N)");
#endif
#else
            zOss_Printf(SUBMDL_TEST, PRINT_LEVEL_NORMAL, "\t0:ARM쳣 1: 쳣 2: ϵͳ쳣");
#endif
            return;
        }
        
        if (-1 == Shell_StrisNumber(CmdMsg->para[0]))
        {
            zOss_Printf(SUBMDL_TEST, PRINT_LEVEL_NORMAL, "\thelpѯ÷");
            return;
        }
            
        ret = strtoul((char *)CmdMsg->para[0], NULL, 0);
#ifdef _USE_MULTI_CORE_RAMDUMP
        if(ret == 0)
        {
            zOss_AssertExN(FALSE);
        }
        else
        {            
            ret = zOss_RamdumpForceClientException(ret);
            if(ret != ZOSS_SUCCESS)
               zOss_Printf(SUBMDL_TEST, PRINT_LEVEL_NORMAL, "\thelpѯ÷");
        }
#else
        if(ret <= 2)
        {
            zOss_RamdumpForceException(ret);
        }
        else
        {
            zOss_Printf(SUBMDL_TEST, PRINT_LEVEL_NORMAL, "\thelpѯ÷");
        }
#endif
    }
    else
    {
        zOss_Printf(SUBMDL_TEST, PRINT_LEVEL_NORMAL, "\thelpѯ÷");
    }
}

/**************************************************************************
* : OSA_DbgTrace
* : 鿴ģϢ
* ˵: (IN)
            CmdMsg:shell
            (OUT)
*   ֵ: VOID
* ˵: VOID
**************************************************************************/
VOID OSA_DbgTrace(T_Shell_CommandMessage *CmdMsg)
{
    zOss_AssertExN(CmdMsg != NULL);

    switch (CmdMsg->paraCount)
    {
    case 1:
        {
            if (strcmp((const char *)CmdMsg->para[0], "init") == 0)
            {
                zOss_TraceFuncInit();
                zOss_Printf(SUBMDL_TEST, PRINT_LEVEL_NORMAL, "\ttraceٹܳʼɹ");                
            }
            else if (strcmp((const char *)CmdMsg->para[0], "info") == 0)
            {
                zOss_TraceFuncInfo(NULL);
            }
            else if (strcmp((const char *)CmdMsg->para[0], "help") == 0)
            {
                zOss_Printf(SUBMDL_TEST, PRINT_LEVEL_NORMAL, "\ttrace:鿴ģϢ");
                zOss_Printf(SUBMDL_TEST, PRINT_LEVEL_NORMAL, "\tʼٱ־λ trace init");
                zOss_Printf(SUBMDL_TEST, PRINT_LEVEL_NORMAL, "\t鿴ٺϢ trace info [funcname]");
                zOss_Printf(SUBMDL_TEST, PRINT_LEVEL_NORMAL, "\tfuncnameΪ");
            }
            else
            {
                zOss_Printf(SUBMDL_TEST, PRINT_LEVEL_NORMAL, "\thelpѯ÷");
            }
            break;
        }
    case 2:
        {
            if (strcmp((const char *)CmdMsg->para[0], "info") == 0)
            {
                zOss_TraceFuncInfo(CmdMsg->para[1]);
            }
            else
            {
                zOss_Printf(SUBMDL_TEST, PRINT_LEVEL_NORMAL, "\thelpѯ÷");
            }
            break;
        }
    default:
        {
            zOss_Printf(SUBMDL_TEST, PRINT_LEVEL_NORMAL, "\thelpѯ÷");
            break;
        }
    }
}

#ifdef __cplusplus
}
#endif

