/*******************************************************************************
* Ȩ (C)2015, ͨѶɷ޹˾
* 
* ļ:     linux_mpu.c
* ļʶ:     linux_mpu.c
* ժҪ:     Linuxڴ汣Ԫ(MPU)ùģ
* 
* ޸        汾      ޸ı        ޸          ޸
* ------------------------------------------------------------------------------
* 2015/01/06      V1.0        Create                    
* 
*******************************************************************************/

/*******************************************************************************
*                                   ͷļ                                     *
*******************************************************************************/
#include <linux/kernel.h>

#ifdef CONFIG_ARM_MPU

#include <asm/mpu.h>
#include "ram_config.h"

#ifdef __cplusplus
extern "C" {
#endif

/*******************************************************************************
*                                ⲿ                                  *
*******************************************************************************/

/*******************************************************************************
*                                ⲿ                                  *
*******************************************************************************/

/*******************************************************************************
*                                                                      *
*******************************************************************************/

/*******************************************************************************
*                                   궨                                     *
*******************************************************************************/

/*******************************************************************************
*                                Ͷ                                  *
*******************************************************************************/

/*******************************************************************************
*                                ֲ                                  *
*******************************************************************************/

/*******************************************************************************
*                              ֲ̬                                *
*******************************************************************************/

/*******************************************************************************
*                                ȫֱ                                  *
*******************************************************************************/

linux_mpu_config_t linux_mpu_config[MPU_USER_REGION_NR] = 
{
    {
        "tool_buffer_1M",
        DDR_BASE_ADDR_TOOL_AGENT,
        0x00100000,
        MPU_AP_PL1RW_PL0RW | MPU_RGN_NORMAL,
    },

    {
        "tool_buffer_2M",
        DDR_BASE_ADDR_TOOL_AGENT + 0x00100000,
        0x00200000,
        MPU_AP_PL1RW_PL0RW | MPU_RGN_NORMAL,
    },

    {
        "tool_buffer_0.5M",
        DDR_BASE_ADDR_TOOL_AGENT + 0x00300000,
        0x00080000,
        MPU_AP_PL1RW_PL0RW | MPU_RGN_NORMAL,
    },

#ifdef _USE_RF_SP_LTEA
    {
        "ps_buffer_1",
        DDR_BASE_ADDR_PSBUF,
        0x100000,
        MPU_AP_PL1RW_PL0RW | MPU_RGN_NORMAL,
    },
	
    {
        "ps_buffer_2",
        DDR_BASE_ADDR_PSBUF + 0x100000,
        0x200000,
        MPU_AP_PL1RW_PL0RW | MPU_RGN_NORMAL,
    },

    {
        "ps_buffer_3",
        DDR_BASE_ADDR_PSBUF + 0x300000,
        0x400000,
        MPU_AP_PL1RW_PL0RW | MPU_RGN_NORMAL,
    },
#else
    {
        "ps_buffer_1",
        DDR_BASE_ADDR_PSBUF,
        0x400000,
        MPU_AP_PL1RW_PL0RW | MPU_RGN_NORMAL,
    },
	
    {
        "ps_buffer_2",
        DDR_BASE_ADDR_PSBUF + 0x400000,
        0x200000,
        MPU_AP_PL1RW_PL0RW | MPU_RGN_NORMAL,
    },

    {
        "ps_buffer_3",
        DDR_BASE_ADDR_PSBUF + 0x600000,
        0x100000,
        MPU_AP_PL1RW_PL0RW | MPU_RGN_NORMAL,
    },
#endif

    {
        "dtcm",
        0x00200000,
        0x8000,
        MPU_AP_PL1RW_PL0RW | MPU_ACR_XN | MPU_RGN_NORMAL_NON_CACHEABLE,
    },

    {
        "itcm",
        0x00220000,
        0x10000,
        MPU_AP_PL1RW_PL0RW | MPU_RGN_NORMAL_NON_CACHEABLE,
    },
};

/*******************************************************************************
*                                ֲʵ                                  *
*******************************************************************************/

/*******************************************************************************
*                                ȫֺʵ                                  *
*******************************************************************************/

#ifdef __cplusplus
}
#endif

#endif
