# /*****************************************************************************
#* Ȩ (C)2011, ͨѶɷ޹˾
#* 
#* ļ:     tos_link.mk
#* ļʶ:     tos_link.mk
#* ժҪ:     tosӦóļ
#* ʹ÷:     include tos_link.mk
#* 
#* ޸     汾  ޸ı    ޸      ޸
#* -----------------------------------------------------------------------------
#* 2011/01/06   V1.0    Create            
#* 2011/07/13   V1.1    USE_L1G           ⲿĽ´
#* 2012/02/25   V1.2    Modify            Կļзűѭҹ
#* 
# *****************************************************************************/

#===============================================================================
#ͷļ
#===============================================================================
include $(PRJ_PATH)/config/project.mk

#===============================================================================
#ѹر
#===============================================================================
ifeq ($(USE_COMPRESSED), yes)
export COMPRESSED_BIN_PATH = $(BIN_PATH)/compressed

COMPRESSED_OBJS            = $(TOS_LIB)/compressed/head.o \
                             $(OBJ_PATH)/os/tos/compressed/compressed.o
COMPRESSED_LIBS            = $(TOS_LIB)/compressed/libgzip.a
COMPRESSED_LDFLAG          = -Wl,--no-check-sections -nostartfiles -L$(GCC_LIB) -T$(PRJ_PATH)/config/os/tos/tos_compressed.ld
COMPRESSED_GLOBAL_LDFLAGS  = $(TOS_GLOBAL_LDFLAGS) -Wl,-Map,$(COMPRESSED_BIN_PATH)/$(BIN_NAME).map

COMPRESSED_IMAGE_START ?= 0x25400000
endif

#===============================================================================
#Ŀļ
#===============================================================================
OBJECTS = $(wildcard $(OBJ_PATH)/os/tos/*.o)

#===============================================================================
#Ŀļ
#===============================================================================
LIBS =     $(wildcard $(LIB_PATH)/drv/bsp/*.o)   \
           $(wildcard $(LIB_PATH)/drv/*.a)       \
           $(wildcard $(LIB_PATH)/appstart/*.a)  \
           $(wildcard $(LIB_PATH)/plat/*.a)      \
           $(wildcard $(LIB_PATH)/tools/*.a)     \
           $(wildcard $(LIB_PATH)/net/net.a)     \
           $(wildcard $(LIB_PATH)/phy/phy.a)     \
           $(wildcard $(LIB_PATH)/usat/usat.a)   \
           $(wildcard $(LIB_PATH)/ps/ps.a)       \
           $(wildcard $(LIB_PATH)/psbase/base.a) \
           $(wildcard $(LIB_PATH)/ps/ati.a)

LIBS += $(wildcard $(AMT_LIB_PATH)/*.a)

ifeq ($(USE_L1G), yes)
LIBS += $(wildcard $(LIB_PATH)/gsml1/*.lib)
endif

LIBS += $(PRODUCT_LIBS)

LIBS += $(wildcard $(SOFTAP_LIB_PATH)/*.a)

#===============================================================================
#ⲿļ
#===============================================================================
ifeq ($(USE_L1G), yes)
EXT_LIBS        = $(wildcard $(GSML1_PATH)/lib/*.lib)
else
EXT_LIBS        = ''
endif

ifneq ($(EXT_LIBS), '')
EXT_TOTAL_LIB   = ext_total_lib.a
else
EXT_TOTAL_LIB   = 
endif


#===============================================================================
#ִļ
#===============================================================================
#BIN_NAME = $(PRJ_NAME)
IMAGE_LOAD ?= 0x23A00000
export IMAGE_START = $(IMAGE_LOAD)

#===============================================================================
#Mapļ
#===============================================================================
TOS_GLOBAL_LDFLAGS += -Wl,-Map,$(BIN_PATH)/$(BIN_NAME).map

#===============================================================================
#Ŀϵ
#===============================================================================
tos_app: $(BIN_PATH)/$(BIN_NAME).elf $(BIN_PATH)/$(BIN_NAME).bin

tos_app_clean: 
	@$(RM) -rf $(BIN_PATH)/$(BIN_NAME).*
	@$(RM) -rf $(OBJ_PATH)/os/tos/*.o
	@$(RM) -rf $(OBJ_PATH)/os/tos/*.a
ifeq ($(USE_COMPRESSED), yes)
	@$(GNUMAKE) --no-print-directory -C $(TOS_PATH)/src/compressed/ws clean FLAVOR=$(FLAVOR)
endif

$(EXT_TOTAL_LIB): $(EXT_LIBS)
	@$(foreach lib, $(EXT_LIBS), $(shell $(AR) -x $(lib)))
	@$(AR) $(ARFLAGS) $@ ./*.o
	@$(RM) ./*.o

$(BIN_PATH)/$(BIN_NAME).elf : $(OBJECTS) $(LIBS)
	@$(ECHO) "--- Linking $@"
	@-$(MKDIR) $(BIN_PATH)
	@$(CC) -o $@ $(OBJECTS) -Wl,--start-group $(LIBS) -Wl,--end-group $(LDFLAG) $(TOS_GLOBAL_LDFLAGS)

$(BIN_PATH)/$(BIN_NAME).bin : $(BIN_PATH)/$(BIN_NAME).elf
	@$(ECHO) "--- Generating binary $@"
	@-$(MKDIR) $(BIN_PATH)
	@$(ELF2BIN) $(ELF2BINOUT) $< $@
ifeq ($(USE_COMPRESSED), yes)
	@$(ECHO) "--- Start Compress"
	@-$(MKDIR) $(COMPRESSED_BIN_PATH)
	@-$(GZIP1) -n $@ > $(COMPRESSED_BIN_PATH)/compressed.gz
	@$(ECHO) "--- Compressed!"
	@$(GNUMAKE) --no-print-directory -C $(TOS_PATH)/src/compressed/ws clean FLAVOR=$(FLAVOR)
	@$(GNUMAKE) --no-print-directory -C $(TOS_PATH)/src/compressed/ws lib FLAVOR=$(FLAVOR)
	@$(CC) -o $(COMPRESSED_BIN_PATH)/$(BIN_NAME).elf $(COMPRESSED_OBJS) -Wl,--start-group $(COMPRESSED_LIBS) -Wl,--end-group $(COMPRESSED_LDFLAG) $(COMPRESSED_GLOBAL_LDFLAGS)
	@$(ELF2BIN) $(ELF2BINOUT) $(COMPRESSED_BIN_PATH)/$(BIN_NAME).elf $(COMPRESSED_BIN_PATH)/$(BIN_NAME).bin
	@$(MKIMAGE) -A arm -O TOS -T kernel -C none -a $(COMPRESSED_IMAGE_START) -e $(COMPRESSED_IMAGE_START) -n '$(BIN_NAME) Image' -d $(COMPRESSED_BIN_PATH)/$(BIN_NAME).bin $(BIN_PATH)/$(BIN_NAME).img
	@$(ECHO) "--- Generating flash image $(BIN_PATH)/$(BIN_NAME).img"
	@$(RM) $(BIN_PATH)/$(BIN_NAME).bin
	@$(RM) -rf $(COMPRESSED_BIN_PATH)
endif
ifeq ($(USE_COMPRESSED), no)
	@$(MKIMAGE) -A arm -O TOS -T kernel -C none -a $(IMAGE_LOAD) -e $(IMAGE_START) -n '$(BIN_NAME) Image' -d $@ $(BIN_PATH)/$(BIN_NAME).img
	@$(ECHO) "--- Generating flash image $(BIN_PATH)/$(BIN_NAME).img"
	@$(RM) $(BIN_PATH)/$(BIN_NAME).bin
endif
ifeq ($(CONFIG_SIGN_IMAGE), yes)
	@$(SIGN) -s $(BIN_PATH)/$(BIN_NAME).img $(BIN_PATH)/$(BIN_NAME).img $(PRIVATE_KEY_PATH)
endif

