# /*****************************************************************************
#* Ȩ (C)2015, ͨѶɷ޹˾
#* 
#* ļ:     tos_pub_cfg.mk
#* ļʶ:     tos_pub_cfg.mk
#* ժҪ:     TOSļ
#* ʹ÷:     include project.mk
#* 
#* ޸        汾      ޸ı        ޸          ޸
#* -----------------------------------------------------------------------------
#* 2015/05/20      V1.0                              
#* 
# ******************************************************************************/

#====================================================
#CPU: armv5/armv6/armv6-m/armv7-r/armv7-a/ck610
#====================================================
export CPU_ARCH = armv7-a

#====================================================
#: rvct/gcc_arm/gcc_csky
#====================================================
export CMPL_TYPE ?= gcc_arm

#====================================================
#ϵͳ: ose/tos
#====================================================
export OSTYPE ?= tos

#====================================================
# 
#====================================================
export HOST       = win32
export VERBOSE    = no
export LINTCHK    = no

ifeq ($(CMPL_TYPE),rvct)
ifeq ($(OSTYPE),ose)
export COMPILER   = rvct.mk
else
export COMPILER   = rvct_tos.mk
endif
export USE_CMPL   = RVCT
endif
ifeq ($(CMPL_TYPE),gcc_arm)
export COMPILER   = gcc_arm.mk
export USE_CMPL   = GCC
endif
ifeq ($(CMPL_TYPE),gcc_csky)
export COMPILER   = gcc_csky.mk
export USE_CMPL   = GCC
endif

#====================================================
#ϵͳ
#====================================================
INCLUDE           =
STDINCLUDE        =
DEFINE            =
LDFLAGS           =

include $(PRJ_PATH)/config/pub/product_cfg.mk

#====================================================
#OS
# ose/tos
#====================================================
#OSE
ifeq ($(OSTYPE), ose)
include $(PRJ_PATH)/config/os/ose/ose.mk
endif

ifeq ($(OSTYPE), tos)
include $(PRJ_PATH)/config/os/tos/tos.mk
endif

#====================================================
#
# rvct/gcc_arm/ads
#====================================================
ifeq ($(COMPILER),rvct.mk)
include $(FRAME_PATH)/compiler/rvct.mk
endif
ifeq ($(COMPILER),rvct_tos.mk)
include $(FRAME_PATH)/compiler/rvct_tos.mk
endif
ifeq ($(COMPILER),gcc_arm.mk)
include $(FRAME_PATH)/compiler/gcc_arm_tos.mk
endif
ifeq ($(COMPILER),gcc_csky.mk)
include $(FRAME_PATH)/compiler/gcc_csky.mk
endif

#====================================================
# ƽ̨
#====================================================
ifeq ($(FLAVOR),debug)
DEFINE += -D_DEBUG
else
DEFINE += -D_RELEASE
endif
ifeq ($(VERBOSE), yes)
VERB=
else
VERB=@
endif

#====================================================
#LINT
#====================================================
ifeq ($(LINTCHK),yes)
export PCLINT = $(LINT_ROOT)/lint-nt
export LINTOPTION = -zero -i$(LINT_ROOT) std.lnt 
export LINTFLAG = 
endif
LINT=$(LINT_ROOT)/lint-nt


ifeq ($(COMPILER),rvct.mk)
_COMPILER_TYPE = rvct
endif

