/*******************************************************************************
 * Copyright (C) 2014, ZTE Corporation.
 *
 * File Name:	 hal_pm_wrapper.c
 * File Mark:
 * Description:
 * Others:
 * Version: 	  V1.0
 * Author:		  yx
 * Date:		  2011-11-11
 * History 1:
 *	   Date:
 *	   Version:
 *	   Author:
 *	   Modification:
 * History 2:
  ********************************************************************************/

/****************************************************************************
*											   Include files
****************************************************************************/
#include "drvs_general.h"
#include "drvs_ret.h"
#include "drvs_pmic.h"
#include "drvs_gpio.h"
#include "drvs_comm.h"
#include "drvs_ref_cfg.h"

/****************************************************************************
*											   Local Macros
****************************************************************************/

/****************************************************************************
*											   Local Types
****************************************************************************/

/****************************************************************************
*											   Local Constants
****************************************************************************/

/****************************************************************************
*											   Local Function Prototypes
****************************************************************************/

/****************************************************************************
*											  Global Constants
****************************************************************************/

/****************************************************************************
*											  Global Variables
****************************************************************************/
static T_ZDrvPmic_Opt s_pmicOpt =
    {
        zDrvZx234290_LdoInit,
    };
UINT32 g_pmicPsholdPin = NULL;
/****************************************************************************
*											  Function Definitions
****************************************************************************/
/*******************************************************************************
* Function:
* Description:
* Parameters:
*	 Input:
*
*	 Output:
*
* Returns:
*
*
* Others:
    No Module | Name | Default Voltage | Current Rating | Programmable Voltage | Power Pin /Power Domain Type | Default On/off Status
    2 BUCK1 0.9V 2.5A Group VBA PVCC1 / VBAT BUCK (DVS) on
    3 BUCK2 1.2V 1A Group VBC PVCC2 / VBAT BUCK on
    4 BUCK3 1.6V 1A External Adjustable, 0.9V~3.3V PVCC3 / VBAT BUCK on
    5 BUCK4 3.6V* 3A External Adjustable, > 0.8V PVCC4 / VBAT RF-DCDC on

    1 LDO1 0.9V 250mA Group VLA VINLA BUCK2 / VBAT N Digital LDO on
    2 LDO2 1.8V 300mA Group VLA VINLC BUCK4 / VBAT Digital LDO on
    3 LDO3 1.8V 150mA Group VLA VINLB BUCK4 / VBAT Analog LDO on
    4 LDO4 2.85V 100mA Group VLD VINLB BUCK4 / VBAT Analog LDO on
    5 LDO5 3.3V 100mA Fixed VBUS VBUS/VBAT Digital LDO on VBUS
    6 LDO6 1.8 100mA Group VLD VINLC BUCK4/VBAT Digital LDO off
    7 LDO7 2.85V 300mA Group VLD VINLB BUCK4 / VBAT Analog LDO on
    8 LDO8 2.85V 300mA Group VLD VINLC BUCK4 / VBAT Digital LDO on
    9 LDO9 1.8 200mA Group VLD VINLC BUCK4/VBAT Digital LDO off
    10 LDO10 2.8V 250mA Group VLA VINLA BUCK2 / VBAT N Analog LDO on
    12 VCOIN 3.0V 10mA Group VLB BATT VBAT Analog LDO on
********************************************************************************/
UINT8 reg_val = 0 ;
SINT32 zDrvZx234290_LdoInit(VOID)
{
    zDrvZx234290_Config();
	zDrvZx234290_LdoRstErr();

    Zx234290_SetVbuck1ActiveMode(BUCK_NRM_FORCE_PWM);
    Zx234290_SetVbuck2ActiveMode(BUCK_NRM_FORCE_PWM);
    /*buck3 force pwm*/
	Zx234290_SetVbuck3ActiveMode(BUCK_NRM_FORCE_PWM);
	/* buck4 */
	Zx234290_SetVbuck4ActiveMode(BUCK_NRM_FORCE_PWM);

    /*testing...*/
    #if 0
    Zx234290_SetVldo6Onoff(LDO_ENABLE_OFF);
    Zx234290_SetVldo6Onoff(LDO_ENABLE_ON);

    Zx234290_SetVldo6Onoff(LDO_ENABLE_OFF);
    Zx234290_SetVldo6Onoff(LDO_ENABLE_ON);

    Zx234290_SetVldo6(VLDOD_1_800);
    Zx234290_SetVldo6(VLDOD_2_800);

    Zx234290_SetVldo6(VLDOD_1_800);
    Zx234290_SetVldo6(VLDOD_2_800);
    #endif

	zDrvZx234290_DischargerConfig();

	zDrvZx234290_SleepConfig();

    //zDrvZx234290_DebugConfig();
    Zx234290_SetLlpEnable(LLP_ENABLE);
    Zx234290_SetTllpToDo(LLP_SHUTDOWN);
    Zx234290_SetRestartDly(LLP_DLY_500MS);  //LLP_DLY_250MS

    #if 0
	UINT8 slv_addr=0, reg_addr=0, /*reg_val=0, */reg_val_write;

    //read and wirte mask
    slv_addr = ZX234290_I2C_SLAVE_ADDR0;
    reg_addr = ZX234290_REG_ADDR_INTA_MASK;
    zDrvPmic_I2cRead(slv_addr, reg_addr, &reg_val);
    zDrvPmic_SetRegister(slv_addr, reg_addr, 0x28, 0xFF);
	zDrvPmic_I2cRead(slv_addr, reg_addr, &reg_val);

	//rtc sec reg test
	slv_addr = ZX234290_I2C_SLAVE_ADDR0;
    reg_addr = ZX234290_REG_ADDR_SECONDS;
	zDrvPmic_I2cRead(slv_addr, reg_addr, &reg_val);

    zDrvPmic_SetRegister(slv_addr, reg_addr, 30, 0xFF);

	zDrvPmic_I2cRead(slv_addr, reg_addr, &reg_val);


    //ldo1 on/off
    Zx234290_SetVldo1(VLDOA_0_800);
    Zx234290_SetVldo1(VLDOA_0_900);
	Zx234290_SetVldo1Onoff(LDO_ENABLE_ON);
	Zx234290_SetVldo1Onoff(LDO_ENABLE_OFF);
	Zx234290_SetVldo1Onoff(LDO_ENABLE_ON);

    //ldo2 on/off
    Zx234290_SetVldo2(VLDOC_1_500);
    Zx234290_SetVldo2(VLDOC_1_800);
	Zx234290_SetVldo2Onoff(LDO_ENABLE_ON);
	Zx234290_SetVldo2Onoff(LDO_ENABLE_OFF);
	Zx234290_SetVldo2Onoff(LDO_ENABLE_ON);

    //ldo3 on/off
    Zx234290_SetVldo3(VLDOC_1_500);
    Zx234290_SetVldo3(VLDOC_1_800);
	Zx234290_SetVldo3Onoff(LDO_ENABLE_ON);
	Zx234290_SetVldo3Onoff(LDO_ENABLE_OFF);
	Zx234290_SetVldo3Onoff(LDO_ENABLE_ON);

    //ldo4 on/off
    Zx234290_SetVldo4(VLDOD_2_700);
    Zx234290_SetVldo4(VLDOD_2_850);
	Zx234290_SetVldo4Onoff(LDO_ENABLE_ON);
	Zx234290_SetVldo4Onoff(LDO_ENABLE_OFF);
	Zx234290_SetVldo4Onoff(LDO_ENABLE_ON);

    //ldo5 on/off
    Zx234290_SetVldo5(VLDOB_3_000);
    Zx234290_SetVldo5(VLDOB_3_300);
	Zx234290_SetVldo5Onoff(LDO_ENABLE_ON);
	Zx234290_SetVldo5Onoff(LDO_ENABLE_OFF);
	Zx234290_SetVldo5Onoff(LDO_ENABLE_ON);


	//ldo6 on/off
	Zx234290_SetVldo6Onoff(LDO_ENABLE_ON);
	Zx234290_SetVldo6Onoff(LDO_ENABLE_OFF);

	Zx234290_SetVldo6(VLDOD_1_800);
	Zx234290_SetVldo6Onoff(LDO_ENABLE_ON);
	Zx234290_SetVldo6(VLDOD_2_000);

    //ldo7 on/off
    Zx234290_SetVldo7(VLDOD_2_700);
    Zx234290_SetVldo7(VLDOD_2_850);
	Zx234290_SetVldo7Onoff(LDO_ENABLE_ON);
	Zx234290_SetVldo7Onoff(LDO_ENABLE_OFF);
	Zx234290_SetVldo7Onoff(LDO_ENABLE_ON);

    //ldo8 on/off
	Zx234290_SetVldo8Onoff(LDO_ENABLE_ON);
	Zx234290_SetVldo8Onoff(LDO_ENABLE_OFF);

	Zx234290_SetVldo8(VLDOD_1_800);
	Zx234290_SetVldo8Onoff(LDO_ENABLE_ON);
	Zx234290_SetVldo8(VLDOD_2_800);

    //ldo9 on/off
    Zx234290_SetVldo9(VLDOA_0_800);
    Zx234290_SetVldo9(VLDOA_0_900);
	Zx234290_SetVldo9Onoff(LDO_ENABLE_ON);
	Zx234290_SetVldo9Onoff(LDO_ENABLE_OFF);
	Zx234290_SetVldo9Onoff(LDO_ENABLE_ON);

    //ldo10 on/off
    Zx234290_SetVldo10(VLDOA_0_800);
    Zx234290_SetVldo10(VLDOA_0_900);
	Zx234290_SetVldo10Onoff(LDO_ENABLE_ON);
	Zx234290_SetVldo10Onoff(LDO_ENABLE_OFF);
	Zx234290_SetVldo10Onoff(LDO_ENABLE_ON);

    //buck1
    Zx234290_SetVbuck1(VBUCKA_0_800);
    Zx234290_SetVbuck1(VBUCKA_0_900);

    Zx234290_SetVbuck2(VBUCKC_1_100);
    Zx234290_SetVbuck2(VBUCKC_1_200);

    Zx234290_SetVbuck1Onoff(LDO_ENABLE_OFF);
    Zx234290_SetVbuck2Onoff(LDO_ENABLE_OFF);


#endif


	return DRV_SUCCESS;
}

/*******************************************************************************
* Function:
* Description: pmu config, such as pshold...
* Parameters:
*	 Input:
*
*	 Output:
*
* Returns:
*
*
* Others:
********************************************************************************/
SINT32 zDrvZx234290_Config(VOID)
{
	SINT32	ret = 0;

    /*ps hold config*/
    g_pmicPsholdPin = zDrvGpio_Request("pmic_pshold_1");
    if( g_pmicPsholdPin == NULL )
        return DRV_ERROR;

    //ret = zDrvGpio_SetFunc(g_pmicPsholdPin, AON_FUNC_SEL,0);
    if( ret != DRV_SUCCESS )
        return DRV_ERROR;

    zDrvGpio_SetDirection(g_pmicPsholdPin, PSHOLD1_PIN_GPIO_DIRECTION);  //set output;v3 gpio24(pshold) direction is reverse
    if( ret != DRV_SUCCESS )
        return DRV_ERROR;

    //ret = zDrvGpio_SetValue(g_pmicPsholdPin, GPIO_HIGH);
    if( ret != DRV_SUCCESS )
        return DRV_ERROR;

    //zDrvPmic_SetOpt(&s_pmicOpt);

    return DRV_SUCCESS;
}

/*******************************************************************************
* Function:
* Description: debug info init
* Parameters:
*	 Input:
*
*	 Output:
*
* Returns:
*
*
* Others:
********************************************************************************/
SINT32 zDrvZx234290_DischargerConfig(VOID)
{
    SINT32 nRet = DRV_SUCCESS;
    UINT32 index = 0 ;

    /*enable all discharger*/
    for(index = DISCHARGER_LDO_9; index < DISCHARGER_MAX; index++)
    {
        if(index == DISCHARGER_BUCK_X || index == DISCHARGER_LDO_X)
            continue;
        nRet = Zx234290_SetDischarger(index, DISCHARGER_ENABLE);
    	if (DRV_SUCCESS != nRet)
    	{
    		return DRV_ERROR;
    	}
    }
    /*config, buck0 discharger disable*/
    /*
    nRet = Zx234290_SetDischarger(DISCHARGER_BUCK_0, DISCHARGER_DISBALE);
    if (DRV_SUCCESS != nRet)
    {
    	return DRV_ERROR;
    }*/

    return DRV_SUCCESS;
}

static SINT32 zDrvZx234290_NormalSleepConfig(VOID)
{
	SINT32 nRet = DRV_SUCCESS;

	/* if chg_pwron, this bucks will be closed, we open them again when system reset... */
    //Zx234290_SetVbuck3Onoff(LDO_ENABLE_ON);        /*RF 1V6*/
    Zx234290_SetVbuck4Onoff(LDO_ENABLE_ON);        /*PA 3V6*/
    //Zx234290_SetVldo8Onoff(LDO_ENABLE_ON);         /*ZSP JTAG/SD 2V85*/
	//Zx234290_SetVldo6Onoff(LDO_ENABLE_ON);         /*SIM1 1V8ﲻÿSIMԼӰʱ*/
	Zx234290_SetVldo10Onoff(LDO_ENABLE_ON);        /*adc0.9v/dac0.9v/avdd_pll0.9v/avdd_abb0.9v*/
    Zx234290_SetVldo1Onoff(LDO_ENABLE_ON);         /*USB 0V9*/
    Zx234290_SetVldo5Onoff(LDO_ENABLE_ON);         /*USB 3V3*/
	
	//nRet = Zx234290_SetBUCK1SleepMode(BUCK1_SLP_AUTO_ECO_SLP);
	nRet = Zx234290_SetBUCK1SleepMode(BUCK1_SLP_SHUTDOWN);
	if (DRV_SUCCESS != nRet)
	{
		return DRV_ERROR;
	}

    nRet = Zx234290_SetBUCK2SleepMode(BUCK234_SLP_ECO_WITH_ECO);
	if (DRV_SUCCESS != nRet)
	{
		return DRV_ERROR;
	}
	//nRet = Zx234290_SetBUCK3SleepMode(BUCK234_SLP_ECO_WITH_ECO);
	nRet = Zx234290_SetBUCK3SleepMode(BUCK234_SLP_SHUTDOWN);
	if (DRV_SUCCESS != nRet)
	{
		return DRV_ERROR;
	}

	nRet = Zx234290_SetBUCK4SleepMode(BUCK234_SLP_SHUTDOWN);
	if (DRV_SUCCESS != nRet)
	{
		return DRV_ERROR;
	}
	nRet = Zx234290_SetLDO2SleepMode(LDOA_SLP_ECO_VOLT);
	if (DRV_SUCCESS != nRet)
	{
		return DRV_ERROR;
	}
	nRet = Zx234290_SetLDO3SleepMode(LDOA_SLP_ECO_VOLT);
	if (DRV_SUCCESS != nRet)
	{
		return DRV_ERROR;
	}

	nRet = Zx234290_SetLDO4SleepMode(LDOB_SLP_SHUTDOWN);
	if (DRV_SUCCESS != nRet)
	{
		return DRV_ERROR;
	}

	nRet = Zx234290_SetLDO6SleepMode(LDOB_SLP_ECO_VOLT);
	if (DRV_SUCCESS != nRet)
	{
		return DRV_ERROR;
	}

	nRet = Zx234290_SetLDO7SleepMode(LDOA_SLP_ECO_VOLT);
	if (DRV_SUCCESS != nRet)
	{
		return DRV_ERROR;
	}

	nRet = Zx234290_SetLDO8SleepMode(LDOA_SLP_ECO_VOLT);//עͺŻܹ
	if (DRV_SUCCESS != nRet)
	{
		return DRV_ERROR;
	}

	nRet = Zx234290_SetLDO9SleepMode(LDOA_SLP_ECO_VOLT);
	if (DRV_SUCCESS != nRet)
	{
		return DRV_ERROR;
	}

    nRet = Zx234290_SetLDO10SleepMode(LDOA_SLP_ECO_VOLT);
	if (DRV_SUCCESS != nRet)
	{
		return DRV_ERROR;
	}

	return DRV_SUCCESS;
}

/* for chaging power on */
static SINT32 zDrvZx234290_ChgOnSleepConfig(VOID)
{
    //Zx234290_SetVbuck3Onoff(LDO_ENABLE_OFF);        /*RF 1V6*/
    Zx234290_SetVbuck4Onoff(LDO_ENABLE_OFF);        /*PA 3V6*/
    //Zx234290_SetVldo1Onoff(LDO_ENABLE_OFF);         /*USB 0V9*/
    //Zx234290_SetVldo5Onoff(LDO_ENABLE_OFF);         /*USB 3V3*/
    Zx234290_SetVldo6Onoff(LDO_ENABLE_OFF);         /*SIM1 1V8*/
    //Zx234290_SetVldo7Onoff(LDO_ENABLE_OFF);       /*RF 2V85*/
    //Zx234290_SetVldo8Onoff(LDO_ENABLE_ON);         /*ZSP JTAG/SD 2V85 ͺŻܹ*/
    //Zx234290_SetVldo9Onoff(LDO_ENABLE_OFF);         /*PLL 0V9*/
    Zx234290_SetVldo10Onoff(LDO_ENABLE_OFF);        /*ABB DIG*/

	Zx234290_SetBUCK1SleepMode(BUCK1_SLP_SHUTDOWN);  /*vdcore*/
    Zx234290_SetBUCK2SleepMode(BUCK234_SLP_ECO_WITH_ECO);/*ddr1.2v/mcp1.2v/hsic1.2v*/
    Zx234290_SetBUCK3SleepMode(BUCK234_SLP_SHUTDOWN);   /*RF 1V6*/
    //Zx234290_SetBUCK4SleepMode(BUCK234_SLP_SHUTDOWN);   /*PA 3V6*/
    //Zx234290_SetLDO1SleepMode(LDOA_SLP_SHUTDOWN);       /*USB 0V9*/
    //Zx234290_SetLDO5SleepMode(LDOA_SLP_SHUTDOWN);       /*USB 3V3*/
	Zx234290_SetLDO2SleepMode(LDOA_SLP_ECO_VOLT_SLP);    /*io1.8v/mcp1.8v/sd01.8v*/
	Zx234290_SetLDO3SleepMode(LDOA_SLP_ECO_VOLT_SLP);	/*vp111.8v/vddr_pll1.8v/*/
	Zx234290_SetLDO4SleepMode(LDOA_SLP_SHUTDOWN);		/*vcxo*/
    //Zx234290_SetLDO6SleepMode(LDOA_SLP_SHUTDOWN);       /*SIM1 1V8*/
    Zx234290_SetLDO7SleepMode(LDOA_SLP_ECO_VOLT_SLP);  /*RF 2V85 -- 26M */
    Zx234290_SetLDO8SleepMode(LDOA_SLP_ECO_VOLT_SLP);       /*ZSP JTAG/SD 2V85/LCD*/
    Zx234290_SetLDO9SleepMode(LDOA_SLP_ECO_VOLT_SLP);       /*PLL 0V9*/
    //Zx234290_SetLDO10SleepMode(LDOA_SLP_SHUTDOWN);      /*ABB DIG*/

	return DRV_SUCCESS;
}

SINT32 zDrvZx234290_SleepConfig(VOID)
{
    if(POWER_ON_CHARGING == zDrvComm_GetPowerOnState())
		return zDrvZx234290_ChgOnSleepConfig();
	else
		return zDrvZx234290_NormalSleepConfig();
}

SINT32 zDrvZx234290_DebugConfig(VOID)
{
    return DRV_SUCCESS;
}

#if 1
SINT32 zDrvZx234290_SetTimerCount(UINT8 cnt)
{
    SINT32 ret = 0;
    UINT8 slv_addr=0, reg_addr=0, reg_val=0, mask=0;


    slv_addr = ZX234290_I2C_SLAVE_ADDR0;
    reg_addr = ZX234290_REG_ADDR_TIMER_CNT;

    reg_val = ZX234290_BITFVAL(cnt, ZX234290_RTC_TIMER_CNT_LSH);
    mask = ZX234290_BITFMASK(ZX234290_RTC_TIMER_CNT_WID, ZX234290_RTC_TIMER_CNT_LSH);
    ret = zDrvPmic_SetRegister(slv_addr, reg_addr, reg_val, mask);

    if (ret != DRV_SUCCESS)
    {
        return DRV_ERROR;
    }

    return DRV_SUCCESS;
}

SINT32 zDrvZx234290_SetTimerTD(T_ZDrvZx234290_TimerCount td)
{
    SINT32 ret = 0;
    UINT8 slv_addr=0, reg_addr=0, reg_val=0, mask=0;


    slv_addr = ZX234290_I2C_SLAVE_ADDR0;

    reg_addr = ZX234290_REG_ADDR_TIMER_CTRL;
    reg_val = ZX234290_BITFVAL(td, ZX234290_RTC_TIMER_TD_LSH);
    mask = ZX234290_BITFMASK(ZX234290_RTC_TIMER_TD_WID, ZX234290_RTC_TIMER_TD_LSH);
    ret = zDrvPmic_SetRegister(slv_addr, reg_addr, reg_val, mask);

    if (ret != DRV_SUCCESS)
    {
        return DRV_ERROR;
    }

    return DRV_SUCCESS;
}

SINT32 zDrvZx234290_EnableTimer(T_ZDrvRtc_AlarmPower bIsOn)
{
    SINT32 ret = 0;
    UINT8 slv_addr=0, reg_addr=0, reg_val=0, mask=0;


    slv_addr = ZX234290_I2C_SLAVE_ADDR0;

    reg_addr = ZX234290_REG_ADDR_TIMER_CTRL;
    reg_val = ZX234290_BITFVAL(bIsOn, ZX234290_RTC_TIMER_EN_LSH);
    mask = ZX234290_BITFMASK(ZX234290_RTC_TIMER_EN_WID, ZX234290_RTC_TIMER_EN_LSH);
    ret = zDrvPmic_SetRegister(slv_addr, reg_addr, reg_val, mask);

    if (ret != DRV_SUCCESS)
    {
        return DRV_ERROR;
    }

    return DRV_SUCCESS;
}

SINT32 zDrvZx234290_EnableTimerInt(T_ZDrvRtc_IntSetup bIsOn)
{
    SINT32 ret = 0;
    UINT8 slv_addr=0, reg_addr=0, reg_val=0, mask=0;


    slv_addr = ZX234290_I2C_SLAVE_ADDR0;

    reg_addr = ZX234290_REG_ADDR_RTC_CTRL2;
    reg_val = ZX234290_BITFVAL(bIsOn, ZX234290_RTC_TIMER_INT_EN_LSH);
    mask = ZX234290_BITFMASK(ZX234290_RTC_TIMER_INT_EN_WID, ZX234290_RTC_TIMER_INT_EN_LSH);
    ret = zDrvPmic_SetRegister(slv_addr, reg_addr, reg_val, mask);

    if (ret != DRV_SUCCESS)
    {
        return DRV_ERROR;
    }

    return DRV_SUCCESS;
}

SINT32 zDrvZx234290_SetTimerCountdown(UINT8 cnt)
{
    SINT32 ret = 0;
    UINT8 slv_addr=0, reg_addr=0, reg_val=0, mask=0;
    UINT8 content =0;
    slv_addr = ZX234290_I2C_SLAVE_ADDR0;

    mask = ZX234290_BITFMASK(ZX234290_RTC_TIMER_INT_EN_WID, 2);
	reg_val= ZX234290_BITFVAL(0, 2);
	zDrvPmic_SetRegister(slv_addr,ZX234290_REG_ADDR_RTC_CTRL2, reg_val, mask);//clear TF, At the end of a timer countdown

    zDrvZx234290_EnableTimerInt(RTC_INT_ENABLE);//set TIE, timer interrupt enabled.
    zDrvZx234290_EnableTimer(ALARM_POWER_ON);//set TE, timer enabled
    zDrvZx234290_SetTimerTD(TIMER_COUNT_1);//set TD1/TD0
    zDrvZx234290_SetTimerCount(cnt);

    #if 0
    zDrvPmic_I2cRead(slv_addr, ZX234290_REG_ADDR_RTC_CTRL2, &content);

    zDrvRamlog_PRINTF(RAMLOG_MOD_CHARGER, "RTC REG(0x%xH)=0x%x", ZX234290_REG_ADDR_RTC_CTRL2, content);


    zDrvPmic_I2cRead(slv_addr, ZX234290_REG_ADDR_TIMER_CTRL, &content);

    zDrvRamlog_PRINTF(RAMLOG_MOD_CHARGER, "RTC REG(0x%xH)=0x%x", ZX234290_REG_ADDR_TIMER_CTRL, content);


    zDrvPmic_I2cRead(slv_addr, ZX234290_REG_ADDR_INTB_MASK, &content);

    zDrvRamlog_PRINTF(RAMLOG_MOD_CHARGER, "RTC REG(0x%xH)=0x%x", ZX234290_REG_ADDR_INTB_MASK, content);


    zDrvPmic_I2cRead(slv_addr, ZX234290_REG_ADDR_TIMER_CNT, &content);

    zDrvRamlog_PRINTF(RAMLOG_MOD_CHARGER, "RTC REG(0x%xH)=0x%x", ZX234290_REG_ADDR_TIMER_CNT, content);
    #endif

    return DRV_SUCCESS;
}
//#define ZX297520_A1_CRM_DRV_RESET   0x0013B000
#if 0
SINT32 zDrvZx234290_RestartByTc(VOID)
{
    SINT32 ret = 0;
    T_ZDrvGpio_IoVolt chgAcState  = -1;

    chgAcState  = chg_isChgIn();//ȡ״̬
    if(GPIO_LOW == chgAcState)//
    {
        //reg32(ZX297520_A1_CRM_DRV_RESET) = (0x1) << 31;
        hal_Comm_Soft_Reset(RESET_TO_NORMAL);
    }
    else if(GPIO_HIGH == chgAcState)//γ粢ʹtimercount
    {
        zDrvZx234290_SetTimerCountdown(5);
        ret = zDrvGpio_SetValue(g_pmicPsholdPin, GPIO_LOW);
        if( ret != DRV_SUCCESS )
        {
            return ret;
        }
    }
    return DRV_SUCCESS;
}
#endif
#endif

#if 1	/* vdd_CORE0 -- 0.9V -- BUCK1 */
/*******************************************************************************
 * Function:
 * Description:
 * Parameters:
 *	 Input:
 *
 *	 Output:
 *
 * Returns:
 *
 *
 * Others:
 ********************************************************************************/
SINT32 zDrvZx234290_SetVcoreOnoff(T_ZDrvPmic_Enable status)
{
	SINT32 ret = 0;

	ret = Zx234290_SetVbuck1Onoff(status);

	return ret;
}

T_ZDrvPmic_Enable zDrvZx234290_GetVcoreOnoff(VOID)	   /*  buck1   */
{
	T_ZDrvPmic_Enable status;

	status	= Zx234290_GetVbuck1Onoff();

	return status;
}

SINT32 zDrvZx234290_SetVcore(T_ZDrvPmic_Voltage vol) 	 /*  buck1	 */
{
	SINT32 ret = 0;
	switch (vol)
	{
		case PM_VOLT_0_900:
		{
			ret = Zx234290_SetVbuck1(VBUCKA_0_900);
			break;
		}

		case PM_VOLT_1_100:
		{
			ret = Zx234290_SetVbuck1(VBUCKA_1_100);
			break;
		}
		default:
		{
			ret = DRV_ERR_INVALID_PARAM;
		}
	}

	return ret;
}

T_ZDrvPmic_Voltage zDrvZx234290_GetVcore(VOID)
{
	T_ZDrvPmic_Voltage	vget;
	T_ZDrvZx234290_VbuckA	 vol;

	vol = Zx234290_GetVbuck1();
	switch (vol)
	{
		case VBUCKA_0_900:
		{
			vget = PM_VOLT_0_900;
			break;
		}

		case VBUCKA_1_100:
		{
			vget = PM_VOLT_1_100;
			break;
		}

		default:
		{
			return PM_VOLT_NOT_SUPPORT;
		}
	}

	return vget;
}

SINT32 zDrvZx234290_SetVcoreSleepMode(T_ZDrvPmic_SlpMode mode)
{
	SINT32 ret = DRV_SUCCESS;

    switch (mode)
	{
		case PM_SLPMODE_AUTO_NORMAL:
		case PM_SLPMODE_ECO_NRMV:
		case PM_SLPMODE_ECO_SLPV:
        case PM_SLPMODE_OFF:
		{
			ret = Zx234290_SetBUCK1SleepMode(mode);
			break;
		}
		default:
		{
			ret = DRV_ERR_INVALID_PARAM;
		}
	}


	return ret;
}

T_ZDrvPmic_SlpMode zDrvZx234290_GetVcoreSleepMode(VOID)
{
	T_ZDrvPmic_SlpMode	getMode;
	T_ZDrvZx234290_BUCK1_SLPMODE	 mode;

	mode = Zx234290_GetBUCK1SleepMode();
	switch (mode)
	{
		case BUCK1_SLP_AUTO_WITHOUT_ECO:
		case BUCK1_SLP_AUTO_ECO:
		case BUCK1_SLP_AUTO_ECO_SLP:
		case BUCK1_SLP_SHUTDOWN:
		{
			getMode = mode;
			break;
		}
		default:
		{
			return PM_SLPMODE_NOT_SUPPORT;
		}
	}

	return getMode;


}

SINT32 zDrvZx234290_SetVcoreSlpV(T_ZDrvPmic_Voltage vol) 	 /* buck1 sleep vol */
{
	SINT32 ret = 0;
	switch (vol)
	{
        case PM_VOLT_0_800:
		{
			ret = Zx234290_SetVbuck1SLPV(VBUCKA_0_800);
			break;
		}
		case PM_VOLT_0_900:
		{
			ret = Zx234290_SetVbuck1SLPV(VBUCKA_0_900);
			break;
		}

		case PM_VOLT_1_100:
		{
			ret = Zx234290_SetVbuck1SLPV(VBUCKA_1_100);
			break;
		}
		default:
		{
			ret = DRV_ERR_INVALID_PARAM;
		}
	}

	return ret;
}
#endif

#if 1	/* IO_DDR HSIC DDR2 --1.2V	BUCK2 */
/*******************************************************************************
 * Function:
 * Description:
 * Parameters:
 *	 Input:
 *
 *	 Output:
 *
 * Returns:
 *
 *
 * Others:
 ********************************************************************************/
SINT32 zDrvZx234290_SetVmemOnoff(T_ZDrvPmic_Enable status)
{
	SINT32 ret = 0;

	ret = Zx234290_SetVbuck2Onoff(status);

	return ret;
}

T_ZDrvPmic_Enable zDrvZx234290_GetVmemOnoff(VOID)	  /*  MEM	*/
{
	T_ZDrvPmic_Enable status;

	status	= Zx234290_GetVbuck2Onoff();

	return status;
}

SINT32 zDrvZx234290_SetVmem(T_ZDrvPmic_Voltage vol)		/*	MEM   */
{
	SINT32 ret = 0;
	switch (vol)
	{
		case PM_VOLT_1_200:
		{
			ret = Zx234290_SetVbuck2(VBUCKC_1_200);
			break;
		}
		default:
		{
			ret = DRV_ERR_INVALID_PARAM;
		}
	}

	return ret;
}

T_ZDrvPmic_Voltage zDrvZx234290_GetVmem(VOID)
{
	T_ZDrvPmic_Voltage	vget;
	T_ZDrvZx234290_VbuckC	 vol;

	vol = Zx234290_GetVbuck2(); 	 /*   buck2MEMĵѹ	  */
	switch (vol)
	{
		case VBUCKC_1_200:
		{
			vget = PM_VOLT_1_200;
			break;
		}
		default:
		{
			return PM_VOLT_NOT_SUPPORT;
		}
	}

	return vget;
}

SINT32 zDrvZx234290_SetVmemSleepMode(T_ZDrvPmic_SlpMode mode)
{
	SINT32 ret = DRV_SUCCESS;

    switch (mode)
	{
		case PM_SLPMODE_AUTO_NORMAL:
		case PM_SLPMODE_ECO_NRMV:
		case PM_SLPMODE_ECO_SLPV:
        case PM_SLPMODE_OFF:
		{
			ret = Zx234290_SetBUCK2SleepMode(mode);
			break;
		}
		default:
		{
			ret = DRV_ERR_INVALID_PARAM;
		}
	}
	return ret;
}

T_ZDrvPmic_SlpMode zDrvZx234290_GetVmemSleepMode(VOID)
{
	T_ZDrvPmic_SlpMode	getMode;
	T_ZDrvZx234290_LDOA_SLPMODE	 mode;

	mode = Zx234290_GetBUCK2SleepMode();
	switch (mode)
	{
		case LDOA_SLP_NRM_MODE:
		case LDOA_SLP_ECO_VOLT:
        case LDOA_SLP_ECO_VOLT_SLP:
		case LDOA_SLP_SHUTDOWN:
		{
			getMode = mode;
			break;
		}
		default:
		{
			return PM_SLPMODE_NOT_SUPPORT;
		}
	}

	return getMode;

}

#endif
#if 1	/* ACO405_16 RFCORE -- 1.6V -- buck3  */
/*******************************************************************************
 * Function:
 * Description:
 * Parameters:
 *	 Input:
 *
 *	 Output:
 *
 *
 * Returns:
 *
 *
 * Others:
 ********************************************************************************/
SINT32 zDrvZx234290_SetVrfcoreOnoff(T_ZDrvPmic_Enable status)
{
	SINT32 ret = 0;

	ret = Zx234290_SetVbuck3Onoff(status);

	return ret;
}

T_ZDrvPmic_Enable zDrvZx234290_GetVrfcoreOnoff(VOID)
{
	T_ZDrvPmic_Enable status;

	status	= Zx234290_GetVbuck3Onoff();

	return status;
}

SINT32 zDrvZx234290_SetVrfcoreSleepMode(T_ZDrvPmic_SlpMode mode)
{
	SINT32 ret = DRV_SUCCESS;

    switch (mode)
	{
		case PM_SLPMODE_AUTO_NORMAL:
		case PM_SLPMODE_ECO_NRMV:
        case PM_SLPMODE_OFF:
		{
			ret = Zx234290_SetBUCK3SleepMode(mode);
			break;
		}
		default:
		{
			ret = DRV_ERR_INVALID_PARAM;
		}
	}
	return ret;
}

T_ZDrvPmic_SlpMode zDrvZx234290_GetVrfcoreSleepMode(VOID)
{
	T_ZDrvPmic_SlpMode	getMode;
	T_ZDrvZx234290_LDOA_SLPMODE	 mode;

	mode = Zx234290_GetBUCK3SleepMode();
	switch (mode)
	{
		case LDOA_SLP_NRM_MODE:
		case LDOA_SLP_ECO_VOLT:
		case LDOA_SLP_SHUTDOWN:
		{
			getMode = mode;
			break;
		}
		default:
		{
			return PM_SLPMODE_NOT_SUPPORT;
		}
	}

	return getMode;

}
#endif

#if 1	/*	BUF  RTC VUSB0.9v -- LDO1 */
/*******************************************************************************
 * Function:
 * Description:
 * Parameters:
 *	 Input:
 *
 *	 Output:
 *
 * Returns:
 *
 *
 * Others:
 ********************************************************************************/
SINT32 zDrvZx234290_SetVusb0v9Onoff(T_ZDrvPmic_Enable status)
{
	SINT32 ret = 0;

	ret = Zx234290_SetVldo1Onoff(status);

	return ret;
}

T_ZDrvPmic_Enable zDrvZx234290_GetVusb0v9Onoff(VOID)
{
	T_ZDrvPmic_Enable status;

	status	= Zx234290_GetVldo1Onoff();

	return status;
}

SINT32 zDrvZx234290_SetVusb0v9(T_ZDrvPmic_Voltage vol)
{
	SINT32 ret = 0;
	switch (vol)
	{
		case PM_VOLT_0_900:
		{
			ret = Zx234290_SetVldo1(VLDOA_0_900);
			break;
		}
		default:
		{
			ret = DRV_ERR_INVALID_PARAM;
		}
	}
	return ret;
}

T_ZDrvPmic_Voltage zDrvZx234290_GetVusb0v9(VOID)
{
	T_ZDrvPmic_Voltage  vget;
	T_ZDrvZx234290_VldoA   vol;

	vol = Zx234290_GetVldo1();
	switch (vol)
	{
		case VLDOA_0_900:
		{
			vget = PM_VOLT_0_900;
			break;
		}
		default:
		{
			return PM_VOLT_NOT_SUPPORT;
		}
	}

	return vget;
}

SINT32 zDrvZx234290_SetVusb0v9SleepMode(T_ZDrvPmic_SlpMode mode)
{
	SINT32 ret = DRV_SUCCESS;

    switch (mode)
	{
		case PM_SLPMODE_AUTO_NORMAL:
		case PM_SLPMODE_ECO_NRMV:
		case PM_SLPMODE_ECO_SLPV:
        case PM_SLPMODE_OFF:
		{
			ret = Zx234290_SetLDO1SleepMode(mode);
			break;
		}
		default:
		{
			ret = DRV_ERR_INVALID_PARAM;
		}
	}
	return ret;

}

T_ZDrvPmic_SlpMode zDrvZx234290_GetVusb0v9SleepMode(VOID)
{
	T_ZDrvPmic_SlpMode	getMode;
	T_ZDrvZx234290_LDOA_SLPMODE	 mode;

	mode = Zx234290_GetLDO1SleepMode();
	switch (mode)
	{
		case LDOA_SLP_NRM_MODE:
		case LDOA_SLP_ECO_VOLT:
        case LDOA_SLP_ECO_VOLT_SLP:
		case LDOA_SLP_SHUTDOWN:
		{
			getMode = mode;
			break;
		}
		default:
		{
			return PM_SLPMODE_NOT_SUPPORT;
		}
	}
	return getMode;
}

#endif
#if 1	/* IO_1.8V LDO2 */
/*******************************************************************************
 * Function:
 * Description:
 * Parameters:
 *	 Input:
 *
 *	 Output:
 *
 * Returns:
 *
 *
 * Others:
 ********************************************************************************/
SINT32 zDrvZx234290_SetVioOnoff(T_ZDrvPmic_Enable status)
{
	SINT32 ret = 0;

	ret = Zx234290_SetVldo2Onoff(status);

	return ret;
}

T_ZDrvPmic_Enable zDrvZx234290_GetVioOnoff(VOID)
{
	T_ZDrvPmic_Enable status;

	status	= Zx234290_GetVldo2Onoff();

	return status;
}

SINT32 zDrvZx234290_SetVio(T_ZDrvPmic_Voltage vol)
{
	SINT32 ret = 0;
	switch (vol)
	{
		case PM_VOLT_1_800:
		{
			ret = Zx234290_SetVldo2(VLDOC_1_800);
			break;
		}

		default:
		{
			ret = DRV_ERR_INVALID_PARAM;
		}
	}

	return ret;
}

T_ZDrvPmic_Voltage zDrvZx234290_GetVio(VOID)
{
	T_ZDrvPmic_Voltage vget;
	T_ZDrvZx234290_VldoA vol;

	vol = Zx234290_GetVldo2();
	switch (vol)
	{
		case VLDOC_1_800:
		{
			vget = PM_VOLT_1_800;
			break;
		}

		default:
		{
			return PM_VOLT_NOT_SUPPORT;
		}
	}

	return vget;
}
#endif


#if 1	/* PLL_1V8 SSBUF BUFFER LDO3 */
/*******************************************************************************
 * Function:
 * Description:
 * Parameters:
 *	 Input:
 *
 *	 Output:
 *
 * Returns:
 *
 *
 * Others:
 ********************************************************************************/
SINT32 zDrvZx234290_SetVbuf_1v8Onoff(T_ZDrvPmic_Enable status)
{
	SINT32 ret = 0;

	ret = Zx234290_SetVldo3Onoff(status);

	return ret;
}

T_ZDrvPmic_Enable zDrvZx234290_GetVbuf_1v8Onoff(VOID)
{
	T_ZDrvPmic_Enable status;

	status	= Zx234290_GetVldo3Onoff();

	return status;
}

SINT32 zDrvZx234290_SetVbuf_1v8(T_ZDrvPmic_Voltage vol)
{
	SINT32 ret = 0;
	switch (vol)
	{
		case PM_VOLT_1_800:
		{
			ret = Zx234290_SetVldo3(VLDOC_1_800);
			break;
		}
		default:
		{
			ret = DRV_ERR_INVALID_PARAM;
		}
	}
	return ret;
}

T_ZDrvPmic_Voltage zDrvZx234290_GetVbuf_1v8(VOID)
{
	T_ZDrvPmic_Voltage  vget;
	T_ZDrvZx234290_VldoC   vol;

	vol = Zx234290_GetVldo3();
	switch (vol)
	{
		case VLDOC_1_800:
		{
			vget = PM_VOLT_1_800;
			break;
		}

		default:
		{
			return PM_VOLT_NOT_SUPPORT;
		}
	}

	return vget;
}

#endif

#if 1	/*	  TCXO 2.8v -- LDO4 */
/*******************************************************************************
 * Function:
 * Description:
 * Parameters:
 *	 Input:
 *
 *	 Output:
 *
 * Returns:
 *
 *
 * Others:
 ********************************************************************************/
SINT32 zDrvZx234290_SetVtcxo2v8Onoff(T_ZDrvPmic_Enable status)
{
	SINT32 ret = 0;

	ret = Zx234290_SetVldo4Onoff(status);

	return ret;
}

T_ZDrvPmic_Enable zDrvZx234290_GetVtcxo2v8Onoff(VOID)
{
	T_ZDrvPmic_Enable status;

	status	= Zx234290_GetVldo4Onoff();

	return status;
}

SINT32 zDrvZx234290_SetVtcxo2v8(T_ZDrvPmic_Voltage vol)
{
	SINT32 ret = 0;
	switch (vol)
	{
		case PM_VOLT_2_850:
		{
			ret = Zx234290_SetVldo4(VLDOD_2_850);
			break;
		}
		default:
		{
			ret = DRV_ERR_INVALID_PARAM;
		}
	}
	return ret;
}

T_ZDrvPmic_Voltage zDrvZx234290_GetVtcxo2v8(VOID)
{
	T_ZDrvPmic_Voltage  vget;
	T_ZDrvZx234290_VldoD   vol;

	vol = Zx234290_GetVldo4();
	switch (vol)
	{
		case VLDOD_2_850:
		{
			vget = PM_VOLT_2_850;	/* Ҫ¶ */
			break;
		}

		default:
		{
			return PM_VOLT_NOT_SUPPORT;
		}
	}

	return vget;
}
#endif



#if 1	/* USBTRM -- 3.3V -- LDO5 */
/*******************************************************************************
 * Function:
 * Description:
 * Parameters:
 *	 Input:
 *
 *	 Output:
 *
 * Returns:
 *
 *
 * Others:
 ********************************************************************************/
SINT32 zDrvZx234290_SetVusbtrmOnoff(T_ZDrvPmic_Enable status)
{
	SINT32 ret = 0;

	ret = Zx234290_SetVldo5Onoff(status);

	return ret;
}

T_ZDrvPmic_Enable zDrvZx234290_GetVusbtrmOnoff(VOID)
{
	T_ZDrvPmic_Enable status;

	status	= Zx234290_GetVldo5Onoff();

	return status;
}

SINT32 zDrvZx234290_SetVusbtrmSleepMode(T_ZDrvPmic_SlpMode mode)
{
	SINT32 ret = DRV_SUCCESS;
    switch (mode)
	{
		case PM_SLPMODE_AUTO_NORMAL:
		case PM_SLPMODE_ECO_NRMV:
        case PM_SLPMODE_OFF:
		{
			ret = Zx234290_SetLDO5SleepMode(mode);
			break;
		}
		default:
		{
			ret = DRV_ERR_INVALID_PARAM;
		}
	}
	return ret;
}

T_ZDrvPmic_SlpMode zDrvZx234290_GetVusbtrmSleepMode(VOID)
{
	T_ZDrvPmic_SlpMode	getMode;
	T_ZDrvZx234290_LDOA_SLPMODE	 mode;

	mode = Zx234290_GetLDO5SleepMode();
	switch (mode)
	{
		case LDOA_SLP_NRM_MODE:
		case LDOA_SLP_ECO_VOLT:
		case LDOA_SLP_SHUTDOWN:
		{
			getMode = mode;
			break;
		}
		default:
		{
			return PM_SLPMODE_NOT_SUPPORT;
		}
	}
	return getMode;
}

#endif



#if 1	/* SIM_1V 8_3V -- LDO6 */
/*******************************************************************************
 * Function:
 * Description:
 * Parameters:
 *	 Input:
 *
 *	 Output:
 *
 * Returns:
 *
 *
 * Others:
 ********************************************************************************/
SINT32 zDrvZx234290_SetVsimOnoff(T_ZDrvPmic_Enable status)
{
	SINT32 ret = 0;

	ret = Zx234290_SetVldo6Onoff(status);

	return ret;
}

SINT32 zDrvZx234290_SetVsimOnoff_PSM(T_ZDrvPmic_Enable status)
{
	SINT32 ret = 0;

	ret = Zx234290_SetVldo6Onoff_PSM(status);

	return ret;
}
T_ZDrvPmic_Enable zDrvZx234290_GetVsimOnoff(VOID)
{
	T_ZDrvPmic_Enable status;

	status	= Zx234290_GetVldo6Onoff();

	return status;
}

SINT32 zDrvZx234290_SetVsim(T_ZDrvPmic_Voltage vol)
{
	SINT32 ret = 0;
	switch (vol)
	{
		case PM_VOLT_1_800:
		{
			ret = Zx234290_SetVldo6(VLDOD_1_800);
			break;
		}

		case PM_VOLT_3_000:
		{
			ret = Zx234290_SetVldo6(VLDOD_3_000);
			break;
		}

		default:
		{
			ret = DRV_ERR_INVALID_PARAM;
		}
	}

	return ret;
}

T_ZDrvPmic_Voltage zDrvZx234290_GetVsim(VOID)
{
	T_ZDrvPmic_Voltage vget;
	T_ZDrvZx234290_VldoD vol;

	vol = Zx234290_GetVldo6();
	switch (vol)
	{
		case VLDOD_1_800:
		{
			vget = PM_VOLT_1_800;
			break;
		}

		case VLDOD_3_000:
		{
			vget = PM_VOLT_3_000;
			break;
		}

		default:
		{
			return PM_VOLT_NOT_SUPPORT;
		}
	}

	return vget;
}

SINT32 zDrvZx234290_SetVsimSleepMode(T_ZDrvPmic_SlpMode mode)
{
	SINT32 ret = DRV_SUCCESS;

    switch (mode)
	{
		case PM_SLPMODE_AUTO_NORMAL:
		case PM_SLPMODE_ECO_NRMV:
        case PM_SLPMODE_OFF:
		{
			ret = Zx234290_SetLDO6SleepMode(mode);
			break;
		}
		default:
		{
			ret = DRV_ERR_INVALID_PARAM;
		}
	}
	return ret;

}

T_ZDrvPmic_SlpMode zDrvZx234290_GetVsimSleepMode(VOID)
{
	T_ZDrvPmic_SlpMode	getMode;
	T_ZDrvZx234290_LDOB_SLPMODE	 mode;

	mode = Zx234290_GetLDO6SleepMode();
	switch (mode)
	{
		case LDOB_SLP_NRM_MODE:
		case LDOB_SLP_ECO_VOLT:
		case LDOB_SLP_SHUTDOWN:
		{
			getMode = mode;
			break;
		}
		default:
		{
			return PM_SLPMODE_NOT_SUPPORT;
		}
	}

	return getMode;
}

#endif

#if 1	/* RF 405 -- 2.8V -- LDO7 */
/*******************************************************************************
 * Function:
 * Description:
 * Parameters:
 *	 Input:
 *
 *	 Output:
 *
 * Returns:
 *
 *
 * Others:
 ********************************************************************************/
SINT32 zDrvZx234290_SetVrf_2v8Onoff(T_ZDrvPmic_Enable status)
{
	SINT32 ret = 0;

	ret = Zx234290_SetVldo7Onoff(status);

	return ret;
}

T_ZDrvPmic_Enable zDrvZx234290_GetVrf_2v8Onoff(VOID)	 /*  buck1	 */
{
	T_ZDrvPmic_Enable status;

	status	= Zx234290_GetVldo7Onoff();

	return status;
}

SINT32 zDrvZx234290_SetVrf_2v8(T_ZDrvPmic_Voltage vol) 	 /*  buck1	 */
{
	SINT32 ret = 0;
	switch (vol)
	{
		case PM_VOLT_2_850:
		{
			ret = Zx234290_SetVldo7(VLDOD_2_850);
			break;
		}
		default:
		{
			ret = DRV_ERR_INVALID_PARAM;
		}
	}

	return ret;
}

T_ZDrvPmic_Voltage zDrvZx234290_GetVrf_2v8(VOID)
{
	T_ZDrvPmic_Voltage   vget;
	T_ZDrvZx234290_VldoD	vol;

	vol = Zx234290_GetVldo7();
	switch (vol)
	{
		case VLDOD_2_850:
		{
			vget = PM_VOLT_2_850;
			break;
		}

		default:
		{
			return PM_VOLT_NOT_SUPPORT;
		}
	}

	return vget;
}

SINT32 zDrvZx234290_SetVrf_2v8SleepMode(T_ZDrvPmic_SlpMode mode)
{
	SINT32 ret = DRV_SUCCESS;
    switch (mode)
	{
		case PM_SLPMODE_AUTO_NORMAL:
		case PM_SLPMODE_ECO_NRMV:
		case PM_SLPMODE_ECO_SLPV:
        case PM_SLPMODE_OFF:
		{
			ret = Zx234290_SetLDO7SleepMode(mode);
			break;
		}
		default:
		{
			ret = DRV_ERR_INVALID_PARAM;
		}
	}
	return ret;

}

T_ZDrvPmic_SlpMode zDrvZx234290_GetVrf_2v8SleepMode(VOID)
{
	T_ZDrvPmic_SlpMode	getMode;
	T_ZDrvZx234290_LDOA_SLPMODE	 mode;

	mode = Zx234290_GetLDO7SleepMode();
	switch (mode)
	{
		case LDOA_SLP_NRM_MODE:
		case LDOA_SLP_ECO_VOLT:
        case LDOA_SLP_ECO_VOLT_SLP:
		case LDOA_SLP_SHUTDOWN:
		{
			getMode = mode;
			break;
		}
		default:
		{
			return PM_SLPMODE_NOT_SUPPORT;
		}
	}
	return getMode;
}

#endif


#if 1	/* SD- 2.8V --LDO8 */
/*******************************************************************************
 * Function:
 * Description:
 * Parameters:
 *	 Input:
 *
 *	 Output:
 *
 * Returns:
 *
 *
 * Others:
 ********************************************************************************/
SINT32 zDrvZx234290_SetVsdOnoff(T_ZDrvPmic_Enable status)
{
	SINT32 ret = 0;

	ret = Zx234290_SetVldo8Onoff(status);

	return ret;
}

T_ZDrvPmic_Enable zDrvZx234290_GetVsdOnoff(VOID)
{
	T_ZDrvPmic_Enable status;

	status	= Zx234290_GetVldo8Onoff();

	return status;
}

SINT32 zDrvZx234290_SetVsd(T_ZDrvPmic_Voltage vol)
{
	SINT32 ret = DRV_SUCCESS;
	switch (vol)
	{
        case PM_VOLT_1_800:
		{
			ret = Zx234290_SetVldo8(VLDOD_1_800);
			break;
		}
		case PM_VOLT_2_800:
		{
			ret = Zx234290_SetVldo8(VLDOD_2_800);
			break;
		}
		case PM_VOLT_2_850:
		{
			ret = Zx234290_SetVldo8(VLDOD_2_850);
			break;
		}
		default:
		{
			ret = DRV_ERR_INVALID_PARAM;
		}
	}

	return ret;
}

T_ZDrvPmic_Voltage zDrvZx234290_GetVsd(VOID)
{
	T_ZDrvPmic_Voltage	vget;
	T_ZDrvZx234290_VldoD vol;

	vol = Zx234290_GetVldo8();
	switch (vol)
	{
        case VLDOD_1_800:
		{
			vget = PM_VOLT_1_800;
			break;
		}

		case VLDOD_2_800:
		{
			vget = PM_VOLT_2_800;
			break;
		}
		case VLDOD_2_850:
		{
			vget = PM_VOLT_2_850;
			break;
		}

		default:
		{
			return PM_VOLT_NOT_SUPPORT;
		}
	}

	return vget;
}

SINT32 zDrvZx234290_SetVsdSleepMode(T_ZDrvPmic_SlpMode mode)
{
	SINT32 ret = DRV_SUCCESS;

    switch (mode)
	{
		case PM_SLPMODE_AUTO_NORMAL:
		case PM_SLPMODE_ECO_NRMV:
        case PM_SLPMODE_ECO_SLPV:
        case PM_SLPMODE_OFF:
		{
			ret = Zx234290_SetLDO8SleepMode(mode);
			break;
		}
		default:
		{
			ret = DRV_ERR_INVALID_PARAM;
		}
	}
	return ret;

}

T_ZDrvPmic_SlpMode zDrvZx234290_GetVsdSleepMode(VOID)
{
	T_ZDrvPmic_SlpMode	getMode;
	T_ZDrvZx234290_LDOA_SLPMODE	 mode;

	mode = Zx234290_GetLDO8SleepMode();
	switch (mode)
	{
		case LDOA_SLP_NRM_MODE:
		case LDOA_SLP_ECO_VOLT:
        case LDOA_SLP_ECO_VOLT_SLP:
		case LDOA_SLP_SHUTDOWN:
		{
			getMode = mode;
			break;
		}
		default:
		{
			return PM_SLPMODE_NOT_SUPPORT;
		}
	}

	return getMode;
}

#endif

