/*******************************************************************************
 * Copyright (C) 2010, ZTE Corporation.
 *
 * File Name:
 * File Mark:
 * Description:
 * Others:
 * Version:       V1.0
 * Author:        zhangdongdong
 * Date:          2013-5-16
 * History 1:
 *     Date:
 *     Version:
 *     Author:
 *     Modification:
 * History 2:
  ********************************************************************************/

/****************************************************************************
*                                              Include files
****************************************************************************/
#include "drvs_general.h"
#include "drvs_pow.h"
#include "drvs_pmic_regulator.h"
#include "drvs_comm.h"
#ifdef  _USE_PSM_TEST
#include "sys_func_atcfg.h"
#endif

/****************************************************************************
*                                              macro define
****************************************************************************/
#if PSM_CPU_CP


#ifdef  _USE_PSM_TEST
#define ATCFG_VCORE_NODVS     zSys_SetR7SleepType(VDCORE_NO_DVS)
#else
#define ATCFG_VCORE_NODVS     0
#endif

/****************************************************************************
*                                             Global Variables
****************************************************************************/
/*  (1<<RM_RTC_ALARM_INT_DIS) |           \ */
UINT32 wake_int[] =
{
    /*reg1*/
    (1<<PS_TIMER1_INT_DIS)              |           \
    (1<<ICP_AP2PS_INT_DIS)              |           \
    (1<<ICP_PHY2PS_INT_DIS)             |           \
    (1<<ICP_M02PS_INT_DIS)              |           \
    (1<<RM_KEYPAD_INT_DIS)              |           \
    (1<<SPCU_PW_INT_DIS),

    /*reg2*/
	(1<<(EXTERNAL_INT0_DIS-32))         |           \
    (1<<(EXTERNAL_INT1_DIS-32))         |           \
    (1<<(EXTERNAL_INT5_DIS-32))         |           \
	(1<<(EXTERNAL_INT6_DIS-32))         |           \
    (1<<(EXTERNAL_INT7_DIS-32)),
};

static VOID pow_RefBeforeDeepSleep(VOID);
static VOID pow_RefAfterDeepSleep(VOID);

static T_ZDrvPow_Opt s_powOpt =
    {
        pow_RefBeforeDeepSleep,
        pow_RefAfterDeepSleep,
    };

/*******************************************************************************
*                           Function Prototypes                                *
*******************************************************************************/
extern SINT32 zDrvPmic_SetVaoNormSlp(T_ZDrvZx234290_VbuckA vol);
extern VOID zDrvPow_ChargerOnSleepOpt(VOID);

/****************************************************************************
*                                           function
****************************************************************************/

/*******************************************************************************
 * Function: Pow_xx_Sleep
 * Description:
 * Parameters:
 *   Input: N/A
 *
 *   Output: N/A
 * Returns: N/A
 * Others:
********************************************************************************/
UINT32 Pow_Kernel_Sleep(UINT32 sleep_time)
{
    zDrvPow_KernelSleep();
    return 0;
}

UINT32 Pow_Boot_Sleep(UINT32 sleep_time)
{
    if(zDrvComm_GetPowerOnState() == POWER_ON_CHARGING)
   {
   	return zDrvPow_ChargerSleep(sleep_time);
    }
    else
    {
    	return zDrvPow_BootSleep(sleep_time);
    }
}

UINT32 Pow_deep_sleep(UINT32 sleep_time)
{
    return zDrvPow_PsmDeepSleep(sleep_time);
}
#endif

/*******************************************************************************
 * Function: Pow_Sleep_Func
 * Description:
 * Parameters:
 *   Input: N/A
 *
 *   Output: N/A
 * Returns: N/A
 * Others:
********************************************************************************/
UINT32 zDrvPow_Sleep_Func(T_ZDrvPow_SleepMode sleep_mode, UINT32 sleep_time)
{
    UINT32 real_sleep_time = 0;

    if(sleep_mode >= MAX_SLEEP_MODE)
    {
        zDrv_ASSERT(0);
    }

#if PSM_CPU_CP
    switch(sleep_mode)
    {
        case KERNEL_SLEEP_MODE:
        {
            real_sleep_time = Pow_Kernel_Sleep(sleep_time);
            break;
        }
        case BOOT_SLEEP_MODE:
        {
            real_sleep_time = Pow_Boot_Sleep(sleep_time);
            break;
        }
        case LOSSCOVERAGE_SLEEP_MODE:
        case AIRPLANE_SLEEP_MODE:
        case DEEP_SLEEP_MODE:
        {
            real_sleep_time = Pow_deep_sleep(sleep_time);
            break;
        }
        default:
        {
            real_sleep_time = Pow_Kernel_Sleep(sleep_time);
            break;
        }
    }
#endif

    return real_sleep_time;

}

#if PSM_CPU_CP
/*******************************************************************************
 * Function: pow_RefBeforeSleep
 * Description: the int enable for ps core deep sleep
 * Parameters:
 *   Input: N/A
 *
 *   Output: N/A
 * Returns: N/A

 * Others:  //not use
********************************************************************************/
static VOID pow_RefBeforeDeepSleep(VOID)
{

}


/*******************************************************************************
 * Function: pow_RefAfterSleep
 * Description:
 * Parameters:
 *   Input: N/A
 *
 *   Output: N/A
 * Returns: N/A

 * Others:  //not use
 ********************************************************************************/
static VOID pow_RefAfterDeepSleep(VOID)
{

}

/*******************************************************************************
 * Function: zDrvPow_Idle2ConnecSetVcore0V9
 * Description:
 * Parameters:
 *   Input: N/A
 *
 *   Output: N/A
 * Returns: N/A
 * Others:
*********************************************************************************/
SINT32 zDrvPow_Idle2ConnecSetVcore0V9(VOID)
{
    SINT32 nRet = DRV_SUCCESS;
    return DRV_SUCCESS;
    if(!ATCFG_VCORE_NODVS)
    {
        /*nRet = zDrvPmic_SetVcoreNormSlp(VBUCKA_0_900);*/
        nRet = Zx234290_SetVbuck1(VBUCKA_0_900);
        //nRet = Zx234290_SetVbuck1(VBUCKA_0_850);
    }
     if(nRet != DRV_SUCCESS)
    {
        return DRV_ERROR;
    }
    /*nRet = zDrvPmic_SetVaoNormSlp(VBUCKA_0_900);
    if(nRet != DRV_SUCCESS)
    {
        return DRV_ERROR;
    }*/
    return DRV_SUCCESS;
}

/*******************************************************************************
 * Function:        pow_PowerDomainInit
 * Description:
 * Parameters:
 *   Input: N/A
 *
 *   Output: N/A
 * Returns: N/A
 * Others:
*********************************************************************************/
VOID pow_PowerDomainInit(VOID)
{
#ifndef _USE_PSM_OPT
    //zDrvpow_SetPwrGate(GSM_RAM_PWR, POW_DISABLE);
    //zDrvpow_SetPwrGate(GSM_DSP_PWR, POW_DISABLE);
#endif

    //zDrvpow_SetPwrGate(USB_HSIC_PWR, POW_DISABLE);
}


/*******************************************************************************
 * Function: pow_RefInit
 * Description:
 * Parameters:
 *   Input: N/A
 *
 *   Output: N/A
 * Returns: N/A

 * Others:  //not use
 ********************************************************************************/

SINT32 pow_RefInit(VOID)
{
   // zDrvPow_PcuSetWakeSource(wake_int);

  //  pow_PowerDomainInit();
   // zDrvPow_ChargerOnSleepOpt();
 //   zDrvPow_ChargerOnSleepInit();

  //  zDrvPow_SetOpt(&s_powOpt);

    return DRV_SUCCESS;
}
#endif

