/*******************************************************************************
 * Copyright (C) 2013, ZTE Corporation.
 *
 * File Name:   hal_refconfig.c
 * File Mark:
 * Description:  This file contains the drv refer design config.
 * Others:
 * Version:       V1.0
 * Author:        geanfeng
 * Date:          2013-04-03
  ******************************************************************************/

/****************************************************************************
*                                  Include files
****************************************************************************/
#define DRV_CONFIG_WRITE_ENABLE

#include "drvs_general.h"
#include "drvs_config.h"
#include "drvs_chip_cfg.h"

/****************************************************************************
* 	                                           Local Macros
****************************************************************************/
/****************************************************************************
* 	                                           Local Types
****************************************************************************/

/****************************************************************************
* 	                                           Local Constants
****************************************************************************/
/****************************************************************************
 * Function:   zDrvConfig_Initiate
 * Description: initialize drv configuration;
 * Parameters:
 *   Input:
 *   Output:
 *
 * Returns:
 *     SINT32
 *
 * Others:
 ***************************************************************************/

#define BOOTSEL_INFO	   (A1_CRM_REG_BASE+0x4)
#define readl(reg)	(*((volatile unsigned int *) (reg)))



static int get_flasht_type(void)
{  
   char boot_mode = 0;
    

	boot_mode= (readl(BOOTSEL_INFO)&7);/* SPI NAND BOOT*/
	
	if((boot_mode == 4)||(boot_mode == 5) )
	{
		return 1;
	}
	else /*  NAND BOOT*/
	{
        return 0;
	}
}


SINT32 zDrvConfig_Initiate(VOID)
{
     //DRV_CONFIG(USB_HIGHSPEED) = 1;
     DRV_CONFIG(USB_VNIC_ADJUST_MAXPKTNUM) = 1;
	 
     /* I2C */
     DRV_CONFIG(USE_PMIC_I2C) = 1;
     /*DRV_CONFIG(USE_I2C0) = 1;*/
     DRV_CONFIG(USE_I2C1) = 1; 
     
     /* FLASH TYPE */

	 
    
     if(0 == get_flasht_type())
 	{
 		 DRV_CONFIG(USE_NAND) = 1;
		 DRV_CONFIG(USE_SPI_NAND) = 0;
 	}
	 else
 	{
		 DRV_CONFIG(USE_NAND) = 0;
		 DRV_CONFIG(USE_SPI_NAND) = 1;
 	}
   
   

     DRV_CONFIG(USE_MMC) = 0;
	 
     DRV_CONFIG(USE_PART) = 1;
         
     DRV_CONFIG(USB_HIGHSPEED) = 1;
     DRV_CONFIG(USB_VNIC_HALF_DL_BUFF_CNT) = 1;     
     return DRV_SUCCESS;
}

#if 0/*˹ܺͨzDrvInt_DelayUnmaskAdd(UINT32 intLine)ӣҪ޸ĸýӿڣ"drvs_int.h"*/
/****************************************************************************
 * Function:   zDrvInt_DelayUnmask
 * Description: TOSãжЩжҪӳٽ
 * Parameters:
 *   Input:жϺ
 *   Output:ҪӳUnmask0;
 *
 * Returns:
 *     SINT32
 *
 * Others:
 ***************************************************************************/
SINT32 zDrvInt_DelayUnmask(UINT32 intLine)
{
    switch (intLine) {
    /*case EX0_INT:
        return 0;*/
    default:
        return 1;
    }

}
#endif

