/*******************************************************************************
 * Copyright (C) 2014, ZTE Corporation.
 *
 * File Name:
 * File Mark:
 * Description:
 * Others:
 * Version:       V1.0
 * Author:        caidaofang
 * Date:          2014-7-11
 * History 1:
 *     Date:
 *     Version:
 *     Author:
 *     Modification:
 * History 2:
  ********************************************************************************/
#include "drvs_general.h"
#include "drvs_gpio.h"

#define UART_DEFAULT_BAUDRATE  115200
#define  UART_DEFAULT_DATA_BITS     8
#define UART_DEFAULT_FLOW_CONTROL   ZDRV_DEV_UART_FCTL_OFF
#define UART_DEFAULT_PARITY   ZDRV_DEV_UART_PARITY_NULL
#define  UART_DEFAULT_STOP_BITS    1

#define UART_TX_BUF_SIZE    8192
#define UART_RX_BUF_SIZE    2048*8

#define  UART_PORTN_0   0
#define  UART_PORTN_1   1
//#define  UART_PORTN_2   2

UINT32 uart0_rxd = 0;
UINT32 uart0_txd = 0;
UINT32 uart1_rxd = 0;
UINT32 uart1_txd = 0;
//UINT32 uart2_rxd = 0;
//UINT32 uart2_txd = 0;


UINT8 UART_FCTL_FLAG = FALSE;

extern SINT32 halUart_Init(UINT32  ifacNum,T_ZDrvSio_DataConfig  uartConfig);


/*******************************************************************************
 * Function: zDrvUart_SetInstance
 * Description: set uartConfig
 * Parameters:
 *   Input: N/A
 *
 *   Output: N/A
 * Returns: N/A

********************************************************************************/

VOID zDrvUart_SetInstance(VOID)
{
    T_ZDrvSio_DataConfig uart_cfg;


    uart_cfg.baudrate=UART_DEFAULT_BAUDRATE;
    uart_cfg.dataBits = UART_DEFAULT_DATA_BITS;
    uart_cfg.flowControl = UART_DEFAULT_FLOW_CONTROL;
    uart_cfg.parity  = UART_DEFAULT_PARITY;
    uart_cfg.stopBits = UART_DEFAULT_STOP_BITS;
	    
    halUart_Init(0,uart_cfg);
    halUart_Init(1,uart_cfg);
   // halUart_Init(2,uart_cfg);
	
    if(uart_cfg.flowControl == ZDRV_DEV_UART_FCTL_OFF)
    {
        UART_FCTL_FLAG = FALSE;
    }
    else
    {
        UART_FCTL_FLAG = TRUE;
    }
    return;
}


/*******************************************************************************
 * Function: zDrvUart_SetI2CforUart_Flow
 * Description: set  I2C  pins
 * Parameters: flag = 1 ,enable HW Flow
 *   Input: N/A
 *
 *   Output: N/A
 * Returns: N/A

********************************************************************************/

static VOID zDrvUart_SetI2CforUart_Flow(UINT8 flag)

{
#if 0
   if(flag == 1)
   {
	 zDrvGpio_SetFunc(GPIO8, 2);
	 zDrvGpio_SetFunc(GPIO9, 2);
   }
   else
   {
     zDrvGpio_SetFunc(GPIO8, 0);
	 zDrvGpio_SetFunc(GPIO9, 0);
    
   }
#endif
}

/*******************************************************************************
 * Function: zDrvUart_SetGPIOforUart
 * Description: set pins
 * Parameters:
 *   Input: N/A
 *
 *   Output: N/A
 * Returns: N/A

********************************************************************************/
VOID zDrvUart_SetGPIOforUart(UINT8 UartNum)
{
    
    switch (UartNum)
    {/*7520V2*/
    case UART_PORTN_0:    
        uart0_rxd = zDrvGpio_Request("uart0_rxd");
        uart0_txd = zDrvGpio_Request("uart0_txd");
        zDrvGpio_SetFunc(uart0_rxd, GPIO29_UART0_RXD);
        zDrvGpio_SetFunc(uart0_txd, GPIO30_UART0_TXD);
	    break;
    case UART_PORTN_1:
        uart1_rxd = zDrvGpio_Request("uart0_cts");
        uart1_txd = zDrvGpio_Request("uart0_rts");
        zDrvGpio_SetFunc(uart1_rxd, GPIO33_UART1_RXD);
        zDrvGpio_SetFunc(uart1_txd, GPIO34_UART1_TXD);
        break;
  #if 0
    case UART_PORTN_2:
        uart2_rxd = zDrvGpio_Request("gpio211");
        uart2_txd = zDrvGpio_Request("gpio212");
        zDrvGpio_SetFunc(uart2_rxd, 3);/*0:gpio211  3:uart2_rxd */
        zDrvGpio_SetFunc(uart2_txd, 3);/*0:gpio212  3:uart2_txd */
        break;
   #endif
    default:
        break;
    }

    if(UART_FCTL_FLAG == TRUE)
    {
        zDrvUart_SetI2CforUart_Flow(TRUE);
    }
  
    return;
}
/*******************************************************************************
 * Function: zDrvUart_SetGPIOforGPIO
 * Description: set pins
 * Parameters:
 *   Input: N/A
 *
 *   Output: N/A
 * Returns: N/A

********************************************************************************/
VOID zDrvUart_SetGPIOforGPIO(UINT8 UartNum)
{

    switch (UartNum)
    {/*7520V2*/
    case UART_PORTN_0:      
        zDrvGpio_SetFunc(uart0_rxd, GPIO29_GPIO29);
        zDrvGpio_SetFunc(uart0_txd, GPIO30_GPIO30);
        zDrvGpio_Free(uart0_rxd);
        zDrvGpio_Free(uart0_txd);        
	    break;
    case UART_PORTN_1:
        zDrvGpio_SetFunc(uart1_rxd, GPIO33_GPIO33);
        zDrvGpio_SetFunc(uart1_txd, GPIO34_GPIO34);
        zDrvGpio_Free(uart1_rxd);
        zDrvGpio_Free(uart1_txd);
        break;
    #if 0
    case UART_PORTN_2:
        zDrvGpio_SetFunc(uart2_rxd, 0);/*0:gpio211  3:uart2_rxd */
        zDrvGpio_SetFunc(uart2_txd, 0);/*0:gpio212  3:uart2_txd */
        zDrvGpio_Free(uart2_rxd);
        zDrvGpio_Free(uart2_txd);
        break;
    #endif
    default:
        break;
    }
    if(UART_FCTL_FLAG == TRUE)
    {
       zDrvUart_SetI2CforUart_Flow(FALSE);
    }
    
    return;
}


