/*******************************************************************************
 * Copyright (C) 2010, ZTE Corporation.
 *
 * File Name:
 * File Mark:
 * Description:
 * Others:
 * Version:       V1.0
 * Author:        zhouyuchao
 * Date:          2013-7-30
 * History 1:
 *     Date:
 *     Version:
 *     Author:
 *     Modification:
 * History 2:
  ********************************************************************************/

/****************************************************************************
* 	                                           Include files
****************************************************************************/
#include "drvs_general.h"		// for common driver develop head file
#include "drvs_usb_config.h"
#include "NvParam_drv.h"
#include "RWNvParam_CTRM.h"
#include "tspconfig.h"

/****************************************************************************
* 	                               local Types
****************************************************************************/

/****************************************************************************
* 	                                        macro
****************************************************************************/
#define MAX_IP_DATA_NUM    0x608         //ip data 1544
#define USB_ECM_MAC_ADDR0 "00A0C6000000"
#define USB_ECM_MAC_ADDR1 "00A0C600000A"

#define MAX_VIC_NUM 2
#define ECM_FUNCTION0 {FALSE,0xff,{USB_ECM_MAC_ADDR0,0x00000000,MAX_IP_DATA_NUM,0x0001}}
#define ECM_FUNCTION1 {FALSE,0xff,{USB_ECM_MAC_ADDR1,0x00000000,MAX_IP_DATA_NUM,0x0001}}


//pid & vid define
#define	    VID_ZTE					0x19d2

#define 	PID_TSP					0x0201
#define 	PID_TSP_MUX				0xF084
#define 	PID_TSP_NDIS			0x0199
#define 	PID_TSP_RNDIS			0x0194
#define     PID_TSP_ECM 			0x0195
#define 	PID_A370_BOOT			0x0198	//for cdrom
#define 	PID_A370_NORMAL			0x0170	//for multi-interface
#define 	PID_TEST				0xff00


#define 	DEVICE_CLASSD			0x00
#define 	DEVICE_SUBCLASS			0x00
#define 	DEVICE_PROTOCOL			0x00

#define 	DEVICE_CLASS_IAD		0xEF
#define 	DEVICE_SUBCLASS_IAD		0x02
#define 	DEVICE_PROTOCOL_IAD		0x01

//const string define
#define STR_USB_PRODUCT_BOOT		"ZTE-CDROM"
#define STR_USB_PRODUCT_NORMAL	    "ZTE-Modem"
#define STR_USB_PRODUCT_TEST		"ZTE-Test"
#define STR_USB_VENDOR_ZTE		    "ZTE"

#ifdef _USE_AMT
#define STR_USB_SN_BOOT			    NULL
#define STR_USB_SN_NORMAL			NULL
#define STR_USB_SN_TEST			    NULL
#define STR_USB_SN_ECM				NULL
#else
#define STR_USB_SN_BOOT			    STR_USB_PRODUCT_BOOT
#define STR_USB_SN_NORMAL			STR_USB_PRODUCT_NORMAL
#define STR_USB_SN_TEST			STR_USB_PRODUCT_TEST
#define STR_USB_SN_ECM				STR_USB_VENDOR_ZTE		//"ZTE-ECM"
#endif

/* USB⴮ֱַdrvs_io_names.h к궨 */
#define STR_USB_IFAC_AT			ZDRV_DEV_VCOM_AT		//"USB-AT"
#define STR_USB_IFAC_AT_02			ZDRV_DEV_VCOM_AT_02	//"USB-AT(2)" for DUAL STANDBY
#define STR_USB_IFAC_MODEM		ZDRV_DEV_VCOM_MODEM	//"USB-Modem"
#define STR_USB_IFAC_LOG			ZDRV_DEV_VCOM_LOG		//"USB-log"
#define STR_USB_IFAC_AMT			ZDRV_DEV_VCOM_AMT		//"USB-AMT"
#define STR_USB_IFAC_MUX			ZDRV_DEV_VCOM_SOUND	//"USB-mux"
#define STR_USB_IFAC_SOUND		ZDRV_DEV_VCOM_MUX		//"USB-sound"

#define STR_USB_IFAC_DIAG			"USB-Diag"
#define STR_USB_IFAC_MASS			"USB-MassStorage"
#define STR_USB_IFAC_RNDIS			"USB-Rndis"
#define STR_USB_IFAC_NDIS			"USB-NDIS"
#define STR_USB_IFAC_ECM			"USB-Ecm"


extern SINT32 usbStack_CdcInterface_Bind(UINT8* config_buf, VOID* context, UINT8 interfaceNum, UINT32 speed);
extern SINT32 usbStack_NdisInterface_Bind(UINT8* config_buf, VOID* context, UINT8 interfaceNum, UINT32 speed);
extern SINT32 usbStack_MassStorageInterface_Bind(UINT8* config_buf, VOID* context, UINT8 interfaceNum, UINT32 speed);
extern SINT32 usbStack_EcmControlInterface_Bind(UINT8* config_buf, VOID* context, UINT8 interfaceNum, UINT32 speed);
extern SINT32 usbStack_EcmDataInterface_Bind(UINT8* config_buf, VOID* context, UINT8 interfaceNum, UINT32 speed);
extern SINT32 usbStack_RndisControlInterface_Bind(UINT8* config_buf, VOID* context, UINT8 interfaceNum, UINT32 speed);
extern SINT32 usbStack_RndisDataInterface_Bind(UINT8* config_buf, VOID* context, UINT8 interfaceNum, UINT32 speed);
extern 	SINT32 zDrvPmic_OpenUsbPower(VOID);
extern SINT32 zDrvPmic_CloseUsbPower(VOID);

// interface function class based by cdc and mass
#define USB_IFAC_NULL					{FALSE,0,USB_NULL_EP,USB_NULL_EP,USB_NULL_EP,NULL,NULL}

//cdc interface
#define USB_IFAC_AT(epNum)			USB_IFAC_CDC_CPU(DEV_CDC,epNum,STR_USB_IFAC_AT,usbStack_CdcInterface_Bind)
#define USB_IFAC_AT_02(epNum)		USB_IFAC_CDC_CPU(DEV_CDC,epNum,STR_USB_IFAC_AT_02,usbStack_CdcInterface_Bind)
#define USB_IFAC_MODEM(epNum)		USB_IFAC_CDC_CPU(DEV_CDC,epNum,STR_USB_IFAC_MODEM,usbStack_CdcInterface_Bind)
#define USB_IFAC_LOG(epNum)		USB_IFAC_CDC_CPU(DEV_CDC,epNum,STR_USB_IFAC_LOG,usbStack_CdcInterface_Bind)
#define USB_IFAC_AMT(epNum)		USB_IFAC_CDC_CPU(DEV_CDC,epNum,STR_USB_IFAC_AMT,usbStack_CdcInterface_Bind)

//mass interface
#define USB_IFAC_MASS(funCode,epNum)  	USB_IFAC_MASS_CPU(funCode,epNum,STR_USB_IFAC_MASS,usbStack_MassStorageInterface_Bind)

//NDIS Interface
#define USB_IFAC_NDIS(epNum1,epNum2)  USB_IFAC_NDIS_CPU(DEV_NDIS,epNum1,epNum2,STR_USB_IFAC_NDIS,usbStack_NdisInterface_Bind)

//ECM Interface
#define USB_CCIFAC_ECM(epNum)  	USB_CCIFAC_ECM_CPU(DEV_ECM_CCI,epNum,STR_USB_IFAC_ECM,usbStack_EcmControlInterface_Bind)
#define USB_DCIFAC_ECM(epNum)  	USB_DCIFAC_ECM_DMA(DEV_ECM_DCI,epNum,STR_USB_IFAC_ECM,usbStack_EcmDataInterface_Bind)

//RNDIS Interface
#define USB_CCIFAC_RNDIS(epNum)     USB_CIFAC_RNDIS_CPU(DEV_RNDIS_CCI,epNum,STR_USB_IFAC_RNDIS,usbStack_RndisControlInterface_Bind)
#define USB_DCIFAC_RNDIS(epNum)     USB_DIFAC_RNDIS_DMA(DEV_RNDIS_DCI,epNum,STR_USB_IFAC_RNDIS,usbStack_RndisDataInterface_Bind)

//device base class
#define USB_DEV_ZTE(pProductName,pSerialNum,uiPID,DeviceClass,DeviceSubClas,DeviceProtocol) 	{STR_USB_VENDOR_ZTE,pProductName,pSerialNum,VID_ZTE,uiPID,DeviceClass,DeviceSubClas,DeviceProtocol}


#define USB_DEV_ZTE_TSP			    USB_DEV_ZTE(STR_USB_PRODUCT_NORMAL,STR_USB_SN_NORMAL,PID_TSP,0,0,0)
#define USB_DEV_ZTE_TSP_MUX		    USB_DEV_ZTE(STR_USB_PRODUCT_NORMAL,STR_USB_SN_NORMAL,PID_TSP_MUX,0,0,0)
#define USB_DEV_ZTE_TSP_NDIS		USB_DEV_ZTE(STR_USB_PRODUCT_NORMAL,STR_USB_SN_NORMAL,PID_TSP_NDIS,0,0,0)
#define USB_DEV_ZTE_TSP_RNDIS		USB_DEV_ZTE(STR_USB_PRODUCT_NORMAL,STR_USB_SN_NORMAL,PID_TSP_RNDIS,0,0,0)
#define USB_DEV_ZTE_TSP_ECM         USB_DEV_ZTE(STR_USB_PRODUCT_NORMAL,STR_USB_SN_ECM,PID_TSP_NDIS,0x02,0,0)
#define USB_DEV_ZTE_A370_BOOT		USB_DEV_ZTE(STR_USB_PRODUCT_BOOT,STR_USB_SN_BOOT,PID_A370_BOOT,0,0,0)
#define USB_DEV_ZTE_A370			USB_DEV_ZTE(STR_USB_PRODUCT_NORMAL,STR_USB_SN_NORMAL,PID_A370_NORMAL,0,0,0)
#define USB_DEV_ZTE_TEST			USB_DEV_ZTE(STR_USB_PRODUCT_TEST,STR_USB_SN_TEST,PID_TEST,0,0,0)

#define USB_DEV_ZTE_CDROM			USB_DEV_ZTE(STR_USB_PRODUCT_BOOT,STR_USB_SN_BOOT,PID_A370_BOOT,DEVICE_CLASS_IAD,DEVICE_SUBCLASS_IAD,DEVICE_PROTOCOL_IAD)

//------------------------------------------------------------------------------------------------------------------
//SET config
//------------------------------------------------------------------------------------------------------------------
//for datacard selfboot
#if 0
#define USB_CONFIG_COMBINE0	{TRUE,USB_DEV_ZTE_A370_BOOT,{USB_IFAC_MASS(DEV_MASSSTORAGE_CDROM,6),\
															USB_IFAC_NULL,\
															USB_IFAC_NULL,\
															USB_IFAC_NULL,\
															USB_IFAC_NULL,\
															USB_IFAC_NULL,\
															USB_IFAC_NULL}}
#else
#define USB_CONFIG_COMBINE0	{TRUE,USB_DEV_ZTE_CDROM,{USB_IFAC_MASS(DEV_MASSSTORAGE_CDROM,6),\
															USB_IFAC_NULL,\
															USB_IFAC_NULL,\
															USB_IFAC_NULL,\
															USB_IFAC_NULL,\
															USB_IFAC_NULL,\
															USB_IFAC_NULL}}
#endif
//------------------------------------------------------------------------------------------------------------------
//AT,Log,Modem 
#define USB_CONFIG_COMBINE1	{TRUE,USB_DEV_ZTE_TSP,{USB_IFAC_AT(1),\
												USB_IFAC_NULL,\
												USB_IFAC_LOG(3),\
												USB_IFAC_NULL,\
												USB_IFAC_NULL,\
												USB_IFAC_NULL,\
												USB_IFAC_NULL}}
//------------------------------------------------------------------------------------------------------------------
//AT,Log,Modem,NDIS;  sigle VIC in Windows
#define USB_CONFIG_COMBINE2	{TRUE,USB_DEV_ZTE_TSP_NDIS,{USB_IFAC_AT(1),\
												USB_IFAC_NDIS(2,3),\
												USB_IFAC_MODEM(4),\
												USB_IFAC_LOG(5),\
												USB_IFAC_NULL,\
												USB_IFAC_NULL,\
												USB_IFAC_NULL}}

//------------------------------------------------------------------------------------------------------------------
//AT,Log,Modem,RNDIS; sigle VIC in Windows
#define USB_CONFIG_COMBINE3	{TRUE,USB_DEV_ZTE_TSP_RNDIS,{USB_CCIFAC_RNDIS(1),\
  									    		       USB_DCIFAC_RNDIS(2),\
												USB_IFAC_AT(3),\
												USB_IFAC_MODEM(4),\
												USB_IFAC_LOG(5),\
												USB_IFAC_AT_02(6),\
												USB_IFAC_NULL}}

//------------------------------------------------------------------------------------------------------------------
//AT,Log,Modem,Single ECM;  Single VIC in Mac Os
#define USB_CONFIG_COMBINE4	{TRUE,USB_DEV_ZTE_TSP_ECM,{USB_CCIFAC_ECM(1),\
												USB_DCIFAC_ECM(2),\
												USB_IFAC_AT(3),\
												USB_IFAC_MODEM(4),\
												USB_IFAC_LOG(5),\
												USB_IFAC_AT_02(6),\
												USB_IFAC_NULL}}

//------------------------------------------------------------------------------------------------------------------
//AT,Log,Modem,Double NDIS;  for Double VIC in Windows 
#define USB_CONFIG_COMBINE5	{TRUE,USB_DEV_ZTE_TSP_NDIS,{USB_IFAC_AT(1),\
												USB_IFAC_NDIS(2,3),\
												USB_IFAC_MODEM(4),\
												USB_IFAC_LOG(5),\
												USB_IFAC_NDIS(6,7),\
												USB_IFAC_NULL,\
												USB_IFAC_NULL}}

//------------------------------------------------------------------------------------------------------------------
//Log,double ECM
#define USB_CONFIG_COMBINE6	{TRUE,USB_DEV_ZTE_TSP_ECM,{USB_CCIFAC_ECM(1),\
												USB_DCIFAC_ECM(2),\
												USB_IFAC_LOG(3),\
												USB_CCIFAC_ECM(7),\
												USB_DCIFAC_ECM(4),\
												USB_IFAC_NULL,\
												USB_IFAC_NULL}}
//------------------------------------------------------------------------------------------------------------------
// single Rndis: 
#define USB_CONFIG_COMBINE7	{TRUE,USB_DEV_ZTE_TSP_RNDIS,{USB_CCIFAC_RNDIS(1),\
  									    		       USB_DCIFAC_RNDIS(2),\
												USB_IFAC_NULL,\
												USB_IFAC_NULL,\
												USB_IFAC_NULL,\
												USB_IFAC_NULL,\
												USB_IFAC_NULL}}
//------------------------------------------------------------------------------------------------------------------
// single Ecm: 
#define USB_CONFIG_COMBINE8	{TRUE,USB_DEV_ZTE_TSP_ECM,{USB_CCIFAC_ECM(1),\
  									    		       USB_DCIFAC_ECM(2),\
												USB_IFAC_NULL,\
												USB_IFAC_NULL,\
												USB_IFAC_NULL,\
												USB_IFAC_NULL,\
												USB_IFAC_NULL}}

//------------------------------------------------------------------------------------------------------------------
#define USB_CONFIG_COMBINE9	{TRUE,USB_DEV_ZTE_TEST,{USB_IFAC_MASS(DEV_MASSSTORAGE_RAMDISK,1),\
												USB_IFAC_NULL,\
												USB_IFAC_NULL,\
												USB_IFAC_NULL,\
												USB_IFAC_NULL,\
												USB_IFAC_NULL,\
												USB_IFAC_NULL}}
//------------------------------------------------------------------------------------------------------------------


#define USB_CONFIG0_FUN      USB_CONFIG_COMBINE0     //default cdrom
#define USB_CONFIG1_FUN      USB_CONFIG_COMBINE4     // switch to single ecm
#define USB_CONFIG2_FUN      USB_CONFIG_COMBINE2     //switch to single ndis
#define USB_CONFIG3_FUN      USB_CONFIG_COMBINE1     //amt only
#define USB_CONFIG4_FUN      USB_CONFIG_COMBINE3     //switch to single rndis

#if !defined(_USE_AMT)&&!defined(_USE_SMALL_VERSION)
#define DEFAULT_INSERT_CONFIG       		USB_CONFIG0  //first config with cdrom 
#define DEFAULT_SWITCH_CONFIG_ECM        	USB_CONFIG1
#define DEFAULT_SWITCH_CONFIG_NDIS     		USB_CONFIG2
#define DEFAULT_INSERT_CONFIG_AMT   		USB_CONFIG3  //amt only
#define DEFAULT_SWITCH_CONFIG_RNDIS   		USB_CONFIG4
#else
#define DEFAULT_INSERT_CONFIG       		USB_CONFIG3
#define DEFAULT_INSERT_CONFIG_AMT   		USB_CONFIG3
#define DEFAULT_SWITCH_CONFIG_NDIS     		USB_CONFIG3
#define DEFAULT_SWITCH_CONFIG_RNDIS   		USB_CONFIG3
#define DEFAULT_SWITCH_CONFIG_ECM        	USB_CONFIG3

#endif

/****************************************************************************
* 	                               Global Constants
****************************************************************************/
static T_ZDrvUsb_ConfigContext g_ConfigContextList[USB_MAX_CONFIG_NUM]=
    {
        USB_CONFIG0_FUN,
        USB_CONFIG1_FUN,
        USB_CONFIG2_FUN,
        USB_CONFIG3_FUN,
        USB_CONFIG4_FUN,       
    };



T_ZDrvUsb_EcmContext g_EcmFunction[MAX_VIC_NUM] = 
{
    ECM_FUNCTION0,
    ECM_FUNCTION1,
};

//usb IP config
T_ZDrvUsb_IP g_usbIP[] = 
{
#if 0
    {
        USB_HSIC, //usb-hsic
#ifdef 	_DRV_USB_HSIC_HOST
		USE_USB_HOST
#else
        USB_NONE  //no used
#endif
    },
#endif    
    {
        USB_DWC3,    	 //usb-dwc3 
        USE_USB_DEVICE  //use as usb device
    }
};

/****************************************************************************
* 	                                          Function Definitions
****************************************************************************/
#if defined(_CORE_ARM0)
//extern T_SYS_NV_HOST_OS_FLAG g_BootCheckOsFlag;//zhouyuchao bootloader distinguish os flag
//extern T_SYS_NV_HOST_OS_TYPE g_BootCheckOsType;
UINT8 g_DevOpenSemFlag = 0;//ƽ̨zDrv_OpenʱҪһķʽ1Ҫź0Ҫ
#endif

// 1:usb hisc 0:usb normal 
T_ZDrvUsb_PhyType g_UsbMode = USB_DWC3; 

extern T_SYS_NV_FUN_CTRL_FLAG  zSys_NvGetCdromFlag(VOID);
extern T_ZDrvUsb_OSType zDrvSys_GetOSType(VOID);
extern UINT32 zOss_GetLteFlagInfo(VOID);
extern SINT32 halusb_DeviceInit(T_ZDrvUsb_PhyType usbType);

/*******************************************************************************
 * Function: usbHal_GetUsbConfigContext
 * Description: get usb config context
 * Parameters:
 *   Input: N/A
 *
 *   Output: N/A
 * Returns: N/A

********************************************************************************/
T_ZDrvUsb_ConfigContext* usbHal_GetUsbConfigContext(UINT32 ConfigNum)
{
 	return &g_ConfigContextList[ConfigNum];
}


/*******************************************************************************
 * Function: usbHal_GetEcmConfigContext
 * Description: get ecm parameter
 * Parameters:
 *   Input: N/A
 *
 *   Output: N/A
 * Returns: N/A

 * Others:	//not use

 ********************************************************************************/
T_ZDrvUsb_EcmContext * usbHal_GetEcmConfigContext(UINT8 ifacNum_CCI)
{
    UINT8 index = 0;
    for(index = 0;index < MAX_VIC_NUM;index++)
    {
        if(g_EcmFunction[index].bIsVaild == FALSE)
        {
            g_EcmFunction[index].bIsVaild = TRUE;
            g_EcmFunction[index].ifacNum_CCI = ifacNum_CCI;
            break;
        }
        else if(g_EcmFunction[index].ifacNum_CCI == ifacNum_CCI)	
        {
            break;
        }
    }
    if(index != MAX_VIC_NUM)
    {
        return&g_EcmFunction[index];
    }
    return NULL;
}

/*******************************************************************************
 * Function: usbHal_CleanEcmConfigContext
 * Description: clean ecm parameter state
 * Parameters:
 *   Input: N/A
 *
 *   Output: N/A
 * Returns: N/A

 * Others:	//not use

 ********************************************************************************/
VOID usbHal_CleanEcmConfigContext(VOID)
{
	UINT8 index = 0;
	for(index = 0;index < MAX_VIC_NUM;index++)
	{
		if(g_EcmFunction[index].bIsVaild == TRUE)
		{
			g_EcmFunction[index].bIsVaild = FALSE;
		}
	}
}


/*******************************************************************************
 * Function: usbHal_SetUsbMode
 * Description: set usb mode hsic or normal
 * Parameters:
 *   Input: N/A
 *
 *   Output: N/A
 * Returns: N/A

 * Others:	//not use

 ********************************************************************************/
VOID usbHal_SetUsbMode(T_ZDrvUsb_PhyType usbMode)
{
    g_UsbMode = usbMode;
}

/*******************************************************************************
 * Function: usbHal_GetUsbMode
 * Description: get usb mode hisc or normal
 * Parameters:
 *   Input: N/A
 *
 *   Output: N/A
 * Returns: N/A

 * Others:	//not use

 ********************************************************************************/
T_ZDrvUsb_PhyType usbHal_GetUsbMode(VOID)
{
    return g_UsbMode;
}

/*******************************************************************************
 * Function: usbHal_IsFreeDrvMode
 * Description: get usb drv mode  free or not
 * Parameters:
 *   Input: N/A
 *
 *   Output: 
 * Returns: 

 * Others:	//not use

 ********************************************************************************/
BOOL usbHal_IsFreeDrvMode(VOID)
{	
    return FALSE;
}

/*******************************************************************************
 * Function: usbHal_HSICReConnect_Ind
 * Description: only for usb hsic trap ind to host
 * Parameters:
 *   Input: N/A
 *
 *   Output: N/A
 * Returns: N/A

 * Others:	//not use

 ********************************************************************************/

VOID usbHal_HSICReConnect_Ind(VOID)
{

}


/*******************************************************************************
 * Function: usbStack_msSetNVflag
 * Description: used in datecard set AT\Log\Modem flag in NV 
 *              with singn whether enum it
 * Parameters:
 *   Input: N/A
 *
 *   Output: N/A
 * Returns: N/A

 * Others:	//not use

 ********************************************************************************/
SINT32 usbStack_msSetNVflag()
{
    return DRV_SUCCESS;
}
/*******************************************************************************
 * Function: zDrvRef_NvGetCdromFlag
 * Description: get cdrom flag
 * Parameters:
 *   Input: N/A
 *
 *   Output: N/A
 * Returns: N/A

 * Others:	//not use

 ********************************************************************************/
T_SYS_NV_FUN_CTRL_FLAG  zDrvRef_NvGetCdromFlag(VOID)
{
    T_SYS_NV_FUN_CTRL_FLAG Flag = OFF_STATE;
    return Flag;
}

/*******************************************************************************
 * Function: zDrvRef_NvGetForceNetCardType
 * Description: get nv force net card type
 * Parameters:
 *   Input: N/A
 *
 *   Output: N/A
 * Returns: N/A

 * Others:	//read net force type before nvm init,so use zDrvNand_Read interface,not zOss_NvItemRead 

 ********************************************************************************/
T_SYS_NV_FORCE_VNIC_TYPE zDrvRef_NvGetForceVNICType(VOID)
{
    return FORCE_RNDIS;
}

/*******************************************************************************
 * Function: usbHal_RefSetForceNetCardType
 * Description: test for evb 
 * Parameters:
 *   Input: N/A
 *
 *   Output: N/A
 * Returns: N/A

 * Others:	//not use

 ********************************************************************************/
T_SYS_NV_FORCE_VNIC_TYPE  usbHal_RefSetForceVNICType(T_ZDrvUsb_NVTYPE type)
{
    return FORCE_RNDIS;
}

/*******************************************************************************
 * Function: zDrvRef_NvSetNetCardTypeForWin
 * Description: set nv net card type for windows
 * Parameters:
 *   Input: N/A
 *
 *   Output: N/A
 * Returns: N/A

 * Others:	//not use

 ********************************************************************************/
UINT32 zDrvRef_NvGetVNICTypeForWin(VOID)
{
    return SELECT_RNDIS;
}
/*******************************************************************************
 * Function: usbHal_RefSetForceNetCardType
 * Description: test for evb 
 * Parameters:
 *   Input: N/A
 *
 *   Output: N/A
 * Returns: N/A

 * Others:	//not use

 ********************************************************************************/
T_SYS_NV_VNIC_TYPE_FOR_WIN  usbHal_RefSetVNICTypeForWin(T_ZDrvUsb_NVTYPE type)
{
    return SELECT_RNDIS;
}
/*******************************************************************************
* Function: zDrvSys_GetUsbDefaultInsertConfigNum
* Description:
* Parameters:
*   Input:
*
*   Output:
*
* Returns:
*
* Others:zhouyuchao modify
********************************************************************************/
T_ZDrvUsb_ConfigType zDrvSys_GetUsbDefaultInsertConfigNum(VOID)
{
    return DEFAULT_INSERT_CONFIG;
}

VOID usbHal_GetRefNvFlag(VOID)
{
    UINT32  retCode = ZOSS_ERROR;
    UINT8 num = 0;
    retCode = zDrvNand_Read(ZPS_CTRM_MSINFO_RNDISIPNUM_BASE_ADDR,ZPS_CTRM_MSINFO_MAX_RNDISIPNUM_LEN,(UINT8 *)&num);
    if (ZOSS_SUCCESS != retCode)
    {
        return;
    }
    usbStack_SetWrapPktNum(num);
    return;
}

/*******************************************************************************
* Function: zDrvSys_GetUsbInsertConfig
* Description:
* Parameters:
*   Input:
*
*   Output:
*
* Returns:
*
* Others:zhouyuchao modify
********************************************************************************/
T_ZDrvUsb_ConfigType zDrvSys_GetUsbInsertConfigNum(VOID)
{
#if defined(_CORE_ARM0)

    T_ZDrvUsb_ConfigType configType = USB_MAX_CONFIG_NUM;

    //T_SYS_NV_FUN_CTRL_FLAG ctrl_flag = ERR_STATE;
    T_SYS_NV_FORCE_VNIC_TYPE  fType  = FORCE_ERR;
    T_SYS_NV_VNIC_TYPE_FOR_WIN sType = SELECT_ERR;

    T_ZDrvUsb_OSType osType = zDrvSys_GetOSType();
	
    //ctrl_flag = zSys_NvGetCdromFlag();
    fType = zDrv_NvGetForceVNICType();
    sType = zDrv_NvGetVNICTypeForWin();	

    if(1)   //(ctrl_flag == OFF_STATE)
    {
        g_DevOpenSemFlag = 0;

        if((fType == FORCE_NDIS)||((fType == FORCE_INVALID)&&(sType == SELECT_NDIS)&&(OSType_Windows == osType)))
        {
            configType = DEFAULT_SWITCH_CONFIG_NDIS;    
        }	
        else if((fType == FORCE_RNDIS)||( (fType == FORCE_INVALID)&&(sType == SELECT_RNDIS)&&(OSType_Windows == osType)))	
        {
            configType = DEFAULT_SWITCH_CONFIG_RNDIS;         
        }
        else if((fType == FORCE_ECM)||( (fType == FORCE_INVALID)&&(OSType_Windows != osType)))
        {
            configType = DEFAULT_SWITCH_CONFIG_ECM;  
        }
        return configType ;
		
    }
    else
    {
        g_DevOpenSemFlag = 1;
        return DEFAULT_INSERT_CONFIG ;
    }

#else
    return DEFAULT_INSERT_CONFIG;

#endif
    //return DEFAULT_INSERT_CONFIG ;
}

/*******************************************************************************
* Function: zDrvSys_GetUsbSwitchConfigNum
* Description:
* Parameters:
*   Input:
*
*   Output:
*
* Returns:
*
* Others:
********************************************************************************/
T_ZDrvUsb_ConfigType zDrvSys_GetUsbSwitchConfigNum(VOID)
{
#if defined(_CORE_ARM0)

    T_ZDrvUsb_ConfigType configType = USB_MAX_CONFIG_NUM;

    T_SYS_NV_FORCE_VNIC_TYPE 	fType  = FORCE_ERR;
    T_SYS_NV_VNIC_TYPE_FOR_WIN 	sType = SELECT_ERR;

    T_ZDrvUsb_OSType osType = zDrvSys_GetOSType();
	
    fType = zDrv_NvGetForceVNICType();
    sType = zDrv_NvGetVNICTypeForWin();	

    if((fType == FORCE_NDIS)||((fType == FORCE_INVALID)&&(sType == SELECT_NDIS)&& (OSType_Windows == osType)))
    {
        configType = DEFAULT_SWITCH_CONFIG_NDIS;    
    }	
    else if((fType == FORCE_RNDIS)||( (fType == FORCE_INVALID)&&(sType == SELECT_RNDIS)&& (OSType_Windows == osType)))	
    {
        configType = DEFAULT_SWITCH_CONFIG_RNDIS;         
    }
    else if((fType == FORCE_ECM)||( (fType == FORCE_INVALID)&& (OSType_Windows != osType)))
    {
        configType = DEFAULT_SWITCH_CONFIG_ECM;  
    }
    return configType ;

#endif
}

/*******************************************************************************
 * Function: zDrvUsb_Work_Ahb_Phy_Reset
 * Description:
 * 
 * Parameters:
 *   Input:
 *
 *   Output:
 *
 * Returns:
 *
 *
 * Others:
 ********************************************************************************/
 VOID zDrvUsb_Work_Ahb_Phy_Reset(VOID)
{
	return;
}
/*******************************************************************************
 * Function: zDrvUsb_PowerUp
 * Description:
 * 
 * Parameters:
 *   Input:
 *
 *   Output:
 *
 * Returns:
 *
 *
 * Others:
 ********************************************************************************/
 SINT32 zDrvUsb_PowerUp(VOID)
{
	return DRV_SUCCESS;
}
/*******************************************************************************
 * Function: zDrvUsb_Powerdown
 * Description:
 * 
 * Parameters:
 *   Input:
 *
 *   Output:
 *
 * Returns:
 *
 *
 * Others:
 ********************************************************************************/
 SINT32 zDrvUsb_Powerdown(VOID)
{
	return DRV_SUCCESS;
}

/*******************************************************************************
 * Function: zDrvUsb3_PowerUp
 * Description:
 * 
 * Parameters:
 *   Input:
 *
 *   Output:
 *
 * Returns:
 *
 *
 * Others:
 ********************************************************************************/
SINT32 zDrvUsb3_PowerUp(VOID)
{
	SINT32 ret = DRV_SUCCESS;
#ifdef _USE_PSM
	ret = zDrvPmic_OpenUsbPower();
#endif
	return ret;	
}
/*******************************************************************************
 * Function: zDrvUsb3_Powerdown
 * Description:
 * 
 * Parameters:
 *   Input:
 *
 *   Output:
 *
 * Returns:
 *
 *
 * Others:
 ********************************************************************************/
SINT32 zDrvUsb3_Powerdown(VOID)
{
	SINT32 ret =DRV_SUCCESS;
#ifdef _USE_PSM
	ret = zDrvPmic_CloseUsbPower();
#endif
	return ret;
}

/*******************************************************************************
 * Function: pow_GetUsbLowPowerFlag
 * Description: get usb low power flag
 * Parameters:
 *   Input: N/A
 *
 *   Output: N/A
 * Returns: 
 *          
 *
 * Others:	//not use
 ********************************************************************************/
extern UINT32 g_usbIsPlug;
extern volatile UINT32 g_usbSuspend;/*g_usbSuspend=1: usb Suspend;  g_usbSuspend=0: usb Wakeup*/
UINT32 pow_GetUsbLowPowerFlag(VOID)
{

    return g_usbSuspend;

}

/*******************************************************************************
 * Function: zDrvUsb_Initiate
 * Description: 
 * Parameters: 
 *   Input:
 *
 *   Output:
 *
 * Returns: 
 *
 *
 * Others: 
 ********************************************************************************/
SINT32 zDrvUsb_Initiate(VOID)
{
    UINT8 i=0;
    SINT32 ret = DRV_SUCCESS;
	
    for(i=0;i<sizeof(g_usbIP)/sizeof(T_ZDrvUsb_IP);i++)
    {
        if(g_usbIP[i].usb_DRMode == USE_USB_DEVICE)
        {
            //usb device init
            usbHal_SetUsbMode(g_usbIP[i].usb_Tpye);
            ret = halusb_DeviceInit(g_usbIP[i].usb_Tpye);
        }
        else if(g_usbIP[i].usb_DRMode == USE_USB_HOST)
        {
#ifdef 	_DRV_USB_HSIC_HOST
            usbHost_Init();
#endif
            //for host init
        }
	 else
	 {
	     //usb ip no use, close 
	 }

	 if(ret != DRV_SUCCESS)
        {
            return DRV_ERROR;
        }
    }
	
    return ret;
}


