/*******************************************************************************
 * Copyright (C) 2010, ZTE Corporation.
 *
 * File Name:
 * File Mark:
 * Description:
 * Others:
 * Version:       V1.0
 * Author:        wujinlei
 * Date:          2013-8-24
 * History 1:
 *     Date:
 *     Version:
 *     Author:
 *     Modification:
 * History 2:
  ********************************************************************************/

/****************************************************************************
* 	                                           Include files
****************************************************************************/
#include "drvs_general.h"
#include "drvs_icp.h"
#include "drvs_usb_detect.h"

/****************************************************************************
* 	                               local Types
****************************************************************************/

/****************************************************************************
* 	                                        macro
****************************************************************************/
extern SINT32  zDrvChg_SetCurrent(UINT32 ChgType);
extern VOID usbHal_GetRefNvFlag(VOID);

/****************************************************************************
* 	                                          Function Definitions
****************************************************************************/
T_ZDrvUSBRef_ChargerDetect_CallBack g_USBRef_ChargerDetect = NULL;

/*******************************************************************************
 * Function: zDrvUsb_PluggedIn
 * Description:
 * Parameters:
 * Input:None
 * Output:None
 *
 * Returns:
 * Others:
 ********************************************************************************/
SINT32 zDrvUsb_PluggedIn(VOID)
{
    usbHal_GetRefNvFlag();
    usbHal_PluggedIn(); //state a fake usb insert event
    return DRV_SUCCESS;
}

/*******************************************************************************
 * Function: ReadChargerMsg
 * Description:
 * Parameters:
 * Input:None
 * Output:None
 *
 * Returns:
 * Others:
 ********************************************************************************/
UINT32 usbConnectDetect = 0;
VOID USBRef_Detect(VOID *buf, UINT32 len)
{
    if ((NULL == buf) || (0 == len))
    {
        zDrv_ASSERT(0);
    }

    if (*(T_UsbHal_ConnectMessage *)buf ==CONNECTED_TO_HOST)
    {
        usbHal_GetRefNvFlag();
        usbHal_PluggedIn();
        usbConnectDetect = CONNECTED_TO_HOST;
    }
    else if (*(T_UsbHal_ConnectMessage *)buf ==DISCONNECTED_FROM_HOST)
    {

        usbHal_PluggedOut();
        usbConnectDetect = DISCONNECTED_FROM_HOST;
    }
}

/*******************************************************************************
 * Function: usbHal_GetEcmConfigContext
 * Description: get ecm parameter
 * Parameters:
 *   Input: N/A
 *
 *   Output: N/A
 * Returns: N/A

 * Others:	//not use

 ********************************************************************************/
SINT32 USBRef_ChargerDetect(UINT32 dSts)
{
    SINT32 ret = 0;
    SINT32 which_plug = 0;
#if 0
    //zOss_Sleep(10);

    if (((dSts>>22)&0x3) ==3)
    {
        which_plug = CHARGER;
    }
    else
    {
        which_plug = COMPUTER;
    }
#else
    if ((((dSts>>3)&0x3FFF)!=0) || ((dSts>>18)&0xF)!=0)
    {
    	which_plug = COMPUTER;
    }
    else
    {
        which_plug = CHARGER;
    }
#endif
//    zDrvChg_SetCurrent(which_plug);
    return DRV_SUCCESS;
}

/*******************************************************************************
* Function: zDrvSys_GetUsbSwitchConfigNum
* Description:
* Parameters:
*   Input:
*
*   Output:
*
* Returns:
*
* Others:
********************************************************************************/
SINT32 zDrvUSB_ChargerDetect_RegCallBack(T_ZDrvUSBRef_ChargerDetect_CallBack callback)
{
    g_USBRef_ChargerDetect = callback;
	
    return DRV_SUCCESS;
}

/*******************************************************************************
* Function: zDrvSys_GetUsbInsertConfig
* Description:
* Parameters:
*   Input:
*
*   Output:
*
* Returns:
*
* Others:zhouyuchao modify
********************************************************************************/
SINT32 zDrvUsbRef_Detect_Initiate(VOID)
{
    zDrvUSB_ChargerDetect_RegCallBack(USBRef_ChargerDetect);

	return DRV_SUCCESS;
}




