
#ifndef __TRACE_FLAG__
#define __TRACE_FLAG__

typedef enum _T_TRACE_FLAG
{
    TRACE_ZLOADER_START = 0x00010000,
    TRACE_ZLOADER_NAND,
    TRACE_ZLOADER_DDR,
    TRACE_ZLOADER_PARTITION,
    TRACE_ZLOADER_LOAD_UBOOT,
    TRACE_ZLOADER_LOAD_RPM,
    TRACE_ZLOADER_RUN_UBOOT,
    TRACE_ZLOADER_END_ERR,
    TRACE_ZLOADER_HANG,
    TRACE_ZLOADER_9,
    TRACE_ZLOADER_10,
    TRACE_ZLOADER_11,
    TRACE_ZLOADER_12,
    TRACE_ZLOADER_13,
    TRACE_ZLOADER_14,
    TRACE_ZLOADER_15,
    TRACE_ZLOADER_16,
    TRACE_ZLOADER_17,
    TRACE_ZLOADER_18,
    TRACE_ZLOADER_RUN_RPM = 0x00019999,  /*zloader start normal*/

    TRACE_UBOOT_START = 0x00020000,
    TRACE_UBOOT_PMU,
    TRACE_UBOOT_NAND,
    TRACE_UBOOT_TLOAD,
    TRACE_UBOOT_PARTITION,
    TRACE_UBOOT_PSHOLD,
    TRACE_UBOOT_FOTA_UPDATE,
    TRACE_UBOOT_FOTA,
    TRACE_UBOOT_FOTA_RESET,
    TRACE_UBOOT_CHECK_POWERKEY,
    TRACE_UBOOT_POWER_REASON,
    TRACE_UBOOT_LOW_BATTERY,
    TRACE_UBOOT_SHOW_LCD,
    TRACE_UBOOT_LOAD_IMAGE,
    TRACE_UBOOT_LOAD_LINUX,
    TRACE_UBOOT_MAINLOOP,
    TRACE_UBOOT_16,
    TRACE_UBOOT_17,
    TRACE_UBOOT_18,
    TRACE_UBOOT_BOOT_LINUX = 0x00029999,  /*uboot start normal*/

    TRACE_RPM_0 = 0x00030000,
    TRACE_RPM_1,
    TRACE_RPM_SLEEP,
    TRACE_RPM_RUNNING,
    TRACE_RPM_4,
    TRACE_RPM_5,
    TRACE_RPM_6,
    TRACE_RPM_7,
    TRACE_RPM_8,
    TRACE_RPM_9,
    TRACE_RPM_10,
    TRACE_RPM_11,
    TRACE_RPM_12,
    TRACE_RPM_13,
    TRACE_RPM_14,
    TRACE_RPM_15,
    TRACE_RPM_16,
    TRACE_RPM_17,
    TRACE_RPM_18,
    TRACE_RPM_19,

    TRACE_AP_0 = 0x00040000,
    TRACE_AP_INIT_CALL,
    TRACE_AP_SLEEP,
    TRACE_AP_RUNNING,
    TRACE_AP_4,
    TRACE_AP_5,
    TRACE_AP_6,
    TRACE_AP_7,
    TRACE_AP_8,
    TRACE_AP_9,
    TRACE_AP_10,
    TRACE_AP_11,
    TRACE_AP_12,
    TRACE_AP_13,
    TRACE_AP_14,
    TRACE_AP_15,
    TRACE_AP_16,
    TRACE_AP_17,
    TRACE_AP_18,
    TRACE_AP_19,

    TRACE_PS_0 = 0x00050000,
    TRACE_PS_1,
    TRACE_PS_SLEEP,
    TRACE_PS_RUNNING,
    TRACE_PS_4,
    TRACE_PS_5,
    TRACE_PS_6,
    TRACE_PS_7,
    TRACE_PS_8,
    TRACE_PS_9,
    TRACE_PS_10,
    TRACE_PS_11,
    TRACE_PS_12,
    TRACE_PS_13,
    TRACE_PS_14,
    TRACE_PS_15,
    TRACE_PS_16,
    TRACE_PS_17,
    TRACE_PS_18,
    TRACE_PS_19,

    TRACE_PHY_0 = 0x00060000,
    TRACE_PHY_1,
    TRACE_PHY_SLEEP,
    TRACE_PHY_RUNNING,
    TRACE_PHY_4,
    TRACE_PHY_5,
    TRACE_PHY_6,
    TRACE_PHY_7,
    TRACE_PHY_8,
    TRACE_PHY_9,
    TRACE_PHY_10,
    TRACE_PHY_11,
    TRACE_PHY_12,
    TRACE_PHY_13,
    TRACE_PHY_14,
    TRACE_PHY_15,
    TRACE_PHY_16,
    TRACE_PHY_17,
    TRACE_PHY_18,
    TRACE_PHY_19,

    TRACE_SYSENTRY = 0x00070000,
    TRACE_SYSENTRY_FINISH,
    TRACE_HAL_INIT,
    TRACE_HAL_REF_INIT,
    TRACE_SLEEP,
    TRACE_RUNNING,
    TRACE_COMM_6,
    TRACE_COMM_7,
    TRACE_COMM_8,
    TRACE_COMM_9,
    TRACE_COMM_10,
    TRACE_COMM_11,
    TRACE_COMM_12,
    TRACE_COMM_13,
    TRACE_COMM_14,
    TRACE_COMM_15,
    TRACE_COMM_16,
    TRACE_COMM_17,
    TRACE_COMM_18,
    TRACE_COMM_19,

} T_TRACE_FLAG;

/**************************************************************************
* ƣzSys_SetTraceFlag
* øLOG
* ˵ 
*   ֵ 
* ˵ 
**************************************************************************/
VOID zSys_SetTraceFlag(T_TRACE_FLAG flag, VOID *data);

/**************************************************************************
* ƣzSys_GetTraceFlag
* ѯLOG
* ˵ 
*   ֵ 
* ˵ 
**************************************************************************/
T_TRACE_FLAG zSys_GetTraceFlag(VOID);


#endif
