#ifndef _PHY_LTE_LOG_IF_H
#define _PHY_LTE_LOG_IF_H

#ifndef ZPHY_DEBUG_TMT_SIZE
#define ZPHY_DEBUG_TMT_SIZE    ((UINT32)10) 
#endif

#ifndef ZPHY_SUBFRAMES_PER_FRAME
#define ZPHY_SUBFRAMES_PER_FRAME             ((UINT32)10)
#endif
//LTEϢ
/*========================================================================
LOGͣLOG_TOOL_LTE_PHY_ECSR_PSSINFO
˵PSS Result
=========================================================================*/
typedef struct
{
    WORD16 wHeader;      /* Ϣݰָʾͷ̶Ϊ0x69E8 */
    WORD16 wLogType:8;   /* LOGͣEngLogType*/
    WORD16 wProcId:8;    /* ǰID */
	WORD16 wSubFrame:5;
	WORD16 wFrame:11;
	WORD16 wSuperSubFrame;
    WORD16 wLen;         /* ϢĳȣEngLogHeaderλֽ */
    WORD16 wReserved;
}T_LteEngLogHeader;


typedef struct
{
    WORD16 wMsgId;       /* ׼LOGϢID */
    WORD16 wMsgLen;      /* ׼LOGĳ */
}T_LteEngStandardMsg;    /* ׼LOGϢͷ */

typedef struct
{
    WORD16 wMsgId;       /* ԶӡϢID */
    WORD16 wPri:8;       /* Զӡȼ */
    WORD16 wParaNum:8;   /* ԶӡĲ */
}T_LteEngPrintMsg;       /* ԶӡϢͷ */

typedef struct
{
    WORD16 wMsgId;       /* W_PHYЭջӿϢID */
    WORD16 wMsgLen;      /* ӿϢݵĳ */
}T_LteEngHciMsg;         /* ЭջӿϢϢͷ */

typedef enum
{
    E_LTE_SWAP_HOOK = 0,
    E_LTE_SEND_HOOK,
    E_LTE_TRACE_HOOK,
}E_LteHookEventId;

typedef struct
{
    WORD16 wEventId;     /* HOOKϢ¼ID */
    WORD16 wPara;        /* SWAP_HOOKwParaΪĿID
                         SEND_HOOKwParaΪϢID
                         TRACE_HOOKwParaΪԸ */
}T_LteEngHookMsg;        /* HOOKϢͷ */


typedef struct
{
    WORD16 wDataType;    /* ץȡݵͣ */
    WORD16 wDataLen;     /* ץȡݵĳ */
}T_LteEngDataDump;       /* ץȡLOGϢͷ */



typedef struct
{
     UINT32  dwPssPeakVal;    /* PSS Peak Value Data */
     UINT32  dwPeakPosition;  /* Peak Position */
     UINT32  dwPssIndicies;   /* PSS Indicies */
}T_zPHY_PSSInfo;

typedef struct
{
     UINT16 wUarfcn;  /* Ƶ */
	 UINT16 wpading;
     T_zPHY_PSSInfo  atPSSInfo[16];                
}T_zPHY_UarfcnPssInfo;

typedef struct
{
    UINT32     dwSFN;    //ʱϢ
    T_zPHY_UarfcnPssInfo   atUarfcnPssInfo[4];    
}T_zPHY_ECSR_PssInfo;
/*========================================================================
LOGͣLOG_TOOL_LTE_PHY_ECSR_SERCELLFRMTIMING
˵Serving Cell Frame Timing
=========================================================================*/
typedef struct
{
    UINT32 dwSFN;    //ʱϢ
    
    UINT32 dwStDlFrmTimeOffset;  /* DL Frame Timing Offse */
    UINT32 dwStUlFrmTimeOffset;  /* UL Frame Timing Offse */
    UINT32 dwStUlTA;             /* UL Timing Advance */
    
    UINT16 wChDlFrmTime;         /* Change in DL Frame Timing */
    UINT16 wChUlFrmTime;         /* Change in UL Frame Timing */
}T_zPHY_ECSR_SerCellFrmTiming;
/*========================================================================
LOGͣLOG_TOOL_LTE_PHY_ECSR_SSSINFO
˵SSS Result
=========================================================================*/
typedef struct
{
    UINT16 wCellId;           /* Barred Cell ID */
}T_zPHY_BarredCellId;

typedef struct
{
     UINT32 dwSSSPeakVal;    /* SSS Peak Value Data */
     UINT32 dwSSSPositon;    /* SSS Position */
     UINT32 dwCpMode;        /* CP */
     UINT32 dwHalfFrmHypth;  /* Half Frame Hypothesis */
}T_zPHY_DetectedCell;

typedef struct
{
   T_zPHY_BarredCellId atBarredCellId[16];     
   T_zPHY_DetectedCell atDetectedCell[32];
}T_zPHY_ECSR_SSSInfo;
/*========================================================================
LOGͣLOG_TOOL_LTE_PHY_ECSR_SERCELL_MEAS_RESULT
˵Serving Cell MeasureMent Result
=========================================================================*/
typedef struct
{
    UINT32 dwSFN;             //ʱϢ
    UINT16 wIsIdleMode;       /* Is Idle Mode */
    UINT16 wMeasBW;           /* Measurement BW */
    UINT16 wCellId;           /* Cell ID */
	UINT16 wpading;           /* 壬4ֽڶ*/ 
    UINT32 dwRxTimeOffset;    /* Timing Offset Rx */
}T_zPHY_ECSR_SerCellMeasResult;
/*========================================================================
LOGͣLOG_TOOL_LTE_PHY_ECSR_NEBORCELL_MEAS_RESULT
˵Neighbor Cell Measurements and Tracking 
=========================================================================*/
typedef struct
{
    UINT32 dwEarfcn;     /* Ƶ */
    UINT32 dwDuplexMode; /*  TDD or FDD*/
    UINT16 wCellId;      /*  СID */
    UINT16 wCpmode;      /* CP mode */
}T_zPHY_CellInfo;

typedef struct
{
    UINT32 dwSFN;    //ʱϢ
    T_zPHY_CellInfo  tCellInfo;    
}T_zPHY_ECSR_NeborCellMeasResult;
/*========================================================================
LOGͣLOG_TOOL_LTE_PHY_PBCH_INFO
˵PBCH
=========================================================================*/
typedef struct
{
    UINT32 dwSFN;    //ʱϢ
    UINT16 wSerCellId;    /* Serving Cell ID */
    UINT16 wTransAntCnf;  /* Transmit Antenna Config */
    UINT16 wSfnOffset;    /* SFN Offset */
    UINT16 wCrcValue;     /* CRC */
}T_zPHY_ECSR_PbchInfo;
/*========================================================================
LOGͣLOG_TOOL_LTE_PHY_GLB_MIB_INFO
˵MIBϢ
=========================================================================*/
typedef struct
{
    UINT32 dwMibRefreshFlag;  //MIBϢ±־и1
    UINT32 dwMibInfo;         //MIBϢ
} T_zPHY_ECSR_MibInfo;
/*========================================================================
LOGͣLOG_TOOL_LTE_PHY_GLB_CSR_MEASURE_INFO
˵RSRPRSRQRSSIϢ
=========================================================================*/
typedef struct
{
    UINT32 dwServerCellId;  /* СID */
    
    SINT32 sdwCsrmRssi;     /* RSSI */
    SINT32 sdwCsrmRsrq;     /* RSRQ */
    SINT32 sdwCsrmRsrp;     /* RSRP */
    
    SINT32 sdwCsrmRssiAnt0; /* 0 RSSI */
    SINT32 sdwCsrmRssiAnt1; /* 1 RSSI */
    
    SINT32 sdwCsrmRsrpAnt0; /* 0 RSRP */
    SINT32 sdwCsrmRsrpAnt1; /* 1 RSRP */
    
    SINT32 sdwCsrmRsrqAnt0; /* 0 RSRQ */
    SINT32 sdwCsrmRsrqAnt1; /* 0 RSRQ */
}T_zPHY_ECSR_MeasureInfo;
/*========================================================================
LOGͣLOG_TOOL_LTE_PHY_DL_PCFICH_INFO
˵PCFICHͳϢ
=========================================================================*/
typedef struct
{   
    UINT32          dwSFN;    //ʱϢ
    UINT16           aucDlCfiTab[10];            /*ѭͳ10֡CFIֵ*/
    UINT32          adwDlCfiValue[4];           /*ͳƲͬCFIֵĸ*/
    UINT32          adwDlCfiValueSubf[10][4];   /*֡ͳƲͬCFIֵĸ*/
}T_ZPHY_EDL_PCFICH_INFO;
/*========================================================================
LOGͣLOG_TOOL_LTE_PHY_DL_PHICH_INFO
˵PHICHͳϢ
=========================================================================*/
typedef struct
{
    UINT32          dwSFN;    //ʱϢ
    UINT16           ucNg;                       /* Ng */
    UINT16           ucHiDuration;               /* PHICH Duration */
    UINT32          adwPhichAckNum[2][10];      /* PHICH12 ֡ۼͳ */
    UINT32          adwPhichNackNum[2][10];     /* PHICH12 ֡ۼͳ */
    UINT32          adwPhichAckSumNum[2];       /* PHICH12 ܵۼͳ */
    UINT32          adwPhichNackSumNum[2];      /* PHICH12 ܵۼͳ */
    UINT16           aucPhich1Grp[10];           /* PHICH1      */
    UINT16           aucPhich1Seq[10];           /* PHICH1Ƶк    */
    UINT16           aucPhich2Grp[10];           /* PHICH2      */
    UINT16           aucPhich2Seq[10];           /* PHICH2Ƶк    */
    UINT32          dwPHICH_AckNum;
    UINT32          dwPHICH_NackNum;
}T_ZPHY_EDL_PHICH_INFO;
/*========================================================================
LOGͣLOG_TOOL_LTE_PHY_DL_PDCCH_INFO
˵PDCCHäͳϢ
=========================================================================*/
typedef struct
{
    UINT32          dwSFN;    //ʱϢ
    /*Statistic Si-Rnti Dci Info*/
    UINT32          adwSiRntiDci1ANum[10];       /* Si-Rnti DCI_1A ֡ۼ */
    UINT32          adwSiRntiDci1CNum[10];       /* Si-Rnti DCI_1C ֡ۼ */
    UINT32          dwSiRntiDci1ASumNum;         /* Si-Rnti DCI_1A ܵۼ */
    UINT32          dwSiRntiDci1CSumNum;         /* Si-Rnti DCI_1C ܵۼ */
    UINT32          dwSiRntiDciSumNum;
    
    /*Statistic P-Rnti Dci Info*/
    UINT32          adwPRntiDci1ANum[10];        /* P-Rnti DCI_1A ֡ۼ */
    UINT32          adwPRntiDci1CNum[10];        /* P-Rnti DCI_1C ֡ۼ */
    UINT32          dwPRntiDci1ASumNum;          /* P-Rnti DCI_1A ܵۼ */
    UINT32          dwPRntiDci1CSumNum;          /* P-Rnti DCI_1C ܵۼ */
    UINT32          dwPRntiDciSumNum;
    
    /*Statistic Ra-Rnti Dci Info*/
    UINT32          adwRaRntiDci1ANum[10];       /* Ra-Rnti DCI_1A ֡ۼ */
    UINT32          adwRaRntiDci1CNum[10];       /* Ra-Rnti DCI_1C ֡ۼ */
    UINT32          dwRaRntiDci1ASumNum;         /* Ra-Rnti DCI_1A ܵۼ */
    UINT32          dwRaRntiDci1CSumNum;         /* Ra-Rnti DCI_1C ܵۼ */
    UINT32          dwRaRntiDciSumNum;
    
    /*Statistic C-Rnti Dci Info*/
    UINT32          adwCRntiDci1Num[10];         /* C-Rnti DCI_1 ֡ۼ */
    UINT32          adwCRntiDci1ANum[10];        /* C-Rnti DCI_1A ֡ۼ */
    UINT32          adwCRntiDci1BNum[10];        /* C-Rnti DCI_1B ֡ۼ */
    UINT32          adwCRntiDci1DNum[10];        /* C-Rnti DCI_1D ֡ۼ */
    UINT32          adwCRntiDci2Num[10];         /* C-Rnti DCI_2 ֡ۼ */
    UINT32          adwCRntiDci2ANum[10];        /* C-Rnti DCI_2A ֡ۼ */
    UINT32          adwCRntiDci2BNum[10];        /* C-Rnti DCI_2B ֡ۼ */
    UINT32          dwCRntiDci1SumNum;           /* C-Rnti DCI_1 ܵۼ */
    UINT32          dwCRntiDci1ASumNum;          /* C-Rnti DCI_1A ܵۼ */
    UINT32          dwCRntiDci1BSumNum;          /* C-Rnti DCI_1B ܵۼ */
    UINT32          dwCRntiDci1DSumNum;          /* C-Rnti DCI_1D ܵۼ */
    UINT32          dwCRntiDci2SumNum;           /* C-Rnti DCI_2 ܵۼ */
    UINT32          dwCRntiDci2ASumNum;          /* C-Rnti DCI_2A ܵۼ */
    UINT32          dwCRntiDci2BSumNum;          /* C-Rnti DCI_2B ܵۼ */
    UINT32          dwCRntiDciSumNum;
    
    /*Statistic Tpc-Rnti Dci Info*/
    UINT32          adwTpcRntiDci3Num[10];       /* Tpc-Rnti DCI_3 ֡ۼ */
    UINT32          adwTpcRntiDci3ANum[10];      /* Tpc-Rnti DCI_3A ֡ۼ */
    UINT32          dwTpcRntiDci3SumNum;         /* Tpc-Rnti DCI_3 ܵۼ */
    UINT32          dwTpcRntiDci3ASumNum;        /* Tpc-Rnti DCI_3A ܵۼ */
    UINT32          dwPucchTpcDci33ASumNum;
    UINT32          dwPuschTpcDci33ASumNum;
    
    /*Statistic Sps-Rnti Dci Info*/
    UINT32          adwSpsRntiDci1Num[10];       /* Sps-Rnti DCI_1 ֡ۼ */
    UINT32          adwSpsRntiDci1ANum[10];      /* Sps-Rnti DCI_1A ֡ۼ */
    UINT32          adwSpsRntiDci2Num[10];       /* Sps-Rnti DCI_2 ֡ۼ */
    UINT32          adwSpsRntiDci2ANum[10];      /* Sps-Rnti DCI_2A ֡ۼ */
    UINT32          adwSpsRntiDci2BNum[10];      /* Sps-Rnti DCI_2B ֡ۼ */
    UINT32          dwSpsRntiDci1SunNum;         /* Sps-Rnti DCI_1 ܵۼ */
    UINT32          dwSpsRntiDci1ASunNum;        /* Sps-Rnti DCI_1A ܵۼ */
    UINT32          dwSpsRntiDci2SunNum;         /* Sps-Rnti DCI_2 ܵۼ */
    UINT32          dwSpsRntiDci2ASunNum;        /* Sps-Rnti DCI_2A ܵۼ */
    UINT32          dwSpsRntiDci2BSunNum;        /* Sps-Rnti DCI_2B ܵۼ */
    
    /*Statistic Tc-Rnti Dci Info*/
    UINT32          adwTcRntiDci1Num[10];        /* Tc-Rnti DCI_1 ֡ۼ */
    UINT32          adwTcRntiDci1ANum[10];       /* Tc-Rnti DCI_1A ֡ۼ */
    UINT32          dwTcRntiDci1SumNum;          /* Tc-Rnti DCI_1 ܵۼ */
    UINT32          dwTcRntiDci1ASumNum;         /* Tc-Rnti DCI_1A ܵۼ */
    
    /*Statistic Dci Total Number*/  /* ۺͳ */
    UINT32          adwValidDci0_1Num[10];       /* DCI0_1 ֡ۼ */
    UINT32          adwValidDci0_2Num[10];       /* DCI0_2 ֡ۼ */
    UINT32          adwValidDci1Num[10];         /* DCI1 ֡ۼ */
    UINT32          adwValidDci1ANum[10];        /* DCI1A ֡ۼ */
    UINT32          adwValidDci1CNum[10];        /* DCI1C ֡ۼ */
    UINT32          adwValidDci2Num[10];         /* DCI2 ֡ۼ */
    UINT32          adwValidDci2ANum[10];        /* DCI2A ֡ۼ */
    UINT32          adwValidDci2BNum[10];        /* DCI2B ֡ۼ */
    UINT32          dwValidDci0_1SumNum;         /* DCI0_1 ܵۼ */
    UINT32          dwValidDci0_2SumNum;         /* DCI0_2 ܵۼ */
    UINT32          dwValidDci1SumNum;           /* DCI1 ܵۼ */
    UINT32          dwValidDci1ASumNum;          /* DCI1A ܵۼ */
    UINT32          dwValidDci1CSumNum;          /* DCI1C ܵۼ */
    UINT32          dwValidDci2SumNum;           /* DCI2 ܵۼ */
    UINT32          dwValidDci2ASumNum;          /* DCI2A ܵۼ */
    UINT32          dwValidDci2BSumNum;          /* DCI2B ܵۼ */
    
    UINT32          dwPdcchDlGrantCnt;           /* Ȩͳƣܵۼֵ·룬DCIϢۼӵõ*/
}T_ZPHY_EDL_PDCCH_INFO;
/*========================================================================
LOGͣLOG_TOOL_LTE_PHY_DL_PDSCH_INFO
˵PDSCHͳϢ
=========================================================================*/
typedef struct
{
    UINT32          dwSFN;    //ʱϢ
    /*Statistic C-Rnti PDSCH Decode Info*/
    UINT32          adwCRntiTbCrcOkNum[2][10];   /* TB12 C-Rnti  CRC_OK ֡ۼ */
    UINT32          adwCRntiTbCrcErrNum[2][10];  /* TB12 C-Rnti  CRC_ERR ֡ۼ */
    UINT32          adwCRntiTbCrcOkSumNum[2];    /* TB12 C-Rnti  CRC_OK ܵۼ */
    UINT32          adwCRntiTbCrcErrSumNum[2];   /* TB12 C-Rnti  CRC_ERR ܵۼ */
    
    /*Statistic Si-Rnti PDSCH Decode Info*/
    UINT32          adwSiRntiCrcOkNum[10];       /* Si-Rnti  CRC_OK ֡ۼ */
    UINT32          adwSiRntiCrcErrNum[10];      /* Si-Rnti  CRC_ERR ֡ۼ */
    UINT32          dwSiRntiCrcOkSumNum;         /* Si-Rnti  CRC_OK ܵۼ */
    UINT32          dwSiRntiCrcErrSumNum;        /* Si-Rnti  CRC_ERR ܵۼ */
    
    /*Statistic P-Rnti PDSCH Decode Info*/
    UINT32          adwPRntiCrcOkNum[10];        /* P-Rnti  CRC_OK ֡ۼ */
    UINT32          adwPRntiCrcErrNum[10];       /* P-Rnti  CRC_ERR ֡ۼ */
    UINT32          dwPRntiCrcOkSumNum;          /* P-Rnti  CRC_OK ܵۼ */
    UINT32          dwPRntiCrcErrSumNum;         /* P-Rnti  CRC_ERR ܵۼ */
    
    /*Statistic Ra-Rnti PDSCH Decode Info*/
    UINT32          adwRaRntiCrcOkNum[10];       /* Ra-Rnti  CRC_OK ֡ۼ */
    UINT32          adwRaRntiCrcErrNum[10];      /* Ra-Rnti  CRC_ERR ֡ۼ */
    UINT32          dwRaRntiCrcOkSumNum;         /* Ra-Rnti  CRC_OK ܵۼ */
    UINT32          dwRaRntiCrcErrSumNum;        /* Ra-Rnti  CRC_ERR ܵۼ */
    
    /*Statistic Sps-Rnti PDSCH Decode Info*/
    UINT32          adwSpsRntiCrcOkNum[10];      /* Sps-Rnti  CRC_OK ֡ۼ */
    UINT32          adwSpsRntiCrcErrNum[10];     /* Sps-Rnti  CRC_OK ֡ۼ */
    UINT32          dwSpsRntiCrcOkSumNum;        /* Sps-Rnti  CRC_OK ܵۼ */
    UINT32          dwSpsRntiCrcErrSumNum;       /* Sps-Rnti  CRC_OK ܵۼ */
    
    /*Statistic Tc-Rnti PDSCH Decode Info*/
    UINT32          adwTcRntiCrcOkNum[10];       /* Tc-Rnti  CRC_OK ֡ۼ */
    UINT32          adwTcRntiCrcErrNum[10];      /* Tc-Rnti  CRC_OK ֡ۼ */
    UINT32          dwTcRntiCrcOkSumNum;         /* Tc-Rnti  CRC_OK ܵۼ */
    UINT32          dwTcRntiCrcErrSumNum;        /* Tc-Rnti  CRC_OK ܵۼ */
    UINT32          dwPDSCH_TB1CrcAckNum;
    UINT32          dwPDSCH_TB1CrcNackNum;
    UINT32          dwPDSCH_TB2CrcAckNum;
    UINT32          dwPDSCH_TB2CrcNackNum;
}T_ZPHY_EDL_PDSCH_INFO;
/*========================================================================
LOGͣLOG_TOOL_LTE_PHY_DL_HARQ_INFO
˵HARQϢͳ
=========================================================================*/
typedef struct
{
    UINT32          dwSFN;    //ʱϢ
    UINT32          adwRevTb1RvNum[4];           /* TB1 Եۼͳ */
    UINT32          adwRevTb2RvNum[4];           /* TB2 Եۼͳ */
    
    /*ģHarq ID ACKNACK*/
    /* ֧15Harq ProcessBLERͳ */
    /* TB1*/
    UINT32          adwDlTb1HarqIdAck[15];       /* TB1 15HARQ IDACKϢIDܵۼӣ· */
    UINT32          adwDlTb1HarqIdNack[15];      /* TB1 15HARQ IDNACKϢIDܵۼӣ· */
    
    /* TB2*/
    UINT32          adwDlTb2HarqIdAck[15];       /* TB2 15HARQ IDACKϢIDܵۼӣ· */
    UINT32          adwDlTb2HarqIdNack[15];      /* TB2 15HARQ IDNACKϢIDܵۼӣ· */
    
     /* еһΡڶΡΡĴشɹ */
    UINT32 adwDlHarqSuccNum[2][4];               /* TB1TB2شɹͳƣ ܵۼֵ· */
}T_ZPHY_EDL_HARQ_INFO;
/*========================================================================
LOGͣLOG_TOOL_LTE_PHY_DL_PA_INFO
˵йʷϢͳ
=========================================================================*/
typedef struct
{
    UINT16           ucPowerA;      /* DedicatedϢPDSCHʲĲ */
    UINT16           ucPowerB;      /* CommonϢPDSCHʲĲ */
}T_ZPHY_EDL_PA_INFO;
/*========================================================================
LOGͣLOG_TOOL_LTE_PHY_DL_FLOW_INFO
˵Ϣͳ
=========================================================================*/
typedef struct
{
    UINT32          dwPeakFlow;
    UINT32          dwMeanFlow;
    UINT32          dwBlerAckCount;     /*Only Statistic C-Rnti Pdsch*/
    UINT32          dwBlerNackCount;    /*Only Statistic C-Rnti Pdsch*/
}T_ZPHY_EDL_FLOW_INFO;
/*========================================================================
EVENTͣLOG_TOOL_LTE_PHY_DL_DCI_INFO
˵ 
=========================================================================*/
typedef struct
{
    UINT32  dwSFN;
    UINT32  dwResource;
    UINT32  adwPdschBmp[14];
    UINT16   cRaType;
    UINT16   cRbNum;
    UINT16   cRbStart;
    UINT16   cRbLength;
    UINT16   cHarqId;
    UINT16   cTb1Mcs;
    UINT16   cTb2Mcs;
    UINT16   cTb1Ndi;
    UINT16   cTb2Ndi;
    UINT16   cTb1Rv;
    UINT16   cTb2Rv;
    UINT16   cDaiIdx;
}T_zPHY_DciInfo;  

/* DCIϢ */
typedef struct
{
  T_zPHY_DciInfo atDciInfo[10];                        /* 10֡ĵǰDCIϢ */
}T_ZPHY_EDL_DCI_INFO;
/*========================================================================
LOG_TOOL_LTE_PHY_EXT_PUCCHFMT_STAT_INFO
˵ PUCCH FMT ʽͳϢ 
=========================================================================*/
typedef struct
{
    UINT32                      dwSFN;    //ʱϢ
	UINT32                      dwUlaPucchFmt1Cnt;    /* PUCCH Format1 ͳ ܵۼֵ*/
    UINT32                      dwUlaPucchFmt1aCnt;   /* PUCCH Format1A ͳ ܵۼֵ*/
    UINT32                      dwUlaPucchFmt1bCnt;   /* PUCCH Format1B ͳ ܵۼֵ*/
    UINT32                      dwUlaPucchFmt2Cnt;    /* PUCCH Format2 ͳ ܵۼֵ*/
    UINT32                      dwUlaPucchFmt2aCnt;   /* PUCCH Format2A ͳ ܵۼֵ*/
    UINT32                      dwUlaPucchFmt2bCnt;   /* PUCCH Format2B ͳ ܵۼֵ*/
}T_zPHY_EUL_PucchFmtStatisticsInfo;
/*========================================================================
LOG_TOOL_LTE_PHY_EXT_BUNLDINGAN_STAT_INFO
˵ ͳнBunldingϢ 
=========================================================================*/
typedef struct
{
    UINT32                      dwSFN;    //ʱϢ
	//PUCCH
	UINT32                      dwUlaPucchBunldingAckCnt;       /* PUCCH BundlingACKͳ ܵۼֵ */
	UINT32                      dwUlaPucchBunldingNackCnt;      /* PUCCH BundlingNACKͳ ܵۼֵ */
	UINT32                      dwUlaPucchBunldingAckAckCnt;    /* PUCCH Bundling[ACK ACK]ͳ ܵۼֵ */
	UINT32                      dwUlaPucchBunldingAckNackCnt;   /* PUCCH Bundling[ACK NACK]ͳ ܵۼֵ */
	UINT32                      dwUlaPucchBunldingNackAckCnt;   /* PUCCH Bundling[NACK ACK]ͳ ܵۼֵ */
	UINT32                      dwUlaPucchBunldingNackNackCnt;  /* PUCCH Bundling[NACK NACK]ͳ ܵۼֵ */
	
	//PUSCH
	UINT32                      dwUlaPuschBunldingAckCnt;       /* PUSCH BundlingACKͳ ܵۼֵ */
	UINT32                      dwUlaPuschBunldingNackCnt;      /* PUSCH BundlingNACKͳ ܵۼֵ */
	UINT32                      dwUlaPuschBunldingAckAckCnt;    /* PUSCH Bundling[ACK ACK]ͳ ܵۼֵ */
	UINT32                      dwUlaPuschBunldingAckNackCnt;   /* PUSCH Bundling[ACK NACK]ͳ ܵۼֵ */
	UINT32                      dwUlaPuschBunldingNackAckCnt;   /* PUSCH Bundling[NACK ACK]ͳ ܵۼֵ */
	UINT32                      dwUlaPuschBunldingNackNackCnt;  /* PUSCH Bundling[NACK NACK]ͳ ܵۼֵ */
	
	
	UINT32                      dwPdcchUlGrantCnt;              /* Ȩͳ ܵۼֵ· */
	UINT32                      dwPuschDynPacketNum;            /* ̬ͳ ܵۼֵ· */
}T_zPHY_EUL_BunldingANStatisticsInfo;
/*========================================================================
LOG_TOOL_LTE_PHY_EXT_MUTIPLEXAN_STAT_INFO
˵ PUCCH Multiplexing ѡN1pucchԴͳϢ 
=========================================================================*/
typedef struct
{
    UINT32                      dwSFN;    //ʱϢ
	UINT32                      dwUlaN1pucch0Bits00Cnt;         /* PUCCH Multiplexing ѡN1pucch0Դ[NACK NACK]ͳ ܵۼֵ */
	UINT32                      dwUlaN1pucch0Bits01Cnt;         /* PUCCH Multiplexing ѡN1pucch0Դ[NACK ACK]ͳ ܵۼֵ */
	UINT32                      dwUlaN1pucch0Bits10Cnt;         /* PUCCH Multiplexing ѡN1pucch0Դ[ACK NACK]ͳ ܵۼֵ */
	UINT32                      dwUlaN1pucch0Bits11Cnt;         /* PUCCH Multiplexing ѡN1pucch0Դ[ACK ACK]ͳ ܵۼֵ */
	
	UINT32                      dwUlaN1pucch1Bits00Cnt;         /* PUCCH Multiplexing ѡN1pucch1Դ[NACK NACK]ͳ ܵۼֵ */
	UINT32                      dwUlaN1pucch1Bits01Cnt;         /* PUCCH Multiplexing ѡN1pucch1Դ[NACK ACK]ͳ ܵۼֵ */
	UINT32                      dwUlaN1pucch1Bits10Cnt;         /* PUCCH Multiplexing ѡN1pucch1Դ[ACK NACK]ͳ ܵۼֵ */
	UINT32                      dwUlaN1pucch1Bits11Cnt;         /* PUCCH Multiplexing ѡN1pucch1Դ[ACK ACK]ͳ ܵۼֵ */
	
	UINT32                      dwUlaN1pucch2Bits00Cnt;         /* PUCCH Multiplexing ѡN1pucch2Դ[NACK NACK]ͳ ܵۼֵ */
	UINT32                      dwUlaN1pucch2Bits01Cnt;         /* PUCCH Multiplexing ѡN1pucch2Դ[NACK ACK]ͳ ܵۼֵ */
	UINT32                      dwUlaN1pucch2Bits10Cnt;         /* PUCCH Multiplexing ѡN1pucch2Դ[ACK NACK]ͳ ܵۼֵ */
	UINT32                      dwUlaN1pucch2Bits11Cnt;         /* PUCCH Multiplexing ѡN1pucch2Դ[ACK ACK]ͳ ܵۼֵ */

	UINT32                      dwUlaN1pucch3Bits00Cnt;         /* PUCCH Multiplexing ѡN1pucch3Դ[NACK NACK]ͳ ܵۼֵ */
	UINT32                      dwUlaN1pucch3Bits01Cnt;         /* PUCCH Multiplexing ѡN1pucch3Դ[NACK ACK]ͳ ܵۼֵ */
	UINT32                      dwUlaN1pucch3Bits10Cnt;         /* PUCCH Multiplexing ѡN1pucch3Դ[ACK NACK]ͳ ܵۼֵ */
	UINT32                      dwUlaN1pucch3Bits11Cnt;         /* PUCCH Multiplexing ѡN1pucch3Դ[ACK ACK]ͳ ܵۼֵ */
}T_zPHY_UL_MutiplexingANStatisticsInfo;
/*========================================================================
LOG_TOOL_LTE_PHY_EXT_SRHARQSIMUL_STAT_INFO
˵SR HARQͳϢ
=========================================================================*/
typedef struct
{
    UINT32                      dwSFN;    //ʱϢ
	UINT32                      dwUlaSrAndHarqCnt;              /* PUCCH SRACKһͳƣ̶ѡFormat 1bѡ2bitb(1),b(0)д ܵۼֵ */
    UINT32                      dwUlaSrAndHarqBits00Cnt;        /* ѡb(1)=0 b(0)=0ĸ ܵۼֵ */
    UINT32                      dwUlaSrAndHarqBits01Cnt;        /* ѡb(1)=0 b(0)=1ĸ ܵۼֵ */
    UINT32                      dwUlaSrAndHarqBits10Cnt;        /* ѡb(1)=1 b(0)=0ĸ ܵۼֵ */
    UINT32                      dwUlaSrAndHarqBits11Cnt;        /* ѡb(1)=1 b(0)=1ĸ ܵۼֵ */
}T_zPHY_UL_SrHarqSimulStatisticsInfo;
/*========================================================================
LOG_TOOL_LTE_PHY_EXT_CQIHARQSIMULSIMUL_STAT_INFO
˵ͳCQIϢ
=========================================================================*/
typedef struct
{
    UINT32                      dwSFN;    //ʱϢ
    
	UINT32                      dwUlaCqiAndHarqCnt;             /* PUCCH CQIACKһͳƣ̶ѡFormat 2bѡ2bitb(1),b(0)д ܵۼֵ */
	UINT32                      dwUlaCqiAndHarqBits00Cnt;       /* ѡb(1)=0 b(0)=0ĸ ܵۼֵ */
    UINT32                      dwUlaCqiAndHarqBits01Cnt;       /* ѡb(1)=0 b(0)=1ĸ ܵۼֵ */
    UINT32                      dwUlaCqiAndHarqBits10Cnt;       /* ѡb(1)=1 b(0)=0ĸ ܵۼֵ */
    UINT32                      dwUlaCqiAndHarqBits11Cnt;       /* ѡb(1)=1 b(0)=1ĸ ܵۼֵ */
    
	UINT32                      dwUlaPeriodicCQICnt;            /* CQIͳ ܵۼֵ */
	UINT32                      dwUlaAperiodicCQICnt;           /* PUSCHϷCQIͳ ܵۼֵ */
	UINT32                      dwUlaRiCnt;                     /* RIͳ ܵۼֵ */
	UINT32                      dwUlaPucchPeriodicCQICnt;       /* PUCCHCQIͳ ܵۼֵ */
	UINT32                      dwUlaPuschPeriodicCQICnt;       /* PUSCHCQIͳ ܵۼֵ */
//	UINT32                      dwUlaPuschAperiodicCQICnt;      * PUSCHϷCQIͳ,dwUlaAperiodicCQICntһ ܵۼֵ */
  
    /* 7CQIͳϢ·ಿֽкϲԿǰ֡ͳ */
	UINT32                      adwUlaCqiVal[10];               /* CQIֵ ֱ֡ͳ */
	UINT32                      adwUlaRiVal[10];                /* RIֵ ֱ֡ͳ */
	UINT32                      adwUlaCqiFN[10];                /* CQI֡ */
	UINT32                      adwUlaCqiSFN[10];               /* CQI֡ */

	UINT16						awCqiReportPeriodFlag[10];      /* CQI Flag */
	UINT16						awSubFrameNum[10];              /* SIDе֡ */
	UINT16						awFrameNum[10];                 /* SIDе֡ */
    UINT32                      dwUlMcs;                  //ýӿUL MCS(MCS)MCS Statistic Information,ͨЭõQPSK\16QAM\64QAM
    UINT32                      dwCQI;   
    UINT32                      dwPMI;                          /* PMI */
    UINT32                      dwRI;                           /* RI */
    UINT32                      dwWbCode0Cqi;                   /* Wideband Code0 CQI */
    UINT32                      dwWbCode1Cqi;                   /* Wideband Code1 CQI */
    SINT32                      sdwRank1Sinr;                   /* Rank1 SINR0 */
    SINT32                      sdwRank2Sinr0;                  /* Rank2 SINR0 */
    SINT32                      sdwRank2Sinr1;                  /* Rank2 SINR1 */
    UINT32                      dwTxDivFlag;                    /* Rank SINR 3dbm־ */
	
}T_zPHY_EUL_CqiHarqSimulStatisticsInfo;
/*========================================================================
LOG_TOOL_LTE_PHY_SRSTX_REPORT
˵SRS ͳ
=========================================================================*/
typedef struct
{
    UINT32                    bUeSrsEnable;         /* UE SRS Enable ǷUEȷSRS*/
    UINT32                    bCellSrsEnable;       /* Cell SRS Enable */
    UINT32                  dwStartRb;            /* Start RB */
    UINT32                  dwRbNum;              /* RB */
    UINT32                  dwZcRoot;             /* ZC Root */
    UINT32                  dwCyclicShift;        /* Cyclic Shift */
  
    UINT32                    bToneOffsetEnable;    /* Tone Offset Enable */
}T_zPHY_SrsTx_Report;//ǰ10֡Ϣ
typedef struct
{
    UINT32                      dwSFN;                          /* ʱϢ */
	UINT32                      dwUlaSrsCnt;                    /* SRS͵ͳ ܵۼֵ */
	UINT32						adwdwUlaSrsCommSFCnt[10];       /* ͨ֡SRSͳ ֡ۼֵ */
	
	/* 4Ŀǰûиֵ begin */
	UINT32                      dwUlaSrsForTddSpecSF1LastSymbCnt;                 /* TDD֡1һŷSRSͳƣŶ ܵۼֵ */
	UINT32                      dwUlaSrsForTddSpecSF1LastSecondSymbCnt;           /* TDD֡1еڶŷSRSͳƣŶ ܵۼֵ */
	UINT32                      dwUlaSrsForTddSpecSF6LastSymbCnt;                 /* TDD֡6һŷSRSͳƣŶ ܵۼֵ */
	UINT32                      dwUlaSrsForTddSpecSF6LastSecondSymbCnt;           /* TDD֡6һŷSRSͳƣŶ ܵۼֵ */
	/* 4Ŀǰûиֵ over */	
    T_zPHY_SrsTx_Report atSrsTx_Report[10];//ǰ10֡Ϣ    
}T_zPHY_EUL_SrsStatisticsInfo;
/*========================================================================
LOG_TOOL_LTE_PHY_EXT_PRACH_STAT_INFO
˵Prach ͳϢ
=========================================================================*/
typedef struct
{    
    UINT16                      wParchPremFrmNo;                               /* preamble ֡ţ· */
    UINT16                       cParchPremSubFrmNo;                            /* preamble ֡ţ·(Լ32λ) */
    UINT16                       cParchPremIndex;                               /* preamble ID */
	UINT16						cPrachConfigIndex;                             /* ЭջָʾǰPHYõprach resourceԴѡԼȡpreambleǰøʽ(0,63) */
	UINT16						cHighSpeedFlag;                                /* ־ǰС(1:С,0:Ǹ) */
	UINT16						wNcs;                                          /* NCSֵ */
	UINT16						cPrachFrqOffset;                               /* prach resourceOFDMƵƫֵ */
	UINT16						wRootSwquenceIndex;                            /* ZC߼ֲ */
	UINT16						cNumberOfRAPreamble;                           /* ǰ */
	UINT16						cSizeOfRAPreamblesGroupA;                      /* ǰAĸ */
	UINT16						wMessageSizeGroupA;                            /* ǰAϢ */
	UINT16						cMessagePowerOffetGroupB;                      /* ڽǰѡ */
	UINT16						cPowerRampingStep;                             /* зpreambleʵطpreambleе书 */
	UINT16						wPreambleTransMax;                             /* preambleش */
	UINT16						cRAResponseWindowSize;                         /* RARϢʱ䴰 */
	UINT16						cMacContentionResolutionTimer;                 /* мmsg4ʱ䴰ڴС */
	UINT16						cMaxHQRQMsg3Tx;                                /* зmsg3ʱHARQش */
    UINT16                      wpading;                                       /*壬4ֽڶ*/ 
	UINT16						awMsg1TxSysFrameNum[10];      /* Preamble֡ŵͳ */
	UINT16						awMsg1TxSubFrameNum[10];      /* Preamble֡ŵͳ */

	UINT32						adwMsg1TxCnt[10];             /* Preambleʹͳ ֡ۼͳ */
	UINT16						awMsg1TxFreqPos[10];          /* PreambleƵλnPRBͳ ֡ۼͳ */
	UINT16						acMsg1TxPreambleID[10];       /* Preamble IDͳ ֡ۼͳ */
	//SINT16						ascMsg1TxPower[10];           /* Preamble͹ʵͳ ֡ۼͳ */
	//UINT32					adwMsg1TxNumCnt[10];          /* Preambleͳ ֡ۼͳ */
	UINT32						adwMsg2RxMatchNumCnt[10];     /* RAR PIDƥͳ ֡ۼͳ */
	UINT32						adwMsg2RxNotMatchNumCnt[10];  /* RAR PIDƥͳ ֡ۼͳ */
	UINT32						adwMsg3TxNumCnt[10];          /* Msg3Ŀͳ ֡ۼͳ */
	UINT32						adwMsg3TxAckNumCnt[10];       /* Msg3ȷͳ ֡ۼͳ */
	UINT32						adwMsg3TxNackNumCnt[10];      /* Msg3ʹͳ ֡ۼͳ */
	UINT32						adwMsg4RxNumCnt[10];          /* Msg4յͳ ֡ۼͳ */
	UINT32						adwMsg4RxAckNumCnt[10];       /* Msg4ȷͳ ֡ۼͳ */
}T_zPHY_EUL_PrachStatisticsInfo;
/*========================================================================
LOG_TOOL_LTE_PHY_EXT_PRACH_STAT_INFO
˵HARQ شͳϢԽ·еزֺϲĽṹ
=========================================================================*/
typedef struct
{
    UINT32                      dwSFN;    //ʱϢ
	UINT32                      dwNewTransCnt;            /* ´ͳ ܵۼֵ */       
    UINT32                      dwAdaptTransCnt;          /* Ӧشͳ ܵۼֵ */         
    UINT32                      dwNonAdaptTransCnt;       /* Ӧشͳ ܵۼֵ */                               
    UINT32                      dwNoTransCnt;             /* ͳ ܵۼֵ */          
                                
    UINT32                      dwHarqTransCnt;           /* شͳ ܵۼֵ */  
    UINT32                      dwHarq0TransCnt;          /* HARQ ID=0Ĵͳ ܵۼֵ */
    UINT32                      dwHarq1TransCnt;          /* HARQ ID=1Ĵͳ ܵۼֵ */ 
    UINT32                      dwHarq2TransCnt;          /* HARQ ID=2Ĵͳ ܵۼֵ */
    UINT32                      dwHarq3TransCnt;          /* HARQ ID=3Ĵͳ ܵۼֵ */

    UINT32                      dwHarqRv0Cnt;             /* RV=0ͳ ܵۼֵ */
    UINT32                      dwHarqRv1Cnt;             /* RV=1ͳ ܵۼֵ */
    UINT32                      dwHarqRv2Cnt;             /* RV=2ͳ ܵۼֵ */  
    UINT32                      dwHarqRv3Cnt;             /* RV=3ͳ ܵۼֵ */

    UINT32                      dwCurHarqId;              /* ǰHARQ ID */    
    
    UINT32                      dwHarqMaxReTxLimit;       /* شƴ· */    
    
    /* гشϢͳƳشBlerϢ */
    UINT32                      dwUlHarqInitAck;          /* гACKͳϢ ܵۼֵ· */   
    UINT32                      dwUlHarqInitNack;         /* гNACKͳϢ ܵۼֵ· */
    UINT32                      dwUlHarqReTxAck;          /* شACKͳϢ ܵۼֵ· */
    UINT32                      dwUlHarqReTxNack;         /* شNACKͳϢ ܵۼֵ· */
    
    /*еһΡڶΡΡĴԼشɹ*/
    UINT32                      dwUlHarq1stSuccNum;       /* һشɹ ܵۼֵ· */
    UINT32                      dwUlHarq2ndSuccNum;       /* ڶشɹ ܵۼֵ· */
    UINT32                      dwUlHarq3rdSuccNum;       /* شɹ ܵۼֵ· */
    UINT32                      dwUlHarq4thSuccNum;       /* Ĵشɹ ܵۼֵ· */
    UINT32                      dwUlHarqOtherSuccNum;     /* شɹ ܵۼֵ· */
    
    /*ģHarq ID ACKNACK*/
    UINT32                      adwUlHarqIdAck[8];        /* 8HARQ ACKͳϢIDܵۼֵ· */
    UINT32                      adwUlHarqIdNack[8];       /* 8HARQ NACKͳϢIDܵۼֵ· */
}T_zPHY_EUL_HarqTransStatisticsInfo;
/*========================================================================
LOG_TOOL_LTE_PHY_EXT_DCI0_INFO
˵ DCI0 Ϣ 10ռ䣬ֱ֡ͳ
=========================================================================*/
typedef struct
{
    
    UINT16		            cHoppingFlag;          /* DCI0еƵflag */
    UINT16		            wBlockAssignment;      /* DCI0еRB */
    UINT16		            cMCS;                  /* DCI0еMCS */
    UINT16		            cNewDataFlag;          /* DCI0еNDI */
    UINT16		            cTpcCommand;           /* DCI0еTPC */
    UINT16		            cDMRSCyclicShift;      /* DCI0DMRSѭλ */
    UINT16		            cUlIndex;              /* DCI0еUL Indexλ֡0 */
    UINT16		            cDAI;                  /* DCI0езָʾ */
    UINT16		            cCqiRequest;           /* DCI0еCQIָʾλ */
    UINT16		            cRbStart;              /* DCI0еRIVָʾRBʼλ */
    UINT16		            cLcrbs;                /* DCI0еRIVָʾRB */
	UINT16                   wpading;               /*壬4ֽڶ*/
}T_zPHY_Dci0Info;
typedef struct
{
    T_zPHY_Dci0Info atDci0Info[ZPHY_DEBUG_TMT_SIZE];   
}T_zPHY_EUL_Dci0Info;
/*========================================================================
LOG_TOOL_LTE_PHY_EXT_DCI3OR3A_INFO
˵  TPCϢ 
=========================================================================*/
typedef struct
{
    UINT32                      dwSFN;    //ʱϢ
    UINT16                       cPuschDCI3or3aTpcIdx;    /* ŷʽΪTPC-PUSCH-RNTIDCI3/3AлõTPC Command */
    UINT16                       cPucchDCI3or3aTpcIdx;    /* ŷʽΪTPC-PUCCH-RNTIDCI3/3AлõTPC Command */
}T_zPHY_EUL_DCI3Or3AInfo;
/*========================================================================
LOG_TOOL_LTE_PHY_EXT_ULPOWERCTRL_INFO
˵  йϢ֡ĵǰֵʵʱֵ 
=========================================================================*/
typedef struct
{
    UINT32                                        dwSFN;
    SINT16                                       aswPucchGi[ZPHY_DEBUG_TMT_SIZE];          /* PUCCHջزGi· */
	SINT16						aswPucchPower[ZPHY_DEBUG_TMT_SIZE];        /* PUCCHķ͹ͳ */
	SINT16						aswPuschPower[ZPHY_DEBUG_TMT_SIZE];        /* PUSCHķ͹ͳ */
	SINT16						aswSrsPower[ZPHY_DEBUG_TMT_SIZE];          /* SRSķ͹ͳ */
	SINT16						aswPrachPower[ZPHY_DEBUG_TMT_SIZE];        /* PRACHķ͹ͳ */	
	UINT16						acPuschPowerHeadroom[ZPHY_DEBUG_TMT_SIZE]; /* PUSCHķ͹ʣPHR */
}T_zPHY_EUL_PowerCtrlInfo;
/*========================================================================
LOG_TOOL_LTE_PHY_DFE_DEBUG_INFO
˵  ռDFEҪȫֱTMTʵʱѯ,add by zhoupeng 2011.03.14 
=========================================================================*/
typedef struct
{
	UINT16 	cRxAntennaMode;                         /* ģʽ ĬֵΪģʽ */
	UINT16 	cSyncMode;                              /* ͬģʽ */
	UINT16 	cLNAMode0;
	UINT16 	cLNAMode1;        /* LNAģʽ */
	
	UINT16 	wAgcdBGain0;
	UINT16 	wAgcdBGain1;         /* AGCֵ dB <8,7,u> */
			
	UINT16 	wRxLinDagc0;
	UINT16 	wRxLinDagc1;         /* RX· DAGCֵ ֵ <12,8,u> */
	
	UINT16 	wCsrmLinDagc0;
	UINT16 	wCsrmLinDagc1;     /* CSRM· DAGCֵ ֵ <12,8,u> */
	
	UINT16 	wCsrsLinDagc0;
	UINT16 	wCsrsLinDagc1;     /* CSRS· DAGCֵ ֵ <12,8,u> */
	
	struct
	{
	    UINT16                     wAgcGainMaxFlag;                 /* ƽⲹָʾ */
	    UINT16                    wMaxdBVulue;                     //·߽ϴֵ,<8,8,u>
	    SINT16 	              swAgcFactorLog2;                 /* ƽⲹ<16,7,t> log2ֵ*/
	    UINT16                    wAgcFactor;                      /* ƽⲹ<10,0,u> */
	} tRxAgcBalance;               /* Rx·ƽָʾ */

	struct
	{
	    UINT16                     wAgcGainMaxFlag;                 /* ƽⲹָʾ */
	    UINT16                    wMaxdBVulue;                     //·߽ϴֵ,<8,8,u>
	    SINT16 	               swAgcFactorLog2;                 /* ƽⲹ<16,7,t> log2ֵ*/
	    UINT16                    wAgcFactor;                      /* ƽⲹ<10,0,u> */
	} tCsrsAgcBalance;             /* Csrs·ƽָʾ */

	struct
	{
	    UINT16                     wAgcGainMaxFlag;                 /* ƽⲹָʾ */
	    UINT16                    wMaxdBVulue;                     //·߽ϴֵ,<8,8,u>
	    SINT16 	              swAgcFactorLog2;                 /* ƽⲹ<16,7,t> log2ֵ*/
	    UINT16                    wAgcFactor;                      /* ƽⲹ<10,0,u> */
	} tCsrmAgcBalance;             /* Csrm·ƽָʾ */

	/* CSRM10ֵ֡ <14,6,u> */
	struct
	{
	    UINT16 	                  wTotalAgcGain0Log2;              /* 0ֵ <14,6,u> log2ֵ */
	    UINT16                        wTotalAgcGain1Log2;              /* 1ֵ <14,6,u> log2ֵ */
	} awCsrmTotalAgcGainLog2[ZPHY_SUBFRAMES_PER_FRAME];
	
	/* RX10ֵ֡ <14,6,u> */
	struct
	{
	    UINT16 	                  wTotalAgcGain0Log2;              /* 0ֵ <14,6,u> log2ֵ */
	    UINT16                        wTotalAgcGain1Log2;              /* 1ֵ <14,6,u> log2ֵ */
	} awRxTotalAgcGainLog2[ZPHY_SUBFRAMES_PER_FRAME];

	/* AGCʱ10msƽ */
	SINT16 	aswNotSyncAgcMeanPwr0[70];
	SINT16 	aswNotSyncAgcMeanPwr1[70];
	/* AGCʱ¼ƽֵ */
	SINT16 	swMaxAGCMeanPwr0;
	SINT16 	swMaxAGCMeanPwr1;
	/* AGCɱ־ */
	UINT16 	wNotSyncAGCDone;
	/* Ƶһ֡־ */
	UINT16 	wNotSyncAGCBegin;
	//Ϊʵ˫߷ͬAGCȫֱ,add by zhoupeng 2010.11.6
	UINT16 	wNotSyncAGCDoneAnt0;//0 AGC־
	UINT16 	wNotSyncAGCDoneAnt1;//1 AGC־
	union
	{    
	    struct
		{
		    UINT32 RXBandwidth          :3;       /* Bit[0-2] TX· */
		    UINT32 CPMode               :1;       /* Bit[3] CPģʽ */
		    UINT32 Reserved             :28;      /* Bit[4-31] */
		} tBit;
		
	      UINT32                             dwReg; 
	} 	tRXBandwidthCPMode;
	
	UINT16  	wRxBandwidth;
	UINT16 	cDAGCCalMode;               /* DAGC ģʽ */
	UINT16 	cAGCCalMode;                /* AGC ģʽ */
	UINT16   wpading;                    /*4ֽڶ룬*/
}T_zPHY_EDFE_SYSTEM_INFO;
/*========================================================================
LOG_TOOL_LTE_PHY_RFC_DEBUG_INFO
˵  RFC ״̬ݿ 
=========================================================================*/
typedef struct 
{
    UINT32  				dwRfcSynState;              /*RFCָͬͬʾ ʼΪͬ*/
    UINT32  				dwRfcState;                 /*RFCϡָʾ(֡ͬʱڵ)ʼΪIDLE״̬*/
    UINT16   						bRfcServCellReceive;      /*Сָʾʹʱ򿪣ĬϹر*/
    UINT16  						bRfcCsrCellSearch;          /*СָͬʾʼΪر*/
    UINT32                  dwRfcCsrCellMeas;          /*СָʾɨƵָʾɨƵRFC_syn_stateΪͬѡС˫Сʼر*/
    UINT32   						dwRfcFrequencePoint;       /*Ƶ ʼΪ0 */
    UINT32                       dwRfcFilterBand;            /* ʼΪ20MHz*/	
    UINT32  						dwRfcAsynOffset;           /*ִͬʼʱ䣬ʼΪ0*/	
    UINT32 						dwRfcRxOffsetAnt0;         /*߽ͬ֡磨0ʼΪ0*/
    UINT32 						dwRfcRxOffsetAnt1;         /*RX1߽ͬ֡磨1ʼΪ0*/
    UINT32  						dwRfcRxOffset0;            /*0߽֡磬ʼΪ0*/
    UINT32 						dwRfcRxOffset1;            /*1߽֡,ʼΪ0*/
    UINT16   						cRfcSubFrameNo;           /*߽ͬ֡дʱҪRFC֡תòָתĿ֡ Χ0-9 ʼֵ0xff */
    UINT16  						cRfcSubFrameNo0;          /*0߽֡дʱҪRFC֡תòָתĿ֡ Χ0-9 ʼֵ0xff*/
    UINT16  						cRfcSubFrameNo1;          /*1߽֡дʱҪRFC֡תòָתĿ֡ Χ0-9 ʼֵ0xff*/
    UINT16   						cRfcSubFrameNo2;     /*txĎ߽дʱҪRFC֡תòָתĿ֡ Χ0-9 ʼֵ0xff*/	
    UINT32  			       dwRfcUDMode;                /*ͬ֡,ʼΪE_FRAME_UD_TYPE2*/		
    UINT32  			       dwRfcCPMode;                /*ͬcpģʽ ʼΪnormal CP*/
    UINT32  			       dwRfcCPMode0;               /*0cpģʽ ʼΪnormal CP*/
    UINT32  			       dwRfcCPMode1;               /*1cpģʽ ʼΪnormal CP*/
    UINT16							cRfcMeasSymStart0;				 /*0ȥCPЧſʼ ʼΪ0*/
    UINT16							cRfcMeasSymStart1;				 /*1ȥCPЧſʼ ʼΪ0*/
    UINT32                      dwRfcSpecSubFrameMode;      /*֡GPģʽ ʼΪE_SPEC_SUB_FRAME_TYPE1*/
    UINT32 						dwRfcFreqOffset;           /*ƵƫֵڵRF ʼΪ0*/
    SINT32   						sdwRfcTxOffset;             /*жʱǰʼΪ0*/
    UINT32 						dwRfcRxOffsetAnt0ForTx;         /*TX߽֡磨0ʼΪ0*/
    UINT32 						dwRfcRxOffsetAnt1ForTx;         /*TX߽֡磨1ʼΪ0*/	
    UINT32    			       dwRfcTxAntIndex;					   /*зѡ01ʼΪ0*/
    UINT32    			       dwRfcTxAntIndexForSRS;					   /*зѡ(һSRS)01Ĭϸòδ޸*/
    UINT32 		                dwRfcPowerCloseMode;     	 /*빦ʹرʱ ʼΪE_POWER_CLOSE_NOT_USED*/
    SINT16 						swRfcFirstSymbPower;        /*еһŷ͵Ĺ,ʼΪ0x0fff */
    SINT16 						swRfcLastSymbPower;         /*еŷ͵Ĺ ʼΪ0x0fff*/
    SINT16  						swRfcSpecialPrachPower;     /*֡PRACHֵ,ʼΪ0x0fff */
	UINT16                          wpading;                   /*壬4ֽڶ*/
    UINT32		                dwApcFirstSymbChanType;/*ʿƵһŵͣһһΪSRSTXø֪RFC*/	
    SINT32                      swFreqOffset;
} T_ZPHY_ERFC_INFO;
/*========================================================================
LOG_TOOL_LTE_PHY_ECSR_DEBUGMIB_INFO

=========================================================================*/
typedef struct
{
    UINT16 wCellBand;                       /* д*/
    UINT16 wPhichConfig;                    /* PHICH*/
}T_zPHY_ECSR_DebugMibInfo; /* MIBϢ·ĸʽЩһ */

typedef struct 
{ 
     WORD            wStartPhyCellId;
     WORD            wPhyCellIdNum;
} T_zPHY_DebugPhyCellIdRange;

typedef struct 
{ 
    WORD          wEarfcn;
    UINT16           bMeasBandWidth;  
    UINT16           bCellNum;
    WORD          awPhyCellIdList[32];
    UINT16           bPadding;
    UINT16           bPresenceAntennaPort1;
    UINT16           bNCellConfig;
    UINT16           bBlackCellNum;
    T_zPHY_DebugPhyCellIdRange  atPhyCellIdRangeList[32];
    WORD          wNoDrxReportPeriod;
    WORD          wDrxReportPeriod;
} T_zPHY_DebugMeasFreqInfo;  

typedef struct
{
    UINT16                              bMsgId;
    UINT16                              bReportQuantity;
    UINT16                              bMaxCellReportPerFreq;
    UINT16                              bFreqNum;
    T_zPHY_DebugMeasFreqInfo         atMeasFreqInfoList[4];
}T_zPHY_ECSR_MeasConfigInfo;

typedef struct
{
     UINT16             bMsgId;
     UINT16             bPadding;
     WORD           wMeasBitMask;
     WORD           wPading1;
}T_zPHY_ECSR_MeasMaskSetInfo; 


typedef struct  
{
    UINT32 Ts       :12;                 
    UINT32 Symbol   :3;       
    UINT32 Slot     :5;          
    UINT32 Frame    :10;        
    UINT32 Resv     :2;             
}T_zPHY_DebugSeg4Time;

typedef struct  
{
    UINT32 Ts       :14;                       
    UINT32 Slot     :5;         
    UINT32 Frame    :10;        
    UINT32 Resv     :3;             
}T_zPHY_DebugSeg3Time;

typedef union
{       
    UINT32          dwReg;
    T_zPHY_DebugSeg4Time tSeg4;  
    T_zPHY_DebugSeg3Time tSeg3;  
}T_zPHY_DebugTime;  

typedef struct
{
    UINT32 dwMeasState      :8;         /*С״̬*/
    UINT32 dwSearchState    :8;         /*С״̬*/
    UINT32 dwReserve        :16;    
}T_zPHY_ECSR_DebugCsrCellState;

typedef struct
{
    T_zPHY_DebugTime		tCellFrameBoundry;          /*߽֡Ϣʱ*/
   
}T_zPHY_ECSR_DebugCsrFrameBoundryInfo;

typedef struct
{
	UINT16			    wCellBchMimo;		        /*BCHģʽä⣬BCHäõڷä⣬CTRLд*/
    UINT16			    wCellBchCrcReslut;          /*BCHCRC*/
    UINT16			    wCellBchMark;	            /*BCHʾڱʾǰСǷѾBCHǷҪBCH룬bchѯ*/
    UINT16			    wCellBchPhich;	            /*BCHõPHICH*/
	UINT16				wCellBchBand ;
	UINT16              wPading;                     /*壬4ֽڶ*/
    T_zPHY_DebugTime	    tCellBchSfnOffset;	        /*BCHõ߽֡*/
}T_zPHY_ECSR_DebugCsrBchInfo;		            /*еBCHϢ*/

typedef struct
{
    					
    UINT32			    CsrDDMode;
    UINT32				tCsrCPMode;
    T_zPHY_ECSR_DebugCsrFrameBoundryInfo		tCsrFrameBoundryInfo;
    UINT16                              wCsrFingerValue;       /*SSCHõķֵ(һ),ںϲС---Added by gaozhuhong 0913*/
	UINT16              wPading;                     /*壬4ֽڶ*/
}T_zPHY_ECSR_DebugCsrSearchInfo;

typedef struct
{
    SINT16			    swCellMeasRSRP;              /*õRSRPֵɲģдCTRLȡ*/
    SINT16				swCellMeasRSRQ;              /*õRSRQֵɲģдCTRLȡ*/
    UINT16				wCellMeasBand;              /*CTRLģյʱ޸ģģȡ*/
    UINT16				wCellMeasMinBand;           /*CTRLģ34.101ƵκСӦҵӪ̵ıҵģȡ*/
    UINT16				wCellMeasTimes;              /*CTRL ģõĵǰСĲģȡ*/
    UINT16				wCellMeasAntPort;           /*ߣCTRLģյʱ޸ģģȡ*/
    UINT16              wCellMeasReportQuan;              /*0,ֻrsrp1RSRPRSRQһ*/
    UINT16			    bNCellConfig;               /*СǷһµıʾCTRLģյʱ޸ģģȡ*/

}T_zPHY_ECSR_DebugCsrMeasInfo;               /*CSRԵĲúͽ*/

typedef struct
{
    UINT32  mSearchPriority     :8;
    UINT32  mMeasPriority       :8;
    UINT32  mBlacklistPriority  :8;
    UINT32  mCellValidPriority  :8;
}T_zPHY_ECSR_DebugCsrPriority;

typedef union
{
    UINT32 dwPrio;
    T_zPHY_ECSR_DebugCsrPriority tPrio;
}U_zPHY_ECSR_DebugCsrPriority;

typedef struct
{
    
    UINT16				wCellFrameBoundryAge;       /*߽֡ϻֵ*/
    UINT16				wCellMeasAge;               /*ǰϻֵCTRLģ鶨ڸ£ģȡ*/
    UINT16			    wCellBchAge	; 		        /*BCHŵϻֵ*/
    UINT16              wpading;                  /*壬4ֽڶ*/
    
}T_zPHY_ECSR_DebugCsrAgeInfo;

typedef struct
{
    UINT16 								wEarfcn;
    UINT16								wCellId;
    T_zPHY_ECSR_DebugCsrAgeInfo         tCsrAgeInfo;
    U_zPHY_ECSR_DebugCsrPriority		tCsrPriotity;	
    T_zPHY_ECSR_DebugCsrMeasInfo		tCsrMeasInfo;
    T_zPHY_ECSR_DebugCsrSearchInfo		tCsrSearchInfo;
    T_zPHY_ECSR_DebugCsrBchInfo			tCsrBchInfo ;
    T_zPHY_ECSR_DebugCsrCellState       tCellState;
}T_zPHY_ECSR_DebugCsrCellInfo;
typedef struct
{
    UINT16 wAgcGain0;
    UINT16 wAgcGain1;
    SINT32 sdwAfc;
    UINT16 wEarcfn;
    UINT16 wFreq;
}T_zPHY_ECSR_DebugFreqPointInfor;

typedef struct
{
    UINT16 wServingCellFreq;	/*СƵ*/
    UINT16 wNextInterFreq;	    /*¸GapƵƵ*/
    UINT16 wServingCellID;	    /*ССID*/
	UINT16 wpading;             /*壬4ֽڶ*/   
    T_zPHY_ECSR_DebugFreqPointInfor  atFreqPointInforTab[4];      
    UINT32	tCsrMainState;		/*CSRϵͳǰ״̬*/
    T_zPHY_ECSR_DebugCsrCellInfo	    tCsrCellInfo[16]; /*ṹ󣬽64С16*/
}T_zPHY_ECSR_CellDataBaseInfo; 

typedef struct
{
    UINT32           dwSFN;
    UINT32           dwUeAntNum;
    UINT32           dwBsAntNum;
    UINT32           dwDlBandWidth;
    UINT32           dwTransMode;
    UINT32           dwRxTxBitmap;
    SINT64           sdwNoiseOutput;

    SINT64           sdwRsrpOutput0;
    SINT64           sdwRsrpOutput1;
    SINT64           sdwRsrpOutput2;
    SINT64           sdwRsrpOutput3;
    SINT64           sdwRsrpOutput4;
    SINT64           sdwRsrpOutput5;
    SINT64           sdwRsrpOutput6;
    SINT64           sdwRsrpOutput7;

    SINT64           sdwRspOutput0;
    SINT64           sdwRspOutput1;
    SINT64           sdwRspOutput2;
    SINT64           sdwRspOutput3;
}T_zPHY_EDL_CALC_For_SINR;

typedef struct
{
    UINT32           dwSFN;    //ʱϢ
    
    /*  */
    UINT32           dwDlTB1Flow;
    UINT32           dwDlTB2Flow;
    
    /*  */
    UINT32           dwUlFlow;
    UINT32 dwUlRbNum;         //ýӿ PUSCH Rb Count(RB).  Resource Schedule Information
    UINT32 dwDlRbNum;         //ýӿ PDSCH Rb Count(RB).  Resource Schedule Information
    
}T_zPHY_ULDL_Flow_Info;

typedef struct
{
    UINT32           dwRaRnti;
    UINT32           dwTCRnti;
    UINT32           dwDrxStatus;      
}T_zPHY_EUE_Info;

typedef struct
{ 
    UINT32 PreamSeqIdx;
	UINT32 PhyRootIdx;
	UINT32 CyclicShift;
	SINT32 PreamTxPower;
	UINT32 N_ra_Prb;
	UINT32 PreamFormat;
	UINT16 Duplex_Mode;
	UINT16 f_ra;
	UINT16 t_0_ra;
	UINT16 t_1_ra;
	UINT16 t_2_ra;
	UINT16 Density;
	//UINT16 Reserved;
	UINT32 AccessTime;
	UINT32 RARWinStrat;
	UINT32 RARWinEnd;
	UINT32 RA_RNTI;
	UINT32 PreamActTxPower;
}T_zPHY_EPRACH_Msg1Info;

typedef struct 
{
    UINT32 TPCValue;
	UINT32 MCSValue;
	UINT32 RIV;
	UINT32 CQI;
	UINT32 ULDelay;
	UINT32 HoppingFlag;
	UINT32 Msg3_SFN;
	UINT32 Msg3_SubFrm;
	UINT32 StartResBlock;
	UINT32 TotalResBlockNum;
	UINT32 TransBlockSizeIdx;
	UINT32 ModulationType;
	UINT32 RedundancyVersionIdx;
	UINT32 HarqID;
	
}T_zPHY_EPRACH_Msg3Info;

typedef struct 
{
    UINT32 Msg4_SFN;
	UINT32 Msg4_SubFrm;
	UINT32 Content_Result;
	UINT16 Msg4_Ack_SFN;
	UINT16 Msg4_Ack_SubFrm;

}T_zPHY_EPRACH_Msg4Info;

typedef struct 
{
    UINT32 RARTime;
	UINT32 TAValue;
	UINT32 TAInclude;
	UINT32 RACHType;
	UINT32 RACHMode;
	UINT32 RNTI_Type;
	UINT32 RNTI_Value;
	
}T_zPHY_EPRACH_Msg2Info;
#endif
