
#ifndef	_PHY_LTEA_LOG_IF_H_
#define	_PHY_LTEA_LOG_IF_H_

#define ZPHY_DEBUG_TMT_SIZE    10 

/**************************************************************************
 *                         ȫֱ                                    *
 **************************************************************************/
typedef struct
{
    UINT32 dwWorkEarfcn;            /* Ƶ */
    UINT32 dwWorkCellId;            /* СID */
    UINT32 dwSysBw;                 /* ϵͳ */
    UINT32 dwSubFrmType;            /* ֡ */
    UINT32 dwSpecSubFrmType;        /* ֡ */
    UINT32 dwDlTransMode;           /* дģʽ */
    UINT32 dwUlTransMode;           /* дģʽ */
    UINT32 dwCrntiVal;              /* CRNTI */
    UINT32 dwRaRnti;                /* RaRNTI */
    UINT32 dwTCRnti;                /* TCRNTI */
    UINT32 dwDrxStatus;             /* DrxStatus */
}T_zPHY_UE_Info;


typedef struct
{
    UINT32 dwSFN;    //ʱϢ
    
    /*  */
    UINT32 dwDlTBFlow[2];
    
    /*  */
    UINT32 dwUlTBFlow[2];
    
    UINT32 dwUlRbNum[2];     
    UINT32 dwDlRbNum[2];       
}T_zPHY_ULDL_Flow_Info;

typedef struct
{
    UINT32 dwPowerA;      /* DedicatedϢPDSCHʲĲ */
    UINT32 dwPowerB;      /* CommonϢPDSCHʲĲ */
}T_ZPHY_EDL_PA_INFO;

/* DCIͳϢ */
typedef struct
{
    UINT32 dwSFN;                      /* ʱϢ */
    UINT32 dwResource;                 /* Դֶ */
    UINT32 adwRbBmp[8];                /* 1-bitRB-demapping bitmap */
    UINT32 dwRaType;                   /* RA  */
    UINT32 dwRbNum;                    /* RB */
    UINT32 dwRbStart;                  /* RBʵλ */
    UINT32 dwRbLength;                 /* RB */
    UINT32 dwHarqId;                   /* HARQ ID */
    UINT32 dwTb1Mcs;                   /* TB1 MCSֵ */
    UINT32 dwTb2Mcs;                   /* TB2 MCSֵ */
    UINT32 dwTb1Ndi;                   /* TB1 NDI */
    UINT32 dwTb2Ndi;                   /* TB2 NDI */
    UINT32 dwTb1Rv;                    /* TB1 汾 */
    UINT32 dwTb2Rv;                    /* TB2 汾 */
    UINT32 dwDaiIdx;                   /* DAI  */
}T_ZPHY_EDL_DCI_DECODE;

typedef struct
{
    T_ZPHY_EDL_DCI_DECODE atDlDciInfo[10]; /* 10֡DCIͳ */
}T_ZPHY_EDL_DCI_INFO;


/* HARQϢͳ */
typedef struct
{
    UINT32 adwRevTb1RvNum[4];        /* TB1 Եۼͳ */
    UINT32 adwRevTb2RvNum[4];        /* TB2 Եۼͳ */

    /*ģHarq ID ACKNACK*/
    UINT32 adwDlHarqIdAck[2][15];    /* 15HARQ IDACKϢIDܵۼ */
    UINT32 adwDlHarqIdNack[2][15];   /* 15HARQ IDNACKϢIDܵۼ */

    UINT32 adwDlHarqSuccNum[2][4];      /* TB1TB2شɹͳƣ ܵۼֵ */
}T_ZPHY_EDL_HARQ_INFO;

/* PDSCHͳϢ */
typedef struct
{
    /*Statistic Si-Rnti PDSCH Decode Info*/
    UINT32 adwSiRntiCrcOkNum[10];       /* Si-Rnti  CRC_OK ֡ۼ */
    UINT32 adwSiRntiCrcErrNum[10];      /* Si-Rnti  CRC_ERR ֡ۼ */
    UINT32 dwSiRntiCrcOkSumNum;         /* Si-Rnti  CRC_OK ܵۼ */
    UINT32 dwSiRntiCrcErrSumNum;        /* Si-Rnti  CRC_ERR ܵۼ */

    /*Statistic P-Rnti PDSCH Decode Info*/
    UINT32 adwPRntiCrcOkNum[10];        /* P-Rnti  CRC_OK ֡ۼ */
    UINT32 adwPRntiCrcErrNum[10];       /* P-Rnti  CRC_ERR ֡ۼ */
    UINT32 dwPRntiCrcOkSumNum;          /* P-Rnti  CRC_OK ܵۼ */
    UINT32 dwPRntiCrcErrSumNum;         /* P-Rnti  CRC_ERR ܵۼ */

    /*Statistic Ra-Rnti PDSCH Decode Info*/
    UINT32 adwRaRntiCrcOkNum[10];       /* Ra-Rnti  CRC_OK ֡ۼ */
    UINT32 adwRaRntiCrcErrNum[10];      /* Ra-Rnti  CRC_ERR ֡ۼ */
    UINT32 dwRaRntiCrcOkSumNum;         /* Ra-Rnti  CRC_OK ܵۼ */
    UINT32 dwRaRntiCrcErrSumNum;        /* Ra-Rnti  CRC_ERR ܵۼ */

    /*Statistic Tc-Rnti PDSCH Decode Info*/
    UINT32 adwTcRntiCrcOkNum[10];       /* Tc-Rnti  CRC_OK ֡ۼ */
    UINT32 adwTcRntiCrcErrNum[10];      /* Tc-Rnti  CRC_OK ֡ۼ */
    UINT32 dwTcRntiCrcOkSumNum;         /* Tc-Rnti  CRC_OK ܵۼ */
    UINT32 dwTcRntiCrcErrSumNum;        /* Tc-Rnti  CRC_OK ܵۼ */

    /*Statistic C-Rnti PDSCH Decode Info*/
    UINT32 adwCRntiTbCrcOkNum[2][10];   /* TB12 C-Rnti  CRC_OK ֡ۼ */
    UINT32 adwCRntiTbCrcErrNum[2][10];  /* TB12 C-Rnti  CRC_ERR ֡ۼ */
    UINT32 adwCRntiTbCrcOkSumNum[2];    /* TB12 C-Rnti  CRC_OK ܵۼ */
    UINT32 adwCRntiTbCrcErrSumNum[2];   /* TB12 C-Rnti  CRC_ERR ܵۼ */

    /*Statistic Sps-Rnti PDSCH Decode Info*/
    UINT32 adwSpsRntiCrcOkNum[10];      /* Sps-Rnti  CRC_OK ֡ۼ */
    UINT32 adwSpsRntiCrcErrNum[10];     /* Sps-Rnti  CRC_OK ֡ۼ */
    UINT32 adwSpsRntiCrcOkSumNum;       /* Sps-Rnti  CRC_OK ܵۼ */
    UINT32 adwSpsRntiCrcErrSumNum;      /* Sps-Rnti  CRC_OK ܵۼ */
}T_ZPHY_EDL_PDSCH_INFO;

/*PDCCHäͳϢ*/
typedef struct
{
    /*Statistic Si-Rnti Dci Info*/
    UINT32 adwSiRntiDci1ANum[10];       /* Si-Rnti DCI_1A ֡ۼ */
    UINT32 adwSiRntiDci1CNum[10];       /* Si-Rnti DCI_1C ֡ۼ */
    UINT32 dwSiRntiDci1ASumNum;         /* Si-Rnti DCI_1A ܵۼ */
    UINT32 dwSiRntiDci1CSumNum;         /* Si-Rnti DCI_1C ܵۼ */
    UINT32 dwSiRntiDciSumNum;           /* Si-Rnti DciܵͳƸ */

    /*Statistic P-Rnti Dci Info*/
    UINT32 adwPRntiDci1ANum[10];        /* P-Rnti DCI_1A ֡ۼ */
    UINT32 adwPRntiDci1CNum[10];        /* P-Rnti DCI_1C ֡ۼ */
    UINT32 dwPRntiDci1ASumNum;          /* P-Rnti DCI_1A ܵۼ */
    UINT32 dwPRntiDci1CSumNum;          /* P-Rnti DCI_1C ܵۼ */
    UINT32 dwPRntiDciSumNum;            /* P-Rnti DciܵͳƸ */

    /*Statistic Ra-Rnti Dci Info*/
    UINT32 adwRaRntiDci1ANum[10];       /* Ra-Rnti DCI_1A ֡ۼ */
    UINT32 adwRaRntiDci1CNum[10];       /* Ra-Rnti DCI_1C ֡ۼ */
    UINT32 dwRaRntiDci1ASumNum;         /* Ra-Rnti DCI_1A ܵۼ */
    UINT32 dwRaRntiDci1CSumNum;         /* Ra-Rnti DCI_1C ܵۼ */
    UINT32 dwRaRntiDciSumNum;           /* Ra-Rnti DciܵͳƸ */

    /*Statistic Tc-Rnti Dci Info*/
    UINT32 adwTcRntiDci1Num[10];        /* Tc-Rnti DCI_1 ֡ۼ */
    UINT32 adwTcRntiDci1ANum[10];       /* Tc-Rnti DCI_1A ֡ۼ */
    UINT32 dwTcRntiDci1SumNum;          /* Tc-Rnti DCI_1 ܵۼ */
    UINT32 dwTcRntiDci1ASumNum;         /* Tc-Rnti DCI_1A ܵۼ */
    UINT32 dwTcRntiDciSumNum;           /* Tc-Rnti DciܵͳƸ */

    /*Statistic Tpc-Rnti Dci Info*/
    UINT32 adwTpcRntiDci3Num[10];       /* Tpc-Rnti DCI_3 ֡ۼ */
    UINT32 adwTpcRntiDci3ANum[10];      /* Tpc-Rnti DCI_3A ֡ۼ */
    UINT32 adwTpcRntiDci3SumNum;        /* Tpc-Rnti DCI_3 ܵۼ */
    UINT32 adwTpcRntiDci3ASumNum;       /* Tpc-Rnti DCI_3A ܵۼ */
    UINT32 adwPucchTpcDci33ASumNum;
    UINT32 adwPuschTpcDci33ASumNum;

    /*Statistic C-Rnti Dci Info*/
    UINT32 adwCRntiDci01Num[10];        /* DCI0_1 ֡ۼ */
    UINT32 adwCRntiDci02Num[10];        /* DCI0_2 ֡ۼ */
    UINT32 adwCRntiDci03Num[10];        /* DCI0_3 ֡ۼ */
    UINT32 adwCRntiDci04Num[10];        /* DCI0_4 ֡ۼ */
    UINT32 adwCRntiDci41Num[10];        /* DCI41 ֡ۼ */
    UINT32 adwCRntiDci42Num[10];        /* DCI42 ֡ۼ */
    UINT32 adwCRntiDci43Num[10];        /* DCI43 ֡ۼ */
    UINT32 adwCRntiDci44Num[10];        /* DCI44 ֡ۼ */
    UINT32 adwCRntiDci1Num[10];         /* C-Rnti DCI_1 ֡ۼ */
    UINT32 adwCRntiDci1ANum[10];        /* C-Rnti DCI_1A ֡ۼ */
    UINT32 adwCRntiDci1BNum[10];        /* C-Rnti DCI_1B ֡ۼ */
    UINT32 adwCRntiDci1DNum[10];        /* C-Rnti DCI_1D ֡ۼ */
    UINT32 adwCRntiDci2Num[10];         /* C-Rnti DCI_2 ֡ۼ */
    UINT32 adwCRntiDci2ANum[10];        /* C-Rnti DCI_2A ֡ۼ */
    UINT32 adwCRntiDci2BNum[10];        /* C-Rnti DCI_2B ֡ۼ */
    UINT32 adwCRntiDci2CNum[10];        /* C-Rnti DCI_2C ֡ۼ */
    UINT32 adwCRntiDci01SumNum;         /* C-Rnti DCI_01 ܵۼ */
    UINT32 adwCRntiDci02SumNum;         /* C-Rnti DCI_02 ܵۼ */
    UINT32 adwCRntiDci03SumNum;         /* C-Rnti DCI_03 ܵۼ */
    UINT32 adwCRntiDci04SumNum;         /* C-Rnti DCI_04 ܵۼ */
    UINT32 adwCRntiDci41SumNum;         /* C-Rnti DCI_4 ܵۼ */
    UINT32 adwCRntiDci42SumNum;         /* C-Rnti DCI_4 ܵۼ */
    UINT32 adwCRntiDci43SumNum;         /* C-Rnti DCI_4 ܵۼ */
    UINT32 adwCRntiDci44SumNum;         /* C-Rnti DCI_4 ܵۼ */
    UINT32 adwCRntiDci1SumNum;          /* C-Rnti DCI_1 ܵۼ */
    UINT32 adwCRntiDci1ASumNum;         /* C-Rnti DCI_1A ܵۼ */
    UINT32 adwCRntiDci1BSumNum;         /* C-Rnti DCI_1B ܵۼ */
    UINT32 adwCRntiDci1DSumNum;         /* C-Rnti DCI_1D ܵۼ */
    UINT32 adwCRntiDci2SumNum;          /* C-Rnti DCI_2 ܵۼ */
    UINT32 adwCRntiDci2ASumNum;         /* C-Rnti DCI_2A ܵۼ */
    UINT32 adwCRntiDci2BSumNum;         /* C-Rnti DCI_2B ܵۼ */
    UINT32 adwCRntiDci2CSumNum;         /* C-Rnti DCI_2C ܵۼ */
    UINT32 adwCRntiDciSumNum;           /* C-Rnti DciܵͳƸ */

    /*Statistic Sps-Rnti Dci Info*/
    UINT32 adwSpsRntiDci1Num[10];       /* Sps-Rnti DCI_1 ֡ۼ */
    UINT32 adwSpsRntiDci1ANum[10];      /* Sps-Rnti DCI_1A ֡ۼ */
    UINT32 adwSpsRntiDci2Num[10];       /* Sps-Rnti DCI_2 ֡ۼ */
    UINT32 adwSpsRntiDci2ANum[10];      /* Sps-Rnti DCI_2A ֡ۼ */
    UINT32 adwSpsRntiDci2BNum[10];      /* Sps-Rnti DCI_2B ֡ۼ */
    UINT32 adwSpsRntiDci2CNum[10];      /* Sps-Rnti DCI_2B ֡ۼ */
    UINT32 adwSpsRntiDci1SunNum;        /* Sps-Rnti DCI_1 ܵۼ */
    UINT32 adwSpsRntiDci1ASunNum;       /* Sps-Rnti DCI_1A ܵۼ */
    UINT32 adwSpsRntiDci2SunNum;        /* Sps-Rnti DCI_2 ܵۼ */
    UINT32 adwSpsRntiDci2ASunNum;       /* Sps-Rnti DCI_2A ܵۼ */
    UINT32 adwSpsRntiDci2BSunNum;       /* Sps-Rnti DCI_2B ܵۼ */
    UINT32 adwSpsRntiDci2CSunNum;       /* Sps-Rnti DCI_2B ܵۼ */
}T_ZPHY_EDL_PDCCH_INFO;

/*PHICHͳϢ*/
typedef struct
{
    UINT32 adwHiNg;                     /* Ng */
    UINT32 adwHiDuration;               /* PHICH Duration */
    UINT32 adwPhichAckNum[4][10];       /* PHICH12 ֡ۼͳ */
    UINT32 adwPhichNackNum[4][10];      /* PHICH12 ֡ۼͳ */
    UINT32 adwPhichAckSumNum[4];        /* PHICH12 ܵۼͳ */
    UINT32 adwPhichNackSumNum[4];       /* PHICH12 ܵۼͳ */
    UINT32 adwPhich1Grp[10];            /* PHICH1      */
    UINT32 adwPhich1Seq[10];            /* PHICH1Ƶк    */
    UINT32 adwPhich2Grp[10];            /* PHICH2      */
    UINT32 adwPhich2Seq[10];            /* PHICH2Ƶк    */
    UINT32adwHiAckNum;                 /* Hi AckĿͳ    */
    UINT32adwHiNackNum;                /* Hi NackĿͳ    */
}T_ZPHY_EDL_PHICH_INFO;

/* PCFICHͳϢ */
typedef struct
{
    UINT32 dwCaCrossInd;               /*زָʾ*/
    UINT32 adwCfiValTab[10];           /*ѭͳ10֡CFIֵ*/
    UINT32 adwCfiNumPerVal[4];         /*ͳƲͬCFIֵĸ*/
    UINT32 adwCfiNumPerSF[4][10];      /*֡ͳƲͬCFIֵĸ*/
    UINT32 dwSccPdschStart;            /*زµSCC CFI*/
}T_ZPHY_EDL_PCFICH_INFO;


/*״̬Ϣͳ*/
typedef struct
{
    UINT32 dwAbsSFN;               /*ʱϢ*/
	UINT32 dwRntiAplySubfCnt[10];
    UINT32 dwSiRntiApplyCnt;       /* ʹSIRNTIĴ */
    UINT32 adwCRntiApplyCnt;       /* ʹCRNTIĴ */
    UINT32 dwTcRntiApplyCnt;       /* ʹTCRNTIĴ */
    UINT32 dwRaRntiApplyCnt;       /* ʹRARNTIĴ */
    UINT32 dwPRntiApplyCnt;        /* ʹPRNTIĴ */
    UINT32 dwMRntiApplyCnt;        /* ʹMRNTIĴ */
    UINT32 adwPucchRntiApplyCnt;   /* ʹPucchRNTIĴ */
    UINT32 adwPuschRntiApplyCnt;   /* ʹPuschRNTIĴ */
    UINT32 adwSpsRntiApplyCnt;     /* ʹSPSRNTIĴ */
    UINT32 adwDtchCfgCnt;          /* DTCHô */
    UINT32 adwDtchIntCnt;          /* DTCHжϱ */
    UINT32 dwSibCfgCnt;            /* SIBô */
    UINT32 dwSibIntCnt;            /* SIBжϱ */
    UINT32 dwPchCfgCnt;            /* PCHô */
    UINT32 dwPchIntCnt;            /* PCHжϱ */
    UINT32 dwRarCfgCnt;            /* RARô */
    UINT32 dwRarIntCnt;            /* RARжϱ */
    UINT32 dwMbmsCfgCnt;           /* MBSFNô */
    UINT32 dwMbmsIntCnt;           /* MBSFNжϱ */
}T_ZPHY_EDL_WORK_INFO;


typedef struct
{
    UINT32           dwSFN;
    UINT32           dwUeAntNum;
    UINT32           dwBsAntNum;
    UINT32           dwDlBandWidth;
    UINT32           dwTransMode;
    UINT32           dwRxTxBitmap;
    SINT64           sdwNoiseOutput;

    SINT64           sdwRsrpOutput0;
    SINT64           sdwRsrpOutput1;
    SINT64           sdwRsrpOutput2;
    SINT64           sdwRsrpOutput3;
    SINT64           sdwRsrpOutput4;
    SINT64           sdwRsrpOutput5;
    SINT64           sdwRsrpOutput6;
    SINT64           sdwRsrpOutput7;

    SINT64           sdwRspOutput0;
    SINT64           sdwRspOutput1;
    SINT64           sdwRspOutput2;
    SINT64           sdwRspOutput3;
}T_zPHY_EDL_SINR_INFO;

#if 0
/*CMN_M004  Start */

/******************_DEBUG_TMT_REFER_GAOTONG add by zhangzhirong 20120817*****************************/
//#ifdef _DEBUG_TMT_REFER_GAOTONG
typedef struct
{
     UINT32  dwPssPeakVal;    /* PSS Peak Value Data */
     UINT32  dwPeakPosition;  /* Peak Position */
     UINT32  dwPssIndicies;   /* PSS Indicies */
}T_zPHY_PSSInfo;

typedef struct
{
     UINT16 wUarfcn;  /* Ƶ */
     T_zPHY_PSSInfo  atPSSInfo[16];
}T_zPHY_UarfcnPssInfo;

typedef struct
{
    UINT32     dwSFN;    //ʱϢ
    T_zPHY_UarfcnPssInfo   atUarfcnPssInfo[4];
}T_zPHY_ECSR_PssInfo;

typedef struct
{
    UINT32 dwSFN;    //ʱϢ

    UINT32 dwStDlFrmTimeOffset;  /* DL Frame Timing Offse */
    UINT32 dwStUlFrmTimeOffset;  /* UL Frame Timing Offse */
    UINT32 dwStUlTA;             /* UL Timing Advance */

    UINT16 wChDlFrmTime;         /* Change in DL Frame Timing */
    UINT16 wChUlFrmTime;         /* Change in UL Frame Timing */
}T_zPHY_ECSR_SerCellFrmTiming;

typedef struct
{
    UINT16 wCellId;           /* Barred Cell ID */
}T_zPHY_BarredCellId;

typedef struct
{
     UINT32 dwSSSPeakVal;    /* SSS Peak Value Data */
     UINT32 dwSSSPositon;    /* SSS Position */
     UINT32 dwCpMode;        /* CP */
     UINT32 dwHalfFrmHypth;  /* Half Frame Hypothesis */
}T_zPHY_DetectedCell;

typedef struct
{
   T_zPHY_BarredCellId atBarredCellId[16];
   T_zPHY_DetectedCell atDetectedCell[32];
}T_zPHY_ECSR_SSSInfo;

typedef struct
{
    UINT32 dwSFN;             //ʱϢ
    UINT16 wIsIdleMode;       /* Is Idle Mode */
    UINT16 wMeasBW;           /* Measurement BW */
    UINT16 wCellId;           /* Cell ID */
    UINT32 dwRxTimeOffset;    /* Timing Offset Rx */
}T_zPHY_ECSR_SerCellMeasResult;

typedef struct
{
    UINT32 dwEarfcn;     /* Ƶ */
    UINT32 dwDuplexMode; /*  TDD or FDD*/
    UINT16 wCellId;      /*  СID */
    UINT16 wCpmode;      /* CP mode */
}T_zPHY_CellInfo;

typedef struct
{
    UINT32 dwSFN;    //ʱϢ
    T_zPHY_CellInfo  tCellInfo;
}T_zPHY_ECSR_NeborCellMeasResult;

typedef struct
{
    UINT32 dwSFN;    //ʱϢ
    UINT16 wSerCellId;    /* Serving Cell ID */
    UINT16 wTransAntCnf;  /* Transmit Antenna Config */
    UINT16 wSfnOffset;    /* SFN Offset */
    UINT16 wCrcValue;     /* CRC */
}T_zPHY_ECSR_PbchInfo;

typedef struct
{
    UINT32                    bUeSrsEnable;         /* UE SRS Enable ǷUEȷSRS*/
    UINT32                    bCellSrsEnable;       /* Cell SRS Enable */
    UINT32                  dwStartRb;            /* Start RB */
    UINT32                  dwRbNum;              /* RB */
    UINT32                  dwZcRoot;             /* ZC Root */
    UINT32                  dwCyclicShift;        /* Cyclic Shift */
    //SINT32                  sdwSrsTxPower;       /* 书 */
    UINT32                    bToneOffsetEnable;    /* Tone Offset Enable */
}T_zPHY_SrsTx_Report;//ǰ10֡Ϣ
typedef struct
{
    UINT32           dwRaRnti;
    UINT32           dwTCRnti;
    UINT32           dwDrxStatus;
    //SINT32 dwTimeAdvance; /*T_zPHY_ECSR_SerCellFrmTiming dwStUlTA*/
}T_zPHY_EUE_Info;

typedef struct
{
    UINT32           dwSFN;    //ʱϢ
    UINT32           dwPading;
    /*  */
    UINT64           dwDlTB1Flow;
    UINT64           dwDlTB2Flow;

    /*  */
    UINT64           dwUlFlow;
    
    UINT32 dwUlRbNum;         //ýӿ PUSCH Rb Count(RB).  Resource Schedule Information
    UINT32 dwDlRbNum;         //ýӿ PDSCH Rb Count(RB).  Resource Schedule Information

}T_zPHY_ULDL_Flow_Info;

typedef struct
{
    UINT32           dwSFN;
    UINT32           dwUeAntNum;
    UINT32           dwBsAntNum;
    UINT32           dwDlBandWidth;
    UINT32           dwTransMode;
    UINT32           dwRxTxBitmap;
    SINT64           sdwNoiseOutput;

    SINT64           sdwRsrpOutput0;
    SINT64           sdwRsrpOutput1;
    SINT64           sdwRsrpOutput2;
    SINT64           sdwRsrpOutput3;
    SINT64           sdwRsrpOutput4;
    SINT64           sdwRsrpOutput5;
    SINT64           sdwRsrpOutput6;
    SINT64           sdwRsrpOutput7;

    SINT64           sdwRspOutput0;
    SINT64           sdwRspOutput1;
    SINT64           sdwRspOutput2;
    SINT64           sdwRspOutput3;
}T_zPHY_EDL_CALC_For_SINR;

typedef struct
{
    UINT16 wServingCellFreq;	/*СƵ*/
    UINT16 wNextInterFreq;	    /*¸GapƵƵ*/
    UINT16 wServingCellID;	    /*ССID*/
    T_zPHY_ECSR_FreqPointInfor  atFreqPointInforTab[4];
    UINT32	tCsrMainState;		/*CSRϵͳǰ״̬*/
    T_zPHY_ECSR_CsrCellInfo	    tCsrCellInfo[16]; /*ṹ󣬽64С16*/
}T_zPHY_ECSR_CellDataBaseInfo;

typedef struct
{
     WORD             wMsgId;
     WORD             bPadding;
     WORD           wMeasBitMask;
     WORD           wPading1;
}T_zPHY_ECSR_MeasMaskSetInfo;

typedef struct
{
     WORD            wStartPhyCellId;
     WORD            wPhyCellIdNum;
} T_zPHY_PhyCellIdRange;

typedef struct
{
    WORD           wEarfcn;
    WORD           wMeasBandWidth;
    WORD           wCellNum;
    WORD           awPhyCellIdList[32];
    WORD           wPadding;
    WORD           wPresenceAntennaPort1;
    WORD           wNCellConfig;
    WORD           wBlackCellNum;
    T_zPHY_PhyCellIdRange  atPhyCellIdRangeList[32];
    WORD          wNoDrxReportPeriod;
    WORD          wDrxReportPeriod;
} T_zPHY_MeasFreqInfo;


typedef struct
{
    WORD                              wMsgId;
    WORD                              wReportQuantity;
    WORD                              bMaxCellReportPerFreq;
    WORD                              wFreqNum;
    T_zPHY_MeasFreqInfo         atMeasFreqInfoList[4];
}T_zPHY_ECSR_MeasConfigInfo;

typedef struct
{
    UINT32  				dwRfcSynState;              /*RFCָͬͬʾ ʼΪͬ*/
    UINT32  				dwRfcState;                 /*RFCϡָʾ(֡ͬʱڵ)ʼΪIDLE״̬*/
    BOOL   						bRfcServCellReceive;      /*Сָʾʹʱ򿪣ĬϹر*/
    BOOL  						bRfcCsrCellSearch;          /*СָͬʾʼΪر*/
    UINT32                  dwRfcCsrCellMeas;          /*СָʾɨƵָʾɨƵRFC_syn_stateΪͬѡС˫Сʼر*/
    UINT32   						dwRfcFrequencePoint;       /*Ƶ ʼΪ0 */
    UINT32                       dwRfcFilterBand;            /* ʼΪ20MHz*/
    UINT32  						dwRfcAsynOffset;           /*ִͬʼʱ䣬ʼΪ0*/
    UINT32 						dwRfcRxOffsetAnt0;         /*߽ͬ֡磨0ʼΪ0*/
    UINT32 						dwRfcRxOffsetAnt1;         /*RX1߽ͬ֡磨1ʼΪ0*/
    UINT32  						dwRfcRxOffset0;            /*0߽֡磬ʼΪ0*/
    UINT32 						dwRfcRxOffset1;            /*1߽֡,ʼΪ0*/
    UINT16   						cRfcSubFrameNo;           /*߽ͬ֡дʱҪRFC֡תòָתĿ֡ Χ0-9 ʼֵ0xff */
    UINT16  						cRfcSubFrameNo0;          /*0߽֡дʱҪRFC֡תòָתĿ֡ Χ0-9 ʼֵ0xff*/
    UINT16  						cRfcSubFrameNo1;          /*1߽֡дʱҪRFC֡תòָתĿ֡ Χ0-9 ʼֵ0xff*/
    UINT16   						cRfcSubFrameNo2;     /*txĎ߽дʱҪRFC֡תòָתĿ֡ Χ0-9 ʼֵ0xff*/
    UINT32  			       dwRfcUDMode;                /*ͬ֡,ʼΪE_FRAME_UD_TYPE2*/
    UINT32  			       dwRfcCPMode;                /*ͬcpģʽ ʼΪnormal CP*/
    UINT32  			       dwRfcCPMode0;               /*0cpģʽ ʼΪnormal CP*/
    UINT32  			       dwRfcCPMode1;               /*1cpģʽ ʼΪnormal CP*/
    UINT16							cRfcMeasSymStart0;				 /*0ȥCPЧſʼ ʼΪ0*/
    UINT16							cRfcMeasSymStart1;				 /*1ȥCPЧſʼ ʼΪ0*/
    UINT32                      dwRfcSpecSubFrameMode;      /*֡GPģʽ ʼΪE_SPEC_SUB_FRAME_TYPE1*/
    UINT32 						dwRfcFreqOffset;           /*ƵƫֵڵRF ʼΪ0*/
    SINT32   						sdwRfcTxOffset;             /*жʱǰʼΪ0*/
    UINT32 						dwRfcRxOffsetAnt0ForTx;         /*TX߽֡磨0ʼΪ0*/
    UINT32 						dwRfcRxOffsetAnt1ForTx;         /*TX߽֡磨1ʼΪ0*/
    UINT32    			       dwRfcTxAntIndex;					   /*зѡ01ʼΪ0*/
    UINT32    			       dwRfcTxAntIndexForSRS;					   /*зѡ(һSRS)01Ĭϸòδ޸*/
    UINT32 		                dwRfcPowerCloseMode;     	 /*빦ʹرʱ ʼΪE_POWER_CLOSE_NOT_USED*/
    SINT16 						swRfcFirstSymbPower;        /*еһŷ͵Ĺ,ʼΪ0x0fff */
    SINT16 						swRfcLastSymbPower;         /*еŷ͵Ĺ ʼΪ0x0fff*/
    SINT16  						swRfcSpecialPrachPower;     /*֡PRACHֵ,ʼΪ0x0fff */
    UINT32		                dwApcFirstSymbChanType;/*ʿƵһŵͣһһΪSRSTXø֪RFC*/
    SINT32                      swFreqOffset;
} T_ZPHY_ERFC_INFO;

typedef struct
{
	UINT16 	cRxAntennaMode;                         /* ģʽ ĬֵΪģʽ */
	UINT16 	cSyncMode;                              /* ͬģʽ */
	UINT16 	cLNAMode0;
	UINT16 	cLNAMode1;        /* LNAģʽ */

	UINT16 	wAgcdBGain0;
	UINT16 	wAgcdBGain1;         /* AGCֵ dB <8,7,u> */

	UINT16 	wRxLinDagc0;
	UINT16 	wRxLinDagc1;         /* RX· DAGCֵ ֵ <12,8,u> */

	UINT16 	wCsrmLinDagc0;
	UINT16 	wCsrmLinDagc1;     /* CSRM· DAGCֵ ֵ <12,8,u> */

	UINT16 	wCsrsLinDagc0;
	UINT16 	wCsrsLinDagc1;     /* CSRS· DAGCֵ ֵ <12,8,u> */

	struct
	{
	    UINT16                     cAgcGainMaxFlag;                 /* ƽⲹָʾ */
	    UINT16                    wMaxdBVulue;                     //·߽ϴֵ,<8,8,u>
	    SINT16 	              swAgcFactorLog2;                 /* ƽⲹ<16,7,t> log2ֵ*/
	    UINT16                    wAgcFactor;                      /* ƽⲹ<10,0,u> */
	} tRxAgcBalance;               /* Rx·ƽָʾ */

	struct
	{
	    UINT16                     cAgcGainMaxFlag;                 /* ƽⲹָʾ */
	    UINT16                    wMaxdBVulue;                     //·߽ϴֵ,<8,8,u>
	    SINT16 	               swAgcFactorLog2;                 /* ƽⲹ<16,7,t> log2ֵ*/
	    UINT16                    wAgcFactor;                      /* ƽⲹ<10,0,u> */
	} tCsrsAgcBalance;             /* Csrs·ƽָʾ */

	struct
	{
	    UINT16                     cAgcGainMaxFlag;                 /* ƽⲹָʾ */
	    UINT16                    wMaxdBVulue;                     //·߽ϴֵ,<8,8,u>
	    SINT16 	              swAgcFactorLog2;                 /* ƽⲹ<16,7,t> log2ֵ*/
	    UINT16                    wAgcFactor;                      /* ƽⲹ<10,0,u> */
	} tCsrmAgcBalance;             /* Csrm·ƽָʾ */

	/* CSRM10ֵ֡ <14,6,u> */
	struct
	{
	    UINT16 	                  wTotalAgcGain0Log2;              /* 0ֵ <14,6,u> log2ֵ */
	    UINT16                        wTotalAgcGain1Log2;              /* 1ֵ <14,6,u> log2ֵ */
	} awCsrmTotalAgcGainLog2[ZPHY_SUBFRAMES_PER_FRAME];

	/* RX10ֵ֡ <14,6,u> */
	struct
	{
	    UINT16 	                  wTotalAgcGain0Log2;              /* 0ֵ <14,6,u> log2ֵ */
	    UINT16                        wTotalAgcGain1Log2;              /* 1ֵ <14,6,u> log2ֵ */
	} awRxTotalAgcGainLog2[ZPHY_SUBFRAMES_PER_FRAME];

	/* AGCʱ10msƽ */
	SINT16 	aswNotSyncAgcMeanPwr0[70];
	SINT16 	aswNotSyncAgcMeanPwr1[70];
	/* AGCʱ¼ƽֵ */
	SINT16 	swMaxAGCMeanPwr0;
	SINT16 	swMaxAGCMeanPwr1;
	/* AGCɱ־ */
	UINT16 	wNotSyncAGCDone;
	/* Ƶһ֡־ */
	UINT16 	wNotSyncAGCBegin;
	//Ϊʵ˫߷ͬAGCȫֱ,add by zhoupeng 2010.11.6
	UINT16 	wNotSyncAGCDoneAnt0;//0 AGC־
	UINT16 	wNotSyncAGCDoneAnt1;//1 AGC־
	union
	{
	    struct
		{
		    UINT32 RXBandwidth          :3;       /* Bit[0-2] TX· */
		    UINT32 CPMode               :1;       /* Bit[3] CPģʽ */
		    UINT32 Reserved             :28;      /* Bit[4-31] */
		} tBit;

	      UINT32                             dwReg;
	} 	tRXBandwidthCPMode;

	UINT16  	wRxBandwidth;
	UINT16 	cDAGCCalMode;               /* DAGC ģʽ */
	UINT16 	cAGCCalMode;                /* AGC ģʽ */
}T_zPHY_EDFE_SYSTEM_INFO;

typedef struct
{
    UINT32                                        dwSFN;
    SINT16                                       aswPucchGi[ZPHY_DEBUG_TMT_SIZE];          /* PUCCHջزGi· */
	SINT16						aswPucchPower[ZPHY_DEBUG_TMT_SIZE];        /* PUCCHķ͹ͳ */
	SINT16						aswPuschPower[ZPHY_DEBUG_TMT_SIZE];        /* PUSCHķ͹ͳ */
	SINT16						aswSrsPower[ZPHY_DEBUG_TMT_SIZE];          /* SRSķ͹ͳ */
	SINT16						aswPrachPower[ZPHY_DEBUG_TMT_SIZE];        /* PRACHķ͹ͳ */
	UINT16						acPuschPowerHeadroom[ZPHY_DEBUG_TMT_SIZE]; /* PUSCHķ͹ʣPHR */
}T_zPHY_EUL_PowerCtrlInfo;
typedef struct
{
    //UINT16		              cDci0OrDci1A;          /* DCI0DCI1A */
    UINT16		            cHoppingFlag;          /* DCI0еƵflag */
    UINT16		            wBlockAssignment;      /* DCI0еRB */
    UINT16		            cMCS;                  /* DCI0еMCS */
    UINT16		            cNewDataFlag;          /* DCI0еNDI */
    UINT16		            cTpcCommand;           /* DCI0еTPC */
    UINT16		            cDMRSCyclicShift;      /* DCI0DMRSѭλ */
    UINT16		            cUlIndex;              /* DCI0еUL Indexλ֡0 */
    UINT16		            cDAI;                  /* DCI0езָʾ */
    UINT16		            cCqiRequest;           /* DCI0еCQIָʾλ */
    UINT16		            cRbStart[2];              /* DCI0еRIVָʾRBʼλ */
    UINT16		            cLcrbs[2];                /* DCI0еRIVָʾRB */
}T_zPHY_Dci0Info;
typedef struct
{
    T_zPHY_Dci0Info atDci0Info[ZPHY_DEBUG_TMT_SIZE];
}T_zPHY_EUL_Dci0Info;


typedef struct
{
	//UINT16                      wAbsSubFrmNo;            /* TPC CommandӦ֡ţΪ֡űʾ */
    UINT32                      dwSFN;    //ʱϢ
    UINT16                       wPuschDCI3or3aTpcIdx;    /* ŷʽΪTPC-PUSCH-RNTIDCI3/3AлõTPC Command */
    UINT16                       wPucchDCI3or3aTpcIdx;    /* ŷʽΪTPC-PUCCH-RNTIDCI3/3AлõTPC Command */
}T_zPHY_EUL_DCI3Or3AInfo;

typedef struct
{
    UINT32                      dwSFN;    //ʱϢ
	UINT32                      dwNewTransCnt;            /* ´ͳ ܵۼֵ */
    UINT32                      dwAdaptTransCnt;          /* Ӧشͳ ܵۼֵ */
    UINT32                      dwNonAdaptTransCnt;       /* Ӧشͳ ܵۼֵ */
    UINT32                      dwNoTransCnt;             /* ͳ ܵۼֵ */

    UINT32                      dwHarqTransCnt;           /* شͳ ܵۼֵ */
    UINT32                      dwHarq0TransCnt;          /* HARQ ID=0Ĵͳ ܵۼֵ */
    UINT32                      dwHarq1TransCnt;          /* HARQ ID=1Ĵͳ ܵۼֵ */
    UINT32                      dwHarq2TransCnt;          /* HARQ ID=2Ĵͳ ܵۼֵ */
    UINT32                      dwHarq3TransCnt;          /* HARQ ID=3Ĵͳ ܵۼֵ */

    UINT32                      dwHarqRv0Cnt;             /* RV=0ͳ ܵۼֵ */
    UINT32                      dwHarqRv1Cnt;             /* RV=1ͳ ܵۼֵ */
    UINT32                      dwHarqRv2Cnt;             /* RV=2ͳ ܵۼֵ */
    UINT32                      dwHarqRv3Cnt;             /* RV=3ͳ ܵۼֵ */

    UINT32                      dwCurHarqId;              /* ǰHARQ ID */

    UINT32                      dwHarqMaxReTxLimit;       /* شƴ· */

    /* гشϢͳƳشBlerϢ */
    UINT32                      dwUlHarqInitAck;          /* гACKͳϢ ܵۼֵ· */
    UINT32                      dwUlHarqInitNack;         /* гNACKͳϢ ܵۼֵ· */
    UINT32                      dwUlHarqReTxAck;          /* شACKͳϢ ܵۼֵ· */
    UINT32                      dwUlHarqReTxNack;         /* شNACKͳϢ ܵۼֵ· */

    /*еһΡڶΡΡĴԼشɹ*/
    UINT32                      dwUlHarq1stSuccNum;       /* һشɹ ܵۼֵ· */
    UINT32                      dwUlHarq2ndSuccNum;       /* ڶشɹ ܵۼֵ· */
    UINT32                      dwUlHarq3rdSuccNum;       /* شɹ ܵۼֵ· */
    UINT32                      dwUlHarq4thSuccNum;       /* Ĵشɹ ܵۼֵ· */
    UINT32                      dwUlHarqOtherSuccNum;     /* شɹ ܵۼֵ· */

    /*ģHarq ID ACKNACK*/
    UINT32                      adwUlHarqIdAck[8];        /* 8HARQ ACKͳϢIDܵۼֵ· */
    UINT32                      adwUlHarqIdNack[8];       /* 8HARQ NACKͳϢIDܵۼֵ· */
}T_zPHY_EUL_HarqTransStatisticsInfo;
typedef struct
{
    UINT32                      dwSFN;    //ʱϢ

	UINT32                      dwUlaCqiAndHarqCnt;             /* PUCCH CQIACKһͳƣ̶ѡFormat 2bѡ2bitb(1),b(0)д ܵۼֵ */
	UINT32                      dwUlaCqiAndHarqBits00Cnt;       /* ѡb(1)=0 b(0)=0ĸ ܵۼֵ */
    UINT32                      dwUlaCqiAndHarqBits01Cnt;       /* ѡb(1)=0 b(0)=1ĸ ܵۼֵ */
    UINT32                      dwUlaCqiAndHarqBits10Cnt;       /* ѡb(1)=1 b(0)=0ĸ ܵۼֵ */
    UINT32                      dwUlaCqiAndHarqBits11Cnt;       /* ѡb(1)=1 b(0)=1ĸ ܵۼֵ */

	UINT32                      dwUlaPeriodicCQICnt;            /* CQIͳ ܵۼֵ */
	UINT32                      dwUlaAperiodicCQICnt;           /* PUSCHϷCQIͳ ܵۼֵ */
	UINT32                      dwUlaRiCnt;                     /* RIͳ ܵۼֵ */
	UINT32                      dwUlaPucchPeriodicCQICnt;       /* PUCCHCQIͳ ܵۼֵ */
	UINT32                      dwUlaPuschPeriodicCQICnt;       /* PUSCHCQIͳ ܵۼֵ */
//	UINT32                      dwUlaPuschAperiodicCQICnt;      * PUSCHϷCQIͳ,dwUlaAperiodicCQICntһ ܵۼֵ */

    /* 7CQIͳϢ·ಿֽкϲԿǰ֡ͳ */
	UINT32                      adwUlaCqiVal[10];               /* CQIֵ ֱ֡ͳ */
	UINT32                      adwUlaRiVal[10];                /* RIֵ ֱ֡ͳ */
	UINT32                      adwUlaCqiFN[10];                /* CQI֡ */
	UINT32                      adwUlaCqiSFN[10];               /* CQI֡ */

	UINT16						awCqiReportPeriodFlag[10];      /* CQI Flag */
	UINT16						awSubFrameNum[10];              /* SIDе֡ */
	UINT16						awFrameNum[10];                 /* SIDе֡ */
    UINT32                      dwUlMcs;                  //ýӿUL MCS(MCS)MCS Statistic Information,ͨЭõQPSK\16QAM\64QAM
    UINT32                      dwCQI;
    UINT32                      dwPMI;                          /* PMI */
    UINT32                      dwRI;                           /* RI */
    UINT32                      dwWbCode0Cqi;                   /* Wideband Code0 CQI */
    UINT32                      dwWbCode1Cqi;                   /* Wideband Code1 CQI */
    SINT32                      sdwRank1Sinr;                   /* Rank1 SINR0 */
    SINT32                      sdwRank2Sinr0;                  /* Rank2 SINR0 */
    SINT32                      sdwRank2Sinr1;                  /* Rank2 SINR1 */
    UINT32                      dwTxDivFlag;                    /* Rank SINR 3dbm־ */

}T_zPHY_EUL_CqiHarqSimulStatisticsInfo;
typedef struct
{
    UINT16                      wParchPremFrmNo;                               /* preamble ֡ţ· */
    UINT16                       cParchPremSubFrmNo;                            /* preamble ֡ţ·(Լ32λ) */
    UINT16                       cParchPremIndex;                               /* preamble ID */
	UINT16						cPrachConfigIndex;                             /* ЭջָʾǰPHYõprach resourceԴѡԼȡpreambleǰøʽ(0,63) */
	UINT16						cHighSpeedFlag;                                /* ־ǰС(1:С,0:Ǹ) */
	UINT16						wNcs;                                          /* NCSֵ */
	UINT16						cPrachFrqOffset;                               /* prach resourceOFDMƵƫֵ */
	UINT16						wRootSwquenceIndex;                            /* ZC߼ֲ */
	UINT16						cNumberOfRAPreamble;                           /* ǰ */
	UINT16						cSizeOfRAPreamblesGroupA;                      /* ǰAĸ */
	UINT16						wMessageSizeGroupA;                            /* ǰAϢ */
	UINT16						cMessagePowerOffetGroupB;                      /* ڽǰѡ */
	UINT16						cPowerRampingStep;                             /* зpreambleʵطpreambleе书 */
	UINT16						wPreambleTransMax;                             /* preambleش */
	UINT16						cRAResponseWindowSize;                         /* RARϢʱ䴰 */
	UINT16						cMacContentionResolutionTimer;                 /* мmsg4ʱ䴰ڴС */
	UINT16						cMaxHQRQMsg3Tx;                                /* зmsg3ʱHARQش */

	UINT16						awMsg1TxSysFrameNum[10];      /* Preamble֡ŵͳ */
	UINT16						awMsg1TxSubFrameNum[10];      /* Preamble֡ŵͳ */

	UINT32						adwMsg1TxCnt[10];             /* Preambleʹͳ ֡ۼͳ */
	UINT16						awMsg1TxFreqPos[10];          /* PreambleƵλnPRBͳ ֡ۼͳ */
	UINT16						acMsg1TxPreambleID[10];       /* Preamble IDͳ ֡ۼͳ */
	//SINT8						ascMsg1TxPower[10];           /* Preamble͹ʵͳ ֡ۼͳ */
	//UINT32					adwMsg1TxNumCnt[10];          /* Preambleͳ ֡ۼͳ */
	UINT32						adwMsg2RxMatchNumCnt[10];     /* RAR PIDƥͳ ֡ۼͳ */
	UINT32						adwMsg2RxNotMatchNumCnt[10];  /* RAR PIDƥͳ ֡ۼͳ */
	UINT32						adwMsg3TxNumCnt[10];          /* Msg3Ŀͳ ֡ۼͳ */
	UINT32						adwMsg3TxAckNumCnt[10];       /* Msg3ȷͳ ֡ۼͳ */
	UINT32						adwMsg3TxNackNumCnt[10];      /* Msg3ʹͳ ֡ۼͳ */
	UINT32						adwMsg4RxNumCnt[10];          /* Msg4յͳ ֡ۼͳ */
	UINT32						adwMsg4RxAckNumCnt[10];       /* Msg4ȷͳ ֡ۼͳ */
}T_zPHY_EUL_PrachStatisticsInfo;




/* SRS ͳ */
typedef struct
{
    UINT32                      dwSFN;                          /* ʱϢ */
	UINT32                      dwUlaSrsCnt;                    /* SRS͵ͳ ܵۼֵ */
	UINT32						adwdwUlaSrsCommSFCnt[10];       /* ͨ֡SRSͳ ֡ۼֵ */

	/* 4Ŀǰûиֵ begin */
	UINT32                      dwUlaSrsForTddSpecSF1LastSymbCnt;                 /* TDD֡1һŷSRSͳƣŶ ܵۼֵ */
	UINT32                      dwUlaSrsForTddSpecSF1LastSecondSymbCnt;           /* TDD֡1еڶŷSRSͳƣŶ ܵۼֵ */
	UINT32                      dwUlaSrsForTddSpecSF6LastSymbCnt;                 /* TDD֡6һŷSRSͳƣŶ ܵۼֵ */
	UINT32                      dwUlaSrsForTddSpecSF6LastSecondSymbCnt;           /* TDD֡6һŷSRSͳƣŶ ܵۼֵ */
	/* 4Ŀǰûиֵ over */
    T_zPHY_SrsTx_Report atSrsTx_Report[10];//ǰ10֡Ϣ
}T_zPHY_EUL_SrsStatisticsInfo;

/* SR HARQͳϢ */
typedef struct
{
    UINT32                      dwSFN;    //ʱϢ
	UINT32                      dwUlaSrAndHarqCnt;              /* PUCCH SRACKһͳƣ̶ѡFormat 1bѡ2bitb(1),b(0)д ܵۼֵ */
    UINT32                      dwUlaSrAndHarqBits00Cnt;        /* ѡb(1)=0 b(0)=0ĸ ܵۼֵ */
    UINT32                      dwUlaSrAndHarqBits01Cnt;        /* ѡb(1)=0 b(0)=1ĸ ܵۼֵ */
    UINT32                      dwUlaSrAndHarqBits10Cnt;        /* ѡb(1)=1 b(0)=0ĸ ܵۼֵ */
    UINT32                      dwUlaSrAndHarqBits11Cnt;        /* ѡb(1)=1 b(0)=1ĸ ܵۼֵ */
}T_zPHY_UL_SrHarqSimulStatisticsInfo;

/* PUCCH Multiplexing ѡN1pucchԴͳϢ */
typedef struct
{
    UINT32                      dwSFN;    //ʱϢ
	UINT32                      dwUlaN1pucch0Bits00Cnt;         /* PUCCH Multiplexing ѡN1pucch0Դ[NACK NACK]ͳ ܵۼֵ */
	UINT32                      dwUlaN1pucch0Bits01Cnt;         /* PUCCH Multiplexing ѡN1pucch0Դ[NACK ACK]ͳ ܵۼֵ */
	UINT32                      dwUlaN1pucch0Bits10Cnt;         /* PUCCH Multiplexing ѡN1pucch0Դ[ACK NACK]ͳ ܵۼֵ */
	UINT32                      dwUlaN1pucch0Bits11Cnt;         /* PUCCH Multiplexing ѡN1pucch0Դ[ACK ACK]ͳ ܵۼֵ */

	UINT32                      dwUlaN1pucch1Bits00Cnt;         /* PUCCH Multiplexing ѡN1pucch1Դ[NACK NACK]ͳ ܵۼֵ */
	UINT32                      dwUlaN1pucch1Bits01Cnt;         /* PUCCH Multiplexing ѡN1pucch1Դ[NACK ACK]ͳ ܵۼֵ */
	UINT32                      dwUlaN1pucch1Bits10Cnt;         /* PUCCH Multiplexing ѡN1pucch1Դ[ACK NACK]ͳ ܵۼֵ */
	UINT32                      dwUlaN1pucch1Bits11Cnt;         /* PUCCH Multiplexing ѡN1pucch1Դ[ACK ACK]ͳ ܵۼֵ */

	UINT32                      dwUlaN1pucch2Bits00Cnt;         /* PUCCH Multiplexing ѡN1pucch2Դ[NACK NACK]ͳ ܵۼֵ */
	UINT32                      dwUlaN1pucch2Bits01Cnt;         /* PUCCH Multiplexing ѡN1pucch2Դ[NACK ACK]ͳ ܵۼֵ */
	UINT32                      dwUlaN1pucch2Bits10Cnt;         /* PUCCH Multiplexing ѡN1pucch2Դ[ACK NACK]ͳ ܵۼֵ */
	UINT32                      dwUlaN1pucch2Bits11Cnt;         /* PUCCH Multiplexing ѡN1pucch2Դ[ACK ACK]ͳ ܵۼֵ */

	UINT32                      dwUlaN1pucch3Bits00Cnt;         /* PUCCH Multiplexing ѡN1pucch3Դ[NACK NACK]ͳ ܵۼֵ */
	UINT32                      dwUlaN1pucch3Bits01Cnt;         /* PUCCH Multiplexing ѡN1pucch3Դ[NACK ACK]ͳ ܵۼֵ */
	UINT32                      dwUlaN1pucch3Bits10Cnt;         /* PUCCH Multiplexing ѡN1pucch3Դ[ACK NACK]ͳ ܵۼֵ */
	UINT32                      dwUlaN1pucch3Bits11Cnt;         /* PUCCH Multiplexing ѡN1pucch3Դ[ACK ACK]ͳ ܵۼֵ */
}T_zPHY_UL_MutiplexingANStatisticsInfo;

/* ͳнBunldingϢ */
typedef struct
{
    UINT32                      dwSFN;    //ʱϢ
	//PUCCH
	UINT32                      dwUlaPucchBunldingAckCnt;       /* PUCCH BundlingACKͳ ܵۼֵ */
	UINT32                      dwUlaPucchBunldingNackCnt;      /* PUCCH BundlingNACKͳ ܵۼֵ */
	UINT32                      dwUlaPucchBunldingAckAckCnt;    /* PUCCH Bundling[ACK ACK]ͳ ܵۼֵ */
	UINT32                      dwUlaPucchBunldingAckNackCnt;   /* PUCCH Bundling[ACK NACK]ͳ ܵۼֵ */
	UINT32                      dwUlaPucchBunldingNackAckCnt;   /* PUCCH Bundling[NACK ACK]ͳ ܵۼֵ */
	UINT32                      dwUlaPucchBunldingNackNackCnt;  /* PUCCH Bundling[NACK NACK]ͳ ܵۼֵ */

	//PUSCH
	UINT32                      dwUlaPuschBunldingAckCnt;       /* PUSCH BundlingACKͳ ܵۼֵ */
	UINT32                      dwUlaPuschBunldingNackCnt;      /* PUSCH BundlingNACKͳ ܵۼֵ */
	UINT32                      dwUlaPuschBunldingAckAckCnt;    /* PUSCH Bundling[ACK ACK]ͳ ܵۼֵ */
	UINT32                      dwUlaPuschBunldingAckNackCnt;   /* PUSCH Bundling[ACK NACK]ͳ ܵۼֵ */
	UINT32                      dwUlaPuschBunldingNackAckCnt;   /* PUSCH Bundling[NACK ACK]ͳ ܵۼֵ */
	UINT32                      dwUlaPuschBunldingNackNackCnt;  /* PUSCH Bundling[NACK NACK]ͳ ܵۼֵ */


	UINT32                      dwPdcchUlGrantCnt;              /* Ȩͳ ܵۼֵ· */
	UINT32                      dwPuschDynPacketNum;            /* ̬ͳ ܵۼֵ· */
}T_zPHY_EUL_BunldingANStatisticsInfo;

/* PUCCH FMT ʽͳϢ */
typedef struct
{
    UINT32                      dwSFN;    //ʱϢ
	UINT32                      dwUlaPucchFmt1Cnt;    /* PUCCH Format1 ͳ ܵۼֵ*/
    UINT32                      dwUlaPucchFmt1aCnt;   /* PUCCH Format1A ͳ ܵۼֵ*/
    UINT32                      dwUlaPucchFmt1bCnt;   /* PUCCH Format1B ͳ ܵۼֵ*/
    UINT32                      dwUlaPucchFmt2Cnt;    /* PUCCH Format2 ͳ ܵۼֵ*/
    UINT32                      dwUlaPucchFmt2aCnt;   /* PUCCH Format2A ͳ ܵۼֵ*/
    UINT32                      dwUlaPucchFmt2bCnt;   /* PUCCH Format2B ͳ ܵۼֵ*/
    UINT32                      dwUlaPucchFmt3Cnt;   /* PUCCH Format2B ͳ ܵۼֵ*/
}T_zPHY_EUL_PucchFmtStatisticsInfo;

/* Ϣͳ */  
typedef struct
{
    UINT32 dwPhyDLTB1Flow;    
    UINT32 dwPhyDLTB2Flow;
    UINT32 dwPhyULTB1Flow;    
    UINT32 dwPhyULTB2Flow;
}T_ZPHY_EULDL_FLOW_INFO;

typedef struct
{
    UINT32 dwPowerA;      /* DedicatedϢPDSCHʲĲ */
    UINT32 dwPowerB;      /* CommonϢPDSCHʲĲ */
}T_ZPHY_EDL_PA_INFO;

/* DCIͳϢ */
typedef struct
{
    UINT32 dwSFN;                      /* ʱϢ */
    UINT32 dwResource;                 /* Դֶ */
    UINT32 adwRbBmp[8];                /* 1-bitRB-demapping bitmap */
    UINT32 dwRaType;                   /* RA  */
    UINT32 dwRbNum;                    /* RB */
    UINT32 dwRbStart;                  /* RBʵλ */
    UINT32 dwRbLength;                 /* RB */
    UINT32 dwHarqId;                   /* HARQ ID */
    UINT32 dwTb1Mcs;                   /* TB1 MCSֵ */
    UINT32 dwTb2Mcs;                   /* TB2 MCSֵ */
    UINT32 dwTb1Ndi;                   /* TB1 NDI */
    UINT32 dwTb2Ndi;                   /* TB2 NDI */
    UINT32 dwTb1Rv;                    /* TB1 汾 */
    UINT32 dwTb2Rv;                    /* TB2 汾 */
    UINT32 dwDaiIdx;                   /* DAI  */
}T_ZPHY_EDL_DCI_DECODE;

typedef struct
{
    T_ZPHY_EDL_DCI_DECODE atDlDciInfo[10]; /* 10֡DCIͳ */
}T_ZPHY_EDL_DCI_INFO;


/* HARQϢͳ */
typedef struct
{
    UINT32 adwRevTb1RvNum[4];        /* TB1 Եۼͳ */
    UINT32 adwRevTb2RvNum[4];        /* TB2 Եۼͳ */

    /*ģHarq ID ACKNACK*/
    UINT32 adwDlTb1HarqIdAck[15];    /* TB1 15HARQ IDACKϢIDܵۼ */
    UINT32 adwDlTb1HarqIdNack[15];   /* TB1 15HARQ IDNACKϢIDܵۼ */
    UINT32 adwDlTb2HarqIdAck[15];    /* TB2 15HARQ IDACKϢIDܵۼ */
    UINT32 adwDlTb2HarqIdNack[15];   /* TB2 15HARQ IDNACKϢIDܵۼ */

    UINT32 adwDlHarqSuccNum[4];      /* TB1TB2شɹͳƣ ܵۼֵ */
}T_ZPHY_EDL_HARQ_INFO;

/* PDSCHͳϢ */
typedef struct
{
    /*Statistic Si-Rnti PDSCH Decode Info*/
    UINT32 adwSiRntiCrcOkNum[10];       /* Si-Rnti  CRC_OK ֡ۼ */
    UINT32 adwSiRntiCrcErrNum[10];      /* Si-Rnti  CRC_ERR ֡ۼ */
    UINT32 dwSiRntiCrcOkSumNum;         /* Si-Rnti  CRC_OK ܵۼ */
    UINT32 dwSiRntiCrcErrSumNum;        /* Si-Rnti  CRC_ERR ܵۼ */

    /*Statistic P-Rnti PDSCH Decode Info*/
    UINT32 adwPRntiCrcOkNum[10];        /* P-Rnti  CRC_OK ֡ۼ */
    UINT32 adwPRntiCrcErrNum[10];       /* P-Rnti  CRC_ERR ֡ۼ */
    UINT32 dwPRntiCrcOkSumNum;          /* P-Rnti  CRC_OK ܵۼ */
    UINT32 dwPRntiCrcErrSumNum;         /* P-Rnti  CRC_ERR ܵۼ */

    /*Statistic Ra-Rnti PDSCH Decode Info*/
    UINT32 adwRaRntiCrcOkNum[10];       /* Ra-Rnti  CRC_OK ֡ۼ */
    UINT32 adwRaRntiCrcErrNum[10];      /* Ra-Rnti  CRC_ERR ֡ۼ */
    UINT32 dwRaRntiCrcOkSumNum;         /* Ra-Rnti  CRC_OK ܵۼ */
    UINT32 dwRaRntiCrcErrSumNum;        /* Ra-Rnti  CRC_ERR ܵۼ */

    /*Statistic Tc-Rnti PDSCH Decode Info*/
    UINT32 adwTcRntiCrcOkNum[10];       /* Tc-Rnti  CRC_OK ֡ۼ */
    UINT32 adwTcRntiCrcErrNum[10];      /* Tc-Rnti  CRC_OK ֡ۼ */
    UINT32 dwTcRntiCrcOkSumNum;         /* Tc-Rnti  CRC_OK ܵۼ */
    UINT32 dwTcRntiCrcErrSumNum;        /* Tc-Rnti  CRC_OK ܵۼ */

    /*Statistic C-Rnti PDSCH Decode Info*/
    UINT32 adwCRntiTbCrcOkNum[2][10];   /* TB12 C-Rnti  CRC_OK ֡ۼ */
    UINT32 adwCRntiTbCrcErrNum[2][10];  /* TB12 C-Rnti  CRC_ERR ֡ۼ */
    UINT32 adwCRntiTbCrcOkSumNum[2];    /* TB12 C-Rnti  CRC_OK ܵۼ */
    UINT32 adwCRntiTbCrcErrSumNum[2];   /* TB12 C-Rnti  CRC_ERR ܵۼ */

    /*Statistic Sps-Rnti PDSCH Decode Info*/
    UINT32 adwSpsRntiCrcOkNum[10];      /* Sps-Rnti  CRC_OK ֡ۼ */
    UINT32 adwSpsRntiCrcErrNum[10];     /* Sps-Rnti  CRC_OK ֡ۼ */
    UINT32 adwSpsRntiCrcOkSumNum;       /* Sps-Rnti  CRC_OK ܵۼ */
    UINT32 adwSpsRntiCrcErrSumNum;      /* Sps-Rnti  CRC_OK ܵۼ */
}T_ZPHY_EDL_PDSCH_INFO;

/*PDCCHäͳϢ*/
typedef struct
{
    /*Statistic Si-Rnti Dci Info*/
    UINT32 adwSiRntiDci1ANum[10];       /* Si-Rnti DCI_1A ֡ۼ */
    UINT32 adwSiRntiDci1CNum[10];       /* Si-Rnti DCI_1C ֡ۼ */
    UINT32 dwSiRntiDci1ASumNum;         /* Si-Rnti DCI_1A ܵۼ */
    UINT32 dwSiRntiDci1CSumNum;         /* Si-Rnti DCI_1C ܵۼ */
    UINT32 dwSiRntiDciSumNum;           /* Si-Rnti DciܵͳƸ */

    /*Statistic P-Rnti Dci Info*/
    UINT32 adwPRntiDci1ANum[10];        /* P-Rnti DCI_1A ֡ۼ */
    UINT32 adwPRntiDci1CNum[10];        /* P-Rnti DCI_1C ֡ۼ */
    UINT32 dwPRntiDci1ASumNum;          /* P-Rnti DCI_1A ܵۼ */
    UINT32 dwPRntiDci1CSumNum;          /* P-Rnti DCI_1C ܵۼ */
    UINT32 dwPRntiDciSumNum;            /* P-Rnti DciܵͳƸ */

    /*Statistic Ra-Rnti Dci Info*/
    UINT32 adwRaRntiDci1ANum[10];       /* Ra-Rnti DCI_1A ֡ۼ */
    UINT32 adwRaRntiDci1CNum[10];       /* Ra-Rnti DCI_1C ֡ۼ */
    UINT32 dwRaRntiDci1ASumNum;         /* Ra-Rnti DCI_1A ܵۼ */
    UINT32 dwRaRntiDci1CSumNum;         /* Ra-Rnti DCI_1C ܵۼ */
    UINT32 dwRaRntiDciSumNum;           /* Ra-Rnti DciܵͳƸ */

    /*Statistic Tc-Rnti Dci Info*/
    UINT32 adwTcRntiDci1Num[10];        /* Tc-Rnti DCI_1 ֡ۼ */
    UINT32 adwTcRntiDci1ANum[10];       /* Tc-Rnti DCI_1A ֡ۼ */
    UINT32 dwTcRntiDci1SumNum;          /* Tc-Rnti DCI_1 ܵۼ */
    UINT32 dwTcRntiDci1ASumNum;         /* Tc-Rnti DCI_1A ܵۼ */
    UINT32 dwTcRntiDciSumNum;           /* Tc-Rnti DciܵͳƸ */

    /*Statistic Tpc-Rnti Dci Info*/
    UINT32 adwTpcRntiDci3Num[10];       /* Tpc-Rnti DCI_3 ֡ۼ */
    UINT32 adwTpcRntiDci3ANum[10];      /* Tpc-Rnti DCI_3A ֡ۼ */
    UINT32 adwTpcRntiDci3SumNum;        /* Tpc-Rnti DCI_3 ܵۼ */
    UINT32 adwTpcRntiDci3ASumNum;       /* Tpc-Rnti DCI_3A ܵۼ */
    UINT32 adwPucchTpcDci33ASumNum;
    UINT32 adwPuschTpcDci33ASumNum;

    /*Statistic C-Rnti Dci Info*/
    UINT32 adwCRntiDci01Num[10];        /* DCI0_1 ֡ۼ */
    UINT32 adwCRntiDci02Num[10];        /* DCI0_2 ֡ۼ */
    UINT32 adwCRntiDci03Num[10];        /* DCI0_3 ֡ۼ */
    UINT32 adwCRntiDci04Num[10];        /* DCI0_4 ֡ۼ */
    UINT32 adwCRntiDci41Num[10];        /* DCI41 ֡ۼ */
    UINT32 adwCRntiDci42Num[10];        /* DCI42 ֡ۼ */
    UINT32 adwCRntiDci43Num[10];        /* DCI43 ֡ۼ */
    UINT32 adwCRntiDci44Num[10];        /* DCI44 ֡ۼ */
    UINT32 adwCRntiDci1Num[10];         /* C-Rnti DCI_1 ֡ۼ */
    UINT32 adwCRntiDci1ANum[10];        /* C-Rnti DCI_1A ֡ۼ */
    UINT32 adwCRntiDci1BNum[10];        /* C-Rnti DCI_1B ֡ۼ */
    UINT32 adwCRntiDci1DNum[10];        /* C-Rnti DCI_1D ֡ۼ */
    UINT32 adwCRntiDci2Num[10];         /* C-Rnti DCI_2 ֡ۼ */
    UINT32 adwCRntiDci2ANum[10];        /* C-Rnti DCI_2A ֡ۼ */
    UINT32 adwCRntiDci2BNum[10];        /* C-Rnti DCI_2B ֡ۼ */
    UINT32 adwCRntiDci2CNum[10];        /* C-Rnti DCI_2C ֡ۼ */
    UINT32 adwCRntiDci01SumNum;         /* C-Rnti DCI_01 ܵۼ */
    UINT32 adwCRntiDci02SumNum;         /* C-Rnti DCI_02 ܵۼ */
    UINT32 adwCRntiDci03SumNum;         /* C-Rnti DCI_03 ܵۼ */
    UINT32 adwCRntiDci04SumNum;         /* C-Rnti DCI_04 ܵۼ */
    UINT32 adwCRntiDci41SumNum;         /* C-Rnti DCI_4 ܵۼ */
    UINT32 adwCRntiDci42SumNum;         /* C-Rnti DCI_4 ܵۼ */
    UINT32 adwCRntiDci43SumNum;         /* C-Rnti DCI_4 ܵۼ */
    UINT32 adwCRntiDci44SumNum;         /* C-Rnti DCI_4 ܵۼ */
    UINT32 adwCRntiDci1SumNum;          /* C-Rnti DCI_1 ܵۼ */
    UINT32 adwCRntiDci1ASumNum;         /* C-Rnti DCI_1A ܵۼ */
    UINT32 adwCRntiDci1BSumNum;         /* C-Rnti DCI_1B ܵۼ */
    UINT32 adwCRntiDci1DSumNum;         /* C-Rnti DCI_1D ܵۼ */
    UINT32 adwCRntiDci2SumNum;          /* C-Rnti DCI_2 ܵۼ */
    UINT32 adwCRntiDci2ASumNum;         /* C-Rnti DCI_2A ܵۼ */
    UINT32 adwCRntiDci2BSumNum;         /* C-Rnti DCI_2B ܵۼ */
    UINT32 adwCRntiDci2CSumNum;         /* C-Rnti DCI_2C ܵۼ */
    UINT32 adwCRntiDciSumNum;           /* C-Rnti DciܵͳƸ */

    /*Statistic Sps-Rnti Dci Info*/
    UINT32 adwSpsRntiDci1Num[10];       /* Sps-Rnti DCI_1 ֡ۼ */
    UINT32 adwSpsRntiDci1ANum[10];      /* Sps-Rnti DCI_1A ֡ۼ */
    UINT32 adwSpsRntiDci2Num[10];       /* Sps-Rnti DCI_2 ֡ۼ */
    UINT32 adwSpsRntiDci2ANum[10];      /* Sps-Rnti DCI_2A ֡ۼ */
    UINT32 adwSpsRntiDci2BNum[10];      /* Sps-Rnti DCI_2B ֡ۼ */
    UINT32 adwSpsRntiDci2CNum[10];      /* Sps-Rnti DCI_2B ֡ۼ */
    UINT32 adwSpsRntiDci1SunNum;        /* Sps-Rnti DCI_1 ܵۼ */
    UINT32 adwSpsRntiDci1ASunNum;       /* Sps-Rnti DCI_1A ܵۼ */
    UINT32 adwSpsRntiDci2SunNum;        /* Sps-Rnti DCI_2 ܵۼ */
    UINT32 adwSpsRntiDci2ASunNum;       /* Sps-Rnti DCI_2A ܵۼ */
    UINT32 adwSpsRntiDci2BSunNum;       /* Sps-Rnti DCI_2B ܵۼ */
    UINT32 adwSpsRntiDci2CSunNum;       /* Sps-Rnti DCI_2B ܵۼ */
}T_ZPHY_EDL_PDCCH_INFO;

/*PHICHͳϢ*/
typedef struct
{
    UINT32 adwHiNg;                     /* Ng */
    UINT32 adwHiDuration;               /* PHICH Duration */
    UINT32 adwPhichAckNum[4][10];       /* PHICH12 ֡ۼͳ */
    UINT32 adwPhichNackNum[4][10];      /* PHICH12 ֡ۼͳ */
    UINT32 adwPhichAckSumNum[4];        /* PHICH12 ܵۼͳ */
    UINT32 adwPhichNackSumNum[4];       /* PHICH12 ܵۼͳ */
	UINT32 adwPhich1Grp[10];            /* PHICH1      */
	UINT32 adwPhich1Seq[10];            /* PHICH1Ƶк    */
	UINT32 adwPhich2Grp[10];            /* PHICH2      */
	UINT32 adwPhich2Seq[10];            /* PHICH2Ƶк    */
    UINT32adwHiAckNum;                 /* Hi AckĿͳ    */
    UINT32adwHiNackNum;                /* Hi NackĿͳ    */
}T_ZPHY_EDL_PHICH_INFO;

/* PCFICHͳϢ */
typedef struct
{
    UINT32 dwCaCrossInd;               /*زָʾ*/
    UINT32 adwCfiValTab[10];           /*ѭͳ10֡CFIֵ*/
    UINT32 adwCfiNumPerVal[4];         /*ͳƲͬCFIֵĸ*/
    UINT32 adwCfiNumPerSF[4][10];      /*֡ͳƲͬCFIֵĸ*/
    UINT32 dwSccPdschStart;            /*زµSCC CFI*/
}T_ZPHY_EDL_PCFICH_INFO;


/*״̬Ϣͳ*/
typedef struct
{
    UINT32 dwAbsSFN;               /*ʱϢ*/
	UINT32 dwRntiAplySubfCnt[10];
    UINT32 dwSiRntiApplyCnt;       /* ʹSIRNTIĴ */
    UINT32 adwCRntiApplyCnt;       /* ʹCRNTIĴ */
    UINT32 dwTcRntiApplyCnt;       /* ʹTCRNTIĴ */
    UINT32 dwRaRntiApplyCnt;       /* ʹRARNTIĴ */
    UINT32 dwPRntiApplyCnt;        /* ʹPRNTIĴ */
    UINT32 dwMRntiApplyCnt;        /* ʹMRNTIĴ */
    UINT32 adwPucchRntiApplyCnt;   /* ʹPucchRNTIĴ */
    UINT32 adwPuschRntiApplyCnt;   /* ʹPuschRNTIĴ */
    UINT32 adwSpsRntiApplyCnt;     /* ʹSPSRNTIĴ */
    UINT32 adwDtchCfgCnt;          /* DTCHô */
    UINT32 adwDtchIntCnt;          /* DTCHжϱ */
    UINT32 dwSibCfgCnt;            /* SIBô */
    UINT32 dwSibIntCnt;            /* SIBжϱ */
    UINT32 dwPchCfgCnt;            /* PCHô */
    UINT32 dwPchIntCnt;            /* PCHжϱ */
    UINT32 dwRarCfgCnt;            /* RARô */
    UINT32 dwRarIntCnt;            /* RARжϱ */
    UINT32 dwMbmsCfgCnt;           /* MBSFNô */
    UINT32 dwMbmsIntCnt;           /* MBSFNжϱ */
}T_ZPHY_EDL_WORK_INFO;

/* SNRϢ */
typedef struct
{
    SINT32 sdwSinrVal;     
    SINT32 sdwRx0Tx0Snr;   
    SINT32 sdwRx0Tx0Snr;    
    SINT32 sdwRx0Tx0Snr;
    SINT32 sdwRx0Tx0Snr;
}T_ZPHY_EDL_SNR_INFO;


/* UEϢ */
typedef struct
{
    UINT32 dwWorkEarfcn;            /* PCHô */
    UINT32 dwWorkCellId;            /* PCHжϱ */
    UINT32 dwSysBw;                 /* RARô */
    UINT32 dwSubFrmType;            /* RARжϱ */
    UINT32 dwSpecSubFrmType;        /* MBSFNô */
    UINT32 dwDlTransMode;           /* дģʽ */
    UINT32 dwUlTransMode;           /* дģʽ */
    UINT32 dwCrntiVal;
}T_ZPHY_EDL_SNR_INFO;






typedef struct
{
    UINT32 dwServerCellId;  /* СID */

    SINT32 sdwCsrmRssi;     /* RSSI */
    SINT32 sdwCsrmRsrq;     /* RSRQ */
    SINT32 sdwCsrmRsrp;     /* RSRP */

    SINT32 sdwCsrmRssiAnt0; /* 0 RSSI */
    SINT32 sdwCsrmRssiAnt1; /* 1 RSSI */

    SINT32 sdwCsrmRsrpAnt0; /* 0 RSRP */
    SINT32 sdwCsrmRsrpAnt1; /* 1 RSRP */

    SINT32 sdwCsrmRsrqAnt0; /* 0 RSRQ */
    SINT32 sdwCsrmRsrqAnt1; /* 0 RSRQ */
}T_zPHY_ECSR_MeasureInfo;

typedef struct
{
    UINT32 dwMibRefreshFlag;  //MIBϢ±־и1
    UINT32 dwMibInfo;         //MIBϢ
}T_zPHY_ECSR_MibInfo;

typedef struct
{
    UINT16 wCellBand;                       /* д*/
    UINT16 wPhichConfig;                    /* PHICH*/
}T_zPHY_ECSR_DebugMibInfo;


#endif

#ifdef _DEBUG_PHY_TMT_GLOBAL_CONTROL
    extern T_zPHY_DebugStatisticsFigInfo *g_patLtePhyDbgFigInfo;
    #ifdef _DEBUG_TMT_FOR_DINGLI  //20120208 MIBϢ
        extern T_zPHY_MibInfoForDingLi *g_ptMibInfo;
    #endif
#endif
typedef struct
{
    UINT32 dwWorkMode;              /* ʽ */
    UINT32 dwWorkEarfcn;            /* Ƶ */
    UINT32 dwWorkCellId;            /* СID */
    UINT32 dwSysBw;                 /* ϵͳ */
    UINT32 dwSubFrmType;            /* ֡ */
    UINT32 dwSpecSubFrmType;        /* ֡ */
    UINT32 dwDlTransMode;           /* дģʽ */
    UINT32 dwUlTransMode;           /* дģʽ */
    UINT32 dwCrntiVal;              /* CRNTI */
    UINT32 dwRaRnti;                /* RaRNTI */
    UINT32 dwTCRnti;                /* TCRNTI */
    UINT32 dwDrxStatus;             /* DrxStatus */
}T_ZPHY_UE_BASE_INFO;
typedef struct
{
    UINT32           dwSFN;
    UINT32           dwUeAntNum;
    UINT32           dwBsAntNum;
    UINT32           dwDlBandWidth;
    UINT32           dwTransMode;
    UINT32           dwRxTxBitmap;
    SINT64           sdwNoiseOutput;

    SINT64           sdwRsrpOutput0;
    SINT64           sdwRsrpOutput1;
    SINT64           sdwRsrpOutput2;
    SINT64           sdwRsrpOutput3;
    SINT64           sdwRsrpOutput4;
    SINT64           sdwRsrpOutput5;
    SINT64           sdwRsrpOutput6;
    SINT64           sdwRsrpOutput7;

    SINT64           sdwRspOutput0;
    SINT64           sdwRspOutput1;
    SINT64           sdwRspOutput2;
    SINT64           sdwRspOutput3;
}T_zPHY_EDL_CALC_For_SINR;

typedef struct
{
    UINT16     cRxAntennaMode;                         /* ģʽ ĬֵΪģʽ */
    UINT16     cSyncMode;                              /* ͬģʽ */
    UINT16     cLNAMode0;
    UINT16     cLNAMode1;        /* LNAģʽ */

    UINT16     wAgcdBGain0;
    UINT16     wAgcdBGain1;         /* AGCֵ dB <8,7,u> */

    UINT16     wRxLinDagc0;
    UINT16     wRxLinDagc1;         /* RX· DAGCֵ ֵ <12,8,u> */

    UINT16     wCsrmLinDagc0;
    UINT16     wCsrmLinDagc1;     /* CSRM· DAGCֵ ֵ <12,8,u> */

    UINT16     wCsrsLinDagc0;
    UINT16     wCsrsLinDagc1;     /* CSRS· DAGCֵ ֵ <12,8,u> */

    struct
    {
        UINT16                     cAgcGainMaxFlag;                 /* ƽⲹָʾ */
        UINT16                    wMaxdBVulue;                     //·߽ϴֵ,<8,8,u>
        SINT16                   swAgcFactorLog2;                 /* ƽⲹ<16,7,t> log2ֵ*/
        UINT16                    wAgcFactor;                      /* ƽⲹ<10,0,u> */
    } tRxAgcBalance;               /* Rx·ƽָʾ */

    struct
    {
        UINT16                     cAgcGainMaxFlag;                 /* ƽⲹָʾ */
        UINT16                    wMaxdBVulue;                     //·߽ϴֵ,<8,8,u>
        SINT16                    swAgcFactorLog2;                 /* ƽⲹ<16,7,t> log2ֵ*/
        UINT16                    wAgcFactor;                      /* ƽⲹ<10,0,u> */
    } tCsrsAgcBalance;             /* Csrs·ƽָʾ */

    struct
    {
        UINT16                     cAgcGainMaxFlag;                 /* ƽⲹָʾ */
        UINT16                    wMaxdBVulue;                     //·߽ϴֵ,<8,8,u>
        SINT16                   swAgcFactorLog2;                 /* ƽⲹ<16,7,t> log2ֵ*/
        UINT16                    wAgcFactor;                      /* ƽⲹ<10,0,u> */
    } tCsrmAgcBalance;             /* Csrm·ƽָʾ */

    /* CSRM10ֵ֡ <14,6,u> */
    struct
    {
        UINT16                       wTotalAgcGain0Log2;              /* 0ֵ <14,6,u> log2ֵ */
        UINT16                        wTotalAgcGain1Log2;              /* 1ֵ <14,6,u> log2ֵ */
    } awCsrmTotalAgcGainLog2[ZPHY_SUBFRAMES_PER_FRAME];

    /* RX10ֵ֡ <14,6,u> */
    struct
    {
        UINT16                       wTotalAgcGain0Log2;              /* 0ֵ <14,6,u> log2ֵ */
        UINT16                        wTotalAgcGain1Log2;              /* 1ֵ <14,6,u> log2ֵ */
    } awRxTotalAgcGainLog2[ZPHY_SUBFRAMES_PER_FRAME];

    /* AGCʱ10msƽ */
    SINT16     aswNotSyncAgcMeanPwr0[70];
    SINT16     aswNotSyncAgcMeanPwr1[70];
    /* AGCʱ¼ƽֵ */
    SINT16     swMaxAGCMeanPwr0;
    SINT16     swMaxAGCMeanPwr1;
    /* AGCɱ־ */
    UINT16     wNotSyncAGCDone;
    /* Ƶһ֡־ */
    UINT16     wNotSyncAGCBegin;
    //Ϊʵ˫߷ͬAGCȫֱ,add by zhoupeng 2010.11.6
    UINT16     wNotSyncAGCDoneAnt0;//0 AGC־
    UINT16     wNotSyncAGCDoneAnt1;//1 AGC־
    union
    {
        struct
        {
            UINT32 RXBandwidth          :3;       /* Bit[0-2] TX· */
            UINT32 CPMode               :1;       /* Bit[3] CPģʽ */
            UINT32 Reserved             :28;      /* Bit[4-31] */
        } tBit;

          UINT32                             dwReg;
    }     tRXBandwidthCPMode;

    UINT16      wRxBandwidth;
    UINT16     cDAGCCalMode;               /* DAGC ģʽ */
    UINT16     cAGCCalMode;                /* AGC ģʽ */
}T_zPHY_EDFE_SYSTEM_INFO;

#ifdef _DEBUG_TMT_REFER_GAOTONG

#if 0
    extern T_zPHY_ECSR_PssInfo    g_ECSR_PssInfo;
    extern T_zPHY_ECSR_SerCellFrmTiming g_ECSR_SerCellFrmTiming;
    extern T_zPHY_ECSR_SSSInfo g_ECSR_SSSInfo;
    extern T_zPHY_ECSR_SerCellMeasResult g_ECSR_SerCellMeasResult;
    extern T_zPHY_ECSR_NeborCellMeasResult g_ECSR_NeborCellMeasResult[64];
    extern T_zPHY_ECSR_PbchInfo g_ECSR_PbchInfo;
    extern T_zPHY_ECSR_MibInfo g_ECSR_MibInfo;
    extern T_zPHY_ECSR_MeasureInfo g_ECSR_MeasureInfo;
#endif
    extern T_ZPHY_EDL_PCFICH_INFO g_EDL_PCFICH_INFO;
    extern T_ZPHY_EDL_PHICH_INFO g_EDL_PHICH_INFO;
    extern T_ZPHY_EDL_PDCCH_INFO g_EDL_PDCCH_INFO;
    extern T_ZPHY_EDL_PDSCH_INFO g_EDL_PDSCH_INFO;
    extern T_ZPHY_EDL_HARQ_INFO g_EDL_HARQ_INFO;
    extern T_ZPHY_EDL_DCI_INFO g_EDL_DCI_INFO;
    extern T_ZPHY_EDL_PA_INFO g_EDL_PA_INFO;
    //extern T_ZPHY_EDL_FLOW_INFO g_EDL_FLOW_INFO;
    extern T_ZPHY_EDL_WORK_INFO g_EDL_WORK_INFO;
    extern T_ZPHY_UE_BASE_INFO         g_UE_BASE_INFO[2];
    extern T_zPHY_ULDL_Flow_Info g_EDLUL_FLOW_INFO [2];
	
    extern T_zPHY_EUL_PucchFmtStatisticsInfo  g_EUL_PucchFmtStatisticsInfo;
    extern T_zPHY_EUL_BunldingANStatisticsInfo g_EUL_BunldingANStatisticsInfo;
    extern T_zPHY_UL_MutiplexingANStatisticsInfo g_UL_MutiplexingANStatisticsInfo;
    extern T_zPHY_UL_SrHarqSimulStatisticsInfo g_UL_SrHarqSimulStatisticsInfo;
    extern T_zPHY_EUL_CqiHarqSimulStatisticsInfo g_EUL_CqiHarqSimulStatisticsInfo;
    extern T_zPHY_EUL_SrsStatisticsInfo g_EUL_SrsStatisticsInfo[2];
    extern T_zPHY_EUL_PrachStatisticsInfo g_EUL_PrachStatisticsInfo;
    extern T_zPHY_EUL_HarqTransStatisticsInfo g_EUL_HarqTransStatisticsInfo[2];
    extern T_zPHY_EUL_Dci0Info g_EUL_Dci0Info[2];
    extern T_zPHY_EUL_DCI3Or3AInfo g_EUL_DCI3Or3AInfo[2];
    extern T_zPHY_EUL_PowerCtrlInfo g_EUL_PowerCtrlInfo[2];
    extern T_zPHY_ULDL_Flow_Info g_ULDL_Flow_Info;
    extern T_zPHY_EDFE_SYSTEM_INFO g_EDFE_SYSTEM_INFO;
    extern T_zPHY_EDL_CALC_For_SINR  g_EDL_CALC_For_SINR;
    #if 0
    
    extern T_ZPHY_ERFC_INFO g_ERFC_INFO;
    extern T_zPHY_ECSR_DebugMibInfo g_ECSR_DebugMibInfo;
    extern T_zPHY_ECSR_MeasConfigInfo g_ECSR_MeasConfigInfo;
    extern T_zPHY_ECSR_MeasMaskSetInfo g_ECSR_MeasMaskSetInfo;;
    extern T_zPHY_ECSR_CellDataBaseInfo  g_ECSR_CellDataBaseInfo;
   

    extern T_zPHY_EUE_Info g_EUE_Info;
#endif
#endif
/*CMN_M004  End */

/**************************************************************************
 *                        ȫֺԭ                                     *
 **************************************************************************/


/*****************************************************************************
 *          zPHY_VersionInfo
 *            LTEڲ汾Ϣά
 *        
 *        
 *    ֵ˵  
 *    ˵    
 *****************************************************************************/
VOID zPHY_VersionInfo(VOID);

#endif  
