#ifndef ZSPTRACE_H_
#define ZSPTRACE_H_

#define ZCAT_ZPS_BUFFER_SIZE                (0x00010000UL>>CPU_SHIFT)

#ifndef DDR_BASE_ADDR_TOOL_ICP
extern unsigned long ZCAT_PS_2_PHY_BUFFER_BASE;
extern unsigned long ZCAT_PHY_2_PS_BUFFER_BASE;
#endif

////PHY-ZCAT
#define ZCAT_PHY_2_PS_BUFFER_SIZE           (0x00060000UL>>CPU_SHIFT)
#define ZCAT_PHY_LOG_UNIT_ORDER             (14 - CPU_SHIFT)              /* 16KB */
#define ZCAT_PHY_LOG_UNIT_SIZE              (1UL<<ZCAT_PHY_LOG_UNIT_ORDER)
#define ZCAT_PHY_LOG_UNIT_NUM               (ZCAT_PHY_2_PS_BUFFER_SIZE >> ZCAT_PHY_LOG_UNIT_ORDER)

#define ZCAT_PHY_STD_LOG_OFFSET             (28UL>>CPU_SHIFT) /* sizeof(T_COMM_TYPE + T_ZCAT_HEADER) */
#define ZCAT_PHY_PRT_LOG_OFFSET             (40UL>>CPU_SHIFT) /* sizeof(T_COMM_TYPE + T_ZCAT_HEADER + T_ZCAT_DBG_HEADER) */

#define LOG_TD  (1)
#define LOG_LTE (2)
#define LOG_W   (3)
#define LOG_SIG (4)

typedef struct
{
    unsigned long type;
    unsigned long len;
} T_ZCAT_Phy_Log_Unit_Header;

#define ZCAT_PHY_LOG_UNIT_HEAD             (IRAM_BASE_ADDR_ZCAT_PHY_LOG)
#define ZCAT_PHY_LOG_UNIT_TAIL             (ZCAT_PHY_LOG_UNIT_HEAD + (4>>CPU_SHIFT))
#define ZCAT_PHY_LOG_Free_UNIT_BUF         (ZCAT_PHY_LOG_UNIT_TAIL + (4>>CPU_SHIFT))
#define ZCAT_PHY_LOG_Free_UNIT_LEN         (96>>CPU_SHIFT) /* (24 * 4)B = 384K*/ 
#define ZCAT_PHY_LOG_OFF                   (ZCAT_PHY_LOG_UNIT_HEAD + (16>>CPU_SHIFT) + ZCAT_PHY_LOG_Free_UNIT_LEN) /* Ԥ8ֽ */
#define ZCAT_PHY_LOG_ZSP_BUF_READY         (ZCAT_PHY_LOG_OFF + (4>>CPU_SHIFT)) 
#define ZCAT_PHY_LOG_VEHICLE_SIGN          (ZCAT_PHY_LOG_ZSP_BUF_READY + (4>>CPU_SHIFT)) 

////zCat Log Rule
#define ZCAT_RULE_LTE_ENABLED              (ZCAT_PHY_LOG_VEHICLE_SIGN + (4>>CPU_SHIFT)) 
#define ZCAT_RULE_SIG_ENABLED              (ZCAT_RULE_LTE_ENABLED + (4>>CPU_SHIFT)) 
#define ZCAT_RULE_TD_ENABLED               (ZCAT_RULE_SIG_ENABLED + (4>>CPU_SHIFT)) 
#define ZCAT_RULE_WCDMA_ENABLED            (ZCAT_RULE_TD_ENABLED + (4>>CPU_SHIFT)) 
#define ZCAT_RULE_AP2APP_ENABLED           (ZCAT_RULE_WCDMA_ENABLED + (4>>CPU_SHIFT)) 
#define ZCAT_RULE_AP2KERNEL_ENABLED        (ZCAT_RULE_AP2APP_ENABLED + (4>>CPU_SHIFT)) 

////PHY<->PS ringbuffer(TD)
#define ZCAT_PHY_LOG_CONTROL_SIZE           (0x200UL>>CPU_SHIFT)
#define ZCAT_PHY_LOG_CONTROL_LEN            (ZCAT_PHY_LOG_CONTROL_SIZE - (4 >> CPU_SHIFT))

#define ZCAT_TD_LOG_CONTROL_BASE_ADDR      (ZCAT_PS_2_PHY_BUFFER_BASE)
#define ZCAT_TD_LOG_CONTROL_WPOINTER       (ZCAT_TD_LOG_CONTROL_BASE_ADDR) 
#define ZCAT_TD_LOG_CONTROL_RPOINTER       (ZCAT_TD_LOG_CONTROL_WPOINTER + (2 >> CPU_SHIFT))
#define ZCAT_TD_LOG_CONTROL_CONTENT        (ZCAT_TD_LOG_CONTROL_RPOINTER + (2 >> CPU_SHIFT))

////PHY<->PS ringbuffer(LTE)
#define ZCAT_LTE_LOG_CONTROL_BASE_ADDR      (ZCAT_TD_LOG_CONTROL_BASE_ADDR + ZCAT_PHY_LOG_CONTROL_SIZE)
#define ZCAT_LTE_LOG_CONTROL_WPOINTER       (ZCAT_LTE_LOG_CONTROL_BASE_ADDR) 
#define ZCAT_LTE_LOG_CONTROL_RPOINTER       (ZCAT_LTE_LOG_CONTROL_WPOINTER + (2 >> CPU_SHIFT))
#define ZCAT_LTE_LOG_CONTROL_CONTENT        (ZCAT_LTE_LOG_CONTROL_RPOINTER + (2 >> CPU_SHIFT))

////PHY<->PS ringbuffer(W)
#define ZCAT_W_LOG_CONTROL_BASE_ADDR      (ZCAT_LTE_LOG_CONTROL_BASE_ADDR + ZCAT_PHY_LOG_CONTROL_SIZE)
#define ZCAT_W_LOG_CONTROL_WPOINTER       (ZCAT_W_LOG_CONTROL_BASE_ADDR) 
#define ZCAT_W_LOG_CONTROL_RPOINTER       (ZCAT_W_LOG_CONTROL_WPOINTER + (2 >> CPU_SHIFT))
#define ZCAT_W_LOG_CONTROL_CONTENT        (ZCAT_W_LOG_CONTROL_RPOINTER + (2 >> CPU_SHIFT))

////PHY<->PS ringbuffer(SIG)
#define ZCAT_SIG_LOG_CONTROL_BASE_ADDR      (ZCAT_W_LOG_CONTROL_BASE_ADDR + ZCAT_PHY_LOG_CONTROL_SIZE)
#define ZCAT_SIG_LOG_CONTROL_WPOINTER       (ZCAT_SIG_LOG_CONTROL_BASE_ADDR) 
#define ZCAT_SIG_LOG_CONTROL_RPOINTER       (ZCAT_SIG_LOG_CONTROL_WPOINTER + (2 >> CPU_SHIFT))
#define ZCAT_SIG_LOG_CONTROL_CONTENT        (ZCAT_SIG_LOG_CONTROL_RPOINTER + (2 >> CPU_SHIFT))

////ZCAT-TD
#define ZCAT_TD_PS_TO_PHY_BUFFER_BASE_ADDR  (ZCAT_SIG_LOG_CONTROL_BASE_ADDR + ZCAT_PHY_LOG_CONTROL_SIZE)
#define ZCAT_TD_PS_TO_PHY_BUFFER_SIZE       (0x00000200UL>>CPU_SHIFT)

////ZCAT-LTE
#define ZCAT_LTE_PS_TO_PHY_BUFFER_BASE_ADDR (ZCAT_TD_PS_TO_PHY_BUFFER_BASE_ADDR + ZCAT_TD_PS_TO_PHY_BUFFER_SIZE)
#define ZCAT_LTE_PS_TO_PHY_BUFFER_SIZE      (0x00000200UL>>CPU_SHIFT)

////ZCAT-WCDMA
#define ZCAT_W_PS_TO_PHY_BUFFER_BASE_ADDR   (ZCAT_LTE_PS_TO_PHY_BUFFER_BASE_ADDR + ZCAT_LTE_PS_TO_PHY_BUFFER_SIZE)
#define ZCAT_W_PS_TO_PHY_BUFFER_SIZE        (0x00000200UL>>CPU_SHIFT)

////ZCAT-SIG
#define ZCAT_SIG_PS_TO_PHY_BUFFER_BASE_ADDR (ZCAT_W_PS_TO_PHY_BUFFER_BASE_ADDR + ZCAT_W_PS_TO_PHY_BUFFER_SIZE)
#define ZCAT_SIG_PS_TO_PHY_BUFFER_SIZE      (0x00000200UL>>CPU_SHIFT)

#define ZCAT_PS_2_PHY_BUFFER_SIZE           (ZCAT_PHY_LOG_CONTROL_SIZE + ZCAT_PHY_LOG_CONTROL_SIZE + ZCAT_PHY_LOG_CONTROL_SIZE + ZCAT_PHY_LOG_CONTROL_SIZE + \
                                             ZCAT_TD_PS_TO_PHY_BUFFER_SIZE + ZCAT_LTE_PS_TO_PHY_BUFFER_SIZE + ZCAT_W_PS_TO_PHY_BUFFER_SIZE + ZCAT_SIG_PS_TO_PHY_BUFFER_SIZE)
#endif

