
#include <linux/module.h>
#include <linux/kernel.h>
#include <linux/init.h>
#include <linux/cdev.h>
#include <linux/semaphore.h>

// #include <linux/fs.h>
#include <linux/ioport.h>
// #include <linux/serial_reg.h>
#include <linux/poll.h>
#include <linux/delay.h>
#include <linux/wait.h>
#include <linux/err.h>
#include <linux/interrupt.h>
#include <linux/sched.h>
#include <linux/types.h>
#include <linux/device.h>
#include <linux/miscdevice.h>
// #include <linux/spinlock.h>
#include <linux/list.h>
#include <linux/slab.h>
#include <linux/sched.h>
// #include <linux/kthread.h>
#include <asm/io.h>

#include <linux/vmalloc.h>
#include <linux/soc/zte/rpm/rpmsg.h>
// #include <linux/syscalls.h>

// #include "debuginfo.h"
#include "pub_debug_info.h"
#include "ringbuf.h"

#if defined(_USE_ZXIC_DEBUG_INFO) && !defined(CONFIG_SYSTEM_RECOVERY)
/*******************************************************************************
 *                                   宏定义                                     *
 *******************************************************************************/
#define DEBUG_INFO_SHARE_MEM_LEN    (0x2000)
#define DEBUG_INFO_READABLE_LEN     (0x1400)
#define DEBUG_INFO_MAX_DATA_LEN     (128)
#define DEBUG_INFO_MAX_TOTAL_LEN    (140) // 8 + 128 + 4
#define DEBUG_INFO_MEM_HEAD_LEN     (8)
#define DEBUG_INFO_FILE_HEAD_LEN    (12)

#define DEBUG_INFO_CHANNEL          (channel_9)
#define DEBUG_INFO_MSG_CAP_SIZE     (2 * 1024)

// #define DEBUG_INFO_MEM_TYPE_KERNEL  (0)
// #define DEBUG_INFO_MEM_TYPE_USER    (1)

#define DEBUG_INFO_OK               (0)
#define DEBUG_INFO_ERROR            (-1)

/*******************************************************************************
 *                                结构体定义                                     *
 *******************************************************************************/
typedef unsigned int UINT32;
typedef unsigned short UINT16;
typedef unsigned char UINT8;

typedef struct
{
    UINT16 module_id; // 模块id
    UINT16 sub_len;   // 用户数据长度
    UINT32 time;
    char sub_data[]; // 用户数据
} T_SHARED_MEM_DATA;

/*******************************************************************************
 *                                  全局变量                                     *
 *******************************************************************************/
static int g_init_flag = 0;

/*******************************************************************************
 *                              内部函数定义                                     *
 *******************************************************************************/
static int sc_debug_info_read_to_user(char *buf, unsigned short count);
static int sc_debug_info_record_from_user(const char *info, unsigned short count);
static int sc_debug_info_send_to_cap(T_SHARED_MEM_DATA *debug_msg, unsigned int len);

static ssize_t debug_info_read(struct file *fp, char __user *buf, size_t count, loff_t *pos);
static ssize_t debug_info_write(struct file *fp, const char __user *buf, size_t count, loff_t *pos);
static int debug_info_open(struct inode *ip, struct file *fp);
static long debug_info_ioctl(struct file *fp, unsigned int cmd, unsigned long arg);
static int debug_info_release(struct inode *ip, struct file *fp);

static const struct file_operations debug_info_fops = {
    .owner = THIS_MODULE,
    .read = debug_info_read,
    .write = debug_info_write,
    .open = debug_info_open,
    .unlocked_ioctl = debug_info_ioctl,
    .release = debug_info_release,
};

static struct miscdevice debug_info_device = {
    .minor = MISC_DYNAMIC_MINOR,
    .name = "debug_info",
    .fops = &debug_info_fops,
};

static ssize_t debug_info_read(struct file *fp, char __user *buf, size_t count, loff_t *pos)
{
    return -1;
}

static ssize_t debug_info_write(struct file *fp, const char __user *buf, size_t count, loff_t *pos)
{
    int wr_len = sc_debug_info_record_from_user(buf, count);

    return wr_len;
}

static int debug_info_open(struct inode *ip, struct file *fp)
{
    return 0;
}

static long debug_info_ioctl(struct file *fp, unsigned int cmd, unsigned long arg)
{
    return 0;
}

static int debug_info_release(struct inode *ip, struct file *fp)
{
    return 0;
}

static int sc_debug_info_read_to_user(char *buf, unsigned short count)
{
    return -1;
}

static int sc_debug_info_record_from_user(const char *info, unsigned short count)
{
    unsigned int cnt = 0;
    char str_buf[DEBUG_INFO_MAX_TOTAL_LEN] __attribute__((aligned(4)));
    T_SHARED_MEM_DATA *shareMemData;    

    if (g_init_flag == 0)
    {
        printk("debug_info not init.\n");
        return DEBUG_INFO_ERROR;
    }
    if (info == NULL)
    {
        printk("sc_debug_info_record_from_user:: info is NULL.\n");
        return DEBUG_INFO_ERROR;
    }
    copy_from_user(str_buf, info, count);
    shareMemData = (T_SHARED_MEM_DATA *)str_buf;

    cnt = sc_debug_info_send_to_cap(shareMemData, count);

    return cnt;
}

static int __init debug_info_init(void)
{
    int ret;  
   
    ret = misc_register(&debug_info_device);
    if (ret)
    {
        printk("debug_info_device init.\n");
        return DEBUG_INFO_ERROR;
    }

    ret = zDrvRpMsg_CreateChannel_Cap(
        CAP_ID, 
        DEBUG_INFO_CHANNEL,
        DEBUG_INFO_MSG_CAP_SIZE);
    if (ret != DEBUG_INFO_OK) 
    {
        printk("zDrvRpMsg_CreateChannel_Cap failed, ret = %d\n", ret);
        return DEBUG_INFO_ERROR;
    }   
 
    g_init_flag = 1;

    return DEBUG_INFO_OK;
}

static void __exit debug_info_exit(void)
{
    misc_deregister(&debug_info_device);
}

module_init(debug_info_init);
module_exit(debug_info_exit);

MODULE_AUTHOR("jcw");
MODULE_DESCRIPTION("debug_info driver");
MODULE_LICENSE("GPL");

static int sc_debug_info_send_to_cap(T_SHARED_MEM_DATA *debug_msg, unsigned int len)
{
    int ret;
    T_ZDrvRpMsg_Msg rpmsg = {0};

    rpmsg.actorID = CAP_ID;
    rpmsg.chID = DEBUG_INFO_CHANNEL;
    rpmsg.flag = RPMSG_WRITE_INT;
    rpmsg.buf = debug_msg;
    rpmsg.len = len;

    ret = zDrvRpMsg_Write_Cap(&rpmsg);
    if (ret != rpmsg.len)
    {
        printk("sc_debug_info_send_to_cap:: debug_msg send fail, ret = %d\n", ret);
        return DEBUG_INFO_ERROR;
    }

    return ret;
}

int sc_debug_info_vrecord(unsigned int id, const char *format, va_list args)
{
    int len;
    int sendlen;
    // va_list args;
    char str_buf[DEBUG_INFO_MAX_TOTAL_LEN] __attribute__((aligned(4)));
    T_SHARED_MEM_DATA *shareMemData = (T_SHARED_MEM_DATA *)str_buf;

    if (g_init_flag == 0)
    {
        printk("debug_info not init.\n");
        return DEBUG_INFO_ERROR;
    }

    /* args是一个char*类型指针，指向format之后的第一个参数*/
    // va_start(args, format);
    len = vsnprintf(shareMemData->sub_data, DEBUG_INFO_MAX_DATA_LEN, format, args);
    // va_end(args);
    if (len < 0)
    {
        printk("vsnprintf format error.\n");
        return DEBUG_INFO_ERROR;
    }

    shareMemData->module_id = (UINT16)(id & 0xFFFF);
    shareMemData->sub_len = len;
    shareMemData->time = jiffies;    

    sendlen = sc_debug_info_send_to_cap(shareMemData, (len+DEBUG_INFO_MEM_HEAD_LEN));
    
    return sendlen;
}
EXPORT_SYMBOL(sc_debug_info_vrecord);

int sc_debug_info_record(unsigned int id, const char *format, ...)
{
    va_list args;
	int r;

	va_start(args, format);
	r = sc_debug_info_vrecord(id, format, args);
	va_end(args);


    return r;
}
EXPORT_SYMBOL(sc_debug_info_record);

#endif   /*  _USE_ZXIC_DEBUG_INFO */

