/**
 * 
 * @file      ringbuf.c
 * @brief     
 *            This file is part of tools.
 *            ring buffer
 *            
 * @details   
 * @author    Tools Team.
 * @email     
 * @copyright Copyright (C) 2013 Sanechips Technology Co., Ltd.
 * @warning   
 * @date      2019/02/02
 * @version   1.1
 * @pre       
 * @post      
 *            
 * @par       
 * Change History :
 * ---------------------------------------------------------------------------
 * date        version  author         description
 * ---------------------------------------------------------------------------
 * 2013/01/21  1.0      lu.xieji       Create file
 * 2019/02/02  1.1      jiang.fenglin  ޸עͷʽΪdoxygen
 * ---------------------------------------------------------------------------
 * 
 * 
 */

#include "ringbuf.h"
#include <linux/uaccess.h>

#define SYMBOL_VALUE ZCAT_IPC_ESTABLISHED

/**
 * @brief жϻǷЧ
 * @param[in] ringBuf λ
 * @return ǷTRUE,񷵻FALSE
 * @note
 * @see 
 */
BOOL IsRingBufferValid(T_RINGBUFFER *ringBuf)
{
    return (ringBuf != NULL && ringBuf->symbol == SYMBOL_VALUE);
}

/**
 * @brief ҪĻ,ָλֵ
 *        bufΪNULLַָһڴΪ
 * @param[in] buf ַ
 * @param[in] bufSize С
 * @param[in] bufSize λ
 * @return ɹָ򻺳ṹָ룬򷵻NULL
 * @note
 * @see 
 */
T_RINGBUFFER *CreateRingBufferWithSymbol(UINT8 *buf, UINT32 bufSize, UINT32 symbol)
{
    T_RINGBUFFER *ringBuf = NULL;

    if (bufSize <= sizeof(T_RINGBUFFER))
    {
        return NULL;
    }

    if (buf == NULL)
    {
        //ringBuf = (T_RINGBUFFER *)kmalloc(ALIGNED_SIZE(bufSize, 3), GFP_KERNEL);

        //if (ringBuf == NULL)
        {
            return NULL;
        }
    }
    else
    {
        ringBuf = (T_RINGBUFFER *)buf;
    }

    ringBuf->capacity   = bufSize - sizeof(T_RINGBUFFER);
    ringBuf->readPoint  = 0;
    ringBuf->writePoint = 0;
    ringBuf->symbol     = symbol;

    return ringBuf;
}


/**
 * @brief ҪĻ
 *        bufΪNULLַָһڴΪ
 * @param[in] buf ַ
 * @param[in] bufSize С
 * @return ɹָ򻺳ṹָ룬򷵻NULL
 * @note
 * @see 
 */
T_RINGBUFFER *CreateRingBuffer(UINT8 *buf, UINT32 bufSize)
{
    T_RINGBUFFER *ringBuf = NULL;

    if (bufSize <= sizeof(T_RINGBUFFER))
    {
        return NULL;
    }

    if (buf == NULL)
    {
        //ringBuf = (T_RINGBUFFER *)kmalloc(ALIGNED_SIZE(bufSize, 3), GFP_KERNEL);

        //if (ringBuf == NULL)
        {
            return NULL;
        }
    }
    else
    {
        ringBuf = (T_RINGBUFFER *)buf;
    }

    ringBuf->capacity   = bufSize - sizeof(T_RINGBUFFER);
    ringBuf->readPoint  = 0;
    ringBuf->writePoint = 0;
    ringBuf->symbol     = SYMBOL_VALUE;

    return ringBuf;
}


/**
* @brief д뻷λ
* @param[in] ringBuf λָ
* @param[in] buf ݻָ
* @param[in] len ݳ
* @param[in] flags ݻڴͣ0:ں̬,1:û̬
* @return дʵʳ
* @note
* @see 
*/
UINT32 WriteRingBuffer(T_RINGBUFFER *ringBuf, UINT8 *buf, UINT32 len, UINT32 flags)
{
    UINT32 writeLen = 0;
    UINT32 writePoint = ringBuf->writePoint;
    UINT32 readPoint = ringBuf->readPoint;

    /* ж */
    if (!IsRingBufferValid(ringBuf) || buf == NULL || len == 0)
    {
        return 0;
    }
    if( writePoint >= ringBuf->capacity || readPoint >= ringBuf->capacity )
	{
        return 0;
	}
	
    if (writePoint >= readPoint)
    {
        if (ringBuf->capacity - writePoint > len)
        {
            if (ZCAT_MEM_TYPE_USER == flags) { copy_from_user(ringBuf->buf + writePoint, buf, len); }
            else { memcpy(ringBuf->buf + writePoint, buf, len); }
            ringBuf->writePoint += len;
            writeLen = len;
        }
        else if ((ringBuf->capacity - writePoint + readPoint - 1) >= len)
        {
            UINT32 copyLen = ringBuf->capacity - writePoint;
            if (ZCAT_MEM_TYPE_USER == flags) { copy_from_user(ringBuf->buf + writePoint, buf, copyLen); }
            else { memcpy(ringBuf->buf + writePoint, buf, copyLen); }

            copyLen = len - copyLen;

            if (copyLen > 0)
            {
                if (ZCAT_MEM_TYPE_USER == flags) { copy_from_user(ringBuf->buf, buf + (len - copyLen), copyLen); }
                else { memcpy(ringBuf->buf, buf + (len - copyLen), copyLen); }
            }

            ringBuf->writePoint = copyLen;
            writeLen = len;
        }
    }
    else
    {
        if (readPoint - writePoint - 1 >= len)
        {
            if (ZCAT_MEM_TYPE_USER == flags) { copy_from_user(ringBuf->buf + writePoint, buf, len); }
            else { memcpy(ringBuf->buf + writePoint, buf, len); }
            ringBuf->writePoint += len;
            writeLen = len;
        }
    }

    return writeLen;
}

/**
* @brief ȡһλλݵĿ껺
* @param[in] ringBuf λָ
* @param[in] buf Ŀ껺ָ
* @param[in] len Ŀ껺泤
* @param[in] flags Ŀ껺ڴͣ0:ں̬,1:û̬
* @return ضȡ
* @note
* @see 
*/
UINT32 ReadRingBuffer(T_RINGBUFFER *ringBuf, UINT8 *buf, UINT32 len, UINT32 flags)
{
    UINT32 readLen = 0;
    UINT32 writePoint = ringBuf->writePoint;
    UINT32 readPoint = ringBuf->readPoint;

    /*  */
    if (!IsRingBufferValid(ringBuf) || buf == NULL || len == 0)
    {
        return 0;
    }
    if( writePoint >= ringBuf->capacity || readPoint >= ringBuf->capacity )
	{
        return 0;
	}
    if (writePoint > readPoint)
    {
        readLen = writePoint - readPoint;
        readLen = (readLen >= len) ? len : readLen;

        if (ZCAT_MEM_TYPE_USER == flags) { copy_to_user(buf, ringBuf->buf + readPoint, readLen); }
        else { memcpy(buf, ringBuf->buf + readPoint, readLen); }
        ringBuf->readPoint += readLen;
    }
    else if (writePoint < readPoint)
    {
        readLen = ringBuf->capacity - readPoint + writePoint;
        readLen = (readLen >= len) ? len : readLen;

        if (ringBuf->capacity - readPoint >= readLen)
        {
            if (ZCAT_MEM_TYPE_USER == flags) { copy_to_user(buf, ringBuf->buf + readPoint, readLen); }
            else { memcpy(buf, ringBuf->buf + readPoint, readLen); }
            ringBuf->readPoint = (ringBuf->readPoint + readLen) % ringBuf->capacity;
        }
        else
        {
            UINT32 copyLen = ringBuf->capacity - readPoint;
            if (ZCAT_MEM_TYPE_USER == flags) { copy_to_user(buf, ringBuf->buf + readPoint, copyLen); }
            else { memcpy(buf, ringBuf->buf + readPoint, copyLen); }

            copyLen = readLen - copyLen;
            if (ZCAT_MEM_TYPE_USER == flags) { copy_to_user(buf + (readLen - copyLen), ringBuf->buf, copyLen); }
            else { memcpy(buf + (readLen - copyLen), ringBuf->buf, copyLen);}

            ringBuf->readPoint = copyLen;
        }
    }

    return readLen;
}

/**
* @brief ȡǰRing BufferпĴС
* @param[in] ringBuf λָ
* @return ֽ
* @note
* @see 
*/
UINT32 GetRingBufferSize(T_RINGBUFFER *ringBuf)
{
    UINT32 writePoint = ringBuf->writePoint;
    UINT32 readPoint = ringBuf->readPoint;
    UINT32 bufSize = 0;

    if (!IsRingBufferValid(ringBuf))
    {
        return 0;
    }

    if (writePoint > readPoint)
    {
        bufSize = writePoint - readPoint;
    }
    else if (writePoint < readPoint)
    {
        bufSize = ringBuf->capacity - readPoint + writePoint;
    }

    return bufSize;
}

/**
* @brief ÿ
* @param[in] ringBuf λָ
* @return void
* @note
* @see 
*/
VOID EmptyRingBuffer(T_RINGBUFFER *ringBuf)
{
    if (IsRingBufferValid(ringBuf))
    {
        ringBuf->readPoint = ringBuf->writePoint;
    }
}

