/**
 * 
 * @file      commgt_api.h
 * @brief     
 *            This file is part of tools.
 *            CommAgtӿڹ
 *            
 * @details   
 * @author    Tools Team.
 * @email     
 * @copyright Copyright (C) 2013 Sanechips Technology Co., Ltd.
 * @warning   
 * @date      2019/02/02
 * @version   1.4
 * @pre       
 * @post      
 *            
 * @par       
 * Change History :
 * ---------------------------------------------------------------------------
 * date        version  author         description
 * ---------------------------------------------------------------------------
 * 2013/01/14  1.0      lu.xieji       Create file
 * 2018/09/24  1.1      jiang.fenglin  ˼ͨŹڴ1MΪ512K
 * 2018/09/25  1.2      dai.kang       λڴ3.5MΪ2M
 * 2018/12/25  1.3      dai.kang       λڴɾ̬ΪzOss_GetUBֱ̬
 * 2019/02/02  1.4      jiang.fenglin  ޸עͷʽΪdoxygen
 * ---------------------------------------------------------------------------
 * 
 * 
 */

#ifndef RINGBUF_H_
#define RINGBUF_H_

#include "logcat_drv.h"

#define ZCAT_MEM_TYPE_KERNEL 0  
#define ZCAT_MEM_TYPE_USER   1

// С
#define ALIGNED_SIZE(size, alignment) (((size) + (alignment)) & ~(alignment))

/* ӡ */
typedef struct
{
    UINT32 capacity;                /* */
    volatile UINT32 readPoint;      /* ָ */
    volatile UINT32 writePoint;     /* дָ */
    UINT32 symbol;                  /* ƿʶ */
    UINT8 buf[1];                   /* ӡ */
} T_RINGBUFFER;


/**
 * @brief ҪĻ
 *        bufΪNULLַָһڴΪ
 * @param[in] buf ַ
 * @param[in] bufSize С
 * @return ɹָ򻺳ṹָ룬򷵻NULL
 * @note
 * @see 
 */
T_RINGBUFFER* CreateRingBuffer(UINT8 *buf, UINT32 bufSize);

/**
 * @brief ҪĻ,ָλֵ
 *        bufΪNULLַָһڴΪ
 * @param[in] buf ַ
 * @param[in] bufSize С
 * @param[in] bufSize λ
 * @return ɹָ򻺳ṹָ룬򷵻NULL
 * @note
 * @see 
 */
T_RINGBUFFER* CreateRingBufferWithSymbol(UINT8 *buf, UINT32 bufSize, UINT32 symbol);

/**
 * @brief жϻǷЧ
 * @param[in] ringBuf λ
 * @return ǷTRUE,񷵻FALSE
 * @note
 * @see 
 */
BOOL IsRingBufferValid(T_RINGBUFFER *ringBuf);

/**
 * @brief ÿ
 * @param[in] ringBuf λָ
 * @return void
 * @note
 * @see 
 */
VOID EmptyRingBuffer(T_RINGBUFFER *ringBuf);

/**
 * @brief д뻷λ
 * @param[in] ringBuf λָ
 * @param[in] buf ݻָ
 * @param[in] len ݳ
 * @param[in] flags ݻڴͣ0:ں̬,1:û̬
 * @return дʵʳ
 * @note
 * @see 
 */
UINT32 WriteRingBuffer(T_RINGBUFFER *ringBuf, UINT8 *buf, UINT32 len, UINT32 flags);

/**
 * @brief ȡһλλݵĿ껺
 * @param[in] ringBuf λָ
 * @param[in] buf Ŀ껺ָ
 * @param[in] len Ŀ껺泤
 * @param[in] flags Ŀ껺ڴͣ0:ں̬,1:û̬
 * @return ضȡ
 * @note
 * @see 
 */
UINT32 ReadRingBuffer(T_RINGBUFFER *ringBuf, UINT8 *buf, UINT32 len, UINT32 flags);

/**
 * @brief ȡǰRing BufferпĴС
 * @param[in] ringBuf λָ
 * @return ֽ
 * @note
 * @see 
 */
UINT32 GetRingBufferSize(T_RINGBUFFER *ringBuf);


#endif /*RINGBUF_H_*/

