/*
 * Ethernet driver for zte zx2975xx gmac on chip network device
 * (c)2008 http://www.zte.com.cn
 * Authors:	zhang dongdong <zhang.dongdong16@zte.com.cn>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version
 * 2 of the License, or (at your option) any later version.
 */
#include <linux/kernel.h>
#include <linux/module.h>
#include <linux/interrupt.h>
#include <linux/types.h>
#include <linux/delay.h>
#include <linux/init.h>
#include <linux/spinlock.h>
#include <linux/netdevice.h>
#include <linux/etherdevice.h>
#include <linux/phy.h>
#include <linux/platform_device.h>
#include "zx29_gmac.h"

struct kset *kset_gmac;
struct kobject *gmackobj = NULL;
u32 zx29_gmac_plug_state[3] = {0};	/*0:phy  1:sw_wan   2:sw_lan*/

//KOBJ ADD BY LYL
static struct attribute gmac_phy_plug_attr =
{
        .name = "eth_phy_state",
        .mode = S_IRWXUGO,
};
static struct attribute gmac_sw_wan_plug_attr =
{
        .name = "eth_sw_wan_state",
        .mode = S_IRWXUGO,
};
static struct attribute gmac_sw_lan_plug_attr =
{
        .name = "eth_sw_lan_state",
        .mode = S_IRWXUGO,
};

static struct attribute *gmac_status_attrs[] =
{
       &gmac_phy_plug_attr,
	   &gmac_sw_wan_plug_attr,
	   &gmac_sw_lan_plug_attr,
       NULL,
};

ssize_t kobj_gmac_show(struct kobject *kobject,struct attribute *attr,char *buf)
{
    unsigned  link =0;

	if(!strcmp(attr->name,"eth_phy_state")) {
		if(zx29_gmac_plug_state[0] == 0)
			sprintf(buf, "%s","0");
		else
			sprintf(buf, "%s","1");
	} else if(!strcmp(attr->name,"eth_sw_wan_state")) {
		if(zx29_gmac_plug_state[1] == 0)
			sprintf(buf, "%s","0");
		else
			sprintf(buf, "%s","1");
	} else if(!strcmp(attr->name,"eth_sw_lan_state")) {
		if(zx29_gmac_plug_state[2] == 0)
			sprintf(buf, "%s","0");
		else
			sprintf(buf, "%s","1");
	} else {
		printk("invalidate attr name.\n");
	}
	
	return strlen(buf);
}
ssize_t kobj_gmac_store(struct kobject *kobject,struct attribute *attr, const char *buf,size_t size)
{
	unsigned int value = 0;
	value = simple_strtoul(buf, NULL, 4);
	printk("attrname: %s.\n",attr->name);
	if(!strcmp(attr->name,"eth_phy_state")) {
		zx29_gmac_plug_state[0] = value;
	} else if(!strcmp(attr->name,"eth_sw_wan_state")) {
		zx29_gmac_plug_state[1] = value;
	} else if(!strcmp(attr->name,"eth_sw_lan_state")) {
		zx29_gmac_plug_state[2] = value;
	} else {
		printk("invalidate attr name.\n");
	}

	return size;
}
static struct sysfs_ops obj_gmac_sysops =
{
        .show = kobj_gmac_show,
        .store = kobj_gmac_store,        
};

static void kobj_gmac_release(struct kobject *kobject)
{
	printk("[gmac kobj_test: release!]\n");
}

static void kobj_gmac_del(struct kobject *kobject)
{
#if 1
	kset_unregister(kset_gmac);

	kobject_uevent(gmackobj, KOBJ_REMOVE);
	kobject_del(gmackobj);
	kobject_put(gmackobj);

	kfree(gmackobj);
#endif
	printk("[gmac kobj_test: delete!]\n");
}

static struct kobj_type gmacktype =
{       .release = kobj_gmac_release,
        .sysfs_ops = &obj_gmac_sysops,
        .default_attrs = gmac_status_attrs,
};
static int kset_filter(struct kset *kset,struct kobject *kobj)
{
        printk("kset Filter: kobj %s.\n",kobj->name);
        return 1;
}
static const char *kset_name(struct kset *kset,struct kobject *kobj)
{    
        static char buf[20];
        printk("Name:  kobj %s.\n",kobj->name);
        sprintf(buf,"%s","gmac");
        return buf;
}
static int kset_uevent(struct kset *kset,struct kobject *kobj, struct kobj_uevent_env *env)
{
        int i = 0;
        printk("uevent: kobj %s.\n",kobj->name);
        while(i < env->envp_idx)
        {
        printk("%s.\n",env->envp[i]);
         i ++;
         }
         return 0;
}
static struct kset_uevent_ops gmac_uevent_ops =
{
        .filter = kset_filter,
        .name = kset_name,
        .uevent = kset_uevent,
};

void gmac_event_notify(GMAC_NOTIFY_EVENT notify_type, void* puf)
{
	int rtv = -1;
	enum kobject_action action = KOBJ_MAX;
	char*envp_phy_ext[] = {"GMACEVENT=gmac_eth_phy",NULL}; 
	char*envp_sw_wan_ext[] = {"GMACEVENT=gmac_eth_sw_wan",NULL}; 
	char*envp_sw_lan_ext[] = {"GMACEVENT=gmac_eth_sw_lan",NULL}; 

	//zx29_gmac_plug_state = notify_type;
	
	switch(notify_type){
		case GMAC_ETH_PHY_PLUGIN:
			printk("gmac eth phy plugin \n");
			action = KOBJ_ADD;
			zx29_gmac_plug_state[0] = 1;
			if(gmackobj)
				rtv = kobject_uevent_env(gmackobj, action,envp_phy_ext);
			break;
			
		case GMAC_ETH_PHY_PLUGOUT:
			printk("gmac eth phy plugout \n");
			action = KOBJ_REMOVE;
			zx29_gmac_plug_state[0] = 0;
			if(gmackobj)
				rtv = kobject_uevent_env(gmackobj, action,envp_phy_ext);
			break;
			
		case GMAC_ETH_SW_WAN_PLUGIN:
			printk("gmac eth switch wan plugin \n");
			action = KOBJ_ADD;
			zx29_gmac_plug_state[1] = 1;
			if(gmackobj)
				rtv = kobject_uevent_env(gmackobj, action,envp_sw_wan_ext);
			break;
			
		case GMAC_ETH_SW_WAN_PLUGOUT:
			printk("gmac eth switch wan plugout \n");
			action = KOBJ_REMOVE;
			zx29_gmac_plug_state[1] = 0;
			if(gmackobj)
				rtv = kobject_uevent_env(gmackobj, action,envp_sw_wan_ext);
			break;
			
		case GMAC_ETH_SW_LAN_PLUGIN:
			printk("gmac eth switch lan plugin \n");
			action = KOBJ_ADD;
			zx29_gmac_plug_state[2] = 1;
			if(gmackobj)
				rtv = kobject_uevent_env(gmackobj, action,envp_sw_lan_ext);
			break;
			
		case GMAC_ETH_SW_LAN_PLUGOUT:
			printk("gmac eth switch lan plugout \n");
			action = KOBJ_REMOVE;
			zx29_gmac_plug_state[2] = 0;
			if(gmackobj)
				rtv = kobject_uevent_env(gmackobj, action,envp_sw_lan_ext);
			break;

		default:
			printk(KERN_WARNING "UNKWON GMAC EVENT \n");
			break;
	}
    
	printk(KERN_WARNING "rtv:%d \n",rtv);
}

int  gmac_event_init(void)
{
	int ret = 0;
	/* ע kset_p */   
	gmackobj = kzalloc(sizeof(*gmackobj),GFP_KERNEL);
	if(!gmackobj){
		printk(KERN_WARNING "mallock gmackobj failed \n");
		return 0;
	}
	kset_gmac = kset_create_and_add("gmac", &gmac_uevent_ops, NULL); 
	kobject_init(gmackobj, &gmacktype);
	kobject_add(gmackobj,&kset_gmac->kobj,"%s","gmacconfig");  
	gmackobj->kset = kset_gmac;

	return ret;
}


