/*******************************************************************************
* Ȩ (C)2011, ͨѶɷ޹˾ 
*
* ļ:	zx_gmac.c
* ļʶ:
* ժҪ: sanchips Serial GMAC  
* ˵:	ϵͳʹù̶ӳ䣬ԴлȡĵַΪַioremap
*			ϵͳʹö̬ӳ䣬޸probe޶ַӳ 
* ǰ汾:	1.1
* :	 
* : 2011-8-1
*
* ޸ļ¼1
* ޸:
* 汾:
* ޸ġ:
* ޸:
*
*******************************************************************************/

#include "../zx_gmac.h"
#include <linux/wakelock.h>
#include <linux/delay.h>

/*-----------------------------------------------------------------------------------
* 
------------------------------------------------------------------------------*/
#define  GMAC_NO_INT
#define CONFIG_PHY_TIMER_SET
#define   GMAC_PHY_PLUG_NAME          "eth_state"
#define PHY_RTL8201					0x00008200
#define PHY_8E1119R					0x01410E80
#define PHY_KSZ8051					0x00221550
#define PHY_KSZ8081                 0x00221560
#define PHY_IP101A                  0x02430C50
#define PHY_IP101G                  0x02430c54


/*phy reg */

/* PHY page mode control Register. */
#define MII_PAGECTRL             		20



/* WOL+ control Register, page4 register16. */
#define WOL_CTRL             		16
#define WOL_CTRL_EN             		0x8000
#define WOL_CTRL_MASTER             	0x4000
#define WOL_CTRL_INTR_ACT_HIGH          0x2000
#define WOL_CTRL_INTR_12_RSVD           0x1000//reserved
#define WOL_CTRL_SENSE_MAGIC_PKT        0x800
#define WOL_CTRL_SENSE_ANY_PKT          0x400
#define WOL_CTRL_SENSE_DUT              0x200
#define WOL_CTRL_DNSPD_EN               0x100
#define WOL_CTRL_TIMER_SEL              0xC0
#define WOL_CTRL_TIMER_30S              0x00<<6
#define WOL_CTRL_TIMER_3M               0x01<<6
#define WOL_CTRL_TIMER_10M              0x11<<6
#define WOL_CTRL_MANUAL_SET             0x20


/* WOL+ status Register, page17 register17. */
#define WOL_SR             		17
#define WOL_SR_INTR_DIS             	0x8000


/*  Interrupt status Register, page16 register17. */
#define INT_SR             		        17
#define INT_SR_INTR_PIN_USED            0x8000
#define INT_SR_ALL_MASK                 0x800
#define INT_SR_SPEED_MASK               0x400
#define INT_SR_DUPLEX_MASK              0x200
#define INT_SR_LINK_MASK                0x100
#define INT_SR_INT_STATUS               0x8
#define INT_SR_SPEED_INT                0x4
#define INT_SR_DUPLEX_INT               0x2
#define INT_SR_LINK_INT                 0x1


/*  Interrupt status Register, page16 register29. */
#define IO_SPEC_CR             		        29
#define IO_SPEC_CR_SEL_INTR32               0x4

/****************************************************************************
* 	                               Global Variables
****************************************************************************/
unsigned                  phy_id_globle;
int page_select = 0;
static E_LINK_STATE phy_port_state=0;
int int_count = 0;
struct kset *kset_gmac;
struct kobject *gmackobj = NULL;
struct kobject *phykobj = NULL;
static unsigned int phy_plug = 0;
static unsigned int phy_init_state = 0;
static unsigned int phy_init_flag = 1;
static unsigned long phy_init_time_start = 0;
static unsigned long phy_init_time_now = 0;
static char  phy_init_invalid[]="invalid";
static char  phy_on[]="phy_on";
static char  phy_off[]="phy_off";
static char  invalid[]="invalid";
struct wake_lock wlock_PHY;
struct wake_lock wlock_PHY_first;
struct wake_lock phy_negotiation_lock;
struct timer_list		phy_timer;	
typedef enum{
     GMAC_PHY_PLUGIN = 0,
     GMAC_PHY_PLUGOUT,
     GMAC_SWITCH_NUM,
}phy_notify_event;

#ifdef GMAC_NO_INT
struct semaphore gmac_plug_thread_sema;
struct net_device *g_gmac_phy_dev   = NULL;
static unsigned int g_mac_phy_state = 0;
#endif

/*------------------------------------------------------------------------------
* Ϊõⲿӿ
* 
* 
------------------------------------------------------------------------------*/
extern struct net_device* 	gmac_net_dev;
extern int gmac_mii_read(struct net_device *dev, int phy, int reg);
extern void gmac_mii_write(struct net_device *dev, int phy, int reg, int val);
extern void gmac_set_speed_duplex(struct net_device * dev,E_SPEED speed,E_DUPLEX duplex);
/*------------------------------------------------------------------------------
* Ϊڲ˵
* 
* 
------------------------------------------------------------------------------*/
static irqreturn_t zx_phy_int_threadhandler(int irq, void *dev_id);
static irqreturn_t zx_phy_int(int irq, void *dev_id);
static void zx_phy_timer(unsigned long data);
static void kobj_gmac_release(struct kobject *kobject);
static void kobj_gmac_del(struct kobject *kobject);
E_LINK_STATE gmac_phy_link_status(struct net_device *dev);
#ifdef GMAC_NO_INT
//void zx_gmac_plug_thread(unsigned long dev_id);
void zx_gmac_plug_thread_ms(unsigned long dev_id);
#endif

/*------------------------------------------------------------------------------
* Ϊ
* 
* 
------------------------------------------------------------------------------*/
// 趨ǰģʽ˫
static int phy_set_speed_duplex(struct net_device *dev, E_SPEED speed, E_DUPLEX duplex)
{
    unsigned			val;
    struct zx_net_dev* 	prv 	= (struct zx_net_dev*)netdev_priv(dev);
    int					phy 	= prv->phy;
    volatile unsigned 	*gmac 	= (unsigned*)dev->base_addr;
    //ע⣺Ŀǰδǧ
    if((eSPEED_END <= speed) || (eDUPLEX_END <= duplex))
    {
        return -1;
    }
    spin_lock_irq(&prv->phy_lock);
    switch(prv->phy_id)
    {
        case PHY_IP101G:
        {
            if(eSET_AUTO_NEGO == prv->set_duplex_mode)
            {
                val = gmac_mii_read(dev, phy, MII_ADVERTISE);
                val &= ~(ADVERTISE_10HALF|ADVERTISE_10FULL|ADVERTISE_100HALF|ADVERTISE_100FULL);//0x1E1;clear speed and duplex setting
                gmac_mii_write(dev, phy, MII_ADVERTISE, val);
                
                val	= gmac_mii_read(dev, phy, MII_BMCR);
                val &= ~(BMCR_ANENABLE|BMCR_ANRESTART);//0x1200;
                gmac_mii_write(dev, phy, MII_BMCR, val);				// رЭ
            }
            
            val	= gmac_mii_read(dev, phy, MII_BMCR);				//ȡǰٶȺ˫״̬
            val &= ~(BMCR_SPEED100|BMCR_FULLDPLX);//0x2100;		//յǰٶȺ˫״̬

            if(eSPEED_100M == speed)
            {
                val |= BMCR_SPEED100;		//ûٶ
            }
            if(eDUPLEX_FULL == duplex)
            {
                val |= BMCR_FULLDPLX;		//û˫
            }
            gmac_mii_write(dev, phy, MII_BMCR, val);
            
            prv->speed	= speed;
            prv->duplex	= duplex;
            
            gmac_set_speed_duplex(dev,speed,duplex);
            break;
        }
        case PHY_8E1119R:
        {
        //ѡ0ҳĴ
        gmac_mii_write(dev,phy, 22, 0);
        if(eSET_AUTO_NEGO == prv->set_duplex_mode)
        {
            val	= gmac_mii_read(dev, phy, 0);
            val &= ~0x1200;
            gmac_mii_write(dev, phy, 0, val);				// رЭ
        }
        //ѡ2ҳĴ
        gmac_mii_write(dev, phy, 22, 0x2);
        //ע⣺Ŀǰ֧1000Mʵǰ(eSPEED_1000M == speed)ڣδ
        if		(eSPEED_10M == speed) gmac_mii_write(dev, phy, 21, 0x4);	//ѡܽĬʱΪ10M
        else if	(eSPEED_100M == speed) gmac_mii_write(dev, phy, 21, 0x5);	//ѡܽĬʱΪ100M
        //ѡ0ҳĴ
        gmac_mii_write(dev,phy, 22, 0);
        val	= gmac_mii_read(dev, phy, 0);				//ȡǰٶȺ˫״̬
        val &= ~0x2140;								//յǰٶȺ˫״̬
        val |= (speed << 13) | (duplex << 8);		//ûٶȺ˫״̬
        gmac_mii_write(dev, phy, 0, val);
        prv->speed	= speed;
        prv->duplex	= duplex;
        val	= MAC(0x0000) | 1<<11 | 1<<14;	// ĬΪ100Mȫ˫
        if(eSPEED_10M == prv->speed)
        {
            val &= ~(1 << 14);					// 10M
        }
        if(eDUPLEX_HALF == prv->duplex)
        {
            val &= (~(1 << 11));					// ˫
            val |= (1 << 16);
        }
        MAC(0x0000) = val;
        break;
        }
        case PHY_KSZ8051:
        {
        if(eSET_AUTO_NEGO == prv->set_duplex_mode)
        {
            val	= gmac_mii_read(dev, phy, 0);
            val &= ~0x1200;
            gmac_mii_write(dev, phy, 0, val);				// رЭ
        }
        val	= gmac_mii_read(dev, phy, 0);				//ȡǰٶȺ˫״̬
        val &= ~0x2100;								//յǰٶȺ˫״̬
        val |= (speed << 13) | (duplex << 8);		//ûٶȺ˫״̬
        gmac_mii_write(dev, phy, 0, val);
        prv->speed	= speed;
        prv->duplex	= duplex;
        val	= MAC(0x0000) | 1<<11 | 1<<14;	// ĬΪ100Mȫ˫
        if(eSPEED_10M == prv->speed)
        {
            val &= ~(1 << 14);					// 10M
        }

        if(eDUPLEX_HALF == prv->duplex)
        {
            val &= (~(1 << 11));					// ˫
            val |= (1 << 16);
        }
        MAC(0x0000) = val;

        break;
        }
        case PHY_KSZ8081:
        {
            if(eSET_AUTO_NEGO == prv->set_duplex_mode)
            {
                val	= gmac_mii_read(dev, phy, 0);
                val &= ~0x1200;
                gmac_mii_write(dev, phy, 0, val);				// رЭ
            }
            val	= gmac_mii_read(dev, phy, 0);				//ȡǰٶȺ˫״̬
            val &= ~0x2100;								//յǰٶȺ˫״̬
            val |= (speed << 13) | (duplex << 8);		//ûٶȺ˫״̬
            gmac_mii_write(dev, phy, 0, val);
            prv->speed	= speed;
            prv->duplex	= duplex;
            val	= MAC(0x0000) | 1<<11 | 1<<14;	// ĬΪ100Mȫ˫
            if(eSPEED_10M == prv->speed)
            {
                val &= ~(1 << 14);					// 10M
            }
            if(eDUPLEX_HALF == prv->duplex)
            {
                val &= (~(1 << 11));					// ˫
                val |= (1 << 16);
            }
            MAC(0x0000) = val;
            break;
        }
        case PHY_RTL8201:
        default:
        {
            if(eSET_AUTO_NEGO == prv->set_duplex_mode)
            {
                val	= gmac_mii_read(dev, phy, 0);
                val &= ~0x1200;
                gmac_mii_write(dev, phy, 0, val);				// رЭ
            }
            val	= gmac_mii_read(dev, phy, 0);				//ȡǰٶȺ˫״̬
            val &= ~0x2100;								//յǰٶȺ˫״̬
            val |= (speed << 13) | (duplex << 8);		//ûٶȺ˫״̬
            gmac_mii_write(dev, phy, 0, val);
            prv->speed	= speed;
            prv->duplex	= duplex;
            val	= MAC(0x0000) | 1<<11 | 1<<14;	// ĬΪ100Mȫ˫
            if(eSPEED_10M == prv->speed)
            {
              val &= ~(1 << 14);					// 10M
            }
            if(eDUPLEX_HALF == prv->duplex)
            {
                val &= (~(1 << 11));					// ˫
                val |= (1 << 16);
            }
            MAC(0x0000) = val;
            break;
        }
    }
    //״̬ʱڸʡ˫ģʽ϶Ӧδ״̬
    if(netif_carrier_ok(dev))	netif_carrier_off(dev);
    prv->link	= eLINK_OFF;
    //趨ǰֶ״̬
    if		       ((eSPEED_10M  == prv->speed) && (eDUPLEX_FULL == prv->duplex)) prv->set_duplex_mode = eSET_10M_FULL_DUPLEX;
    else if	((eSPEED_100M == prv->speed) && (eDUPLEX_HALF == prv->duplex)) prv->set_duplex_mode = eSET_100M_HALF_DUPLEX;
    else if	((eSPEED_100M == prv->speed) && (eDUPLEX_FULL == prv->duplex)) prv->set_duplex_mode = eSET_100M_FULL_DUPLEX;
    else if	((eSPEED_10M  == prv->speed) && (eDUPLEX_HALF == prv->duplex)) prv->set_duplex_mode = eSET_10M_HALF_DUPLEX;
    spin_unlock_irq(&prv->phy_lock);
    return 0;
}

// PHYԶЭ
static int phy_negotiation(struct net_device *dev)
{
    unsigned			val;
    struct zx_net_dev* 	prv 	= (struct zx_net_dev*)netdev_priv(dev);
    int phy 	= prv->phy;
    int autotimeout = 30000;
    switch(prv->phy_id)
    {
             case PHY_IP101G:
        {
            //set auto-neg advertisement capabilities to 10/100 half/full
            val = ADVERTISE_100FULL|ADVERTISE_100HALF|ADVERTISE_10FULL|ADVERTISE_10HALF|ADVERTISE_CSMA;
            gmac_mii_write(dev, phy, MII_ADVERTISE, val);
            
            val	= gmac_mii_read(dev, phy, MII_BMCR);
            val |= BMCR_ANENABLE | BMCR_ANRESTART;
            gmac_mii_write(dev, phy, MII_BMCR, val);
            
            while(autotimeout)
	    {
	        val = gmac_mii_read(dev,phy, MII_BMSR);
	        if(val&BMSR_ANEGCOMPLETE)
	        {
	  	    break;
	        }
	        autotimeout--;
	    };
           if(autotimeout == 0)
    	    {
    		printk("phy IP101G auto negotiation failed\n");   //add log
    		return -1;
    	    }           
            break;            
        }
        case PHY_IP101A:
        {
            //set auto-neg advertisement capabilities to 10/100 half/full
            val = ADVERTISE_100FULL|ADVERTISE_100HALF|ADVERTISE_10FULL|ADVERTISE_10HALF|ADVERTISE_CSMA;
            gmac_mii_write(dev, phy, MII_ADVERTISE, val);
            
            val	= gmac_mii_read(dev, phy, MII_BMCR);
            val |= BMCR_ANENABLE | BMCR_ANRESTART;
            gmac_mii_write(dev, phy, MII_BMCR, val);
            
            while(autotimeout)
	    {
	        val = gmac_mii_read(dev,phy, MII_BMSR);
	        if(val&BMSR_ANEGCOMPLETE)
	        {
	  	    break;
	        }
	        autotimeout--;
	    };
           if(autotimeout == 0)
    	    {
    		return -1;
    	    }           
            break;           
        }
        case PHY_8E1119R:
        {
            //ѡ2ҳĴ
            gmac_mii_write(dev, phy, 22, 0x2);
            //ѡܽĬʱΪ100M
            gmac_mii_write(dev, phy, 21, 0x5);
            //ѡ0ҳĴ
            gmac_mii_write(dev,phy, 22, 0);
            //ر1000MЭ̹ܣΪĿǰGMACģ鲻֧1000M
            val = gmac_mii_read(dev,phy,9);
            val &= ~0x0300;
            gmac_mii_write(dev,phy, 9, val);
            val	= gmac_mii_read(dev, phy, 0);
            val |= 0x1200;
            gmac_mii_write(dev, phy, 0, val);             // Э
            break;
        }
        case PHY_KSZ8051:
        {
            val	= gmac_mii_read(dev, phy, 0);
            val |= 0x1200;
            gmac_mii_write(dev, phy, 0, val);				// Э
            break;
            }
            case PHY_KSZ8081:
            {
            val	= gmac_mii_read(dev, phy, 0);
            val |= 0x1200;
            gmac_mii_write(dev, phy, 0, val);				// Э
            break;
        }
        case PHY_RTL8201:
        default:
        {
            val	= gmac_mii_read(dev, phy, 0);
            val |= 0x1200;
            gmac_mii_write(dev, phy, 0, val);				// Э
            break;
        }
    }
    spin_lock_irq(&prv->phy_lock);
    //״̬ʱڸЭ̣϶Ӧδ״̬
    if(netif_carrier_ok(dev))	netif_carrier_off(dev);
    prv->link					= eLINK_OFF;
    prv->set_duplex_mode		= eSET_AUTO_NEGO;
    prv->autoneg                =AUTONEG_ENABLE;
    spin_unlock_irq(&prv->phy_lock);
    return 0;
}

// PHYʼ
static int gmac_phy_init(struct net_device *dev)
{
    int				i;
    int 				phy;
    short unsigned		val = 0;
    short unsigned  val_wol_enable = 0;
    unsigned int          	tval = 0;
    unsigned                  plug_flag =0;
	unsigned long flags = IRQF_TRIGGER_FALLING | IRQF_ONESHOT;
    int ret;
    int hh;
    int vv;
    int ext_int6_no;
    int autotimeout = 500;
    struct zx_net_dev* 	prv	= (struct zx_net_dev*)netdev_priv(dev);
    int value = 0;

    
    // ȡһPHYżID
    for(phy = 0; phy <= 31; phy++)
    {
        val				= gmac_mii_read(dev, phy, MII_BMSR);
		printk("gmac_phy_init_mii_read, val:0x%x\n",val);

        if((0 != val) && (0xFFFF != val))
        {
            prv->phy 	= phy;
            prv->phy_id	= (gmac_mii_read(dev, phy, MII_PHYSID1) << 16) | gmac_mii_read(dev, phy, MII_PHYSID2);
	  		phy_id_globle   =  prv->phy_id;
            //prv->phy_id &= ~0xf;//︣ɽӣΪһPHY ID24BITӲ汾ţųӲı
            break;
        }
    }

    if(phy > 31)
    {
        return -1;
    }
    else{
        printk(KERN_INFO "TSP zx29 gmac  find phy,phy_id_globle:0x%d\n",phy_id_globle);
    }

    val = gmac_mii_read(dev, phy, MII_BMCR) | BMCR_RESET;
    gmac_mii_write(dev, phy, MII_BMCR, val);


        for(i = 100000;  i > 0; i--)				// жPHYǷλɹ
        {
            if((gmac_mii_read(dev, phy, MII_BMCR) & BMCR_RESET) == 0)	
            {
                break;
            }
            udelay(10);
        }
        switch(prv->phy_id)
        {
            case PHY_IP101A:
            {
                //150331 temp 802.3.azر
                gmac_mii_write(dev, phy, 0xd, 0x0007); 
                gmac_mii_write(dev, phy, 0xe, 0x003c);
                gmac_mii_write(dev, phy, 0xd, 0x4007);
                gmac_mii_write(dev, phy, 0xe, 0x0000);  
                break;
            }
            case PHY_KSZ8081:
            {
                gmac_mii_write(dev, phy, 13, 0x001c);
                gmac_mii_write(dev, phy, 14, 0x0008);
                gmac_mii_write(dev, phy, 13, 0x401c);
                gmac_mii_write(dev, phy, 14, 0x0067);
                gmac_mii_write(dev, phy, 13, 0x001c);
                gmac_mii_write(dev, phy, 14, 0x0009);
                gmac_mii_write(dev, phy, 13, 0x401c);
                gmac_mii_write(dev, phy, 14, 0xffff);
                gmac_mii_write(dev, phy, 13, 0x001c);
                gmac_mii_write(dev, phy, 14, 0x000a);
                gmac_mii_write(dev, phy, 13, 0x401c);
                gmac_mii_write(dev, phy, 14, 0xffff);
                break;
            }
            default:
            {
                break;
            }
        }
#ifndef GMAC_NO_INT
    //timer
    init_timer(&phy_timer);
    phy_timer.expires 		= jiffies + 3*HZ;
    phy_timer.data 		= (unsigned long)dev;
    phy_timer.function 	= &zx_phy_timer;
    add_timer(&phy_timer);
#endif	
     //register int
    //enable interrupt
    hh   = gmac_mii_read(dev, prv->phy, INT_SR);
    hh |= INT_SR_INTR_PIN_USED;
    hh &= ~(INT_SR_ALL_MASK|INT_SR_LINK_MASK);
    gmac_mii_write(dev, prv->phy, INT_SR, hh);		

    hh   = gmac_mii_read(dev, prv->phy, IO_SPEC_CR);
    hh |= IO_SPEC_CR_SEL_INTR32;
    gmac_mii_write(dev, prv->phy, IO_SPEC_CR, hh);	

    //set auto-neg advertisement capabilities to 10/100 half/full
    value = ADVERTISE_100FULL|ADVERTISE_100HALF|ADVERTISE_10FULL|ADVERTISE_10HALF|ADVERTISE_CSMA;
    gmac_mii_write(dev, phy, MII_ADVERTISE, value);//0x1E1

    val	= gmac_mii_read(dev, phy, MII_BMCR);
    val |= BMCR_ANENABLE | BMCR_ANRESTART;
    gmac_mii_write(dev, phy, MII_BMCR, val);


#if 0//lvwenhua for wol+
    if(prv->phy_id == PHY_IP101G)
    {
        #if 1//lvwenhua for test
        {
           gmac_mii_write(dev,prv->phy, 20, 16);
           value = gmac_mii_read(dev,prv->phy, 17);
           printk("lvwenhua gmac phy init p16r17=0x%x \n", value);
           
           gmac_mii_write(dev,prv->phy, 20, 16);
           value = gmac_mii_read(dev,prv->phy, 29);
           printk("lvwenhua gmac phy init p16r29=0x%x \n", value);
           
           gmac_mii_write(dev,prv->phy, 20, 4);
           value = gmac_mii_read(dev,prv->phy, 16);
           printk("lvwenhua gmac phy init p4r16=0x%x \n", value);
           
           gmac_mii_write(dev,prv->phy, 20, 17);
           value = gmac_mii_read(dev,prv->phy, 17);
           printk("lvwenhua gmac phy init p17r17=0x%x \n", value);
        }
        #endif

//        value = WOL_CTRL_EN|WOL_CTRL_INTR_12_RSVD|WOL_CTRL_SENSE_ANY_PKT|WOL_CTRL_SENSE_DUT|WOL_CTRL_DNSPD_EN|WOL_CTRL_TIMER_30S;
        value = WOL_CTRL_EN|WOL_CTRL_MASTER|WOL_CTRL_INTR_12_RSVD|WOL_CTRL_SENSE_ANY_PKT|WOL_CTRL_SENSE_DUT|WOL_CTRL_DNSPD_EN|WOL_CTRL_TIMER_30S;
        gmac_mii_write(dev,prv->phy, MII_PAGECTRL, 4);
        gmac_mii_write(dev,prv->phy, WOL_CTRL,value);//set wol+ 0x9740:enable,master,any packets,3minutes time out
        
        gmac_mii_write(dev,prv->phy, MII_PAGECTRL, 17);
        gmac_mii_write(dev,prv->phy, WOL_SR,WOL_SR_INTR_DIS);//set wol+ interrupt disable
        
        gmac_mii_write(dev,prv->phy, MII_PAGECTRL, 16);
        printk("gmac phy init: set wol+ p4r16=0x%x \n", value);

        #if 1//lvwenhua for test
        {
           gmac_mii_write(dev,prv->phy, 20, 16);
           value = gmac_mii_read(dev,prv->phy, 17);
           printk("lvwenhua gmac phy after init p16r17=0x%x \n", value);
           
           gmac_mii_write(dev,prv->phy, 20, 16);
           value = gmac_mii_read(dev,prv->phy, 29);
           printk("lvwenhua gmac phy after init p16r29=0x%x \n", value);
           
           gmac_mii_write(dev,prv->phy, 20, 4);
           value = gmac_mii_read(dev,prv->phy, 16);
           printk("lvwenhua gmac phy after init p4r16=0x%x \n", value);
           
           gmac_mii_write(dev,prv->phy, 20, 17);
           value = gmac_mii_read(dev,prv->phy, 17);
           printk("lvwenhua gmac phy after init p17r17=0x%x \n", value);


            gmac_mii_write(dev,prv->phy, 20, 16);
        }
        #endif
    }
#endif



#ifdef CONFIG_ARCH_ZX297520V2
			ret = gpio_request(ZX29_GPIO_56, "ext_int6");
      if (ret) 
      {
	    	printk(KERN_INFO " gpio56  request error.\n");
	    	return ret;
      }
      zx29_gpio_pd_pu_set(ZX29_GPIO_56,IO_CFG_PULL_DISABLE);

	/* config as ext_int*/
      ret = zx29_gpio_config(ZX29_GPIO_56, GPIO56_EXT_INT6); 
      if (ret) 
      return ret;
      /* get int no */
      ext_int6_no = prv->ext_irq;
      printk(KERN_INFO "TSP zx29 gmac phy ext_int6_no irq = %d  !!!!!\n",ext_int6_no);
      zx29_gpio_set_inttype(ZX29_GPIO_56, IRQ_TYPE_LEVEL_HIGH);

      pcu_int_clear(PCU_EX6_INT);   

	  wake_lock_init(&wlock_PHY, WAKE_LOCK_SUSPEND, "gmacPhy");
      ret = request_threaded_irq(ext_int6_no, zx_phy_int, zx_phy_int_threadhandler,flags, dev->name, dev);

	  if(ret)
		return ret;	
      irq_set_irq_wake(ext_int6_no, 1);
#elif  CONFIG_ARCH_ZX297520V3
#ifdef GMAC_NO_INT
     g_gmac_phy_dev = dev;
     wake_lock_init(&wlock_PHY, WAKE_LOCK_SUSPEND, "gmacPhy");
	 sema_init(&gmac_plug_thread_sema, 0);
     kthread_run(zx_gmac_plug_thread_ms, (unsigned long)dev, "gmac_proc/%s", "plug");
#else
   /*ⲿжϲȷ*/
       ret = gpio_request(ZX29_GPIO_64, "phy_int");
       if (ret) 
      {
    	printk(KERN_INFO "reset phy_int  request error.\n");
    	return ret;
      }
	/* config as ext_int*/
      ret = zx29_gpio_config(ZX29_GPIO_64, GPIO64_PHY_INT); 
      if (ret) 
      return ret;
      /* get int no */
      ext_int6_no = prv->ext_irq;
      printk(KERN_INFO "TSP zx29 gmac phy ext_int6_no irq = %d  !!!!!\n",ext_int6_no);

      pcu_int_clear(PCU_GMACPHY_INT);   

	  wake_lock_init(&wlock_PHY, WAKE_LOCK_SUSPEND, "gmacPhy");
      ret = request_threaded_irq(ext_int6_no, zx_phy_int, zx_phy_int_threadhandler,flags, dev->name, dev);
      if(ret)
		return ret;	
   	irq_set_irq_wake(ext_int6_no, 1);
#endif
#endif

   return 0;
}

// жPHYǷ
E_LINK_STATE gmac_phy_link_status(struct net_device *dev)
{
    unsigned			val = 0;
    struct zx_net_dev* 	prv		= (struct zx_net_dev*)netdev_priv(dev);
    
    if(PHY_8E1119R == prv->phy_id)// 
    {
        val	= gmac_mii_read(dev, prv->phy, MII_BMSR);
        val	= gmac_mii_read(dev, prv->phy, MII_BMSR);
    }
    else
    {
        val = gmac_mii_read(dev, prv->phy, MII_BMSR);
    }
    
    return (val & BMSR_LSTATUS)? eLINK_ON:eLINK_OFF;
}

static void zx_phy_timer(unsigned long data)
{
	struct net_device* 	dev		= (struct net_device*)data;
	struct zx_net_dev* 	prv		= (struct zx_net_dev*)netdev_priv(dev);
	//unsigned	 		val		= gmac_phy_linked(dev);
	phy_plug		= gmac_phy_link_status(dev);
	phy_timer.expires 			= jiffies + 3*HZ;				// ´ζʱ3sʼ
	add_timer(&phy_timer);

#if 0//lvwenhua for test
int value = 0;

    gmac_mii_write(dev,prv->phy, 20, 16);
    value = gmac_mii_read(dev,prv->phy, 17);
    printk("lvwenhua gmac phy timer p16r17=0x%x \n", value);
    
    gmac_mii_write(dev,prv->phy, 20, 16);
    value = gmac_mii_read(dev,prv->phy, 29);
    printk("lvwenhua gmac phy timer p16r29=0x%x \n", value);
    
    gmac_mii_write(dev,prv->phy, 20, 4);
    value = gmac_mii_read(dev,prv->phy, 16);
    printk("lvwenhua gmac phy timer p4r16=0x%x \n", value);
    
    gmac_mii_write(dev,prv->phy, 20, 17);
    value = gmac_mii_read(dev,prv->phy, 17);
    printk("lvwenhua gmac phy timer p17r17=0x%x \n", value);
    
    gmac_mii_write(dev,prv->phy, 20, 16);
    value = gmac_mii_read(dev,prv->phy, MII_BMSR);
    printk("lvwenhua gmac phy timer MII_BMSR r1=0x%x \n", value);
    
#endif
}
#ifdef CONFIG_PHY_TIMER_SET
// ڶʱ
static void zx_net_phy_timer(unsigned long data)
{
	struct net_device* 	dev		= (struct net_device*)data;
	struct zx_net_dev* 	prv		= (struct zx_net_dev*)netdev_priv(dev);
	unsigned	 		val		= gmac_phy_link_status(dev);
	volatile unsigned 	*gmac 	= (unsigned*)dev->base_addr;
	int					phy 	= prv->phy;
	unsigned 			temp_val;
    
	spin_lock_irq(&prv->phy_lock);
	if(eLINK_ON == val)													// PHY 
	{
		if((eLINK_OFF == prv->link) && (eSET_AUTO_NEGO == prv->set_duplex_mode))		// ״̬ϴβͬΪЭģʽ
		{
			switch(prv->phy_id)
			{
    			case PHY_IP101G:
                {
                    prv->speed	= (gmac_mii_read(dev,phy, MII_BMCR) & BMCR_SPEED100)?eSPEED_100M:eSPEED_10M;
                    prv->duplex	= (gmac_mii_read(dev,phy, MII_BMCR) & BMCR_FULLDPLX)?eDUPLEX_FULL:eDUPLEX_HALF;
                    break;
                }
                case PHY_IP101A:
                {
                    prv->speed	= (gmac_mii_read(dev,phy, MII_BMCR) & BMCR_SPEED100)?eSPEED_100M:eSPEED_10M;
                    prv->duplex	= (gmac_mii_read(dev,phy, MII_BMCR) & BMCR_FULLDPLX)?eDUPLEX_FULL:eDUPLEX_HALF;
                    break;
                }
				case PHY_8E1119R:
				{
					//ѡ0ҳĴ
					gmac_mii_write(dev, phy, 22, 0x0);

					temp_val     = gmac_mii_read(dev,phy, 17);
					prv->speed  = (temp_val & 0xC000) >> 14;
					prv->duplex = (temp_val & 0x2000) >> 13;

					break;
				}
				case PHY_KSZ8051:
				{
					temp_val	= gmac_mii_read(dev,phy, 0x1e);
					temp_val	&= 0x7;//ȡ0x1eĴ2:0 BITжЭ̽
					if(1 == temp_val)//10M,˫
					{
						prv->speed	= eSPEED_10M;
						prv->duplex	= eDUPLEX_HALF;
					}else if(2 == temp_val)//100M,˫
					{
						prv->speed	= eSPEED_100M;
						prv->duplex	= eDUPLEX_HALF;
					}
					else if(5 == temp_val)//10M,ȫ˫
					{
						prv->speed	= eSPEED_10M;
						prv->duplex	= eDUPLEX_FULL;
					}else if(6 == temp_val)//100M,ȫ˫
					{
						prv->speed	= eSPEED_100M;
						prv->duplex	= eDUPLEX_FULL;
					}else//ЭδɣERRӡҰ100M,ȫ˫趨
					{
						prv->speed	= eSPEED_100M;
						prv->duplex	= eDUPLEX_FULL;
					}
					break;
				}
				case PHY_KSZ8081:
				{
					temp_val	= gmac_mii_read(dev,phy, 0x1e);
					temp_val	&= 0x7;//ȡ0x1eĴ2:0 BITжЭ̽
					if(1 == temp_val)//10M,˫
					{
						prv->speed	= eSPEED_10M;
						prv->duplex	= eDUPLEX_HALF;
					}else if(2 == temp_val)//100M,˫
					{
						prv->speed	= eSPEED_100M;
						prv->duplex	= eDUPLEX_HALF;
					}
					else if(5 == temp_val)//10M,ȫ˫
					{
						prv->speed	= eSPEED_10M;
						prv->duplex	= eDUPLEX_FULL;
					}else if(6 == temp_val)//100M,ȫ˫
					{
						prv->speed	= eSPEED_100M;
						prv->duplex	= eDUPLEX_FULL;
					}else//ЭδɣERRӡҰ100M,ȫ˫趨
					{
						prv->speed	= eSPEED_100M;
						prv->duplex	= eDUPLEX_FULL;
					}
					break;
				}
				case PHY_RTL8201:
				default:
				{
					temp_val	    = gmac_mii_read(dev,phy, 0);
					prv->speed	= (temp_val & 0x2000) >> 13;
					prv->duplex	= (temp_val & 0x0100) >> 8;
					break;
				}
			}
            
            gmac_set_speed_duplex(dev,prv->speed,prv->duplex);
		}	

		if(!netif_carrier_ok(dev))	
			netif_carrier_on(dev);
	}
	else													// PHY δ
	{
		if(netif_carrier_ok(dev))	netif_carrier_off(dev);
	}
	prv->link 					= val;
	prv->timer.expires 			= jiffies + HZ;				// ´ζʱ1sʼ
	spin_unlock_irq(&prv->phy_lock);
	add_timer(&prv->timer);
}
#endif
void phy_notify_up(gmac_notify_event notify_type, void* puf)
{
	int rtv = -1;
	enum kobject_action action = KOBJ_MAX;
	char*envp_ext[] = {"GMACEVENT=gmac_eth0",NULL}; 
    
	switch(notify_type){
		case GMAC_PHY_PLUGIN:
			printk("gmac phy plugin \n");
			action = KOBJ_ADD;
			break;
		case GMAC_PHY_PLUGOUT:
			printk("gmac phy plugout \n");
			action = KOBJ_REMOVE;
			break;
		default:
			printk(KERN_WARNING "UNKWON GMAC EVENT \n");
			break;
	}
    
	if(phykobj){
		rtv = kobject_uevent_env(phykobj, action,envp_ext);
	}
	printk(KERN_WARNING "rtv:%d \n",rtv);
}

#ifndef GMAC_NO_INT
static irqreturn_t zx_phy_int_threadhandler(int irq, void *dev_id) 
{
	struct net_device* dev 		= (struct net_device*)dev_id;
	struct zx_net_dev* 	prv		= (struct zx_net_dev*)netdev_priv(dev);
	int					phy 	= prv->phy;
	volatile unsigned *gmac 	= (unsigned*)dev->base_addr;
	unsigned int	 		val , nphy, i;
	unsigned int	 link_in_count = 0;
	unsigned int	 link_out_count  = 0;
	unsigned  plug_flag;

	if(phy_port_state == eLINK_ON)
	{
		wake_lock(&wlock_PHY);
		phy_notify_up(GMAC_PHY_PLUGIN, NULL);
		phy_plug = 1;
	}
	else 
	{
		wake_unlock(&wlock_PHY);
		phy_notify_up(GMAC_PHY_PLUGOUT, NULL); 
		phy_plug = 0;
	} 
	
   return IRQ_HANDLED;
}
static irqreturn_t zx_phy_int(int irq, void *dev_id)
{
       int_count++;
	struct net_device* dev 		= (struct net_device*)dev_id;
	struct zx_net_dev* 	prv		= (struct zx_net_dev*)netdev_priv(dev);
       unsigned int rdata;
       unsigned int phynum = 0;  
#ifdef CONFIG_ARCH_ZX297520V2
       pcu_int_clear(PCU_EX6_INT);
#elif CONFIG_ARCH_ZX297520V3
       pcu_int_clear(PCU_GMACPHY_INT);
#endif
       prv->ext_int_event   = gmac_mii_read(dev, prv->phy, INT_SR)&INT_SR_LINK_INT; 
       phy_port_state   = gmac_phy_link_status(dev);
	return   IRQ_WAKE_THREAD;
}
#endif
// 豸
int zx_gmac_phy_open(struct net_device *dev)
{
    struct zx_net_dev* prv	= (struct zx_net_dev*)netdev_priv(dev);
#ifdef CONFIG_PHY_TIMER_SET
    init_timer(&prv->timer);
    prv->timer.expires 		= jiffies + HZ;
    prv->timer.data 		= (unsigned long)dev;
    prv->timer.function 	= &zx_net_phy_timer;
    add_timer(&prv->timer);
#endif
    return 0;
}

// ر豸
int zx_gmac_phy_stop(struct net_device *dev)
{
    struct zx_net_dev* prv = (struct zx_net_dev*)netdev_priv(dev);
#ifdef CONFIG_PHY_TIMER_SET
    del_timer_sync(&prv->timer);
#endif 
	wake_unlock(&wlock_PHY);

    return 0;
}

int zx_gmac_phy_release(struct net_device *dev)
{
    struct zx_net_dev* prv = (struct zx_net_dev*)netdev_priv(dev);
	printk("[gmac phy: release!]\n");
#ifndef GMAC_NO_INT
	del_timer_sync(&phy_timer);	
#endif
#ifdef CONFIG_ARCH_ZX297520V2
	gpio_free(ZX29_GPIO_56);
#elif CONFIG_ARCH_ZX297520V3
	gpio_free(ZX29_GPIO_64);
#endif
	free_irq(prv->ext_irq,dev); 
	wake_unlock(&wlock_PHY);
	wake_lock_destroy(&wlock_PHY);
	kobj_gmac_del(NULL);

    return 0;
}


//KOBJ ADD BY LYL
static struct attribute gmac_plug_attr =
{
        .name = "eth_state",
        .mode = S_IRWXUGO,
};

static struct attribute *gmac_status_attrs[] =
{
       &gmac_plug_attr,
       NULL,
};
ssize_t kobj_gmac_show(struct kobject *kobject,struct attribute *attr,char *buf)
{
    unsigned  link =0;
#if 1
sprintf(buf, "%s","0");//phy_off);

#else
	link	= gmac_phy_link_status(gmac_net_dev);
	printk("attrname: %s.\n",attr->name);
	if(!strcmp(attr->name, GMAC_PHY_PLUG_NAME)){
		if(link){
		    sprintf(buf, "%s","1");//phy_on);
		}else {
		    sprintf(buf, "%s","0");//phy_off);
		}                 		
	}
#endif
	return strlen(buf);
}
ssize_t kobj_gmac_store(struct kobject *kobject,struct attribute *attr, const char *buf,size_t size)
{
	unsigned int value = 0;
	value = simple_strtoul(buf, NULL, 4);
	printk("attrname: %s.\n",attr->name);
	if(!strcmp(attr->name,GMAC_PHY_PLUG_NAME)){
		phy_plug = value;
	}
	return size;
}
static struct sysfs_ops obj_gmac_sysops =
{
        .show = kobj_gmac_show,
        .store = kobj_gmac_store,        
};

static void kobj_gmac_release(struct kobject *kobject)
{
	printk("[gmac kobj_test: release!]\n");
}

static void kobj_gmac_del(struct kobject *kobject)
{
#if 1
	kset_unregister(kset_gmac);

	kobject_uevent(gmackobj, KOBJ_REMOVE);
	kobject_del(gmackobj);
	kobject_put(gmackobj);

	kobject_uevent(phykobj, KOBJ_REMOVE);
	kobject_del(phykobj);
	kobject_put(phykobj);

	kfree(phykobj);
	kfree(gmackobj);
#endif
	printk("[gmac kobj_test: delete!]\n");
}


static struct kobj_type gmacktype =
{       .release = kobj_gmac_release,
        .sysfs_ops = &obj_gmac_sysops,
        .default_attrs = gmac_status_attrs,
};
static int kset_filter(struct kset *kset,struct kobject *kobj)
{
        printk("kset Filter: kobj %s.\n",kobj->name);
        return 1;
}
static const char *kset_name(struct kset *kset,struct kobject *kobj)
{    
        static char buf[20];
        printk("Name:  kobj %s.\n",kobj->name);
        sprintf(buf,"%s","gmac");
        return buf;
}
static int kset_uevent(struct kset *kset,struct kobject *kobj, struct kobj_uevent_env *env)
{
        int i = 0;
        printk("uevent: kobj %s.\n",kobj->name);
        while(i < env->envp_idx)
        {
        printk("%s.\n",env->envp[i]);
         i ++;
         }
         return 0;
}
static struct kset_uevent_ops gmac_uevent_ops =
{
        .filter = kset_filter,
        .name = kset_name,
        .uevent = kset_uevent,
};
static int  kset_gmac_init(void)
{
         int ret = 0;
         /* ע kset_p */   
         gmackobj = kzalloc(sizeof(*gmackobj),GFP_KERNEL);
         if(!gmackobj){
            printk(KERN_WARNING "mallock gmackobj failed \n");
            return 0;
         }
         kobject_init(gmackobj, &gmacktype);
         kobject_add(gmackobj,kernel_kobj,"%s","eth_debug");  
         kset_gmac = kset_create_and_add("gmac", &gmac_uevent_ops, NULL); 
         
         phykobj = kzalloc(sizeof(*phykobj),GFP_KERNEL);
         if(!phykobj){
       	printk(KERN_WARNING "mallock phykobj failed \n");
    	  return 0;
         }
         kobject_init(phykobj, &gmacktype);
         kobject_add(phykobj,&kset_gmac->kobj,"%s","gmacconfig");
         phykobj->kset = kset_gmac;
         return ret;
}
#if 0
void gmac_kick_plug_thread(void)
{
    int int_event = 0;
    struct zx_net_dev* 	prv		= (struct zx_net_dev*)netdev_priv(g_gmac_phy_dev);
  //  if (phy_init_state = 1)
  //  {
        int_event        = gmac_mii_read(g_gmac_phy_dev, prv->phy, INT_SR)&INT_SR_LINK_INT; 
        phy_port_state   = gmac_phy_link_status(g_gmac_phy_dev);
      // if(!test_and_set_bit(1, &gmac_plug_sema_up_flag))
  //  printk("gaohf:kick_plug ,phy_plug=%d,phy_port_state=%d\n",phy_plug,phy_port_state);
        if (g_mac_phy_state != phy_port_state )
        {
            g_mac_phy_state = phy_port_state;
            up(&gmac_plug_thread_sema);
        }
  //  }
}

void zx_gmac_plug_thread(unsigned long dev_id)
{
	struct net_device* dev 		= (struct net_device*)dev_id;
	struct zx_net_dev* 	prv		= (struct zx_net_dev*)netdev_priv(dev);
	int					phy 	= prv->phy;
	volatile unsigned *gmac 	= (unsigned*)dev->base_addr;
	unsigned int	 		val , nphy, i;
	unsigned int	 link_in_count = 0;
	unsigned int	 link_out_count  = 0;
	unsigned  plug_flag;

	while (!kthread_should_stop()){
		down(&gmac_plug_thread_sema);
    	if(phy_port_state == eLINK_ON)
    	{
    		wake_lock(&wlock_PHY);
    		phy_notify_up(GMAC_PHY_PLUGIN, NULL);
    		phy_plug = eLINK_ON;
            printk("gaohf GMAC PHY_PLUGIN \n");
    	}
    	else 
    	{
    		wake_unlock(&wlock_PHY);
    		phy_notify_up(GMAC_PHY_PLUGOUT, NULL); 
    		phy_plug = eLINK_OFF;
            printk("gaohf GMAC PHY_PLUGOUT \n");
    	} 
	}
}
#endif

#ifdef GMAC_NO_INT
void zx_gmac_plug_thread_ms(unsigned long dev_id)
{
	struct net_device *dev = (struct net_device*)dev_id;
	struct zx_net_dev *prv = (struct zx_net_dev*)netdev_priv(dev);
    int          int_event = 0;
    
	while (!kthread_should_stop()){
        int_event        = gmac_mii_read(g_gmac_phy_dev, prv->phy, INT_SR)&INT_SR_LINK_INT; 
        phy_port_state   = gmac_phy_link_status(g_gmac_phy_dev);
        if (g_mac_phy_state != phy_port_state )
        {
            g_mac_phy_state = phy_port_state;
        	if(phy_port_state == eLINK_ON)
        	{
        		wake_lock(&wlock_PHY);
        		phy_notify_up(GMAC_PHY_PLUGIN, NULL);
        		phy_plug = eLINK_ON;
				prv->link = eLINK_ON;
                printk("gaohf GMAC PHY_PLUGIN \n");
        	}
        	else 
        	{
        		wake_unlock(&wlock_PHY);
        		phy_notify_up(GMAC_PHY_PLUGOUT, NULL); 
        		phy_plug = eLINK_OFF;
				prv->link =  eLINK_OFF;
                printk("gaohf GMAC PHY_PLUGOUT \n");
        	} 
        }
        msleep(1000);
	}
}
#endif

int  zx_gmac_phy_init(struct net_device *dev)
{  
         int	ret = 0;
         struct zx_net_dev* prv = (struct zx_net_dev*)netdev_priv(dev);

         kset_gmac_init();	  
         ret = gmac_phy_init(dev);
         if( ret <0 )   
         {
              printk(KERN_INFO "TSP zx29 gmac can not find phy\n");
              return 1  ;
         }
         phy_init_state = 1;
         return 0;
}

