/*******************************************************************************
* Ȩ (C)2011, ͨѶɷ޹˾ 
*
* ļ:	zx_gmac.c
* ļʶ:
* ժҪ: sanchips Serial GMAC  
* ˵:	ϵͳʹù̶ӳ䣬ԴлȡĵַΪַioremap
*			ϵͳʹö̬ӳ䣬޸probe޶ַӳ 
* ǰ汾:	1.1
* :	 
* : 2011-8-1
*
* ޸ļ¼1
* ޸:
* 汾:
* ޸ġ:
* ޸:
*
*******************************************************************************/
#include "rtl8306e_types.h"
#include "rtl8306e_asicdrv.h"
#include "rtk_api.h"
#include "../zx_gmac.h"

#include <mach/highspeed_debug.h>
/*-----------------------------------------------------------------------------------
* 궨
------------------------------------------------------------------------------*/
//#define   CONFIG_SWITCH_TIMER_SET
#define GMAC_NO_INT

#define   SWITCH_PORT_NUM  	   5	
#define   GMAC_PLUG_NAME    "eth_state"
#define   SWITCH_CTL_MAC     SWITCH_PORT_NUM+1  
#define   SWITCH_WAN_PORT   RTL8306_PORT4

typedef enum{
     GMAC_SWITCH_WAN_PLUGIN = 0,
     GMAC_SWITCH_WAN_PLUGOUT,
     GMAC_SWITCH_LAN_PLUGIN,
     GMAC_SWITCH_LAN_PLUGOUT,
     GMAC_SWITCH_NUM,
}switch_notify_event;
/****************************************************************************
* 	                               Global Variables
****************************************************************************/
struct kset *kset_gmac;
//struct kset kset_c;
struct kobject *gmackobj = NULL;
struct kobject *gmac_switchkobj = NULL;

static unsigned int wan_plug = 0;
static unsigned int lan_plug = 0;
static unsigned int wan_lan_plug = 0;
static unsigned int switch_init_state = 0;

static char   wan_on_lan_off[] ="wan_on_lan_off";
static char  wan_off_lan_on[] ="wan_off_lan_on";
static char  wan_lan_on[]="wan_lan_on";
static char  wan_lan_off[]="wan_lan_off";
static char  switch_init_invalid[]="invalid";
static unsigned long switch_init_time_start = 0;
static unsigned long switch_init_time_now = 0;
static unsigned int switch_init_flag = 1;

extern struct net_device* 	gmac_net_dev;
extern struct zx_net_dev* 	gmac_net_dev_prv;
#ifdef GMAC_NO_INT
static E_LINK_STATE g_switch_port_state[SWITCH_PORT_NUM]= {0};
#endif

/*------------------------------------------------------------------------------
* Ϊõⲿӿ
* 
* 
------------------------------------------------------------------------------*/
extern rtk_api_ret_t rtk_port_macForceLinkExt0_set(rtk_mode_ext_t mode, rtk_port_mac_ability_t *pPortability);
extern rtk_api_ret_t rtk_vlan_get(rtk_vlan_t vid, rtk_portmask_t *pMbrmsk, rtk_portmask_t *pUntagmsk, rtk_fid_t *pFid);
extern rtk_api_ret_t rtk_vlan_portPvid_get(rtk_port_t port, rtk_vlan_t *pPvid, rtk_pri_t *pPriority);
extern rtk_api_ret_t rtk_vlan_init(void);
extern rtk_api_ret_t rtk_vlan_portPvid_set(rtk_port_t port, rtk_vlan_t pvid, rtk_pri_t priority);
extern rtk_api_ret_t rtk_vlan_set(rtk_vlan_t vid, rtk_portmask_t mbrmsk, rtk_portmask_t untagmsk, rtk_fid_t fid);
extern rtk_api_ret_t rtk_vlan_portAcceptFrameType_set(rtk_port_t port, rtk_vlan_acceptFrameType_t accept_frame_type);
extern rtk_api_ret_t rtk_vlan_destroy(rtk_vlan_t vid);
extern int32 rtl8306e_vlan_portBase_set();
extern int gmac_mii_read(struct net_device *dev, int phy, int reg);
extern void gmac_mii_write(struct net_device *dev, int phy, int reg, int val);
#ifdef GMAC_NO_INT
//void zx_gmac_plug_thread(unsigned long dev_id);
void zx_gmac_plug_thread_ms(unsigned long dev_id);
#endif
/*------------------------------------------------------------------------------
* Ϊ
* 
* 
------------------------------------------------------------------------------*/
 static E_LINK_STATE switch_port_state[SWITCH_PORT_NUM]={0};

void switch_notify_up(gmac_notify_event notify_type, void* puf)
{
	unsigned char buf[100];
	int rtv = -1;
	enum kobject_action action;
	char*envp_ext_sw0_wan[] = {"GMACEVENT=gmac_sw0_wan",NULL}; 
	char*envp_ext_sw0_lan[] = {"GMACEVENT=gmac_sw0_lan",NULL}; 
	switch(notify_type){
		case GMAC_SWITCH_WAN_PLUGIN:
			gmac_printk("gmac sw0 wan plugin \n");
//			strcpy(envp_ext[0],"GMACEVENT=gmac_sw0_wan");
			action = KOBJ_ADD;
			if(gmac_switchkobj){
				rtv = kobject_uevent_env(gmac_switchkobj, action,envp_ext_sw0_wan);
			}			
			break;

		case GMAC_SWITCH_WAN_PLUGOUT:
			gmac_printk("gmac sw0 wan plugout \n");
		//	strcpy(envp_ext[0],"GMACEVENT=gmac_sw0_wan");
			action = KOBJ_REMOVE;
			if(gmac_switchkobj){
				rtv = kobject_uevent_env(gmac_switchkobj, action,envp_ext_sw0_wan);
			}			
			break;

		case GMAC_SWITCH_LAN_PLUGIN:
			gmac_printk("gmac sw0 lan plugin \n");
		//	strcpy(envp_ext[0],"GMACEVENT=gmac_sw0_lan");
			action = KOBJ_ADD;
			if(gmac_switchkobj){
				rtv = kobject_uevent_env(gmac_switchkobj, action,envp_ext_sw0_lan);
			}			
			break;
		case GMAC_SWITCH_LAN_PLUGOUT:
			gmac_printk("gmac sw0 lan plugout\n");
			//strcpy(envp_ext[0],"GMACEVENT=gmac_sw0_lan");
			action = KOBJ_REMOVE;
			if(gmac_switchkobj){
				rtv = kobject_uevent_env(gmac_switchkobj, action,envp_ext_sw0_lan);
			}			
			break;
		default:
			gmac_printk("UNKWON GMAC EVENT \n");
			break;
	}


	gmac_printk("rtv:%d \n",rtv);
}
void rtl8306e_all_port_state_get()
{
    int i = 0;
    uint32 val = 0;
     for(i= RTL8306_PORT0 ;i<RTL8306_PORT5;i++)
       {
            rtl8306e_port_phyLinkStatus_get(i,&val);   
            if(val)
            { 
               if(i != RTL8306_PORT4)     lan_plug = 1;
               else                                wan_plug = 1;
            }     
      }

     if(lan_plug && wan_plug)
     {
           wan_lan_plug = 1;
     }
    
}

int smiRead(int phyad, int regad,int * data)
{
	*data = gmac_mii_read(gmac_net_dev, phyad, regad);	
	return 1;
}

int smiWrite(int phyad, int regad, int data)
{
	gmac_mii_write(gmac_net_dev, phyad, regad, data);
	return 1;
}

void zx_net_switch_notify(unsigned long dev_id)
{
    struct net_device* dev 		= (struct net_device*)dev_id;
    struct zx_net_dev* prv 	= (struct zx_net_dev*)netdev_priv(dev);
    volatile unsigned *gmac 	= (unsigned*)dev->base_addr;
    uint32	 		val , nphy, i;
    uint32	 link_in_count = 0;
    uint32	 link_out_count  = 0;
    unsigned int events = 0;	    
	
    while(1)
    {
        down(&prv->phy_sem);
        events	= prv->ext_int_event;	
        
        for(i= RTL8306_PORT0 ;i<RTL8306_PORT5;i++)
        {
            // if(events &(0x1<<i))       //port0 -4 link  state
            nphy = i;
            if(nphy == SWITCH_WAN_PORT)  //wan
            {
                if(switch_port_state[nphy]&& (events &(0x1<<4))) //in
                {
                    gmac_printk("wan in !\n");
                    switch_notify_up(GMAC_SWITCH_WAN_PLUGIN, NULL);
                    wan_plug = 1;
                }
                else if(events &(0x1<<4)) //out
                {
                    gmac_printk("wan out !\n");
                    switch_notify_up(GMAC_SWITCH_WAN_PLUGOUT, NULL); 
                    wan_plug = 0;
                }
            }	 
            else if((events &(0x1<<0))|| (events &(0x1<<1))|| (events &(0x1<<2))|| (events &(0x1<<3)))//lan
            {                
                if(switch_port_state[nphy]) //in
                {    	   
                    link_in_count++;
                    gmac_printk("the value of  link_in_count is = %d  !\n",link_in_count);
                }
                else  //out
                {
                    link_out_count++;	
                    gmac_printk("the value of  link_out_count is = %d  !\n",link_out_count);  
                }
            }
            if(((events &(0x1<<0))&&switch_port_state[0] )|| ((events &(0x1<<1))&&switch_port_state[1] ) || ((events &(0x1<<2))&&switch_port_state[2] ) || ((events &(0x1<<3))&&switch_port_state[3] ))
            {
                if((nphy == RTL8306_PORT4) && (link_in_count == 1))
                {
                    gmac_printk("lan in !\n");
                    switch_notify_up(GMAC_SWITCH_LAN_PLUGIN, NULL);    
                    lan_plug = 1;
                }
            }
            if((nphy == RTL8306_PORT4)&& (link_out_count == 4))
            {
                gmac_printk("lan out !\n");
                switch_notify_up(GMAC_SWITCH_LAN_PLUGOUT, NULL);     
                lan_plug = 0;
            }	   
                
            if(i == RTL8306_PORT4)
            {
                link_in_count =0;
                link_out_count=0;
            }              							
        }
    }
}
E_LINK_STATE gmac_switch_linked(struct net_device *dev)
{
    unsigned int  rdata = 0;
    rtl8306e_port_phyLinkStatus_get(SWITCH_CTL_MAC,&rdata);  
    return rdata;
}
#if 0
static E_LINK_STATE switch_linked(struct net_device *dev)
{
	struct zx_net_dev* 	prv		= (struct zx_net_dev*)netdev_priv(dev);
       short unsigned	       val         =  0;
       /*switch page 0*/
       val  = mii_read(dev,0, 16); 
       val  = (val & 0x7FFF) | 0x0002;
       mii_write(dev,0,16,val);
        /*read phy 6 reg 0  ,get link states*/
       val = mii_read(dev,6,1);
       
       return (val >> 2) & 0x01;
} 
#endif
#ifdef GMAC_NO_INT
void zx_gmac_plug_thread_ms(unsigned long dev_id)
{
	struct net_device *dev = (struct net_device*)dev_id;
	struct zx_net_dev *prv = (struct zx_net_dev*)netdev_priv(dev);
    int          int_event = 0;
    uint32       rdata     = 0;
    uint32       phynum    = 0;
    int          i         = 0;
    int       state_change = 0;
	while (!kthread_should_stop()){
        rtl8306e_reg_get(4, 22, 3, &rdata);
        prv->ext_int_event = rdata;

        for(phynum = 0;phynum<RTL8306_PORT5;phynum++)
        {
            rdata = 0;
            rtl8306e_port_phyLinkStatus_get(phynum,&rdata);   
            switch_port_state[phynum] = rdata;

            if( g_switch_port_state[phynum] != switch_port_state[phynum] )
            {
                g_switch_port_state[phynum] = switch_port_state[phynum];
                state_change = 1;
            }
        }
        
        if (state_change == 1)
        {
            state_change = 0;
            up(&prv->phy_sem);
        }
        
        msleep(1000);
	}
}
#else
#ifdef CONFIG_SWITCH_TIMER_SET
// ڶʱ
static void zx_net_switch_timer(unsigned long data)
{
    	struct net_device* 	dev		= (struct net_device*)data;
	struct zx_net_dev* 	prv		= (struct zx_net_dev*)netdev_priv(dev);
	volatile unsigned 	*gmac 	= (unsigned*)dev->base_addr;
	int					phy 	= prv->phy;
	unsigned 			temp_val;
       uint32   val = 0;
       
       spin_lock_irq(&prv->phy_lock);
       rtl8306e_port_phyLinkStatus_get(SWITCH_CTL_MAC,&val);    

       if(val)
        {
                if(!netif_carrier_ok(dev))	netif_carrier_on(dev);
	}
	else													// PHY δ
	{
		if(netif_carrier_ok(dev))	netif_carrier_off(dev);
	}

	prv->link 					= val;
	prv->timer.expires 			= jiffies + HZ;				// ´ζʱ1sʼ

	spin_unlock_irq(&prv->phy_lock);
	
	add_timer(&prv->timer);
}

#else 
// PHY жϴ
static irqreturn_t zx_switch_int(int irq, void *dev_id)
{
	struct net_device* dev 		= (struct net_device*)dev_id;
	struct zx_net_dev* 	prv		= (struct zx_net_dev*)netdev_priv(dev);
       uint32 rdata;
       uint32 phynum = 0;
       
#ifdef CONFIG_ARCH_ZX297520V2  
			pcu_int_clear(PCU_EX6_INT);
#elif CONFIG_ARCH_ZX297520V3
       pcu_int_clear(PCU_GMACPHY_INT);
#endif
     //  phy_count++;
       rtl8306e_reg_get(4, 22, 3, &rdata);
   

        prv->ext_int_event = rdata;

        for(phynum = 0;phynum<RTL8306_PORT5;phynum++)
        {
            rdata = 0;
            rtl8306e_port_phyLinkStatus_get(phynum,&rdata);   
            switch_port_state[phynum] = rdata;    
        }

        up(&prv->phy_sem);
        
	return IRQ_HANDLED;
}
#endif
#endif

// 豸
int zx_gmac_switch_open(struct net_device *dev)
{
    int ret;
    struct zx_net_dev* prv	= (struct zx_net_dev*)netdev_priv(dev);
    uint32 rdata = 0;
    int ext_int6_no = 0;

    
    prv->link 		= gmac_switch_linked(dev);  
    
#ifdef CONFIG_SWITCH_TIMER_SET
    init_timer(&prv->timer);
    prv->timer.expires 		= jiffies + HZ;
    prv->timer.data 		= (unsigned long)dev;
    prv->timer.function 	= &zx_net_switch_timer;
    add_timer(&prv->timer);   
 #endif
    return 0;
}

// ر豸
int zx_gmac_switch_stop(struct net_device *dev)
{
    unsigned long       flags = 0;

    struct zx_net_dev* prv = (struct zx_net_dev*)netdev_priv(dev);

#ifdef CONFIG_SWITCH_TIMER_SET    
       del_timer_sync(&prv->timer);
#else
	gpio_free(ZX29_GPIO_64);
	free_irq(prv->ext_irq,dev); 
#endif

    return 0;
}

static struct attribute gmac_plug_attr =
{
        .name = "eth_state",
        .mode = S_IRWXUGO,
};

static struct attribute *gmac_status_attrs[] =
{
       &gmac_plug_attr,
       NULL,
};

ssize_t kobj_gmac_show(struct kobject *kobject,struct attribute *attr,char *buf)
{
        uint32 phynum = 0;
        uint32 phyon_num = 6;
	 uint32 rdata = 0;
        for(phynum = 0;phynum<RTL8306_PORT5;phynum++)
        {
               rtl8306e_port_phyLinkStatus_get(phynum,&rdata);   
		 switch_port_state[phynum] = rdata;
		 if (switch_port_state[phynum] == 1)
		{
		     phyon_num = phynum;
		     break;
		}        
         }
         gmac_printk("attrname: %s.\n",attr->name);		 
	  if(!strcmp(attr->name, GMAC_PLUG_NAME)){

		 if(phyon_num != 6)
		   {
		      rtl8306e_all_port_state_get();
                   if(wan_plug&&lan_plug)
                   {
                       sprintf(buf, "%s",wan_lan_on);
                   }
                   else if(wan_plug)
                   {
                       sprintf(buf, "%s",wan_on_lan_off);
                    }
                    else if(lan_plug)
                    {
                       sprintf(buf, "%s",wan_off_lan_on);
                     }
                     else 
                     {
                        sprintf(buf, "%s",wan_lan_off);
                     }  
		       return strlen(buf);
		 }
		 else
		 {
                   sprintf(buf, "%s",wan_lan_off);
		     return strlen(buf);
	        }		          
	    }
      return strlen(buf);
}
ssize_t kobj_gmac_store(struct kobject *kobject,struct attribute *attr, const char *buf,size_t size)
{
	unsigned int value = 0;
	value = simple_strtoul(buf, NULL, 4);
	gmac_printk("attrname: %s.\n",attr->name);
	if(!strcmp(attr->name,GMAC_PLUG_NAME)){
		wan_plug = value;
	}
	return size;
}
static struct sysfs_ops obj_gmac_sysops =
{
        .show = kobj_gmac_show,
        .store = kobj_gmac_store,        
};

void obj_gmac_release(struct kobject *kobject)
{
	gmac_printk("[kobj_test: release!]\n");
}

static struct kobj_type gmacktype =

{       .release = obj_gmac_release,
        .sysfs_ops = &obj_gmac_sysops,
        .default_attrs = gmac_status_attrs,
};
static int kset_filter(struct kset *kset,struct kobject *kobj)
{
   gmac_printk("kset Filter: kobj %s.\n",kobj->name);
     return 1;
}

static const char *kset_name(struct kset *kset,struct kobject *kobj)
{    
       static char buf[20];
       gmac_printk("Name:  kobj %s.\n",kobj->name);
       sprintf(buf,"%s","gmac");
       return buf;
}

static int kset_uevent(struct kset *kset,struct kobject *kobj, struct kobj_uevent_env *env)
{
   int i = 0;
    gmac_printk("uevent: kobj %s.\n",kobj->name);

   while(i < env->envp_idx)
    {
        gmac_printk("%s.\n",env->envp[i]);
       i ++;
    }

    return 0;
}

static struct kset_uevent_ops gmac_uevent_ops =
{
    .filter = kset_filter,
    .name = kset_name,
    .uevent = kset_uevent,
};

static int  kset_gmac_init(void)
{
  int ret = 0;
  
   gmac_printk("kobject  init!\n");
   /* ע kset_p */
   
     gmackobj = kzalloc(sizeof(*gmackobj),GFP_KERNEL);
   if(!gmackobj){
        printk(KERN_WARNING "mallock gmackobj failed \n");
        return 0;
    }
   kobject_init(gmackobj, &gmacktype);
   kobject_add(gmackobj,kernel_kobj,"%s","eth_debug");
   
    gmac_printk("kset test init!\n");
   kset_gmac = kset_create_and_add("gmac", &gmac_uevent_ops, NULL); 

   gmac_switchkobj = kzalloc(sizeof(*gmac_switchkobj),GFP_KERNEL);
   if(!gmac_switchkobj){
   	printk(KERN_WARNING "mallock gmac_switchkobj failed \n");
	return 0;
     }
    kobject_init(gmac_switchkobj, &gmacktype);
    kobject_add(gmac_switchkobj,&kset_gmac->kobj,"%s","gmacconfig");
    gmac_switchkobj->kset = kset_gmac;

   return ret;
}

int  zx_gmac_switch_init(struct net_device *dev)
{
    int	ret = 0;
    rtk_mode_ext_t  Mode;
    rtk_port_mac_ability_t portAbility;
    uint32 rdata = 0;
    int ext_int6_no = 0;
	int a;
    struct zx_net_dev* prv	= (struct zx_net_dev*)netdev_priv(dev);
   //reset
   rtl8306e_regbit_set(1, 0, 15, 0, 1);
   
   while (a == 1)
   	{
    rtl8306e_regbit_get(1, 0, 15, 0, &a);
   }
   
    /*enable interrupt*/
    rtl8306e_regbit_set(2, 22, 15, 3, 0);
    /*mask interrupt phy 0-5 */
    rtl8306e_reg_get(4, 23, 3, &rdata);
    //rdata |= 0x5f;
    rdata |= 0x1f;
    rtl8306e_reg_set(4, 23, 3, rdata); 

    sema_init(&prv->phy_sem,0);

#ifdef GMAC_NO_INT
    kthread_run(zx_gmac_plug_thread_ms, (unsigned long)dev, "gmac_switch/%s", "plug");
#else
#ifdef CONFIG_ARCH_ZX297520V2  
    ret = gpio_request(ZX29_GPIO_56, "ext_int6");
    if (ret) 
    {
    	gmac_printk("reset gpio6  request error.\n");
    	return ret;
    }
    zx29_gpio_pd_pu_set(ZX29_GPIO_56,IO_CFG_PULL_DISABLE);
	/* config as ext_int*/
    ret = zx29_gpio_config(ZX29_GPIO_56, GPIO56_EXT_INT6); 
#elif CONFIG_ARCH_ZX297520V3
    ret = gpio_request(ZX29_GPIO_64, "phy_int");
    if (ret) 
    {
    	gmac_printk("reset GPIO_64  request error.\n");
    	return ret;
    }
    zx29_gpio_pd_pu_set(ZX29_GPIO_64,IO_CFG_PULL_DISABLE);
    /* config as ext_int*/
    ret = zx29_gpio_config(ZX29_GPIO_64, GPIO64_PHY_INT); 
#endif 
    if (ret) 
    return ret;
	
    /* get int no */
    ext_int6_no = prv->ext_irq;
    gmac_printk("TSP zx29 gmac phy int no irq = %d  !\n",ext_int6_no);
//    zx29_gpio_set_inttype(ZX29_GPIO_64, IRQ_TYPE_LEVEL_HIGH);
#ifdef CONFIG_ARCH_ZX297520V2  
			pcu_int_clear(PCU_EX6_INT);
#elif CONFIG_ARCH_ZX297520V3
			pcu_int_clear(PCU_GMACPHY_INT);
#endif   
    ret = request_threaded_irq(ext_int6_no, zx_switch_int, NULL,0, dev->name, dev);
    if(ret)
    return ret;
    irq_set_irq_wake(ext_int6_no, 1);
#endif

    rtl8306e_asic_init();
     /*MAC5 force link up*/
     Mode = MODE_EXT_RMII;
     portAbility.forcemode = 1;
     portAbility.nway = 0;
     portAbility.speed = PORT_SPEED_100M;
     portAbility.link = 1;
     portAbility.duplex = PORT_FULL_DUPLEX;
     portAbility.rxpause = 1;
     portAbility.txpause = 1;

    rtk_port_macForceLinkExt0_set(Mode,&portAbility);
    prv->link = eLINK_OFF;
    rtl8306e_vlan_portBase_set();	
   
     switch_init_state = 1;
     kset_gmac_init();
	 
#ifndef CONFIG_SWITCH_TIMER_SET
	  
    prv->switch_thread = kthread_run(zx_net_switch_notify, dev, "eth_sw0_thread");
    if (IS_ERR(prv->switch_thread) )
    {
        prv->switch_thread = NULL;
        gmac_printk("[%s] create switch_thread fail\n", __FUNCTION__);
	 return 1;	 
    }
#endif
    return ret;
}

