/*******************************************************************************
* Ȩ (C)2011, ͨѶɷ޹˾ 
*
* ļ:	zx_gmac.c
* ļʶ:
* ժҪ: sanchips Serial GMAC  
* ˵:	ϵͳʹù̶ӳ䣬ԴлȡĵַΪַioremap
*			ϵͳʹö̬ӳ䣬޸probe޶ַӳ 
* ǰ汾:	1.1
* :	 
* : 2011-8-1
*
* ޸ļ¼1
* ޸:
* 汾:
* ޸ġ:
* ޸:
*
*******************************************************************************/
#include <linux/gmac/gmac.h>
#include "zx_gmac.h"
#include <mach/highspeed_debug.h>
/*-----------------------------------------------------------------------------------
* 
------------------------------------------------------------------------------*/
#define	LOG_TAG						"GMAC"

#define DEV_NAME					"GMAC"
#define  GMAC_NO_INT

#ifdef GMAC_NO_INT
#define GTIMER_INTERVAL  2000
#endif
/****************************************************************************
* 	                               Global Variables
****************************************************************************/
struct wake_lock gmac_wake_lock;
u8 gmac_addr[MAC_ADDR_LENTH] = {0xec,0x1d,0x7f,0xb0,0x2f,0x32};
struct net_device* 	gmac_net_dev = NULL;
struct zx_net_dev* 	gmac_net_dev_prv= NULL;

static     char  *gmac_switch_name = "sw";
static     char  *gmac_phy_name = "eth";

char* dma_tx_vir_bak = NULL;
unsigned	dma_rx_phy_bak= 0;	
volatile unsigned	*g_gmac = NULL;
struct tasklet_struct	*g_gmac_tasklet = NULL;
 struct zx_net_dev	*g_gmac_dev = NULL;
/*------------------------------------------------------------------------------
* Ϊõⲿӿ
* 
* 
------------------------------------------------------------------------------*/
extern void readreg();
extern void invalid_cache(unsigned char *data,int len);
extern void clean_cache(unsigned char *data,int len);
extern unsigned long  virtaddr_to_phys(unsigned long virt);
extern unsigned long  physaddr_to_virt(unsigned long phys);
extern int nand_NvRead(int dwStart, int dwLen, char* to);
extern int nand_NvProgram(int dwStart, int dwLen, char* from);
#ifdef CONFIG_NET_ZX29_GMAC_SWITCH
extern int zx_gmac_switch_open(struct net_device *dev);
extern int zx_gmac_switch_stop(struct net_device *dev);
extern int  zx_gmac_switch_init(struct net_device *dev);
extern int zx_gmac_switch_release(struct net_device *dev);
E_LINK_STATE gmac_switch_linked(struct net_device *dev);
#endif
#ifdef CONFIG_NET_ZX29_GMAC_PHY
extern int zx_gmac_phy_open(struct net_device *dev);
extern int zx_gmac_phy_stop(struct net_device *dev);
extern int  zx_gmac_phy_init(struct net_device *dev);
E_LINK_STATE gmac_phy_link_status(struct net_device *dev);
extern int zx_gmac_phy_release(struct net_device *dev);
#endif
extern void gmac_kick_plug_thread(void);

#ifdef GMAC_NO_INT
static void gmac_start_timer(void);
static int gmac_stop_timer(void);
#endif
/*------------------------------------------------------------------------------
* Ϊ
* 
* 
------------------------------------------------------------------------------*/

int gmac_mii_read(struct net_device *dev, int phy, int reg)
{
	unsigned long flags;
    volatile unsigned 	*gmac 	= (unsigned*)dev->base_addr;
    struct zx_net_dev	*prv 	= (struct zx_net_dev*)netdev_priv(dev);

    unsigned val	= ( 1 	        << 0 	|		// busy λ
    				     0 		 << 1 	|		// R/Wָʾλ
    				    PHY_CLOCK	<< 2)	|		// ʱλ
    				    (reg & 0x1F)     << 6	       |		// Ĵ
    				    (phy & 0x1F)     << 11;			// оƬ

spin_lock_irqsave(&prv->lock,flags);
    while(mac_mii_is_busy());
    MAC(0x0010)		= val;
spin_unlock_irqrestore(&prv->lock,flags);

    while(mac_mii_is_busy());

    return (MAC(0x0014) & 0xFFFF);
}

void gmac_mii_write(struct net_device *dev, int phy, int reg, int val)
{
	volatile unsigned 	*gmac	= (unsigned*)dev->base_addr;
	struct zx_net_dev	*prv 	= (struct zx_net_dev*)netdev_priv(dev);

	unsigned data	= ( 1 	<< 0 	|		// busy λ
					     1 	<< 1 	|		// R/Wָʾλ
					    PHY_CLOCK	<< 2)	|		// ʱλ
					    (reg & 0x1F)     << 6	|		// Ĵ
					    (phy & 0x1F)    << 11;			// оƬ

	spin_lock_irq(&prv->lock);

	while(mac_mii_is_busy());
	MAC(0x0014)		= val;
	MAC(0x0010)		= data;

	spin_unlock_irq(&prv->lock);

	while(mac_mii_is_busy());
}

void gmac_set_speed_duplex(struct net_device *dev, E_SPEED speed, E_DUPLEX duplex)
{
    unsigned			val;
    struct zx_net_dev* 	prv 	= (struct zx_net_dev*)netdev_priv(dev);
    int					phy 	= prv->phy;
    volatile unsigned 	*gmac 	= (unsigned*)dev->base_addr;

    val = MAC(0x0000) | 1<<11 | 1<<14;  // ĬΪ100Mȫ˫
    if(eSPEED_10M == speed)
    {
        val &= ~(1 << 14);                  // 10M
    }
    if(eDUPLEX_HALF == duplex)
    {
        val &= (~(1 << 11));                    // ˫
        val |= (1 << 16);
    }
    MAC(0x0000) = val;
}



static void mac_init(struct net_device *dev)
{
    volatile unsigned *gmac = (unsigned*)dev->base_addr;
    unsigned int i=0, j=0, mac_rst=0;

    mac_provide_clock();
#ifdef __DEAD_LOOP_POLL__                       //////ܻѭ޷˳ں˳ʼ޷/////////
    mac_reset();  								// λ
    mac_set_gmii_mode();						// MIIӿ
    mac_wait_reset_finished();
#else                                           /////޸ĴҪϸ////////
    //LOG_INFO("wait for gmac reseting");
    for(i=0; i<MAC_RESET_NUM; i++)              /////λԴ/////
    {
        mac_reset();
        mac_set_mii_mode();                 //Ϊmiiģʽ10m100m
        for(j=0; j<MAC_WAIT_TIME; j++)          /////ѯλ״̬ʱѭ10.1ms////////
        {
            printk(".");
            if(!((MAC(0x1000)) & 1))
            {
                printk("ok\n");
                mac_rst = 1;
                goto mac_reset_option;
            } 
            udelay(100);                        ////ȴ 0.1ms
        }
    }
mac_reset_option:
    if(!mac_rst)                                ////gmacmacоƬûиλɹ//////
    {
        gmac_printk("gmac reset failed!\n");
    }
#endif
    while(mac_mii_is_busy());
}

// ֹͣӲ
static void gmac_stop(void* io)
{
    volatile unsigned *gmac = (unsigned*)io;

    dma_disable();
    mac_disable();
    mac_int_disable();

    // շFIFO
    dma_clear_tx_fifo();
    dma_wait_tx_fifo_cleared();
}

// ʹӲ
static void gmac_start(void* io)
{
    volatile unsigned *gmac = (unsigned*)io;

    mac_int_enable();
    dma_enable();
    mac_enable();
}

// 
static void gmac_trig_transmit(void* io)
{
    volatile unsigned *gmac 	= (unsigned*)io;
    register unsigned status	= (MAC(0x1014) >> 20) & 0x07;
    switch(status)
    {
        case 0:		// ֹͣλֹͣ
            dma_enable();
            break;
        case 6:		// 𣻴ûߴ仺硣
            dma_continue_tx();
            break;
        case 1:		// ڽУȡ
        case 2:		// ڽУȴ״̬
        case 3:		// ڽУӷͻȡݲ͵ FIFO(TxFIFO)
        case 4:		// дʱ״̬
        case 5:		// 
        case 7:		// Уرմ
        default:
            break;
    }
}

// 
static void gmac_trig_receive(void* io)
{
    volatile unsigned *gmac 	= (unsigned*)io;
    register unsigned status	= (MAC(0x1014) >> 17) & 0x07;;
    switch(status)
    {
        case 0:		// ֹͣ
            dma_enable();
            break;
        case 4:		// 
            dma_continue_rx();
            break;
        default:
            break;
    }
}

// ӲMACַ
static inline void gmac_update_mac(struct net_device *dev)
{
    volatile unsigned *gmac = (unsigned*)dev->base_addr;
    unsigned char *mac		= (unsigned char *)(dev->dev_addr);

    MAC(0x0044)	= mac[0] | mac[1] << 8 | mac[2] << 16 | mac[3] << 24;
    MAC(0x0040) = mac[4] | mac[5] << 8;

    //LOG_INFO("MAC: %02X-%02X-%02X-%02X-%02X-%02X\n", mac[5], mac[4], mac[3], mac[2], mac[1], mac[0]);
}

/*******************************************************************************
* ù
* еMACĵ֡
* ܶಥ֡
* ܹ㲥֡
*******************************************************************************/
static void gmac_set_filter(struct net_device *dev)
{
	volatile unsigned *gmac = (unsigned*)dev->base_addr;

	MAC(0x0004)	=	(0 << 31)	|				// ֡: ù: ֡
					(1 << 10)	|				// ϣȫʹ: ʹܹϣȫ
					(0 << 9)	|				// Դַ: ر
					(3 << 6)	|				// ݵַտ֡
					(0 << 5)	|				// 㲥֡: нյĹ㲥֡
					(0 << 4)	|				// ಥ֡: жಥ֡
					(0 << 3)	|				// ԵͶಥ֡Ŀַƥ
					(0 << 2)	|				// Ϊ1ʱԽյĶಥ֡ݹϣݽĿַ
					(0 << 1)	|				// Ϊ1ʱԽյĵ֡ݹϣݽĿַ
					(0 << 0);					// ̫֡

	gmac_update_mac(dev);
}

// ȡõǰĽ
static struct bd_rx *get_rx_bd(struct net_device *dev)
{
    struct zx_net_dev* prv 		= (struct zx_net_dev*)netdev_priv(dev);
    int   n						= prv->rx_bd_offset;
    struct bd_rx *d				= (struct bd_rx*)prv->dma_rx_vir;

    if(d[n].RDES0 & DMA_OWNER) 
    {
        return 0;
    }
    else	
    {
        return &d[n];
    }
}

static inline int mod_sub(int left, int right, int mod)
{
    return (mod - right + left) % mod;
}

// ȡõǰķ
static inline struct bd_tx *get_tx_bd(struct net_device *dev)
{
    struct zx_net_dev* prv 		= (struct zx_net_dev*)netdev_priv(dev);
    int   n						= prv->tx_bd_offset;
    struct bd_tx *d				= (struct bd_tx*)prv->dma_tx_vir;
	
    if( mod_sub(prv->tx_bd_offset, prv->txed_bd, GMAC_TX_BD_NUM) > GMAC_TX_BD_NUM - 2 )  
	{
		return 0;
	}
		
    if(d[n].TDES0 & DMA_OWNER) 	
    {
        return 0;
    }
    else
    {
        return &d[n];
    }
}


// ȡѷ
static struct bd_tx *get_txed_bd(struct net_device *dev)
{
    struct bd_tx *d;
    struct zx_net_dev* prv 		= (struct zx_net_dev*)netdev_priv(dev);
    int n						= prv->txed_bd;

    d	= (struct bd_tx*)prv->dma_tx_vir;

	if(n == prv->tx_bd_offset) return 0;
	
    if(d[n].TDES0 & DMA_OWNER)	return 0;
	
	if(d[n].skb == NULL) return 0; 

    prv->txed_bd++;
    prv->txed_bd %= GMAC_TX_BD_NUM;

    return &d[n];
}

// Ӳȥʼ
static void hw_net_uninit(struct net_device *dev)
{
    int 				i;
    struct bd_rx 		*rx_bd;
	struct bd_tx 		*tx_bd;
    volatile unsigned 	*gmac	= (unsigned*)dev->base_addr;
    struct zx_net_dev	*prv	= (struct zx_net_dev*)netdev_priv(dev);

    gmac_stop((void*)dev->base_addr);

    // עrx tx һ
    if(prv->dma_rx_phy)
    {
        rx_bd   = (struct bd_rx*)prv->dma_rx_vir;

        for(i = 0; i < GMAC_RX_BD_NUM; i++)
        {
        	if(rx_bd[i].skb != NULL)
        	{        
 	           dev_kfree_skb_any(rx_bd[i].skb);
        	}
        }

		tx_bd   = (struct bd_tx*)prv->dma_tx_vir;
		
        for(i = 0; i < GMAC_TX_BD_NUM; i++)
        {
        	if(tx_bd[i].skb != NULL)
        	{
            	dev_kfree_skb_any(tx_bd[i].skb);
        	}
        }

       // dma_free_coherent(NULL, GMAC_BUF_LEN, prv->dma_rx_vir, prv->dma_rx_phy);   //ͷdma
    }

    dma_set_tx_buffer(0);   //׸BDĻΪ0
    dma_set_rx_buffer(0);

    prv->rx_bd_offset	= 0;
    prv->tx_bd_offset	= 0;
    prv->txed_bd		= 0;
    prv->dma_rx_phy		= 0;
    prv->dma_rx_vir		= 0;
    prv->dma_tx_phy		= 0;
    prv->dma_tx_vir		= 0;
}

static int gmac_init_rx_bd(struct net_device *dev, struct zx_net_dev* prv)
{
    struct sk_buff	*skb = NULL;
    struct bd_rx *rx  = (struct bd_rx *)prv->dma_rx_vir;
    int 			i = 0;	

    prv->rx_bd_offset		= 0;

	for(i = 0; i < GMAC_RX_BD_NUM; i++)
	{
		// ʼ
		// ݻΪ SKBdataΣȷӦskb
		// ڽϣGMACӲݱ󣬽skbȡ£͸Эϲ
		// ͬʱҪ·һSKBٹҵ

		skb = netdev_alloc_skb(dev, GMAC_FRAME_LEN + NET_IP_ALIGN);

		if(unlikely(!skb))
		{
		   // LOG_ERR("kmalloc memory failed\n");
			hw_net_uninit(dev);
			return -1;
		}

		skb_reserve(skb, NET_IP_ALIGN);

		rx[i].RDES0 	   |= DMA_OWNER;
		rx[i].RDES1  = 0;
		rx[i].RDES1 	   = GMAC_FRAME_LEN | 1 << 14;
		rx[i].dma_buf		= virtaddr_to_phys((unsigned)skb->data);
		rx[i].next			= prv->dma_rx_phy + ((i + 1) << 5);
		rx[i].skb			= skb;
#if 0
		if(i%4 != 0)
		{
	       rx[i].RDES1  |= 0x80000000;
		}
#endif
		dma_sync_single_for_device(&dev->dev, rx[i].dma_buf, GMAC_FRAME_LEN, DMA_TO_DEVICE);

	}

	// ´Ƕлش
	rx[GMAC_RX_BD_NUM-1].next			= prv->dma_rx_phy;
	rx[GMAC_RX_BD_NUM-1].RDES1 			= GMAC_FRAME_LEN	  | 1 << 14 | 1 << 15;

	return 0;
}

static void gmac_init_tx_bd(struct zx_net_dev* prv)
{
    struct bd_tx *tx  = (struct bd_tx *)prv->dma_tx_vir;

    int 			i = 0;

    prv->tx_bd_offset		= 0;
    prv->txed_bd			= 0;

    for(i = 0; i < GMAC_TX_BD_NUM; i++)
    {
        // ʼ
        // ݻΪ SKBdataΣʲҪݻ
        // ʱSKBڷϣGMACӲݷͺݲȻƻʱٴ

        tx[i].TDES0       	= (1 << 20 | 1 << 30);
        tx[i].TDES1       	= GMAC_FRAME_LEN;
        tx[i].next			= prv->dma_tx_phy + ((i + 1) << 5);
    }

    // ´Ƕлش
    tx[GMAC_TX_BD_NUM-1].next		    	= prv->dma_tx_phy;
    tx[GMAC_TX_BD_NUM-1].TDES0            	= 1 << 20 | 1 << 21 | 1 << 30;	
}

// Ӳʼ
static int hw_net_init(struct net_device *dev)
{
	int ret = -1;
    unsigned 		val;

    volatile unsigned *gmac	= (unsigned*)dev->base_addr;   //WL  豸IOַ
    struct zx_net_dev* prv 	= (struct zx_net_dev*)netdev_priv(dev);
   // rtk_mode_ext_t *Mode ;
   // rtk_port_mac_ability_t portAbility;

    // 뷢
    // ʹSKBdataΪݻʲҪݻ

    if(prv->dma_rx_phy)
    {
        //LOG_DBG(4, "dma buffer has alloc, uninit hardware first\n");
        hw_net_uninit(dev);
    }

    if(!prv->stopped)
    {
		prv->dma_rx_vir	= dma_alloc_coherent(NULL,
							GMAC_BUF_LEN,
						&prv->dma_rx_phy,
						GFP_KERNEL);

		if(0 == prv->dma_rx_vir)
		{
			prv->dma_rx_phy		= 0;						// ʧʱܻеֵַ
			//LOG_ERR("alloc DMA buffer failed\n");
			return -ENOMEM;
		}
		else
		{
			dma_tx_vir_bak = prv->dma_rx_vir;
			dma_rx_phy_bak = prv->dma_rx_phy;
		}
    }
    else
    {
		prv->dma_rx_vir = dma_tx_vir_bak;
		prv->dma_rx_phy = dma_rx_phy_bak ;
    }
      // ǰΪ 1 << CONFIG_GMAC_BUF_NUM  
    // Ϊ 1 << CONFIG_GMAC_BUF_NUM  
    prv->dma_tx_vir	= prv->dma_rx_vir + GMAC_RX_BUF_LEN;
    prv->dma_tx_phy	= prv->dma_rx_phy + GMAC_RX_BUF_LEN;

    // 
    memset(prv->dma_rx_vir, 0, GMAC_BUF_LEN);

    //LOG_INFO("alloc dma buffer at 0x%8X(0x%8X) size 0x%08X\n", (unsigned)prv->dma_rx_vir, prv->dma_rx_phy, 0x40 << CONFIG_GMAC_BUF_NUM);

//ec616000600086,should check init_rx result
    ret = gmac_init_rx_bd(dev, prv);
	if(ret < 0)
	{
		printk("hw_net_init,init_rx_bd fail\n");
		return ret;
	}
    gmac_init_tx_bd(prv);

    // Ӳʼ
    mac_init(dev);

    // رGMACй
    dma_disable();
    mac_disable();
    mac_int_disable();

    // ͻ䳤
    val		 	= MAC(0x1000);
    
    val			&= ~(0x3F << 8);
    val			|=  (0x10 << 8);    //burst 16
    
   // val                   &= ~(0xDFF << 8);
  //val                   |=  (0x1 << 8);    //burst 16

    MAC(0x1000)	 = val;

    //  ý뷢
    dma_set_rx_buffer(prv->dma_rx_phy);
    dma_set_tx_buffer(prv->dma_tx_phy);

    mac_int_clear(0x0001FFFF);								// ж
    while(mac_mii_is_busy());

    MAC(0x0000)  |= (0x1<<14)|(0x1<<11);                                   //MacspeedΪ100mȫ˫
    mac_rece_all_data();									// 
    //gmac_set_filter(dev);                                                          //ʱԲô

    return 0;
}

// 豸
static int zx_net_open(struct net_device *dev)
{
    int ret;
    struct zx_net_dev* prv	= (struct zx_net_dev*)netdev_priv(dev);
        /*for 616000599226,phy not link ,so return fail 
	        */	
    if(eLINK_OFF == prv->link)
    {
    	printk("zx_net_open,no link, fail\n");
    	return -ENOENT;
    }

    ret	= hw_net_init(dev);
    
    if(ret)		
		return ret;

    gmac_start((void*)dev->base_addr);
	
    netif_carrier_on(dev);
	
    ret = prv->open(dev);
    if(ret)		return ret;

    netif_start_queue(dev);

    prv->stopped = 0;

#ifdef GMAC_NO_INT
	gmac_start_timer();
#endif
    
    gmac_printk("TSP zx29 gmac net open\n");
    return 0;
}

// ر豸
static int zx_net_stop(struct net_device *dev)
{
    unsigned long       flags = 0;
    
    struct zx_net_dev* prv = (struct zx_net_dev*)netdev_priv(dev);
    
    spin_lock_irqsave(&prv->lock, flags);
	
#ifdef GMAC_NO_INT
	gmac_stop_timer();
#endif

    prv->stopped = 1;
    
    netif_stop_queue(dev);
    netif_carrier_off(dev);
	
    prv->stop(dev);
	
    hw_net_uninit(dev);
    
    memset(&dev->stats, 0, sizeof(struct net_device_stats));
    
    spin_unlock_irqrestore(&prv->lock,flags);
    
    gmac_printk("TSP zx29 gmac net stop\n");

    return 0;
}

// ͺ
static int zx_net_start_xmit(struct sk_buff *skb, struct net_device *dev)
    {
    unsigned long       flags;
    unsigned 			len;
    struct sk_buff		*skb_old;
    struct bd_tx 		*tx;
    struct zx_net_dev* 	prv		= (struct zx_net_dev*)netdev_priv(dev);
    unsigned int  retVal = 0;
    if(eLINK_OFF == prv->link)
    {
        /*for 616000599226,phy not link ,so free skb 
	        */
        dev_kfree_skb_any(skb);
    	//netif_stop_queue(dev);
        gmac_printk("TSP zx29 gmac xmit  phy not link\n");   
        return NETDEV_TX_OK;
    }
    
    // ȡʱҪ

    spin_lock_irqsave(&prv->lock, flags);

    if(prv->stopped)
    {
        spin_unlock_irqrestore(&prv->lock,flags);
        dev_kfree_skb_any(skb);
        
        gmac_printk("zx_net_start_xmit when stopped\n");
        
        return NETDEV_TX_OK;
    }

    tx	= get_tx_bd(dev);

    if(!tx)
    {
        spin_unlock_irqrestore(&prv->lock,flags);
        dev_kfree_skb_any(skb);
        return NETDEV_TX_OK;
    }
    prv->tx_bd_offset++;
    prv->tx_bd_offset %= GMAC_TX_BD_NUM;
    spin_unlock_irqrestore(&prv->lock, flags);

    if(skb->len > ETH_FRAME_LEN + 4)	//LOG_INFO("tx length too big\n");
    gmac_printk("TSP zx29 gmac start xmit len too long\n");

    // ȡϹŵSKBȻ󽫸SKB(SKBѷ)
    // ٽµSKBȥ(SKBַԼskb->dataεַGMAC֮)
    // עڽskb->dataεݷȨGMAC֮ǰҪdataεݽCACHEͬ
    // Ϊskb->datacached

    //wl skb_old		 = tx->skb;
    //flush_skbuf(skb);

    skb= flush_skbuf(skb);
	if(NULL == skb)
		BUG_ON(1);   
    len 		        = MIN(skb->len, GMAC_FRAME_LEN - NET_IP_ALIGN);
    tx->TDES0	      |= (0x07 << 28);					// ״̬Ϊ֡ĵһݰһɺж(һ֡һݰ)
    //tx->dma_buf	 = __virt_to_phys((unsigned)skb->data);
    tx->dma_buf	 = virtaddr_to_phys((unsigned)skb->data);
    tx->skb		 = skb;

    // дͬ
    // dma_sync_single_for_device(&dev->dev, tx->dma_buf, len, DMA_TO_DEVICE);
    //wl dev_kfree_skb_any(skb_old);
      
    tx->TDES1 	 = len;
    tx->TDES0 	|= DMA_OWNER;

    //prv->tx_bd_offset++;
    //prv->tx_bd_offset %= GMAC_TX_BD_NUM;
    wmb();
    dev->stats.tx_bytes			+= len;
    dev->stats.tx_packets++;
    dev->trans_start			= jiffies;

    gmac_trig_transmit((void*)dev->base_addr);
    
    return NETDEV_TX_OK;
}

// ʱ: ú¶Ӳȫʼ
static void zx_net_timeout(struct net_device *dev)
{
    struct zx_net_dev* prv	= (struct zx_net_dev*)netdev_priv(dev);
	
    prv->link= prv->link_state(dev);
	
    if(eLINK_OFF == prv->link)
    {	
        gmac_printk("TSP zx29 gmac net timeout phy not link\n");                                            // PHY δ
        netif_stop_queue(dev);
        netif_carrier_off(dev);
    }
    else
    {
        gmac_printk("TSP zx29 gmac net timeout phy linked\n"); 
        gmac_trig_transmit(dev);
        gmac_trig_receive(dev);

        netif_carrier_on(dev);
        netif_wake_queue(dev);
        dev->trans_start 		= jiffies;
        dev->stats.tx_errors++;
        dev->stats.tx_dropped++;
    }
}

// MACַ
static int zx_net_set_mac_address(struct net_device *dev, void *p)
{
    int ret = eth_mac_addr(dev, p);
	
    if(!ret) {
		gmac_update_mac(dev);
		gmac_printk(" zx29 gmac set mac addr ok\n");
    }

    return ret;
}

u32 zx_net_get_link(struct net_device *dev)
{
    struct zx_net_dev* prv = (struct zx_net_dev*)netdev_priv(dev);
    int ret = -1;

    spin_lock_irq(&prv->phy_lock);
    ret = prv->link;
    spin_unlock_irq(&prv->phy_lock);

    return ret;
}

static int zx_net_get_settings(struct net_device *dev, struct ethtool_cmd *cmd)
{
    struct zx_net_dev* prv = (struct zx_net_dev*)netdev_priv(dev);
    int ret = -1;

    spin_lock_irq(&prv->phy_lock);
    cmd->advertising = prv->set_duplex_mode;
    cmd->autoneg = prv->autoneg;
    spin_unlock_irq(&prv->phy_lock);

    ret = 0;

    return ret;
}

static int zx_net_set_settings(struct net_device *dev, struct ethtool_cmd *cmd)
{
    u32 speed = ethtool_cmd_speed(cmd);
    E_SPEED physpeed;
    E_DUPLEX phyduplex;

    struct zx_net_dev* prv = (struct zx_net_dev*)netdev_priv(dev);

    spin_lock_irq(&prv->phy_lock);
    if(cmd->advertising == prv->set_duplex_mode)
    {
        spin_unlock_irq(&prv->phy_lock);
        return 0;
    }
    spin_unlock_irq(&prv->phy_lock);

    //LOG_INFO("zx_net_set_settings cmd->advertising=%d\n", cmd->advertising);
    // LOG_INFO("zx_net_set_settings cmd->autoneg=%d\n", cmd->autoneg);

    //verify the setting we care about
    if(cmd->autoneg == AUTONEG_DISABLE &&
    ((speed != SPEED_100 &&
    speed != SPEED_10) ||
    (cmd->duplex != DUPLEX_HALF &&
    cmd->duplex != DUPLEX_FULL)))
    return -EINVAL;

    if(cmd->autoneg == AUTONEG_ENABLE)
    {
        prv->autoneg    =   AUTONEG_ENABLE;
       //return phy_negotiation(dev);
       return 0;
    }

    physpeed = (speed == SPEED_10) ? eSPEED_10M : eSPEED_100M;
    phyduplex = (cmd->duplex == DUPLEX_HALF) ? eDUPLEX_HALF : eDUPLEX_FULL;

   // return phy_set_speed_duplex(dev, physpeed, phyduplex);
   return  0;
}

static const struct ethtool_ops zx_net_ethtool_ops = 
{
    .get_settings	= zx_net_get_settings,
    .set_settings	= zx_net_set_settings,
    .get_link		= zx_net_get_link,
};

static inline int phy_mc_hash(__u8 *addr)
{
	return (bitrev32(~ crc32_le(~0, addr, ETH_ALEN)) >> 26);
}

// öಥHASH
static void zx_set_multicast(struct net_device *dev)
{
    volatile unsigned *gmac 	= (unsigned*)dev->base_addr;

    if(dev->flags & IFF_PROMISC) 
    {
        MAC(0x0004)    |= 1 << 31;		// ֡: ֡
    } 
    else if(dev->flags & IFF_ALLMULTI) 
    {
        MAC(0x0008) 	= 0xffffffff;
        MAC(0x000C) 	= 0xffffffff;
        MAC(0x0004)     |= 1 << 2;
        MAC(0x0004)    &= ~(1 << 31);	// ֡: ù: ֡
    } 
    else if(dev->mc.count > 0) 
    {
        u32		hash[2];
        u32		hash_id;
        struct	netdev_hw_addr *ha;

        hash[0]		= 0;
        hash[1]		= 0;

        netdev_hw_addr_list_for_each(ha, &dev->mc)
        {
        	hash_id	= phy_mc_hash(ha->addr);
        	
        	if(hash_id > 31) 
        	{
        		hash[1] |= 1 << (hash_id - 32);
        	} 
        	else 
        	{
        		hash[0] |= 1 << hash_id;
        	}
        }

        MAC(0x0004)    &= ~(1 << 31);	// ֡: ù: ֡
        MAC(0x0004)    |= 1 << 2;

        if((MAC(0x000C) == hash[0]) && (MAC(0x0008) == hash[1])) return;

        MAC(0x0008) 	= hash[1];
        MAC(0x000C) 	= hash[0];
    } 
    else 
    {
        MAC(0x0008) 	= 0x0;
        MAC(0x000C) 	= 0x0;
        MAC(0x0004)    |= 1 << 2;
        MAC(0x0004)    &= ~(1 << 31);	// ֡: ù: ֡
    }
}

static const struct net_device_ops zx_net_netdev_ops =
{
    .ndo_open				= zx_net_open,
    .ndo_stop				= zx_net_stop,
    .ndo_start_xmit			= zx_net_start_xmit,
    .ndo_tx_timeout			= zx_net_timeout,
   // .ndo_set_multicast_list =  zx_set_multicast,
    .ndo_change_mtu		= eth_change_mtu,
    .ndo_validate_addr		= eth_validate_addr,
    .ndo_set_mac_address	= zx_net_set_mac_address,
};

// պ
static int zx_net_rx(struct net_device *dev)
{
	struct bd_rx 	*rx;
	struct sk_buff	*skb;
	struct sk_buff	*skb_new;
	unsigned		len;
	int   exhausted = 0;

	struct zx_net_dev* prv = (struct zx_net_dev*)netdev_priv(dev);

    rx  = get_rx_bd(dev);

    if(unlikely(!rx))	goto rcv_done;

    while(rx)
    {
        if((rx->RDES0 & ERR_RX_ES) || (rx->RDES0 & ERR_RX_LE))
        {
            dev->stats.rx_errors++;
            if(rx->RDES0 & ERR_RX_LE)	dev->stats.rx_length_errors++;
            if(rx->RDES0 & ERR_RX_OE)	dev->stats.rx_over_errors++;
            if(rx->RDES0 & ERR_RX_IPC)	dev->stats.rx_frame_errors++;
            if(rx->RDES0 & ERR_RX_LC)	dev->stats.rx_fifo_errors++;
            if(rx->RDES0 & ERR_RX_CE)	dev->stats.rx_crc_errors++;
        }
        else
        {
            // Խݽд
            // еskbȡ·skbϣڽ
            // ʱѾskb->dataˣݳskb֪ݻûCACHEͬ
            // skbݳȡͬ
            // ȻϱЭϲ

            len = ((rx->RDES0 >> 16) & 0x3FFF) - 4;
            if(len  > (ETH_FRAME_LEN+8))  
            {
            //LOG_INFO("rx data length more than %d\n", ETH_FRAME_LEN);
                dev->stats.rx_dropped++;
                goto rx_bd_reset;
            }

            skb_new = netdev_alloc_skb(dev, GMAC_FRAME_LEN + NET_IP_ALIGN);
            if(unlikely(!skb_new))
            {
                //LOG_DBG(3, "memory squeeze, dropping packet\n");
                dev->stats.rx_dropped++;
				exhausted++;
            }
            else
            {	
            	exhausted = 0;
            	dev->stats.rx_packets++;
				dev->stats.rx_bytes += len;
				// ݶȡͬDMA buffer ¸cpu
				dma_sync_single_for_cpu(&dev->dev, rx->dma_buf, GMAC_FRAME_LEN, DMA_FROM_DEVICE);
                skb				= rx->skb;
                skb_put(skb, len);
                skb->protocol 		= eth_type_trans(skb, dev);
                netif_rx(skb);		
				
                skb_reserve(skb_new, NET_IP_ALIGN);
                //rx->dma_buf    		= __virt_to_phys((unsigned)skb_new->data);
                rx->dma_buf    		= virtaddr_to_phys((unsigned)skb_new->data);
                rx->skb			= skb_new;
				wmb();
                // ݶȡͬ豸
				dma_sync_single_for_device(&dev->dev, rx->dma_buf, GMAC_FRAME_LEN, DMA_TO_DEVICE); //TODO
            }
        }
        rx_bd_reset:
        rx->RDES0 = rx->RDES0 | DMA_OWNER;
        prv->rx_bd_offset++;
        prv->rx_bd_offset %= GMAC_RX_BD_NUM;
		wmb();
		
		if(exhausted >= 10)
			break;
	
        gmac_trig_receive((void*)dev->base_addr);     //գȡմ
        rx	= get_rx_bd(dev);
    }

    rcv_done:
    gmac_trig_receive((void*)dev->base_addr);
	
	return (exhausted >= 10);
}


// жϴ
static void zx_net_tx(struct net_device *dev)
{
    register unsigned status;
    struct net_device_stats	s	= dev->stats;
    struct bd_tx *tx 			= get_txed_bd(dev);

    while(tx)
    {
        status	= tx->TDES0;

        if(tx->TDES0 & ERR_TX_ES)
        {
            s.tx_errors++;
            if(status & ERR_TX_LC)		s.tx_carrier_errors++;
            if(status & ERR_TX_NC)		s.tx_carrier_errors++;
            if(status & ERR_TX_EC)		s.tx_window_errors++;
            if(status & ERR_TX_LATECOL)	s.tx_window_errors++;
            if(status & ERR_TX_UF)		s.tx_aborted_errors++;
            if(status & ERR_TX_ED)		s.tx_aborted_errors++;
            if(status & ERR_TX_JT)		s.tx_fifo_errors++;
            if(status & ERR_TX_FF)		s.tx_fifo_errors++;

            //LOG_DBG(3, "%s %ld\n", __FUNCTION__, s.tx_errors);
        }
	dev_kfree_skb_any( tx->skb);  //wl
	tx->skb = NULL;
	tx = get_txed_bd(dev);      
    }

   if(netif_queue_stopped(dev))
  // if (netif_carrier_ok(dev))
    {
        netif_wake_queue(dev);    //ʹϲЭʼµ
    }
}

#ifndef GMAC_NO_INT
// GMAC жϴ
void zx_net_tasklet(unsigned long dev_id)
{
    struct net_device* dev 		= (struct net_device*)dev_id;
    struct zx_net_dev* prv 	= (struct zx_net_dev*)netdev_priv(dev);
    volatile unsigned *gmac 	= (unsigned*)dev->base_addr;

    unsigned events				= prv->int_event;								// ȡжбжϱ

    // GMACжϽֱûж()Ҫ
    do
    {
        if(events & INT_ST_TX)
        {
            zx_net_tx(dev); 
        }                                                     
        if(events & INT_ST_RX)	    
        {
            zx_net_rx(dev);
        }

        events			= MAC(0x1014);
        MAC(0x1014)		= events;

    } while( events & (INT_ST_TX | INT_ST_RX));

    // ʱGMACжǹرյģҪٴδ
    mac_int_enable();															// GMACٴβж
}
#else
// GMAC жϴ
void zx_net_tasklet(unsigned long dev_id)
{
    struct net_device* dev 		= (struct net_device*)dev_id;
    struct zx_net_dev* prv 	= (struct zx_net_dev*)netdev_priv(dev);
    volatile unsigned *gmac 	= (unsigned*)dev->base_addr;
	int rx_result = 0;
    unsigned events				= prv->int_event;								// ȡжбжϱ

    // GMACжϽֱûж()Ҫ
    do
    {
        if(events & INT_ST_TX)
        {
            zx_net_tx(dev); 
        }                                                     
        if(events & INT_ST_RX)	    
        {
           rx_result = zx_net_rx(dev);
			if(rx_result)//this means skb is exhausted,so break task
				break;
        }

        events			= MAC(0x1014);
        MAC(0x1014)		= events;

    } while( events & (INT_ST_TX | INT_ST_RX));

    // ʱGMACжǹرյģҪٴδ
   // mac_int_enable();															// GMACٴβж
}
static unsigned int gmac_sema_up_flag = 0;
//DEFINE_SEMAPHORE(gmac_thread_sema);
struct semaphore gmac_thread_sema;
struct hrtimer *gmac_timer;

static void gmac_kick_thread(void)
{
    unsigned  *gmac      = NULL;
    unsigned   events    = 0;
    
	gmac        = g_gmac;
    events	    = MAC(0x1014);
	MAC(0x1014)	= events;
	
    if ( events >> 15)
	{
		if(!test_and_set_bit(1, &gmac_sema_up_flag))
			up(&gmac_thread_sema);
	}
}

 enum hrtimer_restart gmac_timer_callback(struct hrtimer *timer)
{
	unsigned long delay_in_us = GTIMER_INTERVAL;
	ktime_t gmac_schdule_time;
	
	gmac_schdule_time = ktime_set(0, delay_in_us * 1000);
	hrtimer_forward_now(timer, gmac_schdule_time);

	//gmac_kick_thread();
    tasklet_schedule(g_gmac_tasklet);
    //gmac_kick_plug_thread();
    //tasklet_schedule(&gmac_net_dev_prv->tasklet);
	return HRTIMER_RESTART;
}

static void gmac_init_timer(void)
{
	sema_init(&gmac_thread_sema, 0);

	gmac_timer = kzalloc(sizeof(struct hrtimer),GFP_KERNEL);
	if(gmac_timer == NULL){
		BUG_ON(1);
	}
    hrtimer_init(gmac_timer, CLOCK_MONOTONIC, HRTIMER_MODE_REL );

    gmac_timer->function = gmac_timer_callback;
}

static void gmac_start_timer(void)
{
	unsigned long delay_in_us = GTIMER_INTERVAL;
	ktime_t gmac_schdule_time;

	gmac_schdule_time = ktime_set(0, delay_in_us * 1000);
    hrtimer_start(gmac_timer, gmac_schdule_time, HRTIMER_MODE_REL );
}

static int gmac_stop_timer(void)
{
	int ret = 0;
	
    ret = hrtimer_cancel(gmac_timer);
	if(ret < 0)
		BUG_ON(1);
	
	return ret;
}

void zx_net_thread(unsigned long dev_id)
{
    struct net_device* dev 		= (struct net_device*)dev_id;
    struct zx_net_dev* prv 	= (struct zx_net_dev*)netdev_priv(dev);
    volatile unsigned *gmac 	= (unsigned*)dev->base_addr;
    unsigned events	= 0;								// ȡжбжϱ

	while (!kthread_should_stop()){
		down(&gmac_thread_sema);
		if(!test_and_clear_bit(1, &gmac_sema_up_flag))
			continue;

		events = prv->int_event;

		// GMACжϽֱûж()Ҫ
		do
	    {
	        if(events & INT_ST_TX)
	        {
	            zx_net_tx(dev); 
	        }                                                     
	        if(events & INT_ST_RX)	    
	        {
	            zx_net_rx(dev);
	        }

	        events			= MAC(0x1014);
	        MAC(0x1014)		= events;

	    } while( events & (INT_ST_TX | INT_ST_RX));

		//msleep(1);
	}
}

#endif


// GMAC жϴ
static irqreturn_t zx_net_int(int irq, void *dev_id)
{
	struct net_device* dev 		= (struct net_device*)dev_id;
	struct zx_net_dev* prv 		= (struct zx_net_dev*)netdev_priv(dev);
	volatile unsigned *gmac 	= (unsigned*)dev->base_addr;

	prv->int_event				= MAC(0x1014);									// ȡжϢ
	MAC(0x1014)					= prv->int_event;								// ж

	// ȽGMACжΣȻҪ̷ж
	// жɺٴGAMCж

	mac_int_disable();
	tasklet_schedule(&prv->tasklet);

	return IRQ_HANDLED;
}

//chenhao debug for setting gmac mac addr
static inline void zx_net_set_mac(struct net_device* ndev)
{
    // ȡMAC ַ: 
    // MACĴеĵַЧʹøMAC
    // Ч//zx297520v2   ֱmac ַ
 
   int i =0;
   u8 gmac_nvaddr[MAC_ADDR_LENTH] = {0};
   int retval = 0;
#if  0 
   //now can not read NV,just change
    retval = nand_NvRead(MAC_HWETHER,MAC_ADDR_LENTH,gmac_nvaddr);
    if(retval < 0)
    {
	gmac_printk("TSP zx29 gmac read mac nv error");
    }
    else
    {
	gmac_printk("TSP zx29 gmac read mac nv ok");
	if(is_valid_ether_addr(gmac_nvaddr))
	{
		for(i = 0;i<MAC_ADDR_LENTH;i++)
		{
			ndev->dev_addr[i]   = gmac_nvaddr[i];
		}
		return;
	}
    }
#endif	
#if  MAC_ADDR_SET
    for(i = 0;i<MAC_ADDR_LENTH;i++)
    {
     ndev->dev_addr[i]   = gmac_addr[i];
    }

    if(!is_valid_ether_addr(ndev->dev_addr))
    {
	    random_ether_addr(ndev->dev_addr);
    }
#else
    random_ether_addr(ndev->dev_addr);
#endif
}

//static void __iomem *virt_gmac= 0;
static int __devinit zx_net_probe(struct platform_device *pdev)
{
    int	ret = 0;
    struct zx_net_dev	*prv = NULL;
    volatile unsigned	*gmac = NULL;
    // ȷṹ壬ȡ IO  IRQ Դ
    struct net_device* 	ndev	= alloc_etherdev(sizeof(struct zx_net_dev));
    struct resource* 	res		= platform_get_resource(pdev, IORESOURCE_MEM, 0);

#ifndef GMAC_NO_INT	
    int gmac_irq				= platform_get_irq_byname(pdev, "gmac_int");
#endif
	struct zx29_gmac_platform_data *pdata = pdev->dev.platform_data;
    struct clk *pclk=NULL;
    unsigned int value;
    //pclk=clk_get_sys("zx29_gmac.0", "rmii_clk");     //gmac rmii_clk_o    50M
    //clk_set_rate(pclk,50000000);
    //clk_prepare_enable(pclk);
    wake_lock_init(&gmac_wake_lock, WAKE_LOCK_SUSPEND, "gmac_pm");
    wake_lock(&gmac_wake_lock);
	
    // zx_cpuidle_set_busy(IDLE_FLAG_GMAC);
    
    *(volatile unsigned int  *)(ZX_TOP_CRM_BASE+0x11C) = 0x00000005 ;   // GMAC_MOD_CFG gmac clk 50m
 
    platform_set_drvdata(pdev, ndev);

    if(NULL == res)		return -ENXIO;	// RES Ѿַָ
    if(NULL == ndev)	return -ENOMEM;
#ifndef GMAC_NO_INT	
    if(gmac_irq < 0)	return -EINVAL;
#endif    
    gmac_net_dev = ndev;
    prv 					= (struct zx_net_dev*)netdev_priv(ndev);
    prv->netdev 			= ndev;
    prv->set_duplex_mode	= eSET_AUTO_NEGO;
    prv->autoneg                  = AUTONEG_ENABLE;     //Э
    prv->stopped 			= 0;                //init stop
#ifdef CONFIG_ARCH_ZX297520V2  
	prv->ext_irq			= platform_get_irq_byname(pdev, "ext_int");
#elif CONFIG_ARCH_ZX297520V3
	
#ifndef GMAC_NO_INT
    prv->ext_irq			= platform_get_irq_byname(pdev, "phy_int");
#endif
#endif	
	
    //gmac_printk("TSP zx29 gmac  irq = %d  !!!!!\n",gmac_irq);
    gmac_printk("TSP zx29 gmac phy irq = %d  !!!!!\n",prv->ext_irq);

#ifndef GMAC_NO_INT	
    if(prv->ext_irq < 0)		return -EINVAL;
	
    ndev->irq				= gmac_irq;
#endif			
    ndev->dev.parent		= &pdev->dev;
    ndev->base_addr		= res->start;
    ndev->netdev_ops		= &zx_net_netdev_ops;
    ndev->ethtool_ops		= &zx_net_ethtool_ops;
    ndev->watchdog_timeo 	=  HZ   ;    //for what ?

    gmac_net_dev_prv = prv;
#ifdef CONFIG_NET_ZX29_GMAC_SWITCH
   snprintf(ndev->name, sizeof(ndev->name), "%s%%d", gmac_switch_name);
   prv->device_type =  ePERIPHERAL_SWITCH;
   prv->init = zx_gmac_switch_init;
   prv->open = zx_gmac_switch_open;
   prv->stop = zx_gmac_switch_stop;
   prv->link_state = gmac_switch_linked;
#endif

#ifdef CONFIG_NET_ZX29_GMAC_PHY
   snprintf(ndev->name, sizeof(ndev->name), "%s%%d", gmac_phy_name);
   prv->device_type =  ePERIPHERAL_PHY;
   prv->init = zx_gmac_phy_init;
   prv->open = zx_gmac_phy_open;
   prv->stop = zx_gmac_phy_stop;
   prv->release = zx_gmac_phy_release;
   prv->link_state = gmac_phy_link_status;
#endif

    gmac 	= (unsigned*)ndev->base_addr;
	g_gmac  = gmac;
    // MAC ַ
    zx_net_set_mac(ndev);

    spin_lock_init(&prv->lock);
    spin_lock_init(&prv->phy_lock);

    dma_disable();
    mac_disable();
    mac_int_disable();
   // gmac_stop((void*)ndev->base_addr);

#ifndef GMAC_NO_INT
    // ѷжϣȻװж
    ret = request_irq(ndev->irq, zx_net_int, IRQF_DISABLED, pdev->name, ndev);
    if(ret)		goto failed_request_irq;
#endif

    // ע豸
    ret = register_netdev(ndev);
    if(ret)		goto failed_register;
	
    gmac_printk("TSP zx29 gmac netdev register success \n");


	//div			= (unsigned*)GMAC_CLKEN;
    //div[0]					= 0x0;

//don't request this gpio
#if 0//ndef CONFIG_NET_ZX29_GMAC_PHY    
	if(gpio_request(pdata->pwr_gpio, pdata->pwr_name))
		goto failed_request_gpio;
	zx29_gpio_config(pdata->pwr_gpio, pdata->pwr_func);
	gpio_direction_output(pdata->pwr_gpio, 1);
#endif	
    value = *(volatile unsigned int  *)(ZX_SOC_SYS_BASE+0x150); 
    *(volatile unsigned int  *)(ZX_SOC_SYS_BASE+0x150) = value | 0x10 ;   // GMAC_MOD_CFG gmac phy reset
    mdelay(500);      //phy delay >10ms  ok
    
   ret = prv->init (ndev);
  if(ret)   goto failed_phy_request_irq;

#if 1//ndef ///GMAC_NO_INT
    g_gmac_dev = prv;
    tasklet_init(&prv->tasklet, zx_net_tasklet, (unsigned long)ndev);
    g_gmac_tasklet = &prv->tasklet;
    gmac_init_timer();
#else
	kthread_run(zx_net_thread, (unsigned long)ndev, "gmac_proc/%s", "txrx");
	
#endif


    return 0;


failed_phy_request_irq:
	unregister_netdev(ndev);
failed_request_gpio:
#if 0//def CONFIG_NET_ZX29_GMAC_PHY 
	gpio_free(pdata->pwr_gpio);
#endif
failed_request_irq:
#ifndef GMAC_NO_INT
	free_irq(ndev->irq, ndev);
#endif
failed_register:
	free_netdev(ndev);
	platform_set_drvdata(pdev, NULL);
	gmac_net_dev_prv = NULL;
	g_gmac = NULL;

	return ret;
}

static int zx_net_suspend(struct device *dev)      //gmac
{
    struct platform_device *pdev	= to_platform_device(dev);
    struct net_device 	*ndev		= platform_get_drvdata(pdev);

    if(ndev)
    {
    	if(netif_running(ndev))
    	{
    		netif_device_detach(ndev);
    		gmac_stop((void*)ndev->base_addr);
    		// TODO: бҪ PHY
    	}
    }
    return 0;
}

static int zx_net_resume(struct device *dev)       //ָGMAC
{
    struct platform_device *pdev	= to_platform_device(dev);
    struct net_device *ndev 		= platform_get_drvdata(pdev);

    if(ndev)
    {
    	if(netif_running(ndev))
    	{
        	// TODO: бҪָ PHY Ϊģʽ
        	gmac_start((void*)ndev->base_addr);
        	netif_device_attach(ndev);
    	}
    }
    return 0;
}

// ж豸
static int __devexit zx_net_remove(struct platform_device *pdev)
{
    struct net_device *ndev 	= platform_get_drvdata(pdev);
    struct zx_net_dev* prv 	= (struct zx_net_dev*)netdev_priv(ndev);
	struct zx29_gmac_platform_data *pdata = pdev->dev.platform_data;

    tasklet_disable(&prv->tasklet);
    tasklet_kill(&prv->tasklet);

	if(prv->release)
		prv->release(ndev);
	
#ifdef CONFIG_NET_ZX29_GMAC_PHY 
	gpio_free(pdata->pwr_gpio);
#endif
	free_irq(ndev->irq, ndev);
	
    if(prv->switch_thread)
    {
        kthread_stop(prv->switch_thread);
        prv->switch_thread = NULL;
    }

    if(prv->dma_rx_vir)
    {
	dma_free_coherent(NULL, GMAC_BUF_LEN, prv->dma_rx_vir, prv->dma_rx_phy);   //ͷdma
     }
    unregister_netdev(ndev);
    //free_netdev(ndev);
    platform_set_drvdata(pdev, NULL);

	wake_unlock(&gmac_wake_lock);
	wake_lock_destroy(&gmac_wake_lock);

	gmac_printk("TSP zx29 gmac remove success\n");
    return 0;
}

static struct dev_pm_ops driver_pm_ops =
{
	.suspend		= zx_net_suspend,
	.resume		= zx_net_resume,
};

static void zx_net_shutdown(struct platform_device *pdev)    //make phy into power down mode
{
    struct net_device *ndev 	= platform_get_drvdata(pdev);
    //struct zx_net_dev* prv 	= (struct zx_net_dev*)netdev_priv(ndev);
    if(ndev)
    {	   
        /*netif_device_detach(ndev);
        gmac_stop((void*)ndev->base_addr);*/
        // TODO: бҪ PHY
        //phy_pwd_mode(ndev);
    }
    return ;
}
static struct platform_driver net_driver =
{
	.driver			=
	{
		.name    		= "zx29_gmac",
		.owner	 	= THIS_MODULE,
		.pm	 		= &driver_pm_ops,
	},
	.probe			= zx_net_probe,
	.remove			= __devexit_p(zx_net_remove),
	.shutdown       	= zx_net_shutdown,
	
};

static int __init zx_init(void)
{
    int ret = platform_driver_register(&net_driver);     /*ʼעắ豸zx_gmac*/

    if(ret)	
    {
        gmac_printk("TSP zx29 gmac driver register failed\n");
    }
    else	
    {
        gmac_printk("TSP zx29 gmac driver register successed\n");
    }

    return    ret;
}

static void __exit zx_cleanup(void)
{
    platform_driver_unregister(&net_driver);
	gmac_printk("TSP zx29 gmac unregister success\n");
}

module_init(zx_init);
module_exit(zx_cleanup);
MODULE_AUTHOR("sanchips, SOC");
MODULE_DESCRIPTION("ZX279000 Serial GMAC network driver");
MODULE_LICENSE("GPL");
