#ifndef _PSNET_H_
#define _PSNET_H_

#include <linux/interrupt.h>

#include <linux/netdevice.h>

#include <linux/kthread.h>

#include <linux/skbuff.h>
#include <linux/spinlock.h>
#include <linux/semaphore.h>
//#include "psnet.h"

#ifdef dbg
#undef dbg
#endif
#if PSNET_DEBUG
#define dbg(format, arg...) printk(KERN_DEBUG " psnet.c<%s>: " format "\n" , \
	__func__ , ## arg)
#else
#define dbg(format, arg...) do {} while (0)
#endif

#ifdef err
#undef err
#endif
#define err(format, arg...) printk(KERN_ERR " psnet.c<%s>: " format "\n" , \
	__func__ , ## arg)

#ifdef warn
#undef warn
#endif
#define warn(format, arg...) printk(KERN_WARNING " psnet.c<%s>: " format "\n" , \
	__func__ , ## arg)

#ifdef info
#undef info
#endif
#define info(format, arg...) printk(KERN_ERR " psnet.c<%s>: " format "\n" , \
	__func__ , ## arg)


#define NET_LAN  	0x10
#define NET_WAN 	0x11
typedef (*functpye1)(unsigned int);
typedef (*functpye2)(unsigned int, void*, unsigned int);

struct psnet_msg
{
    void  *buf;
    unsigned int len;
    u32 protocol; 
};

struct psnet {
    struct net_device  *net;
	//void*  IOhandle;
	int initflag;
    /*lan0 or wan0*/
    unsigned char lan;
	unsigned int index;
    //struct sk_buff_head txq;
    struct sk_buff_head rxq;
	//struct semaphore  skb_que_sem;
    //struct tasklet_struct rx_bh;
	struct task_struct* rcv_thread;
	//struct completion rcv_completion;
	//wait_queue_head_t waitqueue;
	void (*channelOpen)(unsigned int chid);
	void (*channelClose)(unsigned int chid);
	int (*transdataOut)(unsigned int channel, void* buff, unsigned int length);
};

enum{
	DDR_DEV_WAN1 = 0,
	DDR_DEV_WAN2,
	DDR_DEV_WAN3,
	DDR_DEV_WAN4,
	DDR_DEV_WAN5,
	DDR_DEV_WAN6,
	DDR_DEV_WAN7,
	DDR_DEV_WAN8,
	DDR_DEV_MAX,
	
};
void psnet_recv_notify(unsigned int index, const void *buffer, unsigned int length);
int psnet_registerOpsCallback(unsigned int chID, functpye1* funcOpen, functpye1* funcClose, functpye2* funcOut);

#if 0
#ifdef USE_PSNET_PACKET
s32 psnet_skb_xmit_thread(void * __dev);
#endif
int psnet_rx_packet(struct net_device *net, struct psnet_msg *psMsg);
#endif
#endif  /*  _PSNET_H_  */

