#include <linux/module.h>
#include <linux/etherdevice.h>

#include <net/SI/ext_mem.h>

#include "psnet.h"
#include "psnet_io.h"
#include <mach/iomap.h>
#define WATCHDOG_TIMEO (5*HZ)

/* NET NUMBER;  channel id;  lan/wan*/

static unsigned int ddr_net_collect[DDR_DEV_MAX][2]= {
		{DDR_DEV_WAN1, NET_WAN},
		{DDR_DEV_WAN2, NET_WAN},
		{DDR_DEV_WAN3, NET_WAN},
		{DDR_DEV_WAN4, NET_WAN},
		{DDR_DEV_WAN5, NET_WAN},
		{DDR_DEV_WAN6, NET_WAN},
		{DDR_DEV_WAN7, NET_WAN},
		{DDR_DEV_WAN8, NET_WAN}	
};

//int *vir_addr_ddrnet = ZX_DDR_PSBUF_BASE;
int *vir_addr_ddrnet = 0;
EXPORT_SYMBOL(vir_addr_ddrnet);

static struct net_device *psnet_dev[DDR_DEV_MAX];

struct psnet *global_psnet[DDR_DEV_MAX];

extern int (*fast_from_driver)(struct sk_buff *skb, struct net_device* dev);

void psnet_get_flow_statistic_by_sim(unsigned long *tx_bytes, unsigned long *rx_bytes, unsigned char sim)
{
	int i = 0;
	
	if(sim){
		for(i = 4; i < DDR_DEV_MAX; i++)
		{
			if(psnet_dev[i]){
				*tx_bytes+=psnet_dev[i]->stats.tx_bytes;
				*rx_bytes+=psnet_dev[i]->stats.rx_bytes;
			}
		}
	} else {
		for(i = 0; i < DDR_DEV_MAX-4; i++)
		{
			if(psnet_dev[i]){
				*tx_bytes+=psnet_dev[i]->stats.tx_bytes;
				*rx_bytes+=psnet_dev[i]->stats.rx_bytes;
			}
		}
	}
	err("psnet get_flow_statistic sim=%d\n", sim);
}

void psnet_reset_stat_by_sim(unsigned char sim)
{
	int i = 0;
	
	if(sim){
		for(i = 4; i < DDR_DEV_MAX; i++)
		{
			if(psnet_dev[i])
				memset(&psnet_dev[i]->stats, 0, sizeof(struct net_device_stats));
		}
	} else {
		for(i = 0; i < DDR_DEV_MAX-4; i++)
		{
			if(psnet_dev[i])
				memset(&psnet_dev[i]->stats, 0, sizeof(struct net_device_stats));
		}
	}
	err("psnet reset_stat sim=%d\n", sim);
}

static psnet_receive_thread(unsigned long param)
{
    struct psnet *dev = (struct psnet *)param;
    struct sk_buff    *skb;
	int status;

	struct sched_param sch_param = { .sched_priority = 1 };
	sch_param.sched_priority = 37;
	sched_setscheduler(current, SCHED_FIFO, &sch_param);
	
    while(1) {

		if (dev->rxq.qlen == 0) 
		{
			// avoid to continue calling wake_up_process() when cmd_thread is NULL
			//set_bit(WAKE_EVENT_CMD, &pshare->wake_event);
			//DECLARE_WAITQUEUE(wait, current);
			//add_wait_queue(&dev->waitqueue, &wait);
			set_current_state(TASK_KILLABLE);			
			//printk("[%s] is closed (%d)\n",dev->net->name, dev->bOpen);
			schedule();
			set_current_state(TASK_RUNNING);	
			//remove_wait_queue(&dev->waitqueue, &wait);
			continue;
		}		
		skb = skb_dequeue(&dev->rxq);
		//TO DO read data from ps and trans to skb data
		
        if (skb && skb->len)
    	{
	    	skb->protocol = eth_type_trans (skb, dev->net);

		    status = netif_rx (skb);
		    if (status == NET_RX_SUCCESS) {
		        dev->net->stats.rx_packets++;
		        dev->net->stats.rx_bytes += skb->len;
		    } else {
		        dev->net->stats.rx_errors++;
		        err("netif_rx status %d.", status);
		    }
    	}
        else {
            dev->net->stats.rx_errors++;
            
            dev_kfree_skb (skb);
            err("drop!!!psnet_bh skb len == 0.");
        }
    }
}

static int psnet_open(struct net_device *net)
{
	//int retval;
	struct psnet *dev = netdev_priv(net);
	if(dev->initflag != 1)
		return 0;
	info("psnet_open %s", dev->net->name);
	
	if(net->flags & IFF_UP) {
		dbg("the %s has been opened!", dev->net->name);
		return -EBUSY;
	}
	if(dev->rcv_thread == NULL)
    	dev->rcv_thread = kthread_run(psnet_receive_thread, dev, "psnet-thread/%s", dev->net->name);
	else
		wake_up_process(dev->rcv_thread);
	netif_start_queue (net);
	dev->channelOpen(dev->index);
	dev->initflag = 2;
	return 0;
}

static int psnet_close(struct net_device *net)
{
    struct psnet *dev = netdev_priv(net);
	if(dev->initflag != 2)
		return 0;
    info("psnet_close");
    netif_stop_queue(net);
	dev->channelClose(dev->index);
    //tasklet_kill (&dev->rx_bh);
	dev->initflag = 1;
	return 0;
}
extern unsigned long skb_max_panic;
extern atomic_t  skb_used;
extern atomic_t  skb_tops;
extern atomic_t  skb_fromps;
/* Called by the kernel in order to transmit a packet. */
static netdev_tx_t psnet_xmit(struct sk_buff *skb, struct net_device *net)
{
	unsigned int length;
	unsigned char *psbuff;
	struct psnet *dev = netdev_priv(net);
	int retval = 0;

	if (!skb) {
		panic("skb  err!!!!");
	}
	if(skb_max_panic && (atomic_read(&skb_tops) > skb_max_panic))
	{
		kfree_skb(skb);
		//printk("skb=%d tops fail tops=%d fromps=%d\n",atomic_read(&skb_used),atomic_read(&skb_tops),atomic_read(&skb_fromps));
		net->stats.tx_dropped++;
		return NET_XMIT_SUCCESS;		  
	}
	//ƫipͷ
	skb_pull(skb, ETH_HLEN);

	//ˢcache
	skb = flush_skbuf(skb);
	if (!skb) {
		panic("skb  err!!!!");
		return NET_XMIT_SUCCESS;		  
	}
	insert_toext_mem(skb);

	//TODO convert data to psbuf, wirte data to ps
	length = skb->len;
	retval = dev->transdataOut(dev->index, skb, length);
	if (retval == 0) {
		net->trans_start = jiffies;
		net->stats.tx_packets++;
		net->stats.tx_bytes += length;
		return NET_XMIT_SUCCESS;		  
	} else {
		if(printk_ratelimit())
		printk("write err, ret : %d!!!!\n", retval);
//		dev_kfree_skb(skb);
		free_toext_mem(skb);
		net->stats.tx_errors++;
		return NET_XMIT_SUCCESS;		  
	}

}
#if 0
static void psnet_rx_bh (unsigned long param)
{
    struct psnet *dev = (struct psnet *)param;
    struct sk_buff    *skb;
	int status;
    while(skb = skb_dequeue(&dev->rxq)) {
        if (skb->len)
    	{
	    	skb->protocol = eth_type_trans (skb, dev->net);

		    status = netif_rx (skb);
		    if (status == NET_RX_SUCCESS) {
		        dev->net->stats.rx_packets++;
		        dev->net->stats.rx_bytes += skb->len;
		    } else {
		        dev->net->stats.rx_errors++;
		        err("netif_rx status %d.", status);
		    }
    	}
        else {
            dev->net->stats.rx_errors++;
            
            dev_kfree_skb (skb);
            err("drop!!!psnet_bh skb len == 0.");
        }
    }
}
#endif 

/* Called by the kernel when transmit times out */
static void psnet_tx_timeout(struct net_device *net)
{
    err("sent timeout!");
    net->stats.tx_errors++;
    netif_wake_queue(net);
}

#define PSBUFF_DL_HEADER_OFFSET 64 //80
//extern void * zGetpsbufferHead(void * data);
void psnet_recv_notify(unsigned int index, const void *buffer, unsigned int length)//(T_ZDrvRpMsg_Msg rpmsg)
{
	struct sk_buff    *skb;
	struct  psnet *dev = (struct  psnet *)global_psnet[index];
	struct T_FromExt_mem psData = { 0 };

	psData.pbuf_data = (void *)buffer;
#if 0
#ifdef USE_CPPS_KO
	psData.pbuf_head = (void *)cpps_callbacks.zGetpsbufferHead(buffer); 
#else
	psData.pbuf_head = (void *)zGetpsbufferHead(buffer); 
#endif
#else
    psData.pbuf_head = buffer - PSBUFF_DL_HEADER_OFFSET;
#endif
	psData.datalen = length;
      skb = skb_build_psbuf(&psData);

	if (!skb) 
	{
		//err("psnet_recv_notify can not allocate skb. drop the package");
		dev->net->stats.rx_dropped++;
	} 
	else 
	{
		skb_push(skb, ETH_HLEN);

		if (set_protocol_by_version(skb) < 0)
			return;

		if (fast_from_driver && fast_from_driver(skb, dev->net))
		{
			return;
		}

            memcpy(skb->data, dev->net->dev_addr, ETH_ALEN);
            memcpy(skb->data + ETH_ALEN, dev->net->dev_addr, ETH_ALEN);
			
		skb_queue_tail(&dev->rxq, skb);
		wake_up_process(dev->rcv_thread);
	}

}

static struct net_device_stats *psnet_get_stats(struct net_device *net)
{
//    dbg("%s: request for stats\n", net->name);
    return &net->stats;
}

const struct net_device_ops psnet_netdev_ops = {
    .ndo_open    = psnet_open,
    .ndo_stop    = psnet_close,
    .ndo_start_xmit = psnet_xmit,
    .ndo_tx_timeout = psnet_tx_timeout,
    .ndo_get_stats = psnet_get_stats,
};
int psnet_registerOpsCallback(unsigned int chID, functpye1* funcOpen, functpye1* funcClose, functpye2* funcOut)
{
	int nRet = -1;
	struct  psnet *dev = global_psnet[chID];
	if(funcOpen && funcClose && funcOut)
	{
		dev->channelOpen = funcOpen;
		dev->channelClose = funcClose;
		//rpmsg_channel->transdatatoRpmsg = funcIn;
		dev->transdataOut = funcOut;
		dev->initflag = 1;
		nRet = 0;
	}
	return nRet;
}

static inline void psnet_init_netdev(struct net_device *net)
{
    //memset(net->dev_addr, 0xfe, ETH_ALEN);
#if 0
	u8 mac[ETH_ALEN] = {0x0, 0xa0, 0xc6, 0x11, 0x22, 0x33};
	memcpy(net->dev_addr, mac, ETH_ALEN);
#else
	// randomly generated ethernet address
	static u8 node_id [ETH_ALEN];
	random_ether_addr(node_id);
	memcpy (net->dev_addr, node_id, sizeof node_id);
#endif
    net->netdev_ops = &psnet_netdev_ops;
    net->watchdog_timeo = WATCHDOG_TIMEO;
    net->flags |= IFF_NOARP;
}
static inline void psnet_init_lan(struct net_device *net, unsigned int index)
{
    struct psnet *dev;
    dev = netdev_priv(net);
    dev->net = net;
    //strcpy(net->name, "lan%d");
    sprintf(net->name, "ps%d", index+1);
    dev->lan = 1;
    skb_queue_head_init (&dev->rxq);
}

static inline void psnet_init_wan(struct net_device *net, unsigned int index)
{
    struct psnet *dev;
	//unsigned wan_index;
    dev = netdev_priv(net);
    dev->net = net;
	sprintf(net->name, "wan%d", index+1);// WAN1, WAN2,....
    dev->lan = 0;
    skb_queue_head_init (&dev->rxq);
}


static int __init psnet_init(void)
{
    int i;
    int err;
    struct psnet *dev;
    struct net_device *net;
	
    dbg("ddr_ap_net_lan_init.\n");
    
    err = -ENOMEM;
    for (i = 0; i < DDR_DEV_MAX; i++){
    //for (i = 0; i < 1; i++) {
        net = alloc_etherdev(sizeof(struct psnet));
        if (!net) {
            printk(KERN_ERR "could not allocate device.\n");
            return err;
        }

        //ȷзcpͷԤ㹻ˢcacheʱskb
        net->needed_headroom += NET_SKB_PAD - ETH_HLEN;
        
        dev = netdev_priv(net);
        global_psnet[i] = dev;

        if(ddr_net_collect[i][1] == NET_LAN)
        {
        	printk("NET_LAN :%d\n",i);
        	psnet_init_lan(net, i);
        }
        else if (ddr_net_collect[i][1] == NET_WAN)
        {
        	psnet_init_wan(net, i);
		printk("NET_WAN :%d\n",i);
        }
        else
        {
        	printk("NET_error :%d\n",i);
        	goto out_free_netdev;
        }
	dev->index = i;
	dev->net = net;
        //dev->rx_bh.func = psnet_rx_bh;
        //dev->rx_bh.data = (unsigned long) dev;
		//sema_init(&dev->skb_que_sem,1);
		//init_waitqueue_head(&dev->waitqueue);
		//init_completion(&dev->rcv_completion);
        psnet_init_netdev(net);
        err = register_netdev(net);
	printk("register_netdev error:%d :%d\n",err,i);
        if (err)
            goto out_free_netdev;
        psnet_dev[i] = net;
//		psnet_start(net);
    }

    return 0;

out_free_netdev:
    free_netdev(net);
    return err;
}
late_initcall(psnet_init);

static void __exit psnet_exit(void)
{
    int i;
    struct net_device *net;

    for (i = 0; i < DDR_DEV_MAX; i++) {
        if ((net = psnet_dev[i])) {
            unregister_netdev(net);
            free_netdev(net);
            psnet_dev[i] = NULL;
        }
    }
}
module_exit(psnet_exit);

MODULE_AUTHOR("P96G");
MODULE_DESCRIPTION("7510 AP Lan Net Device");
MODULE_LICENSE("GPL");
