#define NEW_PS_BUF
#include <linux/module.h>
#include "psnet.h"
#include "psnet_io.h"
#include <linux/cp_types.h>
#include <linux/soc/zte/rpm/rpmsg_sim.h>
#include "zpsi_api.h"
#include <linux/if_addr.h>
#include <linux/if_arp.h>
#include <linux/ipv6.h>
#include <linux/icmpv6.h>
#include <net/ipv6.h>
#include <net/protocol.h>
#include <net/ndisc.h>

extern struct psnet *global_psnet[DDR_DEV_MAX];

#define ZATI2_DATA_CHANNEL_ID_NUM_START		(CHANNEL_AP2PS_MAXID)//+1
#define ZATI2_DATA_CHANNEL_BASE 90
#define ZATI2_DATA_CHANNEL_BASE_SIM0 0
#ifdef USE_DSDS_VSIM
#define ZATI2_DATA_CHANNEL_BASE_SIM1 ZATI2_DATA_CHANNEL_BASE
#else
#define ZATI2_DATA_CHANNEL_BASE_SIM1 0
#endif

#define PSNET_IO_SUCCESS	0
#define PSNET_IO_ERROR		1
//ֽڶ
#define MAC4BYTE_ASSERT 	4
#define MAC2BYTE_ASSERT 	2

#define  ZATI2_SUCCESS	0
#define  ZATI2_ERROR	1

typedef struct _PS_CHID_INFO{
	unsigned int chid;
	unsigned int  stat; 
} PS_CHID_INFO;

static PS_CHID_INFO s_pschid_info[DDR_DEV_MAX] = {
		{ZATI2_DATA_CHANNEL_ID_NUM_START +ZATI2_DATA_CHANNEL_BASE_SIM0+ 0, 0},
		{ZATI2_DATA_CHANNEL_ID_NUM_START +ZATI2_DATA_CHANNEL_BASE_SIM0+ 1, 0},
		{ZATI2_DATA_CHANNEL_ID_NUM_START +ZATI2_DATA_CHANNEL_BASE_SIM0+ 2, 0},
		{ZATI2_DATA_CHANNEL_ID_NUM_START +ZATI2_DATA_CHANNEL_BASE_SIM0+ 3, 0},
		{ZATI2_DATA_CHANNEL_ID_NUM_START +ZATI2_DATA_CHANNEL_BASE_SIM1+ 4, 0},
		{ZATI2_DATA_CHANNEL_ID_NUM_START +ZATI2_DATA_CHANNEL_BASE_SIM1+ 5, 0},
		{ZATI2_DATA_CHANNEL_ID_NUM_START +ZATI2_DATA_CHANNEL_BASE_SIM1+ 6, 0},
		{ZATI2_DATA_CHANNEL_ID_NUM_START +ZATI2_DATA_CHANNEL_BASE_SIM1+ 7, 0}
};
extern PBYTE zPutSkb2Psbuf(PBYTE pbIpData, WORD wIpDataLen, PBYTE pbPdcpPduAddr, PBYTE pbSkbAddr);
extern WORD zGetUpLinkSduSize(VOID);
enum ip_ver {
	IP_V4,
	IP_V6,
	MAX_IP_VER
};

extern VOID zFreeDlBuf(PBYTE pBuf);

struct nd_opt_prefix_info     /* prefix information */
{
	uint8_t   nd_opt_pi_type;
	uint8_t   nd_opt_pi_len;
	uint8_t   nd_opt_pi_prefix_len;
	uint8_t   nd_opt_pi_flags_reserved;
	uint32_t  nd_opt_pi_valid_time;
	uint32_t  nd_opt_pi_preferred_time;
	uint32_t  nd_opt_pi_reserved2;
	struct in6_addr nd_opt_pi_prefix;
};

struct psnet_RA_info
{
	unsigned int flag;
	struct in6_addr prefix;
	unsigned char prefix_len;
	unsigned char ext_cid;
	struct semaphore sem;
};
typedef void (*set_pdp_state_CB)(unsigned char cid, unsigned int state);
typedef int (*get_ipv6_prefix_CB)(unsigned char cid, int len, unsigned char *prefix, unsigned char *prefix_len);
extern set_pdp_state_CB g_psnet_set_RA_state;
extern get_ipv6_prefix_CB g_psnet_get_prefix;
extern int zAti2_IsExCid(unsigned char cid, unsigned char *pcid);
struct psnet_RA_info g_psnet_ipv6_prefix[DDR_DEV_MAX] = {0};

void psnet_parse_RA_pkt(unsigned char cid, unsigned char* pkt, int len)
{
	//warn("cid=%d flag=%d\n", cid, g_psnet_ipv6_prefix[cid-1].flag);
	if(likely(g_psnet_ipv6_prefix[cid-1].flag))
		return;

	if (cid > 0 && cid <= DDR_DEV_MAX && (pkt[0] & 0xF0) == 0x60 && len >= (sizeof(struct ipv6hdr) + sizeof(struct ra_msg) + sizeof(struct nd_opt_prefix_info))){
		struct ipv6hdr *ip6h = (struct ipv6hdr *)pkt;
		unsigned char nexthdr = ip6h->nexthdr;
		unsigned char *hp = pkt + sizeof(struct ipv6hdr);
		warn("cid=%d nexthdr=%d data=%d\n", cid,nexthdr,(*hp));
		while((nexthdr == NEXTHDR_HOP)||(nexthdr == NEXTHDR_ROUTING)|| (nexthdr == NEXTHDR_DEST)){
			nexthdr = *hp;
			hp = hp + ipv6_optlen((struct ipv6_opt_hdr *)hp);
		}
		if(nexthdr == IPPROTO_ICMPV6 && (*hp) == NDISC_ROUTER_ADVERTISEMENT){
			struct nd_opt_hdr *nd_opt = (struct nd_opt_hdr *)(hp + sizeof(struct ra_msg));
			int opt_len = len - sizeof(struct ipv6hdr) - sizeof(struct ra_msg);
			while (opt_len) {
				int l;
				if (opt_len < sizeof(struct nd_opt_hdr))
					return;
				l = nd_opt->nd_opt_len << 3;
				if (opt_len < l || l == 0)
					return;
				if((nd_opt->nd_opt_type) == ND_OPT_PREFIX_INFO){
					struct nd_opt_prefix_info *pinfo = (struct nd_opt_prefix_info *)nd_opt;
					unsigned char ext_cid = 0;
#ifdef USE_CPPS_KO
					cpps_callbacks.zAti2_IsExCid(cid, &ext_cid);
#else
					zAti2_IsExCid(cid, &ext_cid);
#endif
					if(ext_cid){
						g_psnet_ipv6_prefix[cid-1].flag = 2;
						g_psnet_ipv6_prefix[cid-1].ext_cid = ext_cid;
						g_psnet_ipv6_prefix[ext_cid-1].ext_cid = cid;
					}else{
						ext_cid = cid;
					}
					memcpy(&g_psnet_ipv6_prefix[ext_cid-1].prefix, &pinfo->nd_opt_pi_prefix, sizeof(struct in6_addr));
					g_psnet_ipv6_prefix[ext_cid-1].prefix_len = pinfo->nd_opt_pi_prefix_len;
					g_psnet_ipv6_prefix[ext_cid-1].flag = 1;
					up(&g_psnet_ipv6_prefix[ext_cid-1].sem);
					warn("cid=%d prefix_len=%d\n", ext_cid, pinfo->nd_opt_pi_prefix_len);
					return;
				}
				opt_len -= l;
				nd_opt = ((void *)nd_opt) + l;
			}
		}
	}
}

void psnet_set_RA_state(unsigned char cid, unsigned int flag)
{
	if(cid > 0 && cid <= DDR_DEV_MAX){
		unsigned char ext_cid = g_psnet_ipv6_prefix[cid-1].ext_cid;
		warn("cid=%d flag=%d cur_flg=%d ext=%d\n", cid, flag, g_psnet_ipv6_prefix[cid-1].flag, ext_cid);
		if(flag == 0 && ext_cid > 0 && ext_cid <= DDR_DEV_MAX){
			warn("ext cid=%d cur_flg=%d ext=%d\n", ext_cid, 
				g_psnet_ipv6_prefix[ext_cid-1].flag, g_psnet_ipv6_prefix[ext_cid-1].ext_cid);
			if(g_psnet_ipv6_prefix[cid-1].flag == 1){
				g_psnet_ipv6_prefix[ext_cid-1].flag = 0;
			}
			g_psnet_ipv6_prefix[ext_cid-1].ext_cid = 0;
			g_psnet_ipv6_prefix[cid-1].ext_cid = 0;
		}
		g_psnet_ipv6_prefix[cid-1].flag = flag;
		if(flag == 0){
			int ret = down_trylock(&g_psnet_ipv6_prefix[cid-1].sem);
			if(ret != 0)//cov
				warn("cid=%d down_trylock ret=%d\n", cid, ret);
		}
		return;
	}
	err("err cid=%d flag=%d \n", cid, flag);
}

int psnet_get_prefix(unsigned char cid, int len, unsigned char *prefix, unsigned char *prefix_len)
{
	if(cid > 0 && cid <= DDR_DEV_MAX){
		if(g_psnet_ipv6_prefix[cid-1].flag == 0){
			int ret = down_timeout(&g_psnet_ipv6_prefix[cid-1].sem, 3*HZ);
			if(ret != 0)//cov
				err("err ipv6_prefix down_timeout ret=%d\n", ret);
		}
		if(g_psnet_ipv6_prefix[cid-1].flag == 1 
			&& len > (((g_psnet_ipv6_prefix[cid-1].prefix_len/8+1)/2) * 5)){
			int i = 0;
			unsigned char* prefix_str = prefix;
			int prefix_temp = g_psnet_ipv6_prefix[cid-1].prefix_len/8;
			
			for (i = 0; i < prefix_temp; i++) {
				sprintf(prefix_str + strlen(prefix_str), "%02x", g_psnet_ipv6_prefix[cid-1].prefix.s6_addr[i]);
				if (i % 2 == 1)
					sprintf(prefix_str + strlen(prefix_str), "%s", ":");
			}
			warn("cid=%d len=%d plen=%d prefix=%s\n", cid, len, g_psnet_ipv6_prefix[cid-1].prefix_len, prefix);
			*prefix_len = g_psnet_ipv6_prefix[cid-1].prefix_len;
			return strlen(prefix)+1;
		}
		err("err flag=%d pflen=%d \n", g_psnet_ipv6_prefix[cid-1].flag, g_psnet_ipv6_prefix[cid-1].prefix_len);
	}
	err("err cid=%d len=%d \n", cid, len);
	return 0;
}

void psnet_freepsbuf(void *head)
{
#ifdef USE_CPPS_KO
		cpps_callbacks.zFreeDlBuf(head);
#else
    	zFreeDlBuf(head);	
#endif
}
/*
unsigned int psnet_get_pschid_stat(unsigned int chid)
{
	unsigned int index = (chid>ZATI2_DATA_CHANNEL_BASE)?(chid-ZATI2_DATA_CHANNEL_BASE-ZATI2_DATA_CHANNEL_ID_NUM_START):(chid-ZATI2_DATA_CHANNEL_ID_NUM_START);
	return s_pschid_info[index].stat;
}*/

void psnet_set_pschid_stat(unsigned int chid, unsigned int newstat)
{
	unsigned int index = (chid>ZATI2_DATA_CHANNEL_BASE)?(chid-ZATI2_DATA_CHANNEL_BASE-ZATI2_DATA_CHANNEL_ID_NUM_START):(chid-ZATI2_DATA_CHANNEL_ID_NUM_START);
	if(index < DDR_DEV_MAX)
		s_pschid_info[index].stat = newstat;
}

unsigned char psnet_get_pschid_stat_all(void)
{
	unsigned char stat = 0;
	int i = 0;
	
	for(i = 0; i < DDR_DEV_MAX; i++)
	{
		if(s_pschid_info[i].stat)
			stat |= (1<<(i));
	}
	err("psnet stat=%d\n", stat);
	return stat;
}

void psnet_set_pschid_stat_by_sim(unsigned char stat, unsigned char sim)
{
	int i = 0;
	
	if(sim){
		for(i = 4; i < DDR_DEV_MAX; i++)
		{
			s_pschid_info[i].stat = (stat&(1<<(i)))?1:0;
		}
	} else {
		for(i = 0; i < DDR_DEV_MAX-4; i++)
		{
			s_pschid_info[i].stat = (stat&(1<<(i)))?1:0;
		}
	}
	err("psnet stat=%d sim=%d\n", stat, sim);
}

static int psnet_write(struct sk_buff  *skb, unsigned long data_len, unsigned char ip_type, int ch_id)
{
	int ret  = 1;
	unsigned char * pdata = skb->data;
    //EL2DDRѹUL EPDCP NODEEL2й
    //APٽ룬ֵͷŹ
    //unsigned char * pdcpDataAddr = skb->head;
       unsigned char * pdcpDataAddr = NULL;
#ifdef USE_CPPS_KO
	PBYTE p_to_ps_packet = (PBYTE)cpps_callbacks.zPutSkb2Psbuf(pdata, data_len, pdcpDataAddr, skb);
#else
	PBYTE p_to_ps_packet = (PBYTE)zPutSkb2Psbuf(pdata, data_len, pdcpDataAddr, skb);
#endif
	if(p_to_ps_packet == NULL)
		panic("get ulbufaddr error ");
		
	//p_to_ps_packet->wIpPacketLen    = (UINT16)(data_len);
	//p_to_ps_packet->wIpPacketOffSet = (UINT16)(pdata - (UINT8 *)p_to_ps_packet->Data);        

	//printk("[ZJT] IPType =%d , skb->len = %d, ch_id = %d \r\n", ip_type, data_len, ch_id);
#ifdef USE_CPPS_KO
	WORD SduSize = cpps_callbacks.zGetUpLinkSduSize();
#else
	WORD SduSize = zGetUpLinkSduSize();
#endif
	if(0 == ip_type)   	
#ifdef USE_CPPS_KO
		ret = cpps_callbacks.zAti2_Send(ch_id, (UINT8*)p_to_ps_packet, SduSize, ZATI2_CHIND_PSD);
#else
		ret = zAti2_Send(ch_id, (UINT8*)p_to_ps_packet, SduSize, ZATI2_CHIND_PSD);
#endif
	else if(1 == ip_type)	
#ifdef USE_CPPS_KO
		ret = cpps_callbacks.zAti2_Send(ch_id, (UINT8*)p_to_ps_packet, SduSize, ZATI2_CHIND_PSDV6);
#else
		ret = zAti2_Send(ch_id, (UINT8*)p_to_ps_packet, SduSize, ZATI2_CHIND_PSDV6);
#endif
	else
		panic("send data with wrong ip_type ");

	return (0-ret);
}
int open_flag[DDR_DEV_MAX] = {0};
int psnet_IOOpen(unsigned int index)
{
	int chid;
	int ret;
	char pStr[20] = {0};
	
	if(index >= DDR_DEV_MAX)
	{
		err("%s: chid [%d] is illegal \n", __func__, index);
		return PSNET_IO_ERROR;
	}

	chid = s_pschid_info[index].chid;
	if(0 == open_flag[index])
	{
#ifdef USE_CPPS_KO
		ret = cpps_callbacks.zAti2_Open(chid);
#else
		ret = zAti2_Open(chid);
#endif
		if(ret != ZATI2_SUCCESS)
		{
			panic("open chid failed");
		}
		open_flag[index]=1;
	}

	//ZGACTǰͨΪ̬һֱΪ̬	
	sprintf((char *)pStr, "\r\nAT+ZGACT=1,%d\r\n",index+1);	
	//printk("[zjt] chid= %d, pStr =%s \n", chid, pStr);
#ifdef USE_CPPS_KO
	ret = cpps_callbacks.zAti2_Send(chid, pStr, strlen(pStr), ZATI2_CHIND_AT); 
#else
	ret = zAti2_Send(chid, pStr, strlen(pStr), ZATI2_CHIND_AT);	
#endif
	if(ret != 0)	
	{		
		err("send %s to %d  failed!!!", pStr, chid);
	}
	return PSNET_IO_SUCCESS;
}

int psnet_IOClose(unsigned int index)
{
	int chid;

	if(index >= DDR_DEV_MAX)
	{
		err("%s: dev index [%d] is illegal \n", __func__, index);
		return PSNET_IO_ERROR;
	}	

	chid = s_pschid_info[index].chid;
	if(s_pschid_info[index].stat != 1)
	{
		err("%s: chid [%d] is already deact, please check !!! \n", __func__, chid);
		return PSNET_IO_ERROR;
	}

	//ZGACTǰͨΪAT̬
#ifdef USE_CPPS_KO
	cpps_callbacks.zAti2_Send(chid, NULL, 0, ZATI2_CHIND_TURN_AT);
#else
	zAti2_Send(chid, NULL, 0, ZATI2_CHIND_TURN_AT);
#endif
	s_pschid_info[index].stat = 0;
	
	return 0;
}
extern int atio_is_scaning(void);
int psnet_transIPdataToPS(unsigned int index, struct sk_buff * skb, unsigned int length)
{

    	unsigned long flags;
	int chid;		
	int ret = 0;

	unsigned char * buffer  = skb->data;
	if(index >= DDR_DEV_MAX)
	{
		err("%s: chid [%d] is illegal \n", __func__, index);
		return PSNET_IO_ERROR;
	}	

	if(buffer == NULL)//cov_2 || length < 0)
	{
		err("%s:  Input data is not valid \n", __func__);
		return PSNET_IO_ERROR;
	}

	chid = s_pschid_info[index].chid;

	//if(!((unsigned long)buffer%MAC4BYTE_ASSERT != 0) || !((unsigned long)buffer % MAC2BYTE_ASSERT == 0))
	//	panic("wrong skb data");
	
	if((s_pschid_info[index].stat == 1) 
#ifdef USE_DSDS_VSIM
		&& (atio_is_scaning() == 0)
#endif
	){
		if ((((unsigned)buffer[0]) & 0xF0) == 0x40){
			ret = psnet_write(skb, length, IP_V4, chid); 
		}else if ((((unsigned)buffer[0]) & 0xF0) == 0x60){
			ret = psnet_write(skb, length, IP_V6, chid); 
		}else{
			//err("%s:: IP type of data is wrong!!!", __func__);
			return PSNET_IO_ERROR;
		}
	}
	else
	{
		//err("%s:: wan%d not ready!!!", __func__, index+1);
		return PSNET_IO_ERROR;
	}
	
	if(ret < 0)
	{
		//err("%s:: direct psnet_transIPdataToPS failed!!!\n", __func__);
		return PSNET_IO_ERROR;
	}

	return 0;
}
int transdataToTCPIP(unsigned int chid, void *buffer, unsigned int length)
{
#ifdef USE_DSDS_VSIM
	unsigned int index = (chid>ZATI2_DATA_CHANNEL_BASE)?(chid-ZATI2_DATA_CHANNEL_BASE-ZATI2_DATA_CHANNEL_ID_NUM_START):(chid-ZATI2_DATA_CHANNEL_ID_NUM_START);
#else
	unsigned int index = chid - ZATI2_DATA_CHANNEL_ID_NUM_START;
#endif
	//truct psnet *dev = global_psnet[index];
	psnet_recv_notify(index,buffer,length);
    	return 0;
}

int psnet_IOInit(void)
{
	int index;
	for (index = 0; index < DDR_DEV_MAX; index++)
	{
		psnet_registerOpsCallback(index, psnet_IOOpen, psnet_IOClose, psnet_transIPdataToPS);
		sema_init(&g_psnet_ipv6_prefix[index].sem, 0);
	}	
	g_psnet_set_RA_state = psnet_set_RA_state;
	g_psnet_get_prefix = psnet_get_prefix;
	return 0;
}

int psnet_IOExit(void)
{
	return 0;
}

late_initcall(psnet_IOInit);
module_exit(psnet_IOExit);

MODULE_AUTHOR("ZTE");
MODULE_DESCRIPTION("ZTE Lan Net Device");
MODULE_LICENSE("GPL");

