/**
 * aicwf_sdio.h
 *
 * SDIO function declarations
 *
 * Copyright (C) AICSemi 2018-2020
 */

#ifndef _AICWF_SDMMC_H_
#define _AICWF_SDMMC_H_

#ifdef AICWF_SDIO_SUPPORT
#include <linux/skbuff.h>
#include <linux/if_ether.h>
#include <linux/ieee80211.h>
#include <linux/semaphore.h>
#include "rwnx_cmds.h"
#define AICWF_SDIO_NAME                 "aicwf_sdio"
#define SDIOWIFI_FUNC_BLOCKSIZE         512

#define SDIO_VENDOR_ID_AIC              0xC8A1
#define SDIO_DEVICE_ID_AIC              0xC08D
#define SDIOWIFI_BYTEMODE_LEN_REG       0x02
#define SDIOWIFI_INTR_CONFIG_REG	    0x04
#define SDIOWIFI_SLEEP_REG	            0x05
#define SDIOWIFI_WAKEUP_REG             0x09
#define SDIOWIFI_FLOW_CTRL_REG          0x0A
#define SDIOWIFI_REGISTER_BLOCK         0x0B
#define SDIOWIFI_BYTEMODE_ENABLE_REG    0x11
#define SDIOWIFI_BLOCK_CNT_REG          0x12
#define SDIOWIFI_FLOWCTRL_MASK_REG      0x7F

#define SDIOWIFI_PWR_CTRL_INTERVAL      30
#define FLOW_CTRL_RETRY_COUNT           50
#define BUFFER_SIZE                     1536
#define TAIL_LEN                        4
#define TXQLEN                          (2048*4)

#define SDIO_SLEEP_ST                    0
#define SDIO_ACTIVE_ST                   1

#define DATA_FLOW_CTRL_THRESH 2
#ifdef CONFIG_TX_NETIF_FLOWCTRL
#define AICWF_SDIO_TX_LOW_WATER          100
#define AICWF_SDIO_TX_HIGH_WATER         500
#endif
typedef enum {
    SDIO_TYPE_DATA         = 0X00,
    SDIO_TYPE_CFG          = 0X10,
    SDIO_TYPE_CFG_CMD_RSP  = 0X11,
    SDIO_TYPE_CFG_DATA_CFM = 0X12
} sdio_type;

struct rwnx_hw;

#ifdef LESS_SKB
struct rx_buff {
    struct list_head queue;
    unsigned char *data;
    u32 len;
    u8_l *start;
    u8_l *end;
    u8_l *read;
};
#endif

struct aic_sdio_dev {
    struct rwnx_hw *rwnx_hw;
    struct sdio_func *func;
    struct sdio_func *func_msg;
    struct device *dev;
    struct aicwf_bus *bus_if;
    struct rwnx_cmd_mgr cmd_mgr;

    struct aicwf_rx_priv *rx_priv;
    struct aicwf_tx_priv *tx_priv;
    u32 state;
#ifdef CONFIG_TX_NETIF_FLOWCTRL
    u8 flowctrl;
    spinlock_t tx_flow_lock;
#endif
    #if defined(CONFIG_SDIO_PWRCTRL)
    //for sdio pwr ctrl
    struct timer_list timer;
    uint active_duration;
    struct completion pwrctrl_trgg;
    struct task_struct *pwrctl_tsk;
    spinlock_t pwrctl_lock;
    struct semaphore pwrctl_wakeup_sema;
    #endif
};
int aicwf_sdio_writeb(struct aic_sdio_dev *sdiodev, uint regaddr, u8 val);
void aicwf_sdio_hal_irqhandler(struct sdio_func *func);
void aicwf_sdio_hal_irqhandler_func2(struct sdio_func *func);

#if defined(CONFIG_SDIO_PWRCTRL)
void aicwf_sdio_pwrctl_timer(struct aic_sdio_dev *sdiodev, uint duration);
int aicwf_sdio_pwr_stctl(struct  aic_sdio_dev *sdiodev, uint target);
#endif
int aicwf_sdio_func_init(struct aic_sdio_dev *sdiodev);
void aicwf_sdio_func_deinit(struct aic_sdio_dev *sdiodev);
#ifdef CONFIG_TX_NETIF_FLOWCTRL
void aicwf_sdio_tx_netif_flowctrl(struct rwnx_hw *rwnx_hw, bool state);
#endif
int aicwf_sdio_flow_ctrl(struct aic_sdio_dev *sdiodev);
int aicwf_sdio_flow_ctrl_msg(struct aic_sdio_dev *sdiodev);
#ifdef LESS_SKB
int aicwf_sdio_recv_pkt(struct aic_sdio_dev *sdiodev, struct rx_buff *rxbuff, u32 size, u8 msg);
#else
int aicwf_sdio_recv_pkt(struct aic_sdio_dev *sdiodev, struct sk_buff *skbbuf, u32 size, u8 msg);
#endif
int aicwf_sdio_send_pkt(struct aic_sdio_dev *sdiodev, u8 *buf, uint count);
void *aicwf_sdio_bus_init(struct aic_sdio_dev *sdiodev);
void aicwf_sdio_release(struct aic_sdio_dev *sdiodev);
void aicwf_sdio_release_func2(struct aic_sdio_dev *sdiodev);
void aicwf_sdio_exit(void);
void aicwf_sdio_register(void);
int aicwf_sdio_txpkt(struct aic_sdio_dev *sdiodev, struct sk_buff *pkt);
#ifdef HANDLE_TX_THREAD_ZTE
int sdio_bustx_thread(void *data);
#else
void sdio_bustx_tasklet(void *data);
#endif
#ifdef HANDLE_RX_THREAD_ZTE
int sdio_busrx_thread(void *data);
#else
void sdio_busrx_tasklet(void *data);
#endif
int aicwf_sdio_aggr(struct aicwf_tx_priv *tx_priv, struct sk_buff *pkt);
int aicwf_sdio_send(struct aicwf_tx_priv *tx_priv, u8 txnow);
void aicwf_sdio_aggr_send(struct aicwf_tx_priv *tx_priv);
void aicwf_sdio_aggrbuf_reset(struct aicwf_tx_priv* tx_priv);
extern void aicwf_hostif_ready(void);
extern void aicwf_hostif_fail(void);
void aic_thread_wait_stop(void);
#ifdef CONFIG_PLATFORM_NANOPI
extern void extern_wifi_set_enable(int is_on);
extern void sdio_reinit(void);
#endif /*CONFIG_PLATFORM_NANOPI*/

#endif /* AICWF_SDIO_SUPPORT */

#endif /*_AICWF_SDMMC_H_*/
