/*
 * Copyright (c) 2015 iComm-semi Ltd.
 *
 * Permission to use, copy, modify, and/or distribute this software for any
 * purpose with or without fee is hereby granted, provided that the above
 * copyright notice and this permission notice appear in all copies.
 *
 * THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES
 * WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR
 * ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
 * ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
 * OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 */

/*
 * Common declarations and definitions between driver and firmware 
 * for SSV6020.
 */

#ifndef __SSV6020_COMMON_H__
#define __SSV6020_COMMON_H__

#include <ssv6xxx_common.h>
#define FW_VERSION_REG   ADR_TX_SEG
/*
    Reference with firmware
*/

/* Hardware Offload Engine ID */
#define M_ENG_CPU                       (0x00)
#define M_ENG_HWHCI                     (0x01)
//#define M_ENG_FRAG                    (0x02)
#define M_ENG_EMPTY                     (0x02)
#define M_ENG_ENCRYPT                   (0x03)
#define M_ENG_MACRX                     (0x04)
#define M_ENG_MIC                       (0x05)
#define M_ENG_TX_EDCA0                  (0x06)
#define M_ENG_TX_EDCA1                  (0x07)
#define M_ENG_TX_EDCA2                  (0x08)
#define M_ENG_TX_EDCA3                  (0x09)
#define M_ENG_TX_MNG                    (0x0A)
#define M_ENG_ENCRYPT_SEC               (0x0B)
#define M_ENG_MIC_SEC                   (0x0C)
#define M_ENG_RESERVED_1                (0x0D)
#define M_ENG_RESERVED_2                (0x0E)
#define M_ENG_TRASH_CAN                 (0x0F)
#define M_ENG_MAX                       (M_ENG_TRASH_CAN+1)


/* Software Engine ID: */
#define M_CPU_HWENG                     (0x00)
#define M_CPU_TXL34CS                   (0x01)
#define M_CPU_RXL34CS                   (0x02)
#define M_CPU_DEFRAG                    (0x03)
#define M_CPU_EDCATX                    (0x04)
#define M_CPU_RXDATA                    (0x05)
#define M_CPU_RXMGMT                    (0x06)
#define M_CPU_RXCTRL                    (0x07)
#define M_CPU_FRAG                      (0x08)
#define M_CPU_TXTPUT                    (0x09)

#ifndef ID_TRAP_SW_TXTPUT
#define ID_TRAP_SW_TXTPUT               (50) //(ID_TRAP_SW_START + M_CPU_TXTPUT - 1)
#endif //ID_TRAP_SW_TXTPUT

#endif /* __SSV6020_COMMON_H__ */
