/*******************************************************************************
 *                           Include header files                              *
 ******************************************************************************/
#include <linux/module.h>
#include <linux/etherdevice.h>
#include <net/sock.h>
#include "zvnet_dev.h"

/*******************************************************************************
 *                             Macro definitions                               *
 ******************************************************************************/
#define USE_ZVNET_PACKET

#define WATCHDOG_TIMEO (5*HZ)
#define XMIT_RETRANS_TIMES 3
#define ZVNET_SKB_PAD 128
#define ZVNET_TMP_BUFF_LEN 2048
#define ZVNET_FREE_BUFF_NUM 256
#define ZVNET_XMIT_BUFF_NUM 64
#define ZVNET_XMIT_MAX_QUEUE_NUM 2048

/*******************************************************************************
 *							   Type definitions 						*
 ******************************************************************************/
//APݸCAPݰϢд빲DDR
struct	T_zvnet_rpmsg
{
	void *buff;//skb_headָ룬ͷʱݸ˼䣬Աͷ;
	void *head;//˼ʹõĵַ߽磬Խ磬ڴ쳣;ַ
	unsigned short data_off;//˼䴫ݰ׵ַָMAC֡ͷ;ַ
	unsigned short len;//ݰЧȣһΪMAC֡
	unsigned short end_off;//end offset
	unsigned short dev;//cid 1->8
};
/*******************************************************************************
 *						   Local variable definitions					*
 ******************************************************************************/
struct zvnet_device zvnet_dev[DDR_ZVNET_DEV_MAX];
int *vir_addr_cap = NULL;
struct sk_buff_head g_zvnet_skb_queue;
struct zvnet_channel g_zvnet_chn_info;

#ifdef USE_ZVNET_PACKET
void *g_zvnet_free_buff[ZVNET_FREE_BUFF_NUM];
int g_zvnet_free_num;
spinlock_t g_zvnet_free_lock;
struct semaphore g_zvnet_free_sem;
struct semaphore g_zvnet_xmit_sem;
struct sk_buff_head g_zvnet_skb_xmit_queue;

unsigned int g_wrap_packet_size = 1000;
module_param(g_wrap_packet_size, int, 0644);
unsigned int g_wrap_num = 10;
module_param(g_wrap_num, int, 0644);
unsigned int g_wrap_timeout = 10;
module_param(g_wrap_timeout, int, 0644);
#endif

/*******************************************************************************
 *						  Global variable definitions					*
 ******************************************************************************/
extern int (*fast_from_driver)(struct sk_buff *skb, struct net_device* dev);
#ifdef CONFIG_SPEED_OPT
extern void skb_sys_pool_free(void        *ptr);
extern void *skb_sys_pool_alloc(size_t      size);
extern size_t skb_sys_pool_size(const void *ptr);
#endif
extern void psnet_freepsbuf(void *head);
extern atomic_t  skb_used;
extern atomic_t  skb_tops;
extern atomic_t  skb_fromps;
extern int skb_num_limit;
extern struct kmem_cache *skbuff_head_cache;
extern void dma_cache_maint(const void *vir_addr, const void *phy_addr, size_t size, int direction);
/*******************************************************************************
 *					   Local function declarations						*
 ******************************************************************************/
static int zvnet_open(struct net_device *net);
static int zvnet_close(struct net_device *net);
static netdev_tx_t zvnet_xmit(struct sk_buff *skb, struct net_device *net);
static void zvnet_tx_timeout(struct net_device *net);
static struct net_device_stats *zvnet_get_stats(struct net_device *net);
static void v2xnet_init_netdev(struct net_device *net);
static void zvnet_skb_return (struct zvnet *dev, struct sk_buff *skb);
static void zvnet_bh (unsigned long param);
static struct zvnet *v2xnet_dev_init(struct net_device *net, struct zvnet_device *zvnetdev);

static int zvnet_channel_write(struct zvnet_channel *chninfo, void *buf, unsigned int len);
static int zvnet_channel_read(struct zvnet_channel *chninfo, void *buf, unsigned int len);
static int zvnet_channel_clear(struct zvnet_channel *chninfo);
static int zvnet_read_header(struct zvnet_channel *chninfo, struct zvp_header *phzvp);
static struct sk_buff *zvnet_direct_read_skb(struct zvnet_channel *chninfo);
static struct sk_buff *zvnet_read_skb(struct zvnet_channel *chninfo, unsigned int tlen, struct zvnet *dev);
static int zvnet_receive_thread(void *argv);
static int rpmsgCreateChannel_v2xnet (T_ZDrvRpMsg_ActorID dstCoreID, T_ZDrvRpMsg_ChID chID, unsigned int size);
static int zvnet_createIcpChannel(T_ZDrvRpMsg_ActorID core_id, T_ZDrvRpMsg_ChID channel_id, unsigned int channel_size);
static int zvnet_channel_create(struct zvnet_device *zvnetdev);

/*******************************************************************************
 * 					 Local function implementations 						*
 ******************************************************************************/

unsigned long virt_to_phys_cap(unsigned long virt)
{
	if(virt >= (unsigned long)vir_addr_cap && virt <= ((unsigned long)vir_addr_cap+DDR_BASE_LEN_CAP)) 
		return DDR_BASE_CAP_ADDR_PA + (virt - (unsigned long)vir_addr_cap);
	return NULL;
}

unsigned long phys_to_virt_cap(unsigned long phys)
{
	if(phys >= DDR_BASE_CAP_ADDR_PA && phys <= (DDR_BASE_CAP_ADDR_PA + DDR_BASE_LEN_CAP)) 
		return (unsigned long)vir_addr_cap + (phys - DDR_BASE_CAP_ADDR_PA);
	return NULL;
}

void check_skb_test(struct sk_buff *skb)
{
	if(skb && vir_addr_cap){
		struct sk_buff *tmp_skb;
		if((skb->capHead && (virt_to_phys_cap(skb->head) == NULL))
		|| ((skb->capHead == NULL) && virt_to_phys_cap(skb->head))){
			dump_stack();
			msleep(1000);
			panic("capHead err");
		}
		skb_queue_walk(&g_zvnet_skb_queue, tmp_skb) {
			if(tmp_skb == skb){
				dump_stack();
				msleep(1000);
				panic("dup free");
			}
		}
	}
}

int zvnet_get_index_by_netdev(struct net_device *net)
{
    int i;

    for (i = 0; i < DDR_ZVNET_DEV_MAX; i++) {
        if(zvnet_dev[i].net == net)
            return i;
    }
    return -1;
}
#ifdef USE_ZVNET_PACKET
void write_free_apbuf_packet(void)
{
	int ret,size;
	unsigned long flags;
	void *buf[ZVNET_FREE_BUFF_NUM];

	spin_lock_irqsave(&g_zvnet_free_lock, flags);
	if(g_zvnet_free_num == 0){
		spin_unlock_irqrestore(&g_zvnet_free_lock, flags);
		return;
	}
	size = (g_zvnet_free_num << 2);
	memcpy(buf, g_zvnet_free_buff, size);
	g_zvnet_free_num = 0;
	spin_unlock_irqrestore(&g_zvnet_free_lock, flags);
	{
		T_ZDrvRpMsg_Msg msg = { .actorID = CAP_ID,
								.chID = channel_29,
								.flag = RPMSG_WRITE_INT};
		if((size >> 2) > ZVNET_FREE_BUFF_NUM)
			panic("free packet err");
		msg.buf = &buf;
		msg.len = size;
		zv_info("tofree size=%d", size);
		ret = zvnetWriteLockIrq(&msg);
		if(ret < 0)
			panic("err, ret:%d!!!!!!", ret);
	}
}
#endif
//CAPഫcapbufָдDDRICPʽ֪ͨCAP
void write_free_capbuf(void *head)
{
#ifdef USE_ZVNET_PACKET
	unsigned long flags;

	zv_info("g_zvnet_free_num=%d,skb=0x%x", g_zvnet_free_num, head);
	spin_lock_irqsave(&g_zvnet_free_lock, flags);
	g_zvnet_free_buff[g_zvnet_free_num] = head;
	g_zvnet_free_num++;
	if(g_zvnet_free_num == ZVNET_FREE_BUFF_NUM){
		int size;
		void *buf[ZVNET_FREE_BUFF_NUM];
		
		size = (g_zvnet_free_num << 2);
		memcpy(buf, g_zvnet_free_buff, size);
		g_zvnet_free_num = 0;
		spin_unlock_irqrestore(&g_zvnet_free_lock, flags);
		if((size >> 2) > ZVNET_FREE_BUFF_NUM)
			panic("free packet err");
		{
			int ret;
			T_ZDrvRpMsg_Msg msg = { .actorID = CAP_ID,
									.chID = channel_29,
									.flag = RPMSG_WRITE_INT};
			msg.buf = &buf;
			msg.len = size;
			if(printk_ratelimit())
				zv_warn("tofree quick size=%d", size);
			ret = zvnetWriteLockIrq(&msg);
			if(ret < 0)
				panic("err, ret:%d!!!!!!", ret);
		}
		return;
	}
	if(g_zvnet_free_num > g_wrap_num)
		up(&g_zvnet_free_sem);
	if(g_zvnet_free_num > ZVNET_FREE_BUFF_NUM)
		panic("free_buff err");
	spin_unlock_irqrestore(&g_zvnet_free_lock, flags);
#else
	int ret = 0;
	long buf = (long)head;
	
	T_ZDrvRpMsg_Msg msg = { .actorID = CAP_ID,
							.chID = channel_29,
							.flag = RPMSG_WRITE_INT,
							.buf = NULL,
							.len = 4 };
	msg.buf = &buf;
	zv_info("tofree 0x%x", head);
	ret = zvnetWrite(&msg);
	if(ret < 0)
		panic("err, ret:%d!!!!!!", ret);
#endif	
}

struct sk_buff *skb_build_capbuf(struct T_zvnet_rpmsg *pbuf_temp)
{
	struct skb_shared_info *shinfo;
	struct sk_buff *skb;
	unsigned int size;
	int          len;
	zv_info("build 0x%x 0x%x %d %d", pbuf_temp->buff, pbuf_temp->head, pbuf_temp->data_off, pbuf_temp->len);
	if((unsigned long )pbuf_temp->head < DDR_BASE_CAP_ADDR_PA || (unsigned long )pbuf_temp->head > (DDR_BASE_CAP_ADDR_PA + DDR_BASE_LEN_CAP)){
		zv_err("err 0x%x 0x%x %d %d", pbuf_temp->buff, pbuf_temp->head, pbuf_temp->data_off, pbuf_temp->len);
		panic("addr is not CAPBUF mem!!!");
		return NULL;
	}

	if(skb_num_limit && (atomic_read(&skb_used) > skb_num_limit))
	{
		write_free_capbuf(pbuf_temp->buff);
		if(printk_ratelimit())
		zv_err("skb=%d capbuff fail tops=%d fromps=%d\n",atomic_read(&skb_used),atomic_read(&skb_tops),atomic_read(&skb_fromps));
		return NULL;
	}
#ifndef CONFIG_SPEED_OPT
#ifdef CONFIG_SLOB_OPT
	skb = kmalloc(kmem_cache_size(skbuff_head_cache), GFP_ATOMIC);
#else
	skb = kmem_cache_alloc(skbuff_head_cache, GFP_ATOMIC);
#endif
#else
    skb =  skb_sys_pool_alloc(kmem_cache_size(skbuff_head_cache));
#endif
	if (!skb)
	{
		write_free_capbuf(pbuf_temp->buff);
		zv_err("skb=%d alloc fail tops=%d fromps=%d\n",atomic_read(&skb_used),atomic_read(&skb_tops),atomic_read(&skb_fromps));
		return NULL;
	}
	skb_alloc_track(skb);
	memset(skb, 0, offsetof(struct sk_buff, tail));

	//жǷcapbuff
	
	if(pbuf_temp->dev < 0 || pbuf_temp->dev >= DDR_ZVNET_DEV_MAX)
		panic("dev index error!!!");
	skb->head = phys_to_virt_cap((unsigned long )pbuf_temp->head);
	skb->data = skb->head + pbuf_temp->data_off;
	skb->capHead = pbuf_temp->buff;
	//Ҫcacheж
	skb->truesize = SKB_TRUESIZE(skb->data - skb->head + pbuf_temp->len);//βпõڴռ䣬ʱδ;SKB_DATA_ALIGN 

	atomic_set(&skb->users, 1);
	skb_reset_tail_pointer(skb);
	skb->tail += pbuf_temp->len;
	skb->len = pbuf_temp->len;
	skb->end = skb->head + pbuf_temp->end_off;
	skb->dev = zvnet_dev[pbuf_temp->dev].net;
	if(skb->len == 0 || skb->len > 2000)
		panic("len    ERR!!!!!!!!!!\n");
	/* make sure we initialize shinfo sequentially */
	dma_cache_maint(skb->head, pbuf_temp->head, pbuf_temp->end_off + sizeof(struct skb_shared_info), DMA_FROM_DEVICE);
	if(IFF_NOARP & skb->dev->flags)
		memcpy(skb->data, skb->dev->dev_addr, 6);
	skb_reset_network_header(skb);
	shinfo = skb_shinfo(skb);
	//memset(shinfo, 0, offsetof(struct skb_shared_info, dataref));
	atomic_set(&shinfo->dataref, 1);
	//kmemcheck_annotate_variable(shinfo->destructor_arg);
	return skb;
}


static void skb_debug_test(struct sk_buff *skb)
{
    int i;
    int vcount = skb->len/10;
    int rcount = skb->len%10;
    char tmp[64] = {0};
    char strbuf[64] = {0};

    zv_info("\n");
    for(i=0; i<vcount; i++) {
        zv_info("%d---0x%x,0x%x,0x%x,0x%x,0x%x,0x%x,0x%x,0x%x,0x%x,0x%x\n",i,skb->data[0+10*i],skb->data[1+10*i],skb->data[2+10*i],
                skb->data[3+10*i],skb->data[4+10*i],skb->data[5+10*i],skb->data[6+10*i],skb->data[7+10*i],skb->data[8+10*i],skb->data[9+10*i]);
    }
    if(vcount > 0) {
        memset(tmp,0,sizeof(tmp));
        memset(strbuf,0,sizeof(strbuf));
        sprintf(strbuf,"%d---",vcount);

        for(i=0; i<rcount; i++)
        {
            sprintf(tmp,"0x%x,",skb->data[10*vcount + i]);
            strcat(strbuf,tmp);
        }
        zv_info("%s ",strbuf);
    }
    zv_info("\n");
}

static int zvnet_open(struct net_device *net)
{
    struct zvnet *dev = netdev_priv(net);

    if(net->flags & IFF_UP) {
        zv_dbg("%s has been opened!", dev->net->name);
        return -EBUSY;
    }
    netif_start_queue (net);

    return 0;
}

static int zvnet_close(struct net_device *net)
{
    struct zvnet *dev = netdev_priv(net);

    zv_info("%s", dev->net->name);
    netif_stop_queue(net);
    tasklet_kill (&dev->bh);

    return 0;
}
#ifdef USE_ZVNET_PACKET
static void zvnet_xmit_packet(void)
{
	int i,j,k,ret,num;
	unsigned long flags;
	unsigned long flags1;
	struct sk_buff *skb;
	T_ZDrvRpMsg_Msg msg = { .actorID = CAP_ID,
							.chID = channel_20,
							.flag = RPMSG_WRITE_INT};
	static struct T_zvnet_rpmsg buff[ZVNET_XMIT_MAX_QUEUE_NUM];

	spin_lock_irqsave(&g_zvnet_skb_xmit_queue.lock, flags);
	if (skb_queue_empty(&g_zvnet_skb_xmit_queue)) {
		spin_unlock_irqrestore(&g_zvnet_skb_xmit_queue.lock, flags);
		return;
	}
	i = 0;
	skb_queue_walk(&g_zvnet_skb_xmit_queue, skb) {
		buff[i].buff = skb;
		buff[i].data_off = skb->data - skb->head;
		buff[i].head = virt_to_phys(skb->head);
		buff[i].len = skb->len;
		buff[i].end_off = skb->end - skb->head;
		buff[i].dev = zvnet_get_index_by_netdev(skb->dev);
		i++;
		zv_info("xmit skb=0x%x i=%d", skb, i);
		if(i > ZVNET_XMIT_MAX_QUEUE_NUM){
			panic("qlen:%d!", i);
		}
	}
	spin_lock_irqsave(&g_zvnet_skb_queue.lock, flags1);
	skb_queue_splice_tail_init(&g_zvnet_skb_xmit_queue, &g_zvnet_skb_queue);
	spin_unlock_irqrestore(&g_zvnet_skb_queue.lock, flags1);
	spin_unlock_irqrestore(&g_zvnet_skb_xmit_queue.lock, flags);
	zv_info("g_zvnet_skb_queue.qlen=%d i=%d", g_zvnet_skb_queue.qlen, i);
	for(j = 0; j < i; j = j + ZVNET_XMIT_BUFF_NUM){
		if(i <= (j + ZVNET_XMIT_BUFF_NUM)){
			msg.buf = (void *)&buff[j];
			msg.len = sizeof(struct T_zvnet_rpmsg)*(i-j);/*ȡ*/
			ret = zvnetWrite(&msg);
		}else{
			msg.buf = (void *)&buff[j];
			msg.len = sizeof(struct T_zvnet_rpmsg)*ZVNET_XMIT_BUFF_NUM;
			ret = zvnetWrite(&msg);
		}
		zv_info("xmit write ret=%d size=%d i=%d j=%d", ret, msg.len, i, j);
		if(ret < 0) {
			if(printk_ratelimit())
				zv_warn("zvnet_channel_write ret=%d fail.",ret);
			num = msg.len / sizeof(struct T_zvnet_rpmsg);
			for(k = j; k < j+num; k++){
				skb = (struct sk_buff *)buff[k].buff;
				skb_unlink(skb, &g_zvnet_skb_queue);
				skb->isTocap = 0;
				kfree_skb(skb);
			}
		}
	}
}
#endif
static netdev_tx_t zvnet_xmit(struct sk_buff *skb, struct net_device *net)
{
#ifdef USE_ZVNET_PACKET
	struct sk_buff *data = NULL;

	//zv_info("g_zvnet_skb_xmit_queue.qlen=%d", g_zvnet_skb_xmit_queue.qlen);
	if(g_zvnet_skb_xmit_queue.qlen >= ZVNET_XMIT_MAX_QUEUE_NUM){
		net->stats.tx_errors++;
		net->stats.tx_dropped++;
		zv_err("write err, qlen:%d!", g_zvnet_skb_xmit_queue.qlen);
		kfree_skb(skb);
		return NET_XMIT_SUCCESS;
	}
		
	if(unlikely(skb->capHead || skb->next || skb->fclone || skb->cloned 
		|| (skb_shinfo(skb)->nr_frags) || (skb_shinfo(skb)->tx_flags & SKBTX_DEV_ZEROCOPY) 
		|| (skb_has_frag_list(skb)))){
		int ret_len = skb->len;

		data = dev_alloc_skb(ret_len + NET_IP_ALIGN);
		if (unlikely(!data)) {
			zv_err("dev_alloc_skb fail,len %d",ret_len);
			net->stats.tx_errors++;
			net->stats.tx_dropped++;
			kfree_skb(skb);
			return NET_XMIT_SUCCESS;
		}
		skb_put(data,ret_len);
		skb_reserve(data, NET_IP_ALIGN);
		memcpy(data->data, skb->data, ret_len);
		zv_info("ap=0x%x next=0x%x clone=%d nr_frags=%d tx_flags=%d frag_list=0x%x", skb->capHead, skb->next, skb->cloned, (skb_shinfo(skb)->nr_frags), skb_shinfo(skb)->tx_flags, skb_shinfo(skb)->frag_list);
		kfree_skb(skb);
	}else{
		data = skb;
	}
	data->dev = net;
	data->isTocap = 1;
	dma_cache_maint(data->head, virt_to_phys(data->head), data->end - data->head + sizeof(struct skb_shared_info), DMA_TO_DEVICE);
	skb_queue_tail(&g_zvnet_skb_xmit_queue, data);
	if(data->len < g_wrap_packet_size || g_zvnet_skb_xmit_queue.qlen > g_wrap_num)
		up(&g_zvnet_xmit_sem);
	net->trans_start = jiffies;
	net->stats.tx_packets++;
	net->stats.tx_bytes += skb->len;
#else
    struct zvnet *dev = netdev_priv(net);
    struct zvnet_device *zvnetdev = (struct zvnet_device *)dev->dev_priv;
    int ret = 0;
    struct zvp_header hzvp;

    if (!skb) {
        zv_err("err: skb == 0!");
    }
#if 0
    if (skb->len > ZVNET_TMP_BUFF_LEN) {
        zv_err("err: skb->len(%d)>%d!", skb->len, ZVNET_TMP_BUFF_LEN);
    }

send_header:
    ret = zvnet_channel_write(&(zvnetdev->chn_info), skb->data, skb->len);

    if((ret < 0) && (zvnetdev->retran_times < XMIT_RETRANS_TIMES)) {
        zvnetdev->retran_times ++;
        zv_warn("The retran_times is %d.",zvnetdev->retran_times);
        goto send_header;
    }

    if (ret >= 0) {
        net->trans_start = jiffies;
        net->stats.tx_packets++;
        net->stats.tx_bytes += skb->len;
    } else {
        net->stats.tx_errors++;
        net->stats.tx_dropped++;
        zv_err("write err, ret:%d!", ret);
    }

exit:
    kfree_skb(skb);
#else
	struct T_zvnet_rpmsg buff = {0};
	struct sk_buff *data = NULL;
	if(unlikely(skb->capHead || skb->fclone || skb->cloned || skb->next 
		|| (skb_shinfo(skb)->nr_frags) || (skb_shinfo(skb)->tx_flags & SKBTX_DEV_ZEROCOPY) 
		|| (skb_has_frag_list(skb)))){
		int ret_len = skb->len;

		data = dev_alloc_skb(ret_len + NET_IP_ALIGN);
		if (unlikely(!data)) {
			zv_err("dev_alloc_skb fail,len %d",ret_len);
			net->stats.tx_errors++;
			net->stats.tx_dropped++;
			kfree_skb(skb);
			return NET_XMIT_SUCCESS;
		}
		skb_put(data,ret_len);
		skb_reserve(data, NET_IP_ALIGN);
		memcpy(data->data, skb->data, ret_len);
		data->isTocap = 1;
		buff.buff = data;
		buff.data_off = data->data - data->head;
		buff.head = virt_to_phys(data->head);
		buff.len = ret_len;
		buff.end_off = data->end - data->head;
		buff.dev = zvnet_get_index_by_netdev(net);
		zv_info("alloc 0x%x 0x%x %d %d", buff.buff, buff.head, buff.data_off, buff.len);
		zv_info("cap=0x%x next=0x%x clone=%d nr_frags=%d tx_flags=%d frag_list=0x%x", skb->capHead, skb->next, skb->cloned, (skb_shinfo(skb)->nr_frags), skb_shinfo(skb)->tx_flags, skb_shinfo(skb)->frag_list);
		dma_cache_maint(data->head, buff.head, buff.end_off + sizeof(struct skb_shared_info), DMA_TO_DEVICE);
	}else{
		skb->isTocap = 1;
		buff.buff = skb;
		buff.data_off = skb->data - skb->head;
		buff.head = virt_to_phys(skb->head);
		buff.len = skb->len;
		buff.end_off = skb->end - skb->head;
		buff.dev = zvnet_get_index_by_netdev(net);
		zv_info("transfer 0x%x %d 0x%x %d", buff.buff, buff.head, buff.data_off, buff.len);
		dma_cache_maint(skb->head, buff.head, buff.end_off + sizeof(struct skb_shared_info), DMA_TO_DEVICE);
	}
send_header:
	ret = zvnet_channel_write(&g_zvnet_chn_info, &buff, sizeof(struct T_zvnet_rpmsg));

	if((ret < 0) && (zvnetdev->retran_times < XMIT_RETRANS_TIMES)) {
		zvnetdev->retran_times ++;
		zv_warn("The retran_times is %d.",zvnetdev->retran_times);
		goto send_header;
	}

	if (ret >= 0) {
		net->trans_start = jiffies;
		net->stats.tx_packets++;
		net->stats.tx_bytes += skb->len;
		if(data){
			kfree_skb(skb);
			skb_queue_tail(&g_zvnet_skb_queue, data);
		}else
			skb_queue_tail(&g_zvnet_skb_queue, skb);
		zvnetdev->retran_times = 0;
	} else {
		net->stats.tx_errors++;
		net->stats.tx_dropped++;
		zv_err("write err, ret:%d!", ret);
		if(data){
			data->isTocap = 0;
			kfree_skb(data);
		}
		else
			skb->isTocap = 0;
		kfree_skb(skb);
	}
#endif
#endif
    return NET_XMIT_SUCCESS;
}

/* Called by the kernel when transmit times out */
static void zvnet_tx_timeout(struct net_device *net)
{
    zv_warn("sent timeout!");
    net->stats.tx_errors++;
    netif_wake_queue(net);
}

static struct net_device_stats *zvnet_get_stats(struct net_device *net)
{
    return &net->stats;
}

const struct net_device_ops zvnet_netdev_ops = {
    .ndo_open	    = zvnet_open,
    .ndo_stop	    = zvnet_close,
    .ndo_start_xmit = zvnet_xmit,
    .ndo_tx_timeout = zvnet_tx_timeout,
    .ndo_get_stats  = zvnet_get_stats,
    .ndo_change_mtu = eth_change_mtu,
    .ndo_validate_addr = eth_validate_addr,
};

static void v2xnet_init_netdev(struct net_device *net)
{
    u8 node_id [ETH_ALEN];

    random_ether_addr(node_id);
    memcpy (net->dev_addr, node_id, sizeof node_id);

    net->netdev_ops = &zvnet_netdev_ops;
    net->watchdog_timeo = WATCHDOG_TIMEO;
    net->flags |= IFF_NOARP;
}

static void zvnet_skb_return (struct zvnet *dev, struct sk_buff *skb)
{
    int status;

    //zv_info("enter...");

    skb->protocol = eth_type_trans(skb, dev->net);

    status = netif_rx (skb);
    if (status == NET_RX_SUCCESS) {
        dev->net->stats.rx_packets++;
        dev->net->stats.rx_bytes += skb->len;
    } else {
        dev->net->stats.rx_errors++;
        zv_err("netif_rx status %d.", status);
    }
}

static void zvnet_bh (unsigned long param)
{
    struct zvnet *dev = (struct zvnet *)param;
    struct sk_buff	  *skb;

    while((skb = skb_dequeue(&dev->rxq)) != NULL) {
        if (skb->len)
            zvnet_skb_return(dev, skb);
        else {
            dev->net->stats.rx_errors++;
            dev_kfree_skb (skb);
            zv_err("drop!!!ddrnet_bh skb len == 0.");
        }
    }
}

static struct zvnet *v2xnet_dev_init(struct net_device *net, struct zvnet_device *zvnetdev)
{
    struct zvnet *dev = NULL;

    dev = netdev_priv(net);
    if(!dev) {
        zv_err("dev is null.\n");
        return NULL;
    }

    dev->net = net;
    dev->bh.func = zvnet_bh;
    dev->bh.data = (unsigned long) dev;

    skb_queue_head_init (&dev->rxq);

    dev->dev_priv = zvnetdev;

    return dev;
}

/*ֵڵ0ʾдͨɹС0ʾдͨʧ*/
static int zvnet_channel_write(struct zvnet_channel *chninfo, void *buf, unsigned int len)
{
    T_ZDrvRpMsg_Msg msg;

    if(NULL == buf) {
        return -EINVAL;
    }
    memset(&msg, 0, sizeof(msg));
    msg.actorID = chninfo->core_id;
    msg.chID = chninfo->channel_id;
    msg.flag |= RPMSG_WRITE_INT; // | RPMSG_WRITE_IRQLOCK;
    msg.buf = buf;
    msg.len = len;

    return zvnetWrite(&msg);
}

/*ֵ0ʾȡͨɹСڵ0ʾͨΪջʧ*/
static int zvnet_channel_read(struct zvnet_channel *chninfo, void *buf, unsigned int len)
{
    T_ZDrvRpMsg_Msg msg;
    int ret = 0;

    if(NULL == buf) {
        return -EINVAL;
    }

    memset(&msg, 0, sizeof(msg));
    msg.actorID = chninfo->core_id;
    msg.chID    = chninfo->channel_id;
    msg.buf     = buf;
    msg.len     = len;

    ret = zvnetRead(&msg);
    if (ret <= 0) {
        zv_err("rpm read err=%d!",ret);
        return ret;
    }

    return ret;
}

static int zvnet_channel_clear(struct zvnet_channel *chninfo)
{
    char *tbuf = NULL;
    unsigned int tlen = chninfo->channel_size/2;
    int ret = 0;

    tbuf = (char *)kzalloc(tlen,GFP_ATOMIC);
    if(IS_ERR(tbuf)) {
        zv_err("kzalloc fail! %d byte.", tlen);
        return -ENOMEM;
    }
    ret = zvnet_channel_read(chninfo, tbuf, tlen);
    if(ret < 0) {
        zv_err("zvnet_channel_read fail!");
        ret = 0;
    }
    kfree(tbuf);
    zv_err("Drop channel data. %d byte.",ret);

    return ret;
}

static int zvnet_read_header(struct zvnet_channel *chninfo, struct zvp_header *phzvp)
{
    return zvnet_channel_read(chninfo, phzvp, sizeof(struct zvp_header));
}

static struct sk_buff *zvnet_read_skb(struct zvnet_channel *chninfo, unsigned int tlen, struct zvnet *dev)
{
    struct sk_buff *skb;

    if(NULL == chninfo || 0 >= tlen || NULL == dev) {
        return NULL;
    }
    skb = dev_alloc_skb(tlen);
    if (unlikely(!skb)) {
        zv_err("netdev_alloc_skb fail,len %d",tlen);
        return NULL;
    }
    skb_put(skb,tlen);

    if(zvnet_channel_read(chninfo, (void *)skb->data, tlen) != tlen) {
        zv_err("zvnet_channel_read fail.\n");
        kfree_skb(skb);
        return NULL;
    }

    zv_info("%s dev receive packet %d byte.",dev->net->name, tlen);

    skb->dev = dev->net;

    return skb;
}

static struct sk_buff *zvnet_direct_read_skb(struct zvnet_channel *chninfo)
{
    struct sk_buff *skb;
#if 0
    char skb_data[ZVNET_TMP_BUFF_LEN];
    int ret_len = 0;

    if(NULL == chninfo || NULL == dev) {
        zv_err("zvnet_channel_read null.\n");
        return NULL;
    }

    ret_len = zvnet_channel_read(chninfo, (void *)skb_data, sizeof(skb_data));

    if(ret_len <= 0) {
        zv_err("zvnet_channel_read fail.\n");
        return NULL;
    }

    skb = dev_alloc_skb(ret_len + ZVNET_SKB_PAD);
    if (unlikely(!skb)) {
        zv_err("netdev_alloc_skb fail,len %d",ret_len);
        return NULL;
    }

    skb_put(skb,ret_len);
    skb_reserve(skb, ZVNET_SKB_PAD);
    memcpy(skb->data, &skb_data[0], ret_len);
#else
	struct T_zvnet_rpmsg buff = {0};
	int ret_len = 0;
	ret_len = zvnet_channel_read(chninfo, (void *)&buff, sizeof(struct T_zvnet_rpmsg));

	if(ret_len <= 0) {
		zv_err("rpm read err=%d", ret_len);
		msleep(1000);
		return NULL;
	}
	if(ret_len != sizeof(struct T_zvnet_rpmsg)) {
		panic("err, ret:%d!!!!!!", ret_len);	
	}
    skb = skb_build_capbuf(&buff);
    if (unlikely(!skb)) {
        zv_err("netdev_alloc_skb fail,len %d",ret_len);
        return NULL;
    }
#endif
    //skb->dev = dev->net;
    return skb;
}

static int zvnet_receive_thread(void *argv)
{
    //struct zvnet_device *zvnetdev = (struct zvnet_device *)argv;
    //struct zvnet_channel *chninfo = NULL;
    struct zvnet *dev = NULL;
	int index,ret_len,i,num;
    unsigned long flags;
	struct sk_buff *skb = NULL;
	T_ZDrvRpMsg_Msg msg = { .actorID = CAP_ID,
							.chID = channel_20,
							.flag = 0};
	struct T_zvnet_rpmsg buff[ZVNET_XMIT_BUFF_NUM];
    //struct zvp_header hzvp;
/*
    if(IS_ERR(zvnetdev)) {
        zv_err("The receive thread create fail!");
        return -EINVAL;
    }
    chninfo = &zvnetdev->chn_info;
    dev = zvnetdev->dev;
*/
    while(1) {
/*
        if(unlikely(!(zvnetdev->net->flags & IFF_UP))) {
            msleep(1000);
            continue;
        }
*/
        //memset(&hzvp, 0, sizeof(hzvp));
#ifdef USE_ZVNET_PACKET
		//ret_len = zvnet_channel_read(&g_zvnet_chn_info, (void *)buff, sizeof(struct T_zvnet_rpmsg)*ZVNET_XMIT_BUFF_NUM);
		msg.buf 	= (void *)(buff);  // 
		msg.len 	= sizeof(struct T_zvnet_rpmsg)*ZVNET_XMIT_BUFF_NUM;// ȡĳ
		ret_len = zvnetRead(&msg);	 // ȡζһڵ㣬
		zv_info("zvnetRead ret=%d", ret_len);
		if(ret_len <= 0) {
			zv_err("rpm read err=%d", ret_len);
			msleep(1000);
			continue;
		}
		if((ret_len % sizeof(struct T_zvnet_rpmsg)) != 0) {
			panic("err, ret:%d!!!!!!", ret_len);	
		}
		num = ret_len / sizeof(struct T_zvnet_rpmsg);
		for(i = 0; i < num; i++){
			skb = skb_build_capbuf(&buff[i]);
			if (unlikely(!skb)) {
				zv_err("skb_build_capbuf fail,len=%d i=%d",ret_len,i);
				continue;
			}
	        if(unlikely(!(skb->dev->flags & IFF_UP))) {
				dev_kfree_skb (skb);
				if(printk_ratelimit())
					zv_err("drop!!!%s is down.", skb->dev->name);
	            continue;
	        }
            if (fast_from_driver && fast_from_driver(skb, skb->dev))
            {
                continue;
            }
			index = zvnet_get_index_by_netdev(skb->dev);
			if(index < 0)
				panic("");
			dev = zvnet_dev[index].dev;
            spin_lock_irqsave(&dev->rxq.lock, flags);
            __skb_queue_tail(&dev->rxq, skb);
            spin_unlock_irqrestore(&dev->rxq.lock, flags);
            tasklet_schedule(&dev->bh);
		}
#else
        if(0 != (skb = zvnet_direct_read_skb(&g_zvnet_chn_info))) {
            //skb_debug_test(skb);
	        if(unlikely(!(skb->dev->flags & IFF_UP))) {
				dev_kfree_skb (skb);
				zv_err("drop!!!%s is down.", skb->dev->name);
	            continue;
	        }
#if 1
            if (fast_from_driver && fast_from_driver(skb, skb->dev))
            {
                continue;
            }
#endif
			index = zvnet_get_index_by_netdev(skb->dev);
			if(index < 0)
				panic("");
			dev = zvnet_dev[index].dev;
            spin_lock_irqsave(&dev->rxq.lock, flags);
            __skb_queue_tail(&dev->rxq, skb);
            spin_unlock_irqrestore(&dev->rxq.lock, flags);
            tasklet_schedule(&dev->bh);
        }
        else {
            zv_err("zvnet_read_header fail.");
            msleep(1000);
        }
#endif
    }

    zv_err("The receive thread exit!");
    return 0;
}

static int rpmsgCreateChannel_v2xnet (T_ZDrvRpMsg_ActorID dstCoreID, T_ZDrvRpMsg_ChID chID, unsigned int size)
{
    return zvnetCreateChannel (dstCoreID, chID, size);
}

static int zvnet_createIcpChannel(T_ZDrvRpMsg_ActorID core_id, T_ZDrvRpMsg_ChID channel_id, unsigned int channel_size)
{
    int retval;

    retval = rpmsgCreateChannel_v2xnet (core_id, channel_id, channel_size);
    if(retval != RPMSG_SUCCESS && retval != RPMSG_CHANNEL_ALREADY_EXIST)
        goto out;

    return retval;

out:
    zv_err("could not create channel.");
    return retval;
}
/*
static int zvnet_channel_create(struct zvnet_device *zvnetdev)
{
    struct task_struct *th = NULL;
    int retval = 0;
    struct zvnet_channel *chninfo = NULL;

    if (IS_ERR(zvnetdev)) {
        return -EINVAL;
    }
    chninfo = &(zvnetdev->chn_info);
    retval = zvnet_createIcpChannel(chninfo->core_id, chninfo->channel_id, chninfo->channel_size);
    if(retval < 0) {
        zv_err("Create IcpChannel fail.");
        return retval;
    }

    th = kthread_run(zvnet_receive_thread, (void *)zvnetdev, "zvnet-recv%d", chninfo->channel_id);
    if (IS_ERR(th)) {
        zv_err("Unable to start receive thread.");
        return PTR_ERR(th);
    }
    chninfo->rcv_thread = th;

    return 0;
}
*/
static int zvnet_release_thread(void * nouse)
{
	T_ZDrvRpMsg_Msg msg = { .actorID = CAP_ID,
							.chID = channel_29,
							.flag = 0};
	void *buff[ZVNET_FREE_BUFF_NUM] = {0};
	int i,num,retval;
	struct sk_buff *skb;
	struct sched_param param = { .sched_priority = 1 };
	param.sched_priority = 37;
	sched_setscheduler(current, SCHED_FIFO, &param);

	while(1) {
		zv_info("g_zvnet_skb_queue.qlen=%d", g_zvnet_skb_queue.qlen);
#ifdef USE_ZVNET_PACKET
		msg.buf 	= (unsigned char *)(buff);  // 
		msg.len 	= 4*ZVNET_FREE_BUFF_NUM;// ȡĳ
		retval = zvnetRead(&msg);	 // ȡζһڵ㣬
		zv_info("free read ret=%d", retval);
		if (retval <= 0) {
			zv_err("rpm read err=%d", retval);
			msleep(1000);
			continue;
		}
		if((retval%4) != 0) {
			panic("err, ret:%d!!!!!!", retval);
		}
		num = retval>>2;
		for(i = 0; i < num; i++){
			skb = (struct sk_buff *)buff[i];
			zv_info("free 0x%x i=%d", skb, i);
			if (skb == NULL || skb->next == NULL || skb->prev == NULL) {
				panic("rpm read=%d i=%d NULL", retval, i);
				continue;
			}
			skb_unlink(skb, &g_zvnet_skb_queue);
			if(skb->isTocap != 1)
				panic("");
			skb->isTocap = 0;
			kfree_skb(skb);
		}
#else
		void *buff;
		msg.actorID = CAP_ID;
		msg.chID	=  channel_29;
		msg.buf 	= (unsigned char *)(&buff);  // 
		msg.len 	= 4;// ȡĳ
		//msg.flag |= RPMSG_READ_POLL;

		retval = zvnetRead(&msg);	 // ȡζһڵ㣬
		if (retval <= 0) {
			zv_err("no msg or threand exited");
			msleep(1000);
			continue;
		}
		if(retval != 4) {
			panic("err, ret:%d!!!!!!", retval);
		}
		zv_info("free 0x%x", buff);
		skb = (struct sk_buff *)buff;
		skb_unlink(skb, &g_zvnet_skb_queue);
		if(skb->isTocap != 1)
			panic("");
		skb->isTocap = 0;
		kfree_skb(skb);
#endif
	}
    zv_err("The realse thread exit!");
    return 0;
}
#ifdef USE_ZVNET_PACKET
static int zvnet_xmit_warp_thread(void * nouse)
{
	while(1) {
		down_timeout(&g_zvnet_xmit_sem, msecs_to_jiffies(g_wrap_timeout));
		zvnet_xmit_packet();
	}
	zv_err("The xmit warp thread exit!");
	return 0;
}

static int zvnet_free_warp_thread(void * nouse)
{
	while(1) {
		down_timeout(&g_zvnet_free_sem, msecs_to_jiffies(g_wrap_timeout));
		write_free_apbuf_packet();
	}
	zv_err("The free warp thread exit!");
	return 0;
}
#endif
/*******************************************************************************
 *					 Global function implementations						*
 ******************************************************************************/
static int __init zvnet_init(void)
{
    int i;
    int err = -ENOMEM;
    struct zvnet *dev = NULL;
    struct net_device *net = NULL;
    struct zvnet_device *zvnetdev = NULL;

#ifdef USE_ZVNET_PACKET
	skb_queue_head_init(&g_zvnet_skb_xmit_queue);
	spin_lock_init(&g_zvnet_free_lock);
	sema_init(&g_zvnet_free_sem, 0);
	sema_init(&g_zvnet_xmit_sem, 0);
#endif
    skb_queue_head_init(&g_zvnet_skb_queue);
	g_zvnet_chn_info.core_id = CAP_ID;
	g_zvnet_chn_info.channel_id = ICP_CHN_ZVNET1;
	g_zvnet_chn_info.channel_size = ICP_CHANNEL_SIZE;
    for (i = 0; i < DDR_ZVNET_DEV_MAX; i++) {
        zvnetdev = &zvnet_dev[i];
        memset(zvnetdev, 0, sizeof(struct zvnet_device));
        net = alloc_etherdev(sizeof(struct zvnet));
        if (!net) {
            zv_err("could not allocate device.\n");
            return err;
        }

        net->needed_headroom += ZVNET_SKB_PAD;//NET_SKB_PAD;
        sprintf(net->name, "%s%d", ZVNET_IFNAME_PREFIX, i);
        dev = v2xnet_dev_init(net, zvnetdev);
        v2xnet_init_netdev(net);
		if(0 == i){
			net->flags = (net->flags & (~IFF_NOARP));
		}
        err = register_netdev(net);
        if (err) {
            zv_err("register_netdev error:%d :%d\n",err,i);
            return err;
        }
        zvnetdev->dev = dev;
        zvnetdev->net = net;
/*
        zvnetdev->chn_info.core_id = CAP_ID;
        zvnetdev->chn_info.channel_id = ICP_CHN_ZVNET1 + i;//zvnet_collect[i];
        zvnetdev->chn_info.channel_size = ICP_CHANNEL_SIZE;
        err = zvnet_channel_create(zvnetdev);
        if(0 != err) {
            zv_err("zvnet_channel_create error:%d :%d\n",err,i);
            goto out_unregister_netdev;
        }
*/
    }
	{
	    struct task_struct *th = NULL;
	    int retval = 0;
		
	    retval = zvnet_createIcpChannel(CAP_ID, channel_20, ICP_CHANNEL_SIZE);
	    if(retval < 0) {
	        zv_err("Create IcpChannel channel_20 fail.");
	        return retval;
	    }

	    th = kthread_run(zvnet_receive_thread, 0, "zvnet-recv%d", channel_20);
	    if (IS_ERR(th)) {
	        zv_err("Unable to start receive thread.");
	        return PTR_ERR(th);
	    }
        g_zvnet_chn_info.rcv_thread = th;

	    retval = zvnet_createIcpChannel(CAP_ID, channel_29, ICP_CHANNEL_SIZE);
	    if(retval < 0) {
	        zv_err("Create IcpChannel channel_29 fail.");
	        return retval;
	    }

	    th = kthread_run(zvnet_release_thread, 0, "zvnet-free%d", channel_29);
	    if (IS_ERR(th)) {
	        zv_err("Unable to start release thread.");
	        return PTR_ERR(th);
	    }
#ifdef USE_ZVNET_PACKET
	    th = kthread_run(zvnet_xmit_warp_thread, 0, "zvnet-xmit-wrap");
	    if (IS_ERR(th)) {
	        zv_err("Unable to start xmit_warp thread.");
	        return PTR_ERR(th);
	    }
		
	    th = kthread_run(zvnet_free_warp_thread, 0, "zvnet-free-wrap");
	    if (IS_ERR(th)) {
	        zv_err("Unable to start free_warp thread.");
	        return PTR_ERR(th);
	    }
#endif
		vir_addr_cap = ioremap_cached(DDR_BASE_CAP_ADDR_PA, DDR_BASE_LEN_CAP);
		zv_warn("vir_addr_cap vir=0x%x phy=0x%x len=0x%x", vir_addr_cap, DDR_BASE_CAP_ADDR_PA, DDR_BASE_LEN_CAP);
		if(vir_addr_cap == NULL)
		{
			zv_err("CAP mmap failed.\n");
			return -1;
		}

	}
    zv_dbg("success.\n");
    return 0;

}

static void __exit zvnet_exit(void)
{
    int i;
    struct net_device *net;

    for (i = 0; i < DDR_ZVNET_DEV_MAX; i++) {
        net = zvnet_dev[i].net;
        unregister_netdev(net);
        free_netdev(net);
        zvnet_dev[i].net = NULL;
    }
    zv_warn("success.\n");
}

late_initcall(zvnet_init);
module_exit(zvnet_exit);

MODULE_AUTHOR("ZXIC");
MODULE_DESCRIPTION("ZXIC CAP LAN NET DEVICE");
MODULE_LICENSE("GPL");

