
#ifndef	_8192CD_11V_H_
#define _8192CD_11V_H_


#ifdef DOT11V_DEBUG
#define DOT11VDEBUG(fmt, args...) panic_printk("[%s %d]"fmt,__FUNCTION__,__LINE__,## args)
#else
#define DOT11VDEBUG(fmt, args...)
#endif

//#define DOT11V_TRACE
#ifdef DOT11V_TRACE
#define DOT11VTRACE(fmt, args...) panic_printk("[%s %d]"fmt,__FUNCTION__,__LINE__,## args)
#else
#define DOT11VTRACE(fmt, args...)
#endif

#ifndef _8192CD_11V_C_
#define EXTERN  extern
#else
#define EXTERN
#endif

#define _WNM_TSF_INFO_                         				1
#define _WNM_CONDENSED_COUNTRY_STRING_ 			2
#define _WNM_BSS_TRANS_CANDIDATE_PREFRENCE_   	3	// subelement
#define _WNM_BSS_TERMINATION_DURATION_  		4
#define _WNM_BEARING_                     					5
#define _WNM_MEASUREMENT_PILOT_          			66
#define _WNM_RRM_ENABLED_CAPABILITIES_   			70
#define _WNM_MULTIPLE_BSSID_             				71

#define TRANS_LIST_PROC_LEN	50
#define MAX_PREFERRED_VAL 		255
#define NEIGHBOR_REPORT_SIZE 	13	 // size of neighbor report structure

/* band steering */
#define DB_BS_BLOCK_TIME 20 // block this sta 20 sec
#define REDIRECT_AP_TX_LOAD 0x1
#define REDIRECT_AP_RX_LOAD 0x2

EXTERN unsigned char getPreferredVal(struct rtl8192cd_priv *priv, unsigned char channel_utilization, unsigned char rcpi, bool excluded);
EXTERN void OnBSSTransQuery(struct rtl8192cd_priv *priv, struct stat_info *pstat, unsigned char *pframe, int frame_len);
EXTERN void OnBSSTransRsp(struct rtl8192cd_priv *priv, struct stat_info *pstat, unsigned char *pframe, int frame_len);
EXTERN int issue_BSS_Trans_Req(struct rtl8192cd_priv *priv, unsigned char *da, unsigned char dialog_token);
EXTERN unsigned char * construct_neighbor_report_ie(unsigned char *pbuf, unsigned int *frlen, struct dot11k_neighbor_report * report);
EXTERN void set_staBssTransCap(struct stat_info *pstat, unsigned char *pframe, int frameLen, unsigned short ie_offset);
EXTERN void reset_staBssTransStatus(struct stat_info *pstat);
EXTERN void WNM_ActionHandler(struct rtl8192cd_priv *priv, struct stat_info *pstat, unsigned char *pframe, int frame_len);
#ifdef DOT11K
EXTERN void set_BssTransPara(struct rtl8192cd_priv *priv, unsigned char *tmpbuf);
#endif
EXTERN void send_bss_trans_event(struct rtl8192cd_priv *priv, struct stat_info *pstat, unsigned char i);
EXTERN void process_BssTransReq(struct rtl8192cd_priv *priv);
EXTERN void BssTrans_DiassocTimer(struct rtl8192cd_priv *priv);
EXTERN void BssTrans_ExpiredTimer(struct rtl8192cd_priv *priv);

/* band steering */
EXTERN bool checkBssTransDbBsIsEnable(struct rtl8192cd_priv *priv);
EXTERN void process_TriggerBssTrans(struct rtl8192cd_priv *priv);
EXTERN void BssTransDriverBased(struct rtl8192cd_priv *priv);
EXTERN bool bssTransDbBsCheckRequest(struct rtl8192cd_priv *priv, unsigned char *mac, int frame_type);
EXTERN void bssTransDbBsTimer(struct rtl8192cd_priv *priv);

#undef EXTERN

#endif
