/*
 * Copyright (c) 2015 iComm-semi Ltd.
 *
 * Permission to use, copy, modify, and/or distribute this software for any
 * purpose with or without fee is hereby granted, provided that the above
 * copyright notice and this permission notice appear in all copies.
 *
 * THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES
 * WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR
 * ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
 * ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
 * OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 */

#include <linux/version.h>
#include <linux/init.h>
#include <linux/module.h>
#include <linux/netdevice.h>
#include <linux/skbuff.h>
#include <ssv6xxx_prealloc_skb.h>

MODULE_AUTHOR("iComm-semi, Ltd");
MODULE_DESCRIPTION("Pre-allocated memory for SSV wireless LAN cards.");
MODULE_LICENSE("Dual BSD/GPL");
int ssv_rx_pre_alloc_max_skbs = RX_AGG_RECYCLE_MAX_SKBS;
EXPORT_SYMBOL(ssv_rx_pre_alloc_max_skbs);
module_param(ssv_rx_pre_alloc_max_skbs, int, 0644);
MODULE_PARM_DESC(ssv_rx_pre_alloc_max_skbs, "Max length of RX pre alloc list");

//HCI RX AGG
//#define MAX_FRAME_SIZE                      2432
//#define HCI_RX_AGGR_SIZE                   0x2710
//#define MAX_HCI_RX_AGGR_SIZE                (HCI_RX_AGGR_SIZE+MAX_FRAME_SIZE)  //AGGR_SIZE+MPDU
int ssv_rx_pre_alloc_skb_size = (0x2710 + 2432);
EXPORT_SYMBOL(ssv_rx_pre_alloc_skb_size);
module_param(ssv_rx_pre_alloc_skb_size, int, 0644);
MODULE_PARM_DESC(ssv_rx_pre_alloc_skb_size, "Max size of RX pre alloc skb");

struct ssv6xxx_prealloc ssv_prealloc;
EXPORT_SYMBOL(ssv_prealloc);

struct sk_buff *ssv_pre_rx_alloc_skb_alloc(void) 
{
    struct sk_buff *skb = NULL;

    skb = skb_dequeue(&ssv_prealloc.rx_skb_q);
    return skb;
}
EXPORT_SYMBOL(ssv_pre_rx_alloc_skb_alloc);


void ssv_pre_rx_skb_free(struct sk_buff *skb) 
{
    struct skb_shared_info *s = skb_shinfo(skb);
        
    // reset skb 
    memset(s, 0, offsetof(struct skb_shared_info, dataref));
    atomic_set(&s->dataref, 1);
    memset(skb, 0, offsetof(struct sk_buff, tail));
    skb_reset_tail_pointer(skb);
    // enqueue rxq
    skb_queue_tail(&ssv_prealloc.rx_skb_q, skb);
}
EXPORT_SYMBOL(ssv_pre_rx_skb_free);

void ssv_pre_rx_skb_qlen_check(void) 
{
    if (ssv_prealloc.rx_skb_q_len != skb_queue_len(&ssv_prealloc.rx_skb_q)) {
        printk("%s() pre_alloc_rx_skb_q %d/%d\n", 
                __FUNCTION__, ssv_prealloc.rx_skb_q_len, skb_queue_len(&ssv_prealloc.rx_skb_q));
        WARN_ON(1);
    }
}
EXPORT_SYMBOL(ssv_pre_rx_skb_qlen_check);

//static int __init ssv_prealloc_init(void)
int ssv_prealloc_init(void)
{
    struct sk_buff *skb;
    int i = 0;

	printk("ENTER SSV PREALLOC MODULE\n");

    skb_queue_head_init(&ssv_prealloc.rx_skb_q);
    
	for (i = 0 ; i < ssv_rx_pre_alloc_max_skbs ; i++) {
        skb = __dev_alloc_skb(ssv_rx_pre_alloc_skb_size, GFP_KERNEL);
        if (skb) 
            skb_queue_tail(&ssv_prealloc.rx_skb_q, skb);
    }
    
    ssv_prealloc.rx_skb_q_len = skb_queue_len(&ssv_prealloc.rx_skb_q);
	printk("Alloc pre alloc skb queue %d\n", skb_queue_len(&ssv_prealloc.rx_skb_q));
    return 0;
}

//static void __exit ssv_prealloc_exit(void)
void  ssv_prealloc_exit(void)
{
    struct sk_buff *skb;
    
    printk("EXIT SSV PREALLOC MODULE\n");

	printk("Free pre alloc skb queue %d\n", skb_queue_len(&ssv_prealloc.rx_skb_q));
    while ((skb = skb_dequeue(&ssv_prealloc.rx_skb_q)) != NULL) {
        dev_kfree_skb_any(skb);
    }

}
//module_init(ssv_prealloc_init);
//module_exit(ssv_prealloc_exit);

