#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <time.h>
#include <sys/types.h>
#include <sys/wait.h>
#include <sys/time.h>

#include "task.h"
#include "types.h"
#include "ctrl_bench.h"
#include "pattern2dut.h"
#include "../log/log.h"

#include "../bench/cli/cli.h"
#include "./hci_tools/lib/ssv_lib.h"
#include "./hci_tools/lib_bt/bt_hci_cmd_declare.h"
#include "./hci_tools/host_cli.h"
#include "./hci_tools/lib_bluez/bluetooth.h"
#include "./hci_tools/lib_bluez/hci.h"
#include "./hci_tools/lib_bluez/hci_lib.h"

#include "./pattern/param_pattern.h"
#include "./pattern/cli_cmd_master.h"
#include "./pattern/cli_cmd_bcmd.h"

enum {
    DUT_TYPE_TI = 1 ,
    DUT_TYPE_SSV,
    DUT_TYPE_CSR
};

enum {
    TI_CONT_TX_MOD = 0,
    TI_CONT_TX_TP,
    TI_CONT_TX_FREQ,
    TI_CONT_TX_PWR,
    TI_CONT_TX_PARAM_NUM
};

enum {
    TI_PKT_TXRX_FREQ_MODE = 0,
    TI_PKT_TXRX_TX_CH,
    TI_PKT_TXRX_RX_CH,
    TI_PKT_TXRX_PKT_TYPE,
    TI_PKT_TXRX_PKT_PATTERN,
	TI_PKT_TXRX_PKT_LEN,
	TI_PKT_TXRX_PWR_LEVEL,
	TI_PKT_TXRX_PRBS9,
	TI_PKT_TXRX_PARAM_NUM
};

enum {
    TI_BER_METER_START_FREQ = 0,
    TI_BER_METER_START_PKT_TYPE,
    TI_BER_METER_START_PKT_LEN,
    TI_BER_METER_START_NUM_OF_PKT,
	TI_BER_METER_START_PRBS9,
    TI_BER_METER_START_PARAM_NUM
};

typedef enum {
    CFG_DEFAULT = 0,
    CFG_ADV     ,
    CFG_SCAN    ,
    CFG_MULTIROLE   ,
    CFG_SLAVE   ,
    CFG_MASTER  
}enum_cfg;

#define ACL_DATA_MAX 27
#define FIXED_MAS_LE_PDU_BUF 4


static u8 READ_LE_EVENT =0;

static u8  s_manufacturer[2]= {0};
static u8  s_subversion[2]  = {0};
static u8  s_dev_num        = 0;
static u8  s_dev_type[MAX_DUTS+1]    = {0};
static u32 s_pkt_cnt        = 100;
static struct timeval timeStart, timeEnd;

#define CH_MAP_FULL 0x1FFFFFFFFF
#define CH_MAP_ODD  0x0AAAAAAAAA
#define CH_MAP_EVEN 0x1555555555

u8 scan_addr[ADDR_LENGTH]           = {0x4F, 0x80, 0xCD, 0x72, 0x39, 0xD0};
u8 adv_addr[ADDR_LENGTH]            = {0x00, 0x80, 0xCD, 0x72, 0x39, 0xD0};
u8 init_addr[ADDR_LENGTH]           = {0xF0, 0x60, 0x25, 0x8C, 0xBA, 0x1C};
u8 scan_random_addr[ADDR_LENGTH]    = {0x66, 0x55, 0x44, 0x33, 0x22, 0x11};
u8 adv_random_addr[ADDR_LENGTH]     = {0x11, 0x22, 0x33, 0x44, 0x55, 0x66};
u8 zero_addr[ADDR_LENGTH]           = {0x00, 0x00, 0x00, 0x00, 0x00, 0x00};

typedef struct {
    u8  dut_type;
    int dut_fd;
    u8  dut_addr[ADDR_LENGTH];
    u8  dut_random_addr[ADDR_LENGTH]; 
}dut_setting;

dut_setting Dut_setting[MAX_DUTS+1];

u8 error_addr[ADDR_LENGTH]          = {0x11, 0x22, 0x33, 0x44, 0x55, 0x66};
u8 dut1_error_com_ass[ADDR_LENGTH]  = {0x4F, 0x80, 0xCD, 0x44, 0x55, 0x66};
u8 dut1_error_com_idf[ADDR_LENGTH]  = {0x11, 0x22, 0x33, 0x72, 0x39, 0xD0};
u8 dut1_error_both[ADDR_LENGTH]     = {0x11, 0x22, 0x33, 0x44, 0x55, 0x66};

u8 dut2_error_com_ass[ADDR_LENGTH]  = {0x00, 0x80, 0xCD, 0x44, 0x55, 0x66};
u8 dut2_error_com_idf[ADDR_LENGTH]  = {0x11, 0x22, 0x33, 0x72, 0x39, 0xD0};
u8 dut2_error_both[ADDR_LENGTH]     = {0x11, 0x22, 0x33, 0x44, 0x55, 0x66};

u8 enc_rand[8] = {0x90, 0x78, 0x56, 0x34, 0x12, 0xEF, 0xCD, 0xAB};
u8 enc_ediv[2] = {0x74, 0x24};
u8 enc_ltk[16] = {0x11,0x22,0x33,0x44,0x55,0x66,0x77,0x88,0x99,0x00,0x11,0x22,0x33,0x44,0x55,0x66};

u8 dut2_error_conn_handles[2] = {0x03, 0x00};

#define PRINT_TIME \
    {\
        char now[256];\
        log_time(now);\
        printf("%s " ,now);\
    }\

#define HCI_WRITEDATA(PARAM)	\
        PRINT_TIME \
		ret=bt_hci_write_data2socket(dut_fd, &PARAM);	\
		if(SOCKET_SUCCESS != ret)	\
			return FAIL;	\


#define HCI_WRITEDATA_AND_NUMPACKETS_PARSING(PARAM)	\
        PRINT_TIME \
		ret=bt_hci_write_data2socket(dut_fd, &PARAM);	\
		if(SOCKET_SUCCESS != ret)	\
			return FAIL;	\
        do{ \
            ret=socket_msg_get(dut_fd,&len,buf);\
        }while(len <=0);    \
        if(SOCKET_SUCCESS != ret)   \
            return FAIL;    \
		printf("Get Event(%d):\n",dut_fd);	\
		print_charray(len,buf); \
		\
		printf("%d packets completed\n ", hci_event_num_of_completed_packets_parsing(buf)); \

#define HCI_WRITECMD(PARAM)	\
        PRINT_TIME \
		ret=bt_hci_write_cmd2socket(dut_fd, &PARAM);	\
		if(SOCKET_SUCCESS != ret)	\
			return FAIL;	\

#define HCI_WRITECMD_AND_GETEVENT_PARSING(PARAM)	\
        PRINT_TIME \
		ret=bt_hci_write_cmd2socket(dut_fd, &PARAM);	\
		if(SOCKET_SUCCESS != ret)	\
			return FAIL;	\
		do{   \
    		ret=socket_msg_get(dut_fd,&len,buf);	\
		}while(len <=0);    \
        if(SOCKET_SUCCESS != ret)   \
            return FAIL;    \
		printf("Get Event(%d):              ",dut_fd);	\
        ret = hci_event_command_complete_parsing(buf);\
        if (CMD_SUCCESS == ret){ \
			printf("# command complete (success)\n");   \
        } \
        else{   \
            printf("# command complete (failed 0x%02x)\n" , ret); \
        }\
        print_charray(len,buf); \


#define HCI_WRITECMD_AND_GETEVENT_PARSING_CMD_STATUS(PARAM) \
        PRINT_TIME \
		ret=bt_hci_write_cmd2socket(dut_fd, &PARAM);	\
		if(SOCKET_SUCCESS != ret)	\
			return FAIL;	\
        do{   \
            ret=socket_msg_get(dut_fd,&len,buf);    \
        }while(len <=0);    \
        if(SOCKET_SUCCESS != ret)   \
            return FAIL;    \
        printf("Get Event(%d):              ",dut_fd);  \
        ret = hci_event_command_status_parsing(buf);\
        if (CMD_SUCCESS == ret) {   \
            printf("# command status (success)\n"); \
        }  \
        else{   \
            printf("# command status (failed 0x%02x)\n" , ret); \
        }\
        print_charray(len,buf); \
		
#define VERDICT_FAIL_RESULT_WITH_LINE()	\
        if (PASS == verdict)    \
        {   \
            line=__LINE__;  \
            goto FUN_FAIL;  \
        }

#define VERDICT_RESULT_WITH_LINE()	\
		if (PASS != verdict)	\
		{	\
			line=__LINE__;	\
			goto FUN_FAIL;	\
		}

#define VERDICT_ERROR_CODE_CHECK_WITH_LINE(ERRORCODE)	\
		if (ERRORCODE != verdict)	\
		{	\
			line=__LINE__;	\
			goto FUN_FAIL;	\
		}

#define FUNC_END() \
        printf(INV "\n                               [run func end]                               \n" NONE);\
        event_query_timer_stop(&timer); \
        read_le_event_disable(); \
        COMM_Dut_check_payload(dut1_fd , 0); \
    	dut_reset_with_mask_en(dut1_fd); \
        COMM_Dut_check_payload(dut2_fd , 0); \
        dut_reset_with_mask_en(dut2_fd); \
        printf(INV "\n                               [run func end]                               \n" NONE);\
        gettimeofday(&timeEnd, NULL);   \
        LOG_INFO("Execution Time : %d sec\n", (u32)(timeEnd.tv_sec - timeStart.tv_sec));

#define MULTIROLE_FUNC_END() \
        {\
            printf(INV "\n[run func end]\n" NONE);\
            event_query_timer_stop(&timer); \
            read_le_event_disable(); \
            int dut_cnt = 0; \
            for(dut_cnt = 0; dut_cnt < MAX_DUTS+1; dut_cnt++) { \
                if(Dut_setting[dut_cnt].dut_fd != 0) \
                    COMM_Dut_check_payload(Dut_setting[dut_cnt].dut_fd, 0); \
            }\
            for(dut_cnt = 0; dut_cnt < MAX_DUTS+1; dut_cnt++) { \
                if(Dut_setting[dut_cnt].dut_fd != 0) \
                    dut_reset_with_mask_en(Dut_setting[dut_cnt].dut_fd); \
            }\
            gettimeofday(&timeEnd, NULL);   \
            LOG_INFO("Execution Time : %d sec\n", (u32)(timeEnd.tv_sec - timeStart.tv_sec)); \
        }\

#define LOG_TIME() \
        gettimeofday(&start_time,NULL); \
        LOG_INFO("\n###time = %ld %ld###\n",start_time.tv_sec ,start_time.tv_usec); \

#define CHECK_CONNECT() \
        printf("\ncheck connect with dut 1\n");    \
        if (SUCCESS != QUERY_LE_Event(dut1_fd, buf, _BT_HCI_LE_EVENT_SUB_OP_CONNECTION_COMPLETE_, 0)) { \
    	    line = __LINE__;    \
    	    goto FUN_FAIL;  \
    	}   \
    	else if(SUCCESS != hci_le_event_connection_complete_parsing(0, buf, g_pattern_param)) { \
    	    line = __LINE__;    \
    	    goto FUN_FAIL;  \
    	}   \
        printf("\ncheck connect with dut 2\n");    \
        if (SUCCESS != QUERY_LE_Event(dut2_fd, buf, _BT_HCI_LE_EVENT_SUB_OP_CONNECTION_COMPLETE_, 0)) { \
    	    line = __LINE__;    \
    	    goto FUN_FAIL;  \
    	}   \
    	else if(SUCCESS != hci_le_event_connection_complete_parsing(0, buf, g_pattern_param)) { \
    	    line = __LINE__;    \
    	    goto FUN_FAIL;  \
    	}   \

#define CHECK_NON_DISCONNECT()  \
         printf("\ncheck disconnect with dut 1\n");    \
         if(SUCCESS != QUERY_Event(dut1_fd, buf, _BT_HCI_EVENT_OP_DISCONNECTION_COMPLETE_)) {    \
             line = __LINE__;   \
             goto FUN_FAIL; \
         }  else if(SUCCESS != hci_event_disconnection_complete_parsing(0, buf, g_pattern_param)) {    \
             line = __LINE__;   \
             goto FUN_FAIL; \
         }  \
         if( 0 != buf[_BT_HCI_EVT_DISCONN_COMP_REASON]) { \
             line = __LINE__;   \
             goto FUN_FAIL; \
         }  \
         printf("\ncheck disconnect with dut 2\n");    \
         if(SUCCESS != QUERY_Event(dut2_fd, buf, _BT_HCI_EVENT_OP_DISCONNECTION_COMPLETE_)) {   \
             line = __LINE__;   \
             goto FUN_FAIL; \
         }  else if(SUCCESS != hci_event_disconnection_complete_parsing(0, buf, g_pattern_param)) {    \
             line = __LINE__;   \
             goto FUN_FAIL; \
         }  \
         if( 0 != buf[_BT_HCI_EVT_DISCONN_COMP_REASON]) { \
             line = __LINE__;   \
             goto FUN_FAIL; \
         }  \


#define ADV_TIME_IND_PATTERN_CONFIG_READ() pattern_config_read(__FUNCTION__ , ADV_PARAM_TIME_INDEP );
#define ADV_TIME_DEP_PATTERN_CONFIG_READ() pattern_config_read(__FUNCTION__ , ADV_PARAM_TIME_DEP   );
#define SCN_TIME_IND_PATTERN_CONFIG_READ() pattern_config_read(__FUNCTION__ , SCAN_PARAM_TIME_INDEP   );
#define SCN_TIME_DEP_PATTERN_CONFIG_READ() pattern_config_read(__FUNCTION__ , SCAN_PARAM_TIME_DEP   );
#define SLA_TIME_IND_PATTERN_CONFIG_READ() pattern_config_read(__FUNCTION__ , SLAVE_PARAM_TIME_INDEP   );
#define SLA_TIME_DEP_PATTERN_CONFIG_READ() pattern_config_read(__FUNCTION__ , SLAVE_PARAM_TIME_DEP   );
#define ADV_STABLE_PATTERN_CONFIG_READ()   pattern_config_read(__FUNCTION__ , ADV_STABLE   );
#define SCN_STABLE_PATTERN_CONFIG_READ()   pattern_config_read(__FUNCTION__ , SCAN_STABLE   );
#define SLA_STABLE_PATTERN_CONFIG_READ()   pattern_config_read(__FUNCTION__ , SLAVE_STABLE   );
#define SLA_STRESS_PATTERN_CONFIG_READ()   pattern_config_read(__FUNCTION__ , SLAVE_STRESS   );
#define MULTIROLE_SLA_PERF_PATTERN_CONFIG_READ() pattern_config_read(__FUNCTION__ , MULTIROLE_SLA_PERF);


#define MSLEEP(val) usleep(val * 1000)

Pattern_param g_pattern_param;

/*
util
*/
char* 	dut_type_str(u8 dut_type) {
	switch (dut_type) {
    case DUT_TYPE_TI:	return "TI";
    case DUT_TYPE_SSV:	return "SSV";
    case DUT_TYPE_CSR:	return "CSR";
	}
	return "UNKNOWN";
}

void fill_data(u8 * source , u32 send_cnt){

    source[0] = (send_cnt & 0x00ff0000) >> 16 ; 
    source[1] = (send_cnt & 0x0000ff00) >>  8 ;
    source[2] = (send_cnt & 0x000000ff) ;

}

void acl_data_gen_tbx(u8 *acl_data , u8 len , u8 val)
{
	u8 cnt = 0;
	for ( ; cnt < len ; cnt ++){		
		acl_data[cnt+4] = val;
	}
}

void dump_fail_reason(Fail_reason *reason){

    LOG_INFO(" reason.instant_passed                 %d \n" , reason->instant_passed      );            
    LOG_INFO(" reason.no_conn_req                    %d \n" , reason->no_conn_req         );
    LOG_INFO(" reason.no_num_pkt_comp                %d \n" , reason->no_num_pkt_comp     );
    LOG_INFO(" reason_fail_to_establish              %d \n" , reason->fail_to_establish   );
    LOG_INFO(" reason.connection_timeout             %d \n" , reason->connection_timeout  );
    LOG_INFO(" reason.error_pld_acl                  %d \n" , reason->error_pld_acl       );
    LOG_INFO(" reason.error_no_acl                   %d \n" , reason->error_no_acl        );
    LOG_INFO(" reason.instant_passed                 %d \n" , reason->instant_passed      );
    LOG_INFO(" reason.no_encrypt_change_master       %d \n" , reason->no_encrypt_change_master      );   
    LOG_INFO(" reason.no_encrypt_change_slave        %d \n" , reason->no_encrypt_change_slave       );
}

int hci_event_num_of_completed_packets_parsing(u8 * event_parameter){
	return (event_parameter[_BT_HCI_IDX_EVENT_NUM_OF_PACKETS + 1] << 8) +
			event_parameter[_BT_HCI_IDX_EVENT_NUM_OF_PACKETS];
}

int hci_event_command_status_parsing(u8 * event_parameter){
	return event_parameter[_BT_HCI_IDX_CMD_STATUS];
}

int hci_event_command_complete_parsing(u8 * event_parameter){
	return event_parameter[_BT_HCI_W_EVENT_HEADER_+_BT_HCI_IDX_EVENT_PARAMETER_];
}

int hci_event_encryption_change_parsing(int adv_type,u8 * event_parameter ,Pattern_param param)
{
	printf("Status = %d\n" ,	event_parameter[_BT_HCI_EVT_ENCRYPTION_CHANGE_STATUS]);
	printf("Connection_Handle = 0x%02x 0x%02x\n" ,
		event_parameter[_BT_HCI_EVT_ENCRYPTION_CHANGE_CONN_HANDLE],
		event_parameter[_BT_HCI_EVT_ENCRYPTION_CHANGE_CONN_HANDLE+1]);
	printf("Encryption_Enabled = %d\n\n" ,	event_parameter[_BT_HCI_EVT_ENCRYPTION_CHANGE_ENABLED]);

    if ((event_parameter[_BT_HCI_EVT_ENCRYPTION_CHANGE_CONN_HANDLE] == 0) && 
        (event_parameter[_BT_HCI_EVT_ENCRYPTION_CHANGE_CONN_HANDLE+1] == 0)){
        return __LINE__ ; 
    }
    else{      
    	return event_parameter[_BT_HCI_EVT_DISCONN_COMP_STATUS];
    }
}

int hci_event_encryption_key_refresh_complte_parsing(int adv_type,u8 * event_parameter ,Pattern_param param)
{
	printf("Status = %d\n" ,	event_parameter[_BT_HCI_EVT_ENCRYPTION_KEY_REFRESH_COMPLETE_STATUS]);
	printf("Connection_Handle = 0x%02x 0x%02x\n\n" ,
		event_parameter[_BT_HCI_EVT_ENCRYPTION_KEY_REFRESH_COMPLETE_CONN_HANDLE],
		event_parameter[_BT_HCI_EVT_ENCRYPTION_KEY_REFRESH_COMPLETE_CONN_HANDLE+1]);

    if ((event_parameter[_BT_HCI_EVT_ENCRYPTION_KEY_REFRESH_COMPLETE_CONN_HANDLE] == 0) && 
        (event_parameter[_BT_HCI_EVT_ENCRYPTION_KEY_REFRESH_COMPLETE_CONN_HANDLE+1] == 0)){
        return __LINE__ ; 
    }        
    else{
	    return event_parameter[_BT_HCI_EVT_DISCONN_COMP_STATUS];
    }

}


int hci_event_disconnection_complete_parsing(int adv_type,u8 * event_parameter ,Pattern_param param)
{

	printf("Status = %d\n" ,	event_parameter[_BT_HCI_EVT_DISCONN_COMP_STATUS]);
    printf("Connection_Handle = 0x%02x 0x%02x\n" ,
        event_parameter[_BT_HCI_EVT_DISCONN_COMP_HANDLE],
        event_parameter[_BT_HCI_EVT_DISCONN_COMP_HANDLE+1]);
	printf("Disconnect Reason = 0x%x\n\n" , event_parameter[_BT_HCI_EVT_DISCONN_COMP_REASON]);

	return event_parameter[_BT_HCI_EVT_DISCONN_COMP_STATUS];
}

int hci_event_read_remote_version_information_complete_parsing(u8 * event_parameter ,Pattern_param param)
{
	printf("Status = %d\n" ,	event_parameter[_BT_HCI_EVT_REMOTE_VER_INFO_STATUS]);
	printf("Connection_Handle = 0x%02x 0x%02x\n" ,
		event_parameter[_BT_HCI_EVT_REMOTE_VER_INFO_CONN_HANDLE],
		event_parameter[_BT_HCI_EVT_REMOTE_VER_INFO_CONN_HANDLE+1]);
	printf("Version = %d\n" ,	event_parameter[_BT_HCI_EVT_REMOTE_VER_INFO_VER]);
	printf("Manufacturer_Name = 0x%02x 0x%02x\n" ,
		event_parameter[_BT_HCI_EVT_REMOTE_VER_INFO_MANU_NAME],
		event_parameter[_BT_HCI_EVT_REMOTE_VER_INFO_MANU_NAME+1]);
	printf("Subversion: = 0x%02x 0x%02x\n\n" ,
		event_parameter[_BT_HCI_EVT_REMOTE_VER_INFO_SUBVER],
		event_parameter[_BT_HCI_EVT_REMOTE_VER_INFO_SUBVER+1]);
    
    if ((event_parameter[_BT_HCI_EVT_REMOTE_VER_INFO_CONN_HANDLE] == 0) && 
        (event_parameter[_BT_HCI_EVT_REMOTE_VER_INFO_CONN_HANDLE+1] == 0)){
        return ERROR ; 
    }        
    else{
	    return event_parameter[_BT_HCI_EVT_REMOTE_VER_INFO_STATUS];
    }
}

int hci_event_read_remote_supported_features_complete_parsing(int adv_type,u8 * event_parameter ,Pattern_param param)
{

	printf("Subevent_Code = %d\n" , event_parameter[_BT_HCI_EVT_REMOTE_USED_FEATURES_SUB_CODE]);
	printf("Status = %d\n"		,	event_parameter[_BT_HCI_EVT_REMOTE_USED_FEATURES_STATUS]);
	printf("Connection_Handle = 0x%02x 0x%02x\n" ,
		event_parameter[_BT_HCI_EVT_REMOTE_USED_FEATURES_HANDLE+0],
		event_parameter[_BT_HCI_EVT_REMOTE_USED_FEATURES_HANDLE+1]);
	printf("LE_Features = %x%x%x%x%x%x%x%x\n\n" ,
		event_parameter[_BT_HCI_EVT_REMOTE_USED_FEATURES_LE_FEATURES+0],
		event_parameter[_BT_HCI_EVT_REMOTE_USED_FEATURES_LE_FEATURES+1],
		event_parameter[_BT_HCI_EVT_REMOTE_USED_FEATURES_LE_FEATURES+2],
		event_parameter[_BT_HCI_EVT_REMOTE_USED_FEATURES_LE_FEATURES+3],
		event_parameter[_BT_HCI_EVT_REMOTE_USED_FEATURES_LE_FEATURES+4],
		event_parameter[_BT_HCI_EVT_REMOTE_USED_FEATURES_LE_FEATURES+5],
		event_parameter[_BT_HCI_EVT_REMOTE_USED_FEATURES_LE_FEATURES+6],
		event_parameter[_BT_HCI_EVT_REMOTE_USED_FEATURES_LE_FEATURES+7]
	);

    if ((event_parameter[_BT_HCI_EVT_REMOTE_USED_FEATURES_HANDLE] == 0) && 
        (event_parameter[_BT_HCI_EVT_REMOTE_USED_FEATURES_HANDLE+1] == 0)){
        return ERROR ; 
    }        
    else{
    	return event_parameter[_BT_HCI_EVT_REMOTE_USED_FEATURES_STATUS];
    }
}

int hci_event_read_white_list_size_parsing(u8 * event_parameter)
{
	printf("Status = %d\n" ,	event_parameter[_BT_HCI_EVT_LE_READ_WHITE_LIST_SIZE_STATUS]);
	printf("Size   = %d\n" ,    event_parameter[_BT_HCI_EVT_LE_READ_WHITE_LIST_SIZE]);

	return event_parameter[_BT_HCI_EVT_LE_READ_WHITE_LIST_SIZE_STATUS];
}

int hci_event_read_buff_size_parsing(u8 * event_parameter)
{
	printf("Status = %d\n" ,	event_parameter[_BT_HCI_EVT_LE_READ_BUFF_SIZE_STATUS]);
	printf("Data Pkt Len = %02x %02x\n" ,
		event_parameter[_BT_HCI_EVT_LE_READ_BUFF_SIZE_LE_DATA_PKT_LEN],
		event_parameter[_BT_HCI_EVT_LE_READ_BUFF_SIZE_LE_DATA_PKT_LEN+1]);
	printf("Data Pkts Num = %02x \n\n" ,
		event_parameter[_BT_HCI_EVT_LE_READ_BUFF_SIZE_LE_DATA_PKT_NUM]);

	return event_parameter[_BT_HCI_EVT_LE_READ_BUFF_SIZE_STATUS];
}


int hci_le_event_connection_complete_parsing(int adv_type,u8 * event_parameter ,Pattern_param param)
{
	printf("Subevent_Code = %d\n" , event_parameter[_BT_HCI_EVT_CON_COMP_SUB_CODE]);
	printf("Status = %d\n" ,	event_parameter[_BT_HCI_EVT_CON_COMP_STATUS]);
	printf("Connection_Handle = 0x%02x 0x%02x\n\n" ,
		event_parameter[_BT_HCI_EVT_CON_COMP_CONN_HANDLE],
		event_parameter[_BT_HCI_EVT_CON_COMP_CONN_HANDLE+1]);

    if ((event_parameter[_BT_HCI_EVT_CON_COMP_CONN_HANDLE] == 0) && 
        (event_parameter[_BT_HCI_EVT_CON_COMP_CONN_HANDLE+1] == 0)){
        return __LINE__ ; 
    }        
    else{
	    return event_parameter[_BT_HCI_EVT_CON_COMP_STATUS];
    }
}


int hci_le_event_advertising_report_parsing(int adv_type,u8 * event_parameter ,Pattern_param param)
{
	int ret = EQUAL;

    if(event_parameter[_BT_HCI_EVT_ADV_RPT_NUM_RPT] == 0){
        ret = __LINE__ ;
        return ret ;
    }

    if(event_parameter[_BT_HCI_IDX_EVENT_PARAMETER_] != 0){
        printf("\n");
    	printf("#Subevent_Code   =   %d\n" , event_parameter[_BT_HCI_IDX_EVENT_PARAMETER_]);
    	printf("#Num_Reports     =   %d\n" ,	event_parameter[_BT_HCI_EVT_ADV_RPT_NUM_RPT]);
    }
	//for (;report_cnt < event_parameter[4] ; report_cnt++)
	{
        //if(event_parameter[_BT_HCI_IDX_EVENT_PARAMETER_] != 0)
    	printf("#Event_Type      =   %d\n" ,	event_parameter[_BT_HCI_EVT_ADV_RPT_EVT_TYPE]);
		printf("#Address_Type    =   %d\n" ,	event_parameter[_BT_HCI_EVT_ADV_RPT_ADDR_TYPE]);
		printf("#Address         =   %02x:%02x:%02x:%02x:%02x:%02x\n" ,
			event_parameter[_BT_HCI_EVT_ADV_RPT_ADDR0],event_parameter[_BT_HCI_EVT_ADV_RPT_ADDR1],
			event_parameter[_BT_HCI_EVT_ADV_RPT_ADDR2],event_parameter[_BT_HCI_EVT_ADV_RPT_ADDR3],
			event_parameter[_BT_HCI_EVT_ADV_RPT_ADDR4],event_parameter[_BT_HCI_EVT_ADV_RPT_ADDR5]
			);
		printf("#Length_Data     =   %d\n" ,event_parameter[_BT_HCI_EVT_ADV_RPT_DATA_LEN]);
        
		if(0 != event_parameter[_BT_HCI_EVT_ADV_RPT_DATA_LEN])
			print_charray(event_parameter[_BT_HCI_EVT_ADV_RPT_DATA_LEN],event_parameter+_BT_HCI_EVT_ADV_RPT_DATA);
		//for(;data_len <event_parameter[13] ;data_len++ )
			//printf("%02x " ,event_parameter[14+data_len]);
		printf("#RSSI            =   %x\n\n" ,event_parameter[_BT_HCI_EVT_ADV_RPT_RSSI(event_parameter)]);
	}

    //# addr type check
	if (param.adv_param.Own_Address_Type[0]!=		event_parameter[_BT_HCI_EVT_ADV_RPT_ADDR_TYPE]){
		printf("!addr_type error %d:%d\n" ,         param.adv_param.Own_Address_Type[0] ,	
                                                    event_parameter[_BT_HCI_EVT_ADV_RPT_ADDR_TYPE]);
		ret=__LINE__;
	}

	if( adv_type != HCI_SUBEVENT_ADV_RPT_EVENT_SCAN_RSP){

        //# adv rpt type check
		if (param.adv_param.Advertising_Type[0] !=  event_parameter[_BT_HCI_EVT_ADV_RPT_EVT_TYPE]){
			printf("!adv_type error %d:%d\n" ,		param.adv_param.Advertising_Type[0]
												,	event_parameter[_BT_HCI_EVT_ADV_RPT_EVT_TYPE]);
			ret=__LINE__;
		}
    
	    //# adv rpt data len check
	    if(HCI_CMD_PARAM_ADV_DIRECT_IND != param.adv_param.Advertising_Type[0]){
    		if (param.adv_data_param.Advertising_Data_Length[0] !=		event_parameter[_BT_HCI_EVT_ADV_RPT_DATA_LEN]){
    			printf("!adv_data_len error %d:%d\n" ,
    				param.adv_data_param.Advertising_Data_Length[0],	event_parameter[_BT_HCI_EVT_ADV_RPT_DATA_LEN]);
    			ret=__LINE__;
    		}

    		if(0 != memcmp(param.adv_data_param.Advertising_Data,
    						event_parameter+_BT_HCI_EVT_ADV_RPT_DATA,		
    						event_parameter[_BT_HCI_EVT_ADV_RPT_DATA_LEN])){
    			printf("!adv_data error \n");
    			print_charray(event_parameter[_BT_HCI_EVT_ADV_RPT_DATA_LEN] ,	param.adv_data_param.Advertising_Data);
    			print_charray(event_parameter[_BT_HCI_EVT_ADV_RPT_DATA_LEN] ,	event_parameter+_BT_HCI_EVT_ADV_RPT_DATA);
    			ret=__LINE__;
    		}
	    }    

        
	    if(HCI_CMD_PARAM_ADV_DIRECT_IND == param.adv_param.Advertising_Type[0]){
            if(event_parameter[_BT_HCI_EVT_ADV_RPT_DATA_LEN] != 0){
    			printf("!adv_data_len error %d:%d\n" ,
    				param.adv_data_param.Advertising_Data_Length[0],	event_parameter[_BT_HCI_EVT_ADV_RPT_DATA_LEN]);
    			ret=__LINE__;
            }
	    }
        
	}
	else{//HCI_SUBEVENT_ADV_RPT_EVENT_SCAN_RSP

		if (param.scn_rsp_param.Scan_Response_Data_Length[0] != 	event_parameter[_BT_HCI_EVT_ADV_RPT_DATA_LEN]){
			printf("!scan_rsp_data_len error %d:%d\n" ,
				param.scn_rsp_param.Scan_Response_Data_Length[0],	event_parameter[_BT_HCI_EVT_ADV_RPT_DATA_LEN]);
			ret=__LINE__;
		}

		if(0 != memcmp(param.scn_rsp_param.Scan_Response_Data,
						event_parameter+_BT_HCI_EVT_ADV_RPT_DATA,		
						event_parameter[_BT_HCI_EVT_ADV_RPT_DATA_LEN])){
			printf("!scan_rsp_data error \n");
			print_charray(event_parameter[_BT_HCI_EVT_ADV_RPT_DATA_LEN] ,	param.scn_rsp_param.Scan_Response_Data);
			print_charray(event_parameter[_BT_HCI_EVT_ADV_RPT_DATA_LEN] ,	event_parameter+_BT_HCI_EVT_ADV_RPT_DATA);
			ret=__LINE__;
		}	   
		
	}

	// check the advertiser's address to avoid catch error data  //add by ShaoShih 2015/06/10 

	if(HCI_CMD_PARAM_ADV_DIRECT_IND != param.adv_param.Advertising_Type[0]) {

        if ( 0 != memcmp (param.adv_param.Direct_Address , 
             event_parameter + _BT_HCI_EVT_ADV_RPT_ADDR0 ,
             ADDR_LENGTH)){			 
    			printf("!Direct_Address error \n");
    			printf("!param.adv_param.Advertising_Type : %d \n", param.adv_param.Advertising_Type[0]);
                printf("!param %02x:%02x:%02x:%02x:%02x:%02x\n" , param.adv_param.Direct_Address[0] , param.adv_param.Direct_Address[1] , 
                    param.adv_param.Direct_Address[2] ,param.adv_param.Direct_Address[3] ,param.adv_param.Direct_Address[4] ,
                    param.adv_param.Direct_Address[5] );
                printf("!event %02x:%02x:%02x:%02x:%02x:%02x\n" , event_parameter[_BT_HCI_EVT_ADV_RPT_ADDR0] , event_parameter[_BT_HCI_EVT_ADV_RPT_ADDR1],
                    event_parameter[_BT_HCI_EVT_ADV_RPT_ADDR2] , event_parameter[_BT_HCI_EVT_ADV_RPT_ADDR3],
                    event_parameter[_BT_HCI_EVT_ADV_RPT_ADDR4] , event_parameter[_BT_HCI_EVT_ADV_RPT_ADDR5]);
    			ret = __LINE__; 		   
		}
	}
	else {

        u8 addr_check ;
        //# adv_direct_ind , rpt addr will be advA
        addr_check = (  memcmp(adv_addr             , event_parameter + _BT_HCI_EVT_ADV_RPT_ADDR0 , ADDR_LENGTH) &&
                        memcmp(adv_random_addr      , event_parameter + _BT_HCI_EVT_ADV_RPT_ADDR0 , ADDR_LENGTH) &&
                        memcmp(dut2_error_com_ass   , event_parameter + _BT_HCI_EVT_ADV_RPT_ADDR0 , ADDR_LENGTH) &&
                        memcmp(dut2_error_com_idf   , event_parameter + _BT_HCI_EVT_ADV_RPT_ADDR0 , ADDR_LENGTH) &&
                        memcmp(dut2_error_both      , event_parameter + _BT_HCI_EVT_ADV_RPT_ADDR0 , ADDR_LENGTH) );

        if (addr_check != 0){
            printf("!adv_Address error \n");
            printf("!param.adv_param.Advertising_Type : %d \n", 
                    param.adv_param.Advertising_Type[0]);
            printf("!param %02x:%02x:%02x:%02x:%02x:%02x\n" , 
                    param.adv_param.Direct_Address[0] , param.adv_param.Direct_Address[1] , 
                    param.adv_param.Direct_Address[2] , param.adv_param.Direct_Address[3] ,
                    param.adv_param.Direct_Address[4] , param.adv_param.Direct_Address[5] );
            
            printf("!event %02x:%02x:%02x:%02x:%02x:%02x\n" , 
                event_parameter[_BT_HCI_EVT_ADV_RPT_ADDR0] , event_parameter[_BT_HCI_EVT_ADV_RPT_ADDR1],
                event_parameter[_BT_HCI_EVT_ADV_RPT_ADDR2] , event_parameter[_BT_HCI_EVT_ADV_RPT_ADDR3],
                event_parameter[_BT_HCI_EVT_ADV_RPT_ADDR4] , event_parameter[_BT_HCI_EVT_ADV_RPT_ADDR5]);
            ret = __LINE__;     
        }

	}				  
	
	return ret;
}

int hci_le_event_connection_update_complete_parsing(int adv_type,u8 * event_parameter ,Pattern_param param)
{
	int ret = EQUAL;

	printf("Subevent_Code = %d\n" , event_parameter[_BT_HCI_EVT_CON_COMP_SUB_CODE]);
	printf("Status = %d\n" ,	event_parameter[_BT_HCI_EVT_CON_COMP_STATUS]);
	printf("Connection_Handle = 0x%02x 0x%02x\n" ,
		event_parameter[_BT_HCI_EVT_CON_COMP_CONN_HANDLE],
		event_parameter[_BT_HCI_EVT_CON_COMP_CONN_HANDLE+1]);

    if ((event_parameter[_BT_HCI_EVT_CON_COMP_CONN_HANDLE] == 0) && (event_parameter[_BT_HCI_EVT_CON_COMP_CONN_HANDLE+1] == 0)){
        ret=__LINE__;
    }        
    else{
	    return event_parameter[_BT_HCI_EVT_CON_COMP_STATUS];
    }

    if( 0 != memcmp (  event_parameter + _BT_HCI_EVT_CON_COMP_CONN_INT, 
                       param.conn_update_param.Conn_Interval_Min, 
                       2)){
        ret=__LINE__;
    }
    
    if( 0 != memcmp (  event_parameter + _BT_HCI_EVT_CON_COMP_CONN_LATENCY, 
                       param.conn_update_param.Conn_Latency, 
                       2)){
        ret=__LINE__;
    }

    if( 0 != memcmp (  event_parameter + _BT_HCI_EVT_CON_COMP_SUPER_TO, 
                       param.conn_update_param.Supervision_Timeout, 
                       2)){
        ret=__LINE__;

    }
    
	printf("Connection_Interval = %02x %02x\n" ,
		event_parameter[_BT_HCI_EVT_CON_COMP_CONN_INT],
		event_parameter[_BT_HCI_EVT_CON_COMP_CONN_INT+1]);
	printf("Connection_Latency  = %02x %02x\n" ,
		event_parameter[_BT_HCI_EVT_CON_COMP_CONN_LATENCY],
		event_parameter[_BT_HCI_EVT_CON_COMP_CONN_LATENCY+1]);
	printf("Supervision_Timeout = %02x %02x\n\n" ,
		event_parameter[_BT_HCI_EVT_CON_COMP_SUPER_TO],
		event_parameter[_BT_HCI_EVT_CON_COMP_SUPER_TO+1]);

    return ret;
    
}


int hci_le_event_ltk_request_parsing(int adv_type,u8 * event_parameter ,Pattern_param param)
{
	int ret = EQUAL;

	printf("Subevent_Code = %d\n" , event_parameter[_BT_HCI_EVT_LTK_REQ_SUB_CODE]);
	printf("Connection_Handle = 0x%02x 0x%02x\n" ,
		event_parameter[_BT_HCI_EVT_LTK_REQ_CONN_HANDLES+0],
		event_parameter[_BT_HCI_EVT_LTK_REQ_CONN_HANDLES+1]);
	printf("Random_Number = %x%x%x%x%x%x%x%x\n" ,
		event_parameter[_BT_HCI_EVT_LTK_REQ_RANDOM_NUM+0],
		event_parameter[_BT_HCI_EVT_LTK_REQ_RANDOM_NUM+1],
		event_parameter[_BT_HCI_EVT_LTK_REQ_RANDOM_NUM+2],
		event_parameter[_BT_HCI_EVT_LTK_REQ_RANDOM_NUM+3],
		event_parameter[_BT_HCI_EVT_LTK_REQ_RANDOM_NUM+4],
		event_parameter[_BT_HCI_EVT_LTK_REQ_RANDOM_NUM+5],
		event_parameter[_BT_HCI_EVT_LTK_REQ_RANDOM_NUM+6],
		event_parameter[_BT_HCI_EVT_LTK_REQ_RANDOM_NUM+7]);
	printf("Encrypted_Diversifier = 0x%02x 0x%02x\n\n" ,
		event_parameter[_BT_HCI_EVT_LTK_REQ_EDIV],
		event_parameter[_BT_HCI_EVT_LTK_REQ_EDIV+1]);

    if(( 0 == event_parameter[_BT_HCI_EVT_LTK_REQ_CONN_HANDLES+0]) && 
       ( 0 == event_parameter[_BT_HCI_EVT_LTK_REQ_CONN_HANDLES+1])){
        
        ret=__LINE__;        
    }

    return ret;
 
}

void Calculate_Execution_Time_Start() 
{
    gettimeofday(&timeStart,NULL);     
}

void read_le_event_enable()
{
	READ_LE_EVENT = 1;
}

void read_le_event_disable()
{
	READ_LE_EVENT =0 ;
}

int read_le_event_get()
{
	return READ_LE_EVENT;
}

int QUERY_Acl_Data(u8 dut_fd ,u8 * buf ){
	u16 len;
	u8 ret;
    
	memset(buf , 0 , SOCKET_BUF_SIZE);

	buf[_BT_HCI_IDX_INDICATOR_]         =	_BT_HCI_INDICATOR_QUERY_ACL_DATA_;
	buf[_BT_HCI_IDX_EVENT_CODE_]	    =	0xFF;
	buf[_BT_HCI_IDX_EVENT_LENGTH_]	    =	QUERY_ACL_LENGTH ;

#ifdef READ_EVT_DEBUG
    PRINT_TIME;
    printf(COLOR);
	printf("# send Acl Data query (dut:%d)\n",dut_fd);
    printf(NONE);
	print_charray(QUERY_EVT_HDR_LENGTH + _BT_HCI_W_EVENT_LENGTH_ +QUERY_ACL_LENGTH,buf);
#endif

	ret=socket_msg_send(dut_fd , QUERY_EVT_HDR_LENGTH + _BT_HCI_W_EVENT_LENGTH_ +QUERY_ACL_LENGTH ,buf);
	if(SOCKET_SUCCESS != ret)
		return __LINE__;

    do{
        ret=socket_msg_get(dut_fd,&len,buf);
    }while(len <=0);

	if(SOCKET_SUCCESS != ret)
		return __LINE__;

#ifdef READ_EVT_DEBUG
    PRINT_TIME;
    printf(COLOR);
	printf("# recv Acl Data from Buff (dut:%d)(len:%d)\n",dut_fd , len);
    printf(NONE);
	print_charray(len,buf);
#endif
	return SUCCESS;

}


int QUERY_Event(u8 dut_fd ,u8 * buf ,u8 event ){
	u16 len;
	u8 ret;

	memset(buf , 0 , SOCKET_BUF_SIZE);
    
	buf[_BT_HCI_IDX_INDICATOR_]         =	_BT_HCI_INDICATOR_QUERY_EVENT_;
	buf[_BT_HCI_IDX_EVENT_CODE_]	    =	event;
	buf[_BT_HCI_IDX_EVENT_LENGTH_]	    =	QUERY_EVT_LENGTH ;

#ifdef READ_EVT_DEBUG
    PRINT_TIME;
    printf(COLOR);
	printf("# send Event query (dut:%d)\n",dut_fd);
    printf(NONE);
	print_charray(QUERY_EVT_HDR_LENGTH + _BT_HCI_W_EVENT_LENGTH_ +QUERY_EVT_LENGTH,buf);
#endif
	ret=socket_msg_send(dut_fd , QUERY_EVT_HDR_LENGTH + _BT_HCI_W_EVENT_LENGTH_ +QUERY_EVT_LENGTH ,buf);
	if(SOCKET_SUCCESS != ret)
		return __LINE__;

    do{
        ret=socket_msg_get(dut_fd,&len,buf);
    }while(len <=0);
	if(SOCKET_SUCCESS != ret)
		return __LINE__;

#ifdef READ_EVT_DEBUG
    PRINT_TIME;
    printf(COLOR);
	printf("# recv Event from Buff (dut:%d)\n",dut_fd);
    printf(NONE);
	print_charray(len,buf);
#endif

	return SUCCESS;

}


int QUERY_LE_Event(u8 dut_fd ,u8 * buf ,u8 sub_event ,u8 adv_type){
	u16 len;
	u8 ret;

	memset(buf , 0 , SOCKET_BUF_SIZE);
    
	buf[_BT_HCI_IDX_INDICATOR_] 		=	_BT_HCI_INDICATOR_QUERY_EVENT_;
	buf[_BT_HCI_IDX_EVENT_CODE_]		=	_BT_HCI_EVENT_OP_LE_EVENT_;
	buf[_BT_HCI_IDX_EVENT_LENGTH_]		=	QUERY_LE_EVT_LENGTH ;
	buf[_BT_HCI_IDX_EVENT_PARAMETER_]	=	sub_event;
	buf[_BT_HCI_IDX_EVENT_PARAMETER_+1] =	0x00 ;//don't care	
	buf[_BT_HCI_IDX_EVENT_PARAMETER_+2] =	adv_type;
    
#ifdef READ_EVT_DEBUG
    PRINT_TIME;
    printf(COLOR);
    printf("# send Le Event query (dut:%d)\n",dut_fd);
    printf(NONE);
    print_charray(QUERY_EVT_HDR_LENGTH + _BT_HCI_W_EVENT_LENGTH_ +QUERY_LE_EVT_LENGTH+2,buf);
#endif

	ret=socket_msg_send(dut_fd , QUERY_EVT_HDR_LENGTH + _BT_HCI_W_EVENT_LENGTH_ +QUERY_LE_EVT_LENGTH+2 ,buf);
	if(SOCKET_SUCCESS != ret)
		return __LINE__;

    do{
        ret=socket_msg_get(dut_fd,&len,buf);
    }while(len <=0);
	if(SOCKET_SUCCESS != ret)
		return __LINE__;

#ifdef READ_EVT_DEBUG
    PRINT_TIME;
    printf(COLOR);
    printf("# recv Le Event from Buff (dut:%d)\n",dut_fd);
    printf(NONE);
	print_charray(len,buf);
#endif



	return SUCCESS;

}

void cfg_parse_hex(u8 *src, u8 *dest ,u8 digit)
{
	u8 i,k=0;
	for(i=0;i<digit;i++)
		{
		if(src[i] >= '0' && src[i] <= '9')
			dest[k] = (src[i] - '0') <<4;
		else if(src[i] >= 'A' && src [i] <= 'F')
			dest[k] = (src[i] - 'A'+10) << 4;
		else if(src[i] >= 'a' && src [i] <= 'f')
			dest[k] = (src[i] - 'a'+10) << 4;

		i++;

		if(src[i] >= '0' && src[i] <= '9')
			dest[k++] += src[i] - '0';
		else if(src[i] >= 'A' && src [i] <= 'F')
			dest[k++] += src[i] - 'A' +10;
		else if(src[i] >= 'a' && src [i] <= 'f')
			dest[k++] += src[i] - 'a' +10;

		i++;
		}

}

u8 pattern_config_read(const char * func_name , int type){

	// # read config file
    switch(type){
        case ADV_PARAM_TIME_INDEP :
            param_config_read(func_name  , adv_param_time_indep_config_tbl);
            break;

        case ADV_PARAM_TIME_DEP :
            param_config_read(func_name  , adv_param_time_dep_config_tbl);
            break;

        case SCAN_PARAM_TIME_INDEP :
            param_config_read(func_name  , scan_param_time_indep_config_tbl);
            break;
        
        case SCAN_PARAM_TIME_DEP :
            param_config_read(func_name  , scan_param_time_dep_config_tbl);
            break;

        case SLAVE_PARAM_TIME_INDEP :
            param_config_read(func_name  , slave_param_time_indep_config_tbl);
            break;
        
        case SLAVE_PARAM_TIME_DEP :
            param_config_read(func_name  , slave_param_time_dep_config_tbl);
            break;            

        case ADV_STABLE :
            param_config_read(func_name  , adv_stable_config_tbl);
            break;            

        case SCAN_STABLE :
            param_config_read(func_name  , scan_stable_config_tbl);
            break;  

        case SLAVE_STABLE :
            param_config_read(func_name  , sla_stable_config_tbl);
            break;  

        case SLAVE_STRESS :
            param_config_read(func_name  , sla_stress_config_tbl);
            break; 

        case MULTIROLE_SLA_PERF :
            param_config_read(func_name  , multirole_sla_perf_config_tbl);
            break;

    }

	return 0;
}

void error_addr_config(void){

    int i ;

    for(i = 0; i <= 5; i++) {
        dut1_error_both[i] = error_addr[i];
        dut2_error_both[i] = error_addr[i];
        
        if(i <= 2){
            dut1_error_com_ass[i] = scan_addr[i];
            dut1_error_com_idf[i] = error_addr[i];
            dut2_error_com_ass[i] = adv_addr[i];
            dut2_error_com_idf[i] = error_addr[i];
        }
        else {
            dut1_error_com_ass[i] = error_addr[i];
            dut1_error_com_idf[i] = scan_addr[i];
            dut2_error_com_ass[i] = error_addr[i];
            dut2_error_com_idf[i] = adv_addr[i];
        }
    }

    printf("dut1_error_com_ass = %02x:%02x:%02x:%02x:%02x:%02x\n",dut1_error_com_ass[0],dut1_error_com_ass[1],dut1_error_com_ass[2],\
         dut1_error_com_ass[3],dut1_error_com_ass[4],dut1_error_com_ass[5]);

    printf("dut1_error_com_idf = %02x:%02x:%02x:%02x:%02x:%02x\n",dut1_error_com_idf[0],dut1_error_com_idf[1],dut1_error_com_idf[2],\
         dut1_error_com_idf[3],dut1_error_com_idf[4],dut1_error_com_idf[5]);

    printf("dut1_error_both    = %02x:%02x:%02x:%02x:%02x:%02x\n",dut1_error_both[0],dut1_error_both[1],dut1_error_both[2],\
         dut1_error_both[3],dut1_error_both[4],dut1_error_both[5]);

    printf("dut2_error_com_ass = %02x:%02x:%02x:%02x:%02x:%02x\n",dut2_error_com_ass[0],dut2_error_com_ass[1],dut2_error_com_ass[2],\
         dut2_error_com_ass[3],dut2_error_com_ass[4],dut2_error_com_ass[5]);

    printf("dut2_error_com_idf = %02x:%02x:%02x:%02x:%02x:%02x\n",dut2_error_com_idf[0],dut2_error_com_idf[1],dut2_error_com_idf[2],\
         dut2_error_com_idf[3],dut2_error_com_idf[4],dut2_error_com_idf[5]);

    printf("dut2_error_both    = %02x:%02x:%02x:%02x:%02x:%02x\n",dut2_error_both[0],dut2_error_both[1],dut2_error_both[2],\
         dut2_error_both[3],dut2_error_both[4],dut2_error_both[5]);

}

void cfg_dev_type(u8 dut_num ,u8 *dut_type_name){
    
    if(memcmp(dut_type_name,"ti",2) == 0){
        s_dev_type[dut_num] = DUT_TYPE_TI;
    }
    
    if (memcmp(dut_type_name,"ssv",3) == 0){
        s_dev_type[dut_num] = DUT_TYPE_SSV;
    }
    
    if (memcmp(dut_type_name,"csr",3) == 0){
        s_dev_type[dut_num] = DUT_TYPE_CSR;
    }
    
    if(s_dev_type[dut_num] == 0){
        printf("!error dut type config");
        exit(1);
    }

    Dut_setting[dut_num].dut_type = s_dev_type[dut_num];
    printf("dut%d = %s", dut_num , dut_type_name);

}


#define CONFIG_BUF_SIZE 32
u8 bench_config_load(enum_cfg role_cfg){
	FILE *cfg_f;
	u8 cfg[1025],*pt ;

    switch (role_cfg){
        
        case CFG_ADV:
            printf("load adv cfg\n");
            if ((cfg_f = fopen("bench-adv.cfg","r")) == NULL){
             printf("cant't open config file\n");
             return -1;
            }
            break;

        case CFG_SCAN:
            printf("load scan cfg\n");            
            if ((cfg_f = fopen("bench-scn.cfg","r")) == NULL){
             printf("cant't open config file\n");
             return -1;
            }
            break;            
            
        case CFG_MULTIROLE:
            printf("load multirole cfg\n");            
            if ((cfg_f = fopen("bench-multirole.cfg","r")) == NULL){
             printf("cant't open config file\n");
             return -1;
            }

            break;

        default:            
            printf("load default cfg\n");
            if ((cfg_f = fopen("bench.cfg","r")) == NULL){
             printf("cant't open config file\n");
             return -1;
            }
            break;

    }

	//read config file, select dut path.
	while(1){
		fgets((char*)cfg , CONFIG_BUF_SIZE , cfg_f);
		if(cfg[0] == '^'){
			break;
		}

		pt=cfg;

		if(memcmp(cfg,"dev_num",7) == 0){
			while(*pt++ != '='){};
			printf("dev = %d\n" , atoi((char*)pt));
			s_dev_num = atoi((char*)pt);
		}
        
#define CFG_MANUFACTURER_LEN 4
#define CFG_SUBVERSION_LEN 4

		if(memcmp(cfg,"manufacturer",12) == 0){
			while(*pt++ != '='){};
            cfg_parse_hex(pt , s_manufacturer , CFG_MANUFACTURER_LEN);            
			printf("manufacturer = %02x%02x\n" , s_manufacturer[0] , s_manufacturer[1]);
		}
        
		if(memcmp(cfg,"subversion",10) == 0){
			while(*pt++ != '='){};
            cfg_parse_hex(pt , s_subversion , CFG_SUBVERSION_LEN);                        
			printf("subversion = %02x%02x\n" , s_subversion[0] ,s_subversion[1] );
		}
        // # start from '1'
        
		if(memcmp(cfg,"dut1_type",sizeof("dut1_type")-1) == 0){
			while(*pt++ != '='){};
            cfg_dev_type(1 , pt);
		}

		if(memcmp(cfg,"dut2_type",sizeof("dut2_type")-1) == 0){
			while(*pt++ != '='){};
            cfg_dev_type(2 , pt);            
		}

        if(memcmp(cfg,"dut3_type",sizeof("dut3_type")-1) == 0){
            while(*pt++ != '='){};
            cfg_dev_type(3 , pt);            
        }

        if(memcmp(cfg,"dut4_type",sizeof("dut4_type")-1) == 0){
            while(*pt++ != '='){};
            cfg_dev_type(4 , pt);            
        }

#define CFG_ADDR_LEN 18

		if(memcmp(cfg,"scan_addr",sizeof("scan_addr")-1) == 0){
			while(*pt++ != '='){};
			cfg_parse_hex(pt,scan_addr , CFG_ADDR_LEN);
            LOG_DEVICE(scan_addr , LOG_DEVICE_TYPE_SCANNER);
			//		  memcpy(cen_addr,dut_central_cfg.implementation_cfg.bd_addr,BD_ADDR_LEN);
			printf("scan_addr = %02x:%02x:%02x:%02x:%02x:%02x\n",scan_addr[0],scan_addr[1],scan_addr[2],\
					scan_addr[3],scan_addr[4],scan_addr[5]);
		}

		if(memcmp(cfg,"adv_addr",sizeof("adv_addr")-1) == 0){
			while(*pt++ != '='){};
			cfg_parse_hex(pt,adv_addr , CFG_ADDR_LEN);
            LOG_DEVICE(adv_addr , LOG_DEVICE_TYPE_ADVERTISER);
			//		memcpy(peri_addr,dut_peri_cfg.implementation_cfg.bd_addr,BD_ADDR_LEN);
			printf("adv_addr  = %02x:%02x:%02x:%02x:%02x:%02x\n",adv_addr[0],adv_addr[1],adv_addr[2],\
					adv_addr[3],adv_addr[4],adv_addr[5]);
		}

		if(memcmp(cfg,"init_addr",sizeof("init_addr")-1) == 0){
			while(*pt++ != '='){};
			cfg_parse_hex(pt,init_addr, CFG_ADDR_LEN);
            LOG_DEVICE(init_addr , LOG_DEVICE_TYPE_INITATOR);
			//		memcpy(peri_addr,dut_peri_cfg.implementation_cfg.bd_addr,BD_ADDR_LEN);
			printf("init_addr = %02x:%02x:%02x:%02x:%02x:%02x\n",init_addr[0],init_addr[1],init_addr[2],\
					init_addr[3],init_addr[4],init_addr[5]);
		}

        if(memcmp(cfg,"dut1_addr",sizeof("dut1_addr")-1) == 0){
            while(*pt++ != '='){};
            cfg_parse_hex(pt,Dut_setting[1].dut_addr, CFG_ADDR_LEN);
            LOG_DEVICE(Dut_setting[1].dut_addr , LOG_MULTIROLE_DEVICE_TYPE_1);
            //      memcpy(peri_addr,dut_peri_cfg.implementation_cfg.bd_addr,BD_ADDR_LEN);
            printf("dut1_addr = %02x:%02x:%02x:%02x:%02x:%02x\n",Dut_setting[1].dut_addr[0], Dut_setting[1].dut_addr[1], Dut_setting[1].dut_addr[2],\
                    Dut_setting[1].dut_addr[3], Dut_setting[1].dut_addr[4], Dut_setting[1].dut_addr[5]);

            //single role to muti role should init new dut_fd
            int dut_fd = dut_socket_init(1);
            if(ERROR != dut_fd) {
                Dut_setting[1].dut_fd = dut_fd;
                dut_reset_with_mask_en(dut_fd);
            }  
        }

        if(memcmp(cfg,"dut2_addr",sizeof("dut2_addr")-1) == 0){
            while(*pt++ != '='){};
            cfg_parse_hex(pt,Dut_setting[2].dut_addr, CFG_ADDR_LEN);
            LOG_DEVICE(Dut_setting[2].dut_addr , LOG_MULTIROLE_DEVICE_TYPE_2);
            //      memcpy(peri_addr,dut_peri_cfg.implementation_cfg.bd_addr,BD_ADDR_LEN);
            printf("dut2_addr = %02x:%02x:%02x:%02x:%02x:%02x\n",Dut_setting[2].dut_addr[0],Dut_setting[2].dut_addr[1],Dut_setting[2].dut_addr[2],\
                    Dut_setting[2].dut_addr[3],Dut_setting[2].dut_addr[4],Dut_setting[2].dut_addr[5]);

            //single role to muti role should init new dut_fd
            int dut_fd = dut_socket_init(2);
            if(ERROR != dut_fd) {
                Dut_setting[2].dut_fd = dut_fd;
                dut_reset_with_mask_en(dut_fd);
            }
        }

        if(memcmp(cfg,"dut3_addr",sizeof("dut3_addr")-1) == 0){
            while(*pt++ != '='){};
            cfg_parse_hex(pt,Dut_setting[3].dut_addr, CFG_ADDR_LEN);
            LOG_DEVICE(Dut_setting[3].dut_addr , LOG_MULTIROLE_DEVICE_TYPE_3);
            //      memcpy(peri_addr,dut_peri_cfg.implementation_cfg.bd_addr,BD_ADDR_LEN);
            printf("dut3_addr = %02x:%02x:%02x:%02x:%02x:%02x\n",Dut_setting[3].dut_addr[0],Dut_setting[3].dut_addr[1],Dut_setting[3].dut_addr[2],\
                    Dut_setting[3].dut_addr[3],Dut_setting[3].dut_addr[4],Dut_setting[3].dut_addr[5]);

            //single role to muti role should init new dut_fd
            int dut_fd = dut_socket_init(3);
            if(ERROR != dut_fd) {
                Dut_setting[3].dut_fd = dut_fd;
                dut_reset_with_mask_en(dut_fd);
            }
        }

        if(memcmp(cfg,"dut4_addr",sizeof("dut4_addr")-1) == 0){
            while(*pt++ != '='){};
            cfg_parse_hex(pt,Dut_setting[4].dut_addr, CFG_ADDR_LEN);
            LOG_DEVICE(Dut_setting[4].dut_addr , LOG_MULTIROLE_DEVICE_TYPE_4);
            //      memcpy(peri_addr,dut_peri_cfg.implementation_cfg.bd_addr,BD_ADDR_LEN);
            printf("dut4_addr = %02x:%02x:%02x:%02x:%02x:%02x\n",Dut_setting[4].dut_addr[0],Dut_setting[4].dut_addr[1],Dut_setting[4].dut_addr[2],\
                    Dut_setting[4].dut_addr[3],Dut_setting[4].dut_addr[4],Dut_setting[4].dut_addr[5]);

            //single role to muti role should init new dut_fd
            int dut_fd = dut_socket_init(4);
            if(ERROR != dut_fd) {
                Dut_setting[4].dut_fd = dut_fd;
                dut_reset_with_mask_en(dut_fd);
            }
        }

		if(memcmp(cfg,"dtm_pkt_cnt",11) == 0){
		    while(*pt++ != '='){};
			s_pkt_cnt = atoi((char*)pt) ;
			printf("pkt_cnt = %d\n" , s_pkt_cnt);
		}

	 }

	 printf("\n");

	 fclose(cfg_f);
	 return 0;
}


// # toolbox
void Dtm_Tx_Sleep_time(u32 pkt2tx )
{
	if(170 > pkt2tx)
	{
		usleep(120000);
	}else if(820 > pkt2tx)
	{
		usleep(585000);
	}
	else if(1700 > pkt2tx)
	{
		sleep(1);
		usleep(170000);
	}
	else if(3200 > pkt2tx)
	{
		sleep(2);
		usleep(340000);
	}
	else if(6400 > pkt2tx)
	{
		sleep(4);
		usleep(680000);

	}
	else if(10000 >= pkt2tx)
	{
		sleep(7);
		usleep(250000);

	}
}

int Dtm(int rxdut, int txdut ,int channel ,u32 pkt_cnt ,Ret_param * retp)
{
		s32 dut1_fd=0;
		s32 dut2_fd=0;
		u8 buf[SOCKET_BUF_SIZE]; //william : buf size should be  according socket_get_msg
		u16 len;

		u32 pkt2tx=pkt_cnt;
		// paramters for commands
		u8 TX_Frequency[1]		 = {channel};
		u8 Length_Of_Test_Data[1]	 = {0x25};
		u8 Packet_Payload[1]		 = {0x00};

		u8 VSCMD_TI_TX_Power_Level		  [1] = {0x01};
		u8 VSCMD_TI_RX_Mode 			  [1] = {0x00};
		u8 VSCMD_TI_Packets_to_transmit   [2] = {0xe8, 0x03};
		u8 VSCMD_TI_Access_code 		  [4] = {0x29, 0x41, 0x76, 0x71};
		u8 VSCMD_TI_PER_BER_Test_Enable   [1] = {0x00};
		u8 VSCMD_TI_BER_Test_Pattern	  [1] = {0x00};
		u8 VSCMD_TI_BER_Test_Packet_Length[1] = {0x1f};
		u8 VSCMD_TI_BER_FA_Threshold	  [1] = {0x14};
		u8 VSCMD_TI_Trace_Enable		  [1] = {0x00};
		u8 VSCMD_TI_Reference_CRC		  [4] = {0x55, 0x55, 0x55, 0x55};

		dut1_fd=dut_socket_init(rxdut);
		dut2_fd=dut_socket_init(txdut);
		//LOG_PRINTF("************* Testing with %d(rx) *************\n" ,dut1_fd);
		bt_hci_cmd_le_receiver_test.parameter_tbl[0].value = &channel;
		bt_hci_write_cmd2socket(dut1_fd, &bt_hci_cmd_le_receiver_test);

        do{
            socket_msg_get(dut1_fd,&len,buf);
        }while(len <=0);
		//print_charray(len,buf);
		bt_hci_event_parsing(buf[_BT_HCI_IDX_EVENT_CODE_],
							buf[_BT_HCI_IDX_EVENT_LENGTH_],
							buf+_BT_HCI_IDX_EVENT_PARAMETER_);

		//LOG_PRINTF("************* Testing with %d(rx) *************\n" ,dut2_fd);

		if (1) //TI
		{
	//		TI_LoadPatch(fd_uart_array[1]);
			VSCMD_TI_Packets_to_transmit[0] = (pkt2tx & 0x000000ff) >> 0;
			VSCMD_TI_Packets_to_transmit[1] = (pkt2tx & 0x0000ff00) >> 8;

			bt_hci_cmd_ti_set_le_test_mode_parameters.parameter_tbl[0].value = VSCMD_TI_TX_Power_Level		  ;
			bt_hci_cmd_ti_set_le_test_mode_parameters.parameter_tbl[1].value = VSCMD_TI_RX_Mode 			  ;
			bt_hci_cmd_ti_set_le_test_mode_parameters.parameter_tbl[2].value = VSCMD_TI_Packets_to_transmit   ;
			bt_hci_cmd_ti_set_le_test_mode_parameters.parameter_tbl[3].value = VSCMD_TI_Access_code 		  ;
			bt_hci_cmd_ti_set_le_test_mode_parameters.parameter_tbl[4].value = VSCMD_TI_PER_BER_Test_Enable   ;
			bt_hci_cmd_ti_set_le_test_mode_parameters.parameter_tbl[5].value = VSCMD_TI_BER_Test_Pattern	  ;
			bt_hci_cmd_ti_set_le_test_mode_parameters.parameter_tbl[6].value = VSCMD_TI_BER_Test_Packet_Length;
			bt_hci_cmd_ti_set_le_test_mode_parameters.parameter_tbl[7].value = VSCMD_TI_BER_FA_Threshold	  ;
			bt_hci_cmd_ti_set_le_test_mode_parameters.parameter_tbl[8].value = VSCMD_TI_Trace_Enable		  ;
			bt_hci_cmd_ti_set_le_test_mode_parameters.parameter_tbl[9].value = VSCMD_TI_Reference_CRC		  ;
			bt_hci_write_cmd2socket (dut2_fd, &bt_hci_cmd_ti_set_le_test_mode_parameters);
            do{
                socket_msg_get(dut2_fd,&len,buf);
            }while(len <=0);
			//print_charray(len,buf);
			bt_hci_event_parsing(buf[_BT_HCI_IDX_EVENT_CODE_],
								buf[_BT_HCI_IDX_EVENT_LENGTH_],
								buf+_BT_HCI_IDX_EVENT_PARAMETER_);

			bt_hci_cmd_le_transmitter_test.parameter_tbl[0].value = TX_Frequency		;
			bt_hci_cmd_le_transmitter_test.parameter_tbl[1].value = Length_Of_Test_Data;
			bt_hci_cmd_le_transmitter_test.parameter_tbl[2].value = Packet_Payload	;

			bt_hci_write_cmd2socket (dut2_fd, &bt_hci_cmd_le_transmitter_test);
            do{
                socket_msg_get(dut2_fd,&len,buf);
            }while(len <=0);
			//print_charray(len,buf);
			bt_hci_event_parsing(buf[_BT_HCI_IDX_EVENT_CODE_],
								buf[_BT_HCI_IDX_EVENT_LENGTH_],
								buf+_BT_HCI_IDX_EVENT_PARAMETER_);

			printf("Waiting TX finish...\n");
			Dtm_Tx_Sleep_time(pkt2tx);

#if 1 //wiliam add for even tx failed
			//printf("***********william testing****************\n");
			bt_hci_write_cmd2socket (dut2_fd, &bt_hci_cmd_le_transmitter_test);
            do{
                socket_msg_get(dut2_fd,&len,buf);
            }while(len <=0);
			//print_charray(len,buf);
			bt_hci_event_parsing(buf[_BT_HCI_IDX_EVENT_CODE_],
								buf[_BT_HCI_IDX_EVENT_LENGTH_],
								buf+_BT_HCI_IDX_EVENT_PARAMETER_);
#endif
			bt_hci_write_cmd2socket(dut2_fd, &bt_hci_cmd_le_test_end);
            do{
                socket_msg_get(dut2_fd,&len,buf);
            }while(len <=0);
			//print_charray(len,buf);
			bt_hci_event_parsing(buf[_BT_HCI_IDX_EVENT_CODE_],
								buf[_BT_HCI_IDX_EVENT_LENGTH_],
								buf+_BT_HCI_IDX_EVENT_PARAMETER_);

			bt_hci_write_cmd2socket(dut1_fd, &bt_hci_cmd_le_test_end);
            do{
                socket_msg_get(dut1_fd,&len,buf);
            }while(len <=0);
			//print_charray(len,buf);
			bt_hci_event_parsing(buf[_BT_HCI_IDX_EVENT_CODE_],
								buf[_BT_HCI_IDX_EVENT_LENGTH_],
								buf+_BT_HCI_IDX_EVENT_PARAMETER_);

			return (buf[5+_BT_HCI_IDX_EVENT_PARAMETER_]<<8) + buf[4+_BT_HCI_IDX_EVENT_PARAMETER_];
				}
}


int AutoDtm(int rxdut, int txdut ,int channel , u32 tx_pkt_cnt,Ret_param * retp)
{
		s32 dut1_fd=0;
		s32 dut2_fd=0;
		u8 buf[SOCKET_BUF_SIZE]; //william : buf size should be  according socket_get_msg
		u16 len;

		u32 pkt2tx=tx_pkt_cnt;
		// paramters for commands
		u8 TX_Frequency[1]		 = {channel};
		u8 Length_Of_Test_Data[1]	 = {0x25};
		u8 Packet_Payload[1]		 = {0x00};

		u8 VSCMD_TI_TX_Power_Level		  [1] = {0x01};
		u8 VSCMD_TI_RX_Mode 			  [1] = {0x00};
		u8 VSCMD_TI_Packets_to_transmit   [2] = {0xe8, 0x03};
		u8 VSCMD_TI_Access_code 		  [4] = {0x29, 0x41, 0x76, 0x71};
		u8 VSCMD_TI_PER_BER_Test_Enable   [1] = {0x00};
		u8 VSCMD_TI_BER_Test_Pattern	  [1] = {0x00};
		u8 VSCMD_TI_BER_Test_Packet_Length[1] = {0x1f};
		u8 VSCMD_TI_BER_FA_Threshold	  [1] = {0x14};
		u8 VSCMD_TI_Trace_Enable		  [1] = {0x00};
		u8 VSCMD_TI_Reference_CRC		  [4] = {0x55, 0x55, 0x55, 0x55};

		dut1_fd=dut_socket_init(rxdut);
		dut2_fd=dut_socket_init(txdut);
		//LOG_PRINTF("************* Testing with %d(rx) *************\n" ,dut1_fd);
		bt_hci_cmd_le_receiver_test.parameter_tbl[0].value = &channel;
		bt_hci_write_cmd2socket(dut1_fd, &bt_hci_cmd_le_receiver_test);

        do{
            socket_msg_get(dut1_fd,&len,buf);
        }while(len <=0);
		//print_charray(len,buf);
		bt_hci_event_parsing(buf[_BT_HCI_IDX_EVENT_CODE_],
							buf[_BT_HCI_IDX_EVENT_LENGTH_],
							buf+_BT_HCI_IDX_EVENT_PARAMETER_);

		//LOG_PRINTF("************* Testing with %d(rx) *************\n" ,dut2_fd);

		if (1) //TI
		{
	//		TI_LoadPatch(fd_uart_array[1]);
			VSCMD_TI_Packets_to_transmit[0] = (pkt2tx & 0x000000ff) >> 0;
			VSCMD_TI_Packets_to_transmit[1] = (pkt2tx & 0x0000ff00) >> 8;

			bt_hci_cmd_ti_set_le_test_mode_parameters.parameter_tbl[0].value = VSCMD_TI_TX_Power_Level		  ;
			bt_hci_cmd_ti_set_le_test_mode_parameters.parameter_tbl[1].value = VSCMD_TI_RX_Mode 			  ;
			bt_hci_cmd_ti_set_le_test_mode_parameters.parameter_tbl[2].value = VSCMD_TI_Packets_to_transmit   ;
			bt_hci_cmd_ti_set_le_test_mode_parameters.parameter_tbl[3].value = VSCMD_TI_Access_code 		  ;
			bt_hci_cmd_ti_set_le_test_mode_parameters.parameter_tbl[4].value = VSCMD_TI_PER_BER_Test_Enable   ;
			bt_hci_cmd_ti_set_le_test_mode_parameters.parameter_tbl[5].value = VSCMD_TI_BER_Test_Pattern	  ;
			bt_hci_cmd_ti_set_le_test_mode_parameters.parameter_tbl[6].value = VSCMD_TI_BER_Test_Packet_Length;
			bt_hci_cmd_ti_set_le_test_mode_parameters.parameter_tbl[7].value = VSCMD_TI_BER_FA_Threshold	  ;
			bt_hci_cmd_ti_set_le_test_mode_parameters.parameter_tbl[8].value = VSCMD_TI_Trace_Enable		  ;
			bt_hci_cmd_ti_set_le_test_mode_parameters.parameter_tbl[9].value = VSCMD_TI_Reference_CRC		  ;
			bt_hci_write_cmd2socket (dut2_fd, &bt_hci_cmd_ti_set_le_test_mode_parameters);
            do{
                socket_msg_get(dut2_fd,&len,buf);
            }while(len <=0);
			//print_charray(len,buf);
			bt_hci_event_parsing(buf[_BT_HCI_IDX_EVENT_CODE_],
								buf[_BT_HCI_IDX_EVENT_LENGTH_],
								buf+_BT_HCI_IDX_EVENT_PARAMETER_);

			bt_hci_cmd_le_transmitter_test.parameter_tbl[0].value = TX_Frequency		;
			bt_hci_cmd_le_transmitter_test.parameter_tbl[1].value = Length_Of_Test_Data;
			bt_hci_cmd_le_transmitter_test.parameter_tbl[2].value = Packet_Payload	;

			bt_hci_write_cmd2socket (dut2_fd, &bt_hci_cmd_le_transmitter_test);
            do{
                socket_msg_get(dut2_fd,&len,buf);
            }while(len <=0);
			//print_charray(len,buf);
			bt_hci_event_parsing(buf[_BT_HCI_IDX_EVENT_CODE_],
								buf[_BT_HCI_IDX_EVENT_LENGTH_],
								buf+_BT_HCI_IDX_EVENT_PARAMETER_);

			printf("Waiting TX finish...\n");
			Dtm_Tx_Sleep_time(pkt2tx);

#if 1 //wiliam add for even tx failed
			//printf("***********william testing****************\n");
			bt_hci_write_cmd2socket (dut2_fd, &bt_hci_cmd_le_transmitter_test);
            do{
                socket_msg_get(dut2_fd,&len,buf);
            }while(len <=0);
			//print_charray(len,buf);
			bt_hci_event_parsing(buf[_BT_HCI_IDX_EVENT_CODE_],
								buf[_BT_HCI_IDX_EVENT_LENGTH_],
								buf+_BT_HCI_IDX_EVENT_PARAMETER_);
#endif
			bt_hci_write_cmd2socket(dut2_fd, &bt_hci_cmd_le_test_end);
            do{
                socket_msg_get(dut2_fd,&len,buf);
            }while(len <=0);
			//print_charray(len,buf);
			bt_hci_event_parsing(buf[_BT_HCI_IDX_EVENT_CODE_],
								buf[_BT_HCI_IDX_EVENT_LENGTH_],
								buf+_BT_HCI_IDX_EVENT_PARAMETER_);

			bt_hci_write_cmd2socket(dut1_fd, &bt_hci_cmd_le_test_end);
            do{
                socket_msg_get(dut1_fd,&len,buf);
            }while(len <=0);
			//print_charray(len,buf);
			bt_hci_event_parsing(buf[_BT_HCI_IDX_EVENT_CODE_],
								buf[_BT_HCI_IDX_EVENT_LENGTH_],
								buf+_BT_HCI_IDX_EVENT_PARAMETER_);

			return (buf[5+_BT_HCI_IDX_EVENT_PARAMETER_]<<8) + buf[4+_BT_HCI_IDX_EVENT_PARAMETER_];
		}
}



void  TI_Dtm_Tx(u8 txdut  ,u8 channel ,u16 pkt_cnt , u8 pkt_len , u8 pld_tp){

	s32 dut1_fd=0;
	u8	buf[SOCKET_BUF_SIZE]; //william : buf size should be  according socket_get_msg
	u16 len;

	// paramters for commands
	u8 TX_Frequency[1]		 = {channel};
	u8 Length_Of_Packet[1]	 = {pkt_len};
	/*
	# 0 - PRBS 9
	# 1 - FOFO		: 11110000
	# 2 - ZOZO		: 10101010
	# 3 - PRBS 15
	# 4 - All Ones
	# 5 - All Zeros
	# 6 - OFOF		:00001111
	# 7 - OZOZ		:01010101
	*/
	u8 Packet_Payload_Type			  [1] = {pld_tp};
	u8 VSCMD_TI_TX_Power_Level		  [1] = {0x01};     //fixed ble power level
	u8 VSCMD_TI_RX_Mode 			  [1] = {0x00};     //normal ,widewin ,cont RX,widewin and powersaving
	u8 VSCMD_TI_Packets_to_transmit   [2] = {0};
	u8 VSCMD_TI_Access_code 		  [4] = {0x29, 0x41, 0x76, 0x71};
	u8 VSCMD_TI_PER_BER_Test_Enable   [1] = {0x00};     //BER disable , PER enable
	u8 VSCMD_TI_BER_Test_Pattern	  [1] = {0x00}; 	//PRBS 9
	u8 VSCMD_TI_BER_Test_Packet_Length[1] = {0x1f};     //Number of payload bytes to be recieved in the BER test
	u8 VSCMD_TI_BER_FA_Threshold	  [1] = {0x14};
	u8 VSCMD_TI_Trace_Enable		  [1] = {0x00};
	u8 VSCMD_TI_Reference_CRC		  [4] = {0x55, 0x55, 0x55, 0x55};

	printf("dut(%d) pkt=%d channel=%d len=%d pldtype=%d\n" ,
		txdut ,pkt_cnt ,channel , pkt_len , pld_tp);

	dut1_fd=dut_socket_init(txdut);
	printf("************* Testing with %d(tx) *************\n" ,dut1_fd);


	VSCMD_TI_Packets_to_transmit[0] = (pkt_cnt & 0x000000ff) >> 0;
	VSCMD_TI_Packets_to_transmit[1] = (pkt_cnt & 0x0000ff00) >> 8;

	bt_hci_cmd_ti_set_le_test_mode_parameters.parameter_tbl[0].value = VSCMD_TI_TX_Power_Level		  ;
	bt_hci_cmd_ti_set_le_test_mode_parameters.parameter_tbl[1].value = VSCMD_TI_RX_Mode 			  ;
	bt_hci_cmd_ti_set_le_test_mode_parameters.parameter_tbl[2].value = VSCMD_TI_Packets_to_transmit   ;
	bt_hci_cmd_ti_set_le_test_mode_parameters.parameter_tbl[3].value = VSCMD_TI_Access_code 		  ;
	bt_hci_cmd_ti_set_le_test_mode_parameters.parameter_tbl[4].value = VSCMD_TI_PER_BER_Test_Enable   ;
	bt_hci_cmd_ti_set_le_test_mode_parameters.parameter_tbl[5].value = VSCMD_TI_BER_Test_Pattern	  ;
	bt_hci_cmd_ti_set_le_test_mode_parameters.parameter_tbl[6].value = VSCMD_TI_BER_Test_Packet_Length;
	bt_hci_cmd_ti_set_le_test_mode_parameters.parameter_tbl[7].value = VSCMD_TI_BER_FA_Threshold	  ;
	bt_hci_cmd_ti_set_le_test_mode_parameters.parameter_tbl[8].value = VSCMD_TI_Trace_Enable		  ;
	bt_hci_cmd_ti_set_le_test_mode_parameters.parameter_tbl[9].value = VSCMD_TI_Reference_CRC		  ;
	bt_hci_write_cmd2socket (dut1_fd, &bt_hci_cmd_ti_set_le_test_mode_parameters);

    do{
        socket_msg_get(dut1_fd,&len,buf);
    }while(len <=0);
	//print_charray(len,buf);
	bt_hci_event_parsing(buf[_BT_HCI_IDX_EVENT_CODE_],
						buf[_BT_HCI_IDX_EVENT_LENGTH_],
						buf+_BT_HCI_IDX_EVENT_PARAMETER_);

	bt_hci_cmd_le_transmitter_test.parameter_tbl[0].value = TX_Frequency;
	bt_hci_cmd_le_transmitter_test.parameter_tbl[1].value = Length_Of_Packet;
	bt_hci_cmd_le_transmitter_test.parameter_tbl[2].value = Packet_Payload_Type ;

	bt_hci_write_cmd2socket (dut1_fd, &bt_hci_cmd_le_transmitter_test);
    
    do{
        socket_msg_get(dut1_fd,&len,buf);
    }while(len <=0);
	//print_charray(len,buf);
	bt_hci_event_parsing(buf[_BT_HCI_IDX_EVENT_CODE_],
						buf[_BT_HCI_IDX_EVENT_LENGTH_],
						buf+_BT_HCI_IDX_EVENT_PARAMETER_);

	printf("Waiting TX finish...\n");
	Dtm_Tx_Sleep_time(pkt_cnt);

	//add for even tx failed
	bt_hci_write_cmd2socket (dut1_fd, &bt_hci_cmd_le_transmitter_test);
    do{
        socket_msg_get(dut1_fd,&len,buf);
    }while(len <=0);
	//print_charray(len,buf);
	bt_hci_event_parsing(buf[_BT_HCI_IDX_EVENT_CODE_],
						buf[_BT_HCI_IDX_EVENT_LENGTH_],
						buf+_BT_HCI_IDX_EVENT_PARAMETER_);

}

void  TI_Dtm_Tx_Continue(u8 txdut  ,u8 channel ,u16 pkt_cnt , u8 pkt_len , u8 pld_tp){

	s32 dut1_fd=0;
	u8	buf[SOCKET_BUF_SIZE]; //william : buf size should be  according socket_get_msg
	u16 len;

	// paramters for commands
	u8 TX_Frequency[1]		 = {channel};
	u8 Length_Of_Packet[1]	 = {pkt_len};
	/*
	# 0 - PRBS 9
	# 1 - FOFO		: 11110000
	# 2 - ZOZO		: 10101010
	# 3 - PRBS 15
	# 4 - All Ones
	# 5 - All Zeros
	# 6 - OFOF		:00001111
	# 7 - OZOZ		:01010101
	*/
	u8 Packet_Payload_Type			  [1] = {pld_tp};
	u8 VSCMD_TI_TX_Power_Level		  [1] = {0x01};     //fixed ble power level
	u8 VSCMD_TI_RX_Mode 			  [1] = {0x00};     //normal ,widewin ,cont RX,widewin and powersaving
	u8 VSCMD_TI_Packets_to_transmit   [2] = {0};
	u8 VSCMD_TI_Access_code 		  [4] = {0x29, 0x41, 0x76, 0x71};
	u8 VSCMD_TI_PER_BER_Test_Enable   [1] = {0x00};     //BER disable , PER enable
	u8 VSCMD_TI_BER_Test_Pattern	  [1] = {0x00}; 	//PRBS 9
	u8 VSCMD_TI_BER_Test_Packet_Length[1] = {0x1f};     //Number of payload bytes to be recieved in the BER test
	u8 VSCMD_TI_BER_FA_Threshold	  [1] = {0x14};
	u8 VSCMD_TI_Trace_Enable		  [1] = {0x00};
	u8 VSCMD_TI_Reference_CRC		  [4] = {0x55, 0x55, 0x55, 0x55};

	printf("dut(%d) pkt=%d channel=%d len=%d pldtype=%d\n" ,
		txdut ,pkt_cnt ,channel , pkt_len , pld_tp);

	dut1_fd=dut_socket_init(txdut);
	printf("************* Testing with %d(tx) *************\n" ,dut1_fd);


	VSCMD_TI_Packets_to_transmit[0] = (pkt_cnt & 0x000000ff) >> 0;
	VSCMD_TI_Packets_to_transmit[1] = (pkt_cnt & 0x0000ff00) >> 8;

	bt_hci_cmd_ti_set_le_test_mode_parameters.parameter_tbl[0].value = VSCMD_TI_TX_Power_Level		  ;
	bt_hci_cmd_ti_set_le_test_mode_parameters.parameter_tbl[1].value = VSCMD_TI_RX_Mode 			  ;
	bt_hci_cmd_ti_set_le_test_mode_parameters.parameter_tbl[2].value = VSCMD_TI_Packets_to_transmit   ;
	bt_hci_cmd_ti_set_le_test_mode_parameters.parameter_tbl[3].value = VSCMD_TI_Access_code 		  ;
	bt_hci_cmd_ti_set_le_test_mode_parameters.parameter_tbl[4].value = VSCMD_TI_PER_BER_Test_Enable   ;
	bt_hci_cmd_ti_set_le_test_mode_parameters.parameter_tbl[5].value = VSCMD_TI_BER_Test_Pattern	  ;
	bt_hci_cmd_ti_set_le_test_mode_parameters.parameter_tbl[6].value = VSCMD_TI_BER_Test_Packet_Length;
	bt_hci_cmd_ti_set_le_test_mode_parameters.parameter_tbl[7].value = VSCMD_TI_BER_FA_Threshold	  ;
	bt_hci_cmd_ti_set_le_test_mode_parameters.parameter_tbl[8].value = VSCMD_TI_Trace_Enable		  ;
	bt_hci_cmd_ti_set_le_test_mode_parameters.parameter_tbl[9].value = VSCMD_TI_Reference_CRC		  ;
	bt_hci_write_cmd2socket (dut1_fd, &bt_hci_cmd_ti_set_le_test_mode_parameters);

    do{
        socket_msg_get(dut1_fd,&len,buf);
    }while(len <=0);
	//print_charray(len,buf);
	bt_hci_event_parsing(buf[_BT_HCI_IDX_EVENT_CODE_],
						buf[_BT_HCI_IDX_EVENT_LENGTH_],
						buf+_BT_HCI_IDX_EVENT_PARAMETER_);

	bt_hci_cmd_le_transmitter_test.parameter_tbl[0].value = TX_Frequency;
	bt_hci_cmd_le_transmitter_test.parameter_tbl[1].value = Length_Of_Packet;
	bt_hci_cmd_le_transmitter_test.parameter_tbl[2].value = Packet_Payload_Type ;

	bt_hci_write_cmd2socket (dut1_fd, &bt_hci_cmd_le_transmitter_test);
    
    do{
        socket_msg_get(dut1_fd,&len,buf);
    }while(len <=0);
	//print_charray(len,buf);
	bt_hci_event_parsing(buf[_BT_HCI_IDX_EVENT_CODE_],
						buf[_BT_HCI_IDX_EVENT_LENGTH_],
						buf+_BT_HCI_IDX_EVENT_PARAMETER_);

	printf("Waiting TX finish...\n");
	Dtm_Tx_Sleep_time(pkt_cnt);

	//add for even tx failed
	bt_hci_write_cmd2socket (dut1_fd, &bt_hci_cmd_le_transmitter_test);
    do{
        socket_msg_get(dut1_fd,&len,buf);
    }while(len <=0);
	//print_charray(len,buf);
	bt_hci_event_parsing(buf[_BT_HCI_IDX_EVENT_CODE_],
						buf[_BT_HCI_IDX_EVENT_LENGTH_],
						buf+_BT_HCI_IDX_EVENT_PARAMETER_);

}

void  TI_Dtm_Tx_Continue_End(u8 txdut  ,u8 channel ,u16 pkt_cnt , u8 pkt_len , u8 pld_tp){

	s32 dut1_fd=0;
	u8	buf[SOCKET_BUF_SIZE]; //william : buf size should be  according socket_get_msg
	u16 len;

	// paramters for commands
	u8 TX_Frequency[1]		 = {channel};
	u8 Length_Of_Packet[1]	 = {pkt_len};
	/*
	# 0 - PRBS 9
	# 1 - FOFO		: 11110000
	# 2 - ZOZO		: 10101010
	# 3 - PRBS 15
	# 4 - All Ones
	# 5 - All Zeros
	# 6 - OFOF		:00001111
	# 7 - OZOZ		:01010101
	*/
	u8 Packet_Payload_Type			  [1] = {pld_tp};
	u8 VSCMD_TI_TX_Power_Level		  [1] = {0x01};     //fixed ble power level
	u8 VSCMD_TI_RX_Mode 			  [1] = {0x00};     //normal ,widewin ,cont RX,widewin and powersaving
	u8 VSCMD_TI_Packets_to_transmit   [2] = {0};
	u8 VSCMD_TI_Access_code 		  [4] = {0x29, 0x41, 0x76, 0x71};
	u8 VSCMD_TI_PER_BER_Test_Enable   [1] = {0x00};     //BER disable , PER enable
	u8 VSCMD_TI_BER_Test_Pattern	  [1] = {0x00}; 	//PRBS 9
	u8 VSCMD_TI_BER_Test_Packet_Length[1] = {0x1f};     //Number of payload bytes to be recieved in the BER test
	u8 VSCMD_TI_BER_FA_Threshold	  [1] = {0x14};
	u8 VSCMD_TI_Trace_Enable		  [1] = {0x00};
	u8 VSCMD_TI_Reference_CRC		  [4] = {0x55, 0x55, 0x55, 0x55};

	printf("dut(%d) pkt=%d channel=%d len=%d pldtype=%d\n" ,
		txdut ,pkt_cnt ,channel , pkt_len , pld_tp);

	dut1_fd=dut_socket_init(txdut);
	printf("************* Testing with %d(tx) *************\n" ,dut1_fd);


	VSCMD_TI_Packets_to_transmit[0] = (pkt_cnt & 0x000000ff) >> 0;
	VSCMD_TI_Packets_to_transmit[1] = (pkt_cnt & 0x0000ff00) >> 8;

	bt_hci_cmd_ti_set_le_test_mode_parameters.parameter_tbl[0].value = VSCMD_TI_TX_Power_Level		  ;
	bt_hci_cmd_ti_set_le_test_mode_parameters.parameter_tbl[1].value = VSCMD_TI_RX_Mode 			  ;
	bt_hci_cmd_ti_set_le_test_mode_parameters.parameter_tbl[2].value = VSCMD_TI_Packets_to_transmit   ;
	bt_hci_cmd_ti_set_le_test_mode_parameters.parameter_tbl[3].value = VSCMD_TI_Access_code 		  ;
	bt_hci_cmd_ti_set_le_test_mode_parameters.parameter_tbl[4].value = VSCMD_TI_PER_BER_Test_Enable   ;
	bt_hci_cmd_ti_set_le_test_mode_parameters.parameter_tbl[5].value = VSCMD_TI_BER_Test_Pattern	  ;
	bt_hci_cmd_ti_set_le_test_mode_parameters.parameter_tbl[6].value = VSCMD_TI_BER_Test_Packet_Length;
	bt_hci_cmd_ti_set_le_test_mode_parameters.parameter_tbl[7].value = VSCMD_TI_BER_FA_Threshold	  ;
	bt_hci_cmd_ti_set_le_test_mode_parameters.parameter_tbl[8].value = VSCMD_TI_Trace_Enable		  ;
	bt_hci_cmd_ti_set_le_test_mode_parameters.parameter_tbl[9].value = VSCMD_TI_Reference_CRC		  ;
	bt_hci_write_cmd2socket (dut1_fd, &bt_hci_cmd_ti_set_le_test_mode_parameters);

    do{
        socket_msg_get(dut1_fd,&len,buf);
    }while(len <=0);
	//print_charray(len,buf);
	bt_hci_event_parsing(buf[_BT_HCI_IDX_EVENT_CODE_],
						buf[_BT_HCI_IDX_EVENT_LENGTH_],
						buf+_BT_HCI_IDX_EVENT_PARAMETER_);

	bt_hci_cmd_le_transmitter_test.parameter_tbl[0].value = TX_Frequency;
	bt_hci_cmd_le_transmitter_test.parameter_tbl[1].value = Length_Of_Packet;
	bt_hci_cmd_le_transmitter_test.parameter_tbl[2].value = Packet_Payload_Type ;

	printf("run for even tx faild...\n");

	//add for even tx failed
	bt_hci_write_cmd2socket (dut1_fd, &bt_hci_cmd_le_transmitter_test);
    do{
        socket_msg_get(dut1_fd,&len,buf);
    }while(len <=0);
	//print_charray(len,buf);
	bt_hci_event_parsing(buf[_BT_HCI_IDX_EVENT_CODE_],
						buf[_BT_HCI_IDX_EVENT_LENGTH_],
						buf+_BT_HCI_IDX_EVENT_PARAMETER_);

}


void  TI_Dtm_Rx(u8 rxdut ,u8 channel){

	s32 dut1_fd=0;
	u8	buf[SOCKET_BUF_SIZE]; //william : buf size should be  according socket_get_msg
	u16 len;

	printf("dut(%d) channel=%d \n" , rxdut,channel);

	dut1_fd=dut_socket_init(rxdut);
	printf("************* Testing with %d(rx) *************\n" ,dut1_fd);
	bt_hci_cmd_le_receiver_test.parameter_tbl[0].value = &channel;
	bt_hci_write_cmd2socket(dut1_fd, &bt_hci_cmd_le_receiver_test);

    do{
        socket_msg_get(dut1_fd,&len,buf);
    }while(len <=0);
	//print_charray(len,buf);
	bt_hci_event_parsing(buf[_BT_HCI_IDX_EVENT_CODE_],
						buf[_BT_HCI_IDX_EVENT_LENGTH_],
						buf+_BT_HCI_IDX_EVENT_PARAMETER_);

	//*bug with TI ? when R->T->R(can't recv packet) ; may add another le_recv_test cmd

}

void TI_Dtm_End(u8 dut){

	s32 dut1_fd=0;
	u8 buf[SOCKET_BUF_SIZE]; //william : buf size should be  according socket_get_msg
	u16 len;

	dut1_fd=dut_socket_init(dut);

	bt_hci_write_cmd2socket(dut1_fd, &bt_hci_cmd_le_test_end);
    do{
        socket_msg_get(dut1_fd,&len,buf);
    }while(len <=0);
	//print_charray(len,buf);
	bt_hci_event_parsing(buf[_BT_HCI_IDX_EVENT_CODE_],
						buf[_BT_HCI_IDX_EVENT_LENGTH_],
						buf+_BT_HCI_IDX_EVENT_PARAMETER_);

    printf ("\n#receive %d packets#\n\n" , 
            (buf[5+_BT_HCI_IDX_EVENT_PARAMETER_]<<8) + 
             buf[4+_BT_HCI_IDX_EVENT_PARAMETER_]
           );

    
}

void  TI_DTM(u8 rxdut ,u8 txdut ,u8 rfch ,u16 tx_pkt_cnt){

	Ret_param retp;
	int pkt_cnt;
	char printf_buff[50][100];

	printf("DTM with Rx(%d) Tx(%d) \n" ,rxdut,txdut);

	pkt_cnt=Dtm(rxdut, txdut , rfch, tx_pkt_cnt , &retp);

	if(0==pkt_cnt){
		sprintf(printf_buff[0] ,"DTM (%d) Fail\n",rfch);
	}
	else{
		sprintf(printf_buff[0] ,"DTM (%d) RX/TX = %d/%d\n",rfch , pkt_cnt , tx_pkt_cnt );
	}

	printf("\n");
	printf("%s" , printf_buff[0]);

	printf("Exit DTM\n");
}


void  TI_Auto_DTM(u8 rxdut ,u8 txdut ,u16 tx_pkt_cnt){

	Ret_param retp;
	int pkt_cnt;
	int cnt=0;
	int channel_cnt=0;
	char printf_buff[50][100];

	for ( ; channel_cnt < 40 ; channel_cnt++)
	{
		pkt_cnt=AutoDtm(rxdut,txdut,channel_cnt, tx_pkt_cnt,&retp);

		if(0==pkt_cnt)
		{
			sprintf(printf_buff[channel_cnt] ,"Auto TxRx (%d) Fail\n",channel_cnt);
//			PRINTF_FX("Auto TxRx (%d) Fail\n" , ch2txrx);
		}
		else
		{
			sprintf(printf_buff[channel_cnt] ,"Auto TxRx (%d) RX/TX = %d/%d\n",channel_cnt , pkt_cnt ,tx_pkt_cnt);
//			PRINTF_FX("Auto TxRx (%d),RX/TX = %d/%d!\n",ch2txrx , ret, pkt2tx);
		}
	}

    
	printf("\nAuto testing with Rx(%d) Tx(%d) \n" ,rxdut,txdut);

	for ( ; cnt < 40 ; cnt++ )
	{
		printf("%s" , printf_buff[cnt]);
	}

	printf("Exit Auto testing\n");
}


u8 ssv_transmit_test(u8 tx_dut ,u8 channel ,u16 pkt_cnt, u8 pkt_len , u8 pld_tp){
	u8 buf[SOCKET_BUF_SIZE];
	u16 len;
	u8 ret;

//
	u8 TX_Frequency[1]		 = {channel};
	u8 Packet_Count[2]		 = {0,0};
	u8 Length_Of_Packet[1]	 = {pkt_len};

	/*
# 0 - PRBS 9
# 1 - FOFO		: 11110000
# 2 - ZOZO		: 10101010
# 3 - PRBS 15
# 4 - All Ones
# 5 - All Zeros
# 6 - OFOF		:00001111
# 7 - OZOZ		:01010101
	*/
	u8 Packet_Payload_Type[1]		 = {pld_tp};

	s32 dut_fd=0;

	printf("\ndut %d channel=%d\n\n" , tx_dut ,channel);

	dut_fd=dut_socket_init(tx_dut);

	Packet_Count[0] = (pkt_cnt & 0x000000ff) >> 0;
	Packet_Count[1] = (pkt_cnt & 0x0000ff00) >> 8;

	bt_hci_cmd_ssv_le_transmitter_test.parameter_tbl[0].value =TX_Frequency;
	bt_hci_cmd_ssv_le_transmitter_test.parameter_tbl[1].value =Packet_Count;
	bt_hci_cmd_ssv_le_transmitter_test.parameter_tbl[2].value =Length_Of_Packet;
	bt_hci_cmd_ssv_le_transmitter_test.parameter_tbl[3].value =Packet_Payload_Type;

	HCI_WRITECMD_AND_GETEVENT_PARSING(bt_hci_cmd_ssv_le_transmitter_test);

	return 0;
}


u8 transmit_test(u8 tx_dut	,u8 channel , s8 pkt_len , s8 pld_tp){
	u8 buf[SOCKET_BUF_SIZE];
	u16 len;
	u8 ret;

//
	u8 TX_Frequency[1]		 = {channel};
	u8 Length_Of_Packet[1]	 = {pkt_len};
	/*
# 0 - PRBS 9
# 1 - FOFO		: 11110000
# 2 - ZOZO		: 10101010
# 3 - PRBS 15
# 4 - All Ones
# 5 - All Zeros
# 6 - OFOF		:00001111
# 7 - OZOZ		:01010101
	*/
	u8 Packet_Payload_Type[1]		 = {pld_tp};

	s32 dut_fd=0;

	printf("\ndut %d channel %d\n\n" , tx_dut ,channel);

	dut_fd=dut_socket_init(tx_dut);

	bt_hci_cmd_le_transmitter_test.parameter_tbl[0].value =TX_Frequency;
	bt_hci_cmd_le_transmitter_test.parameter_tbl[1].value =Length_Of_Packet;
	bt_hci_cmd_le_transmitter_test.parameter_tbl[2].value =Packet_Payload_Type;

	HCI_WRITECMD_AND_GETEVENT_PARSING(bt_hci_cmd_le_transmitter_test);

	return 0;

}

u8 receive_test(u8 rxdut ,u8 channel){

	u8 buf[SOCKET_BUF_SIZE];
	u16 len;
	u8 ret;

	s32 dut_fd=0;

	printf("\ndut %d channel %d \n\n" , rxdut,channel);

	dut_fd=dut_socket_init(rxdut);
	bt_hci_cmd_le_receiver_test.parameter_tbl[0].value = &channel;

	HCI_WRITECMD_AND_GETEVENT_PARSING(bt_hci_cmd_le_receiver_test);
	return 0;

}

u8 test_end(u8 dut){
	u8 buf[SOCKET_BUF_SIZE];
	u16 len;
	u8 ret;

	s32 dut_fd=0;

	printf("\ndut %d end \n\n" , dut);

	dut_fd=dut_socket_init(dut);
	HCI_WRITECMD_AND_GETEVENT_PARSING(bt_hci_cmd_le_test_end);

    printf ("#receive %d packets#\n" , 
            (buf[5+_BT_HCI_IDX_EVENT_PARAMETER_]<<8) + 
             buf[4+_BT_HCI_IDX_EVENT_PARAMETER_]
           );

	return 0;

}



u16 ssv_auto_txrx_ti_ssv(u8 ti_dut,u8 ssv_dut,u8 channel,u16 pkt_cnt,u8 pkt_len,u8 pld_type){

	s32 rx_fd=0;
	u8  buf[SOCKET_BUF_SIZE];
	u16 len;

	rx_fd=dut_socket_init(ssv_dut);

	// # T= TI , R = SSV
	receive_test (ssv_dut, channel);
	TI_Dtm_Tx(ti_dut , channel , pkt_cnt , pkt_len , pld_type);
	test_end (ti_dut);

	// # inorder to return the packet num
	bt_hci_write_cmd2socket(rx_fd, &bt_hci_cmd_le_test_end);
    do{
        socket_msg_get(rx_fd,&len,buf);
    }while(len <=0);
	//print_charray(len,buf);
	bt_hci_event_parsing(buf[_BT_HCI_IDX_EVENT_CODE_],
						buf[_BT_HCI_IDX_EVENT_LENGTH_],
						buf+_BT_HCI_IDX_EVENT_PARAMETER_);

	return (buf[5+_BT_HCI_IDX_EVENT_PARAMETER_]<<8) + buf[4+_BT_HCI_IDX_EVENT_PARAMETER_];

}

u16 ssv_auto_txrx_ssv_ti(u8 ti_dut,u8 ssv_dut,u8 channel,u16 pkt_cnt,u8 pkt_len,u8 pld_type){

	s32 rx_fd=0;
	u8 buf[SOCKET_BUF_SIZE];
	u16 len;

	rx_fd=dut_socket_init(ti_dut);

	// # T= SSV , R = TI
	receive_test (ti_dut, channel);
	ssv_transmit_test(ssv_dut , channel ,pkt_cnt ,pkt_len,pld_type);
	Dtm_Tx_Sleep_time(pkt_cnt);
	test_end (ssv_dut);

	// # inorder to return the packet num
	bt_hci_write_cmd2socket(rx_fd, &bt_hci_cmd_le_test_end);
    do{
        socket_msg_get(rx_fd,&len,buf);
    }while(len <=0);
	//print_charray(len,buf);
	bt_hci_event_parsing(buf[_BT_HCI_IDX_EVENT_CODE_],
						buf[_BT_HCI_IDX_EVENT_LENGTH_],
						buf+_BT_HCI_IDX_EVENT_PARAMETER_);

	return (buf[5+_BT_HCI_IDX_EVENT_PARAMETER_]<<8) + buf[4+_BT_HCI_IDX_EVENT_PARAMETER_];

}


void set_adv_interval(u16 interval){
    u16 intv = interval / 0.625 ;
    g_pattern_param.adv_param.Advertising_Interval_Min[0] =  intv & 0x00ff;
    g_pattern_param.adv_param.Advertising_Interval_Min[1] = (intv & 0xff00) >> 8;

    g_pattern_param.adv_param.Advertising_Interval_Max[0] =  intv & 0x00ff;
    g_pattern_param.adv_param.Advertising_Interval_Max[1] = (intv & 0xff00) >> 8;
}

void set_adv_policy(u16 policy){

	g_pattern_param.adv_param.Advertising_Filter_Policy[0] =	policy;
}

void set_scan_interval(u16 interval){

    u16 intv = interval / 0.625 ;
    g_pattern_param.scn_param.LE_Scan_Interval[0] =  intv & 0x00ff;
    g_pattern_param.scn_param.LE_Scan_Interval[1] = (intv & 0xff00) >> 8;

}

void set_scan_windows(u16 window){

    u16 win  = window   / 0.625 ;
    g_pattern_param.scn_param.LE_Scan_Window[0] =  win & 0x00ff;
    g_pattern_param.scn_param.LE_Scan_Window[1] = (win & 0xff00) >> 8;
}

void set_scan_policy(u16 policy){

	g_pattern_param.scn_param.Scanning_Filter_Policy[0] =	policy;
}

void set_conn_interval(u16 interval){

    u16 intv = interval / 1.25 ;
    g_pattern_param.create_conn_param.Conn_Interval_Min[0]      =    intv & 0x00ff;
    g_pattern_param.create_conn_param.Conn_Interval_Min[1]      =   (intv & 0xff00) >> 8;    
    g_pattern_param.create_conn_param.Conn_Interval_Max[0]      =    intv & 0x00ff;
    g_pattern_param.create_conn_param.Conn_Interval_Max[1]      =   (intv & 0xff00) >> 8;
}

void set_conn_slave_latency(u16 latency){
    g_pattern_param.create_conn_param.Conn_Latency[0]           =    latency & 0x00ff;
    g_pattern_param.create_conn_param.Conn_Latency[1]           =   (latency & 0xff00) >> 8;    
}

void set_conn_super_timeout(u16 timeout){

    u16 to = timeout / 1.25 ;
    g_pattern_param.create_conn_param.Supervision_Timeout[0]    =    to & 0x00ff;
    g_pattern_param.create_conn_param.Supervision_Timeout[1]    =   (to & 0xff00) >> 8;    
}

#define RX_SUCCESS_RATE 0.99
#define TRX_PKT_CNT     1000
void ssv_dtm_pattern(u8 ti_dut ,u8 ssv_dut ,u16 pkt_cnt ,u8 pkt_len ,u8 pld_type){

	u8   log_cnt=0;
	u8	 channel=0;
    u8   chan_max =40 ;
	u16  rx_pkt_cnt=0;
    u16  rx_pkt_cnt_exp = TRX_PKT_CNT * RX_SUCCESS_RATE;
    
	char   printf_buff1[50][100];
	char   printf_buff2[50][100];

    u8   loop_pkt_len  = 0;
    u8   loop_pld_type = 0;
    
    while(loop_pld_type < 3){        

        printf("\npld_type [%d]\n" , loop_pld_type);

        rx_pkt_cnt=ssv_auto_txrx_ssv_ti(ti_dut,ssv_dut,channel,TRX_PKT_CNT,37,loop_pld_type);

        if( rx_pkt_cnt_exp >= rx_pkt_cnt)
        {
            LOG_INFO("SSV->TI type:%d ; less than %d[%d]\n",loop_pld_type , rx_pkt_cnt_exp , rx_pkt_cnt);
            return;
        }

        loop_pld_type ++ ;
    }

    LOG_INFO("pld_type pattern PASS\n");

    while(loop_pkt_len < 38){

        printf("\npkt_len [%d]\n" , loop_pkt_len);
        
        rx_pkt_cnt=ssv_auto_txrx_ssv_ti(ti_dut,ssv_dut,channel,TRX_PKT_CNT,loop_pkt_len,0);
        
        if( rx_pkt_cnt_exp >= rx_pkt_cnt)
        {
            LOG_INFO("SSV->pkt len:%d ; less than %d[%d]\n", loop_pkt_len, rx_pkt_cnt_exp, rx_pkt_cnt);
            return;
        }

        loop_pkt_len ++;
    }

    LOG_INFO("pkt_len pattern PASS\n");
    
	for ( channel = 0; channel < chan_max ; channel ++)
	{
		rx_pkt_cnt=ssv_auto_txrx_ti_ssv(ti_dut , ssv_dut,channel , TRX_PKT_CNT , 37 , 0);

        sprintf(printf_buff1[channel] ,"TI->SSV ch:%d RX/TX = %d/%d\n",channel , rx_pkt_cnt , TRX_PKT_CNT);

        if( rx_pkt_cnt_exp >= rx_pkt_cnt)
        {
            LOG_INFO("RX->ch:%d ; less than %d[%d]\n", channel , rx_pkt_cnt_exp, rx_pkt_cnt);
            return;
        }

	}

	for ( channel = 0; channel < chan_max ; channel ++)
	{
		rx_pkt_cnt=ssv_auto_txrx_ssv_ti(ti_dut , ssv_dut,channel , TRX_PKT_CNT , 37 , 0);

        sprintf(printf_buff2[channel] ,"SSV->TI ch:%d RX/TX = %d/%d\n",channel , rx_pkt_cnt , TRX_PKT_CNT);

        if( rx_pkt_cnt_exp >= rx_pkt_cnt)
        {
            LOG_INFO("TX->ch:%d ; less than %d[%d]\n", channel , rx_pkt_cnt_exp, rx_pkt_cnt);
            return;
        }
	}

    LOG_INFO("ch pattern PASS\n");

	LOG_INFO("##############################\n");
    
	for( log_cnt = 0 ; log_cnt < chan_max ; log_cnt ++)
	{
		LOG_INFO("%s" , printf_buff1[log_cnt]);
	}

	LOG_INFO("##############################\n");

	for( log_cnt = 0 ; log_cnt < chan_max ; log_cnt ++)
	{
		LOG_INFO("%s" , printf_buff2[log_cnt]);
	}

	LOG_INFO("##############################\n");

    LOG_INFO("dtm all pattern PASS\n");

}


void ssv_auto_dtm(u8 ti_dut ,u8 ssv_dut ,u16 pkt_cnt ,u8 pkt_len ,u8 pld_type){

	int  log_cnt=0;
	u8	 channel=0;
	u8	 chan_max =40;
	u16  rx_pkt_cnt=0;
	char printf_buff1[50][100];
	char printf_buff2[50][100];

	printf("ssv Auto testing with %d %d \n" ,ti_dut,ssv_dut);

	for ( channel = 0; channel < chan_max ; channel ++)
	{
		rx_pkt_cnt=ssv_auto_txrx_ti_ssv(ti_dut,ssv_dut,channel,pkt_cnt,pkt_len,pld_type);

		if(0==rx_pkt_cnt)
		{
			sprintf(printf_buff1[channel] ,"TI->SSV ch:%d Fail\n",channel);
		}
		else
		{
			sprintf(printf_buff1[channel] ,"TI->SSV ch:%d RX/TX = %d/%d\n",channel , rx_pkt_cnt,pkt_cnt);
		}
	}

	for ( channel = 0; channel < chan_max ; channel ++)
	{
		rx_pkt_cnt=ssv_auto_txrx_ssv_ti(ti_dut,ssv_dut,channel,pkt_cnt,pkt_len,pld_type);

		if(0==rx_pkt_cnt)
		{
			sprintf(printf_buff2[channel] ,"SSV->TI ch:%d Fail\n",channel);
		}
		else
		{
			sprintf(printf_buff2[channel] ,"SSV->TI ch:%d RX/TX = %d/%d\n",channel , rx_pkt_cnt,pkt_cnt);
		}
	}

	LOG_INFO("##############################\n");
    
	for( log_cnt = 0 ; log_cnt < chan_max ; log_cnt ++)
	{
		LOG_INFO("%s" , printf_buff1[log_cnt]);
	}

	LOG_INFO("##############################\n");

	for( log_cnt = 0 ; log_cnt < chan_max ; log_cnt ++)
	{
		LOG_INFO("%s" , printf_buff2[log_cnt]);
	}

	LOG_INFO("##############################\n");

	printf("Exit SSV Auto testing\n");
}




void COMM_Ltk_Req_Rep_Config(u8 dut_fd ,Pattern_param * param , u8 * conn_handle)
{
	param->ltk_req_rep_parameter.Connection_Handle[0]=conn_handle[0];
	param->ltk_req_rep_parameter.Connection_Handle[1]=conn_handle[1];

	memcpy(param->ltk_req_rep_parameter.Long_Term_Key,			enc_ltk,		16);

	bt_hci_cmd_le_long_term_key_request_reply.parameter_tbl[0].value = param->ltk_req_rep_parameter.Connection_Handle;
	bt_hci_cmd_le_long_term_key_request_reply.parameter_tbl[1].value = param->ltk_req_rep_parameter.Long_Term_Key;
}

void COMM_Ltk_Req_Negative_Rep_Config(u8 dut_fd ,Pattern_param * param , u8 * conn_handle)
{
	param->ltk_req_negative_rep_parameter.Connection_Handle[0]=conn_handle[0];
	param->ltk_req_negative_rep_parameter.Connection_Handle[1]=conn_handle[1];

	bt_hci_cmd_le_long_term_key_request_negative_reply.parameter_tbl[0].value = param->ltk_req_negative_rep_parameter.Connection_Handle;
}


void COMM_Start_Encryption_Config(u8 dut_fd ,Pattern_param * param , u8 * conn_handle)
{
	param->encryption_parameter.Connection_Handle[0]=conn_handle[0];
	param->encryption_parameter.Connection_Handle[1]=conn_handle[1];

	memcpy(param->encryption_parameter.Random_Number ,		    enc_rand ,	8);
	memcpy(param->encryption_parameter.Encrypted_Diversifier ,	enc_ediv ,	2);
	memcpy(param->encryption_parameter.Long_Term_Key,			enc_ltk  ,	16);

	bt_hci_cmd_le_start_encryption .parameter_tbl[0].value = param->encryption_parameter.Connection_Handle;
	bt_hci_cmd_le_start_encryption .parameter_tbl[1].value = param->encryption_parameter.Random_Number;
	bt_hci_cmd_le_start_encryption .parameter_tbl[2].value = param->encryption_parameter.Encrypted_Diversifier ;
	bt_hci_cmd_le_start_encryption .parameter_tbl[3].value = param->encryption_parameter.Long_Term_Key;
}

void COMM_Static_Random_Device_Address_Set_Config(u8* addr)
{
	bt_hci_cmd_le_set_random_address.parameter_tbl[0].value = addr;
}

void COMM_Random_Device_Address_Set_Config (u8 DUT ,Pattern_param * param)
{
	u8 cnt=0;
	//should get a random addr for SEC
	param->random_address[0]=0xb6;
	param->random_address[1]=0x54;
	param->random_address[2]=0x10;
	param->random_address[3]=0x40;
	param->random_address[4]=0x21;
	param->random_address[5]=0x61;

	for( ; cnt < 15 ; cnt++)
		param->ir[cnt] = param->plaintext[cnt]=cnt;

	param->ir[cnt] = param->plaintext[cnt]=0x01;


	bt_hci_cmd_le_set_random_address.parameter_tbl[0].value = param->random_address;
	bt_hci_cmd_le_encrypt.parameter_tbl[0].value=param->ir;
	bt_hci_cmd_le_encrypt.parameter_tbl[1].value=param->plaintext;


}


void COMM_Device_Address_Set_Config (u8 DUT ,Pattern_param * param)
{
	//should get a random addr for SEC
	param->random_address[0]=0x00;
	param->random_address[1]=0x01;
	param->random_address[2]=0x02;
	param->random_address[3]=0x03;
	param->random_address[4]=0x04;
	param->random_address[5]=0b11000011;

	bt_hci_cmd_le_set_random_address.parameter_tbl[0].value = param->random_address;
}

void COMM_Ch_Map_Set_Config (u8 DUT , Pattern_param * param , u64 ch_map)
{
	param->LE_Channel_Map[0]= (ch_map & 0x00000000FF)		;//ch 0~ 7
	param->LE_Channel_Map[1]= (ch_map & 0x000000FF00) >> 8	;//ch 8~ 15
	param->LE_Channel_Map[2]= (ch_map & 0x0000FF0000) >> 16 ;//ch 16~23
	param->LE_Channel_Map[3]= (ch_map & 0x00FF000000) >> 24 ;//ch 24~31
	param->LE_Channel_Map[4]= (ch_map & 0x1F00000000) >> 32 ;//ch 36	

	bt_hci_cmd_le_set_host_channel_classification.parameter_tbl[0].value = param->LE_Channel_Map;
}


void COMM_Ch_Map_Read_Config (Pattern_param * param , u8 *conn_handle)
{
	param->LE_Connection_Handle[0]= conn_handle[0]  ;
	param->LE_Connection_Handle[1]= conn_handle[1]  ;

	bt_hci_cmd_le_read_channel_map.parameter_tbl[0].value = param->LE_Connection_Handle;
}


void COMM_Conn_Update_Set_Config (u8 DUT , Pattern_param * param , u8 * conn_handle)
{

	param->conn_update_param.Connection_Handle[0]		= conn_handle[0];
	param->conn_update_param.Connection_Handle[1]		= conn_handle[1];

	param->conn_update_param.Conn_Interval_Min[0]		=24;//HCI_CMD_PARAM_CONN_INT_MIN & 0x00ff;
	param->conn_update_param.Conn_Interval_Min[1]		=0;//(HCI_CMD_PARAM_CONN_INT_MIN & 0xff00)	>> 8;
	param->conn_update_param.Conn_Interval_Max[0]		=40;
	param->conn_update_param.Conn_Interval_Max[1]		=0;
	param->conn_update_param.Conn_Latency[0]		    =HCI_CMD_PARAM_CONN_LATENCY_MIN;//HCI_CMD_PARAM_CONN_LATENCY_MAX & 0x00ff;
	param->conn_update_param.Conn_Latency[1]		    =HCI_CMD_PARAM_CONN_LATENCY_MIN;//(HCI_CMD_PARAM_CONN_LATENCY_MAX & 0xff00)  >> 8;
	//The Supervision_Timeout in milliseconds shall be larger than the Conn_Interval_Max in milliseconds.
	//superviision TO > (1+connSlaveLatency)*Conninterval
	param->conn_update_param.Supervision_Timeout[0] 	=0x64; //=0xD0;
	param->conn_update_param.Supervision_Timeout[1] 	=0x00 ; //=0x07;


	bt_hci_cmd_le_connection_update.parameter_tbl[0].value = param->conn_update_param.Connection_Handle;
	bt_hci_cmd_le_connection_update.parameter_tbl[1].value = param->conn_update_param.Conn_Interval_Min;
	bt_hci_cmd_le_connection_update.parameter_tbl[2].value = param->conn_update_param.Conn_Interval_Max;
	bt_hci_cmd_le_connection_update.parameter_tbl[3].value = param->conn_update_param.Conn_Latency;
	bt_hci_cmd_le_connection_update.parameter_tbl[4].value = param->conn_update_param.Supervision_Timeout;
	bt_hci_cmd_le_connection_update.parameter_tbl[5].value = param->conn_update_param.Minimum_CE_Length;
	bt_hci_cmd_le_connection_update.parameter_tbl[6].value = param->conn_update_param.Maximum_CE_Length;

}

verdict COMM_Send_ACL_Data_Without_event (u8 dut_fd , u8 * conn_handle , u8 pb ,u8 bc ,u16 data_len,u8* data)
{
	u8 ret;
	bt_hci_acl_data raw_data;
	//the conn_handle should be MSB->LSB
	//ex: 01 04 =>04<<8 | 01 = 401
	raw_data.conn_handle= conn_handle[0] |( conn_handle[1] << 8);
	raw_data.pb = pb & 0b00000011;
	raw_data.bc = bc & 0b00000011;
	raw_data.length =data_len;
	raw_data.data =data;

	//printf("%3x %d %d %ld\n" , row_data.conn_handle, row_data.pb ,row_data.bc ,row_data.length);
	HCI_WRITEDATA(raw_data);
	return PASS;
}


verdict COMM_Send_ACL_Data (u8 dut_fd , u8 * conn_handle , u8 pb ,u8 bc ,u16 data_len,u8* data)
{
	u8 buf[SOCKET_BUF_SIZE];
	u16 len;
	u8 ret;
	bt_hci_acl_data raw_data;
	//the conn_handle should be MSB->LSB
	//ex: 01 04 =>04<<8 | 01 = 401
	raw_data.conn_handle= conn_handle[0] |( conn_handle[1] << 8);
	raw_data.pb = pb & 0b00000011;
	raw_data.bc = bc & 0b00000011;
	raw_data.length =data_len;
	raw_data.data =data;

	//printf("%3x %d %d %ld\n" , raw_data.conn_handle, raw_data.pb ,raw_data.bc ,raw_data.length);
	HCI_WRITEDATA_AND_NUMPACKETS_PARSING(raw_data);
	return PASS;
}

int COMM_Scan_Response_Data_Set_Config(u8 dut_fd , u16 len, Pattern_param * param)
{   
    memset(param->scn_rsp_param.Scan_Response_Data , 0 , sizeof(param->scn_rsp_param.Scan_Response_Data));
	param->scn_rsp_param.Scan_Response_Data_Length[0] = len;
	param->scn_rsp_param.Scan_Response_Data[0] = 0x44;
	param->scn_rsp_param.Scan_Response_Data[1] = 0x55;
	param->scn_rsp_param.Scan_Response_Data[2] = 0x54;

	bt_hci_cmd_le_set_scan_response_data.parameter_tbl[0].value = param->scn_rsp_param.Scan_Response_Data_Length;
	bt_hci_cmd_le_set_scan_response_data.parameter_tbl[1].value = param->scn_rsp_param.Scan_Response_Data;

    return 0;
}

verdict COMM_Scan_Response_Data_Set(u8 dut_fd ,Pattern_param param)
{
	u8 buf[SOCKET_BUF_SIZE];
	u16 len;
	u8 ret;

	HCI_WRITECMD_AND_GETEVENT_PARSING(bt_hci_cmd_le_set_scan_response_data);

	return ret;
}

int COMM_Random_Device_Address_Set (u8 dut_fd ,Pattern_param *param)
{
	u8 buf[SOCKET_BUF_SIZE];
	u16 len;
	u8 status;
	u8 prand[8];
	u8 irk[16];
	u8 encryptdata[16];

	u8 ir[] = {0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 0x08, 0x09, 0x0a, 0x0b, 0x0c, 0x0d, 0x0e, 0x0f,0x10};
	u8 irk_pad[16] = {0};
	irk_pad[0] = 1;

    PRINT_TIME;

	bt_hci_write_cmd2socket(dut_fd, &bt_hci_cmd_le_rand);
    do{ 
        socket_msg_get(dut_fd,&len,buf);
    }while(len <=0);
	status=buf[_BT_HCI_W_EVENT_HEADER_+_BT_HCI_IDX_EVENT_PARAMETER_];
	//print_charray(len,buf);
	bt_hci_event_parsing(buf[_BT_HCI_IDX_EVENT_CODE_],
						buf[_BT_HCI_IDX_EVENT_LENGTH_],
						buf+_BT_HCI_IDX_EVENT_PARAMETER_);

	printf("Status =%d\n" , status);
	if( 0 != status)
	{
		printf("%s FAILED\n" , __FUNCTION__);
		return ERROR;
	}

	memcpy(prand, buf+7, 3);
	//set bit 23 to 1, bit 24 to 0.
	prand[2] |= 0x40;
	prand[2] &= 0x7f;
	print_charray(3,prand);

	//generate IRK
	bt_hci_cmd_le_encrypt.parameter_tbl[0].value = ir;
	bt_hci_cmd_le_encrypt.parameter_tbl[1].value = irk_pad;
	bt_hci_write_cmd2socket (dut_fd, &bt_hci_cmd_le_encrypt);
    do{
        socket_msg_get(dut_fd,&len,buf);
    }while(len <=0);
	print_charray(len,buf);
	status=buf[_BT_HCI_W_EVENT_HEADER_+_BT_HCI_IDX_EVENT_PARAMETER_];
	bt_hci_event_parsing(buf[_BT_HCI_IDX_EVENT_CODE_],
						buf[_BT_HCI_IDX_EVENT_LENGTH_],
						buf+_BT_HCI_IDX_EVENT_PARAMETER_);

	printf("Status =%d\n" , status);
	if( 0 != status)
	{
		printf("%s FAILED\n" , __FUNCTION__);
		return ERROR;
	}
	//irk
	memcpy(encryptdata, buf+7, 16);
	print_charray(16,encryptdata);

	memcpy(irk,encryptdata,16);   //save irk
	memset(encryptdata,0,sizeof(encryptdata));
	memcpy(encryptdata,prand,3);	//use prand as encryptdata to gen hash value

	//generate hash value
	bt_hci_cmd_le_encrypt.parameter_tbl[0].value = irk;
	bt_hci_cmd_le_encrypt.parameter_tbl[1].value = encryptdata;
	bt_hci_write_cmd2socket (dut_fd, &bt_hci_cmd_le_encrypt);
    do{ 
        socket_msg_get(dut_fd,&len,buf);
    }while(len <=0);
	print_charray(len,buf);
	status=buf[_BT_HCI_W_EVENT_HEADER_+_BT_HCI_IDX_EVENT_PARAMETER_];
	bt_hci_event_parsing(buf[_BT_HCI_IDX_EVENT_CODE_],
					buf[_BT_HCI_IDX_EVENT_LENGTH_],
					buf+_BT_HCI_IDX_EVENT_PARAMETER_);

	printf("Status =%d\n" , status);
	if( 0 != status)
	{
		printf("%s FAILED\n" , __FUNCTION__);
		return ERROR;
	}
	//hash value
	printf("hash value:\n");
	memcpy(encryptdata, buf+7, 16);
	print_charray(3,encryptdata);

	//use the first 3 bytes of hash value as the lower 3 bytes of address
	//use the higher 3 bytes prand as the higher 3 bytes of address
	memcpy(param->random_address+3,prand,3);// higher 24 bit is prand
	memcpy(param->random_address,encryptdata,3);
	/*	  param->random_address[0] = prand[2];
	param->random_address[1] = prand[1];
	param->random_address[2] = prand[0];
	param->random_address[3] = encryptdata[2];
	param->random_address[4] = encryptdata[1];
	param->random_address[5] = encryptdata[0];
	*/
	printf("random address:\n");
	print_charray(6,param->random_address);
	bt_hci_cmd_le_set_random_address.parameter_tbl[0].value = param->random_address;
#if 0
	bt_hci_cmd_le_encrypt.parameter_tbl[0].value=encryptdata;
	bt_hci_cmd_le_encrypt.parameter_tbl[1].value=prand_shift ;
#endif
#if 0
	bt_hci_write_cmd2socket(dut_fd, &bt_hci_cmd_le_set_random_address);

    do{
        ret=socket_msg_get(dut_fd,&len,buf);
    }while(len <=0);
	status=buf[_BT_HCI_W_EVENT_HEADER_+_BT_HCI_IDX_EVENT_PARAMETER_];
	//print_charray(len,buf);
	bt_hci_event_parsing(buf[_BT_HCI_IDX_EVENT_CODE_],
						buf[_BT_HCI_IDX_EVENT_LENGTH_],
						buf+_BT_HCI_IDX_EVENT_PARAMETER_);

	printf("Status =%d\n" , status);
	if( 0 != status)
	{
		printf("%s FAILED\n" , __FUNCTION__);
		return ERROR;
	}
	bt_hci_write_cmd2socket (dut_fd, &bt_hci_cmd_read_bd_addr);
    do{
        ret=socket_msg_get(dut_fd,&len,buf);
    }while(len <=0);
	print_charray(len,buf);
	status=buf[_BT_HCI_W_EVENT_HEADER_+_BT_HCI_IDX_EVENT_PARAMETER_];
	bt_hci_event_parsing(buf[_BT_HCI_IDX_EVENT_CODE_],
						buf[_BT_HCI_IDX_EVENT_LENGTH_],
						buf+_BT_HCI_IDX_EVENT_PARAMETER_);

	printf("Status =%d\n" , status);
	if( 0 != status)
	{
		printf("%s FAILED\n" , __FUNCTION__);
		return ERROR;
	}
#endif
	return 0;
}

int TI_sleep_mode_configurations (u8 dut_fd)
{
	u8 buf[SOCKET_BUF_SIZE];
	u16 len;
	u8 status;

    u8 reserved[1]              = {0}; 
    u8 sleep_enable[1]          = {0};
    u8 sleep_mode[1]            = {0};
    u8 output_io_select[1]      = {0};
    u8 output_pull_enable[1]    = {0};
    u8 input_pull_enable[1]     = {0};
    u8 input_io_select[1]       = {0};
    u8 reserved2[2]             = {0};
/*
    https://e2e.ti.com/support/wireless_connectivity/bluetooth_cc256x/f/660/t/134855
*/
#define SLEEP_MODE_HCILL       0
#define SLEEP_MODE_DONT_CHANGE 0xff

    reserved[0]                 =  1    ;
    sleep_enable[0]             =  1    ;    
    sleep_mode[0]               =  SLEEP_MODE_HCILL    ;
    output_io_select[0]         =  0xff ;
    output_pull_enable[0]       =  0xff ;
    input_pull_enable[0]        =  0xff ;
    input_io_select[0]          =  0xff ;    
    reserved2[0]                =  100  ;
    reserved2[1]                =  0    ;

    bt_hci_cmd_ti_sleep_mode_configurations.parameter_tbl[0].value = reserved;
    bt_hci_cmd_ti_sleep_mode_configurations.parameter_tbl[1].value = sleep_enable;
    bt_hci_cmd_ti_sleep_mode_configurations.parameter_tbl[2].value = sleep_mode;
    bt_hci_cmd_ti_sleep_mode_configurations.parameter_tbl[3].value = output_io_select;
    bt_hci_cmd_ti_sleep_mode_configurations.parameter_tbl[4].value = output_pull_enable;
    bt_hci_cmd_ti_sleep_mode_configurations.parameter_tbl[5].value = input_pull_enable;
    bt_hci_cmd_ti_sleep_mode_configurations.parameter_tbl[6].value = input_io_select;
    bt_hci_cmd_ti_sleep_mode_configurations.parameter_tbl[7].value = reserved2;
    
    PRINT_TIME;

	bt_hci_write_cmd2socket (dut_fd, &bt_hci_cmd_ti_sleep_mode_configurations);
    do{
        socket_msg_get(dut_fd,&len,buf);
    }while(len <=0);

	print_charray(len,buf);
	status=buf[_BT_HCI_W_EVENT_HEADER_+_BT_HCI_IDX_EVENT_PARAMETER_];
	bt_hci_event_parsing(buf[_BT_HCI_IDX_EVENT_CODE_],
						buf[_BT_HCI_IDX_EVENT_LENGTH_],
						buf+_BT_HCI_IDX_EVENT_PARAMETER_);

	printf("Status =%d\n" , status);
	if( 0 != status)
	{
		printf("%s FAILED\n" , __FUNCTION__);
		return ERROR;
	}
	return 0;
}


int TI_Get_System_Status (u8 dut_fd)
{
	u8 buf[SOCKET_BUF_SIZE];
	u16 len;
	u8 status;

    PRINT_TIME;

	bt_hci_write_cmd2socket (dut_fd, &bt_hci_cmd_ti_get_system_status);
    do{
        socket_msg_get(dut_fd,&len,buf);
    }while(len <=0);
	print_charray(len,buf);
	status=buf[_BT_HCI_W_EVENT_HEADER_+_BT_HCI_IDX_EVENT_PARAMETER_];
	bt_hci_event_parsing(buf[_BT_HCI_IDX_EVENT_CODE_],
						buf[_BT_HCI_IDX_EVENT_LENGTH_],
						buf+_BT_HCI_IDX_EVENT_PARAMETER_);

	printf("Status =%d\n" , status);
	if( 0 != status)
	{
		printf("%s FAILED\n" , __FUNCTION__);
		return ERROR;
	}
	return 0;
}

//#define TI_BAUDRATE_115K 0x01c4e6
//#define TI_BAUDRATE_230k 0x038c6e
//#define TI_BAUDRATE_460k 0x071183
#define TI_BAUDRATE_920k 0x0E20E5


int TI_Update_Hci_Baudrate (u8 dut_fd)
{
	u8 buf[SOCKET_BUF_SIZE];
	u16 len;
	u8 status;

    u8 baudrate[4] = {0};

    baudrate[3] = ((TI_BAUDRATE_920k)& 0xff000000)>> 24 ;
    baudrate[2] = ((TI_BAUDRATE_920k)& 0x00ff0000)>> 16 ;
    baudrate[1] = ((TI_BAUDRATE_920k)& 0x0000ff00)>> 8 ;
    baudrate[0] = ((TI_BAUDRATE_920k)& 0x000000ff)>> 0 ;

    bt_hci_cmd_ti_update_uart_hci_baudrate.parameter_tbl[0].value = baudrate;

    PRINT_TIME;

	bt_hci_write_cmd2socket (dut_fd, &bt_hci_cmd_ti_update_uart_hci_baudrate);
    do{
        socket_msg_get(dut_fd,&len,buf);
    }while(len <=0);
	print_charray(len,buf);
	status=buf[_BT_HCI_W_EVENT_HEADER_+_BT_HCI_IDX_EVENT_PARAMETER_];
	bt_hci_event_parsing(buf[_BT_HCI_IDX_EVENT_CODE_],
						buf[_BT_HCI_IDX_EVENT_LENGTH_],
						buf+_BT_HCI_IDX_EVENT_PARAMETER_);

	printf("Status =%d\n" , status);
	if( 0 != status)
	{
		printf("%s FAILED\n" , __FUNCTION__);
		return ERROR;
	}
	return 0;
}

s8 pwr_lv_tbl [16]={
    -50 , 
     12 , //8 
    -23 , //-24
    -23 ,
    -23 ,
    -23 ,
    -23 ,
    -23 ,
    -23 ,
    -18 , //-18.5
    -13 , //-14
    -8  , //-9
    -3  , //-4
     2  , //0
     7  , //2 //2
     12 , //8
};

int TI_Output_power (u8 dut_fd , u8 power_lv)
{
	u8 buf[SOCKET_BUF_SIZE];
	u16 len;
	u8 status;

    u8 power_level[1] = {power_lv} ;
    bt_hci_cmd_ti_le_output_power.parameter_tbl[0].value = power_level;

    PRINT_TIME;

    printf("\nset power_lv to [%d] dbm\n" , pwr_lv_tbl[power_level[0]]);

	bt_hci_write_cmd2socket (dut_fd, &bt_hci_cmd_ti_le_output_power);
    do{
        socket_msg_get(dut_fd,&len,buf);
    }while(len <=0);
	print_charray(len,buf);
	status=buf[_BT_HCI_W_EVENT_HEADER_+_BT_HCI_IDX_EVENT_PARAMETER_];
	bt_hci_event_parsing(buf[_BT_HCI_IDX_EVENT_CODE_],
						buf[_BT_HCI_IDX_EVENT_LENGTH_],
						buf+_BT_HCI_IDX_EVENT_PARAMETER_);

	printf("Status =%d\n" , status);
	if( 0 != status)
	{
		printf("%s FAILED\n" , __FUNCTION__);
		return ERROR;
	}
	return 0;
}


int TI_Cont_Tx_Mode (u8 dut_fd , u8* pcmd_param)
{
	u8 buf[SOCKET_BUF_SIZE];
	u16 len;
	u8 status;
	u32 reserved = 0x00000000;

    bt_hci_cmd_ti_cont_tx_mode.parameter_tbl[0].value = &pcmd_param[TI_CONT_TX_MOD];
    bt_hci_cmd_ti_cont_tx_mode.parameter_tbl[1].value = &pcmd_param[TI_CONT_TX_TP];
    bt_hci_cmd_ti_cont_tx_mode.parameter_tbl[2].value = &pcmd_param[TI_CONT_TX_FREQ];
    bt_hci_cmd_ti_cont_tx_mode.parameter_tbl[3].value = &pcmd_param[TI_CONT_TX_PWR];
    bt_hci_cmd_ti_cont_tx_mode.parameter_tbl[4].value = &reserved;
    bt_hci_cmd_ti_cont_tx_mode.parameter_tbl[5].value = &reserved;

    PRINT_TIME;

	bt_hci_write_cmd2socket (dut_fd, &bt_hci_cmd_ti_cont_tx_mode);
    do{
        socket_msg_get(dut_fd,&len,buf);
    }while(len <=0);
	print_charray(len,buf);
	status=buf[_BT_HCI_W_EVENT_HEADER_+_BT_HCI_IDX_EVENT_PARAMETER_];
	bt_hci_event_parsing(buf[_BT_HCI_IDX_EVENT_CODE_],
						buf[_BT_HCI_IDX_EVENT_LENGTH_],
						buf+_BT_HCI_IDX_EVENT_PARAMETER_);

	printf("Status =%d\n" , status);
	if( 0 != status)
	{
		printf("%s FAILED\n" , __FUNCTION__);
		return ERROR;
	}
	return 0;
}


int TI_Write_BD_Addr (u8 dut_fd , u8* bd_addr)
{
	u8 buf[SOCKET_BUF_SIZE];
	u16 len;
	u8 status;

    bt_hci_cmd_ti_write_bd_addr.parameter_tbl[0].value = bd_addr;

    PRINT_TIME;

	bt_hci_write_cmd2socket (dut_fd, &bt_hci_cmd_ti_write_bd_addr);
    do{
        socket_msg_get(dut_fd,&len,buf);
    }while(len <=0);
	print_charray(len,buf);
	status=buf[_BT_HCI_W_EVENT_HEADER_+_BT_HCI_IDX_EVENT_PARAMETER_];
	bt_hci_event_parsing(buf[_BT_HCI_IDX_EVENT_CODE_],
						buf[_BT_HCI_IDX_EVENT_LENGTH_],
						buf+_BT_HCI_IDX_EVENT_PARAMETER_);

	printf("Status =%d\n" , status);
	if( 0 != status)
	{
		printf("%s FAILED\n" , __FUNCTION__);
		return ERROR;
	}
	return 0;
}


int TI_Pkt_Tx_Rx (u8 dut_fd , u16* pcmd_param)
{
	u8 buf[SOCKET_BUF_SIZE];
	u16 len;
	u8 status;
	u8 reserved = 0x00;
	u8 disable_whitening = 0x01;

    bt_hci_cmd_ti_pkt_tx_rx.parameter_tbl[0].value = &pcmd_param[TI_PKT_TXRX_FREQ_MODE];
    bt_hci_cmd_ti_pkt_tx_rx.parameter_tbl[1].value = &pcmd_param[TI_PKT_TXRX_TX_CH];
    bt_hci_cmd_ti_pkt_tx_rx.parameter_tbl[2].value = &pcmd_param[TI_PKT_TXRX_RX_CH];
    bt_hci_cmd_ti_pkt_tx_rx.parameter_tbl[3].value = &pcmd_param[TI_PKT_TXRX_PKT_TYPE];
    bt_hci_cmd_ti_pkt_tx_rx.parameter_tbl[4].value = &pcmd_param[TI_PKT_TXRX_PKT_PATTERN];
    bt_hci_cmd_ti_pkt_tx_rx.parameter_tbl[5].value = &reserved;
    bt_hci_cmd_ti_pkt_tx_rx.parameter_tbl[6].value = &pcmd_param[TI_PKT_TXRX_PKT_LEN];
    bt_hci_cmd_ti_pkt_tx_rx.parameter_tbl[7].value = &pcmd_param[TI_PKT_TXRX_PWR_LEVEL];
    bt_hci_cmd_ti_pkt_tx_rx.parameter_tbl[8].value = &disable_whitening;
    bt_hci_cmd_ti_pkt_tx_rx.parameter_tbl[9].value = &pcmd_param[TI_PKT_TXRX_PRBS9];

    PRINT_TIME;

	bt_hci_write_cmd2socket (dut_fd, &bt_hci_cmd_ti_pkt_tx_rx);
    do{
        socket_msg_get(dut_fd,&len,buf);
    }while(len <=0);
	print_charray(len,buf);
	status=buf[_BT_HCI_W_EVENT_HEADER_+_BT_HCI_IDX_EVENT_PARAMETER_];
	bt_hci_event_parsing(buf[_BT_HCI_IDX_EVENT_CODE_],
						buf[_BT_HCI_IDX_EVENT_LENGTH_],
						buf+_BT_HCI_IDX_EVENT_PARAMETER_);

	printf("Status =%d\n" , status);
	if( 0 != status)
	{
		printf("%s FAILED\n" , __FUNCTION__);
		return ERROR;
	}
	return 0;
}


int TI_BER_Meter_Start (u8 dut_fd , u16* pcmd_param, u8* bd_addr)
{
	u8 buf[SOCKET_BUF_SIZE];
	u16 len;
	u8 status;
	u8 reserved = 0x00;
	u8 lt_addr = 0x01;
	u8 poll_period = 0x01;

    bt_hci_cmd_ti_ber_meter_start.parameter_tbl[0].value = &pcmd_param[TI_BER_METER_START_FREQ];
    bt_hci_cmd_ti_ber_meter_start.parameter_tbl[1].value = &reserved;
    bt_hci_cmd_ti_ber_meter_start.parameter_tbl[2].value = bd_addr;
    bt_hci_cmd_ti_ber_meter_start.parameter_tbl[3].value = &lt_addr;
    bt_hci_cmd_ti_ber_meter_start.parameter_tbl[4].value = &pcmd_param[TI_BER_METER_START_PKT_TYPE];
    bt_hci_cmd_ti_ber_meter_start.parameter_tbl[5].value = &pcmd_param[TI_BER_METER_START_PKT_LEN];
    bt_hci_cmd_ti_ber_meter_start.parameter_tbl[6].value = &pcmd_param[TI_BER_METER_START_NUM_OF_PKT];
    bt_hci_cmd_ti_ber_meter_start.parameter_tbl[7].value = &pcmd_param[TI_BER_METER_START_PRBS9];
    bt_hci_cmd_ti_ber_meter_start.parameter_tbl[8].value = &poll_period;

    PRINT_TIME;

	bt_hci_write_cmd2socket (dut_fd, &bt_hci_cmd_ti_ber_meter_start);
    do{
        socket_msg_get(dut_fd,&len,buf);
    }while(len <=0);
	print_charray(len,buf);
	status=buf[_BT_HCI_W_EVENT_HEADER_+_BT_HCI_IDX_EVENT_PARAMETER_];
	bt_hci_event_parsing(buf[_BT_HCI_IDX_EVENT_CODE_],
						buf[_BT_HCI_IDX_EVENT_LENGTH_],
						buf+_BT_HCI_IDX_EVENT_PARAMETER_);

	printf("Status =%d\n" , status);
	if( 0 != status)
	{
		printf("%s FAILED\n" , __FUNCTION__);
		return ERROR;
	}
	return 0;
}


int TI_Read_BER_Meter_Result (u8 dut_fd)
{
	u8 buf[SOCKET_BUF_SIZE];
	u16 len;
	u8 status;

    PRINT_TIME;

	bt_hci_write_cmd2socket (dut_fd, &bt_hci_cmd_ti_read_ber_meter_result);
    do{
        socket_msg_get(dut_fd,&len,buf);
    }while(len <=0);
	print_charray(len,buf);
	status=buf[_BT_HCI_W_EVENT_HEADER_+_BT_HCI_IDX_EVENT_PARAMETER_];
	bt_hci_event_parsing(buf[_BT_HCI_IDX_EVENT_CODE_],
						buf[_BT_HCI_IDX_EVENT_LENGTH_],
						buf+_BT_HCI_IDX_EVENT_PARAMETER_);

	printf("Status =%d\n" , status);
	if( 0 != status)
	{
		printf("%s FAILED\n" , __FUNCTION__);
		return ERROR;
	}
	return 0;
}


int COMM_Ch_Map_Set (u8 dut_fd ,Pattern_param param)
{
	u8 buf[SOCKET_BUF_SIZE];
	u16 len;
	u8 status;

    PRINT_TIME;

	bt_hci_write_cmd2socket(dut_fd, &bt_hci_cmd_le_set_host_channel_classification);

    do{ 
        socket_msg_get(dut_fd,&len,buf);
    }while(len <=0);
	status=buf[_BT_HCI_W_EVENT_HEADER_+_BT_HCI_IDX_EVENT_PARAMETER_];
	//print_charray(len,buf);
	bt_hci_event_parsing(buf[_BT_HCI_IDX_EVENT_CODE_],
						buf[_BT_HCI_IDX_EVENT_LENGTH_],
						buf+_BT_HCI_IDX_EVENT_PARAMETER_);

	printf("Status =%d\n" , status);
	if( 0 != status)
	{
		printf("%s FAILED\n" , __FUNCTION__);
		return ERROR;
	}
	return 0;
}

int COMM_Ch_Map_Check (u8 dut_fd ,Pattern_param param )
{
	u8 buf[SOCKET_BUF_SIZE];
	u16 len;
	u8  status;
    u16 conn_handle;
    u16 conn_handle_config;

    PRINT_TIME;

	bt_hci_write_cmd2socket(dut_fd, &bt_hci_cmd_le_read_channel_map);

    do{ 
        socket_msg_get(dut_fd,&len,buf);
    }while(len <=0);
    
	status      =   buf[_BT_HCI_W_EVENT_HEADER_+_BT_HCI_IDX_EVENT_PARAMETER_];
    
	conn_handle =   buf[_BT_HCI_W_EVENT_HEADER_+_BT_HCI_EVT_LE_READ_CHANNEL_MAP_CONN_HANDLE] + \
                   (buf[_BT_HCI_W_EVENT_HEADER_+_BT_HCI_EVT_LE_READ_CHANNEL_MAP_CONN_HANDLE + 1] << 8);

    conn_handle_config = (u16)(param.LE_Connection_Handle[0]) + (u16)(param.LE_Connection_Handle[1] << 8) ;

	//print_charray(len,buf);
	bt_hci_event_parsing(buf[_BT_HCI_IDX_EVENT_CODE_],
						buf[_BT_HCI_IDX_EVENT_LENGTH_],
						buf+_BT_HCI_IDX_EVENT_PARAMETER_);

	printf("Status =%d\n" , status);

	if( 0 != status)
	{
		printf("%s FAILED\n" , __FUNCTION__);
		return status;
	}else{

        if(conn_handle !=  conn_handle_config){
            printf("conn handle mismatch %x : %x \n" , conn_handle , conn_handle_config);
            printf("%s FAILED\n" , __FUNCTION__);
            return ERROR ;
        }

        if( memcmp(buf+_BT_HCI_W_EVENT_HEADER_+_BT_HCI_EVT_LE_READ_CHANNEL_MAP_CHANNEL_MAP , 
                   &(param.LE_Channel_Map), 5 ) != 0){
        
            printf("channel map mismatch \n");
            printf("%s FAILED\n" , __FUNCTION__);
            return ERROR ;
        }  
	}
    
	return 0;
}



int COMM_Conn_Update_Set (u8 dut_fd ,Pattern_param param)
{
	u8 buf[SOCKET_BUF_SIZE];
	u16 len;
    u8 ret ;

    PRINT_TIME;
    
	bt_hci_write_cmd2socket(dut_fd, &bt_hci_cmd_le_connection_update);

    do{
        ret=socket_msg_get(dut_fd,&len,buf);
    }while(len <=0);
	printf("Get Event(%d):\n",dut_fd);	
	print_charray(len,buf); 
	if(SOCKET_SUCCESS != ret){	
		return FAIL;	
	}

    ret = hci_event_command_status_parsing(buf);
    
	if (CMD_SUCCESS == ret) {
        printf("command status (success)\n\n");
    }    
	else{        
        printf("command status (failed 0x%x)\n\n" , ret);
        return ret;
    }
	return PASS;

}

int COMM_Read_BD_Addr (u8 dut_fd ,Pattern_param param)
{
	u8 buf[SOCKET_BUF_SIZE];
	u16 len;
	u8 status;

    PRINT_TIME;

	bt_hci_write_cmd2socket (dut_fd, &bt_hci_cmd_read_bd_addr);
    do{
        socket_msg_get(dut_fd,&len,buf);
    }while(len <=0);
	print_charray(len,buf);
	status=buf[_BT_HCI_W_EVENT_HEADER_+_BT_HCI_IDX_EVENT_PARAMETER_];
	bt_hci_event_parsing(buf[_BT_HCI_IDX_EVENT_CODE_],
						buf[_BT_HCI_IDX_EVENT_LENGTH_],
						buf+_BT_HCI_IDX_EVENT_PARAMETER_);

	printf("Status =%d\n" , status);
	if( 0 != status)
	{
		printf("%s FAILED\n" , __FUNCTION__);
		return ERROR;
	}
	return 0;
}

#define LOCAL_FEATURES 0x4000000000
int COMM_Read_Local_features (u8 dut_fd ,Pattern_param param)
{
	u8  buf[SOCKET_BUF_SIZE];
	u16 len;
	u8  ret;

	HCI_WRITECMD_AND_GETEVENT_PARSING(bt_hci_cmd_read_local_supported_features);

    u64 val = *(u64*)(buf+_BT_HCI_W_CMD_HEADER_ + _BT_HCI_IDX_EVENT_PARAMETER_);
    if(val != LOCAL_FEATURES){
        printf("local features mismatch %llx / %llx \n" , val , LOCAL_FEATURES );
        return FAIL;
    }else{
        printf("local features %x %x %x %x %x %x %x %x\n" , 
            buf[_BT_HCI_W_CMD_HEADER_ + _BT_HCI_IDX_EVENT_PARAMETER_ + 7],
            buf[_BT_HCI_W_CMD_HEADER_ + _BT_HCI_IDX_EVENT_PARAMETER_ + 6],
            buf[_BT_HCI_W_CMD_HEADER_ + _BT_HCI_IDX_EVENT_PARAMETER_ + 5],
            buf[_BT_HCI_W_CMD_HEADER_ + _BT_HCI_IDX_EVENT_PARAMETER_ + 4],
            buf[_BT_HCI_W_CMD_HEADER_ + _BT_HCI_IDX_EVENT_PARAMETER_ + 3],
            buf[_BT_HCI_W_CMD_HEADER_ + _BT_HCI_IDX_EVENT_PARAMETER_ + 2],
            buf[_BT_HCI_W_CMD_HEADER_ + _BT_HCI_IDX_EVENT_PARAMETER_ + 1],
            buf[_BT_HCI_W_CMD_HEADER_ + _BT_HCI_IDX_EVENT_PARAMETER_ + 0]
        );
    }
       
	return PASS;

}

int COMM_Read_Local_commands (u8 dut_fd ,Pattern_param param)
{
	u8  buf[SOCKET_BUF_SIZE];
	u16 len;
	u8  ret;

	HCI_WRITECMD_AND_GETEVENT_PARSING(bt_hci_cmd_read_local_supported_commands);

    u64 val = *(u64*)(buf+_BT_HCI_W_CMD_HEADER_ + _BT_HCI_IDX_EVENT_PARAMETER_);
    if(0)//(val != LOCAL_FEATURES)
    {
        printf("local commands mismatch %llx / %llx \n" , val , LOCAL_FEATURES );
        return FAIL;
    }else{
        printf("local commands %x %x %x %x %x %x %x %x\n" ,
            buf[_BT_HCI_W_CMD_HEADER_ + _BT_HCI_IDX_EVENT_PARAMETER_ + 7],
            buf[_BT_HCI_W_CMD_HEADER_ + _BT_HCI_IDX_EVENT_PARAMETER_ + 6],
            buf[_BT_HCI_W_CMD_HEADER_ + _BT_HCI_IDX_EVENT_PARAMETER_ + 5],
            buf[_BT_HCI_W_CMD_HEADER_ + _BT_HCI_IDX_EVENT_PARAMETER_ + 4],
            buf[_BT_HCI_W_CMD_HEADER_ + _BT_HCI_IDX_EVENT_PARAMETER_ + 3],
            buf[_BT_HCI_W_CMD_HEADER_ + _BT_HCI_IDX_EVENT_PARAMETER_ + 2],
            buf[_BT_HCI_W_CMD_HEADER_ + _BT_HCI_IDX_EVENT_PARAMETER_ + 1],
            buf[_BT_HCI_W_CMD_HEADER_ + _BT_HCI_IDX_EVENT_PARAMETER_ + 0]
        );
    }

	return PASS;

}
#define LE_LOCAL_FEATURES 0x01
int COMM_LE_Read_Local_features (u8 dut_fd ,Pattern_param param)
{
	u8  buf[SOCKET_BUF_SIZE];
	u16 len;
	u8  ret;

	HCI_WRITECMD_AND_GETEVENT_PARSING(bt_hci_cmd_le_read_local_supported_features);

    u64 val = *(u64*)(buf+_BT_HCI_W_CMD_HEADER_ + _BT_HCI_IDX_EVENT_PARAMETER_);
    if(val != LE_LOCAL_FEATURES){
        printf("LE local features mismatch %llx / %x \n" , val , LE_LOCAL_FEATURES );
        return FAIL;
    }else{
        printf("LE local features  %x %x %x %x %x %x %x %x\n" , 
            buf[_BT_HCI_W_CMD_HEADER_ + _BT_HCI_IDX_EVENT_PARAMETER_ + 7],
            buf[_BT_HCI_W_CMD_HEADER_ + _BT_HCI_IDX_EVENT_PARAMETER_ + 6],
            buf[_BT_HCI_W_CMD_HEADER_ + _BT_HCI_IDX_EVENT_PARAMETER_ + 5],
            buf[_BT_HCI_W_CMD_HEADER_ + _BT_HCI_IDX_EVENT_PARAMETER_ + 4],
            buf[_BT_HCI_W_CMD_HEADER_ + _BT_HCI_IDX_EVENT_PARAMETER_ + 3],
            buf[_BT_HCI_W_CMD_HEADER_ + _BT_HCI_IDX_EVENT_PARAMETER_ + 2],
            buf[_BT_HCI_W_CMD_HEADER_ + _BT_HCI_IDX_EVENT_PARAMETER_ + 1],
            buf[_BT_HCI_W_CMD_HEADER_ + _BT_HCI_IDX_EVENT_PARAMETER_ + 0]
        );
    }

	return PASS;

}

#define LE_LOCAL_STATES 0xC30FFBF
int COMM_LE_Read_Local_supported_states (u8 dut_fd ,Pattern_param param)
{
	u8  buf[SOCKET_BUF_SIZE];
	u16 len;
	u8  ret;

	HCI_WRITECMD_AND_GETEVENT_PARSING(bt_hci_cmd_le_read_local_supported_states);


    u64 val = *(u64*)(buf+_BT_HCI_W_CMD_HEADER_ + _BT_HCI_IDX_EVENT_PARAMETER_);
    if(val != LE_LOCAL_STATES){
        printf("LE local supported states mismatch %llx / %x \n" , val , LE_LOCAL_STATES );
        return FAIL;
    }else{
        printf("LE local supported states %x %x %x %x %x %x %x %x\n" , 
            buf[_BT_HCI_W_CMD_HEADER_ + _BT_HCI_IDX_EVENT_PARAMETER_ + 7],
            buf[_BT_HCI_W_CMD_HEADER_ + _BT_HCI_IDX_EVENT_PARAMETER_ + 6],
            buf[_BT_HCI_W_CMD_HEADER_ + _BT_HCI_IDX_EVENT_PARAMETER_ + 5],
            buf[_BT_HCI_W_CMD_HEADER_ + _BT_HCI_IDX_EVENT_PARAMETER_ + 4],
            buf[_BT_HCI_W_CMD_HEADER_ + _BT_HCI_IDX_EVENT_PARAMETER_ + 3],
            buf[_BT_HCI_W_CMD_HEADER_ + _BT_HCI_IDX_EVENT_PARAMETER_ + 2],
            buf[_BT_HCI_W_CMD_HEADER_ + _BT_HCI_IDX_EVENT_PARAMETER_ + 1],
            buf[_BT_HCI_W_CMD_HEADER_ + _BT_HCI_IDX_EVENT_PARAMETER_ + 0]
        );
    }

	return PASS;

}


int COMM_Device_Address_Set (u8 dut_fd ,Pattern_param param)
{
	u8 buf[SOCKET_BUF_SIZE];
	u16 len;
	u8 status;

    PRINT_TIME;

	bt_hci_write_cmd2socket(dut_fd, &bt_hci_cmd_le_set_random_address);

    do{
        socket_msg_get(dut_fd,&len,buf);
    }while(len <=0);
	status=buf[_BT_HCI_W_EVENT_HEADER_+_BT_HCI_IDX_EVENT_PARAMETER_];
	//print_charray(len,buf);
	bt_hci_event_parsing(buf[_BT_HCI_IDX_EVENT_CODE_],
						buf[_BT_HCI_IDX_EVENT_LENGTH_],
						buf+_BT_HCI_IDX_EVENT_PARAMETER_);

	printf("Status =%d\n" , status);
	if( 0 != status)
	{
		printf("%s FAILED\n" , __FUNCTION__);
		return ERROR;
	}
	return 0;
}


void COMM_ADV_Advertising_Parameters_Set_Config (u8 DUT ,Pattern_param * param)
{
    printf("adv interval min %x %x\n" , param->adv_param.Advertising_Interval_Min[1] ,param->adv_param.Advertising_Interval_Min[0]);
    printf("adv interval max %x %x\n" , param->adv_param.Advertising_Interval_Max[1] ,param->adv_param.Advertising_Interval_Max[0]);
    printf("adv type %x\n" , param->adv_param.Advertising_Type[0]);
    printf("own addr type %x\n" , param->adv_param.Own_Address_Type[0]);
    printf("dir addr type %x\n" , param->adv_param.Direct_Address_Type[0]);
    printf("adv ch %x\n" , param->adv_param.Advertising_Channel_Map[0]);
    printf("adv filter %x\n" , param->adv_param.Advertising_Filter_Policy[0]);

	bt_hci_cmd_le_set_advertising_parameters.parameter_tbl[0].value = param->adv_param.Advertising_Interval_Min;
	bt_hci_cmd_le_set_advertising_parameters.parameter_tbl[1].value = param->adv_param.Advertising_Interval_Max;
	bt_hci_cmd_le_set_advertising_parameters.parameter_tbl[2].value = param->adv_param.Advertising_Type;
	bt_hci_cmd_le_set_advertising_parameters.parameter_tbl[3].value = param->adv_param.Own_Address_Type;
	bt_hci_cmd_le_set_advertising_parameters.parameter_tbl[4].value = param->adv_param.Direct_Address_Type;
	bt_hci_cmd_le_set_advertising_parameters.parameter_tbl[5].value = param->adv_param.Direct_Address;
	bt_hci_cmd_le_set_advertising_parameters.parameter_tbl[6].value = param->adv_param.Advertising_Channel_Map;
	bt_hci_cmd_le_set_advertising_parameters.parameter_tbl[7].value = param->adv_param.Advertising_Filter_Policy;
}


int COMM_ADV_Advertising_Parameters_Set (u8 dut_fd ,Pattern_param param)
{
	u8 buf[SOCKET_BUF_SIZE];
	u16 len;
	u8 status;

    PRINT_TIME;

	bt_hci_write_cmd2socket(dut_fd, &bt_hci_cmd_le_set_advertising_parameters);

    do{
        socket_msg_get(dut_fd,&len,buf);
    }while(len <=0);
	status=buf[_BT_HCI_W_EVENT_HEADER_+_BT_HCI_IDX_EVENT_PARAMETER_];
	//print_charray(len,buf);
	bt_hci_event_parsing(buf[_BT_HCI_IDX_EVENT_CODE_],
						buf[_BT_HCI_IDX_EVENT_LENGTH_],
						buf+_BT_HCI_IDX_EVENT_PARAMETER_);

	printf("Status =%d\n" , status);
	if( 0 != status)
	{
		printf("%s FAILED\n" , __FUNCTION__);
		return status;
	}
	return 0;
}

verdict COMM_ADV_Advertising_Data_Set(u8 dut_fd ,Pattern_param param)
{
	u8 buf[SOCKET_BUF_SIZE];
	u16 len;
	u8 ret;

	HCI_WRITECMD_AND_GETEVENT_PARSING(bt_hci_cmd_le_set_advertising_data);

	return PASS;
}

void COMM_ADV_Directed_Advertising_Reconfig (Pattern_param * paramDst)
{
	static u8 adv_ent =2; //start from ch39(adv_ent=2)

	//advevent(1~20)[1]+Addr[6]+Addr[2]+Ch[1]=10bytes
	//paramDst->adv_data_param.Advertising_Data_Length[0] = 10;

	paramDst->adv_data_param.Advertising_Data[0]=adv_ent;
#if 0 //mark for SM implement
	paramDst->adv_data_param.Advertising_Data[1]=paramSrc->adv_data_param.Advertising_Data[0];
	paramDst->adv_data_param.Advertising_Data[2]=paramSrc->adv_data_param.Advertising_Data[0];
	paramDst->adv_data_param.Advertising_Data[3]=paramSrc->adv_data_param.Advertising_Data[0];
	paramDst->adv_data_param.Advertising_Data[4]=paramSrc->adv_data_param.Advertising_Data[0];
	paramDst->adv_data_param.Advertising_Data[5]=paramSrc->adv_data_param.Advertising_Data[0];
	paramDst->adv_data_param.Advertising_Data[6]=paramSrc->adv_data_param.Advertising_Data[0];
	paramDst->adv_data_param.Advertising_Data[7]=paramSrc->adv_data_param.Advertising_Data[0];
	paramDst->adv_data_param.Advertising_Data[8]=paramSrc->adv_data_param.Advertising_Data[0];
#endif

	switch(adv_ent%3)
	{
		case 1:
			paramDst->adv_param.Advertising_Channel_Map[0] =HCI_CMD_PARAM_ENABLE_CHANNEL_38;
		break;

		case 2:
			paramDst->adv_param.Advertising_Channel_Map[0] =HCI_CMD_PARAM_ENABLE_CHANNEL_39;
		break;

		case 0:
			paramDst->adv_param.Advertising_Channel_Map[0] =HCI_CMD_PARAM_ENABLE_CHANNEL_37;
		break;
	}

	paramDst->adv_data_param.Advertising_Data[9]=37+(adv_ent % 3);

	paramDst->Advertising_Enable[0] = HCI_CMD_PARAM_ADV_ENABLE;
	adv_ent++;

}


void COMM_ADV_Undirected_Advertising_Reconfig (Pattern_param * paramDst)
{
	static u8 adv_ent =2; //start from ch39(adv_ent=2)

	//advevent(1~20)[1]+Addr[6]+Addr[2]+Ch[1]=10bytes
	//paramDst->adv_data_param.Advertising_Data_Length[0] = 10;

	paramDst->adv_data_param.Advertising_Data[0]=adv_ent;
#if 0 //mark for SM implement
	paramDst->adv_data_param.Advertising_Data[1]=paramSrc->adv_data_param.Advertising_Data[0];
	paramDst->adv_data_param.Advertising_Data[2]=paramSrc->adv_data_param.Advertising_Data[0];
	paramDst->adv_data_param.Advertising_Data[3]=paramSrc->adv_data_param.Advertising_Data[0];
	paramDst->adv_data_param.Advertising_Data[4]=paramSrc->adv_data_param.Advertising_Data[0];
	paramDst->adv_data_param.Advertising_Data[5]=paramSrc->adv_data_param.Advertising_Data[0];
	paramDst->adv_data_param.Advertising_Data[6]=paramSrc->adv_data_param.Advertising_Data[0];
	paramDst->adv_data_param.Advertising_Data[7]=paramSrc->adv_data_param.Advertising_Data[0];
	paramDst->adv_data_param.Advertising_Data[8]=paramSrc->adv_data_param.Advertising_Data[0];
#endif

	switch(adv_ent%3)
	{
		case 1:
			paramDst->adv_param.Advertising_Channel_Map[0] =HCI_CMD_PARAM_ENABLE_CHANNEL_38;
		break;

		case 2:
			paramDst->adv_param.Advertising_Channel_Map[0] =HCI_CMD_PARAM_ENABLE_CHANNEL_39;
		break;

		case 0:
			paramDst->adv_param.Advertising_Channel_Map[0] =HCI_CMD_PARAM_ENABLE_CHANNEL_37;
		break;
	}

	paramDst->adv_data_param.Advertising_Data[9]=37+(adv_ent % 3);

	paramDst->Advertising_Enable[0] = HCI_CMD_PARAM_ADV_ENABLE;
	adv_ent++;

}


void COMM_ADV_NonConnectable_Advertising_Reconfig (Pattern_param * paramDst)
{
	static u8 adv_ent =2;

	//advevent(1~20)[1]+Addr[6]+Addr[2]+Ch[1]=10bytes
	//paramDst->adv_data_param.Advertising_Data_Length[0] = 10;

	paramDst->adv_data_param.Advertising_Data[0]=adv_ent;
#if 0 //mark for SM implement
	paramDst->adv_data_param.Advertising_Data[1]=paramSrc->adv_data_param.Advertising_Data[0];
	paramDst->adv_data_param.Advertising_Data[2]=paramSrc->adv_data_param.Advertising_Data[0];
	paramDst->adv_data_param.Advertising_Data[3]=paramSrc->adv_data_param.Advertising_Data[0];
	paramDst->adv_data_param.Advertising_Data[4]=paramSrc->adv_data_param.Advertising_Data[0];
	paramDst->adv_data_param.Advertising_Data[5]=paramSrc->adv_data_param.Advertising_Data[0];
	paramDst->adv_data_param.Advertising_Data[6]=paramSrc->adv_data_param.Advertising_Data[0];
	paramDst->adv_data_param.Advertising_Data[7]=paramSrc->adv_data_param.Advertising_Data[0];
	paramDst->adv_data_param.Advertising_Data[8]=paramSrc->adv_data_param.Advertising_Data[0];
#endif

	switch(adv_ent%3)
	{
		case 1:
			paramDst->adv_param.Advertising_Channel_Map[0] =HCI_CMD_PARAM_ENABLE_CHANNEL_38;
		break;

		case 2:
			paramDst->adv_param.Advertising_Channel_Map[0] =HCI_CMD_PARAM_ENABLE_CHANNEL_39;
		break;

		case 0:
			paramDst->adv_param.Advertising_Channel_Map[0] =HCI_CMD_PARAM_ENABLE_CHANNEL_37;
		break;
	}

	paramDst->adv_data_param.Advertising_Data[9]=37+(adv_ent % 3);//start from ch38
	paramDst->Advertising_Enable[0] = HCI_CMD_PARAM_ADV_ENABLE;
	adv_ent++;
}

void COMM_ADV_NonConnectable_Advertising_Config (u8 len ,Pattern_param * param)
{
	int payload_cnt = 0;

	// P.27 to set the parameters' advertising interval and advertising channel map
	param->adv_param.Advertising_Interval_Min[0]= HCI_CMD_PARAM_ADVERTISING_INTERVAL_MIN_ADV_SCAN_OR_NONCONN_IND & 0x00ff;
	param->adv_param.Advertising_Interval_Min[1]=(HCI_CMD_PARAM_ADVERTISING_INTERVAL_MIN_ADV_SCAN_OR_NONCONN_IND & 0xff00) >> 8;
	param->adv_param.Advertising_Interval_Max[0]= HCI_CMD_PARAM_ADVERTISING_INTERVAL_MAX & 0x00ff;
	param->adv_param.Advertising_Interval_Max[1]=(HCI_CMD_PARAM_ADVERTISING_INTERVAL_MAX & 0xff00)	>> 8;
	param->adv_param.Advertising_Type[0]	= HCI_CMD_PARAM_ADV_NONCONN_IND;
	param->adv_param.Own_Address_Type[0]	= HCI_CMD_PARAM_PUBLIC_DEVICE_ADDRESS;
	param->adv_param.Direct_Address_Type[0] = HCI_CMD_PARAM_PUBLIC_DEVICE_ADDRESS;

    memcpy (param->adv_param.Direct_Address , adv_addr , ADDR_LENGTH);

	param->adv_param.Advertising_Channel_Map[0] =HCI_CMD_PARAM_ENABLE_CHANNEL_37 | HCI_CMD_PARAM_ENABLE_CHANNEL_38 |HCI_CMD_PARAM_ENABLE_CHANNEL_39;
	param->adv_param.Advertising_Filter_Policy[0] = HCI_CMD_PARAM_ALLOW_SCAN_REQ_FROM_WHITELIST_ONLY_AND_CONN_REQ_FROM_WHITELIST_ONLY;
	//TP p.46 ,set policy:0x03
	//HCI_CMD_PARAM_ALLOW_SCAN_REQ_AND_CONN_REQ_FROM_ANY;

	bt_hci_cmd_le_set_advertising_parameters.parameter_tbl[0].value = param->adv_param.Advertising_Interval_Min;
	bt_hci_cmd_le_set_advertising_parameters.parameter_tbl[1].value = param->adv_param.Advertising_Interval_Max;
	bt_hci_cmd_le_set_advertising_parameters.parameter_tbl[2].value = param->adv_param.Advertising_Type;
	bt_hci_cmd_le_set_advertising_parameters.parameter_tbl[3].value = param->adv_param.Own_Address_Type;
	bt_hci_cmd_le_set_advertising_parameters.parameter_tbl[4].value = param->adv_param.Direct_Address_Type;
	bt_hci_cmd_le_set_advertising_parameters.parameter_tbl[5].value = param->adv_param.Direct_Address;
	bt_hci_cmd_le_set_advertising_parameters.parameter_tbl[6].value = param->adv_param.Advertising_Channel_Map;
	bt_hci_cmd_le_set_advertising_parameters.parameter_tbl[7].value = param->adv_param.Advertising_Filter_Policy;

	param->adv_data_param.Advertising_Data_Length[0]=len;
	bt_hci_cmd_le_set_advertising_data.parameter_tbl[0].value = param->adv_data_param.Advertising_Data_Length;

	if (0 != len)
	{
		for ( ; payload_cnt  < len ; payload_cnt++){
			param->adv_data_param.Advertising_Data[payload_cnt]=payload_cnt;
		}
		bt_hci_cmd_le_set_advertising_data.parameter_tbl[1].value = param->adv_data_param.Advertising_Data;
	}

	param->Advertising_Enable[0] = HCI_CMD_PARAM_ADV_ENABLE;

	bt_hci_cmd_le_set_advertise_enable.parameter_tbl[0].value = param->Advertising_Enable;
}


verdict COMM_ADV_NonConnectable_Advertising(u8 dut_fd ,Pattern_param param)
{
	u8 buf[SOCKET_BUF_SIZE];
	u16 len;
	u8 ret;

	HCI_WRITECMD_AND_GETEVENT_PARSING(bt_hci_cmd_le_set_advertising_parameters);
	HCI_WRITECMD_AND_GETEVENT_PARSING(bt_hci_cmd_le_set_advertising_data);
	HCI_WRITECMD_AND_GETEVENT_PARSING(bt_hci_cmd_le_set_advertise_enable);

	return PASS;

}

void COMM_ADV_Undirected_Advertising_Config (u8 len ,Pattern_param * param)
{

	int payload_cnt = 0;

	// P.27 to set the parameters' advertising interval and advertising channel map
	param->adv_param.Advertising_Interval_Min[0]=HCI_CMD_PARAM_ADVERTISING_INTERVAL_MIN & 0x00ff;
	param->adv_param.Advertising_Interval_Min[1]=(HCI_CMD_PARAM_ADVERTISING_INTERVAL_MIN & 0xff00) >> 8;
	param->adv_param.Advertising_Interval_Max[0]=HCI_CMD_PARAM_ADVERTISING_INTERVAL_MAX & 0x00ff;
	param->adv_param.Advertising_Interval_Max[1]=(HCI_CMD_PARAM_ADVERTISING_INTERVAL_MAX & 0xff00)	>> 8;
	param->adv_param.Advertising_Type[0]	= HCI_CMD_PARAM_ADV_IND;
	param->adv_param.Own_Address_Type[0]    = HCI_CMD_PARAM_PUBLIC_DEVICE_ADDRESS;
	param->adv_param.Direct_Address_Type[0] = HCI_CMD_PARAM_PUBLIC_DEVICE_ADDRESS;

	memcpy (param->adv_param.Direct_Address , adv_addr , ADDR_LENGTH);

	param->adv_param.Advertising_Channel_Map[0] =HCI_CMD_PARAM_ENABLE_CHANNEL_37 | HCI_CMD_PARAM_ENABLE_CHANNEL_38 |HCI_CMD_PARAM_ENABLE_CHANNEL_39;
	param->adv_param.Advertising_Filter_Policy[0] = HCI_CMD_PARAM_ALLOW_SCAN_REQ_AND_CONN_REQ_FROM_ANY;

	bt_hci_cmd_le_set_advertising_parameters.parameter_tbl[0].value = param->adv_param.Advertising_Interval_Min;
	bt_hci_cmd_le_set_advertising_parameters.parameter_tbl[1].value = param->adv_param.Advertising_Interval_Max;
	bt_hci_cmd_le_set_advertising_parameters.parameter_tbl[2].value = param->adv_param.Advertising_Type;
	bt_hci_cmd_le_set_advertising_parameters.parameter_tbl[3].value = param->adv_param.Own_Address_Type;
	bt_hci_cmd_le_set_advertising_parameters.parameter_tbl[4].value = param->adv_param.Direct_Address_Type;
	bt_hci_cmd_le_set_advertising_parameters.parameter_tbl[5].value = param->adv_param.Direct_Address;
	bt_hci_cmd_le_set_advertising_parameters.parameter_tbl[6].value = param->adv_param.Advertising_Channel_Map;
	bt_hci_cmd_le_set_advertising_parameters.parameter_tbl[7].value = param->adv_param.Advertising_Filter_Policy;


	param->adv_data_param.Advertising_Data_Length[0]=len;
	bt_hci_cmd_le_set_advertising_data.parameter_tbl[0].value = param->adv_data_param.Advertising_Data_Length;

	if (0 != len)
	{
		for (; payload_cnt	< len ; payload_cnt++)
			param->adv_data_param.Advertising_Data[payload_cnt]=payload_cnt;
		bt_hci_cmd_le_set_advertising_data.parameter_tbl[1].value = param->adv_data_param.Advertising_Data;
	}
	memset(param->scn_rsp_param.Scan_Response_Data , 0 , len);
	param->scn_rsp_param.Scan_Response_Data_Length[0]=len;
	param->scn_rsp_param.Scan_Response_Data[0]=0x44;
	param->scn_rsp_param.Scan_Response_Data[1]=0x55;
	param->scn_rsp_param.Scan_Response_Data[2]=0x54;

	bt_hci_cmd_le_set_scan_response_data.parameter_tbl[0].value = param->scn_rsp_param.Scan_Response_Data_Length;
	bt_hci_cmd_le_set_scan_response_data.parameter_tbl[1].value = param->scn_rsp_param.Scan_Response_Data;


	param->Advertising_Enable[0] = HCI_CMD_PARAM_ADV_ENABLE;

	bt_hci_cmd_le_set_advertise_enable.parameter_tbl[0].value = param->Advertising_Enable;
}


verdict COMM_ADV_Advertising(u8 dut_fd)
{
	u8 buf[SOCKET_BUF_SIZE];
	u16 len;
	u8 ret;

	HCI_WRITECMD_AND_GETEVENT_PARSING(bt_hci_cmd_le_set_advertising_parameters);
	HCI_WRITECMD_AND_GETEVENT_PARSING(bt_hci_cmd_le_set_advertising_data);
	HCI_WRITECMD_AND_GETEVENT_PARSING(bt_hci_cmd_le_set_scan_response_data);
	HCI_WRITECMD_AND_GETEVENT_PARSING(bt_hci_cmd_le_set_advertise_enable);

	return PASS;
}


verdict COMM_ADV_Undirected_Advertising(u8 dut_fd ,Pattern_param param)
{
	u8 buf[SOCKET_BUF_SIZE];
	u16 len;
	u8 ret;

	HCI_WRITECMD_AND_GETEVENT_PARSING(bt_hci_cmd_le_set_advertising_parameters);
	HCI_WRITECMD_AND_GETEVENT_PARSING(bt_hci_cmd_le_set_advertising_data);
	HCI_WRITECMD_AND_GETEVENT_PARSING(bt_hci_cmd_le_set_scan_response_data);
	HCI_WRITECMD_AND_GETEVENT_PARSING(bt_hci_cmd_le_set_advertise_enable);

	return PASS;
}

void COMM_ADV_Discoverable_Advertising_Config (u8 len ,Pattern_param * param)
{
	int payload_cnt = 0;

	// P.27 to set the parameters' advertising interval and advertising channel map
	param->adv_param.Advertising_Interval_Min[0]=HCI_CMD_PARAM_ADVERTISING_INTERVAL_MIN_ADV_SCAN_OR_NONCONN_IND & 0x00ff;
	param->adv_param.Advertising_Interval_Min[1]=(HCI_CMD_PARAM_ADVERTISING_INTERVAL_MIN_ADV_SCAN_OR_NONCONN_IND & 0xff00) >> 8;
	param->adv_param.Advertising_Interval_Max[0]=HCI_CMD_PARAM_ADVERTISING_INTERVAL_MAX & 0x00ff;
	param->adv_param.Advertising_Interval_Max[1]=(HCI_CMD_PARAM_ADVERTISING_INTERVAL_MAX & 0xff00)	>> 8;
	param->adv_param.Advertising_Type[0]	= HCI_CMD_PARAM_ADV_SCAN_IND;
	param->adv_param.Own_Address_Type[0] =HCI_CMD_PARAM_PUBLIC_DEVICE_ADDRESS;
	param->adv_param.Direct_Address_Type[0] = HCI_CMD_PARAM_PUBLIC_DEVICE_ADDRESS;

	memcpy (param->adv_param.Direct_Address , adv_addr , ADDR_LENGTH);

	param->adv_param.Advertising_Channel_Map[0] =HCI_CMD_PARAM_ENABLE_CHANNEL_37 | HCI_CMD_PARAM_ENABLE_CHANNEL_38 |HCI_CMD_PARAM_ENABLE_CHANNEL_39;
	//param->adv_param.Advertising_Channel_Map[0] =HCI_CMD_PARAM_ENABLE_CHANNEL_38;
	param->adv_param.Advertising_Filter_Policy[0] = HCI_CMD_PARAM_ALLOW_SCAN_REQ_AND_CONN_REQ_FROM_ANY;

	bt_hci_cmd_le_set_advertising_parameters.parameter_tbl[0].value = param->adv_param.Advertising_Interval_Min;
	bt_hci_cmd_le_set_advertising_parameters.parameter_tbl[1].value = param->adv_param.Advertising_Interval_Max;
	bt_hci_cmd_le_set_advertising_parameters.parameter_tbl[2].value = param->adv_param.Advertising_Type;
	bt_hci_cmd_le_set_advertising_parameters.parameter_tbl[3].value = param->adv_param.Own_Address_Type;
	bt_hci_cmd_le_set_advertising_parameters.parameter_tbl[4].value = param->adv_param.Direct_Address_Type;
	bt_hci_cmd_le_set_advertising_parameters.parameter_tbl[5].value = param->adv_param.Direct_Address;
	bt_hci_cmd_le_set_advertising_parameters.parameter_tbl[6].value = param->adv_param.Advertising_Channel_Map;
	bt_hci_cmd_le_set_advertising_parameters.parameter_tbl[7].value = param->adv_param.Advertising_Filter_Policy;

	param->adv_data_param.Advertising_Data_Length[0]=len;
	bt_hci_cmd_le_set_advertising_data.parameter_tbl[0].value = param->adv_data_param.Advertising_Data_Length;

	//if (0 != len)
	{
		for (; payload_cnt	< len ; payload_cnt++)
			param->adv_data_param.Advertising_Data[payload_cnt]=payload_cnt;
		bt_hci_cmd_le_set_advertising_data.parameter_tbl[1].value = param->adv_data_param.Advertising_Data;
	}

	param->Advertising_Enable[0]= HCI_CMD_PARAM_ADV_ENABLE;

	bt_hci_cmd_le_set_advertise_enable.parameter_tbl[0].value = param->Advertising_Enable;
}


verdict COMM_ADV_Discoverable_Advertising(u8 dut_fd ,Pattern_param param)
{
	u8 buf[SOCKET_BUF_SIZE];
	u16 len;
	u8 ret;

	HCI_WRITECMD_AND_GETEVENT_PARSING(bt_hci_cmd_le_set_advertising_parameters);
	HCI_WRITECMD_AND_GETEVENT_PARSING(bt_hci_cmd_le_set_advertising_data);
    //HCI_WRITECMD_AND_GETEVENT_PARSING(bt_hci_cmd_le_set_scan_response_data);
	HCI_WRITECMD_AND_GETEVENT_PARSING(bt_hci_cmd_le_set_advertise_enable);

	return PASS;
}

void COMM_ADV_Directed_Advertising_Config (u8 DUT ,Pattern_param * param)
{
	// P.27 to set the parameters' advertising interval and advertising channel map
	param->adv_param.Advertising_Interval_Min[0] = HCI_CMD_PARAM_ADVERTISING_INTERVAL_MIN & 0x00ff;
	param->adv_param.Advertising_Interval_Min[1] =(HCI_CMD_PARAM_ADVERTISING_INTERVAL_MIN & 0xff00) >> 8;
	param->adv_param.Advertising_Interval_Max[0] = HCI_CMD_PARAM_ADVERTISING_INTERVAL_MAX & 0x00ff;
	param->adv_param.Advertising_Interval_Max[1] =(HCI_CMD_PARAM_ADVERTISING_INTERVAL_MAX & 0xff00)	>> 8;
	param->adv_param.Advertising_Type[0]	     = HCI_CMD_PARAM_ADV_DIRECT_IND;
	param->adv_param.Own_Address_Type[0]         = HCI_CMD_PARAM_PUBLIC_DEVICE_ADDRESS;
	param->adv_param.Direct_Address_Type[0]      = HCI_CMD_PARAM_PUBLIC_DEVICE_ADDRESS;

	memcpy (param->adv_param.Direct_Address , init_addr , ADDR_LENGTH);//should be peer addr!!!

	param->adv_param.Advertising_Channel_Map[0] =HCI_CMD_PARAM_ENABLE_CHANNEL_37 | HCI_CMD_PARAM_ENABLE_CHANNEL_38 |HCI_CMD_PARAM_ENABLE_CHANNEL_39;
	param->adv_param.Advertising_Filter_Policy[0] = HCI_CMD_PARAM_ALLOW_SCAN_REQ_AND_CONN_REQ_FROM_ANY;

	bt_hci_cmd_le_set_advertising_parameters.parameter_tbl[0].value = param->adv_param.Advertising_Interval_Min;
	bt_hci_cmd_le_set_advertising_parameters.parameter_tbl[1].value = param->adv_param.Advertising_Interval_Max;
	bt_hci_cmd_le_set_advertising_parameters.parameter_tbl[2].value = param->adv_param.Advertising_Type;
	bt_hci_cmd_le_set_advertising_parameters.parameter_tbl[3].value = param->adv_param.Own_Address_Type;
	bt_hci_cmd_le_set_advertising_parameters.parameter_tbl[4].value = param->adv_param.Direct_Address_Type;
	bt_hci_cmd_le_set_advertising_parameters.parameter_tbl[5].value = param->adv_param.Direct_Address;
	bt_hci_cmd_le_set_advertising_parameters.parameter_tbl[6].value = param->adv_param.Advertising_Channel_Map;
	bt_hci_cmd_le_set_advertising_parameters.parameter_tbl[7].value = param->adv_param.Advertising_Filter_Policy;

	param->adv_data_param.Advertising_Data_Length[0]=0;
	bt_hci_cmd_le_set_advertising_data.parameter_tbl[0].value = param->adv_data_param.Advertising_Data_Length;

	param->Advertising_Enable[0] = HCI_CMD_PARAM_ADV_ENABLE;

	bt_hci_cmd_le_set_advertise_enable.parameter_tbl[0].value = param->Advertising_Enable;
}


void COMM_ADV_Low_Duty_Directed_Advertising_Config (u8 DUT ,Pattern_param * param)
{
	// P.27 to set the parameters' advertising interval and advertising channel map
	param->adv_param.Advertising_Interval_Min[0] = HCI_CMD_PARAM_ADVERTISING_INTERVAL_MIN & 0x00ff;
	param->adv_param.Advertising_Interval_Min[1] =(HCI_CMD_PARAM_ADVERTISING_INTERVAL_MIN & 0xff00) >> 8;
	param->adv_param.Advertising_Interval_Max[0] = HCI_CMD_PARAM_ADVERTISING_INTERVAL_MAX & 0x00ff;
	param->adv_param.Advertising_Interval_Max[1] =(HCI_CMD_PARAM_ADVERTISING_INTERVAL_MAX & 0xff00)	>> 8;
	param->adv_param.Advertising_Type[0]	     = 4;
	param->adv_param.Own_Address_Type[0]         = HCI_CMD_PARAM_PUBLIC_DEVICE_ADDRESS;
	param->adv_param.Direct_Address_Type[0]      = HCI_CMD_PARAM_PUBLIC_DEVICE_ADDRESS;

	memcpy (param->adv_param.Direct_Address , init_addr , ADDR_LENGTH);//should be peer addr!!!

	param->adv_param.Advertising_Channel_Map[0] =HCI_CMD_PARAM_ENABLE_CHANNEL_37 | HCI_CMD_PARAM_ENABLE_CHANNEL_38 |HCI_CMD_PARAM_ENABLE_CHANNEL_39;
	param->adv_param.Advertising_Filter_Policy[0] = HCI_CMD_PARAM_ALLOW_SCAN_REQ_AND_CONN_REQ_FROM_ANY;

	bt_hci_cmd_le_set_advertising_parameters.parameter_tbl[0].value = param->adv_param.Advertising_Interval_Min;
	bt_hci_cmd_le_set_advertising_parameters.parameter_tbl[1].value = param->adv_param.Advertising_Interval_Max;
	bt_hci_cmd_le_set_advertising_parameters.parameter_tbl[2].value = param->adv_param.Advertising_Type;
	bt_hci_cmd_le_set_advertising_parameters.parameter_tbl[3].value = param->adv_param.Own_Address_Type;
	bt_hci_cmd_le_set_advertising_parameters.parameter_tbl[4].value = param->adv_param.Direct_Address_Type;
	bt_hci_cmd_le_set_advertising_parameters.parameter_tbl[5].value = param->adv_param.Direct_Address;
	bt_hci_cmd_le_set_advertising_parameters.parameter_tbl[6].value = param->adv_param.Advertising_Channel_Map;
	bt_hci_cmd_le_set_advertising_parameters.parameter_tbl[7].value = param->adv_param.Advertising_Filter_Policy;

	param->adv_data_param.Advertising_Data_Length[0]=0;
	bt_hci_cmd_le_set_advertising_data.parameter_tbl[0].value = param->adv_data_param.Advertising_Data_Length;

	param->Advertising_Enable[0] = HCI_CMD_PARAM_ADV_ENABLE;

	bt_hci_cmd_le_set_advertise_enable.parameter_tbl[0].value = param->Advertising_Enable;
}
void COMM_ADV_Directed_Advertising_Config_type_addr (u8 DUT ,Pattern_param * param, u8 type, u8 addr[ADDR_LENGTH])
{
	// P.27 to set the parameters' advertising interval and advertising channel map
	param->adv_param.Advertising_Interval_Min[0] = HCI_CMD_PARAM_ADVERTISING_INTERVAL_MIN & 0x00ff;
	param->adv_param.Advertising_Interval_Min[1] =(HCI_CMD_PARAM_ADVERTISING_INTERVAL_MIN & 0xff00) >> 8;
	param->adv_param.Advertising_Interval_Max[0] = HCI_CMD_PARAM_ADVERTISING_INTERVAL_MAX & 0x00ff;
	param->adv_param.Advertising_Interval_Max[1] =(HCI_CMD_PARAM_ADVERTISING_INTERVAL_MAX & 0xff00)	>> 8;
	param->adv_param.Advertising_Type[0]	     = HCI_CMD_PARAM_ADV_DIRECT_IND;
	param->adv_param.Own_Address_Type[0]         = type;
	param->adv_param.Direct_Address_Type[0]      = HCI_CMD_PARAM_PUBLIC_DEVICE_ADDRESS;

	memcpy (param->adv_param.Direct_Address , addr , ADDR_LENGTH);//should be peer addr!!!

	param->adv_param.Advertising_Channel_Map[0] =HCI_CMD_PARAM_ENABLE_CHANNEL_37 | HCI_CMD_PARAM_ENABLE_CHANNEL_38 |HCI_CMD_PARAM_ENABLE_CHANNEL_39;
	param->adv_param.Advertising_Filter_Policy[0] = HCI_CMD_PARAM_ALLOW_SCAN_REQ_AND_CONN_REQ_FROM_ANY;

	bt_hci_cmd_le_set_advertising_parameters.parameter_tbl[0].value = param->adv_param.Advertising_Interval_Min;
	bt_hci_cmd_le_set_advertising_parameters.parameter_tbl[1].value = param->adv_param.Advertising_Interval_Max;
	bt_hci_cmd_le_set_advertising_parameters.parameter_tbl[2].value = param->adv_param.Advertising_Type;
	bt_hci_cmd_le_set_advertising_parameters.parameter_tbl[3].value = param->adv_param.Own_Address_Type;
	bt_hci_cmd_le_set_advertising_parameters.parameter_tbl[4].value = param->adv_param.Direct_Address_Type;
	bt_hci_cmd_le_set_advertising_parameters.parameter_tbl[5].value = param->adv_param.Direct_Address;
	bt_hci_cmd_le_set_advertising_parameters.parameter_tbl[6].value = param->adv_param.Advertising_Channel_Map;
	bt_hci_cmd_le_set_advertising_parameters.parameter_tbl[7].value = param->adv_param.Advertising_Filter_Policy;

	param->adv_data_param.Advertising_Data_Length[0]=0;
	bt_hci_cmd_le_set_advertising_data.parameter_tbl[0].value = param->adv_data_param.Advertising_Data_Length;

	param->Advertising_Enable[0] = HCI_CMD_PARAM_ADV_ENABLE;

	bt_hci_cmd_le_set_advertise_enable.parameter_tbl[0].value = param->Advertising_Enable;
}
verdict COMM_ADV_Directed_Advertising(u8 dut_fd ,Pattern_param param)
{
	u8 buf[SOCKET_BUF_SIZE];
	u16 len;
	u8 ret;

	HCI_WRITECMD_AND_GETEVENT_PARSING(bt_hci_cmd_le_set_advertising_parameters);
	//HCI_WRITECMD_AND_GETEVENT_PARSING(bt_hci_cmd_le_set_advertising_data);
	HCI_WRITECMD_AND_GETEVENT_PARSING(bt_hci_cmd_le_set_advertise_enable);

	return PASS;
}
verdict COMM_ADV_Low_Duty_Directed_Advertising(u8 dut_fd ,Pattern_param param)
{
	u8 buf[SOCKET_BUF_SIZE];
	u16 len;
	u8 ret;

	//bt_hci_cmd_le_set_advertising_parameters.parameter_tbl[2].value = 0x04;//low duty
	HCI_WRITECMD_AND_GETEVENT_PARSING(bt_hci_cmd_le_set_advertising_parameters);
	//HCI_WRITECMD_AND_GETEVENT_PARSING(bt_hci_cmd_le_set_advertising_data);
	HCI_WRITECMD_AND_GETEVENT_PARSING(bt_hci_cmd_le_set_advertise_enable);

	return PASS;
}
//here

void COMM_Disconnect_Config (u8 DUT ,Pattern_param * param , u8 * buf)
{
	param->disconn_param.Connection_Handle[0]	=buf[_BT_HCI_EVT_CON_COMP_CONN_HANDLE+0];
	param->disconn_param.Connection_Handle[1]	=buf[_BT_HCI_EVT_CON_COMP_CONN_HANDLE+1];
	param->disconn_param.Reason[0]= HCI_CMD_PARAM_CONNECTION_TERMINATED_BY_LOCAL_HOST;

	bt_hci_cmd_disconnect.parameter_tbl[0].value =param->disconn_param.Connection_Handle;
	bt_hci_cmd_disconnect.parameter_tbl[1].value =param->disconn_param.Reason;
}

verdict COMM_Read_LE_White_List_Size(u8 dut_fd ,Pattern_param *param)
{
	u8  buf[SOCKET_BUF_SIZE];
	u16 len;
	u8  ret;
    u32 line;

	HCI_WRITECMD_AND_GETEVENT_PARSING(bt_hci_cmd_le_read_white_list_size);

    if(SUCCESS != hci_event_read_white_list_size_parsing(buf)) {
        line = __LINE__;
        return line;
    }else{
        param->white_list_param.Size[0] = 
            buf[_BT_HCI_EVT_LE_READ_WHITE_LIST_SIZE];
    }

	return PASS;
}


verdict COMM_Read_LE_Buffer_Size(u8 dut_fd ,Pattern_param *param)
{
	u8  buf[SOCKET_BUF_SIZE];
	u16 len;
	u8  ret;
    u32 line;

	HCI_WRITECMD_AND_GETEVENT_PARSING(bt_hci_cmd_le_read_buffer_size);

    if(SUCCESS != hci_event_read_buff_size_parsing(buf)) {
        line = __LINE__;
        return line;
    }else{
        param->buff_size_param.HCI_LE_ACL_Data_Packet_Length = 
            (buf[_BT_HCI_EVT_LE_READ_BUFF_SIZE_LE_DATA_PKT_LEN +1]<< 8) + buf[_BT_HCI_EVT_LE_READ_BUFF_SIZE_LE_DATA_PKT_LEN];
        param->buff_size_param.HCI_Total_Num_LE_ACL_Data_Packets =
            buf[_BT_HCI_EVT_LE_READ_BUFF_SIZE_LE_DATA_PKT_NUM];
    }

    printf("check len %d num %d\n" , 
        param->buff_size_param.HCI_LE_ACL_Data_Packet_Length ,
        param->buff_size_param.HCI_Total_Num_LE_ACL_Data_Packets 
    );

	return PASS;
}

verdict COMM_Read_Local_Version_Information(u8 dut_fd ,Pattern_param *param)
{
	u8 buf[SOCKET_BUF_SIZE];
	u16 len;
	u8 ret;

	HCI_WRITECMD_AND_GETEVENT_PARSING(bt_hci_cmd_read_local_version_information);

    memcpy( &(param->local_version_information_param.HCI_Version), 
              buf + _BT_HCI_W_EVENT_HEADER_+_BT_HCI_EVT_LOCAL_VER_INFO_HCI_VER, 8);

	return PASS;
}

verdict COMM_Read_Remote_Version_Information_Config(u8 dut_fd ,Pattern_param *param ,u8 * conn_handle )
{
	param->remote_version_information_param.Connection_Handle[0]	=conn_handle[0];
	param->remote_version_information_param.Connection_Handle[1]	=conn_handle[1];

	bt_hci_cmd_read_remote_version_information.parameter_tbl[0].value =param->remote_version_information_param.Connection_Handle;

	return PASS;
}


verdict COMM_Read_Remote_Version_Information(u8 dut_fd ,Pattern_param param)
{
	u8 buf[SOCKET_BUF_SIZE];
	u16 len;
	u8 ret;

	HCI_WRITECMD_AND_GETEVENT_PARSING_CMD_STATUS(bt_hci_cmd_read_remote_version_information);

    return ret ;
}
/*
verdict COMM_Read_Local_Supported_Features_Config(u8 dut_fd ,Pattern_param *param ,u8 * conn_handle )
{
	param->local_features_param.Connection_Handle[0]	=conn_handle[0];
	param->local_features_param.Connection_Handle[1]	=conn_handle[1];

	bt_hci_cmd_le_read_local_supported_features.parameter_tbl[0].value =param->local_features_param.Connection_Handle;

	return PASS;
}
*/
verdict COMM_Read_Local_Supported_Features(u8 dut_fd ,Pattern_param param)
{
	u8 buf[SOCKET_BUF_SIZE];
	u16 len;
	u8 ret;

	HCI_WRITECMD_AND_GETEVENT_PARSING(bt_hci_cmd_le_read_local_supported_features);

    return ret ;
}

verdict COMM_Read_Local_Supported_States(u8 dut_fd ,Pattern_param param)
{
	u8 buf[SOCKET_BUF_SIZE];
	u16 len;
	u8 ret;

	HCI_WRITECMD_AND_GETEVENT_PARSING(bt_hci_cmd_le_read_local_supported_states);

    return ret ;
}


verdict COMM_Read_Remote_Supported_Features_Config(u8 dut_fd ,Pattern_param *param ,u8 * conn_handle )
{
	param->remote_features_param.Connection_Handle[0]	=conn_handle[0];
	param->remote_features_param.Connection_Handle[1]	=conn_handle[1];

	bt_hci_cmd_le_read_remote_used_features.parameter_tbl[0].value =param->remote_features_param.Connection_Handle;

	return PASS;
}


verdict COMM_Read_Remote_Supported_Features(u8 dut_fd ,Pattern_param param)
{
	u8 buf[SOCKET_BUF_SIZE];
	u16 len;
	u8 ret;

	HCI_WRITECMD_AND_GETEVENT_PARSING_CMD_STATUS(bt_hci_cmd_le_read_remote_used_features);

    return ret ;
}


verdict COMM_Disconnect(u8 dut_fd ,Pattern_param param)
{
	u8 buf[SOCKET_BUF_SIZE];
	u16 len;
	u8 ret;

	//HCI_WRITECMD_AND_GETEVENT_PARSING(bt_hci_cmd_le_create_connection);
	PRINT_TIME;
	ret=bt_hci_write_cmd2socket(dut_fd, &bt_hci_cmd_disconnect);
	if(SOCKET_SUCCESS != ret)
		return FAIL;
        do{
            ret=socket_msg_get(dut_fd,&len,buf);
        }while(len <=0);
	printf("Get Event(%d):\n",dut_fd);
	print_charray(len,buf);

	if(SOCKET_SUCCESS != ret){	
		return FAIL;	
	}

    ret = hci_event_command_status_parsing(buf);
    
	if (CMD_SUCCESS == ret) {
        printf("command status (success)\n\n");
    }    
	else{        
        printf("command status (failed 0x%x)\n\n" , ret);
        return ret;
    }

	return PASS;
}


void COMM_INI_Initiating_Config (u8 DUT ,Pattern_param * param)
{
#if 1
	param->create_conn_param.LE_Scan_Interval[0]		=   0xA0;//0x00;
	param->create_conn_param.LE_Scan_Interval[1]		=   0;//0x08;
	param->create_conn_param.LE_Scan_Window[0]			=   0xA0;//18
	param->create_conn_param.LE_Scan_Window[1]			=   0;
	param->create_conn_param.Initiator_Filter_Policy[0] =   HCI_CMD_PARAM_FILTER_POLICY_WHITE_LIST_NOT_USED;
	param->create_conn_param.Peer_Address_Type[0]		=   HCI_CMD_PARAM_PUBLIC_DEVICE_ADDRESS;
	memcpy(param->create_conn_param.Peer_Address ,adv_addr,ADDR_LENGTH );
	param->create_conn_param.Own_Address_Type[0]		=   HCI_CMD_PARAM_PUBLIC_DEVICE_ADDRESS;
	param->create_conn_param.Conn_Interval_Min[0]		=   24; //HCI_CMD_PARAM_CONN_INT_MIN & 0x00ff;
	param->create_conn_param.Conn_Interval_Min[1]		=   0;//(HCI_CMD_PARAM_CONN_INT_MIN & 0xff00)	>> 8;
	param->create_conn_param.Conn_Interval_Max[0]		=   40;
	param->create_conn_param.Conn_Interval_Max[1]		=   0;
	param->create_conn_param.Conn_Latency[0]		    =   HCI_CMD_PARAM_CONN_LATENCY_MIN;//HCI_CMD_PARAM_CONN_LATENCY_MAX & 0x00ff;
	param->create_conn_param.Conn_Latency[1]		    =   HCI_CMD_PARAM_CONN_LATENCY_MIN;//(HCI_CMD_PARAM_CONN_LATENCY_MAX & 0xff00)  >> 8;
	//The Supervision_Timeout in milliseconds shall be larger than the Conn_Interval_Max in milliseconds.
	//superviision TO > (1+connSlaveLatency)*Conninterval
	param->create_conn_param.Supervision_Timeout[0] 	=   0x64 ; //=0xD0;
	param->create_conn_param.Supervision_Timeout[1] 	=   0x00 ; //=0x07;
	param->create_conn_param.Minimum_CE_Length[0]		=   0;
	param->create_conn_param.Minimum_CE_Length[1]		=   0;
	param->create_conn_param.Maximum_CE_Length[0]		=   0;
	param->create_conn_param.Maximum_CE_Length[1]		=   0;

	bt_hci_cmd_le_create_connection.parameter_tbl[0].value  =   param->create_conn_param.LE_Scan_Interval;
	bt_hci_cmd_le_create_connection.parameter_tbl[1].value  =   param->create_conn_param.LE_Scan_Window;
	bt_hci_cmd_le_create_connection.parameter_tbl[2].value  =   param->create_conn_param.Initiator_Filter_Policy;
	bt_hci_cmd_le_create_connection.parameter_tbl[3].value  =   param->create_conn_param.Peer_Address_Type;
	bt_hci_cmd_le_create_connection.parameter_tbl[4].value  =   param->create_conn_param.Peer_Address;
	bt_hci_cmd_le_create_connection.parameter_tbl[5].value  =   param->create_conn_param.Own_Address_Type;
	bt_hci_cmd_le_create_connection.parameter_tbl[6].value  =   param->create_conn_param.Conn_Interval_Min;
	bt_hci_cmd_le_create_connection.parameter_tbl[7].value  =   param->create_conn_param.Conn_Interval_Max;
	bt_hci_cmd_le_create_connection.parameter_tbl[8].value  =   param->create_conn_param.Conn_Latency;
	bt_hci_cmd_le_create_connection.parameter_tbl[9].value  =   param->create_conn_param.Supervision_Timeout;
	bt_hci_cmd_le_create_connection.parameter_tbl[10].value =   param->create_conn_param.Minimum_CE_Length;
	bt_hci_cmd_le_create_connection.parameter_tbl[11].value =   param->create_conn_param.Maximum_CE_Length;


#else
	param->create_conn_param.LE_Scan_Interval[0]	=HCI_CMD_PARAM_LE_SCAN_INT_MAX & 0x00ff;
	param->create_conn_param.LE_Scan_Interval[1]	=(HCI_CMD_PARAM_LE_SCAN_INT_MAX & 0xff00)  >> 8;
	param->create_conn_param.LE_Scan_Window[0]	=HCI_CMD_PARAM_LE_SCAN_WIN_MAX & 0x00ff;
	param->create_conn_param.LE_Scan_Window[1]	=(HCI_CMD_PARAM_LE_SCAN_WIN_MAX & 0xff00)  >> 8;
	param->create_conn_param.Initiator_Filter_Policy[0] =HCI_CMD_PARAM_FILTER_POLICY_WHITE_LIST_NOT_USED;
	param->create_conn_param.Peer_Address_Type[0]		=HCI_CMD_PARAM_PUBLIC_DEVICE_ADDRESS;
	memcpy(param->create_conn_param.Peer_Address ,adv_addr,ADDR_LENGTH );
	param->create_conn_param.Own_Address_Type[0]		=HCI_CMD_PARAM_PUBLIC_DEVICE_ADDRESS;
	param->create_conn_param.Conn_Interval_Min[0]		=HCI_CMD_PARAM_CONN_INT_MAX& 0x00ff; //HCI_CMD_PARAM_CONN_INT_MIN & 0x00ff;
	param->create_conn_param.Conn_Interval_Min[1]		=(HCI_CMD_PARAM_CONN_INT_MAX & 0xff00)	>> 8;//(HCI_CMD_PARAM_CONN_INT_MIN & 0xff00)  >> 8;
	param->create_conn_param.Conn_Interval_Max[0]		=HCI_CMD_PARAM_CONN_INT_MAX & 0x00ff;
	param->create_conn_param.Conn_Interval_Max[1]		=(HCI_CMD_PARAM_CONN_INT_MAX & 0xff00)	>> 8;
	param->create_conn_param.Conn_Latency[0]		=HCI_CMD_PARAM_CONN_LATENCY_MIN;//HCI_CMD_PARAM_CONN_LATENCY_MAX & 0x00ff;
	param->create_conn_param.Conn_Latency[1]		=HCI_CMD_PARAM_CONN_LATENCY_MIN;//(HCI_CMD_PARAM_CONN_LATENCY_MAX & 0xff00)  >> 8;
	//The Supervision_Timeout in milliseconds shall be larger than the Conn_Interval_Max in milliseconds.
	//superviision TO > (1+connSlaveLatency)*Conninterval
	param->create_conn_param.Supervision_Timeout[0] 	=HCI_CMD_PARAM_SUPERVISION_TO_MAX& 0x00ff;
	param->create_conn_param.Supervision_Timeout[1] 	=(HCI_CMD_PARAM_SUPERVISION_TO_MAX & 0xff00)  >> 8;
	param->create_conn_param.Minimum_CE_Length[0]		=HCI_CMD_PARAM_CE_LENGTH_MIN& 0x00ff;
	param->create_conn_param.Minimum_CE_Length[1]		=(HCI_CMD_PARAM_CE_LENGTH_MIN& 0xff00)	>> 8;
	param->create_conn_param.Maximum_CE_Length[0]		=HCI_CMD_PARAM_CE_LENGHT_MAX& 0x00ff;
	param->create_conn_param.Maximum_CE_Length[1]		=(HCI_CMD_PARAM_CE_LENGHT_MAX& 0xff00)	>> 8;

	bt_hci_cmd_le_create_connection.parameter_tbl[0].value =param->create_conn_param.LE_Scan_Interval;
	bt_hci_cmd_le_create_connection.parameter_tbl[1].value =param->create_conn_param.LE_Scan_Window;
	bt_hci_cmd_le_create_connection.parameter_tbl[2].value =param->create_conn_param.Initiator_Filter_Policy;
	bt_hci_cmd_le_create_connection.parameter_tbl[3].value =param->create_conn_param.Peer_Address_Type;
	bt_hci_cmd_le_create_connection.parameter_tbl[4].value =param->create_conn_param.Peer_Address;
	bt_hci_cmd_le_create_connection.parameter_tbl[5].value =param->create_conn_param.Own_Address_Type;
	bt_hci_cmd_le_create_connection.parameter_tbl[6].value =param->create_conn_param.Conn_Interval_Min;
	bt_hci_cmd_le_create_connection.parameter_tbl[7].value =param->create_conn_param.Conn_Interval_Max;
	bt_hci_cmd_le_create_connection.parameter_tbl[8].value =param->create_conn_param.Conn_Latency;
	bt_hci_cmd_le_create_connection.parameter_tbl[9].value =param->create_conn_param.Supervision_Timeout;
	bt_hci_cmd_le_create_connection.parameter_tbl[10].value =param->create_conn_param.Minimum_CE_Length;
	bt_hci_cmd_le_create_connection.parameter_tbl[11].value =param->create_conn_param.Maximum_CE_Length;
#endif
}


verdict COMM_INI_Initiating(u8 dut_fd ,Pattern_param param)
{
	u8 buf[SOCKET_BUF_SIZE];
	u16 len;
	u8 ret;

    PRINT_TIME ;
	//HCI_WRITECMD_AND_GETEVENT_PARSING(bt_hci_cmd_le_create_connection);
	ret=bt_hci_write_cmd2socket(dut_fd, &bt_hci_cmd_le_create_connection);
	if(SOCKET_SUCCESS != ret)
		return FAIL;
    do{ 
        ret=socket_msg_get(dut_fd,&len,buf);
    }while(len <=0);

	printf("Get Event(%d):\n",dut_fd);
	print_charray(len,buf);
    
	if(SOCKET_SUCCESS != ret){	
		return FAIL;	
	}

    ret = hci_event_command_status_parsing(buf);
    
	if (CMD_SUCCESS == ret) {
        printf("command status (success)\n\n");
    }    
	else{        
        printf("command status (failed 0x%x)\n\n" , ret);
        return ret;
    }
	return PASS;
}

//
verdict COMM_Set_Event_Mask(u8 dut_fd ,Pattern_param * param)
{
	u8 buf[SOCKET_BUF_SIZE];
	u16 len;
	u8 ret;

    param->Event_Mask[0]                    =   0x90;
    param->Event_Mask[1]                    =   0x88;
    param->Event_Mask[2]                    =   0x00;
    param->Event_Mask[3]                    =   0x02;
    param->Event_Mask[4]                    =   0x00;
    param->Event_Mask[5]                    =   0x80;
    param->Event_Mask[6]                    =   0x00;
    param->Event_Mask[7]                    =   0x20;

	bt_hci_cmd_set_event_mask.parameter_tbl[0].value =	 param->Event_Mask;

	HCI_WRITECMD_AND_GETEVENT_PARSING(bt_hci_cmd_set_event_mask);

	return PASS;
}

verdict COMM_Le_Set_Event_Mask(u8 dut_fd , Pattern_param * param)
{
	u8 buf[SOCKET_BUF_SIZE];
	u16 len;
	u8 ret;

	param->LE_Event_Mask[0] 				=	HCI_CMD_PARAM_LE_EVENT_MASK_DEFAULT;
	bt_hci_cmd_le_set_event_mask.parameter_tbl[0].value =param->LE_Event_Mask;

	HCI_WRITECMD_AND_GETEVENT_PARSING(bt_hci_cmd_le_set_event_mask);
	return PASS;
}

verdict COMM_Dut_clean_buffer(u8 dut_fd)
{
 	u8 ret;
	HCI_WRITECMD(bt_hci_cmd_dut_clean_buff);

    MSLEEP(10);
	return PASS;
}

verdict COMM_Dut_check_payload(u8 dut_fd , u8 val)
{
    u8 enable[1];
	u8 ret;

    enable[0] = val ;

	bt_hci_cmd_dut_check_payload.parameter_tbl[0].value = enable;            //enable
	HCI_WRITECMD(bt_hci_cmd_dut_check_payload);
    
    MSLEEP(10);
	return PASS;
}

#define ADV_IND_NUM_IDX   0
#define ADV_IND_NUM_WIDTH 2
#define SCN_RSP_NUM_IDX   ADV_IND_NUM_IDX + ADV_IND_NUM_WIDTH
#define SCN_RSP_WIDTH_IDX 2

verdict COMM_Dut_check_adv_rpt_num(u8 dut_fd , u32 *adv_ind , u32 *scn_rsp)
{
	u8 buf[SOCKET_BUF_SIZE];
	u16 len;
	u32 ret;

	HCI_WRITECMD(bt_hci_cmd_dut_query_adv_cnt);

    do{
        socket_msg_get(dut_fd,&len,buf);
    }while(len <=0);
    
	print_charray(len,buf);

    if (adv_ind){
	    *adv_ind =((buf[ADV_IND_NUM_IDX+1]) << 8)+ buf[ADV_IND_NUM_IDX];
    }

    if (scn_rsp){
	    *scn_rsp =((buf[SCN_RSP_NUM_IDX+1]) << 8)+ buf[SCN_RSP_NUM_IDX];
    }
    
    
	return PASS;
}

verdict COMM_Dut_check_num_of_packets_num(u8 dut_fd , u32 *num)
{
	u8 buf[SOCKET_BUF_SIZE];
	u16 len;
	u32 ret;

	HCI_WRITECMD(bt_hci_cmd_dut_query_num_of_packets_cnt);

    do{
        socket_msg_get(dut_fd, &len, buf);
    }while(len <=0);
    
	print_charray(len, buf);

    if (num){
	    *num =((buf[1]) << 8) + buf[0];
    }

	return PASS;
}

verdict COMM_Dut_check_data_buffer_overflow_num(u8 dut_fd , u32 *num)
{
	u8 buf[SOCKET_BUF_SIZE];
	u16 len;
	u32 ret;

	HCI_WRITECMD(bt_hci_cmd_dut_query_data_buffer_overflow_cnt);

    do{
        socket_msg_get(dut_fd, &len, buf);
    }while(len <=0);
    
	print_charray(len, buf);

    if (num){
	    *num =((buf[1]) << 8) + buf[0];
    }

	return PASS;
}

verdict COMM_Dut_check_rx_acl_packets_cnt(u8 dut_fd , u32 *cnt)
{
	u8 buf[SOCKET_BUF_SIZE];
	u16 len;
	u32 ret;

	HCI_WRITECMD(bt_hci_cmd_dut_query_rx_acl_packets_cnt);

    do{
        socket_msg_get(dut_fd, &len, buf);
    }while(len <=0);
    
	print_charray(len, buf);

    if (cnt){
	    *cnt =((buf[1]) << 8) + buf[0];
    }

	return PASS;
}

verdict COMM_Reset(u8 dut_fd)
{
	u8 buf[SOCKET_BUF_SIZE];
	u16 len;
	u8 ret;
	HCI_WRITECMD_AND_GETEVENT_PARSING(bt_hci_cmd_reset);

    MSLEEP(10);
	return PASS;
}

verdict SSV_Ble_init(u8 dut_fd)
{
	u8 buf[SOCKET_BUF_SIZE];
	u16 len;
	u8 ret;
    
	HCI_WRITECMD_AND_GETEVENT_PARSING(bt_hci_cmd_ssv_ble_init);

	return PASS;
}

verdict SSV_Slave_subrate(u8 dut_fd)
{
	u8 buf[SOCKET_BUF_SIZE];
	u16 len;
	u8 ret;
    
    u8 enable[1];
    u8 min_tx_latency[1];

    enable[0]           =   1;
    min_tx_latency[0]   =   0; // # if 0 , sleep
    
	bt_hci_cmd_ssv_slave_subrate.parameter_tbl[0].value = enable;            //enable
	bt_hci_cmd_ssv_slave_subrate.parameter_tbl[1].value = min_tx_latency;    //tx latency = 0

	HCI_WRITECMD_AND_GETEVENT_PARSING(bt_hci_cmd_ssv_slave_subrate);

	return PASS;
}

verdict SSV_Set_adv_channel_priority(u8 dut_fd , ADVERTISING_CHANNEL_PRIORITY adv_ch_priority)
{
	u8 buf[SOCKET_BUF_SIZE];
	u16 len;
	u8 ret;
    
    u8 priority[1];

    priority[0]           =   adv_ch_priority;
    
	bt_hci_cmd_ssv_set_advertising_channel_priority.parameter_tbl[0].value = priority;            //enable

	HCI_WRITECMD_AND_GETEVENT_PARSING(bt_hci_cmd_ssv_set_advertising_channel_priority);

	return PASS;
}

verdict SSV_acl_evt_to_external_host(u8 dut_fd)
{
	u8 buf[SOCKET_BUF_SIZE];
	u16 len;
	u8 ret;
    
	HCI_WRITECMD_AND_GETEVENT_PARSING(bt_hci_cmd_ssv_acl_evt_to_external_host);

	return PASS;
}

void COMM_SCN_Parameters_Set_Config (u8 DUT ,Pattern_param * param)
{
    printf("scan type %x\n" ,           param->scn_param.LE_Scan_Type[0]);
    printf("scan interval %x %x\n" ,    param->scn_param.LE_Scan_Interval[1] ,param->scn_param.LE_Scan_Interval[0]);
    printf("scan window %x %x\n" ,      param->scn_param.LE_Scan_Window[1], param->scn_param.LE_Scan_Window[0]);
    printf("own addr type %x\n" ,       param->scn_param.Own_Address_Type[0]);
    printf("scan filter %x\n" ,         param->scn_param.Scanning_Filter_Policy[0]);

	bt_hci_cmd_le_set_scan_parameters.parameter_tbl[0].value =	param->scn_param.LE_Scan_Type;
	bt_hci_cmd_le_set_scan_parameters.parameter_tbl[1].value =	param->scn_param.LE_Scan_Interval;
	bt_hci_cmd_le_set_scan_parameters.parameter_tbl[2].value =	param->scn_param.LE_Scan_Window;
	bt_hci_cmd_le_set_scan_parameters.parameter_tbl[3].value =	param->scn_param.Own_Address_Type;
	bt_hci_cmd_le_set_scan_parameters.parameter_tbl[4].value =	param->scn_param.Scanning_Filter_Policy;

}


int COMM_SCN_Parameters_Set (u8 dut_fd ,Pattern_param param)
{
	u8 buf[SOCKET_BUF_SIZE];
	u16 len;
	u8 status;

	bt_hci_write_cmd2socket(dut_fd, &bt_hci_cmd_le_set_scan_parameters);

    do{
        socket_msg_get(dut_fd,&len,buf);
    }while(len <=0);
	status=buf[_BT_HCI_W_EVENT_HEADER_+_BT_HCI_IDX_EVENT_PARAMETER_];
	//print_charray(len,buf);
	bt_hci_event_parsing(buf[_BT_HCI_IDX_EVENT_CODE_],
						buf[_BT_HCI_IDX_EVENT_LENGTH_],
						buf+_BT_HCI_IDX_EVENT_PARAMETER_);

	printf("Status =%d\n" , status);
	if( 0 != status)
	{
		printf("%s FAILED\n" , __FUNCTION__);
		return status;
	}
	return 0;
}


verdict COMM_SCN_Passive_Scanning_Config (u8 DUT ,Pattern_param * param)
{

	param->scn_param.LE_Scan_Type[0]		=	HCI_CMD_PARAM_PASSIVE_SCAN;
	//if scan_interval = scan_windows , ll should scan continuously P.65
	param->scn_param.LE_Scan_Interval[0]	=	HCI_CMD_PARAM_SCAN_INT_MAX & 0x00ff ;
	param->scn_param.LE_Scan_Interval[1]	=  (HCI_CMD_PARAM_SCAN_INT_MAX & 0xff00) >> 8;
	param->scn_param.LE_Scan_Window[0]		=	HCI_CMD_PARAM_SCAN_WIN_MAX & 0x00ff ;
	param->scn_param.LE_Scan_Window[1]		=  (HCI_CMD_PARAM_SCAN_WIN_MAX & 0xff00) >> 8;
	param->scn_param.Own_Address_Type[0]	=	HCI_CMD_PARAM_PUBLIC_DEVICE_ADDRESS;
	param->scn_param.Scanning_Filter_Policy[0] =	HCI_CMD_PARAM_ACCEPT_ALL_ADV_PKTS;

	bt_hci_cmd_le_set_scan_parameters.parameter_tbl[0].value =param->scn_param.LE_Scan_Type;
	bt_hci_cmd_le_set_scan_parameters.parameter_tbl[1].value =param->scn_param.LE_Scan_Interval;
	bt_hci_cmd_le_set_scan_parameters.parameter_tbl[2].value =param->scn_param.LE_Scan_Window;
	bt_hci_cmd_le_set_scan_parameters.parameter_tbl[3].value =param->scn_param.Own_Address_Type;
	bt_hci_cmd_le_set_scan_parameters.parameter_tbl[4].value =param->scn_param.Scanning_Filter_Policy;

	param->Scan_Enable[0] = HCI_CMD_PARAM_SCAN_ENABLE;
	param->Filter_Duplicates[0] = HCI_CMD_PARAM_FILTER_DUPLICATES_DISABLE;

	bt_hci_cmd_le_set_scan_enable.parameter_tbl[0].value = param->Scan_Enable;
	bt_hci_cmd_le_set_scan_enable.parameter_tbl[1].value = param->Filter_Duplicates;
	return PASS;

}


verdict COMM_SCN_Passive_Scanning(u8 dut_fd ,Pattern_param param)
{
	u8 buf[SOCKET_BUF_SIZE];
	u16 len;
	u8 ret;

	HCI_WRITECMD_AND_GETEVENT_PARSING(bt_hci_cmd_le_set_scan_parameters);
	HCI_WRITECMD_AND_GETEVENT_PARSING(bt_hci_cmd_le_set_scan_enable);

	return PASS;

}

void COMM_SCN_Active_Scanning_Config (u8 DUT ,Pattern_param * param)
{

	param->scn_param.LE_Scan_Type[0]		=	    HCI_CMD_PARAM_ACTIVE_SCAN;
	param->scn_param.LE_Scan_Interval[0]	=	    HCI_CMD_PARAM_SCAN_INT_MAX & 0x00ff ;
	param->scn_param.LE_Scan_Interval[1]	=	   (HCI_CMD_PARAM_SCAN_INT_MAX & 0xff00) >> 8;
	param->scn_param.LE_Scan_Window[0]	=	        HCI_CMD_PARAM_SCAN_WIN_MAX & 0x00ff ;
	param->scn_param.LE_Scan_Window[1]	=	       (HCI_CMD_PARAM_SCAN_WIN_MAX & 0xff00) >> 8;
	param->scn_param.Own_Address_Type[0]	=	    HCI_CMD_PARAM_PUBLIC_DEVICE_ADDRESS;
	param->scn_param.Scanning_Filter_Policy[0] =	HCI_CMD_PARAM_ACCEPT_ALL_ADV_PKTS;

	bt_hci_cmd_le_set_scan_parameters.parameter_tbl[0].value =	param->scn_param.LE_Scan_Type;
	bt_hci_cmd_le_set_scan_parameters.parameter_tbl[1].value =	param->scn_param.LE_Scan_Interval;
	bt_hci_cmd_le_set_scan_parameters.parameter_tbl[2].value =	param->scn_param.LE_Scan_Window;
	bt_hci_cmd_le_set_scan_parameters.parameter_tbl[3].value =	param->scn_param.Own_Address_Type;
	bt_hci_cmd_le_set_scan_parameters.parameter_tbl[4].value =	param->scn_param.Scanning_Filter_Policy;

	param->Scan_Enable[0] = HCI_CMD_PARAM_SCAN_ENABLE;
	param->Filter_Duplicates[0] = HCI_CMD_PARAM_FILTER_DUPLICATES_DISABLE;


	bt_hci_cmd_le_set_scan_enable.parameter_tbl[0].value =		param->Scan_Enable;
	bt_hci_cmd_le_set_scan_enable.parameter_tbl[1].value =		param->Filter_Duplicates;


}


int COMM_SCN_Active_Scanning(u8 dut_fd ,Pattern_param param)
{
	u8 buf[SOCKET_BUF_SIZE];
	u16 len;
	u8 ret;

	HCI_WRITECMD_AND_GETEVENT_PARSING(bt_hci_cmd_le_set_scan_parameters);
	HCI_WRITECMD_AND_GETEVENT_PARSING(bt_hci_cmd_le_set_scan_enable);

	return PASS;
}

void COMM_SCN_Disable_Config (u8 DUT ,Pattern_param * param)
{
	param->Scan_Enable[0] = HCI_CMD_PARAM_SCAN_DISABLE;
	param->Filter_Duplicates[0] =HCI_CMD_PARAM_FILTER_DUPLICATES_DISABLE;

	bt_hci_cmd_le_set_scan_enable.parameter_tbl[0].value =param->Scan_Enable;
	bt_hci_cmd_le_set_scan_enable.parameter_tbl[1].value =param->Filter_Duplicates;
}

void COMM_SCN_Enable_Config (u8 DUT ,Pattern_param * param)
{
	param->Scan_Enable[0] = HCI_CMD_PARAM_SCAN_ENABLE;
	param->Filter_Duplicates[0] =HCI_CMD_PARAM_FILTER_DUPLICATES_DISABLE;
	bt_hci_cmd_le_set_scan_enable.parameter_tbl[0].value =param->Scan_Enable;
	bt_hci_cmd_le_set_scan_enable.parameter_tbl[1].value =param->Filter_Duplicates;
}


int COMM_SCN_Enable(u8 dut_fd ,Pattern_param param)
{
	u8 buf[SOCKET_BUF_SIZE];
	u16 len;
	u8 ret;
	HCI_WRITECMD_AND_GETEVENT_PARSING(bt_hci_cmd_le_set_scan_enable);
	return PASS;
}


int COMM_SCN_Disable(u8 dut_fd ,Pattern_param param)
{
	u8 buf[SOCKET_BUF_SIZE];
	u16 len;
	u8 ret;

	HCI_WRITECMD_AND_GETEVENT_PARSING(bt_hci_cmd_le_set_scan_enable);
	return PASS;
}

void COMM_ADV_Disable_Config (u8 DUT ,Pattern_param * param)
{
	param->Advertising_Enable[0] = HCI_CMD_PARAM_ADV_DISABLE;
	bt_hci_cmd_le_set_advertise_enable.parameter_tbl[0].value =param->Advertising_Enable;

}

void COMM_ADV_Enable_Config (u8 DUT ,Pattern_param * param)
{
	param->Advertising_Enable[0] = HCI_CMD_PARAM_ADV_ENABLE;
	bt_hci_cmd_le_set_advertise_enable.parameter_tbl[0].value =param->Advertising_Enable;

}


int COMM_ADV_Disable(u8 dut_fd ,Pattern_param param)
{
	u8 buf[SOCKET_BUF_SIZE];
	u16 len;
	u8 ret;

	HCI_WRITECMD_AND_GETEVENT_PARSING(bt_hci_cmd_le_set_advertise_enable);

    return ret;
}

int COMM_ADV_Enable(u8 dut_fd ,Pattern_param param)
{
	u8 buf[SOCKET_BUF_SIZE];
	u16 len;
	u8 ret;

	HCI_WRITECMD_AND_GETEVENT_PARSING(bt_hci_cmd_le_set_advertise_enable);

    return ret;
}

static void  COMM_Add_Device_To_White_List_Config(u8 addr_type ,u8 * addr  ,Pattern_param *param)
{
	param->white_list_param.Address_Type[0]	= addr_type;
	memcpy( param->white_list_param.Address	,addr,ADDR_LENGTH);

	bt_hci_cmd_le_add_device_to_white_list.parameter_tbl[0].value = param->white_list_param.Address_Type;
	bt_hci_cmd_le_add_device_to_white_list.parameter_tbl[1].value = param->white_list_param.Address;
}

static void  COMM_Remove_Device_From_White_List_Config(u8 addr_type ,u8 * addr  ,Pattern_param *param)
{
	param->white_list_param.Address_Type[0]	= addr_type;
	memcpy( param->white_list_param.Address	,addr,ADDR_LENGTH);

	bt_hci_cmd_le_remove_device_from_white_list.parameter_tbl[0].value = param->white_list_param.Address_Type;
	bt_hci_cmd_le_remove_device_from_white_list.parameter_tbl[1].value = param->white_list_param.Address;
}

//bt_hci_cmd_le_read_white_list_size


verdict  COMM_Add_Device_To_White_List(u8 dut_fd , Pattern_param param)
{
	  u8 buf[SOCKET_BUF_SIZE];
	  u16 len;
	  u8 ret;

	  HCI_WRITECMD_AND_GETEVENT_PARSING(bt_hci_cmd_le_add_device_to_white_list);

      return ret;
}

verdict  COMM_Remove_Device_From_White_List(u8 dut_fd , Pattern_param param)
{
	  u8 buf[SOCKET_BUF_SIZE];
	  u16 len;
	  u8 ret;

	  HCI_WRITECMD_AND_GETEVENT_PARSING(bt_hci_cmd_le_remove_device_from_white_list);

      return ret;
}


verdict COMM_Clear_White_List(u8 dut_fd)
{
	  u8 buf[SOCKET_BUF_SIZE];
	  u16 len;
	  u8 ret;

	  HCI_WRITECMD_AND_GETEVENT_PARSING(bt_hci_cmd_le_clear_white_list);

      return ret;
}

static void  COMM_INI_Connection_Setup_White_Listed_Config(u8 DUT ,Pattern_param *param)
{
	param->white_list_param.Address_Type[0]	= HCI_CMD_PARAM_PUBLIC_DEVICE_ADDRESS;
	memcpy( param->white_list_param.Address	,scan_addr,ADDR_LENGTH);

	bt_hci_cmd_le_add_device_to_white_list.parameter_tbl[0].value = param->white_list_param.Address_Type;
	bt_hci_cmd_le_add_device_to_white_list.parameter_tbl[1].value = param->white_list_param.Address;
}

verdict  COMM_INI_Connection_Setup_White_Listed(u8 dut_fd , Pattern_param param)
{
	 u8 buf[SOCKET_BUF_SIZE];
	 u16 len;
	 u8 ret;

	 HCI_WRITECMD_AND_GETEVENT_PARSING(bt_hci_cmd_le_clear_white_list);
	 HCI_WRITECMD_AND_GETEVENT_PARSING(bt_hci_cmd_le_add_device_to_white_list);

     return ret;
}

verdict  COMM_Start_Encryption(u8 dut_fd , Pattern_param param)
{
	 u8 buf[SOCKET_BUF_SIZE];
	 u16 len;
	 u8 ret;

	 HCI_WRITECMD_AND_GETEVENT_PARSING_CMD_STATUS(bt_hci_cmd_le_start_encryption);

     return ret;
}

verdict  COMM_Ltk_Req_Rep(u8 dut_fd , Pattern_param param)
{
	 u8 buf[SOCKET_BUF_SIZE];
	 u16 len;
	 u8 ret;

	 HCI_WRITECMD_AND_GETEVENT_PARSING(bt_hci_cmd_le_long_term_key_request_reply);

     return ret;
}

verdict  COMM_Ltk_Req_Negative_Rep(u8 dut_fd , Pattern_param param)
{
	 u8 buf[SOCKET_BUF_SIZE];
	 u16 len;
	 u8 ret;

	 HCI_WRITECMD_AND_GETEVENT_PARSING(bt_hci_cmd_le_long_term_key_request_negative_reply);

     return ret;
}

// 5.2.1.1
verdict DDI_ADV_NonConnectable_Advertising_Events(u8 dut1_fd ,u8 dut2_fd)
{
	u8 buf[SOCKET_BUF_SIZE];	
	int verdict = FAIL;
	int dut1 = 0;
	u16 line;    
    u32 adv_cnt = 0;    
	struct itimerval timer;	  
    u16 time_reduce = 3;
    u16 test_time   = 30;

    COMM_Dut_clean_buffer(dut1_fd);
    COMM_Dut_clean_buffer(dut2_fd);
    
	Calculate_Execution_Time_Start();
	COMM_INI_Connection_Setup_White_Listed_Config(dut1, &g_pattern_param);
	memcpy(g_pattern_param.white_list_param.Address, adv_addr, ADDR_LENGTH);
	verdict = COMM_INI_Connection_Setup_White_Listed(dut1_fd, g_pattern_param);
	VERDICT_RESULT_WITH_LINE();

	// 1.	Configure Lower Tester to monitor advertising packets from the IUT.
	// scan_window = scan_Interval = 0x4000
	COMM_SCN_Passive_Scanning_Config(dut1, &g_pattern_param);	
	g_pattern_param.scn_param.LE_Scan_Interval[0] =  HCI_CMD_PARAM_SCAN_INT_MAX/time_reduce & 0x00ff;
	g_pattern_param.scn_param.LE_Scan_Interval[1] = (HCI_CMD_PARAM_SCAN_INT_MAX/time_reduce & 0xff00) >> 8;
	g_pattern_param.scn_param.LE_Scan_Window[0] =	 HCI_CMD_PARAM_SCAN_WIN_MAX/time_reduce & 0x00ff;
	g_pattern_param.scn_param.LE_Scan_Window[1] =   (HCI_CMD_PARAM_SCAN_WIN_MAX/time_reduce & 0xff00) >> 8;
    
	g_pattern_param.scn_param.Scanning_Filter_Policy[0] =	HCI_CMD_PARAM_IGNORE_ADV_PKTS_FROM_DEV_NOT_IN_WHITE_LIST_ONLY;
	verdict = COMM_SCN_Passive_Scanning(dut1_fd, g_pattern_param);
	VERDICT_RESULT_WITH_LINE();

	// 2.	Upper Tester enables non connectable advertising in the IUT 
	//		using all supported advertising channels and minimum advertising interval
	COMM_ADV_NonConnectable_Advertising_Config(HCI_CMD_PARAM_ADV_DATA_LEN_MAX, &g_pattern_param);
	g_pattern_param.adv_param.Advertising_Filter_Policy[0] = HCI_CMD_PARAM_ALLOW_SCAN_REQ_FROM_WHITELIST_ONLY_AND_CONN_REQ_FROM_WHITELIST_ONLY;
	g_pattern_param.adv_data_param.Advertising_Data_Length[0] = 0x00;
    
	//The timing range detected for advertising events(ADV_NONCONN_IND) is from 100.0 ms to 110.0 ms
	//interval : 160(0x00a0) * 0.625ms = 100ms
	g_pattern_param.adv_param.Advertising_Interval_Max[0] =  HCI_CMD_PARAM_ADVERTISING_INTERVAL_MIN_ADV_SCAN_OR_NONCONN_IND & 0x00ff;
	g_pattern_param.adv_param.Advertising_Interval_Max[1] = (HCI_CMD_PARAM_ADVERTISING_INTERVAL_MIN_ADV_SCAN_OR_NONCONN_IND & 0xff00) >> 8;
	g_pattern_param.adv_param.Advertising_Interval_Min[0] =  HCI_CMD_PARAM_ADVERTISING_INTERVAL_MIN_ADV_SCAN_OR_NONCONN_IND & 0x00ff;
	g_pattern_param.adv_param.Advertising_Interval_Min[1] = (HCI_CMD_PARAM_ADVERTISING_INTERVAL_MIN_ADV_SCAN_OR_NONCONN_IND & 0xff00) >> 8;
	verdict = COMM_ADV_NonConnectable_Advertising(dut2_fd, g_pattern_param);
	VERDICT_RESULT_WITH_LINE();	

	// step 4-5 
	read_le_event_enable();    
    
	while(1) {//waiting adv report event , timer or counter  
		if(1 == read_le_event_get()) {
    		// start the scanning time : 30 sec
    		event_query_timer_config(test_time/time_reduce, 0, 0, 0, &timer);
    		event_query_timer_start(timer, read_le_event_disable);

    		printf("****wait for %d sec****\n" , test_time / time_reduce);

    		while(read_le_event_get()) {

                MSLEEP(10);
                
    			if(SUCCESS != QUERY_LE_Event(dut1_fd,buf,   _BT_HCI_LE_EVENT_SUB_OP_ADVERTISING_REPORT_ , 
                                                            HCI_SUBEVENT_ADV_RPT_EVENT_NONCONN_IND)) {              
    								
    				continue;
    			}			 
    			else if(EQUAL != hci_le_event_advertising_report_parsing(HCI_SUBEVENT_ADV_RPT_EVENT_NONCONN_IND, buf, g_pattern_param))	{
    				continue;
    			}
    			else {
    				adv_cnt++; 
                    printf("adv coming, chk %d\n" , adv_cnt);
    			}
		    }
                
        // the ideal value : 30(s) / 110(ms) = 272
        if (((float)((adv_cnt * 100) / (272/time_reduce))) <= 50) {
            LOG_INFO("[Pattern][%s]FAIL, Counter : %d\n", __FUNCTION__, adv_cnt);
    		LOG_INFO("[Pattern][%s]Ideal value : %d\n", __FUNCTION__, 272/time_reduce);
    		LOG_INFO("[Pattern][%s]Exp   value : %d\n", __FUNCTION__, adv_cnt);
    		LOG_INFO("[Pattern][%s]Ratio value : %.2f %%\n", __FUNCTION__, (float)((adv_cnt * 100) / (272/time_reduce)));            
            line=__LINE__;
			goto FUN_FAIL;
        }
        else {			

            FUNC_END();

            LOG_INFO("[Pattern][%s]SUCCESS, Counter : %d\n", __FUNCTION__, adv_cnt);
		    LOG_INFO("[Pattern][%s]Ideal value : %d\n", __FUNCTION__, 272/time_reduce);
		    LOG_INFO("[Pattern][%s]Exp   value : %d\n", __FUNCTION__, adv_cnt);
		    LOG_INFO("[Pattern][%s]Ratio value : %.2f %%\n", __FUNCTION__, (float)((adv_cnt * 100) / (272/time_reduce)));
        }        

		return PASS;
    	}
    }
	
FUN_FAIL:
    FUNC_END();

	LOG_INFO("[Pattern][%s]:%d FAIL\n", __FUNCTION__, line);
    return FAIL;
}

// 5.2.1.2
verdict DDI_ADV_Undirected_Advertising_Events(u8 dut1_fd, u8 dut2_fd)
{
	u8 buf[SOCKET_BUF_SIZE];	
	int verdict = FAIL;
	int dut1 = 0;
	u16 line = 0;
	struct itimerval timer;	
	u32 adv_cnt = 0;	  
    u16 time_reduce = 3;
    u16 test_time   = 30;

    COMM_Dut_clean_buffer(dut1_fd);
    COMM_Dut_clean_buffer(dut2_fd);
    
    Calculate_Execution_Time_Start();
	COMM_INI_Connection_Setup_White_Listed_Config(dut1, &g_pattern_param);
	memcpy(g_pattern_param.white_list_param.Address, adv_addr, ADDR_LENGTH);
	verdict = COMM_INI_Connection_Setup_White_Listed(dut1_fd, g_pattern_param);
	VERDICT_RESULT_WITH_LINE();

	COMM_SCN_Passive_Scanning_Config(dut1, &g_pattern_param);
	g_pattern_param.scn_param.LE_Scan_Interval[0] =  HCI_CMD_PARAM_SCAN_INT_MAX/time_reduce & 0x00ff;
	g_pattern_param.scn_param.LE_Scan_Interval[1] = (HCI_CMD_PARAM_SCAN_INT_MAX/time_reduce & 0xff00) >> 8;
	g_pattern_param.scn_param.LE_Scan_Window[0] =	 HCI_CMD_PARAM_SCAN_WIN_MAX/time_reduce & 0x00ff;
	g_pattern_param.scn_param.LE_Scan_Window[1] =   (HCI_CMD_PARAM_SCAN_WIN_MAX/time_reduce & 0xff00) >> 8;
	g_pattern_param.scn_param.Scanning_Filter_Policy[0] = HCI_CMD_PARAM_IGNORE_ADV_PKTS_FROM_DEV_NOT_IN_WHITE_LIST_ONLY;
	verdict = COMM_SCN_Passive_Scanning(dut1_fd, g_pattern_param);
	VERDICT_RESULT_WITH_LINE();

	COMM_ADV_Undirected_Advertising_Config(HCI_CMD_PARAM_ADV_DATA_LEN_MAX, &g_pattern_param);
	g_pattern_param.adv_param.Advertising_Filter_Policy[0] = HCI_CMD_PARAM_ALLOW_SCAN_REQ_FROM_WHITELIST_ONLY_AND_CONN_REQ_FROM_WHITELIST_ONLY;
	g_pattern_param.adv_data_param.Advertising_Data_Length[0] = 0x00;
	//The timing range detected for advertising events(ADV_IND) is from 20.0 ms to 30.0 ms
	//interval : 32(0x0020) * 0.625ms = 20ms
	g_pattern_param.adv_param.Advertising_Interval_Max[0] =  HCI_CMD_PARAM_ADVERTISING_INTERVAL_MIN & 0x00ff;
	g_pattern_param.adv_param.Advertising_Interval_Max[1] = (HCI_CMD_PARAM_ADVERTISING_INTERVAL_MIN & 0xff00) >> 8;
	g_pattern_param.adv_param.Advertising_Interval_Min[0] =  HCI_CMD_PARAM_ADVERTISING_INTERVAL_MIN & 0x00ff;
	g_pattern_param.adv_param.Advertising_Interval_Min[1] = (HCI_CMD_PARAM_ADVERTISING_INTERVAL_MIN & 0xff00) >> 8;
	verdict = COMM_ADV_Undirected_Advertising(dut2_fd, g_pattern_param);
	VERDICT_RESULT_WITH_LINE();

	read_le_event_enable();
    
	while(1) {//waiting adv report event , timer or counter  
		if(1 == read_le_event_get()) {
		    // start the scanning time :30 sec
		    event_query_timer_config(test_time/time_reduce, 0, 0, 0, &timer);
		    event_query_timer_start(timer, read_le_event_disable);
            
            printf("****wait for %d sec****\n" , test_time / time_reduce);

		    while(read_le_event_get()) {
                
                MSLEEP(10);
                
			    if(SUCCESS != QUERY_LE_Event(dut1_fd, buf, _BT_HCI_LE_EVENT_SUB_OP_ADVERTISING_REPORT_, HCI_SUBEVENT_ADV_RPT_EVENT_ADV_IND)) {				
				    
				    
				    continue;
			    }
    			else if(EQUAL != hci_le_event_advertising_report_parsing(HCI_SUBEVENT_ADV_RPT_EVENT_ADV_IND, buf,g_pattern_param)) {
    				
    				continue;
    			}
    			else {
    				adv_cnt++; 
                    printf("adv coming, chk %d\n" , adv_cnt);
    			}    					
    		}

            // the ideal value : 30(s) / 30(ms) = 1000
            if (((float)((adv_cnt * 100) / (1000/time_reduce))) <= 50) {
                LOG_INFO("[Pattern][%s]FAIL, Counter : %d\n", __FUNCTION__, adv_cnt);
        		LOG_INFO("[Pattern][%s]Ideal value : %d\n", __FUNCTION__, 1000/time_reduce);
        		LOG_INFO("[Pattern][%s] Exp. value : %d\n", __FUNCTION__, adv_cnt);
        		LOG_INFO("[Pattern][%s]Ratio value : %.2f %%\n", __FUNCTION__, (float)((adv_cnt * 100) / 1000/time_reduce));
                line=__LINE__;
    			goto FUN_FAIL;
            }
            else {

                FUNC_END();
                LOG_INFO("[Pattern][%s]SUCCESS, Counter : %d\n", __FUNCTION__, adv_cnt);
    		    LOG_INFO("[Pattern][%s]Ideal value : %d\n", __FUNCTION__, 1000/time_reduce);
    		    LOG_INFO("[Pattern][%s] Exp. value : %d\n", __FUNCTION__, adv_cnt);
    		    LOG_INFO("[Pattern][%s]Ratio value : %.2f %%\n", __FUNCTION__, (float)((adv_cnt * 100) / 1000/time_reduce));
            }    		

    		return PASS;
		}
    }	
FUN_FAIL:
    FUNC_END();

	LOG_INFO("[Pattern][%s]:%d FAIL\n" ,__FUNCTION__,line);
    return FAIL;

}

// 5.2.1.3
verdict DDI_ADV_Advertising_Data_Non_Connectable(u8 dut1_fd ,u8 dut2_fd)
{
	u8 buf[SOCKET_BUF_SIZE];
	u16 line;
	int verdict = FAIL;
	int dut1 = 0;
	int repeat = 0;
	int i = 0;
	int data1_cnt, data2_cnt, data3_cnt, data4_cnt;
	struct itimerval timer;	
	u16 adv_cnt1 = 0;
	u16 adv_cnt2 = 0;	
    u16 time_reduce = 3;
    u16 test_time   = 30;

    COMM_Dut_clean_buffer(dut1_fd);
    COMM_Dut_clean_buffer(dut2_fd);
        
    Calculate_Execution_Time_Start();       

REPEAT:

    COMM_INI_Connection_Setup_White_Listed_Config(dut1, &g_pattern_param);
	memcpy(g_pattern_param.white_list_param.Address, adv_addr, ADDR_LENGTH);
	verdict=COMM_INI_Connection_Setup_White_Listed(dut1_fd, g_pattern_param);
	VERDICT_RESULT_WITH_LINE();
    
	adv_cnt1 = 0;
	adv_cnt2 = 0;
	repeat++;
	
	COMM_SCN_Passive_Scanning_Config(dut1, &g_pattern_param);
	g_pattern_param.scn_param.LE_Scan_Interval[0] =  HCI_CMD_PARAM_SCAN_INT_MAX/time_reduce & 0x00ff;
	g_pattern_param.scn_param.LE_Scan_Interval[1] = (HCI_CMD_PARAM_SCAN_INT_MAX/time_reduce & 0xff00) >> 8;
	g_pattern_param.scn_param.LE_Scan_Window[0] =	 HCI_CMD_PARAM_SCAN_WIN_MAX/time_reduce & 0x00ff;
	g_pattern_param.scn_param.LE_Scan_Window[1] =   (HCI_CMD_PARAM_SCAN_WIN_MAX/time_reduce & 0xff00) >> 8;
	g_pattern_param.scn_param.Scanning_Filter_Policy[0] =	HCI_CMD_PARAM_IGNORE_ADV_PKTS_FROM_DEV_NOT_IN_WHITE_LIST_ONLY;
	verdict = COMM_SCN_Passive_Scanning(dut1_fd, g_pattern_param);
	VERDICT_RESULT_WITH_LINE();
	
    //The timing range detected for advertising events(ADV_NONCONN_IND) is from 100.0 ms to 110.0 ms
	//interval : 160(0x00a0) * 0.625ms = 100ms
    if (1 == repeat) {
		COMM_ADV_NonConnectable_Advertising_Config(HCI_CMD_PARAM_ADV_DATA_LEN_MAX, &g_pattern_param);
		g_pattern_param.adv_param.Advertising_Interval_Max[0] =  HCI_CMD_PARAM_ADVERTISING_INTERVAL_MIN_ADV_SCAN_OR_NONCONN_IND & 0x00ff;
	    g_pattern_param.adv_param.Advertising_Interval_Max[1] = (HCI_CMD_PARAM_ADVERTISING_INTERVAL_MIN_ADV_SCAN_OR_NONCONN_IND & 0xff00) >> 8;
	    g_pattern_param.adv_param.Advertising_Interval_Min[0] =  HCI_CMD_PARAM_ADVERTISING_INTERVAL_MIN_ADV_SCAN_OR_NONCONN_IND & 0x00ff;
	    g_pattern_param.adv_param.Advertising_Interval_Min[1] = (HCI_CMD_PARAM_ADVERTISING_INTERVAL_MIN_ADV_SCAN_OR_NONCONN_IND & 0xff00) >> 8;
		g_pattern_param.adv_data_param.Advertising_Data_Length[0] = 0x01;
		g_pattern_param.adv_data_param.Advertising_Data[0] = 0x01;
		verdict = COMM_ADV_NonConnectable_Advertising(dut2_fd, g_pattern_param);
		VERDICT_RESULT_WITH_LINE();
	}
	else if(2 == repeat) {
		COMM_ADV_NonConnectable_Advertising_Config(HCI_CMD_PARAM_ADV_DATA_LEN_MAX, &g_pattern_param);
		g_pattern_param.adv_param.Advertising_Interval_Max[0] =  HCI_CMD_PARAM_ADVERTISING_INTERVAL_MIN_ADV_SCAN_OR_NONCONN_IND & 0x00ff;
	    g_pattern_param.adv_param.Advertising_Interval_Max[1] = (HCI_CMD_PARAM_ADVERTISING_INTERVAL_MIN_ADV_SCAN_OR_NONCONN_IND & 0xff00) >> 8;
	    g_pattern_param.adv_param.Advertising_Interval_Min[0] =  HCI_CMD_PARAM_ADVERTISING_INTERVAL_MIN_ADV_SCAN_OR_NONCONN_IND & 0x00ff;
	    g_pattern_param.adv_param.Advertising_Interval_Min[1] = (HCI_CMD_PARAM_ADVERTISING_INTERVAL_MIN_ADV_SCAN_OR_NONCONN_IND & 0xff00) >> 8;
		g_pattern_param.adv_data_param.Advertising_Data_Length[0] = 0x1f;
		g_pattern_param.adv_data_param.Advertising_Data[0] = 0x1f;
		for(i = 1; i < 31; i++) {
			g_pattern_param.adv_data_param.Advertising_Data[i] = 0x00;
		}
		verdict = COMM_ADV_NonConnectable_Advertising(dut2_fd, g_pattern_param);
		VERDICT_RESULT_WITH_LINE();
	}
	else {
		printf("[Pattern][%s]FAIL : ERROR Repeat = %d\n", __FUNCTION__, repeat);
		line = __LINE__;
		goto FUN_FAIL;
	}

	while(1)//waiting adv report event , timer or counter
	{
		read_le_event_enable();
        event_query_timer_config(test_time/time_reduce, 0, 0, 0, &timer);
		event_query_timer_start(timer ,read_le_event_disable);

        printf("****wait for %d sec****\n" , test_time / time_reduce);

		while (read_le_event_get()){

            MSLEEP(50);
            
			if (SUCCESS != QUERY_LE_Event(dut1_fd, buf, _BT_HCI_LE_EVENT_SUB_OP_ADVERTISING_REPORT_, HCI_SUBEVENT_ADV_RPT_EVENT_NONCONN_IND)) {
				continue;				 
			}
			else if(EQUAL != hci_le_event_advertising_report_parsing(HCI_SUBEVENT_ADV_RPT_EVENT_NONCONN_IND, buf, g_pattern_param)) {
				continue;
			}
			else {
				adv_cnt1++ ;
				printf("** Data_1 : check advertising intervals : %d time **\n" , adv_cnt1);					
			}			  
		}
		if(1 == repeat) {
			data1_cnt = adv_cnt1;
		}
		else {
			data3_cnt = adv_cnt1;
		}
        dut_reset_with_mask_en(dut1_fd);
        dut_reset_with_mask_en(dut2_fd);

		break;		  
	}

    sleep(5);

    COMM_INI_Connection_Setup_White_Listed_Config(dut1, &g_pattern_param);
	memcpy(g_pattern_param.white_list_param.Address, adv_addr, ADDR_LENGTH);
	verdict=COMM_INI_Connection_Setup_White_Listed(dut1_fd, g_pattern_param);
	VERDICT_RESULT_WITH_LINE();
	
	//second round
    COMM_SCN_Passive_Scanning_Config(dut1, &g_pattern_param);
	g_pattern_param.scn_param.LE_Scan_Interval[0] =  HCI_CMD_PARAM_SCAN_INT_MAX/time_reduce & 0x00ff;
	g_pattern_param.scn_param.LE_Scan_Interval[1] = (HCI_CMD_PARAM_SCAN_INT_MAX/time_reduce & 0xff00) >> 8;
	g_pattern_param.scn_param.LE_Scan_Window[0] =	 HCI_CMD_PARAM_SCAN_WIN_MAX/time_reduce & 0x00ff;
	g_pattern_param.scn_param.LE_Scan_Window[1] =   (HCI_CMD_PARAM_SCAN_WIN_MAX/time_reduce & 0xff00) >> 8;
	g_pattern_param.scn_param.Scanning_Filter_Policy[0] =	HCI_CMD_PARAM_IGNORE_ADV_PKTS_FROM_DEV_NOT_IN_WHITE_LIST_ONLY;    
	verdict = COMM_SCN_Passive_Scanning(dut1_fd, g_pattern_param);
	VERDICT_RESULT_WITH_LINE();
    
	COMM_ADV_NonConnectable_Advertising_Config(0,&g_pattern_param);
    g_pattern_param.adv_param.Advertising_Interval_Max[0] = 0x00a0 & 0x00ff;
	g_pattern_param.adv_param.Advertising_Interval_Max[1] = (0x00a0 & 0xff00) >> 8;
	g_pattern_param.adv_param.Advertising_Interval_Min[0] = 0x00a0 & 0x00ff;
	g_pattern_param.adv_param.Advertising_Interval_Min[1] = (0x00a0 & 0xff00) >> 8;	
	g_pattern_param.adv_data_param.Advertising_Data_Length[0] = 0x00;
	g_pattern_param.adv_data_param.Advertising_Data[0] = 0x00;
	verdict=COMM_ADV_NonConnectable_Advertising(dut2_fd,g_pattern_param);
	VERDICT_RESULT_WITH_LINE();
    
    //waiting adv report event , timer or counter
	while(1) {
		read_le_event_enable();
		event_query_timer_config(test_time/time_reduce, 0, 0, 0, &timer);
		event_query_timer_start(timer, read_le_event_disable);
        
        printf("****wait for %d sec****\n" , test_time / time_reduce);

		while(read_le_event_get()) {									
            MSLEEP(50);

			if(SUCCESS != QUERY_LE_Event(dut1_fd, buf, _BT_HCI_LE_EVENT_SUB_OP_ADVERTISING_REPORT_, HCI_SUBEVENT_ADV_RPT_EVENT_NONCONN_IND)) {
				continue;
			}
			if(EQUAL != hci_le_event_advertising_report_parsing(HCI_SUBEVENT_ADV_RPT_EVENT_NONCONN_IND,	buf, g_pattern_param)) {
				continue;
			}
			else {
				adv_cnt2++ ;
				printf("** Data_2 : check advertising intervals : %d time **\n" , adv_cnt2);					
			}			  
		} 
        dut_reset_with_mask_en(dut1_fd);
        dut_reset_with_mask_en(dut2_fd);

		if(1 == repeat) {
			data2_cnt = adv_cnt2;
		}
		else {
			data4_cnt = adv_cnt2;
		}
		break;

	}
	
	if(repeat != 2)	{
		printf("[Pattern][%s]REPEAT\n", __FUNCTION__);
		goto REPEAT;
	}
	else {
        if ((((float)((data1_cnt * 100) / (272/time_reduce))) <= 50) || (((float)((data2_cnt * 100) / (272/time_reduce))) <= 50) ||
             (((float)((data3_cnt * 100) / (272/time_reduce))) <= 50) || (((float)((data4_cnt * 100) / (272/time_reduce))) <= 50)) {

            line = __LINE__;
			goto FUN_FAIL;
        }
        else {			

            FUNC_END();

            LOG_INFO("[Pattern][%s]SUCCESS\n", __FUNCTION__);
		    LOG_INFO("Ideal Value : %d\n", 272/time_reduce);
    		LOG_INFO("Data1(0x01) : %d, Ratio : %.2f %%\n", data1_cnt, (float)((data1_cnt * 100) / (272/time_reduce)));
            LOG_INFO("Data1(0x00) : %d, Ratio : %.2f %%\n", data2_cnt, (float)((data2_cnt * 100) / (272/time_reduce)));
            LOG_INFO("Data1(0x1f) : %d, Ratio : %.2f %%\n", data3_cnt, (float)((data3_cnt * 100) / (272/time_reduce)));
            LOG_INFO("Data1(0x00) : %d, Ratio : %.2f %%\n", data4_cnt, (float)((data4_cnt * 100) / (272/time_reduce)));  
            return PASS;
        }		
	}
FUN_FAIL:
    FUNC_END();

	LOG_INFO("[Pattern][%s]:%d FAIL\n" ,__FUNCTION__, line);
    LOG_INFO("Ideal Value : %d\n", 272);
    LOG_INFO("Data1(0x01) : %d, Ratio : %.2f %%\n", data1_cnt, (float)((data1_cnt * 100) / 272));
    LOG_INFO("Data1(0x00) : %d, Ratio : %.2f %%\n", data2_cnt, (float)((data2_cnt * 100) / 272));
    LOG_INFO("Data1(0x1f) : %d, Ratio : %.2f %%\n", data3_cnt, (float)((data3_cnt * 100) / 272));
    LOG_INFO("Data1(0x00) : %d, Ratio : %.2f %%\n", data4_cnt, (float)((data4_cnt * 100) / 272));

    return FAIL;
}


// 5.2.1.4
verdict DDI_ADV_Advertising_Data_Undirected(u8 dut1_fd ,u8 dut2_fd)
{
	u8 buf[SOCKET_BUF_SIZE];
	u16 line;
	int verdict = FAIL;
	int dut1 = 0;
	int repeat = 0;
	int i = 0;
	int data1_cnt, data2_cnt, data3_cnt, data4_cnt;
	struct itimerval timer;	
	u16 adv_cnt1 = 0;
	u16 adv_cnt2 = 0;
    u16 time_reduce = 3;
    u16 test_time = 30;

    COMM_Dut_clean_buffer(dut1_fd);
    COMM_Dut_clean_buffer(dut2_fd);

    Calculate_Execution_Time_Start();

REPEAT:

	COMM_INI_Connection_Setup_White_Listed_Config(dut1, &g_pattern_param);
	memcpy(g_pattern_param.white_list_param.Address, adv_addr, ADDR_LENGTH);
	verdict = COMM_INI_Connection_Setup_White_Listed(dut1_fd, g_pattern_param);
	VERDICT_RESULT_WITH_LINE();    

	adv_cnt1 = 0;
	adv_cnt2 = 0;
	repeat++;

    COMM_SCN_Passive_Scanning_Config(dut1, &g_pattern_param);
	g_pattern_param.scn_param.LE_Scan_Interval[0] =  HCI_CMD_PARAM_SCAN_INT_MAX/time_reduce & 0x00ff;
	g_pattern_param.scn_param.LE_Scan_Interval[1] = ((HCI_CMD_PARAM_SCAN_INT_MAX/time_reduce) & 0xff00) >> 8;
	g_pattern_param.scn_param.LE_Scan_Window[0] =	 HCI_CMD_PARAM_SCAN_WIN_MAX/time_reduce & 0x00ff;
	g_pattern_param.scn_param.LE_Scan_Window[1] =   ((HCI_CMD_PARAM_SCAN_WIN_MAX/time_reduce) & 0xff00) >> 8;
	g_pattern_param.scn_param.Scanning_Filter_Policy[0] = HCI_CMD_PARAM_IGNORE_ADV_PKTS_FROM_DEV_NOT_IN_WHITE_LIST_ONLY;
	verdict = COMM_SCN_Passive_Scanning(dut1_fd, g_pattern_param);
	VERDICT_RESULT_WITH_LINE();

    //The timing range detected for advertising events(ADV_IND) is from 20.0 ms to 30.0 ms
	//interval : 32(0x0020) * 0.625ms = 20ms
	if (1 == repeat) {
		COMM_ADV_Undirected_Advertising_Config(HCI_CMD_PARAM_ADV_DATA_LEN_MAX, &g_pattern_param);
		g_pattern_param.adv_param.Advertising_Interval_Max[0] = HCI_CMD_PARAM_ADVERTISING_INTERVAL_MIN & 0x00ff;
		g_pattern_param.adv_param.Advertising_Interval_Max[1] = (HCI_CMD_PARAM_ADVERTISING_INTERVAL_MIN & 0xff00) >> 8;
		g_pattern_param.adv_param.Advertising_Interval_Min[0] = HCI_CMD_PARAM_ADVERTISING_INTERVAL_MIN & 0x00ff;
		g_pattern_param.adv_param.Advertising_Interval_Min[1] = (HCI_CMD_PARAM_ADVERTISING_INTERVAL_MIN & 0xff00) >> 8;
		g_pattern_param.adv_data_param.Advertising_Data_Length[0] = 0x01;
		g_pattern_param.adv_data_param.Advertising_Data[0]      = 0x01;
		verdict = COMM_ADV_Undirected_Advertising(dut2_fd, g_pattern_param);
		VERDICT_RESULT_WITH_LINE();
	}
	else if(2 == repeat) {
		COMM_ADV_Undirected_Advertising_Config(HCI_CMD_PARAM_ADV_DATA_LEN_MAX, &g_pattern_param);
		g_pattern_param.adv_param.Advertising_Interval_Max[0] = HCI_CMD_PARAM_ADVERTISING_INTERVAL_MIN & 0x00ff;
		g_pattern_param.adv_param.Advertising_Interval_Max[1] = (HCI_CMD_PARAM_ADVERTISING_INTERVAL_MIN & 0xff00) >> 8;
		g_pattern_param.adv_param.Advertising_Interval_Min[0] = HCI_CMD_PARAM_ADVERTISING_INTERVAL_MIN & 0x00ff;
		g_pattern_param.adv_param.Advertising_Interval_Min[1] = (HCI_CMD_PARAM_ADVERTISING_INTERVAL_MIN & 0xff00) >> 8;
		g_pattern_param.adv_data_param.Advertising_Data_Length[0] = 0x1f;
		for(i = 1; i < 31; i++) {
			g_pattern_param.adv_data_param.Advertising_Data[i]  = 0x00;
		}
		g_pattern_param.adv_data_param.Advertising_Data[0]      = 0x01f;
		verdict = COMM_ADV_Undirected_Advertising(dut2_fd, g_pattern_param);
		VERDICT_RESULT_WITH_LINE();
	}
	else {
		printf("[Pattern][%s]FAIL : ERROR Repeat\n", __FUNCTION__);
		line = __LINE__;
		goto FUN_FAIL;
	}

	//waiting adv report event , timer or counter
	while(1) {
		read_le_event_enable();
		event_query_timer_config(test_time/time_reduce, 0, 0, 0, &timer);
		event_query_timer_start(timer, read_le_event_disable);
        printf("****wait for %d sec****\n" , test_time / time_reduce);

		while (read_le_event_get()){							

            MSLEEP(10);

			if (SUCCESS != QUERY_LE_Event(dut1_fd, buf, _BT_HCI_LE_EVENT_SUB_OP_ADVERTISING_REPORT_, HCI_SUBEVENT_ADV_RPT_EVENT_ADV_IND)) {
				continue;
				
				
			}			 
			else if(EQUAL != hci_le_event_advertising_report_parsing(HCI_SUBEVENT_ADV_RPT_EVENT_ADV_IND, buf, g_pattern_param)) {
				continue;
			}
			else {
				adv_cnt1++ ;
				printf("** Data_1 : check advertising intervals : %d time **\n", adv_cnt1);
			}
			 
	    } 
        dut_reset_with_mask_en(dut1_fd);
        dut_reset_with_mask_en(dut2_fd);

		if(1 == repeat) {
			data1_cnt = adv_cnt1;
		}
		else {
			data3_cnt = adv_cnt1;
		}
		break;
	}


    COMM_INI_Connection_Setup_White_Listed_Config(dut1, &g_pattern_param);
    memcpy(g_pattern_param.white_list_param.Address, adv_addr, ADDR_LENGTH);
    verdict = COMM_INI_Connection_Setup_White_Listed(dut1_fd, g_pattern_param);
    VERDICT_RESULT_WITH_LINE();        

//second round
    COMM_SCN_Passive_Scanning_Config(dut1, &g_pattern_param);
	g_pattern_param.scn_param.LE_Scan_Interval[0] =  (HCI_CMD_PARAM_SCAN_INT_MAX/time_reduce) & 0x00ff;
	g_pattern_param.scn_param.LE_Scan_Interval[1] = ((HCI_CMD_PARAM_SCAN_INT_MAX/time_reduce) & 0xff00) >> 8;
	g_pattern_param.scn_param.LE_Scan_Window[0] =	 (HCI_CMD_PARAM_SCAN_WIN_MAX/time_reduce) & 0x00ff;
	g_pattern_param.scn_param.LE_Scan_Window[1] =   ((HCI_CMD_PARAM_SCAN_WIN_MAX/time_reduce) & 0xff00) >> 8;
	g_pattern_param.scn_param.Scanning_Filter_Policy[0] = HCI_CMD_PARAM_IGNORE_ADV_PKTS_FROM_DEV_NOT_IN_WHITE_LIST_ONLY;
	verdict = COMM_SCN_Passive_Scanning(dut1_fd, g_pattern_param);
	VERDICT_RESULT_WITH_LINE();

	COMM_ADV_Undirected_Advertising_Config(0, &g_pattern_param);
	g_pattern_param.adv_param.Advertising_Interval_Max[0] =  HCI_CMD_PARAM_ADVERTISING_INTERVAL_MIN & 0x00ff;
	g_pattern_param.adv_param.Advertising_Interval_Max[1] = (HCI_CMD_PARAM_ADVERTISING_INTERVAL_MIN & 0xff00) >> 8;
	g_pattern_param.adv_param.Advertising_Interval_Min[0] =  HCI_CMD_PARAM_ADVERTISING_INTERVAL_MIN & 0x00ff;
	g_pattern_param.adv_param.Advertising_Interval_Min[1] = (HCI_CMD_PARAM_ADVERTISING_INTERVAL_MIN & 0xff00) >> 8;
	g_pattern_param.adv_data_param.Advertising_Data_Length[0]   = 0x00;	 
	g_pattern_param.adv_data_param.Advertising_Data[0]          = 0x00;
	verdict = COMM_ADV_Undirected_Advertising(dut2_fd, g_pattern_param);
	VERDICT_RESULT_WITH_LINE();

    //waiting adv report event , timer or counter
	while(1) {
		read_le_event_enable();
		event_query_timer_config(test_time / time_reduce, 0, 0, 0, &timer);
		event_query_timer_start(timer, read_le_event_disable);
        printf("****wait for %d sec****\n" , test_time / time_reduce);

		while(read_le_event_get()){

            MSLEEP(10);

			if(SUCCESS != QUERY_LE_Event(dut1_fd, buf, _BT_HCI_LE_EVENT_SUB_OP_ADVERTISING_REPORT_, HCI_SUBEVENT_ADV_RPT_EVENT_ADV_IND)) {
				continue;				 
			}
			else if(EQUAL != hci_le_event_advertising_report_parsing(HCI_SUBEVENT_ADV_RPT_EVENT_ADV_IND, buf, g_pattern_param)) {
				continue;
			}
			else {
				adv_cnt2++ ;
				printf("** Data_2 : check advertising intervals : %d time **\n", adv_cnt2);					
			}			  
	    }
        dut_reset_with_mask_en(dut1_fd);
        dut_reset_with_mask_en(dut2_fd);

		if(1 == repeat) {
			data2_cnt = adv_cnt2;
		}
		else {
			data4_cnt = adv_cnt2;
		}
		break;	 
	}
	
	if(repeat != 2) {
		printf("[Pattern][%s]REPEAT\n", __FUNCTION__);
		goto REPEAT;
	}
	else {		
        if ((((float)((data1_cnt * 100) / (1000/time_reduce))) <= 50) || (((float)((data2_cnt * 100) / (1000/time_reduce))) <= 50) ||
             (((float)((data3_cnt * 100) / (1000/time_reduce))) <= 50) || (((float)((data4_cnt * 100) / (1000/time_reduce))) <= 50)) {
            line = __LINE__;
			goto FUN_FAIL;
        }
        else {			

            FUNC_END();

            LOG_INFO("[Pattern][%s]SUCCESS\n", __FUNCTION__);
		    LOG_INFO("Ideal Value : %d\n", 1000/time_reduce);
    		LOG_INFO("Data1(0x01) : %d, Ratio : %.2f %%\n", data1_cnt, (float)((data1_cnt * 100) / (1000/time_reduce)));
            LOG_INFO("Data1(0x00) : %d, Ratio : %.2f %%\n", data2_cnt, (float)((data2_cnt * 100) / (1000/time_reduce)));
            LOG_INFO("Data1(0x1f) : %d, Ratio : %.2f %%\n", data3_cnt, (float)((data3_cnt * 100) / (1000/time_reduce)));
            LOG_INFO("Data1(0x00) : %d, Ratio : %.2f %%\n", data4_cnt, (float)((data4_cnt * 100) / (1000/time_reduce)));  
            return PASS;
        }
	}
FUN_FAIL:
    FUNC_END();

	LOG_INFO("[Pattern][%s]:%d FAIL\n" ,__FUNCTION__,line);

    LOG_INFO("Ideal Value : %d\n", 1000/time_reduce);
    LOG_INFO("Data1(0x01) : %d, Ratio : %.2f %%\n", data1_cnt, (float)((data1_cnt * 100) / (1000/time_reduce)));
    LOG_INFO("Data1(0x00) : %d, Ratio : %.2f %%\n", data2_cnt, (float)((data2_cnt * 100) / (1000/time_reduce)));
    LOG_INFO("Data1(0x1f) : %d, Ratio : %.2f %%\n", data3_cnt, (float)((data3_cnt * 100) / (1000/time_reduce)));
    LOG_INFO("Data1(0x00) : %d, Ratio : %.2f %%\n", data4_cnt, (float)((data4_cnt * 100) / (1000/time_reduce)));

    return FAIL;

}


// 5.2.1.5
verdict DDI_ADV_Scan_Request_Undirected_Connectable(u8 dut1_fd ,u8 dut2_fd)
{  
    u8 buf[SOCKET_BUF_SIZE];
    int verdict = FAIL;
    int dut1 = 0;
    int line;
    struct itimerval timer;
    int query_time = 15;

    u32 ch = 36; // default
    u32 adv_cnt_37 = 0;
    u32 adv_cnt_38 = 0;
    u32 adv_cnt_39 = 0;

    u32 scn_rsp_37 = 0;
    u32 scn_rsp_38 = 0;
    u32 scn_rsp_39 = 0;   

    COMM_Dut_clean_buffer(dut1_fd);
    COMM_Dut_clean_buffer(dut2_fd);

    Calculate_Execution_Time_Start();    

LOOP1: //case 1 ,policy = 0 , scn_rsp len =0 ;
    ch ++ ;
    
    COMM_INI_Connection_Setup_White_Listed_Config(dut1, &g_pattern_param);
	memcpy(g_pattern_param.white_list_param.Address, adv_addr, ADDR_LENGTH);
	verdict=COMM_INI_Connection_Setup_White_Listed(dut1_fd, g_pattern_param);
	VERDICT_RESULT_WITH_LINE();
    
    // # p1 : Upper Tester sends an HCI_LE_Set_Scan_Response_Data(using device name length of 0 as response data).  
    COMM_Scan_Response_Data_Set_Config(dut2_fd , 0, &g_pattern_param);
    verdict = COMM_Scan_Response_Data_Set(dut2_fd, g_pattern_param);
    VERDICT_RESULT_WITH_LINE();

    // # p2 : Configure Lower Tester to monitor the advertising and scan response packets of the IUT    
    COMM_SCN_Active_Scanning_Config(dut1, &g_pattern_param);
    g_pattern_param.scn_param.Own_Address_Type[0] = HCI_CMD_PARAM_PUBLIC_DEVICE_ADDRESS;             
    g_pattern_param.scn_param.LE_Scan_Interval[0] =  0x00A0 & 0x00ff;
    g_pattern_param.scn_param.LE_Scan_Interval[1] = (0x00A0 & 0xff00) >> 8;
    g_pattern_param.scn_param.LE_Scan_Window[0] =    0x00A0 & 0x00ff;
    g_pattern_param.scn_param.LE_Scan_Window[1] =   (0x00A0 & 0xff00) >> 8;
	g_pattern_param.scn_param.Scanning_Filter_Policy[0] =	HCI_CMD_PARAM_IGNORE_ADV_PKTS_FROM_DEV_NOT_IN_WHITE_LIST_ONLY;

    verdict = COMM_SCN_Active_Scanning(dut1_fd, g_pattern_param);
    VERDICT_RESULT_WITH_LINE();

    // # p3 : Upper Tester enables undirected advertising in the IUT using all 
    // supported advertising channels, minimum advertising intervals and filtering policy 
    //set to Allow Scan Request from Any, Allow Connect Request from Any (Default) (0x00)'. 
    COMM_ADV_Undirected_Advertising_Config(31, &g_pattern_param);    
    if (ch == 37){
        g_pattern_param.adv_param.Advertising_Channel_Map[0] = HCI_CMD_PARAM_ENABLE_CHANNEL_37;
    }    
    else if (ch == 38){
        g_pattern_param.adv_param.Advertising_Channel_Map[0] = HCI_CMD_PARAM_ENABLE_CHANNEL_38;
    }    
    else if (ch == 39){
        g_pattern_param.adv_param.Advertising_Channel_Map[0] = HCI_CMD_PARAM_ENABLE_CHANNEL_39;
    }        
    g_pattern_param.adv_param.Advertising_Filter_Policy[0] = HCI_CMD_PARAM_ALLOW_SCAN_REQ_AND_CONN_REQ_FROM_ANY;
    g_pattern_param.adv_param.Advertising_Interval_Max[0] =  HCI_CMD_PARAM_ADVERTISING_INTERVAL_MIN & 0x00ff;
    g_pattern_param.adv_param.Advertising_Interval_Max[1] = (HCI_CMD_PARAM_ADVERTISING_INTERVAL_MIN & 0xff00) >> 8;
    g_pattern_param.adv_param.Advertising_Interval_Min[0] =  HCI_CMD_PARAM_ADVERTISING_INTERVAL_MIN & 0x00ff;
    g_pattern_param.adv_param.Advertising_Interval_Min[1] = (HCI_CMD_PARAM_ADVERTISING_INTERVAL_MIN & 0xff00) >> 8;
    verdict = COMM_ADV_Undirected_Advertising(dut2_fd, g_pattern_param);
    VERDICT_RESULT_WITH_LINE();

    read_le_event_enable();
        
    while(1) {//waiting adv report event , timer or counter  
        if(1 == read_le_event_get()) {
            event_query_timer_config(query_time, 0, 0, 0, &timer);
            event_query_timer_start(timer, read_le_event_disable);
            
            while(read_le_event_get()) {
                // # p4 :Lower Tester sends a SCAN_REQ packet on the selected advertising channel 
                //after receiving an ADV_DISCOVER_IND packet from IUT on the advertising 
                //channel configured in Step 3. The SCAN_REQ is sent T_IFS after the end of an 
                //ADV_IND packet. 
                MSLEEP(10);
               
                if(SUCCESS != QUERY_LE_Event(dut1_fd, buf, _BT_HCI_LE_EVENT_SUB_OP_ADVERTISING_REPORT_, HCI_SUBEVENT_ADV_RPT_EVENT_ADV_IND)) {               
                    
                    
                    continue;
                } 
                else if(EQUAL != hci_le_event_advertising_report_parsing(HCI_CMD_PARAM_ADV_IND, buf, g_pattern_param)) {
                    printf("****parsing ADV non EQUAL**** LOOP1\n");
                    continue;
                }
                else {

                    if (ch == 37){
                        adv_cnt_37++; 
                    }
                    
                    if (ch == 38){
                        adv_cnt_38++; 
                    }
                    
                    if (ch == 39){
                        adv_cnt_39++; 
                    }                    

                    printf("****LOOP 1 adv ch %d | adv cnt %d %d %d ****\n" ,ch , adv_cnt_37 , adv_cnt_38 , adv_cnt_39);

                }

                // # p5 : Lower Tester expects a SCAN_RSP packet from the IUT T_IFS after the end of the SCAN_REQ packet.  
                if (SUCCESS != QUERY_LE_Event(dut1_fd, buf, _BT_HCI_LE_EVENT_SUB_OP_ADVERTISING_REPORT_, HCI_SUBEVENT_ADV_RPT_EVENT_SCAN_RSP)) {
                    continue;
                    
                    
                }            
                else if(EQUAL != hci_le_event_advertising_report_parsing(HCI_SUBEVENT_ADV_RPT_EVENT_SCAN_RSP, buf, g_pattern_param)) {
                    printf("****parsing SCN non EQUAL**** LOOP1\n");
                    continue;
                }
                else {
                    if (ch == 37){
                        scn_rsp_37++; 
                    }
                    
                    if (ch == 38){
                        scn_rsp_38++; 
                    }
                    
                    if (ch == 39){
                        scn_rsp_39++; 
                    }                    
                    
                    printf("****parsing SCN EQUAL**** %d %d %d %d\n" , ch ,scn_rsp_37 ,scn_rsp_38 ,scn_rsp_39);

                }
 
            }

            dut_reset_with_mask_en(dut1_fd);
            dut_reset_with_mask_en(dut2_fd);


            if(ch != 39){
                goto LOOP1;
            }

            // # p6 Repeat steps 4-5 30 times. 
            if((adv_cnt_37 < 30) || (adv_cnt_38 < 30) || (adv_cnt_39 < 30) || 
               (scn_rsp_37 < 30) || (scn_rsp_38 < 30) || (scn_rsp_39 < 30) ) {
                line = __LINE__;
                goto FUN_FAIL;
            }   

            break;
        }
    }

    ch = 36; // default
    adv_cnt_37 = 0;
    adv_cnt_38 = 0;
    adv_cnt_39 = 0;

    scn_rsp_37 = 0;
    scn_rsp_38 = 0;
    scn_rsp_39 = 0;

LOOP2: //case 2 ,policy = 1 , scn_rsp len =0 ;
    ch ++ ;
    
    COMM_INI_Connection_Setup_White_Listed_Config(dut1, &g_pattern_param);
	memcpy(g_pattern_param.white_list_param.Address, adv_addr, ADDR_LENGTH);
	verdict=COMM_INI_Connection_Setup_White_Listed(dut1_fd, g_pattern_param);
	VERDICT_RESULT_WITH_LINE();
    
    // # p1 : Upper Tester sends an HCI_LE_Set_Scan_Response_Data.  
    COMM_Scan_Response_Data_Set_Config(dut2_fd, 0, &g_pattern_param);
    verdict = COMM_Scan_Response_Data_Set(dut2_fd, g_pattern_param);
    VERDICT_RESULT_WITH_LINE();

    // # p2 : Configure Lower Tester to monitor the advertising and scan response packets of the IUT    
    COMM_SCN_Active_Scanning_Config(dut1, &g_pattern_param);
    g_pattern_param.scn_param.Own_Address_Type[0] = HCI_CMD_PARAM_PUBLIC_DEVICE_ADDRESS;             
    g_pattern_param.scn_param.LE_Scan_Interval[0] =  0x0500 & 0x00ff;
    g_pattern_param.scn_param.LE_Scan_Interval[1] = (0x0500 & 0xff00) >> 8;
    g_pattern_param.scn_param.LE_Scan_Window[0] =    0x0500 & 0x00ff;
    g_pattern_param.scn_param.LE_Scan_Window[1] =   (0x0500 & 0xff00) >> 8;
	g_pattern_param.scn_param.Scanning_Filter_Policy[0] =	HCI_CMD_PARAM_IGNORE_ADV_PKTS_FROM_DEV_NOT_IN_WHITE_LIST_ONLY;    
    verdict = COMM_SCN_Active_Scanning(dut1_fd, g_pattern_param);
    VERDICT_RESULT_WITH_LINE();

    // # p3 : Upper Tester enables discoverable undirected advertising in the IUT using all 
    // supported advertising channels, minimum advertising intervals and filtering policy 
    //set to Allow Scan Request from White List, Allow Connect Request from Any (0x01)'. 
    COMM_ADV_Undirected_Advertising_Config(0, &g_pattern_param);    
    if (ch == 37){
        g_pattern_param.adv_param.Advertising_Channel_Map[0] = HCI_CMD_PARAM_ENABLE_CHANNEL_37;
    }    
    else if (ch == 38){
        g_pattern_param.adv_param.Advertising_Channel_Map[0] = HCI_CMD_PARAM_ENABLE_CHANNEL_38;
    }    
    else if (ch == 39){
        g_pattern_param.adv_param.Advertising_Channel_Map[0] = HCI_CMD_PARAM_ENABLE_CHANNEL_39;
    }        
    g_pattern_param.adv_param.Advertising_Filter_Policy[0] = HCI_CMD_PARAM_ALLOW_SCAN_REQ_FROM_WHITELIST_ONLY_AND_CONN_REQ_FROM_ANY;
    g_pattern_param.adv_param.Advertising_Interval_Max[0] =  HCI_CMD_PARAM_ADVERTISING_INTERVAL_MIN & 0x00ff;
    g_pattern_param.adv_param.Advertising_Interval_Max[1] = (HCI_CMD_PARAM_ADVERTISING_INTERVAL_MIN & 0xff00) >> 8;
    g_pattern_param.adv_param.Advertising_Interval_Min[0] =  HCI_CMD_PARAM_ADVERTISING_INTERVAL_MIN & 0x00ff;
    g_pattern_param.adv_param.Advertising_Interval_Min[1] = (HCI_CMD_PARAM_ADVERTISING_INTERVAL_MIN & 0xff00) >> 8;
    verdict = COMM_ADV_Undirected_Advertising(dut2_fd, g_pattern_param);
    VERDICT_RESULT_WITH_LINE();

    read_le_event_enable();

    while(1) {//waiting adv report event , timer or counter  
        if(1 == read_le_event_get()) {
        // start the scanning time :30 sec
            event_query_timer_config(query_time, 0, 0, 0, &timer);
            event_query_timer_start(timer, read_le_event_disable);
            
            while(read_le_event_get()) {
                // # p4 :Lower Tester sends a SCAN_REQ packet on the selected advertising channel 
                //after receiving an ADV_DISCOVER_IND packet from IUT on the advertising 
                //channel configured in Step 3. The SCAN_REQ is sent T_IFS after the end of an 
                //ADV_IND packet. 

                MSLEEP(10);
                
                if(SUCCESS != QUERY_LE_Event(dut1_fd, buf, _BT_HCI_LE_EVENT_SUB_OP_ADVERTISING_REPORT_, HCI_SUBEVENT_ADV_RPT_EVENT_ADV_IND)) {
                    continue;
                } 
                else if(EQUAL != hci_le_event_advertising_report_parsing(HCI_CMD_PARAM_ADV_IND, buf,g_pattern_param)) {
                    printf("****parsing ADV non EQUAL**** LOOP2\n");
                    continue;
                }
                else {

                    if (ch == 37){
                        adv_cnt_37++; 
                    }
                    
                    if (ch == 38){
                        adv_cnt_38++; 
                    }
                    
                    if (ch == 39){
                        adv_cnt_39++; 
                    }                    

                    printf("****LOOP 2 adv ch %d | adv cnt %d %d %d ****\n" ,ch , adv_cnt_37 , adv_cnt_38 , adv_cnt_39);

                }

                // # p5 : Lower Tester expects a SCAN_RSP packet from the IUT T_IFS after the end of the SCAN_REQ packet.  
                if(SUCCESS != QUERY_LE_Event(dut1_fd, buf, _BT_HCI_LE_EVENT_SUB_OP_ADVERTISING_REPORT_, HCI_SUBEVENT_ADV_RPT_EVENT_SCAN_RSP)) {
                    continue;
                }            
                else if(EQUAL != hci_le_event_advertising_report_parsing(HCI_SUBEVENT_ADV_RPT_EVENT_SCAN_RSP, buf, g_pattern_param)) {
                    printf("****parsing SCN non EQUAL**** LOOP2\n");
                    continue;
                }
                else {
                    if (ch == 37){
                        scn_rsp_37++; 
                    }
                    
                    if (ch == 38){
                        scn_rsp_38++; 
                    }
                    
                    if (ch == 39){
                        scn_rsp_39++; 
                    }                    
                   
                    printf("****parsing SCN EQUAL**** %d %d %d %d\n" , ch ,scn_rsp_37 ,scn_rsp_38 ,scn_rsp_39);
                }
 
            }

            dut_reset_with_mask_en(dut1_fd);
            dut_reset_with_mask_en(dut2_fd);


            if(ch != 39){
                goto LOOP2;
            }

            // # p6 Repeat steps 4-5 30 times. 
            if((adv_cnt_37 < 30) || (adv_cnt_38 < 30) || (adv_cnt_39 < 30) || 
               (scn_rsp_37 > 0) || (scn_rsp_38 > 0) || (scn_rsp_39 > 0) ){
                line = __LINE__;
                goto FUN_FAIL;
            }   

            break;
        }
    }

    ch = 36; // default
    adv_cnt_37 = 0;
    adv_cnt_38 = 0;
    adv_cnt_39 = 0;

    scn_rsp_37 = 0;
    scn_rsp_38 = 0;
    scn_rsp_39 = 0;

LOOP3: //policy = 0 , scan data = 31
    ch ++ ;

    COMM_INI_Connection_Setup_White_Listed_Config(dut1, &g_pattern_param);
	memcpy(g_pattern_param.white_list_param.Address, adv_addr, ADDR_LENGTH);
	verdict=COMM_INI_Connection_Setup_White_Listed(dut1_fd, g_pattern_param);
	VERDICT_RESULT_WITH_LINE();
    
    // # p1 : Upper Tester sends an HCI_LE_Set_Scan_Response_Data.  
    COMM_Scan_Response_Data_Set_Config(dut2_fd, 31, &g_pattern_param);
    verdict = COMM_Scan_Response_Data_Set(dut2_fd, g_pattern_param);
    VERDICT_RESULT_WITH_LINE();

    // # p2 : Configure Lower Tester to monitor the advertising and scan response packets of the IUT    
    COMM_SCN_Active_Scanning_Config(dut1, &g_pattern_param);
    g_pattern_param.scn_param.Own_Address_Type[0] = HCI_CMD_PARAM_PUBLIC_DEVICE_ADDRESS;             
    g_pattern_param.scn_param.LE_Scan_Interval[0] =  0x0500 & 0x00ff;
    g_pattern_param.scn_param.LE_Scan_Interval[1] = (0x0500 & 0xff00) >> 8;
    g_pattern_param.scn_param.LE_Scan_Window[0] =    0x0500 & 0x00ff;
    g_pattern_param.scn_param.LE_Scan_Window[1] =   (0x0500 & 0xff00) >> 8;
	g_pattern_param.scn_param.Scanning_Filter_Policy[0] =	HCI_CMD_PARAM_IGNORE_ADV_PKTS_FROM_DEV_NOT_IN_WHITE_LIST_ONLY;
    verdict = COMM_SCN_Active_Scanning(dut1_fd, g_pattern_param);
    VERDICT_RESULT_WITH_LINE();

    // # p3 : Upper Tester enables discoverable undirected advertising in the IUT using all 
    // supported advertising channels, minimum advertising intervals and filtering policy 
    //set to Allow Scan Request from Any, Allow Connect Request from Any (Default) (0x00)'. 
    COMM_ADV_Undirected_Advertising_Config(0, &g_pattern_param);

    if (ch == 37){
        g_pattern_param.adv_param.Advertising_Channel_Map[0] = HCI_CMD_PARAM_ENABLE_CHANNEL_37;
    }    
    else if (ch == 38){
        g_pattern_param.adv_param.Advertising_Channel_Map[0] = HCI_CMD_PARAM_ENABLE_CHANNEL_38;
    }    
    else if (ch == 39){
        g_pattern_param.adv_param.Advertising_Channel_Map[0] = HCI_CMD_PARAM_ENABLE_CHANNEL_39;
    }
    
    g_pattern_param.adv_param.Advertising_Filter_Policy[0] = HCI_CMD_PARAM_ALLOW_SCAN_REQ_AND_CONN_REQ_FROM_ANY;
    g_pattern_param.adv_param.Advertising_Interval_Max[0] =  HCI_CMD_PARAM_ADVERTISING_INTERVAL_MIN & 0x00ff;
    g_pattern_param.adv_param.Advertising_Interval_Max[1] = (HCI_CMD_PARAM_ADVERTISING_INTERVAL_MIN & 0xff00) >> 8;
    g_pattern_param.adv_param.Advertising_Interval_Min[0] =  HCI_CMD_PARAM_ADVERTISING_INTERVAL_MIN & 0x00ff;
    g_pattern_param.adv_param.Advertising_Interval_Min[1] = (HCI_CMD_PARAM_ADVERTISING_INTERVAL_MIN & 0xff00) >> 8;
    verdict = COMM_ADV_Undirected_Advertising(dut2_fd, g_pattern_param);
    VERDICT_RESULT_WITH_LINE();

    read_le_event_enable();
    
    while(1) {//waiting adv report event , timer or counter  
        if(1 == read_le_event_get()) {
            event_query_timer_config(query_time, 0, 0, 0, &timer);
            event_query_timer_start(timer, read_le_event_disable);
            
            while(read_le_event_get()) {
                // # p4 :Lower Tester sends a SCAN_REQ packet on the selected advertising channel 
                //after receiving an ADV_DISCOVER_IND packet from IUT on the advertising 
                //channel configured in Step 3. The SCAN_REQ is sent T_IFS after the end of an 
                //ADV_IND packet. 

                MSLEEP(10);
                
                if(SUCCESS != QUERY_LE_Event(dut1_fd, buf, _BT_HCI_LE_EVENT_SUB_OP_ADVERTISING_REPORT_, HCI_SUBEVENT_ADV_RPT_EVENT_ADV_IND)) {
                    continue;
                } 
                else if(EQUAL != hci_le_event_advertising_report_parsing(HCI_CMD_PARAM_ADV_IND, buf,g_pattern_param)) {
                    printf("****parsing ADV non EQUAL**** LOOP3\n");
                    continue;
                }
                else {
                    if (ch == 37){
                        adv_cnt_37++; 
                    }
                    
                    if (ch == 38){
                        adv_cnt_38++; 
                    }
                    
                    if (ch == 39){
                        adv_cnt_39++; 
                    }                    

                    printf("****LOOP 3 adv ch %d | adv cnt %d %d %d ****\n" ,ch , adv_cnt_37 , adv_cnt_38 , adv_cnt_39);
                }

                // # p5 : Lower Tester expects a SCAN_RSP packet from the IUT T_IFS after the end of the SCAN_REQ packet.  
                if (SUCCESS != QUERY_LE_Event(dut1_fd, buf, _BT_HCI_LE_EVENT_SUB_OP_ADVERTISING_REPORT_, HCI_SUBEVENT_ADV_RPT_EVENT_SCAN_RSP)) {
                    continue;
                }            
                else if(EQUAL != hci_le_event_advertising_report_parsing(HCI_SUBEVENT_ADV_RPT_EVENT_SCAN_RSP, buf, g_pattern_param)) {
                    printf("****parsing SCN non EQUAL**** LOOP3\n");
                    continue;
                }
                else {
                    if (ch == 37){
                        scn_rsp_37++; 
                    }
                    
                    if (ch == 38){
                        scn_rsp_38++; 
                    }
                    
                    if (ch == 39){
                        scn_rsp_39++; 
                    }                    

                    printf("****parsing SCN EQUAL**** %d %d %d %d\n" , ch ,scn_rsp_37 ,scn_rsp_38 ,scn_rsp_39);

                }
 
            }

            dut_reset_with_mask_en(dut1_fd);
            dut_reset_with_mask_en(dut2_fd);

            if(ch != 39){
                goto LOOP3;
            }

            // # p6 Repeat steps 4-5 30 times. 
            if((adv_cnt_37 < 30) || (adv_cnt_38 < 30) || (adv_cnt_39 < 30) || 
               (scn_rsp_37 < 30) || (scn_rsp_38 < 30) || (scn_rsp_39 < 30) ){
                line = __LINE__;
                goto FUN_FAIL;
            }   

            break;
        }
    }

    ch = 36; // default
    adv_cnt_37 = 0;
    adv_cnt_38 = 0;
    adv_cnt_39 = 0;

    scn_rsp_37 = 0;
    scn_rsp_38 = 0;
    scn_rsp_39 = 0;
    
LOOP4: //policy = 1 , scan data = 31
    ch ++ ;

    COMM_INI_Connection_Setup_White_Listed_Config(dut1, &g_pattern_param);
	memcpy(g_pattern_param.white_list_param.Address, adv_addr, ADDR_LENGTH);
	verdict=COMM_INI_Connection_Setup_White_Listed(dut1_fd, g_pattern_param);
	VERDICT_RESULT_WITH_LINE();

    // # p1 : Upper Tester sends an HCI_LE_Set_Scan_Response_Data.  
    COMM_Scan_Response_Data_Set_Config(dut2_fd, 31, &g_pattern_param);
    verdict = COMM_Scan_Response_Data_Set(dut2_fd, g_pattern_param);
    VERDICT_RESULT_WITH_LINE();

    // # p2 : Configure Lower Tester to monitor the advertising and scan response packets of the IUT    
    COMM_SCN_Active_Scanning_Config(dut1, &g_pattern_param);
    g_pattern_param.scn_param.Own_Address_Type[0] = HCI_CMD_PARAM_PUBLIC_DEVICE_ADDRESS;             
    g_pattern_param.scn_param.LE_Scan_Interval[0] =  0x0500 & 0x00ff;
    g_pattern_param.scn_param.LE_Scan_Interval[1] = (0x0500 & 0xff00) >> 8;
    g_pattern_param.scn_param.LE_Scan_Window[0] =    0x0500 & 0x00ff;
    g_pattern_param.scn_param.LE_Scan_Window[1] =   (0x0500 & 0xff00) >> 8;
	g_pattern_param.scn_param.Scanning_Filter_Policy[0] =	HCI_CMD_PARAM_IGNORE_ADV_PKTS_FROM_DEV_NOT_IN_WHITE_LIST_ONLY;
    verdict = COMM_SCN_Active_Scanning(dut1_fd, g_pattern_param);
    VERDICT_RESULT_WITH_LINE();

    // # p3 : Upper Tester enables discoverable undirected advertising in the IUT using all 
    // supported advertising channels, minimum advertising intervals and filtering policy 
    //set to Allow Scan Request from Any, Allow Connect Request from Any (Default) (0x00)'. 
    COMM_ADV_Undirected_Advertising_Config(0, &g_pattern_param);    
    if (ch == 37){
        g_pattern_param.adv_param.Advertising_Channel_Map[0] = HCI_CMD_PARAM_ENABLE_CHANNEL_37;
    }    
    else if (ch == 38){
        g_pattern_param.adv_param.Advertising_Channel_Map[0] = HCI_CMD_PARAM_ENABLE_CHANNEL_38;
    }    
    else if (ch == 39){
        g_pattern_param.adv_param.Advertising_Channel_Map[0] = HCI_CMD_PARAM_ENABLE_CHANNEL_39;
    }
    
    g_pattern_param.adv_param.Advertising_Filter_Policy[0] = HCI_CMD_PARAM_ALLOW_SCAN_REQ_FROM_WHITELIST_ONLY_AND_CONN_REQ_FROM_ANY;
    g_pattern_param.adv_param.Advertising_Interval_Max[0] =  HCI_CMD_PARAM_ADVERTISING_INTERVAL_MIN & 0x00ff;
    g_pattern_param.adv_param.Advertising_Interval_Max[1] = (HCI_CMD_PARAM_ADVERTISING_INTERVAL_MIN & 0xff00) >> 8;
    g_pattern_param.adv_param.Advertising_Interval_Min[0] =  HCI_CMD_PARAM_ADVERTISING_INTERVAL_MIN & 0x00ff;
    g_pattern_param.adv_param.Advertising_Interval_Min[1] = (HCI_CMD_PARAM_ADVERTISING_INTERVAL_MIN & 0xff00) >> 8;
    verdict = COMM_ADV_Undirected_Advertising(dut2_fd, g_pattern_param);
    VERDICT_RESULT_WITH_LINE();

    read_le_event_enable();
   
    while(1) {//waiting adv report event , timer or counter  
        if(1 == read_le_event_get()) {
        // start the scanning time :30 sec
            event_query_timer_config(query_time, 0, 0, 0, &timer);
            event_query_timer_start(timer, read_le_event_disable);
            
            while(read_le_event_get()) {
                // # p4 :Lower Tester sends a SCAN_REQ packet on the selected advertising channel 
                //after receiving an ADV_IND packet from IUT on the advertising 
                //channel configured in Step 3. The SCAN_REQ is sent T_IFS after the end of an 
                //ADV_IND packet. 

                MSLEEP(10);
                
                if(SUCCESS != QUERY_LE_Event(dut1_fd, buf, _BT_HCI_LE_EVENT_SUB_OP_ADVERTISING_REPORT_, HCI_SUBEVENT_ADV_RPT_EVENT_ADV_IND)) {
                    continue;
                } 
                else if(EQUAL != hci_le_event_advertising_report_parsing(HCI_CMD_PARAM_ADV_IND, buf,g_pattern_param)) {
                    printf("****parsing ADV non EQUAL**** LOOP4\n");
                    continue;
                }
                else {
                    if (ch == 37){
                        adv_cnt_37++; 
                    }
                    
                    if (ch == 38){
                        adv_cnt_38++; 
                    }
                    
                    if (ch == 39){
                        adv_cnt_39++; 
                    }                    

                    printf("****LOOP 4 adv ch %d | adv cnt %d %d %d ****\n" ,ch , adv_cnt_37 , adv_cnt_38 , adv_cnt_39);

                }

                // # p5 : Lower Tester expects a SCAN_RSP packet from the IUT T_IFS after the end of the SCAN_REQ packet.  
                if (SUCCESS != QUERY_LE_Event(dut1_fd, buf, _BT_HCI_LE_EVENT_SUB_OP_ADVERTISING_REPORT_, HCI_SUBEVENT_ADV_RPT_EVENT_SCAN_RSP)) {
                    continue;
                }            
                else if(EQUAL != hci_le_event_advertising_report_parsing(HCI_SUBEVENT_ADV_RPT_EVENT_SCAN_RSP, buf, g_pattern_param)) {
                    printf("****parsing SCN non EQUAL**** LOOP4\n");
                    continue;
                }
                else {
                    if (ch == 37){
                        scn_rsp_37++; 
                    }
                    
                    if (ch == 38){
                        scn_rsp_38++; 
                    }
                    
                    if (ch == 39){
                        scn_rsp_39++; 
                    }                    
                    
                    printf("****parsing SCN EQUAL**** %d %d %d %d\n" , ch ,scn_rsp_37 ,scn_rsp_38 ,scn_rsp_39);
                }
 
            }

            dut_reset_with_mask_en(dut1_fd);
            dut_reset_with_mask_en(dut2_fd);


            if(ch != 39){
                goto LOOP4;
            }

            // # p6 Repeat steps 4-5 30 times. 
            if((adv_cnt_37 < 30) || (adv_cnt_38 < 30) || (adv_cnt_39 < 30) || 
                (scn_rsp_37 > 0) || (scn_rsp_38 > 0) || (scn_rsp_39 > 0) ){
                line = __LINE__;
                goto FUN_FAIL;
            }    

            break;
        }
    }

    ch = 36; // default
    adv_cnt_37 = 0;
    adv_cnt_38 = 0;
    adv_cnt_39 = 0;

    scn_rsp_37 = 0;
    scn_rsp_38 = 0;
    scn_rsp_39 = 0;
        
LOOP5: //policy = 0 , dev_addr =diff comp id ,scan data = 0     
    ch ++ ;

    COMM_Static_Random_Device_Address_Set_Config(scan_random_addr);
    COMM_Device_Address_Set(dut1_fd, g_pattern_param);

    COMM_INI_Connection_Setup_White_Listed_Config(dut1, &g_pattern_param);
	memcpy(g_pattern_param.white_list_param.Address, adv_addr, ADDR_LENGTH);
	verdict=COMM_INI_Connection_Setup_White_Listed(dut1_fd, g_pattern_param);
	VERDICT_RESULT_WITH_LINE();
    
    // # p1 : Upper Tester sends an HCI_LE_Set_Scan_Response_Data.  
    COMM_Scan_Response_Data_Set_Config(dut2_fd , 0, &g_pattern_param);
    verdict = COMM_Scan_Response_Data_Set(dut2_fd, g_pattern_param);
    VERDICT_RESULT_WITH_LINE();

    // # p2 : Configure Lower Tester to monitor the advertising and scan response packets of the IUT    
    COMM_SCN_Active_Scanning_Config(dut1, &g_pattern_param);
    g_pattern_param.scn_param.Own_Address_Type[0] = HCI_CMD_PARAM_RANDOM_DEVICE_ADDRESS;             
    g_pattern_param.scn_param.LE_Scan_Interval[0] =  0x0500 & 0x00ff;
    g_pattern_param.scn_param.LE_Scan_Interval[1] = (0x0500 & 0xff00) >> 8;
    g_pattern_param.scn_param.LE_Scan_Window[0] =    0x0500 & 0x00ff;
    g_pattern_param.scn_param.LE_Scan_Window[1] =   (0x0500 & 0xff00) >> 8;
	g_pattern_param.scn_param.Scanning_Filter_Policy[0] =	HCI_CMD_PARAM_IGNORE_ADV_PKTS_FROM_DEV_NOT_IN_WHITE_LIST_ONLY;

    verdict = COMM_SCN_Active_Scanning(dut1_fd, g_pattern_param);
    VERDICT_RESULT_WITH_LINE();

    // # p3 : Upper Tester enables discoverable undirected advertising in the IUT using all 
    // supported advertising channels, minimum advertising intervals and filtering policy 
    //set to Allow Scan Request from Any, Allow Connect Request from Any (Default) (0x00)'. 
    COMM_ADV_Undirected_Advertising_Config(0, &g_pattern_param);

    if (ch == 37){
        g_pattern_param.adv_param.Advertising_Channel_Map[0] = HCI_CMD_PARAM_ENABLE_CHANNEL_37;
    }    
    else if (ch == 38){
        g_pattern_param.adv_param.Advertising_Channel_Map[0] = HCI_CMD_PARAM_ENABLE_CHANNEL_38;
    }    
    else if (ch == 39){
        g_pattern_param.adv_param.Advertising_Channel_Map[0] = HCI_CMD_PARAM_ENABLE_CHANNEL_39;
    }
    
    g_pattern_param.adv_param.Advertising_Filter_Policy[0] = HCI_CMD_PARAM_ALLOW_SCAN_REQ_AND_CONN_REQ_FROM_ANY;
    g_pattern_param.adv_param.Advertising_Interval_Max[0] =  HCI_CMD_PARAM_ADVERTISING_INTERVAL_MIN & 0x00ff;
    g_pattern_param.adv_param.Advertising_Interval_Max[1] = (HCI_CMD_PARAM_ADVERTISING_INTERVAL_MIN & 0xff00) >> 8;
    g_pattern_param.adv_param.Advertising_Interval_Min[0] =  HCI_CMD_PARAM_ADVERTISING_INTERVAL_MIN & 0x00ff;
    g_pattern_param.adv_param.Advertising_Interval_Min[1] = (HCI_CMD_PARAM_ADVERTISING_INTERVAL_MIN & 0xff00) >> 8;
    verdict = COMM_ADV_Undirected_Advertising(dut2_fd, g_pattern_param);
    VERDICT_RESULT_WITH_LINE();

    read_le_event_enable();
    
    while(1) {//waiting adv report event , timer or counter  
        if(1 == read_le_event_get()) {
        // start the scanning time :30 sec
            event_query_timer_config(query_time, 0, 0, 0, &timer);
            event_query_timer_start(timer, read_le_event_disable);
            
            while(read_le_event_get()) {
                // # p4 :Lower Tester sends a SCAN_REQ packet on the selected advertising channel 
                //after receiving an ADV_DISCOVER_IND packet from IUT on the advertising 
                //channel configured in Step 3. The SCAN_REQ is sent T_IFS after the end of an 
                //ADV_IND packet. 

                MSLEEP(10);
                
                if(SUCCESS != QUERY_LE_Event(dut1_fd, buf, _BT_HCI_LE_EVENT_SUB_OP_ADVERTISING_REPORT_, HCI_SUBEVENT_ADV_RPT_EVENT_ADV_IND)) {
                    continue;
                } 
                else if(EQUAL != hci_le_event_advertising_report_parsing(HCI_CMD_PARAM_ADV_IND, buf,g_pattern_param)) {
                    printf("****parsing ADV non EQUAL**** LOOP5\n");
                    continue;
                }
                else {

                    if (ch == 37){
                        adv_cnt_37++; 
                    }
                    
                    if (ch == 38){
                        adv_cnt_38++; 
                    }
                    
                    if (ch == 39){
                        adv_cnt_39++; 
                    }                    

                    printf("****LOOP 5 adv ch %d | adv cnt %d %d %d ****\n" ,ch , adv_cnt_37 , adv_cnt_38 , adv_cnt_39);
                }

                // # p5 : Lower Tester expects a SCAN_RSP packet from the IUT T_IFS after the end of the SCAN_REQ packet.  
                if (SUCCESS != QUERY_LE_Event(dut1_fd, buf, _BT_HCI_LE_EVENT_SUB_OP_ADVERTISING_REPORT_, HCI_SUBEVENT_ADV_RPT_EVENT_SCAN_RSP)) {
                    continue;
                }            
                else if(EQUAL != hci_le_event_advertising_report_parsing(HCI_SUBEVENT_ADV_RPT_EVENT_SCAN_RSP, buf, g_pattern_param)) {
                    printf("****parsing SCN non EQUAL**** LOOP5\n");
                    continue;
                }
                else {
                    if (ch == 37){
                        scn_rsp_37++; 
                    }
                    
                    if (ch == 38){
                        scn_rsp_38++; 
                    }
                    
                    if (ch == 39){
                        scn_rsp_39++; 
                    }                    

                    printf("****parsing SCN EQUAL**** %d %d %d %d\n" , ch ,scn_rsp_37 ,scn_rsp_38 ,scn_rsp_39);

                }
 
            }

            dut_reset_with_mask_en(dut1_fd);
            dut_reset_with_mask_en(dut2_fd);


            if(ch != 39){
                goto LOOP5;
            }

            // # p6 Repeat steps 4-5 30 times. 
            if((adv_cnt_37 < 30) || (adv_cnt_38 < 30) || (adv_cnt_39 < 30) || 
               (scn_rsp_37 < 30) || (scn_rsp_38 < 30) || (scn_rsp_39 < 30) ){
                line = __LINE__;
                goto FUN_FAIL;
            }   

            break;
        }
    }


    ch = 36; // default
    adv_cnt_37 = 0;
    adv_cnt_38 = 0;
    adv_cnt_39 = 0;

    scn_rsp_37 = 0;
    scn_rsp_38 = 0;
    scn_rsp_39 = 0;
            
LOOP6: //policy = 1 , dev_addr =diff comp id ,scan data = 0   
    ch ++ ;

    COMM_Static_Random_Device_Address_Set_Config(scan_random_addr);
    COMM_Device_Address_Set(dut1_fd, g_pattern_param);

    COMM_INI_Connection_Setup_White_Listed_Config(dut1, &g_pattern_param);
	memcpy(g_pattern_param.white_list_param.Address, adv_addr, ADDR_LENGTH);
	verdict=COMM_INI_Connection_Setup_White_Listed(dut1_fd, g_pattern_param);
	VERDICT_RESULT_WITH_LINE();
    
    // # p1 : Upper Tester sends an HCI_LE_Set_Scan_Response_Data.  
    COMM_Scan_Response_Data_Set_Config(dut2_fd , 0, &g_pattern_param);
    verdict = COMM_Scan_Response_Data_Set(dut2_fd, g_pattern_param);
    VERDICT_RESULT_WITH_LINE();

    // # p2 : Configure Lower Tester to monitor the advertising and scan response packets of the IUT    
    COMM_SCN_Active_Scanning_Config(dut1, &g_pattern_param);
    g_pattern_param.scn_param.Own_Address_Type[0] = HCI_CMD_PARAM_RANDOM_DEVICE_ADDRESS;             
    g_pattern_param.scn_param.LE_Scan_Interval[0] =  0x0500 & 0x00ff;
    g_pattern_param.scn_param.LE_Scan_Interval[1] = (0x0500 & 0xff00) >> 8;
    g_pattern_param.scn_param.LE_Scan_Window[0] =    0x0500 & 0x00ff;
    g_pattern_param.scn_param.LE_Scan_Window[1] =   (0x0500 & 0xff00) >> 8;
	g_pattern_param.scn_param.Scanning_Filter_Policy[0] =	HCI_CMD_PARAM_IGNORE_ADV_PKTS_FROM_DEV_NOT_IN_WHITE_LIST_ONLY;    
    verdict = COMM_SCN_Active_Scanning(dut1_fd, g_pattern_param);
    VERDICT_RESULT_WITH_LINE();

    // # p3 : Upper Tester enables discoverable undirected advertising in the IUT using all 
    // supported advertising channels, minimum advertising intervals and filtering policy 
    //set to Allow Scan Request from Any, Allow Connect Request from Any (Default) (0x00)'. 
    COMM_ADV_Undirected_Advertising_Config(0, &g_pattern_param);

    if (ch == 37){
        g_pattern_param.adv_param.Advertising_Channel_Map[0] =HCI_CMD_PARAM_ENABLE_CHANNEL_37;
    }    
    else if (ch == 38){
        g_pattern_param.adv_param.Advertising_Channel_Map[0] =HCI_CMD_PARAM_ENABLE_CHANNEL_38;
    }    
    else if (ch == 39){
        g_pattern_param.adv_param.Advertising_Channel_Map[0] =HCI_CMD_PARAM_ENABLE_CHANNEL_39;
    }
    
    g_pattern_param.adv_param.Advertising_Filter_Policy[0] = HCI_CMD_PARAM_ALLOW_SCAN_REQ_FROM_WHITELIST_ONLY_AND_CONN_REQ_FROM_ANY;
    g_pattern_param.adv_param.Advertising_Interval_Max[0] =  HCI_CMD_PARAM_ADVERTISING_INTERVAL_MIN & 0x00ff;
    g_pattern_param.adv_param.Advertising_Interval_Max[1] = (HCI_CMD_PARAM_ADVERTISING_INTERVAL_MIN & 0xff00) >> 8;
    g_pattern_param.adv_param.Advertising_Interval_Min[0] =  HCI_CMD_PARAM_ADVERTISING_INTERVAL_MIN & 0x00ff;
    g_pattern_param.adv_param.Advertising_Interval_Min[1] = (HCI_CMD_PARAM_ADVERTISING_INTERVAL_MIN & 0xff00) >> 8;
    verdict = COMM_ADV_Undirected_Advertising(dut2_fd, g_pattern_param);
    VERDICT_RESULT_WITH_LINE();

    read_le_event_enable();

    //waiting adv report event , timer or counter  
    while(1) {
        if(1 == read_le_event_get()) {
            event_query_timer_config(query_time, 0, 0, 0, &timer);
            event_query_timer_start(timer, read_le_event_disable);
            
            while(read_le_event_get()) {
                // # p4 :Lower Tester sends a SCAN_REQ packet on the selected advertising channel 
                //after receiving an ADV_DISCOVER_IND packet from IUT on the advertising 
                //channel configured in Step 3. The SCAN_REQ is sent T_IFS after the end of an 
                //ADV_IND packet. 

                MSLEEP(10);
                
                if(SUCCESS != QUERY_LE_Event(dut1_fd, buf, _BT_HCI_LE_EVENT_SUB_OP_ADVERTISING_REPORT_, HCI_SUBEVENT_ADV_RPT_EVENT_ADV_IND)) {
                    continue;
                } 
                else if(EQUAL != hci_le_event_advertising_report_parsing(HCI_CMD_PARAM_ADV_IND, buf,g_pattern_param)) {
                    printf("****parsing ADV non EQUAL**** LOOP6\n");
                    continue;
                }
                else {
                    if (ch == 37){
                        adv_cnt_37++; 
                    }
                    
                    if (ch == 38){
                        adv_cnt_38++; 
                    }
                    
                    if (ch == 39){
                        adv_cnt_39++; 
                    }                    

                    printf("****LOOP 6 adv ch %d | adv cnt %d %d %d ****\n" ,ch , adv_cnt_37 , adv_cnt_38 , adv_cnt_39);

                }

                // # p5 : Lower Tester expects a SCAN_RSP packet from the IUT T_IFS after the end of the SCAN_REQ packet.  
                if (SUCCESS != QUERY_LE_Event(dut1_fd, buf, _BT_HCI_LE_EVENT_SUB_OP_ADVERTISING_REPORT_, HCI_SUBEVENT_ADV_RPT_EVENT_SCAN_RSP)) {
                    continue;
                }            
                else if(EQUAL != hci_le_event_advertising_report_parsing(HCI_SUBEVENT_ADV_RPT_EVENT_SCAN_RSP, buf, g_pattern_param)) {
                    printf("****parsing SCN non EQUAL**** LOOP6\n");
                    continue;
                }
                else {
                    if (ch == 37){
                        scn_rsp_37++; 
                    }
                    
                    if (ch == 38){
                        scn_rsp_38++; 
                    }
                    
                    if (ch == 39){
                        scn_rsp_39++; 
                    }                    

                    printf("****parsing SCN EQUAL**** %d %d %d %d\n" , ch ,scn_rsp_37 ,scn_rsp_38 ,scn_rsp_39);

                }
 
            }

            dut_reset_with_mask_en(dut1_fd);
            dut_reset_with_mask_en(dut2_fd);

            if(ch != 39){
                goto LOOP6;
            }

            // # p6 Repeat steps 4-5 30 times. 
            if((adv_cnt_37 < 30) || (adv_cnt_38 < 30) || (adv_cnt_39 < 30) || 
                (scn_rsp_37 > 0) || (scn_rsp_38 > 0) || (scn_rsp_39 > 0) ){
                line = __LINE__;
                goto FUN_FAIL;
            }   


            break;
        }
    }

    ch = 36; // default
    adv_cnt_37 = 0;
    adv_cnt_38 = 0;
    adv_cnt_39 = 0;

    scn_rsp_37 = 0;
    scn_rsp_38 = 0;
    scn_rsp_39 = 0;

LOOP7: //policy = 0 , dev_addr =diff comp id ,scan data = 31     
    ch ++ ;

    COMM_Static_Random_Device_Address_Set_Config(scan_random_addr);
    COMM_Device_Address_Set(dut1_fd, g_pattern_param);

    COMM_INI_Connection_Setup_White_Listed_Config(dut1, &g_pattern_param);
	memcpy(g_pattern_param.white_list_param.Address, adv_addr, ADDR_LENGTH);
	verdict=COMM_INI_Connection_Setup_White_Listed(dut1_fd, g_pattern_param);
	VERDICT_RESULT_WITH_LINE();
    
    // # p1 : Upper Tester sends an HCI_LE_Set_Scan_Response_Data.  
    COMM_Scan_Response_Data_Set_Config(dut2_fd , 31, &g_pattern_param);
    verdict = COMM_Scan_Response_Data_Set(dut2_fd, g_pattern_param);
    VERDICT_RESULT_WITH_LINE();

    // # p2 : Configure Lower Tester to monitor the advertising and scan response packets of the IUT    
    COMM_SCN_Active_Scanning_Config(dut1, &g_pattern_param);
    g_pattern_param.scn_param.Own_Address_Type[0] = HCI_CMD_PARAM_RANDOM_DEVICE_ADDRESS;             
    g_pattern_param.scn_param.LE_Scan_Interval[0] =  0x0500 & 0x00ff;
    g_pattern_param.scn_param.LE_Scan_Interval[1] = (0x0500 & 0xff00) >> 8;
    g_pattern_param.scn_param.LE_Scan_Window[0] =    0x0500 & 0x00ff;
    g_pattern_param.scn_param.LE_Scan_Window[1] =   (0x0500 & 0xff00) >> 8;
	g_pattern_param.scn_param.Scanning_Filter_Policy[0] =	HCI_CMD_PARAM_IGNORE_ADV_PKTS_FROM_DEV_NOT_IN_WHITE_LIST_ONLY;

    verdict = COMM_SCN_Active_Scanning(dut1_fd, g_pattern_param);
    VERDICT_RESULT_WITH_LINE();

    // # p3 : Upper Tester enables discoverable undirected advertising in the IUT using all 
    // supported advertising channels, minimum advertising intervals and filtering policy 
    //set to Allow Scan Request from Any, Allow Connect Request from Any (Default) (0x00)'. 
    COMM_ADV_Undirected_Advertising_Config(0, &g_pattern_param);

    if (ch == 37){
        g_pattern_param.adv_param.Advertising_Channel_Map[0] = HCI_CMD_PARAM_ENABLE_CHANNEL_37;
    }    
    else if (ch == 38){
        g_pattern_param.adv_param.Advertising_Channel_Map[0] = HCI_CMD_PARAM_ENABLE_CHANNEL_38;
    }    
    else if (ch == 39){
        g_pattern_param.adv_param.Advertising_Channel_Map[0] = HCI_CMD_PARAM_ENABLE_CHANNEL_39;
    }
    
    g_pattern_param.adv_param.Advertising_Filter_Policy[0] = HCI_CMD_PARAM_ALLOW_SCAN_REQ_AND_CONN_REQ_FROM_ANY;
    g_pattern_param.adv_param.Advertising_Interval_Max[0] =  HCI_CMD_PARAM_ADVERTISING_INTERVAL_MIN & 0x00ff;
    g_pattern_param.adv_param.Advertising_Interval_Max[1] = (HCI_CMD_PARAM_ADVERTISING_INTERVAL_MIN & 0xff00) >> 8;
    g_pattern_param.adv_param.Advertising_Interval_Min[0] =  HCI_CMD_PARAM_ADVERTISING_INTERVAL_MIN & 0x00ff;
    g_pattern_param.adv_param.Advertising_Interval_Min[1] = (HCI_CMD_PARAM_ADVERTISING_INTERVAL_MIN & 0xff00) >> 8;
    verdict = COMM_ADV_Undirected_Advertising(dut2_fd, g_pattern_param);
    VERDICT_RESULT_WITH_LINE();

    read_le_event_enable();

    while(1) {//waiting adv report event , timer or counter  
        if(1 == read_le_event_get()) {
            event_query_timer_config(query_time, 0, 0, 0, &timer);
            event_query_timer_start(timer, read_le_event_disable);
            
            while(read_le_event_get()) {
                // # p4 :Lower Tester sends a SCAN_REQ packet on the selected advertising channel 
                //after receiving an ADV_DISCOVER_IND packet from IUT on the advertising 
                //channel configured in Step 3. The SCAN_REQ is sent T_IFS after the end of an 
                //ADV_IND packet. 

                MSLEEP(10);
                
                if(SUCCESS != QUERY_LE_Event(dut1_fd, buf, _BT_HCI_LE_EVENT_SUB_OP_ADVERTISING_REPORT_, HCI_SUBEVENT_ADV_RPT_EVENT_ADV_IND)) {
                    continue;
                } 
                else if(EQUAL != hci_le_event_advertising_report_parsing(HCI_CMD_PARAM_ADV_IND, buf,g_pattern_param)) {
                    printf("****parsing ADV non EQUAL**** LOOP7\n");
                    continue;
                }
                else {

                    if (ch == 37){
                        adv_cnt_37++; 
                    }
                    
                    if (ch == 38){
                        adv_cnt_38++; 
                    }
                    
                    if (ch == 39){
                        adv_cnt_39++; 
                    }                    

                    printf("****LOOP 7 adv ch %d | adv cnt %d %d %d ****\n" ,ch , adv_cnt_37 , adv_cnt_38 , adv_cnt_39);
                }

                // # p5 : Lower Tester expects a SCAN_RSP packet from the IUT T_IFS after the end of the SCAN_REQ packet.  
                if (SUCCESS != QUERY_LE_Event(dut1_fd, buf, _BT_HCI_LE_EVENT_SUB_OP_ADVERTISING_REPORT_, HCI_SUBEVENT_ADV_RPT_EVENT_SCAN_RSP)) {
                    continue;
                }            
                else if(EQUAL != hci_le_event_advertising_report_parsing(HCI_SUBEVENT_ADV_RPT_EVENT_SCAN_RSP, buf, g_pattern_param)) {
                    printf("****parsing SCN non EQUAL**** LOOP7\n");
                    continue;
                }
                else {
                    if (ch == 37){
                        scn_rsp_37++; 
                    }
                    
                    if (ch == 38){
                        scn_rsp_38++; 
                    }
                    
                    if (ch == 39){
                        scn_rsp_39++; 
                    }                    

                    printf("****parsing SCN EQUAL**** %d %d %d %d\n" , ch ,scn_rsp_37 ,scn_rsp_38 ,scn_rsp_39);

                }
 
            }

            dut_reset_with_mask_en(dut1_fd);
            dut_reset_with_mask_en(dut2_fd);


            if(ch != 39){
                goto LOOP7;
            }

            // # p6 Repeat steps 4-5 30 times. 
            if((adv_cnt_37 < 30) || (adv_cnt_38 < 30) || (adv_cnt_39 < 30) || 
               (scn_rsp_37 < 30) || (scn_rsp_38 < 30) || (scn_rsp_39 < 30) ){
                line = __LINE__;
                goto FUN_FAIL;
            }   

            break;
        }
    }


    ch = 36; // default
    adv_cnt_37 = 0;
    adv_cnt_38 = 0;
    adv_cnt_39 = 0;

    scn_rsp_37 = 0;
    scn_rsp_38 = 0;
    scn_rsp_39 = 0;
            
LOOP8: //policy = 1 , dev_addr =diff comp id ,scan data = 31   
    ch ++ ;

    COMM_Static_Random_Device_Address_Set_Config(scan_random_addr);
    COMM_Device_Address_Set(dut1_fd, g_pattern_param);

    COMM_INI_Connection_Setup_White_Listed_Config(dut1, &g_pattern_param);
	memcpy(g_pattern_param.white_list_param.Address, adv_addr, ADDR_LENGTH);
	verdict=COMM_INI_Connection_Setup_White_Listed(dut1_fd, g_pattern_param);
	VERDICT_RESULT_WITH_LINE();
    
    // # p1 : Upper Tester sends an HCI_LE_Set_Scan_Response_Data.  
    COMM_Scan_Response_Data_Set_Config(dut2_fd , 31, &g_pattern_param);
    verdict = COMM_Scan_Response_Data_Set(dut2_fd, g_pattern_param);
    VERDICT_RESULT_WITH_LINE();

    // # p2 : Configure Lower Tester to monitor the advertising and scan response packets of the IUT    
    COMM_SCN_Active_Scanning_Config(dut1, &g_pattern_param);
    g_pattern_param.scn_param.Own_Address_Type[0] = HCI_CMD_PARAM_RANDOM_DEVICE_ADDRESS;             
    g_pattern_param.scn_param.LE_Scan_Interval[0] =  0x0500 & 0x00ff;
    g_pattern_param.scn_param.LE_Scan_Interval[1] = (0x0500 & 0xff00) >> 8;
    g_pattern_param.scn_param.LE_Scan_Window[0] =    0x0500 & 0x00ff;
    g_pattern_param.scn_param.LE_Scan_Window[1] =   (0x0500 & 0xff00) >> 8;
	g_pattern_param.scn_param.Scanning_Filter_Policy[0] =	HCI_CMD_PARAM_IGNORE_ADV_PKTS_FROM_DEV_NOT_IN_WHITE_LIST_ONLY;    
    verdict = COMM_SCN_Active_Scanning(dut1_fd, g_pattern_param);
    VERDICT_RESULT_WITH_LINE();

    // # p3 : Upper Tester enables discoverable undirected advertising in the IUT using all 
    // supported advertising channels, minimum advertising intervals and filtering policy 
    //set to Allow Scan Request from Any, Allow Connect Request from Any (Default) (0x00)'. 
    COMM_ADV_Undirected_Advertising_Config(0, &g_pattern_param);

    if (ch == 37){
        g_pattern_param.adv_param.Advertising_Channel_Map[0] =HCI_CMD_PARAM_ENABLE_CHANNEL_37;
    }    
    else if (ch == 38){
        g_pattern_param.adv_param.Advertising_Channel_Map[0] =HCI_CMD_PARAM_ENABLE_CHANNEL_38;
    }    
    else if (ch == 39){
        g_pattern_param.adv_param.Advertising_Channel_Map[0] =HCI_CMD_PARAM_ENABLE_CHANNEL_39;
    }
    
    g_pattern_param.adv_param.Advertising_Filter_Policy[0] = HCI_CMD_PARAM_ALLOW_SCAN_REQ_FROM_WHITELIST_ONLY_AND_CONN_REQ_FROM_ANY;
    g_pattern_param.adv_param.Advertising_Interval_Max[0] =  HCI_CMD_PARAM_ADVERTISING_INTERVAL_MIN & 0x00ff;
    g_pattern_param.adv_param.Advertising_Interval_Max[1] = (HCI_CMD_PARAM_ADVERTISING_INTERVAL_MIN & 0xff00) >> 8;
    g_pattern_param.adv_param.Advertising_Interval_Min[0] =  HCI_CMD_PARAM_ADVERTISING_INTERVAL_MIN & 0x00ff;
    g_pattern_param.adv_param.Advertising_Interval_Min[1] = (HCI_CMD_PARAM_ADVERTISING_INTERVAL_MIN & 0xff00) >> 8;
    verdict = COMM_ADV_Undirected_Advertising(dut2_fd, g_pattern_param);
    VERDICT_RESULT_WITH_LINE();

    read_le_event_enable();

    //waiting adv report event , timer or counter  
    while(1) {
        if(1 == read_le_event_get()) {
            event_query_timer_config(query_time, 0, 0, 0, &timer);
            event_query_timer_start(timer, read_le_event_disable);
            
            while(read_le_event_get()) {
                // # p4 :Lower Tester sends a SCAN_REQ packet on the selected advertising channel 
                //after receiving an ADV_DISCOVER_IND packet from IUT on the advertising 
                //channel configured in Step 3. The SCAN_REQ is sent T_IFS after the end of an 
                //ADV_IND packet. 

                MSLEEP(10);
                
                if(SUCCESS != QUERY_LE_Event(dut1_fd, buf, _BT_HCI_LE_EVENT_SUB_OP_ADVERTISING_REPORT_, HCI_SUBEVENT_ADV_RPT_EVENT_ADV_IND)) {
                    continue;
                } 
                else if(EQUAL != hci_le_event_advertising_report_parsing(HCI_CMD_PARAM_ADV_IND, buf,g_pattern_param)) {
                    printf("****parsing ADV non EQUAL**** LOOP8\n");
                    continue;
                }
                else {
                    if (ch == 37){
                        adv_cnt_37++; 
                    }
                    
                    if (ch == 38){
                        adv_cnt_38++; 
                    }
                    
                    if (ch == 39){
                        adv_cnt_39++; 
                    }                    

                    printf("****LOOP 8 adv ch %d | adv cnt %d %d %d ****\n" ,ch , adv_cnt_37 , adv_cnt_38 , adv_cnt_39);

                }

                // # p5 : Lower Tester expects a SCAN_RSP packet from the IUT T_IFS after the end of the SCAN_REQ packet.  
                if (SUCCESS != QUERY_LE_Event(dut1_fd, buf, _BT_HCI_LE_EVENT_SUB_OP_ADVERTISING_REPORT_, HCI_SUBEVENT_ADV_RPT_EVENT_SCAN_RSP)) {
                    continue;
                }            
                else if(EQUAL != hci_le_event_advertising_report_parsing(HCI_SUBEVENT_ADV_RPT_EVENT_SCAN_RSP, buf, g_pattern_param)) {
                    printf("****parsing SCN non EQUAL**** LOOP8\n");
                }
                else {
                    if (ch == 37){
                        scn_rsp_37++; 
                    }
                    
                    if (ch == 38){
                        scn_rsp_38++; 
                    }
                    
                    if (ch == 39){
                        scn_rsp_39++; 
                    }                    

                    printf("****parsing SCN EQUAL**** %d %d %d %d\n" , ch ,scn_rsp_37 ,scn_rsp_38 ,scn_rsp_39);

                }
 
            }

            dut_reset_with_mask_en(dut1_fd);
            dut_reset_with_mask_en(dut2_fd);

            if(ch != 39){
                goto LOOP8;
            }

            // # p6 Repeat steps 4-5 30 times. 
            if((adv_cnt_37 < 30) || (adv_cnt_38 < 30) || (adv_cnt_39 < 30) || 
                (scn_rsp_37 > 0) || (scn_rsp_38 > 0) || (scn_rsp_39 > 0) ){
                line = __LINE__;
                goto FUN_FAIL;
            }   


            break;
        }
    }

    ch = 36; // default
    adv_cnt_37 = 0;
    adv_cnt_38 = 0;
    adv_cnt_39 = 0;

    scn_rsp_37 = 0;
    scn_rsp_38 = 0;
    scn_rsp_39 = 0;

LOOP9: //policy = 0 , dev_addr =diff both id ,scan data = 0     
    ch ++ ;

    COMM_Static_Random_Device_Address_Set_Config(dut1_error_both);
    COMM_Device_Address_Set(dut1_fd, g_pattern_param);

    COMM_INI_Connection_Setup_White_Listed_Config(dut1, &g_pattern_param);
    memcpy(g_pattern_param.white_list_param.Address, adv_addr, ADDR_LENGTH);
    verdict=COMM_INI_Connection_Setup_White_Listed(dut1_fd, g_pattern_param);
    VERDICT_RESULT_WITH_LINE();
    
    // # p1 : Upper Tester sends an HCI_LE_Set_Scan_Response_Data.  
    COMM_Scan_Response_Data_Set_Config(dut2_fd , 0, &g_pattern_param);
    verdict = COMM_Scan_Response_Data_Set(dut2_fd, g_pattern_param);
    VERDICT_RESULT_WITH_LINE();

    // # p2 : Configure Lower Tester to monitor the advertising and scan response packets of the IUT    
    COMM_SCN_Active_Scanning_Config(dut1, &g_pattern_param);
    g_pattern_param.scn_param.Own_Address_Type[0] = HCI_CMD_PARAM_RANDOM_DEVICE_ADDRESS;             
    g_pattern_param.scn_param.LE_Scan_Interval[0] =  0x0500 & 0x00ff;
    g_pattern_param.scn_param.LE_Scan_Interval[1] = (0x0500 & 0xff00) >> 8;
    g_pattern_param.scn_param.LE_Scan_Window[0] =    0x0500 & 0x00ff;
    g_pattern_param.scn_param.LE_Scan_Window[1] =   (0x0500 & 0xff00) >> 8;
    g_pattern_param.scn_param.Scanning_Filter_Policy[0] =   HCI_CMD_PARAM_IGNORE_ADV_PKTS_FROM_DEV_NOT_IN_WHITE_LIST_ONLY;

    verdict = COMM_SCN_Active_Scanning(dut1_fd, g_pattern_param);
    VERDICT_RESULT_WITH_LINE();

    // # p3 : Upper Tester enables discoverable undirected advertising in the IUT using all 
    // supported advertising channels, minimum advertising intervals and filtering policy 
    //set to Allow Scan Request from Any, Allow Connect Request from Any (Default) (0x00)'. 
    COMM_ADV_Undirected_Advertising_Config(0, &g_pattern_param);

    if (ch == 37){
        g_pattern_param.adv_param.Advertising_Channel_Map[0] = HCI_CMD_PARAM_ENABLE_CHANNEL_37;
    }    
    else if (ch == 38){
        g_pattern_param.adv_param.Advertising_Channel_Map[0] = HCI_CMD_PARAM_ENABLE_CHANNEL_38;
    }    
    else if (ch == 39){
        g_pattern_param.adv_param.Advertising_Channel_Map[0] = HCI_CMD_PARAM_ENABLE_CHANNEL_39;
    }
    
    g_pattern_param.adv_param.Advertising_Filter_Policy[0] = HCI_CMD_PARAM_ALLOW_SCAN_REQ_AND_CONN_REQ_FROM_ANY;
    g_pattern_param.adv_param.Advertising_Interval_Max[0] =  HCI_CMD_PARAM_ADVERTISING_INTERVAL_MIN & 0x00ff;
    g_pattern_param.adv_param.Advertising_Interval_Max[1] = (HCI_CMD_PARAM_ADVERTISING_INTERVAL_MIN & 0xff00) >> 8;
    g_pattern_param.adv_param.Advertising_Interval_Min[0] =  HCI_CMD_PARAM_ADVERTISING_INTERVAL_MIN & 0x00ff;
    g_pattern_param.adv_param.Advertising_Interval_Min[1] = (HCI_CMD_PARAM_ADVERTISING_INTERVAL_MIN & 0xff00) >> 8;
    verdict = COMM_ADV_Undirected_Advertising(dut2_fd, g_pattern_param);
    VERDICT_RESULT_WITH_LINE();

    read_le_event_enable();
    
    while(1) {//waiting adv report event , timer or counter  
        if(1 == read_le_event_get()) {
            event_query_timer_config(query_time, 0, 0, 0, &timer);
            event_query_timer_start(timer, read_le_event_disable);
            
            while(read_le_event_get()) {
                // # p4 :Lower Tester sends a SCAN_REQ packet on the selected advertising channel 
                //after receiving an ADV_DISCOVER_IND packet from IUT on the advertising 
                //channel configured in Step 3. The SCAN_REQ is sent T_IFS after the end of an 
                //ADV_IND packet. 

                MSLEEP(10);
                
                if(SUCCESS != QUERY_LE_Event(dut1_fd, buf, _BT_HCI_LE_EVENT_SUB_OP_ADVERTISING_REPORT_, HCI_SUBEVENT_ADV_RPT_EVENT_ADV_IND)) {
                    continue;
                } 
                else if(EQUAL != hci_le_event_advertising_report_parsing(HCI_CMD_PARAM_ADV_IND, buf,g_pattern_param)) {
                    printf("****parsing ADV non EQUAL**** LOOP9\n");
                    continue;
                }
                else {

                    if (ch == 37){
                        adv_cnt_37++; 
                    }
                    
                    if (ch == 38){
                        adv_cnt_38++; 
                    }
                    
                    if (ch == 39){
                        adv_cnt_39++; 
                    }                    

                    printf("****LOOP 9 adv ch %d | adv cnt %d %d %d ****\n" ,ch , adv_cnt_37 , adv_cnt_38 , adv_cnt_39);
                }

                // # p5 : Lower Tester expects a SCAN_RSP packet from the IUT T_IFS after the end of the SCAN_REQ packet.  
                if (SUCCESS != QUERY_LE_Event(dut1_fd, buf, _BT_HCI_LE_EVENT_SUB_OP_ADVERTISING_REPORT_, HCI_SUBEVENT_ADV_RPT_EVENT_SCAN_RSP)) {
                    continue;
                    
                    
                }            
                else if(EQUAL != hci_le_event_advertising_report_parsing(HCI_SUBEVENT_ADV_RPT_EVENT_SCAN_RSP, buf, g_pattern_param)) {
                    printf("****parsing SCN non EQUAL**** LOOP9\n");
                    continue;
                }
                else {
                    if (ch == 37){
                        scn_rsp_37++; 
                    }
                    
                    if (ch == 38){
                        scn_rsp_38++; 
                    }
                    
                    if (ch == 39){
                        scn_rsp_39++; 
                    }                    

                    printf("****parsing SCN EQUAL**** %d %d %d %d\n" , ch ,scn_rsp_37 ,scn_rsp_38 ,scn_rsp_39);

                }
 
            }

            dut_reset_with_mask_en(dut1_fd);
            dut_reset_with_mask_en(dut2_fd);


            if(ch != 39){
                goto LOOP9;
            }

            // # p6 Repeat steps 4-5 30 times. 
            if((adv_cnt_37 < 30) || (adv_cnt_38 < 30) || (adv_cnt_39 < 30) || 
               (scn_rsp_37 < 30) || (scn_rsp_38 < 30) || (scn_rsp_39 < 30) ){
                line = __LINE__;
                goto FUN_FAIL;
            }   

            break;
        }
    }


    ch = 36; // default
    adv_cnt_37 = 0;
    adv_cnt_38 = 0;
    adv_cnt_39 = 0;

    scn_rsp_37 = 0;
    scn_rsp_38 = 0;
    scn_rsp_39 = 0;
            
LOOP10: //policy = 1 , dev_addr =both id ,scan data = 0   
    ch ++ ;

    COMM_Static_Random_Device_Address_Set_Config(dut1_error_both);
    COMM_Device_Address_Set(dut1_fd, g_pattern_param);

    COMM_INI_Connection_Setup_White_Listed_Config(dut1, &g_pattern_param);
    memcpy(g_pattern_param.white_list_param.Address, adv_addr, ADDR_LENGTH);
    verdict=COMM_INI_Connection_Setup_White_Listed(dut1_fd, g_pattern_param);
    VERDICT_RESULT_WITH_LINE();
    
    // # p1 : Upper Tester sends an HCI_LE_Set_Scan_Response_Data.  
    COMM_Scan_Response_Data_Set_Config(dut2_fd , 0, &g_pattern_param);
    verdict = COMM_Scan_Response_Data_Set(dut2_fd, g_pattern_param);
    VERDICT_RESULT_WITH_LINE();

    // # p2 : Configure Lower Tester to monitor the advertising and scan response packets of the IUT    
    COMM_SCN_Active_Scanning_Config(dut1, &g_pattern_param);
    g_pattern_param.scn_param.Own_Address_Type[0] = HCI_CMD_PARAM_RANDOM_DEVICE_ADDRESS;             
    g_pattern_param.scn_param.LE_Scan_Interval[0] =  0x0500 & 0x00ff;
    g_pattern_param.scn_param.LE_Scan_Interval[1] = (0x0500 & 0xff00) >> 8;
    g_pattern_param.scn_param.LE_Scan_Window[0] =    0x0500 & 0x00ff;
    g_pattern_param.scn_param.LE_Scan_Window[1] =   (0x0500 & 0xff00) >> 8;
    g_pattern_param.scn_param.Scanning_Filter_Policy[0] =   HCI_CMD_PARAM_IGNORE_ADV_PKTS_FROM_DEV_NOT_IN_WHITE_LIST_ONLY;    
    verdict = COMM_SCN_Active_Scanning(dut1_fd, g_pattern_param);
    VERDICT_RESULT_WITH_LINE();

    // # p3 : Upper Tester enables discoverable undirected advertising in the IUT using all 
    // supported advertising channels, minimum advertising intervals and filtering policy 
    //set to Allow Scan Request from Any, Allow Connect Request from Any (Default) (0x00)'. 
    COMM_ADV_Undirected_Advertising_Config(0, &g_pattern_param);

    if (ch == 37){
        g_pattern_param.adv_param.Advertising_Channel_Map[0] =HCI_CMD_PARAM_ENABLE_CHANNEL_37;
    }    
    else if (ch == 38){
        g_pattern_param.adv_param.Advertising_Channel_Map[0] =HCI_CMD_PARAM_ENABLE_CHANNEL_38;
    }    
    else if (ch == 39){
        g_pattern_param.adv_param.Advertising_Channel_Map[0] =HCI_CMD_PARAM_ENABLE_CHANNEL_39;
    }
    
    g_pattern_param.adv_param.Advertising_Filter_Policy[0] = HCI_CMD_PARAM_ALLOW_SCAN_REQ_FROM_WHITELIST_ONLY_AND_CONN_REQ_FROM_ANY;
    g_pattern_param.adv_param.Advertising_Interval_Max[0] =  HCI_CMD_PARAM_ADVERTISING_INTERVAL_MIN & 0x00ff;
    g_pattern_param.adv_param.Advertising_Interval_Max[1] = (HCI_CMD_PARAM_ADVERTISING_INTERVAL_MIN & 0xff00) >> 8;
    g_pattern_param.adv_param.Advertising_Interval_Min[0] =  HCI_CMD_PARAM_ADVERTISING_INTERVAL_MIN & 0x00ff;
    g_pattern_param.adv_param.Advertising_Interval_Min[1] = (HCI_CMD_PARAM_ADVERTISING_INTERVAL_MIN & 0xff00) >> 8;
    verdict = COMM_ADV_Undirected_Advertising(dut2_fd, g_pattern_param);
    VERDICT_RESULT_WITH_LINE();

    read_le_event_enable();

    //waiting adv report event , timer or counter  
    while(1) {
        if(1 == read_le_event_get()) {

            event_query_timer_config(query_time, 0, 0, 0, &timer);
            event_query_timer_start(timer, read_le_event_disable);
            
            while(read_le_event_get()) {
                // # p4 :Lower Tester sends a SCAN_REQ packet on the selected advertising channel 
                //after receiving an ADV_DISCOVER_IND packet from IUT on the advertising 
                //channel configured in Step 3. The SCAN_REQ is sent T_IFS after the end of an 
                //ADV_IND packet. 

                MSLEEP(10);
                
                if(SUCCESS != QUERY_LE_Event(dut1_fd, buf, _BT_HCI_LE_EVENT_SUB_OP_ADVERTISING_REPORT_, HCI_SUBEVENT_ADV_RPT_EVENT_ADV_IND)) {
                    continue;
                } 
                else if(EQUAL != hci_le_event_advertising_report_parsing(HCI_CMD_PARAM_ADV_IND, buf,g_pattern_param)) {
                    printf("****parsing ADV non EQUAL**** LOOP10\n");
                    continue;
                }
                else {
                    if (ch == 37){
                        adv_cnt_37++; 
                    }
                    
                    if (ch == 38){
                        adv_cnt_38++; 
                    }
                    
                    if (ch == 39){
                        adv_cnt_39++; 
                    }                    

                    printf("****LOOP 10 adv ch %d | adv cnt %d %d %d ****\n" ,ch , adv_cnt_37 , adv_cnt_38 , adv_cnt_39);

                }

                // # p5 : Lower Tester expects a SCAN_RSP packet from the IUT T_IFS after the end of the SCAN_REQ packet.  
                if (SUCCESS != QUERY_LE_Event(dut1_fd, buf, _BT_HCI_LE_EVENT_SUB_OP_ADVERTISING_REPORT_, HCI_SUBEVENT_ADV_RPT_EVENT_SCAN_RSP)) {
                    continue;
                }            
                else if(EQUAL != hci_le_event_advertising_report_parsing(HCI_SUBEVENT_ADV_RPT_EVENT_SCAN_RSP, buf, g_pattern_param)) {
                    printf("****parsing SCN non EQUAL**** LOOP10\n");
                }
                else {
                    if (ch == 37){
                        scn_rsp_37++; 
                    }
                    
                    if (ch == 38){
                        scn_rsp_38++; 
                    }
                    
                    if (ch == 39){
                        scn_rsp_39++; 
                    }                    

                    printf("****parsing SCN EQUAL**** %d %d %d %d\n" , ch ,scn_rsp_37 ,scn_rsp_38 ,scn_rsp_39);

                }
 
            }

            dut_reset_with_mask_en(dut1_fd);
            dut_reset_with_mask_en(dut2_fd);

            if(ch != 39){
                goto LOOP10;
            }

            // # p6 Repeat steps 4-5 30 times. 
            if((adv_cnt_37 < 30) || (adv_cnt_38 < 30) || (adv_cnt_39 < 30) || 
                (scn_rsp_37 > 0) || (scn_rsp_38 > 0) || (scn_rsp_39 > 0) ){
                line = __LINE__;
                goto FUN_FAIL;
            }   


            break;
        }
    }

    ch = 36; // default
    adv_cnt_37 = 0;
    adv_cnt_38 = 0;
    adv_cnt_39 = 0;

    scn_rsp_37 = 0;
    scn_rsp_38 = 0;
    scn_rsp_39 = 0;

LOOP11: //policy = 0 , dev_addr =both id ,scan data = 31     
    ch ++ ;

    COMM_Static_Random_Device_Address_Set_Config(dut1_error_both);
    COMM_Device_Address_Set(dut1_fd, g_pattern_param);

    COMM_INI_Connection_Setup_White_Listed_Config(dut1, &g_pattern_param);
    memcpy(g_pattern_param.white_list_param.Address, adv_addr, ADDR_LENGTH);
    verdict=COMM_INI_Connection_Setup_White_Listed(dut1_fd, g_pattern_param);
    VERDICT_RESULT_WITH_LINE();
    
    // # p1 : Upper Tester sends an HCI_LE_Set_Scan_Response_Data.  
    COMM_Scan_Response_Data_Set_Config(dut2_fd , 31, &g_pattern_param);
    verdict = COMM_Scan_Response_Data_Set(dut2_fd, g_pattern_param);
    VERDICT_RESULT_WITH_LINE();

    // # p2 : Configure Lower Tester to monitor the advertising and scan response packets of the IUT    
    COMM_SCN_Active_Scanning_Config(dut1, &g_pattern_param);
    g_pattern_param.scn_param.Own_Address_Type[0] = HCI_CMD_PARAM_RANDOM_DEVICE_ADDRESS;             
    g_pattern_param.scn_param.LE_Scan_Interval[0] =  0x0500 & 0x00ff;
    g_pattern_param.scn_param.LE_Scan_Interval[1] = (0x0500 & 0xff00) >> 8;
    g_pattern_param.scn_param.LE_Scan_Window[0] =    0x0500 & 0x00ff;
    g_pattern_param.scn_param.LE_Scan_Window[1] =   (0x0500 & 0xff00) >> 8;
    g_pattern_param.scn_param.Scanning_Filter_Policy[0] =   HCI_CMD_PARAM_IGNORE_ADV_PKTS_FROM_DEV_NOT_IN_WHITE_LIST_ONLY;

    verdict = COMM_SCN_Active_Scanning(dut1_fd, g_pattern_param);
    VERDICT_RESULT_WITH_LINE();

    // # p3 : Upper Tester enables discoverable undirected advertising in the IUT using all 
    // supported advertising channels, minimum advertising intervals and filtering policy 
    //set to Allow Scan Request from Any, Allow Connect Request from Any (Default) (0x00)'. 
    COMM_ADV_Undirected_Advertising_Config(0, &g_pattern_param);

    if (ch == 37){
        g_pattern_param.adv_param.Advertising_Channel_Map[0] = HCI_CMD_PARAM_ENABLE_CHANNEL_37;
    }    
    else if (ch == 38){
        g_pattern_param.adv_param.Advertising_Channel_Map[0] = HCI_CMD_PARAM_ENABLE_CHANNEL_38;
    }    
    else if (ch == 39){
        g_pattern_param.adv_param.Advertising_Channel_Map[0] = HCI_CMD_PARAM_ENABLE_CHANNEL_39;
    }
    
    g_pattern_param.adv_param.Advertising_Filter_Policy[0] = HCI_CMD_PARAM_ALLOW_SCAN_REQ_AND_CONN_REQ_FROM_ANY;
    g_pattern_param.adv_param.Advertising_Interval_Max[0] =  HCI_CMD_PARAM_ADVERTISING_INTERVAL_MIN & 0x00ff;
    g_pattern_param.adv_param.Advertising_Interval_Max[1] = (HCI_CMD_PARAM_ADVERTISING_INTERVAL_MIN & 0xff00) >> 8;
    g_pattern_param.adv_param.Advertising_Interval_Min[0] =  HCI_CMD_PARAM_ADVERTISING_INTERVAL_MIN & 0x00ff;
    g_pattern_param.adv_param.Advertising_Interval_Min[1] = (HCI_CMD_PARAM_ADVERTISING_INTERVAL_MIN & 0xff00) >> 8;
    verdict = COMM_ADV_Undirected_Advertising(dut2_fd, g_pattern_param);
    VERDICT_RESULT_WITH_LINE();

    read_le_event_enable();
    
    while(1) {//waiting adv report event , timer or counter  
        if(1 == read_le_event_get()) {

            event_query_timer_config(query_time, 0, 0, 0, &timer);
            event_query_timer_start(timer, read_le_event_disable);
            
            while(read_le_event_get()) {
                // # p4 :Lower Tester sends a SCAN_REQ packet on the selected advertising channel 
                //after receiving an ADV_DISCOVER_IND packet from IUT on the advertising 
                //channel configured in Step 3. The SCAN_REQ is sent T_IFS after the end of an 
                //ADV_IND packet. 

                MSLEEP(10);
                
                if(SUCCESS != QUERY_LE_Event(dut1_fd, buf, _BT_HCI_LE_EVENT_SUB_OP_ADVERTISING_REPORT_, HCI_SUBEVENT_ADV_RPT_EVENT_ADV_IND)) {
                    continue;
                } 
                else if(EQUAL != hci_le_event_advertising_report_parsing(HCI_CMD_PARAM_ADV_IND, buf,g_pattern_param)) {
                    printf("****parsing ADV non EQUAL**** LOOP11\n");
                    continue;
                }
                else {

                    if (ch == 37){
                        adv_cnt_37++; 
                    }
                    
                    if (ch == 38){
                        adv_cnt_38++; 
                    }
                    
                    if (ch == 39){
                        adv_cnt_39++; 
                    }                    

                    printf("****LOOP 11 adv ch %d | adv cnt %d %d %d ****\n" ,ch , adv_cnt_37 , adv_cnt_38 , adv_cnt_39);
                }

                // # p5 : Lower Tester expects a SCAN_RSP packet from the IUT T_IFS after the end of the SCAN_REQ packet.  
                if (SUCCESS != QUERY_LE_Event(dut1_fd, buf, _BT_HCI_LE_EVENT_SUB_OP_ADVERTISING_REPORT_, HCI_SUBEVENT_ADV_RPT_EVENT_SCAN_RSP)) {
                    continue;
                }            
                else if(EQUAL != hci_le_event_advertising_report_parsing(HCI_SUBEVENT_ADV_RPT_EVENT_SCAN_RSP, buf, g_pattern_param)) {
                    printf("****parsing SCN non EQUAL**** LOOP11\n");
                    continue;
                }
                else {
                    if (ch == 37){
                        scn_rsp_37++; 
                    }
                    
                    if (ch == 38){
                        scn_rsp_38++; 
                    }
                    
                    if (ch == 39){
                        scn_rsp_39++; 
                    }                    

                    printf("****parsing SCN EQUAL**** %d %d %d %d\n" , ch ,scn_rsp_37 ,scn_rsp_38 ,scn_rsp_39);

                }
 
            }

            dut_reset_with_mask_en(dut1_fd);
            dut_reset_with_mask_en(dut2_fd);


            if(ch != 39){
                goto LOOP11;
            }

            // # p6 Repeat steps 4-5 30 times. 
            if((adv_cnt_37 < 30) || (adv_cnt_38 < 30) || (adv_cnt_39 < 30) || 
               (scn_rsp_37 < 30) || (scn_rsp_38 < 30) || (scn_rsp_39 < 30) ){
                line = __LINE__;
                goto FUN_FAIL;
            }   

            break;
        }
    }


    ch = 36; // default
    adv_cnt_37 = 0;
    adv_cnt_38 = 0;
    adv_cnt_39 = 0;

    scn_rsp_37 = 0;
    scn_rsp_38 = 0;
    scn_rsp_39 = 0;
            
LOOP12: //policy = 1 , dev_addr =both id ,scan data = 31   
    ch ++ ;

    COMM_Static_Random_Device_Address_Set_Config(scan_random_addr);
    COMM_Device_Address_Set(dut1_fd, g_pattern_param);

    COMM_INI_Connection_Setup_White_Listed_Config(dut1, &g_pattern_param);
    memcpy(g_pattern_param.white_list_param.Address, adv_addr, ADDR_LENGTH);
    verdict=COMM_INI_Connection_Setup_White_Listed(dut1_fd, g_pattern_param);
    VERDICT_RESULT_WITH_LINE();
    
    // # p1 : Upper Tester sends an HCI_LE_Set_Scan_Response_Data.  
    COMM_Scan_Response_Data_Set_Config(dut2_fd , 31, &g_pattern_param);
    verdict = COMM_Scan_Response_Data_Set(dut2_fd, g_pattern_param);
    VERDICT_RESULT_WITH_LINE();

    // # p2 : Configure Lower Tester to monitor the advertising and scan response packets of the IUT    
    COMM_SCN_Active_Scanning_Config(dut1, &g_pattern_param);
    g_pattern_param.scn_param.Own_Address_Type[0] = HCI_CMD_PARAM_RANDOM_DEVICE_ADDRESS;             
    g_pattern_param.scn_param.LE_Scan_Interval[0] =  0x0500 & 0x00ff;
    g_pattern_param.scn_param.LE_Scan_Interval[1] = (0x0500 & 0xff00) >> 8;
    g_pattern_param.scn_param.LE_Scan_Window[0] =    0x0500 & 0x00ff;
    g_pattern_param.scn_param.LE_Scan_Window[1] =   (0x0500 & 0xff00) >> 8;
    g_pattern_param.scn_param.Scanning_Filter_Policy[0] =   HCI_CMD_PARAM_IGNORE_ADV_PKTS_FROM_DEV_NOT_IN_WHITE_LIST_ONLY;    
    verdict = COMM_SCN_Active_Scanning(dut1_fd, g_pattern_param);
    VERDICT_RESULT_WITH_LINE();

    // # p3 : Upper Tester enables discoverable undirected advertising in the IUT using all 
    // supported advertising channels, minimum advertising intervals and filtering policy 
    //set to Allow Scan Request from Any, Allow Connect Request from Any (Default) (0x00)'. 
    COMM_ADV_Undirected_Advertising_Config(0, &g_pattern_param);

    if (ch == 37){
        g_pattern_param.adv_param.Advertising_Channel_Map[0] =HCI_CMD_PARAM_ENABLE_CHANNEL_37;
    }    
    else if (ch == 38){
        g_pattern_param.adv_param.Advertising_Channel_Map[0] =HCI_CMD_PARAM_ENABLE_CHANNEL_38;
    }    
    else if (ch == 39){
        g_pattern_param.adv_param.Advertising_Channel_Map[0] =HCI_CMD_PARAM_ENABLE_CHANNEL_39;
    }
    
    g_pattern_param.adv_param.Advertising_Filter_Policy[0] = HCI_CMD_PARAM_ALLOW_SCAN_REQ_FROM_WHITELIST_ONLY_AND_CONN_REQ_FROM_ANY;
    g_pattern_param.adv_param.Advertising_Interval_Max[0] =  HCI_CMD_PARAM_ADVERTISING_INTERVAL_MIN & 0x00ff;
    g_pattern_param.adv_param.Advertising_Interval_Max[1] = (HCI_CMD_PARAM_ADVERTISING_INTERVAL_MIN & 0xff00) >> 8;
    g_pattern_param.adv_param.Advertising_Interval_Min[0] =  HCI_CMD_PARAM_ADVERTISING_INTERVAL_MIN & 0x00ff;
    g_pattern_param.adv_param.Advertising_Interval_Min[1] = (HCI_CMD_PARAM_ADVERTISING_INTERVAL_MIN & 0xff00) >> 8;
    verdict = COMM_ADV_Undirected_Advertising(dut2_fd, g_pattern_param);
    VERDICT_RESULT_WITH_LINE();

    read_le_event_enable();

    //waiting adv report event , timer or counter  
    while(1) {
        if(1 == read_le_event_get()) {
        // start the scanning time :30 sec
            event_query_timer_config(query_time, 0, 0, 0, &timer);
            event_query_timer_start(timer, read_le_event_disable);
            
            while(read_le_event_get()) {
                // # p4 :Lower Tester sends a SCAN_REQ packet on the selected advertising channel 
                //after receiving an ADV_DISCOVER_IND packet from IUT on the advertising 
                //channel configured in Step 3. The SCAN_REQ is sent T_IFS after the end of an 
                //ADV_IND packet. 

                MSLEEP(10);
                
                if(SUCCESS != QUERY_LE_Event(dut1_fd, buf, _BT_HCI_LE_EVENT_SUB_OP_ADVERTISING_REPORT_, HCI_SUBEVENT_ADV_RPT_EVENT_ADV_IND)) {
                    continue;
                } 
                else if(EQUAL != hci_le_event_advertising_report_parsing(HCI_CMD_PARAM_ADV_IND, buf,g_pattern_param)) {
                    printf("****parsing ADV non EQUAL**** LOOP12\n");
                    continue;
                }
                else {
                    if (ch == 37){
                        adv_cnt_37++; 
                    }
                    
                    if (ch == 38){
                        adv_cnt_38++; 
                    }
                    
                    if (ch == 39){
                        adv_cnt_39++; 
                    }                    

                    printf("****LOOP 12 adv ch %d | adv cnt %d %d %d ****\n" ,ch , adv_cnt_37 , adv_cnt_38 , adv_cnt_39);

                }

                // # p5 : Lower Tester expects a SCAN_RSP packet from the IUT T_IFS after the end of the SCAN_REQ packet.  
                if (SUCCESS != QUERY_LE_Event(dut1_fd, buf, _BT_HCI_LE_EVENT_SUB_OP_ADVERTISING_REPORT_, HCI_SUBEVENT_ADV_RPT_EVENT_SCAN_RSP)) {
                    continue;
                }            
                else if(EQUAL != hci_le_event_advertising_report_parsing(HCI_SUBEVENT_ADV_RPT_EVENT_SCAN_RSP, buf, g_pattern_param)) {
                    printf("****parsing SCN non EQUAL**** LOOP12\n");
                }
                else {
                    if (ch == 37){
                        scn_rsp_37++; 
                    }
                    
                    if (ch == 38){
                        scn_rsp_38++; 
                    }
                    
                    if (ch == 39){
                        scn_rsp_39++; 
                    }                    

                    printf("****parsing SCN EQUAL**** %d %d %d %d\n" , ch ,scn_rsp_37 ,scn_rsp_38 ,scn_rsp_39);

                }
 
            }

            dut_reset_with_mask_en(dut1_fd);
            dut_reset_with_mask_en(dut2_fd);

            if(ch != 39){
                goto LOOP12;
            }

            // # p6 Repeat steps 4-5 30 times. 
            if((adv_cnt_37 < 30) || (adv_cnt_38 < 30) || (adv_cnt_39 < 30) || 
                (scn_rsp_37 > 0) || (scn_rsp_38 > 0) || (scn_rsp_39 > 0) ){
                line = __LINE__;
                goto FUN_FAIL;
            }   


            break;
        }
    }

    FUNC_END();
    
    // the ideal value : 30(s) / 30(ms) = 1000
    LOG_INFO("[Pattern][%s]SUCCESS\n" ,__FUNCTION__);    
    LOG_INFO("adv cnt 37 =%d \n" , adv_cnt_37);
    LOG_INFO("adv cnt 38 =%d \n" , adv_cnt_38);
    LOG_INFO("adv cnt 39 =%d \n" , adv_cnt_39);
    LOG_INFO("scn rsp 37 =%d \n" , scn_rsp_37);
    LOG_INFO("scn rsp 38 =%d \n" , scn_rsp_38);
    LOG_INFO("scn rsp 39 =%d \n" , scn_rsp_39);
    return PASS;
    
FUN_FAIL:
    FUNC_END();
    
    LOG_INFO("[Pattern][%s]:%d FAIL\n" ,__FUNCTION__,line);
    LOG_INFO("adv cnt 37 =%d \n" , adv_cnt_37);
    LOG_INFO("adv cnt 38 =%d \n" , adv_cnt_38);
    LOG_INFO("adv cnt 39 =%d \n" , adv_cnt_39);
    LOG_INFO("scn rsp 37 =%d \n" , scn_rsp_37);
    LOG_INFO("scn rsp 38 =%d \n" , scn_rsp_38);
    LOG_INFO("scn rsp 39 =%d \n" , scn_rsp_39);
    return FAIL;
}

// 5.2.1.6
verdict DDI_ADV_Connection_Request(u8 dut1_fd ,u8 dut2_fd)
{
    u8 buf[SOCKET_BUF_SIZE];
	int verdict = FAIL;
	int dut1 = 0;
    int dut2 = 0;
	u16 line = 0;	
	u32 adv_cnt = 1;
    u32 check_cnt = 0;
    u32 err_cnt = 0;
    int adv_Channel = 37;
	struct itimerval timer;	

    COMM_Dut_clean_buffer(dut1_fd);
    COMM_Dut_clean_buffer(dut2_fd);
    
    Calculate_Execution_Time_Start();    
    LOOP1: 
    /****************************************************************************  
        case 1,
        INI:
            Address : scan_addr
            Type    : HCI_CMD_PARAM_PUBLIC_DEVICE_ADDRESS
        ADV:
            adv_policy = 0x00(HCI_CMD_PARAM_ALLOW_SCAN_REQ_AND_CONN_REQ_FROM_ANY),

        Result : Expect the IUT stop advertising.
    *****************************************************************************/    
    // Uptest(white list) config
    COMM_INI_Connection_Setup_White_Listed_Config(dut2, &g_pattern_param);
    memcpy(g_pattern_param.white_list_param.Address, scan_addr, ADDR_LENGTH);
    g_pattern_param.white_list_param.Address_Type[0] = HCI_CMD_PARAM_PUBLIC_DEVICE_ADDRESS;
    verdict = COMM_INI_Connection_Setup_White_Listed(dut2_fd, g_pattern_param);
    VERDICT_RESULT_WITH_LINE();
    
    // ***********************************************************************************            
    // Lwtest(Init) config    
    COMM_INI_Initiating_Config(dut1, &g_pattern_param);
    g_pattern_param.create_conn_param.Own_Address_Type[0] = HCI_CMD_PARAM_PUBLIC_DEVICE_ADDRESS;
    memcpy(g_pattern_param.create_conn_param.Peer_Address, adv_addr, ADDR_LENGTH);
    verdict = COMM_INI_Initiating(dut1_fd, g_pattern_param);            
    VERDICT_RESULT_WITH_LINE();
     
    // ***********************************************************************************            
    // IUT(ADV) config
    COMM_ADV_Undirected_Advertising_Config(HCI_CMD_PARAM_ADV_DATA_LEN_MAX, &g_pattern_param);
    
    if(37 == adv_Channel) {
        g_pattern_param.adv_param.Advertising_Channel_Map[0] = HCI_CMD_PARAM_ENABLE_CHANNEL_37;
    }
    else if(38 == adv_Channel) {
        g_pattern_param.adv_param.Advertising_Channel_Map[0] = HCI_CMD_PARAM_ENABLE_CHANNEL_38;
    }
    else {
        g_pattern_param.adv_param.Advertising_Channel_Map[0] = HCI_CMD_PARAM_ENABLE_CHANNEL_39;
    }
    
    g_pattern_param.adv_param.Advertising_Filter_Policy[0] = HCI_CMD_PARAM_ALLOW_SCAN_REQ_AND_CONN_REQ_FROM_ANY;
    g_pattern_param.adv_param.Advertising_Interval_Max[0] =  HCI_CMD_PARAM_ADVERTISING_INTERVAL_MIN & 0x00ff;
    g_pattern_param.adv_param.Advertising_Interval_Max[1] = (HCI_CMD_PARAM_ADVERTISING_INTERVAL_MIN & 0xff00) >> 8;
    g_pattern_param.adv_param.Advertising_Interval_Min[0] =  HCI_CMD_PARAM_ADVERTISING_INTERVAL_MIN & 0x00ff;
    g_pattern_param.adv_param.Advertising_Interval_Min[1] = (HCI_CMD_PARAM_ADVERTISING_INTERVAL_MIN & 0xff00) >> 8;
    verdict = COMM_ADV_Undirected_Advertising(dut2_fd, g_pattern_param);
    VERDICT_RESULT_WITH_LINE();    
    
    sleep(1);
    CHECK_CONNECT();    
     
	dut_reset_with_mask_en(dut1_fd);

    MSLEEP(500);

    COMM_SCN_Active_Scanning_Config(dut1, &g_pattern_param);
    g_pattern_param.scn_param.Own_Address_Type[0] = HCI_CMD_PARAM_PUBLIC_DEVICE_ADDRESS;             
    g_pattern_param.scn_param.LE_Scan_Interval[0] =  0x0200 & 0x00ff;
    g_pattern_param.scn_param.LE_Scan_Interval[1] = (0x0200 & 0xff00) >> 8;
    g_pattern_param.scn_param.LE_Scan_Window[0] =    0x0200 & 0x00ff;
    g_pattern_param.scn_param.LE_Scan_Window[1] =   (0x0200 & 0xff00) >> 8;
	g_pattern_param.scn_param.Scanning_Filter_Policy[0] =	HCI_CMD_PARAM_IGNORE_ADV_PKTS_FROM_DEV_NOT_IN_WHITE_LIST_ONLY;

    verdict = COMM_SCN_Active_Scanning(dut1_fd, g_pattern_param);            
    VERDICT_RESULT_WITH_LINE();                

    while (check_cnt < 20) {
        if (SUCCESS != QUERY_LE_Event(dut1_fd, buf, _BT_HCI_LE_EVENT_SUB_OP_ADVERTISING_REPORT_, HCI_SUBEVENT_ADV_RPT_EVENT_ADV_IND)) {
            //query ADV report
            printf("****SUCCESS != QUERY_LE_Event****\n");
	        continue;
	    }				    
        else if (EQUAL == hci_le_event_advertising_report_parsing(HCI_SUBEVENT_ADV_RPT_EVENT_ADV_IND, buf, g_pattern_param)) {
             // Expect the IUT stop advertising                        
             printf("****EQUAL != HCI : %d****\n", err_cnt);             
             err_cnt++;
             if (50 <= err_cnt) {
                 line=__LINE__;
	            goto FUN_FAIL;
             }             
        }                        
        else {
             check_cnt ++ ;
             err_cnt = 0;
             printf("###run Loop : %d   ADV_Channel = %d ###\n", adv_cnt, adv_Channel);
             printf("** Lower Tester expects the IUT stop advertising : %d / 20 times **\n" , check_cnt);
        }
        
        MSLEEP(500);
    }

    dut_reset_with_mask_en(dut1_fd);
	dut_reset_with_mask_en(dut2_fd);
    MSLEEP(500);
	
	printf("** CH : %d, Lower Tester expects IUT don't advertise : %d / 20 times **\n" , adv_Channel, check_cnt);
	if(adv_Channel != 39){        
        adv_Channel ++;
		check_cnt   = 0;
		err_cnt     = 0;
        goto LOOP1;
    }
    else {
        adv_cnt++;
        check_cnt   = 0;
		err_cnt     = 0;
		adv_Channel = 37; // default
    }   

    /****************************************************************************  
        case 2,
        INI:
            Address : dut1_error_com_ass
            Type    : HCI_CMD_PARAM_RANDOM_DEVICE_ADDRESS
        ADV:
            adv_policy = 0x00(HCI_CMD_PARAM_ALLOW_SCAN_REQ_AND_CONN_REQ_FROM_ANY),

        Result : Expect the IUT stop advertising.
    *****************************************************************************/
    LOOP2: 
    // Uptest(white list) config
    COMM_INI_Connection_Setup_White_Listed_Config(dut2, &g_pattern_param);
    memcpy(g_pattern_param.white_list_param.Address, scan_addr, ADDR_LENGTH);
    g_pattern_param.white_list_param.Address_Type[0] = HCI_CMD_PARAM_PUBLIC_DEVICE_ADDRESS;
    verdict = COMM_INI_Connection_Setup_White_Listed(dut2_fd, g_pattern_param);
    VERDICT_RESULT_WITH_LINE();
    
    // ***********************************************************************************            
    // Lwtest(Init) config
    COMM_Static_Random_Device_Address_Set_Config(dut1_error_com_ass);
    COMM_Device_Address_Set(dut1_fd, g_pattern_param);
    COMM_INI_Initiating_Config(dut1, &g_pattern_param);
    g_pattern_param.create_conn_param.Own_Address_Type[0] = HCI_CMD_PARAM_RANDOM_DEVICE_ADDRESS;
    verdict = COMM_INI_Initiating(dut1_fd, g_pattern_param);            
    VERDICT_RESULT_WITH_LINE();
     
    // ***********************************************************************************            
    // IUT(ADV) config
    COMM_ADV_Undirected_Advertising_Config(HCI_CMD_PARAM_ADV_DATA_LEN_MAX, &g_pattern_param);            
    memcpy(g_pattern_param.adv_param.Direct_Address, adv_addr, ADDR_LENGTH);
    if(37 == adv_Channel) {
        g_pattern_param.adv_param.Advertising_Channel_Map[0] = HCI_CMD_PARAM_ENABLE_CHANNEL_37;
    }
    else if(38 == adv_Channel) {
        g_pattern_param.adv_param.Advertising_Channel_Map[0] = HCI_CMD_PARAM_ENABLE_CHANNEL_38;
    }
    else {
        g_pattern_param.adv_param.Advertising_Channel_Map[0] = HCI_CMD_PARAM_ENABLE_CHANNEL_39;
    }
    g_pattern_param.adv_param.Advertising_Filter_Policy[0] = HCI_CMD_PARAM_ALLOW_SCAN_REQ_AND_CONN_REQ_FROM_ANY;
    g_pattern_param.adv_param.Advertising_Interval_Max[0] =  HCI_CMD_PARAM_ADVERTISING_INTERVAL_MIN & 0x00ff;
    g_pattern_param.adv_param.Advertising_Interval_Max[1] = (HCI_CMD_PARAM_ADVERTISING_INTERVAL_MIN & 0xff00) >> 8;
    g_pattern_param.adv_param.Advertising_Interval_Min[0] =  HCI_CMD_PARAM_ADVERTISING_INTERVAL_MIN & 0x00ff;
    g_pattern_param.adv_param.Advertising_Interval_Min[1] = (HCI_CMD_PARAM_ADVERTISING_INTERVAL_MIN & 0xff00) >> 8;
    verdict = COMM_ADV_Undirected_Advertising(dut2_fd, g_pattern_param);
    VERDICT_RESULT_WITH_LINE();    

    sleep(1);
    CHECK_CONNECT();   
     
    dut_reset_with_mask_en(dut1_fd);	
    MSLEEP(500);
	
    COMM_SCN_Active_Scanning_Config(dut1, &g_pattern_param);
    g_pattern_param.scn_param.Own_Address_Type[0] = HCI_CMD_PARAM_PUBLIC_DEVICE_ADDRESS;             
    g_pattern_param.scn_param.LE_Scan_Interval[0] =  0x0200 & 0x00ff;
    g_pattern_param.scn_param.LE_Scan_Interval[1] = (0x0200 & 0xff00) >> 8;
    g_pattern_param.scn_param.LE_Scan_Window[0] =    0x0200 & 0x00ff;
    g_pattern_param.scn_param.LE_Scan_Window[1] =   (0x0200 & 0xff00) >> 8;
	g_pattern_param.scn_param.Scanning_Filter_Policy[0] =	HCI_CMD_PARAM_IGNORE_ADV_PKTS_FROM_DEV_NOT_IN_WHITE_LIST_ONLY;

    verdict = COMM_SCN_Active_Scanning(dut1_fd, g_pattern_param);            
    VERDICT_RESULT_WITH_LINE();                

    while (check_cnt < 20) {
        if (SUCCESS != QUERY_LE_Event(dut1_fd, buf, _BT_HCI_LE_EVENT_SUB_OP_ADVERTISING_REPORT_, HCI_SUBEVENT_ADV_RPT_EVENT_ADV_IND)) {
            //query ADV report
            printf("****SUCCESS != QUERY_LE_Event****\n");
	        continue;
	    }				    
        else if (EQUAL == hci_le_event_advertising_report_parsing(HCI_SUBEVENT_ADV_RPT_EVENT_ADV_IND, buf, g_pattern_param)) {
             // Expect the IUT stop advertising                        
             printf("****EQUAL != HCI : %d****\n", err_cnt);             
             err_cnt++;
             if (50 <= err_cnt) {
                 line=__LINE__;
	            goto FUN_FAIL;
             }             
        }                        
        else {
             check_cnt ++ ;
             err_cnt = 0;
             printf("###run case : %d   ADV_Channel = %d ###\n", adv_cnt, adv_Channel);
             printf("** Lower Tester expects the IUT stop advertising : %d / 20 times **\n" , check_cnt);
         }
        MSLEEP(500);
    }
	
	dut_reset_with_mask_en(dut1_fd);
	dut_reset_with_mask_en(dut2_fd);
    MSLEEP(500);
	
	printf("** CH : %d, Lower Tester expects IUT continue advertise : %d / 20 times **\n" , adv_Channel, check_cnt);
	if(adv_Channel != 39){        
        adv_Channel ++;
		check_cnt   = 0;
		err_cnt     = 0;
        goto LOOP2;
    }
    else {
        adv_cnt++;
        check_cnt   = 0;
		err_cnt     = 0;
		adv_Channel = 37; // default
    }

    /****************************************************************************  
        case 3,
        INI:
            Address : dut1_error_com_idf
            Type    : HCI_CMD_PARAM_RANDOM_DEVICE_ADDRESS
        ADV:
            adv_policy = 0x00(HCI_CMD_PARAM_ALLOW_SCAN_REQ_AND_CONN_REQ_FROM_ANY),

        Result : Expect the IUT stop advertising.
    *****************************************************************************/
    LOOP3: 
    // Uptest(white list) config
    COMM_INI_Connection_Setup_White_Listed_Config(dut2, &g_pattern_param);
    memcpy(g_pattern_param.white_list_param.Address, scan_addr, ADDR_LENGTH);
    g_pattern_param.white_list_param.Address_Type[0] = HCI_CMD_PARAM_PUBLIC_DEVICE_ADDRESS;
    verdict = COMM_INI_Connection_Setup_White_Listed(dut2_fd, g_pattern_param);
    VERDICT_RESULT_WITH_LINE();
    
    // ***********************************************************************************            
    // Lwtest(Init) config
    COMM_Static_Random_Device_Address_Set_Config(dut1_error_com_idf);
    COMM_Device_Address_Set(dut1_fd, g_pattern_param);
    COMM_INI_Initiating_Config(dut1, &g_pattern_param);
    g_pattern_param.create_conn_param.Own_Address_Type[0] = HCI_CMD_PARAM_RANDOM_DEVICE_ADDRESS;
    verdict = COMM_INI_Initiating(dut1_fd, g_pattern_param);            
    VERDICT_RESULT_WITH_LINE();
     
    // ***********************************************************************************            
    // IUT(ADV) config
    COMM_ADV_Undirected_Advertising_Config(HCI_CMD_PARAM_ADV_DATA_LEN_MAX, &g_pattern_param);            
    memcpy(g_pattern_param.adv_param.Direct_Address, adv_addr, ADDR_LENGTH);
    if(37 == adv_Channel) {
        g_pattern_param.adv_param.Advertising_Channel_Map[0] = HCI_CMD_PARAM_ENABLE_CHANNEL_37;
    }
    else if(38 == adv_Channel) {
        g_pattern_param.adv_param.Advertising_Channel_Map[0] = HCI_CMD_PARAM_ENABLE_CHANNEL_38;
    }
    else {
        g_pattern_param.adv_param.Advertising_Channel_Map[0] = HCI_CMD_PARAM_ENABLE_CHANNEL_39;
    }
    g_pattern_param.adv_param.Advertising_Filter_Policy[0] = HCI_CMD_PARAM_ALLOW_SCAN_REQ_AND_CONN_REQ_FROM_ANY;
    g_pattern_param.adv_param.Advertising_Interval_Max[0] =  HCI_CMD_PARAM_ADVERTISING_INTERVAL_MIN & 0x00ff;
    g_pattern_param.adv_param.Advertising_Interval_Max[1] = (HCI_CMD_PARAM_ADVERTISING_INTERVAL_MIN & 0xff00) >> 8;
    g_pattern_param.adv_param.Advertising_Interval_Min[0] =  HCI_CMD_PARAM_ADVERTISING_INTERVAL_MIN & 0x00ff;
    g_pattern_param.adv_param.Advertising_Interval_Min[1] = (HCI_CMD_PARAM_ADVERTISING_INTERVAL_MIN & 0xff00) >> 8;
    verdict = COMM_ADV_Undirected_Advertising(dut2_fd, g_pattern_param);
    VERDICT_RESULT_WITH_LINE();  
    
    sleep(1);
    CHECK_CONNECT();   
    
    dut_reset_with_mask_en(dut1_fd);	
    MSLEEP(500);
	
    COMM_SCN_Active_Scanning_Config(dut1, &g_pattern_param);
    g_pattern_param.scn_param.Own_Address_Type[0] = HCI_CMD_PARAM_PUBLIC_DEVICE_ADDRESS;             
    g_pattern_param.scn_param.LE_Scan_Interval[0] =  0x0200 & 0x00ff;
    g_pattern_param.scn_param.LE_Scan_Interval[1] = (0x0200 & 0xff00) >> 8;
    g_pattern_param.scn_param.LE_Scan_Window[0] =    0x0200 & 0x00ff;
    g_pattern_param.scn_param.LE_Scan_Window[1] =   (0x0200 & 0xff00) >> 8;
	g_pattern_param.scn_param.Scanning_Filter_Policy[0] =	HCI_CMD_PARAM_IGNORE_ADV_PKTS_FROM_DEV_NOT_IN_WHITE_LIST_ONLY;

    verdict = COMM_SCN_Active_Scanning(dut1_fd, g_pattern_param);            
    VERDICT_RESULT_WITH_LINE();                

    while (check_cnt < 20) {
        if (SUCCESS != QUERY_LE_Event(dut1_fd, buf, _BT_HCI_LE_EVENT_SUB_OP_ADVERTISING_REPORT_, HCI_SUBEVENT_ADV_RPT_EVENT_ADV_IND)) {
            //query ADV report
            printf("****SUCCESS != QUERY_LE_Event****\n");
	        continue;
	    }				    
        else if (EQUAL == hci_le_event_advertising_report_parsing(HCI_SUBEVENT_ADV_RPT_EVENT_ADV_IND, buf, g_pattern_param)) {
             // Expect the IUT stop advertising                        
             printf("****EQUAL != HCI : %d****\n", err_cnt);             
             err_cnt++;
             if (50 <= err_cnt) {
                 line=__LINE__;
	            goto FUN_FAIL;
             }             
        }                        
        else {
             check_cnt ++ ;
             err_cnt = 0;
             printf("###run case : %d   ADV_Channel = %d ###\n", adv_cnt, adv_Channel);
             printf("** Lower Tester expects the IUT stop advertising : %d / 20 times **\n" , check_cnt);
         }
        MSLEEP(500);
    }   

	dut_reset_with_mask_en(dut1_fd);
	dut_reset_with_mask_en(dut2_fd);
    MSLEEP(500);
	
	printf("** CH : %d, Lower Tester expects IUT continue advertise : %d / 20 times **\n" , adv_Channel, check_cnt);
	if(adv_Channel != 39){        
        adv_Channel ++;
		check_cnt   = 0;
		err_cnt     = 0;
        goto LOOP3;
    }
    else {
        adv_cnt++;
        check_cnt   = 0;
		err_cnt     = 0;
		adv_Channel = 37; // default
    }

    /****************************************************************************  
        case 4,
        INI:
            Address : dut1_error_both
            Type    : HCI_CMD_PARAM_RANDOM_DEVICE_ADDRESS
        ADV:
            adv_policy = 0x00(HCI_CMD_PARAM_ALLOW_SCAN_REQ_AND_CONN_REQ_FROM_ANY),

        Result : Expect the IUT stop advertising.
    *****************************************************************************/
    LOOP4: 
    // Uptest(white list) config
    COMM_INI_Connection_Setup_White_Listed_Config(dut2, &g_pattern_param);
    memcpy(g_pattern_param.white_list_param.Address, scan_addr, ADDR_LENGTH);
    g_pattern_param.white_list_param.Address_Type[0] = HCI_CMD_PARAM_PUBLIC_DEVICE_ADDRESS;
    verdict = COMM_INI_Connection_Setup_White_Listed(dut2_fd, g_pattern_param);
    VERDICT_RESULT_WITH_LINE();
    
    // ***********************************************************************************            
    // Lwtest(Init) config
    COMM_Static_Random_Device_Address_Set_Config(dut1_error_both);
    COMM_Device_Address_Set(dut1_fd, g_pattern_param);
    COMM_INI_Initiating_Config(dut1, &g_pattern_param);
    g_pattern_param.create_conn_param.Own_Address_Type[0] = HCI_CMD_PARAM_RANDOM_DEVICE_ADDRESS;
    verdict = COMM_INI_Initiating(dut1_fd, g_pattern_param);            
    VERDICT_RESULT_WITH_LINE();
     
    // ***********************************************************************************            
    // IUT(ADV) config
    COMM_ADV_Undirected_Advertising_Config(HCI_CMD_PARAM_ADV_DATA_LEN_MAX, &g_pattern_param);            
    memcpy(g_pattern_param.adv_param.Direct_Address, adv_addr, ADDR_LENGTH);
    if(37 == adv_Channel) {
        g_pattern_param.adv_param.Advertising_Channel_Map[0] = HCI_CMD_PARAM_ENABLE_CHANNEL_37;
    }
    else if(38 == adv_Channel) {
        g_pattern_param.adv_param.Advertising_Channel_Map[0] = HCI_CMD_PARAM_ENABLE_CHANNEL_38;
    }
    else {
        g_pattern_param.adv_param.Advertising_Channel_Map[0] = HCI_CMD_PARAM_ENABLE_CHANNEL_39;
    }
    g_pattern_param.adv_param.Advertising_Filter_Policy[0] = HCI_CMD_PARAM_ALLOW_SCAN_REQ_AND_CONN_REQ_FROM_ANY;
    g_pattern_param.adv_param.Advertising_Interval_Max[0] =  HCI_CMD_PARAM_ADVERTISING_INTERVAL_MIN & 0x00ff;
    g_pattern_param.adv_param.Advertising_Interval_Max[1] = (HCI_CMD_PARAM_ADVERTISING_INTERVAL_MIN & 0xff00) >> 8;
    g_pattern_param.adv_param.Advertising_Interval_Min[0] =  HCI_CMD_PARAM_ADVERTISING_INTERVAL_MIN & 0x00ff;
    g_pattern_param.adv_param.Advertising_Interval_Min[1] = (HCI_CMD_PARAM_ADVERTISING_INTERVAL_MIN & 0xff00) >> 8;
    verdict = COMM_ADV_Undirected_Advertising(dut2_fd, g_pattern_param);
    VERDICT_RESULT_WITH_LINE();    

    sleep(1);
    CHECK_CONNECT();

    dut_reset_with_mask_en(dut1_fd);
    MSLEEP(500);
    
    COMM_SCN_Active_Scanning_Config(dut1, &g_pattern_param);
    g_pattern_param.scn_param.Own_Address_Type[0] = HCI_CMD_PARAM_PUBLIC_DEVICE_ADDRESS;             
    g_pattern_param.scn_param.LE_Scan_Interval[0] =  0x0200 & 0x00ff;
    g_pattern_param.scn_param.LE_Scan_Interval[1] = (0x0200 & 0xff00) >> 8;
    g_pattern_param.scn_param.LE_Scan_Window[0] =    0x0200 & 0x00ff;
    g_pattern_param.scn_param.LE_Scan_Window[1] =   (0x0200 & 0xff00) >> 8;
	g_pattern_param.scn_param.Scanning_Filter_Policy[0] =	HCI_CMD_PARAM_IGNORE_ADV_PKTS_FROM_DEV_NOT_IN_WHITE_LIST_ONLY;

    verdict = COMM_SCN_Active_Scanning(dut1_fd, g_pattern_param);            
    VERDICT_RESULT_WITH_LINE();                

    while (check_cnt < 20) {
        if (SUCCESS != QUERY_LE_Event(dut1_fd, buf, _BT_HCI_LE_EVENT_SUB_OP_ADVERTISING_REPORT_, HCI_SUBEVENT_ADV_RPT_EVENT_ADV_IND)) {
            //query ADV report
            printf("****SUCCESS != QUERY_LE_Event****\n");
	        continue;
	    }				    
        else if (EQUAL == hci_le_event_advertising_report_parsing(HCI_SUBEVENT_ADV_RPT_EVENT_ADV_IND, buf, g_pattern_param)) {
             // Expect the IUT stop advertising                        
             printf("****EQUAL != HCI : %d****\n", err_cnt);             
             err_cnt++;
             if (50 <= err_cnt) {
                 line=__LINE__;
	            goto FUN_FAIL;
             }             
        }                        
        else {
             check_cnt ++ ;
             err_cnt = 0;
             printf("###run case : %d   ADV_Channel = %d ###\n", adv_cnt, adv_Channel);
             printf("** Lower Tester expects the IUT stop advertising : %d / 20 times **\n" , check_cnt);
         }
        MSLEEP(500);
    }   

	dut_reset_with_mask_en(dut1_fd);
	dut_reset_with_mask_en(dut2_fd);
    MSLEEP(500);
	
	printf("** CH : %d, Lower Tester expects IUT continue advertise : %d / 20 times **\n" , adv_Channel, check_cnt);
	if(adv_Channel != 39){        
        adv_Channel ++;
		check_cnt   = 0;
		err_cnt     = 0;
        goto LOOP4;
    }
    else {
        adv_cnt++;
        check_cnt   = 0;
		err_cnt     = 0;
		adv_Channel = 37; // default
    }

    /****************************************************************************  
        case 5,
        INI:
            Address : scan_addr
            Type    : HCI_CMD_PARAM_PUBLIC_DEVICE_ADDRESS
        ADV:
            adv_policy = 0x01(HCI_CMD_PARAM_ALLOW_SCAN_REQ_FROM_WHITELIST_ONLY_AND_CONN_REQ_FROM_ANY),

        Result : Expect the IUT stop advertising.
    *****************************************************************************/
    LOOP5: 
    // Uptest(white list) config
    COMM_INI_Connection_Setup_White_Listed_Config(dut2, &g_pattern_param);
    memcpy(g_pattern_param.white_list_param.Address, scan_addr, ADDR_LENGTH);
    g_pattern_param.white_list_param.Address_Type[0] = HCI_CMD_PARAM_PUBLIC_DEVICE_ADDRESS;
    verdict = COMM_INI_Connection_Setup_White_Listed(dut2_fd, g_pattern_param);
    VERDICT_RESULT_WITH_LINE();
    
    // ***********************************************************************************            
    // Lwtest(Init) config
    //COMM_Static_Random_Device_Address_Set_Config(dut1_error_both);
    //COMM_Device_Address_Set(dut1_fd, g_pattern_param);
    COMM_INI_Initiating_Config(dut1, &g_pattern_param);
    g_pattern_param.create_conn_param.Own_Address_Type[0] = HCI_CMD_PARAM_PUBLIC_DEVICE_ADDRESS;
    verdict = COMM_INI_Initiating(dut1_fd, g_pattern_param);            
    VERDICT_RESULT_WITH_LINE();
     
    // ***********************************************************************************            
    // IUT(ADV) config
    COMM_ADV_Undirected_Advertising_Config(HCI_CMD_PARAM_ADV_DATA_LEN_MAX, &g_pattern_param);            
    memcpy(g_pattern_param.adv_param.Direct_Address, adv_addr, ADDR_LENGTH);
    if(37 == adv_Channel) {
        g_pattern_param.adv_param.Advertising_Channel_Map[0] = HCI_CMD_PARAM_ENABLE_CHANNEL_37;
    }
    else if(38 == adv_Channel) {
        g_pattern_param.adv_param.Advertising_Channel_Map[0] = HCI_CMD_PARAM_ENABLE_CHANNEL_38;
    }
    else {
        g_pattern_param.adv_param.Advertising_Channel_Map[0] = HCI_CMD_PARAM_ENABLE_CHANNEL_39;
    }
    g_pattern_param.adv_param.Advertising_Filter_Policy[0] = HCI_CMD_PARAM_ALLOW_SCAN_REQ_FROM_WHITELIST_ONLY_AND_CONN_REQ_FROM_ANY;
    g_pattern_param.adv_param.Advertising_Interval_Max[0] =  HCI_CMD_PARAM_ADVERTISING_INTERVAL_MIN & 0x00ff;
    g_pattern_param.adv_param.Advertising_Interval_Max[1] = (HCI_CMD_PARAM_ADVERTISING_INTERVAL_MIN & 0xff00) >> 8;
    g_pattern_param.adv_param.Advertising_Interval_Min[0] =  HCI_CMD_PARAM_ADVERTISING_INTERVAL_MIN & 0x00ff;
    g_pattern_param.adv_param.Advertising_Interval_Min[1] = (HCI_CMD_PARAM_ADVERTISING_INTERVAL_MIN & 0xff00) >> 8;
    verdict = COMM_ADV_Undirected_Advertising(dut2_fd, g_pattern_param);
    VERDICT_RESULT_WITH_LINE();    

    sleep(1);
    CHECK_CONNECT();   
    
    dut_reset_with_mask_en(dut1_fd);
    MSLEEP(500);
    
    COMM_SCN_Active_Scanning_Config(dut1, &g_pattern_param);
    g_pattern_param.scn_param.Own_Address_Type[0] = HCI_CMD_PARAM_PUBLIC_DEVICE_ADDRESS;             
    g_pattern_param.scn_param.LE_Scan_Interval[0] =  0x0200 & 0x00ff;
    g_pattern_param.scn_param.LE_Scan_Interval[1] = (0x0200 & 0xff00) >> 8;
    g_pattern_param.scn_param.LE_Scan_Window[0] =    0x0200 & 0x00ff;
    g_pattern_param.scn_param.LE_Scan_Window[1] =   (0x0200 & 0xff00) >> 8;
	g_pattern_param.scn_param.Scanning_Filter_Policy[0] =	HCI_CMD_PARAM_IGNORE_ADV_PKTS_FROM_DEV_NOT_IN_WHITE_LIST_ONLY;    
    verdict = COMM_SCN_Active_Scanning(dut1_fd, g_pattern_param);            
    VERDICT_RESULT_WITH_LINE();                

    while (check_cnt < 20) {
        if (SUCCESS != QUERY_LE_Event(dut1_fd, buf, _BT_HCI_LE_EVENT_SUB_OP_ADVERTISING_REPORT_, HCI_SUBEVENT_ADV_RPT_EVENT_ADV_IND)) {
            //query ADV report
            printf("****SUCCESS != QUERY_LE_Event****\n");
	        continue;
	    }				    
        else if (EQUAL == hci_le_event_advertising_report_parsing(HCI_SUBEVENT_ADV_RPT_EVENT_ADV_IND, buf, g_pattern_param)) {
             // Expect the IUT stop advertising                        
             printf("****EQUAL != HCI : %d****\n", err_cnt);             
             err_cnt++;
             if (50 <= err_cnt) {
                 line=__LINE__;
	            goto FUN_FAIL;
             }             
        }                        
        else {
             check_cnt ++ ;
             err_cnt = 0;
             printf("###run case : %d   ADV_Channel = %d ###\n", adv_cnt, adv_Channel);
             printf("** Lower Tester expects the IUT stop advertising : %d / 20 times **\n" , check_cnt);
         }
        MSLEEP(500);
    }   

	dut_reset_with_mask_en(dut1_fd);
	dut_reset_with_mask_en(dut2_fd);
    MSLEEP(500);
	
	printf("** CH : %d, Lower Tester expects IUT continue advertise : %d / 20 times **\n" , adv_Channel, check_cnt);
	if(adv_Channel != 39){        
        adv_Channel ++;
		check_cnt   = 0;
		err_cnt     = 0;
        goto LOOP5;
    }
    else {
        adv_cnt++;
        check_cnt   = 0;
		err_cnt     = 0;
		adv_Channel = 37; // default
    }

    /****************************************************************************  
        case 6,
        INI:
            Address : dut1_error_com_ass
            Type    : HCI_CMD_PARAM_RANDOM_DEVICE_ADDRESS
        ADV:
            adv_policy = 0x01(HCI_CMD_PARAM_ALLOW_SCAN_REQ_FROM_WHITELIST_ONLY_AND_CONN_REQ_FROM_ANY),

        Result : Expect the IUT stop advertising.
    *****************************************************************************/
    LOOP6: 
    // Uptest(white list) config
    COMM_INI_Connection_Setup_White_Listed_Config(dut2, &g_pattern_param);
    memcpy(g_pattern_param.white_list_param.Address, scan_addr, ADDR_LENGTH);
    g_pattern_param.white_list_param.Address_Type[0] = HCI_CMD_PARAM_PUBLIC_DEVICE_ADDRESS;
    verdict = COMM_INI_Connection_Setup_White_Listed(dut2_fd, g_pattern_param);
    VERDICT_RESULT_WITH_LINE();
    
    // ***********************************************************************************            
    // Lwtest(Init) config
    COMM_Static_Random_Device_Address_Set_Config(dut1_error_com_ass);
    COMM_Device_Address_Set(dut1_fd, g_pattern_param);
    COMM_INI_Initiating_Config(dut1, &g_pattern_param);
    g_pattern_param.create_conn_param.Own_Address_Type[0] = HCI_CMD_PARAM_RANDOM_DEVICE_ADDRESS;
    verdict = COMM_INI_Initiating(dut1_fd, g_pattern_param);            
    VERDICT_RESULT_WITH_LINE();
     
    // ***********************************************************************************            
    // IUT(ADV) config
    COMM_ADV_Undirected_Advertising_Config(HCI_CMD_PARAM_ADV_DATA_LEN_MAX, &g_pattern_param);            
    memcpy(g_pattern_param.adv_param.Direct_Address, adv_addr, ADDR_LENGTH);
    if(37 == adv_Channel) {
        g_pattern_param.adv_param.Advertising_Channel_Map[0] = HCI_CMD_PARAM_ENABLE_CHANNEL_37;
    }
    else if(38 == adv_Channel) {
        g_pattern_param.adv_param.Advertising_Channel_Map[0] = HCI_CMD_PARAM_ENABLE_CHANNEL_38;
    }
    else {
        g_pattern_param.adv_param.Advertising_Channel_Map[0] = HCI_CMD_PARAM_ENABLE_CHANNEL_39;
    }
    g_pattern_param.adv_param.Advertising_Filter_Policy[0] = HCI_CMD_PARAM_ALLOW_SCAN_REQ_FROM_WHITELIST_ONLY_AND_CONN_REQ_FROM_ANY;
    g_pattern_param.adv_param.Advertising_Interval_Max[0] =  HCI_CMD_PARAM_ADVERTISING_INTERVAL_MIN & 0x00ff;
    g_pattern_param.adv_param.Advertising_Interval_Max[1] = (HCI_CMD_PARAM_ADVERTISING_INTERVAL_MIN & 0xff00) >> 8;
    g_pattern_param.adv_param.Advertising_Interval_Min[0] =  HCI_CMD_PARAM_ADVERTISING_INTERVAL_MIN & 0x00ff;
    g_pattern_param.adv_param.Advertising_Interval_Min[1] = (HCI_CMD_PARAM_ADVERTISING_INTERVAL_MIN & 0xff00) >> 8;
    verdict = COMM_ADV_Undirected_Advertising(dut2_fd, g_pattern_param);
    VERDICT_RESULT_WITH_LINE();    

    sleep(1);
    CHECK_CONNECT();   
    
    dut_reset_with_mask_en(dut1_fd);
    MSLEEP(500);
    
    COMM_SCN_Active_Scanning_Config(dut1, &g_pattern_param);
    g_pattern_param.scn_param.Own_Address_Type[0] = HCI_CMD_PARAM_PUBLIC_DEVICE_ADDRESS;             
    g_pattern_param.scn_param.LE_Scan_Interval[0] =  0x0200 & 0x00ff;
    g_pattern_param.scn_param.LE_Scan_Interval[1] = (0x0200 & 0xff00) >> 8;
    g_pattern_param.scn_param.LE_Scan_Window[0] =    0x0200 & 0x00ff;
    g_pattern_param.scn_param.LE_Scan_Window[1] =   (0x0200 & 0xff00) >> 8;
	g_pattern_param.scn_param.Scanning_Filter_Policy[0] =	HCI_CMD_PARAM_IGNORE_ADV_PKTS_FROM_DEV_NOT_IN_WHITE_LIST_ONLY;
    
    verdict = COMM_SCN_Active_Scanning(dut1_fd, g_pattern_param);            
    VERDICT_RESULT_WITH_LINE();                

    while (check_cnt < 20) {
        if (SUCCESS != QUERY_LE_Event(dut1_fd, buf, _BT_HCI_LE_EVENT_SUB_OP_ADVERTISING_REPORT_, HCI_SUBEVENT_ADV_RPT_EVENT_ADV_IND)) {
            //query ADV report
            printf("****SUCCESS != QUERY_LE_Event****\n");
	        continue;
	    }				    
        else if (EQUAL == hci_le_event_advertising_report_parsing(HCI_SUBEVENT_ADV_RPT_EVENT_ADV_IND, buf, g_pattern_param)) {
             // Expect the IUT stop advertising                        
             printf("****EQUAL != HCI : %d****\n", err_cnt);             
             err_cnt++;
             if (50 <= err_cnt) {
                 line=__LINE__;
	            goto FUN_FAIL;
             }             
        }                        
        else {
             check_cnt ++ ;
             err_cnt = 0;
             printf("###run case : %d   ADV_Channel = %d ###\n", adv_cnt, adv_Channel);
             printf("** Lower Tester expects the IUT stop advertising : %d / 20 times **\n" , check_cnt);
         }
        MSLEEP(500);
    }

	dut_reset_with_mask_en(dut1_fd);
	dut_reset_with_mask_en(dut2_fd);
    MSLEEP(500);
	
	printf("** CH : %d, Lower Tester expects IUT continue advertise : %d / 20 times **\n" , adv_Channel, check_cnt);
	if(adv_Channel != 39){        
        adv_Channel ++;
		check_cnt   = 0;
		err_cnt     = 0;
        goto LOOP6;
    }
    else {
        adv_cnt++;
        check_cnt   = 0;
		err_cnt     = 0;
		adv_Channel = 37; // default
    }
    
    /****************************************************************************  
        case 7,
        INI:
            Address : dut1_error_com_ass
            Type    : HCI_CMD_PARAM_RANDOM_DEVICE_ADDRESS
        ADV:
            adv_policy = 0x01(HCI_CMD_PARAM_ALLOW_SCAN_REQ_FROM_WHITELIST_ONLY_AND_CONN_REQ_FROM_ANY),

        Result : Expect the IUT stop advertising.
    *****************************************************************************/
    LOOP7: 
    // Uptest(white list) config
    COMM_INI_Connection_Setup_White_Listed_Config(dut2, &g_pattern_param);
    memcpy(g_pattern_param.white_list_param.Address, scan_addr, ADDR_LENGTH);
    g_pattern_param.white_list_param.Address_Type[0] = HCI_CMD_PARAM_PUBLIC_DEVICE_ADDRESS;
    verdict = COMM_INI_Connection_Setup_White_Listed(dut2_fd, g_pattern_param);
    VERDICT_RESULT_WITH_LINE();
    
    // ***********************************************************************************            
    // Lwtest(Init) config
    COMM_Static_Random_Device_Address_Set_Config(dut1_error_com_ass);
    COMM_Device_Address_Set(dut1_fd, g_pattern_param);
    COMM_INI_Initiating_Config(dut1, &g_pattern_param);
    g_pattern_param.create_conn_param.Own_Address_Type[0] = HCI_CMD_PARAM_RANDOM_DEVICE_ADDRESS;
    verdict = COMM_INI_Initiating(dut1_fd, g_pattern_param);            
    VERDICT_RESULT_WITH_LINE();
     
    // ***********************************************************************************            
    // IUT(ADV) config
    COMM_ADV_Undirected_Advertising_Config(HCI_CMD_PARAM_ADV_DATA_LEN_MAX, &g_pattern_param);            
    memcpy(g_pattern_param.adv_param.Direct_Address, adv_addr, ADDR_LENGTH);
    if(37 == adv_Channel) {
        g_pattern_param.adv_param.Advertising_Channel_Map[0] = HCI_CMD_PARAM_ENABLE_CHANNEL_37;
    }
    else if(38 == adv_Channel) {
        g_pattern_param.adv_param.Advertising_Channel_Map[0] = HCI_CMD_PARAM_ENABLE_CHANNEL_38;
    }
    else {
        g_pattern_param.adv_param.Advertising_Channel_Map[0] = HCI_CMD_PARAM_ENABLE_CHANNEL_39;
    }
    g_pattern_param.adv_param.Advertising_Filter_Policy[0] = HCI_CMD_PARAM_ALLOW_SCAN_REQ_FROM_WHITELIST_ONLY_AND_CONN_REQ_FROM_ANY;
    g_pattern_param.adv_param.Advertising_Interval_Max[0] = HCI_CMD_PARAM_ADVERTISING_INTERVAL_MIN & 0x00ff;
    g_pattern_param.adv_param.Advertising_Interval_Max[1] = (HCI_CMD_PARAM_ADVERTISING_INTERVAL_MIN & 0xff00) >> 8;
    g_pattern_param.adv_param.Advertising_Interval_Min[0] = HCI_CMD_PARAM_ADVERTISING_INTERVAL_MIN & 0x00ff;
    g_pattern_param.adv_param.Advertising_Interval_Min[1] = (HCI_CMD_PARAM_ADVERTISING_INTERVAL_MIN & 0xff00) >> 8;
    verdict = COMM_ADV_Undirected_Advertising(dut2_fd, g_pattern_param);
    VERDICT_RESULT_WITH_LINE();    

    sleep(1);
    CHECK_CONNECT();
    
    dut_reset_with_mask_en(dut1_fd);
    MSLEEP(500);
    
    COMM_SCN_Active_Scanning_Config(dut1, &g_pattern_param);
    g_pattern_param.scn_param.Own_Address_Type[0] = HCI_CMD_PARAM_PUBLIC_DEVICE_ADDRESS;             
    g_pattern_param.scn_param.LE_Scan_Interval[0] =  0x0200 & 0x00ff;
    g_pattern_param.scn_param.LE_Scan_Interval[1] = (0x0200 & 0xff00) >> 8;
    g_pattern_param.scn_param.LE_Scan_Window[0] =    0x0200 & 0x00ff;
    g_pattern_param.scn_param.LE_Scan_Window[1] =   (0x0200 & 0xff00) >> 8;
	g_pattern_param.scn_param.Scanning_Filter_Policy[0] =	HCI_CMD_PARAM_IGNORE_ADV_PKTS_FROM_DEV_NOT_IN_WHITE_LIST_ONLY;    
    verdict = COMM_SCN_Active_Scanning(dut1_fd, g_pattern_param);            
    VERDICT_RESULT_WITH_LINE();                

    while (check_cnt < 20) {
        if (SUCCESS != QUERY_LE_Event(dut1_fd, buf, _BT_HCI_LE_EVENT_SUB_OP_ADVERTISING_REPORT_, HCI_SUBEVENT_ADV_RPT_EVENT_ADV_IND)) {
            //query ADV report
            printf("****SUCCESS != QUERY_LE_Event****\n");
	        continue;
	    }				    
        else if (EQUAL == hci_le_event_advertising_report_parsing(HCI_SUBEVENT_ADV_RPT_EVENT_ADV_IND, buf, g_pattern_param)) {
             // Expect the IUT stop advertising                        
             printf("****EQUAL != HCI : %d****\n", err_cnt);             
             err_cnt++;
             if (50 <= err_cnt) {
                 line=__LINE__;
	            goto FUN_FAIL;
             }             
        }                        
        else {
             check_cnt ++ ;
             err_cnt = 0;
             printf("###run case : %d   ADV_Channel = %d ###\n", adv_cnt, adv_Channel);
             printf("** Lower Tester expects the IUT stop advertising : %d / 20 times **\n" , check_cnt);
         }
        MSLEEP(500);
    }

    dut_reset_with_mask_en(dut1_fd);
	dut_reset_with_mask_en(dut2_fd);
    MSLEEP(500);
    
	printf("** CH : %d, Lower Tester expects IUT continue advertise : %d / 20 times **\n" , adv_Channel, check_cnt);
	if(adv_Channel != 39){        
        adv_Channel ++;
		check_cnt   = 0;
		err_cnt     = 0;
        goto LOOP7;
    }
    else {
        adv_cnt++;
        check_cnt   = 0;
		err_cnt     = 0;
		adv_Channel = 37; // default
    }

    /****************************************************************************  
        case 8,
        INI:
            Address : dut1_error_both
            Type    : HCI_CMD_PARAM_RANDOM_DEVICE_ADDRESS
        ADV:
            adv_policy = 0x01(HCI_CMD_PARAM_ALLOW_SCAN_REQ_FROM_WHITELIST_ONLY_AND_CONN_REQ_FROM_ANY),

        Result : Expect the IUT stop advertising.
    *****************************************************************************/
    LOOP8: 
    // Uptest(white list) config
    COMM_INI_Connection_Setup_White_Listed_Config(dut2, &g_pattern_param);
    memcpy(g_pattern_param.white_list_param.Address, scan_addr, ADDR_LENGTH);
    g_pattern_param.white_list_param.Address_Type[0] = HCI_CMD_PARAM_PUBLIC_DEVICE_ADDRESS;
    verdict = COMM_INI_Connection_Setup_White_Listed(dut2_fd, g_pattern_param);
    VERDICT_RESULT_WITH_LINE();
    
    // ***********************************************************************************            
    // Lwtest(Init) config
    COMM_Static_Random_Device_Address_Set_Config(dut1_error_both);
    COMM_Device_Address_Set(dut1_fd, g_pattern_param);
    COMM_INI_Initiating_Config(dut1, &g_pattern_param);
    g_pattern_param.create_conn_param.Own_Address_Type[0] = HCI_CMD_PARAM_RANDOM_DEVICE_ADDRESS;
    verdict = COMM_INI_Initiating(dut1_fd, g_pattern_param);            
    VERDICT_RESULT_WITH_LINE();
     
    // ***********************************************************************************            
    // IUT(ADV) config
    COMM_ADV_Undirected_Advertising_Config(HCI_CMD_PARAM_ADV_DATA_LEN_MAX, &g_pattern_param);            
    memcpy(g_pattern_param.adv_param.Direct_Address, adv_addr, ADDR_LENGTH);
    if(37 == adv_Channel) {
        g_pattern_param.adv_param.Advertising_Channel_Map[0] = HCI_CMD_PARAM_ENABLE_CHANNEL_37;
    }
    else if(38 == adv_Channel) {
        g_pattern_param.adv_param.Advertising_Channel_Map[0] = HCI_CMD_PARAM_ENABLE_CHANNEL_38;
    }
    else {
        g_pattern_param.adv_param.Advertising_Channel_Map[0] = HCI_CMD_PARAM_ENABLE_CHANNEL_39;
    }
    g_pattern_param.adv_param.Advertising_Filter_Policy[0] = HCI_CMD_PARAM_ALLOW_SCAN_REQ_FROM_WHITELIST_ONLY_AND_CONN_REQ_FROM_ANY;
    g_pattern_param.adv_param.Advertising_Interval_Max[0] = HCI_CMD_PARAM_ADVERTISING_INTERVAL_MIN & 0x00ff;
    g_pattern_param.adv_param.Advertising_Interval_Max[1] = (HCI_CMD_PARAM_ADVERTISING_INTERVAL_MIN & 0xff00) >> 8;
    g_pattern_param.adv_param.Advertising_Interval_Min[0] = HCI_CMD_PARAM_ADVERTISING_INTERVAL_MIN & 0x00ff;
    g_pattern_param.adv_param.Advertising_Interval_Min[1] = (HCI_CMD_PARAM_ADVERTISING_INTERVAL_MIN & 0xff00) >> 8;
    verdict = COMM_ADV_Undirected_Advertising(dut2_fd, g_pattern_param);
    VERDICT_RESULT_WITH_LINE();    

    sleep(1);
    CHECK_CONNECT();   

    dut_reset_with_mask_en(dut1_fd);
    MSLEEP(500);
    
    COMM_SCN_Active_Scanning_Config(dut1, &g_pattern_param);
    g_pattern_param.scn_param.Own_Address_Type[0] = HCI_CMD_PARAM_PUBLIC_DEVICE_ADDRESS;             
    g_pattern_param.scn_param.LE_Scan_Interval[0] =  0x0200 & 0x00ff;
    g_pattern_param.scn_param.LE_Scan_Interval[1] = (0x0200 & 0xff00) >> 8;
    g_pattern_param.scn_param.LE_Scan_Window[0] =    0x0200 & 0x00ff;
    g_pattern_param.scn_param.LE_Scan_Window[1] =   (0x0200 & 0xff00) >> 8;
	g_pattern_param.scn_param.Scanning_Filter_Policy[0] =	HCI_CMD_PARAM_IGNORE_ADV_PKTS_FROM_DEV_NOT_IN_WHITE_LIST_ONLY;
    verdict = COMM_SCN_Active_Scanning(dut1_fd, g_pattern_param);            
    VERDICT_RESULT_WITH_LINE();                

    while (check_cnt < 20) {
        if (SUCCESS != QUERY_LE_Event(dut1_fd, buf, _BT_HCI_LE_EVENT_SUB_OP_ADVERTISING_REPORT_, HCI_SUBEVENT_ADV_RPT_EVENT_ADV_IND)) {
            //query ADV report
            printf("****SUCCESS != QUERY_LE_Event****\n");
	        continue;
	    }				    
        else if (EQUAL == hci_le_event_advertising_report_parsing(HCI_SUBEVENT_ADV_RPT_EVENT_ADV_IND, buf, g_pattern_param)) {
             // Expect the IUT stop advertising                        
             printf("****EQUAL != HCI : %d****\n", err_cnt);             
             err_cnt++;
             if (50 <= err_cnt) {
                 line=__LINE__;
	            goto FUN_FAIL;
             }             
        }                        
        else {
             check_cnt ++ ;
             err_cnt = 0;
             printf("###run case : %d   ADV_Channel = %d ###\n", adv_cnt, adv_Channel);
             printf("** Lower Tester expects the IUT stop advertising : %d / 20 times **\n" , check_cnt);
         }
        MSLEEP(500);
    }

	dut_reset_with_mask_en(dut1_fd);
	dut_reset_with_mask_en(dut2_fd);
    MSLEEP(500);
	
	printf("** CH : %d, Lower Tester expects IUT continue advertise : %d / 20 times **\n" , adv_Channel, check_cnt);
	if(adv_Channel != 39){        
        adv_Channel ++;
		check_cnt   = 0;
		err_cnt     = 0;
        goto LOOP8;
    }
    else {
        adv_cnt++;
        check_cnt   = 0;
		err_cnt     = 0;
		adv_Channel = 37; // default
    }    
    FUNC_END();

    LOG_INFO("[Pattern][%s]SUCCESS\n" ,__FUNCTION__);
    return PASS;
        
FUN_FAIL:
    FUNC_END();

    LOG_INFO("[Pattern][%s]:%d FAIL, \n" ,__FUNCTION__,line);
    return FAIL;

}

// 5.2.1.7
verdict DDI_ADV_Scan_Request_Connection_Request(u8 dut1_fd ,u8 dut2_fd)
{
	u8 buf[SOCKET_BUF_SIZE];	
	int verdict = FAIL;
	int dut1 = 0;
	u16 line = 0;
	struct itimerval timer;
	u8 check_cnt = 0;
	u8 conn_handles_mas[2];
	int num = 0;
    int err_cnt = 0;

    COMM_Dut_clean_buffer(dut1_fd);
    COMM_Dut_clean_buffer(dut2_fd);

    Calculate_Execution_Time_Start();
REPEAT:

    COMM_INI_Connection_Setup_White_Listed_Config(dut1, &g_pattern_param);
	memcpy(g_pattern_param.white_list_param.Address, adv_addr, ADDR_LENGTH);
	verdict=COMM_INI_Connection_Setup_White_Listed(dut1_fd, g_pattern_param);
	VERDICT_RESULT_WITH_LINE();
	
	// # set dut1 for scan
	// # p1:
	// # a.all adv channel
	// # b.min adv interval
	// # c.filter policy to 0
	COMM_SCN_Active_Scanning_Config(dut1, &g_pattern_param);
	g_pattern_param.scn_param.LE_Scan_Interval[0] =  0x0500 & 0x00ff;
    g_pattern_param.scn_param.LE_Scan_Interval[1] = (0x0500 & 0xff00) >> 8;
    g_pattern_param.scn_param.LE_Scan_Window[0] =    0x0500 & 0x00ff;
    g_pattern_param.scn_param.LE_Scan_Window[1] =   (0x0500 & 0xff00) >> 8;
	g_pattern_param.scn_param.Scanning_Filter_Policy[0] =	HCI_CMD_PARAM_IGNORE_ADV_PKTS_FROM_DEV_NOT_IN_WHITE_LIST_ONLY;
	verdict = COMM_SCN_Active_Scanning(dut1_fd, g_pattern_param);
	VERDICT_RESULT_WITH_LINE();

	// # set dut2 for adv
	// # p2:
	// # a.adv report
	// # b.scan rsp
	COMM_ADV_Undirected_Advertising_Config(HCI_CMD_PARAM_ADV_DATA_LEN_MAX, &g_pattern_param);
    if(num == 0){
		g_pattern_param.adv_param.Advertising_Channel_Map[0] = HCI_CMD_PARAM_ENABLE_CHANNEL_37;
	}
	else if(num == 1){
		g_pattern_param.adv_param.Advertising_Channel_Map[0] = HCI_CMD_PARAM_ENABLE_CHANNEL_38;
	}
	else if(num == 2){
		g_pattern_param.adv_param.Advertising_Channel_Map[0] = HCI_CMD_PARAM_ENABLE_CHANNEL_39;
	}
	g_pattern_param.adv_param.Advertising_Filter_Policy[0] = HCI_CMD_PARAM_ALLOW_SCAN_REQ_AND_CONN_REQ_FROM_ANY;	
	g_pattern_param.adv_param.Advertising_Interval_Max[0] =  HCI_CMD_PARAM_ADVERTISING_INTERVAL_MIN & 0x00ff;
	g_pattern_param.adv_param.Advertising_Interval_Max[1] = (HCI_CMD_PARAM_ADVERTISING_INTERVAL_MIN & 0xff00) >> 8;
	g_pattern_param.adv_param.Advertising_Interval_Min[0] =  HCI_CMD_PARAM_ADVERTISING_INTERVAL_MIN & 0x00ff;
	g_pattern_param.adv_param.Advertising_Interval_Min[1] = (HCI_CMD_PARAM_ADVERTISING_INTERVAL_MIN & 0xff00) >> 8;
	verdict = COMM_ADV_Undirected_Advertising(dut2_fd, g_pattern_param);
	VERDICT_RESULT_WITH_LINE();	

	event_query_timer_config(1, 0, 0, 0, &timer);
	event_query_timer_start(timer, read_le_event_enable);

    //waiting adv report event , timer or counter
	while(1) {
		if(1 == read_le_event_get()) {

			read_le_event_disable();
			// # query adv_ind
			// # p3 : monitor adv report
			// # p4 : monitor scan rsp
			// # p5 : check for 30 times
            while (check_cnt < 30) {
                if (SUCCESS != QUERY_LE_Event(dut1_fd, buf, _BT_HCI_LE_EVENT_SUB_OP_ADVERTISING_REPORT_, HCI_SUBEVENT_ADV_RPT_EVENT_SCAN_RSP)) {
                    printf("****SUCCESS != QUERY_LE_Event****\n");
                    continue;
                }            
                else if(EQUAL != hci_le_event_advertising_report_parsing(HCI_SUBEVENT_ADV_RPT_EVENT_SCAN_RSP, buf, g_pattern_param)) {
                    printf("****EQUAL != HCI_err : %d, right_Cnt = %d ****\n", err_cnt, check_cnt);             
                     err_cnt++;
                     if (err_cnt > 100) {
                         line=__LINE__;
                        goto FUN_FAIL;
                     }
                }        
                else {
                     check_cnt ++ ;
                     err_cnt = 0;                     
                     printf("** 1.Upper Tester expects an RSP event from the IUT : %d / 30 times **\n" , check_cnt);
                 }
                MSLEEP(300);
            }
				 

			// # stop scn before reconfig adv
			COMM_SCN_Disable_Config(dut1, &g_pattern_param);
			verdict = COMM_SCN_Disable(dut1_fd, g_pattern_param);
			VERDICT_RESULT_WITH_LINE();

			// # start creat connection
			COMM_INI_Initiating_Config(dut1, &g_pattern_param);
			verdict = COMM_INI_Initiating(dut1_fd, g_pattern_param);
			VERDICT_RESULT_WITH_LINE();

			sleep(1);

			// # p6 : check conn complete with CONN_REQ 
			if (SUCCESS != QUERY_LE_Event(dut1_fd, buf, _BT_HCI_LE_EVENT_SUB_OP_CONNECTION_COMPLETE_, 0)) {
			    line = __LINE__;
			    goto FUN_FAIL;
		    }
		    else if(SUCCESS != hci_le_event_connection_complete_parsing(0, buf, g_pattern_param)) {
			    line = __LINE__;
			    goto FUN_FAIL;
		    }

			conn_handles_mas[0] = buf[_BT_HCI_EVT_CON_COMP_CONN_HANDLE+0];
			conn_handles_mas[1] = buf[_BT_HCI_EVT_CON_COMP_CONN_HANDLE+1];

            if (SUCCESS != QUERY_LE_Event(dut2_fd, buf, _BT_HCI_LE_EVENT_SUB_OP_CONNECTION_COMPLETE_, 0)) {
			    line = __LINE__;
			    goto FUN_FAIL;
		    }
		    else if(SUCCESS != hci_le_event_connection_complete_parsing(0, buf, g_pattern_param)) {
			    line = __LINE__;
			    goto FUN_FAIL;
		    }

            // # p7 : check no adv ind
            if(SUCCESS != QUERY_LE_Event(dut2_fd, buf, _BT_HCI_LE_EVENT_SUB_OP_ADVERTISING_REPORT_, HCI_SUBEVENT_ADV_RPT_EVENT_ADV_IND)) {
				line = __LINE__;
				goto FUN_FAIL;
			}						  
			else if(EQUAL == hci_le_event_advertising_report_parsing(HCI_SUBEVENT_ADV_RPT_EVENT_ADV_IND,	buf, g_pattern_param)) {
				line = __LINE__;
				goto FUN_FAIL;
			}

			// # Slave Connection Terminated
			// use connect handle to disconnect
			buf[_BT_HCI_EVT_CON_COMP_CONN_HANDLE+0] = conn_handles_mas[0];
			buf[_BT_HCI_EVT_CON_COMP_CONN_HANDLE+1] = conn_handles_mas[1];
			
			COMM_Disconnect_Config(dut1, &g_pattern_param, buf);
			verdict = COMM_Disconnect(dut1_fd, g_pattern_param);
			VERDICT_RESULT_WITH_LINE();

            sleep(5);

			// # p9 : check conn terminated
			if(SUCCESS != QUERY_Event(dut2_fd, buf, _BT_HCI_EVENT_OP_DISCONNECTION_COMPLETE_)) {
				line = __LINE__;
				goto FUN_FAIL;
			}
			else if(SUCCESS != hci_event_disconnection_complete_parsing(0, buf, g_pattern_param)) {
				line = __LINE__;
				goto FUN_FAIL;
			}
            if( 0 == buf[_BT_HCI_EVT_DISCONN_COMP_REASON]) {
                line = __LINE__;
                goto FUN_FAIL;
            }


			dut_reset_with_mask_en(dut1_fd);
    		dut_reset_with_mask_en(dut2_fd);
            MSLEEP(500);

			num++;
			if(num <3){
				goto REPEAT;
			}
			else{
				break;
			}
		}
	}


    FUNC_END();

	LOG_INFO("[Pattern][%s]SUCCESS\n" ,__FUNCTION__);
	return PASS;	
    
FUN_FAIL:
    FUNC_END();

	LOG_INFO("[Pattern][%s]:%d FAIL\n", __FUNCTION__, line);
	return FAIL;

}

// 5.2.1.8
verdict DDI_ADV_Scan_Request_Device_Filtering(u8 dut1_fd ,u8 dut2_fd)
{
	u8 buf[SOCKET_BUF_SIZE];
    int adv_Channel = 37;
	int verdict = FAIL;
	int dut1 = 0, dut2 = 0;
    int check_cnt = 0;
    u16 line = 0;	
	struct itimerval timer;
	u32 adv_cnt = 1;	
    int scn_rsp_cnt = 0;

    COMM_Dut_clean_buffer(dut1_fd);
    COMM_Dut_clean_buffer(dut2_fd);

    Calculate_Execution_Time_Start();
REPEAT:    
    check_cnt = 0;
	printf("###run case %d###\n", adv_cnt);
	switch (adv_cnt)
	{
		case 1:			
			/*// Uptest   : addr_type = public 
			// Lwtest   : addr_type = public, addr error(black); 
			// IUT      : undirected advertising, filter policy = 0x03
			// ***********************************************************************************
			// Uptest(white list) config
			COMM_INI_Connection_Setup_White_Listed_Config(dut2, &g_pattern_param);
			memcpy(g_pattern_param.white_list_param.Address, scan_addr, ADDR_LENGTH);
            g_pattern_param.white_list_param.Address_Type[0] = HCI_CMD_PARAM_PUBLIC_DEVICE_ADDRESS;
			verdict = COMM_INI_Connection_Setup_White_Listed(dut2_fd, g_pattern_param);
			VERDICT_RESULT_WITH_LINE();

            // Lwtest(white list) config
            COMM_INI_Connection_Setup_White_Listed_Config(dut1, &g_pattern_param);
            memcpy(g_pattern_param.white_list_param.Address, adv_addr, ADDR_LENGTH);
            verdict=COMM_INI_Connection_Setup_White_Listed(dut1_fd, g_pattern_param);
            VERDICT_RESULT_WITH_LINE();
            
            // ***********************************************************************************            
            // Lwtest(SCN) config
            COMM_Static_Random_Device_Address_Set_Config(error_addr);
			COMM_Device_Address_Set(dut1_fd, g_pattern_param);
            COMM_SCN_Active_Scanning_Config(dut1, &g_pattern_param);            
            g_pattern_param.scn_param.Own_Address_Type[0] = HCI_CMD_PARAM_RANDOM_DEVICE_ADDRESS;             
            g_pattern_param.scn_param.LE_Scan_Interval[0] = 0x0500 & 0x00ff;
	        g_pattern_param.scn_param.LE_Scan_Interval[1] = (0x0500 & 0xff00) >> 8;
	        g_pattern_param.scn_param.LE_Scan_Window[0] =	0x0500 & 0x00ff;
	        g_pattern_param.scn_param.LE_Scan_Window[1] = (0x0500 & 0xff00) >> 8;
            g_pattern_param.scn_param.Scanning_Filter_Policy[0] =   HCI_CMD_PARAM_IGNORE_ADV_PKTS_FROM_DEV_NOT_IN_WHITE_LIST_ONLY;

			verdict = COMM_SCN_Active_Scanning(dut1_fd, g_pattern_param);            
			VERDICT_RESULT_WITH_LINE();
            
            // ***********************************************************************************            
            // IUT(ADV) config
            COMM_ADV_Undirected_Advertising_Config(HCI_CMD_PARAM_ADV_DATA_LEN_MAX, &g_pattern_param);            
            if(37 == adv_Channel) {
                g_pattern_param.adv_param.Advertising_Channel_Map[0] = HCI_CMD_PARAM_ENABLE_CHANNEL_37;
            }
            else if(38 == adv_Channel) {
                g_pattern_param.adv_param.Advertising_Channel_Map[0] = HCI_CMD_PARAM_ENABLE_CHANNEL_38;
            }
            else {
                g_pattern_param.adv_param.Advertising_Channel_Map[0] = HCI_CMD_PARAM_ENABLE_CHANNEL_39;
            }
			g_pattern_param.adv_param.Advertising_Filter_Policy[0] = HCI_CMD_PARAM_ALLOW_SCAN_REQ_FROM_WHITELIST_ONLY_AND_CONN_REQ_FROM_WHITELIST_ONLY;
            g_pattern_param.adv_param.Advertising_Interval_Max[0] = HCI_CMD_PARAM_ADVERTISING_INTERVAL_MIN & 0x00ff;
	        g_pattern_param.adv_param.Advertising_Interval_Max[1] = (HCI_CMD_PARAM_ADVERTISING_INTERVAL_MIN & 0xff00) >> 8;
	        g_pattern_param.adv_param.Advertising_Interval_Min[0] = HCI_CMD_PARAM_ADVERTISING_INTERVAL_MIN & 0x00ff;
	        g_pattern_param.adv_param.Advertising_Interval_Min[1] = (HCI_CMD_PARAM_ADVERTISING_INTERVAL_MIN & 0xff00) >> 8;
            verdict = COMM_ADV_Undirected_Advertising(dut2_fd, g_pattern_param);
			VERDICT_RESULT_WITH_LINE();*/
		break;

		case 2:			
			// Uptest   : addr_type = public 
			// Lwtest   : addr_type = random
			// IUT      : undirected advertising, filter policy = 0x03
			// ***********************************************************************************
            // Uptest(white list) config
            COMM_INI_Connection_Setup_White_Listed_Config(dut2, &g_pattern_param);
			memcpy(g_pattern_param.white_list_param.Address, scan_addr, ADDR_LENGTH);
            g_pattern_param.white_list_param.Address_Type[0] = HCI_CMD_PARAM_PUBLIC_DEVICE_ADDRESS;
			verdict = COMM_INI_Connection_Setup_White_Listed(dut2_fd, g_pattern_param);
			VERDICT_RESULT_WITH_LINE();

            // Lwtest(white list) config
            COMM_INI_Connection_Setup_White_Listed_Config(dut1, &g_pattern_param);
            memcpy(g_pattern_param.white_list_param.Address, adv_addr, ADDR_LENGTH);
            verdict=COMM_INI_Connection_Setup_White_Listed(dut1_fd, g_pattern_param);
            VERDICT_RESULT_WITH_LINE();

            
            // ***********************************************************************************            
            // Lwtest(SCN) config
            COMM_SCN_Active_Scanning_Config(dut1, &g_pattern_param);
            COMM_Static_Random_Device_Address_Set_Config(scan_addr);
			COMM_Device_Address_Set(dut1_fd, g_pattern_param);
            g_pattern_param.scn_param.Own_Address_Type[0] = HCI_CMD_PARAM_RANDOM_DEVICE_ADDRESS;             
            g_pattern_param.scn_param.LE_Scan_Interval[0] =  0x0500 & 0x00ff;
	        g_pattern_param.scn_param.LE_Scan_Interval[1] = (0x0500 & 0xff00) >> 8;
	        g_pattern_param.scn_param.LE_Scan_Window[0] =	 0x0500 & 0x00ff;
	        g_pattern_param.scn_param.LE_Scan_Window[1] =   (0x0500 & 0xff00) >> 8;
            g_pattern_param.scn_param.Scanning_Filter_Policy[0] =   HCI_CMD_PARAM_IGNORE_ADV_PKTS_FROM_DEV_NOT_IN_WHITE_LIST_ONLY;

			verdict = COMM_SCN_Active_Scanning(dut1_fd, g_pattern_param);            
			VERDICT_RESULT_WITH_LINE();
            
            // ***********************************************************************************            
            // IUT(ADV) config
            COMM_ADV_Undirected_Advertising_Config(HCI_CMD_PARAM_ADV_DATA_LEN_MAX, &g_pattern_param);
            if(37 == adv_Channel) {
                g_pattern_param.adv_param.Advertising_Channel_Map[0] = HCI_CMD_PARAM_ENABLE_CHANNEL_37;
            }
            else if(38 == adv_Channel) {
                g_pattern_param.adv_param.Advertising_Channel_Map[0] = HCI_CMD_PARAM_ENABLE_CHANNEL_38;
            }
            else {
                g_pattern_param.adv_param.Advertising_Channel_Map[0] = HCI_CMD_PARAM_ENABLE_CHANNEL_39;
            }
			g_pattern_param.adv_param.Advertising_Filter_Policy[0] = HCI_CMD_PARAM_ALLOW_SCAN_REQ_FROM_WHITELIST_ONLY_AND_CONN_REQ_FROM_WHITELIST_ONLY;
            g_pattern_param.adv_param.Advertising_Interval_Max[0] =  HCI_CMD_PARAM_ADVERTISING_INTERVAL_MIN & 0x00ff;
	        g_pattern_param.adv_param.Advertising_Interval_Max[1] = (HCI_CMD_PARAM_ADVERTISING_INTERVAL_MIN & 0xff00) >> 8;
	        g_pattern_param.adv_param.Advertising_Interval_Min[0] =  HCI_CMD_PARAM_ADVERTISING_INTERVAL_MIN & 0x00ff;
	        g_pattern_param.adv_param.Advertising_Interval_Min[1] = (HCI_CMD_PARAM_ADVERTISING_INTERVAL_MIN & 0xff00) >> 8;
            verdict = COMM_ADV_Undirected_Advertising(dut2_fd, g_pattern_param);
			VERDICT_RESULT_WITH_LINE();
		break;

		case 3:			
			// Uptest   : addr_type = public 
			// Lwtest   : addr_type = public
			// IUT      : undirected advertising, filter policy = 0x03
			// ***********************************************************************************
            // Uptest(white list) config
            COMM_INI_Connection_Setup_White_Listed_Config(dut2, &g_pattern_param);
			memcpy(g_pattern_param.white_list_param.Address, scan_addr, ADDR_LENGTH);
            g_pattern_param.white_list_param.Address_Type[0] = HCI_CMD_PARAM_PUBLIC_DEVICE_ADDRESS;
			verdict = COMM_INI_Connection_Setup_White_Listed(dut2_fd, g_pattern_param);
			VERDICT_RESULT_WITH_LINE();

            // Lwtest(white list) config
            COMM_INI_Connection_Setup_White_Listed_Config(dut1, &g_pattern_param);
            memcpy(g_pattern_param.white_list_param.Address, adv_addr, ADDR_LENGTH);
            verdict=COMM_INI_Connection_Setup_White_Listed(dut1_fd, g_pattern_param);
            VERDICT_RESULT_WITH_LINE();
            
            // ***********************************************************************************            
            // Lwtest(SCN) config
            COMM_SCN_Active_Scanning_Config(dut1, &g_pattern_param);
            g_pattern_param.scn_param.Own_Address_Type[0] = HCI_CMD_PARAM_PUBLIC_DEVICE_ADDRESS;             
            g_pattern_param.scn_param.LE_Scan_Interval[0] =  0x0500 & 0x00ff;
	        g_pattern_param.scn_param.LE_Scan_Interval[1] = (0x0500 & 0xff00) >> 8;
	        g_pattern_param.scn_param.LE_Scan_Window[0] =	 0x0500 & 0x00ff;
	        g_pattern_param.scn_param.LE_Scan_Window[1] =   (0x0500 & 0xff00) >> 8;
            g_pattern_param.scn_param.Scanning_Filter_Policy[0] =   HCI_CMD_PARAM_IGNORE_ADV_PKTS_FROM_DEV_NOT_IN_WHITE_LIST_ONLY;

			verdict = COMM_SCN_Active_Scanning(dut1_fd, g_pattern_param);            
			VERDICT_RESULT_WITH_LINE();
            
            // ***********************************************************************************            
            // IUT(ADV) config
            COMM_ADV_Undirected_Advertising_Config(HCI_CMD_PARAM_ADV_DATA_LEN_MAX, &g_pattern_param);
            if(37 == adv_Channel) {
                g_pattern_param.adv_param.Advertising_Channel_Map[0] = HCI_CMD_PARAM_ENABLE_CHANNEL_37;
            }
            else if(38 == adv_Channel) {
                g_pattern_param.adv_param.Advertising_Channel_Map[0] = HCI_CMD_PARAM_ENABLE_CHANNEL_38;
            }
            else {
                g_pattern_param.adv_param.Advertising_Channel_Map[0] = HCI_CMD_PARAM_ENABLE_CHANNEL_39;
            }
			g_pattern_param.adv_param.Advertising_Filter_Policy[0] = HCI_CMD_PARAM_ALLOW_SCAN_REQ_FROM_WHITELIST_ONLY_AND_CONN_REQ_FROM_WHITELIST_ONLY;
            g_pattern_param.adv_param.Advertising_Interval_Max[0] =  HCI_CMD_PARAM_ADVERTISING_INTERVAL_MIN & 0x00ff;
	        g_pattern_param.adv_param.Advertising_Interval_Max[1] = (HCI_CMD_PARAM_ADVERTISING_INTERVAL_MIN & 0xff00) >> 8;
	        g_pattern_param.adv_param.Advertising_Interval_Min[0] =  HCI_CMD_PARAM_ADVERTISING_INTERVAL_MIN & 0x00ff;
	        g_pattern_param.adv_param.Advertising_Interval_Min[1] = (HCI_CMD_PARAM_ADVERTISING_INTERVAL_MIN & 0xff00) >> 8;
            verdict = COMM_ADV_Undirected_Advertising(dut2_fd, g_pattern_param);
			VERDICT_RESULT_WITH_LINE();
		break;
		
		case 4:			
			// Uptest   : addr_type = public 
			// Lwtest   : addr_type = random, addr error(black); 
			// IUT      : undirected advertising, filter policy = 0x03
			// ***********************************************************************************
            // Uptest(white list) config
            COMM_INI_Connection_Setup_White_Listed_Config(dut2, &g_pattern_param);
			memcpy(g_pattern_param.white_list_param.Address, scan_addr, ADDR_LENGTH);
            g_pattern_param.white_list_param.Address_Type[0] = HCI_CMD_PARAM_PUBLIC_DEVICE_ADDRESS;
			verdict = COMM_INI_Connection_Setup_White_Listed(dut2_fd, g_pattern_param);
			VERDICT_RESULT_WITH_LINE();

            // Lwtest(white list) config
            COMM_INI_Connection_Setup_White_Listed_Config(dut1, &g_pattern_param);
            memcpy(g_pattern_param.white_list_param.Address, adv_addr, ADDR_LENGTH);
            verdict=COMM_INI_Connection_Setup_White_Listed(dut1_fd, g_pattern_param);
            VERDICT_RESULT_WITH_LINE();
            
            // ***********************************************************************************            
            // Lwtest(SCN) config
            COMM_Static_Random_Device_Address_Set_Config(error_addr);
			COMM_Device_Address_Set(dut1_fd, g_pattern_param);
            COMM_SCN_Active_Scanning_Config(dut1, &g_pattern_param);
            g_pattern_param.scn_param.Own_Address_Type[0] = HCI_CMD_PARAM_RANDOM_DEVICE_ADDRESS;             
            g_pattern_param.scn_param.LE_Scan_Interval[0] =  0x0500 & 0x00ff;
	        g_pattern_param.scn_param.LE_Scan_Interval[1] = (0x0500 & 0xff00) >> 8;
	        g_pattern_param.scn_param.LE_Scan_Window[0] =	 0x0500 & 0x00ff;
	        g_pattern_param.scn_param.LE_Scan_Window[1] =   (0x0500 & 0xff00) >> 8;
            g_pattern_param.scn_param.Scanning_Filter_Policy[0] =   HCI_CMD_PARAM_IGNORE_ADV_PKTS_FROM_DEV_NOT_IN_WHITE_LIST_ONLY;

			verdict = COMM_SCN_Active_Scanning(dut1_fd, g_pattern_param);            
			VERDICT_RESULT_WITH_LINE();
            
            // ***********************************************************************************            
            // IUT(ADV) config
            COMM_ADV_Undirected_Advertising_Config(HCI_CMD_PARAM_ADV_DATA_LEN_MAX, &g_pattern_param);
            if(37 == adv_Channel) {
                g_pattern_param.adv_param.Advertising_Channel_Map[0] = HCI_CMD_PARAM_ENABLE_CHANNEL_37;
            }
            else if(38 == adv_Channel) {
                g_pattern_param.adv_param.Advertising_Channel_Map[0] = HCI_CMD_PARAM_ENABLE_CHANNEL_38;
            }
            else {
                g_pattern_param.adv_param.Advertising_Channel_Map[0] = HCI_CMD_PARAM_ENABLE_CHANNEL_39;
            }
			g_pattern_param.adv_param.Advertising_Filter_Policy[0] = HCI_CMD_PARAM_ALLOW_SCAN_REQ_FROM_WHITELIST_ONLY_AND_CONN_REQ_FROM_WHITELIST_ONLY;
            g_pattern_param.adv_param.Advertising_Interval_Max[0] =  HCI_CMD_PARAM_ADVERTISING_INTERVAL_MIN & 0x00ff;
	        g_pattern_param.adv_param.Advertising_Interval_Max[1] = (HCI_CMD_PARAM_ADVERTISING_INTERVAL_MIN & 0xff00) >> 8;
	        g_pattern_param.adv_param.Advertising_Interval_Min[0] =  HCI_CMD_PARAM_ADVERTISING_INTERVAL_MIN & 0x00ff;
	        g_pattern_param.adv_param.Advertising_Interval_Min[1] = (HCI_CMD_PARAM_ADVERTISING_INTERVAL_MIN & 0xff00) >> 8;
            verdict = COMM_ADV_Undirected_Advertising(dut2_fd, g_pattern_param);
			VERDICT_RESULT_WITH_LINE();
		break;

		case 5:			
			// Uptest   : addr_type = public 
			// Lwtest   : addr_type = random(error)
			// IUT      : undirected advertising, filter policy = 0x03
			// ***********************************************************************************
            // Uptest(white list) config
            COMM_INI_Connection_Setup_White_Listed_Config(dut2, &g_pattern_param);
			memcpy(g_pattern_param.white_list_param.Address, scan_addr, ADDR_LENGTH);
            g_pattern_param.white_list_param.Address_Type[0] = HCI_CMD_PARAM_PUBLIC_DEVICE_ADDRESS;
			verdict = COMM_INI_Connection_Setup_White_Listed(dut2_fd, g_pattern_param);
			VERDICT_RESULT_WITH_LINE();

            // Lwtest(white list) config
            COMM_INI_Connection_Setup_White_Listed_Config(dut1, &g_pattern_param);
            memcpy(g_pattern_param.white_list_param.Address, adv_addr, ADDR_LENGTH);
            verdict=COMM_INI_Connection_Setup_White_Listed(dut1_fd, g_pattern_param);
            VERDICT_RESULT_WITH_LINE();
            
            // ***********************************************************************************            
            // Lwtest(SCN) config
            COMM_SCN_Active_Scanning_Config(dut1, &g_pattern_param);
            COMM_Static_Random_Device_Address_Set_Config(scan_addr);
			COMM_Device_Address_Set(dut1_fd, g_pattern_param);
            g_pattern_param.scn_param.Own_Address_Type[0] = HCI_CMD_PARAM_RANDOM_DEVICE_ADDRESS;
            g_pattern_param.scn_param.LE_Scan_Interval[0] =  0x0500 & 0x00ff;
	        g_pattern_param.scn_param.LE_Scan_Interval[1] = (0x0500 & 0xff00) >> 8;
	        g_pattern_param.scn_param.LE_Scan_Window[0] =	 0x0500 & 0x00ff;
	        g_pattern_param.scn_param.LE_Scan_Window[1] =   (0x0500 & 0xff00) >> 8;
            g_pattern_param.scn_param.Scanning_Filter_Policy[0] =   HCI_CMD_PARAM_IGNORE_ADV_PKTS_FROM_DEV_NOT_IN_WHITE_LIST_ONLY;

			verdict = COMM_SCN_Active_Scanning(dut1_fd, g_pattern_param);            
			VERDICT_RESULT_WITH_LINE();
            
            // ***********************************************************************************            
            // IUT(ADV) config
            COMM_ADV_Undirected_Advertising_Config(HCI_CMD_PARAM_ADV_DATA_LEN_MAX, &g_pattern_param);
            if(37 == adv_Channel) {
                g_pattern_param.adv_param.Advertising_Channel_Map[0] = HCI_CMD_PARAM_ENABLE_CHANNEL_37;
            }
            else if(38 == adv_Channel) {
                g_pattern_param.adv_param.Advertising_Channel_Map[0] = HCI_CMD_PARAM_ENABLE_CHANNEL_38;
            }
            else {
                g_pattern_param.adv_param.Advertising_Channel_Map[0] = HCI_CMD_PARAM_ENABLE_CHANNEL_39;
            }
			g_pattern_param.adv_param.Advertising_Filter_Policy[0] = HCI_CMD_PARAM_ALLOW_SCAN_REQ_FROM_WHITELIST_ONLY_AND_CONN_REQ_FROM_WHITELIST_ONLY;
            g_pattern_param.adv_param.Advertising_Interval_Max[0] =  HCI_CMD_PARAM_ADVERTISING_INTERVAL_MIN & 0x00ff;
	        g_pattern_param.adv_param.Advertising_Interval_Max[1] = (HCI_CMD_PARAM_ADVERTISING_INTERVAL_MIN & 0xff00) >> 8;
	        g_pattern_param.adv_param.Advertising_Interval_Min[0] =  HCI_CMD_PARAM_ADVERTISING_INTERVAL_MIN & 0x00ff;
	        g_pattern_param.adv_param.Advertising_Interval_Min[1] = (HCI_CMD_PARAM_ADVERTISING_INTERVAL_MIN & 0xff00) >> 8;
            verdict = COMM_ADV_Undirected_Advertising(dut2_fd, g_pattern_param);
			VERDICT_RESULT_WITH_LINE();
		break;

		case 6:
			// Uptest   : addr_type = public 
			// Lwtest   : addr_type = public
			// IUT      : undirected advertising, filter policy = 0x03
			// ***********************************************************************************
            // Uptest(white list) config
            COMM_INI_Connection_Setup_White_Listed_Config(dut2, &g_pattern_param);
			memcpy(g_pattern_param.white_list_param.Address, scan_addr, ADDR_LENGTH);
            g_pattern_param.white_list_param.Address_Type[0] = HCI_CMD_PARAM_PUBLIC_DEVICE_ADDRESS;
			verdict = COMM_INI_Connection_Setup_White_Listed(dut2_fd, g_pattern_param);
			VERDICT_RESULT_WITH_LINE();

            // Lwtest(white list) config
            COMM_INI_Connection_Setup_White_Listed_Config(dut1, &g_pattern_param);
            memcpy(g_pattern_param.white_list_param.Address, adv_addr, ADDR_LENGTH);
            verdict=COMM_INI_Connection_Setup_White_Listed(dut1_fd, g_pattern_param);
            VERDICT_RESULT_WITH_LINE();
            
            // ***********************************************************************************            
            // Lwtest(SCN) config
            COMM_SCN_Active_Scanning_Config(dut1, &g_pattern_param);
            g_pattern_param.scn_param.Own_Address_Type[0] = HCI_CMD_PARAM_PUBLIC_DEVICE_ADDRESS;             
            g_pattern_param.scn_param.LE_Scan_Interval[0] =  0x0500 & 0x00ff;
	        g_pattern_param.scn_param.LE_Scan_Interval[1] = (0x0500 & 0xff00) >> 8;
	        g_pattern_param.scn_param.LE_Scan_Window[0] =	 0x0500 & 0x00ff;
	        g_pattern_param.scn_param.LE_Scan_Window[1] =   (0x0500 & 0xff00) >> 8;
            g_pattern_param.scn_param.Scanning_Filter_Policy[0] =   HCI_CMD_PARAM_IGNORE_ADV_PKTS_FROM_DEV_NOT_IN_WHITE_LIST_ONLY;

			verdict = COMM_SCN_Active_Scanning(dut1_fd, g_pattern_param);            
			VERDICT_RESULT_WITH_LINE();
            
            // ***********************************************************************************            
            // IUT(ADV) config
            COMM_ADV_Undirected_Advertising_Config(HCI_CMD_PARAM_ADV_DATA_LEN_MAX, &g_pattern_param);
            if(37 == adv_Channel) {
                g_pattern_param.adv_param.Advertising_Channel_Map[0] = HCI_CMD_PARAM_ENABLE_CHANNEL_37;
            }
            else if(38 == adv_Channel) {
                g_pattern_param.adv_param.Advertising_Channel_Map[0] = HCI_CMD_PARAM_ENABLE_CHANNEL_38;
            }
            else {
                g_pattern_param.adv_param.Advertising_Channel_Map[0] = HCI_CMD_PARAM_ENABLE_CHANNEL_39;
            }
			g_pattern_param.adv_param.Advertising_Filter_Policy[0] = HCI_CMD_PARAM_ALLOW_SCAN_REQ_FROM_WHITELIST_ONLY_AND_CONN_REQ_FROM_WHITELIST_ONLY;
            g_pattern_param.adv_param.Advertising_Interval_Max[0] =  HCI_CMD_PARAM_ADVERTISING_INTERVAL_MIN & 0x00ff;
	        g_pattern_param.adv_param.Advertising_Interval_Max[1] = (HCI_CMD_PARAM_ADVERTISING_INTERVAL_MIN & 0xff00) >> 8;
	        g_pattern_param.adv_param.Advertising_Interval_Min[0] =  HCI_CMD_PARAM_ADVERTISING_INTERVAL_MIN & 0x00ff;
	        g_pattern_param.adv_param.Advertising_Interval_Min[1] = (HCI_CMD_PARAM_ADVERTISING_INTERVAL_MIN & 0xff00) >> 8;
            verdict = COMM_ADV_Undirected_Advertising(dut2_fd, g_pattern_param);
			VERDICT_RESULT_WITH_LINE();
		break;

		//part E : filter policy = 0x01 ;	repeat case1~3=>7~9
		case 7:			
			/*// Uptest   : addr_type = public 
			// Lwtest   : addr_type = public, addr error(black); 
			// IUT      : undirected advertising, filter policy = 0x01
			// ***********************************************************************************
			// Uptest(white list) config
			COMM_INI_Connection_Setup_White_Listed_Config(dut2, &g_pattern_param);
			memcpy(g_pattern_param.white_list_param.Address, scan_addr, ADDR_LENGTH);
            g_pattern_param.white_list_param.Address_Type[0] = HCI_CMD_PARAM_PUBLIC_DEVICE_ADDRESS;
			verdict = COMM_INI_Connection_Setup_White_Listed(dut2_fd, g_pattern_param);
			VERDICT_RESULT_WITH_LINE();

            // Lwtest(white list) config
            COMM_INI_Connection_Setup_White_Listed_Config(dut1, &g_pattern_param);
            memcpy(g_pattern_param.white_list_param.Address, adv_addr, ADDR_LENGTH);
            verdict=COMM_INI_Connection_Setup_White_Listed(dut1_fd, g_pattern_param);
            VERDICT_RESULT_WITH_LINE();

            
            // ***********************************************************************************            
            // Lwtest(SCN) config
            COMM_Static_Random_Device_Address_Set_Config(error_addr);
			COMM_Device_Address_Set(dut1_fd, g_pattern_param);
            COMM_SCN_Active_Scanning_Config(dut1, &g_pattern_param);            
            g_pattern_param.scn_param.Own_Address_Type[0] = HCI_CMD_PARAM_RANDOM_DEVICE_ADDRESS;             
            g_pattern_param.scn_param.LE_Scan_Interval[0] = 0x0500 & 0x00ff;
	        g_pattern_param.scn_param.LE_Scan_Interval[1] = (0x0500 & 0xff00) >> 8;
	        g_pattern_param.scn_param.LE_Scan_Window[0] =	0x0500 & 0x00ff;
	        g_pattern_param.scn_param.LE_Scan_Window[1] = (0x0500 & 0xff00) >> 8;
            g_pattern_param.scn_param.Scanning_Filter_Policy[0] =   HCI_CMD_PARAM_IGNORE_ADV_PKTS_FROM_DEV_NOT_IN_WHITE_LIST_ONLY;

			verdict = COMM_SCN_Active_Scanning(dut1_fd, g_pattern_param);            
			VERDICT_RESULT_WITH_LINE();
            
            // ***********************************************************************************            
            // IUT(ADV) config
            COMM_ADV_Undirected_Advertising_Config(HCI_CMD_PARAM_ADV_DATA_LEN_MAX, &g_pattern_param);
            if(37 == adv_Channel) {
                g_pattern_param.adv_param.Advertising_Channel_Map[0] = HCI_CMD_PARAM_ENABLE_CHANNEL_37;
            }
            else if(38 == adv_Channel) {
                g_pattern_param.adv_param.Advertising_Channel_Map[0] = HCI_CMD_PARAM_ENABLE_CHANNEL_38;
            }
            else {
                g_pattern_param.adv_param.Advertising_Channel_Map[0] = HCI_CMD_PARAM_ENABLE_CHANNEL_39;
            }
			g_pattern_param.adv_param.Advertising_Filter_Policy[0] = HCI_CMD_PARAM_ALLOW_SCAN_REQ_FROM_WHITELIST_ONLY_AND_CONN_REQ_FROM_ANY;
            g_pattern_param.adv_param.Advertising_Interval_Max[0] = HCI_CMD_PARAM_ADVERTISING_INTERVAL_MIN & 0x00ff;
	        g_pattern_param.adv_param.Advertising_Interval_Max[1] = (HCI_CMD_PARAM_ADVERTISING_INTERVAL_MIN & 0xff00) >> 8;
	        g_pattern_param.adv_param.Advertising_Interval_Min[0] = HCI_CMD_PARAM_ADVERTISING_INTERVAL_MIN & 0x00ff;
	        g_pattern_param.adv_param.Advertising_Interval_Min[1] = (HCI_CMD_PARAM_ADVERTISING_INTERVAL_MIN & 0xff00) >> 8;
            verdict = COMM_ADV_Undirected_Advertising(dut2_fd, g_pattern_param);
			VERDICT_RESULT_WITH_LINE();*/

		break;

		case 8:			
			// Uptest   : addr_type = public 
			// Lwtest   : addr_type = random(error)
			// IUT      : undirected advertising, filter policy = 0x01
			// ***********************************************************************************
            // Uptest(white list) config
            COMM_INI_Connection_Setup_White_Listed_Config(dut2, &g_pattern_param);
			memcpy(g_pattern_param.white_list_param.Address, scan_addr, ADDR_LENGTH);
            g_pattern_param.white_list_param.Address_Type[0] = HCI_CMD_PARAM_PUBLIC_DEVICE_ADDRESS;
			verdict = COMM_INI_Connection_Setup_White_Listed(dut2_fd, g_pattern_param);
			VERDICT_RESULT_WITH_LINE();

            // Lwtest(white list) config
            COMM_INI_Connection_Setup_White_Listed_Config(dut1, &g_pattern_param);
            memcpy(g_pattern_param.white_list_param.Address, adv_addr, ADDR_LENGTH);
            verdict=COMM_INI_Connection_Setup_White_Listed(dut1_fd, g_pattern_param);
            VERDICT_RESULT_WITH_LINE();

            
            // ***********************************************************************************            
            // Lwtest(SCN) config
            COMM_SCN_Active_Scanning_Config(dut1, &g_pattern_param);
            COMM_Static_Random_Device_Address_Set_Config(scan_addr);
			COMM_Device_Address_Set(dut1_fd, g_pattern_param);
            g_pattern_param.scn_param.Own_Address_Type[0] = HCI_CMD_PARAM_RANDOM_DEVICE_ADDRESS;             
            g_pattern_param.scn_param.LE_Scan_Interval[0] =  0x0500 & 0x00ff;
	        g_pattern_param.scn_param.LE_Scan_Interval[1] = (0x0500 & 0xff00) >> 8;
	        g_pattern_param.scn_param.LE_Scan_Window[0] =	 0x0500 & 0x00ff;
	        g_pattern_param.scn_param.LE_Scan_Window[1] =   (0x0500 & 0xff00) >> 8;
            g_pattern_param.scn_param.Scanning_Filter_Policy[0] =   HCI_CMD_PARAM_IGNORE_ADV_PKTS_FROM_DEV_NOT_IN_WHITE_LIST_ONLY;
            
			verdict = COMM_SCN_Active_Scanning(dut1_fd, g_pattern_param);            
			VERDICT_RESULT_WITH_LINE();
            
            // ***********************************************************************************            
            // IUT(ADV) config
            COMM_ADV_Undirected_Advertising_Config(HCI_CMD_PARAM_ADV_DATA_LEN_MAX, &g_pattern_param);
            if(37 == adv_Channel) {
                g_pattern_param.adv_param.Advertising_Channel_Map[0] = HCI_CMD_PARAM_ENABLE_CHANNEL_37;
            }
            else if(38 == adv_Channel) {
                g_pattern_param.adv_param.Advertising_Channel_Map[0] = HCI_CMD_PARAM_ENABLE_CHANNEL_38;
            }
            else {
                g_pattern_param.adv_param.Advertising_Channel_Map[0] = HCI_CMD_PARAM_ENABLE_CHANNEL_39;
            }
			g_pattern_param.adv_param.Advertising_Filter_Policy[0] = HCI_CMD_PARAM_ALLOW_SCAN_REQ_FROM_WHITELIST_ONLY_AND_CONN_REQ_FROM_ANY;
            g_pattern_param.adv_param.Advertising_Interval_Max[0] =  HCI_CMD_PARAM_ADVERTISING_INTERVAL_MIN & 0x00ff;
	        g_pattern_param.adv_param.Advertising_Interval_Max[1] = (HCI_CMD_PARAM_ADVERTISING_INTERVAL_MIN & 0xff00) >> 8;
	        g_pattern_param.adv_param.Advertising_Interval_Min[0] =  HCI_CMD_PARAM_ADVERTISING_INTERVAL_MIN & 0x00ff;
	        g_pattern_param.adv_param.Advertising_Interval_Min[1] = (HCI_CMD_PARAM_ADVERTISING_INTERVAL_MIN & 0xff00) >> 8;
            verdict = COMM_ADV_Undirected_Advertising(dut2_fd, g_pattern_param);
			VERDICT_RESULT_WITH_LINE();
		break;

		case 9:
			// Uptest   : addr_type = public 
			// Lwtest   : addr_type = public
			// IUT      : undirected advertising, filter policy = 0x01
			// ***********************************************************************************
            // Uptest(white list) config
            COMM_INI_Connection_Setup_White_Listed_Config(dut2, &g_pattern_param);
			memcpy(g_pattern_param.white_list_param.Address, scan_addr, ADDR_LENGTH);
            g_pattern_param.white_list_param.Address_Type[0] = HCI_CMD_PARAM_PUBLIC_DEVICE_ADDRESS;
			verdict = COMM_INI_Connection_Setup_White_Listed(dut2_fd, g_pattern_param);
			VERDICT_RESULT_WITH_LINE();

            // Lwtest(white list) config
            COMM_INI_Connection_Setup_White_Listed_Config(dut1, &g_pattern_param);
            memcpy(g_pattern_param.white_list_param.Address, adv_addr, ADDR_LENGTH);
            verdict=COMM_INI_Connection_Setup_White_Listed(dut1_fd, g_pattern_param);
            VERDICT_RESULT_WITH_LINE();

            
            // ***********************************************************************************            
            // Lwtest(SCN) config
            COMM_SCN_Active_Scanning_Config(dut1, &g_pattern_param);
            g_pattern_param.scn_param.Own_Address_Type[0] = HCI_CMD_PARAM_PUBLIC_DEVICE_ADDRESS;             
            g_pattern_param.scn_param.LE_Scan_Interval[0] =  0x0500 & 0x00ff;
	        g_pattern_param.scn_param.LE_Scan_Interval[1] = (0x0500 & 0xff00) >> 8;
	        g_pattern_param.scn_param.LE_Scan_Window[0] =	 0x0500 & 0x00ff;
	        g_pattern_param.scn_param.LE_Scan_Window[1] =   (0x0500 & 0xff00) >> 8;
            g_pattern_param.scn_param.Scanning_Filter_Policy[0] =   HCI_CMD_PARAM_IGNORE_ADV_PKTS_FROM_DEV_NOT_IN_WHITE_LIST_ONLY;

			verdict = COMM_SCN_Active_Scanning(dut1_fd, g_pattern_param);            
			VERDICT_RESULT_WITH_LINE();
            
            // ***********************************************************************************            
            // IUT(ADV) config
            COMM_ADV_Undirected_Advertising_Config(HCI_CMD_PARAM_ADV_DATA_LEN_MAX, &g_pattern_param);
            if(37 == adv_Channel) {
                g_pattern_param.adv_param.Advertising_Channel_Map[0] = HCI_CMD_PARAM_ENABLE_CHANNEL_37;
            }
            else if(38 == adv_Channel) {
                g_pattern_param.adv_param.Advertising_Channel_Map[0] = HCI_CMD_PARAM_ENABLE_CHANNEL_38;
            }
            else {
                g_pattern_param.adv_param.Advertising_Channel_Map[0] = HCI_CMD_PARAM_ENABLE_CHANNEL_39;
            }
			g_pattern_param.adv_param.Advertising_Filter_Policy[0] = HCI_CMD_PARAM_ALLOW_SCAN_REQ_FROM_WHITELIST_ONLY_AND_CONN_REQ_FROM_ANY;
            g_pattern_param.adv_param.Advertising_Interval_Max[0] =  HCI_CMD_PARAM_ADVERTISING_INTERVAL_MIN & 0x00ff;
	        g_pattern_param.adv_param.Advertising_Interval_Max[1] = (HCI_CMD_PARAM_ADVERTISING_INTERVAL_MIN & 0xff00) >> 8;
	        g_pattern_param.adv_param.Advertising_Interval_Min[0] =  HCI_CMD_PARAM_ADVERTISING_INTERVAL_MIN & 0x00ff;
	        g_pattern_param.adv_param.Advertising_Interval_Min[1] = (HCI_CMD_PARAM_ADVERTISING_INTERVAL_MIN & 0xff00) >> 8;
            verdict = COMM_ADV_Undirected_Advertising(dut2_fd, g_pattern_param);
			VERDICT_RESULT_WITH_LINE();
		break;


		//part F : filter policy = 0x01 ; Lwtest :addr_type=random repeat case 1~3=10~12
		case 10:			
            // Uptest   : addr_type = public 
			// Lwtest   : addr_type = random, addr error(black); 
			// IUT      : undirected advertising, filter policy = 0x01
			// ***********************************************************************************
			// Uptest(white list) config
			COMM_INI_Connection_Setup_White_Listed_Config(dut2, &g_pattern_param);
			memcpy(g_pattern_param.white_list_param.Address, scan_addr, ADDR_LENGTH);
            g_pattern_param.white_list_param.Address_Type[0] = HCI_CMD_PARAM_PUBLIC_DEVICE_ADDRESS;
			verdict = COMM_INI_Connection_Setup_White_Listed(dut2_fd, g_pattern_param);
			VERDICT_RESULT_WITH_LINE();

            // Lwtest(white list) config
            COMM_INI_Connection_Setup_White_Listed_Config(dut1, &g_pattern_param);
            memcpy(g_pattern_param.white_list_param.Address, adv_addr, ADDR_LENGTH);
            verdict=COMM_INI_Connection_Setup_White_Listed(dut1_fd, g_pattern_param);
            VERDICT_RESULT_WITH_LINE();

            
            // ***********************************************************************************            
            // Lwtest(SCN) config
            COMM_Static_Random_Device_Address_Set_Config(error_addr);
			COMM_Device_Address_Set(dut1_fd, g_pattern_param);
            COMM_SCN_Active_Scanning_Config(dut1, &g_pattern_param);            
            g_pattern_param.scn_param.Own_Address_Type[0] = HCI_CMD_PARAM_RANDOM_DEVICE_ADDRESS;             
            g_pattern_param.scn_param.LE_Scan_Interval[0] =  0x0500 & 0x00ff;
	        g_pattern_param.scn_param.LE_Scan_Interval[1] = (0x0500 & 0xff00) >> 8;
	        g_pattern_param.scn_param.LE_Scan_Window[0] =	 0x0500 & 0x00ff;
	        g_pattern_param.scn_param.LE_Scan_Window[1] =   (0x0500 & 0xff00) >> 8;
            g_pattern_param.scn_param.Scanning_Filter_Policy[0] =   HCI_CMD_PARAM_IGNORE_ADV_PKTS_FROM_DEV_NOT_IN_WHITE_LIST_ONLY;
            
			verdict = COMM_SCN_Active_Scanning(dut1_fd, g_pattern_param);            
			VERDICT_RESULT_WITH_LINE();
            
            // ***********************************************************************************            
            // IUT(ADV) config
            COMM_ADV_Undirected_Advertising_Config(HCI_CMD_PARAM_ADV_DATA_LEN_MAX, &g_pattern_param);
            if(37 == adv_Channel) {
                g_pattern_param.adv_param.Advertising_Channel_Map[0] = HCI_CMD_PARAM_ENABLE_CHANNEL_37;
            }
            else if(38 == adv_Channel) {
                g_pattern_param.adv_param.Advertising_Channel_Map[0] = HCI_CMD_PARAM_ENABLE_CHANNEL_38;
            }
            else {
                g_pattern_param.adv_param.Advertising_Channel_Map[0] = HCI_CMD_PARAM_ENABLE_CHANNEL_39;
            }
			g_pattern_param.adv_param.Advertising_Filter_Policy[0] = HCI_CMD_PARAM_ALLOW_SCAN_REQ_FROM_WHITELIST_ONLY_AND_CONN_REQ_FROM_ANY;
            g_pattern_param.adv_param.Advertising_Interval_Max[0] =  HCI_CMD_PARAM_ADVERTISING_INTERVAL_MIN & 0x00ff;
	        g_pattern_param.adv_param.Advertising_Interval_Max[1] = (HCI_CMD_PARAM_ADVERTISING_INTERVAL_MIN & 0xff00) >> 8;
	        g_pattern_param.adv_param.Advertising_Interval_Min[0] =  HCI_CMD_PARAM_ADVERTISING_INTERVAL_MIN & 0x00ff;
	        g_pattern_param.adv_param.Advertising_Interval_Min[1] = (HCI_CMD_PARAM_ADVERTISING_INTERVAL_MIN & 0xff00) >> 8;
            verdict = COMM_ADV_Undirected_Advertising(dut2_fd, g_pattern_param);
			VERDICT_RESULT_WITH_LINE();

		break;

		case 11:
			// Uptest   : addr_type = public 
			// Lwtest   : addr_type = random(error)
			// IUT      : undirected advertising, filter policy = 0x01
			// ***********************************************************************************
			// Uptest(white list) config
			COMM_INI_Connection_Setup_White_Listed_Config(dut2, &g_pattern_param);
			memcpy(g_pattern_param.white_list_param.Address, scan_addr, ADDR_LENGTH);
            g_pattern_param.white_list_param.Address_Type[0] = HCI_CMD_PARAM_PUBLIC_DEVICE_ADDRESS;
			verdict = COMM_INI_Connection_Setup_White_Listed(dut2_fd, g_pattern_param);
			VERDICT_RESULT_WITH_LINE();

            // Lwtest(white list) config
            COMM_INI_Connection_Setup_White_Listed_Config(dut1, &g_pattern_param);
            memcpy(g_pattern_param.white_list_param.Address, adv_addr, ADDR_LENGTH);
            verdict=COMM_INI_Connection_Setup_White_Listed(dut1_fd, g_pattern_param);
            VERDICT_RESULT_WITH_LINE();

            
            // ***********************************************************************************            
            // Lwtest(SCN) config
            //COMM_Static_Random_Device_Address_Set_Config(scan_random_addr);
			//COMM_Device_Address_Set(dut1_fd, g_pattern_param);
            COMM_SCN_Active_Scanning_Config(dut1, &g_pattern_param);
            COMM_Static_Random_Device_Address_Set_Config(scan_addr);
			COMM_Device_Address_Set(dut1_fd, g_pattern_param);
            g_pattern_param.scn_param.Own_Address_Type[0] = HCI_CMD_PARAM_RANDOM_DEVICE_ADDRESS;             
            g_pattern_param.scn_param.LE_Scan_Interval[0] =  0x0500 & 0x00ff;
	        g_pattern_param.scn_param.LE_Scan_Interval[1] = (0x0500 & 0xff00) >> 8;
	        g_pattern_param.scn_param.LE_Scan_Window[0] =	 0x0500 & 0x00ff;
	        g_pattern_param.scn_param.LE_Scan_Window[1] =   (0x0500 & 0xff00) >> 8;
            g_pattern_param.scn_param.Scanning_Filter_Policy[0] =   HCI_CMD_PARAM_IGNORE_ADV_PKTS_FROM_DEV_NOT_IN_WHITE_LIST_ONLY;

			verdict = COMM_SCN_Active_Scanning(dut1_fd, g_pattern_param);            
			VERDICT_RESULT_WITH_LINE();
            
            // ***********************************************************************************            
            // IUT(ADV) config
            COMM_ADV_Undirected_Advertising_Config(HCI_CMD_PARAM_ADV_DATA_LEN_MAX, &g_pattern_param);
            if(37 == adv_Channel) {
                g_pattern_param.adv_param.Advertising_Channel_Map[0] = HCI_CMD_PARAM_ENABLE_CHANNEL_37;
            }
            else if(38 == adv_Channel) {
                g_pattern_param.adv_param.Advertising_Channel_Map[0] = HCI_CMD_PARAM_ENABLE_CHANNEL_38;
            }
            else {
                g_pattern_param.adv_param.Advertising_Channel_Map[0] = HCI_CMD_PARAM_ENABLE_CHANNEL_39;
            }
			g_pattern_param.adv_param.Advertising_Filter_Policy[0] = HCI_CMD_PARAM_ALLOW_SCAN_REQ_FROM_WHITELIST_ONLY_AND_CONN_REQ_FROM_ANY;
            g_pattern_param.adv_param.Advertising_Interval_Max[0] =  HCI_CMD_PARAM_ADVERTISING_INTERVAL_MIN & 0x00ff;
	        g_pattern_param.adv_param.Advertising_Interval_Max[1] = (HCI_CMD_PARAM_ADVERTISING_INTERVAL_MIN & 0xff00) >> 8;
	        g_pattern_param.adv_param.Advertising_Interval_Min[0] =  HCI_CMD_PARAM_ADVERTISING_INTERVAL_MIN & 0x00ff;
	        g_pattern_param.adv_param.Advertising_Interval_Min[1] = (HCI_CMD_PARAM_ADVERTISING_INTERVAL_MIN & 0xff00) >> 8;
            verdict = COMM_ADV_Undirected_Advertising(dut2_fd, g_pattern_param);
			VERDICT_RESULT_WITH_LINE();
		break;

		case 12:			
			// Uptest   : addr_type = public 
			// Lwtest   : addr_type = public
			// IUT      : undirected advertising, filter policy = 0x01
			// ***********************************************************************************
            // Uptest(white list) config
            COMM_INI_Connection_Setup_White_Listed_Config(dut2, &g_pattern_param);
			memcpy(g_pattern_param.white_list_param.Address, scan_addr, ADDR_LENGTH);
            g_pattern_param.white_list_param.Address_Type[0] = HCI_CMD_PARAM_PUBLIC_DEVICE_ADDRESS;
			verdict = COMM_INI_Connection_Setup_White_Listed(dut2_fd, g_pattern_param);
			VERDICT_RESULT_WITH_LINE();

            // Lwtest(white list) config
            COMM_INI_Connection_Setup_White_Listed_Config(dut1, &g_pattern_param);
            memcpy(g_pattern_param.white_list_param.Address, adv_addr, ADDR_LENGTH);
            verdict=COMM_INI_Connection_Setup_White_Listed(dut1_fd, g_pattern_param);
            VERDICT_RESULT_WITH_LINE();

            
            // ***********************************************************************************            
            // Lwtest(SCN) config
            COMM_SCN_Active_Scanning_Config(dut1, &g_pattern_param);
            g_pattern_param.scn_param.Own_Address_Type[0] = HCI_CMD_PARAM_PUBLIC_DEVICE_ADDRESS;             
            g_pattern_param.scn_param.LE_Scan_Interval[0] =  0x0500 & 0x00ff;
	        g_pattern_param.scn_param.LE_Scan_Interval[1] = (0x0500 & 0xff00) >> 8;
	        g_pattern_param.scn_param.LE_Scan_Window[0] =	 0x0500 & 0x00ff;
	        g_pattern_param.scn_param.LE_Scan_Window[1] =   (0x0500 & 0xff00) >> 8;
            g_pattern_param.scn_param.Scanning_Filter_Policy[0] =   HCI_CMD_PARAM_IGNORE_ADV_PKTS_FROM_DEV_NOT_IN_WHITE_LIST_ONLY;

			verdict = COMM_SCN_Active_Scanning(dut1_fd, g_pattern_param);            
			VERDICT_RESULT_WITH_LINE();
            
            // ***********************************************************************************            
            // IUT(ADV) config
            COMM_ADV_Undirected_Advertising_Config(HCI_CMD_PARAM_ADV_DATA_LEN_MAX, &g_pattern_param);
            if(37 == adv_Channel) {
                g_pattern_param.adv_param.Advertising_Channel_Map[0] = HCI_CMD_PARAM_ENABLE_CHANNEL_37;
            }
            else if(38 == adv_Channel) {
                g_pattern_param.adv_param.Advertising_Channel_Map[0] = HCI_CMD_PARAM_ENABLE_CHANNEL_38;
            }
            else {
                g_pattern_param.adv_param.Advertising_Channel_Map[0] = HCI_CMD_PARAM_ENABLE_CHANNEL_39;
            }
			g_pattern_param.adv_param.Advertising_Filter_Policy[0] = HCI_CMD_PARAM_ALLOW_SCAN_REQ_FROM_WHITELIST_ONLY_AND_CONN_REQ_FROM_ANY;
            g_pattern_param.adv_param.Advertising_Interval_Max[0] =  HCI_CMD_PARAM_ADVERTISING_INTERVAL_MIN & 0x00ff;
	        g_pattern_param.adv_param.Advertising_Interval_Max[1] = (HCI_CMD_PARAM_ADVERTISING_INTERVAL_MIN & 0xff00) >> 8;
	        g_pattern_param.adv_param.Advertising_Interval_Min[0] =  HCI_CMD_PARAM_ADVERTISING_INTERVAL_MIN & 0x00ff;
	        g_pattern_param.adv_param.Advertising_Interval_Min[1] = (HCI_CMD_PARAM_ADVERTISING_INTERVAL_MIN & 0xff00) >> 8;
            verdict = COMM_ADV_Undirected_Advertising(dut2_fd, g_pattern_param);
			VERDICT_RESULT_WITH_LINE();
		break;


	}

	//uptest_part++;
	event_query_timer_config(2 , 0 , 0 , 0, &timer);
	event_query_timer_start(timer ,read_le_event_enable );


	while(adv_cnt <= 12)//waiting adv report event , timer or counter
	{
		if ( 1== read_le_event_get() )
		{
			//reset event flag
			read_le_event_disable();
CONT:
			//##################################################
     

			if ( 1 == (adv_cnt % 3) ){
                //because the TI SCN can't set public type and change the addr at the same time,
                //so we don't verify the behavior at case 1 & 7     
                if ((1 != adv_cnt) && (7 != adv_cnt)) {
                    while (check_cnt < 30) {
				        if (SUCCESS != QUERY_LE_Event(dut1_fd, buf, _BT_HCI_LE_EVENT_SUB_OP_ADVERTISING_REPORT_, HCI_SUBEVENT_ADV_RPT_EVENT_SCAN_RSP)) {
                            //query scan_rsp
                            line = __LINE__;
					        goto FUN_FAIL;
				        }				    
				        else if(EQUAL == hci_le_event_advertising_report_parsing(HCI_SUBEVENT_ADV_RPT_EVENT_SCAN_RSP, buf, g_pattern_param)) {
                            //there is no scan_rsp here ,so should not be equal
                            line = __LINE__;
					        goto FUN_FAIL;
				        }
                        else {
					        check_cnt ++ ;
                            printf("###run case : %d   ADV_Channel = %d ###\n", adv_cnt, adv_Channel);
					        printf("** Low Test expects no response from the IUT : %d / 30 times **\n" , check_cnt);
				        }
                        MSLEEP(200);
                    }    
                }                				
			}
			else if ( 2 == (adv_cnt % 3)) {
                while (check_cnt < 30) {
				    //query scan_rsp
				    if (SUCCESS != QUERY_LE_Event(dut1_fd, buf,	_BT_HCI_LE_EVENT_SUB_OP_ADVERTISING_REPORT_, HCI_SUBEVENT_ADV_RPT_EVENT_SCAN_RSP)) {
					    line = __LINE__;
					    goto FUN_FAIL;
				    }				
				    else if(EQUAL == hci_le_event_advertising_report_parsing(HCI_SUBEVENT_ADV_RPT_EVENT_SCAN_RSP, buf, g_pattern_param)) {
                        //there is no scan_rsp here ,so should not be equal
                        line = __LINE__;
					    goto FUN_FAIL;
				    }
                    else {
					    check_cnt ++ ;
                        printf("###run case : %d   ADV_Channel = %d ###\n", adv_cnt, adv_Channel);
					    printf("** Low Test expects no response from the IUT : %d / 30 times **\n" , check_cnt);
				    }
                    MSLEEP(200);
                }
			}
			else {                
		        //query scan_rsp
				if (SUCCESS != QUERY_LE_Event(dut1_fd, buf, _BT_HCI_LE_EVENT_SUB_OP_ADVERTISING_REPORT_, HCI_SUBEVENT_ADV_RPT_EVENT_SCAN_RSP)) {
				    line = __LINE__;
				    goto FUN_FAIL;
		        }				
				else if(EQUAL != hci_le_event_advertising_report_parsing(HCI_SUBEVENT_ADV_RPT_EVENT_SCAN_RSP, buf, g_pattern_param)) {
                    //expects a scan_rsp packet from thr IUT
                    if (scn_rsp_cnt < 100){
                        printf("check scn rsp cnt %d \n" , scn_rsp_cnt);
                        scn_rsp_cnt ++;
                        MSLEEP(300);

                        goto CONT;
                    }else{
                        line = __LINE__;
    					goto FUN_FAIL;
                    }                    
		        }
                else {
				    check_cnt ++ ;
                    printf("###run case : %d   ADV_Channel = %d ###\n", adv_cnt, adv_Channel);
					printf("** Low Test expects response from the IUT **\n");
				}
                MSLEEP(200);
			}
			//event add

			//because the TI SCN can't set public type and change the addr at the same time,
            //so we don't verify the behavior at case 1 & 7     
            if ((1 != adv_cnt) && (7 != adv_cnt)) {
                dut_reset_with_mask_en(dut1_fd);
                dut_reset_with_mask_en(dut2_fd);

                sleep(1);                
            }       
            
			if (37 == adv_Channel) {
                adv_Channel++;
            }
            else if(38 == adv_Channel) {
                adv_Channel++;
            }
            else {
                adv_Channel = 37;
                adv_cnt++;
            }
			goto REPEAT;
		}
	}

    FUNC_END();

	LOG_INFO("[Pattern][%s]SUCCESS\n" ,__FUNCTION__);
	return PASS;

FUN_FAIL:
    FUNC_END();

	LOG_INFO("[Pattern][%s]:%d FAIL %d \n" ,__FUNCTION__,line ,adv_cnt);
    return FAIL;

}

// 5.2.1.9
verdict DDI_ADV_Connection_Request_Device_Filtering(u8 dut1_fd ,u8 dut2_fd)
{
    u8 buf[SOCKET_BUF_SIZE];
    int adv_Channel = 37;
    int verdict = FAIL;
    int dut1 = 0, dut2 = 0;
    int check_cnt = 0;
    u16 line = 0;   
    struct itimerval timer;
    u32 adv_cnt = 1;
    u32 err_cnt = 0;

    COMM_Dut_clean_buffer(dut1_fd);
    COMM_Dut_clean_buffer(dut2_fd);

    Calculate_Execution_Time_Start();
REPEAT:
    check_cnt = 0;
    printf("###run case %d###\n", adv_cnt);
    switch (adv_cnt)
    {
        case 1:         
          /*// Uptest   : addr_type = public 
            // Lwtest   : addr_type = public, addr error(black); 
            // IUT      : undirected advertising, filter policy = 0x03
            // ***********************************************************************************
            // Uptest(white list) config
            COMM_INI_Connection_Setup_White_Listed_Config(dut2, &g_pattern_param);
            memcpy(g_pattern_param.white_list_param.Address, scan_addr, ADDR_LENGTH);
            g_pattern_param.white_list_param.Address_Type[0] = HCI_CMD_PARAM_PUBLIC_DEVICE_ADDRESS;
            verdict = COMM_INI_Connection_Setup_White_Listed(dut2_fd, g_pattern_param);
            VERDICT_RESULT_WITH_LINE();

            // Lwtest(white list) config
            COMM_INI_Connection_Setup_White_Listed_Config(dut1, &g_pattern_param);
            memcpy(g_pattern_param.white_list_param.Address, adv_addr, ADDR_LENGTH);
            verdict=COMM_INI_Connection_Setup_White_Listed(dut1_fd, g_pattern_param);
            VERDICT_RESULT_WITH_LINE();
            
            // ***********************************************************************************            
            // Lwtest(CON) config
            COMM_Static_Random_Device_Address_Set_Config(error_addr);
            COMM_Device_Address_Set(dut1_fd, g_pattern_param);
            COMM_INI_Initiating_Config(dut1, &g_pattern_param);
            g_pattern_param.create_conn_param.Own_Address_Type[0] = HCI_CMD_PARAM_RANDOM_DEVICE_ADDRESS;
            verdict = COMM_INI_Initiating(dut1_fd, g_pattern_param);            
            VERDICT_RESULT_WITH_LINE();
            
            // ***********************************************************************************            
            // IUT(ADV) config            
            COMM_ADV_Undirected_Advertising_Config(HCI_CMD_PARAM_ADV_DATA_LEN_MAX, &g_pattern_param);            
            memcpy(g_pattern_param.adv_param.Direct_Address, adv_addr, ADDR_LENGTH);
            if(37 == adv_Channel) {
                g_pattern_param.adv_param.Advertising_Channel_Map[0] = HCI_CMD_PARAM_ENABLE_CHANNEL_37;
            }
            else if(38 == adv_Channel) {
                g_pattern_param.adv_param.Advertising_Channel_Map[0] = HCI_CMD_PARAM_ENABLE_CHANNEL_38;
            }
            else {
                g_pattern_param.adv_param.Advertising_Channel_Map[0] = HCI_CMD_PARAM_ENABLE_CHANNEL_39;
            }
            g_pattern_param.adv_param.Advertising_Filter_Policy[0] = HCI_CMD_PARAM_ALLOW_SCAN_REQ_FROM_WHITELIST_ONLY_AND_CONN_REQ_FROM_WHITELIST_ONLY;
            g_pattern_param.adv_param.Advertising_Interval_Max[0] = HCI_CMD_PARAM_ADVERTISING_INTERVAL_MIN & 0x00ff;
            g_pattern_param.adv_param.Advertising_Interval_Max[1] = (HCI_CMD_PARAM_ADVERTISING_INTERVAL_MIN & 0xff00) >> 8;
            g_pattern_param.adv_param.Advertising_Interval_Min[0] = HCI_CMD_PARAM_ADVERTISING_INTERVAL_MIN & 0x00ff;
            g_pattern_param.adv_param.Advertising_Interval_Min[1] = (HCI_CMD_PARAM_ADVERTISING_INTERVAL_MIN & 0xff00) >> 8;
            verdict = COMM_ADV_Undirected_Advertising(dut2_fd, g_pattern_param);
            VERDICT_RESULT_WITH_LINE();*/
        break;
 
        case 2:         
            // Uptest   : addr_type = public 
            // Lwtest   : addr_type = random
            // IUT      : undirected advertising, filter policy = 0x03
            // ***********************************************************************************
            // Uptest(white list) config
            COMM_INI_Connection_Setup_White_Listed_Config(dut2, &g_pattern_param);
            memcpy(g_pattern_param.white_list_param.Address, scan_addr, ADDR_LENGTH);
            g_pattern_param.white_list_param.Address_Type[0] = HCI_CMD_PARAM_PUBLIC_DEVICE_ADDRESS;
            verdict = COMM_INI_Connection_Setup_White_Listed(dut2_fd, g_pattern_param);
            VERDICT_RESULT_WITH_LINE();

            // Lwtest(white list) config
            COMM_INI_Connection_Setup_White_Listed_Config(dut1, &g_pattern_param);
            memcpy(g_pattern_param.white_list_param.Address, adv_addr, ADDR_LENGTH);
            verdict=COMM_INI_Connection_Setup_White_Listed(dut1_fd, g_pattern_param);
            VERDICT_RESULT_WITH_LINE();
            
            // ***********************************************************************************            
            // Lwtest(CON) config
            COMM_INI_Initiating_Config(dut1, &g_pattern_param);
            COMM_Static_Random_Device_Address_Set_Config(scan_addr);
            COMM_Device_Address_Set(dut1_fd, g_pattern_param);
            //memcpy(g_pattern_param.create_conn_param.Peer_Address, adv_addr, ADDR_LENGTH );
            g_pattern_param.create_conn_param.Own_Address_Type[0] = HCI_CMD_PARAM_RANDOM_DEVICE_ADDRESS;
            g_pattern_param.create_conn_param.Initiator_Filter_Policy[0] = HCI_CMD_PARAM_FILTER_POLICY_WHITE_LIST_USED;

            verdict = COMM_INI_Initiating(dut1_fd, g_pattern_param);            
            VERDICT_RESULT_WITH_LINE();
            
            // ***********************************************************************************            
            // IUT(ADV) config
            COMM_ADV_Undirected_Advertising_Config(HCI_CMD_PARAM_ADV_DATA_LEN_MAX, &g_pattern_param);
            memcpy(g_pattern_param.adv_param.Direct_Address, adv_addr, ADDR_LENGTH);
            if(37 == adv_Channel) {
                g_pattern_param.adv_param.Advertising_Channel_Map[0] = HCI_CMD_PARAM_ENABLE_CHANNEL_37;
            }
            else if(38 == adv_Channel) {
                g_pattern_param.adv_param.Advertising_Channel_Map[0] = HCI_CMD_PARAM_ENABLE_CHANNEL_38;
            }
            else {
                g_pattern_param.adv_param.Advertising_Channel_Map[0] = HCI_CMD_PARAM_ENABLE_CHANNEL_39;
            }
            g_pattern_param.adv_param.Advertising_Filter_Policy[0] = HCI_CMD_PARAM_ALLOW_SCAN_REQ_FROM_WHITELIST_ONLY_AND_CONN_REQ_FROM_WHITELIST_ONLY;
            g_pattern_param.adv_param.Advertising_Interval_Max[0] =  HCI_CMD_PARAM_ADVERTISING_INTERVAL_MIN & 0x00ff;
            g_pattern_param.adv_param.Advertising_Interval_Max[1] = (HCI_CMD_PARAM_ADVERTISING_INTERVAL_MIN & 0xff00) >> 8;
            g_pattern_param.adv_param.Advertising_Interval_Min[0] =  HCI_CMD_PARAM_ADVERTISING_INTERVAL_MIN & 0x00ff;
            g_pattern_param.adv_param.Advertising_Interval_Min[1] = (HCI_CMD_PARAM_ADVERTISING_INTERVAL_MIN & 0xff00) >> 8;
            verdict = COMM_ADV_Undirected_Advertising(dut2_fd, g_pattern_param);
            VERDICT_RESULT_WITH_LINE();
        break;
          case 3:         
            // Uptest   : addr_type = public 
            // Lwtest   : addr_type = public
            // IUT      : undirected advertising, filter policy = 0x03
            // ***********************************************************************************
            // Uptest(white list) config
            COMM_INI_Connection_Setup_White_Listed_Config(dut2, &g_pattern_param);
            memcpy(g_pattern_param.white_list_param.Address, scan_addr, ADDR_LENGTH);
            g_pattern_param.white_list_param.Address_Type[0] = HCI_CMD_PARAM_PUBLIC_DEVICE_ADDRESS;
            verdict = COMM_INI_Connection_Setup_White_Listed(dut2_fd, g_pattern_param);
            VERDICT_RESULT_WITH_LINE();

            // Lwtest(white list) config
            COMM_INI_Connection_Setup_White_Listed_Config(dut1, &g_pattern_param);
            memcpy(g_pattern_param.white_list_param.Address, adv_addr, ADDR_LENGTH);
            verdict=COMM_INI_Connection_Setup_White_Listed(dut1_fd, g_pattern_param);
            VERDICT_RESULT_WITH_LINE();
            
            // ***********************************************************************************            
            // Lwtest(CON) config
            COMM_INI_Initiating_Config(dut1, &g_pattern_param);
            memcpy(g_pattern_param.create_conn_param.Peer_Address, adv_addr, ADDR_LENGTH );
            g_pattern_param.create_conn_param.Own_Address_Type[0] = HCI_CMD_PARAM_PUBLIC_DEVICE_ADDRESS;
            g_pattern_param.create_conn_param.Initiator_Filter_Policy[0] = HCI_CMD_PARAM_FILTER_POLICY_WHITE_LIST_USED;
            
            verdict = COMM_INI_Initiating(dut1_fd, g_pattern_param);            
            VERDICT_RESULT_WITH_LINE();
             
            // ***********************************************************************************            
            // IUT(ADV) config
            COMM_ADV_Undirected_Advertising_Config(HCI_CMD_PARAM_ADV_DATA_LEN_MAX, &g_pattern_param);
            //memcpy(g_pattern_param.adv_param.Direct_Address, adv_addr, ADDR_LENGTH);
            if(37 == adv_Channel) {
                g_pattern_param.adv_param.Advertising_Channel_Map[0] = HCI_CMD_PARAM_ENABLE_CHANNEL_37;
            }
            else if(38 == adv_Channel) {
                g_pattern_param.adv_param.Advertising_Channel_Map[0] = HCI_CMD_PARAM_ENABLE_CHANNEL_38;
            }
            else {
                g_pattern_param.adv_param.Advertising_Channel_Map[0] = HCI_CMD_PARAM_ENABLE_CHANNEL_39;
            }
            g_pattern_param.adv_param.Advertising_Filter_Policy[0] = HCI_CMD_PARAM_ALLOW_SCAN_REQ_FROM_WHITELIST_ONLY_AND_CONN_REQ_FROM_WHITELIST_ONLY;
            g_pattern_param.adv_param.Advertising_Interval_Max[0] =  HCI_CMD_PARAM_ADVERTISING_INTERVAL_MIN & 0x00ff;
            g_pattern_param.adv_param.Advertising_Interval_Max[1] = (HCI_CMD_PARAM_ADVERTISING_INTERVAL_MIN & 0xff00) >> 8;
            g_pattern_param.adv_param.Advertising_Interval_Min[0] =  HCI_CMD_PARAM_ADVERTISING_INTERVAL_MIN & 0x00ff;
            g_pattern_param.adv_param.Advertising_Interval_Min[1] = (HCI_CMD_PARAM_ADVERTISING_INTERVAL_MIN & 0xff00) >> 8;
            verdict = COMM_ADV_Undirected_Advertising(dut2_fd, g_pattern_param);
            VERDICT_RESULT_WITH_LINE();
        break;
        
        case 4:         
            // Uptest   : addr_type = public 
            // Lwtest   : addr_type = random, addr error(black); 
            // IUT      : undirected advertising, filter policy = 0x03
            // ***********************************************************************************
            // Uptest(white list) config
            COMM_INI_Connection_Setup_White_Listed_Config(dut2, &g_pattern_param);
            memcpy(g_pattern_param.white_list_param.Address, scan_addr, ADDR_LENGTH);
            g_pattern_param.white_list_param.Address_Type[0] = HCI_CMD_PARAM_PUBLIC_DEVICE_ADDRESS;
            verdict = COMM_INI_Connection_Setup_White_Listed(dut2_fd, g_pattern_param);
            VERDICT_RESULT_WITH_LINE();

            // Lwtest(white list) config
            COMM_INI_Connection_Setup_White_Listed_Config(dut1, &g_pattern_param);
            memcpy(g_pattern_param.white_list_param.Address, adv_addr, ADDR_LENGTH);
            verdict=COMM_INI_Connection_Setup_White_Listed(dut1_fd, g_pattern_param);
            VERDICT_RESULT_WITH_LINE();

            
            // ***********************************************************************************            
            // Lwtest(CON) config
            COMM_Static_Random_Device_Address_Set_Config(error_addr);
            COMM_Device_Address_Set(dut1_fd, g_pattern_param);
            COMM_INI_Initiating_Config(dut1, &g_pattern_param);
            g_pattern_param.create_conn_param.Own_Address_Type[0] = HCI_CMD_PARAM_RANDOM_DEVICE_ADDRESS;
            g_pattern_param.create_conn_param.Initiator_Filter_Policy[0] = HCI_CMD_PARAM_FILTER_POLICY_WHITE_LIST_USED;

            verdict = COMM_INI_Initiating(dut1_fd, g_pattern_param);            
            VERDICT_RESULT_WITH_LINE();
            
            // ***********************************************************************************            
            // IUT(ADV) config
            COMM_ADV_Undirected_Advertising_Config(HCI_CMD_PARAM_ADV_DATA_LEN_MAX, &g_pattern_param);            
            memcpy(g_pattern_param.adv_param.Direct_Address, adv_addr, ADDR_LENGTH);
            if(37 == adv_Channel) {
                g_pattern_param.adv_param.Advertising_Channel_Map[0] = HCI_CMD_PARAM_ENABLE_CHANNEL_37;
            }
            else if(38 == adv_Channel) {
                g_pattern_param.adv_param.Advertising_Channel_Map[0] = HCI_CMD_PARAM_ENABLE_CHANNEL_38;
            }
            else {
                g_pattern_param.adv_param.Advertising_Channel_Map[0] = HCI_CMD_PARAM_ENABLE_CHANNEL_39;
            }
            g_pattern_param.adv_param.Advertising_Filter_Policy[0] = HCI_CMD_PARAM_ALLOW_SCAN_REQ_FROM_WHITELIST_ONLY_AND_CONN_REQ_FROM_WHITELIST_ONLY;
            g_pattern_param.adv_param.Advertising_Interval_Max[0] =  HCI_CMD_PARAM_ADVERTISING_INTERVAL_MIN & 0x00ff;
            g_pattern_param.adv_param.Advertising_Interval_Max[1] = (HCI_CMD_PARAM_ADVERTISING_INTERVAL_MIN & 0xff00) >> 8;
            g_pattern_param.adv_param.Advertising_Interval_Min[0] =  HCI_CMD_PARAM_ADVERTISING_INTERVAL_MIN & 0x00ff;
            g_pattern_param.adv_param.Advertising_Interval_Min[1] = (HCI_CMD_PARAM_ADVERTISING_INTERVAL_MIN & 0xff00) >> 8;
            verdict = COMM_ADV_Undirected_Advertising(dut2_fd, g_pattern_param);
            VERDICT_RESULT_WITH_LINE();
        break;

        case 5:         
            // Uptest   : addr_type = public 
            // Lwtest   : addr_type = random(error)
            // IUT      : undirected advertising, filter policy = 0x03
            // ***********************************************************************************
            // Uptest(white list) config
            COMM_INI_Connection_Setup_White_Listed_Config(dut2, &g_pattern_param);
            memcpy(g_pattern_param.white_list_param.Address, scan_addr, ADDR_LENGTH);
            g_pattern_param.white_list_param.Address_Type[0] = HCI_CMD_PARAM_PUBLIC_DEVICE_ADDRESS;
            verdict = COMM_INI_Connection_Setup_White_Listed(dut2_fd, g_pattern_param);
            VERDICT_RESULT_WITH_LINE();

            // Lwtest(white list) config
            COMM_INI_Connection_Setup_White_Listed_Config(dut1, &g_pattern_param);
            memcpy(g_pattern_param.white_list_param.Address, adv_addr, ADDR_LENGTH);
            verdict=COMM_INI_Connection_Setup_White_Listed(dut1_fd, g_pattern_param);
            VERDICT_RESULT_WITH_LINE();

            
            // ***********************************************************************************            
            // Lwtest(CON) config
            COMM_INI_Initiating_Config(dut1, &g_pattern_param);
            COMM_Static_Random_Device_Address_Set_Config(scan_addr);
            COMM_Device_Address_Set(dut1_fd, g_pattern_param);
            //memcpy(g_pattern_param.create_conn_param.Peer_Address, adv_addr, ADDR_LENGTH );
            g_pattern_param.create_conn_param.Own_Address_Type[0] = HCI_CMD_PARAM_RANDOM_DEVICE_ADDRESS;
            g_pattern_param.create_conn_param.Initiator_Filter_Policy[0] = HCI_CMD_PARAM_FILTER_POLICY_WHITE_LIST_USED;

            verdict = COMM_INI_Initiating(dut1_fd, g_pattern_param);            
            VERDICT_RESULT_WITH_LINE();
            
            // ***********************************************************************************            
            // IUT(ADV) config
            COMM_ADV_Undirected_Advertising_Config(HCI_CMD_PARAM_ADV_DATA_LEN_MAX, &g_pattern_param);
            memcpy(g_pattern_param.adv_param.Direct_Address, adv_addr, ADDR_LENGTH);
            if(37 == adv_Channel) {
                g_pattern_param.adv_param.Advertising_Channel_Map[0] = HCI_CMD_PARAM_ENABLE_CHANNEL_37;
            }
            else if(38 == adv_Channel) {
                g_pattern_param.adv_param.Advertising_Channel_Map[0] = HCI_CMD_PARAM_ENABLE_CHANNEL_38;
            }
            else {
                g_pattern_param.adv_param.Advertising_Channel_Map[0] = HCI_CMD_PARAM_ENABLE_CHANNEL_39;
            }
            g_pattern_param.adv_param.Advertising_Filter_Policy[0] = HCI_CMD_PARAM_ALLOW_SCAN_REQ_FROM_WHITELIST_ONLY_AND_CONN_REQ_FROM_WHITELIST_ONLY;
            g_pattern_param.adv_param.Advertising_Interval_Max[0] =  HCI_CMD_PARAM_ADVERTISING_INTERVAL_MIN & 0x00ff;
            g_pattern_param.adv_param.Advertising_Interval_Max[1] = (HCI_CMD_PARAM_ADVERTISING_INTERVAL_MIN & 0xff00) >> 8;
            g_pattern_param.adv_param.Advertising_Interval_Min[0] =  HCI_CMD_PARAM_ADVERTISING_INTERVAL_MIN & 0x00ff;
            g_pattern_param.adv_param.Advertising_Interval_Min[1] = (HCI_CMD_PARAM_ADVERTISING_INTERVAL_MIN & 0xff00) >> 8;
            verdict = COMM_ADV_Undirected_Advertising(dut2_fd, g_pattern_param);
            VERDICT_RESULT_WITH_LINE();
        break;

        case 6:
            // Uptest   : addr_type = public 
            // Lwtest   : addr_type = public
            // IUT      : undirected advertising, filter policy = 0x03
            // ***********************************************************************************
            // Uptest(white list) config
            COMM_INI_Connection_Setup_White_Listed_Config(dut2, &g_pattern_param);
            memcpy(g_pattern_param.white_list_param.Address, scan_addr, ADDR_LENGTH);
            g_pattern_param.white_list_param.Address_Type[0] = HCI_CMD_PARAM_PUBLIC_DEVICE_ADDRESS;
            verdict = COMM_INI_Connection_Setup_White_Listed(dut2_fd, g_pattern_param);
            VERDICT_RESULT_WITH_LINE();

            // Lwtest(white list) config
            COMM_INI_Connection_Setup_White_Listed_Config(dut1, &g_pattern_param);
            memcpy(g_pattern_param.white_list_param.Address, adv_addr, ADDR_LENGTH);
            verdict=COMM_INI_Connection_Setup_White_Listed(dut1_fd, g_pattern_param);
            VERDICT_RESULT_WITH_LINE();

            
            // ***********************************************************************************            
            // Lwtest(CON) config
            COMM_INI_Initiating_Config(dut1, &g_pattern_param);
            memcpy(g_pattern_param.create_conn_param.Peer_Address, adv_addr, ADDR_LENGTH );
            g_pattern_param.create_conn_param.Own_Address_Type[0] = HCI_CMD_PARAM_PUBLIC_DEVICE_ADDRESS;
            g_pattern_param.create_conn_param.Initiator_Filter_Policy[0] = HCI_CMD_PARAM_FILTER_POLICY_WHITE_LIST_USED;

            verdict = COMM_INI_Initiating(dut1_fd, g_pattern_param);            
            VERDICT_RESULT_WITH_LINE();
             
            // ***********************************************************************************            
            // IUT(ADV) config
            COMM_ADV_Undirected_Advertising_Config(HCI_CMD_PARAM_ADV_DATA_LEN_MAX, &g_pattern_param);
            memcpy(g_pattern_param.adv_param.Direct_Address, adv_addr, ADDR_LENGTH);
            if(37 == adv_Channel) {
                g_pattern_param.adv_param.Advertising_Channel_Map[0] = HCI_CMD_PARAM_ENABLE_CHANNEL_37;
            }
            else if(38 == adv_Channel) {
                g_pattern_param.adv_param.Advertising_Channel_Map[0] = HCI_CMD_PARAM_ENABLE_CHANNEL_38;
            }
            else {
                g_pattern_param.adv_param.Advertising_Channel_Map[0] = HCI_CMD_PARAM_ENABLE_CHANNEL_39;
            }
            g_pattern_param.adv_param.Advertising_Filter_Policy[0] = HCI_CMD_PARAM_ALLOW_SCAN_REQ_FROM_WHITELIST_ONLY_AND_CONN_REQ_FROM_WHITELIST_ONLY;
            g_pattern_param.adv_param.Advertising_Interval_Max[0] =  HCI_CMD_PARAM_ADVERTISING_INTERVAL_MIN & 0x00ff;
            g_pattern_param.adv_param.Advertising_Interval_Max[1] = (HCI_CMD_PARAM_ADVERTISING_INTERVAL_MIN & 0xff00) >> 8;
            g_pattern_param.adv_param.Advertising_Interval_Min[0] =  HCI_CMD_PARAM_ADVERTISING_INTERVAL_MIN & 0x00ff;
            g_pattern_param.adv_param.Advertising_Interval_Min[1] = (HCI_CMD_PARAM_ADVERTISING_INTERVAL_MIN & 0xff00) >> 8;
            verdict = COMM_ADV_Undirected_Advertising(dut2_fd, g_pattern_param);
            VERDICT_RESULT_WITH_LINE();
        break;

        //part E : filter policy = 0x01 ;   repeat case1~3=>7~9
        case 7:         
            /*// Uptest   : addr_type = public 
            // Lwtest   : addr_type = public, addr error(black); 
            // IUT      : undirected advertising, filter policy = 0x02
            // ***********************************************************************************
            // Uptest(white list) config
            COMM_INI_Connection_Setup_White_Listed_Config(dut2, &g_pattern_param);
            memcpy(g_pattern_param.white_list_param.Address, scan_addr, ADDR_LENGTH);
            g_pattern_param.white_list_param.Address_Type[0] = HCI_CMD_PARAM_PUBLIC_DEVICE_ADDRESS;
            verdict = COMM_INI_Connection_Setup_White_Listed(dut2_fd, g_pattern_param);
            VERDICT_RESULT_WITH_LINE();

            // Lwtest(white list) config
            COMM_INI_Connection_Setup_White_Listed_Config(dut1, &g_pattern_param);
            memcpy(g_pattern_param.white_list_param.Address, adv_addr, ADDR_LENGTH);
            verdict=COMM_INI_Connection_Setup_White_Listed(dut1_fd, g_pattern_param);
            VERDICT_RESULT_WITH_LINE();

            
            // ***********************************************************************************            
            // Lwtest(CON) config
            COMM_Static_Random_Device_Address_Set_Config(error_addr);
            COMM_Device_Address_Set(dut1_fd, g_pattern_param);
            COMM_INI_Initiating_Config(dut1, &g_pattern_param);
            g_pattern_param.create_conn_param.Own_Address_Type[0] = HCI_CMD_PARAM_RANDOM_DEVICE_ADDRESS;
            g_pattern_param.create_conn_param.Initiator_Filter_Policy[0] = HCI_CMD_PARAM_FILTER_POLICY_WHITE_LIST_USED;

            verdict = COMM_INI_Initiating(dut1_fd, g_pattern_param);            
            VERDICT_RESULT_WITH_LINE();
            
            // ***********************************************************************************            
            // IUT(ADV) config
            COMM_ADV_Undirected_Advertising_Config(HCI_CMD_PARAM_ADV_DATA_LEN_MAX, &g_pattern_param);
            memcpy(g_pattern_param.adv_param.Direct_Address, adv_addr, ADDR_LENGTH);
            if(37 == adv_Channel) {
                g_pattern_param.adv_param.Advertising_Channel_Map[0] = HCI_CMD_PARAM_ENABLE_CHANNEL_37;
            }
            else if(38 == adv_Channel) {
                g_pattern_param.adv_param.Advertising_Channel_Map[0] = HCI_CMD_PARAM_ENABLE_CHANNEL_38;
            }
            else {
                g_pattern_param.adv_param.Advertising_Channel_Map[0] = HCI_CMD_PARAM_ENABLE_CHANNEL_39;
            }
            g_pattern_param.adv_param.Advertising_Filter_Policy[0] = HCI_CMD_PARAM_ALLOW_SCAN_REQ_FROM_ANY_AND_CONN_REQ_FROM_WHITELIST_ONLY;
            g_pattern_param.adv_param.Advertising_Interval_Max[0] = HCI_CMD_PARAM_ADVERTISING_INTERVAL_MIN & 0x00ff;
            g_pattern_param.adv_param.Advertising_Interval_Max[1] = (HCI_CMD_PARAM_ADVERTISING_INTERVAL_MIN & 0xff00) >> 8;
            g_pattern_param.adv_param.Advertising_Interval_Min[0] = HCI_CMD_PARAM_ADVERTISING_INTERVAL_MIN & 0x00ff;
            g_pattern_param.adv_param.Advertising_Interval_Min[1] = (HCI_CMD_PARAM_ADVERTISING_INTERVAL_MIN & 0xff00) >> 8;
            verdict = COMM_ADV_Undirected_Advertising(dut2_fd, g_pattern_param);
            VERDICT_RESULT_WITH_LINE();*/

        break;

        case 8:         
            // Uptest   : addr_type = public 
            // Lwtest   : addr_type = random(error)
            // IUT      : undirected advertising, filter policy = 0x02
            // ***********************************************************************************
            // Uptest(white list) config
            COMM_INI_Connection_Setup_White_Listed_Config(dut2, &g_pattern_param);
            memcpy(g_pattern_param.white_list_param.Address, scan_addr, ADDR_LENGTH);
            g_pattern_param.white_list_param.Address_Type[0] = HCI_CMD_PARAM_PUBLIC_DEVICE_ADDRESS;
            verdict = COMM_INI_Connection_Setup_White_Listed(dut2_fd, g_pattern_param);
            VERDICT_RESULT_WITH_LINE();


        	// Lwtest(white list) config
        	COMM_INI_Connection_Setup_White_Listed_Config(dut1, &g_pattern_param);
        	memcpy(g_pattern_param.white_list_param.Address, adv_addr, ADDR_LENGTH);
        	verdict=COMM_INI_Connection_Setup_White_Listed(dut1_fd, g_pattern_param);
        	VERDICT_RESULT_WITH_LINE();            
            // ***********************************************************************************            
            // Lwtest(CON) config
            COMM_INI_Initiating_Config(dut1, &g_pattern_param);
            COMM_Static_Random_Device_Address_Set_Config(scan_addr);
            COMM_Device_Address_Set(dut1_fd, g_pattern_param);
            //memcpy(g_pattern_param.create_conn_param.Peer_Address, adv_addr, ADDR_LENGTH );
            g_pattern_param.create_conn_param.Own_Address_Type[0] = HCI_CMD_PARAM_RANDOM_DEVICE_ADDRESS;
            g_pattern_param.create_conn_param.Initiator_Filter_Policy[0] = HCI_CMD_PARAM_FILTER_POLICY_WHITE_LIST_USED;

            verdict = COMM_INI_Initiating(dut1_fd, g_pattern_param);            
            VERDICT_RESULT_WITH_LINE();
            
            // ***********************************************************************************            
            // IUT(ADV) config
            COMM_ADV_Undirected_Advertising_Config(HCI_CMD_PARAM_ADV_DATA_LEN_MAX, &g_pattern_param);
            memcpy(g_pattern_param.adv_param.Direct_Address, adv_addr, ADDR_LENGTH);
            if(37 == adv_Channel) {
                g_pattern_param.adv_param.Advertising_Channel_Map[0] = HCI_CMD_PARAM_ENABLE_CHANNEL_37;
            }
            else if(38 == adv_Channel) {
                g_pattern_param.adv_param.Advertising_Channel_Map[0] = HCI_CMD_PARAM_ENABLE_CHANNEL_38;
            }
            else {
                g_pattern_param.adv_param.Advertising_Channel_Map[0] = HCI_CMD_PARAM_ENABLE_CHANNEL_39;
            }
            g_pattern_param.adv_param.Advertising_Filter_Policy[0] = HCI_CMD_PARAM_ALLOW_SCAN_REQ_FROM_ANY_AND_CONN_REQ_FROM_WHITELIST_ONLY;
            g_pattern_param.adv_param.Advertising_Interval_Max[0] =  HCI_CMD_PARAM_ADVERTISING_INTERVAL_MIN & 0x00ff;
            g_pattern_param.adv_param.Advertising_Interval_Max[1] = (HCI_CMD_PARAM_ADVERTISING_INTERVAL_MIN & 0xff00) >> 8;
            g_pattern_param.adv_param.Advertising_Interval_Min[0] =  HCI_CMD_PARAM_ADVERTISING_INTERVAL_MIN & 0x00ff;
            g_pattern_param.adv_param.Advertising_Interval_Min[1] = (HCI_CMD_PARAM_ADVERTISING_INTERVAL_MIN & 0xff00) >> 8;
            verdict = COMM_ADV_Undirected_Advertising(dut2_fd, g_pattern_param);
            VERDICT_RESULT_WITH_LINE();
        break;

        case 9:
            // Uptest   : addr_type = public 
            // Lwtest   : addr_type = public
            // IUT      : undirected advertising, filter policy = 0x02
            // ***********************************************************************************
            // Uptest(white list) config
            COMM_INI_Connection_Setup_White_Listed_Config(dut2, &g_pattern_param);
            memcpy(g_pattern_param.white_list_param.Address, scan_addr, ADDR_LENGTH);
            g_pattern_param.white_list_param.Address_Type[0] = HCI_CMD_PARAM_PUBLIC_DEVICE_ADDRESS;
            verdict = COMM_INI_Connection_Setup_White_Listed(dut2_fd, g_pattern_param);
            VERDICT_RESULT_WITH_LINE();

            // Lwtest(white list) config
            COMM_INI_Connection_Setup_White_Listed_Config(dut1, &g_pattern_param);
            memcpy(g_pattern_param.white_list_param.Address, adv_addr, ADDR_LENGTH);
            verdict=COMM_INI_Connection_Setup_White_Listed(dut1_fd, g_pattern_param);
            VERDICT_RESULT_WITH_LINE();

            
            // ***********************************************************************************            
            // Lwtest(CON) config
            COMM_INI_Initiating_Config(dut1, &g_pattern_param);
            memcpy(g_pattern_param.create_conn_param.Peer_Address, adv_addr, ADDR_LENGTH );
            g_pattern_param.create_conn_param.Own_Address_Type[0] = HCI_CMD_PARAM_PUBLIC_DEVICE_ADDRESS;
            g_pattern_param.create_conn_param.Initiator_Filter_Policy[0] = HCI_CMD_PARAM_FILTER_POLICY_WHITE_LIST_USED;

            verdict = COMM_INI_Initiating(dut1_fd, g_pattern_param);            
            VERDICT_RESULT_WITH_LINE();
            
            // ***********************************************************************************            
            // IUT(ADV) config
            COMM_ADV_Undirected_Advertising_Config(HCI_CMD_PARAM_ADV_DATA_LEN_MAX, &g_pattern_param);
            memcpy(g_pattern_param.adv_param.Direct_Address, adv_addr, ADDR_LENGTH);
            if(37 == adv_Channel) {
                g_pattern_param.adv_param.Advertising_Channel_Map[0] = HCI_CMD_PARAM_ENABLE_CHANNEL_37;
            }
            else if(38 == adv_Channel) {
                g_pattern_param.adv_param.Advertising_Channel_Map[0] = HCI_CMD_PARAM_ENABLE_CHANNEL_38;
            }
            else {
                g_pattern_param.adv_param.Advertising_Channel_Map[0] = HCI_CMD_PARAM_ENABLE_CHANNEL_39;
            }
            g_pattern_param.adv_param.Advertising_Filter_Policy[0] = HCI_CMD_PARAM_ALLOW_SCAN_REQ_FROM_ANY_AND_CONN_REQ_FROM_WHITELIST_ONLY;
            g_pattern_param.adv_param.Advertising_Interval_Max[0] =  HCI_CMD_PARAM_ADVERTISING_INTERVAL_MIN & 0x00ff;
            g_pattern_param.adv_param.Advertising_Interval_Max[1] = (HCI_CMD_PARAM_ADVERTISING_INTERVAL_MIN & 0xff00) >> 8;
            g_pattern_param.adv_param.Advertising_Interval_Min[0] =  HCI_CMD_PARAM_ADVERTISING_INTERVAL_MIN & 0x00ff;
            g_pattern_param.adv_param.Advertising_Interval_Min[1] = (HCI_CMD_PARAM_ADVERTISING_INTERVAL_MIN & 0xff00) >> 8;
            verdict = COMM_ADV_Undirected_Advertising(dut2_fd, g_pattern_param);
            VERDICT_RESULT_WITH_LINE();
        break;


        //part F : filter policy = 0x01 ; Lwtest :addr_type=random repeat case 1~3=10~12
        case 10:            
            // Uptest   : addr_type = public 
            // Lwtest   : addr_type = random, addr error(black); 
            // IUT      : undirected advertising, filter policy = 0x02
            // ***********************************************************************************
            // Uptest(white list) config
            COMM_INI_Connection_Setup_White_Listed_Config(dut2, &g_pattern_param);
            memcpy(g_pattern_param.white_list_param.Address, scan_addr, ADDR_LENGTH);
            g_pattern_param.white_list_param.Address_Type[0] = HCI_CMD_PARAM_PUBLIC_DEVICE_ADDRESS;
            verdict = COMM_INI_Connection_Setup_White_Listed(dut2_fd, g_pattern_param);
            VERDICT_RESULT_WITH_LINE();

            // Lwtest(white list) config
            COMM_INI_Connection_Setup_White_Listed_Config(dut1, &g_pattern_param);
            memcpy(g_pattern_param.white_list_param.Address, adv_addr, ADDR_LENGTH);
            verdict=COMM_INI_Connection_Setup_White_Listed(dut1_fd, g_pattern_param);
            VERDICT_RESULT_WITH_LINE();

            
            // ***********************************************************************************            
            // Lwtest(CON) config
            COMM_Static_Random_Device_Address_Set_Config(error_addr);
            COMM_Device_Address_Set(dut1_fd, g_pattern_param);
            COMM_INI_Initiating_Config(dut1, &g_pattern_param);
            g_pattern_param.create_conn_param.Own_Address_Type[0] = HCI_CMD_PARAM_RANDOM_DEVICE_ADDRESS;
            g_pattern_param.create_conn_param.Initiator_Filter_Policy[0] = HCI_CMD_PARAM_FILTER_POLICY_WHITE_LIST_USED;

            verdict = COMM_INI_Initiating(dut1_fd, g_pattern_param);            
            VERDICT_RESULT_WITH_LINE();
            
            // ***********************************************************************************            
            // IUT(ADV) config
            COMM_ADV_Undirected_Advertising_Config(HCI_CMD_PARAM_ADV_DATA_LEN_MAX, &g_pattern_param);
            memcpy(g_pattern_param.adv_param.Direct_Address, adv_addr, ADDR_LENGTH);
            if(37 == adv_Channel) {
                g_pattern_param.adv_param.Advertising_Channel_Map[0] = HCI_CMD_PARAM_ENABLE_CHANNEL_37;
            }
            else if(38 == adv_Channel) {
                g_pattern_param.adv_param.Advertising_Channel_Map[0] = HCI_CMD_PARAM_ENABLE_CHANNEL_38;
            }
            else {
                g_pattern_param.adv_param.Advertising_Channel_Map[0] = HCI_CMD_PARAM_ENABLE_CHANNEL_39;
            }
            g_pattern_param.adv_param.Advertising_Filter_Policy[0] = HCI_CMD_PARAM_ALLOW_SCAN_REQ_FROM_ANY_AND_CONN_REQ_FROM_WHITELIST_ONLY;
            g_pattern_param.adv_param.Advertising_Interval_Max[0] =  HCI_CMD_PARAM_ADVERTISING_INTERVAL_MIN & 0x00ff;
            g_pattern_param.adv_param.Advertising_Interval_Max[1] = (HCI_CMD_PARAM_ADVERTISING_INTERVAL_MIN & 0xff00) >> 8;
            g_pattern_param.adv_param.Advertising_Interval_Min[0] =  HCI_CMD_PARAM_ADVERTISING_INTERVAL_MIN & 0x00ff;
            g_pattern_param.adv_param.Advertising_Interval_Min[1] = (HCI_CMD_PARAM_ADVERTISING_INTERVAL_MIN & 0xff00) >> 8;
            verdict = COMM_ADV_Undirected_Advertising(dut2_fd, g_pattern_param);
            VERDICT_RESULT_WITH_LINE();

        break;

        case 11:
            // Uptest   : addr_type = public 
            // Lwtest   : addr_type = random(error)
            // IUT      : undirected advertising, filter policy = 0x02
            // ***********************************************************************************
            // Uptest(white list) config
            COMM_INI_Connection_Setup_White_Listed_Config(dut2, &g_pattern_param);
            memcpy(g_pattern_param.white_list_param.Address, scan_addr, ADDR_LENGTH);
            g_pattern_param.white_list_param.Address_Type[0] = HCI_CMD_PARAM_PUBLIC_DEVICE_ADDRESS;
            verdict = COMM_INI_Connection_Setup_White_Listed(dut2_fd, g_pattern_param);
            VERDICT_RESULT_WITH_LINE();

            // Lwtest(white list) config
            COMM_INI_Connection_Setup_White_Listed_Config(dut1, &g_pattern_param);
            memcpy(g_pattern_param.white_list_param.Address, adv_addr, ADDR_LENGTH);
            verdict=COMM_INI_Connection_Setup_White_Listed(dut1_fd, g_pattern_param);
            VERDICT_RESULT_WITH_LINE();

            
            // ***********************************************************************************            
            // Lwtest(CON) config
            //COMM_Static_Random_Device_Address_Set_Config(scan_random_addr);
            //COMM_Device_Address_Set(dut1_fd, g_pattern_param);
            COMM_INI_Initiating_Config(dut1, &g_pattern_param);
            COMM_Static_Random_Device_Address_Set_Config(scan_addr);
            COMM_Device_Address_Set(dut1_fd, g_pattern_param);
            //memcpy(g_pattern_param.create_conn_param.Peer_Address, adv_addr, ADDR_LENGTH );
            g_pattern_param.create_conn_param.Own_Address_Type[0] = HCI_CMD_PARAM_RANDOM_DEVICE_ADDRESS;
            g_pattern_param.create_conn_param.Initiator_Filter_Policy[0] = HCI_CMD_PARAM_FILTER_POLICY_WHITE_LIST_USED;

            verdict = COMM_INI_Initiating(dut1_fd, g_pattern_param);            
            VERDICT_RESULT_WITH_LINE();
            
            // ***********************************************************************************            
            // IUT(ADV) config
            COMM_ADV_Undirected_Advertising_Config(HCI_CMD_PARAM_ADV_DATA_LEN_MAX, &g_pattern_param);
            memcpy(g_pattern_param.adv_param.Direct_Address, adv_addr, ADDR_LENGTH);
            if(37 == adv_Channel) {
                g_pattern_param.adv_param.Advertising_Channel_Map[0] = HCI_CMD_PARAM_ENABLE_CHANNEL_37;
            }
            else if(38 == adv_Channel) {
                g_pattern_param.adv_param.Advertising_Channel_Map[0] = HCI_CMD_PARAM_ENABLE_CHANNEL_38;
            }
            else {
                g_pattern_param.adv_param.Advertising_Channel_Map[0] = HCI_CMD_PARAM_ENABLE_CHANNEL_39;
            }
            g_pattern_param.adv_param.Advertising_Filter_Policy[0] = HCI_CMD_PARAM_ALLOW_SCAN_REQ_FROM_ANY_AND_CONN_REQ_FROM_WHITELIST_ONLY;
            g_pattern_param.adv_param.Advertising_Interval_Max[0] =  HCI_CMD_PARAM_ADVERTISING_INTERVAL_MIN & 0x00ff;
            g_pattern_param.adv_param.Advertising_Interval_Max[1] = (HCI_CMD_PARAM_ADVERTISING_INTERVAL_MIN & 0xff00) >> 8;
            g_pattern_param.adv_param.Advertising_Interval_Min[0] =  HCI_CMD_PARAM_ADVERTISING_INTERVAL_MIN & 0x00ff;
            g_pattern_param.adv_param.Advertising_Interval_Min[1] = (HCI_CMD_PARAM_ADVERTISING_INTERVAL_MIN & 0xff00) >> 8;
            verdict = COMM_ADV_Undirected_Advertising(dut2_fd, g_pattern_param);
            VERDICT_RESULT_WITH_LINE();
        break;

        case 12:            
            // Uptest   : addr_type = public 
            // Lwtest   : addr_type = public
            // IUT      : undirected advertising, filter policy = 0x02
            // ***********************************************************************************
            // Uptest(white list) config
            COMM_INI_Connection_Setup_White_Listed_Config(dut2, &g_pattern_param);
            memcpy(g_pattern_param.white_list_param.Address, scan_addr, ADDR_LENGTH);
            g_pattern_param.white_list_param.Address_Type[0] = HCI_CMD_PARAM_PUBLIC_DEVICE_ADDRESS;
            verdict = COMM_INI_Connection_Setup_White_Listed(dut2_fd, g_pattern_param);
            VERDICT_RESULT_WITH_LINE();

            // Lwtest(white list) config
            COMM_INI_Connection_Setup_White_Listed_Config(dut1, &g_pattern_param);
            memcpy(g_pattern_param.white_list_param.Address, adv_addr, ADDR_LENGTH);
            verdict=COMM_INI_Connection_Setup_White_Listed(dut1_fd, g_pattern_param);
            VERDICT_RESULT_WITH_LINE();
            
            // ***********************************************************************************            
            // Lwtest(CON) config
            COMM_INI_Initiating_Config(dut1, &g_pattern_param);
            memcpy(g_pattern_param.create_conn_param.Peer_Address, adv_addr, ADDR_LENGTH );
            g_pattern_param.create_conn_param.Own_Address_Type[0] = HCI_CMD_PARAM_PUBLIC_DEVICE_ADDRESS;
            g_pattern_param.create_conn_param.Initiator_Filter_Policy[0] = HCI_CMD_PARAM_FILTER_POLICY_WHITE_LIST_USED;

            verdict = COMM_INI_Initiating(dut1_fd, g_pattern_param);            
            VERDICT_RESULT_WITH_LINE();
            
            // ***********************************************************************************            
            // IUT(ADV) config
            COMM_ADV_Undirected_Advertising_Config(HCI_CMD_PARAM_ADV_DATA_LEN_MAX, &g_pattern_param);
            memcpy(g_pattern_param.adv_param.Direct_Address, adv_addr, ADDR_LENGTH);
            if(37 == adv_Channel) {
                g_pattern_param.adv_param.Advertising_Channel_Map[0] = HCI_CMD_PARAM_ENABLE_CHANNEL_37;
            }
            else if(38 == adv_Channel) {
                g_pattern_param.adv_param.Advertising_Channel_Map[0] = HCI_CMD_PARAM_ENABLE_CHANNEL_38;
            }
            else {
                g_pattern_param.adv_param.Advertising_Channel_Map[0] = HCI_CMD_PARAM_ENABLE_CHANNEL_39;
            }
            g_pattern_param.adv_param.Advertising_Filter_Policy[0] = HCI_CMD_PARAM_ALLOW_SCAN_REQ_FROM_ANY_AND_CONN_REQ_FROM_WHITELIST_ONLY;
            g_pattern_param.adv_param.Advertising_Interval_Max[0] =  HCI_CMD_PARAM_ADVERTISING_INTERVAL_MIN & 0x00ff;
            g_pattern_param.adv_param.Advertising_Interval_Max[1] = (HCI_CMD_PARAM_ADVERTISING_INTERVAL_MIN & 0xff00) >> 8;
            g_pattern_param.adv_param.Advertising_Interval_Min[0] =  HCI_CMD_PARAM_ADVERTISING_INTERVAL_MIN & 0x00ff;
            g_pattern_param.adv_param.Advertising_Interval_Min[1] = (HCI_CMD_PARAM_ADVERTISING_INTERVAL_MIN & 0xff00) >> 8;
            verdict = COMM_ADV_Undirected_Advertising(dut2_fd, g_pattern_param);
            VERDICT_RESULT_WITH_LINE();
        break;


    }

    //uptest_part++;
    event_query_timer_config(2 , 0 , 0 , 0, &timer);
    event_query_timer_start(timer ,read_le_event_enable );


    while(adv_cnt <= 12)//waiting adv report event , timer or counter
    {
        if ( 1== read_le_event_get() )
        {
            //reset event flag
            read_le_event_disable();               

            if ( 1 == (adv_cnt % 3) ){
                //because the TI SCN can't set public type and change the Addr at the same time,
                //so we don't verify the behavior at case 1 & 7 
                if ((1 != adv_cnt) && (7 != adv_cnt)) {
                    //dut_reset_with_mask_en(dut1_fd);					
                    COMM_SCN_Disable_Config(dut1, &g_pattern_param);
                    COMM_SCN_Disable(dut1_fd, g_pattern_param);

                    MSLEEP(500);

                    // # for check ADV_IND after Master send CONN_REQ
                    COMM_SCN_Active_Scanning_Config(dut1, &g_pattern_param);
                    g_pattern_param.scn_param.Own_Address_Type[0] = HCI_CMD_PARAM_PUBLIC_DEVICE_ADDRESS;             
                    g_pattern_param.scn_param.LE_Scan_Interval[0] = 0x0500 & 0x00ff;
                    g_pattern_param.scn_param.LE_Scan_Interval[1] =(0x0500 & 0xff00) >> 8;
                    g_pattern_param.scn_param.LE_Scan_Window[0] =   0x0500 & 0x00ff;
                    g_pattern_param.scn_param.LE_Scan_Window[1] =  (0x0500 & 0xff00) >> 8;
                    verdict = COMM_SCN_Active_Scanning(dut1_fd, g_pattern_param);            
                    VERDICT_RESULT_WITH_LINE();
                    
                    while (check_cnt < 30) {
                        if (SUCCESS != QUERY_LE_Event(dut1_fd, buf, _BT_HCI_LE_EVENT_SUB_OP_ADVERTISING_REPORT_, HCI_SUBEVENT_ADV_RPT_EVENT_ADV_IND)) {
                            //query ADV report
                            printf("###run case : %d   ADV_Channel = %d ###\n", adv_cnt, adv_Channel);
                            printf("****SUCCESS != QUERY_LE_Event****\n");                        
                            continue;
    			        }				    
                       else if (EQUAL != hci_le_event_advertising_report_parsing(HCI_SUBEVENT_ADV_RPT_EVENT_ADV_IND, buf, g_pattern_param)) {
                            // Expect the IUT to continue advertising                        
                            printf("****EQUAL != HCI : %d****\n", err_cnt);
                            printf("###run case : %d   ADV_Channel = %d ###\n", adv_cnt, adv_Channel);
                            err_cnt++;
                            if (200 <= err_cnt) {
                                line=__LINE__;
    				            goto FUN_FAIL;
                            }    				        
                       }                        
                       else {                        
                            err_cnt = 0;
                            check_cnt ++ ;
                            printf("###run case : %d   ADV_Channel = %d ###\n", adv_cnt, adv_Channel);
                            printf("** Low Test expects the IUT to continue advertising : %d / 30 times **\n" , check_cnt);
                        }
                       MSLEEP(100);
                    }
                }                               
            }
            else if ( 2 == (adv_cnt % 3)) {                
                //dut_reset_with_mask_en(dut1_fd);
                COMM_SCN_Disable_Config(dut1, &g_pattern_param);
                COMM_SCN_Disable(dut1_fd, g_pattern_param);

                MSLEEP(500);

                // # for check ADV_IND after Master send CONN_REQ                
                COMM_SCN_Active_Scanning_Config(dut1, &g_pattern_param);
                g_pattern_param.scn_param.Own_Address_Type[0] = HCI_CMD_PARAM_PUBLIC_DEVICE_ADDRESS;             
                g_pattern_param.scn_param.LE_Scan_Interval[0] = 0x0500 & 0x00ff;
                g_pattern_param.scn_param.LE_Scan_Interval[1] =(0x0500 & 0xff00) >> 8;
                g_pattern_param.scn_param.LE_Scan_Window[0] =   0x0500 & 0x00ff;
                g_pattern_param.scn_param.LE_Scan_Window[1] =  (0x0500 & 0xff00) >> 8;
                verdict = COMM_SCN_Active_Scanning(dut1_fd, g_pattern_param);            
                VERDICT_RESULT_WITH_LINE();
                while (check_cnt < 30) {
                    if (SUCCESS != QUERY_LE_Event(dut1_fd, buf, _BT_HCI_LE_EVENT_SUB_OP_ADVERTISING_REPORT_, HCI_SUBEVENT_ADV_RPT_EVENT_ADV_IND)) {
                        //query ADV report
                        printf("****SUCCESS != QUERY_LE_Event****\n");
                        printf("###run case : %d   ADV_Channel = %d ###\n", adv_cnt, adv_Channel);
				        continue;
			        }				    
                   else if (EQUAL != hci_le_event_advertising_report_parsing(HCI_SUBEVENT_ADV_RPT_EVENT_ADV_IND, buf, g_pattern_param)) {
                        // Expect the IUT to continue advertising                            
                        printf("****EQUAL != HCI : %d****\n", err_cnt);
                        printf("###run case : %d   ADV_Channel = %d ###\n", adv_cnt, adv_Channel);
                        err_cnt++;
                        if (200 <= err_cnt) {
                            line=__LINE__;
				            goto FUN_FAIL;
                        }				        
                   }                        
                   else {
                        check_cnt ++ ;
                        err_cnt = 0;
                        printf("###run case : %d   ADV_Channel = %d ###\n", adv_cnt, adv_Channel);
                        printf("** Low Test expects the IUT to continue advertising : %d / 30 times **\n" , check_cnt);
                    }
                   MSLEEP(100);
                }
            }
            else {
                // Upper Tester expects an HCI_LE_Connection_Complete event from the IUT including the parameters sent to the IUT
		        if (SUCCESS != QUERY_LE_Event(dut1_fd, buf, _BT_HCI_LE_EVENT_SUB_OP_CONNECTION_COMPLETE_, 0)) {
				    line = __LINE__;
				    goto FUN_FAIL;
			    }
			    else if(SUCCESS != hci_le_event_connection_complete_parsing(0, buf, g_pattern_param)) {
				    line = __LINE__;
				    goto FUN_FAIL;
			    }

                if (SUCCESS != QUERY_LE_Event(dut2_fd, buf, _BT_HCI_LE_EVENT_SUB_OP_CONNECTION_COMPLETE_, 0)) {
				    line = __LINE__;
				    goto FUN_FAIL;
			    }
			    else if(SUCCESS != hci_le_event_connection_complete_parsing(0, buf, g_pattern_param)) {
				    line = __LINE__;
				    goto FUN_FAIL;
			    }
                
		        //dut_reset_with_mask_en(dut1_fd);				
                COMM_SCN_Disable_Config(dut1, &g_pattern_param);
                COMM_SCN_Disable(dut1_fd, g_pattern_param);

                MSLEEP(500);

                // # for check ADV_IND after Master send CONN_REQ                
                COMM_SCN_Active_Scanning_Config(dut1, &g_pattern_param);
                g_pattern_param.scn_param.Own_Address_Type[0] = HCI_CMD_PARAM_PUBLIC_DEVICE_ADDRESS;             
                g_pattern_param.scn_param.LE_Scan_Interval[0] = 0x0500 & 0x00ff;
                g_pattern_param.scn_param.LE_Scan_Interval[1] =(0x0500 & 0xff00) >> 8;
                g_pattern_param.scn_param.LE_Scan_Window[0] =   0x0500 & 0x00ff;
                g_pattern_param.scn_param.LE_Scan_Window[1] =  (0x0500 & 0xff00) >> 8;
                verdict = COMM_SCN_Active_Scanning(dut1_fd, g_pattern_param);            
                VERDICT_RESULT_WITH_LINE();                

                while (check_cnt < 30) {
                   if (SUCCESS != QUERY_LE_Event(dut1_fd, buf, _BT_HCI_LE_EVENT_SUB_OP_ADVERTISING_REPORT_, HCI_SUBEVENT_ADV_RPT_EVENT_ADV_IND)) {
                        //query ADV report
                        printf("****SUCCESS != QUERY_LE_Event****\n");
				        continue;
			       }				    
                   else if (EQUAL == hci_le_event_advertising_report_parsing(HCI_SUBEVENT_ADV_RPT_EVENT_ADV_IND, buf, g_pattern_param)) {
                        // Expect the IUT to continue advertising                        
                        printf("****EQUAL != HCI : %d****\n", err_cnt);
                        printf("###run case : %d   ADV_Channel = %d ###\n", adv_cnt, adv_Channel);
                        err_cnt++;
                        if (50 <= err_cnt) {
                            line=__LINE__;
				            goto FUN_FAIL;
                        }                        
                   }                        
                   else {
                        check_cnt ++ ;
                        err_cnt = 0;
                        printf("###run case : %d   ADV_Channel = %d ###\n", adv_cnt, adv_Channel);
                        printf("** Lower Tester expects the IUT to stop advertising : %d / 30 times **\n" , check_cnt);
                    }
                   MSLEEP(100);
                }                          
            }
            //event add
            if (37 == adv_Channel) {
                adv_Channel++;
            }
            else if(38 == adv_Channel) {
                adv_Channel++;
            }
            else {
                adv_Channel = 37;
                adv_cnt++;
            }
            //##################################################
            dut_reset_with_mask_en(dut1_fd);
			dut_reset_with_mask_en(dut2_fd);
            MSLEEP(500);
            goto REPEAT;
        }
    }

    FUNC_END();

    LOG_INFO("[Pattern][%s]SUCCESS\n" ,__FUNCTION__);
    return PASS;

FUN_FAIL:
    FUNC_END();

	LOG_INFO("[Pattern][%s]:%d FAIL %d\n" ,__FUNCTION__, line , adv_cnt);
	return FAIL;
}

// 5.2.1.10
verdict DDI_ADV_Directed_Advertising_Events(u8 dut1_fd ,u8 dut2_fd)
{
	u8 buf[SOCKET_BUF_SIZE];
	int verdict = FAIL;
	int dut1 = 0;
    int dut2 = 0;
	u16 line = 0;		
	int try_num = 0;
    int err_cnt = 0;
	int adv_TimeCnt = 0;
    int adv_Channel = 37;
	struct itimerval timer;

    COMM_Dut_clean_buffer(dut1_fd);
    COMM_Dut_clean_buffer(dut2_fd);

    Calculate_Execution_Time_Start();    

    // Uptest(white list) config
	COMM_INI_Connection_Setup_White_Listed_Config(dut1, &g_pattern_param);
	memcpy(g_pattern_param.white_list_param.Address, adv_addr, ADDR_LENGTH);	
	verdict = COMM_INI_Connection_Setup_White_Listed(dut1_fd, g_pattern_param);
	VERDICT_RESULT_WITH_LINE();

    COMM_INI_Connection_Setup_White_Listed_Config(dut2, &g_pattern_param);
	memcpy(g_pattern_param.white_list_param.Address, scan_addr, ADDR_LENGTH);	
	verdict = COMM_INI_Connection_Setup_White_Listed(dut2_fd, g_pattern_param);
	VERDICT_RESULT_WITH_LINE();
            
	COMM_SCN_Passive_Scanning_Config(dut1, &g_pattern_param);
	g_pattern_param.scn_param.Own_Address_Type[0] = HCI_CMD_PARAM_PUBLIC_DEVICE_ADDRESS;     
	g_pattern_param.scn_param.Scanning_Filter_Policy[0] = HCI_CMD_PARAM_IGNORE_ADV_PKTS_FROM_DEV_NOT_IN_WHITE_LIST_ONLY;
	//the interval of Man/Min must use 0x0500 instead of HCI_CMD_PARAM_SCAN_INT_MAX 
	g_pattern_param.scn_param.LE_Scan_Interval[0] =  0x01E0 & 0x00ff;
	g_pattern_param.scn_param.LE_Scan_Interval[1] = (0x01E0 & 0xff00) >> 8;
	g_pattern_param.scn_param.LE_Scan_Window[0] =    0x01E0 & 0x00ff;
	g_pattern_param.scn_param.LE_Scan_Window[1] =   (0x01E0 & 0xff00) >> 8;    
	verdict = COMM_SCN_Passive_Scanning(dut1_fd, g_pattern_param);
	VERDICT_RESULT_WITH_LINE();
    
Case1:  
    COMM_ADV_Directed_Advertising_Config(HCI_CMD_PARAM_ADV_DATA_LEN_MAX, &g_pattern_param);
   	g_pattern_param.adv_param.Advertising_Filter_Policy[0] = HCI_CMD_PARAM_ALLOW_SCAN_REQ_FROM_WHITELIST_ONLY_AND_CONN_REQ_FROM_WHITELIST_ONLY;
	if(adv_Channel == 37){
		g_pattern_param.adv_param.Advertising_Channel_Map[0] = HCI_CMD_PARAM_ENABLE_CHANNEL_37;
	}
	else if(adv_Channel == 38){
		g_pattern_param.adv_param.Advertising_Channel_Map[0] = HCI_CMD_PARAM_ENABLE_CHANNEL_38;
	}
	else if(adv_Channel == 39){
		g_pattern_param.adv_param.Advertising_Channel_Map[0] = HCI_CMD_PARAM_ENABLE_CHANNEL_39;
	}
	//the interval of Man/Min must use 0x00a0 instead of HCI_CMD_PARAM_ADVERTISING_INTERVAL_MIN 
	g_pattern_param.adv_param.Advertising_Interval_Max[0] =  0x00a0 & 0x00ff;
	g_pattern_param.adv_param.Advertising_Interval_Max[1] = (0x00a0 & 0xff00) >> 8;
	g_pattern_param.adv_param.Advertising_Interval_Min[0] =  0x00a0 & 0x00ff;
	g_pattern_param.adv_param.Advertising_Interval_Min[1] = (0x00a0 & 0xff00) >> 8;
	verdict = COMM_ADV_Directed_Advertising(dut2_fd, g_pattern_param);
	VERDICT_RESULT_WITH_LINE();		


    while (try_num < 300) {
        // # restart the ADV_DIRECT
		if(adv_TimeCnt > 100) {
			adv_TimeCnt = 0;
            COMM_ADV_Directed_Advertising(dut2_fd, g_pattern_param);
		}        
        
        if (SUCCESS != QUERY_LE_Event(dut1_fd, buf, _BT_HCI_LE_EVENT_SUB_OP_ADVERTISING_REPORT_, HCI_SUBEVENT_ADV_RPT_EVENT_DIRECT_IND)) {
            //query ADV report
            printf("****SUCCESS != QUERY_LE_Event****\n");
	        continue;
	    }				    
        else if (EQUAL != hci_le_event_advertising_report_parsing(HCI_SUBEVENT_ADV_RPT_EVENT_DIRECT_IND, buf, g_pattern_param)) {
             
             printf("****EQUAL != HCI_err : %d, right_Cnt = %d ****\n", err_cnt, try_num);             
             err_cnt++;
             if (err_cnt > 900) {
                line=__LINE__;
	            goto FUN_FAIL;
             }                 
        }                        
        else {
             try_num ++ ;
             err_cnt = 0;
             printf("** Upper Tester expects an HCI_LE_Advertising_Report event from the IUT : %d / 300 times **\n" , try_num);
        }
        
		adv_TimeCnt++;
        MSLEEP(1);
    }
   
    sleep(5);
    
	if (SUCCESS != QUERY_LE_Event(dut2_fd, buf, _BT_HCI_LE_EVENT_SUB_OP_CONNECTION_COMPLETE_, 0)) {
		line = __LINE__;
		goto FUN_FAIL;
	}

	if(_BT_HCI_EVT_CMD_COMP_STATUS_DIRECTED_ADVERTISING_TIMEOUT != hci_le_event_connection_complete_parsing(0, buf, g_pattern_param)) {
		line = __LINE__;
		goto FUN_FAIL;
	}
    else{

        if ( 0 != memcmp (g_pattern_param.adv_param.Direct_Address , 
             buf + _BT_HCI_EVT_CON_COMP_PEER_ADDR0 ,
             ADDR_LENGTH)){

            line = __LINE__;
            goto FUN_FAIL;

        }
    }
    

    if(adv_Channel != 39){        
        adv_Channel ++;		
        try_num = 0;
        err_cnt = 0;
        goto Case1;
    }
    else {
        adv_Channel= 37;
        try_num = 0;
        err_cnt = 0;
    }

    dut_reset_with_mask_en(dut1_fd);
    dut_reset_with_mask_en(dut2_fd);

    MSLEEP(500);

Case2:

	COMM_INI_Connection_Setup_White_Listed_Config(dut1, &g_pattern_param);
	memcpy(g_pattern_param.white_list_param.Address, adv_addr, ADDR_LENGTH);	
	verdict = COMM_INI_Connection_Setup_White_Listed(dut1_fd, g_pattern_param);
	VERDICT_RESULT_WITH_LINE();

    COMM_INI_Connection_Setup_White_Listed_Config(dut2, &g_pattern_param);
	memcpy(g_pattern_param.white_list_param.Address, scan_addr, ADDR_LENGTH);	
	verdict = COMM_INI_Connection_Setup_White_Listed(dut2_fd, g_pattern_param);
	VERDICT_RESULT_WITH_LINE();

	COMM_SCN_Passive_Scanning_Config(dut1, &g_pattern_param);
	g_pattern_param.scn_param.Own_Address_Type[0] = HCI_CMD_PARAM_PUBLIC_DEVICE_ADDRESS;     
	g_pattern_param.scn_param.Scanning_Filter_Policy[0] = HCI_CMD_PARAM_IGNORE_ADV_PKTS_FROM_DEV_NOT_IN_WHITE_LIST_ONLY;
	//the interval of Man/Min must use 0x0500 instead of HCI_CMD_PARAM_SCAN_INT_MAX 
	g_pattern_param.scn_param.LE_Scan_Interval[0] =  0x01E0 & 0x00ff;
	g_pattern_param.scn_param.LE_Scan_Interval[1] = (0x01E0 & 0xff00) >> 8;
	g_pattern_param.scn_param.LE_Scan_Window[0] =    0x01E0 & 0x00ff;
	g_pattern_param.scn_param.LE_Scan_Window[1] =   (0x01E0 & 0xff00) >> 8;    
	verdict = COMM_SCN_Passive_Scanning(dut1_fd, g_pattern_param);
	VERDICT_RESULT_WITH_LINE();
    
    COMM_ADV_Directed_Advertising_Config(HCI_CMD_PARAM_ADV_DATA_LEN_MAX,&g_pattern_param);
    g_pattern_param.adv_param.Advertising_Filter_Policy[0] = HCI_CMD_PARAM_ALLOW_SCAN_REQ_FROM_WHITELIST_ONLY_AND_CONN_REQ_FROM_WHITELIST_ONLY;
    g_pattern_param.adv_param.Advertising_Interval_Max[0] = 0x00a0 & 0x00ff;
    g_pattern_param.adv_param.Advertising_Interval_Max[1] = (0x00a0 & 0xff00) >> 8;
    g_pattern_param.adv_param.Advertising_Interval_Min[0] = 0x00a0 & 0x00ff;
    g_pattern_param.adv_param.Advertising_Interval_Min[1] = (0x00a0 & 0xff00) >> 8; 
    if(37 == adv_Channel) {
        g_pattern_param.adv_param.Advertising_Channel_Map[0] = HCI_CMD_PARAM_ENABLE_CHANNEL_37;
    }
    else if(38 == adv_Channel) {
        g_pattern_param.adv_param.Advertising_Channel_Map[0] = HCI_CMD_PARAM_ENABLE_CHANNEL_38;
    }
    else {
        g_pattern_param.adv_param.Advertising_Channel_Map[0] = HCI_CMD_PARAM_ENABLE_CHANNEL_39;
    }
    verdict = COMM_ADV_Directed_Advertising(dut2_fd,g_pattern_param);    
    VERDICT_RESULT_WITH_LINE();

    COMM_INI_Initiating_Config(dut1,&g_pattern_param);
    memcpy(g_pattern_param.create_conn_param.Peer_Address, adv_addr, ADDR_LENGTH );
    verdict=COMM_INI_Initiating(dut1_fd,g_pattern_param);
    VERDICT_RESULT_WITH_LINE();

	event_query_timer_config(3, 0, 0, 0, &timer);
	event_query_timer_start(timer, read_le_event_enable);

 
    while(1)//waiting adv report event , timer or counter
	{
		if(1 == read_le_event_get())
		{
            read_le_event_disable();
            
			if(SUCCESS != QUERY_LE_Event(dut1_fd, buf, _BT_HCI_LE_EVENT_SUB_OP_CONNECTION_COMPLETE_, 0)) {
				line = __LINE__;
				goto FUN_FAIL;
			}
			else if(SUCCESS != hci_le_event_connection_complete_parsing(0, buf, g_pattern_param)) {
				line = __LINE__;
				goto FUN_FAIL;
			}

			if(SUCCESS != QUERY_LE_Event(dut1_fd, buf,	_BT_HCI_LE_EVENT_SUB_OP_ADVERTISING_REPORT_, 0)) {
				line = __LINE__;
				goto FUN_FAIL;
			}
			else if(EQUAL == hci_le_event_advertising_report_parsing(0, buf, g_pattern_param)) {
				line = __LINE__;
				goto FUN_FAIL;
			}			

            if(adv_Channel != 39){        
                adv_Channel ++;             

                dut_reset_with_mask_en(dut1_fd);
                dut_reset_with_mask_en(dut2_fd);

                MSLEEP(500);
                goto Case2;
            }else{
                break;
            }
		}
	}

    FUNC_END();

    LOG_INFO("[Pattern][%s]SUCCESS\n", __FUNCTION__);
    return PASS;
    
FUN_FAIL:
    FUNC_END();

    LOG_INFO("[Pattern][%s]:%d FAIL, ADV_Channel = %d\n" ,__FUNCTION__, line, adv_Channel);	
	return FAIL;

}

// 5.2.1.11
verdict DDI_ADV_Discoverable_Advertising_Events(u8 dut1_fd ,u8 dut2_fd)
{
	u8 buf[SOCKET_BUF_SIZE];
	int verdict=FAIL;
	int dut1=0;
	int ret;
	int line=0;
	int ch_num=0;
	u32 adv_cnt=0;
    u16 adv_chk_err = 0;
	struct itimerval timer;

    COMM_Dut_clean_buffer(dut1_fd);
    COMM_Dut_clean_buffer(dut2_fd);
    
    Calculate_Execution_Time_Start();

REPEAT:

	COMM_INI_Connection_Setup_White_Listed_Config(dut1, &g_pattern_param);
	memcpy(g_pattern_param.white_list_param.Address, adv_addr, ADDR_LENGTH);
	verdict=COMM_INI_Connection_Setup_White_Listed(dut1_fd, g_pattern_param);
	VERDICT_RESULT_WITH_LINE();

	//p1: set dut1 for scan
	COMM_SCN_Passive_Scanning_Config(dut1,&g_pattern_param);
	g_pattern_param.scn_param.LE_Scan_Interval[0] =  0x01E0 & 0x00ff;
	g_pattern_param.scn_param.LE_Scan_Interval[1] = (0x01E0 & 0xff00) >> 8;
	g_pattern_param.scn_param.LE_Scan_Window[0] =	 0x01E0 & 0x00ff;
	g_pattern_param.scn_param.LE_Scan_Window[1] =   (0x01E0 & 0xff00) >> 8;
	g_pattern_param.scn_param.Scanning_Filter_Policy[0] = HCI_CMD_PARAM_IGNORE_ADV_PKTS_FROM_DEV_NOT_IN_WHITE_LIST_ONLY;
	verdict=COMM_SCN_Passive_Scanning(dut1_fd,g_pattern_param);
	VERDICT_RESULT_WITH_LINE();

	//p2: set dut2 for adv
	COMM_ADV_Discoverable_Advertising_Config(HCI_CMD_PARAM_ADV_DATA_LEN_MAX,&g_pattern_param);
	g_pattern_param.adv_param.Advertising_Filter_Policy[0] = 0x03;
	g_pattern_param.adv_param.Advertising_Interval_Max[0] =  HCI_CMD_PARAM_ADVERTISING_INTERVAL_MIN & 0x00ff;
	g_pattern_param.adv_param.Advertising_Interval_Max[1] = (HCI_CMD_PARAM_ADVERTISING_INTERVAL_MIN & 0xff00) >> 8;
	g_pattern_param.adv_param.Advertising_Interval_Min[0] =  HCI_CMD_PARAM_ADVERTISING_INTERVAL_MIN & 0x00ff;
	g_pattern_param.adv_param.Advertising_Interval_Min[1] = (HCI_CMD_PARAM_ADVERTISING_INTERVAL_MIN & 0xff00) >> 8;

	if(ch_num == 0){
		g_pattern_param.adv_param.Advertising_Channel_Map[0] =HCI_CMD_PARAM_ENABLE_CHANNEL_37;
	}
	else if(ch_num == 1){
		g_pattern_param.adv_param.Advertising_Channel_Map[0] =HCI_CMD_PARAM_ENABLE_CHANNEL_38;
	}
	else if(ch_num == 2){
		g_pattern_param.adv_param.Advertising_Channel_Map[0] =HCI_CMD_PARAM_ENABLE_CHANNEL_39;
	}
	//g_pattern_param.adv_param.Advertising_Channel_Map[0] =HCI_CMD_PARAM_ENABLE_CHANNEL_37;
	verdict=COMM_ADV_Discoverable_Advertising(dut2_fd,g_pattern_param);
	VERDICT_RESULT_WITH_LINE();


	// # timer for 2 sec
	event_query_timer_config(0 , 100 , 0 , 0, &timer);
	event_query_timer_start(timer ,read_le_event_enable );
	//read_le_event_enable();
	

	while(1)//waiting adv report event , timer or counter
	{
		if ( 1 == read_le_event_get() )
		{

			//read_le_event_disable();

			//p3, p4, p5
			if (SUCCESS != QUERY_LE_Event(dut1_fd,buf ,
										_BT_HCI_LE_EVENT_SUB_OP_ADVERTISING_REPORT_,
										HCI_CMD_PARAM_ADV_SCAN_IND))
			{
				line=__LINE__;
				goto FUN_FAIL;
			}

			ret=hci_le_event_advertising_report_parsing(HCI_CMD_PARAM_ADV_SCAN_IND,buf,g_pattern_param);
			
			if (EQUAL == ret)
			{
				adv_cnt++;
                adv_chk_err = 0;
				//p6: until a number advertising intervals (100) have been detected.
				if (100 == adv_cnt) //after 100 scan_interval stop?
				{
                    printf("receive 100 adv , change channel\n");
                    
                    dut_reset_with_mask_en(dut1_fd);
                    dut_reset_with_mask_en(dut2_fd);

    				adv_cnt=0;
    				read_le_event_disable();

					ch_num ++;
					if(ch_num <3){
						goto REPEAT;
					}
					else{
						break;
					}

				}
			}
            else{
                printf("no adv coming, chk %d\n" , adv_chk_err);

                adv_chk_err ++ ;
                if(adv_chk_err == 100){
                    line = __LINE__;
                    goto FUN_FAIL;
                }
            }
            MSLEEP(20);
            
		}
	}

    FUNC_END();

	LOG_INFO("[Pattern][%s]SUCCESS\n" ,__FUNCTION__);
	return PASS;

FUN_FAIL:
    FUNC_END();

	LOG_INFO("[Pattern][%s]:%d FAIL\n" ,__FUNCTION__,line);
    return FAIL;

}

// 5.2.1.12
verdict DDI_ADV_Advertising_Data_Discoverable(u8 dut1_fd ,u8 dut2_fd)
{
	u8 buf[SOCKET_BUF_SIZE];
	u16 line;
	int verdict = FAIL;
	int dut1 = 0;
    int dut2 = 0;	
	int repeat = 0;
	int i = 0;
	int data1_cnt, data2_cnt, data3_cnt, data4_cnt;
	struct itimerval timer;	
	u16 adv_cnt1 = 0;
	u16 adv_cnt2 = 0;
    u16 time_reduce = 3;
    u16 test_time = 30;

    COMM_Dut_clean_buffer(dut1_fd);
    COMM_Dut_clean_buffer(dut2_fd);

    Calculate_Execution_Time_Start();
	COMM_INI_Connection_Setup_White_Listed_Config(dut1, &g_pattern_param);
	memcpy(g_pattern_param.white_list_param.Address, adv_addr, ADDR_LENGTH);
	verdict = COMM_INI_Connection_Setup_White_Listed(dut1_fd, g_pattern_param);
	VERDICT_RESULT_WITH_LINE();    

REPEAT:
	adv_cnt1 = 0;
	adv_cnt2 = 0;
	repeat++;

    COMM_SCN_Passive_Scanning_Config(dut1, &g_pattern_param);
	g_pattern_param.scn_param.LE_Scan_Interval[0] =  0x1E0 & 0x00ff;
	g_pattern_param.scn_param.LE_Scan_Interval[1] = (0x1E0 & 0xff00) >> 8;
	g_pattern_param.scn_param.LE_Scan_Window[0] =	 0x1E0 & 0x00ff;
	g_pattern_param.scn_param.LE_Scan_Window[1] =   (0x1E0 & 0xff00) >> 8;
	g_pattern_param.scn_param.Scanning_Filter_Policy[0] = HCI_CMD_PARAM_IGNORE_ADV_PKTS_FROM_DEV_NOT_IN_WHITE_LIST_ONLY;
	verdict = COMM_SCN_Passive_Scanning(dut1_fd, g_pattern_param);
	VERDICT_RESULT_WITH_LINE();

    //The timing range detected for advertising events(ADV_IND) is from 20.0 ms to 30.0 ms
	//interval : 32(0x0020) * 0.625ms = 20ms
	if (1 == repeat) {
		COMM_ADV_Discoverable_Advertising_Config(HCI_CMD_PARAM_ADV_DATA_LEN_MAX, &g_pattern_param);
		g_pattern_param.adv_param.Advertising_Interval_Max[0] =  0x00a0 & 0x00ff;
		g_pattern_param.adv_param.Advertising_Interval_Max[1] = (0x00a0 & 0xff00) >> 8;
		g_pattern_param.adv_param.Advertising_Interval_Min[0] =  0x00a0 & 0x00ff;
		g_pattern_param.adv_param.Advertising_Interval_Min[1] = (0x00a0 & 0xff00) >> 8;
		g_pattern_param.adv_data_param.Advertising_Data_Length[0] = 0x01;
		g_pattern_param.adv_data_param.Advertising_Data[0] = 0x01;
		verdict = COMM_ADV_Discoverable_Advertising(dut2_fd, g_pattern_param);
		VERDICT_RESULT_WITH_LINE();
	}
	else if(2 == repeat) {
		COMM_ADV_Discoverable_Advertising_Config(HCI_CMD_PARAM_ADV_DATA_LEN_MAX, &g_pattern_param);
		g_pattern_param.adv_param.Advertising_Interval_Max[0] =  0x00a0 & 0x00ff;
		g_pattern_param.adv_param.Advertising_Interval_Max[1] = (0x00a0 & 0xff00) >> 8;
		g_pattern_param.adv_param.Advertising_Interval_Min[0] =  0x00a0 & 0x00ff;
		g_pattern_param.adv_param.Advertising_Interval_Min[1] = (0x00a0 & 0xff00) >> 8;
		g_pattern_param.adv_data_param.Advertising_Data_Length[0] = 0x1f;
		for(i = 1; i < 31; i++) {
			g_pattern_param.adv_data_param.Advertising_Data[i] = 0x00;
		}
		g_pattern_param.adv_data_param.Advertising_Data[0] = 0x01f;
		verdict = COMM_ADV_Discoverable_Advertising(dut2_fd, g_pattern_param);
		VERDICT_RESULT_WITH_LINE();
	}
	else {
		printf("[Pattern][%s]FAIL : ERROR Repeat\n", __FUNCTION__);
		line = __LINE__;
		goto FUN_FAIL;
	}

	//waiting adv report event , timer or counter
	while(1) {
		read_le_event_enable();
		event_query_timer_config(test_time/time_reduce, 0, 0, 0, &timer);
		event_query_timer_start(timer, read_le_event_disable);

		while (read_le_event_get()){							

            MSLEEP(50);

			if (SUCCESS != QUERY_LE_Event(dut1_fd, buf, _BT_HCI_LE_EVENT_SUB_OP_ADVERTISING_REPORT_, HCI_SUBEVENT_ADV_RPT_EVENT_SCAN_IND)) {
				continue;								
			}			 
			else if(EQUAL != hci_le_event_advertising_report_parsing(HCI_CMD_PARAM_ADV_SCAN_IND, buf, g_pattern_param)) {
				continue;
			}
			else {
				adv_cnt1++ ;
				printf("** Data_1 : check advertising intervals : %d time **\n", adv_cnt1);
			}
	    }
        
        COMM_SCN_Disable_Config(dut1, &g_pattern_param);
		verdict = COMM_SCN_Disable(dut1_fd, g_pattern_param);
        VERDICT_RESULT_WITH_LINE();
        
		COMM_ADV_Disable_Config(dut2, &g_pattern_param);
		verdict = COMM_ADV_Disable(dut2_fd, g_pattern_param);
		//VERDICT_RESULT_WITH_LINE();
        
		if(1 == repeat) {
			data1_cnt = adv_cnt1;
		}
		else {
			data3_cnt = adv_cnt1;
		}
        
		break;
	}
	
//second round
    COMM_SCN_Passive_Scanning_Config(dut1, &g_pattern_param);
	g_pattern_param.scn_param.LE_Scan_Interval[0] =  0x1E0 & 0x00ff;
	g_pattern_param.scn_param.LE_Scan_Interval[1] = (0x1E0 & 0xff00) >> 8;
	g_pattern_param.scn_param.LE_Scan_Window[0] =	 0x1E0 & 0x00ff;
	g_pattern_param.scn_param.LE_Scan_Window[1] =   (0x1E0 & 0xff00) >> 8;
	g_pattern_param.scn_param.Scanning_Filter_Policy[0] = HCI_CMD_PARAM_IGNORE_ADV_PKTS_FROM_DEV_NOT_IN_WHITE_LIST_ONLY;
	verdict = COMM_SCN_Passive_Scanning(dut1_fd, g_pattern_param);
	VERDICT_RESULT_WITH_LINE();

	COMM_ADV_Discoverable_Advertising_Config(0, &g_pattern_param);
	g_pattern_param.adv_param.Advertising_Interval_Max[0] =  0x00a0 & 0x00ff;
	g_pattern_param.adv_param.Advertising_Interval_Max[1] = (0x00a0 & 0xff00) >> 8;
	g_pattern_param.adv_param.Advertising_Interval_Min[0] =  0x00a0 & 0x00ff;
	g_pattern_param.adv_param.Advertising_Interval_Min[1] = (0x00a0 & 0xff00) >> 8;
	g_pattern_param.adv_data_param.Advertising_Data_Length[0] = 0x00;	 
	g_pattern_param.adv_data_param.Advertising_Data[0] = 0x00;
	verdict = COMM_ADV_Discoverable_Advertising(dut2_fd, g_pattern_param);
	VERDICT_RESULT_WITH_LINE();

    //waiting adv report event , timer or counter
	while(1) {
		read_le_event_enable();
		event_query_timer_config(test_time/time_reduce, 0, 0, 0, &timer);
		event_query_timer_start(timer, read_le_event_disable);

		while(read_le_event_get()){

            MSLEEP(50);

			if(SUCCESS != QUERY_LE_Event(dut1_fd, buf, _BT_HCI_LE_EVENT_SUB_OP_ADVERTISING_REPORT_, HCI_SUBEVENT_ADV_RPT_EVENT_SCAN_IND)) {
				continue;				 
			}
			else if(EQUAL != hci_le_event_advertising_report_parsing(HCI_CMD_PARAM_ADV_SCAN_IND, buf, g_pattern_param)) {
				continue;
			}
			else {
				adv_cnt2++ ;
				printf("** Data_2 : check advertising intervals : %d time **\n", adv_cnt2);					
			}			  
	    }
        
        COMM_SCN_Disable_Config(dut1, &g_pattern_param);
		verdict = COMM_SCN_Disable(dut1_fd, g_pattern_param);
        //VERDICT_RESULT_WITH_LINE();
        
		COMM_ADV_Disable_Config(dut2, &g_pattern_param);
		verdict = COMM_ADV_Disable(dut2_fd, g_pattern_param);
		//VERDICT_RESULT_WITH_LINE();
        sleep(1);
		if(1 == repeat) {
			data2_cnt = adv_cnt2;
		}
		else {
			data4_cnt = adv_cnt2;
		}
		break;	 
	}
	
	if(repeat != 2) {
		printf("[Pattern][%s]REPEAT\n", __FUNCTION__);
		goto REPEAT;
	}
	else {		
        if ((((float)((data1_cnt * 100) / (272/time_reduce))) <= 50) || (((float)((data2_cnt * 100) / (272/time_reduce))) <= 50) ||
             (((float)((data3_cnt * 100) / (272/time_reduce))) <= 50) || (((float)((data4_cnt * 100) / (272/time_reduce))) <= 50)) {
            LOG_INFO("[Pattern][%s]FAIL\n", __FUNCTION__);
    		LOG_INFO("Ideal Value : %d\n", 272/time_reduce);
    		LOG_INFO("Data1(0x01) : %d, Ratio : %.2f %%\n", data1_cnt, (float)((data1_cnt * 100) / (272/time_reduce)));
            LOG_INFO("Data1(0x00) : %d, Ratio : %.2f %%\n", data2_cnt, (float)((data2_cnt * 100) / (272/time_reduce)));
            LOG_INFO("Data1(0x1f) : %d, Ratio : %.2f %%\n", data3_cnt, (float)((data3_cnt * 100) / (272/time_reduce)));
            LOG_INFO("Data1(0x00) : %d, Ratio : %.2f %%\n", data4_cnt, (float)((data4_cnt * 100) / (272/time_reduce)));
            line = __LINE__;
			goto FUN_FAIL;
        }
        else {			

            FUNC_END();

            LOG_INFO("[Pattern][%s]SUCCESS\n", __FUNCTION__);
		    LOG_INFO("Ideal Value : %d\n", 272/time_reduce);
    		LOG_INFO("Data1(0x01) : %d, Ratio : %.2f %%\n", data1_cnt, (float)((data1_cnt * 100) / (272/time_reduce)));
            LOG_INFO("Data1(0x00) : %d, Ratio : %.2f %%\n", data2_cnt, (float)((data2_cnt * 100) / (272/time_reduce)));
            LOG_INFO("Data1(0x1f) : %d, Ratio : %.2f %%\n", data3_cnt, (float)((data3_cnt * 100) / (272/time_reduce)));
            LOG_INFO("Data1(0x00) : %d, Ratio : %.2f %%\n", data4_cnt, (float)((data4_cnt * 100) / (272/time_reduce)));  
            return PASS;
        }
	}
FUN_FAIL:
    FUNC_END();

	LOG_INFO("[Pattern][%s]:%d FAIL\n" ,__FUNCTION__,line);
    return FAIL;

}


// 5.2.1.13
verdict DDI_ADV_Scan_Request_Discoverable(u8 dut1_fd ,u8 dut2_fd)
{  
    u8 buf[SOCKET_BUF_SIZE];
    int verdict=FAIL;
    int dut1=0;
    int line;
    struct itimerval timer;
    int query_time = 15;

    u32 ch = 36; // default
    u32 adv_cnt_37 = 0;
    u32 adv_cnt_38 = 0;
    u32 adv_cnt_39 = 0;

    u32 scn_rsp_37 = 0;
    u32 scn_rsp_38 = 0;
    u32 scn_rsp_39 = 0;

    COMM_Dut_clean_buffer(dut1_fd);
    COMM_Dut_clean_buffer(dut2_fd);

    Calculate_Execution_Time_Start();
LOOP1: //case 1 ,policy = 0
    ch ++ ;

	COMM_INI_Connection_Setup_White_Listed_Config(dut1, &g_pattern_param);
	memcpy(g_pattern_param.white_list_param.Address, adv_addr, ADDR_LENGTH);
	verdict=COMM_INI_Connection_Setup_White_Listed(dut1_fd, g_pattern_param);
	VERDICT_RESULT_WITH_LINE();

    // # p1 : Upper Tester sends an HCI_LE_Set_Scan_Response_Data.  
    COMM_Scan_Response_Data_Set_Config(dut2_fd , 3, &g_pattern_param);
    verdict = COMM_Scan_Response_Data_Set(dut2_fd, g_pattern_param);
    VERDICT_RESULT_WITH_LINE();

    // # p2 : Configure Lower Tester to monitor the advertising and scan response packets of the IUT    
    COMM_SCN_Active_Scanning_Config(dut1,&g_pattern_param);
    g_pattern_param.scn_param.Own_Address_Type[0] = HCI_CMD_PARAM_PUBLIC_DEVICE_ADDRESS;             
    g_pattern_param.scn_param.LE_Scan_Interval[0] =  0x0160 & 0x00ff;
	g_pattern_param.scn_param.LE_Scan_Interval[1] = (0x0160 & 0xff00) >> 8;
	g_pattern_param.scn_param.LE_Scan_Window[0] =	 0x0160 & 0x00ff;
	g_pattern_param.scn_param.LE_Scan_Window[1] =   (0x0160 & 0xff00) >> 8;
	g_pattern_param.scn_param.Scanning_Filter_Policy[0] =	HCI_CMD_PARAM_IGNORE_ADV_PKTS_FROM_DEV_NOT_IN_WHITE_LIST_ONLY;
    verdict = COMM_SCN_Active_Scanning(dut1_fd,g_pattern_param);
    VERDICT_RESULT_WITH_LINE();

    // # p3 : Upper Tester enables discoverable undirected advertising in the IUT using all 
    // supported advertising channels, minimum advertising intervals and filtering policy 
    //set to Allow Scan Request from Any, Allow Connect Request from Any (Default) (0x00)'. 
    COMM_ADV_Discoverable_Advertising_Config(31,&g_pattern_param);


    if (ch == 37){
    	g_pattern_param.adv_param.Advertising_Channel_Map[0] =HCI_CMD_PARAM_ENABLE_CHANNEL_37;
    }

    if (ch == 38){
    	g_pattern_param.adv_param.Advertising_Channel_Map[0] =HCI_CMD_PARAM_ENABLE_CHANNEL_38;
    }

    if (ch == 39){
    	g_pattern_param.adv_param.Advertising_Channel_Map[0] =HCI_CMD_PARAM_ENABLE_CHANNEL_39;
    }
    
    g_pattern_param.adv_param.Advertising_Filter_Policy[0] = HCI_CMD_PARAM_ALLOW_SCAN_REQ_AND_CONN_REQ_FROM_ANY;
    g_pattern_param.adv_param.Advertising_Interval_Max[0] =  HCI_CMD_PARAM_ADVERTISING_INTERVAL_MIN & 0x00ff;
	g_pattern_param.adv_param.Advertising_Interval_Max[1] = (HCI_CMD_PARAM_ADVERTISING_INTERVAL_MIN & 0xff00) >> 8;
	g_pattern_param.adv_param.Advertising_Interval_Min[0] =  HCI_CMD_PARAM_ADVERTISING_INTERVAL_MIN & 0x00ff;
	g_pattern_param.adv_param.Advertising_Interval_Min[1] = (HCI_CMD_PARAM_ADVERTISING_INTERVAL_MIN & 0xff00) >> 8;
    verdict=COMM_ADV_Discoverable_Advertising(dut2_fd,g_pattern_param);
    VERDICT_RESULT_WITH_LINE();

    read_le_event_enable();
        
	while(1) {//waiting adv report event , timer or counter  
		if(1 == read_le_event_get()) {

            event_query_timer_config(query_time, 0, 0, 0, &timer);
    		event_query_timer_start(timer, read_le_event_disable);
            
    		while(read_le_event_get()) {
                // # p4 :Lower Tester sends a SCAN_REQ packet on the selected advertising channel 
                //after receiving an ADV_DISCOVER_IND packet from IUT on the advertising 
                //channel configured in Step 3. The SCAN_REQ is sent T_IFS after the end of an 
                //ADV_IND packet. 
                MSLEEP(10);
               
    			if(SUCCESS != QUERY_LE_Event(dut1_fd, buf, _BT_HCI_LE_EVENT_SUB_OP_ADVERTISING_REPORT_, HCI_SUBEVENT_ADV_RPT_EVENT_SCAN_IND))
    			{				
    				    				
    				continue;
    			} 
    			else if(EQUAL != hci_le_event_advertising_report_parsing(HCI_SUBEVENT_ADV_RPT_EVENT_SCAN_IND, buf,g_pattern_param))
    			{
    				
    				continue;
    			}
    			else {

                    if (ch == 37){
                        adv_cnt_37++; 
                    }
                    
                    if (ch == 38){
                        adv_cnt_38++; 
                    }
                    
                    if (ch == 39){
                        adv_cnt_39++; 
                    }                    

                    printf("****LOOP 1 adv ch %d | adv cnt %d %d %d ****\n" ,ch , adv_cnt_37 , adv_cnt_38 , adv_cnt_39);

			    }

                // # p5 : Lower Tester expects a SCAN_RSP packet from the IUT T_IFS after the end of the SCAN_REQ packet.  
                if (SUCCESS != QUERY_LE_Event(dut1_fd, buf, _BT_HCI_LE_EVENT_SUB_OP_ADVERTISING_REPORT_, HCI_SUBEVENT_ADV_RPT_EVENT_SCAN_RSP)) {
                    continue;
                    
                    
                }            
                else if(EQUAL != hci_le_event_advertising_report_parsing(HCI_SUBEVENT_ADV_RPT_EVENT_SCAN_RSP, buf, g_pattern_param)) {
                    continue;
                }
                else {
                    
                    if (ch == 37){
                        scn_rsp_37++; 
                    }
                    
                    if (ch == 38){
                        scn_rsp_38++; 
                    }
                    
                    if (ch == 39){
                        scn_rsp_39++; 
                    }                    

                    printf("****LOOP 1 adv ch %d | scn cnt %d %d %d ****\n" ,ch , scn_rsp_37 , scn_rsp_38 , scn_rsp_39);


                }
 
		    }

            dut_reset_with_mask_en(dut1_fd);
            dut_reset_with_mask_en(dut2_fd);

            sleep(1);

            if(ch != 39){
                goto LOOP1;
            }

            // # p6 Repeat steps 4-5 30 times. 
            if((adv_cnt_37 < 30) || (adv_cnt_38 < 30) || (adv_cnt_39 < 30) || \
               (scn_rsp_37 < 30) || (scn_rsp_38 < 30) || (scn_rsp_39 < 30) ){
                line = __LINE__;
                goto FUN_FAIL;
            }   

    		break;
		}
    }

    ch = 36; // default
    adv_cnt_37 = 0;
    adv_cnt_38 = 0;
    adv_cnt_39 = 0;

    scn_rsp_37 = 0;
    scn_rsp_38 = 0;
    scn_rsp_39 = 0;

LOOP2: //case 2 ,policy = 1
    ch ++ ;
    // # p1 : Upper Tester sends an HCI_LE_Set_Scan_Response_Data.  
    COMM_Scan_Response_Data_Set_Config(dut2_fd , 3, &g_pattern_param);
    verdict = COMM_Scan_Response_Data_Set(dut2_fd, g_pattern_param);
    VERDICT_RESULT_WITH_LINE();

    COMM_INI_Connection_Setup_White_Listed_Config(dut1, &g_pattern_param);
	memcpy(g_pattern_param.white_list_param.Address, adv_addr, ADDR_LENGTH);
	verdict=COMM_INI_Connection_Setup_White_Listed(dut1_fd, g_pattern_param);
	VERDICT_RESULT_WITH_LINE();

    // # p2 : Configure Lower Tester to monitor the advertising and scan response packets of the IUT    
    COMM_SCN_Active_Scanning_Config(dut1,&g_pattern_param);
    g_pattern_param.scn_param.Own_Address_Type[0] = HCI_CMD_PARAM_PUBLIC_DEVICE_ADDRESS;             
    g_pattern_param.scn_param.LE_Scan_Interval[0] =  0x0160  & 0x00ff;
    g_pattern_param.scn_param.LE_Scan_Interval[1] = (0x0160  & 0xff00) >> 8;
    g_pattern_param.scn_param.LE_Scan_Window[0] =    0x0160  & 0x00ff;
    g_pattern_param.scn_param.LE_Scan_Window[1] =   (0x0160  & 0xff00) >> 8;
	g_pattern_param.scn_param.Scanning_Filter_Policy[0] =	HCI_CMD_PARAM_IGNORE_ADV_PKTS_FROM_DEV_NOT_IN_WHITE_LIST_ONLY;

    verdict = COMM_SCN_Active_Scanning(dut1_fd,g_pattern_param);
    VERDICT_RESULT_WITH_LINE();

    // # p3 : Upper Tester enables discoverable undirected advertising in the IUT using all 
    // supported advertising channels, minimum advertising intervals and filtering policy 
    //set to Allow Scan Request from Any, Allow Connect Request from Any (Default) (0x00)'. 
    COMM_ADV_Discoverable_Advertising_Config(0,&g_pattern_param);

    if (ch == 37){
        g_pattern_param.adv_param.Advertising_Channel_Map[0] =HCI_CMD_PARAM_ENABLE_CHANNEL_37;
    }

    if (ch == 38){
        g_pattern_param.adv_param.Advertising_Channel_Map[0] =HCI_CMD_PARAM_ENABLE_CHANNEL_38;
    }

    if (ch == 39){
        g_pattern_param.adv_param.Advertising_Channel_Map[0] =HCI_CMD_PARAM_ENABLE_CHANNEL_39;
    }
    
    g_pattern_param.adv_param.Advertising_Filter_Policy[0] = HCI_CMD_PARAM_ALLOW_SCAN_REQ_FROM_WHITELIST_ONLY_AND_CONN_REQ_FROM_ANY;
    g_pattern_param.adv_param.Advertising_Interval_Max[0] =  HCI_CMD_PARAM_ADVERTISING_INTERVAL_MIN & 0x00ff;
    g_pattern_param.adv_param.Advertising_Interval_Max[1] = (HCI_CMD_PARAM_ADVERTISING_INTERVAL_MIN & 0xff00) >> 8;
    g_pattern_param.adv_param.Advertising_Interval_Min[0] =  HCI_CMD_PARAM_ADVERTISING_INTERVAL_MIN & 0x00ff;
    g_pattern_param.adv_param.Advertising_Interval_Min[1] = (HCI_CMD_PARAM_ADVERTISING_INTERVAL_MIN & 0xff00) >> 8;
    verdict=COMM_ADV_Discoverable_Advertising(dut2_fd,g_pattern_param);
    VERDICT_RESULT_WITH_LINE();

    read_le_event_enable();
    
    while(1) {//waiting adv report event , timer or counter  
        if(1 == read_le_event_get()) {
            event_query_timer_config(query_time, 0, 0, 0, &timer);
            event_query_timer_start(timer, read_le_event_disable);
            
            while(read_le_event_get()) {
                // # p4 :Lower Tester sends a SCAN_REQ packet on the selected advertising channel 
                //after receiving an ADV_DISCOVER_IND packet from IUT on the advertising 
                //channel configured in Step 3. The SCAN_REQ is sent T_IFS after the end of an 
                //ADV_IND packet. 

            MSLEEP(10);
                
                if(SUCCESS != QUERY_LE_Event(dut1_fd, buf, _BT_HCI_LE_EVENT_SUB_OP_ADVERTISING_REPORT_, HCI_SUBEVENT_ADV_RPT_EVENT_SCAN_IND))
                {               
                    
                    
                    continue;
                } 
                else if(EQUAL != hci_le_event_advertising_report_parsing(HCI_SUBEVENT_ADV_RPT_EVENT_SCAN_IND, buf,g_pattern_param))
                {
                    
                    continue;
                }
                else {
                                        
                    if (ch == 37){
                        adv_cnt_37++; 
                    }
                    
                    if (ch == 38){
                        adv_cnt_38++; 
                    }
                    
                    if (ch == 39){
                        adv_cnt_39++; 
                    }                     

                    printf("****LOOP 2 adv ch %d | adv cnt %d %d %d ****\n" ,ch , adv_cnt_37 , adv_cnt_38 , adv_cnt_39);

                }

                // # p5 : Lower Tester expects a SCAN_RSP packet from the IUT T_IFS after the end of the SCAN_REQ packet.  
                if (SUCCESS != QUERY_LE_Event(dut1_fd, buf, _BT_HCI_LE_EVENT_SUB_OP_ADVERTISING_REPORT_, HCI_SUBEVENT_ADV_RPT_EVENT_SCAN_RSP)) {
                    continue;
                    
                    
                }            
                else if(EQUAL != hci_le_event_advertising_report_parsing(HCI_SUBEVENT_ADV_RPT_EVENT_SCAN_RSP, buf, g_pattern_param)) {
                    continue;
                }
                else {
                    if (ch == 37){
                        scn_rsp_37++; 
                    }
                    
                    if (ch == 38){
                        scn_rsp_38++; 
                    }
                    
                    if (ch == 39){
                        scn_rsp_39++; 
                    }                    

                    printf("****LOOP 2 adv ch %d | scn cnt %d %d %d ****\n" ,ch , scn_rsp_37 , scn_rsp_38 , scn_rsp_39);

                }
 
            }

            dut_reset_with_mask_en(dut1_fd);
            dut_reset_with_mask_en(dut2_fd);
            sleep(1);


            if(ch != 39){
                goto LOOP2;
            }

            // # p6 Repeat steps 4-5 30 times. 
            if((adv_cnt_37 < 30) || (adv_cnt_38 < 30) || (adv_cnt_39 < 30) || \
               (scn_rsp_37 > 0) || (scn_rsp_38 > 0) || (scn_rsp_39 > 0) ){
                line = __LINE__;
                goto FUN_FAIL;
            }   

            break;
        }
    }

    ch = 36; // default
    adv_cnt_37 = 0;
    adv_cnt_38 = 0;
    adv_cnt_39 = 0;

    scn_rsp_37 = 0;
    scn_rsp_38 = 0;
    scn_rsp_39 = 0;

LOOP3: //policy = 0 , scan data = 31
    ch ++ ;
    // # p1 : Upper Tester sends an HCI_LE_Set_Scan_Response_Data.  
    COMM_Scan_Response_Data_Set_Config(dut2_fd , 31, &g_pattern_param);
    verdict = COMM_Scan_Response_Data_Set(dut2_fd, g_pattern_param);
    VERDICT_RESULT_WITH_LINE();

    COMM_INI_Connection_Setup_White_Listed_Config(dut1, &g_pattern_param);
	memcpy(g_pattern_param.white_list_param.Address, adv_addr, ADDR_LENGTH);
	verdict = COMM_INI_Connection_Setup_White_Listed(dut1_fd, g_pattern_param);
	VERDICT_RESULT_WITH_LINE();


    // # p2 : Configure Lower Tester to monitor the advertising and scan response packets of the IUT    
    COMM_SCN_Active_Scanning_Config(dut1,&g_pattern_param);
    g_pattern_param.scn_param.Own_Address_Type[0] = HCI_CMD_PARAM_PUBLIC_DEVICE_ADDRESS;             
    g_pattern_param.scn_param.LE_Scan_Interval[0] =  0x0160  & 0x00ff;
    g_pattern_param.scn_param.LE_Scan_Interval[1] = (0x0160  & 0xff00) >> 8;
    g_pattern_param.scn_param.LE_Scan_Window[0] =    0x0160  & 0x00ff;
    g_pattern_param.scn_param.LE_Scan_Window[1] =   (0x0160  & 0xff00) >> 8;
	g_pattern_param.scn_param.Scanning_Filter_Policy[0] =	HCI_CMD_PARAM_IGNORE_ADV_PKTS_FROM_DEV_NOT_IN_WHITE_LIST_ONLY;

    verdict = COMM_SCN_Active_Scanning(dut1_fd,g_pattern_param);
    VERDICT_RESULT_WITH_LINE();

    // # p3 : Upper Tester enables discoverable undirected advertising in the IUT using all 
    // supported advertising channels, minimum advertising intervals and filtering policy 
    //set to Allow Scan Request from Any, Allow Connect Request from Any (Default) (0x00)'. 
    COMM_ADV_Discoverable_Advertising_Config(0,&g_pattern_param);

    if (ch == 37){
        g_pattern_param.adv_param.Advertising_Channel_Map[0] =HCI_CMD_PARAM_ENABLE_CHANNEL_37;
    }

    if (ch == 38){
        g_pattern_param.adv_param.Advertising_Channel_Map[0] =HCI_CMD_PARAM_ENABLE_CHANNEL_38;
    }

    if (ch == 39){
        g_pattern_param.adv_param.Advertising_Channel_Map[0] =HCI_CMD_PARAM_ENABLE_CHANNEL_39;
    }
    
    g_pattern_param.adv_param.Advertising_Filter_Policy[0] = HCI_CMD_PARAM_ALLOW_SCAN_REQ_AND_CONN_REQ_FROM_ANY;
    g_pattern_param.adv_param.Advertising_Interval_Max[0] =  HCI_CMD_PARAM_ADVERTISING_INTERVAL_MIN & 0x00ff;
    g_pattern_param.adv_param.Advertising_Interval_Max[1] = (HCI_CMD_PARAM_ADVERTISING_INTERVAL_MIN & 0xff00) >> 8;
    g_pattern_param.adv_param.Advertising_Interval_Min[0] =  HCI_CMD_PARAM_ADVERTISING_INTERVAL_MIN & 0x00ff;
    g_pattern_param.adv_param.Advertising_Interval_Min[1] = (HCI_CMD_PARAM_ADVERTISING_INTERVAL_MIN & 0xff00) >> 8;
    verdict=COMM_ADV_Discoverable_Advertising(dut2_fd,g_pattern_param);
    VERDICT_RESULT_WITH_LINE();

    read_le_event_enable();
    
    while(1) {//waiting adv report event , timer or counter  
        if(1 == read_le_event_get()) {
        // start the scanning time :30 sec
            event_query_timer_config(query_time, 0, 0, 0, &timer);
            event_query_timer_start(timer, read_le_event_disable);
            
            while(read_le_event_get()) {
                // # p4 :Lower Tester sends a SCAN_REQ packet on the selected advertising channel 
                //after receiving an ADV_DISCOVER_IND packet from IUT on the advertising 
                //channel configured in Step 3. The SCAN_REQ is sent T_IFS after the end of an 
                //ADV_IND packet. 

                MSLEEP(10);
                
                if(SUCCESS != QUERY_LE_Event(dut1_fd, buf, _BT_HCI_LE_EVENT_SUB_OP_ADVERTISING_REPORT_, HCI_SUBEVENT_ADV_RPT_EVENT_SCAN_IND))
                {               
                    
                    
                    continue;
                } 
                else if(EQUAL != hci_le_event_advertising_report_parsing(HCI_SUBEVENT_ADV_RPT_EVENT_SCAN_IND, buf,g_pattern_param))
                {
                    
                    continue;
                }
                else {

                    if (ch == 37){
                        adv_cnt_37++; 
                    }
                    
                    if (ch == 38){
                        adv_cnt_38++; 
                    }
                    
                    if (ch == 39){
                        adv_cnt_39++; 
                    }                    

                    printf("****LOOP 3 adv ch %d | adv cnt %d %d %d ****\n" ,ch , adv_cnt_37 , adv_cnt_38 , adv_cnt_39);

                }

                // # p5 : Lower Tester expects a SCAN_RSP packet from the IUT T_IFS after the end of the SCAN_REQ packet.  
                if (SUCCESS != QUERY_LE_Event(dut1_fd, buf, _BT_HCI_LE_EVENT_SUB_OP_ADVERTISING_REPORT_, HCI_SUBEVENT_ADV_RPT_EVENT_SCAN_RSP)) {
                    continue;
                    
                    
                }            
                else if(EQUAL != hci_le_event_advertising_report_parsing(HCI_SUBEVENT_ADV_RPT_EVENT_SCAN_RSP, buf, g_pattern_param)) {
                    continue;
                }
                else {
                    if (ch == 37){
                        scn_rsp_37++; 
                    }
                    
                    if (ch == 38){
                        scn_rsp_38++; 
                    }
                    
                    if (ch == 39){
                        scn_rsp_39++; 
                    }                    

                    printf("****LOOP 3 adv ch %d | scn cnt %d %d %d ****\n" ,ch , scn_rsp_37 , scn_rsp_38 , scn_rsp_39);

                }
 
            }

            dut_reset_with_mask_en(dut1_fd);
            dut_reset_with_mask_en(dut2_fd);
            sleep(1);


            if(ch != 39){
                goto LOOP3;
            }

            // # p6 Repeat steps 4-5 30 times. 
            if((adv_cnt_37 < 30) || (adv_cnt_38 < 30) || (adv_cnt_39 < 30) || \
               (scn_rsp_37 < 30) || (scn_rsp_38 < 30) || (scn_rsp_39 < 30) ){
                line = __LINE__;
                goto FUN_FAIL;
            }   

            break;
        }
    }

    ch = 36; // default
    adv_cnt_37 = 0;
    adv_cnt_38 = 0;
    adv_cnt_39 = 0;

    scn_rsp_37 = 0;
    scn_rsp_38 = 0;
    scn_rsp_39 = 0;
    
LOOP4: //policy = 1 , scan data = 31
    ch ++ ;
    // # p1 : Upper Tester sends an HCI_LE_Set_Scan_Response_Data.  
    COMM_Scan_Response_Data_Set_Config(dut2_fd , 31, &g_pattern_param);
    verdict = COMM_Scan_Response_Data_Set(dut2_fd, g_pattern_param);
    VERDICT_RESULT_WITH_LINE();

    COMM_INI_Connection_Setup_White_Listed_Config(dut1, &g_pattern_param);
	memcpy(g_pattern_param.white_list_param.Address, adv_addr, ADDR_LENGTH);
	verdict = COMM_INI_Connection_Setup_White_Listed(dut1_fd, g_pattern_param);
	VERDICT_RESULT_WITH_LINE();


    // # p2 : Configure Lower Tester to monitor the advertising and scan response packets of the IUT    
    COMM_SCN_Active_Scanning_Config(dut1,&g_pattern_param);
    g_pattern_param.scn_param.Own_Address_Type[0] = HCI_CMD_PARAM_PUBLIC_DEVICE_ADDRESS;             
    g_pattern_param.scn_param.LE_Scan_Interval[0] =  0x0160  & 0x00ff;
    g_pattern_param.scn_param.LE_Scan_Interval[1] = (0x0160  & 0xff00) >> 8;
    g_pattern_param.scn_param.LE_Scan_Window[0] =    0x0160  & 0x00ff;
    g_pattern_param.scn_param.LE_Scan_Window[1] =   (0x0160  & 0xff00) >> 8;
	g_pattern_param.scn_param.Scanning_Filter_Policy[0] =	HCI_CMD_PARAM_IGNORE_ADV_PKTS_FROM_DEV_NOT_IN_WHITE_LIST_ONLY;
    
    verdict = COMM_SCN_Active_Scanning(dut1_fd,g_pattern_param);
    VERDICT_RESULT_WITH_LINE();

    // # p3 : Upper Tester enables discoverable undirected advertising in the IUT using all 
    // supported advertising channels, minimum advertising intervals and filtering policy 
    //set to Allow Scan Request from Any, Allow Connect Request from Any (Default) (0x00)'. 
    COMM_ADV_Discoverable_Advertising_Config(0,&g_pattern_param);

    if (ch == 37){
        g_pattern_param.adv_param.Advertising_Channel_Map[0] =HCI_CMD_PARAM_ENABLE_CHANNEL_37;
    }

    if (ch == 38){
        g_pattern_param.adv_param.Advertising_Channel_Map[0] =HCI_CMD_PARAM_ENABLE_CHANNEL_38;
    }

    if (ch == 39){
        g_pattern_param.adv_param.Advertising_Channel_Map[0] =HCI_CMD_PARAM_ENABLE_CHANNEL_39;
    }
    
    g_pattern_param.adv_param.Advertising_Filter_Policy[0] = HCI_CMD_PARAM_ALLOW_SCAN_REQ_FROM_WHITELIST_ONLY_AND_CONN_REQ_FROM_ANY;
    g_pattern_param.adv_param.Advertising_Interval_Max[0] =  HCI_CMD_PARAM_ADVERTISING_INTERVAL_MIN & 0x00ff;
    g_pattern_param.adv_param.Advertising_Interval_Max[1] = (HCI_CMD_PARAM_ADVERTISING_INTERVAL_MIN & 0xff00) >> 8;
    g_pattern_param.adv_param.Advertising_Interval_Min[0] =  HCI_CMD_PARAM_ADVERTISING_INTERVAL_MIN & 0x00ff;
    g_pattern_param.adv_param.Advertising_Interval_Min[1] = (HCI_CMD_PARAM_ADVERTISING_INTERVAL_MIN & 0xff00) >> 8;
    verdict=COMM_ADV_Discoverable_Advertising(dut2_fd,g_pattern_param);
    VERDICT_RESULT_WITH_LINE();

    read_le_event_enable();

    printf("****timer for 30sec****\n" );
    
    while(1) {//waiting adv report event , timer or counter  
        if(1 == read_le_event_get()) {
        // start the scanning time :30 sec
            event_query_timer_config(query_time, 0, 0, 0, &timer);
            event_query_timer_start(timer, read_le_event_disable);
            
            while(read_le_event_get()) {
                // # p4 :Lower Tester sends a SCAN_REQ packet on the selected advertising channel 
                //after receiving an ADV_DISCOVER_IND packet from IUT on the advertising 
                //channel configured in Step 3. The SCAN_REQ is sent T_IFS after the end of an 
                //ADV_IND packet. 

                MSLEEP(10);
                
                if(SUCCESS != QUERY_LE_Event(dut1_fd, buf, _BT_HCI_LE_EVENT_SUB_OP_ADVERTISING_REPORT_, HCI_SUBEVENT_ADV_RPT_EVENT_SCAN_IND))
                {               
                    
                    
                    continue;
                } 
                else if(EQUAL != hci_le_event_advertising_report_parsing(HCI_SUBEVENT_ADV_RPT_EVENT_SCAN_IND, buf,g_pattern_param))
                {
                    
                    continue;
                }
                else {
                    if (ch == 37){
                        adv_cnt_37++; 
                    }
                    
                    if (ch == 38){
                        adv_cnt_38++; 
                    }
                    
                    if (ch == 39){
                        adv_cnt_39++; 
                    }

                    printf("****LOOP 4 adv ch %d | adv cnt %d %d %d ****\n" ,ch , adv_cnt_37 , adv_cnt_38 , adv_cnt_39);
                    
                }

                // # p5 : Lower Tester expects a SCAN_RSP packet from the IUT T_IFS after the end of the SCAN_REQ packet.  
                if (SUCCESS != QUERY_LE_Event(dut1_fd, buf, _BT_HCI_LE_EVENT_SUB_OP_ADVERTISING_REPORT_, HCI_SUBEVENT_ADV_RPT_EVENT_SCAN_RSP)) {
                    continue;
                    
                    
                }            
                else if(EQUAL != hci_le_event_advertising_report_parsing(HCI_SUBEVENT_ADV_RPT_EVENT_SCAN_RSP, buf, g_pattern_param)) {
                    continue;
                }
                else {
                    if (ch == 37){
                        scn_rsp_37++; 
                    }
                    
                    if (ch == 38){
                        scn_rsp_38++; 
                    }
                    
                    if (ch == 39){
                        scn_rsp_39++; 
                    }                    

                    printf("****LOOP 4 adv ch %d | scn cnt %d %d %d ****\n" ,ch , scn_rsp_37 , scn_rsp_38 , scn_rsp_39);

                }
 
            }

            dut_reset_with_mask_en(dut1_fd);
            dut_reset_with_mask_en(dut2_fd);
            sleep(1);


            if(ch != 39){
                goto LOOP4;
            }

            // # p6 Repeat steps 4-5 30 times. 
            if((adv_cnt_37 < 30) || (adv_cnt_38 < 30) || (adv_cnt_39 < 30) || \
                (scn_rsp_37 > 0) || (scn_rsp_38 > 0) || (scn_rsp_39 > 0) ){
                line = __LINE__;
                goto FUN_FAIL;
            }    

            break;
        }
    }

    ch = 36; // default
    adv_cnt_37 = 0;
    adv_cnt_38 = 0;
    adv_cnt_39 = 0;

    scn_rsp_37 = 0;
    scn_rsp_38 = 0;
    scn_rsp_39 = 0;
        
LOOP5: //policy = 0 , dev_addr =diff comp id ,scan data = 0		
    ch ++ ;

	COMM_Static_Random_Device_Address_Set_Config(scan_random_addr);
	COMM_Device_Address_Set(dut1_fd,g_pattern_param);

    COMM_INI_Connection_Setup_White_Listed_Config(dut1, &g_pattern_param);
	memcpy(g_pattern_param.white_list_param.Address, adv_addr, ADDR_LENGTH);
	verdict=COMM_INI_Connection_Setup_White_Listed(dut1_fd, g_pattern_param);
	VERDICT_RESULT_WITH_LINE();

    
    // # p1 : Upper Tester sends an HCI_LE_Set_Scan_Response_Data.  
    COMM_Scan_Response_Data_Set_Config(dut2_fd , 0, &g_pattern_param);
    verdict = COMM_Scan_Response_Data_Set(dut2_fd, g_pattern_param);
    VERDICT_RESULT_WITH_LINE();

    // # p2 : Configure Lower Tester to monitor the advertising and scan response packets of the IUT    
    COMM_SCN_Active_Scanning_Config(dut1,&g_pattern_param);
    g_pattern_param.scn_param.Own_Address_Type[0] = HCI_CMD_PARAM_RANDOM_DEVICE_ADDRESS;             
    g_pattern_param.scn_param.LE_Scan_Interval[0] =  0x0160  & 0x00ff;
    g_pattern_param.scn_param.LE_Scan_Interval[1] = (0x0160  & 0xff00) >> 8;
    g_pattern_param.scn_param.LE_Scan_Window[0] =    0x0160  & 0x00ff;
    g_pattern_param.scn_param.LE_Scan_Window[1] =   (0x0160  & 0xff00) >> 8;
	g_pattern_param.scn_param.Scanning_Filter_Policy[0] =	HCI_CMD_PARAM_IGNORE_ADV_PKTS_FROM_DEV_NOT_IN_WHITE_LIST_ONLY;

    verdict = COMM_SCN_Active_Scanning(dut1_fd,g_pattern_param);
    VERDICT_RESULT_WITH_LINE();

    // # p3 : Upper Tester enables discoverable undirected advertising in the IUT using all 
    // supported advertising channels, minimum advertising intervals and filtering policy 
    //set to Allow Scan Request from Any, Allow Connect Request from Any (Default) (0x00)'. 
    COMM_ADV_Discoverable_Advertising_Config(0,&g_pattern_param);

    if (ch == 37){
        g_pattern_param.adv_param.Advertising_Channel_Map[0] =HCI_CMD_PARAM_ENABLE_CHANNEL_37;
    }

    if (ch == 38){
        g_pattern_param.adv_param.Advertising_Channel_Map[0] =HCI_CMD_PARAM_ENABLE_CHANNEL_38;
    }

    if (ch == 39){
        g_pattern_param.adv_param.Advertising_Channel_Map[0] =HCI_CMD_PARAM_ENABLE_CHANNEL_39;
    }
    
    g_pattern_param.adv_param.Advertising_Filter_Policy[0] = HCI_CMD_PARAM_ALLOW_SCAN_REQ_AND_CONN_REQ_FROM_ANY;
    g_pattern_param.adv_param.Advertising_Interval_Max[0] =  HCI_CMD_PARAM_ADVERTISING_INTERVAL_MIN & 0x00ff;
    g_pattern_param.adv_param.Advertising_Interval_Max[1] = (HCI_CMD_PARAM_ADVERTISING_INTERVAL_MIN & 0xff00) >> 8;
    g_pattern_param.adv_param.Advertising_Interval_Min[0] =  HCI_CMD_PARAM_ADVERTISING_INTERVAL_MIN & 0x00ff;
    g_pattern_param.adv_param.Advertising_Interval_Min[1] = (HCI_CMD_PARAM_ADVERTISING_INTERVAL_MIN & 0xff00) >> 8;
    verdict=COMM_ADV_Discoverable_Advertising(dut2_fd,g_pattern_param);
    VERDICT_RESULT_WITH_LINE();

    read_le_event_enable();

    printf("****timer for 30sec****\n" );
    
    while(1) {//waiting adv report event , timer or counter  
        if(1 == read_le_event_get()) {
        // start the scanning time :30 sec
            event_query_timer_config(query_time, 0, 0, 0, &timer);
            event_query_timer_start(timer, read_le_event_disable);
            
            while(read_le_event_get()) {
                // # p4 :Lower Tester sends a SCAN_REQ packet on the selected advertising channel 
                //after receiving an ADV_DISCOVER_IND packet from IUT on the advertising 
                //channel configured in Step 3. The SCAN_REQ is sent T_IFS after the end of an 
                //ADV_IND packet. 

                MSLEEP(10);
                
                if(SUCCESS != QUERY_LE_Event(dut1_fd, buf, _BT_HCI_LE_EVENT_SUB_OP_ADVERTISING_REPORT_, HCI_SUBEVENT_ADV_RPT_EVENT_SCAN_IND))
                {               
                    
                    
                    continue;
                } 
                else if(EQUAL != hci_le_event_advertising_report_parsing(HCI_SUBEVENT_ADV_RPT_EVENT_SCAN_IND, buf,g_pattern_param))
                {
                    
                    continue;
                }
                else {

                    if (ch == 37){
                        adv_cnt_37++; 
                    }
                    
                    if (ch == 38){
                        adv_cnt_38++; 
                    }
                    
                    if (ch == 39){
                        adv_cnt_39++; 
                    }                    

                    printf("****LOOP 5 adv ch %d | adv cnt %d %d %d ****\n" ,ch , adv_cnt_37 , adv_cnt_38 , adv_cnt_39);

                }

                // # p5 : Lower Tester expects a SCAN_RSP packet from the IUT T_IFS after the end of the SCAN_REQ packet.  
                if (SUCCESS != QUERY_LE_Event(dut1_fd, buf, _BT_HCI_LE_EVENT_SUB_OP_ADVERTISING_REPORT_, HCI_SUBEVENT_ADV_RPT_EVENT_SCAN_RSP)) {
                    continue;
                    
                    
                }            
                else if(EQUAL != hci_le_event_advertising_report_parsing(HCI_SUBEVENT_ADV_RPT_EVENT_SCAN_RSP, buf, g_pattern_param)) {
                    continue;
                }
                else {
                    if (ch == 37){
                        scn_rsp_37++; 
                    }
                    
                    if (ch == 38){
                        scn_rsp_38++; 
                    }
                    
                    if (ch == 39){
                        scn_rsp_39++; 
                    }                    

                    printf("****LOOP 5 adv ch %d | scn cnt %d %d %d ****\n" ,ch , scn_rsp_37 , scn_rsp_38 , scn_rsp_39);

                }
 
            }

            dut_reset_with_mask_en(dut1_fd);
            dut_reset_with_mask_en(dut2_fd);
            sleep(1);


            if(ch != 39){
                goto LOOP5;
            }

            // # p6 Repeat steps 4-5 30 times. 
            if((adv_cnt_37 < 30) || (adv_cnt_38 < 30) || (adv_cnt_39 < 30) || \
               (scn_rsp_37 < 30) || (scn_rsp_38 < 30) || (scn_rsp_39 < 30) ){
                line = __LINE__;
                goto FUN_FAIL;
            }   

            break;
        }
    }


    ch = 36; // default
    adv_cnt_37 = 0;
    adv_cnt_38 = 0;
    adv_cnt_39 = 0;

    scn_rsp_37 = 0;
    scn_rsp_38 = 0;
    scn_rsp_39 = 0;
            
LOOP6: //policy = 1 , dev_addr =diff comp id ,scan data = 0   
    ch ++ ;

	COMM_Static_Random_Device_Address_Set_Config(scan_random_addr);
	COMM_Device_Address_Set(dut1_fd,g_pattern_param);

    COMM_INI_Connection_Setup_White_Listed_Config(dut1, &g_pattern_param);
	memcpy(g_pattern_param.white_list_param.Address, adv_addr, ADDR_LENGTH);
	verdict=COMM_INI_Connection_Setup_White_Listed(dut1_fd, g_pattern_param);
	VERDICT_RESULT_WITH_LINE();
    
    // # p1 : Upper Tester sends an HCI_LE_Set_Scan_Response_Data.  
    COMM_Scan_Response_Data_Set_Config(dut2_fd , 0, &g_pattern_param);
    verdict = COMM_Scan_Response_Data_Set(dut2_fd, g_pattern_param);
    VERDICT_RESULT_WITH_LINE();

    // # p2 : Configure Lower Tester to monitor the advertising and scan response packets of the IUT    
    COMM_SCN_Active_Scanning_Config(dut1,&g_pattern_param);
    g_pattern_param.scn_param.Own_Address_Type[0] = HCI_CMD_PARAM_RANDOM_DEVICE_ADDRESS;             
    g_pattern_param.scn_param.LE_Scan_Interval[0] =  0x0160  & 0x00ff;
    g_pattern_param.scn_param.LE_Scan_Interval[1] = (0x0160  & 0xff00) >> 8;
    g_pattern_param.scn_param.LE_Scan_Window[0] =    0x0160  & 0x00ff;
    g_pattern_param.scn_param.LE_Scan_Window[1] =   (0x0160  & 0xff00) >> 8;
	g_pattern_param.scn_param.Scanning_Filter_Policy[0] =	HCI_CMD_PARAM_IGNORE_ADV_PKTS_FROM_DEV_NOT_IN_WHITE_LIST_ONLY;
    
    verdict = COMM_SCN_Active_Scanning(dut1_fd,g_pattern_param);
    VERDICT_RESULT_WITH_LINE();

    // # p3 : Upper Tester enables discoverable undirected advertising in the IUT using all 
    // supported advertising channels, minimum advertising intervals and filtering policy 
    //set to Allow Scan Request from Any, Allow Connect Request from Any (Default) (0x00)'. 
    COMM_ADV_Discoverable_Advertising_Config(0,&g_pattern_param);

    if (ch == 37){
        g_pattern_param.adv_param.Advertising_Channel_Map[0] =HCI_CMD_PARAM_ENABLE_CHANNEL_37;
    }

    if (ch == 38){
        g_pattern_param.adv_param.Advertising_Channel_Map[0] =HCI_CMD_PARAM_ENABLE_CHANNEL_38;
    }

    if (ch == 39){
        g_pattern_param.adv_param.Advertising_Channel_Map[0] =HCI_CMD_PARAM_ENABLE_CHANNEL_39;
    }
    
    g_pattern_param.adv_param.Advertising_Filter_Policy[0] = HCI_CMD_PARAM_ALLOW_SCAN_REQ_FROM_WHITELIST_ONLY_AND_CONN_REQ_FROM_ANY;
    g_pattern_param.adv_param.Advertising_Interval_Max[0] =  HCI_CMD_PARAM_ADVERTISING_INTERVAL_MIN & 0x00ff;
    g_pattern_param.adv_param.Advertising_Interval_Max[1] = (HCI_CMD_PARAM_ADVERTISING_INTERVAL_MIN & 0xff00) >> 8;
    g_pattern_param.adv_param.Advertising_Interval_Min[0] =  HCI_CMD_PARAM_ADVERTISING_INTERVAL_MIN & 0x00ff;
    g_pattern_param.adv_param.Advertising_Interval_Min[1] = (HCI_CMD_PARAM_ADVERTISING_INTERVAL_MIN & 0xff00) >> 8;
    verdict=COMM_ADV_Discoverable_Advertising(dut2_fd,g_pattern_param);
    VERDICT_RESULT_WITH_LINE();

    read_le_event_enable();

    printf("****timer for 30sec****\n" );
    
    while(1) {//waiting adv report event , timer or counter  
        if(1 == read_le_event_get()) {
        // start the scanning time :30 sec
            event_query_timer_config(query_time, 0, 0, 0, &timer);
            event_query_timer_start(timer, read_le_event_disable);
            
            while(read_le_event_get()) {
                // # p4 :Lower Tester sends a SCAN_REQ packet on the selected advertising channel 
                //after receiving an ADV_DISCOVER_IND packet from IUT on the advertising 
                //channel configured in Step 3. The SCAN_REQ is sent T_IFS after the end of an 
                //ADV_IND packet. 

                MSLEEP(10);
                
                if(SUCCESS != QUERY_LE_Event(dut1_fd, buf, _BT_HCI_LE_EVENT_SUB_OP_ADVERTISING_REPORT_, HCI_SUBEVENT_ADV_RPT_EVENT_SCAN_IND))
                {               
                    
                    
                    continue;
                } 
                else if(EQUAL != hci_le_event_advertising_report_parsing(HCI_SUBEVENT_ADV_RPT_EVENT_SCAN_IND, buf,g_pattern_param))
                {
                    
                    continue;
                }
                else {

                    if (ch == 37){
                        adv_cnt_37++; 
                    }
                    
                    if (ch == 38){
                        adv_cnt_38++; 
                    }
                    
                    if (ch == 39){
                        adv_cnt_39++; 
                    }                    

                    printf("****LOOP 6 adv ch %d | adv cnt %d %d %d ****\n" ,ch , adv_cnt_37 , adv_cnt_38 , adv_cnt_39);

                }

                // # p5 : Lower Tester expects a SCAN_RSP packet from the IUT T_IFS after the end of the SCAN_REQ packet.  
                if (SUCCESS != QUERY_LE_Event(dut1_fd, buf, _BT_HCI_LE_EVENT_SUB_OP_ADVERTISING_REPORT_, HCI_SUBEVENT_ADV_RPT_EVENT_SCAN_RSP)) {
                    continue;
                    
                    
                }            
                else if(EQUAL != hci_le_event_advertising_report_parsing(HCI_SUBEVENT_ADV_RPT_EVENT_SCAN_RSP, buf, g_pattern_param)) {
                    continue;
                }
                else {
                    
                    if (ch == 37){
                        scn_rsp_37++; 
                    }
                    
                    if (ch == 38){
                        scn_rsp_38++; 
                    }
                    
                    if (ch == 39){
                        scn_rsp_39++; 
                    }                    

                    printf("****LOOP 6 adv ch %d | scn cnt %d %d %d ****\n" ,ch , scn_rsp_37 , scn_rsp_38 , scn_rsp_39);

                }
 
            }

            dut_reset_with_mask_en(dut1_fd);
            dut_reset_with_mask_en(dut2_fd);
            sleep(1);


            if(ch != 39){
                goto LOOP6;
            }

            // # p6 Repeat steps 4-5 30 times. 
            if((adv_cnt_37 < 30) || (adv_cnt_38 < 30) || (adv_cnt_39 < 30) || \
                (scn_rsp_37 > 0) || (scn_rsp_38 > 0) || (scn_rsp_39 > 0) ){
                line = __LINE__;
                goto FUN_FAIL;
            }   


            break;
        }
    }

    ch = 36; // default
    adv_cnt_37 = 0;
    adv_cnt_38 = 0;
    adv_cnt_39 = 0;

    scn_rsp_37 = 0;
    scn_rsp_38 = 0;
    scn_rsp_39 = 0;

LOOP7: //policy = 0 , dev_addr =diff comp id ,scan data = 0   
    ch ++ ;

	COMM_Static_Random_Device_Address_Set_Config(scan_random_addr);
	COMM_Device_Address_Set(dut1_fd,g_pattern_param);

    COMM_INI_Connection_Setup_White_Listed_Config(dut1, &g_pattern_param);
	memcpy(g_pattern_param.white_list_param.Address, adv_addr, ADDR_LENGTH);
	verdict=COMM_INI_Connection_Setup_White_Listed(dut1_fd, g_pattern_param);
	VERDICT_RESULT_WITH_LINE();

    
    // # p1 : Upper Tester sends an HCI_LE_Set_Scan_Response_Data.  
    COMM_Scan_Response_Data_Set_Config(dut2_fd , 0, &g_pattern_param);
    verdict = COMM_Scan_Response_Data_Set(dut2_fd, g_pattern_param);
    VERDICT_RESULT_WITH_LINE();

    // # p2 : Configure Lower Tester to monitor the advertising and scan response packets of the IUT    
    COMM_SCN_Active_Scanning_Config(dut1,&g_pattern_param);
    g_pattern_param.scn_param.Own_Address_Type[0] = HCI_CMD_PARAM_RANDOM_DEVICE_ADDRESS;             
    g_pattern_param.scn_param.LE_Scan_Interval[0] =  0x0160  & 0x00ff;
    g_pattern_param.scn_param.LE_Scan_Interval[1] = (0x0160  & 0xff00) >> 8;
    g_pattern_param.scn_param.LE_Scan_Window[0] =    0x0160  & 0x00ff;
    g_pattern_param.scn_param.LE_Scan_Window[1] =   (0x0160  & 0xff00) >> 8;
	g_pattern_param.scn_param.Scanning_Filter_Policy[0] =	HCI_CMD_PARAM_IGNORE_ADV_PKTS_FROM_DEV_NOT_IN_WHITE_LIST_ONLY;

    verdict = COMM_SCN_Active_Scanning(dut1_fd,g_pattern_param);
    VERDICT_RESULT_WITH_LINE();

    // # p3 : Upper Tester enables discoverable undirected advertising in the IUT using all 
    // supported advertising channels, minimum advertising intervals and filtering policy 
    //set to Allow Scan Request from Any, Allow Connect Request from Any (Default) (0x00)'. 
    COMM_ADV_Discoverable_Advertising_Config(0,&g_pattern_param);

    if (ch == 37){
        g_pattern_param.adv_param.Advertising_Channel_Map[0] =HCI_CMD_PARAM_ENABLE_CHANNEL_37;
    }

    if (ch == 38){
        g_pattern_param.adv_param.Advertising_Channel_Map[0] =HCI_CMD_PARAM_ENABLE_CHANNEL_38;
    }

    if (ch == 39){
        g_pattern_param.adv_param.Advertising_Channel_Map[0] =HCI_CMD_PARAM_ENABLE_CHANNEL_39;
    }
    
    g_pattern_param.adv_param.Advertising_Filter_Policy[0] = HCI_CMD_PARAM_ALLOW_SCAN_REQ_AND_CONN_REQ_FROM_ANY;
    g_pattern_param.adv_param.Advertising_Interval_Max[0] =  HCI_CMD_PARAM_ADVERTISING_INTERVAL_MIN & 0x00ff;
    g_pattern_param.adv_param.Advertising_Interval_Max[1] = (HCI_CMD_PARAM_ADVERTISING_INTERVAL_MIN & 0xff00) >> 8;
    g_pattern_param.adv_param.Advertising_Interval_Min[0] =  HCI_CMD_PARAM_ADVERTISING_INTERVAL_MIN & 0x00ff;
    g_pattern_param.adv_param.Advertising_Interval_Min[1] = (HCI_CMD_PARAM_ADVERTISING_INTERVAL_MIN & 0xff00) >> 8;
    verdict=COMM_ADV_Discoverable_Advertising(dut2_fd,g_pattern_param);
    VERDICT_RESULT_WITH_LINE();

    read_le_event_enable();

    printf("****timer for 30sec****\n" );
    
    while(1) {//waiting adv report event , timer or counter  
        if(1 == read_le_event_get()) {
        // start the scanning time :30 sec
            event_query_timer_config(query_time, 0, 0, 0, &timer);
            event_query_timer_start(timer, read_le_event_disable);
            
            while(read_le_event_get()) {
                // # p4 :Lower Tester sends a SCAN_REQ packet on the selected advertising channel 
                //after receiving an ADV_DISCOVER_IND packet from IUT on the advertising 
                //channel configured in Step 3. The SCAN_REQ is sent T_IFS after the end of an 
                //ADV_IND packet. 

                MSLEEP(10);
                
                if(SUCCESS != QUERY_LE_Event(dut1_fd, buf, _BT_HCI_LE_EVENT_SUB_OP_ADVERTISING_REPORT_, HCI_SUBEVENT_ADV_RPT_EVENT_SCAN_IND))
                {               
                    
                    
                    continue;
                } 
                else if(EQUAL != hci_le_event_advertising_report_parsing(HCI_SUBEVENT_ADV_RPT_EVENT_SCAN_IND, buf,g_pattern_param))
                {
                    
                    continue;
                }
                else {
                    if (ch == 37){
                        adv_cnt_37++; 
                    }
                    
                    if (ch == 38){
                        adv_cnt_38++; 
                    }
                    
                    if (ch == 39){
                        adv_cnt_39++; 
                    }                    

                    printf("****LOOP 7 adv ch %d | adv cnt %d %d %d ****\n" ,ch , adv_cnt_37 , adv_cnt_38 , adv_cnt_39);

                }

                // # p5 : Lower Tester expects a SCAN_RSP packet from the IUT T_IFS after the end of the SCAN_REQ packet.  
                if (SUCCESS != QUERY_LE_Event(dut1_fd, buf, _BT_HCI_LE_EVENT_SUB_OP_ADVERTISING_REPORT_, HCI_SUBEVENT_ADV_RPT_EVENT_SCAN_RSP)) {
                    continue;
                    
                    
                }            
                else if(EQUAL != hci_le_event_advertising_report_parsing(HCI_SUBEVENT_ADV_RPT_EVENT_SCAN_RSP, buf, g_pattern_param)) {
                    continue;
                }
                else {
                    
                    if (ch == 37){
                        scn_rsp_37++; 
                    }
                    
                    if (ch == 38){
                        scn_rsp_38++; 
                    }
                    
                    if (ch == 39){
                        scn_rsp_39++; 
                    }                    

                    printf("****LOOP 7 adv ch %d | scn cnt %d %d %d ****\n" ,ch , scn_rsp_37 , scn_rsp_38 , scn_rsp_39);

                }
 
            }
            dut_reset_with_mask_en(dut1_fd);
            dut_reset_with_mask_en(dut2_fd);
            sleep(1);


            if(ch != 39){
                goto LOOP7;
            }

            // # p6 Repeat steps 4-5 30 times. 
            if((adv_cnt_37 < 30) || (adv_cnt_38 < 30) || (adv_cnt_39 < 30) || \
               (scn_rsp_37 < 30) || (scn_rsp_38 < 30) || (scn_rsp_39 < 30) ){
                line = __LINE__;
                goto FUN_FAIL;
            }   

            break;
        }
    }


    ch = 36; // default
    adv_cnt_37 = 0;
    adv_cnt_38 = 0;
    adv_cnt_39 = 0;

    scn_rsp_37 = 0;
    scn_rsp_38 = 0;
    scn_rsp_39 = 0;

LOOP8: //policy = 1 , dev_addr =diff comp id ,scan data = 0   
    ch ++ ;

	COMM_Static_Random_Device_Address_Set_Config(scan_random_addr);
	COMM_Device_Address_Set(dut1_fd,g_pattern_param);

    COMM_INI_Connection_Setup_White_Listed_Config(dut1, &g_pattern_param);
	memcpy(g_pattern_param.white_list_param.Address, adv_addr, ADDR_LENGTH);
	verdict=COMM_INI_Connection_Setup_White_Listed(dut1_fd, g_pattern_param);
	VERDICT_RESULT_WITH_LINE();

    
    // # p1 : Upper Tester sends an HCI_LE_Set_Scan_Response_Data.  
    COMM_Scan_Response_Data_Set_Config(dut2_fd , 0, &g_pattern_param);
    verdict = COMM_Scan_Response_Data_Set(dut2_fd, g_pattern_param);
    VERDICT_RESULT_WITH_LINE();

    // # p2 : Configure Lower Tester to monitor the advertising and scan response packets of the IUT    
    COMM_SCN_Active_Scanning_Config(dut1,&g_pattern_param);
    g_pattern_param.scn_param.Own_Address_Type[0] = HCI_CMD_PARAM_RANDOM_DEVICE_ADDRESS;             
    g_pattern_param.scn_param.LE_Scan_Interval[0] =  0x0160  & 0x00ff;
    g_pattern_param.scn_param.LE_Scan_Interval[1] = (0x0160  & 0xff00) >> 8;
    g_pattern_param.scn_param.LE_Scan_Window[0] =    0x0160  & 0x00ff;
    g_pattern_param.scn_param.LE_Scan_Window[1] =   (0x0160  & 0xff00) >> 8;
	g_pattern_param.scn_param.Scanning_Filter_Policy[0] =	HCI_CMD_PARAM_IGNORE_ADV_PKTS_FROM_DEV_NOT_IN_WHITE_LIST_ONLY;
    
    verdict = COMM_SCN_Active_Scanning(dut1_fd,g_pattern_param);
    VERDICT_RESULT_WITH_LINE();

    // # p3 : Upper Tester enables discoverable undirected advertising in the IUT using all 
    // supported advertising channels, minimum advertising intervals and filtering policy 
    //set to Allow Scan Request from Any, Allow Connect Request from Any (Default) (0x00)'. 
    COMM_ADV_Discoverable_Advertising_Config(0,&g_pattern_param);

    if (ch == 37){
        g_pattern_param.adv_param.Advertising_Channel_Map[0] =HCI_CMD_PARAM_ENABLE_CHANNEL_37;
    }

    if (ch == 38){
        g_pattern_param.adv_param.Advertising_Channel_Map[0] =HCI_CMD_PARAM_ENABLE_CHANNEL_38;
    }

    if (ch == 39){
        g_pattern_param.adv_param.Advertising_Channel_Map[0] =HCI_CMD_PARAM_ENABLE_CHANNEL_39;
    }
    
    g_pattern_param.adv_param.Advertising_Filter_Policy[0] = HCI_CMD_PARAM_ALLOW_SCAN_REQ_FROM_WHITELIST_ONLY_AND_CONN_REQ_FROM_ANY;
    g_pattern_param.adv_param.Advertising_Interval_Max[0] =  HCI_CMD_PARAM_ADVERTISING_INTERVAL_MIN & 0x00ff;
    g_pattern_param.adv_param.Advertising_Interval_Max[1] = (HCI_CMD_PARAM_ADVERTISING_INTERVAL_MIN & 0xff00) >> 8;
    g_pattern_param.adv_param.Advertising_Interval_Min[0] =  HCI_CMD_PARAM_ADVERTISING_INTERVAL_MIN & 0x00ff;
    g_pattern_param.adv_param.Advertising_Interval_Min[1] = (HCI_CMD_PARAM_ADVERTISING_INTERVAL_MIN & 0xff00) >> 8;
    verdict=COMM_ADV_Discoverable_Advertising(dut2_fd,g_pattern_param);
    VERDICT_RESULT_WITH_LINE();

    read_le_event_enable();

    printf("****timer for 30sec****\n" );
    
    while(1) {//waiting adv report event , timer or counter  
        if(1 == read_le_event_get()) {
        // start the scanning time :30 sec
            event_query_timer_config(query_time, 0, 0, 0, &timer);
            event_query_timer_start(timer, read_le_event_disable);
            
            while(read_le_event_get()) {
                // # p4 :Lower Tester sends a SCAN_REQ packet on the selected advertising channel 
                //after receiving an ADV_DISCOVER_IND packet from IUT on the advertising 
                //channel configured in Step 3. The SCAN_REQ is sent T_IFS after the end of an 
                //ADV_IND packet. 

                MSLEEP(10);
                
                if(SUCCESS != QUERY_LE_Event(dut1_fd, buf, _BT_HCI_LE_EVENT_SUB_OP_ADVERTISING_REPORT_, HCI_SUBEVENT_ADV_RPT_EVENT_SCAN_IND))
                {               
                    
                    
                    continue;
                } 
                else if(EQUAL != hci_le_event_advertising_report_parsing(HCI_SUBEVENT_ADV_RPT_EVENT_SCAN_IND, buf,g_pattern_param))
                {
                    
                    continue;
                }
                else {

                    if (ch == 37){
                        adv_cnt_37++; 
                    }
                    
                    if (ch == 38){
                        adv_cnt_38++; 
                    }
                    
                    if (ch == 39){
                        adv_cnt_39++; 
                    }                    

                    printf("****LOOP 8 adv ch %d | adv cnt %d %d %d ****\n" ,ch , adv_cnt_37 , adv_cnt_38 , adv_cnt_39);

                }

                // # p5 : Lower Tester expects a SCAN_RSP packet from the IUT T_IFS after the end of the SCAN_REQ packet.  
                if (SUCCESS != QUERY_LE_Event(dut1_fd, buf, _BT_HCI_LE_EVENT_SUB_OP_ADVERTISING_REPORT_, HCI_SUBEVENT_ADV_RPT_EVENT_SCAN_RSP)) {
                    continue;
                    
                    
                }            
                else if(EQUAL != hci_le_event_advertising_report_parsing(HCI_SUBEVENT_ADV_RPT_EVENT_SCAN_RSP, buf, g_pattern_param)) {
                    continue;
                }
                else {
                    
                    if (ch == 37){
                        scn_rsp_37++; 
                    }
                    
                    if (ch == 38){
                        scn_rsp_38++; 
                    }
                    
                    if (ch == 39){
                        scn_rsp_39++; 
                    }                    

                    printf("****LOOP 8 adv ch %d | scn cnt %d %d %d ****\n" ,ch , scn_rsp_37 , scn_rsp_38 , scn_rsp_39);
                }
 
            }

            dut_reset_with_mask_en(dut1_fd);
            dut_reset_with_mask_en(dut2_fd);
            sleep(1);


            if(ch != 39){
                goto LOOP8;
            }

            // # p6 Repeat steps 4-5 30 times. 
            if((adv_cnt_37 < 30) || (adv_cnt_38 < 30) || (adv_cnt_39 < 30) || \
                (scn_rsp_37 > 0) || (scn_rsp_38 > 0) || (scn_rsp_39 > 0) ){
                line = __LINE__;
                goto FUN_FAIL;
            }    

            break;
        }
    }

    ch = 36; // default
    adv_cnt_37 = 0;
    adv_cnt_38 = 0;
    adv_cnt_39 = 0;

    scn_rsp_37 = 0;
    scn_rsp_38 = 0;
    scn_rsp_39 = 0;
        
LOOP9: //policy = 0 , dev_addr =diff both id ,scan data = 0     
    ch ++ ;

    COMM_Static_Random_Device_Address_Set_Config(dut1_error_both);
    COMM_Device_Address_Set(dut1_fd,g_pattern_param);

    COMM_INI_Connection_Setup_White_Listed_Config(dut1, &g_pattern_param);
    memcpy(g_pattern_param.white_list_param.Address, adv_addr, ADDR_LENGTH);
    verdict=COMM_INI_Connection_Setup_White_Listed(dut1_fd, g_pattern_param);
    VERDICT_RESULT_WITH_LINE();

    
    // # p1 : Upper Tester sends an HCI_LE_Set_Scan_Response_Data.  
    COMM_Scan_Response_Data_Set_Config(dut2_fd , 0, &g_pattern_param);
    verdict = COMM_Scan_Response_Data_Set(dut2_fd, g_pattern_param);
    VERDICT_RESULT_WITH_LINE();

    // # p2 : Configure Lower Tester to monitor the advertising and scan response packets of the IUT    
    COMM_SCN_Active_Scanning_Config(dut1,&g_pattern_param);
    g_pattern_param.scn_param.Own_Address_Type[0] = HCI_CMD_PARAM_RANDOM_DEVICE_ADDRESS;             
    g_pattern_param.scn_param.LE_Scan_Interval[0] =  0x0160  & 0x00ff;
    g_pattern_param.scn_param.LE_Scan_Interval[1] = (0x0160  & 0xff00) >> 8;
    g_pattern_param.scn_param.LE_Scan_Window[0] =    0x0160  & 0x00ff;
    g_pattern_param.scn_param.LE_Scan_Window[1] =   (0x0160  & 0xff00) >> 8;
    g_pattern_param.scn_param.Scanning_Filter_Policy[0] =   HCI_CMD_PARAM_IGNORE_ADV_PKTS_FROM_DEV_NOT_IN_WHITE_LIST_ONLY;

    verdict = COMM_SCN_Active_Scanning(dut1_fd,g_pattern_param);
    VERDICT_RESULT_WITH_LINE();

    // # p3 : Upper Tester enables discoverable undirected advertising in the IUT using all 
    // supported advertising channels, minimum advertising intervals and filtering policy 
    //set to Allow Scan Request from Any, Allow Connect Request from Any (Default) (0x00)'. 
    COMM_ADV_Discoverable_Advertising_Config(0,&g_pattern_param);

    if (ch == 37){
        g_pattern_param.adv_param.Advertising_Channel_Map[0] =HCI_CMD_PARAM_ENABLE_CHANNEL_37;
    }

    if (ch == 38){
        g_pattern_param.adv_param.Advertising_Channel_Map[0] =HCI_CMD_PARAM_ENABLE_CHANNEL_38;
    }

    if (ch == 39){
        g_pattern_param.adv_param.Advertising_Channel_Map[0] =HCI_CMD_PARAM_ENABLE_CHANNEL_39;
    }
    
    g_pattern_param.adv_param.Advertising_Filter_Policy[0] = HCI_CMD_PARAM_ALLOW_SCAN_REQ_AND_CONN_REQ_FROM_ANY;
    g_pattern_param.adv_param.Advertising_Interval_Max[0] =  HCI_CMD_PARAM_ADVERTISING_INTERVAL_MIN & 0x00ff;
    g_pattern_param.adv_param.Advertising_Interval_Max[1] = (HCI_CMD_PARAM_ADVERTISING_INTERVAL_MIN & 0xff00) >> 8;
    g_pattern_param.adv_param.Advertising_Interval_Min[0] =  HCI_CMD_PARAM_ADVERTISING_INTERVAL_MIN & 0x00ff;
    g_pattern_param.adv_param.Advertising_Interval_Min[1] = (HCI_CMD_PARAM_ADVERTISING_INTERVAL_MIN & 0xff00) >> 8;
    verdict=COMM_ADV_Discoverable_Advertising(dut2_fd,g_pattern_param);
    VERDICT_RESULT_WITH_LINE();

    read_le_event_enable();

    printf("****timer for 30sec****\n" );
    
    while(1) {//waiting adv report event , timer or counter  
        if(1 == read_le_event_get()) {
        // start the scanning time :30 sec
            event_query_timer_config(query_time, 0, 0, 0, &timer);
            event_query_timer_start(timer, read_le_event_disable);
            
            while(read_le_event_get()) {
                // # p4 :Lower Tester sends a SCAN_REQ packet on the selected advertising channel 
                //after receiving an ADV_DISCOVER_IND packet from IUT on the advertising 
                //channel configured in Step 3. The SCAN_REQ is sent T_IFS after the end of an 
                //ADV_IND packet. 

                MSLEEP(10);
                
                if(SUCCESS != QUERY_LE_Event(dut1_fd, buf, _BT_HCI_LE_EVENT_SUB_OP_ADVERTISING_REPORT_, HCI_SUBEVENT_ADV_RPT_EVENT_SCAN_IND))
                {               
                    
                    
                    continue;
                } 
                else if(EQUAL != hci_le_event_advertising_report_parsing(HCI_SUBEVENT_ADV_RPT_EVENT_SCAN_IND, buf,g_pattern_param))
                {
                    
                    continue;
                }
                else {

                    if (ch == 37){
                        adv_cnt_37++; 
                    }
                    
                    if (ch == 38){
                        adv_cnt_38++; 
                    }
                    
                    if (ch == 39){
                        adv_cnt_39++; 
                    }                    

                    printf("****LOOP 9 adv ch %d | adv cnt %d %d %d ****\n" ,ch , adv_cnt_37 , adv_cnt_38 , adv_cnt_39);

                }

                // # p5 : Lower Tester expects a SCAN_RSP packet from the IUT T_IFS after the end of the SCAN_REQ packet.  
                if (SUCCESS != QUERY_LE_Event(dut1_fd, buf, _BT_HCI_LE_EVENT_SUB_OP_ADVERTISING_REPORT_, HCI_SUBEVENT_ADV_RPT_EVENT_SCAN_RSP)) {
                    continue;
                    
                    
                }            
                else if(EQUAL != hci_le_event_advertising_report_parsing(HCI_SUBEVENT_ADV_RPT_EVENT_SCAN_RSP, buf, g_pattern_param)) {
                    continue;
                }
                else {
                    if (ch == 37){
                        scn_rsp_37++; 
                    }
                    
                    if (ch == 38){
                        scn_rsp_38++; 
                    }
                    
                    if (ch == 39){
                        scn_rsp_39++; 
                    }                    

                    printf("****LOOP 9 adv ch %d | scn cnt %d %d %d ****\n" ,ch , scn_rsp_37 , scn_rsp_38 , scn_rsp_39);

                }
 
            }

            dut_reset_with_mask_en(dut1_fd);
            dut_reset_with_mask_en(dut2_fd);
            sleep(1);


            if(ch != 39){
                goto LOOP9;
            }

            // # p6 Repeat steps 4-5 30 times. 
            if((adv_cnt_37 < 30) || (adv_cnt_38 < 30) || (adv_cnt_39 < 30) || \
               (scn_rsp_37 < 30) || (scn_rsp_38 < 30) || (scn_rsp_39 < 30) ){
                line = __LINE__;
                goto FUN_FAIL;
            }   

            break;
        }
    }


    ch = 36; // default
    adv_cnt_37 = 0;
    adv_cnt_38 = 0;
    adv_cnt_39 = 0;

    scn_rsp_37 = 0;
    scn_rsp_38 = 0;
    scn_rsp_39 = 0;
            
LOOP10: //policy = 1 , dev_addr =diff both id ,scan data = 0   
    ch ++ ;

    COMM_Static_Random_Device_Address_Set_Config(dut1_error_both);
    COMM_Device_Address_Set(dut1_fd,g_pattern_param);

    COMM_INI_Connection_Setup_White_Listed_Config(dut1, &g_pattern_param);
    memcpy(g_pattern_param.white_list_param.Address, adv_addr, ADDR_LENGTH);
    verdict=COMM_INI_Connection_Setup_White_Listed(dut1_fd, g_pattern_param);
    VERDICT_RESULT_WITH_LINE();
    
    // # p1 : Upper Tester sends an HCI_LE_Set_Scan_Response_Data.  
    COMM_Scan_Response_Data_Set_Config(dut2_fd , 0, &g_pattern_param);
    verdict = COMM_Scan_Response_Data_Set(dut2_fd, g_pattern_param);
    VERDICT_RESULT_WITH_LINE();

    // # p2 : Configure Lower Tester to monitor the advertising and scan response packets of the IUT    
    COMM_SCN_Active_Scanning_Config(dut1,&g_pattern_param);
    g_pattern_param.scn_param.Own_Address_Type[0] = HCI_CMD_PARAM_RANDOM_DEVICE_ADDRESS;             
    g_pattern_param.scn_param.LE_Scan_Interval[0] =  0x0160  & 0x00ff;
    g_pattern_param.scn_param.LE_Scan_Interval[1] = (0x0160  & 0xff00) >> 8;
    g_pattern_param.scn_param.LE_Scan_Window[0] =    0x0160  & 0x00ff;
    g_pattern_param.scn_param.LE_Scan_Window[1] =   (0x0160  & 0xff00) >> 8;
    g_pattern_param.scn_param.Scanning_Filter_Policy[0] =   HCI_CMD_PARAM_IGNORE_ADV_PKTS_FROM_DEV_NOT_IN_WHITE_LIST_ONLY;
    
    verdict = COMM_SCN_Active_Scanning(dut1_fd,g_pattern_param);
    VERDICT_RESULT_WITH_LINE();

    // # p3 : Upper Tester enables discoverable undirected advertising in the IUT using all 
    // supported advertising channels, minimum advertising intervals and filtering policy 
    //set to Allow Scan Request from Any, Allow Connect Request from Any (Default) (0x00)'. 
    COMM_ADV_Discoverable_Advertising_Config(0,&g_pattern_param);

    if (ch == 37){
        g_pattern_param.adv_param.Advertising_Channel_Map[0] =HCI_CMD_PARAM_ENABLE_CHANNEL_37;
    }

    if (ch == 38){
        g_pattern_param.adv_param.Advertising_Channel_Map[0] =HCI_CMD_PARAM_ENABLE_CHANNEL_38;
    }

    if (ch == 39){
        g_pattern_param.adv_param.Advertising_Channel_Map[0] =HCI_CMD_PARAM_ENABLE_CHANNEL_39;
    }
    
    g_pattern_param.adv_param.Advertising_Filter_Policy[0] = HCI_CMD_PARAM_ALLOW_SCAN_REQ_FROM_WHITELIST_ONLY_AND_CONN_REQ_FROM_ANY;
    g_pattern_param.adv_param.Advertising_Interval_Max[0] =  HCI_CMD_PARAM_ADVERTISING_INTERVAL_MIN & 0x00ff;
    g_pattern_param.adv_param.Advertising_Interval_Max[1] = (HCI_CMD_PARAM_ADVERTISING_INTERVAL_MIN & 0xff00) >> 8;
    g_pattern_param.adv_param.Advertising_Interval_Min[0] =  HCI_CMD_PARAM_ADVERTISING_INTERVAL_MIN & 0x00ff;
    g_pattern_param.adv_param.Advertising_Interval_Min[1] = (HCI_CMD_PARAM_ADVERTISING_INTERVAL_MIN & 0xff00) >> 8;
    verdict=COMM_ADV_Discoverable_Advertising(dut2_fd,g_pattern_param);
    VERDICT_RESULT_WITH_LINE();

    read_le_event_enable();

    printf("****timer for 30sec****\n" );
    
    while(1) {//waiting adv report event , timer or counter  
        if(1 == read_le_event_get()) {
        // start the scanning time :30 sec
            event_query_timer_config(query_time, 0, 0, 0, &timer);
            event_query_timer_start(timer, read_le_event_disable);
            
            while(read_le_event_get()) {
                // # p4 :Lower Tester sends a SCAN_REQ packet on the selected advertising channel 
                //after receiving an ADV_DISCOVER_IND packet from IUT on the advertising 
                //channel configured in Step 3. The SCAN_REQ is sent T_IFS after the end of an 
                //ADV_IND packet. 

                MSLEEP(10);
                
                if(SUCCESS != QUERY_LE_Event(dut1_fd, buf, _BT_HCI_LE_EVENT_SUB_OP_ADVERTISING_REPORT_, HCI_SUBEVENT_ADV_RPT_EVENT_SCAN_IND))
                {               
                    
                    
                    continue;
                } 
                else if(EQUAL != hci_le_event_advertising_report_parsing(HCI_SUBEVENT_ADV_RPT_EVENT_SCAN_IND, buf,g_pattern_param))
                {
                    
                    continue;
                }
                else {

                    if (ch == 37){
                        adv_cnt_37++; 
                    }
                    
                    if (ch == 38){
                        adv_cnt_38++; 
                    }
                    
                    if (ch == 39){
                        adv_cnt_39++; 
                    }                    

                    printf("****LOOP 10 adv ch %d | adv cnt %d %d %d ****\n" ,ch , adv_cnt_37 , adv_cnt_38 , adv_cnt_39);

                }

                // # p5 : Lower Tester expects a SCAN_RSP packet from the IUT T_IFS after the end of the SCAN_REQ packet.  
                if (SUCCESS != QUERY_LE_Event(dut1_fd, buf, _BT_HCI_LE_EVENT_SUB_OP_ADVERTISING_REPORT_, HCI_SUBEVENT_ADV_RPT_EVENT_SCAN_RSP)) {
                    continue;
                    
                    
                }            
                else if(EQUAL != hci_le_event_advertising_report_parsing(HCI_SUBEVENT_ADV_RPT_EVENT_SCAN_RSP, buf, g_pattern_param)) {
                    continue;
                }
                else {
                    
                    if (ch == 37){
                        scn_rsp_37++; 
                    }
                    
                    if (ch == 38){
                        scn_rsp_38++; 
                    }
                    
                    if (ch == 39){
                        scn_rsp_39++; 
                    }                    

                    printf("****LOOP 10 adv ch %d | scn cnt %d %d %d ****\n" ,ch , scn_rsp_37 , scn_rsp_38 , scn_rsp_39);

                }
 
            }

            dut_reset_with_mask_en(dut1_fd);
            dut_reset_with_mask_en(dut2_fd);
            sleep(1);


            if(ch != 39){
                goto LOOP10;
            }

            // # p6 Repeat steps 4-5 30 times. 
            if((adv_cnt_37 < 30) || (adv_cnt_38 < 30) || (adv_cnt_39 < 30) || \
                (scn_rsp_37 > 0) || (scn_rsp_38 > 0) || (scn_rsp_39 > 0) ){
                line = __LINE__;
                goto FUN_FAIL;
            }   


            break;
        }
    }

    ch = 36; // default
    adv_cnt_37 = 0;
    adv_cnt_38 = 0;
    adv_cnt_39 = 0;

    scn_rsp_37 = 0;
    scn_rsp_38 = 0;
    scn_rsp_39 = 0;

LOOP11: //policy = 0 , dev_addr =both comp id ,scan data = 31   
    ch ++ ;

    COMM_Static_Random_Device_Address_Set_Config(scan_random_addr);
    COMM_Device_Address_Set(dut1_fd,g_pattern_param);

    COMM_INI_Connection_Setup_White_Listed_Config(dut1, &g_pattern_param);
    memcpy(g_pattern_param.white_list_param.Address, adv_addr, ADDR_LENGTH);
    verdict=COMM_INI_Connection_Setup_White_Listed(dut1_fd, g_pattern_param);
    VERDICT_RESULT_WITH_LINE();

    
    // # p1 : Upper Tester sends an HCI_LE_Set_Scan_Response_Data.  
    COMM_Scan_Response_Data_Set_Config(dut2_fd , 31, &g_pattern_param);
    verdict = COMM_Scan_Response_Data_Set(dut2_fd, g_pattern_param);
    VERDICT_RESULT_WITH_LINE();

    // # p2 : Configure Lower Tester to monitor the advertising and scan response packets of the IUT    
    COMM_SCN_Active_Scanning_Config(dut1,&g_pattern_param);
    g_pattern_param.scn_param.Own_Address_Type[0] = HCI_CMD_PARAM_RANDOM_DEVICE_ADDRESS;             
    g_pattern_param.scn_param.LE_Scan_Interval[0] =  0x0160  & 0x00ff;
    g_pattern_param.scn_param.LE_Scan_Interval[1] = (0x0160  & 0xff00) >> 8;
    g_pattern_param.scn_param.LE_Scan_Window[0] =    0x0160  & 0x00ff;
    g_pattern_param.scn_param.LE_Scan_Window[1] =   (0x0160  & 0xff00) >> 8;
    g_pattern_param.scn_param.Scanning_Filter_Policy[0] =   HCI_CMD_PARAM_IGNORE_ADV_PKTS_FROM_DEV_NOT_IN_WHITE_LIST_ONLY;

    verdict = COMM_SCN_Active_Scanning(dut1_fd,g_pattern_param);
    VERDICT_RESULT_WITH_LINE();

    // # p3 : Upper Tester enables discoverable undirected advertising in the IUT using all 
    // supported advertising channels, minimum advertising intervals and filtering policy 
    //set to Allow Scan Request from Any, Allow Connect Request from Any (Default) (0x00)'. 
    COMM_ADV_Discoverable_Advertising_Config(0,&g_pattern_param);

    if (ch == 37){
        g_pattern_param.adv_param.Advertising_Channel_Map[0] =HCI_CMD_PARAM_ENABLE_CHANNEL_37;
    }

    if (ch == 38){
        g_pattern_param.adv_param.Advertising_Channel_Map[0] =HCI_CMD_PARAM_ENABLE_CHANNEL_38;
    }

    if (ch == 39){
        g_pattern_param.adv_param.Advertising_Channel_Map[0] =HCI_CMD_PARAM_ENABLE_CHANNEL_39;
    }
    
    g_pattern_param.adv_param.Advertising_Filter_Policy[0] = HCI_CMD_PARAM_ALLOW_SCAN_REQ_AND_CONN_REQ_FROM_ANY;
    g_pattern_param.adv_param.Advertising_Interval_Max[0] =  HCI_CMD_PARAM_ADVERTISING_INTERVAL_MIN & 0x00ff;
    g_pattern_param.adv_param.Advertising_Interval_Max[1] = (HCI_CMD_PARAM_ADVERTISING_INTERVAL_MIN & 0xff00) >> 8;
    g_pattern_param.adv_param.Advertising_Interval_Min[0] =  HCI_CMD_PARAM_ADVERTISING_INTERVAL_MIN & 0x00ff;
    g_pattern_param.adv_param.Advertising_Interval_Min[1] = (HCI_CMD_PARAM_ADVERTISING_INTERVAL_MIN & 0xff00) >> 8;
    verdict=COMM_ADV_Discoverable_Advertising(dut2_fd,g_pattern_param);
    VERDICT_RESULT_WITH_LINE();

    read_le_event_enable();

    printf("****timer for 30sec****\n" );
    
    while(1) {//waiting adv report event , timer or counter  
        if(1 == read_le_event_get()) {
        // start the scanning time :30 sec
            event_query_timer_config(query_time, 0, 0, 0, &timer);
            event_query_timer_start(timer, read_le_event_disable);
            
            while(read_le_event_get()) {
                // # p4 :Lower Tester sends a SCAN_REQ packet on the selected advertising channel 
                //after receiving an ADV_DISCOVER_IND packet from IUT on the advertising 
                //channel configured in Step 3. The SCAN_REQ is sent T_IFS after the end of an 
                //ADV_IND packet. 

                MSLEEP(10);
                
                if(SUCCESS != QUERY_LE_Event(dut1_fd, buf, _BT_HCI_LE_EVENT_SUB_OP_ADVERTISING_REPORT_, HCI_SUBEVENT_ADV_RPT_EVENT_SCAN_IND))
                {               
                    
                    
                    continue;
                } 
                else if(EQUAL != hci_le_event_advertising_report_parsing(HCI_SUBEVENT_ADV_RPT_EVENT_SCAN_IND, buf,g_pattern_param))
                {
                    
                    continue;
                }
                else {
                    if (ch == 37){
                        adv_cnt_37++; 
                    }
                    
                    if (ch == 38){
                        adv_cnt_38++; 
                    }
                    
                    if (ch == 39){
                        adv_cnt_39++; 
                    }                    

                    printf("****LOOP 11 adv ch %d | adv cnt %d %d %d ****\n" ,ch , adv_cnt_37 , adv_cnt_38 , adv_cnt_39);

                }

                // # p5 : Lower Tester expects a SCAN_RSP packet from the IUT T_IFS after the end of the SCAN_REQ packet.  
                if (SUCCESS != QUERY_LE_Event(dut1_fd, buf, _BT_HCI_LE_EVENT_SUB_OP_ADVERTISING_REPORT_, HCI_SUBEVENT_ADV_RPT_EVENT_SCAN_RSP)) {
                    continue;
                    
                    
                }            
                else if(EQUAL != hci_le_event_advertising_report_parsing(HCI_SUBEVENT_ADV_RPT_EVENT_SCAN_RSP, buf, g_pattern_param)) {
                    continue;
                }
                else {
                    
                    if (ch == 37){
                        scn_rsp_37++; 
                    }
                    
                    if (ch == 38){
                        scn_rsp_38++; 
                    }
                    
                    if (ch == 39){
                        scn_rsp_39++; 
                    }                    

                    printf("****LOOP 11 adv ch %d | scn cnt %d %d %d ****\n" ,ch , scn_rsp_37 , scn_rsp_38 , scn_rsp_39);

                }
 
            }

            dut_reset_with_mask_en(dut1_fd);
            dut_reset_with_mask_en(dut2_fd);
            sleep(1);


            if(ch != 39){
                goto LOOP11;
            }

            // # p6 Repeat steps 4-5 30 times. 
            if((adv_cnt_37 < 30) || (adv_cnt_38 < 30) || (adv_cnt_39 < 30) || \
               (scn_rsp_37 < 30) || (scn_rsp_38 < 30) || (scn_rsp_39 < 30) ){
                line = __LINE__;
                goto FUN_FAIL;
            }   

            break;
        }
    }


    ch = 36; // default
    adv_cnt_37 = 0;
    adv_cnt_38 = 0;
    adv_cnt_39 = 0;

    scn_rsp_37 = 0;
    scn_rsp_38 = 0;
    scn_rsp_39 = 0;

LOOP12: //policy = 1 , dev_addr =diff both id ,scan data = 31   
    ch ++ ;

    COMM_Static_Random_Device_Address_Set_Config(dut1_error_both);
    COMM_Device_Address_Set(dut1_fd,g_pattern_param);

    COMM_INI_Connection_Setup_White_Listed_Config(dut1, &g_pattern_param);
    memcpy(g_pattern_param.white_list_param.Address, adv_addr, ADDR_LENGTH);
    verdict=COMM_INI_Connection_Setup_White_Listed(dut1_fd, g_pattern_param);
    VERDICT_RESULT_WITH_LINE();

    
    // # p1 : Upper Tester sends an HCI_LE_Set_Scan_Response_Data.  
    COMM_Scan_Response_Data_Set_Config(dut2_fd , 31, &g_pattern_param);
    verdict = COMM_Scan_Response_Data_Set(dut2_fd, g_pattern_param);
    VERDICT_RESULT_WITH_LINE();
    
    // # p2 : Configure Lower Tester to monitor the advertising and scan response packets of the IUT    
    COMM_SCN_Active_Scanning_Config(dut1,&g_pattern_param);
    g_pattern_param.scn_param.Own_Address_Type[0] = HCI_CMD_PARAM_RANDOM_DEVICE_ADDRESS;             
    g_pattern_param.scn_param.LE_Scan_Interval[0] =  0x0160  & 0x00ff;
    g_pattern_param.scn_param.LE_Scan_Interval[1] = (0x0160  & 0xff00) >> 8;
    g_pattern_param.scn_param.LE_Scan_Window[0] =    0x0160  & 0x00ff;
    g_pattern_param.scn_param.LE_Scan_Window[1] =   (0x0160  & 0xff00) >> 8;
    g_pattern_param.scn_param.Scanning_Filter_Policy[0] =   HCI_CMD_PARAM_IGNORE_ADV_PKTS_FROM_DEV_NOT_IN_WHITE_LIST_ONLY;
    
    verdict = COMM_SCN_Active_Scanning(dut1_fd,g_pattern_param);
    VERDICT_RESULT_WITH_LINE();

    // # p3 : Upper Tester enables discoverable undirected advertising in the IUT using all 
    // supported advertising channels, minimum advertising intervals and filtering policy 
    //set to Allow Scan Request from Any, Allow Connect Request from Any (Default) (0x00)'. 
    COMM_ADV_Discoverable_Advertising_Config(0,&g_pattern_param);

    if (ch == 37){
        g_pattern_param.adv_param.Advertising_Channel_Map[0] =HCI_CMD_PARAM_ENABLE_CHANNEL_37;
    }

    if (ch == 38){
        g_pattern_param.adv_param.Advertising_Channel_Map[0] =HCI_CMD_PARAM_ENABLE_CHANNEL_38;
    }

    if (ch == 39){
        g_pattern_param.adv_param.Advertising_Channel_Map[0] =HCI_CMD_PARAM_ENABLE_CHANNEL_39;
    }
    
    g_pattern_param.adv_param.Advertising_Filter_Policy[0] = HCI_CMD_PARAM_ALLOW_SCAN_REQ_FROM_WHITELIST_ONLY_AND_CONN_REQ_FROM_ANY;
    g_pattern_param.adv_param.Advertising_Interval_Max[0] =  HCI_CMD_PARAM_ADVERTISING_INTERVAL_MIN & 0x00ff;
    g_pattern_param.adv_param.Advertising_Interval_Max[1] = (HCI_CMD_PARAM_ADVERTISING_INTERVAL_MIN & 0xff00) >> 8;
    g_pattern_param.adv_param.Advertising_Interval_Min[0] =  HCI_CMD_PARAM_ADVERTISING_INTERVAL_MIN & 0x00ff;
    g_pattern_param.adv_param.Advertising_Interval_Min[1] = (HCI_CMD_PARAM_ADVERTISING_INTERVAL_MIN & 0xff00) >> 8;
    verdict=COMM_ADV_Discoverable_Advertising(dut2_fd,g_pattern_param);
    VERDICT_RESULT_WITH_LINE();

    read_le_event_enable();

    printf("****timer for 30sec****\n" );
    
    while(1) {//waiting adv report event , timer or counter  
        if(1 == read_le_event_get()) {
        // start the scanning time :30 sec
            event_query_timer_config(query_time, 0, 0, 0, &timer);
            event_query_timer_start(timer, read_le_event_disable);
            
            while(read_le_event_get()) {
                // # p4 :Lower Tester sends a SCAN_REQ packet on the selected advertising channel 
                //after receiving an ADV_DISCOVER_IND packet from IUT on the advertising 
                //channel configured in Step 3. The SCAN_REQ is sent T_IFS after the end of an 
                //ADV_IND packet. 

                MSLEEP(10);
                
                if(SUCCESS != QUERY_LE_Event(dut1_fd, buf, _BT_HCI_LE_EVENT_SUB_OP_ADVERTISING_REPORT_, HCI_SUBEVENT_ADV_RPT_EVENT_SCAN_IND))
                {               
                    
                    
                    continue;
                } 
                else if(EQUAL != hci_le_event_advertising_report_parsing(HCI_SUBEVENT_ADV_RPT_EVENT_SCAN_IND, buf,g_pattern_param))
                {
                    
                    continue;
                }
                else {

                    if (ch == 37){
                        adv_cnt_37++; 
                    }
                    
                    if (ch == 38){
                        adv_cnt_38++; 
                    }
                    
                    if (ch == 39){
                        adv_cnt_39++; 
                    }                    

                    printf("****LOOP 12 adv ch %d | adv cnt %d %d %d ****\n" ,ch , adv_cnt_37 , adv_cnt_38 , adv_cnt_39);

                }

                // # p5 : Lower Tester expects a SCAN_RSP packet from the IUT T_IFS after the end of the SCAN_REQ packet.  
                if (SUCCESS != QUERY_LE_Event(dut1_fd, buf, _BT_HCI_LE_EVENT_SUB_OP_ADVERTISING_REPORT_, HCI_SUBEVENT_ADV_RPT_EVENT_SCAN_RSP)) {
                    continue;
                    
                    
                }            
                else if(EQUAL != hci_le_event_advertising_report_parsing(HCI_SUBEVENT_ADV_RPT_EVENT_SCAN_RSP, buf, g_pattern_param)) {
                    continue;
                }
                else {
                    
                    if (ch == 37){
                        scn_rsp_37++; 
                    }
                    
                    if (ch == 38){
                        scn_rsp_38++; 
                    }
                    
                    if (ch == 39){
                        scn_rsp_39++; 
                    }                    

                    printf("****LOOP 12 adv ch %d | scn cnt %d %d %d ****\n" ,ch , scn_rsp_37 , scn_rsp_38 , scn_rsp_39);
                }
 
            }

            dut_reset_with_mask_en(dut1_fd);
            dut_reset_with_mask_en(dut2_fd);
            sleep(1);


            if(ch != 39){
                goto LOOP12;
            }

            // # p6 Repeat steps 4-5 30 times. 
            if((adv_cnt_37 < 30) || (adv_cnt_38 < 30) || (adv_cnt_39 < 30) || \
                (scn_rsp_37 > 0) || (scn_rsp_38 > 0) || (scn_rsp_39 > 0) ){
                line = __LINE__;
                goto FUN_FAIL;
            }    

            break;
        }
    }



    // ========
    // # finish
    FUNC_END();


    // the ideal value : 30(s) / 30(ms) = 1000
    LOG_INFO("[Pattern][%s]SUCCESS\n" , __FUNCTION__);    
    LOG_INFO("adv cnt 37 =%d \n" , adv_cnt_37);
    LOG_INFO("adv cnt 38 =%d \n" , adv_cnt_38);
    LOG_INFO("adv cnt 39 =%d \n" , adv_cnt_39);
    LOG_INFO("scn rsp 37 =%d \n" , scn_rsp_37);
    LOG_INFO("scn rsp 38 =%d \n" , scn_rsp_38);
    LOG_INFO("scn rsp 39 =%d \n" , scn_rsp_39);
    return PASS;
    
FUN_FAIL:
    FUNC_END();

	LOG_INFO("[Pattern][%s]FAIL :%d\n" ,__FUNCTION__ , line);
    LOG_INFO("adv cnt 37 =%d \n" , adv_cnt_37);
    LOG_INFO("adv cnt 38 =%d \n" , adv_cnt_38);
    LOG_INFO("adv cnt 39 =%d \n" , adv_cnt_39);
    LOG_INFO("scn rsp 37 =%d \n" , scn_rsp_37);
    LOG_INFO("scn rsp 38 =%d \n" , scn_rsp_38);
    LOG_INFO("scn rsp 39 =%d \n" , scn_rsp_39);
    return FAIL;
}

// 5.2.1.14
verdict DDI_ADV_Device_Filtering_Discoverable(u8 dut1_fd ,u8 dut2_fd)
{        
	u8 buf[SOCKET_BUF_SIZE];
    int adv_Channel = 37;
	int verdict = FAIL;
	int dut1 = 0, dut2 = 0;
    int check_cnt = 0;
    int err_cnt = 0;
    u16 line = 0;	
	struct itimerval timer;
	u32 adv_cnt = 1;	

    COMM_Dut_clean_buffer(dut1_fd);
    COMM_Dut_clean_buffer(dut2_fd);

    Calculate_Execution_Time_Start();
REPEAT:
    check_cnt = 0;
	LOG_INFO("###run case %d###\n", adv_cnt);

    //# ignore case 1 and 7
    if((adv_cnt == 1) || (adv_cnt == 7)){
        adv_cnt ++;
    }
    
	switch (adv_cnt)
	{
		case 1:			
			// Uptest   : addr_type = public 
			// Lwtest   : addr_type = public, addr error(black); 
			// IUT      : undirected advertising, filter policy = 0x03
			// ***********************************************************************************
			// Uptest(white list) config
			COMM_INI_Connection_Setup_White_Listed_Config(dut1, &g_pattern_param);
			memcpy(g_pattern_param.white_list_param.Address, adv_addr, ADDR_LENGTH);
            g_pattern_param.white_list_param.Address_Type[0] = HCI_CMD_PARAM_PUBLIC_DEVICE_ADDRESS;
			verdict = COMM_INI_Connection_Setup_White_Listed(dut1_fd, g_pattern_param);
			VERDICT_RESULT_WITH_LINE();
			
			COMM_INI_Connection_Setup_White_Listed_Config(dut2, &g_pattern_param);
			memcpy(g_pattern_param.white_list_param.Address, scan_addr, ADDR_LENGTH);
            g_pattern_param.white_list_param.Address_Type[0] = HCI_CMD_PARAM_PUBLIC_DEVICE_ADDRESS;
			verdict = COMM_INI_Connection_Setup_White_Listed(dut2_fd, g_pattern_param);
			VERDICT_RESULT_WITH_LINE();
            
            // ***********************************************************************************            
            // Lwtest(SCN) config
            COMM_Static_Random_Device_Address_Set_Config(error_addr);
			COMM_Device_Address_Set(dut1_fd, g_pattern_param);
            COMM_SCN_Active_Scanning_Config(dut1, &g_pattern_param);            
            g_pattern_param.scn_param.Own_Address_Type[0] = HCI_CMD_PARAM_RANDOM_DEVICE_ADDRESS;             
            g_pattern_param.scn_param.Scanning_Filter_Policy[0] =	HCI_CMD_PARAM_IGNORE_ADV_PKTS_FROM_DEV_NOT_IN_WHITE_LIST_ONLY;
            g_pattern_param.scn_param.LE_Scan_Interval[0] = 0x0500 & 0x00ff;
	        g_pattern_param.scn_param.LE_Scan_Interval[1] =(0x0500 & 0xff00) >> 8;
	        g_pattern_param.scn_param.LE_Scan_Window[0] =	0x0500 & 0x00ff;
	        g_pattern_param.scn_param.LE_Scan_Window[1] =  (0x0500 & 0xff00) >> 8;
            g_pattern_param.scn_param.Scanning_Filter_Policy[0] =   HCI_CMD_PARAM_IGNORE_ADV_PKTS_FROM_DEV_NOT_IN_WHITE_LIST_ONLY;

			verdict = COMM_SCN_Active_Scanning(dut1_fd, g_pattern_param);            
			VERDICT_RESULT_WITH_LINE();
            
            // ***********************************************************************************            
            // IUT(ADV) config
            COMM_ADV_Undirected_Advertising_Config(HCI_CMD_PARAM_ADV_DATA_LEN_MAX, &g_pattern_param);            
            if(37 == adv_Channel) {
                g_pattern_param.adv_param.Advertising_Channel_Map[0] = HCI_CMD_PARAM_ENABLE_CHANNEL_37;
            }
            else if(38 == adv_Channel) {
                g_pattern_param.adv_param.Advertising_Channel_Map[0] = HCI_CMD_PARAM_ENABLE_CHANNEL_38;
            }
            else {
                g_pattern_param.adv_param.Advertising_Channel_Map[0] = HCI_CMD_PARAM_ENABLE_CHANNEL_39;
            }
			g_pattern_param.adv_param.Advertising_Filter_Policy[0] = HCI_CMD_PARAM_ALLOW_SCAN_REQ_FROM_WHITELIST_ONLY_AND_CONN_REQ_FROM_WHITELIST_ONLY;
            g_pattern_param.adv_param.Advertising_Interval_Max[0] =  HCI_CMD_PARAM_ADVERTISING_INTERVAL_MIN & 0x00ff;
	        g_pattern_param.adv_param.Advertising_Interval_Max[1] = (HCI_CMD_PARAM_ADVERTISING_INTERVAL_MIN & 0xff00) >> 8;
	        g_pattern_param.adv_param.Advertising_Interval_Min[0] =  HCI_CMD_PARAM_ADVERTISING_INTERVAL_MIN & 0x00ff;
	        g_pattern_param.adv_param.Advertising_Interval_Min[1] = (HCI_CMD_PARAM_ADVERTISING_INTERVAL_MIN & 0xff00) >> 8;
            verdict = COMM_ADV_Undirected_Advertising(dut2_fd, g_pattern_param);
			VERDICT_RESULT_WITH_LINE();
		break;

		case 2:			

			// Uptest   : addr_type = public 
			// Lwtest   : addr_type = random
			// IUT      : undirected advertising, filter policy = 0x03
			// ***********************************************************************************
            // Uptest(white list) config
            COMM_INI_Connection_Setup_White_Listed_Config(dut1, &g_pattern_param);
			memcpy(g_pattern_param.white_list_param.Address, adv_addr, ADDR_LENGTH);
            g_pattern_param.white_list_param.Address_Type[0] = HCI_CMD_PARAM_PUBLIC_DEVICE_ADDRESS;
			verdict = COMM_INI_Connection_Setup_White_Listed(dut1_fd, g_pattern_param);
			VERDICT_RESULT_WITH_LINE();
            
            COMM_INI_Connection_Setup_White_Listed_Config(dut2, &g_pattern_param);
			memcpy(g_pattern_param.white_list_param.Address, scan_addr, ADDR_LENGTH);
            g_pattern_param.white_list_param.Address_Type[0] = HCI_CMD_PARAM_PUBLIC_DEVICE_ADDRESS;
			verdict = COMM_INI_Connection_Setup_White_Listed(dut2_fd, g_pattern_param);
			VERDICT_RESULT_WITH_LINE();
            
            // ***********************************************************************************            
            // Lwtest(SCN) config
            COMM_SCN_Active_Scanning_Config(dut1, &g_pattern_param);
            COMM_Static_Random_Device_Address_Set_Config(scan_addr);
			COMM_Device_Address_Set(dut1_fd, g_pattern_param);
            g_pattern_param.scn_param.Own_Address_Type[0] = HCI_CMD_PARAM_RANDOM_DEVICE_ADDRESS;             
            g_pattern_param.scn_param.Scanning_Filter_Policy[0] =	HCI_CMD_PARAM_IGNORE_ADV_PKTS_FROM_DEV_NOT_IN_WHITE_LIST_ONLY;
            g_pattern_param.scn_param.LE_Scan_Interval[0] =  0x0500 & 0x00ff;
	        g_pattern_param.scn_param.LE_Scan_Interval[1] = (0x0500 & 0xff00) >> 8;
	        g_pattern_param.scn_param.LE_Scan_Window[0] =	 0x0500 & 0x00ff;
	        g_pattern_param.scn_param.LE_Scan_Window[1] =   (0x0500 & 0xff00) >> 8;
			verdict = COMM_SCN_Active_Scanning(dut1_fd, g_pattern_param);            
			VERDICT_RESULT_WITH_LINE();
            
            // ***********************************************************************************            
            // IUT(ADV) config
            COMM_ADV_Undirected_Advertising_Config(HCI_CMD_PARAM_ADV_DATA_LEN_MAX, &g_pattern_param);
            if(37 == adv_Channel) {
                g_pattern_param.adv_param.Advertising_Channel_Map[0] = HCI_CMD_PARAM_ENABLE_CHANNEL_37;
            }
            else if(38 == adv_Channel) {
                g_pattern_param.adv_param.Advertising_Channel_Map[0] = HCI_CMD_PARAM_ENABLE_CHANNEL_38;
            }
            else {
                g_pattern_param.adv_param.Advertising_Channel_Map[0] = HCI_CMD_PARAM_ENABLE_CHANNEL_39;
            }
			g_pattern_param.adv_param.Advertising_Filter_Policy[0] = HCI_CMD_PARAM_ALLOW_SCAN_REQ_FROM_WHITELIST_ONLY_AND_CONN_REQ_FROM_WHITELIST_ONLY;
            g_pattern_param.adv_param.Advertising_Interval_Max[0] =  HCI_CMD_PARAM_ADVERTISING_INTERVAL_MIN & 0x00ff;
	        g_pattern_param.adv_param.Advertising_Interval_Max[1] = (HCI_CMD_PARAM_ADVERTISING_INTERVAL_MIN & 0xff00) >> 8;
	        g_pattern_param.adv_param.Advertising_Interval_Min[0] =  HCI_CMD_PARAM_ADVERTISING_INTERVAL_MIN & 0x00ff;
	        g_pattern_param.adv_param.Advertising_Interval_Min[1] = (HCI_CMD_PARAM_ADVERTISING_INTERVAL_MIN & 0xff00) >> 8;
            verdict = COMM_ADV_Undirected_Advertising(dut2_fd, g_pattern_param);
			VERDICT_RESULT_WITH_LINE();

		break;

		case 3:			
			// Uptest   : addr_type = public 
			// Lwtest   : addr_type = public
			// IUT      : undirected advertising, filter policy = 0x03
			// ***********************************************************************************
            // Uptest(white list) config
            COMM_INI_Connection_Setup_White_Listed_Config(dut1, &g_pattern_param);
			memcpy(g_pattern_param.white_list_param.Address, adv_addr, ADDR_LENGTH);
            g_pattern_param.white_list_param.Address_Type[0] = HCI_CMD_PARAM_PUBLIC_DEVICE_ADDRESS;
			verdict = COMM_INI_Connection_Setup_White_Listed(dut1_fd, g_pattern_param);
			VERDICT_RESULT_WITH_LINE();

            COMM_INI_Connection_Setup_White_Listed_Config(dut2, &g_pattern_param);
			memcpy(g_pattern_param.white_list_param.Address, scan_addr, ADDR_LENGTH);
            g_pattern_param.white_list_param.Address_Type[0] = HCI_CMD_PARAM_PUBLIC_DEVICE_ADDRESS;
			verdict = COMM_INI_Connection_Setup_White_Listed(dut2_fd, g_pattern_param);
			VERDICT_RESULT_WITH_LINE();
            
            // ***********************************************************************************            
            // Lwtest(SCN) config
            COMM_SCN_Active_Scanning_Config(dut1, &g_pattern_param);
            g_pattern_param.scn_param.Own_Address_Type[0] = HCI_CMD_PARAM_PUBLIC_DEVICE_ADDRESS;     
            g_pattern_param.scn_param.Scanning_Filter_Policy[0] =	HCI_CMD_PARAM_IGNORE_ADV_PKTS_FROM_DEV_NOT_IN_WHITE_LIST_ONLY;
            g_pattern_param.scn_param.LE_Scan_Interval[0] =  0x0500 & 0x00ff;
	        g_pattern_param.scn_param.LE_Scan_Interval[1] = (0x0500 & 0xff00) >> 8;
	        g_pattern_param.scn_param.LE_Scan_Window[0] =	 0x0500 & 0x00ff;
	        g_pattern_param.scn_param.LE_Scan_Window[1] =   (0x0500 & 0xff00) >> 8;
			verdict = COMM_SCN_Active_Scanning(dut1_fd, g_pattern_param);            
			VERDICT_RESULT_WITH_LINE();
            
            // ***********************************************************************************            
            // IUT(ADV) config
            COMM_ADV_Undirected_Advertising_Config(HCI_CMD_PARAM_ADV_DATA_LEN_MAX, &g_pattern_param);
            if(37 == adv_Channel) {
                g_pattern_param.adv_param.Advertising_Channel_Map[0] = HCI_CMD_PARAM_ENABLE_CHANNEL_37;
            }
            else if(38 == adv_Channel) {
                g_pattern_param.adv_param.Advertising_Channel_Map[0] = HCI_CMD_PARAM_ENABLE_CHANNEL_38;
            }
            else {
                g_pattern_param.adv_param.Advertising_Channel_Map[0] = HCI_CMD_PARAM_ENABLE_CHANNEL_39;
            }
			g_pattern_param.adv_param.Advertising_Filter_Policy[0] = HCI_CMD_PARAM_ALLOW_SCAN_REQ_FROM_WHITELIST_ONLY_AND_CONN_REQ_FROM_WHITELIST_ONLY;
            g_pattern_param.adv_param.Advertising_Interval_Max[0] =  HCI_CMD_PARAM_ADVERTISING_INTERVAL_MIN & 0x00ff;
	        g_pattern_param.adv_param.Advertising_Interval_Max[1] = (HCI_CMD_PARAM_ADVERTISING_INTERVAL_MIN & 0xff00) >> 8;
	        g_pattern_param.adv_param.Advertising_Interval_Min[0] =  HCI_CMD_PARAM_ADVERTISING_INTERVAL_MIN & 0x00ff;
	        g_pattern_param.adv_param.Advertising_Interval_Min[1] = (HCI_CMD_PARAM_ADVERTISING_INTERVAL_MIN & 0xff00) >> 8;
            verdict = COMM_ADV_Undirected_Advertising(dut2_fd, g_pattern_param);
			VERDICT_RESULT_WITH_LINE();
		break;
		
		case 4:			
			// Uptest   : addr_type = public 
			// Lwtest   : addr_type = random, addr error(black); 
			// IUT      : undirected advertising, filter policy = 0x03
			// ***********************************************************************************
            // Uptest(white list) config
            COMM_INI_Connection_Setup_White_Listed_Config(dut1, &g_pattern_param);
			memcpy(g_pattern_param.white_list_param.Address, adv_addr, ADDR_LENGTH);
            g_pattern_param.white_list_param.Address_Type[0] = HCI_CMD_PARAM_PUBLIC_DEVICE_ADDRESS;
			verdict = COMM_INI_Connection_Setup_White_Listed(dut1_fd, g_pattern_param);
			VERDICT_RESULT_WITH_LINE();
            
            COMM_INI_Connection_Setup_White_Listed_Config(dut2, &g_pattern_param);
			memcpy(g_pattern_param.white_list_param.Address, scan_addr, ADDR_LENGTH);
            g_pattern_param.white_list_param.Address_Type[0] = HCI_CMD_PARAM_PUBLIC_DEVICE_ADDRESS;
			verdict = COMM_INI_Connection_Setup_White_Listed(dut2_fd, g_pattern_param);
			VERDICT_RESULT_WITH_LINE();
            
            // ***********************************************************************************            
            // Lwtest(SCN) config
            COMM_Static_Random_Device_Address_Set_Config(error_addr);
			COMM_Device_Address_Set(dut1_fd, g_pattern_param);
            COMM_SCN_Active_Scanning_Config(dut1, &g_pattern_param);
            g_pattern_param.scn_param.Own_Address_Type[0] = HCI_CMD_PARAM_RANDOM_DEVICE_ADDRESS;             
            g_pattern_param.scn_param.Scanning_Filter_Policy[0] =	HCI_CMD_PARAM_IGNORE_ADV_PKTS_FROM_DEV_NOT_IN_WHITE_LIST_ONLY;
            g_pattern_param.scn_param.LE_Scan_Interval[0] =  0x0500 & 0x00ff;
	        g_pattern_param.scn_param.LE_Scan_Interval[1] = (0x0500 & 0xff00) >> 8;
	        g_pattern_param.scn_param.LE_Scan_Window[0] =	 0x0500 & 0x00ff;
	        g_pattern_param.scn_param.LE_Scan_Window[1] =   (0x0500 & 0xff00) >> 8;
			verdict = COMM_SCN_Active_Scanning(dut1_fd, g_pattern_param);            
			VERDICT_RESULT_WITH_LINE();
            
            // ***********************************************************************************            
            // IUT(ADV) config
            COMM_ADV_Undirected_Advertising_Config(HCI_CMD_PARAM_ADV_DATA_LEN_MAX, &g_pattern_param);
            if(37 == adv_Channel) {
                g_pattern_param.adv_param.Advertising_Channel_Map[0] = HCI_CMD_PARAM_ENABLE_CHANNEL_37;
            }
            else if(38 == adv_Channel) {
                g_pattern_param.adv_param.Advertising_Channel_Map[0] = HCI_CMD_PARAM_ENABLE_CHANNEL_38;
            }
            else {
                g_pattern_param.adv_param.Advertising_Channel_Map[0] = HCI_CMD_PARAM_ENABLE_CHANNEL_39;
            }
			g_pattern_param.adv_param.Advertising_Filter_Policy[0] = HCI_CMD_PARAM_ALLOW_SCAN_REQ_FROM_WHITELIST_ONLY_AND_CONN_REQ_FROM_WHITELIST_ONLY;
            g_pattern_param.adv_param.Advertising_Interval_Max[0] =  HCI_CMD_PARAM_ADVERTISING_INTERVAL_MIN & 0x00ff;
	        g_pattern_param.adv_param.Advertising_Interval_Max[1] = (HCI_CMD_PARAM_ADVERTISING_INTERVAL_MIN & 0xff00) >> 8;
	        g_pattern_param.adv_param.Advertising_Interval_Min[0] =  HCI_CMD_PARAM_ADVERTISING_INTERVAL_MIN & 0x00ff;
	        g_pattern_param.adv_param.Advertising_Interval_Min[1] = (HCI_CMD_PARAM_ADVERTISING_INTERVAL_MIN & 0xff00) >> 8;
            verdict = COMM_ADV_Undirected_Advertising(dut2_fd, g_pattern_param);
			VERDICT_RESULT_WITH_LINE();
		break;

		case 5:			
			// Uptest   : addr_type = public 
			// Lwtest   : addr_type = random(error)
			// IUT      : undirected advertising, filter policy = 0x03
			// ***********************************************************************************
            // Uptest(white list) config
            COMM_INI_Connection_Setup_White_Listed_Config(dut1, &g_pattern_param);
			memcpy(g_pattern_param.white_list_param.Address, adv_addr, ADDR_LENGTH);
            g_pattern_param.white_list_param.Address_Type[0] = HCI_CMD_PARAM_PUBLIC_DEVICE_ADDRESS;
			verdict = COMM_INI_Connection_Setup_White_Listed(dut1_fd, g_pattern_param);
			VERDICT_RESULT_WITH_LINE();
            
            COMM_INI_Connection_Setup_White_Listed_Config(dut2, &g_pattern_param);
			memcpy(g_pattern_param.white_list_param.Address, scan_addr, ADDR_LENGTH);
            g_pattern_param.white_list_param.Address_Type[0] = HCI_CMD_PARAM_PUBLIC_DEVICE_ADDRESS;
			verdict = COMM_INI_Connection_Setup_White_Listed(dut2_fd, g_pattern_param);
			VERDICT_RESULT_WITH_LINE();
            
            // ***********************************************************************************            
            // Lwtest(SCN) config
            COMM_SCN_Active_Scanning_Config(dut1, &g_pattern_param);
            COMM_Static_Random_Device_Address_Set_Config(scan_addr);
			COMM_Device_Address_Set(dut1_fd, g_pattern_param);
            g_pattern_param.scn_param.Own_Address_Type[0] = HCI_CMD_PARAM_RANDOM_DEVICE_ADDRESS;
            g_pattern_param.scn_param.Scanning_Filter_Policy[0] =	HCI_CMD_PARAM_IGNORE_ADV_PKTS_FROM_DEV_NOT_IN_WHITE_LIST_ONLY;
            g_pattern_param.scn_param.LE_Scan_Interval[0] =  0x0500 & 0x00ff;
	        g_pattern_param.scn_param.LE_Scan_Interval[1] = (0x0500 & 0xff00) >> 8;
	        g_pattern_param.scn_param.LE_Scan_Window[0] =	 0x0500 & 0x00ff;
	        g_pattern_param.scn_param.LE_Scan_Window[1] =   (0x0500 & 0xff00) >> 8;
			verdict = COMM_SCN_Active_Scanning(dut1_fd, g_pattern_param);            
			VERDICT_RESULT_WITH_LINE();
            
            // ***********************************************************************************            
            // IUT(ADV) config
            COMM_ADV_Undirected_Advertising_Config(HCI_CMD_PARAM_ADV_DATA_LEN_MAX, &g_pattern_param);
            if(37 == adv_Channel) {
                g_pattern_param.adv_param.Advertising_Channel_Map[0] = HCI_CMD_PARAM_ENABLE_CHANNEL_37;
            }
            else if(38 == adv_Channel) {
                g_pattern_param.adv_param.Advertising_Channel_Map[0] = HCI_CMD_PARAM_ENABLE_CHANNEL_38;
            }
            else {
                g_pattern_param.adv_param.Advertising_Channel_Map[0] = HCI_CMD_PARAM_ENABLE_CHANNEL_39;
            }
			g_pattern_param.adv_param.Advertising_Filter_Policy[0] = HCI_CMD_PARAM_ALLOW_SCAN_REQ_FROM_WHITELIST_ONLY_AND_CONN_REQ_FROM_WHITELIST_ONLY;
            g_pattern_param.adv_param.Advertising_Interval_Max[0] =  HCI_CMD_PARAM_ADVERTISING_INTERVAL_MIN & 0x00ff;
	        g_pattern_param.adv_param.Advertising_Interval_Max[1] = (HCI_CMD_PARAM_ADVERTISING_INTERVAL_MIN & 0xff00) >> 8;
	        g_pattern_param.adv_param.Advertising_Interval_Min[0] =  HCI_CMD_PARAM_ADVERTISING_INTERVAL_MIN & 0x00ff;
	        g_pattern_param.adv_param.Advertising_Interval_Min[1] = (HCI_CMD_PARAM_ADVERTISING_INTERVAL_MIN & 0xff00) >> 8;
            verdict = COMM_ADV_Undirected_Advertising(dut2_fd, g_pattern_param);
			VERDICT_RESULT_WITH_LINE();
		break;

		case 6:
			// Uptest   : addr_type = public 
			// Lwtest   : addr_type = public
			// IUT      : undirected advertising, filter policy = 0x03
			// ***********************************************************************************
            // Uptest(white list) config
            COMM_INI_Connection_Setup_White_Listed_Config(dut1, &g_pattern_param);
			memcpy(g_pattern_param.white_list_param.Address, adv_addr, ADDR_LENGTH);
            g_pattern_param.white_list_param.Address_Type[0] = HCI_CMD_PARAM_PUBLIC_DEVICE_ADDRESS;
			verdict = COMM_INI_Connection_Setup_White_Listed(dut1_fd, g_pattern_param);
			VERDICT_RESULT_WITH_LINE();
            
            COMM_INI_Connection_Setup_White_Listed_Config(dut2, &g_pattern_param);
			memcpy(g_pattern_param.white_list_param.Address, scan_addr, ADDR_LENGTH);
            g_pattern_param.white_list_param.Address_Type[0] = HCI_CMD_PARAM_PUBLIC_DEVICE_ADDRESS;
			verdict = COMM_INI_Connection_Setup_White_Listed(dut2_fd, g_pattern_param);
			VERDICT_RESULT_WITH_LINE();
            
            // ***********************************************************************************            
            // Lwtest(SCN) config
            COMM_SCN_Active_Scanning_Config(dut1, &g_pattern_param);
            g_pattern_param.scn_param.Own_Address_Type[0] = HCI_CMD_PARAM_PUBLIC_DEVICE_ADDRESS;             
            g_pattern_param.scn_param.Scanning_Filter_Policy[0] =	HCI_CMD_PARAM_IGNORE_ADV_PKTS_FROM_DEV_NOT_IN_WHITE_LIST_ONLY;
            g_pattern_param.scn_param.LE_Scan_Interval[0] = 0x0500 & 0x00ff;
	        g_pattern_param.scn_param.LE_Scan_Interval[1] = (0x0500 & 0xff00) >> 8;
	        g_pattern_param.scn_param.LE_Scan_Window[0] =	0x0500 & 0x00ff;
	        g_pattern_param.scn_param.LE_Scan_Window[1] = (0x0500 & 0xff00) >> 8;
			verdict = COMM_SCN_Active_Scanning(dut1_fd, g_pattern_param);            
			VERDICT_RESULT_WITH_LINE();
            
            // ***********************************************************************************            
            // IUT(ADV) config
            COMM_ADV_Undirected_Advertising_Config(HCI_CMD_PARAM_ADV_DATA_LEN_MAX, &g_pattern_param);
            if(37 == adv_Channel) {
                g_pattern_param.adv_param.Advertising_Channel_Map[0] = HCI_CMD_PARAM_ENABLE_CHANNEL_37;
            }
            else if(38 == adv_Channel) {
                g_pattern_param.adv_param.Advertising_Channel_Map[0] = HCI_CMD_PARAM_ENABLE_CHANNEL_38;
            }
            else {
                g_pattern_param.adv_param.Advertising_Channel_Map[0] = HCI_CMD_PARAM_ENABLE_CHANNEL_39;
            }
			g_pattern_param.adv_param.Advertising_Filter_Policy[0] = HCI_CMD_PARAM_ALLOW_SCAN_REQ_FROM_WHITELIST_ONLY_AND_CONN_REQ_FROM_WHITELIST_ONLY;
            g_pattern_param.adv_param.Advertising_Interval_Max[0] =  HCI_CMD_PARAM_ADVERTISING_INTERVAL_MIN & 0x00ff;
	        g_pattern_param.adv_param.Advertising_Interval_Max[1] = (HCI_CMD_PARAM_ADVERTISING_INTERVAL_MIN & 0xff00) >> 8;
	        g_pattern_param.adv_param.Advertising_Interval_Min[0] =  HCI_CMD_PARAM_ADVERTISING_INTERVAL_MIN & 0x00ff;
	        g_pattern_param.adv_param.Advertising_Interval_Min[1] = (HCI_CMD_PARAM_ADVERTISING_INTERVAL_MIN & 0xff00) >> 8;
            verdict = COMM_ADV_Undirected_Advertising(dut2_fd, g_pattern_param);
			VERDICT_RESULT_WITH_LINE();
		break;

		//part E : filter policy = 0x01 ;	repeat case1~3=>7~9
		case 7:			
			// Uptest   : addr_type = public 
			// Lwtest   : addr_type = public, addr error(black); 
			// IUT      : undirected advertising, filter policy = 0x01
			// ***********************************************************************************
			// Uptest(white list) config
			COMM_INI_Connection_Setup_White_Listed_Config(dut1, &g_pattern_param);
			memcpy(g_pattern_param.white_list_param.Address, adv_addr, ADDR_LENGTH);
            g_pattern_param.white_list_param.Address_Type[0] = HCI_CMD_PARAM_PUBLIC_DEVICE_ADDRESS;
			verdict = COMM_INI_Connection_Setup_White_Listed(dut1_fd, g_pattern_param);
			VERDICT_RESULT_WITH_LINE();
			
			COMM_INI_Connection_Setup_White_Listed_Config(dut2, &g_pattern_param);
			memcpy(g_pattern_param.white_list_param.Address, scan_addr, ADDR_LENGTH);
            g_pattern_param.white_list_param.Address_Type[0] = HCI_CMD_PARAM_PUBLIC_DEVICE_ADDRESS;
			verdict = COMM_INI_Connection_Setup_White_Listed(dut2_fd, g_pattern_param);
			VERDICT_RESULT_WITH_LINE();
            
            // ***********************************************************************************            
            // Lwtest(SCN) config
            COMM_Static_Random_Device_Address_Set_Config(error_addr);
			COMM_Device_Address_Set(dut1_fd, g_pattern_param);
            COMM_SCN_Active_Scanning_Config(dut1, &g_pattern_param);            
            g_pattern_param.scn_param.Own_Address_Type[0] = HCI_CMD_PARAM_RANDOM_DEVICE_ADDRESS;             
            g_pattern_param.scn_param.Scanning_Filter_Policy[0] =	HCI_CMD_PARAM_IGNORE_ADV_PKTS_FROM_DEV_NOT_IN_WHITE_LIST_ONLY;
            g_pattern_param.scn_param.LE_Scan_Interval[0] = 0x0500 & 0x00ff;
	        g_pattern_param.scn_param.LE_Scan_Interval[1] = (0x0500 & 0xff00) >> 8;
	        g_pattern_param.scn_param.LE_Scan_Window[0] =	0x0500 & 0x00ff;
	        g_pattern_param.scn_param.LE_Scan_Window[1] = (0x0500 & 0xff00) >> 8;
			verdict = COMM_SCN_Active_Scanning(dut1_fd, g_pattern_param);            
			VERDICT_RESULT_WITH_LINE();
            
            // ***********************************************************************************            
            // IUT(ADV) config
            COMM_ADV_Undirected_Advertising_Config(HCI_CMD_PARAM_ADV_DATA_LEN_MAX, &g_pattern_param);
            if(37 == adv_Channel) {
                g_pattern_param.adv_param.Advertising_Channel_Map[0] = HCI_CMD_PARAM_ENABLE_CHANNEL_37;
            }
            else if(38 == adv_Channel) {
                g_pattern_param.adv_param.Advertising_Channel_Map[0] = HCI_CMD_PARAM_ENABLE_CHANNEL_38;
            }
            else {
                g_pattern_param.adv_param.Advertising_Channel_Map[0] = HCI_CMD_PARAM_ENABLE_CHANNEL_39;
            }
			g_pattern_param.adv_param.Advertising_Filter_Policy[0] = HCI_CMD_PARAM_ALLOW_SCAN_REQ_FROM_WHITELIST_ONLY_AND_CONN_REQ_FROM_ANY;
            g_pattern_param.adv_param.Advertising_Interval_Max[0] = HCI_CMD_PARAM_ADVERTISING_INTERVAL_MIN & 0x00ff;
	        g_pattern_param.adv_param.Advertising_Interval_Max[1] = (HCI_CMD_PARAM_ADVERTISING_INTERVAL_MIN & 0xff00) >> 8;
	        g_pattern_param.adv_param.Advertising_Interval_Min[0] = HCI_CMD_PARAM_ADVERTISING_INTERVAL_MIN & 0x00ff;
	        g_pattern_param.adv_param.Advertising_Interval_Min[1] = (HCI_CMD_PARAM_ADVERTISING_INTERVAL_MIN & 0xff00) >> 8;
            verdict = COMM_ADV_Undirected_Advertising(dut2_fd, g_pattern_param);
			VERDICT_RESULT_WITH_LINE();
		break;

		case 8:			
			// Uptest   : addr_type = public 
			// Lwtest   : addr_type = random(error)
			// IUT      : undirected advertising, filter policy = 0x01
			// ***********************************************************************************
            // Uptest(white list) config
            COMM_INI_Connection_Setup_White_Listed_Config(dut1, &g_pattern_param);
			memcpy(g_pattern_param.white_list_param.Address, adv_addr, ADDR_LENGTH);
            g_pattern_param.white_list_param.Address_Type[0] = HCI_CMD_PARAM_PUBLIC_DEVICE_ADDRESS;
			verdict = COMM_INI_Connection_Setup_White_Listed(dut1_fd, g_pattern_param);
			VERDICT_RESULT_WITH_LINE();
            
            COMM_INI_Connection_Setup_White_Listed_Config(dut2, &g_pattern_param);
			memcpy(g_pattern_param.white_list_param.Address, scan_addr, ADDR_LENGTH);
            g_pattern_param.white_list_param.Address_Type[0] = HCI_CMD_PARAM_PUBLIC_DEVICE_ADDRESS;
			verdict = COMM_INI_Connection_Setup_White_Listed(dut2_fd, g_pattern_param);
			VERDICT_RESULT_WITH_LINE();
            
            // ***********************************************************************************            
            // Lwtest(SCN) config
            COMM_SCN_Active_Scanning_Config(dut1, &g_pattern_param);
            COMM_Static_Random_Device_Address_Set_Config(scan_addr);
			COMM_Device_Address_Set(dut1_fd, g_pattern_param);
            g_pattern_param.scn_param.Own_Address_Type[0] = HCI_CMD_PARAM_RANDOM_DEVICE_ADDRESS;             
            g_pattern_param.scn_param.Scanning_Filter_Policy[0] =	HCI_CMD_PARAM_IGNORE_ADV_PKTS_FROM_DEV_NOT_IN_WHITE_LIST_ONLY;
            g_pattern_param.scn_param.LE_Scan_Interval[0] =  0x0500 & 0x00ff;
	        g_pattern_param.scn_param.LE_Scan_Interval[1] = (0x0500 & 0xff00) >> 8;
	        g_pattern_param.scn_param.LE_Scan_Window[0] =	 0x0500 & 0x00ff;
	        g_pattern_param.scn_param.LE_Scan_Window[1] =   (0x0500 & 0xff00) >> 8;
			verdict = COMM_SCN_Active_Scanning(dut1_fd, g_pattern_param);            
			VERDICT_RESULT_WITH_LINE();
            
            // ***********************************************************************************            
            // IUT(ADV) config
            COMM_ADV_Undirected_Advertising_Config(HCI_CMD_PARAM_ADV_DATA_LEN_MAX, &g_pattern_param);
            if(37 == adv_Channel) {
                g_pattern_param.adv_param.Advertising_Channel_Map[0] = HCI_CMD_PARAM_ENABLE_CHANNEL_37;
            }
            else if(38 == adv_Channel) {
                g_pattern_param.adv_param.Advertising_Channel_Map[0] = HCI_CMD_PARAM_ENABLE_CHANNEL_38;
            }
            else {
                g_pattern_param.adv_param.Advertising_Channel_Map[0] = HCI_CMD_PARAM_ENABLE_CHANNEL_39;
            }
			g_pattern_param.adv_param.Advertising_Filter_Policy[0] = HCI_CMD_PARAM_ALLOW_SCAN_REQ_FROM_WHITELIST_ONLY_AND_CONN_REQ_FROM_ANY;
            g_pattern_param.adv_param.Advertising_Interval_Max[0] =  HCI_CMD_PARAM_ADVERTISING_INTERVAL_MIN & 0x00ff;
	        g_pattern_param.adv_param.Advertising_Interval_Max[1] = (HCI_CMD_PARAM_ADVERTISING_INTERVAL_MIN & 0xff00) >> 8;
	        g_pattern_param.adv_param.Advertising_Interval_Min[0] =  HCI_CMD_PARAM_ADVERTISING_INTERVAL_MIN & 0x00ff;
	        g_pattern_param.adv_param.Advertising_Interval_Min[1] = (HCI_CMD_PARAM_ADVERTISING_INTERVAL_MIN & 0xff00) >> 8;
            verdict = COMM_ADV_Undirected_Advertising(dut2_fd, g_pattern_param);
			VERDICT_RESULT_WITH_LINE();
		break;

		case 9:
			// Uptest   : addr_type = public 
			// Lwtest   : addr_type = public
			// IUT      : undirected advertising, filter policy = 0x01
			// ***********************************************************************************
            // Uptest(white list) config
            COMM_INI_Connection_Setup_White_Listed_Config(dut1, &g_pattern_param);
			memcpy(g_pattern_param.white_list_param.Address, adv_addr, ADDR_LENGTH);
            g_pattern_param.white_list_param.Address_Type[0] = HCI_CMD_PARAM_PUBLIC_DEVICE_ADDRESS;
			verdict = COMM_INI_Connection_Setup_White_Listed(dut1_fd, g_pattern_param);
			VERDICT_RESULT_WITH_LINE();
            
            COMM_INI_Connection_Setup_White_Listed_Config(dut2, &g_pattern_param);
			memcpy(g_pattern_param.white_list_param.Address, scan_addr, ADDR_LENGTH);
            g_pattern_param.white_list_param.Address_Type[0] = HCI_CMD_PARAM_PUBLIC_DEVICE_ADDRESS;
			verdict = COMM_INI_Connection_Setup_White_Listed(dut2_fd, g_pattern_param);
			VERDICT_RESULT_WITH_LINE();
            
            // ***********************************************************************************            
            // Lwtest(SCN) config
            COMM_SCN_Active_Scanning_Config(dut1, &g_pattern_param);
            g_pattern_param.scn_param.Own_Address_Type[0] = HCI_CMD_PARAM_PUBLIC_DEVICE_ADDRESS;             
            g_pattern_param.scn_param.Scanning_Filter_Policy[0] =	HCI_CMD_PARAM_IGNORE_ADV_PKTS_FROM_DEV_NOT_IN_WHITE_LIST_ONLY;
            g_pattern_param.scn_param.LE_Scan_Interval[0] =  0x0500 & 0x00ff;
	        g_pattern_param.scn_param.LE_Scan_Interval[1] = (0x0500 & 0xff00) >> 8;
	        g_pattern_param.scn_param.LE_Scan_Window[0] =	 0x0500 & 0x00ff;
	        g_pattern_param.scn_param.LE_Scan_Window[1] =   (0x0500 & 0xff00) >> 8;
			verdict = COMM_SCN_Active_Scanning(dut1_fd, g_pattern_param);            
			VERDICT_RESULT_WITH_LINE();
            
            // ***********************************************************************************            
            // IUT(ADV) config
            COMM_ADV_Undirected_Advertising_Config(HCI_CMD_PARAM_ADV_DATA_LEN_MAX, &g_pattern_param);
            if(37 == adv_Channel) {
                g_pattern_param.adv_param.Advertising_Channel_Map[0] = HCI_CMD_PARAM_ENABLE_CHANNEL_37;
            }
            else if(38 == adv_Channel) {
                g_pattern_param.adv_param.Advertising_Channel_Map[0] = HCI_CMD_PARAM_ENABLE_CHANNEL_38;
            }
            else {
                g_pattern_param.adv_param.Advertising_Channel_Map[0] = HCI_CMD_PARAM_ENABLE_CHANNEL_39;
            }
			g_pattern_param.adv_param.Advertising_Filter_Policy[0] = HCI_CMD_PARAM_ALLOW_SCAN_REQ_FROM_WHITELIST_ONLY_AND_CONN_REQ_FROM_ANY;
            g_pattern_param.adv_param.Advertising_Interval_Max[0] =  HCI_CMD_PARAM_ADVERTISING_INTERVAL_MIN & 0x00ff;
	        g_pattern_param.adv_param.Advertising_Interval_Max[1] = (HCI_CMD_PARAM_ADVERTISING_INTERVAL_MIN & 0xff00) >> 8;
	        g_pattern_param.adv_param.Advertising_Interval_Min[0] =  HCI_CMD_PARAM_ADVERTISING_INTERVAL_MIN & 0x00ff;
	        g_pattern_param.adv_param.Advertising_Interval_Min[1] = (HCI_CMD_PARAM_ADVERTISING_INTERVAL_MIN & 0xff00) >> 8;
            verdict = COMM_ADV_Undirected_Advertising(dut2_fd, g_pattern_param);
			VERDICT_RESULT_WITH_LINE();
		break;


		//part F : filter policy = 0x01 ; Lwtest :addr_type=random repeat case 1~3=10~12
		case 10:			
            // Uptest   : addr_type = public 
			// Lwtest   : addr_type = random, addr error(black); 
			// IUT      : undirected advertising, filter policy = 0x01
			// ***********************************************************************************
			// Uptest(white list) config
			COMM_INI_Connection_Setup_White_Listed_Config(dut1, &g_pattern_param);
			memcpy(g_pattern_param.white_list_param.Address, adv_addr, ADDR_LENGTH);
            g_pattern_param.white_list_param.Address_Type[0] = HCI_CMD_PARAM_PUBLIC_DEVICE_ADDRESS;
			verdict = COMM_INI_Connection_Setup_White_Listed(dut1_fd, g_pattern_param);
			VERDICT_RESULT_WITH_LINE();
            
			COMM_INI_Connection_Setup_White_Listed_Config(dut2, &g_pattern_param);
			memcpy(g_pattern_param.white_list_param.Address, scan_addr, ADDR_LENGTH);
            g_pattern_param.white_list_param.Address_Type[0] = HCI_CMD_PARAM_PUBLIC_DEVICE_ADDRESS;
			verdict = COMM_INI_Connection_Setup_White_Listed(dut2_fd, g_pattern_param);
			VERDICT_RESULT_WITH_LINE();
            
            // ***********************************************************************************            
            // Lwtest(SCN) config
            COMM_Static_Random_Device_Address_Set_Config(error_addr);
			COMM_Device_Address_Set(dut1_fd, g_pattern_param);
            COMM_SCN_Active_Scanning_Config(dut1, &g_pattern_param);            
            g_pattern_param.scn_param.Own_Address_Type[0] = HCI_CMD_PARAM_RANDOM_DEVICE_ADDRESS;             
            g_pattern_param.scn_param.Scanning_Filter_Policy[0] =	HCI_CMD_PARAM_IGNORE_ADV_PKTS_FROM_DEV_NOT_IN_WHITE_LIST_ONLY;
            g_pattern_param.scn_param.LE_Scan_Interval[0] =  0x0500 & 0x00ff;
	        g_pattern_param.scn_param.LE_Scan_Interval[1] = (0x0500 & 0xff00) >> 8;
	        g_pattern_param.scn_param.LE_Scan_Window[0] =	 0x0500 & 0x00ff;
	        g_pattern_param.scn_param.LE_Scan_Window[1] =   (0x0500 & 0xff00) >> 8;
			verdict = COMM_SCN_Active_Scanning(dut1_fd, g_pattern_param);            
			VERDICT_RESULT_WITH_LINE();
            
            // ***********************************************************************************            
            // IUT(ADV) config
            COMM_ADV_Undirected_Advertising_Config(HCI_CMD_PARAM_ADV_DATA_LEN_MAX, &g_pattern_param);
            if(37 == adv_Channel) {
                g_pattern_param.adv_param.Advertising_Channel_Map[0] = HCI_CMD_PARAM_ENABLE_CHANNEL_37;
            }
            else if(38 == adv_Channel) {
                g_pattern_param.adv_param.Advertising_Channel_Map[0] = HCI_CMD_PARAM_ENABLE_CHANNEL_38;
            }
            else {
                g_pattern_param.adv_param.Advertising_Channel_Map[0] = HCI_CMD_PARAM_ENABLE_CHANNEL_39;
            }
			g_pattern_param.adv_param.Advertising_Filter_Policy[0] = HCI_CMD_PARAM_ALLOW_SCAN_REQ_FROM_WHITELIST_ONLY_AND_CONN_REQ_FROM_ANY;
            g_pattern_param.adv_param.Advertising_Interval_Max[0] =  HCI_CMD_PARAM_ADVERTISING_INTERVAL_MIN & 0x00ff;
	        g_pattern_param.adv_param.Advertising_Interval_Max[1] = (HCI_CMD_PARAM_ADVERTISING_INTERVAL_MIN & 0xff00) >> 8;
	        g_pattern_param.adv_param.Advertising_Interval_Min[0] =  HCI_CMD_PARAM_ADVERTISING_INTERVAL_MIN & 0x00ff;
	        g_pattern_param.adv_param.Advertising_Interval_Min[1] = (HCI_CMD_PARAM_ADVERTISING_INTERVAL_MIN & 0xff00) >> 8;
            verdict = COMM_ADV_Undirected_Advertising(dut2_fd, g_pattern_param);
			VERDICT_RESULT_WITH_LINE();

		break;

		case 11:
			// Uptest   : addr_type = public 
			// Lwtest   : addr_type = random(error)
			// IUT      : undirected advertising, filter policy = 0x01
			// ***********************************************************************************
			// Uptest(white list) config
			COMM_INI_Connection_Setup_White_Listed_Config(dut1, &g_pattern_param);
			memcpy(g_pattern_param.white_list_param.Address, adv_addr, ADDR_LENGTH);
            g_pattern_param.white_list_param.Address_Type[0] = HCI_CMD_PARAM_PUBLIC_DEVICE_ADDRESS;
			verdict = COMM_INI_Connection_Setup_White_Listed(dut1_fd, g_pattern_param);
			VERDICT_RESULT_WITH_LINE();
            
			COMM_INI_Connection_Setup_White_Listed_Config(dut2, &g_pattern_param);
			memcpy(g_pattern_param.white_list_param.Address, scan_addr, ADDR_LENGTH);
            g_pattern_param.white_list_param.Address_Type[0] = HCI_CMD_PARAM_PUBLIC_DEVICE_ADDRESS;
			verdict = COMM_INI_Connection_Setup_White_Listed(dut2_fd, g_pattern_param);
			VERDICT_RESULT_WITH_LINE();
            
            // ***********************************************************************************            
            // Lwtest(SCN) config
            //COMM_Static_Random_Device_Address_Set_Config(scan_random_addr);
			//COMM_Device_Address_Set(dut1_fd, g_pattern_param);
            COMM_SCN_Active_Scanning_Config(dut1, &g_pattern_param);  
            COMM_Static_Random_Device_Address_Set_Config(scan_addr);
			COMM_Device_Address_Set(dut1_fd, g_pattern_param);
            g_pattern_param.scn_param.Own_Address_Type[0] = HCI_CMD_PARAM_RANDOM_DEVICE_ADDRESS;             
            g_pattern_param.scn_param.Scanning_Filter_Policy[0] =	HCI_CMD_PARAM_IGNORE_ADV_PKTS_FROM_DEV_NOT_IN_WHITE_LIST_ONLY;
            g_pattern_param.scn_param.LE_Scan_Interval[0] =  0x0500 & 0x00ff;
	        g_pattern_param.scn_param.LE_Scan_Interval[1] = (0x0500 & 0xff00) >> 8;
	        g_pattern_param.scn_param.LE_Scan_Window[0] =	 0x0500 & 0x00ff;
	        g_pattern_param.scn_param.LE_Scan_Window[1] =   (0x0500 & 0xff00) >> 8;
			verdict = COMM_SCN_Active_Scanning(dut1_fd, g_pattern_param);            
			VERDICT_RESULT_WITH_LINE();
            
            // ***********************************************************************************            
            // IUT(ADV) config
            COMM_ADV_Undirected_Advertising_Config(HCI_CMD_PARAM_ADV_DATA_LEN_MAX, &g_pattern_param);
            if(37 == adv_Channel) {
                g_pattern_param.adv_param.Advertising_Channel_Map[0] = HCI_CMD_PARAM_ENABLE_CHANNEL_37;
            }
            else if(38 == adv_Channel) {
                g_pattern_param.adv_param.Advertising_Channel_Map[0] = HCI_CMD_PARAM_ENABLE_CHANNEL_38;
            }
            else {
                g_pattern_param.adv_param.Advertising_Channel_Map[0] = HCI_CMD_PARAM_ENABLE_CHANNEL_39;
            }
			g_pattern_param.adv_param.Advertising_Filter_Policy[0] = HCI_CMD_PARAM_ALLOW_SCAN_REQ_FROM_WHITELIST_ONLY_AND_CONN_REQ_FROM_ANY;
            g_pattern_param.adv_param.Advertising_Interval_Max[0] =  HCI_CMD_PARAM_ADVERTISING_INTERVAL_MIN & 0x00ff;
	        g_pattern_param.adv_param.Advertising_Interval_Max[1] = (HCI_CMD_PARAM_ADVERTISING_INTERVAL_MIN & 0xff00) >> 8;
	        g_pattern_param.adv_param.Advertising_Interval_Min[0] =  HCI_CMD_PARAM_ADVERTISING_INTERVAL_MIN & 0x00ff;
	        g_pattern_param.adv_param.Advertising_Interval_Min[1] = (HCI_CMD_PARAM_ADVERTISING_INTERVAL_MIN & 0xff00) >> 8;
            verdict = COMM_ADV_Undirected_Advertising(dut2_fd, g_pattern_param);
			VERDICT_RESULT_WITH_LINE();
		break;

		case 12:			
			// Uptest   : addr_type = public 
			// Lwtest   : addr_type = public
			// IUT      : undirected advertising, filter policy = 0x01
			// ***********************************************************************************
            // Uptest(white list) config
            COMM_INI_Connection_Setup_White_Listed_Config(dut1, &g_pattern_param);
			memcpy(g_pattern_param.white_list_param.Address, adv_addr, ADDR_LENGTH);
            g_pattern_param.white_list_param.Address_Type[0] = HCI_CMD_PARAM_PUBLIC_DEVICE_ADDRESS;
			verdict = COMM_INI_Connection_Setup_White_Listed(dut1_fd, g_pattern_param);
			VERDICT_RESULT_WITH_LINE();
            
            COMM_INI_Connection_Setup_White_Listed_Config(dut2, &g_pattern_param);
			memcpy(g_pattern_param.white_list_param.Address, scan_addr, ADDR_LENGTH);
            g_pattern_param.white_list_param.Address_Type[0] = HCI_CMD_PARAM_PUBLIC_DEVICE_ADDRESS;
			verdict = COMM_INI_Connection_Setup_White_Listed(dut2_fd, g_pattern_param);
			VERDICT_RESULT_WITH_LINE();
            
            // ***********************************************************************************            
            // Lwtest(SCN) config
            COMM_SCN_Active_Scanning_Config(dut1, &g_pattern_param);
            g_pattern_param.scn_param.Own_Address_Type[0] = HCI_CMD_PARAM_PUBLIC_DEVICE_ADDRESS;             
            g_pattern_param.scn_param.Scanning_Filter_Policy[0] =	HCI_CMD_PARAM_IGNORE_ADV_PKTS_FROM_DEV_NOT_IN_WHITE_LIST_ONLY;
            g_pattern_param.scn_param.LE_Scan_Interval[0] =  0x0500 & 0x00ff;
	        g_pattern_param.scn_param.LE_Scan_Interval[1] = (0x0500 & 0xff00) >> 8;
	        g_pattern_param.scn_param.LE_Scan_Window[0] =	 0x0500 & 0x00ff;
	        g_pattern_param.scn_param.LE_Scan_Window[1] =   (0x0500 & 0xff00) >> 8;
			verdict = COMM_SCN_Active_Scanning(dut1_fd, g_pattern_param);            
			VERDICT_RESULT_WITH_LINE();
            
            // ***********************************************************************************            
            // IUT(ADV) config
            COMM_ADV_Undirected_Advertising_Config(HCI_CMD_PARAM_ADV_DATA_LEN_MAX, &g_pattern_param);
            if(37 == adv_Channel) {
                g_pattern_param.adv_param.Advertising_Channel_Map[0] = HCI_CMD_PARAM_ENABLE_CHANNEL_37;
            }
            else if(38 == adv_Channel) {
                g_pattern_param.adv_param.Advertising_Channel_Map[0] = HCI_CMD_PARAM_ENABLE_CHANNEL_38;
            }
            else {
                g_pattern_param.adv_param.Advertising_Channel_Map[0] = HCI_CMD_PARAM_ENABLE_CHANNEL_39;
            }
			g_pattern_param.adv_param.Advertising_Filter_Policy[0] = HCI_CMD_PARAM_ALLOW_SCAN_REQ_FROM_WHITELIST_ONLY_AND_CONN_REQ_FROM_ANY;
            g_pattern_param.adv_param.Advertising_Interval_Max[0] =  HCI_CMD_PARAM_ADVERTISING_INTERVAL_MIN & 0x00ff;
	        g_pattern_param.adv_param.Advertising_Interval_Max[1] = (HCI_CMD_PARAM_ADVERTISING_INTERVAL_MIN & 0xff00) >> 8;
	        g_pattern_param.adv_param.Advertising_Interval_Min[0] =  HCI_CMD_PARAM_ADVERTISING_INTERVAL_MIN & 0x00ff;
	        g_pattern_param.adv_param.Advertising_Interval_Min[1] = (HCI_CMD_PARAM_ADVERTISING_INTERVAL_MIN & 0xff00) >> 8;
            verdict = COMM_ADV_Undirected_Advertising(dut2_fd, g_pattern_param);
			VERDICT_RESULT_WITH_LINE();
		break;


	}

	//uptest_part++;
	event_query_timer_config(2 , 0 , 0 , 0, &timer);
	event_query_timer_start(timer ,read_le_event_enable );


	while(adv_cnt <= 12)//waiting adv report event , timer or counter
	{
		if ( 1== read_le_event_get() )
		{
			//reset event flag
			read_le_event_disable();

			//##################################################


            
			if ( 1 == (adv_cnt % 3) ){
                //because the TI SCN can't set public type and change the addr at the same time,
                //so we don't verify the behavior at case 1 & 7 
                    while (check_cnt < 30) {
    				    if (SUCCESS != QUERY_LE_Event(dut1_fd, buf, _BT_HCI_LE_EVENT_SUB_OP_ADVERTISING_REPORT_, HCI_SUBEVENT_ADV_RPT_EVENT_SCAN_RSP)) {
                            //query scan_rsp
                            line = __LINE__;
    					    goto FUN_FAIL;
    				    }				    
    				    else if(EQUAL == hci_le_event_advertising_report_parsing(HCI_SUBEVENT_ADV_RPT_EVENT_SCAN_RSP, buf, g_pattern_param)) {
                            //there is no scan_rsp here ,so should not be equal
                            line = __LINE__;
    					    goto FUN_FAIL;
    				    }
                        else {
    					    check_cnt ++ ;
                            printf("###run case : %d   ADV_Channel = %d ###\n", adv_cnt, adv_Channel);
    					    printf("** Low Test expects no response from the IUT : %d / 30 times **\n" , check_cnt);
    				    }
                        MSLEEP(200);
                    }
			}
			else if ( 2 == (adv_cnt % 3)) {
                    while (check_cnt < 30) {
                
				    //query scan_rsp
				    if (SUCCESS != QUERY_LE_Event(dut1_fd, buf,	_BT_HCI_LE_EVENT_SUB_OP_ADVERTISING_REPORT_, HCI_SUBEVENT_ADV_RPT_EVENT_SCAN_RSP)) {
					    line = __LINE__;
					    goto FUN_FAIL;
				    }				
				    else if(EQUAL == hci_le_event_advertising_report_parsing(HCI_SUBEVENT_ADV_RPT_EVENT_SCAN_RSP, buf, g_pattern_param)) {
                        //there is no scan_rsp here ,so should not be equal
                        line = __LINE__;
					    goto FUN_FAIL;
				    }
                    else {
					    check_cnt ++ ;
                        printf("###run case : %d   ADV_Channel = %d ###\n", adv_cnt, adv_Channel);
					    printf("** Low Test expects no response from the IUT : %d / 30 times **\n" , check_cnt);
				    }
                    MSLEEP(200);
                    }
			}
			else {                
		        //query scan_rsp
                while (check_cnt == 0) {
                    if (SUCCESS != QUERY_LE_Event(dut1_fd, buf, _BT_HCI_LE_EVENT_SUB_OP_ADVERTISING_REPORT_, HCI_SUBEVENT_ADV_RPT_EVENT_SCAN_RSP)) {
                        //query ADV report
                        printf("****SUCCESS != QUERY_LE_Event****\n");
            	        continue;
            	    }				    
                    else if(EQUAL != hci_le_event_advertising_report_parsing(HCI_SUBEVENT_ADV_RPT_EVENT_SCAN_RSP, buf, g_pattern_param)) {
                         
                         printf("****EQUAL != HCI_err : %d, right_Cnt = %d ****\n", err_cnt, check_cnt);             
                         err_cnt++;
                         if (err_cnt > 50) {
                             line=__LINE__;
            	             goto FUN_FAIL;
                         }             
                    }                        
                    else {
                         check_cnt ++ ;
                         err_cnt = 0;
                         printf("###ADV_Channel = %d ###\n", adv_Channel);
                         printf("** Upper Tester expects an RSP event from the IUT **\n" );
                    }
                    MSLEEP(300);  
                }                
				                
			}

			// # ignored case 1 and case 7
            if ((1 != adv_cnt) && (7 != adv_cnt)) {
                //stop adv
    			COMM_ADV_Disable_Config(dut2, &g_pattern_param);
    			verdict = COMM_ADV_Disable(dut2_fd, g_pattern_param);
    			//VERDICT_RESULT_WITH_LINE();

    			//stop scn
    			COMM_SCN_Disable_Config(dut1, &g_pattern_param);
    			verdict = COMM_SCN_Disable(dut1_fd, g_pattern_param);
    			VERDICT_RESULT_WITH_LINE();
            }


			//event add
			if (37 == adv_Channel) {
                adv_Channel++;
                check_cnt = 0;
            }
            else if(38 == adv_Channel) {
                adv_Channel++;
                check_cnt = 0;
            }
            else {
                adv_Channel = 37;
                check_cnt = 0;
                adv_cnt++;
            }

            COMM_Dut_clean_buffer(dut1_fd);
            COMM_Dut_clean_buffer(dut2_fd);

			goto REPEAT;
		}
	}

    FUNC_END();

	LOG_INFO("[Pattern][%s]SUCCESS\n" ,__FUNCTION__);
	return PASS;

FUN_FAIL:
    FUNC_END();

	LOG_INFO("[Pattern][%s]:%d FAIL\n" ,__FUNCTION__,line);
    return FAIL;
}

// 5.2.2.1
verdict DDI_SCN_Passive_Scanning_Non_Connectable(u8 dut1_fd ,u8 dut2_fd)
{
	u8 buf[SOCKET_BUF_SIZE];	
    int err_cnt = 0;	
    int check_cnt = 0;
	int verdict = FAIL;
	int dut1 = 0;
    int dut2 = 0;
	u16 line = 0;
    int adv_Channel = 37;	
	struct itimerval timer;	

    COMM_Dut_clean_buffer(dut1_fd);
    COMM_Dut_clean_buffer(dut2_fd);

    Calculate_Execution_Time_Start();
	//p2
	COMM_SCN_Passive_Scanning_Config(dut1, &g_pattern_param);
	g_pattern_param.scn_param.LE_Scan_Interval[0] =  0xa0 & 0x00ff;
	g_pattern_param.scn_param.LE_Scan_Interval[1] = (0xa0 & 0xff00) >> 8;
    g_pattern_param.scn_param.LE_Scan_Window[0] =    0xa0 & 0x00ff;
    g_pattern_param.scn_param.LE_Scan_Window[1] =   (0xa0 & 0xff00) >> 8;   
	verdict = COMM_SCN_Passive_Scanning(dut1_fd, g_pattern_param);
	VERDICT_RESULT_WITH_LINE();

REPEAT:	
    
	//p1
	COMM_ADV_NonConnectable_Advertising_Config(HCI_CMD_PARAM_ADV_DATA_LEN_MAX, &g_pattern_param);
	COMM_ADV_NonConnectable_Advertising_Reconfig(&g_pattern_param);
	g_pattern_param.adv_param.Advertising_Interval_Max[0] =  HCI_CMD_PARAM_ADVERTISING_INTERVAL_MIN & 0x00ff;
	g_pattern_param.adv_param.Advertising_Interval_Max[1] = (HCI_CMD_PARAM_ADVERTISING_INTERVAL_MIN & 0xff00) >> 8;
	g_pattern_param.adv_param.Advertising_Interval_Min[0] =  HCI_CMD_PARAM_ADVERTISING_INTERVAL_MIN & 0x00ff;
	g_pattern_param.adv_param.Advertising_Interval_Min[1] = (HCI_CMD_PARAM_ADVERTISING_INTERVAL_MIN & 0xff00) >> 8;
	g_pattern_param.adv_data_param.Advertising_Data_Length[0] = 10;

    if(37 == adv_Channel) {
        g_pattern_param.adv_param.Advertising_Channel_Map[0] = HCI_CMD_PARAM_ENABLE_CHANNEL_37;         
    }
    else if(38 == adv_Channel) {
        COMM_Static_Random_Device_Address_Set_Config(dut2_error_com_idf);
		COMM_Device_Address_Set(dut2_fd, g_pattern_param);
		memcpy(g_pattern_param.adv_param.Direct_Address, dut2_error_com_idf, ADDR_LENGTH);
        g_pattern_param.adv_param.Advertising_Channel_Map[0] = HCI_CMD_PARAM_ENABLE_CHANNEL_38;
        g_pattern_param.adv_param.Own_Address_Type[0] = HCI_CMD_PARAM_RANDOM_DEVICE_ADDRESS;        
    }
    else {
        COMM_Static_Random_Device_Address_Set_Config(dut2_error_com_ass);
		COMM_Device_Address_Set(dut2_fd, g_pattern_param);
		memcpy(g_pattern_param.adv_param.Direct_Address, dut2_error_com_ass, ADDR_LENGTH);
		g_pattern_param.adv_param.Advertising_Channel_Map[0] = HCI_CMD_PARAM_ENABLE_CHANNEL_39;
        g_pattern_param.adv_param.Own_Address_Type[0] = HCI_CMD_PARAM_RANDOM_DEVICE_ADDRESS;
        
    }
	verdict = COMM_ADV_NonConnectable_Advertising(dut2_fd,g_pattern_param);
	VERDICT_RESULT_WITH_LINE();
	
    while (check_cnt < 20) {
        if (SUCCESS != QUERY_LE_Event(dut1_fd, buf, _BT_HCI_LE_EVENT_SUB_OP_ADVERTISING_REPORT_, HCI_SUBEVENT_ADV_RPT_EVENT_NONCONN_IND)) {
            //query ADV report
            printf("****SUCCESS != QUERY_LE_Event****\n");
	        continue;
	    }				    
        else if (EQUAL != hci_le_event_advertising_report_parsing(HCI_SUBEVENT_ADV_RPT_EVENT_NONCONN_IND, buf, g_pattern_param)) {
             
             printf("****EQUAL != HCI_err : %d, right_Cnt = %d ****\n", err_cnt, check_cnt);             
             err_cnt++;
             if (err_cnt > 50) {
                 line=__LINE__;
	            goto FUN_FAIL;
             }             
        }                        
        else {
             check_cnt ++ ;
             err_cnt = 0;
             printf("###ADV_Channel = %d ###\n", adv_Channel);
             printf("** Upper Tester expects an HCI_LE_Advertising_Report event from the IUT : %d / 20 times **\n" , check_cnt);
        }
        MSLEEP(300);
    }

	//stop adv
	COMM_ADV_Disable_Config(dut2, &g_pattern_param);
	verdict = COMM_ADV_Disable(dut2_fd, g_pattern_param);
	//VERDICT_RESULT_WITH_LINE();

    MSLEEP(100);
    COMM_Dut_clean_buffer(dut1_fd);
    COMM_Dut_clean_buffer(dut2_fd);

	if(adv_Channel != 39){        
        adv_Channel ++;
		check_cnt = 0;
		err_cnt = 0;
        goto REPEAT;
    }    

    FUNC_END();

    LOG_INFO("[Pattern][%s]SUCCESS\n" ,__FUNCTION__);
    return PASS;

FUN_FAIL:	

    FUNC_END(); 
	LOG_INFO("[Pattern][%s]:%d FAIL, ADV_Channel = %d\n" ,__FUNCTION__, line, adv_Channel);
    return FAIL;

}

// 5.2.2.2
verdict DDI_SCN_Passive_Scanning_Device_Filtering(u8 dut1_fd ,u8 dut2_fd)
{
    u8 buf[SOCKET_BUF_SIZE];
    u8 adv_cnt = 1;
    int err_cnt = 0;    
    int check_cnt = 0;
    int verdict = FAIL;
    int dut1 = 0;
	int dut2 = 0;
    u16 line = 0;    
    int adv_Channel = 37;    
	struct itimerval timer;	

    COMM_Dut_clean_buffer(dut1_fd);
    COMM_Dut_clean_buffer(dut2_fd);

    Calculate_Execution_Time_Start();
LOOP1: 
    /****************************************************************************  
        case 1,
        SCN(IUT):            
            Type    : HCI_CMD_PARAM_PUBLIC_DEVICE_ADDRESS
            scn_policy = 0x01(HCI_CMD_PARAM_IGNORE_ADV_PKTS_FROM_DEV_NOT_IN_WHITE_LIST_ONLY),
        ADV(Low_T):
            Type    : HCI_CMD_PARAM_PUBLIC_DEVICE_ADDRESS
            Address : adv_addr
        Result : Upper Tester expects an HCI_LE_Advertising_Report event from the IUT.
    *****************************************************************************/    
    // Uptest(white list) config
    COMM_INI_Connection_Setup_White_Listed_Config(dut1, &g_pattern_param);
    memcpy(g_pattern_param.white_list_param.Address, adv_addr, ADDR_LENGTH);
    g_pattern_param.white_list_param.Address_Type[0] = HCI_CMD_PARAM_PUBLIC_DEVICE_ADDRESS;
    verdict = COMM_INI_Connection_Setup_White_Listed(dut1_fd, g_pattern_param);
    VERDICT_RESULT_WITH_LINE();
    
    // ***********************************************************************************    
    COMM_SCN_Passive_Scanning_Config(dut1, &g_pattern_param);
    g_pattern_param.scn_param.LE_Scan_Interval[0] = 0xa0& 0x00ff;
    g_pattern_param.scn_param.LE_Scan_Interval[1] = (0xa0 & 0xff00) >> 8;
    g_pattern_param.scn_param.LE_Scan_Window[0] =   0xa0 & 0x00ff;
    g_pattern_param.scn_param.LE_Scan_Window[1] = (0xa0 & 0xff00) >> 8; 
    g_pattern_param.scn_param.Scanning_Filter_Policy[0] = HCI_CMD_PARAM_IGNORE_ADV_PKTS_FROM_DEV_NOT_IN_WHITE_LIST_ONLY;
    verdict = COMM_SCN_Passive_Scanning(dut1_fd, g_pattern_param);
    VERDICT_RESULT_WITH_LINE();
     
    // ***********************************************************************************    
    COMM_ADV_NonConnectable_Advertising_Config(HCI_CMD_PARAM_ADV_DATA_LEN_MAX, &g_pattern_param);    
    if(37 == adv_Channel) {
        g_pattern_param.adv_param.Advertising_Channel_Map[0] = HCI_CMD_PARAM_ENABLE_CHANNEL_37;
    }
    else if(38 == adv_Channel) {
        g_pattern_param.adv_param.Advertising_Channel_Map[0] = HCI_CMD_PARAM_ENABLE_CHANNEL_38;
    }
    else {
        g_pattern_param.adv_param.Advertising_Channel_Map[0] = HCI_CMD_PARAM_ENABLE_CHANNEL_39;
    }    
    g_pattern_param.adv_param.Own_Address_Type[0] = HCI_CMD_PARAM_PUBLIC_DEVICE_ADDRESS;
    g_pattern_param.adv_param.Advertising_Interval_Max[0] = HCI_CMD_PARAM_ADVERTISING_INTERVAL_MIN & 0x00ff;
    g_pattern_param.adv_param.Advertising_Interval_Max[1] = (HCI_CMD_PARAM_ADVERTISING_INTERVAL_MIN & 0xff00) >> 8;
    g_pattern_param.adv_param.Advertising_Interval_Min[0] = HCI_CMD_PARAM_ADVERTISING_INTERVAL_MIN & 0x00ff;
    g_pattern_param.adv_param.Advertising_Interval_Min[1] = (HCI_CMD_PARAM_ADVERTISING_INTERVAL_MIN & 0xff00) >> 8;
    verdict = COMM_ADV_NonConnectable_Advertising(dut2_fd, g_pattern_param);
    VERDICT_RESULT_WITH_LINE();    
    MSLEEP(500);


    while (check_cnt < 20) {
        if (SUCCESS != QUERY_LE_Event(dut1_fd, buf, _BT_HCI_LE_EVENT_SUB_OP_ADVERTISING_REPORT_, HCI_SUBEVENT_ADV_RPT_EVENT_NONCONN_IND)) {
            //query ADV report
            printf("****SUCCESS != QUERY_LE_Event****\n");
	        continue;
	    }				    
        else if (EQUAL != hci_le_event_advertising_report_parsing(HCI_SUBEVENT_ADV_RPT_EVENT_NONCONN_IND, buf, g_pattern_param)) {
             // Expect the IUT stop advertising                        
             printf("****EQUAL != HCI : %d****\n", err_cnt);             
             err_cnt++;
             if (50 <= err_cnt) {
                 line=__LINE__;
	            goto FUN_FAIL;
             }             
        }                        
        else {
             check_cnt ++ ;
             err_cnt = 0;
             printf("###run Loop : %d ; ADV_Channel = %d ###\n", adv_cnt, adv_Channel);
             printf("** Upper Tester expects an HCI_LE_Advertising_Report event from the IUT : %d / 20 times **\n" , check_cnt);
        }
        MSLEEP(500);
    }

    COMM_SCN_Disable_Config(dut1,&g_pattern_param);
    verdict = COMM_SCN_Disable(dut1_fd,g_pattern_param);
    VERDICT_RESULT_WITH_LINE();
        
    COMM_ADV_Disable_Config(dut2,&g_pattern_param);
    verdict = COMM_ADV_Disable(dut2_fd,g_pattern_param);
    //VERDICT_RESULT_WITH_LINE();

    MSLEEP(100);
    COMM_Dut_clean_buffer(dut1_fd);
    COMM_Dut_clean_buffer(dut2_fd);
    
	//printf("** CH : %d, Upper Tester expects an HCI_LE_Advertising_Report event from the IUT : %d / 20 times **\n" , adv_Channel, check_cnt);
	if(adv_Channel != 39){        
        adv_Channel ++;
		check_cnt = 0;
		err_cnt = 0;
        goto LOOP1;
    }
    else {
        adv_cnt++;
        check_cnt = 0;
		err_cnt = 0;
		adv_Channel = 37; // default
    }

LOOP2: 
    /****************************************************************************  
        case 2,
        SCN(IUT):            
            Type    : HCI_CMD_PARAM_PUBLIC_DEVICE_ADDRESS
            scn_policy = 0x01(HCI_CMD_PARAM_IGNORE_ADV_PKTS_FROM_DEV_NOT_IN_WHITE_LIST_ONLY),
        ADV(Low_T):
            Type    : HCI_CMD_PARAM_RANDOM_DEVICE_ADDRESS
            Address : adv_addr
        Result : Upper Tester expects an HCI_LE_Advertising_Report event from the IUT.
    *****************************************************************************/    
    // Uptest(white list) config
    COMM_INI_Connection_Setup_White_Listed_Config(dut1, &g_pattern_param);
    memcpy(g_pattern_param.white_list_param.Address, adv_addr, ADDR_LENGTH);
    g_pattern_param.white_list_param.Address_Type[0] = HCI_CMD_PARAM_PUBLIC_DEVICE_ADDRESS;
    verdict = COMM_INI_Connection_Setup_White_Listed(dut1_fd, g_pattern_param);
    VERDICT_RESULT_WITH_LINE();
    
    // ***********************************************************************************    
    COMM_SCN_Passive_Scanning_Config(dut1, &g_pattern_param);
    g_pattern_param.scn_param.LE_Scan_Interval[0] = 0xa0& 0x00ff;
    g_pattern_param.scn_param.LE_Scan_Interval[1] = (0xa0 & 0xff00) >> 8;
    g_pattern_param.scn_param.LE_Scan_Window[0] =   0xa0 & 0x00ff;
    g_pattern_param.scn_param.LE_Scan_Window[1] = (0xa0 & 0xff00) >> 8; 
    g_pattern_param.scn_param.Scanning_Filter_Policy[0] = HCI_CMD_PARAM_IGNORE_ADV_PKTS_FROM_DEV_NOT_IN_WHITE_LIST_ONLY;
    verdict = COMM_SCN_Passive_Scanning(dut1_fd, g_pattern_param);
    VERDICT_RESULT_WITH_LINE();
     
    // ***********************************************************************************    
    COMM_ADV_NonConnectable_Advertising_Config(HCI_CMD_PARAM_ADV_DATA_LEN_MAX, &g_pattern_param);
    COMM_Static_Random_Device_Address_Set_Config(adv_addr);
	COMM_Device_Address_Set(dut2_fd, g_pattern_param);
    if(37 == adv_Channel) {
        g_pattern_param.adv_param.Advertising_Channel_Map[0] = HCI_CMD_PARAM_ENABLE_CHANNEL_37;
    }
    else if(38 == adv_Channel) {
        g_pattern_param.adv_param.Advertising_Channel_Map[0] = HCI_CMD_PARAM_ENABLE_CHANNEL_38;
    }
    else {
        g_pattern_param.adv_param.Advertising_Channel_Map[0] = HCI_CMD_PARAM_ENABLE_CHANNEL_39;
    }    
    g_pattern_param.adv_param.Own_Address_Type[0] = HCI_CMD_PARAM_RANDOM_DEVICE_ADDRESS;
    g_pattern_param.adv_param.Advertising_Interval_Max[0] = HCI_CMD_PARAM_ADVERTISING_INTERVAL_MIN & 0x00ff;
    g_pattern_param.adv_param.Advertising_Interval_Max[1] = (HCI_CMD_PARAM_ADVERTISING_INTERVAL_MIN & 0xff00) >> 8;
    g_pattern_param.adv_param.Advertising_Interval_Min[0] = HCI_CMD_PARAM_ADVERTISING_INTERVAL_MIN & 0x00ff;
    g_pattern_param.adv_param.Advertising_Interval_Min[1] = (HCI_CMD_PARAM_ADVERTISING_INTERVAL_MIN & 0xff00) >> 8;
    verdict = COMM_ADV_NonConnectable_Advertising(dut2_fd, g_pattern_param);
    VERDICT_RESULT_WITH_LINE();    
    MSLEEP(500);

    while (check_cnt < 20) {
        if (SUCCESS != QUERY_LE_Event(dut1_fd, buf, _BT_HCI_LE_EVENT_SUB_OP_ADVERTISING_REPORT_, HCI_SUBEVENT_ADV_RPT_EVENT_NONCONN_IND)) {
            //query ADV report
            printf("****SUCCESS != QUERY_LE_Event****\n");
	        continue;
	    }				    
        else if (EQUAL == hci_le_event_advertising_report_parsing(HCI_SUBEVENT_ADV_RPT_EVENT_NONCONN_IND, buf, g_pattern_param)) {
             // Expect the IUT stop advertising                        
             printf("****EQUAL != HCI : %d****\n", err_cnt);             
             err_cnt++;
             if (50 <= err_cnt) {
                 line=__LINE__;
	            goto FUN_FAIL;
             }             
        }                        
        else {
             check_cnt ++ ;
             err_cnt = 0;
             printf("###run Loop : %d   ADV_Channel = %d ###\n", adv_cnt, adv_Channel);
             printf("** Upper Tester expects no HCI_LE_Advertising_Report event from the IUT : %d / 20 times **\n" , check_cnt);
        }
        MSLEEP(500);
    }

    COMM_SCN_Disable_Config(dut1,&g_pattern_param);
    verdict = COMM_SCN_Disable(dut1_fd,g_pattern_param);
    VERDICT_RESULT_WITH_LINE();
        
    COMM_ADV_Disable_Config(dut2,&g_pattern_param);
    verdict = COMM_ADV_Disable(dut2_fd,g_pattern_param);
    //VERDICT_RESULT_WITH_LINE();

    MSLEEP(100);
    COMM_Dut_clean_buffer(dut1_fd);
    COMM_Dut_clean_buffer(dut2_fd);
    
	printf("** CH : %d, Upper Tester expects no HCI_LE_Advertising_Report event from the IUT : %d / 20 times **\n" , adv_Channel, check_cnt);
	if(adv_Channel != 39){        
        adv_Channel ++;
		check_cnt = 0;
		err_cnt = 0;
        goto LOOP2;
    }
    else {
        adv_cnt++;
        check_cnt = 0;
		err_cnt = 0;
		adv_Channel = 37; // default
    }


LOOP3: 
    /****************************************************************************  
        case 3,
        SCN(IUT):            
            Type    : HCI_CMD_PARAM_PUBLIC_DEVICE_ADDRESS
            scn_policy = 0x01(HCI_CMD_PARAM_IGNORE_ADV_PKTS_FROM_DEV_NOT_IN_WHITE_LIST_ONLY),
        ADV(Low_T):
            Type    : HCI_CMD_PARAM_PUBLIC_DEVICE_ADDRESS
            Address : dut2_error_com_idf
        Result : Upper Tester expects an HCI_LE_Advertising_Report event from the IUT.
    *****************************************************************************/    
    // Uptest(white list) config
    COMM_INI_Connection_Setup_White_Listed_Config(dut1, &g_pattern_param);
    memcpy(g_pattern_param.white_list_param.Address, adv_addr, ADDR_LENGTH);
    g_pattern_param.white_list_param.Address_Type[0] = HCI_CMD_PARAM_PUBLIC_DEVICE_ADDRESS;
    verdict = COMM_INI_Connection_Setup_White_Listed(dut1_fd, g_pattern_param);
    VERDICT_RESULT_WITH_LINE();
    
    // ***********************************************************************************    
    COMM_SCN_Passive_Scanning_Config(dut1, &g_pattern_param);
    g_pattern_param.scn_param.LE_Scan_Interval[0] = 0xa0& 0x00ff;
    g_pattern_param.scn_param.LE_Scan_Interval[1] = (0xa0 & 0xff00) >> 8;
    g_pattern_param.scn_param.LE_Scan_Window[0] =   0xa0 & 0x00ff;
    g_pattern_param.scn_param.LE_Scan_Window[1] = (0xa0 & 0xff00) >> 8; 
    g_pattern_param.scn_param.Scanning_Filter_Policy[0] = HCI_CMD_PARAM_IGNORE_ADV_PKTS_FROM_DEV_NOT_IN_WHITE_LIST_ONLY;
    verdict = COMM_SCN_Passive_Scanning(dut1_fd, g_pattern_param);
    VERDICT_RESULT_WITH_LINE();
     
    // ***********************************************************************************    
    COMM_ADV_NonConnectable_Advertising_Config(HCI_CMD_PARAM_ADV_DATA_LEN_MAX, &g_pattern_param);
	COMM_ADV_NonConnectable_Advertising_Reconfig(&g_pattern_param);
	g_pattern_param.adv_param.Advertising_Interval_Max[0] = HCI_CMD_PARAM_ADVERTISING_INTERVAL_MIN & 0x00ff;
	g_pattern_param.adv_param.Advertising_Interval_Max[1] = (HCI_CMD_PARAM_ADVERTISING_INTERVAL_MIN & 0xff00) >> 8;
	g_pattern_param.adv_param.Advertising_Interval_Min[0] = HCI_CMD_PARAM_ADVERTISING_INTERVAL_MIN & 0x00ff;
	g_pattern_param.adv_param.Advertising_Interval_Min[1] = (HCI_CMD_PARAM_ADVERTISING_INTERVAL_MIN & 0xff00) >> 8;	
    if(37 == adv_Channel) {
        g_pattern_param.adv_param.Advertising_Channel_Map[0] = HCI_CMD_PARAM_ENABLE_CHANNEL_37;
    }
    else if(38 == adv_Channel) {
        g_pattern_param.adv_param.Advertising_Channel_Map[0] = HCI_CMD_PARAM_ENABLE_CHANNEL_38;
    }
    else {
        g_pattern_param.adv_param.Advertising_Channel_Map[0] = HCI_CMD_PARAM_ENABLE_CHANNEL_39;
    }    
    COMM_Static_Random_Device_Address_Set_Config(dut2_error_com_idf);
	COMM_Device_Address_Set(dut2_fd, g_pattern_param);
	memcpy(g_pattern_param.adv_param.Direct_Address, dut2_error_com_idf, ADDR_LENGTH);   	
    g_pattern_param.adv_param.Own_Address_Type[0] = HCI_CMD_PARAM_RANDOM_DEVICE_ADDRESS;        
    verdict = COMM_ADV_NonConnectable_Advertising(dut2_fd, g_pattern_param);
    VERDICT_RESULT_WITH_LINE();    
    MSLEEP(500);


    while (check_cnt < 20) {
        if (SUCCESS != QUERY_LE_Event(dut1_fd, buf, _BT_HCI_LE_EVENT_SUB_OP_ADVERTISING_REPORT_, HCI_SUBEVENT_ADV_RPT_EVENT_NONCONN_IND)) {
            //query ADV report
            printf("****SUCCESS != QUERY_LE_Event****\n");
	        continue;
	    }				    
        else if (EQUAL == hci_le_event_advertising_report_parsing(HCI_SUBEVENT_ADV_RPT_EVENT_NONCONN_IND, buf, g_pattern_param)) {
             // Expect the IUT stop advertising                        
             printf("****EQUAL != HCI : %d****\n", err_cnt);             
             err_cnt++;
             if (50 <= err_cnt) {
                 line=__LINE__;
	            goto FUN_FAIL;
             }             
        }                        
        else {
             check_cnt ++ ;
             err_cnt = 0;
             printf("###run Loop : %d   ADV_Channel = %d ###\n", adv_cnt, adv_Channel);
             printf("** Upper Tester expects no HCI_LE_Advertising_Report event from the IUT : %d / 20 times **\n" , check_cnt);
         }
        MSLEEP(500);
    }

    COMM_SCN_Disable_Config(dut1,&g_pattern_param);
    verdict = COMM_SCN_Disable(dut1_fd,g_pattern_param);
    VERDICT_RESULT_WITH_LINE();
        
    COMM_ADV_Disable_Config(dut2,&g_pattern_param);
    verdict = COMM_ADV_Disable(dut2_fd,g_pattern_param);
    VERDICT_RESULT_WITH_LINE();

    MSLEEP(100);
    COMM_Dut_clean_buffer(dut1_fd);
    COMM_Dut_clean_buffer(dut2_fd);
	
	printf("** CH : %d, Upper Tester expects no HCI_LE_Advertising_Report event from the IUT : %d / 20 times **\n" , adv_Channel, check_cnt);
	if(adv_Channel != 39){        
        adv_Channel ++;
		check_cnt = 0;
		err_cnt = 0;
        goto LOOP3;
    }
    else {
        adv_cnt++;
        check_cnt = 0;
		err_cnt = 0;
		adv_Channel = 37; // default
    }


LOOP4: 
    /****************************************************************************  
        case 4,
        SCN(IUT):            
            Type    : HCI_CMD_PARAM_PUBLIC_DEVICE_ADDRESS
            scn_policy = 0x01(HCI_CMD_PARAM_IGNORE_ADV_PKTS_FROM_DEV_NOT_IN_WHITE_LIST_ONLY),
        ADV(Low_T):
            Type    : HCI_CMD_PARAM_PUBLIC_DEVICE_ADDRESS
            Address : dut2_error_both
        Result : Upper Tester expects an HCI_LE_Advertising_Report event from the IUT.
    *****************************************************************************/    
    // Uptest(white list) config
    COMM_INI_Connection_Setup_White_Listed_Config(dut1, &g_pattern_param);
    memcpy(g_pattern_param.white_list_param.Address, adv_addr, ADDR_LENGTH);
    g_pattern_param.white_list_param.Address_Type[0] = HCI_CMD_PARAM_PUBLIC_DEVICE_ADDRESS;
    verdict = COMM_INI_Connection_Setup_White_Listed(dut1_fd, g_pattern_param);
    VERDICT_RESULT_WITH_LINE();
    
    // ***********************************************************************************    
    COMM_SCN_Passive_Scanning_Config(dut1, &g_pattern_param);
    g_pattern_param.scn_param.LE_Scan_Interval[0] = 0xa0& 0x00ff;
    g_pattern_param.scn_param.LE_Scan_Interval[1] = (0xa0 & 0xff00) >> 8;
    g_pattern_param.scn_param.LE_Scan_Window[0] =   0xa0 & 0x00ff;
    g_pattern_param.scn_param.LE_Scan_Window[1] = (0xa0 & 0xff00) >> 8; 
    g_pattern_param.scn_param.Scanning_Filter_Policy[0] = HCI_CMD_PARAM_IGNORE_ADV_PKTS_FROM_DEV_NOT_IN_WHITE_LIST_ONLY;
    verdict = COMM_SCN_Passive_Scanning(dut1_fd, g_pattern_param);
    VERDICT_RESULT_WITH_LINE();
     
    // ***********************************************************************************    
    COMM_ADV_NonConnectable_Advertising_Config(HCI_CMD_PARAM_ADV_DATA_LEN_MAX, &g_pattern_param);
	COMM_ADV_NonConnectable_Advertising_Reconfig(&g_pattern_param);
	g_pattern_param.adv_param.Advertising_Interval_Max[0] = HCI_CMD_PARAM_ADVERTISING_INTERVAL_MIN & 0x00ff;
	g_pattern_param.adv_param.Advertising_Interval_Max[1] = (HCI_CMD_PARAM_ADVERTISING_INTERVAL_MIN & 0xff00) >> 8;
	g_pattern_param.adv_param.Advertising_Interval_Min[0] = HCI_CMD_PARAM_ADVERTISING_INTERVAL_MIN & 0x00ff;
	g_pattern_param.adv_param.Advertising_Interval_Min[1] = (HCI_CMD_PARAM_ADVERTISING_INTERVAL_MIN & 0xff00) >> 8;	
    if(37 == adv_Channel) {
        g_pattern_param.adv_param.Advertising_Channel_Map[0] = HCI_CMD_PARAM_ENABLE_CHANNEL_37;
    }
    else if(38 == adv_Channel) {
        g_pattern_param.adv_param.Advertising_Channel_Map[0] = HCI_CMD_PARAM_ENABLE_CHANNEL_38;
    }
    else {
        g_pattern_param.adv_param.Advertising_Channel_Map[0] = HCI_CMD_PARAM_ENABLE_CHANNEL_39;
    }    
    COMM_Static_Random_Device_Address_Set_Config(dut2_error_both);
	COMM_Device_Address_Set(dut2_fd, g_pattern_param);
	memcpy(g_pattern_param.adv_param.Direct_Address, dut2_error_both, ADDR_LENGTH);   	
    g_pattern_param.adv_param.Own_Address_Type[0] = HCI_CMD_PARAM_RANDOM_DEVICE_ADDRESS;        
    verdict = COMM_ADV_NonConnectable_Advertising(dut2_fd, g_pattern_param);
    VERDICT_RESULT_WITH_LINE();    
    MSLEEP(500);

    while (check_cnt < 20) {
        if (SUCCESS != QUERY_LE_Event(dut1_fd, buf, _BT_HCI_LE_EVENT_SUB_OP_ADVERTISING_REPORT_, HCI_SUBEVENT_ADV_RPT_EVENT_NONCONN_IND)) {
            //query ADV report
            printf("****SUCCESS != QUERY_LE_Event****\n");
	        continue;
	    }				    
        else if (EQUAL == hci_le_event_advertising_report_parsing(HCI_SUBEVENT_ADV_RPT_EVENT_NONCONN_IND, buf, g_pattern_param)) {
             // Expect the IUT stop advertising                        
             printf("****EQUAL != HCI : %d****\n", err_cnt);             
             err_cnt++;
             if (50 <= err_cnt) {
                 line=__LINE__;
	            goto FUN_FAIL;
             }             
        }                        
        else {
             check_cnt ++ ;
             err_cnt = 0;
             printf("###run Loop : %d   ADV_Channel = %d ###\n", adv_cnt, adv_Channel);
             printf("** Upper Tester expects no HCI_LE_Advertising_Report event from the IUT : %d / 20 times **\n" , check_cnt);
        }
        MSLEEP(500);
    }

    COMM_SCN_Disable_Config(dut1,&g_pattern_param);
    verdict = COMM_SCN_Disable(dut1_fd,g_pattern_param);
    VERDICT_RESULT_WITH_LINE();
        
    COMM_ADV_Disable_Config(dut2,&g_pattern_param);
    verdict = COMM_ADV_Disable(dut2_fd,g_pattern_param);
    VERDICT_RESULT_WITH_LINE();

    MSLEEP(100);
    COMM_Dut_clean_buffer(dut1_fd);
    COMM_Dut_clean_buffer(dut2_fd);
    
	printf("** CH : %d, Upper Tester expects no HCI_LE_Advertising_Report event from the IUT : %d / 20 times **\n" , adv_Channel, check_cnt);
	if(adv_Channel != 39){        
        adv_Channel ++;
		check_cnt = 0;
		err_cnt = 0;
        goto LOOP4;
    }
    else {
        adv_cnt++;
        check_cnt = 0;
		err_cnt = 0;
		adv_Channel = 37; // default
    }
    FUNC_END();

    LOG_INFO("[Pattern][%s]SUCCESS\n" ,__FUNCTION__);
    return PASS; 

FUN_FAIL:   
    FUNC_END();

    LOG_INFO("[Pattern][%s]:%d FAIL, ADV_Channel = %d\n" ,__FUNCTION__, line, adv_Channel);
    return FAIL;

}

// 5.2.2.3
verdict DDI_SCN_Active_Scanning(u8 dut1_fd ,u8 dut2_fd)
{

	u8 buf[SOCKET_BUF_SIZE];
	int verdict=FAIL;
	int dut1=0,dut2=0;
	u16 line =0 ;
	u32 adv_cnt=0;
	int adv_Channel = 37;
	int com_ID_cnt = 0;
    int adv_fail_cnt = 0 ;
    int scan_rsp_fail_cnt = 0 ;
	int i;
	struct itimerval timer;	

    COMM_Dut_clean_buffer(dut1_fd);
    COMM_Dut_clean_buffer(dut2_fd);

    Calculate_Execution_Time_Start();
    COMM_SCN_Active_Scanning_Config(dut1,&g_pattern_param);
    g_pattern_param.scn_param.LE_Scan_Interval[0] =  0xa0 & 0x00ff;
    g_pattern_param.scn_param.LE_Scan_Interval[1] = (0xa0 & 0xff00) >> 8;
    g_pattern_param.scn_param.LE_Scan_Window[0] =    0xa0 & 0x00ff;
    g_pattern_param.scn_param.LE_Scan_Window[1] =   (0xa0 & 0xff00) >> 8;
	g_pattern_param.scn_param.Scanning_Filter_Policy[0] =	HCI_CMD_PARAM_ACCEPT_ALL_ADV_PKTS;
    
	verdict = COMM_SCN_Active_Scanning(dut1_fd,g_pattern_param);
	VERDICT_RESULT_WITH_LINE();

REPEAT:	
    printf("\n### ch %d |  com_ID %d | adv_cnt %d ###\n", adv_Channel , com_ID_cnt , adv_cnt);    

	COMM_ADV_Undirected_Advertising_Config(HCI_CMD_PARAM_ADV_DATA_LEN_MAX,&g_pattern_param);
	if(37 == adv_Channel) {
        g_pattern_param.adv_param.Advertising_Channel_Map[0] = HCI_CMD_PARAM_ENABLE_CHANNEL_37;
	}
	else if(38 == adv_Channel) {
	    g_pattern_param.adv_param.Advertising_Channel_Map[0] = HCI_CMD_PARAM_ENABLE_CHANNEL_38;
	}
	else {
	    g_pattern_param.adv_param.Advertising_Channel_Map[0] = HCI_CMD_PARAM_ENABLE_CHANNEL_39;
	}
	g_pattern_param.adv_param.Advertising_Interval_Max[0] =  HCI_CMD_PARAM_ADVERTISING_INTERVAL_MIN & 0x00ff;
	g_pattern_param.adv_param.Advertising_Interval_Max[1] = (HCI_CMD_PARAM_ADVERTISING_INTERVAL_MIN & 0xff00) >> 8;
	g_pattern_param.adv_param.Advertising_Interval_Min[0] =  HCI_CMD_PARAM_ADVERTISING_INTERVAL_MIN & 0x00ff;
	g_pattern_param.adv_param.Advertising_Interval_Min[1] = (HCI_CMD_PARAM_ADVERTISING_INTERVAL_MIN & 0xff00) >> 8;

    // Lwtest(SCN) config
    // use the correct company identifier and company assigned identifier default.
    
     if(com_ID_cnt == 1){
         //with an identical company assigned identifier
         //but a different company identifier
         COMM_Static_Random_Device_Address_Set_Config(dut2_error_com_idf);
         COMM_Device_Address_Set(dut2_fd, g_pattern_param);
         for(i=0; i<6; i++){
             g_pattern_param.adv_param.Direct_Address[i] = dut2_error_com_idf[i];
         }
         g_pattern_param.adv_param.Own_Address_Type[0] = HCI_CMD_PARAM_RANDOM_DEVICE_ADDRESS;             
         
     }
     else if(com_ID_cnt == 2){
         //with an identical company identifier
         //but a different company assigned identifier
         COMM_Static_Random_Device_Address_Set_Config(dut2_error_com_ass);
         COMM_Device_Address_Set(dut2_fd, g_pattern_param);
         for(i=0; i<6; i++){
             g_pattern_param.adv_param.Direct_Address[i] = dut2_error_com_ass[i];
         }
         g_pattern_param.adv_param.Own_Address_Type[0] = HCI_CMD_PARAM_RANDOM_DEVICE_ADDRESS;             
         
     }
     else if(com_ID_cnt == 3){
         //with different company identifier 
         //and company assigned identifier
         COMM_Static_Random_Device_Address_Set_Config(dut2_error_both);
         COMM_Device_Address_Set(dut2_fd, g_pattern_param);
         for(i=0; i<6; i++){
             g_pattern_param.adv_param.Direct_Address[i] = dut2_error_both[i];
         }
         g_pattern_param.adv_param.Own_Address_Type[0] = HCI_CMD_PARAM_RANDOM_DEVICE_ADDRESS;             
     }

	verdict=COMM_ADV_Undirected_Advertising(dut2_fd,g_pattern_param);
	VERDICT_RESULT_WITH_LINE();

	while(1)//waiting adv report event , timer or counter
	{
        printf("\n### ch %d |  com_ID %d | adv_cnt %d | adv_fail_cnt %d | scan_rsp_fail_cnt %d ###\n", 
            adv_Channel , com_ID_cnt , adv_cnt , adv_fail_cnt ,scan_rsp_fail_cnt);    
    
		//query adv_ind
		if (SUCCESS != QUERY_LE_Event(dut1_fd,buf ,
									_BT_HCI_LE_EVENT_SUB_OP_ADVERTISING_REPORT_,
									HCI_SUBEVENT_ADV_RPT_EVENT_ADV_IND))
		{
			line=__LINE__;
			goto FUN_FAIL;
		}
		else if(EQUAL != hci_le_event_advertising_report_parsing(HCI_SUBEVENT_ADV_RPT_EVENT_ADV_IND,
														buf,g_pattern_param))
		{
    		adv_fail_cnt ++ ;
            
            if (adv_fail_cnt < 300){
                MSLEEP(300);
    			continue;
            }else{            
                line = __LINE__;
                goto FUN_FAIL;
            }
            
		}
		else{
            adv_fail_cnt = 0;
            
			if(adv_cnt < 20){
				//stop adv
				COMM_ADV_Disable_Config(dut2,&g_pattern_param);
				verdict=COMM_ADV_Disable(dut2_fd,g_pattern_param);
				VERDICT_RESULT_WITH_LINE();

                MSLEEP(100);
                COMM_Dut_clean_buffer(dut1_fd);
                COMM_Dut_clean_buffer(dut2_fd);
				//reconfig adv param and start adv again
				g_pattern_param.adv_data_param.Advertising_Data[0]= adv_cnt;
				g_pattern_param.adv_data_param.Advertising_Data[1]= \
							g_pattern_param.adv_param.Advertising_Channel_Map[0];
				g_pattern_param.Advertising_Enable[0] = HCI_CMD_PARAM_ADV_ENABLE;
                
				verdict=COMM_ADV_Undirected_Advertising(dut2_fd,g_pattern_param);
				VERDICT_RESULT_WITH_LINE();
                
				adv_cnt ++;
				continue;
			}
			else{
				adv_cnt = 0;
                //go next
			}
		}


REPEAT2: 

        printf("\n### ch %d |  com_ID %d | adv_cnt %d | adv_fail_cnt %d | scan_rsp_fail_cnt %d ###\n", 
            adv_Channel , com_ID_cnt , adv_cnt , adv_fail_cnt ,scan_rsp_fail_cnt);    

		//query scan_rsp
		if (SUCCESS != QUERY_LE_Event(dut1_fd,buf ,
									_BT_HCI_LE_EVENT_SUB_OP_ADVERTISING_REPORT_,
									HCI_SUBEVENT_ADV_RPT_EVENT_SCAN_RSP))
		{
			line=__LINE__;
			goto FUN_FAIL;
		}else if(EQUAL != hci_le_event_advertising_report_parsing(HCI_SUBEVENT_ADV_RPT_EVENT_SCAN_RSP,
														buf,g_pattern_param))
		{
    		scan_rsp_fail_cnt ++ ;
            if (scan_rsp_fail_cnt < 100){
                MSLEEP(300);
                goto REPEAT2;
    			//continue;
            }else{
                line = __LINE__;
                goto FUN_FAIL;
            }

		}
		else{
            
    		scan_rsp_fail_cnt = 0 ;
		}

        //verify different company ID per channel
        if(com_ID_cnt !=3){
            com_ID_cnt ++;
            adv_cnt = 0;
        
            //COMM_Reset(dut1_fd);
            COMM_ADV_Disable_Config(dut2,&g_pattern_param);
            verdict=COMM_ADV_Disable(dut2_fd,g_pattern_param);

            MSLEEP(100);
            COMM_Dut_clean_buffer(dut1_fd);
            COMM_Dut_clean_buffer(dut2_fd);
            
            VERDICT_RESULT_WITH_LINE();
            goto REPEAT;
        }
        else{
            if(adv_Channel != 39){
                com_ID_cnt=0;
                adv_Channel ++;
                adv_cnt = 0;
        
                //COMM_Reset(dut1_fd);
                COMM_ADV_Disable_Config(dut2,&g_pattern_param);
                verdict=COMM_ADV_Disable(dut2_fd,g_pattern_param);

                MSLEEP(100);
                COMM_Dut_clean_buffer(dut1_fd);
                COMM_Dut_clean_buffer(dut2_fd);
                
                VERDICT_RESULT_WITH_LINE();
                goto REPEAT;
            }
            else{                    
                FUNC_END();

                LOG_INFO("[Pattern][%s]SUCCESS\n" ,__FUNCTION__);
                return PASS;
            }
        }


	}

FUN_FAIL:    
    FUNC_END();

	LOG_INFO("[Pattern][%s]:%d FAIL : ch %d \n" ,__FUNCTION__,line ,adv_Channel);
    return FAIL;

}

// 5.2.2.4
verdict DDI_SCN_Active_Scanning_Device_Filtering(u8 dut1_fd ,u8 dut2_fd)
{
	u8 buf[SOCKET_BUF_SIZE];	
    int err_cnt = 0;	
    int check_cnt = 0;
	int verdict = FAIL;
	int dut1 = 0;
    int dut2 = 0;
	u16 line = 0;
    int adv_Channel = 37;	
	struct itimerval timer;	

    COMM_Dut_clean_buffer(dut1_fd);
    COMM_Dut_clean_buffer(dut2_fd);

    // Uptest(white list) config
    Calculate_Execution_Time_Start();
    COMM_INI_Connection_Setup_White_Listed_Config(dut1, &g_pattern_param);
    memcpy(g_pattern_param.white_list_param.Address, adv_addr, ADDR_LENGTH);
    g_pattern_param.white_list_param.Address_Type[0] = HCI_CMD_PARAM_PUBLIC_DEVICE_ADDRESS;
    verdict = COMM_INI_Connection_Setup_White_Listed(dut1_fd, g_pattern_param);
    VERDICT_RESULT_WITH_LINE();

	//p2
	COMM_SCN_Active_Scanning_Config(dut1, &g_pattern_param);
    g_pattern_param.scn_param.Scanning_Filter_Policy[0] = HCI_CMD_PARAM_IGNORE_ADV_PKTS_FROM_DEV_NOT_IN_WHITE_LIST_ONLY;
    g_pattern_param.scn_param.LE_Scan_Interval[0] =  (0xa0)& 0x00ff;
    g_pattern_param.scn_param.LE_Scan_Interval[1] =  (0xa0 & 0xff00) >> 8;
    g_pattern_param.scn_param.LE_Scan_Window[0] =    (0xa0)& 0x00ff;
    g_pattern_param.scn_param.LE_Scan_Window[1] =    (0xa0 & 0xff00) >> 8; 
    verdict = COMM_SCN_Active_Scanning(dut1_fd, g_pattern_param);
    VERDICT_RESULT_WITH_LINE();

REPEAT:	
    // Uptest(white list) config
	//p1
	COMM_ADV_Undirected_Advertising_Config(HCI_CMD_PARAM_ADV_DATA_LEN_MAX, &g_pattern_param);	
	g_pattern_param.adv_param.Advertising_Interval_Max[0] =  HCI_CMD_PARAM_ADVERTISING_INTERVAL_MIN & 0x00ff;
	g_pattern_param.adv_param.Advertising_Interval_Max[1] = (HCI_CMD_PARAM_ADVERTISING_INTERVAL_MIN & 0xff00) >> 8;
	g_pattern_param.adv_param.Advertising_Interval_Min[0] =  HCI_CMD_PARAM_ADVERTISING_INTERVAL_MIN & 0x00ff;
	g_pattern_param.adv_param.Advertising_Interval_Min[1] = (HCI_CMD_PARAM_ADVERTISING_INTERVAL_MIN & 0xff00) >> 8;	
    if(37 == adv_Channel) {
        g_pattern_param.adv_param.Advertising_Channel_Map[0] = HCI_CMD_PARAM_ENABLE_CHANNEL_37;		
    }
    else if(38 == adv_Channel) {
        g_pattern_param.adv_param.Advertising_Channel_Map[0] = HCI_CMD_PARAM_ENABLE_CHANNEL_38;
    }
    else {
        g_pattern_param.adv_param.Advertising_Channel_Map[0] = HCI_CMD_PARAM_ENABLE_CHANNEL_39;        
    }
	verdict = COMM_ADV_Undirected_Advertising(dut2_fd, g_pattern_param);
	VERDICT_RESULT_WITH_LINE();
	
    while (check_cnt < 20) {
        if (SUCCESS != QUERY_LE_Event(dut1_fd, buf, _BT_HCI_LE_EVENT_SUB_OP_ADVERTISING_REPORT_
                                                  , HCI_SUBEVENT_ADV_RPT_EVENT_ADV_IND)) {
            //query ADV report
            printf("****SUCCESS != QUERY_LE_Event****\n");
	        continue;
	    }				    
        else if (EQUAL != hci_le_event_advertising_report_parsing(HCI_SUBEVENT_ADV_RPT_EVENT_ADV_IND, buf, g_pattern_param)) {                 
             printf("****EQUAL != HCI_err : %d, right_Cnt = %d ****\n", err_cnt, check_cnt);             
             err_cnt++;
             if (err_cnt > 50) {
                 line=__LINE__;
	            goto FUN_FAIL;
             }                 
        }        
        else {
             check_cnt ++ ;
             err_cnt = 0;
             printf("###ADV_Channel = %d ###\n", adv_Channel);
             printf("** 1.Upper Tester expects an HCI_LE_Advertising_Report event from the IUT : %d / 20 times **\n" , check_cnt);
        }
        MSLEEP(300);
    }

    err_cnt = 0;
    check_cnt = 0;
    
    while (check_cnt < 20) {
        if (SUCCESS != QUERY_LE_Event(dut1_fd, buf, _BT_HCI_LE_EVENT_SUB_OP_ADVERTISING_REPORT_
                                                  , HCI_SUBEVENT_ADV_RPT_EVENT_SCAN_RSP)) {
            printf("****SUCCESS != QUERY_LE_Event****\n");
	        continue;
        }            
        else if(EQUAL != hci_le_event_advertising_report_parsing(HCI_SUBEVENT_ADV_RPT_EVENT_SCAN_RSP, buf, g_pattern_param)) {
            printf("****EQUAL != HCI_err : %d, right_Cnt = %d ****\n", err_cnt, check_cnt);             
             err_cnt++;
             if (err_cnt > 100) {
                 line=__LINE__;
	            goto FUN_FAIL;
             }
        }        
        else {
             check_cnt ++ ;
             err_cnt = 0;
             printf("###ADV_Channel = %d ###\n", adv_Channel);
             printf("** 1.Upper Tester expects an RSP event from the IUT : %d / 20 times **\n" , check_cnt);
        }
        MSLEEP(300);
    }

    // using a non white listed device address and a public address type. 
    // The device address has a different company assigned identifier and the same company identifier as IUT. 
    // Scan response is also configured in the Lower Tester

    /*COMM_Reset(dut1_fd);
    COMM_Reset(dut2_fd);

    COMM_INI_Connection_Setup_White_Listed_Config(dut1, &g_pattern_param);
    memcpy(g_pattern_param.white_list_param.Address, adv_addr, ADDR_LENGTH);
    g_pattern_param.white_list_param.Address_Type[0] = HCI_CMD_PARAM_PUBLIC_DEVICE_ADDRESS;
    verdict = COMM_INI_Connection_Setup_White_Listed(dut1_fd, g_pattern_param);
    VERDICT_RESULT_WITH_LINE();

	//p2
	COMM_SCN_Active_Scanning_Config(dut1, &g_pattern_param);
    g_pattern_param.scn_param.Scanning_Filter_Policy[0] = HCI_CMD_PARAM_IGNORE_ADV_PKTS_FROM_DEV_NOT_IN_WHITE_LIST_ONLY;
	g_pattern_param.scn_param.LE_Scan_Interval[0] = 0xa0& 0x00ff;
	g_pattern_param.scn_param.LE_Scan_Interval[1] = (0xa0 & 0xff00) >> 8;
	g_pattern_param.scn_param.LE_Scan_Window[0] =	0xa0 & 0x00ff;
	g_pattern_param.scn_param.LE_Scan_Window[1] = (0xa0 & 0xff00) >> 8;	
	verdict = COMM_SCN_Active_Scanning(dut1_fd, g_pattern_param);
	VERDICT_RESULT_WITH_LINE();

	//p1
	COMM_ADV_Undirected_Advertising_Config(HCI_CMD_PARAM_ADV_DATA_LEN_MAX, &g_pattern_param);
    COMM_Static_Random_Device_Address_Set_Config(dut2_error_com_idf);
	COMM_Device_Address_Set(dut2_fd, g_pattern_param);
	memcpy(g_pattern_param.adv_param.Direct_Address, dut2_error_com_idf, ADDR_LENGTH);
    g_pattern_param.adv_param.Own_Address_Type[0] = HCI_CMD_PARAM_RANDOM_DEVICE_ADDRESS;
	g_pattern_param.adv_param.Advertising_Interval_Max[0] = HCI_CMD_PARAM_ADVERTISING_INTERVAL_MIN & 0x00ff;
	g_pattern_param.adv_param.Advertising_Interval_Max[1] = (HCI_CMD_PARAM_ADVERTISING_INTERVAL_MIN & 0xff00) >> 8;
	g_pattern_param.adv_param.Advertising_Interval_Min[0] = HCI_CMD_PARAM_ADVERTISING_INTERVAL_MIN & 0x00ff;
	g_pattern_param.adv_param.Advertising_Interval_Min[1] = (HCI_CMD_PARAM_ADVERTISING_INTERVAL_MIN & 0xff00) >> 8;	
    if(37 == adv_Channel) {
        g_pattern_param.adv_param.Advertising_Channel_Map[0] = HCI_CMD_PARAM_ENABLE_CHANNEL_37;		
    }
    else if(38 == adv_Channel) {
        g_pattern_param.adv_param.Advertising_Channel_Map[0] = HCI_CMD_PARAM_ENABLE_CHANNEL_38;
    }
    else {
        g_pattern_param.adv_param.Advertising_Channel_Map[0] = HCI_CMD_PARAM_ENABLE_CHANNEL_39;        
    }
	verdict = COMM_ADV_Undirected_Advertising(dut2_fd, g_pattern_param);
	VERDICT_RESULT_WITH_LINE();
	
    while (check_cnt < 20) {
        if (SUCCESS != QUERY_LE_Event(dut1_fd, buf, _BT_HCI_LE_EVENT_SUB_OP_ADVERTISING_REPORT_, HCI_SUBEVENT_ADV_RPT_EVENT_ADV_IND)) {
            //query ADV report
            printf("****SUCCESS != QUERY_LE_Event****\n");
	        continue;
	    }				    
        else if (EQUAL == hci_le_event_advertising_report_parsing(HCI_SUBEVENT_ADV_RPT_EVENT_ADV_IND, buf, g_pattern_param)) {                 
             printf("****EQUAL != HCI_err : %d, right_Cnt = %d ****\n", err_cnt, check_cnt);             
             err_cnt++;
             if (err_cnt > 50) {
                 line=__LINE__;
	            goto FUN_FAIL;
             }                 
        }        
        else {
             check_cnt ++ ;
             err_cnt = 0;
             printf("###ADV_Channel = %d ###\n", adv_Channel);
             printf("** 2.Upper Tester expects no HCI_LE_Advertising_Report event from the IUT : %d / 20 times **\n" , check_cnt);
         }
         usleep(200000);
    }

    err_cnt = 0;
    check_cnt = 0;
    while (check_cnt < 20) {
        if (SUCCESS != QUERY_LE_Event(dut1_fd, buf, _BT_HCI_LE_EVENT_SUB_OP_ADVERTISING_REPORT_, HCI_SUBEVENT_ADV_RPT_EVENT_SCAN_RSP)) {
            printf("****SUCCESS != QUERY_LE_Event****\n");
	        continue;
        }            
        else if(EQUAL == hci_le_event_advertising_report_parsing(HCI_SUBEVENT_ADV_RPT_EVENT_SCAN_RSP, buf, g_pattern_param)) {
            printf("****EQUAL != HCI_err : %d, right_Cnt = %d ****\n", err_cnt, check_cnt);             
             err_cnt++;
             if (err_cnt > 50) {
                 line=__LINE__;
	            goto FUN_FAIL;
             }
        }        
        else {
             check_cnt ++ ;
             err_cnt = 0;
             printf("###ADV_Channel = %d ###\n", adv_Channel);
             printf("** 2.Upper Tester expects no RSP event from the IUT : %d / 20 times **\n" , check_cnt);
         }
         usleep(200000);
    }

    COMM_Reset(dut1_fd);
    COMM_Reset(dut2_fd);

    // using a non white listed device address and a public address type.
    // The device address has a different company assigned identifier and company identifier as IUT. 
    // Scan response is also configured in the Lower Tester
    
    COMM_INI_Connection_Setup_White_Listed_Config(dut1, &g_pattern_param);
    memcpy(g_pattern_param.white_list_param.Address, adv_addr, ADDR_LENGTH);
    g_pattern_param.white_list_param.Address_Type[0] = HCI_CMD_PARAM_PUBLIC_DEVICE_ADDRESS;
    verdict = COMM_INI_Connection_Setup_White_Listed(dut1_fd, g_pattern_param);
    VERDICT_RESULT_WITH_LINE();

	//p2
	COMM_SCN_Active_Scanning_Config(dut1, &g_pattern_param);
    g_pattern_param.scn_param.Scanning_Filter_Policy[0] = HCI_CMD_PARAM_IGNORE_ADV_PKTS_FROM_DEV_NOT_IN_WHITE_LIST_ONLY;
	g_pattern_param.scn_param.LE_Scan_Interval[0] = 0xa0& 0x00ff;
	g_pattern_param.scn_param.LE_Scan_Interval[1] = (0xa0 & 0xff00) >> 8;
	g_pattern_param.scn_param.LE_Scan_Window[0] =	0xa0 & 0x00ff;
	g_pattern_param.scn_param.LE_Scan_Window[1] = (0xa0 & 0xff00) >> 8;	
	verdict = COMM_SCN_Active_Scanning(dut1_fd, g_pattern_param);
	VERDICT_RESULT_WITH_LINE();

	//p1
	COMM_ADV_Undirected_Advertising_Config(HCI_CMD_PARAM_ADV_DATA_LEN_MAX, &g_pattern_param);
    COMM_Static_Random_Device_Address_Set_Config(dut2_error_both);
	COMM_Device_Address_Set(dut2_fd, g_pattern_param);
	memcpy(g_pattern_param.adv_param.Direct_Address, dut2_error_both, ADDR_LENGTH);
    g_pattern_param.adv_param.Own_Address_Type[0] = HCI_CMD_PARAM_RANDOM_DEVICE_ADDRESS;
	g_pattern_param.adv_param.Advertising_Interval_Max[0] = HCI_CMD_PARAM_ADVERTISING_INTERVAL_MIN & 0x00ff;
	g_pattern_param.adv_param.Advertising_Interval_Max[1] = (HCI_CMD_PARAM_ADVERTISING_INTERVAL_MIN & 0xff00) >> 8;
	g_pattern_param.adv_param.Advertising_Interval_Min[0] = HCI_CMD_PARAM_ADVERTISING_INTERVAL_MIN & 0x00ff;
	g_pattern_param.adv_param.Advertising_Interval_Min[1] = (HCI_CMD_PARAM_ADVERTISING_INTERVAL_MIN & 0xff00) >> 8;	
    if(37 == adv_Channel) {
        g_pattern_param.adv_param.Advertising_Channel_Map[0] = HCI_CMD_PARAM_ENABLE_CHANNEL_37;		
    }
    else if(38 == adv_Channel) {
        g_pattern_param.adv_param.Advertising_Channel_Map[0] = HCI_CMD_PARAM_ENABLE_CHANNEL_38;
    }
    else {
        g_pattern_param.adv_param.Advertising_Channel_Map[0] = HCI_CMD_PARAM_ENABLE_CHANNEL_39;        
    }
	verdict = COMM_ADV_Undirected_Advertising(dut2_fd, g_pattern_param);
	VERDICT_RESULT_WITH_LINE();
	
    while (check_cnt < 20) {
        if (SUCCESS != QUERY_LE_Event(dut1_fd, buf, _BT_HCI_LE_EVENT_SUB_OP_ADVERTISING_REPORT_, HCI_SUBEVENT_ADV_RPT_EVENT_ADV_IND)) {
            //query ADV report
            printf("****SUCCESS != QUERY_LE_Event****\n");
	        continue;
	    }				    
        else if (EQUAL == hci_le_event_advertising_report_parsing(HCI_SUBEVENT_ADV_RPT_EVENT_ADV_IND, buf, g_pattern_param)) {                 
             printf("****EQUAL != HCI_err : %d, right_Cnt = %d ****\n", err_cnt, check_cnt);             
             err_cnt++;
             if (err_cnt > 50) {
                 line=__LINE__;
	            goto FUN_FAIL;
             }                 
        }        
        else {
             check_cnt ++ ;
             err_cnt = 0;
             printf("###ADV_Channel = %d ###\n", adv_Channel);
             printf("** 3.Upper Tester expects no HCI_LE_Advertising_Report event from the IUT : %d / 20 times **\n" , check_cnt);
         }
         usleep(200000);
    }

    err_cnt = 0;
    check_cnt = 0;
    while (check_cnt < 20) {
        if (SUCCESS != QUERY_LE_Event(dut1_fd, buf, _BT_HCI_LE_EVENT_SUB_OP_ADVERTISING_REPORT_, HCI_SUBEVENT_ADV_RPT_EVENT_SCAN_RSP)) {
            printf("****SUCCESS != QUERY_LE_Event****\n");
	        continue;
        }            
        else if(EQUAL == hci_le_event_advertising_report_parsing(HCI_SUBEVENT_ADV_RPT_EVENT_SCAN_RSP, buf, g_pattern_param)) {
            printf("****EQUAL != HCI_err : %d, right_Cnt = %d ****\n", err_cnt, check_cnt);             
             err_cnt++;
             if (err_cnt > 50) {
                 line=__LINE__;
	            goto FUN_FAIL;
             }
        }        
        else {
             check_cnt ++ ;
             err_cnt = 0;
             printf("###ADV_Channel = %d ###\n", adv_Channel);
             printf("** 3.Upper Tester expects no RSP event from the IUT : %d / 20 times **\n" , check_cnt);
         }
         usleep(200000);
    }*/

	//COMM_Reset(dut1_fd);
    COMM_ADV_Disable_Config(dut2,&g_pattern_param);
    verdict = COMM_ADV_Disable(dut2_fd,g_pattern_param);
    VERDICT_RESULT_WITH_LINE();
	if(adv_Channel != 39){        
        adv_Channel ++;
		check_cnt = 0;
		err_cnt = 0;
        goto REPEAT;
    }    
    FUNC_END();

    LOG_INFO("[Pattern][%s]SUCCESS\n" ,__FUNCTION__);
    return PASS;

FUN_FAIL:	
    FUNC_END();

	LOG_INFO("[Pattern][%s]:%d FAIL, ADV_Channel = %d\n" ,__FUNCTION__, line, adv_Channel);
    return FAIL;
}

// 5.2.2.5
verdict DDI_SCN_Scanning_For_Advertiser_Types(u8 dut1_fd ,u8 dut2_fd)
{
	u8 buf[SOCKET_BUF_SIZE];	
    int err_cnt = 0;	
    int check_cnt = 0;
	int verdict = FAIL;
	int dut1 = 0;
	u16 line = 0;
    int adv_Channel = 37;	
	struct itimerval timer;	

    COMM_Dut_clean_buffer(dut1_fd);
    COMM_Dut_clean_buffer(dut2_fd);
    
    Calculate_Execution_Time_Start();

    COMM_Static_Random_Device_Address_Set_Config(scan_addr);
    COMM_Device_Address_Set(dut1_fd, g_pattern_param);
    COMM_SCN_Passive_Scanning_Config(dut1, &g_pattern_param);   
    g_pattern_param.scn_param.Own_Address_Type[0]   =   HCI_CMD_PARAM_RANDOM_DEVICE_ADDRESS;
    g_pattern_param.scn_param.LE_Scan_Interval[0] = 0xa0& 0x00ff;
    g_pattern_param.scn_param.LE_Scan_Interval[1] = (0xa0 & 0xff00) >> 8;
    g_pattern_param.scn_param.LE_Scan_Window[0] =   0xa0 & 0x00ff;
    g_pattern_param.scn_param.LE_Scan_Window[1] = (0xa0 & 0xff00) >> 8; 
    verdict = COMM_SCN_Passive_Scanning(dut1_fd, g_pattern_param);
    VERDICT_RESULT_WITH_LINE();
    
REPEAT:
	    
	//p1
    if(37 == adv_Channel) {
        COMM_Static_Random_Device_Address_Set_Config(dut2_error_com_ass);
		COMM_Device_Address_Set(dut2_fd, g_pattern_param);		
        COMM_ADV_NonConnectable_Advertising_Config(HCI_CMD_PARAM_ADV_DATA_LEN_MAX, &g_pattern_param);
		memcpy(g_pattern_param.adv_param.Direct_Address, dut2_error_com_ass, ADDR_LENGTH);
    	g_pattern_param.adv_param.Own_Address_Type[0]	= HCI_CMD_PARAM_RANDOM_DEVICE_ADDRESS;
    	g_pattern_param.adv_param.Advertising_Interval_Max[0] =  HCI_CMD_PARAM_ADVERTISING_INTERVAL_MIN & 0x00ff;
    	g_pattern_param.adv_param.Advertising_Interval_Max[1] = (HCI_CMD_PARAM_ADVERTISING_INTERVAL_MIN & 0xff00) >> 8;
    	g_pattern_param.adv_param.Advertising_Interval_Min[0] =  HCI_CMD_PARAM_ADVERTISING_INTERVAL_MIN & 0x00ff;
    	g_pattern_param.adv_param.Advertising_Interval_Min[1] = (HCI_CMD_PARAM_ADVERTISING_INTERVAL_MIN & 0xff00) >> 8;    	
        g_pattern_param.adv_param.Advertising_Channel_Map[0] = HCI_CMD_PARAM_ENABLE_CHANNEL_37;         
        verdict = COMM_ADV_NonConnectable_Advertising(dut2_fd,g_pattern_param);
        VERDICT_RESULT_WITH_LINE();
    }
    else if(38 == adv_Channel) {
        COMM_Static_Random_Device_Address_Set_Config(dut2_error_com_idf);
		COMM_Device_Address_Set(dut2_fd, g_pattern_param);		
        COMM_ADV_Discoverable_Advertising_Config(HCI_CMD_PARAM_ADV_DATA_LEN_MAX, &g_pattern_param);
		memcpy(g_pattern_param.adv_param.Direct_Address, dut2_error_com_idf, ADDR_LENGTH);
    	g_pattern_param.adv_param.Own_Address_Type[0]	= HCI_CMD_PARAM_RANDOM_DEVICE_ADDRESS;
    	g_pattern_param.adv_param.Advertising_Interval_Max[0] =  HCI_CMD_PARAM_ADVERTISING_INTERVAL_MIN & 0x00ff;
    	g_pattern_param.adv_param.Advertising_Interval_Max[1] = (HCI_CMD_PARAM_ADVERTISING_INTERVAL_MIN & 0xff00) >> 8;
    	g_pattern_param.adv_param.Advertising_Interval_Min[0] =  HCI_CMD_PARAM_ADVERTISING_INTERVAL_MIN & 0x00ff;
    	g_pattern_param.adv_param.Advertising_Interval_Min[1] = (HCI_CMD_PARAM_ADVERTISING_INTERVAL_MIN & 0xff00) >> 8;    	
        g_pattern_param.adv_param.Advertising_Channel_Map[0] = HCI_CMD_PARAM_ENABLE_CHANNEL_38;         
        verdict = COMM_ADV_Discoverable_Advertising(dut2_fd,g_pattern_param);
        VERDICT_RESULT_WITH_LINE();
    }
    else {
		COMM_Static_Random_Device_Address_Set_Config(dut2_error_both);
		COMM_Device_Address_Set(dut2_fd, g_pattern_param);		
        COMM_ADV_Directed_Advertising_Config(HCI_CMD_PARAM_ADV_DATA_LEN_MAX, &g_pattern_param);	
		memcpy(g_pattern_param.adv_param.Direct_Address, scan_addr, ADDR_LENGTH);
		g_pattern_param.adv_param.Own_Address_Type[0] = HCI_CMD_PARAM_RANDOM_DEVICE_ADDRESS;
		g_pattern_param.adv_param.Direct_Address_Type[0] = HCI_CMD_PARAM_RANDOM_DEVICE_ADDRESS;
    	g_pattern_param.adv_param.Advertising_Interval_Max[0] = HCI_CMD_PARAM_ADVERTISING_INTERVAL_MIN & 0x00ff;
    	g_pattern_param.adv_param.Advertising_Interval_Max[1] = (HCI_CMD_PARAM_ADVERTISING_INTERVAL_MIN & 0xff00) >> 8;
    	g_pattern_param.adv_param.Advertising_Interval_Min[0] = HCI_CMD_PARAM_ADVERTISING_INTERVAL_MIN & 0x00ff;
    	g_pattern_param.adv_param.Advertising_Interval_Min[1] = (HCI_CMD_PARAM_ADVERTISING_INTERVAL_MIN & 0xff00) >> 8;	
        g_pattern_param.adv_param.Advertising_Channel_Map[0] = HCI_CMD_PARAM_ENABLE_CHANNEL_39;		
		g_pattern_param.adv_data_param.Advertising_Data_Length[0] = 0;		        
        verdict = COMM_ADV_Directed_Advertising(dut2_fd, g_pattern_param);
	    VERDICT_RESULT_WITH_LINE();        
    }		
	
    while (check_cnt < 20) {
        if (37 == adv_Channel) {
            if (SUCCESS != QUERY_LE_Event(dut1_fd, buf, _BT_HCI_LE_EVENT_SUB_OP_ADVERTISING_REPORT_, HCI_CMD_PARAM_ADV_NONCONN_IND)) {
                //query ADV report
                printf("****SUCCESS != QUERY_LE_Event****\n");
    	        continue;
    	    }				    
            else if (EQUAL != hci_le_event_advertising_report_parsing(HCI_SUBEVENT_ADV_RPT_EVENT_NONCONN_IND, buf, g_pattern_param)) {             
                 printf("****EQUAL != HCI_err : %d, right_Cnt = %d ****\n", err_cnt, check_cnt);             
                 err_cnt++;
                 if (err_cnt > 50) {
                     line=__LINE__;
    	            goto FUN_FAIL;
                 }             
            }                        
            else {
                 check_cnt ++ ;
                 err_cnt = 0;
                 printf("###ADV_Channel = %d ###\n", adv_Channel);
                 printf("** IUT expects an ADV_NONCONN_IND event from the Lower Tester : %d / 20 times **\n" , check_cnt);
            }
            MSLEEP(300);
        }
        else if (38 == adv_Channel) {
            if (SUCCESS != QUERY_LE_Event(dut1_fd, buf, _BT_HCI_LE_EVENT_SUB_OP_ADVERTISING_REPORT_, HCI_CMD_PARAM_ADV_SCAN_IND)) {
                //query ADV report
                printf("****SUCCESS != QUERY_LE_Event****\n");
    	        continue;
    	    }				    
            else if (EQUAL != hci_le_event_advertising_report_parsing(HCI_SUBEVENT_ADV_RPT_EVENT_SCAN_IND, buf, g_pattern_param)) {             
                printf("****EQUAL != HCI_err : %d, right_Cnt = %d ****\n", err_cnt, check_cnt);             
                err_cnt++;
                if (err_cnt > 50) {
                    line=__LINE__;
    	           goto FUN_FAIL;
                }             
            }            
            else {
                 check_cnt ++ ;
                 err_cnt = 0;
                 printf("###ADV_Channel = %d ###\n", adv_Channel);
                 printf("** IUT expects an ADV_SCAN_IND event from the Lower Tester : %d / 20 times **\n" , check_cnt);
            }
            MSLEEP(300);
        }
        else {
            if (SUCCESS != QUERY_LE_Event(dut1_fd, buf, _BT_HCI_LE_EVENT_SUB_OP_ADVERTISING_REPORT_, HCI_SUBEVENT_ADV_RPT_EVENT_DIRECT_IND)) {
                //query ADV report
                printf("****SUCCESS != QUERY_LE_Event****\n");
    	        continue;
    	    }				    
            else if (EQUAL != hci_le_event_advertising_report_parsing(HCI_SUBEVENT_ADV_RPT_EVENT_DIRECT_IND, buf, g_pattern_param)) {
                 
                 printf("****EQUAL != HCI_err : %d, right_Cnt = %d ****\n", err_cnt, check_cnt);             
                 err_cnt++;

                 if (err_cnt == 100) {
                    verdict = COMM_ADV_Directed_Advertising(dut2_fd, g_pattern_param);
                    VERDICT_RESULT_WITH_LINE();  
                 }
                 
                 if (err_cnt > 200) {
                     line=__LINE__;
    	            goto FUN_FAIL;
                 }                 
            }                        
            else {
                 check_cnt ++ ;
                 err_cnt = 0;
                 printf("###ADV_Channel = %d ###\n", adv_Channel);
                 printf("** Upper Tester expects an HCI_LE_Advertising_Report event from the IUT : %d / 20 times **\n" , check_cnt);
            }
            
            MSLEEP(10);
        }
    }
	//dut_reset_with_mask_en(dut1_fd);
    dut_reset_with_mask_en(dut2_fd);
    MSLEEP(500);

	if(adv_Channel != 39){        
        adv_Channel ++;
		check_cnt = 0;
		err_cnt = 0;
        goto REPEAT;
    }    
    
    FUNC_END();

    LOG_INFO("[Pattern][%s]SUCCESS\n" ,__FUNCTION__);
    return PASS;

FUN_FAIL:	
    FUNC_END();

	LOG_INFO("[Pattern][%s]:%d FAIL, ADV_Channel = %d\n" ,__FUNCTION__, line, adv_Channel);
    return FAIL;

}

// 5.2.2.6
verdict DDI_SCN_Passive_Scanning_Undirected_Events(u8 dut1_fd ,u8 dut2_fd)
{
    u8 buf[SOCKET_BUF_SIZE];
    int verdict=FAIL;
    int dut1=0,dut2=0;
    u16 line =0 ;
    u32 adv_cnt=0;
    int adv_Channel = 37;
    int com_ID_cnt = 0;
    int i;
    u16 adv_chk_err = 0;
	struct itimerval timer;	

    COMM_Dut_clean_buffer(dut1_fd);
    COMM_Dut_clean_buffer(dut2_fd);

    Calculate_Execution_Time_Start();
    COMM_SCN_Passive_Scanning_Config(dut1,&g_pattern_param);
    g_pattern_param.scn_param.LE_Scan_Interval[0] =  0xa0 & 0x00ff;
    g_pattern_param.scn_param.LE_Scan_Interval[1] = (0xa0 & 0xff00) >> 8;
    g_pattern_param.scn_param.LE_Scan_Window[0] =    0xa0 & 0x00ff;
    g_pattern_param.scn_param.LE_Scan_Window[1] =   (0xa0 & 0xff00) >> 8;
    g_pattern_param.scn_param.Scanning_Filter_Policy[0] =   HCI_CMD_PARAM_ACCEPT_ALL_ADV_PKTS;
    
    verdict=COMM_SCN_Passive_Scanning(dut1_fd,g_pattern_param);
    VERDICT_RESULT_WITH_LINE();

REPEAT: 
    printf("\n### ch %d |  com_ID %d | adv_cnt %d ###\n", adv_Channel , com_ID_cnt , adv_cnt);    

    COMM_ADV_Undirected_Advertising_Config(HCI_CMD_PARAM_ADV_DATA_LEN_MAX,&g_pattern_param);
    if(37 == adv_Channel) {
        g_pattern_param.adv_param.Advertising_Channel_Map[0] = HCI_CMD_PARAM_ENABLE_CHANNEL_37;
    }
    else if(38 == adv_Channel) {
        g_pattern_param.adv_param.Advertising_Channel_Map[0] = HCI_CMD_PARAM_ENABLE_CHANNEL_38;
    }
    else {
        g_pattern_param.adv_param.Advertising_Channel_Map[0] = HCI_CMD_PARAM_ENABLE_CHANNEL_39;
    }
    g_pattern_param.adv_param.Advertising_Interval_Max[0] =  HCI_CMD_PARAM_ADVERTISING_INTERVAL_MIN & 0x00ff;
    g_pattern_param.adv_param.Advertising_Interval_Max[1] = (HCI_CMD_PARAM_ADVERTISING_INTERVAL_MIN & 0xff00) >> 8;
    g_pattern_param.adv_param.Advertising_Interval_Min[0] =  HCI_CMD_PARAM_ADVERTISING_INTERVAL_MIN & 0x00ff;
    g_pattern_param.adv_param.Advertising_Interval_Min[1] = (HCI_CMD_PARAM_ADVERTISING_INTERVAL_MIN & 0xff00) >> 8;

    // Lwtest(SCN) config
    // use the correct company identifier and company assigned identifier default.
    
     if(com_ID_cnt == 1){
         //with an identical company assigned identifier
         //but a different company identifier
         COMM_Static_Random_Device_Address_Set_Config(dut2_error_com_idf);
         COMM_Device_Address_Set(dut2_fd, g_pattern_param);
         for(i=0; i<6; i++){
             g_pattern_param.adv_param.Direct_Address[i] = dut2_error_com_idf[i];
         }
         g_pattern_param.adv_param.Own_Address_Type[0] = HCI_CMD_PARAM_RANDOM_DEVICE_ADDRESS;             
         
     }
     else if(com_ID_cnt == 2){
         //with an identical company identifier
         //but a different company assigned identifier
         COMM_Static_Random_Device_Address_Set_Config(dut2_error_com_ass);
         COMM_Device_Address_Set(dut2_fd, g_pattern_param);
         for(i=0; i<6; i++){
             g_pattern_param.adv_param.Direct_Address[i] = dut2_error_com_ass[i];
         }
         g_pattern_param.adv_param.Own_Address_Type[0] = HCI_CMD_PARAM_RANDOM_DEVICE_ADDRESS;             
         
     }
     else if(com_ID_cnt == 3){
         //with different company identifier 
         //and company assigned identifier
         COMM_Static_Random_Device_Address_Set_Config(dut2_error_both);
         COMM_Device_Address_Set(dut2_fd, g_pattern_param);
         for(i=0; i<6; i++){
             g_pattern_param.adv_param.Direct_Address[i] = dut2_error_both[i];
         }
         g_pattern_param.adv_param.Own_Address_Type[0] = HCI_CMD_PARAM_RANDOM_DEVICE_ADDRESS;             
     }


    verdict=COMM_ADV_Undirected_Advertising(dut2_fd,g_pattern_param);
    VERDICT_RESULT_WITH_LINE();

    while(1)//waiting adv report event , timer or counter
    {

        MSLEEP(100);

        //query adv_ind
        if (SUCCESS != QUERY_LE_Event(dut1_fd,buf ,
                                    _BT_HCI_LE_EVENT_SUB_OP_ADVERTISING_REPORT_,
                                    HCI_SUBEVENT_ADV_RPT_EVENT_ADV_IND))
        {
            continue;
        }
        else if(EQUAL != hci_le_event_advertising_report_parsing(HCI_SUBEVENT_ADV_RPT_EVENT_ADV_IND,
                                                        buf,g_pattern_param))
        {
            printf("no adv coming, chk %d\n" , adv_chk_err);
            
            adv_chk_err ++ ;
            if(adv_chk_err >= 100){
                line = __LINE__;
                goto FUN_FAIL;
            }
        
            continue;
        }
        else{
            adv_chk_err = 0;
            
            if(adv_cnt < 20){
                //stop adv
                
                COMM_ADV_Disable_Config(dut2,&g_pattern_param);
                verdict=COMM_ADV_Disable(dut2_fd,g_pattern_param);
                VERDICT_RESULT_WITH_LINE();

                //reconfig adv param and start adv again
                g_pattern_param.adv_data_param.Advertising_Data[0]= adv_cnt;
                g_pattern_param.adv_data_param.Advertising_Data[1]= \
                            g_pattern_param.adv_param.Advertising_Channel_Map[0];
                g_pattern_param.Advertising_Enable[0] = HCI_CMD_PARAM_ADV_ENABLE;
                verdict=COMM_ADV_Undirected_Advertising(dut2_fd,g_pattern_param);
                VERDICT_RESULT_WITH_LINE();

                adv_cnt ++;

                continue;
            }
            else{
                adv_cnt = 0;
            }
        }

        if(com_ID_cnt !=3){
            com_ID_cnt ++;
        
            COMM_ADV_Disable_Config(dut2,&g_pattern_param);
            verdict=COMM_ADV_Disable(dut2_fd,g_pattern_param);
            VERDICT_RESULT_WITH_LINE();
        
            adv_cnt = 0;
            goto REPEAT;
        }
        else{
            if(adv_Channel != 39){
        
                COMM_ADV_Disable_Config(dut2,&g_pattern_param);
                verdict=COMM_ADV_Disable(dut2_fd,g_pattern_param);
                VERDICT_RESULT_WITH_LINE();
        
                adv_Channel ++;
                adv_cnt = 0;
                com_ID_cnt=0;
                goto REPEAT;
            }
            else{
                FUNC_END();               
                LOG_INFO("[Pattern][%s]SUCCESS\n" ,__FUNCTION__);
                return PASS;
            }
        }

    }

FUN_FAIL:
    FUNC_END();

    LOG_INFO("[Pattern][%s]:%d FAIL : ch %d \n" ,__FUNCTION__,line ,adv_Channel);
    return FAIL;
}



// 5.2.2.7
verdict DDI_SCN_Passive_Scanning_Directed_Events(u8 dut1_fd ,u8 dut2_fd)
{
	u8 buf[SOCKET_BUF_SIZE];	
    int err_cnt = 0;	
    int check_cnt = 0;
	int adv_TimeCnt = 0;
	int verdict = FAIL;
	int dut1 = 0;	
	u16 line = 0;
    int adv_Channel = 37;	
	struct itimerval timer;	

    COMM_Dut_clean_buffer(dut1_fd);
    COMM_Dut_clean_buffer(dut2_fd);

    Calculate_Execution_Time_Start();

    // Uptest(white list) config
    COMM_INI_Connection_Setup_White_Listed_Config(dut1, &g_pattern_param);
    memcpy(g_pattern_param.white_list_param.Address, adv_addr, ADDR_LENGTH);
    g_pattern_param.white_list_param.Address_Type[0] = HCI_CMD_PARAM_PUBLIC_DEVICE_ADDRESS;
    verdict = COMM_INI_Connection_Setup_White_Listed(dut1_fd, g_pattern_param);
    VERDICT_RESULT_WITH_LINE();

    //p2
    COMM_SCN_Passive_Scanning_Config(dut1, &g_pattern_param);
    g_pattern_param.scn_param.Scanning_Filter_Policy[0] = HCI_CMD_PARAM_IGNORE_ADV_PKTS_FROM_DEV_NOT_IN_WHITE_LIST_ONLY;
    g_pattern_param.scn_param.LE_Scan_Interval[0] = 0xa0& 0x00ff;
    g_pattern_param.scn_param.LE_Scan_Interval[1] = (0xa0 & 0xff00) >> 8;
    g_pattern_param.scn_param.LE_Scan_Window[0] =   0xa0 & 0x00ff;
    g_pattern_param.scn_param.LE_Scan_Window[1] = (0xa0 & 0xff00) >> 8; 
    verdict = COMM_SCN_Passive_Scanning(dut1_fd, g_pattern_param);
    VERDICT_RESULT_WITH_LINE();
    
REPEAT:	

	//p1
	COMM_ADV_Directed_Advertising_Config(HCI_CMD_PARAM_ADV_DATA_LEN_MAX, &g_pattern_param);	
	g_pattern_param.adv_param.Advertising_Interval_Max[0] = HCI_CMD_PARAM_ADVERTISING_INTERVAL_MIN & 0x00ff;
	g_pattern_param.adv_param.Advertising_Interval_Max[1] = (HCI_CMD_PARAM_ADVERTISING_INTERVAL_MIN & 0xff00) >> 8;
	g_pattern_param.adv_param.Advertising_Interval_Min[0] = HCI_CMD_PARAM_ADVERTISING_INTERVAL_MIN & 0x00ff;
	g_pattern_param.adv_param.Advertising_Interval_Min[1] = (HCI_CMD_PARAM_ADVERTISING_INTERVAL_MIN & 0xff00) >> 8;	

    if(37 == adv_Channel) {
        g_pattern_param.adv_param.Advertising_Channel_Map[0] = HCI_CMD_PARAM_ENABLE_CHANNEL_37;
		//memcpy(g_pattern_param.adv_param.Direct_Address, error_scan_com_idf, ADDR_LENGTH);
    }
    else if(38 == adv_Channel) {
        COMM_Static_Random_Device_Address_Set_Config(dut2_error_com_idf);
		COMM_Device_Address_Set(dut2_fd, g_pattern_param);
		memcpy(g_pattern_param.adv_param.Direct_Address, dut2_error_com_idf, ADDR_LENGTH);
        g_pattern_param.adv_param.Advertising_Channel_Map[0] = HCI_CMD_PARAM_ENABLE_CHANNEL_38;
        g_pattern_param.adv_param.Own_Address_Type[0] = HCI_CMD_PARAM_RANDOM_DEVICE_ADDRESS;        
    }
    else {
        COMM_Static_Random_Device_Address_Set_Config(dut2_error_com_ass);
		COMM_Device_Address_Set(dut2_fd, g_pattern_param);
		memcpy(g_pattern_param.adv_param.Direct_Address, dut2_error_com_ass, ADDR_LENGTH);
		g_pattern_param.adv_param.Advertising_Channel_Map[0] = HCI_CMD_PARAM_ENABLE_CHANNEL_39;
        g_pattern_param.adv_param.Own_Address_Type[0] = HCI_CMD_PARAM_RANDOM_DEVICE_ADDRESS;
        
    }

    sleep(1);

	verdict = COMM_ADV_Directed_Advertising(dut2_fd, g_pattern_param);
	VERDICT_RESULT_WITH_LINE();
    
    while (check_cnt < 20) {
		if(adv_TimeCnt > 50) {
			adv_TimeCnt = 0;
			//verdict = 
            COMM_ADV_Directed_Advertising(dut2_fd, g_pattern_param);
		    //VERDICT_RESULT_WITH_LINE();
		}        

        
        if(37 == adv_Channel){
            if (SUCCESS != QUERY_LE_Event(dut1_fd, buf, _BT_HCI_LE_EVENT_SUB_OP_ADVERTISING_REPORT_, HCI_SUBEVENT_ADV_RPT_EVENT_DIRECT_IND)) {
                //query ADV report
                printf("****SUCCESS != QUERY_LE_Event****\n");
    	        continue;
    	    }				    
            else if (EQUAL != hci_le_event_advertising_report_parsing(HCI_SUBEVENT_ADV_RPT_EVENT_DIRECT_IND, buf, g_pattern_param)) {
                 
                 printf("****EQUAL != HCI_err : %d, right_Cnt = %d ****\n", err_cnt, check_cnt);             
                 err_cnt++;
                 if (err_cnt > 100) {
                     line=__LINE__;
    	            goto FUN_FAIL;
                 }                 
            }                        
            else {
                 check_cnt ++ ;
                 err_cnt = 0;
                 printf("###ADV_Channel = %d ###\n", adv_Channel);                 
                 printf("** Upper Tester expects an HCI_LE_Advertising_Report event from the IUT : %d / 20 times **\n" , check_cnt);
             }
			adv_TimeCnt++;
            MSLEEP(60);
        }
        else { // for channel 38 & 39
            if (SUCCESS != QUERY_LE_Event(dut1_fd, buf, _BT_HCI_LE_EVENT_SUB_OP_ADVERTISING_REPORT_, HCI_SUBEVENT_ADV_RPT_EVENT_DIRECT_IND)) {
                //query ADV report
                printf("****SUCCESS != QUERY_LE_Event****\n");
    	        continue;
    	    }				    
            else if (EQUAL == hci_le_event_advertising_report_parsing(HCI_SUBEVENT_ADV_RPT_EVENT_DIRECT_IND, buf, g_pattern_param)) {
                 
                 printf("****EQUAL != HCI_err : %d, right_Cnt = %d ****\n", err_cnt, check_cnt);             
                 err_cnt++;
                 if (err_cnt > 50) {
                     line=__LINE__;
    	            goto FUN_FAIL;
                 }                 
            }                        
            else {
                 check_cnt ++ ;
                 err_cnt = 0;
                 printf("###ADV_Channel = %d ###\n", adv_Channel);
                 printf("** Upper Tester expects no HCI_LE_Advertising_Report event from the IUT : %d / 20 times **\n" , check_cnt);
            }
            MSLEEP(60);
			adv_TimeCnt++;
        }
    }

    //dut_reset_with_mask_en(dut1_fd);
    dut_reset_with_mask_en(dut2_fd);      
    MSLEEP(500);

	if(adv_Channel != 39){        
        adv_Channel ++;
		check_cnt = 0;
		err_cnt = 0;
        goto REPEAT;
    }  
    
    FUNC_END();

    LOG_INFO("[Pattern][%s]SUCCESS\n" ,__FUNCTION__);
    return PASS;

FUN_FAIL:	
    FUNC_END();

	LOG_INFO("[Pattern][%s]:%d FAIL, ADV_Channel = %d\n" ,__FUNCTION__, line, adv_Channel);
    return FAIL;

}


// 5.2.2.8
verdict DDI_SCN_Passive_Scanning_Discoverable_Events(u8 dut1_fd ,u8 dut2_fd)
{
    u8 buf[SOCKET_BUF_SIZE];   
    int err_cnt = 0;    
    int check_cnt = 0;
    int verdict = FAIL;
    int dut1 = 0;
	int dut2 = 0;
    u16 line = 0;
    int adv_Channel = 37;   
	struct itimerval timer;	
    
    COMM_Dut_clean_buffer(dut1_fd);
    COMM_Dut_clean_buffer(dut2_fd);

    Calculate_Execution_Time_Start();
REPEAT: 
    // Uptest(white list) config
    COMM_INI_Connection_Setup_White_Listed_Config(dut1, &g_pattern_param);
    memcpy(g_pattern_param.white_list_param.Address, adv_addr, ADDR_LENGTH);
    g_pattern_param.white_list_param.Address_Type[0] = HCI_CMD_PARAM_PUBLIC_DEVICE_ADDRESS;
    verdict = COMM_INI_Connection_Setup_White_Listed(dut1_fd, g_pattern_param);
    VERDICT_RESULT_WITH_LINE();
    
    //p2
    COMM_SCN_Passive_Scanning_Config(dut1, &g_pattern_param);
    g_pattern_param.scn_param.Scanning_Filter_Policy[0] = HCI_CMD_PARAM_IGNORE_ADV_PKTS_FROM_DEV_NOT_IN_WHITE_LIST_ONLY;
    g_pattern_param.scn_param.LE_Scan_Interval[0] = 0xa0& 0x00ff;
    g_pattern_param.scn_param.LE_Scan_Interval[1] = (0xa0 & 0xff00) >> 8;
    g_pattern_param.scn_param.LE_Scan_Window[0] =   0xa0 & 0x00ff;
    g_pattern_param.scn_param.LE_Scan_Window[1] = (0xa0 & 0xff00) >> 8; 
    verdict = COMM_SCN_Passive_Scanning(dut1_fd, g_pattern_param);
    VERDICT_RESULT_WITH_LINE();

    //p1
    COMM_ADV_Discoverable_Advertising_Config(HCI_CMD_PARAM_ADV_DATA_LEN_MAX, &g_pattern_param); 
    g_pattern_param.adv_param.Advertising_Interval_Max[0] = HCI_CMD_PARAM_ADVERTISING_INTERVAL_MIN & 0x00ff;
    g_pattern_param.adv_param.Advertising_Interval_Max[1] = (HCI_CMD_PARAM_ADVERTISING_INTERVAL_MIN & 0xff00) >> 8;
    g_pattern_param.adv_param.Advertising_Interval_Min[0] = HCI_CMD_PARAM_ADVERTISING_INTERVAL_MIN & 0x00ff;
    g_pattern_param.adv_param.Advertising_Interval_Min[1] = (HCI_CMD_PARAM_ADVERTISING_INTERVAL_MIN & 0xff00) >> 8; 
    if(37 == adv_Channel) {
        g_pattern_param.adv_param.Advertising_Channel_Map[0] = HCI_CMD_PARAM_ENABLE_CHANNEL_37;
        //memcpy(g_pattern_param.adv_param.Direct_Address, error_scan_com_idf, ADDR_LENGTH);
    }
    else if(38 == adv_Channel) {
        COMM_Static_Random_Device_Address_Set_Config(dut2_error_com_idf);
        COMM_Device_Address_Set(dut2_fd, g_pattern_param);
        memcpy(g_pattern_param.adv_param.Direct_Address, dut2_error_com_idf, ADDR_LENGTH);
        g_pattern_param.adv_param.Advertising_Channel_Map[0] = HCI_CMD_PARAM_ENABLE_CHANNEL_38;
        g_pattern_param.adv_param.Own_Address_Type[0] = HCI_CMD_PARAM_RANDOM_DEVICE_ADDRESS;        
    }
    else {
        COMM_Static_Random_Device_Address_Set_Config(dut2_error_com_ass);
        COMM_Device_Address_Set(dut2_fd, g_pattern_param);
        memcpy(g_pattern_param.adv_param.Direct_Address, dut2_error_com_ass, ADDR_LENGTH);
        g_pattern_param.adv_param.Advertising_Channel_Map[0] = HCI_CMD_PARAM_ENABLE_CHANNEL_39;
        g_pattern_param.adv_param.Own_Address_Type[0] = HCI_CMD_PARAM_RANDOM_DEVICE_ADDRESS;
        
    }
    verdict = COMM_ADV_Discoverable_Advertising(dut2_fd, g_pattern_param);
    VERDICT_RESULT_WITH_LINE();
    
    while (check_cnt < 20) {
        if(37 == adv_Channel){
            if (SUCCESS != QUERY_LE_Event(dut1_fd, buf, _BT_HCI_LE_EVENT_SUB_OP_ADVERTISING_REPORT_, HCI_SUBEVENT_ADV_RPT_EVENT_SCAN_IND)) {
                //query ADV report
                printf("****SUCCESS != QUERY_LE_Event****\n");
                continue;
            }                   
            else if (EQUAL != hci_le_event_advertising_report_parsing(HCI_SUBEVENT_ADV_RPT_EVENT_SCAN_IND, buf, g_pattern_param)) {
                 
                 printf("****EQUAL != HCI_err : %d, right_Cnt = %d ****\n", err_cnt, check_cnt);             
                 err_cnt++;
                 if (err_cnt > 50) {
                     line=__LINE__;
                    goto FUN_FAIL;
                 }                 
            }                        
            else {
                 check_cnt ++ ;
                 err_cnt = 0;
                 printf("###ADV_Channel = %d ###\n", adv_Channel);
                 printf("** Upper Tester expects an HCI_LE_Advertising_Report event from the IUT : %d / 20 times **\n" , check_cnt);
            }
            MSLEEP(500);
        }
        else { // for channel 38 & 39
            if (SUCCESS != QUERY_LE_Event(dut1_fd, buf, _BT_HCI_LE_EVENT_SUB_OP_ADVERTISING_REPORT_, HCI_SUBEVENT_ADV_RPT_EVENT_SCAN_IND)) {
                //query ADV report
                printf("****SUCCESS != QUERY_LE_Event****\n");
                continue;
            }                   
            else if (EQUAL == hci_le_event_advertising_report_parsing(HCI_SUBEVENT_ADV_RPT_EVENT_SCAN_IND, buf, g_pattern_param)) {
                 
                 printf("****EQUAL != HCI_err : %d, right_Cnt = %d ****\n", err_cnt, check_cnt);             
                 err_cnt++;
                 if (err_cnt > 50) {
                     line=__LINE__;
                    goto FUN_FAIL;
                 }                 
            }                        
            else {
                 check_cnt ++ ;
                 err_cnt = 0;
                 printf("###ADV_Channel = %d ###\n", adv_Channel);
                 printf("** Upper Tester expects no HCI_LE_Advertising_Report event from the IUT : %d / 20 times **\n" , check_cnt);
            }
            MSLEEP(500);
        }
    }

    COMM_SCN_Disable_Config(dut1,&g_pattern_param);
    verdict = COMM_SCN_Disable(dut1_fd,g_pattern_param);
    VERDICT_RESULT_WITH_LINE();
        
    COMM_ADV_Disable_Config(dut2,&g_pattern_param);
    verdict = COMM_ADV_Disable(dut2_fd,g_pattern_param);
    VERDICT_RESULT_WITH_LINE();    

    if(adv_Channel != 39){        
        adv_Channel ++;
        check_cnt = 0;
        err_cnt = 0;
        goto REPEAT;
    }    
    FUNC_END();

    LOG_INFO("[Pattern][%s]SUCCESS\n" ,__FUNCTION__);
    return PASS;

FUN_FAIL:   
    FUNC_END();

    LOG_INFO("[Pattern][%s]:%d FAIL, ADV_Channel = %d\n" ,__FUNCTION__, line, adv_Channel);
    return FAIL;

}


// 5.3.1.1
verdict CON_ADV_Accepting_Connections(u8 dut1_fd ,u8 dut2_fd)
{
	int verdict = FAIL;
	int dut1 = 0;
    int dut2 = 0;
	u16 line = 0;	
	struct itimerval timer;

	u8 buf[SOCKET_BUF_SIZE];
    u8 conn_handles_mas[2];

    COMM_Dut_clean_buffer(dut1_fd);
    COMM_Dut_clean_buffer(dut2_fd);

    Calculate_Execution_Time_Start();
    // #p1 :low tester init connection
    //start creat connection to send conn_req
    COMM_INI_Initiating_Config(dut1, &g_pattern_param);
	g_pattern_param.create_conn_param.Initiator_Filter_Policy[0] =HCI_CMD_PARAM_FILTER_POLICY_WHITE_LIST_USED;    
	memcpy(g_pattern_param.create_conn_param.Peer_Address, adv_addr, ADDR_LENGTH );
	verdict = COMM_INI_Initiating(dut1_fd, g_pattern_param);
    VERDICT_RESULT_WITH_LINE();

	COMM_INI_Connection_Setup_White_Listed_Config(dut1, &g_pattern_param);
	memcpy(g_pattern_param.white_list_param.Address, adv_addr, ADDR_LENGTH);
	verdict=COMM_INI_Connection_Setup_White_Listed(dut1_fd, g_pattern_param);
	VERDICT_RESULT_WITH_LINE();

    COMM_INI_Connection_Setup_White_Listed_Config(dut2, &g_pattern_param);
    verdict = COMM_INI_Connection_Setup_White_Listed(dut2_fd, g_pattern_param);
    VERDICT_RESULT_WITH_LINE();

    // #p2 :use first channel = 37  
    COMM_ADV_Undirected_Advertising_Config(HCI_CMD_PARAM_ADV_DATA_LEN_MAX, &g_pattern_param);    
    g_pattern_param.adv_param.Advertising_Interval_Max[0] =  HCI_CMD_PARAM_ADVERTISING_INTERVAL_MIN & 0x00ff;
    g_pattern_param.adv_param.Advertising_Interval_Max[1] = (HCI_CMD_PARAM_ADVERTISING_INTERVAL_MIN & 0xff00) >> 8;
    g_pattern_param.adv_param.Advertising_Interval_Min[0] =  HCI_CMD_PARAM_ADVERTISING_INTERVAL_MIN & 0x00ff;
    g_pattern_param.adv_param.Advertising_Interval_Min[1] = (HCI_CMD_PARAM_ADVERTISING_INTERVAL_MIN & 0xff00) >> 8; 
    g_pattern_param.adv_param.Advertising_Filter_Policy[0] = HCI_CMD_PARAM_ALLOW_SCAN_REQ_FROM_WHITELIST_ONLY_AND_CONN_REQ_FROM_WHITELIST_ONLY;
	g_pattern_param.adv_param.Advertising_Channel_Map[0] =   HCI_CMD_PARAM_ENABLE_CHANNEL_37;

    verdict = COMM_ADV_Undirected_Advertising(dut2_fd, g_pattern_param);
    VERDICT_RESULT_WITH_LINE();
    
	event_query_timer_config(5, 0, 0, 0, &timer);
	event_query_timer_start(timer, read_le_event_enable);

    //waiting adv report event , timer or counter
	while(1) {
		if(1 == read_le_event_get()) {
			//reset event flag
			read_le_event_disable();

            //# p4: check respond with CONN REQ
			if(SUCCESS != QUERY_LE_Event(dut2_fd, buf,	_BT_HCI_LE_EVENT_SUB_OP_CONNECTION_COMPLETE_, 0)) {
				line = __LINE__;
				goto FUN_FAIL;
			}

			if(SUCCESS != hci_le_event_connection_complete_parsing(0, buf, g_pattern_param)) {
				line = __LINE__;
				goto FUN_FAIL;
			}

            //# p7: check respond with CONN REQ
			if(SUCCESS != QUERY_LE_Event(dut1_fd, buf,	_BT_HCI_LE_EVENT_SUB_OP_CONNECTION_COMPLETE_, 0)) {
				line = __LINE__;
				goto FUN_FAIL;
			}

			if(SUCCESS != hci_le_event_connection_complete_parsing(0, buf, g_pattern_param)) {
				line=__LINE__;
				goto FUN_FAIL;
			}

			conn_handles_mas[0] = buf[_BT_HCI_EVT_CON_COMP_CONN_HANDLE+0];
			conn_handles_mas[1] = buf[_BT_HCI_EVT_CON_COMP_CONN_HANDLE+1];

			// # Slave Connection Terminated
			// use connect handle to disconnect
			buf[_BT_HCI_EVT_CON_COMP_CONN_HANDLE+0] = conn_handles_mas[0];
			buf[_BT_HCI_EVT_CON_COMP_CONN_HANDLE+1] = conn_handles_mas[1];
			
			COMM_Disconnect_Config(dut1, &g_pattern_param,buf);
			verdict = COMM_Disconnect(dut1_fd, g_pattern_param);
			VERDICT_RESULT_WITH_LINE();
            
            sleep(10);

            dut_reset_with_mask_en(dut1_fd);
            dut_reset_with_mask_en(dut2_fd);
            MSLEEP(500);

            goto CASE_CH_38;
		}
	}

CASE_CH_38:
    // #p9/10/11

    // #p1 :low tester init connection
    //start creat connection to send conn_req
    COMM_INI_Initiating_Config(dut1, &g_pattern_param);
	memcpy(g_pattern_param.create_conn_param.Peer_Address, adv_addr, ADDR_LENGTH );
	verdict = COMM_INI_Initiating(dut1_fd, g_pattern_param);
	VERDICT_RESULT_WITH_LINE();

    COMM_INI_Connection_Setup_White_Listed_Config(dut2, &g_pattern_param);
    verdict = COMM_INI_Connection_Setup_White_Listed(dut2_fd, g_pattern_param);
    VERDICT_RESULT_WITH_LINE();

    // #p2 :use second channel = 38  
    COMM_ADV_Undirected_Advertising_Config(HCI_CMD_PARAM_ADV_DATA_LEN_MAX, &g_pattern_param);    
    g_pattern_param.adv_param.Advertising_Interval_Max[0] =  HCI_CMD_PARAM_ADVERTISING_INTERVAL_MIN & 0x00ff;
    g_pattern_param.adv_param.Advertising_Interval_Max[1] = (HCI_CMD_PARAM_ADVERTISING_INTERVAL_MIN & 0xff00) >> 8;
    g_pattern_param.adv_param.Advertising_Interval_Min[0] =  HCI_CMD_PARAM_ADVERTISING_INTERVAL_MIN & 0x00ff;
    g_pattern_param.adv_param.Advertising_Interval_Min[1] = (HCI_CMD_PARAM_ADVERTISING_INTERVAL_MIN & 0xff00) >> 8; 
    g_pattern_param.adv_param.Advertising_Filter_Policy[0] = HCI_CMD_PARAM_ALLOW_SCAN_REQ_FROM_WHITELIST_ONLY_AND_CONN_REQ_FROM_WHITELIST_ONLY;
    g_pattern_param.adv_param.Advertising_Channel_Map[0] = HCI_CMD_PARAM_ENABLE_CHANNEL_38;

    verdict = COMM_ADV_Undirected_Advertising(dut2_fd, g_pattern_param);
    VERDICT_RESULT_WITH_LINE();
    
    event_query_timer_config(5, 0, 0, 0, &timer);
    event_query_timer_start(timer ,read_le_event_enable );

    //waiting adv report event , timer or counter
    while(1) {
        if(1 == read_le_event_get()) {
            //reset event flag
            read_le_event_disable();
            //# p4: check respond with CONN REQ
            if(SUCCESS != QUERY_LE_Event(dut2_fd, buf, _BT_HCI_LE_EVENT_SUB_OP_CONNECTION_COMPLETE_, 0)) {
                line = __LINE__;
                goto FUN_FAIL;
            }

            if(SUCCESS != hci_le_event_connection_complete_parsing(0, buf, g_pattern_param)) {
                line = __LINE__;
                goto FUN_FAIL;
            }
            

            //# p7: check respond with CONN REQ
			if (SUCCESS != QUERY_LE_Event(dut1_fd, buf,	_BT_HCI_LE_EVENT_SUB_OP_CONNECTION_COMPLETE_, 0)) {
				line = __LINE__;
				goto FUN_FAIL;
			}


			if(SUCCESS != hci_le_event_connection_complete_parsing(0, buf, g_pattern_param)) {
				line = __LINE__;
				goto FUN_FAIL;
			}

			conn_handles_mas[0] = buf[_BT_HCI_EVT_CON_COMP_CONN_HANDLE+0];
			conn_handles_mas[1] = buf[_BT_HCI_EVT_CON_COMP_CONN_HANDLE+1];


			// # Slave Connection Terminated
			// use connect handle to disconnect
			buf[_BT_HCI_EVT_CON_COMP_CONN_HANDLE+0] = conn_handles_mas[0];
			buf[_BT_HCI_EVT_CON_COMP_CONN_HANDLE+1] = conn_handles_mas[1];
			
			COMM_Disconnect_Config(dut1, &g_pattern_param, buf);
			verdict = COMM_Disconnect(dut1_fd, g_pattern_param);
			VERDICT_RESULT_WITH_LINE();
            sleep(10);

            dut_reset_with_mask_en(dut1_fd);
            dut_reset_with_mask_en(dut2_fd);
            MSLEEP(500);
            goto CASE_CH_39;            
        }
    }

CASE_CH_39:

    // #p12/13/14
    // #p1 :low tester init connection
    //start creat connection to send conn_req
    COMM_INI_Initiating_Config(dut1, &g_pattern_param);
	memcpy(g_pattern_param.create_conn_param.Peer_Address, adv_addr, ADDR_LENGTH );
	verdict = COMM_INI_Initiating(dut1_fd, g_pattern_param);
	VERDICT_RESULT_WITH_LINE();

    COMM_INI_Connection_Setup_White_Listed_Config(dut2, &g_pattern_param);
    verdict = COMM_INI_Connection_Setup_White_Listed(dut2_fd, g_pattern_param);
    VERDICT_RESULT_WITH_LINE();

    // #p2 :use third channel = 39  
    COMM_ADV_Undirected_Advertising_Config(HCI_CMD_PARAM_ADV_DATA_LEN_MAX, &g_pattern_param);
    g_pattern_param.adv_param.Advertising_Interval_Max[0] =  HCI_CMD_PARAM_ADVERTISING_INTERVAL_MIN & 0x00ff;
    g_pattern_param.adv_param.Advertising_Interval_Max[1] = (HCI_CMD_PARAM_ADVERTISING_INTERVAL_MIN & 0xff00) >> 8;
    g_pattern_param.adv_param.Advertising_Interval_Min[0] =  HCI_CMD_PARAM_ADVERTISING_INTERVAL_MIN & 0x00ff;
    g_pattern_param.adv_param.Advertising_Interval_Min[1] = (HCI_CMD_PARAM_ADVERTISING_INTERVAL_MIN & 0xff00) >> 8; 
    g_pattern_param.adv_param.Advertising_Filter_Policy[0] = HCI_CMD_PARAM_ALLOW_SCAN_REQ_FROM_WHITELIST_ONLY_AND_CONN_REQ_FROM_WHITELIST_ONLY;
    g_pattern_param.adv_param.Advertising_Channel_Map[0] = HCI_CMD_PARAM_ENABLE_CHANNEL_39;

    verdict = COMM_ADV_Undirected_Advertising(dut2_fd, g_pattern_param);
    VERDICT_RESULT_WITH_LINE();
    
    event_query_timer_config(5, 0, 0, 0, &timer);
    event_query_timer_start(timer, read_le_event_enable);

    //waiting adv report event , timer or counter
    while(1) {
        if(1 == read_le_event_get()) {
            //reset event flag
            read_le_event_disable();

            //# p4: check respond with CONN REQ
            if(SUCCESS != QUERY_LE_Event(dut2_fd, buf, _BT_HCI_LE_EVENT_SUB_OP_CONNECTION_COMPLETE_, 0)) {
                line = __LINE__;
                goto FUN_FAIL;
            }

            if(SUCCESS != hci_le_event_connection_complete_parsing(0, buf, g_pattern_param)) {
                line = __LINE__;
                goto FUN_FAIL;
            }

            //# p7: check respond with CONN REQ
			if(SUCCESS != QUERY_LE_Event(dut1_fd, buf, _BT_HCI_LE_EVENT_SUB_OP_CONNECTION_COMPLETE_, 0)) {
				line = __LINE__;
				goto FUN_FAIL;
			}


			if(SUCCESS != hci_le_event_connection_complete_parsing(0, buf, g_pattern_param)) {
				line = __LINE__;
				goto FUN_FAIL;
			}

			conn_handles_mas[0] = buf[_BT_HCI_EVT_CON_COMP_CONN_HANDLE+0];
			conn_handles_mas[1] = buf[_BT_HCI_EVT_CON_COMP_CONN_HANDLE+1];

			// # Slave Connection Terminated
			// use connect handle to disconnect
			buf[_BT_HCI_EVT_CON_COMP_CONN_HANDLE+0] = conn_handles_mas[0];
			buf[_BT_HCI_EVT_CON_COMP_CONN_HANDLE+1] = conn_handles_mas[1];
			
			COMM_Disconnect_Config(dut1, &g_pattern_param, buf);
			verdict = COMM_Disconnect(dut1_fd, g_pattern_param);
			VERDICT_RESULT_WITH_LINE();
            goto FUN_SUCCESS;
            
        }
    }

FUN_SUCCESS:
    FUNC_END();

	LOG_INFO("[Pattern][%s]SUCCESS\n", __FUNCTION__);
	return PASS;

FUN_FAIL:
    FUNC_END();

	LOG_INFO("[Pattern][%s]:%d FAIL\n", __FUNCTION__, line);
    return FAIL;


}

// 5.3.1.2
verdict CON_ADV_Accepting_Connections_Timeout(u8 dut1_fd ,u8 dut2_fd)
{
	u8 buf[SOCKET_BUF_SIZE];
	int verdict = FAIL;
	int dut1 = 0;
	u16 line = 0;
	struct itimerval timer;

    COMM_Dut_clean_buffer(dut1_fd);
    COMM_Dut_clean_buffer(dut2_fd);

    Calculate_Execution_Time_Start();
    COMM_ADV_Undirected_Advertising_Config(HCI_CMD_PARAM_ADV_DATA_LEN_MAX, &g_pattern_param);
    g_pattern_param.adv_param.Advertising_Interval_Max[0] =  HCI_CMD_PARAM_ADVERTISING_INTERVAL_MIN & 0x00ff;
    g_pattern_param.adv_param.Advertising_Interval_Max[1] = (HCI_CMD_PARAM_ADVERTISING_INTERVAL_MIN & 0xff00) >> 8;
    g_pattern_param.adv_param.Advertising_Interval_Min[0] =  HCI_CMD_PARAM_ADVERTISING_INTERVAL_MIN & 0x00ff;
    g_pattern_param.adv_param.Advertising_Interval_Min[1] = (HCI_CMD_PARAM_ADVERTISING_INTERVAL_MIN & 0xff00) >> 8; 
	//here use lowest ch to testing
	g_pattern_param.adv_param.Advertising_Channel_Map[0] = HCI_CMD_PARAM_ENABLE_CHANNEL_37 ;
	verdict = COMM_ADV_Undirected_Advertising(dut2_fd, g_pattern_param);
	VERDICT_RESULT_WITH_LINE();


	COMM_INI_Connection_Setup_White_Listed_Config(dut1, &g_pattern_param);
	memcpy(g_pattern_param.white_list_param.Address, adv_addr, ADDR_LENGTH);
	verdict=COMM_INI_Connection_Setup_White_Listed(dut1_fd, g_pattern_param);
	VERDICT_RESULT_WITH_LINE();

	COMM_INI_Initiating_Config(dut1, &g_pattern_param);
	g_pattern_param.create_conn_param.Initiator_Filter_Policy[0] =HCI_CMD_PARAM_FILTER_POLICY_WHITE_LIST_USED;        
	memcpy(g_pattern_param.create_conn_param.Peer_Address, adv_addr, ADDR_LENGTH );
	verdict = COMM_INI_Initiating(dut1_fd, g_pattern_param);
	VERDICT_RESULT_WITH_LINE();

	dut_reset_with_mask_en(dut1_fd);
    MSLEEP(500);
	event_query_timer_config(10, 0, 0, 0, &timer);
	event_query_timer_start(timer, read_le_event_enable);

    //waiting adv report event , timer or counter
	while(1) {
		if(1 == read_le_event_get()) {
            read_le_event_disable();

			if(SUCCESS != QUERY_LE_Event(dut2_fd, buf, _BT_HCI_LE_EVENT_SUB_OP_CONNECTION_COMPLETE_, 0)) {
				line = __LINE__;
				goto FUN_FAIL;
			}

			if(SUCCESS != hci_le_event_connection_complete_parsing(0, buf, g_pattern_param)) {
				line = __LINE__;
				goto FUN_FAIL;
			}
			sleep(10);
            
			if(SUCCESS != QUERY_Event(dut2_fd, buf, _BT_HCI_EVENT_OP_DISCONNECTION_COMPLETE_)) {
				line = __LINE__;
				goto FUN_FAIL;
			}

			hci_event_disconnection_complete_parsing(0, buf, g_pattern_param);
			/*if(_BT_HCI_EVT_CMD_COMP_STATUS_CONNECTION_FAILED_TO_BE_ESTABLISHED != buf[_BT_HCI_EVT_DISCONN_COMP_REASON])	{
				line = __LINE__;
				goto FUN_FAIL;
			}*/
                FUNC_END();

			LOG_INFO("[Pattern][%s]SUCCESS\n", __FUNCTION__);
			return PASS;
		}
	}

FUN_FAIL:
    FUNC_END();

	LOG_INFO("[Pattern][%s]:%d FAIL\n", __FUNCTION__, line);
	return FAIL;
}

// 5.3.1.4
verdict CON_ADV_Directed_Advertising_Connection(u8 dut1_fd ,u8 dut2_fd)
{    
    u8 buf[SOCKET_BUF_SIZE];
    int verdict = FAIL;
    int dut1 = 0;
    int dut2 = 0;
    u16 line = 0;
    int adv_Channel = 37;    
    struct itimerval timer;
    u8 conn_handles_mas[2];

    COMM_Dut_clean_buffer(dut1_fd);
    COMM_Dut_clean_buffer(dut2_fd);

    Calculate_Execution_Time_Start();
REPEAT:
    // Uptest(white list) config
	COMM_INI_Connection_Setup_White_Listed_Config(dut2, &g_pattern_param);
    memcpy(g_pattern_param.white_list_param.Address, scan_addr, ADDR_LENGTH);
    g_pattern_param.white_list_param.Address_Type[0] = HCI_CMD_PARAM_PUBLIC_DEVICE_ADDRESS;
    verdict = COMM_INI_Connection_Setup_White_Listed(dut2_fd, g_pattern_param);
    VERDICT_RESULT_WITH_LINE();

    //# case 1
	COMM_ADV_Directed_Advertising_Config(HCI_CMD_PARAM_ADV_DATA_LEN_MAX, &g_pattern_param);
    g_pattern_param.adv_param.Advertising_Filter_Policy[0] = HCI_CMD_PARAM_ALLOW_SCAN_REQ_FROM_WHITELIST_ONLY_AND_CONN_REQ_FROM_WHITELIST_ONLY;
	g_pattern_param.adv_param.Advertising_Interval_Max[0] =  0x00a0 & 0x00ff;
    g_pattern_param.adv_param.Advertising_Interval_Max[1] = (0x00a0 & 0xff00) >> 8;
    g_pattern_param.adv_param.Advertising_Interval_Min[0] =  0x00a0 & 0x00ff;
    g_pattern_param.adv_param.Advertising_Interval_Min[1] = (0x00a0 & 0xff00) >> 8;
	if(37 == adv_Channel) {
        g_pattern_param.adv_param.Advertising_Channel_Map[0] = HCI_CMD_PARAM_ENABLE_CHANNEL_37;
    }
    else if(38 == adv_Channel) {
        g_pattern_param.adv_param.Advertising_Channel_Map[0] = HCI_CMD_PARAM_ENABLE_CHANNEL_38;
    }
    else {
        g_pattern_param.adv_param.Advertising_Channel_Map[0] = HCI_CMD_PARAM_ENABLE_CHANNEL_39;
    }
	verdict = COMM_ADV_Directed_Advertising(dut2_fd, g_pattern_param);
	VERDICT_RESULT_WITH_LINE();

    // #config mismatch init address
	COMM_INI_Initiating_Config(dut1, &g_pattern_param);
    memcpy(g_pattern_param.create_conn_param.Peer_Address, error_addr, ADDR_LENGTH);
	verdict = COMM_INI_Initiating(dut1_fd, g_pattern_param);
	VERDICT_RESULT_WITH_LINE();
    
    event_query_timer_config(5, 0, 0, 0, &timer);
    event_query_timer_start(timer, read_le_event_enable);

    //waiting adv report event , timer or counter
    while(1) {
        if( 1 == read_le_event_get() ) {
            read_le_event_disable();
            if (SUCCESS != QUERY_LE_Event(dut2_fd, buf, _BT_HCI_LE_EVENT_SUB_OP_CONNECTION_COMPLETE_, 0)) {
                line = __LINE__;
                goto FUN_FAIL;
            }

            if(_BT_HCI_EVT_CMD_COMP_STATUS_DIRECTED_ADVERTISING_TIMEOUT != hci_le_event_connection_complete_parsing(0, buf, g_pattern_param)) {
                line = __LINE__;
                goto FUN_FAIL;
            }
            break;
        }
    }
    dut_reset_with_mask_en(dut1_fd);
    sleep(1);


    //# case 2
    COMM_ADV_Directed_Advertising_Config(HCI_CMD_PARAM_ADV_DATA_LEN_MAX, &g_pattern_param);
    g_pattern_param.adv_param.Advertising_Filter_Policy[0] = HCI_CMD_PARAM_ALLOW_SCAN_REQ_FROM_WHITELIST_ONLY_AND_CONN_REQ_FROM_WHITELIST_ONLY;
	g_pattern_param.adv_param.Advertising_Interval_Max[0] =  0x00a0 & 0x00ff;
    g_pattern_param.adv_param.Advertising_Interval_Max[1] = (0x00a0 & 0xff00) >> 8;
    g_pattern_param.adv_param.Advertising_Interval_Min[0] =  0x00a0 & 0x00ff;
    g_pattern_param.adv_param.Advertising_Interval_Min[1] = (0x00a0 & 0xff00) >> 8;
	if(37 == adv_Channel) {
        g_pattern_param.adv_param.Advertising_Channel_Map[0] = HCI_CMD_PARAM_ENABLE_CHANNEL_37;
    }
    else if(38 == adv_Channel) {
        g_pattern_param.adv_param.Advertising_Channel_Map[0] = HCI_CMD_PARAM_ENABLE_CHANNEL_38;
    }
    else {
        g_pattern_param.adv_param.Advertising_Channel_Map[0] = HCI_CMD_PARAM_ENABLE_CHANNEL_39;
    }
	verdict = COMM_ADV_Directed_Advertising(dut2_fd, g_pattern_param);
	VERDICT_RESULT_WITH_LINE();

	COMM_INI_Initiating_Config(dut1, &g_pattern_param);
    memcpy(g_pattern_param.create_conn_param.Peer_Address, adv_addr, ADDR_LENGTH);
	verdict = COMM_INI_Initiating(dut1_fd, g_pattern_param);
	VERDICT_RESULT_WITH_LINE();
    
    event_query_timer_config(5, 0, 0, 0, &timer);
    event_query_timer_start(timer, read_le_event_enable);

    //waiting adv report event , timer or counter
    while(1) {
        if( 1 == read_le_event_get() ) {
            read_le_event_disable();
            if (SUCCESS != QUERY_LE_Event(dut2_fd, buf, _BT_HCI_LE_EVENT_SUB_OP_CONNECTION_COMPLETE_, 0)) {
                line = __LINE__;
                goto FUN_FAIL;
            }

            if(SUCCESS != hci_le_event_connection_complete_parsing(0, buf, g_pattern_param)) {
                line = __LINE__;
                goto FUN_FAIL;
            }

            if (SUCCESS != QUERY_LE_Event(dut1_fd, buf, _BT_HCI_LE_EVENT_SUB_OP_CONNECTION_COMPLETE_, 0)) {
                line = __LINE__;
                goto FUN_FAIL;
            }

            if(SUCCESS != hci_le_event_connection_complete_parsing(0, buf, g_pattern_param)) {
                line = __LINE__;
                goto FUN_FAIL;
            }

			conn_handles_mas[0] = buf[_BT_HCI_EVT_CON_COMP_CONN_HANDLE+0];
			conn_handles_mas[1] = buf[_BT_HCI_EVT_CON_COMP_CONN_HANDLE+1];
            
            break;
        }
    }

    sleep(30);    

    if(SUCCESS != QUERY_Event(dut1_fd, buf, _BT_HCI_EVENT_OP_DISCONNECTION_COMPLETE_)) {
        line = __LINE__;
        goto FUN_FAIL;
    }
    else if(SUCCESS != hci_event_disconnection_complete_parsing(0, buf, g_pattern_param)) {
        line = __LINE__;
        goto FUN_FAIL;
    }       
    if( 0 != buf[_BT_HCI_EVT_DISCONN_COMP_REASON]) {
        line = __LINE__;
        goto FUN_FAIL;
    }


    if(SUCCESS != QUERY_Event(dut2_fd, buf, _BT_HCI_EVENT_OP_DISCONNECTION_COMPLETE_)) {
        line = __LINE__;
        goto FUN_FAIL;
    }
    else if(SUCCESS != hci_event_disconnection_complete_parsing(0, buf, g_pattern_param)) {
        line = __LINE__;
        goto FUN_FAIL;
    } 
    if( 0 != buf[_BT_HCI_EVT_DISCONN_COMP_REASON]) {
        line = __LINE__;
        goto FUN_FAIL;
    }


    // # Slave Connection Terminated
    // use connect handle to disconnect
    buf[_BT_HCI_EVT_CON_COMP_CONN_HANDLE+0] = conn_handles_mas[0];
    buf[_BT_HCI_EVT_CON_COMP_CONN_HANDLE+1] = conn_handles_mas[1];
    
    COMM_Disconnect_Config(dut1, &g_pattern_param,buf);
    verdict = COMM_Disconnect(dut1_fd, g_pattern_param);
    VERDICT_RESULT_WITH_LINE();
    
    sleep(5);
    
    dut_reset_with_mask_en(dut1_fd);
    dut_reset_with_mask_en(dut2_fd);

    MSLEEP(500);

    if(adv_Channel != 39){        
        adv_Channel ++;		
        goto REPEAT;
    }
    FUNC_END();

    LOG_INFO("[Pattern][%s]SUCCESS\n" ,__FUNCTION__);
    return 0;
    
FUN_FAIL:
    FUNC_END();

    LOG_INFO("[Pattern][%s]:%d FAIL : ch %d \n" ,__FUNCTION__,line ,adv_Channel);
    return 0;
}

// 5.3.2.1
verdict CON_INI_Connection_Initiation(u8 dut1_fd ,u8 dut2_fd)
{
	int verdict = FAIL;
	int dut1 = 0;
    int dut2 = 0;
	u16 line = 0;
	struct itimerval timer;

	u8 buf[SOCKET_BUF_SIZE];
    u8 conn_handles_mas[2];

    COMM_Dut_clean_buffer(dut1_fd);
    COMM_Dut_clean_buffer(dut2_fd);

    Calculate_Execution_Time_Start();
    // #p1 :low tester init connection
    //start creat connection to send conn_req
    COMM_INI_Initiating_Config(dut1, &g_pattern_param);
	g_pattern_param.create_conn_param.Initiator_Filter_Policy[0] =HCI_CMD_PARAM_FILTER_POLICY_WHITE_LIST_USED;
	memcpy(g_pattern_param.create_conn_param.Peer_Address, adv_addr, ADDR_LENGTH );
	verdict = COMM_INI_Initiating(dut1_fd, g_pattern_param);
    VERDICT_RESULT_WITH_LINE();

	// Upper Tester sends an HCI_LE_Set_Random_Address command to set the IUT random address and
	// expects an HCI_Command_Complete event from the IUT with a Status of 0x0C.
	COMM_Random_Device_Address_Set_Config(dut1,&g_pattern_param);
	COMM_Device_Address_Set(dut1_fd,g_pattern_param);

	COMM_INI_Connection_Setup_White_Listed_Config(dut1, &g_pattern_param);
	memcpy(g_pattern_param.white_list_param.Address, adv_addr, ADDR_LENGTH);
	verdict=COMM_INI_Connection_Setup_White_Listed(dut1_fd, g_pattern_param);
	VERDICT_RESULT_WITH_LINE();

    COMM_INI_Connection_Setup_White_Listed_Config(dut2, &g_pattern_param);
    verdict = COMM_INI_Connection_Setup_White_Listed(dut2_fd, g_pattern_param);
    VERDICT_RESULT_WITH_LINE();

    // #p2 :use first channel = 37
    COMM_ADV_Undirected_Advertising_Config(HCI_CMD_PARAM_ADV_DATA_LEN_MAX, &g_pattern_param);
    g_pattern_param.adv_param.Advertising_Interval_Max[0] =  HCI_CMD_PARAM_ADVERTISING_INTERVAL_MIN & 0x00ff;
    g_pattern_param.adv_param.Advertising_Interval_Max[1] = (HCI_CMD_PARAM_ADVERTISING_INTERVAL_MIN & 0xff00) >> 8;
    g_pattern_param.adv_param.Advertising_Interval_Min[0] =  HCI_CMD_PARAM_ADVERTISING_INTERVAL_MIN & 0x00ff;
    g_pattern_param.adv_param.Advertising_Interval_Min[1] = (HCI_CMD_PARAM_ADVERTISING_INTERVAL_MIN & 0xff00) >> 8;
    g_pattern_param.adv_param.Advertising_Filter_Policy[0] = HCI_CMD_PARAM_ALLOW_SCAN_REQ_FROM_WHITELIST_ONLY_AND_CONN_REQ_FROM_WHITELIST_ONLY;
	g_pattern_param.adv_param.Advertising_Channel_Map[0] =   HCI_CMD_PARAM_ENABLE_CHANNEL_37;

    verdict = COMM_ADV_Undirected_Advertising(dut2_fd, g_pattern_param);
    VERDICT_RESULT_WITH_LINE();

	event_query_timer_config(5, 0, 0, 0, &timer);
	event_query_timer_start(timer, read_le_event_enable);

    //waiting adv report event , timer or counter
	while(1) {
		if(1 == read_le_event_get()) {
			//reset event flag
			read_le_event_disable();

            //# p4: check respond with CONN REQ
			if(SUCCESS != QUERY_LE_Event(dut2_fd, buf,	_BT_HCI_LE_EVENT_SUB_OP_CONNECTION_COMPLETE_, 0)) {
				line = __LINE__;
				goto FUN_FAIL;
			}

			if(SUCCESS != hci_le_event_connection_complete_parsing(0, buf, g_pattern_param)) {
				line = __LINE__;
				goto FUN_FAIL;
			}

            //# p7: check respond with CONN REQ
			if(SUCCESS != QUERY_LE_Event(dut1_fd, buf,	_BT_HCI_LE_EVENT_SUB_OP_CONNECTION_COMPLETE_, 0)) {
				line = __LINE__;
				goto FUN_FAIL;
			}

			if(SUCCESS != hci_le_event_connection_complete_parsing(0, buf, g_pattern_param)) {
				line=__LINE__;
				goto FUN_FAIL;
			}

			conn_handles_mas[0] = buf[_BT_HCI_EVT_CON_COMP_CONN_HANDLE+0];
			conn_handles_mas[1] = buf[_BT_HCI_EVT_CON_COMP_CONN_HANDLE+1];

			// # Slave Connection Terminated
			// use connect handle to disconnect
			buf[_BT_HCI_EVT_CON_COMP_CONN_HANDLE+0] = conn_handles_mas[0];
			buf[_BT_HCI_EVT_CON_COMP_CONN_HANDLE+1] = conn_handles_mas[1];

			COMM_Disconnect_Config(dut1, &g_pattern_param,buf);
			verdict = COMM_Disconnect(dut1_fd, g_pattern_param);
			VERDICT_RESULT_WITH_LINE();

            sleep(10);

            dut_reset_with_mask_en(dut1_fd);
            dut_reset_with_mask_en(dut2_fd);
            MSLEEP(500);

            goto CASE_CH_38;
		}
	}

CASE_CH_38:
    // #p9/10/11

    // #p1 :low tester init connection
    //start creat connection to send conn_req
    COMM_INI_Initiating_Config(dut1, &g_pattern_param);
	memcpy(g_pattern_param.create_conn_param.Peer_Address, adv_addr, ADDR_LENGTH );
	verdict = COMM_INI_Initiating(dut1_fd, g_pattern_param);
	VERDICT_RESULT_WITH_LINE();

	// Upper Tester sends an HCI_LE_Set_Random_Address command to set the IUT random address and
	// expects an HCI_Command_Complete event from the IUT with a Status of 0x0C.
	COMM_Random_Device_Address_Set_Config(dut1,&g_pattern_param);
	COMM_Device_Address_Set(dut1_fd,g_pattern_param);

    COMM_INI_Connection_Setup_White_Listed_Config(dut2, &g_pattern_param);
    verdict = COMM_INI_Connection_Setup_White_Listed(dut2_fd, g_pattern_param);
    VERDICT_RESULT_WITH_LINE();

    // #p2 :use second channel = 38
    COMM_ADV_Undirected_Advertising_Config(HCI_CMD_PARAM_ADV_DATA_LEN_MAX, &g_pattern_param);
    g_pattern_param.adv_param.Advertising_Interval_Max[0] =  HCI_CMD_PARAM_ADVERTISING_INTERVAL_MIN & 0x00ff;
    g_pattern_param.adv_param.Advertising_Interval_Max[1] = (HCI_CMD_PARAM_ADVERTISING_INTERVAL_MIN & 0xff00) >> 8;
    g_pattern_param.adv_param.Advertising_Interval_Min[0] =  HCI_CMD_PARAM_ADVERTISING_INTERVAL_MIN & 0x00ff;
    g_pattern_param.adv_param.Advertising_Interval_Min[1] = (HCI_CMD_PARAM_ADVERTISING_INTERVAL_MIN & 0xff00) >> 8;
    g_pattern_param.adv_param.Advertising_Filter_Policy[0] = HCI_CMD_PARAM_ALLOW_SCAN_REQ_FROM_WHITELIST_ONLY_AND_CONN_REQ_FROM_WHITELIST_ONLY;
    g_pattern_param.adv_param.Advertising_Channel_Map[0] = HCI_CMD_PARAM_ENABLE_CHANNEL_38;

    verdict = COMM_ADV_Undirected_Advertising(dut2_fd, g_pattern_param);
    VERDICT_RESULT_WITH_LINE();

    event_query_timer_config(5, 0, 0, 0, &timer);
    event_query_timer_start(timer ,read_le_event_enable );

    //waiting adv report event , timer or counter
    while(1) {
        if(1 == read_le_event_get()) {
            //reset event flag
            read_le_event_disable();
            //# p4: check respond with CONN REQ
            if(SUCCESS != QUERY_LE_Event(dut2_fd, buf, _BT_HCI_LE_EVENT_SUB_OP_CONNECTION_COMPLETE_, 0)) {
                line = __LINE__;
                goto FUN_FAIL;
            }

            if(SUCCESS != hci_le_event_connection_complete_parsing(0, buf, g_pattern_param)) {
                line = __LINE__;
                goto FUN_FAIL;
            }


            //# p7: check respond with CONN REQ
			if (SUCCESS != QUERY_LE_Event(dut1_fd, buf,	_BT_HCI_LE_EVENT_SUB_OP_CONNECTION_COMPLETE_, 0)) {
				line = __LINE__;
				goto FUN_FAIL;
			}


			if(SUCCESS != hci_le_event_connection_complete_parsing(0, buf, g_pattern_param)) {
				line = __LINE__;
				goto FUN_FAIL;
			}

			conn_handles_mas[0] = buf[_BT_HCI_EVT_CON_COMP_CONN_HANDLE+0];
			conn_handles_mas[1] = buf[_BT_HCI_EVT_CON_COMP_CONN_HANDLE+1];


			// # Slave Connection Terminated
			// use connect handle to disconnect
			buf[_BT_HCI_EVT_CON_COMP_CONN_HANDLE+0] = conn_handles_mas[0];
			buf[_BT_HCI_EVT_CON_COMP_CONN_HANDLE+1] = conn_handles_mas[1];

			COMM_Disconnect_Config(dut1, &g_pattern_param, buf);
			verdict = COMM_Disconnect(dut1_fd, g_pattern_param);
			VERDICT_RESULT_WITH_LINE();
            sleep(10);

            dut_reset_with_mask_en(dut1_fd);
            dut_reset_with_mask_en(dut2_fd);
            MSLEEP(500);
            goto CASE_CH_39;
        }
    }

CASE_CH_39:

    // #p12/13/14
    // #p1 :low tester init connection
    //start creat connection to send conn_req
    COMM_INI_Initiating_Config(dut1, &g_pattern_param);
	memcpy(g_pattern_param.create_conn_param.Peer_Address, adv_addr, ADDR_LENGTH );
	verdict = COMM_INI_Initiating(dut1_fd, g_pattern_param);
	VERDICT_RESULT_WITH_LINE();

	// Upper Tester sends an HCI_LE_Set_Random_Address command to set the IUT random address and
	// expects an HCI_Command_Complete event from the IUT with a Status of 0x0C.
	COMM_Random_Device_Address_Set_Config(dut1,&g_pattern_param);
	COMM_Device_Address_Set(dut1_fd,g_pattern_param);

    COMM_INI_Connection_Setup_White_Listed_Config(dut2, &g_pattern_param);
    verdict = COMM_INI_Connection_Setup_White_Listed(dut2_fd, g_pattern_param);
    VERDICT_RESULT_WITH_LINE();

    // #p2 :use third channel = 39
    COMM_ADV_Undirected_Advertising_Config(HCI_CMD_PARAM_ADV_DATA_LEN_MAX, &g_pattern_param);
    g_pattern_param.adv_param.Advertising_Interval_Max[0] =  HCI_CMD_PARAM_ADVERTISING_INTERVAL_MIN & 0x00ff;
    g_pattern_param.adv_param.Advertising_Interval_Max[1] = (HCI_CMD_PARAM_ADVERTISING_INTERVAL_MIN & 0xff00) >> 8;
    g_pattern_param.adv_param.Advertising_Interval_Min[0] =  HCI_CMD_PARAM_ADVERTISING_INTERVAL_MIN & 0x00ff;
    g_pattern_param.adv_param.Advertising_Interval_Min[1] = (HCI_CMD_PARAM_ADVERTISING_INTERVAL_MIN & 0xff00) >> 8;
    g_pattern_param.adv_param.Advertising_Filter_Policy[0] = HCI_CMD_PARAM_ALLOW_SCAN_REQ_FROM_WHITELIST_ONLY_AND_CONN_REQ_FROM_WHITELIST_ONLY;
    g_pattern_param.adv_param.Advertising_Channel_Map[0] = HCI_CMD_PARAM_ENABLE_CHANNEL_39;

    verdict = COMM_ADV_Undirected_Advertising(dut2_fd, g_pattern_param);
    VERDICT_RESULT_WITH_LINE();

    event_query_timer_config(5, 0, 0, 0, &timer);
    event_query_timer_start(timer, read_le_event_enable);

    //waiting adv report event , timer or counter
    while(1) {
        if(1 == read_le_event_get()) {
            //reset event flag
            read_le_event_disable();

            //# p4: check respond with CONN REQ
            if(SUCCESS != QUERY_LE_Event(dut2_fd, buf, _BT_HCI_LE_EVENT_SUB_OP_CONNECTION_COMPLETE_, 0)) {
                line = __LINE__;
                goto FUN_FAIL;
            }

            if(SUCCESS != hci_le_event_connection_complete_parsing(0, buf, g_pattern_param)) {
                line = __LINE__;
                goto FUN_FAIL;
            }

            //# p7: check respond with CONN REQ
			if(SUCCESS != QUERY_LE_Event(dut1_fd, buf, _BT_HCI_LE_EVENT_SUB_OP_CONNECTION_COMPLETE_, 0)) {
				line = __LINE__;
				goto FUN_FAIL;
			}


			if(SUCCESS != hci_le_event_connection_complete_parsing(0, buf, g_pattern_param)) {
				line = __LINE__;
				goto FUN_FAIL;
			}

			conn_handles_mas[0] = buf[_BT_HCI_EVT_CON_COMP_CONN_HANDLE+0];
			conn_handles_mas[1] = buf[_BT_HCI_EVT_CON_COMP_CONN_HANDLE+1];

			// # Slave Connection Terminated
			// use connect handle to disconnect
			buf[_BT_HCI_EVT_CON_COMP_CONN_HANDLE+0] = conn_handles_mas[0];
			buf[_BT_HCI_EVT_CON_COMP_CONN_HANDLE+1] = conn_handles_mas[1];

			COMM_Disconnect_Config(dut1, &g_pattern_param, buf);
			verdict = COMM_Disconnect(dut1_fd, g_pattern_param);
			VERDICT_RESULT_WITH_LINE();
            goto FUN_SUCCESS;

        }
    }

FUN_SUCCESS:
    FUNC_END();

	LOG_INFO("[Pattern][%s]SUCCESS\n", __FUNCTION__);
	return PASS;

FUN_FAIL:
    FUNC_END();

	LOG_INFO("[Pattern][%s]:%d FAIL\n", __FUNCTION__, line);
    return FAIL;


}


// 5.3.2.2 (refer to 5.3.1.4)
verdict CON_INI_Connecting_to_Directed_Advertising(u8 dut1_fd ,u8 dut2_fd)
{
    u8 buf[SOCKET_BUF_SIZE];
    int verdict = FAIL;
    int dut1 = 0;
    int dut2 = 0;
    u16 line = 0;
    int adv_Channel = 37;
    struct itimerval timer;
    u8 conn_handles_mas[2];

    COMM_Dut_clean_buffer(dut1_fd);
    COMM_Dut_clean_buffer(dut2_fd);

    Calculate_Execution_Time_Start();
REPEAT:
    // Uptest(white list) config
	COMM_INI_Connection_Setup_White_Listed_Config(dut2, &g_pattern_param);
    memcpy(g_pattern_param.white_list_param.Address, scan_addr, ADDR_LENGTH);
    g_pattern_param.white_list_param.Address_Type[0] = HCI_CMD_PARAM_PUBLIC_DEVICE_ADDRESS;
    verdict = COMM_INI_Connection_Setup_White_Listed(dut2_fd, g_pattern_param);
    VERDICT_RESULT_WITH_LINE();

    //# case 1
	COMM_ADV_Directed_Advertising_Config(HCI_CMD_PARAM_ADV_DATA_LEN_MAX, &g_pattern_param);
    g_pattern_param.adv_param.Advertising_Filter_Policy[0] = HCI_CMD_PARAM_ALLOW_SCAN_REQ_FROM_WHITELIST_ONLY_AND_CONN_REQ_FROM_WHITELIST_ONLY;
	g_pattern_param.adv_param.Advertising_Interval_Max[0] =  0x00a0 & 0x00ff;
    g_pattern_param.adv_param.Advertising_Interval_Max[1] = (0x00a0 & 0xff00) >> 8;
    g_pattern_param.adv_param.Advertising_Interval_Min[0] =  0x00a0 & 0x00ff;
    g_pattern_param.adv_param.Advertising_Interval_Min[1] = (0x00a0 & 0xff00) >> 8;
	if(37 == adv_Channel) {
        g_pattern_param.adv_param.Advertising_Channel_Map[0] = HCI_CMD_PARAM_ENABLE_CHANNEL_37;
    }
    else if(38 == adv_Channel) {
        g_pattern_param.adv_param.Advertising_Channel_Map[0] = HCI_CMD_PARAM_ENABLE_CHANNEL_38;
    }
    else {
        g_pattern_param.adv_param.Advertising_Channel_Map[0] = HCI_CMD_PARAM_ENABLE_CHANNEL_39;
    }
	verdict = COMM_ADV_Directed_Advertising(dut2_fd, g_pattern_param);
	VERDICT_RESULT_WITH_LINE();

    // #config mismatch init address
	COMM_INI_Initiating_Config(dut1, &g_pattern_param);
    memcpy(g_pattern_param.create_conn_param.Peer_Address, error_addr, ADDR_LENGTH);
	verdict = COMM_INI_Initiating(dut1_fd, g_pattern_param);
	VERDICT_RESULT_WITH_LINE();

    event_query_timer_config(5, 0, 0, 0, &timer);
    event_query_timer_start(timer, read_le_event_enable);

    //waiting adv report event , timer or counter
    while(1) {
        if( 1 == read_le_event_get() ) {
            read_le_event_disable();
            if (SUCCESS != QUERY_LE_Event(dut2_fd, buf, _BT_HCI_LE_EVENT_SUB_OP_CONNECTION_COMPLETE_, 0)) {
                line = __LINE__;
                goto FUN_FAIL;
            }

            if(_BT_HCI_EVT_CMD_COMP_STATUS_DIRECTED_ADVERTISING_TIMEOUT != hci_le_event_connection_complete_parsing(0, buf, g_pattern_param)) {
                line = __LINE__;
                goto FUN_FAIL;
            }
            break;
        }
    }
    dut_reset_with_mask_en(dut1_fd);
    sleep(1);


    //# case 2
    COMM_ADV_Directed_Advertising_Config(HCI_CMD_PARAM_ADV_DATA_LEN_MAX, &g_pattern_param);
    g_pattern_param.adv_param.Advertising_Filter_Policy[0] = HCI_CMD_PARAM_ALLOW_SCAN_REQ_FROM_WHITELIST_ONLY_AND_CONN_REQ_FROM_WHITELIST_ONLY;
	g_pattern_param.adv_param.Advertising_Interval_Max[0] =  0x00a0 & 0x00ff;
    g_pattern_param.adv_param.Advertising_Interval_Max[1] = (0x00a0 & 0xff00) >> 8;
    g_pattern_param.adv_param.Advertising_Interval_Min[0] =  0x00a0 & 0x00ff;
    g_pattern_param.adv_param.Advertising_Interval_Min[1] = (0x00a0 & 0xff00) >> 8;
	if(37 == adv_Channel) {
        g_pattern_param.adv_param.Advertising_Channel_Map[0] = HCI_CMD_PARAM_ENABLE_CHANNEL_37;
    }
    else if(38 == adv_Channel) {
        g_pattern_param.adv_param.Advertising_Channel_Map[0] = HCI_CMD_PARAM_ENABLE_CHANNEL_38;
    }
    else {
        g_pattern_param.adv_param.Advertising_Channel_Map[0] = HCI_CMD_PARAM_ENABLE_CHANNEL_39;
    }
	verdict = COMM_ADV_Directed_Advertising(dut2_fd, g_pattern_param);
	VERDICT_RESULT_WITH_LINE();

	COMM_INI_Initiating_Config(dut1, &g_pattern_param);
    memcpy(g_pattern_param.create_conn_param.Peer_Address, adv_addr, ADDR_LENGTH);
	verdict = COMM_INI_Initiating(dut1_fd, g_pattern_param);
	VERDICT_RESULT_WITH_LINE();

    event_query_timer_config(5, 0, 0, 0, &timer);
    event_query_timer_start(timer, read_le_event_enable);

    //waiting adv report event , timer or counter
    while(1) {
        if( 1 == read_le_event_get() ) {
            read_le_event_disable();
            if (SUCCESS != QUERY_LE_Event(dut2_fd, buf, _BT_HCI_LE_EVENT_SUB_OP_CONNECTION_COMPLETE_, 0)) {
                line = __LINE__;
                goto FUN_FAIL;
            }

            if(SUCCESS != hci_le_event_connection_complete_parsing(0, buf, g_pattern_param)) {
                line = __LINE__;
                goto FUN_FAIL;
            }

            if (SUCCESS != QUERY_LE_Event(dut1_fd, buf, _BT_HCI_LE_EVENT_SUB_OP_CONNECTION_COMPLETE_, 0)) {
                line = __LINE__;
                goto FUN_FAIL;
            }

            if(SUCCESS != hci_le_event_connection_complete_parsing(0, buf, g_pattern_param)) {
                line = __LINE__;
                goto FUN_FAIL;
            }

			conn_handles_mas[0] = buf[_BT_HCI_EVT_CON_COMP_CONN_HANDLE+0];
			conn_handles_mas[1] = buf[_BT_HCI_EVT_CON_COMP_CONN_HANDLE+1];

            break;
        }
    }

    sleep(600);

    if(SUCCESS != QUERY_Event(dut1_fd, buf, _BT_HCI_EVENT_OP_DISCONNECTION_COMPLETE_)) {
        line = __LINE__;
        goto FUN_FAIL;
    }
    else if(SUCCESS != hci_event_disconnection_complete_parsing(0, buf, g_pattern_param)) {
        line = __LINE__;
        goto FUN_FAIL;
    }
    if( 0 != buf[_BT_HCI_EVT_DISCONN_COMP_REASON]) {
        line = __LINE__;
        goto FUN_FAIL;
    }


    if(SUCCESS != QUERY_Event(dut2_fd, buf, _BT_HCI_EVENT_OP_DISCONNECTION_COMPLETE_)) {
        line = __LINE__;
        goto FUN_FAIL;
    }
    else if(SUCCESS != hci_event_disconnection_complete_parsing(0, buf, g_pattern_param)) {
        line = __LINE__;
        goto FUN_FAIL;
    }
    if( 0 != buf[_BT_HCI_EVT_DISCONN_COMP_REASON]) {
        line = __LINE__;
        goto FUN_FAIL;
    }


    // # Slave Connection Terminated
    // use connect handle to disconnect
    buf[_BT_HCI_EVT_CON_COMP_CONN_HANDLE+0] = conn_handles_mas[0];
    buf[_BT_HCI_EVT_CON_COMP_CONN_HANDLE+1] = conn_handles_mas[1];

    COMM_Disconnect_Config(dut1, &g_pattern_param,buf);
    verdict = COMM_Disconnect(dut1_fd, g_pattern_param);
    VERDICT_RESULT_WITH_LINE();

    sleep(5);

    dut_reset_with_mask_en(dut1_fd);
    dut_reset_with_mask_en(dut2_fd);

    MSLEEP(500);

#if 0
    if(adv_Channel != 39){
        adv_Channel ++;
        goto REPEAT;
    }
#endif
    FUNC_END();

    LOG_INFO("[Pattern][%s]SUCCESS\n" ,__FUNCTION__);
    return 0;

FUN_FAIL:
    FUNC_END();

    LOG_INFO("[Pattern][%s]:%d FAIL : ch %d \n" ,__FUNCTION__,line ,adv_Channel);
    return 0;
}

// 5.3.2.5 (refer to 5.3.2.2)
verdict CON_INI_Initiation_Device_Filtering_Undirected(u8 dut1_fd ,u8 dut2_fd)
{
    u8 buf[SOCKET_BUF_SIZE];
    int verdict = FAIL;
    int dut1 = 0;
    int dut2 = 0;
    u16 line = 0;
    int adv_Channel = 37;
    struct itimerval timer;
    u8 conn_handles_mas[2];

    COMM_Dut_clean_buffer(dut1_fd);
    COMM_Dut_clean_buffer(dut2_fd);

    Calculate_Execution_Time_Start();
REPEAT:
    //# case 1
    //incorrect address type, correct address

    // Uptest(white list) config
	COMM_INI_Connection_Setup_White_Listed_Config(dut1, &g_pattern_param);
    memcpy(g_pattern_param.white_list_param.Address, adv_addr, ADDR_LENGTH);
    g_pattern_param.white_list_param.Address_Type[0] = HCI_CMD_PARAM_PUBLIC_DEVICE_ADDRESS;
    verdict = COMM_INI_Connection_Setup_White_Listed(dut1_fd, g_pattern_param);
    VERDICT_RESULT_WITH_LINE();

	COMM_INI_Connection_Setup_White_Listed_Config(dut2, &g_pattern_param);
    memcpy(g_pattern_param.white_list_param.Address, init_addr, ADDR_LENGTH);
    g_pattern_param.white_list_param.Address_Type[0] = HCI_CMD_PARAM_PUBLIC_DEVICE_ADDRESS;
    verdict = COMM_INI_Connection_Setup_White_Listed(dut2_fd, g_pattern_param);
    VERDICT_RESULT_WITH_LINE();

	COMM_Static_Random_Device_Address_Set_Config(adv_addr);
	COMM_Device_Address_Set(dut2_fd,g_pattern_param);
	COMM_ADV_Undirected_Advertising_Config(HCI_CMD_PARAM_ADV_DATA_LEN_MAX, &g_pattern_param);
	g_pattern_param.adv_param.Own_Address_Type[0]	    =	HCI_CMD_PARAM_RANDOM_DEVICE_ADDRESS;
	//g_pattern_param.adv_param.Direct_Address_Type[0]	=	HCI_CMD_PARAM_RANDOM_DEVICE_ADDRESS;
    g_pattern_param.adv_param.Advertising_Filter_Policy[0] = HCI_CMD_PARAM_ALLOW_SCAN_REQ_FROM_WHITELIST_ONLY_AND_CONN_REQ_FROM_WHITELIST_ONLY;
	g_pattern_param.adv_param.Advertising_Interval_Max[0] =  0x00a0 & 0x00ff;
    g_pattern_param.adv_param.Advertising_Interval_Max[1] = (0x00a0 & 0xff00) >> 8;
    g_pattern_param.adv_param.Advertising_Interval_Min[0] =  0x00a0 & 0x00ff;
    g_pattern_param.adv_param.Advertising_Interval_Min[1] = (0x00a0 & 0xff00) >> 8;
	if(37 == adv_Channel) {
        g_pattern_param.adv_param.Advertising_Channel_Map[0] = HCI_CMD_PARAM_ENABLE_CHANNEL_37;
    }
    else if(38 == adv_Channel) {
        g_pattern_param.adv_param.Advertising_Channel_Map[0] = HCI_CMD_PARAM_ENABLE_CHANNEL_38;
    }
    else {
        g_pattern_param.adv_param.Advertising_Channel_Map[0] = HCI_CMD_PARAM_ENABLE_CHANNEL_39;
    }
	verdict = COMM_ADV_Undirected_Advertising(dut2_fd, g_pattern_param);
	VERDICT_RESULT_WITH_LINE();

	COMM_INI_Initiating_Config(dut1, &g_pattern_param);
    g_pattern_param.create_conn_param.Initiator_Filter_Policy[0] = HCI_CMD_PARAM_FILTER_POLICY_WHITE_LIST_USED;
	bt_hci_cmd_le_create_connection.parameter_tbl[2].value  =  g_pattern_param.create_conn_param.Initiator_Filter_Policy;
    memcpy(g_pattern_param.create_conn_param.Peer_Address, zero_addr, ADDR_LENGTH);
    bt_hci_cmd_le_create_connection.parameter_tbl[4].value  = g_pattern_param.create_conn_param.Peer_Address;
	verdict = COMM_INI_Initiating(dut1_fd, g_pattern_param);
	VERDICT_RESULT_WITH_LINE();

    event_query_timer_config(5, 0, 0, 0, &timer);
    event_query_timer_start(timer, read_le_event_enable);

    //waiting adv report event , timer or counter
    while(1) {
        if( 1 == read_le_event_get() ) {
            read_le_event_disable();
            if (SUCCESS != QUERY_LE_Event(dut2_fd, buf, _BT_HCI_LE_EVENT_SUB_OP_CONNECTION_COMPLETE_, 0)) {
                line = __LINE__;
                goto FUN_FAIL;
            }

            if(SUCCESS == hci_le_event_connection_complete_parsing(0, buf, g_pattern_param)) {
                line = __LINE__;
                goto FUN_FAIL;
            }
            break;
        }
    }
    dut_reset_with_mask_en(dut1_fd);
    dut_reset_with_mask_en(dut2_fd);
    sleep(6);


    //# case 2
    //Correct address type
    //Incorrect address

    // Uptest(white list) config
	COMM_INI_Connection_Setup_White_Listed_Config(dut1, &g_pattern_param);
    memcpy(g_pattern_param.white_list_param.Address, error_addr, ADDR_LENGTH);
    g_pattern_param.white_list_param.Address_Type[0] = HCI_CMD_PARAM_PUBLIC_DEVICE_ADDRESS;
    verdict = COMM_INI_Connection_Setup_White_Listed(dut1_fd, g_pattern_param);
    VERDICT_RESULT_WITH_LINE();

	COMM_INI_Connection_Setup_White_Listed_Config(dut2, &g_pattern_param);
    memcpy(g_pattern_param.white_list_param.Address, init_addr, ADDR_LENGTH);
    g_pattern_param.white_list_param.Address_Type[0] = HCI_CMD_PARAM_PUBLIC_DEVICE_ADDRESS;
    verdict = COMM_INI_Connection_Setup_White_Listed(dut2_fd, g_pattern_param);
    VERDICT_RESULT_WITH_LINE();

	COMM_ADV_Undirected_Advertising_Config(HCI_CMD_PARAM_ADV_DATA_LEN_MAX, &g_pattern_param);
    g_pattern_param.adv_param.Advertising_Filter_Policy[0] = HCI_CMD_PARAM_ALLOW_SCAN_REQ_FROM_WHITELIST_ONLY_AND_CONN_REQ_FROM_WHITELIST_ONLY;
	g_pattern_param.adv_param.Advertising_Interval_Max[0] =  0x00a0 & 0x00ff;
    g_pattern_param.adv_param.Advertising_Interval_Max[1] = (0x00a0 & 0xff00) >> 8;
    g_pattern_param.adv_param.Advertising_Interval_Min[0] =  0x00a0 & 0x00ff;
    g_pattern_param.adv_param.Advertising_Interval_Min[1] = (0x00a0 & 0xff00) >> 8;
	if(37 == adv_Channel) {
        g_pattern_param.adv_param.Advertising_Channel_Map[0] = HCI_CMD_PARAM_ENABLE_CHANNEL_37;
    }
    else if(38 == adv_Channel) {
        g_pattern_param.adv_param.Advertising_Channel_Map[0] = HCI_CMD_PARAM_ENABLE_CHANNEL_38;
    }
    else {
        g_pattern_param.adv_param.Advertising_Channel_Map[0] = HCI_CMD_PARAM_ENABLE_CHANNEL_39;
    }
	verdict = COMM_ADV_Undirected_Advertising(dut2_fd, g_pattern_param);
	VERDICT_RESULT_WITH_LINE();

	COMM_INI_Initiating_Config(dut1, &g_pattern_param);
    g_pattern_param.create_conn_param.Initiator_Filter_Policy[0] = HCI_CMD_PARAM_FILTER_POLICY_WHITE_LIST_USED;
	bt_hci_cmd_le_create_connection.parameter_tbl[2].value  =  g_pattern_param.create_conn_param.Initiator_Filter_Policy;
    memcpy(g_pattern_param.create_conn_param.Peer_Address, zero_addr, ADDR_LENGTH);
    bt_hci_cmd_le_create_connection.parameter_tbl[4].value  = g_pattern_param.create_conn_param.Peer_Address;
	verdict = COMM_INI_Initiating(dut1_fd, g_pattern_param);
	VERDICT_RESULT_WITH_LINE();

    event_query_timer_config(5, 0, 0, 0, &timer);
    event_query_timer_start(timer, read_le_event_enable);

    //waiting adv report event , timer or counter
    while(1) {
        if( 1 == read_le_event_get() ) {
            read_le_event_disable();
            if (SUCCESS != QUERY_LE_Event(dut2_fd, buf, _BT_HCI_LE_EVENT_SUB_OP_CONNECTION_COMPLETE_, 0)) {
                line = __LINE__;
                goto FUN_FAIL;
            }

            if(SUCCESS == hci_le_event_connection_complete_parsing(0, buf, g_pattern_param)) {
                line = __LINE__;
                goto FUN_FAIL;
            }
            break;
        }
    }
    dut_reset_with_mask_en(dut1_fd);
    dut_reset_with_mask_en(dut2_fd);
    sleep(6);


    //# case 3
    //Correct address type
    //Correct address

    // Uptest(white list) config
	COMM_INI_Connection_Setup_White_Listed_Config(dut1, &g_pattern_param);
    memcpy(g_pattern_param.white_list_param.Address, adv_addr, ADDR_LENGTH);
    g_pattern_param.white_list_param.Address_Type[0] = HCI_CMD_PARAM_PUBLIC_DEVICE_ADDRESS;
    verdict = COMM_INI_Connection_Setup_White_Listed(dut1_fd, g_pattern_param);
    VERDICT_RESULT_WITH_LINE();

	COMM_INI_Connection_Setup_White_Listed_Config(dut2, &g_pattern_param);
    memcpy(g_pattern_param.white_list_param.Address, init_addr, ADDR_LENGTH);
    g_pattern_param.white_list_param.Address_Type[0] = HCI_CMD_PARAM_PUBLIC_DEVICE_ADDRESS;
    verdict = COMM_INI_Connection_Setup_White_Listed(dut2_fd, g_pattern_param);
    VERDICT_RESULT_WITH_LINE();

	COMM_ADV_Undirected_Advertising_Config(HCI_CMD_PARAM_ADV_DATA_LEN_MAX, &g_pattern_param);
    g_pattern_param.adv_param.Advertising_Filter_Policy[0] = HCI_CMD_PARAM_ALLOW_SCAN_REQ_FROM_WHITELIST_ONLY_AND_CONN_REQ_FROM_WHITELIST_ONLY;
	g_pattern_param.adv_param.Advertising_Interval_Max[0] =  0x00a0 & 0x00ff;
    g_pattern_param.adv_param.Advertising_Interval_Max[1] = (0x00a0 & 0xff00) >> 8;
    g_pattern_param.adv_param.Advertising_Interval_Min[0] =  0x00a0 & 0x00ff;
    g_pattern_param.adv_param.Advertising_Interval_Min[1] = (0x00a0 & 0xff00) >> 8;
	if(37 == adv_Channel) {
        g_pattern_param.adv_param.Advertising_Channel_Map[0] = HCI_CMD_PARAM_ENABLE_CHANNEL_37;
    }
    else if(38 == adv_Channel) {
        g_pattern_param.adv_param.Advertising_Channel_Map[0] = HCI_CMD_PARAM_ENABLE_CHANNEL_38;
    }
    else {
        g_pattern_param.adv_param.Advertising_Channel_Map[0] = HCI_CMD_PARAM_ENABLE_CHANNEL_39;
    }
	verdict = COMM_ADV_Undirected_Advertising(dut2_fd, g_pattern_param);
	VERDICT_RESULT_WITH_LINE();

	COMM_INI_Initiating_Config(dut1, &g_pattern_param);
    g_pattern_param.create_conn_param.Initiator_Filter_Policy[0] = HCI_CMD_PARAM_FILTER_POLICY_WHITE_LIST_USED;
	bt_hci_cmd_le_create_connection.parameter_tbl[2].value  =  g_pattern_param.create_conn_param.Initiator_Filter_Policy;
    memcpy(g_pattern_param.create_conn_param.Peer_Address, zero_addr, ADDR_LENGTH);
    bt_hci_cmd_le_create_connection.parameter_tbl[4].value  = g_pattern_param.create_conn_param.Peer_Address;
	verdict = COMM_INI_Initiating(dut1_fd, g_pattern_param);
	VERDICT_RESULT_WITH_LINE();

    event_query_timer_config(5, 0, 0, 0, &timer);
    event_query_timer_start(timer, read_le_event_enable);
    //waiting adv report event , timer or counter
    while(1) {
        if( 1 == read_le_event_get() ) {
            read_le_event_disable();
            if (SUCCESS != QUERY_LE_Event(dut2_fd, buf, _BT_HCI_LE_EVENT_SUB_OP_CONNECTION_COMPLETE_, 0)) {
                line = __LINE__;
                goto FUN_FAIL;
            }

            if(SUCCESS != hci_le_event_connection_complete_parsing(0, buf, g_pattern_param)) {
                line = __LINE__;
                goto FUN_FAIL;
            }

            if (SUCCESS != QUERY_LE_Event(dut1_fd, buf, _BT_HCI_LE_EVENT_SUB_OP_CONNECTION_COMPLETE_, 0)) {
                line = __LINE__;
                goto FUN_FAIL;
            }

            if(SUCCESS != hci_le_event_connection_complete_parsing(0, buf, g_pattern_param)) {
                line = __LINE__;
                goto FUN_FAIL;
            }

			conn_handles_mas[0] = buf[_BT_HCI_EVT_CON_COMP_CONN_HANDLE+0];
			conn_handles_mas[1] = buf[_BT_HCI_EVT_CON_COMP_CONN_HANDLE+1];

            break;
        }
    }

    sleep(6);

    if(SUCCESS != QUERY_Event(dut1_fd, buf, _BT_HCI_EVENT_OP_DISCONNECTION_COMPLETE_)) {
        line = __LINE__;
        goto FUN_FAIL;
    }
    else if(SUCCESS != hci_event_disconnection_complete_parsing(0, buf, g_pattern_param)) {
        line = __LINE__;
        goto FUN_FAIL;
    }
    if( 0 != buf[_BT_HCI_EVT_DISCONN_COMP_REASON]) {
        line = __LINE__;
        goto FUN_FAIL;
    }


    if(SUCCESS != QUERY_Event(dut2_fd, buf, _BT_HCI_EVENT_OP_DISCONNECTION_COMPLETE_)) {
        line = __LINE__;
        goto FUN_FAIL;
    }
    else if(SUCCESS != hci_event_disconnection_complete_parsing(0, buf, g_pattern_param)) {
        line = __LINE__;
        goto FUN_FAIL;
    }
    if( 0 != buf[_BT_HCI_EVT_DISCONN_COMP_REASON]) {
        line = __LINE__;
        goto FUN_FAIL;
    }


    // # Slave Connection Terminated
    // use connect handle to disconnect
    buf[_BT_HCI_EVT_CON_COMP_CONN_HANDLE+0] = conn_handles_mas[0];
    buf[_BT_HCI_EVT_CON_COMP_CONN_HANDLE+1] = conn_handles_mas[1];

    COMM_Disconnect_Config(dut1, &g_pattern_param,buf);
    verdict = COMM_Disconnect(dut1_fd, g_pattern_param);
    VERDICT_RESULT_WITH_LINE();

    sleep(5);

    dut_reset_with_mask_en(dut1_fd);
    dut_reset_with_mask_en(dut2_fd);

    MSLEEP(500);

#if 0
    if(adv_Channel != 39){
        adv_Channel ++;
        goto REPEAT;
    }
#endif
    FUNC_END();

    LOG_INFO("[Pattern][%s]SUCCESS\n" ,__FUNCTION__);
    return 0;

FUN_FAIL:
    FUNC_END();

    LOG_INFO("[Pattern][%s]:%d FAIL : ch %d \n" ,__FUNCTION__,line ,adv_Channel);
    return 0;
}

// 5.3.2.6 (refer to 5.3.2.2)
verdict CON_INI_Initiation_Device_Filtering_Directed(u8 dut1_fd ,u8 dut2_fd)
{
    u8 buf[SOCKET_BUF_SIZE];
    int verdict = FAIL;
    int dut1 = 0;
    int dut2 = 0;
    u16 line = 0;
    int adv_Channel = 37;
    struct itimerval timer;
    u8 conn_handles_mas[2];

    COMM_Dut_clean_buffer(dut1_fd);
    COMM_Dut_clean_buffer(dut2_fd);

    Calculate_Execution_Time_Start();
REPEAT:
    //# case 1
    //incorrect address type, correct address

    // Uptest(white list) config
	COMM_INI_Connection_Setup_White_Listed_Config(dut1, &g_pattern_param);
    memcpy(g_pattern_param.white_list_param.Address, adv_addr, ADDR_LENGTH);
    g_pattern_param.white_list_param.Address_Type[0] = HCI_CMD_PARAM_PUBLIC_DEVICE_ADDRESS;
    verdict = COMM_INI_Connection_Setup_White_Listed(dut1_fd, g_pattern_param);
    VERDICT_RESULT_WITH_LINE();

	COMM_INI_Connection_Setup_White_Listed_Config(dut2, &g_pattern_param);
    memcpy(g_pattern_param.white_list_param.Address, init_addr, ADDR_LENGTH);
    g_pattern_param.white_list_param.Address_Type[0] = HCI_CMD_PARAM_PUBLIC_DEVICE_ADDRESS;
    verdict = COMM_INI_Connection_Setup_White_Listed(dut2_fd, g_pattern_param);
    VERDICT_RESULT_WITH_LINE();

	COMM_Static_Random_Device_Address_Set_Config(adv_addr);
	COMM_Device_Address_Set(dut2_fd,g_pattern_param);
	COMM_ADV_Directed_Advertising_Config(HCI_CMD_PARAM_ADV_DATA_LEN_MAX, &g_pattern_param);
	g_pattern_param.adv_param.Own_Address_Type[0]	    =	HCI_CMD_PARAM_RANDOM_DEVICE_ADDRESS;
	//g_pattern_param.adv_param.Direct_Address_Type[0]	=	HCI_CMD_PARAM_RANDOM_DEVICE_ADDRESS;
    g_pattern_param.adv_param.Advertising_Filter_Policy[0] = HCI_CMD_PARAM_ALLOW_SCAN_REQ_FROM_WHITELIST_ONLY_AND_CONN_REQ_FROM_WHITELIST_ONLY;
	g_pattern_param.adv_param.Advertising_Interval_Max[0] =  0x00a0 & 0x00ff;
    g_pattern_param.adv_param.Advertising_Interval_Max[1] = (0x00a0 & 0xff00) >> 8;
    g_pattern_param.adv_param.Advertising_Interval_Min[0] =  0x00a0 & 0x00ff;
    g_pattern_param.adv_param.Advertising_Interval_Min[1] = (0x00a0 & 0xff00) >> 8;
	if(37 == adv_Channel) {
        g_pattern_param.adv_param.Advertising_Channel_Map[0] = HCI_CMD_PARAM_ENABLE_CHANNEL_37;
    }
    else if(38 == adv_Channel) {
        g_pattern_param.adv_param.Advertising_Channel_Map[0] = HCI_CMD_PARAM_ENABLE_CHANNEL_38;
    }
    else {
        g_pattern_param.adv_param.Advertising_Channel_Map[0] = HCI_CMD_PARAM_ENABLE_CHANNEL_39;
    }
	verdict = COMM_ADV_Directed_Advertising(dut2_fd, g_pattern_param);
	VERDICT_RESULT_WITH_LINE();

	COMM_INI_Initiating_Config(dut1, &g_pattern_param);
    g_pattern_param.create_conn_param.Initiator_Filter_Policy[0] = HCI_CMD_PARAM_FILTER_POLICY_WHITE_LIST_USED;
	bt_hci_cmd_le_create_connection.parameter_tbl[2].value  =  g_pattern_param.create_conn_param.Initiator_Filter_Policy;
    memcpy(g_pattern_param.create_conn_param.Peer_Address, zero_addr, ADDR_LENGTH);
    bt_hci_cmd_le_create_connection.parameter_tbl[4].value  = g_pattern_param.create_conn_param.Peer_Address;
	verdict = COMM_INI_Initiating(dut1_fd, g_pattern_param);
	VERDICT_RESULT_WITH_LINE();

    event_query_timer_config(5, 0, 0, 0, &timer);
    event_query_timer_start(timer, read_le_event_enable);

    //waiting adv report event , timer or counter
    while(1) {
        if( 1 == read_le_event_get() ) {
            read_le_event_disable();
            if (SUCCESS != QUERY_LE_Event(dut2_fd, buf, _BT_HCI_LE_EVENT_SUB_OP_CONNECTION_COMPLETE_, 0)) {
                line = __LINE__;
                goto FUN_FAIL;
            }

            if(_BT_HCI_EVT_CMD_COMP_STATUS_DIRECTED_ADVERTISING_TIMEOUT != hci_le_event_connection_complete_parsing(0, buf, g_pattern_param)) {
                line = __LINE__;
                goto FUN_FAIL;
            }
            break;
        }
    }
    dut_reset_with_mask_en(dut1_fd);
    sleep(6);


    //# case 2
    //Correct address type
    //Incorrect address

    // Uptest(white list) config
	COMM_INI_Connection_Setup_White_Listed_Config(dut1, &g_pattern_param);
    memcpy(g_pattern_param.white_list_param.Address, error_addr, ADDR_LENGTH);
    g_pattern_param.white_list_param.Address_Type[0] = HCI_CMD_PARAM_PUBLIC_DEVICE_ADDRESS;
    verdict = COMM_INI_Connection_Setup_White_Listed(dut1_fd, g_pattern_param);
    VERDICT_RESULT_WITH_LINE();

	COMM_INI_Connection_Setup_White_Listed_Config(dut2, &g_pattern_param);
    memcpy(g_pattern_param.white_list_param.Address, init_addr, ADDR_LENGTH);
    g_pattern_param.white_list_param.Address_Type[0] = HCI_CMD_PARAM_PUBLIC_DEVICE_ADDRESS;
    verdict = COMM_INI_Connection_Setup_White_Listed(dut2_fd, g_pattern_param);
    VERDICT_RESULT_WITH_LINE();

	COMM_ADV_Directed_Advertising_Config(HCI_CMD_PARAM_ADV_DATA_LEN_MAX, &g_pattern_param);
    g_pattern_param.adv_param.Advertising_Filter_Policy[0] = HCI_CMD_PARAM_ALLOW_SCAN_REQ_FROM_WHITELIST_ONLY_AND_CONN_REQ_FROM_WHITELIST_ONLY;
	g_pattern_param.adv_param.Advertising_Interval_Max[0] =  0x00a0 & 0x00ff;
    g_pattern_param.adv_param.Advertising_Interval_Max[1] = (0x00a0 & 0xff00) >> 8;
    g_pattern_param.adv_param.Advertising_Interval_Min[0] =  0x00a0 & 0x00ff;
    g_pattern_param.adv_param.Advertising_Interval_Min[1] = (0x00a0 & 0xff00) >> 8;
	if(37 == adv_Channel) {
        g_pattern_param.adv_param.Advertising_Channel_Map[0] = HCI_CMD_PARAM_ENABLE_CHANNEL_37;
    }
    else if(38 == adv_Channel) {
        g_pattern_param.adv_param.Advertising_Channel_Map[0] = HCI_CMD_PARAM_ENABLE_CHANNEL_38;
    }
    else {
        g_pattern_param.adv_param.Advertising_Channel_Map[0] = HCI_CMD_PARAM_ENABLE_CHANNEL_39;
    }
	verdict = COMM_ADV_Directed_Advertising(dut2_fd, g_pattern_param);
	VERDICT_RESULT_WITH_LINE();

	COMM_INI_Initiating_Config(dut1, &g_pattern_param);
    g_pattern_param.create_conn_param.Initiator_Filter_Policy[0] = HCI_CMD_PARAM_FILTER_POLICY_WHITE_LIST_USED;
	bt_hci_cmd_le_create_connection.parameter_tbl[2].value  =  g_pattern_param.create_conn_param.Initiator_Filter_Policy;
    memcpy(g_pattern_param.create_conn_param.Peer_Address, zero_addr, ADDR_LENGTH);
    bt_hci_cmd_le_create_connection.parameter_tbl[4].value  = g_pattern_param.create_conn_param.Peer_Address;
	verdict = COMM_INI_Initiating(dut1_fd, g_pattern_param);
	VERDICT_RESULT_WITH_LINE();

    event_query_timer_config(5, 0, 0, 0, &timer);
    event_query_timer_start(timer, read_le_event_enable);

    //waiting adv report event , timer or counter
    while(1) {
        if( 1 == read_le_event_get() ) {
            read_le_event_disable();
            if (SUCCESS != QUERY_LE_Event(dut2_fd, buf, _BT_HCI_LE_EVENT_SUB_OP_CONNECTION_COMPLETE_, 0)) {
                line = __LINE__;
                goto FUN_FAIL;
            }

            if(_BT_HCI_EVT_CMD_COMP_STATUS_DIRECTED_ADVERTISING_TIMEOUT != hci_le_event_connection_complete_parsing(0, buf, g_pattern_param)) {
                line = __LINE__;
                goto FUN_FAIL;
            }
            break;
        }
    }
    dut_reset_with_mask_en(dut1_fd);
    sleep(6);


    //# case 3
    //Correct address type
    //Correct address

    // Uptest(white list) config
	COMM_INI_Connection_Setup_White_Listed_Config(dut1, &g_pattern_param);
    memcpy(g_pattern_param.white_list_param.Address, adv_addr, ADDR_LENGTH);
    g_pattern_param.white_list_param.Address_Type[0] = HCI_CMD_PARAM_PUBLIC_DEVICE_ADDRESS;
    verdict = COMM_INI_Connection_Setup_White_Listed(dut1_fd, g_pattern_param);
    VERDICT_RESULT_WITH_LINE();

	COMM_INI_Connection_Setup_White_Listed_Config(dut2, &g_pattern_param);
    memcpy(g_pattern_param.white_list_param.Address, init_addr, ADDR_LENGTH);
    g_pattern_param.white_list_param.Address_Type[0] = HCI_CMD_PARAM_PUBLIC_DEVICE_ADDRESS;
    verdict = COMM_INI_Connection_Setup_White_Listed(dut2_fd, g_pattern_param);
    VERDICT_RESULT_WITH_LINE();

	COMM_ADV_Directed_Advertising_Config_type_addr(HCI_CMD_PARAM_ADV_DATA_LEN_MAX, &g_pattern_param, HCI_CMD_PARAM_PUBLIC_DEVICE_ADDRESS, init_addr);
    g_pattern_param.adv_param.Advertising_Filter_Policy[0] = HCI_CMD_PARAM_ALLOW_SCAN_REQ_FROM_WHITELIST_ONLY_AND_CONN_REQ_FROM_WHITELIST_ONLY;
	g_pattern_param.adv_param.Advertising_Interval_Max[0] =  0x00a0 & 0x00ff;
    g_pattern_param.adv_param.Advertising_Interval_Max[1] = (0x00a0 & 0xff00) >> 8;
    g_pattern_param.adv_param.Advertising_Interval_Min[0] =  0x00a0 & 0x00ff;
    g_pattern_param.adv_param.Advertising_Interval_Min[1] = (0x00a0 & 0xff00) >> 8;
	if(37 == adv_Channel) {
        g_pattern_param.adv_param.Advertising_Channel_Map[0] = HCI_CMD_PARAM_ENABLE_CHANNEL_37;
    }
    else if(38 == adv_Channel) {
        g_pattern_param.adv_param.Advertising_Channel_Map[0] = HCI_CMD_PARAM_ENABLE_CHANNEL_38;
    }
    else {
        g_pattern_param.adv_param.Advertising_Channel_Map[0] = HCI_CMD_PARAM_ENABLE_CHANNEL_39;
    }
	verdict = COMM_ADV_Directed_Advertising(dut2_fd, g_pattern_param);
	VERDICT_RESULT_WITH_LINE();

	COMM_INI_Initiating_Config(dut1, &g_pattern_param);
    g_pattern_param.create_conn_param.Initiator_Filter_Policy[0] = HCI_CMD_PARAM_FILTER_POLICY_WHITE_LIST_USED;
	bt_hci_cmd_le_create_connection.parameter_tbl[2].value  =  g_pattern_param.create_conn_param.Initiator_Filter_Policy;
    memcpy(g_pattern_param.create_conn_param.Peer_Address, zero_addr, ADDR_LENGTH);
    bt_hci_cmd_le_create_connection.parameter_tbl[4].value  = g_pattern_param.create_conn_param.Peer_Address;
	verdict = COMM_INI_Initiating(dut1_fd, g_pattern_param);
	VERDICT_RESULT_WITH_LINE();

    event_query_timer_config(5, 0, 0, 0, &timer);
    event_query_timer_start(timer, read_le_event_enable);
    //waiting adv report event , timer or counter
    while(1) {
        if( 1 == read_le_event_get() ) {
            read_le_event_disable();
            if (SUCCESS != QUERY_LE_Event(dut2_fd, buf, _BT_HCI_LE_EVENT_SUB_OP_CONNECTION_COMPLETE_, 0)) {
                line = __LINE__;
                goto FUN_FAIL;
            }

            if(SUCCESS != hci_le_event_connection_complete_parsing(0, buf, g_pattern_param)) {
                line = __LINE__;
                goto FUN_FAIL;
            }

            if (SUCCESS != QUERY_LE_Event(dut1_fd, buf, _BT_HCI_LE_EVENT_SUB_OP_CONNECTION_COMPLETE_, 0)) {
                line = __LINE__;
                goto FUN_FAIL;
            }

            if(SUCCESS != hci_le_event_connection_complete_parsing(0, buf, g_pattern_param)) {
                line = __LINE__;
                goto FUN_FAIL;
            }

			conn_handles_mas[0] = buf[_BT_HCI_EVT_CON_COMP_CONN_HANDLE+0];
			conn_handles_mas[1] = buf[_BT_HCI_EVT_CON_COMP_CONN_HANDLE+1];

            break;
        }
    }

    sleep(6);

    if(SUCCESS != QUERY_Event(dut1_fd, buf, _BT_HCI_EVENT_OP_DISCONNECTION_COMPLETE_)) {
        line = __LINE__;
        goto FUN_FAIL;
    }
    else if(SUCCESS != hci_event_disconnection_complete_parsing(0, buf, g_pattern_param)) {
        line = __LINE__;
        goto FUN_FAIL;
    }
    if( 0 != buf[_BT_HCI_EVT_DISCONN_COMP_REASON]) {
        line = __LINE__;
        goto FUN_FAIL;
    }


    if(SUCCESS != QUERY_Event(dut2_fd, buf, _BT_HCI_EVENT_OP_DISCONNECTION_COMPLETE_)) {
        line = __LINE__;
        goto FUN_FAIL;
    }
    else if(SUCCESS != hci_event_disconnection_complete_parsing(0, buf, g_pattern_param)) {
        line = __LINE__;
        goto FUN_FAIL;
    }
    if( 0 != buf[_BT_HCI_EVT_DISCONN_COMP_REASON]) {
        line = __LINE__;
        goto FUN_FAIL;
    }


    // # Slave Connection Terminated
    // use connect handle to disconnect
    buf[_BT_HCI_EVT_CON_COMP_CONN_HANDLE+0] = conn_handles_mas[0];
    buf[_BT_HCI_EVT_CON_COMP_CONN_HANDLE+1] = conn_handles_mas[1];

    COMM_Disconnect_Config(dut1, &g_pattern_param,buf);
    verdict = COMM_Disconnect(dut1_fd, g_pattern_param);
    VERDICT_RESULT_WITH_LINE();

    sleep(5);

    dut_reset_with_mask_en(dut1_fd);
    dut_reset_with_mask_en(dut2_fd);

    MSLEEP(500);

#if 0
    if(adv_Channel != 39){
        adv_Channel ++;
        goto REPEAT;
    }
#endif
    FUNC_END();

    LOG_INFO("[Pattern][%s]SUCCESS\n" ,__FUNCTION__);
    return 0;

FUN_FAIL:
    FUNC_END();

    LOG_INFO("[Pattern][%s]:%d FAIL : ch %d \n" ,__FUNCTION__,line ,adv_Channel);
    return 0;



}
// 5.3.3.1
verdict CON_SLA_Slave_Asymmetric_Connections (u8 dut1_fd ,u8 dut2_fd)
{
    u8 buf[SOCKET_BUF_SIZE];
    int verdict = FAIL;
    int dut1 = 0;
    int dut2 = 0;
    u16 line = 0;
    struct itimerval timer;
    u8 conn_handles_mas[2];
    u8 acl_data[1] = {0xFF};
    u8 test_cnt1 = 0;

    int sla_pkt_chk = 0 ;

    int adv_Channel = 37;

    COMM_Dut_clean_buffer(dut1_fd);
    COMM_Dut_clean_buffer(dut2_fd);

    Calculate_Execution_Time_Start();
    
    // Uptest(white list) config
    COMM_INI_Connection_Setup_White_Listed_Config(dut2, &g_pattern_param);
    memcpy(g_pattern_param.white_list_param.Address, scan_addr, ADDR_LENGTH);
    g_pattern_param.white_list_param.Address_Type[0] = HCI_CMD_PARAM_PUBLIC_DEVICE_ADDRESS;
    verdict = COMM_INI_Connection_Setup_White_Listed(dut2_fd, g_pattern_param);
    VERDICT_RESULT_WITH_LINE();

    COMM_ADV_Directed_Advertising_Config(HCI_CMD_PARAM_ADV_DATA_LEN_MAX, &g_pattern_param);
    g_pattern_param.adv_param.Advertising_Filter_Policy[0] = HCI_CMD_PARAM_ALLOW_SCAN_REQ_FROM_WHITELIST_ONLY_AND_CONN_REQ_FROM_WHITELIST_ONLY;
    g_pattern_param.adv_param.Advertising_Interval_Max[0] =  0x00a0 & 0x00ff;
    g_pattern_param.adv_param.Advertising_Interval_Max[1] = (0x00a0 & 0xff00) >> 8;
    g_pattern_param.adv_param.Advertising_Interval_Min[0] =  0x00a0 & 0x00ff;
    g_pattern_param.adv_param.Advertising_Interval_Min[1] = (0x00a0 & 0xff00) >> 8; 
    if(37 == adv_Channel) {
        g_pattern_param.adv_param.Advertising_Channel_Map[0] = HCI_CMD_PARAM_ENABLE_CHANNEL_37;
    } 

    verdict = COMM_ADV_Directed_Advertising(dut2_fd, g_pattern_param);
    VERDICT_RESULT_WITH_LINE();

    COMM_INI_Initiating_Config(dut1, &g_pattern_param);
	g_pattern_param.create_conn_param.Conn_Latency[0]		= 5 ;
	g_pattern_param.create_conn_param.Conn_Latency[1]		= 0 ;
	//The Supervision_Timeout in milliseconds shall be larger than the Conn_Interval_Max in milliseconds.
	//superviision TO > (1+connSlaveLatency)*Conninterval
	g_pattern_param.create_conn_param.Supervision_Timeout[0] 	=0x14 ; // 20 * 10ms
	g_pattern_param.create_conn_param.Supervision_Timeout[1] 	=0x00 ; //

    memcpy(g_pattern_param.create_conn_param.Peer_Address, adv_addr, ADDR_LENGTH );
    verdict = COMM_INI_Initiating(dut1_fd, g_pattern_param);
    VERDICT_RESULT_WITH_LINE();

    verdict=COMM_Read_LE_Buffer_Size(dut2_fd,&g_pattern_param);
    VERDICT_RESULT_WITH_LINE();

    event_query_timer_config(3, 0, 0, 0, &timer);
    event_query_timer_start(timer, read_le_event_enable);

    while(1)//waiting adv report event , timer or counter
    {
        if(1 == read_le_event_get())
        {
            read_le_event_disable();

            if(SUCCESS != QUERY_LE_Event(dut1_fd, buf, _BT_HCI_LE_EVENT_SUB_OP_CONNECTION_COMPLETE_, 0)) {
                line = __LINE__;
                goto FUN_FAIL;
            }
            if(SUCCESS != hci_le_event_connection_complete_parsing(0, buf, g_pattern_param)) {
                line = __LINE__;
                goto FUN_FAIL;
            }

            conn_handles_mas[0] = buf[_BT_HCI_EVT_CON_COMP_CONN_HANDLE+0];
            conn_handles_mas[1] = buf[_BT_HCI_EVT_CON_COMP_CONN_HANDLE+1];          


            if (SUCCESS != QUERY_LE_Event(dut2_fd, buf, _BT_HCI_LE_EVENT_SUB_OP_CONNECTION_COMPLETE_, 0)) {
                line = __LINE__;
                goto FUN_FAIL;
            }
            if(SUCCESS != hci_le_event_connection_complete_parsing(0, buf, g_pattern_param)) {
                line = __LINE__;
                goto FUN_FAIL;
            }
            
            //######################################
            //Master to Slave
            while (test_cnt1 < 30) {

                printf("channel : %d, ACL_Data = 0xFF, Test_Cnt = %d\n", adv_Channel, test_cnt1);

                COMM_Send_ACL_Data_Without_event(dut1_fd, conn_handles_mas, 0b00, 0, 1, acl_data);                
PKT_CHK:
                // # check disconnection             
                CHECK_NON_DISCONNECT();
                
                if(SUCCESS != QUERY_Event(dut1_fd, buf, _BT_HCI_EVENT_OP_NUMBER_OF_COMPLETED_PACKETS_)) {
                    line = __LINE__;
                    goto FUN_FAIL;
                }
                else if(1 != hci_event_num_of_completed_packets_parsing(buf)) {
                    
                    MSLEEP(100);
                    sla_pkt_chk ++ ;
                    if (sla_pkt_chk == 100){
                        printf("sla no number of completed pkts\n");
                        line = __LINE__;
                        goto FUN_FAIL;                  
                    }
                    goto PKT_CHK;

                }                 

                sla_pkt_chk = 0;
                
                MSLEEP(300);
            
                if (SUCCESS != QUERY_Acl_Data(dut2_fd,buf)) {

                    line = __LINE__;
                    goto FUN_FAIL;
                }

                if (0x02 != (buf[_BT_HCI_IDX_ACL_DATA_CONN_HANDLE_+1] & 0xF0) >> 4) {
                    line = __LINE__;
                    goto FUN_FAIL;
                }

                // # need add api to check acl_data
                if (0xFF != (buf [_BT_HCI_IDX_ACL_DATA_PAYLOAD_]))
                {
                    line=__LINE__;
                    goto FUN_FAIL;
                }


                test_cnt1 ++ ;
             }

			buf[_BT_HCI_EVT_CON_COMP_CONN_HANDLE+0] = conn_handles_mas[0];
			buf[_BT_HCI_EVT_CON_COMP_CONN_HANDLE+1] = conn_handles_mas[1];
			
			COMM_Disconnect_Config(dut1,&g_pattern_param,buf);
			verdict=COMM_Disconnect(dut1_fd,g_pattern_param);
			VERDICT_RESULT_WITH_LINE();

            FUNC_END();


            LOG_INFO("[Pattern][%s]SUCCESS\n", __FUNCTION__);
            return PASS;
        }
    }

FUN_FAIL:

    FUNC_END();

    
    LOG_INFO("[Pattern][%s]:%d channel : %d FAIL!!\n" , __FUNCTION__, line, adv_Channel);
    return FAIL;
}


// 5.3.3.2
verdict CON_SLA_Slave_Sending_Data (u8 dut1_fd ,u8 dut2_fd)
{
	u8 buf[SOCKET_BUF_SIZE];
	int verdict = FAIL;
	int dut1 = 0;
	int dut2 = 0;
	u16 line = 0;
	struct itimerval timer;
	u8 conn_handles_mas[2];
	u8 conn_handles_sla[2];
	u8 acl_data[10] = {0};
	u8 acl_data2[32] = {0};
	u8 test_Times = 100;
	u8 test_cnt1 = 0;
	u8 test_cnt2 = 0;
	u8 test_cnt3 = 0;
    int adv_Channel = 37;
    int acl_init_cnt = 0 ;

    int sla_pkt_chk = 0 ;


    COMM_Dut_clean_buffer(dut1_fd);
    COMM_Dut_clean_buffer(dut2_fd);

    Calculate_Execution_Time_Start();

    // # init acl data with 1
    for ( ; acl_init_cnt < 32 ; acl_init_cnt ++){
        acl_data2[acl_init_cnt] = 1;
    }
        
	test_cnt1 = test_Times;
	test_cnt2 = test_Times;
	test_cnt3 = test_Times;
	
    // Uptest(white list) config
	COMM_INI_Connection_Setup_White_Listed_Config(dut2, &g_pattern_param);
    memcpy(g_pattern_param.white_list_param.Address, scan_addr, ADDR_LENGTH);
    g_pattern_param.white_list_param.Address_Type[0] = HCI_CMD_PARAM_PUBLIC_DEVICE_ADDRESS;
    verdict = COMM_INI_Connection_Setup_White_Listed(dut2_fd, g_pattern_param);
    VERDICT_RESULT_WITH_LINE();

	COMM_ADV_Directed_Advertising_Config(HCI_CMD_PARAM_ADV_DATA_LEN_MAX, &g_pattern_param);
	g_pattern_param.adv_param.Advertising_Filter_Policy[0] = HCI_CMD_PARAM_ALLOW_SCAN_REQ_FROM_WHITELIST_ONLY_AND_CONN_REQ_FROM_WHITELIST_ONLY;
	g_pattern_param.adv_param.Advertising_Interval_Max[0] =  0x00a0 & 0x00ff;
    g_pattern_param.adv_param.Advertising_Interval_Max[1] = (0x00a0 & 0xff00) >> 8;
    g_pattern_param.adv_param.Advertising_Interval_Min[0] =  0x00a0 & 0x00ff;
    g_pattern_param.adv_param.Advertising_Interval_Min[1] = (0x00a0 & 0xff00) >> 8;	
	if(37 == adv_Channel) {
        g_pattern_param.adv_param.Advertising_Channel_Map[0] = HCI_CMD_PARAM_ENABLE_CHANNEL_37;
    }
	verdict = COMM_ADV_Directed_Advertising(dut2_fd, g_pattern_param);
	VERDICT_RESULT_WITH_LINE();

	COMM_INI_Initiating_Config(dut1, &g_pattern_param);
	memcpy(g_pattern_param.create_conn_param.Peer_Address, adv_addr, ADDR_LENGTH );
	verdict = COMM_INI_Initiating(dut1_fd, g_pattern_param);
	VERDICT_RESULT_WITH_LINE();

	event_query_timer_config(5, 0, 0, 0, &timer);
	event_query_timer_start(timer, read_le_event_enable);

	while(1)//waiting adv report event , timer or counter
	{
		if(1 == read_le_event_get())
		{
            read_le_event_disable();


			if(SUCCESS != QUERY_LE_Event(dut1_fd, buf, _BT_HCI_LE_EVENT_SUB_OP_CONNECTION_COMPLETE_, 0)) {
				line = __LINE__;
				goto FUN_FAIL;
			}
			if(SUCCESS != hci_le_event_connection_complete_parsing(0, buf, g_pattern_param)) {
				line = __LINE__;
				goto FUN_FAIL;
			}

			conn_handles_mas[0] = buf[_BT_HCI_EVT_CON_COMP_CONN_HANDLE+0];
			conn_handles_mas[1] = buf[_BT_HCI_EVT_CON_COMP_CONN_HANDLE+1];	

			if (SUCCESS != QUERY_LE_Event(dut2_fd, buf,	_BT_HCI_LE_EVENT_SUB_OP_CONNECTION_COMPLETE_, 0)) {
				line = __LINE__;
				goto FUN_FAIL;
			}
			if(SUCCESS != hci_le_event_connection_complete_parsing(0, buf, g_pattern_param)) {
				line = __LINE__;
				goto FUN_FAIL;
			}

			conn_handles_sla[0] = buf[_BT_HCI_EVT_CON_COMP_CONN_HANDLE+0];
			conn_handles_sla[1] = buf[_BT_HCI_EVT_CON_COMP_CONN_HANDLE+1];	
			
			//######################################
			// # case 1 : LLID 2 , data 0
			for ( ;test_cnt1 > 0; test_cnt1--) {
				COMM_Send_ACL_Data_Without_event(dut2_fd, conn_handles_sla, 0b00, 0, 10, acl_data);
PKT_CHK1:
                // # check disconnection             
                CHECK_NON_DISCONNECT();

                if(SUCCESS != QUERY_Event(dut2_fd, buf, _BT_HCI_EVENT_OP_NUMBER_OF_COMPLETED_PACKETS_)) {
                    line = __LINE__;
                    goto FUN_FAIL;
                }
                else if(1 != hci_event_num_of_completed_packets_parsing(buf)) {

                    MSLEEP(100);
                    sla_pkt_chk ++ ;
                    if (sla_pkt_chk == 100){
                        printf("sla no number of completed pkts\n");
                        line = __LINE__;
                        goto FUN_FAIL;                  
                    }
                    goto PKT_CHK1;
                
                }                 
                
                sla_pkt_chk = 0;

				printf("\ncase 1, ACL_Data = 0b00, Test_Cnt = %d\n", test_cnt1);

                usleep(SLEEP_MS);
                //step2 ~ 4
    			if (SUCCESS != QUERY_Acl_Data(dut1_fd,buf)) {
    				line = __LINE__;
    				goto FUN_FAIL;
    			}

    			if (0x02 != (buf[_BT_HCI_IDX_ACL_DATA_CONN_HANDLE_+1] & 0xF0) >> 4) {
    				line = __LINE__;
    				goto FUN_FAIL;
    			}

                if (0 != memcmp(buf+_BT_HCI_IDX_ACL_DATA_PAYLOAD_ , acl_data ,
                    buf[_BT_HCI_IDX_ACL_DATA_LENGTH_]))
                {
                    line=__LINE__;
                    goto FUN_FAIL;
                }

			}
            

			//######################################
			// # case 2 : LLID 1 , data 0
			
			for ( ;test_cnt2 > 0; test_cnt2--) {
				COMM_Send_ACL_Data_Without_event(dut2_fd, conn_handles_sla, 0b01, 0, 10, acl_data);
PKT_CHK2:
                // # check disconnection                             
                CHECK_NON_DISCONNECT();

                if(SUCCESS != QUERY_Event(dut2_fd, buf, _BT_HCI_EVENT_OP_NUMBER_OF_COMPLETED_PACKETS_)) {
                    line = __LINE__;
                    goto FUN_FAIL;
                }
                else if(1 != hci_event_num_of_completed_packets_parsing(buf)) {

                    MSLEEP(100);
                    sla_pkt_chk ++ ;
                    if (sla_pkt_chk == 100){
                        printf("sla no number of completed pkts\n");
                        line = __LINE__;
                        goto FUN_FAIL;                  
                    }
                    goto PKT_CHK2;
                
                }                 
                
                sla_pkt_chk = 0;


				printf("\ncase 2, ACL_Data = 0b01, Test_Cnt = %d\n", test_cnt2);

                usleep(SLEEP_MS);

    			if (SUCCESS != QUERY_Acl_Data(dut1_fd,buf))	{
    				line = __LINE__;
    				goto FUN_FAIL;
    			}

    			if (0x01 != (buf[_BT_HCI_IDX_ACL_DATA_CONN_HANDLE_+1] & 0xF0) >> 4) {
    				line = __LINE__;
    				goto FUN_FAIL;
    			}

                if (0 != memcmp(buf+_BT_HCI_IDX_ACL_DATA_PAYLOAD_ , acl_data ,
                    buf[_BT_HCI_IDX_ACL_DATA_LENGTH_]))
                {
                    line=__LINE__;
                    goto FUN_FAIL;
                }

                
            }
			//######################################

			// # case 3 : LLID 2 , data 1
            
			for ( ;test_cnt3 > 0; test_cnt3--)	{
				COMM_Send_ACL_Data_Without_event(dut2_fd, conn_handles_sla, 0b01, 0, 10, acl_data2);
PKT_CHK3:
                // # check disconnection             
                CHECK_NON_DISCONNECT();

                if(SUCCESS != QUERY_Event(dut2_fd, buf, _BT_HCI_EVENT_OP_NUMBER_OF_COMPLETED_PACKETS_)) {
                    line = __LINE__;
                    goto FUN_FAIL;
                }
                else if(1 != hci_event_num_of_completed_packets_parsing(buf)) {

                    MSLEEP(100);
                    sla_pkt_chk ++ ;
                    if (sla_pkt_chk == 100){
                        printf("sla no number of completed pkts\n");
                        line = __LINE__;
                        goto FUN_FAIL;                  
                    }
                    goto PKT_CHK3;
                
                }                 
                
                sla_pkt_chk = 0;

				printf("\ncase 3 , ACL_Data = 0b01, Test_Cnt = %d\n", test_cnt3);

                usleep(SLEEP_MS);

    			if (SUCCESS != QUERY_Acl_Data(dut1_fd, buf)) {
    				line = __LINE__;
    				goto FUN_FAIL;
    			}

    			if (0x01 != (buf[_BT_HCI_IDX_ACL_DATA_CONN_HANDLE_+1] & 0xF0) >> 4) {
    				line = __LINE__;
    				goto FUN_FAIL;
    			}

                if (0 != memcmp(buf+_BT_HCI_IDX_ACL_DATA_PAYLOAD_ , acl_data2 ,
                    buf[_BT_HCI_IDX_ACL_DATA_LENGTH_]))
                {
                    line=__LINE__;
                    goto FUN_FAIL;
                }
                
            }
                

			buf[_BT_HCI_EVT_CON_COMP_CONN_HANDLE+0] = conn_handles_mas[0];
			buf[_BT_HCI_EVT_CON_COMP_CONN_HANDLE+1] = conn_handles_mas[1];
			
			COMM_Disconnect_Config(dut1,&g_pattern_param,buf);
			verdict=COMM_Disconnect(dut1_fd,g_pattern_param);
			VERDICT_RESULT_WITH_LINE();


            FUNC_END();

			LOG_INFO("[Pattern][%s]SUCCESS\n", __FUNCTION__);
			return PASS;
		}
	}

FUN_FAIL:
    FUNC_END();

	LOG_INFO("[Pattern][%s]:%d FAIL!!\n" , __FUNCTION__, line);
	return FAIL;
}


// 5.3.3.3
verdict CON_SLA_Slave_Receiving_Data(u8 dut1_fd ,u8 dut2_fd)
{
	u8 buf[SOCKET_BUF_SIZE];
	int verdict = FAIL;
	int dut1 = 0;
    int dut2 = 0;
	u16 line = 0;
	struct itimerval timer;

	u8 conn_handles_mas[2];
	u8 acl_data[10] = {0};
	u8 test_Times = 100;
	u8 test_cnt1 = 0;
	u8 test_cnt2 = 0;
	u8 test_cnt3 = 0;	
    int adv_Channel = 37;

    int sla_pkt_chk = 0 ;

    COMM_Dut_clean_buffer(dut1_fd);
    COMM_Dut_clean_buffer(dut2_fd);

    Calculate_Execution_Time_Start();
    test_cnt1 = test_Times;
	test_cnt2 = test_Times;
	test_cnt3 = test_Times;
    
    COMM_INI_Connection_Setup_White_Listed_Config(dut2, &g_pattern_param);
    memcpy(g_pattern_param.white_list_param.Address, scan_addr, ADDR_LENGTH);
    g_pattern_param.white_list_param.Address_Type[0] = HCI_CMD_PARAM_PUBLIC_DEVICE_ADDRESS;
    verdict = COMM_INI_Connection_Setup_White_Listed(dut2_fd, g_pattern_param);
    VERDICT_RESULT_WITH_LINE();

	COMM_ADV_Directed_Advertising_Config(HCI_CMD_PARAM_ADV_DATA_LEN_MAX,&g_pattern_param);
    g_pattern_param.adv_param.Advertising_Filter_Policy[0] = HCI_CMD_PARAM_ALLOW_SCAN_REQ_FROM_WHITELIST_ONLY_AND_CONN_REQ_FROM_WHITELIST_ONLY;
	g_pattern_param.adv_param.Advertising_Interval_Max[0] =  0x00a0 & 0x00ff;
    g_pattern_param.adv_param.Advertising_Interval_Max[1] = (0x00a0 & 0xff00) >> 8;
    g_pattern_param.adv_param.Advertising_Interval_Min[0] =  0x00a0 & 0x00ff;
    g_pattern_param.adv_param.Advertising_Interval_Min[1] = (0x00a0 & 0xff00) >> 8;	
	if(37 == adv_Channel) {
        g_pattern_param.adv_param.Advertising_Channel_Map[0] = HCI_CMD_PARAM_ENABLE_CHANNEL_37;
    }
  
	verdict = COMM_ADV_Directed_Advertising(dut2_fd,g_pattern_param);    
	VERDICT_RESULT_WITH_LINE();

	COMM_INI_Initiating_Config(dut1,&g_pattern_param);
    memcpy(g_pattern_param.create_conn_param.Peer_Address, adv_addr, ADDR_LENGTH );
	verdict=COMM_INI_Initiating(dut1_fd,g_pattern_param);
	VERDICT_RESULT_WITH_LINE();

	event_query_timer_config(5 , 0 , 0 , 0, &timer);
	event_query_timer_start(timer ,read_le_event_enable );

	while(1)//waiting adv report event , timer or counter
	{
		if ( 1 == read_le_event_get() )
		{
            read_le_event_disable();

            if (SUCCESS != QUERY_LE_Event(dut1_fd, buf, _BT_HCI_LE_EVENT_SUB_OP_CONNECTION_COMPLETE_, 0)) {
			    line = __LINE__;
			    goto FUN_FAIL;
			}
			else if(SUCCESS != hci_le_event_connection_complete_parsing(0, buf, g_pattern_param)) {
			    line = __LINE__;
			    goto FUN_FAIL;
			}

			conn_handles_mas[0] = buf[_BT_HCI_EVT_CON_COMP_CONN_HANDLE+0];
			conn_handles_mas[1] = buf[_BT_HCI_EVT_CON_COMP_CONN_HANDLE+1];


            if (SUCCESS != QUERY_LE_Event(dut2_fd, buf, _BT_HCI_LE_EVENT_SUB_OP_CONNECTION_COMPLETE_, 0)) {
			    line = __LINE__;
			    goto FUN_FAIL;
			}
			else if(SUCCESS != hci_le_event_connection_complete_parsing(0, buf, g_pattern_param)) {
			    line = __LINE__;
			    goto FUN_FAIL;
			}
			
            
            //######################################
            // # case 1 : LLID =2 ; data = 0
			for ( ;test_cnt1 > 0; test_cnt1--) {
				COMM_Send_ACL_Data_Without_event(dut1_fd, conn_handles_mas, 0b00, 0, 10, acl_data);
PKT_CHK1:
                // # check disconnection             
                CHECK_NON_DISCONNECT();

                if(SUCCESS != QUERY_Event(dut1_fd, buf, _BT_HCI_EVENT_OP_NUMBER_OF_COMPLETED_PACKETS_)) {
                    line = __LINE__;
                    goto FUN_FAIL;
                }
                else if(1 != hci_event_num_of_completed_packets_parsing(buf)) {

                    MSLEEP(100);
                    sla_pkt_chk ++ ;
                    if (sla_pkt_chk == 100){
                        printf("sla no number of completed pkts\n");
                        line = __LINE__;
                        goto FUN_FAIL;                  
                    }
                    goto PKT_CHK1;
                
                }                 
                
                sla_pkt_chk = 0;

                
                printf("\ncase 1 , ACL_Data = 0b00, Test_Cnt = %d\n", test_cnt1);

                usleep(SLEEP_MS);
            
                //step2 ~ 4
    			if (SUCCESS != QUERY_Acl_Data(dut2_fd,buf))	{
    				line = __LINE__;
    				goto FUN_FAIL;
    			}

    			if (0x02 != (buf[_BT_HCI_IDX_ACL_DATA_CONN_HANDLE_+1] & 0xF0 ) >> 4) {
    				line = __LINE__;
    				goto FUN_FAIL;
    			}

                if (0 != memcmp(buf+_BT_HCI_IDX_ACL_DATA_PAYLOAD_ , acl_data ,
                    buf[_BT_HCI_IDX_ACL_DATA_LENGTH_]))
                {
                    line=__LINE__;
                    goto FUN_FAIL;
                }

            }
            
            //######################################
            //step5
            // # case 2 : LLID =1 ; data = 0

			for ( ;test_cnt2 > 0; test_cnt2--) {
				COMM_Send_ACL_Data_Without_event(dut1_fd, conn_handles_mas, 0b01, 0, 10, acl_data);
PKT_CHK2:
                // # check disconnection             
                CHECK_NON_DISCONNECT();

                if(SUCCESS != QUERY_Event(dut1_fd, buf, _BT_HCI_EVENT_OP_NUMBER_OF_COMPLETED_PACKETS_)) {
                    line = __LINE__;
                    goto FUN_FAIL;
                }
                else if(1 != hci_event_num_of_completed_packets_parsing(buf)) {

                    MSLEEP(100);
                    sla_pkt_chk ++ ;
                    if (sla_pkt_chk == 100){
                        printf("sla no number of completed pkts\n");
                        line = __LINE__;
                        goto FUN_FAIL;                  
                    }
                    goto PKT_CHK2;
                
                }                 
                
                sla_pkt_chk = 0;

                
                printf("\ncase 2, ACL_Data = 0b01, Test_Cnt = %d\n", test_cnt2);

                usleep(SLEEP_MS);

                //step7
    			if (SUCCESS != QUERY_Acl_Data(dut2_fd, buf)) {
    				line = __LINE__;
    				goto FUN_FAIL;
    			}

    			if (0x01 != (buf[_BT_HCI_IDX_ACL_DATA_CONN_HANDLE_+1] & 0xF0) >> 4) {
    				line = __LINE__;
    				goto FUN_FAIL;
    			}

                if (0 != memcmp(buf+_BT_HCI_IDX_ACL_DATA_PAYLOAD_ , acl_data ,
                    buf[_BT_HCI_IDX_ACL_DATA_LENGTH_]))
                {
                    line=__LINE__;
                    goto FUN_FAIL;
                }
                
            }

            //######################################
            //step8
            // # case 3 : first  LLID =2 ; data = 0 x 1
            //            second LLID =1 ; data = 0 x 999

            COMM_Send_ACL_Data_Without_event(dut1_fd, conn_handles_mas, 0b01, 0, 10, acl_data);
PKT_CHK3:
            // # check disconnection             
            CHECK_NON_DISCONNECT();

            if(SUCCESS != QUERY_Event(dut1_fd, buf, _BT_HCI_EVENT_OP_NUMBER_OF_COMPLETED_PACKETS_)) {
                line = __LINE__;
                goto FUN_FAIL;
            }
            else if(1 != hci_event_num_of_completed_packets_parsing(buf)) {

                MSLEEP(100);
                sla_pkt_chk ++ ;
                if (sla_pkt_chk == 100){
                    printf("sla no number of completed pkts\n");
                    line = __LINE__;
                    goto FUN_FAIL;                  
                }
                goto PKT_CHK3;
            
            }                 
            
            sla_pkt_chk = 0;

            
            printf("\ncase 3, ACL_Data = 0b01, Test_Cnt = %d\n", test_cnt3);
            
            usleep(SLEEP_MS);
            
            //step7
            if (SUCCESS != QUERY_Acl_Data(dut2_fd, buf)) {
                line = __LINE__;
                goto FUN_FAIL;
            }
            
            if (0x01 != (buf[_BT_HCI_IDX_ACL_DATA_CONN_HANDLE_+1] & 0xF0) >> 4) {
                line = __LINE__;
                goto FUN_FAIL;
            }
            
            if (0 != memcmp(buf+_BT_HCI_IDX_ACL_DATA_PAYLOAD_ , acl_data ,
                buf[_BT_HCI_IDX_ACL_DATA_LENGTH_]))
            {
                line=__LINE__;
                goto FUN_FAIL;
            }


			for ( ;test_cnt3 > 0; test_cnt3--) {
				COMM_Send_ACL_Data_Without_event(dut1_fd, conn_handles_mas, 0b01, 0, 10, acl_data);
PKT_CHK4:
                // # check disconnection             
                CHECK_NON_DISCONNECT();

                if(SUCCESS != QUERY_Event(dut1_fd, buf, _BT_HCI_EVENT_OP_NUMBER_OF_COMPLETED_PACKETS_)) {
                    line = __LINE__;
                    goto FUN_FAIL;
                }
                else if(1 != hci_event_num_of_completed_packets_parsing(buf)) {
                    MSLEEP(100);
                    sla_pkt_chk ++ ;
                    if (sla_pkt_chk == 100){
                        printf("sla no number of completed pkts\n");
                        line = __LINE__;
                        goto FUN_FAIL;                  
                    }
                    goto PKT_CHK4;
                
                }                 
                
                sla_pkt_chk = 0;

                
                printf("\ncase 4, ACL_Data = 0b01, Test_Cnt = %d\n", test_cnt3);

                usleep(SLEEP_MS);

                //step7
    			if (SUCCESS != QUERY_Acl_Data(dut2_fd, buf)) {
    				line = __LINE__;
    				goto FUN_FAIL;
    			}

    			if (0x01 != (buf[_BT_HCI_IDX_ACL_DATA_CONN_HANDLE_+1] & 0xF0) >> 4) {
    				line = __LINE__;
    				goto FUN_FAIL;
    			}

                if (0 != memcmp(buf+_BT_HCI_IDX_ACL_DATA_PAYLOAD_ , acl_data ,
                    buf[_BT_HCI_IDX_ACL_DATA_LENGTH_]))
                {
                    line=__LINE__;
                    goto FUN_FAIL;
                }
                
            }

			buf[_BT_HCI_EVT_CON_COMP_CONN_HANDLE+0] = conn_handles_mas[0];
			buf[_BT_HCI_EVT_CON_COMP_CONN_HANDLE+1] = conn_handles_mas[1];
			
			COMM_Disconnect_Config(dut1,&g_pattern_param,buf);
			verdict=COMM_Disconnect(dut1_fd,g_pattern_param);
			VERDICT_RESULT_WITH_LINE();


            FUNC_END();

			LOG_INFO("[Pattern][%s]SUCCESS\n" ,__FUNCTION__);
			return PASS;
		}
	}

FUN_FAIL:
    FUNC_END();

	LOG_INFO("[Pattern][%s]:%d  FAIL!!\n", __FUNCTION__, line);
	return FAIL;

}

// 5.3.3.4
verdict CON_SLA_Slave_Sending_and_Receiving_Data(u8 dut1_fd ,u8 dut2_fd)
{
	u8 buf[SOCKET_BUF_SIZE];
	int verdict = FAIL;
	int dut1 = 0;
    int dut2 = 0;
	u16 line = 0;
	struct itimerval timer;
	u8 conn_handles_sla[2];
	u8 conn_handles_mas[2];
	u8 acl_data[10] = {0};
    u8 test_Times = 100;
	u8 test_cnt1 = 0;
    int adv_Channel = 37;

    int sla_pkt_chk = 0 ;

    COMM_Dut_clean_buffer(dut1_fd);
    COMM_Dut_clean_buffer(dut2_fd);

    Calculate_Execution_Time_Start();

    test_cnt1 = test_Times;

    // Uptest(white list) config
	COMM_INI_Connection_Setup_White_Listed_Config(dut2, &g_pattern_param);
    memcpy(g_pattern_param.white_list_param.Address, scan_addr, ADDR_LENGTH);
    g_pattern_param.white_list_param.Address_Type[0] = HCI_CMD_PARAM_PUBLIC_DEVICE_ADDRESS;
    verdict = COMM_INI_Connection_Setup_White_Listed(dut2_fd, g_pattern_param);
    VERDICT_RESULT_WITH_LINE();

	COMM_ADV_Directed_Advertising_Config(HCI_CMD_PARAM_ADV_DATA_LEN_MAX, &g_pattern_param);
    g_pattern_param.adv_param.Advertising_Filter_Policy[0] = HCI_CMD_PARAM_ALLOW_SCAN_REQ_FROM_WHITELIST_ONLY_AND_CONN_REQ_FROM_WHITELIST_ONLY;
	g_pattern_param.adv_param.Advertising_Interval_Max[0] =  0x00a0 & 0x00ff;
    g_pattern_param.adv_param.Advertising_Interval_Max[1] = (0x00a0 & 0xff00) >> 8;
    g_pattern_param.adv_param.Advertising_Interval_Min[0] =  0x00a0 & 0x00ff;
    g_pattern_param.adv_param.Advertising_Interval_Min[1] = (0x00a0 & 0xff00) >> 8;
	if(37 == adv_Channel) {
        g_pattern_param.adv_param.Advertising_Channel_Map[0] = HCI_CMD_PARAM_ENABLE_CHANNEL_37;
    }
  
	verdict = COMM_ADV_Directed_Advertising(dut2_fd, g_pattern_param);
	VERDICT_RESULT_WITH_LINE();
    
	COMM_INI_Initiating_Config(dut1, &g_pattern_param);
    memcpy(g_pattern_param.create_conn_param.Peer_Address, adv_addr, ADDR_LENGTH );
	verdict = COMM_INI_Initiating(dut1_fd, g_pattern_param);
	VERDICT_RESULT_WITH_LINE();

	event_query_timer_config(5, 0, 0, 0, &timer);
	event_query_timer_start(timer, read_le_event_enable);

    //waiting adv report event , timer or counter
	while(1) {
		if(1 == read_le_event_get()) {
            read_le_event_disable();

    		if(SUCCESS != QUERY_LE_Event(dut1_fd, buf, _BT_HCI_LE_EVENT_SUB_OP_CONNECTION_COMPLETE_, 0)) {
    			line = __LINE__;
    			goto FUN_FAIL;
    		}

    		if(SUCCESS != hci_le_event_connection_complete_parsing(0, buf, g_pattern_param)) {
    			line = __LINE__;
    			goto FUN_FAIL;
    		}

    		conn_handles_mas[0] = buf[_BT_HCI_EVT_CON_COMP_CONN_HANDLE+0];
    		conn_handles_mas[1] = buf[_BT_HCI_EVT_CON_COMP_CONN_HANDLE+1];

    		if(SUCCESS != QUERY_LE_Event(dut2_fd, buf, _BT_HCI_LE_EVENT_SUB_OP_CONNECTION_COMPLETE_, 0)) {
    			line = __LINE__;
    			goto FUN_FAIL;
    		}

    		if(SUCCESS != hci_le_event_connection_complete_parsing(0, buf, g_pattern_param)) {
    			line = __LINE__;
    			goto FUN_FAIL;
    		}

    		conn_handles_sla[0] = buf[_BT_HCI_EVT_CON_COMP_CONN_HANDLE+0];
    		conn_handles_sla[1] = buf[_BT_HCI_EVT_CON_COMP_CONN_HANDLE+1];

            //######################################
    	    for( ;test_cnt1 > 0; test_cnt1--) {
    			COMM_Send_ACL_Data_Without_event(dut2_fd, conn_handles_sla, 0b00, 0, 10, acl_data);
PKT_CHK1:
                // # check disconnection             
                CHECK_NON_DISCONNECT();

                if(SUCCESS != QUERY_Event(dut2_fd, buf, _BT_HCI_EVENT_OP_NUMBER_OF_COMPLETED_PACKETS_)) {
                    line = __LINE__;
                    goto FUN_FAIL;
                }
                else if(1 != hci_event_num_of_completed_packets_parsing(buf)) {

                    MSLEEP(100);
                    sla_pkt_chk ++ ;
                    if (sla_pkt_chk == 100){
                        printf("sla no number of completed pkts\n");
                        line = __LINE__;
                        goto FUN_FAIL;                  
                    }
                    goto PKT_CHK1;
                
                }                 
                
                sla_pkt_chk = 0;



                usleep(SLEEP_MS);
    		
        		if(SUCCESS != QUERY_Acl_Data(dut1_fd, buf))	{
        			line = __LINE__;
        			goto FUN_FAIL;
        		}

        		if(0x02 != (buf[_BT_HCI_IDX_ACL_DATA_CONN_HANDLE_+1] & 0xF0 ) >> 4) {
        			line = __LINE__;
        			goto FUN_FAIL;
        		}

                if (0 != memcmp(buf+_BT_HCI_IDX_ACL_DATA_PAYLOAD_ , acl_data ,
                    buf[_BT_HCI_IDX_ACL_DATA_LENGTH_]))
                {
                    line=__LINE__;
                    goto FUN_FAIL;
                }

    			COMM_Send_ACL_Data_Without_event(dut1_fd, conn_handles_mas, 0b00, 0, 10, acl_data);
PKT_CHK2:
                // # check disconnection             
                CHECK_NON_DISCONNECT();
                
                if(SUCCESS != QUERY_Event(dut1_fd, buf, _BT_HCI_EVENT_OP_NUMBER_OF_COMPLETED_PACKETS_)) {
                    line = __LINE__;
                    goto FUN_FAIL;
                }
                else if(1 != hci_event_num_of_completed_packets_parsing(buf)) {

                    MSLEEP(100);
                    sla_pkt_chk ++ ;
                    if (sla_pkt_chk == 100){
                        printf("sla no number of completed pkts\n");
                        line = __LINE__;
                        goto FUN_FAIL;                  
                    }
                    goto PKT_CHK2;
                
                }                 
                
                sla_pkt_chk = 0;



                usleep(SLEEP_MS);

        		if(SUCCESS != QUERY_Acl_Data(dut2_fd, buf)) {
        			line = __LINE__;
        			goto FUN_FAIL;
        		}

        		if(0x02 != (buf [_BT_HCI_IDX_ACL_DATA_CONN_HANDLE_ + 1] & 0xF0 ) >> 4)	{
        			line = __LINE__;
        			goto FUN_FAIL;
        		}

                if (0 != memcmp(buf+_BT_HCI_IDX_ACL_DATA_PAYLOAD_ , acl_data ,
                    buf[_BT_HCI_IDX_ACL_DATA_LENGTH_]))
                {
                    line=__LINE__;
                    goto FUN_FAIL;
                }
            }

			buf[_BT_HCI_EVT_CON_COMP_CONN_HANDLE+0] = conn_handles_mas[0];
			buf[_BT_HCI_EVT_CON_COMP_CONN_HANDLE+1] = conn_handles_mas[1];
			
			COMM_Disconnect_Config(dut1,&g_pattern_param,buf);
			verdict=COMM_Disconnect(dut1_fd,g_pattern_param);
			VERDICT_RESULT_WITH_LINE();

            FUNC_END();
            
    		LOG_INFO("[Pattern][%s]SUCCESS\n", __FUNCTION__);
    		return PASS;
		}
	}

FUN_FAIL:
    FUNC_END();

	LOG_INFO("[Pattern][%s]:%d FAIL!!\n", __FUNCTION__, line);
	return FAIL;

}

// 5.3.3.5
verdict CON_SLA_Accepting_Parameter_Update(u8 dut1_fd ,u8 dut2_fd)
{
	u8 buf[SOCKET_BUF_SIZE];
	int verdict = FAIL;
	int dut1 = 0;
    int dut2 = 0;
	u16 line = 0;
	struct itimerval timer;
    u8 conn_handles_mas[2];
    int adv_Channel = 37;

    COMM_Dut_clean_buffer(dut1_fd);
    COMM_Dut_clean_buffer(dut2_fd);

    Calculate_Execution_Time_Start();

    // Uptest(white list) config
	COMM_INI_Connection_Setup_White_Listed_Config(dut2, &g_pattern_param);
    memcpy(g_pattern_param.white_list_param.Address, scan_addr, ADDR_LENGTH);
    g_pattern_param.white_list_param.Address_Type[0] = HCI_CMD_PARAM_PUBLIC_DEVICE_ADDRESS;
    verdict = COMM_INI_Connection_Setup_White_Listed(dut2_fd, g_pattern_param);
    VERDICT_RESULT_WITH_LINE();
#if 1
    COMM_ADV_Undirected_Advertising_Config(HCI_CMD_PARAM_ADV_DATA_LEN_MAX,&g_pattern_param);

    g_pattern_param.adv_param.Advertising_Channel_Map[0] =HCI_CMD_PARAM_ENABLE_CHANNEL_37;
    g_pattern_param.adv_param.Advertising_Filter_Policy[0] = HCI_CMD_PARAM_ALLOW_SCAN_REQ_FROM_WHITELIST_ONLY_AND_CONN_REQ_FROM_ANY;
    g_pattern_param.adv_param.Advertising_Interval_Max[0] =  HCI_CMD_PARAM_ADVERTISING_INTERVAL_MIN & 0x00ff;
    g_pattern_param.adv_param.Advertising_Interval_Max[1] = (HCI_CMD_PARAM_ADVERTISING_INTERVAL_MIN & 0xff00) >> 8;
    g_pattern_param.adv_param.Advertising_Interval_Min[0] =  HCI_CMD_PARAM_ADVERTISING_INTERVAL_MIN & 0x00ff;
    g_pattern_param.adv_param.Advertising_Interval_Min[1] = (HCI_CMD_PARAM_ADVERTISING_INTERVAL_MIN & 0xff00) >> 8;
    verdict=COMM_ADV_Undirected_Advertising(dut2_fd,g_pattern_param);
    VERDICT_RESULT_WITH_LINE();


#else
	COMM_ADV_Directed_Advertising_Config(HCI_CMD_PARAM_ADV_DATA_LEN_MAX, &g_pattern_param);
    g_pattern_param.adv_param.Advertising_Filter_Policy[0] = HCI_CMD_PARAM_ALLOW_SCAN_REQ_FROM_WHITELIST_ONLY_AND_CONN_REQ_FROM_WHITELIST_ONLY;
	g_pattern_param.adv_param.Advertising_Interval_Max[0] =  0x00a0 & 0x00ff;
    g_pattern_param.adv_param.Advertising_Interval_Max[1] = (0x00a0 & 0xff00) >> 8;
    g_pattern_param.adv_param.Advertising_Interval_Min[0] =  0x00a0 & 0x00ff;
    g_pattern_param.adv_param.Advertising_Interval_Min[1] = (0x00a0 & 0xff00) >> 8;
	if(37 == adv_Channel) {
        g_pattern_param.adv_param.Advertising_Channel_Map[0] = HCI_CMD_PARAM_ENABLE_CHANNEL_37;
    }
  
	verdict = COMM_ADV_Directed_Advertising(dut2_fd, g_pattern_param);
	VERDICT_RESULT_WITH_LINE();
#endif
	COMM_INI_Initiating_Config(dut1, &g_pattern_param);
    memcpy(g_pattern_param.create_conn_param.Peer_Address, adv_addr, ADDR_LENGTH );
	verdict = COMM_INI_Initiating(dut1_fd, g_pattern_param);
	VERDICT_RESULT_WITH_LINE();

	event_query_timer_config(10, 0, 0, 0, &timer);
	event_query_timer_start(timer, read_le_event_enable);

    //waiting adv report event , timer or counter
	while(1) {
		if(1 == read_le_event_get()) {
            read_le_event_disable();

    		if(SUCCESS != QUERY_LE_Event(dut1_fd, buf,	_BT_HCI_LE_EVENT_SUB_OP_CONNECTION_COMPLETE_, 0)) {
    			line = __LINE__;
    			goto FUN_FAIL;
    		}

    		if(SUCCESS != hci_le_event_connection_complete_parsing(0, buf, g_pattern_param)) {
    			line = __LINE__;
    			goto FUN_FAIL;
    		}

    		conn_handles_mas[0] = buf[_BT_HCI_EVT_CON_COMP_CONN_HANDLE+0];
    		conn_handles_mas[1] = buf[_BT_HCI_EVT_CON_COMP_CONN_HANDLE+1];

            printf("\n");

    		if(SUCCESS != QUERY_LE_Event(dut2_fd, buf, _BT_HCI_LE_EVENT_SUB_OP_CONNECTION_COMPLETE_, 0)) {
    			line = __LINE__;
    			goto FUN_FAIL;
    		}

    		if(SUCCESS != hci_le_event_connection_complete_parsing(0, buf, g_pattern_param)) {
    			line = __LINE__;
    			goto FUN_FAIL;
    		}

            //######################################

            //# case 1 min conn interval ; max event count
            COMM_Conn_Update_Set_Config(dut1 , &g_pattern_param , conn_handles_mas);
            g_pattern_param.conn_update_param.Conn_Interval_Min[0]       = HCI_CMD_PARAM_CONN_INT_MIN & 0x00ff;
            g_pattern_param.conn_update_param.Conn_Interval_Min[1]       =(HCI_CMD_PARAM_CONN_INT_MIN & 0xff00)  >> 8;
            g_pattern_param.conn_update_param.Conn_Interval_Max[0]       = HCI_CMD_PARAM_CONN_INT_MIN & 0x00ff;
            g_pattern_param.conn_update_param.Conn_Interval_Max[1]       =(HCI_CMD_PARAM_CONN_INT_MIN & 0xff00)  >> 8;           
            verdict = COMM_Conn_Update_Set(dut1_fd , g_pattern_param);
            VERDICT_RESULT_WITH_LINE();

            printf("case 1 finished\n");
            printf("wait 10 sec\n");
            fflush(stdout);
            sleep(10);

            if(SUCCESS != QUERY_LE_Event(dut2_fd, buf, _BT_HCI_LE_EVENT_SUB_OP_CONNECTION_UPDATE_COMPLETE_, 0)) {
                line = __LINE__;
                goto FUN_FAIL;
            }

            if(SUCCESS != hci_le_event_connection_update_complete_parsing(0, buf, g_pattern_param)) {
                line = __LINE__;
                goto FUN_FAIL;
            }

            // # wait and check
            // # conn int range 7.5ms to 4 s

            //# case 2 max conn interval ; min event count
            COMM_Conn_Update_Set_Config(dut1 , &g_pattern_param , conn_handles_mas);
 
            g_pattern_param.conn_update_param.Conn_Interval_Min[0]       = HCI_CMD_PARAM_CONN_INT_MAX & 0x00ff;
            g_pattern_param.conn_update_param.Conn_Interval_Min[1]       =(HCI_CMD_PARAM_CONN_INT_MAX & 0xff00)  >> 8;
            g_pattern_param.conn_update_param.Conn_Interval_Max[0]       = HCI_CMD_PARAM_CONN_INT_MAX & 0x00ff;
            g_pattern_param.conn_update_param.Conn_Interval_Max[1]       =(HCI_CMD_PARAM_CONN_INT_MAX & 0xff00)  >> 8;           

            g_pattern_param.conn_update_param.Supervision_Timeout[0]       = HCI_CMD_PARAM_CONN_LATENCY_MAX & 0x00ff;
            g_pattern_param.conn_update_param.Supervision_Timeout[1]       =(HCI_CMD_PARAM_CONN_LATENCY_MAX & 0xff00)  >> 8;

            g_pattern_param.conn_update_param.Conn_Latency[0]       = 0 & 0x00ff;
            g_pattern_param.conn_update_param.Conn_Latency[1]       =(0 & 0xff00)  >> 8;       

            verdict = COMM_Conn_Update_Set(dut1_fd , g_pattern_param);
            VERDICT_RESULT_WITH_LINE();
            printf("case 2 finished\n");            
            printf("wait 30 sec\n");
            fflush(stdout);
            
            sleep(30);

            if(SUCCESS != QUERY_LE_Event(dut2_fd, buf, _BT_HCI_LE_EVENT_SUB_OP_CONNECTION_UPDATE_COMPLETE_, 0)) {
                line = __LINE__;
                goto FUN_FAIL;
            }

            if(SUCCESS != hci_le_event_connection_update_complete_parsing(0, buf, g_pattern_param)) {
                line = __LINE__;
                goto FUN_FAIL;
            }


            //# case 3 min conn interval ; max event count
            COMM_Conn_Update_Set_Config(dut1 , &g_pattern_param , conn_handles_mas);
            g_pattern_param.conn_update_param.Conn_Interval_Min[0]       = HCI_CMD_PARAM_CONN_INT_MIN & 0x00ff;
            g_pattern_param.conn_update_param.Conn_Interval_Min[1]       =(HCI_CMD_PARAM_CONN_INT_MIN & 0xff00)  >> 8;
            g_pattern_param.conn_update_param.Conn_Interval_Max[0]       = HCI_CMD_PARAM_CONN_INT_MIN & 0x00ff;
            g_pattern_param.conn_update_param.Conn_Interval_Max[1]       =(HCI_CMD_PARAM_CONN_INT_MIN & 0xff00)  >> 8;           
            verdict=COMM_Conn_Update_Set(dut1_fd , g_pattern_param);
            VERDICT_RESULT_WITH_LINE();
            printf("case 3 finished\n");
            printf("wait 50 sec\n");
            fflush(stdout);
            
            sleep(50);


            if(SUCCESS != QUERY_LE_Event(dut2_fd, buf, _BT_HCI_LE_EVENT_SUB_OP_CONNECTION_UPDATE_COMPLETE_, 0)) {
                line = __LINE__;
                goto FUN_FAIL;
            }

            if(SUCCESS != hci_le_event_connection_update_complete_parsing(0, buf, g_pattern_param)) {
                line = __LINE__;
                goto FUN_FAIL;
            }

			buf[_BT_HCI_EVT_CON_COMP_CONN_HANDLE+0] = conn_handles_mas[0];
			buf[_BT_HCI_EVT_CON_COMP_CONN_HANDLE+1] = conn_handles_mas[1];
			
			COMM_Disconnect_Config(dut1,&g_pattern_param,buf);
			verdict=COMM_Disconnect(dut1_fd,g_pattern_param);
			VERDICT_RESULT_WITH_LINE();

                       
            FUNC_END();

    		LOG_INFO("[Pattern][%s]SUCCESS\n", __FUNCTION__);
    		return PASS;

		}
	}

FUN_FAIL:
    FUNC_END();

	LOG_INFO("[Pattern][%s]:%d channel : %d FAIL!!\n", __FUNCTION__, line, adv_Channel);
	return FAIL;

}


// 5.3.3.6
verdict CON_SLA_Slave_Sending_Termination(u8 dut1_fd ,u8 dut2_fd)
{
    u8 buf[SOCKET_BUF_SIZE];
    int verdict = FAIL;
    int dut1 = 0;
    int dut2 = 0;
    u16 line = 0;
    struct itimerval timer;
    u8 conn_handles_sla[2];
    int adv_Channel = 37;

    COMM_Dut_clean_buffer(dut1_fd);
    COMM_Dut_clean_buffer(dut2_fd);

    Calculate_Execution_Time_Start();

    // Uptest(white list) config
    COMM_INI_Connection_Setup_White_Listed_Config(dut2, &g_pattern_param);
    memcpy(g_pattern_param.white_list_param.Address, scan_addr, ADDR_LENGTH);
    g_pattern_param.white_list_param.Address_Type[0] = HCI_CMD_PARAM_PUBLIC_DEVICE_ADDRESS;
    verdict = COMM_INI_Connection_Setup_White_Listed(dut2_fd, g_pattern_param);
    VERDICT_RESULT_WITH_LINE();

    COMM_ADV_Directed_Advertising_Config(HCI_CMD_PARAM_ADV_DATA_LEN_MAX, &g_pattern_param);
    g_pattern_param.adv_param.Advertising_Filter_Policy[0] = HCI_CMD_PARAM_ALLOW_SCAN_REQ_FROM_WHITELIST_ONLY_AND_CONN_REQ_FROM_WHITELIST_ONLY;
    g_pattern_param.adv_param.Advertising_Interval_Max[0] =  0x00a0 & 0x00ff;
    g_pattern_param.adv_param.Advertising_Interval_Max[1] = (0x00a0 & 0xff00) >> 8;
    g_pattern_param.adv_param.Advertising_Interval_Min[0] =  0x00a0 & 0x00ff;
    g_pattern_param.adv_param.Advertising_Interval_Min[1] = (0x00a0 & 0xff00) >> 8;
    if(37 == adv_Channel) {
        g_pattern_param.adv_param.Advertising_Channel_Map[0] = HCI_CMD_PARAM_ENABLE_CHANNEL_37;
    }
   
    verdict = COMM_ADV_Directed_Advertising(dut2_fd, g_pattern_param);
    VERDICT_RESULT_WITH_LINE();

    COMM_INI_Initiating_Config(dut1, &g_pattern_param);    
	g_pattern_param.create_conn_param.Supervision_Timeout[0] 	=0x0a ; //=0xD0;
	g_pattern_param.create_conn_param.Supervision_Timeout[1] 	=0x00 ; //=0x07;
    memcpy(g_pattern_param.create_conn_param.Peer_Address, adv_addr, ADDR_LENGTH );
    verdict = COMM_INI_Initiating(dut1_fd, g_pattern_param);
    VERDICT_RESULT_WITH_LINE();

    event_query_timer_config(5, 0, 0, 0, &timer);
    event_query_timer_start(timer, read_le_event_enable);

    //waiting adv report event , timer or counter
    while(1) {
        if(1 == read_le_event_get()) {
            read_le_event_disable();

            if(SUCCESS != QUERY_LE_Event(dut1_fd, buf,  _BT_HCI_LE_EVENT_SUB_OP_CONNECTION_COMPLETE_, 0)) {
                line = __LINE__;
                goto FUN_FAIL;
            }

            if(SUCCESS != hci_le_event_connection_complete_parsing(0, buf, g_pattern_param)) {
                line = __LINE__;
                goto FUN_FAIL;
            }

            if(SUCCESS != QUERY_LE_Event(dut2_fd, buf, _BT_HCI_LE_EVENT_SUB_OP_CONNECTION_COMPLETE_, 0)) {
                line = __LINE__;
                goto FUN_FAIL;
            }

            if(SUCCESS != hci_le_event_connection_complete_parsing(0, buf, g_pattern_param)) {
                line = __LINE__;
                goto FUN_FAIL;
            }

            conn_handles_sla[0] = buf[_BT_HCI_EVT_CON_COMP_CONN_HANDLE+0];
            conn_handles_sla[1] = buf[_BT_HCI_EVT_CON_COMP_CONN_HANDLE+1];

			// # Slave Connection Terminated
			// use connect handle to disconnect
			buf[_BT_HCI_EVT_COMP_HANDLE+0] = conn_handles_sla[0];
			buf[_BT_HCI_EVT_COMP_HANDLE+1] = conn_handles_sla[1];
			
			COMM_Disconnect_Config(dut2,&g_pattern_param,buf);
            g_pattern_param.disconn_param.Reason[0]= HCI_CMD_PARAM_REMOTE_USER_TERMINATED_CONNECTION;
			verdict=COMM_Disconnect(dut2_fd,g_pattern_param);

            //# query dut2

            sleep(10);

            if(SUCCESS != QUERY_Event(dut2_fd, buf, _BT_HCI_EVENT_OP_DISCONNECTION_COMPLETE_)) {
                line = __LINE__;
                goto FUN_FAIL;
            }

            if(SUCCESS != hci_event_disconnection_complete_parsing(0, buf, g_pattern_param)) {
                line = __LINE__;
                goto FUN_FAIL;
            }

            if(HCI_CMD_PARAM_CONNECTION_TERMINATED_BY_LOCAL_HOST != buf[_BT_HCI_EVT_DISCONN_COMP_REASON]) {
                line = __LINE__;
                goto FUN_FAIL;
            }
#if 0
            //# query dut1
            sleep(5);

            if(SUCCESS != QUERY_Event(dut1_fd, buf, _BT_HCI_EVENT_OP_DISCONNECTION_COMPLETE_)) {
                line = __LINE__;
                goto FUN_FAIL;
            }

            if(SUCCESS != hci_event_disconnection_complete_parsing(0, buf, g_pattern_param)) {
                line = __LINE__;
                goto FUN_FAIL;
            }

            if(HCI_CMD_PARAM_CONNECTION_TIMEOUT != buf[_BT_HCI_EVT_DISCONN_COMP_REASON]) {
                line = __LINE__;
                goto FUN_FAIL;
            }
#endif
            printf("sleep!Please check IUT stop sending packets\n");
            sleep(5);
                        
            FUNC_END();

            LOG_INFO("[Pattern][%s]SUCCESS\n", __FUNCTION__);
            return PASS;
        }
    }

FUN_FAIL:
    FUNC_END();

    LOG_INFO("[Pattern][%s]:%d channel : %d FAIL!!\n", __FUNCTION__, line, adv_Channel);
    return FAIL;

}

// 5.3.3.7
verdict CON_SLA_Slave_Accepting_Termination(u8 dut1_fd ,u8 dut2_fd)
{
    u8 buf[SOCKET_BUF_SIZE];
    int verdict = FAIL;
    int dut1 = 0;
    int dut2 = 0;
    u16 line = 0;
    struct itimerval timer;
    u8 conn_handles_mas[2];
    int adv_Channel = 37;

    COMM_Dut_clean_buffer(dut1_fd);
    COMM_Dut_clean_buffer(dut2_fd);

    Calculate_Execution_Time_Start();

    // Uptest(white list) config
    COMM_INI_Connection_Setup_White_Listed_Config(dut2, &g_pattern_param);
    memcpy(g_pattern_param.white_list_param.Address, scan_addr, ADDR_LENGTH);
    g_pattern_param.white_list_param.Address_Type[0] = HCI_CMD_PARAM_PUBLIC_DEVICE_ADDRESS;
    verdict = COMM_INI_Connection_Setup_White_Listed(dut2_fd, g_pattern_param);
    VERDICT_RESULT_WITH_LINE();

    COMM_ADV_Directed_Advertising_Config(HCI_CMD_PARAM_ADV_DATA_LEN_MAX, &g_pattern_param);
    g_pattern_param.adv_param.Advertising_Filter_Policy[0] = HCI_CMD_PARAM_ALLOW_SCAN_REQ_FROM_WHITELIST_ONLY_AND_CONN_REQ_FROM_WHITELIST_ONLY;
    g_pattern_param.adv_param.Advertising_Interval_Max[0] =  0x00a0 & 0x00ff;
    g_pattern_param.adv_param.Advertising_Interval_Max[1] = (0x00a0 & 0xff00) >> 8;
    g_pattern_param.adv_param.Advertising_Interval_Min[0] =  0x00a0 & 0x00ff;
    g_pattern_param.adv_param.Advertising_Interval_Min[1] = (0x00a0 & 0xff00) >> 8;

    if(37 == adv_Channel) {
        g_pattern_param.adv_param.Advertising_Channel_Map[0] = HCI_CMD_PARAM_ENABLE_CHANNEL_37;
    }
  
    verdict = COMM_ADV_Directed_Advertising(dut2_fd, g_pattern_param);
    VERDICT_RESULT_WITH_LINE();

    COMM_INI_Initiating_Config(dut1, &g_pattern_param);    
	g_pattern_param.create_conn_param.Supervision_Timeout[0] 	=0x0a ; //=0xD0;
	g_pattern_param.create_conn_param.Supervision_Timeout[1] 	=0x00 ; //=0x07;
    memcpy(g_pattern_param.create_conn_param.Peer_Address, adv_addr, ADDR_LENGTH );
    verdict = COMM_INI_Initiating(dut1_fd, g_pattern_param);
    VERDICT_RESULT_WITH_LINE();

    event_query_timer_config(5, 0, 0, 0, &timer);
    event_query_timer_start(timer, read_le_event_enable);

    //waiting adv report event , timer or counter
    while(1) {
        if(1 == read_le_event_get()) {
            read_le_event_disable();

            if(SUCCESS != QUERY_LE_Event(dut1_fd, buf,  _BT_HCI_LE_EVENT_SUB_OP_CONNECTION_COMPLETE_, 0)) {
                line = __LINE__;
                goto FUN_FAIL;
            }

            if(SUCCESS != hci_le_event_connection_complete_parsing(0, buf, g_pattern_param)) {
                line = __LINE__;
                goto FUN_FAIL;
            }

            conn_handles_mas[0] = buf[_BT_HCI_EVT_CON_COMP_CONN_HANDLE+0];
            conn_handles_mas[1] = buf[_BT_HCI_EVT_CON_COMP_CONN_HANDLE+1];


            if(SUCCESS != QUERY_LE_Event(dut2_fd, buf, _BT_HCI_LE_EVENT_SUB_OP_CONNECTION_COMPLETE_, 0)) {
                line = __LINE__;
                goto FUN_FAIL;
            }

            if(SUCCESS != hci_le_event_connection_complete_parsing(0, buf, g_pattern_param)) {
                line = __LINE__;
                goto FUN_FAIL;
            }

			// # Slave Connection Terminated
			// use connect handle to disconnect

            buf[_BT_HCI_EVT_CON_COMP_CONN_HANDLE+0] = conn_handles_mas[0];
			buf[_BT_HCI_EVT_CON_COMP_CONN_HANDLE+1] = conn_handles_mas[1];
			
			COMM_Disconnect_Config(dut1,&g_pattern_param,buf);
            g_pattern_param.disconn_param.Reason[0]= HCI_CMD_PARAM_REMOTE_USER_TERMINATED_CONNECTION;
			verdict=COMM_Disconnect(dut1_fd,g_pattern_param);

            sleep(5);
            //# query dut2

            if(SUCCESS != QUERY_Event(dut2_fd, buf, _BT_HCI_EVENT_OP_DISCONNECTION_COMPLETE_)) {
                line = __LINE__;
                goto FUN_FAIL;
            }

            if(SUCCESS != hci_event_disconnection_complete_parsing(0, buf, g_pattern_param)) {
                line = __LINE__;
                goto FUN_FAIL;
            }

            if(HCI_CMD_PARAM_REMOTE_USER_TERMINATED_CONNECTION != buf[_BT_HCI_EVT_DISCONN_COMP_REASON]) {
                line = __LINE__;
                goto FUN_FAIL;
            }

            printf("sleep!Please check IUT stop sending packets\n");
            sleep(5);
                        
            FUNC_END();

            LOG_INFO("[Pattern][%s]SUCCESS\n", __FUNCTION__);
            return PASS;
        }
    }

FUN_FAIL:
    FUNC_END();


    LOG_INFO("[Pattern][%s]:%d channel : %d FAIL!!\n", __FUNCTION__, line, adv_Channel);
    return FAIL;
}


// 5.3.3.8
verdict CON_SLA_Slave_Supervision_Timer(u8 dut1_fd ,u8 dut2_fd)
{
	u8 buf[SOCKET_BUF_SIZE];
	int verdict = FAIL;
	int dut1 = 0;
    int dut2 = 0;
	u16 line = 0;
	struct itimerval timer;

    COMM_Dut_clean_buffer(dut1_fd);
    COMM_Dut_clean_buffer(dut2_fd);

    Calculate_Execution_Time_Start();
    COMM_INI_Connection_Setup_White_Listed_Config(dut1, &g_pattern_param);
    memcpy(g_pattern_param.white_list_param.Address, adv_addr, ADDR_LENGTH);
    g_pattern_param.white_list_param.Address_Type[0] = HCI_CMD_PARAM_PUBLIC_DEVICE_ADDRESS;
    verdict = COMM_INI_Connection_Setup_White_Listed(dut1_fd, g_pattern_param);
    VERDICT_RESULT_WITH_LINE();

    COMM_INI_Connection_Setup_White_Listed_Config(dut2, &g_pattern_param);
    memcpy(g_pattern_param.white_list_param.Address, scan_addr, ADDR_LENGTH);
    g_pattern_param.white_list_param.Address_Type[0] = HCI_CMD_PARAM_PUBLIC_DEVICE_ADDRESS;
    verdict = COMM_INI_Connection_Setup_White_Listed(dut2_fd, g_pattern_param);
    VERDICT_RESULT_WITH_LINE();

    COMM_ADV_Directed_Advertising_Config(HCI_CMD_PARAM_ADV_DATA_LEN_MAX, &g_pattern_param);
	//here use lowest ch to testing
	g_pattern_param.adv_param.Advertising_Channel_Map[0] =   HCI_CMD_PARAM_ENABLE_CHANNEL_37;
    g_pattern_param.adv_param.Advertising_Filter_Policy[0] = HCI_CMD_PARAM_ALLOW_SCAN_REQ_FROM_WHITELIST_ONLY_AND_CONN_REQ_FROM_WHITELIST_ONLY;
	g_pattern_param.adv_param.Advertising_Interval_Max[0] =  0x00a0 & 0x00ff;
    g_pattern_param.adv_param.Advertising_Interval_Max[1] = (0x00a0 & 0xff00) >> 8;
    g_pattern_param.adv_param.Advertising_Interval_Min[0] =  0x00a0 & 0x00ff;
    g_pattern_param.adv_param.Advertising_Interval_Min[1] = (0x00a0 & 0xff00) >> 8;	
    verdict = COMM_ADV_Directed_Advertising(dut2_fd, g_pattern_param);
	VERDICT_RESULT_WITH_LINE();

	COMM_INI_Initiating_Config(dut1, &g_pattern_param);
	//use max supervision here
	memcpy(g_pattern_param.create_conn_param.Peer_Address, adv_addr, ADDR_LENGTH);
    g_pattern_param.create_conn_param.Initiator_Filter_Policy[0] = HCI_CMD_PARAM_FILTER_POLICY_WHITE_LIST_USED;
	g_pattern_param.create_conn_param.Supervision_Timeout[0] =     HCI_CMD_PARAM_SUPERVISION_TO_MAX & 0x00ff;
	g_pattern_param.create_conn_param.Supervision_Timeout[1] =    (HCI_CMD_PARAM_SUPERVISION_TO_MAX & 0xff00) >> 8;
	//memcpy(g_pattern_param.create_conn_param.Peer_Address ,scan_addr,ADDR_LENGTH );
	verdict = COMM_INI_Initiating(dut1_fd, g_pattern_param);
	VERDICT_RESULT_WITH_LINE();

	event_query_timer_config(5, 0, 0, 0, &timer);
	event_query_timer_start(timer, read_le_event_enable);

    //waiting adv report event , timer or counter
	while(1) {
		if(1 == read_le_event_get()) {
            
            read_le_event_disable();

            if(SUCCESS != QUERY_LE_Event(dut1_fd, buf, _BT_HCI_LE_EVENT_SUB_OP_CONNECTION_COMPLETE_, 0)) {
				line = __LINE__;
				goto FUN_FAIL;
			}
			if(SUCCESS != hci_le_event_connection_complete_parsing(0, buf, g_pattern_param)) {
				line = __LINE__;
				goto FUN_FAIL;
			}
            
			if (SUCCESS != QUERY_LE_Event(dut2_fd, buf,	_BT_HCI_LE_EVENT_SUB_OP_CONNECTION_COMPLETE_, 0)) {
				line = __LINE__;
				goto FUN_FAIL;
			}
			if(SUCCESS != hci_le_event_connection_complete_parsing(0, buf, g_pattern_param)) {
				line = __LINE__;
				goto FUN_FAIL;
			}            

			//Connection Terminated
			//use connect handle to disconnect
			COMM_Reset(dut1_fd);

            // # max timeout
			sleep(40);

			if(SUCCESS != QUERY_Event(dut2_fd, buf, _BT_HCI_EVENT_OP_DISCONNECTION_COMPLETE_)) {
                line = __LINE__;
                goto FUN_FAIL;
            }

            if(SUCCESS != hci_event_disconnection_complete_parsing(0, buf, g_pattern_param)) {
                line = __LINE__;
                goto FUN_FAIL;
            }

            if(HCI_CMD_PARAM_CONNECTION_TIMEOUT != buf[_BT_HCI_EVT_DISCONN_COMP_REASON]) {
                line = __LINE__;
                goto FUN_FAIL;
            }

			break;
		}
	}

	//do another testing
	dut_reset_with_mask_en(dut2_fd);
    dut_reset_with_mask_en(dut1_fd);
    sleep(1);

	COMM_INI_Connection_Setup_White_Listed_Config(dut1, &g_pattern_param);
    memcpy(g_pattern_param.white_list_param.Address, adv_addr, ADDR_LENGTH);
    g_pattern_param.white_list_param.Address_Type[0] = HCI_CMD_PARAM_PUBLIC_DEVICE_ADDRESS;
    verdict = COMM_INI_Connection_Setup_White_Listed(dut1_fd, g_pattern_param);
    VERDICT_RESULT_WITH_LINE();

    COMM_INI_Connection_Setup_White_Listed_Config(dut2, &g_pattern_param);
    memcpy(g_pattern_param.white_list_param.Address, scan_addr, ADDR_LENGTH);
    g_pattern_param.white_list_param.Address_Type[0] = HCI_CMD_PARAM_PUBLIC_DEVICE_ADDRESS;
    verdict = COMM_INI_Connection_Setup_White_Listed(dut2_fd, g_pattern_param);
    VERDICT_RESULT_WITH_LINE();

    COMM_ADV_Directed_Advertising_Config(HCI_CMD_PARAM_ADV_DATA_LEN_MAX, &g_pattern_param);
	//here use lowest ch to testing
	g_pattern_param.adv_param.Advertising_Channel_Map[0] = HCI_CMD_PARAM_ENABLE_CHANNEL_37;
    g_pattern_param.adv_param.Advertising_Filter_Policy[0] = HCI_CMD_PARAM_ALLOW_SCAN_REQ_FROM_WHITELIST_ONLY_AND_CONN_REQ_FROM_WHITELIST_ONLY;
	g_pattern_param.adv_param.Advertising_Interval_Max[0] =  0x00a0 & 0x00ff;
    g_pattern_param.adv_param.Advertising_Interval_Max[1] = (0x00a0 & 0xff00) >> 8;
    g_pattern_param.adv_param.Advertising_Interval_Min[0] =  0x00a0 & 0x00ff;
    g_pattern_param.adv_param.Advertising_Interval_Min[1] = (0x00a0 & 0xff00) >> 8;	
    verdict = COMM_ADV_Directed_Advertising(dut2_fd, g_pattern_param);
	VERDICT_RESULT_WITH_LINE();

	COMM_INI_Initiating_Config(dut1, &g_pattern_param);
	//use max supervision here
	memcpy(g_pattern_param.create_conn_param.Peer_Address, adv_addr, ADDR_LENGTH);
    g_pattern_param.create_conn_param.Initiator_Filter_Policy[0] = HCI_CMD_PARAM_FILTER_POLICY_WHITE_LIST_USED;
	g_pattern_param.create_conn_param.Supervision_Timeout[0] =  HCI_CMD_PARAM_SUPERVISION_TO_MIN& 0x00ff;
	g_pattern_param.create_conn_param.Supervision_Timeout[1] = (HCI_CMD_PARAM_SUPERVISION_TO_MIN & 0xff00) >> 8;
	//memcpy(g_pattern_param.create_conn_param.Peer_Address ,scan_addr,ADDR_LENGTH );
	verdict = COMM_INI_Initiating(dut1_fd, g_pattern_param);
	VERDICT_RESULT_WITH_LINE();

	event_query_timer_config(5, 0, 0, 0, &timer);
	event_query_timer_start(timer, read_le_event_enable);

    //waiting adv report event , timer or counter
	while(1) {
		if(1 == read_le_event_get()) {

            read_le_event_disable();
            
			if(SUCCESS != QUERY_LE_Event(dut1_fd, buf, _BT_HCI_LE_EVENT_SUB_OP_CONNECTION_COMPLETE_, 0)) {
				line = __LINE__;
				goto FUN_FAIL;
			}
			if(SUCCESS != hci_le_event_connection_complete_parsing(0, buf, g_pattern_param)) {
				line = __LINE__;
				goto FUN_FAIL;
			}
            
			if (SUCCESS != QUERY_LE_Event(dut2_fd, buf,	_BT_HCI_LE_EVENT_SUB_OP_CONNECTION_COMPLETE_, 0)) {
				line = __LINE__;
				goto FUN_FAIL;
			}
			if(SUCCESS != hci_le_event_connection_complete_parsing(0, buf, g_pattern_param)) {
				line = __LINE__;
				goto FUN_FAIL;
			}            

			//Connection Terminated
			//use connect handle to disconnect
			COMM_Reset(dut1_fd);

			sleep(1);
            
			if(SUCCESS != QUERY_Event(dut2_fd, buf, _BT_HCI_EVENT_OP_DISCONNECTION_COMPLETE_)) {
                line = __LINE__;
                goto FUN_FAIL;
            }

            if(SUCCESS != hci_event_disconnection_complete_parsing(0, buf, g_pattern_param)) {
                line = __LINE__;
                goto FUN_FAIL;
            }

            if(HCI_CMD_PARAM_CONNECTION_TIMEOUT != buf[_BT_HCI_EVT_DISCONN_COMP_REASON]) {
                line = __LINE__;
                goto FUN_FAIL;
            }

            FUNC_END();

			LOG_INFO("[Pattern][%s]SUCCESS\n", __FUNCTION__);
			return PASS;
		}
	}

FUN_FAIL:
    FUNC_END();

	LOG_INFO("[Pattern][%s]:%d FAIL\n", __FUNCTION__, line);
	return FAIL;
}


// 5.3.3.9
verdict CON_SLA_Feature_Setup_Response(u8 dut1_fd ,u8 dut2_fd)
{
	u8 buf[SOCKET_BUF_SIZE];
	int verdict = FAIL;
	int dut1 = 0;
    int dut2 = 0;
	u16 line = 0;
    u8 conn_handles_mas[2];
    
	struct itimerval timer;

    COMM_Dut_clean_buffer(dut1_fd);
    COMM_Dut_clean_buffer(dut2_fd);

    Calculate_Execution_Time_Start();
	COMM_INI_Connection_Setup_White_Listed_Config(dut1, &g_pattern_param);
    memcpy(g_pattern_param.white_list_param.Address, adv_addr, ADDR_LENGTH);
    g_pattern_param.white_list_param.Address_Type[0] = HCI_CMD_PARAM_PUBLIC_DEVICE_ADDRESS;
    verdict = COMM_INI_Connection_Setup_White_Listed(dut1_fd, g_pattern_param);
    VERDICT_RESULT_WITH_LINE();

    COMM_INI_Connection_Setup_White_Listed_Config(dut2, &g_pattern_param);
    memcpy(g_pattern_param.white_list_param.Address, scan_addr, ADDR_LENGTH);
    g_pattern_param.white_list_param.Address_Type[0] = HCI_CMD_PARAM_PUBLIC_DEVICE_ADDRESS;
    verdict = COMM_INI_Connection_Setup_White_Listed(dut2_fd, g_pattern_param);
    VERDICT_RESULT_WITH_LINE();

    COMM_ADV_Directed_Advertising_Config(HCI_CMD_PARAM_ADV_DATA_LEN_MAX, &g_pattern_param);
	//here use lowest ch to testing
	g_pattern_param.adv_param.Advertising_Channel_Map[0] = HCI_CMD_PARAM_ENABLE_CHANNEL_37;
    g_pattern_param.adv_param.Advertising_Filter_Policy[0] = HCI_CMD_PARAM_ALLOW_SCAN_REQ_FROM_WHITELIST_ONLY_AND_CONN_REQ_FROM_WHITELIST_ONLY;
	g_pattern_param.adv_param.Advertising_Interval_Max[0] =  0x00a0 & 0x00ff;
    g_pattern_param.adv_param.Advertising_Interval_Max[1] = (0x00a0 & 0xff00) >> 8;
    g_pattern_param.adv_param.Advertising_Interval_Min[0] =  0x00a0 & 0x00ff;
    g_pattern_param.adv_param.Advertising_Interval_Min[1] = (0x00a0 & 0xff00) >> 8;	
    verdict = COMM_ADV_Directed_Advertising(dut2_fd, g_pattern_param);
	VERDICT_RESULT_WITH_LINE();

	COMM_INI_Initiating_Config(dut1, &g_pattern_param);
	//use max supervision here
	memcpy(g_pattern_param.create_conn_param.Peer_Address, adv_addr, ADDR_LENGTH);
    g_pattern_param.create_conn_param.Initiator_Filter_Policy[0] = HCI_CMD_PARAM_FILTER_POLICY_WHITE_LIST_USED;	
	//memcpy(g_pattern_param.create_conn_param.Peer_Address ,scan_addr,ADDR_LENGTH );
	verdict = COMM_INI_Initiating(dut1_fd, g_pattern_param);
	VERDICT_RESULT_WITH_LINE();

	event_query_timer_config(5, 0, 0, 0, &timer);
	event_query_timer_start(timer, read_le_event_enable);

    //waiting adv report event , timer or counter
	while(1) {
		if(1 == read_le_event_get()) {

            read_le_event_disable();
            
            if(SUCCESS != QUERY_LE_Event(dut1_fd, buf, _BT_HCI_LE_EVENT_SUB_OP_CONNECTION_COMPLETE_, 0)) {
				line = __LINE__;
				goto FUN_FAIL;
			}
			if(SUCCESS != hci_le_event_connection_complete_parsing(0, buf, g_pattern_param)) {
				line = __LINE__;
				goto FUN_FAIL;
			}

            conn_handles_mas[0]=buf[_BT_HCI_EVT_CON_COMP_CONN_HANDLE+0];
			conn_handles_mas[1]=buf[_BT_HCI_EVT_CON_COMP_CONN_HANDLE+1];
            
			if (SUCCESS != QUERY_LE_Event(dut2_fd, buf,	_BT_HCI_LE_EVENT_SUB_OP_CONNECTION_COMPLETE_, 0)) {
				line = __LINE__;
				goto FUN_FAIL;
			}
			if(SUCCESS != hci_le_event_connection_complete_parsing(0, buf, g_pattern_param)) {
				line = __LINE__;
				goto FUN_FAIL;
			}

			verdict = COMM_Read_Local_Supported_Features(dut1_fd, g_pattern_param);
			VERDICT_RESULT_WITH_LINE();

			COMM_Read_Remote_Supported_Features_Config(dut1_fd,&g_pattern_param, conn_handles_mas);
			verdict = COMM_Read_Remote_Supported_Features(dut1_fd, g_pattern_param);
			VERDICT_RESULT_WITH_LINE();

			sleep(5);

			if(SUCCESS != QUERY_LE_Event(dut1_fd, buf, _BT_HCI_LE_EVENT_SUB_OP_READ_REMOTE_USED_FEATURES_COMPLETE_,	0)) {
				line = __LINE__;
				goto FUN_FAIL;
			}

			if(SUCCESS != hci_event_read_remote_supported_features_complete_parsing(0, buf, g_pattern_param)) {
				line = __LINE__;
				goto FUN_FAIL;
			}

			if(SUCCESS != QUERY_LE_Event(dut2_fd, buf, _BT_HCI_LE_EVENT_SUB_OP_READ_REMOTE_USED_FEATURES_COMPLETE_,	0)) {
				line = __LINE__;
				goto FUN_FAIL;
			}

			if(ERROR != hci_event_read_remote_supported_features_complete_parsing(0, buf, g_pattern_param)) {
				line = __LINE__;
				goto FUN_FAIL;
			}



			buf[_BT_HCI_EVT_CON_COMP_CONN_HANDLE+0] = conn_handles_mas[0];
			buf[_BT_HCI_EVT_CON_COMP_CONN_HANDLE+1] = conn_handles_mas[1];
			
			COMM_Disconnect_Config(dut1,&g_pattern_param,buf);
			verdict=COMM_Disconnect(dut1_fd,g_pattern_param);
			VERDICT_RESULT_WITH_LINE();
            
            FUNC_END();

			LOG_INFO("[Pattern][%s]SUCCESS\n" ,__FUNCTION__);
			return PASS;
		}
	}

FUN_FAIL:
    FUNC_END();

	LOG_INFO("[Pattern][%s]:%d FAIL\n" ,__FUNCTION__,line);
	return FAIL;
}


// 5.3.3.14
verdict CON_SLA_Slave_Request_Version(u8 dut1_fd ,u8 dut2_fd)
{
	u8 buf[SOCKET_BUF_SIZE];
	int verdict = FAIL;
	int dut1 = 0;
    int dut2 = 0;
	u16 line = 0;
	struct itimerval timer;
	u8 conn_handles_mas[2];
	u8 conn_handles_sla[2];

    COMM_Dut_clean_buffer(dut1_fd);
    COMM_Dut_clean_buffer(dut2_fd);

    Calculate_Execution_Time_Start();
	// Uptest(white list) config
	COMM_INI_Connection_Setup_White_Listed_Config(dut2, &g_pattern_param);
    memcpy(g_pattern_param.white_list_param.Address, scan_addr, ADDR_LENGTH);
    g_pattern_param.white_list_param.Address_Type[0] = HCI_CMD_PARAM_PUBLIC_DEVICE_ADDRESS;
    verdict = COMM_INI_Connection_Setup_White_Listed(dut2_fd, g_pattern_param);
    VERDICT_RESULT_WITH_LINE();

	COMM_ADV_Directed_Advertising_Config(HCI_CMD_PARAM_ADV_DATA_LEN_MAX, &g_pattern_param);
	g_pattern_param.adv_param.Advertising_Filter_Policy[0] = HCI_CMD_PARAM_ALLOW_SCAN_REQ_FROM_WHITELIST_ONLY_AND_CONN_REQ_FROM_WHITELIST_ONLY;
	g_pattern_param.adv_param.Advertising_Interval_Max[0] =  0x00a0 & 0x00ff;
    g_pattern_param.adv_param.Advertising_Interval_Max[1] = (0x00a0 & 0xff00) >> 8;
    g_pattern_param.adv_param.Advertising_Interval_Min[0] =  0x00a0 & 0x00ff;
    g_pattern_param.adv_param.Advertising_Interval_Min[1] = (0x00a0 & 0xff00) >> 8;	
	g_pattern_param.adv_param.Advertising_Channel_Map[0]  = HCI_CMD_PARAM_ENABLE_CHANNEL_37;
	verdict = COMM_ADV_Directed_Advertising(dut2_fd, g_pattern_param);
	VERDICT_RESULT_WITH_LINE();

	COMM_INI_Initiating_Config(dut1, &g_pattern_param);
	memcpy(g_pattern_param.create_conn_param.Peer_Address, adv_addr, ADDR_LENGTH );
	verdict = COMM_INI_Initiating(dut1_fd, g_pattern_param);
	VERDICT_RESULT_WITH_LINE();
    
	event_query_timer_config(5, 0, 0, 0, &timer);
	event_query_timer_start(timer, read_le_event_enable);

    //waiting adv report event , timer or counter
	while(1) {
		if(1 == read_le_event_get()) {

            read_le_event_disable();
            
			if(SUCCESS != QUERY_LE_Event(dut1_fd, buf, _BT_HCI_LE_EVENT_SUB_OP_CONNECTION_COMPLETE_, 0)) {
				line = __LINE__;
				goto FUN_FAIL;
			}
			if(SUCCESS != hci_le_event_connection_complete_parsing(0, buf, g_pattern_param)) {
				line = __LINE__;
				goto FUN_FAIL;
			}

            conn_handles_mas[0]=buf[_BT_HCI_EVT_CON_COMP_CONN_HANDLE+0];
			conn_handles_mas[1]=buf[_BT_HCI_EVT_CON_COMP_CONN_HANDLE+1];
            
			if (SUCCESS != QUERY_LE_Event(dut2_fd, buf,	_BT_HCI_LE_EVENT_SUB_OP_CONNECTION_COMPLETE_, 0)) {
				line = __LINE__;
				goto FUN_FAIL;
			}
			if(SUCCESS != hci_le_event_connection_complete_parsing(0, buf, g_pattern_param)) {
				line = __LINE__;
				goto FUN_FAIL;
			}

            conn_handles_sla[0]=buf[_BT_HCI_EVT_CON_COMP_CONN_HANDLE+0];
            conn_handles_sla[1]=buf[_BT_HCI_EVT_CON_COMP_CONN_HANDLE+1];            

			COMM_Read_Remote_Version_Information_Config(dut2_fd, &g_pattern_param, conn_handles_sla);
			verdict = COMM_Read_Remote_Version_Information(dut2_fd, g_pattern_param);
			VERDICT_RESULT_WITH_LINE();

			sleep(1);

			if(SUCCESS != QUERY_Event(dut2_fd, buf,	_BT_HCI_EVENT_OP_READ_REMOTE_VERSION_INFORMATION_COMPLETE_)) {
				line = __LINE__;
				goto FUN_FAIL;
			}

			if(SUCCESS != hci_event_read_remote_version_information_complete_parsing(buf, g_pattern_param)) {
				line = __LINE__;
				goto FUN_FAIL;
			}

			buf[_BT_HCI_EVT_CON_COMP_CONN_HANDLE+0] = conn_handles_mas[0];
			buf[_BT_HCI_EVT_CON_COMP_CONN_HANDLE+1] = conn_handles_mas[1];
			
			COMM_Disconnect_Config(dut1,&g_pattern_param,buf);
			verdict=COMM_Disconnect(dut1_fd,g_pattern_param);
			VERDICT_RESULT_WITH_LINE();
                        
            FUNC_END();

			LOG_INFO("[Pattern][%s]SUCCESS\n", __FUNCTION__);
			return PASS;
		}
	}

FUN_FAIL:
    FUNC_END();

	LOG_INFO("[Pattern][%s]:%d FAIL\n", __FUNCTION__, line);
    return FAIL;
}


// 5.3.3.15
verdict CON_SLA_Slave_Respond_Version(u8 dut1_fd ,u8 dut2_fd)
{
	u8 buf[SOCKET_BUF_SIZE];
	int verdict = FAIL;
	int dut1 = 0;
    int dut2 = 0;
	u16 line = 0;
	struct itimerval timer;
	u8 conn_handles_mas[2];

    COMM_Dut_clean_buffer(dut1_fd);
    COMM_Dut_clean_buffer(dut2_fd);

	Calculate_Execution_Time_Start();
	// Uptest(white list) config
	COMM_INI_Connection_Setup_White_Listed_Config(dut2, &g_pattern_param);
    memcpy(g_pattern_param.white_list_param.Address, scan_addr, ADDR_LENGTH);
    g_pattern_param.white_list_param.Address_Type[0] = HCI_CMD_PARAM_PUBLIC_DEVICE_ADDRESS;
    verdict = COMM_INI_Connection_Setup_White_Listed(dut2_fd, g_pattern_param);
    VERDICT_RESULT_WITH_LINE();

	COMM_ADV_Directed_Advertising_Config(HCI_CMD_PARAM_ADV_DATA_LEN_MAX, &g_pattern_param);
	g_pattern_param.adv_param.Advertising_Filter_Policy[0] = HCI_CMD_PARAM_ALLOW_SCAN_REQ_FROM_WHITELIST_ONLY_AND_CONN_REQ_FROM_WHITELIST_ONLY;
	g_pattern_param.adv_param.Advertising_Interval_Max[0] =  0x00a0 & 0x00ff;
    g_pattern_param.adv_param.Advertising_Interval_Max[1] = (0x00a0 & 0xff00) >> 8;
    g_pattern_param.adv_param.Advertising_Interval_Min[0] =  0x00a0 & 0x00ff;
    g_pattern_param.adv_param.Advertising_Interval_Min[1] = (0x00a0 & 0xff00) >> 8;	
	g_pattern_param.adv_param.Advertising_Channel_Map[0] = HCI_CMD_PARAM_ENABLE_CHANNEL_37;
	verdict = COMM_ADV_Directed_Advertising(dut2_fd, g_pattern_param);
	VERDICT_RESULT_WITH_LINE();

	COMM_INI_Initiating_Config(dut1, &g_pattern_param);
	memcpy(g_pattern_param.create_conn_param.Peer_Address, adv_addr, ADDR_LENGTH );
	verdict = COMM_INI_Initiating(dut1_fd, g_pattern_param);
	VERDICT_RESULT_WITH_LINE();

	event_query_timer_config(5, 0, 0, 0, &timer);
	event_query_timer_start(timer, read_le_event_enable);

    verdict = COMM_Read_Local_Version_Information(dut2_fd, &g_pattern_param);
    VERDICT_RESULT_WITH_LINE();

    if((g_pattern_param.local_version_information_param.Manufacturer_Name[0] != s_manufacturer[1]) || 
       (g_pattern_param.local_version_information_param.Manufacturer_Name[1] != s_manufacturer[0])){
    
        LOG_INFO("local manufacturer mismatch\n");
        LOG_INFO("pattern :0x%02x 0x%02x\n" , s_manufacturer[1] , s_manufacturer[0]);
        LOG_INFO("dut     :0x%02x 0x%02x\n" , g_pattern_param.local_version_information_param.Manufacturer_Name[0] , g_pattern_param.local_version_information_param.Manufacturer_Name[1]);
    
        line = __LINE__;
        goto FUN_FAIL;
    }

    if((g_pattern_param.local_version_information_param.LMP_PAL_Subversion[0] != s_subversion[1]) || 
       (g_pattern_param.local_version_information_param.LMP_PAL_Subversion[1] != s_subversion[0])){
    
        LOG_INFO("local subversion mismatch\n");
        LOG_INFO("pattern :0x%02x 0x%02x\n" , s_subversion[1] , s_subversion[0]);
        LOG_INFO("dut     :0x%02x 0x%02x\n" , g_pattern_param.local_version_information_param.LMP_PAL_Subversion[0] , g_pattern_param.local_version_information_param.LMP_PAL_Subversion[1]);
    
        line = __LINE__;
        goto FUN_FAIL;
    }


    
    //waiting adv report event , timer or counter
	while(1) {
		if(1 == read_le_event_get()) {

            read_le_event_disable();
            
			if(SUCCESS != QUERY_LE_Event(dut1_fd, buf, _BT_HCI_LE_EVENT_SUB_OP_CONNECTION_COMPLETE_, 0)) {
				line = __LINE__;
				goto FUN_FAIL;
			}

			if(SUCCESS != hci_le_event_connection_complete_parsing(0, buf, g_pattern_param)) {
				line = __LINE__;
				goto FUN_FAIL;
			}

			conn_handles_mas[0] = buf[_BT_HCI_EVT_CON_COMP_CONN_HANDLE+0];
			conn_handles_mas[1] = buf[_BT_HCI_EVT_CON_COMP_CONN_HANDLE+1];

			if(SUCCESS != QUERY_LE_Event(dut2_fd, buf, _BT_HCI_LE_EVENT_SUB_OP_CONNECTION_COMPLETE_, 0)) {
				line = __LINE__;
				goto FUN_FAIL;
			}

			if(SUCCESS != hci_le_event_connection_complete_parsing(0, buf, g_pattern_param)) {
				line = __LINE__;
				goto FUN_FAIL;
			}

			COMM_Read_Remote_Version_Information_Config(dut1_fd, &g_pattern_param, conn_handles_mas);
			verdict = COMM_Read_Remote_Version_Information(dut1_fd, g_pattern_param);
			VERDICT_RESULT_WITH_LINE();

			sleep(1);

			if (SUCCESS != QUERY_Event(dut1_fd, buf, _BT_HCI_EVENT_OP_READ_REMOTE_VERSION_INFORMATION_COMPLETE_)) {
				line = __LINE__;
				goto FUN_FAIL;
			}

			if(SUCCESS != hci_event_read_remote_version_information_complete_parsing(buf, g_pattern_param)) {
				line = __LINE__;
				goto FUN_FAIL;
			}

        	if((buf[_BT_HCI_EVT_REMOTE_VER_INFO_MANU_NAME  ] != s_manufacturer[1]) || 
               (buf[_BT_HCI_EVT_REMOTE_VER_INFO_MANU_NAME+1] != s_manufacturer[0])){

                LOG_INFO("remote manufacturer mismatch\n");

                line = __LINE__;
                goto FUN_FAIL;
        	}

        	if((buf[_BT_HCI_EVT_REMOTE_VER_INFO_SUBVER  ] != s_subversion[1]) || 
               (buf[_BT_HCI_EVT_REMOTE_VER_INFO_SUBVER+1] != s_subversion[0])){

                LOG_INFO("remote sub version mismatch\n");

                line = __LINE__;
                goto FUN_FAIL;
        	}

			if (SUCCESS != QUERY_Event(dut2_fd, buf, _BT_HCI_EVENT_OP_READ_REMOTE_VERSION_INFORMATION_COMPLETE_)) {
				line = __LINE__;
				goto FUN_FAIL;
			}

			if(ERROR != hci_event_read_remote_version_information_complete_parsing(buf, g_pattern_param)) {
				line = __LINE__;
				goto FUN_FAIL;
			}


			buf[_BT_HCI_EVT_CON_COMP_CONN_HANDLE+0] = conn_handles_mas[0];
			buf[_BT_HCI_EVT_CON_COMP_CONN_HANDLE+1] = conn_handles_mas[1];
			
			COMM_Disconnect_Config(dut1,&g_pattern_param,buf);
			verdict=COMM_Disconnect(dut1_fd,g_pattern_param);
			VERDICT_RESULT_WITH_LINE();                        
            
            FUNC_END();

			LOG_INFO("[Pattern][%s]SUCCESS\n" ,__FUNCTION__);
			return PASS;
		}
	}

FUN_FAIL:
    FUNC_END();

	LOG_INFO("[Pattern][%s]:%d FAIL\n" ,__FUNCTION__,line);
    return FAIL;
}

// 5.3.3.16
verdict CON_SLA_Slave_Acknowledgement_Scheme (u8 dut1_fd ,u8 dut2_fd)
{
    u8 buf[SOCKET_BUF_SIZE];
    int verdict = FAIL;
    int dut1 = 0;
    int dut2 = 0;
    u16 line = 0;
    struct itimerval timer;
    u8 conn_handles_mas[2];

    u8 acl_data[1] = {0xFF};
    u8 test_cnt1 = 0;

    int adv_Channel = 37;

    int sla_pkt_chk = 0 ;

    COMM_Dut_clean_buffer(dut1_fd);
    COMM_Dut_clean_buffer(dut2_fd);

    Calculate_Execution_Time_Start();

    // Uptest(white list) config
    COMM_INI_Connection_Setup_White_Listed_Config(dut2, &g_pattern_param);
    memcpy(g_pattern_param.white_list_param.Address, scan_addr, ADDR_LENGTH);
    g_pattern_param.white_list_param.Address_Type[0] = HCI_CMD_PARAM_PUBLIC_DEVICE_ADDRESS;
    verdict = COMM_INI_Connection_Setup_White_Listed(dut2_fd, g_pattern_param);
    VERDICT_RESULT_WITH_LINE();

    COMM_ADV_Directed_Advertising_Config(HCI_CMD_PARAM_ADV_DATA_LEN_MAX, &g_pattern_param);
    g_pattern_param.adv_param.Advertising_Filter_Policy[0] = HCI_CMD_PARAM_ALLOW_SCAN_REQ_FROM_WHITELIST_ONLY_AND_CONN_REQ_FROM_WHITELIST_ONLY;
    g_pattern_param.adv_param.Advertising_Interval_Max[0] =  0x00a0 & 0x00ff;
    g_pattern_param.adv_param.Advertising_Interval_Max[1] = (0x00a0 & 0xff00) >> 8;
    g_pattern_param.adv_param.Advertising_Interval_Min[0] =  0x00a0 & 0x00ff;
    g_pattern_param.adv_param.Advertising_Interval_Min[1] = (0x00a0 & 0xff00) >> 8; 

    if(37 == adv_Channel) {
        g_pattern_param.adv_param.Advertising_Channel_Map[0] = HCI_CMD_PARAM_ENABLE_CHANNEL_37;
    }

    verdict = COMM_ADV_Directed_Advertising(dut2_fd, g_pattern_param);
    VERDICT_RESULT_WITH_LINE();

    COMM_INI_Initiating_Config(dut1, &g_pattern_param);
    memcpy(g_pattern_param.create_conn_param.Peer_Address, adv_addr, ADDR_LENGTH );
    verdict = COMM_INI_Initiating(dut1_fd, g_pattern_param);
    VERDICT_RESULT_WITH_LINE();

    event_query_timer_config(5, 0, 0, 0, &timer);
    event_query_timer_start(timer, read_le_event_enable);

    while(1)//waiting adv report event , timer or counter
    {
        if(1 == read_le_event_get())
        {        
            read_le_event_disable();
            
            if(SUCCESS != QUERY_LE_Event(dut1_fd, buf, _BT_HCI_LE_EVENT_SUB_OP_CONNECTION_COMPLETE_, 0)) {
                line = __LINE__;
                goto FUN_FAIL;
            }
            if(SUCCESS != hci_le_event_connection_complete_parsing(0, buf, g_pattern_param)) {
                line = __LINE__;
                goto FUN_FAIL;
            }

            conn_handles_mas[0] = buf[_BT_HCI_EVT_CON_COMP_CONN_HANDLE+0];
            conn_handles_mas[1] = buf[_BT_HCI_EVT_CON_COMP_CONN_HANDLE+1];      

            if (SUCCESS != QUERY_LE_Event(dut2_fd, buf, _BT_HCI_LE_EVENT_SUB_OP_CONNECTION_COMPLETE_, 0)) {
                line = __LINE__;
                goto FUN_FAIL;
            }
            if(SUCCESS != hci_le_event_connection_complete_parsing(0, buf, g_pattern_param)) {
                line = __LINE__;
                goto FUN_FAIL;
            }
            
            //######################################
            //Master to Slave
            while (test_cnt1 < 15) {

                printf("channel : %d, ACL_Data = 0xFF, Test_Cnt = %d\n", adv_Channel, test_cnt1);
                
                COMM_Send_ACL_Data_Without_event(dut1_fd, conn_handles_mas, 0b00, 0, 1, acl_data);
PKT_CHK:
                // # check disconnection             
                CHECK_NON_DISCONNECT();

                if(SUCCESS != QUERY_Event(dut1_fd, buf, _BT_HCI_EVENT_OP_NUMBER_OF_COMPLETED_PACKETS_)) {
                    line = __LINE__;
                    goto FUN_FAIL;
                }
                else if(1 != hci_event_num_of_completed_packets_parsing(buf)) {

                    MSLEEP(100);

                    sla_pkt_chk ++ ;
                    if (sla_pkt_chk == 100){
                        printf("sla no number of completed pkts\n");
                        line = __LINE__;
                        goto FUN_FAIL;                  
                    }

                    goto PKT_CHK;
                } 

                sla_pkt_chk = 0 ;

                usleep(300000);
            
                if (SUCCESS != QUERY_Acl_Data(dut2_fd,buf)) {
                    line = __LINE__;
                    goto FUN_FAIL;
                }

                if (0x02 != (buf[_BT_HCI_IDX_ACL_DATA_CONN_HANDLE_+1] & 0xF0) >> 4) {
                    line = __LINE__;
                    goto FUN_FAIL;
                }

                // # need add api to check acl_data
                if (0xFF != (buf [_BT_HCI_IDX_ACL_DATA_PAYLOAD_]))
                {
                    line=__LINE__;
                    goto FUN_FAIL;
                }


                test_cnt1 ++ ;
             }

            buf[_BT_HCI_EVT_COMP_HANDLE+0] = conn_handles_mas[0];
            buf[_BT_HCI_EVT_COMP_HANDLE+1] = conn_handles_mas[1];
            
            COMM_Disconnect_Config(dut1,&g_pattern_param,buf);
            verdict=COMM_Disconnect(dut1_fd,g_pattern_param);
            VERDICT_RESULT_WITH_LINE();

            FUNC_END();

            LOG_INFO("[Pattern][%s]SUCCESS\n", __FUNCTION__);
            return PASS;
        }
    }

FUN_FAIL:

    FUNC_END();

    LOG_INFO("[Pattern][%s]:%d channel : %d FAIL!!\n" , __FUNCTION__, line, adv_Channel);
    return FAIL;
}

// 5.4.1.2
verdict CON_MAS_Master_Sending_Data (u8 dut1_fd ,u8 dut2_fd)
{
	u8 buf[SOCKET_BUF_SIZE];
	int verdict = FAIL;
	int dut1 = 0;
    int dut2 = 0;
	u16 line = 0 ;
	struct itimerval timer;
	u8 conn_handles_mas[2];
	u8 acl_data[10] = {0};
	u8 acl_data2[32] = {0};
    u8 test_Times = 100;
    u8 test_cnt1 = 0;
    u8 test_cnt2 = 0;
    u8 test_cnt3 = 0;
    u8 test_cnt4 = 0;
    int adv_Channel = 37;

    int mas_pkt_chk = 0 ;

	Calculate_Execution_Time_Start();
REPEAT:
    test_cnt1 = test_Times;
    test_cnt2 = test_Times;
    test_cnt3 = test_Times;
    test_cnt4 = test_Times;

    COMM_Dut_clean_buffer(dut1_fd);
    COMM_Dut_clean_buffer(dut2_fd);


    // Uptest(white list) config
	COMM_INI_Connection_Setup_White_Listed_Config(dut2, &g_pattern_param);
    memcpy(g_pattern_param.white_list_param.Address, scan_addr, ADDR_LENGTH);
    g_pattern_param.white_list_param.Address_Type[0] = HCI_CMD_PARAM_PUBLIC_DEVICE_ADDRESS;
    verdict = COMM_INI_Connection_Setup_White_Listed(dut2_fd, g_pattern_param);
    VERDICT_RESULT_WITH_LINE();

	COMM_ADV_Directed_Advertising_Config(HCI_CMD_PARAM_ADV_DATA_LEN_MAX, &g_pattern_param);
    g_pattern_param.adv_param.Advertising_Filter_Policy[0] = HCI_CMD_PARAM_ALLOW_SCAN_REQ_FROM_WHITELIST_ONLY_AND_CONN_REQ_FROM_WHITELIST_ONLY;
	g_pattern_param.adv_param.Advertising_Interval_Max[0] = 0x00a0 & 0x00ff;
    g_pattern_param.adv_param.Advertising_Interval_Max[1] = (0x00a0 & 0xff00) >> 8;
    g_pattern_param.adv_param.Advertising_Interval_Min[0] = 0x00a0 & 0x00ff;
    g_pattern_param.adv_param.Advertising_Interval_Min[1] = (0x00a0 & 0xff00) >> 8;
	if(37 == adv_Channel) {
        g_pattern_param.adv_param.Advertising_Channel_Map[0] = HCI_CMD_PARAM_ENABLE_CHANNEL_37;
    }
    else if(38 == adv_Channel) {
        g_pattern_param.adv_param.Advertising_Channel_Map[0] = HCI_CMD_PARAM_ENABLE_CHANNEL_38;
    }
    else {
        g_pattern_param.adv_param.Advertising_Channel_Map[0] = HCI_CMD_PARAM_ENABLE_CHANNEL_39;
    }
	verdict = COMM_ADV_Directed_Advertising(dut2_fd, g_pattern_param);
	VERDICT_RESULT_WITH_LINE();

	COMM_INI_Initiating_Config(dut1, &g_pattern_param);
    memcpy(g_pattern_param.create_conn_param.Peer_Address, adv_addr, ADDR_LENGTH);
	verdict = COMM_INI_Initiating(dut1_fd, g_pattern_param);
	VERDICT_RESULT_WITH_LINE();

	event_query_timer_config(5, 0, 0, 0, &timer);
	event_query_timer_start(timer, read_le_event_enable);

	while(1)//waiting adv report event , timer or counter
	{
		if (1 == read_le_event_get()) {
            read_le_event_disable();
            
			if (SUCCESS != QUERY_LE_Event(dut1_fd, buf,	_BT_HCI_LE_EVENT_SUB_OP_CONNECTION_COMPLETE_, 0)) {
				line = __LINE__;
				goto FUN_FAIL;
			}

			if(SUCCESS != hci_le_event_connection_complete_parsing(0, buf, g_pattern_param)) {
				line = __LINE__;
				goto FUN_FAIL;
			}

			conn_handles_mas[0] = buf[_BT_HCI_EVT_CON_COMP_CONN_HANDLE+0];
			conn_handles_mas[1] = buf[_BT_HCI_EVT_CON_COMP_CONN_HANDLE+1];

			if (SUCCESS != QUERY_LE_Event(dut2_fd, buf,	_BT_HCI_LE_EVENT_SUB_OP_CONNECTION_COMPLETE_, 0)) {
				line = __LINE__;
				goto FUN_FAIL;
			}

			if(SUCCESS != hci_le_event_connection_complete_parsing(0, buf, g_pattern_param)) {
				line = __LINE__;
				goto FUN_FAIL;
			}

			//######################################
			for( ;test_cnt1 > 0; test_cnt1--) {
				COMM_Send_ACL_Data_Without_event(dut1_fd, conn_handles_mas, 0b00, 0, 10, acl_data);
PKT_CHK1:
                // # check disconnection             
                CHECK_NON_DISCONNECT();

                if(SUCCESS != QUERY_Event(dut1_fd, buf, _BT_HCI_EVENT_OP_NUMBER_OF_COMPLETED_PACKETS_)) {
                    line = __LINE__;
                    goto FUN_FAIL;
                }
                else if(1 != hci_event_num_of_completed_packets_parsing(buf)) {

                    MSLEEP(100);

                    mas_pkt_chk ++ ;
                    if (mas_pkt_chk == 100){
                        printf("mas no number of completed pkts\n");
                        line = __LINE__;
                        goto FUN_FAIL;                  
                    }

                    goto PKT_CHK1;
                } 

                mas_pkt_chk = 0 ;
                
                printf("case 1, channel : %d, ACL_Data = 0b00, Test_Cnt = %d\n", adv_Channel, test_cnt1);
			}

            //step2 ~ 4
			if(SUCCESS != QUERY_Acl_Data(dut2_fd,buf))	{
				line = __LINE__;
				goto FUN_FAIL;
			}

			if(0b10 != (buf[_BT_HCI_IDX_ACL_DATA_CONN_HANDLE_+1] & 0xF0 ) >> 4) {
				line = __LINE__;
				goto FUN_FAIL;
			}
			//######################################
			for( ;test_cnt2 > 0; test_cnt2--) {
				COMM_Send_ACL_Data_Without_event(dut1_fd, conn_handles_mas, 0b01, 0, 10, acl_data);
PKT_CHK2:
                // # check disconnection             
                CHECK_NON_DISCONNECT();
    
                if(SUCCESS != QUERY_Event(dut1_fd, buf, _BT_HCI_EVENT_OP_NUMBER_OF_COMPLETED_PACKETS_)) {
                    line = __LINE__;
                    goto FUN_FAIL;
                }
                else if(1 != hci_event_num_of_completed_packets_parsing(buf)) {

                    MSLEEP(100);

                    mas_pkt_chk ++ ;
                    if (mas_pkt_chk == 100){
                        printf("mas no number of completed pkts\n");

                        line = __LINE__;
                        goto FUN_FAIL;                  
                    }
                    
                    goto PKT_CHK2;
                } 

                mas_pkt_chk = 0 ;
                
                printf("case 2, channel : %d, ACL_Data = 0b01, Test_Cnt = %d\n", adv_Channel, test_cnt2);
			}

			if(SUCCESS != QUERY_Acl_Data(dut2_fd, buf))	{
				line = __LINE__;
				goto FUN_FAIL;
			}

			if(0x01 != (buf[_BT_HCI_IDX_ACL_DATA_CONN_HANDLE_+1] & 0xF0 ) >> 4) {
				line = __LINE__;
				goto FUN_FAIL;
			}
			//######################################
			COMM_Send_ACL_Data_Without_event(dut1_fd, conn_handles_mas, 0b00, 0, 10, acl_data);
PKT_CHK3:
            // # check disconnection             
            CHECK_NON_DISCONNECT();
    
            if(SUCCESS != QUERY_Event(dut1_fd, buf, _BT_HCI_EVENT_OP_NUMBER_OF_COMPLETED_PACKETS_)) {
                line = __LINE__;
                goto FUN_FAIL;
            }
            else if(1 != hci_event_num_of_completed_packets_parsing(buf)) {

                MSLEEP(100);

                mas_pkt_chk ++ ;
                if (mas_pkt_chk == 100){
                    printf("mas no number of completed pkts\n");

                    line = __LINE__;
                    goto FUN_FAIL;                  
                }
                
                goto PKT_CHK3;
            } 

            mas_pkt_chk = 0 ;

            printf("case 3, channel : %d, ACL_Data = 0b01, Test_Cnt = %d\n", adv_Channel, test_cnt2);


			if (SUCCESS != QUERY_Acl_Data(dut2_fd, buf)) {
				line = __LINE__;
				goto FUN_FAIL;
			}

			if (0b10 != (buf[_BT_HCI_IDX_ACL_DATA_CONN_HANDLE_+1] & 0xF0 ) >> 4) {
				line = __LINE__;
				goto FUN_FAIL;
			}
			//######################################
			for ( ;test_cnt3 > 0; test_cnt3--) {
				COMM_Send_ACL_Data_Without_event(dut1_fd, conn_handles_mas, 0b01, 0, 10, acl_data);
PKT_CHK4:
                // # check disconnection             
                CHECK_NON_DISCONNECT();

                if(SUCCESS != QUERY_Event(dut1_fd, buf, _BT_HCI_EVENT_OP_NUMBER_OF_COMPLETED_PACKETS_)) {
                    line = __LINE__;
                    goto FUN_FAIL;
                }
                else if(1 != hci_event_num_of_completed_packets_parsing(buf)) {

                    MSLEEP(100);
                
                    mas_pkt_chk ++ ;
                    if (mas_pkt_chk == 100){
                        printf("mas no number of completed pkts\n");
                
                        line = __LINE__;
                        goto FUN_FAIL;                  
                    }
                    
                    goto PKT_CHK4;
                } 
                
                mas_pkt_chk = 0 ;
                
                printf("case 4, channel : %d, ACL_Data = 0b00, Test_Cnt = %d\n", adv_Channel, test_cnt3);
			}
			if (SUCCESS != QUERY_Acl_Data(dut2_fd, buf)) {
				line = __LINE__;
				goto FUN_FAIL;
			}

			if (0b01 != (buf[_BT_HCI_IDX_ACL_DATA_CONN_HANDLE_+1] & 0xF0 ) >> 4) {
				line = __LINE__;
				goto FUN_FAIL;
			}
			//######################################

			for ( ;test_cnt4 > 0; test_cnt4--) {
				COMM_Send_ACL_Data_Without_event(dut1_fd, conn_handles_mas, 0b01, 0, 23, acl_data2);
PKT_CHK5:
                // # check disconnection             
                CHECK_NON_DISCONNECT();

                if(SUCCESS != QUERY_Event(dut1_fd, buf, _BT_HCI_EVENT_OP_NUMBER_OF_COMPLETED_PACKETS_)) {
                    line = __LINE__;
                    goto FUN_FAIL;
                }
                else if(1 != hci_event_num_of_completed_packets_parsing(buf)) {

                    MSLEEP(100);
                
                    mas_pkt_chk ++ ;
                    if (mas_pkt_chk == 100){
                        printf("mas no number of completed pkts\n");
                
                        line = __LINE__;
                        goto FUN_FAIL;                  
                    }
                    
                    goto PKT_CHK5;
                } 
                
                mas_pkt_chk = 0 ;
                
                printf("case 5, channel : %d, ACL_Data = 0b01, Test_Cnt = %d\n", adv_Channel, test_cnt4);
			}

			if (SUCCESS != QUERY_Acl_Data(dut2_fd, buf)) {
				line = __LINE__;
				goto FUN_FAIL;
			}

			if (0x01 != (buf[_BT_HCI_IDX_ACL_DATA_CONN_HANDLE_+1] & 0xF0 ) >> 4) {
				line = __LINE__;
				goto FUN_FAIL;
			}
            if(adv_Channel != 39){        
                adv_Channel ++;				
				//COMM_Reset(dut1_fd);
				//COMM_Reset(dut2_fd);
				dut_reset_with_mask_en(dut1_fd);
				dut_reset_with_mask_en(dut2_fd);
                goto REPEAT;
            }
			//COMM_Reset(dut1_fd);
			//COMM_Reset(dut2_fd);
			dut_reset_with_mask_en(dut1_fd);
			dut_reset_with_mask_en(dut2_fd);

            FUNC_END();
			LOG_INFO("[Pattern][%s]SUCCESS\n", __FUNCTION__);
			return PASS;
		}
	}

FUN_FAIL:
	LOG_INFO("[Pattern][%s]:%d channel : %d FAIL!!\n" , __FUNCTION__, line, adv_Channel);
    return FAIL;
}


// 5.4.1.3
verdict CON_MAS_Master_Receiving_Data(u8 dut1_fd ,u8 dut2_fd)
{
	u8 buf[SOCKET_BUF_SIZE];
	int verdict = FAIL;
	int dut1 = 0;
    int dut2 = 0;
    u16 line = 0;
	struct itimerval timer;
	u8 conn_handles_sla[2];
	u8 acl_data[10] = {0};
	u8 test_Times = 100;
    u8 test_cnt1 = 0;
    u8 test_cnt2 = 0;
    u8 test_cnt3 = 0;    
    int adv_Channel = 37;   
    int mas_pkt_chk = 0 ;
    
	Calculate_Execution_Time_Start();
REPEAT:
    test_cnt1 = test_Times;
    test_cnt2 = test_Times;
    test_cnt3 = test_Times;   

    COMM_Dut_clean_buffer(dut1_fd);
    COMM_Dut_clean_buffer(dut2_fd);

    // Uptest(white list) config
	COMM_INI_Connection_Setup_White_Listed_Config(dut2, &g_pattern_param);
    memcpy(g_pattern_param.white_list_param.Address, scan_addr, ADDR_LENGTH);
    g_pattern_param.white_list_param.Address_Type[0] = HCI_CMD_PARAM_PUBLIC_DEVICE_ADDRESS;
    verdict = COMM_INI_Connection_Setup_White_Listed(dut2_fd, g_pattern_param);
    VERDICT_RESULT_WITH_LINE();

    COMM_ADV_Directed_Advertising_Config(HCI_CMD_PARAM_ADV_DATA_LEN_MAX, &g_pattern_param);
	g_pattern_param.adv_param.Advertising_Filter_Policy[0] = HCI_CMD_PARAM_ALLOW_SCAN_REQ_FROM_WHITELIST_ONLY_AND_CONN_REQ_FROM_WHITELIST_ONLY;
	g_pattern_param.adv_param.Advertising_Interval_Max[0] = 0x00a0 & 0x00ff;
    g_pattern_param.adv_param.Advertising_Interval_Max[1] = (0x00a0 & 0xff00) >> 8;
    g_pattern_param.adv_param.Advertising_Interval_Min[0] = 0x00a0 & 0x00ff;
    g_pattern_param.adv_param.Advertising_Interval_Min[1] = (0x00a0 & 0xff00) >> 8;
	if(37 == adv_Channel) {
        g_pattern_param.adv_param.Advertising_Channel_Map[0] = HCI_CMD_PARAM_ENABLE_CHANNEL_37;
    }
    else if(38 == adv_Channel) {
        g_pattern_param.adv_param.Advertising_Channel_Map[0] = HCI_CMD_PARAM_ENABLE_CHANNEL_38;
    }
    else {
        g_pattern_param.adv_param.Advertising_Channel_Map[0] = HCI_CMD_PARAM_ENABLE_CHANNEL_39;
    }
	verdict = COMM_ADV_Directed_Advertising(dut2_fd, g_pattern_param);
	VERDICT_RESULT_WITH_LINE();

	COMM_INI_Initiating_Config(dut1, &g_pattern_param);
    memcpy(g_pattern_param.create_conn_param.Peer_Address, adv_addr, ADDR_LENGTH);
    verdict = COMM_INI_Initiating(dut1_fd, g_pattern_param);
	VERDICT_RESULT_WITH_LINE();

	event_query_timer_config(5, 0, 0, 0, &timer);
	event_query_timer_start(timer, read_le_event_enable);

    //waiting adv report event , timer or counter
	while(1) {
		if(1 == read_le_event_get()) {
			read_le_event_disable();

			if(SUCCESS != QUERY_LE_Event(dut1_fd, buf,	_BT_HCI_LE_EVENT_SUB_OP_CONNECTION_COMPLETE_, 0)) {
				line = __LINE__;
				goto FUN_FAIL;
			}

			if(SUCCESS != hci_le_event_connection_complete_parsing(0, buf, g_pattern_param)) {
				line = __LINE__;
				goto FUN_FAIL;
			}


			if(SUCCESS != QUERY_LE_Event(dut2_fd, buf, _BT_HCI_LE_EVENT_SUB_OP_CONNECTION_COMPLETE_, 0)) {
				line = __LINE__;
				goto FUN_FAIL;
			}

			if(SUCCESS != hci_le_event_connection_complete_parsing(0, buf, g_pattern_param)) {
				line = __LINE__;
				goto FUN_FAIL;
			}
			conn_handles_sla[0]=buf[_BT_HCI_EVT_CON_COMP_CONN_HANDLE+0];
			conn_handles_sla[1]=buf[_BT_HCI_EVT_CON_COMP_CONN_HANDLE+1];

            //######################################
            //step1
			for( ;test_cnt1 > 0; test_cnt1--) {
				COMM_Send_ACL_Data_Without_event(dut2_fd, conn_handles_sla, 0b00, 0, 10, acl_data);
PKT_CHK1:
                // # check disconnection             
                CHECK_NON_DISCONNECT();

                if(SUCCESS != QUERY_Event(dut2_fd, buf, _BT_HCI_EVENT_OP_NUMBER_OF_COMPLETED_PACKETS_)) {
                    line = __LINE__;
                    goto FUN_FAIL;
                }
                else if(1 != hci_event_num_of_completed_packets_parsing(buf)) {

                    MSLEEP(100);
                
                    mas_pkt_chk ++ ;
                    if (mas_pkt_chk == 100){
                        printf("mas no number of completed pkts\n");
                
                        line = __LINE__;
                        goto FUN_FAIL;                  
                    }
                    
                    goto PKT_CHK1;
                } 
                
                mas_pkt_chk = 0 ;

                printf("case 1, channel : %d, ACL_Data = 0b00, Test_Cnt = %d\n", adv_Channel, test_cnt1);
			}
            //step2 ~ 4
			if(SUCCESS != QUERY_Acl_Data(dut1_fd, buf)) {
				line = __LINE__;
				goto FUN_FAIL;
			}

			if(0b10 != (buf[_BT_HCI_IDX_ACL_DATA_CONN_HANDLE_+1] & 0xF0 ) >> 4) {
				line = __LINE__;
				goto FUN_FAIL;
			}
            //######################################
			for( ;test_cnt2 > 0; test_cnt2--)//step5
			{
				COMM_Send_ACL_Data_Without_event(dut2_fd, conn_handles_sla, 0b01, 0, 10, acl_data);
PKT_CHK2:
                // # check disconnection             
                CHECK_NON_DISCONNECT();

                if(SUCCESS != QUERY_Event(dut2_fd, buf, _BT_HCI_EVENT_OP_NUMBER_OF_COMPLETED_PACKETS_)) {
                    line = __LINE__;
                    goto FUN_FAIL;
                }
                else if(1 != hci_event_num_of_completed_packets_parsing(buf)) {

                    MSLEEP(100);
                
                    mas_pkt_chk ++ ;
                    if (mas_pkt_chk == 100){
                        printf("mas no number of completed pkts\n");
                
                        line = __LINE__;
                        goto FUN_FAIL;                  
                    }
                    
                    goto PKT_CHK2;
                } 
                
                mas_pkt_chk = 0 ;

                printf("case 2, channel : %d, ACL_Data = 0b01, Test_Cnt = %d\n", adv_Channel, test_cnt2);
            }
            //step7
			if(SUCCESS != QUERY_Acl_Data(dut1_fd, buf)) {
				line = __LINE__;
				goto FUN_FAIL;
			}

			if(0b01 != (buf[_BT_HCI_IDX_ACL_DATA_CONN_HANDLE_+1] & 0xF0) >> 4)	{
				line = __LINE__;
				goto FUN_FAIL;
			}
            //######################################
			COMM_Send_ACL_Data_Without_event(dut2_fd, conn_handles_sla, 0b01, 0, 10, acl_data);
PKT_CHK3:
            // # check disconnection             
            CHECK_NON_DISCONNECT();

            if(SUCCESS != QUERY_Event(dut2_fd, buf, _BT_HCI_EVENT_OP_NUMBER_OF_COMPLETED_PACKETS_)) {
                line = __LINE__;
                goto FUN_FAIL;
            }
            else if(1 != hci_event_num_of_completed_packets_parsing(buf)) {

                MSLEEP(100);
            
                mas_pkt_chk ++ ;
                if (mas_pkt_chk == 100){
                    printf("mas no number of completed pkts\n");
            
                    line = __LINE__;
                    goto FUN_FAIL;                  
                }
                
                goto PKT_CHK3;
            } 
            
            mas_pkt_chk = 0 ;


            printf("case 3, channel : %d, ACL_Data = 0b01\n", adv_Channel);
            //step7
			if(SUCCESS != QUERY_Acl_Data(dut1_fd,buf)) {
				line = __LINE__;
				goto FUN_FAIL;
			}

			if(0b01 != (buf[_BT_HCI_IDX_ACL_DATA_CONN_HANDLE_+1] & 0xF0 ) >> 4) {
				line = __LINE__;
				goto FUN_FAIL;
			}
            //######################################
			for( ;test_cnt3 > 0; test_cnt3--) {
				COMM_Send_ACL_Data_Without_event(dut2_fd, conn_handles_sla, 0b01, 0, 10, acl_data);
PKT_CHK4:
                // # check disconnection             
                CHECK_NON_DISCONNECT();

                if(SUCCESS != QUERY_Event(dut2_fd, buf, _BT_HCI_EVENT_OP_NUMBER_OF_COMPLETED_PACKETS_)) {
                    line = __LINE__;
                    goto FUN_FAIL;
                }
                else if(1 != hci_event_num_of_completed_packets_parsing(buf)) {

                    MSLEEP(100);
                
                    mas_pkt_chk ++ ;
                    if (mas_pkt_chk == 100){
                        printf("mas no number of completed pkts\n");
                
                        line = __LINE__;
                        goto FUN_FAIL;                  
                    }
                    
                    goto PKT_CHK4;
                } 
                
                mas_pkt_chk = 0 ;

                printf("case 4, channel : %d, ACL_Data = 0b01, Test_Cnt = %d\n", adv_Channel, test_cnt3);
			}

			if(SUCCESS != QUERY_Acl_Data(dut1_fd, buf)) {
				line = __LINE__;
				goto FUN_FAIL;
			}

			if(0b01 != (buf[_BT_HCI_IDX_ACL_DATA_CONN_HANDLE_+1] & 0xF0 ) >> 4) {
				line = __LINE__;
				goto FUN_FAIL;
			}

            if(adv_Channel != 39){        
                adv_Channel ++;				
				//COMM_Reset(dut1_fd);
				//COMM_Reset(dut2_fd);
				dut_reset_with_mask_en(dut1_fd);
				dut_reset_with_mask_en(dut2_fd);
                goto REPEAT;
            }
			//COMM_Reset(dut1_fd);
			//COMM_Reset(dut2_fd);
			dut_reset_with_mask_en(dut1_fd);
			dut_reset_with_mask_en(dut2_fd);
            FUNC_END();
			LOG_INFO("[Pattern][%s]SUCCESS\n", __FUNCTION__);
			return PASS;
		}
	}

FUN_FAIL:
	LOG_INFO("[Pattern][%s]:%d FAIL\n" ,__FUNCTION__,line);
    return FAIL;

}


// 5.4.1.4
verdict CON_MAS_Master_Sending_and_Receiving_Data(u8 dut1_fd ,u8 dut2_fd)
{
    u8 buf[SOCKET_BUF_SIZE];
    int verdict =FAIL;
	int dut1 = 0;
    int dut2 = 0;
	u16 line = 0;
	struct itimerval timer;
	u8 conn_handles_mas[2];
	u8 conn_handles_sla[2];
	u8 acl_data[10] = {0};
	u8 acl_data2[10] = {0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF};
	u8 test_Times = 100;
    u8 test_cnt1 = 0;
    u8 test_cnt2 = 0;    
    int adv_Channel = 37;
    int mas_pkt_chk = 0;
    
REPEAT:
    test_cnt1 = test_Times;
    test_cnt2 = test_Times;    

    COMM_Dut_clean_buffer(dut1_fd);
    COMM_Dut_clean_buffer(dut2_fd);

    // Uptest(white list) config
	COMM_INI_Connection_Setup_White_Listed_Config(dut2, &g_pattern_param);
    memcpy(g_pattern_param.white_list_param.Address, scan_addr, ADDR_LENGTH);
    g_pattern_param.white_list_param.Address_Type[0] = HCI_CMD_PARAM_PUBLIC_DEVICE_ADDRESS;
    verdict = COMM_INI_Connection_Setup_White_Listed(dut2_fd, g_pattern_param);
    VERDICT_RESULT_WITH_LINE();

	COMM_ADV_Directed_Advertising_Config(HCI_CMD_PARAM_ADV_DATA_LEN_MAX, &g_pattern_param);
	g_pattern_param.adv_param.Advertising_Filter_Policy[0] = HCI_CMD_PARAM_ALLOW_SCAN_REQ_FROM_WHITELIST_ONLY_AND_CONN_REQ_FROM_WHITELIST_ONLY;
	g_pattern_param.adv_param.Advertising_Interval_Max[0] = 0x00a0 & 0x00ff;
    g_pattern_param.adv_param.Advertising_Interval_Max[1] = (0x00a0 & 0xff00) >> 8;
    g_pattern_param.adv_param.Advertising_Interval_Min[0] = 0x00a0 & 0x00ff;
    g_pattern_param.adv_param.Advertising_Interval_Min[1] = (0x00a0 & 0xff00) >> 8;
	if(37 == adv_Channel) {
        g_pattern_param.adv_param.Advertising_Channel_Map[0] = HCI_CMD_PARAM_ENABLE_CHANNEL_37;
    }
    else if(38 == adv_Channel) {
        g_pattern_param.adv_param.Advertising_Channel_Map[0] = HCI_CMD_PARAM_ENABLE_CHANNEL_38;
    }
    else {
        g_pattern_param.adv_param.Advertising_Channel_Map[0] = HCI_CMD_PARAM_ENABLE_CHANNEL_39;
    }
	verdict = COMM_ADV_Directed_Advertising(dut2_fd, g_pattern_param);
	VERDICT_RESULT_WITH_LINE();

	COMM_INI_Initiating_Config(dut1, &g_pattern_param);
    memcpy(g_pattern_param.create_conn_param.Peer_Address, adv_addr, ADDR_LENGTH);
    verdict = COMM_INI_Initiating(dut1_fd, g_pattern_param);
	VERDICT_RESULT_WITH_LINE();

	event_query_timer_config(5, 0, 0, 0, &timer);
	event_query_timer_start(timer, read_le_event_enable);

    //waiting adv report event , timer or counter
    while(1) {
        if(1 == read_le_event_get()) {
            read_le_event_disable();

            if(SUCCESS != QUERY_LE_Event(dut1_fd, buf, _BT_HCI_LE_EVENT_SUB_OP_CONNECTION_COMPLETE_, 0)) {
                line = __LINE__;
                goto FUN_FAIL;
            }

            if(SUCCESS != hci_le_event_connection_complete_parsing(0, buf, g_pattern_param)) {
                line = __LINE__;
                goto FUN_FAIL;
            }

            conn_handles_mas[0] = buf[_BT_HCI_EVT_COMP_HANDLE+0];
            conn_handles_mas[1] = buf[_BT_HCI_EVT_COMP_HANDLE+1];

            if(SUCCESS != QUERY_LE_Event(dut2_fd, buf, _BT_HCI_LE_EVENT_SUB_OP_CONNECTION_COMPLETE_, 0)) {
                line = __LINE__;
                goto FUN_FAIL;
            }

            if(SUCCESS != hci_le_event_connection_complete_parsing(0, buf, g_pattern_param)) {
                line = __LINE__;
                goto FUN_FAIL;
            }

            conn_handles_sla[0] = buf[_BT_HCI_EVT_COMP_HANDLE+0];
            conn_handles_sla[1] = buf[_BT_HCI_EVT_COMP_HANDLE+1];

            //######################################
            for(;test_cnt1 > 0; test_cnt1--) {
                COMM_Send_ACL_Data_Without_event(dut1_fd, conn_handles_mas, 0b00, 0, 10, acl_data);
PKT_CHK1:
                // # check disconnection             
                CHECK_NON_DISCONNECT();

                if(SUCCESS != QUERY_Event(dut1_fd, buf, _BT_HCI_EVENT_OP_NUMBER_OF_COMPLETED_PACKETS_)) {
                    line = __LINE__;
                    goto FUN_FAIL;
                }
                else if(1 != hci_event_num_of_completed_packets_parsing(buf)) {

                    MSLEEP(100);

                    mas_pkt_chk ++ ;
                    if (mas_pkt_chk == 100){
                        printf("mas no number of completed pkts\n");

                        line = __LINE__;
                        goto FUN_FAIL;                  
                    }

                    goto PKT_CHK1;
                } 

                mas_pkt_chk = 0 ;


                usleep(SLEEP_MS);

                if(SUCCESS != QUERY_Acl_Data(dut2_fd, buf)) {
                    line = __LINE__;
                    goto FUN_FAIL;
                }

                if(0b10 != (buf[_BT_HCI_IDX_ACL_DATA_CONN_HANDLE_+1] & 0xF0 ) >> 4) {
                    line = __LINE__;
                    goto FUN_FAIL;
                }

                COMM_Send_ACL_Data_Without_event(dut2_fd, conn_handles_sla, 0b00, 0, 10, acl_data2);
PKT_CHK2:
                // # check disconnection             
                CHECK_NON_DISCONNECT();

                if(SUCCESS != QUERY_Event(dut2_fd, buf, _BT_HCI_EVENT_OP_NUMBER_OF_COMPLETED_PACKETS_)) {
                    line = __LINE__;
                    goto FUN_FAIL;
                }
                else if(1 != hci_event_num_of_completed_packets_parsing(buf)) {

                    MSLEEP(100);

                    mas_pkt_chk ++ ;
                    if (mas_pkt_chk == 100){
                        printf("mas no number of completed pkts\n");

                        line = __LINE__;
                        goto FUN_FAIL;                  
                    }

                    goto PKT_CHK2;
                } 

                mas_pkt_chk = 0 ;


                usleep(SLEEP_MS);

                if(SUCCESS != QUERY_Acl_Data(dut1_fd, buf)) {
                    line = __LINE__;
                    goto FUN_FAIL;
                }

                if(0b10 != (buf[_BT_HCI_IDX_ACL_DATA_CONN_HANDLE_ + 1] & 0xF0 ) >> 4) {
                    line = __LINE__;
                    goto FUN_FAIL;
                }
            }
#if 0
            if(adv_Channel != 39){        
                adv_Channel ++;				
                //COMM_Reset(dut1_fd);
                //COMM_Reset(dut2_fd);
                dut_reset_with_mask_en(dut1_fd);
                dut_reset_with_mask_en(dut2_fd);
                goto REPEAT;
            }
#endif
            buf[_BT_HCI_EVT_CON_COMP_CONN_HANDLE+0] = conn_handles_mas[0];
            buf[_BT_HCI_EVT_CON_COMP_CONN_HANDLE+1] = conn_handles_mas[1];

            COMM_Disconnect_Config(dut1,&g_pattern_param,buf);
            verdict=COMM_Disconnect(dut1_fd,g_pattern_param);
            VERDICT_RESULT_WITH_LINE();

            FUNC_END();
            LOG_INFO("[Pattern][%s]SUCCESS\n", __FUNCTION__);
            return PASS;
        }
    }

FUN_FAIL:
    FUNC_END();
    LOG_INFO("[Pattern][%s]:%d FAIL\n" ,__FUNCTION__,line);
    return FAIL;

}

// 5.4.1.5
verdict CON_MAS_Events_With_Slave_Latency(u8 dut1_fd ,u8 dut2_fd)
{
	u8 buf[SOCKET_BUF_SIZE];
	int verdict = FAIL;
	int dut1 = 0;
    int dut2 = 0;
	u16 line = 0 ;
	struct itimerval timer;
	u8 conn_handles_mas[2];
	u8 conn_handles_sla[2];
	u8 acl_data[4] = {0xFF, 0xFF, 0xFF, 0xFF};
	u8 acl_data2[32] = {0};
    u8 test_Times = 60;
    u8 test_cnt1 = 0;
    u8 test_cnt2 = 0;
    u8 test_cnt3 = 0;
    u8 test_cnt4 = 0;
    int adv_Channel = 37;

    int mas_pkt_chk = 0 ;

	Calculate_Execution_Time_Start();
REPEAT:
    test_cnt1 = test_Times;
    test_cnt2 = test_Times;
    test_cnt3 = test_Times;
    test_cnt4 = test_Times;

    COMM_Dut_clean_buffer(dut1_fd);
    COMM_Dut_clean_buffer(dut2_fd);


    // Uptest(white list) config
	COMM_INI_Connection_Setup_White_Listed_Config(dut2, &g_pattern_param);
    memcpy(g_pattern_param.white_list_param.Address, scan_addr, ADDR_LENGTH);
    g_pattern_param.white_list_param.Address_Type[0] = HCI_CMD_PARAM_PUBLIC_DEVICE_ADDRESS;
    verdict = COMM_INI_Connection_Setup_White_Listed(dut2_fd, g_pattern_param);
    VERDICT_RESULT_WITH_LINE();

	COMM_ADV_Directed_Advertising_Config(HCI_CMD_PARAM_ADV_DATA_LEN_MAX, &g_pattern_param);
    g_pattern_param.adv_param.Advertising_Filter_Policy[0] = HCI_CMD_PARAM_ALLOW_SCAN_REQ_FROM_WHITELIST_ONLY_AND_CONN_REQ_FROM_WHITELIST_ONLY;
	g_pattern_param.adv_param.Advertising_Interval_Max[0] = 0x00a0 & 0x00ff;
    g_pattern_param.adv_param.Advertising_Interval_Max[1] = (0x00a0 & 0xff00) >> 8;
    g_pattern_param.adv_param.Advertising_Interval_Min[0] = 0x00a0 & 0x00ff;
    g_pattern_param.adv_param.Advertising_Interval_Min[1] = (0x00a0 & 0xff00) >> 8;
	if(37 == adv_Channel) {
        g_pattern_param.adv_param.Advertising_Channel_Map[0] = HCI_CMD_PARAM_ENABLE_CHANNEL_37;
    }
    else if(38 == adv_Channel) {
        g_pattern_param.adv_param.Advertising_Channel_Map[0] = HCI_CMD_PARAM_ENABLE_CHANNEL_38;
    }
    else {
        g_pattern_param.adv_param.Advertising_Channel_Map[0] = HCI_CMD_PARAM_ENABLE_CHANNEL_39;
    }
	verdict = COMM_ADV_Directed_Advertising(dut2_fd, g_pattern_param);
	VERDICT_RESULT_WITH_LINE();

	COMM_INI_Initiating_Config(dut1, &g_pattern_param);
    memcpy(g_pattern_param.create_conn_param.Peer_Address, adv_addr, ADDR_LENGTH);

    g_pattern_param.create_conn_param.Conn_Interval_Min[0]       =   26; //HCI_CMD_PARAM_CONN_INT_MIN & 0x00ff;
    g_pattern_param.create_conn_param.Conn_Interval_Min[1]       =   0;//(HCI_CMD_PARAM_CONN_INT_MIN & 0xff00)   >> 8;
    g_pattern_param.create_conn_param.Conn_Interval_Max[0]       =   26;
    g_pattern_param.create_conn_param.Conn_Interval_Max[1]       =   0;
    g_pattern_param.create_conn_param.Conn_Latency[0]            =   5;//HCI_CMD_PARAM_CONN_LATENCY_MIN;//HCI_CMD_PARAM_CONN_LATENCY_MAX & 0x00ff;
    g_pattern_param.create_conn_param.Conn_Latency[1]            =   0;//HCI_CMD_PARAM_CONN_LATENCY_MIN;//(HCI_CMD_PARAM_CONN_LATENCY_MAX & 0xff00)  >> 8;
    //The Supervision_Timeout in milliseconds shall be larger than the Conn_Interval_Max in milliseconds.
    //superviision TO > (1+connSlaveLatency)*Conninterval
    g_pattern_param.create_conn_param.Supervision_Timeout[0]     =   0x80 ; //=0xD0;
    g_pattern_param.create_conn_param.Supervision_Timeout[1]     =   0x0c ; //=0x07;



	verdict = COMM_INI_Initiating(dut1_fd, g_pattern_param);
	VERDICT_RESULT_WITH_LINE();

	event_query_timer_config(5, 0, 0, 0, &timer);
	event_query_timer_start(timer, read_le_event_enable);

	while(1)//waiting adv report event , timer or counter
	{
		if (1 == read_le_event_get()) {
            read_le_event_disable();

			if (SUCCESS != QUERY_LE_Event(dut1_fd, buf,	_BT_HCI_LE_EVENT_SUB_OP_CONNECTION_COMPLETE_, 0)) {
				line = __LINE__;
				goto FUN_FAIL;
			}

			if(SUCCESS != hci_le_event_connection_complete_parsing(0, buf, g_pattern_param)) {
				line = __LINE__;
				goto FUN_FAIL;
			}

			conn_handles_mas[0] = buf[_BT_HCI_EVT_CON_COMP_CONN_HANDLE+0];
			conn_handles_mas[1] = buf[_BT_HCI_EVT_CON_COMP_CONN_HANDLE+1];

			if (SUCCESS != QUERY_LE_Event(dut2_fd, buf,	_BT_HCI_LE_EVENT_SUB_OP_CONNECTION_COMPLETE_, 0)) {
				line = __LINE__;
				goto FUN_FAIL;
			}

			if(SUCCESS != hci_le_event_connection_complete_parsing(0, buf, g_pattern_param)) {
				line = __LINE__;
				goto FUN_FAIL;
			}

			conn_handles_sla[0] = buf[_BT_HCI_EVT_CON_COMP_CONN_HANDLE+0];
			conn_handles_sla[1] = buf[_BT_HCI_EVT_CON_COMP_CONN_HANDLE+1];

			//######################################
			for( ;test_cnt1 > 0; test_cnt1--) {
				COMM_Send_ACL_Data_Without_event(dut1_fd, conn_handles_mas, 0b00, 0, sizeof(acl_data), acl_data);
                if (0 == (test_cnt1%3)) {
    				COMM_Send_ACL_Data_Without_event(dut2_fd, conn_handles_sla, 0b00, 0, sizeof(acl_data), acl_data);
                }
#if 1
PKT_CHK1:
                // # check disconnection
                //CHECK_NON_DISCONNECT();

                if(SUCCESS != QUERY_Event(dut1_fd, buf, _BT_HCI_EVENT_OP_NUMBER_OF_COMPLETED_PACKETS_)) {
                    line = __LINE__;
                    goto FUN_FAIL;
                }
                else if(1 != hci_event_num_of_completed_packets_parsing(buf)) {

                    MSLEEP(100);

                    mas_pkt_chk ++ ;
                    if (mas_pkt_chk == 100){
                        printf("mas no number of completed pkts\n");
                        line = __LINE__;
                        goto FUN_FAIL;
                    }

                    goto PKT_CHK1;
                }

                mas_pkt_chk = 0 ;

                //printf("case 1, channel : %d, ACL_Data = 0b00, Test_Cnt = %d\n", adv_Channel, test_cnt1);
#endif
			}

            //step2 ~ 4
			if(SUCCESS != QUERY_Acl_Data(dut2_fd,buf))	{
				line = __LINE__;
				goto FUN_FAIL;
			}

			if(0b10 != (buf[_BT_HCI_IDX_ACL_DATA_CONN_HANDLE_+1] & 0xF0 ) >> 4) {
				line = __LINE__;
				goto FUN_FAIL;
			}
			//COMM_Reset(dut1_fd);
			//COMM_Reset(dut2_fd);
			dut_reset_with_mask_en(dut1_fd);
			dut_reset_with_mask_en(dut2_fd);

            FUNC_END();
			LOG_INFO("[Pattern][%s]SUCCESS\n", __FUNCTION__);
			return PASS;
		}
	}

FUN_FAIL:
	LOG_INFO("[Pattern][%s]:%d channel : %d FAIL!!\n" , __FUNCTION__, line, adv_Channel);
    return FAIL;
}

// 5.4.1.6 Master Acknowledgement Scheme
verdict CON_MAS_Master_Acknowledgement_Scheme (u8 dut1_fd ,u8 dut2_fd)
{
    u8 buf[SOCKET_BUF_SIZE];
    int verdict = FAIL;
    int dut1 = 0;
    int dut2 = 0;
    u16 line = 0;
    struct itimerval timer;
    u8 conn_handles_mas[2];
    u8 conn_handles_sla[2];

    u8 acl_data[4] = {0xFF, 0xFF, 0xFF, 0xFF};
    u8 test_cnt1 = 0;

    int adv_Channel = 37;

    int sla_pkt_chk = 0 ;

    COMM_Dut_clean_buffer(dut1_fd);
    COMM_Dut_clean_buffer(dut2_fd);

    Calculate_Execution_Time_Start();

    // Uptest(white list) config
    COMM_INI_Connection_Setup_White_Listed_Config(dut2, &g_pattern_param);
    memcpy(g_pattern_param.white_list_param.Address, scan_addr, ADDR_LENGTH);
    g_pattern_param.white_list_param.Address_Type[0] = HCI_CMD_PARAM_PUBLIC_DEVICE_ADDRESS;
    verdict = COMM_INI_Connection_Setup_White_Listed(dut2_fd, g_pattern_param);
    VERDICT_RESULT_WITH_LINE();

    COMM_ADV_Directed_Advertising_Config(HCI_CMD_PARAM_ADV_DATA_LEN_MAX, &g_pattern_param);
    g_pattern_param.adv_param.Advertising_Filter_Policy[0] = HCI_CMD_PARAM_ALLOW_SCAN_REQ_FROM_WHITELIST_ONLY_AND_CONN_REQ_FROM_WHITELIST_ONLY;
    g_pattern_param.adv_param.Advertising_Interval_Max[0] =  0x00a0 & 0x00ff;
    g_pattern_param.adv_param.Advertising_Interval_Max[1] = (0x00a0 & 0xff00) >> 8;
    g_pattern_param.adv_param.Advertising_Interval_Min[0] =  0x00a0 & 0x00ff;
    g_pattern_param.adv_param.Advertising_Interval_Min[1] = (0x00a0 & 0xff00) >> 8;

    if(37 == adv_Channel) {
        g_pattern_param.adv_param.Advertising_Channel_Map[0] = HCI_CMD_PARAM_ENABLE_CHANNEL_37;
    }

    verdict = COMM_ADV_Directed_Advertising(dut2_fd, g_pattern_param);
    VERDICT_RESULT_WITH_LINE();

    COMM_INI_Initiating_Config(dut1, &g_pattern_param);
    memcpy(g_pattern_param.create_conn_param.Peer_Address, adv_addr, ADDR_LENGTH );
    verdict = COMM_INI_Initiating(dut1_fd, g_pattern_param);
    VERDICT_RESULT_WITH_LINE();

    event_query_timer_config(5, 0, 0, 0, &timer);
    event_query_timer_start(timer, read_le_event_enable);

    while(1)//waiting adv report event , timer or counter
    {
        if(1 == read_le_event_get())
        {
            read_le_event_disable();

            if(SUCCESS != QUERY_LE_Event(dut1_fd, buf, _BT_HCI_LE_EVENT_SUB_OP_CONNECTION_COMPLETE_, 0)) {
                line = __LINE__;
                goto FUN_FAIL;
            }
            if(SUCCESS != hci_le_event_connection_complete_parsing(0, buf, g_pattern_param)) {
                line = __LINE__;
                goto FUN_FAIL;
            }

            conn_handles_mas[0] = buf[_BT_HCI_EVT_CON_COMP_CONN_HANDLE+0];
            conn_handles_mas[1] = buf[_BT_HCI_EVT_CON_COMP_CONN_HANDLE+1];

            if (SUCCESS != QUERY_LE_Event(dut2_fd, buf, _BT_HCI_LE_EVENT_SUB_OP_CONNECTION_COMPLETE_, 0)) {
                line = __LINE__;
                goto FUN_FAIL;
            }
            if(SUCCESS != hci_le_event_connection_complete_parsing(0, buf, g_pattern_param)) {
                line = __LINE__;
                goto FUN_FAIL;
            }
            conn_handles_sla[0] = buf[_BT_HCI_EVT_CON_COMP_CONN_HANDLE+0];
            conn_handles_sla[1] = buf[_BT_HCI_EVT_CON_COMP_CONN_HANDLE+1];

            //######################################
            //Master to Slave
            while (test_cnt1 < 15) {

                printf("channel : %d, ACL_Data = 0xFF, Test_Cnt = %d\n", adv_Channel, test_cnt1);

                COMM_Send_ACL_Data_Without_event(dut1_fd, conn_handles_mas, 0b00, 0, sizeof(acl_data), acl_data);
                COMM_Send_ACL_Data_Without_event(dut2_fd, conn_handles_sla, 0b00, 0, sizeof(acl_data), acl_data);
PKT_CHK:
                // # check disconnection
                CHECK_NON_DISCONNECT();

                if(SUCCESS != QUERY_Event(dut1_fd, buf, _BT_HCI_EVENT_OP_NUMBER_OF_COMPLETED_PACKETS_)) {
                    line = __LINE__;
                    goto FUN_FAIL;
                }
                else if(1 != hci_event_num_of_completed_packets_parsing(buf)) {

                    MSLEEP(100);

                    sla_pkt_chk ++ ;
                    if (sla_pkt_chk == 100){
                        printf("sla no number of completed pkts\n");
                        line = __LINE__;
                        goto FUN_FAIL;
                    }

                    goto PKT_CHK;
                }

                sla_pkt_chk = 0 ;

                usleep(300000);

                if (SUCCESS != QUERY_Acl_Data(dut1_fd,buf)) {
                    line = __LINE__;
                    goto FUN_FAIL;
                }

                if (0x02 != (buf[_BT_HCI_IDX_ACL_DATA_CONN_HANDLE_+1] & 0xF0) >> 4) {
                    line = __LINE__;
                    goto FUN_FAIL;
                }

                // # need add api to check acl_data
                if (    (0xFF != (buf [_BT_HCI_IDX_ACL_DATA_PAYLOAD_])) ||
                        (0xFF != (buf [_BT_HCI_IDX_ACL_DATA_PAYLOAD_+1])) ||
                        (0xFF != (buf [_BT_HCI_IDX_ACL_DATA_PAYLOAD_+2])) ||
                        (0xFF != (buf [_BT_HCI_IDX_ACL_DATA_PAYLOAD_+3]))
                    )
                {
                    line=__LINE__;
                    goto FUN_FAIL;
                }

                if (SUCCESS != QUERY_Acl_Data(dut2_fd,buf)) {
                    line = __LINE__;
                    goto FUN_FAIL;
                }

                if (0x02 != (buf[_BT_HCI_IDX_ACL_DATA_CONN_HANDLE_+1] & 0xF0) >> 4) {
                    line = __LINE__;
                    goto FUN_FAIL;
                }

                // # need add api to check acl_data
                if (    (0xFF != (buf [_BT_HCI_IDX_ACL_DATA_PAYLOAD_])) ||
                        (0xFF != (buf [_BT_HCI_IDX_ACL_DATA_PAYLOAD_+1])) ||
                        (0xFF != (buf [_BT_HCI_IDX_ACL_DATA_PAYLOAD_+2])) ||
                        (0xFF != (buf [_BT_HCI_IDX_ACL_DATA_PAYLOAD_+3]))
                    )
                {
                    line=__LINE__;
                    goto FUN_FAIL;
                }


                test_cnt1 ++ ;
             }

            buf[_BT_HCI_EVT_COMP_HANDLE+0] = conn_handles_mas[0];
            buf[_BT_HCI_EVT_COMP_HANDLE+1] = conn_handles_mas[1];

            COMM_Disconnect_Config(dut1,&g_pattern_param,buf);
            verdict=COMM_Disconnect(dut1_fd,g_pattern_param);
            VERDICT_RESULT_WITH_LINE();

            FUNC_END();

            LOG_INFO("[Pattern][%s]SUCCESS\n", __FUNCTION__);
            return PASS;
        }
    }

FUN_FAIL:

    FUNC_END();

    LOG_INFO("[Pattern][%s]:%d channel : %d FAIL!!\n" , __FUNCTION__, line, adv_Channel);
    return FAIL;
}
// 5.4.1.8
verdict CON_MAS_Master_Supervision_Timer(u8 dut1_fd ,u8 dut2_fd)
{
    u8 buf[SOCKET_BUF_SIZE];
    int verdict=FAIL;
    int dut1 =0;
    int dut2 =0;
    u16 line =0 ;
    struct itimerval timer;

    COMM_Dut_clean_buffer(dut1_fd);
    COMM_Dut_clean_buffer(dut2_fd);

    COMM_ADV_Directed_Advertising_Config(HCI_CMD_PARAM_ADV_DATA_LEN_MAX,&g_pattern_param);
    memcpy (g_pattern_param.adv_param.Direct_Address , init_addr , ADDR_LENGTH);//should be peer addr!!!
    //here use lowest ch to testing
    g_pattern_param.adv_param.Advertising_Channel_Map[0] =HCI_CMD_PARAM_ENABLE_CHANNEL_37 ;
    verdict=COMM_ADV_Directed_Advertising(dut2_fd,g_pattern_param);
    VERDICT_RESULT_WITH_LINE();

    COMM_INI_Initiating_Config(dut1,&g_pattern_param);
    //use max supervision here
    g_pattern_param.create_conn_param.Supervision_Timeout[0]		=HCI_CMD_PARAM_SUPERVISION_TO_MAX& 0x00ff;
    g_pattern_param.create_conn_param.Supervision_Timeout[1]		=(HCI_CMD_PARAM_SUPERVISION_TO_MAX & 0xff00)  >> 8;

    memcpy(g_pattern_param.create_conn_param.Peer_Address ,adv_addr,ADDR_LENGTH );
    verdict=COMM_INI_Initiating(dut1_fd,g_pattern_param);
    VERDICT_RESULT_WITH_LINE();

    event_query_timer_config(5 , 0 , 0 , 0, &timer);
    event_query_timer_start(timer ,read_le_event_enable );


    while(1)//waiting adv report event , timer or counter
    {
        if ( 1 == read_le_event_get() )
        {    
            read_le_event_disable();

            if (SUCCESS != QUERY_LE_Event(dut2_fd,buf ,
                        _BT_HCI_LE_EVENT_SUB_OP_CONNECTION_COMPLETE_,
                        0))
            {
                line=__LINE__;
                goto FUN_FAIL;
            }

            if(SUCCESS != hci_le_event_connection_complete_parsing(0,
                        buf,g_pattern_param))
            {
                line=__LINE__;
                goto FUN_FAIL;
            }

            //Reset Slave
            COMM_Reset(dut2_fd);

            sleep(40);
            if (SUCCESS != QUERY_Event(dut1_fd,buf ,
										_BT_HCI_EVENT_OP_DISCONNECTION_COMPLETE_))
			{
				line=__LINE__;
				goto FUN_FAIL;
			}

			hci_event_disconnection_complete_parsing(0,buf,g_pattern_param);
			if(_BT_HCI_EVT_CMD_COMP_STATUS_CONNECTION_TIMEOUT
				!= buf[_BT_HCI_EVT_DISCONN_COMP_REASON])
			{
				line=__LINE__;
				goto FUN_FAIL;
			}

			//printf("[Pattern][%s]SUCCESS\n" ,__FUNCTION__);
			//return ;
			break;
		}
	}

	//do another testing
	//COMM_Reset(dut1_fd);
	dut_reset_with_mask_en(dut1_fd);
	dut_reset_with_mask_en(dut2_fd);

	COMM_ADV_Directed_Advertising_Config(HCI_CMD_PARAM_ADV_DATA_LEN_MAX,&g_pattern_param);
	memcpy (g_pattern_param.adv_param.Direct_Address , init_addr , ADDR_LENGTH);//should be peer addr!!!
	//here use lowest ch to testing
	g_pattern_param.adv_param.Advertising_Channel_Map[0] =HCI_CMD_PARAM_ENABLE_CHANNEL_37 ;
	verdict=COMM_ADV_Directed_Advertising(dut2_fd,g_pattern_param);
	VERDICT_RESULT_WITH_LINE();

	COMM_INI_Initiating_Config(dut1,&g_pattern_param);
	//use min supervision here
	g_pattern_param.create_conn_param.Supervision_Timeout[0]		=HCI_CMD_PARAM_SUPERVISION_TO_MIN& 0x00ff;
	g_pattern_param.create_conn_param.Supervision_Timeout[1]		=(HCI_CMD_PARAM_SUPERVISION_TO_MIN & 0xff00)  >> 8;

	memcpy(g_pattern_param.create_conn_param.Peer_Address ,adv_addr,ADDR_LENGTH );
	verdict=COMM_INI_Initiating(dut1_fd,g_pattern_param);
	VERDICT_RESULT_WITH_LINE();

	event_query_timer_config(5 , 0 , 0 , 0, &timer);
	event_query_timer_start(timer ,read_le_event_enable );


	while(1)//waiting adv report event , timer or counter
	{
		if ( 1 == read_le_event_get() )
		{
            read_le_event_disable();
        
			if (SUCCESS != QUERY_LE_Event(dut2_fd,buf ,
										_BT_HCI_LE_EVENT_SUB_OP_CONNECTION_COMPLETE_,
										0))
			{
				line=__LINE__;
				goto FUN_FAIL;
			}

			if(SUCCESS != hci_le_event_connection_complete_parsing(0,
										buf,g_pattern_param))
			{
				line=__LINE__;
				goto FUN_FAIL;
			}

			//Connection Terminated
			//use connect handle to disconnect
			COMM_Reset(dut2_fd);

            MSLEEP(150);
			if (SUCCESS != QUERY_Event(dut1_fd,buf ,
										_BT_HCI_EVENT_OP_DISCONNECTION_COMPLETE_))
			{
				line=__LINE__;
				goto FUN_FAIL;
			}

			hci_event_disconnection_complete_parsing(0,buf,g_pattern_param);
			if(_BT_HCI_EVT_CMD_COMP_STATUS_CONNECTION_TIMEOUT
				!= buf[_BT_HCI_EVT_DISCONN_COMP_REASON])
			{
				line=__LINE__;
				goto FUN_FAIL;
			}

			FUNC_END();
			LOG_INFO("[Pattern][%s]SUCCESS\n" ,__FUNCTION__);
			return PASS;
		}
	}

FUN_FAIL:
    FUNC_END();
	LOG_INFO("[Pattern][%s]:%d FAIL\n" ,__FUNCTION__,line);
    return FAIL;    
}


// 5.4.1.9
verdict CON_MAS_Feature_Setup_Request(u8 dut1_fd ,u8 dut2_fd)
{
	u8 buf[SOCKET_BUF_SIZE];
	int verdict=FAIL;
	int dut1 =0;
	int dut2 =0;
	u16 line =0 ;
	struct itimerval timer;
	u8 conn_handles_mas[2];

    COMM_Dut_clean_buffer(dut1_fd);
    COMM_Dut_clean_buffer(dut2_fd);

	COMM_ADV_Directed_Advertising_Config(HCI_CMD_PARAM_ADV_DATA_LEN_MAX,&g_pattern_param);
	memcpy (g_pattern_param.adv_param.Direct_Address , init_addr , ADDR_LENGTH);//should be peer addr!!!
	//here use lowest ch to testing
	g_pattern_param.adv_param.Advertising_Channel_Map[0] =HCI_CMD_PARAM_ENABLE_CHANNEL_37 ;
	verdict=COMM_ADV_Directed_Advertising(dut2_fd,g_pattern_param);
	VERDICT_RESULT_WITH_LINE();

	COMM_INI_Initiating_Config(dut1,&g_pattern_param);
	memcpy(g_pattern_param.create_conn_param.Peer_Address ,adv_addr,ADDR_LENGTH );
	verdict=COMM_INI_Initiating(dut1_fd,g_pattern_param);
	VERDICT_RESULT_WITH_LINE();

	event_query_timer_config(5 , 0 , 0 , 0, &timer);
	event_query_timer_start(timer ,read_le_event_enable );



	while(1)//waiting adv report event , timer or counter
	{
		if ( 1 == read_le_event_get() )
		{
            read_le_event_disable();
        
			if (SUCCESS != QUERY_LE_Event(dut1_fd,buf ,
										_BT_HCI_LE_EVENT_SUB_OP_CONNECTION_COMPLETE_,
										0))
			{
				line=__LINE__;
				goto FUN_FAIL;
			}

			if(SUCCESS != hci_le_event_connection_complete_parsing(0,
										buf,g_pattern_param))
			{
				line=__LINE__;
				goto FUN_FAIL;
			}

			conn_handles_mas[0]=buf[_BT_HCI_EVT_CON_COMP_CONN_HANDLE+0];
			conn_handles_mas[1]=buf[_BT_HCI_EVT_CON_COMP_CONN_HANDLE+1];

			verdict=COMM_Read_Local_Supported_Features(dut1_fd,g_pattern_param);
			VERDICT_RESULT_WITH_LINE();

			COMM_Read_Remote_Supported_Features_Config(dut1_fd,&g_pattern_param,conn_handles_mas);
			verdict=COMM_Read_Remote_Supported_Features(dut1_fd,g_pattern_param);
			VERDICT_RESULT_WITH_LINE();

			sleep(5);

			if (SUCCESS != QUERY_LE_Event(dut1_fd,buf ,
										_BT_HCI_LE_EVENT_SUB_OP_READ_REMOTE_USED_FEATURES_COMPLETE_
										,0))
			{
				line=__LINE__;
				goto FUN_FAIL;
			}

			if(SUCCESS != hci_event_read_remote_supported_features_complete_parsing(0,
										buf,g_pattern_param))
			{
				line=__LINE__;
				goto FUN_FAIL;
			}
            FUNC_END();
			LOG_INFO("[Pattern][%s]SUCCESS\n" ,__FUNCTION__);
			return PASS;
		}
	}

FUN_FAIL:
    FUNC_END();
	LOG_INFO("[Pattern][%s]:%d FAIL\n" ,__FUNCTION__,line);
    return FAIL;

}

// 5.4.1.10
verdict CON_MAS_Transmit_Fragmented_L2CAP_Header (u8 dut1_fd ,u8 dut2_fd)
{
	u8 buf[SOCKET_BUF_SIZE];
	int verdict = FAIL;
	int dut1 = 0;
    int dut2 = 0;
	u16 line = 0 ;
	struct itimerval timer;
	u8 conn_handles_mas[2];
	u8 acl_data[10] = {0};
	u8 acl_data2[32] = {0};
    u8 test_Times = 100;
    u8 test_cnt1 = 0;
    u8 test_cnt2 = 0;
    u8 test_cnt3 = 0;
    u8 test_cnt4 = 0;
    int adv_Channel = 37;

    int mas_pkt_chk = 0 ;

REPEAT:
    test_cnt1 = test_Times;
    test_cnt2 = test_Times;
    test_cnt3 = test_Times;
    test_cnt4 = test_Times;

    COMM_Dut_clean_buffer(dut1_fd);
    COMM_Dut_clean_buffer(dut2_fd);


    // Uptest(white list) config
	COMM_INI_Connection_Setup_White_Listed_Config(dut2, &g_pattern_param);
    memcpy(g_pattern_param.white_list_param.Address, scan_addr, ADDR_LENGTH);
    g_pattern_param.white_list_param.Address_Type[0] = HCI_CMD_PARAM_PUBLIC_DEVICE_ADDRESS;
    verdict = COMM_INI_Connection_Setup_White_Listed(dut2_fd, g_pattern_param);
    VERDICT_RESULT_WITH_LINE();

	COMM_ADV_Directed_Advertising_Config(HCI_CMD_PARAM_ADV_DATA_LEN_MAX, &g_pattern_param);
    g_pattern_param.adv_param.Advertising_Filter_Policy[0] = HCI_CMD_PARAM_ALLOW_SCAN_REQ_FROM_WHITELIST_ONLY_AND_CONN_REQ_FROM_WHITELIST_ONLY;
	g_pattern_param.adv_param.Advertising_Interval_Max[0] = 0x00a0 & 0x00ff;
    g_pattern_param.adv_param.Advertising_Interval_Max[1] = (0x00a0 & 0xff00) >> 8;
    g_pattern_param.adv_param.Advertising_Interval_Min[0] = 0x00a0 & 0x00ff;
    g_pattern_param.adv_param.Advertising_Interval_Min[1] = (0x00a0 & 0xff00) >> 8;
	if(37 == adv_Channel) {
        g_pattern_param.adv_param.Advertising_Channel_Map[0] = HCI_CMD_PARAM_ENABLE_CHANNEL_37;
    }
    else if(38 == adv_Channel) {
        g_pattern_param.adv_param.Advertising_Channel_Map[0] = HCI_CMD_PARAM_ENABLE_CHANNEL_38;
    }
    else {
        g_pattern_param.adv_param.Advertising_Channel_Map[0] = HCI_CMD_PARAM_ENABLE_CHANNEL_39;
    }
	verdict = COMM_ADV_Directed_Advertising(dut2_fd, g_pattern_param);
	VERDICT_RESULT_WITH_LINE();

	COMM_INI_Initiating_Config(dut1, &g_pattern_param);
    memcpy(g_pattern_param.create_conn_param.Peer_Address, adv_addr, ADDR_LENGTH);
	verdict = COMM_INI_Initiating(dut1_fd, g_pattern_param);
	VERDICT_RESULT_WITH_LINE();

	event_query_timer_config(5, 0, 0, 0, &timer);
	event_query_timer_start(timer, read_le_event_enable);

	while(1)//waiting adv report event , timer or counter
	{
		if (1 == read_le_event_get()) {
            read_le_event_disable();

			if (SUCCESS != QUERY_LE_Event(dut1_fd, buf,	_BT_HCI_LE_EVENT_SUB_OP_CONNECTION_COMPLETE_, 0)) {
				line = __LINE__;
				goto FUN_FAIL;
			}

			if(SUCCESS != hci_le_event_connection_complete_parsing(0, buf, g_pattern_param)) {
				line = __LINE__;
				goto FUN_FAIL;
			}

			conn_handles_mas[0] = buf[_BT_HCI_EVT_CON_COMP_CONN_HANDLE+0];
			conn_handles_mas[1] = buf[_BT_HCI_EVT_CON_COMP_CONN_HANDLE+1];

			if (SUCCESS != QUERY_LE_Event(dut2_fd, buf,	_BT_HCI_LE_EVENT_SUB_OP_CONNECTION_COMPLETE_, 0)) {
				line = __LINE__;
				goto FUN_FAIL;
			}

			if(SUCCESS != hci_le_event_connection_complete_parsing(0, buf, g_pattern_param)) {
				line = __LINE__;
				goto FUN_FAIL;
			}

			//######################################
			for( ;test_cnt1 > 0; test_cnt1--) {
				COMM_Send_ACL_Data_Without_event(dut1_fd, conn_handles_mas, 0b00, 0, 10, acl_data);
PKT_CHK1:
                // # check disconnection
                CHECK_NON_DISCONNECT();

                if(SUCCESS != QUERY_Event(dut1_fd, buf, _BT_HCI_EVENT_OP_NUMBER_OF_COMPLETED_PACKETS_)) {
                    line = __LINE__;
                    goto FUN_FAIL;
                }
                else if(1 != hci_event_num_of_completed_packets_parsing(buf)) {

                    MSLEEP(100);

                    mas_pkt_chk ++ ;
                    if (mas_pkt_chk == 100){
                        printf("mas no number of completed pkts\n");
                        line = __LINE__;
                        goto FUN_FAIL;
                    }

                    goto PKT_CHK1;
                }

                mas_pkt_chk = 0 ;

                printf("case 1, channel : %d, ACL_Data = 0b00, Test_Cnt = %d\n", adv_Channel, test_cnt1);
			}

            //step2 ~ 4
			if(SUCCESS != QUERY_Acl_Data(dut2_fd,buf))	{
				line = __LINE__;
				goto FUN_FAIL;
			}

			if(0b10 != (buf[_BT_HCI_IDX_ACL_DATA_CONN_HANDLE_+1] & 0xF0 ) >> 4) {
				line = __LINE__;
				goto FUN_FAIL;
			}
			//######################################
			for( ;test_cnt2 > 0; test_cnt2--) {
				COMM_Send_ACL_Data_Without_event(dut1_fd, conn_handles_mas, 0b01, 0, 10, acl_data);
PKT_CHK2:
                // # check disconnection
                CHECK_NON_DISCONNECT();

                if(SUCCESS != QUERY_Event(dut1_fd, buf, _BT_HCI_EVENT_OP_NUMBER_OF_COMPLETED_PACKETS_)) {
                    line = __LINE__;
                    goto FUN_FAIL;
                }
                else if(1 != hci_event_num_of_completed_packets_parsing(buf)) {

                    MSLEEP(100);

                    mas_pkt_chk ++ ;
                    if (mas_pkt_chk == 100){
                        printf("mas no number of completed pkts\n");

                        line = __LINE__;
                        goto FUN_FAIL;
                    }

                    goto PKT_CHK2;
                }

                mas_pkt_chk = 0 ;

                printf("case 2, channel : %d, ACL_Data = 0b01, Test_Cnt = %d\n", adv_Channel, test_cnt2);
			}

			if(SUCCESS != QUERY_Acl_Data(dut2_fd, buf))	{
				line = __LINE__;
				goto FUN_FAIL;
			}

			if(0x01 != (buf[_BT_HCI_IDX_ACL_DATA_CONN_HANDLE_+1] & 0xF0 ) >> 4) {
				line = __LINE__;
				goto FUN_FAIL;
			}
			//######################################
			COMM_Send_ACL_Data_Without_event(dut1_fd, conn_handles_mas, 0b00, 0, 10, acl_data);
PKT_CHK3:
            // # check disconnection
            CHECK_NON_DISCONNECT();

            if(SUCCESS != QUERY_Event(dut1_fd, buf, _BT_HCI_EVENT_OP_NUMBER_OF_COMPLETED_PACKETS_)) {
                line = __LINE__;
                goto FUN_FAIL;
            }
            else if(1 != hci_event_num_of_completed_packets_parsing(buf)) {

                MSLEEP(100);

                mas_pkt_chk ++ ;
                if (mas_pkt_chk == 100){
                    printf("mas no number of completed pkts\n");

                    line = __LINE__;
                    goto FUN_FAIL;
                }

                goto PKT_CHK3;
            }

            mas_pkt_chk = 0 ;

            printf("case 3, channel : %d, ACL_Data = 0b01, Test_Cnt = %d\n", adv_Channel, test_cnt2);


			if (SUCCESS != QUERY_Acl_Data(dut2_fd, buf)) {
				line = __LINE__;
				goto FUN_FAIL;
			}

			if (0b10 != (buf[_BT_HCI_IDX_ACL_DATA_CONN_HANDLE_+1] & 0xF0 ) >> 4) {
				line = __LINE__;
				goto FUN_FAIL;
			}
			//######################################
			for ( ;test_cnt3 > 0; test_cnt3--) {
				COMM_Send_ACL_Data_Without_event(dut1_fd, conn_handles_mas, 0b01, 0, 10, acl_data);
PKT_CHK4:
                // # check disconnection
                CHECK_NON_DISCONNECT();

                if(SUCCESS != QUERY_Event(dut1_fd, buf, _BT_HCI_EVENT_OP_NUMBER_OF_COMPLETED_PACKETS_)) {
                    line = __LINE__;
                    goto FUN_FAIL;
                }
                else if(1 != hci_event_num_of_completed_packets_parsing(buf)) {

                    MSLEEP(100);

                    mas_pkt_chk ++ ;
                    if (mas_pkt_chk == 100){
                        printf("mas no number of completed pkts\n");

                        line = __LINE__;
                        goto FUN_FAIL;
                    }

                    goto PKT_CHK4;
                }

                mas_pkt_chk = 0 ;

                printf("case 4, channel : %d, ACL_Data = 0b00, Test_Cnt = %d\n", adv_Channel, test_cnt3);
			}
			if (SUCCESS != QUERY_Acl_Data(dut2_fd, buf)) {
				line = __LINE__;
				goto FUN_FAIL;
			}

			if (0b01 != (buf[_BT_HCI_IDX_ACL_DATA_CONN_HANDLE_+1] & 0xF0 ) >> 4) {
				line = __LINE__;
				goto FUN_FAIL;
			}
			//######################################

			for ( ;test_cnt4 > 0; test_cnt4--) {
				COMM_Send_ACL_Data_Without_event(dut1_fd, conn_handles_mas, 0b01, 0, 23, acl_data2);
PKT_CHK5:
                // # check disconnection
                CHECK_NON_DISCONNECT();

                if(SUCCESS != QUERY_Event(dut1_fd, buf, _BT_HCI_EVENT_OP_NUMBER_OF_COMPLETED_PACKETS_)) {
                    line = __LINE__;
                    goto FUN_FAIL;
                }
                else if(1 != hci_event_num_of_completed_packets_parsing(buf)) {

                    MSLEEP(100);

                    mas_pkt_chk ++ ;
                    if (mas_pkt_chk == 100){
                        printf("mas no number of completed pkts\n");

                        line = __LINE__;
                        goto FUN_FAIL;
                    }

                    goto PKT_CHK5;
                }

                mas_pkt_chk = 0 ;

                printf("case 5, channel : %d, ACL_Data = 0b01, Test_Cnt = %d\n", adv_Channel, test_cnt4);
			}

			if (SUCCESS != QUERY_Acl_Data(dut2_fd, buf)) {
				line = __LINE__;
				goto FUN_FAIL;
			}

			if (0x01 != (buf[_BT_HCI_IDX_ACL_DATA_CONN_HANDLE_+1] & 0xF0 ) >> 4) {
				line = __LINE__;
				goto FUN_FAIL;
			}
            if(adv_Channel != 39){
                adv_Channel ++;
				//COMM_Reset(dut1_fd);
				//COMM_Reset(dut2_fd);
				dut_reset_with_mask_en(dut1_fd);
				dut_reset_with_mask_en(dut2_fd);
                goto REPEAT;
            }
			//COMM_Reset(dut1_fd);
			//COMM_Reset(dut2_fd);
			dut_reset_with_mask_en(dut1_fd);
			dut_reset_with_mask_en(dut2_fd);

			LOG_INFO("[Pattern][%s]SUCCESS\n", __FUNCTION__);
			return PASS;
		}
	}

FUN_FAIL:
	LOG_INFO("[Pattern][%s]:%d channel : %d FAIL!!\n" , __FUNCTION__, line, adv_Channel);
    return FAIL;
}
// 5.4.1.16
verdict CON_MAS_Master_Request_Version(u8 dut1_fd ,u8 dut2_fd)
{
	u8 buf[SOCKET_BUF_SIZE];
	int verdict=FAIL;
	int dut1=0;
	int dut2=0;
	u16 line =0 ;
	struct itimerval timer;
	u8 conn_handles_mas[2];

    COMM_Dut_clean_buffer(dut1_fd);
    COMM_Dut_clean_buffer(dut2_fd);

	COMM_ADV_Directed_Advertising_Config(HCI_CMD_PARAM_ADV_DATA_LEN_MAX,&g_pattern_param);
	memcpy (g_pattern_param.adv_param.Direct_Address , init_addr , ADDR_LENGTH);//should be peer addr!!!
	//here use lowest ch to testing
	g_pattern_param.adv_param.Advertising_Channel_Map[0] =HCI_CMD_PARAM_ENABLE_CHANNEL_37 ;
	verdict=COMM_ADV_Directed_Advertising(dut2_fd,g_pattern_param);
	VERDICT_RESULT_WITH_LINE();

	COMM_INI_Initiating_Config(dut1,&g_pattern_param);
	memcpy(g_pattern_param.create_conn_param.Peer_Address ,adv_addr,ADDR_LENGTH );
	verdict=COMM_INI_Initiating(dut1_fd,g_pattern_param);
	VERDICT_RESULT_WITH_LINE();

	event_query_timer_config(5 , 0 , 0 , 0, &timer);
	event_query_timer_start(timer ,read_le_event_enable );

	while(1)//waiting adv report event , timer or counter
	{
		if ( 1 == read_le_event_get() )
		{
            read_le_event_disable();
        
			if (SUCCESS != QUERY_LE_Event(dut1_fd,buf ,
										_BT_HCI_LE_EVENT_SUB_OP_CONNECTION_COMPLETE_,
										0))
			{
				line=__LINE__;
				goto FUN_FAIL;
			}

			if(SUCCESS != hci_le_event_connection_complete_parsing(0,
										buf,g_pattern_param))
			{
				line=__LINE__;
				goto FUN_FAIL;
			}

			conn_handles_mas[0]=buf[_BT_HCI_EVT_COMP_HANDLE+0];
			conn_handles_mas[1]=buf[_BT_HCI_EVT_COMP_HANDLE+1];

			verdict=COMM_Read_Local_Version_Information(dut1_fd,&g_pattern_param);
			VERDICT_RESULT_WITH_LINE();

			COMM_Read_Remote_Version_Information_Config(dut1_fd,&g_pattern_param,conn_handles_mas);
			verdict=COMM_Read_Remote_Version_Information(dut1_fd,g_pattern_param);
			VERDICT_RESULT_WITH_LINE();

			sleep(1);

			if (SUCCESS != QUERY_Event(dut1_fd,buf ,
										_BT_HCI_EVENT_OP_READ_REMOTE_VERSION_INFORMATION_COMPLETE_))
			{
				line=__LINE__;
				goto FUN_FAIL;
			}

			if(SUCCESS != hci_event_read_remote_version_information_complete_parsing(buf,g_pattern_param))
			{
				line=__LINE__;
				goto FUN_FAIL;
			}
		  
			LOG_INFO("[Pattern][%s]SUCCESS\n" ,__FUNCTION__);
			return PASS;
		}
	}

FUN_FAIL:
	LOG_INFO("[Pattern][%s]:%d FAIL\n" ,__FUNCTION__,line);
    return FAIL;

}

// 5.4.1.17
verdict CON_MAS_Master_Respond_Version(u8 dut1_fd ,u8 dut2_fd)
{
	u8 buf[SOCKET_BUF_SIZE];
	int verdict=FAIL;
	int dut1 =0;
	int dut2 =0;
	u16 line =0 ;
	struct itimerval timer;
	u8 conn_handles_sla[2];

    COMM_Dut_clean_buffer(dut1_fd);
    COMM_Dut_clean_buffer(dut2_fd);

	COMM_ADV_Directed_Advertising_Config(HCI_CMD_PARAM_ADV_DATA_LEN_MAX,&g_pattern_param);
	memcpy (g_pattern_param.adv_param.Direct_Address , init_addr , ADDR_LENGTH);//should be peer addr!!!
	//here use lowest ch to testing
	g_pattern_param.adv_param.Advertising_Channel_Map[0] =HCI_CMD_PARAM_ENABLE_CHANNEL_37 ;
	verdict=COMM_ADV_Directed_Advertising(dut2_fd,g_pattern_param);
	VERDICT_RESULT_WITH_LINE();

	COMM_INI_Initiating_Config(dut1,&g_pattern_param);
	memcpy(g_pattern_param.create_conn_param.Peer_Address ,adv_addr,ADDR_LENGTH );
	verdict=COMM_INI_Initiating(dut1_fd,g_pattern_param);
	VERDICT_RESULT_WITH_LINE();

	event_query_timer_config(5 , 0 , 0 , 0, &timer);
	event_query_timer_start(timer ,read_le_event_enable );

	while(1)//waiting adv report event , timer or counter
	{
		if ( 1 == read_le_event_get() )
		{
            read_le_event_disable();
        
			if (SUCCESS != QUERY_LE_Event(dut2_fd,buf ,
										_BT_HCI_LE_EVENT_SUB_OP_CONNECTION_COMPLETE_,
										0))
			{
				line=__LINE__;
				goto FUN_FAIL;
			}

			if(SUCCESS != hci_le_event_connection_complete_parsing(0,
										buf,g_pattern_param))
			{
				line=__LINE__;
				goto FUN_FAIL;
			}

			conn_handles_sla[0]=buf[_BT_HCI_EVT_COMP_HANDLE+0];
			conn_handles_sla[1]=buf[_BT_HCI_EVT_COMP_HANDLE+1];

			verdict=COMM_Read_Local_Version_Information(dut2_fd,&g_pattern_param);
			VERDICT_RESULT_WITH_LINE();

			COMM_Read_Remote_Version_Information_Config(dut2_fd,&g_pattern_param,conn_handles_sla);
			verdict=COMM_Read_Remote_Version_Information(dut2_fd,g_pattern_param);
			VERDICT_RESULT_WITH_LINE();

			sleep(1);

			if (SUCCESS != QUERY_Event(dut2_fd,buf ,
										_BT_HCI_EVENT_OP_READ_REMOTE_VERSION_INFORMATION_COMPLETE_))
			{
				line=__LINE__;
				goto FUN_FAIL;
			}

			if(SUCCESS != hci_event_read_remote_version_information_complete_parsing(buf,g_pattern_param))
			{
				line=__LINE__;
				goto FUN_FAIL;
			}
            
            FUNC_END();
            
			LOG_INFO("[Pattern][%s]SUCCESS\n" ,__FUNCTION__);
			return PASS;
		}
	}

FUN_FAIL:
    
    FUNC_END();
    
	LOG_INFO("[Pattern][%s]:%d FAIL\n" ,__FUNCTION__,line);
    return FAIL;

}


// 5.5.1.1
// TIM_ADV_Earliest_transmission_to_Advertiser
verdict TIM_ADV_Earliest_transmission_to_Advertiser(u8 dut1_fd ,u8 dut2_fd)
{
    u8 buf[SOCKET_BUF_SIZE];
    u16 line;
    int verdict = FAIL;
    int dut1 = 0, dut2 = 0;

    struct itimerval timer;
    
    u16 adv_cnt_37 = 0;
    u16 adv_cnt_38 = 0;
    u16 adv_cnt_39 = 0;
    u16 scn_rsp_37 = 0;
    u16 scn_rsp_38 = 0;
    u16 scn_rsp_39 = 0;

    COMM_Dut_clean_buffer(dut1_fd);
    COMM_Dut_clean_buffer(dut2_fd);

    Calculate_Execution_Time_Start();
    //#p1: lower tester with active scanning

    COMM_INI_Connection_Setup_White_Listed_Config(dut1, &g_pattern_param);
	memcpy(g_pattern_param.white_list_param.Address, adv_addr, ADDR_LENGTH);
	verdict=COMM_INI_Connection_Setup_White_Listed(dut1_fd, g_pattern_param);
	VERDICT_RESULT_WITH_LINE();

    COMM_SCN_Active_Scanning_Config(dut1, &g_pattern_param);
    g_pattern_param.scn_param.LE_Scan_Interval[0] =  HCI_CMD_PARAM_SCAN_INT_MAX & 0x00ff;
    g_pattern_param.scn_param.LE_Scan_Interval[1] = (HCI_CMD_PARAM_SCAN_INT_MAX & 0xff00) >> 8;
    g_pattern_param.scn_param.LE_Scan_Window[0] =    HCI_CMD_PARAM_SCAN_WIN_MAX & 0x00ff;
    g_pattern_param.scn_param.LE_Scan_Window[1] =   (HCI_CMD_PARAM_SCAN_WIN_MAX & 0xff00) >> 8;
	g_pattern_param.scn_param.Scanning_Filter_Policy[0] =	HCI_CMD_PARAM_IGNORE_ADV_PKTS_FROM_DEV_NOT_IN_WHITE_LIST_ONLY;
    verdict = COMM_SCN_Active_Scanning(dut1_fd, g_pattern_param);
    VERDICT_RESULT_WITH_LINE();

    //The timing range detected for advertising events(ADV_IND) is from 20.0 ms to 30.0 ms
    //interval : 32(0x0020) * 0.625ms = 20ms
    //if (1 == repeat) {
    COMM_ADV_Undirected_Advertising_Config(HCI_CMD_PARAM_ADV_DATA_LEN_MAX, &g_pattern_param);
    g_pattern_param.adv_param.Advertising_Interval_Max[0] =  HCI_CMD_PARAM_ADVERTISING_INTERVAL_MIN & 0x00ff;
    g_pattern_param.adv_param.Advertising_Interval_Max[1] = (HCI_CMD_PARAM_ADVERTISING_INTERVAL_MIN & 0xff00) >> 8;
    g_pattern_param.adv_param.Advertising_Interval_Min[0] =  HCI_CMD_PARAM_ADVERTISING_INTERVAL_MIN & 0x00ff;
    g_pattern_param.adv_param.Advertising_Interval_Min[1] = (HCI_CMD_PARAM_ADVERTISING_INTERVAL_MIN & 0xff00) >> 8;
    g_pattern_param.adv_data_param.Advertising_Data_Length[0] = 0x01;
    g_pattern_param.adv_data_param.Advertising_Data[0] = 0x01;

    //#p2: undir with ch 37
	g_pattern_param.adv_param.Advertising_Channel_Map[0] = HCI_CMD_PARAM_ENABLE_CHANNEL_37;
    verdict = COMM_ADV_Undirected_Advertising(dut2_fd, g_pattern_param);
    VERDICT_RESULT_WITH_LINE();

    //waiting adv report event , timer or counter
    while(1) {
        read_le_event_enable();
        event_query_timer_config(60, 0, 0, 0, &timer);
        event_query_timer_start(timer, read_le_event_disable);
        printf("****timer for 60 sec****\n" );        

        while (read_le_event_get()){

            MSLEEP(20);

            //#p3 expect ADV_IND
            if (SUCCESS != QUERY_LE_Event(dut1_fd, buf, _BT_HCI_LE_EVENT_SUB_OP_ADVERTISING_REPORT_, HCI_SUBEVENT_ADV_RPT_EVENT_ADV_IND)) {
                continue;
                
                
            }            
            else if(EQUAL != hci_le_event_advertising_report_parsing(HCI_CMD_PARAM_ADV_IND, buf, g_pattern_param)) {
                continue;
            }
            else {
                adv_cnt_37++ ;
                printf("** check adv ind : %d time **\n" , adv_cnt_37);                    
            }

            //#p4 expect SCAN_RSP
            if (SUCCESS != QUERY_LE_Event(dut1_fd, buf, _BT_HCI_LE_EVENT_SUB_OP_ADVERTISING_REPORT_, HCI_SUBEVENT_ADV_RPT_EVENT_SCAN_RSP)) {
                continue;
                
                
            }            
            else if(EQUAL != hci_le_event_advertising_report_parsing(HCI_SUBEVENT_ADV_RPT_EVENT_SCAN_RSP, buf, g_pattern_param)) {
                continue;
            }
            else {
                scn_rsp_37++ ;
                printf("** check scan rsp : %d time **\n" , scn_rsp_37);                    
            }

             
        }
        
        COMM_SCN_Disable_Config(dut1,&g_pattern_param);
        verdict = COMM_SCN_Disable(dut1_fd,g_pattern_param);
        VERDICT_RESULT_WITH_LINE();
        
        COMM_ADV_Disable_Config(dut2, &g_pattern_param);
        verdict = COMM_ADV_Disable(dut2_fd, g_pattern_param);
        //VERDICT_RESULT_WITH_LINE();

        break;
    }

    //#p1: lower tester with active scanning
    COMM_SCN_Active_Scanning_Config(dut1, &g_pattern_param);
    g_pattern_param.scn_param.LE_Scan_Interval[0] =  HCI_CMD_PARAM_SCAN_INT_MAX & 0x00ff;
    g_pattern_param.scn_param.LE_Scan_Interval[1] = (HCI_CMD_PARAM_SCAN_INT_MAX & 0xff00) >> 8;
    g_pattern_param.scn_param.LE_Scan_Window[0] =    HCI_CMD_PARAM_SCAN_WIN_MAX & 0x00ff;
    g_pattern_param.scn_param.LE_Scan_Window[1] =   (HCI_CMD_PARAM_SCAN_WIN_MAX & 0xff00) >> 8;
	g_pattern_param.scn_param.Scanning_Filter_Policy[0] =	HCI_CMD_PARAM_IGNORE_ADV_PKTS_FROM_DEV_NOT_IN_WHITE_LIST_ONLY;
    verdict = COMM_SCN_Active_Scanning(dut1_fd, g_pattern_param);
    VERDICT_RESULT_WITH_LINE();

    //The timing range detected for advertising events(ADV_IND) is from 20.0 ms to 30.0 ms
    //interval : 32(0x0020) * 0.625ms = 20ms
    //if (1 == repeat) {
    COMM_ADV_Undirected_Advertising_Config(HCI_CMD_PARAM_ADV_DATA_LEN_MAX, &g_pattern_param);
    g_pattern_param.adv_param.Advertising_Interval_Max[0] =  HCI_CMD_PARAM_ADVERTISING_INTERVAL_MIN & 0x00ff;
    g_pattern_param.adv_param.Advertising_Interval_Max[1] = (HCI_CMD_PARAM_ADVERTISING_INTERVAL_MIN & 0xff00) >> 8;
    g_pattern_param.adv_param.Advertising_Interval_Min[0] =  HCI_CMD_PARAM_ADVERTISING_INTERVAL_MIN & 0x00ff;
    g_pattern_param.adv_param.Advertising_Interval_Min[1] = (HCI_CMD_PARAM_ADVERTISING_INTERVAL_MIN & 0xff00) >> 8;
    g_pattern_param.adv_data_param.Advertising_Data_Length[0] = 0x01;
    g_pattern_param.adv_data_param.Advertising_Data[0] = 0x01;

    //#p2: undir with ch 38
    g_pattern_param.adv_param.Advertising_Channel_Map[0] =HCI_CMD_PARAM_ENABLE_CHANNEL_38;
    verdict = COMM_ADV_Undirected_Advertising(dut2_fd,g_pattern_param);
    VERDICT_RESULT_WITH_LINE();

    //waiting adv report event , timer or counter
    while(1) {
        read_le_event_enable();
        event_query_timer_config(60, 0, 0, 0, &timer);
        event_query_timer_start(timer, read_le_event_disable);
        printf("****timer for 60 sec****\n" );        

        while(read_le_event_get()){            

            MSLEEP(20);

            //#p3 expect ADV_IND
            if(SUCCESS != QUERY_LE_Event(dut1_fd, buf, _BT_HCI_LE_EVENT_SUB_OP_ADVERTISING_REPORT_, HCI_SUBEVENT_ADV_RPT_EVENT_ADV_IND)) {
                continue;
                
                
            }            
            else if(EQUAL != hci_le_event_advertising_report_parsing(HCI_CMD_PARAM_ADV_IND, buf, g_pattern_param)) {
                continue;
            }
            else {
                adv_cnt_38++ ;
                printf("** check adv ind : %d time **\n", adv_cnt_38);                    
            }

            //#p4 expect SCAN_RSP
            if (SUCCESS != QUERY_LE_Event(dut1_fd, buf, _BT_HCI_LE_EVENT_SUB_OP_ADVERTISING_REPORT_, HCI_SUBEVENT_ADV_RPT_EVENT_SCAN_RSP)) {
                continue;
                
                
            }            
            else if(EQUAL != hci_le_event_advertising_report_parsing(HCI_SUBEVENT_ADV_RPT_EVENT_SCAN_RSP, buf, g_pattern_param)) {
                continue;
            }
            else {
                scn_rsp_38++ ;
                printf("** check scan rsp : %d time **\n" , scn_rsp_38);                    
            }

             
        }
        
        COMM_SCN_Disable_Config(dut1, &g_pattern_param);
        verdict = COMM_SCN_Disable(dut1_fd, g_pattern_param);
        VERDICT_RESULT_WITH_LINE();
        
        COMM_ADV_Disable_Config(dut2, &g_pattern_param);
        verdict = COMM_ADV_Disable(dut2_fd, g_pattern_param);
        //VERDICT_RESULT_WITH_LINE();

        break;
    }

    //#p1: lower tester with active scanning
    COMM_SCN_Active_Scanning_Config(dut1, &g_pattern_param);
    g_pattern_param.scn_param.LE_Scan_Interval[0] =  HCI_CMD_PARAM_SCAN_INT_MAX & 0x00ff;
    g_pattern_param.scn_param.LE_Scan_Interval[1] = (HCI_CMD_PARAM_SCAN_INT_MAX & 0xff00) >> 8;
    g_pattern_param.scn_param.LE_Scan_Window[0] =    HCI_CMD_PARAM_SCAN_WIN_MAX & 0x00ff;
    g_pattern_param.scn_param.LE_Scan_Window[1] =   (HCI_CMD_PARAM_SCAN_WIN_MAX & 0xff00) >> 8;
	g_pattern_param.create_conn_param.Initiator_Filter_Policy[0] =HCI_CMD_PARAM_FILTER_POLICY_WHITE_LIST_USED;
    verdict = COMM_SCN_Active_Scanning(dut1_fd, g_pattern_param);
    VERDICT_RESULT_WITH_LINE();

    //The timing range detected for advertising events(ADV_IND) is from 20.0 ms to 30.0 ms
    //interval : 32(0x0020) * 0.625ms = 20ms
    //if (1 == repeat) {
    COMM_ADV_Undirected_Advertising_Config(HCI_CMD_PARAM_ADV_DATA_LEN_MAX, &g_pattern_param);
    g_pattern_param.adv_param.Advertising_Interval_Max[0] =  HCI_CMD_PARAM_ADVERTISING_INTERVAL_MIN & 0x00ff;
    g_pattern_param.adv_param.Advertising_Interval_Max[1] = (HCI_CMD_PARAM_ADVERTISING_INTERVAL_MIN & 0xff00) >> 8;
    g_pattern_param.adv_param.Advertising_Interval_Min[0] =  HCI_CMD_PARAM_ADVERTISING_INTERVAL_MIN & 0x00ff;
    g_pattern_param.adv_param.Advertising_Interval_Min[1] = (HCI_CMD_PARAM_ADVERTISING_INTERVAL_MIN & 0xff00) >> 8;
    g_pattern_param.adv_data_param.Advertising_Data_Length[0] = 0x01;
    g_pattern_param.adv_data_param.Advertising_Data[0] = 0x01;

    //#p2: undir with ch 39
    g_pattern_param.adv_param.Advertising_Channel_Map[0] =HCI_CMD_PARAM_ENABLE_CHANNEL_39;
    verdict = COMM_ADV_Undirected_Advertising(dut2_fd,g_pattern_param);
    VERDICT_RESULT_WITH_LINE();

    //waiting adv report event , timer or counter
    while(1) {
        read_le_event_enable();
        event_query_timer_config(60, 0, 0, 0, &timer);
        event_query_timer_start(timer, read_le_event_disable);
        printf("****timer for 60 sec****\n" );        

        while (read_le_event_get()){

            MSLEEP(20);

            //#p3 expect ADV_IND
            if (SUCCESS != QUERY_LE_Event(dut1_fd, buf, _BT_HCI_LE_EVENT_SUB_OP_ADVERTISING_REPORT_, HCI_SUBEVENT_ADV_RPT_EVENT_ADV_IND)) {
                continue;
                
                
            }            
            else if(EQUAL != hci_le_event_advertising_report_parsing(HCI_CMD_PARAM_ADV_IND, buf, g_pattern_param)) {
                continue;
            }
            else {
                adv_cnt_39++ ;
                printf("** check adv ind : %d time **\n" , adv_cnt_39);                    
            }

            //#p4 expect SCAN_RSP
            if (SUCCESS != QUERY_LE_Event(dut1_fd, buf, _BT_HCI_LE_EVENT_SUB_OP_ADVERTISING_REPORT_, HCI_SUBEVENT_ADV_RPT_EVENT_SCAN_RSP)) {
                continue;
                
                
            }            
            else if(EQUAL != hci_le_event_advertising_report_parsing(HCI_SUBEVENT_ADV_RPT_EVENT_SCAN_RSP, buf, g_pattern_param)) {
                continue;
            }
            else {
                scn_rsp_39++ ;
                printf("** check scan rsp : %d time **\n" , scn_rsp_39);                    
            }

             
        }
        
        COMM_SCN_Disable_Config(dut1,&g_pattern_param);
        verdict = COMM_SCN_Disable(dut1_fd,g_pattern_param);
        VERDICT_RESULT_WITH_LINE();
        
        COMM_ADV_Disable_Config(dut2, &g_pattern_param);
        verdict = COMM_ADV_Disable(dut2_fd, g_pattern_param);
        //VERDICT_RESULT_WITH_LINE();

        break;
    }

    FUNC_END(); 
    LOG_INFO("[Pattern][%s]SUCCESS\n", __FUNCTION__);    
    LOG_INFO("adv cnt 37 =%d \n" , adv_cnt_37);
    LOG_INFO("adv cnt 38 =%d \n" , adv_cnt_38);
    LOG_INFO("adv cnt 39 =%d \n" , adv_cnt_39);
    LOG_INFO("scn rsp 37 =%d \n" , scn_rsp_37);
    LOG_INFO("scn rsp 38 =%d \n" , scn_rsp_38);
    LOG_INFO("scn rsp 39 =%d \n" , scn_rsp_39);
    return PASS;
    
FUN_FAIL:
    FUNC_END();   
    
    LOG_INFO("[Pattern][%s]:%d FAIL\n" ,__FUNCTION__,line);
    return FAIL;

}


// 5.5.2.1
verdict TIM_SLA_Adjusting_Anchor_Point(u8 dut1_fd ,u8 dut2_fd)
{
	u8 buf[SOCKET_BUF_SIZE];
	int verdict = FAIL;
	int dut1 = 0;
    int dut2 = 0;
	u16 line = 0;
	struct itimerval timer;
	u8 conn_handles_mas[2];
	u8 conn_handles_sla[2];

    int adv_Channel = 37;

    COMM_Dut_clean_buffer(dut1_fd);
    COMM_Dut_clean_buffer(dut2_fd);

    Calculate_Execution_Time_Start();

    // Uptest(white list) config
	COMM_INI_Connection_Setup_White_Listed_Config(dut2, &g_pattern_param);
    memcpy(g_pattern_param.white_list_param.Address, scan_addr, ADDR_LENGTH);
    g_pattern_param.white_list_param.Address_Type[0] = HCI_CMD_PARAM_PUBLIC_DEVICE_ADDRESS;
    verdict = COMM_INI_Connection_Setup_White_Listed(dut2_fd, g_pattern_param);
    VERDICT_RESULT_WITH_LINE();

	COMM_ADV_Directed_Advertising_Config(HCI_CMD_PARAM_ADV_DATA_LEN_MAX, &g_pattern_param);
    g_pattern_param.adv_param.Advertising_Filter_Policy[0] = HCI_CMD_PARAM_ALLOW_SCAN_REQ_FROM_WHITELIST_ONLY_AND_CONN_REQ_FROM_WHITELIST_ONLY;
	g_pattern_param.adv_param.Advertising_Interval_Max[0] =  0x00a0 & 0x00ff;
    g_pattern_param.adv_param.Advertising_Interval_Max[1] = (0x00a0 & 0xff00) >> 8;
    g_pattern_param.adv_param.Advertising_Interval_Min[0] =  0x00a0 & 0x00ff;
    g_pattern_param.adv_param.Advertising_Interval_Min[1] = (0x00a0 & 0xff00) >> 8;
	if(37 == adv_Channel) {
        g_pattern_param.adv_param.Advertising_Channel_Map[0] = HCI_CMD_PARAM_ENABLE_CHANNEL_37;
    }

	verdict = COMM_ADV_Directed_Advertising(dut2_fd, g_pattern_param);
	VERDICT_RESULT_WITH_LINE();

	COMM_INI_Initiating_Config(dut1, &g_pattern_param);
    memcpy(g_pattern_param.create_conn_param.Peer_Address, adv_addr, ADDR_LENGTH );
	verdict = COMM_INI_Initiating(dut1_fd, g_pattern_param);
	VERDICT_RESULT_WITH_LINE();

	event_query_timer_config(5, 0, 0, 0, &timer);
	event_query_timer_start(timer, read_le_event_enable);

    //waiting adv report event , timer or counter
	while(1) {
		if(1 == read_le_event_get()) {
            read_le_event_disable();

    		if(SUCCESS != QUERY_LE_Event(dut1_fd, buf,	_BT_HCI_LE_EVENT_SUB_OP_CONNECTION_COMPLETE_, 0)) {
    			line = __LINE__;
    			goto FUN_FAIL;
    		}

    		if(SUCCESS != hci_le_event_connection_complete_parsing(0, buf, g_pattern_param)) {
    			line = __LINE__;
    			goto FUN_FAIL;
    		}

    		conn_handles_mas[0] = buf[_BT_HCI_EVT_CON_COMP_CONN_HANDLE+0];
    		conn_handles_mas[1] = buf[_BT_HCI_EVT_CON_COMP_CONN_HANDLE+1];


    		if(SUCCESS != QUERY_LE_Event(dut2_fd, buf, _BT_HCI_LE_EVENT_SUB_OP_CONNECTION_COMPLETE_, 0)) {
    			line = __LINE__;
    			goto FUN_FAIL;
    		}

    		if(SUCCESS != hci_le_event_connection_complete_parsing(0, buf, g_pattern_param)) {
    			line = __LINE__;
    			goto FUN_FAIL;
    		}

    		conn_handles_sla[0] = buf[_BT_HCI_EVT_CON_COMP_CONN_HANDLE+0];
    		conn_handles_sla[1] = buf[_BT_HCI_EVT_CON_COMP_CONN_HANDLE+1];

            //######################################

            COMM_Conn_Update_Set_Config(dut1 , &g_pattern_param , conn_handles_mas);
            g_pattern_param.conn_update_param.Conn_Interval_Min[0]       = HCI_CMD_PARAM_CONN_INT_MIN & 0x00ff;
            g_pattern_param.conn_update_param.Conn_Interval_Min[1]       =(HCI_CMD_PARAM_CONN_INT_MIN & 0xff00)  >> 8;
            g_pattern_param.conn_update_param.Conn_Interval_Max[0]       = HCI_CMD_PARAM_CONN_INT_MIN & 0x00ff;
            g_pattern_param.conn_update_param.Conn_Interval_Max[1]       =(HCI_CMD_PARAM_CONN_INT_MIN & 0xff00)  >> 8;           
            verdict=COMM_Conn_Update_Set(dut1_fd , g_pattern_param);
            VERDICT_RESULT_WITH_LINE();

            sleep(6);

            if(SUCCESS != QUERY_LE_Event(dut2_fd, buf, _BT_HCI_LE_EVENT_SUB_OP_CONNECTION_UPDATE_COMPLETE_, 0)) {
                line = __LINE__;
                goto FUN_FAIL;
            }

            if(SUCCESS != hci_le_event_connection_update_complete_parsing(0, buf, g_pattern_param)) {
                line = __LINE__;
                goto FUN_FAIL;
            }

            COMM_Conn_Update_Set_Config(dut1 , &g_pattern_param , conn_handles_mas);
            g_pattern_param.conn_update_param.Conn_Interval_Min[0]       = HCI_CMD_PARAM_CONN_INT_MIN & 0x00ff;
            g_pattern_param.conn_update_param.Conn_Interval_Min[1]       =(HCI_CMD_PARAM_CONN_INT_MIN & 0xff00)  >> 8;
            g_pattern_param.conn_update_param.Conn_Interval_Max[0]       = HCI_CMD_PARAM_CONN_INT_MIN & 0x00ff;
            g_pattern_param.conn_update_param.Conn_Interval_Max[1]       =(HCI_CMD_PARAM_CONN_INT_MIN & 0xff00)  >> 8;           
            verdict=COMM_Conn_Update_Set(dut1_fd , g_pattern_param);
            VERDICT_RESULT_WITH_LINE();

            sleep(6);

            if(SUCCESS != QUERY_LE_Event(dut2_fd, buf, _BT_HCI_LE_EVENT_SUB_OP_CONNECTION_UPDATE_COMPLETE_, 0)) {
                line = __LINE__;
                goto FUN_FAIL;
            }

            if(SUCCESS == hci_le_event_connection_update_complete_parsing(0, buf, g_pattern_param)) {
                line = __LINE__;
                goto FUN_FAIL;
            }
    		buf[_BT_HCI_EVT_CON_COMP_CONN_HANDLE+0] = conn_handles_sla[0] ;
            buf[_BT_HCI_EVT_CON_COMP_CONN_HANDLE+1] = conn_handles_sla[1] ;

			COMM_Disconnect_Config(dut2,&g_pattern_param,buf);
			verdict=COMM_Disconnect(dut2_fd,g_pattern_param);
			VERDICT_RESULT_WITH_LINE();
               
            FUNC_END();


    		LOG_INFO("[Pattern][%s]SUCCESS\n", __FUNCTION__);
    		return PASS;
		}
	}

FUN_FAIL:
    FUNC_END();

    LOG_INFO("[Pattern][%s]:%d FAIL\n", __FUNCTION__, line);
    return FAIL;
}

// 5.5.2.2
verdict TIM_SLA_Earliest_Transmission_Start_to_Slave(u8 dut1_fd ,u8 dut2_fd)
{
    u8 buf[SOCKET_BUF_SIZE];
    int verdict = FAIL;
    int dut1 = 0;
    int dut2 = 0;
    u16 line = 0;
    struct itimerval timer;
    u8 conn_handles_mas[2];
    int adv_Channel = 37;

    COMM_Dut_clean_buffer(dut1_fd);
    COMM_Dut_clean_buffer(dut2_fd);

    Calculate_Execution_Time_Start();

    // Uptest(white list) config
    COMM_INI_Connection_Setup_White_Listed_Config(dut2, &g_pattern_param);
    memcpy(g_pattern_param.white_list_param.Address, scan_addr, ADDR_LENGTH);
    g_pattern_param.white_list_param.Address_Type[0] = HCI_CMD_PARAM_PUBLIC_DEVICE_ADDRESS;
    verdict = COMM_INI_Connection_Setup_White_Listed(dut2_fd, g_pattern_param);
    VERDICT_RESULT_WITH_LINE();

    COMM_ADV_Undirected_Advertising_Config(HCI_CMD_PARAM_ADV_DATA_LEN_MAX, &g_pattern_param);
    g_pattern_param.adv_param.Advertising_Filter_Policy[0] = HCI_CMD_PARAM_ALLOW_SCAN_REQ_FROM_WHITELIST_ONLY_AND_CONN_REQ_FROM_WHITELIST_ONLY;
    g_pattern_param.adv_param.Advertising_Interval_Max[0] = 0x00a0 & 0x00ff;
    g_pattern_param.adv_param.Advertising_Interval_Max[1] = (0x00a0 & 0xff00) >> 8;
    g_pattern_param.adv_param.Advertising_Interval_Min[0] = 0x00a0 & 0x00ff;
    g_pattern_param.adv_param.Advertising_Interval_Min[1] = (0x00a0 & 0xff00) >> 8;
    if(37 == adv_Channel) {
        g_pattern_param.adv_param.Advertising_Channel_Map[0] = HCI_CMD_PARAM_ENABLE_CHANNEL_37;
    }

    verdict = COMM_ADV_Undirected_Advertising(dut2_fd, g_pattern_param);
    VERDICT_RESULT_WITH_LINE();

    COMM_INI_Initiating_Config(dut1, &g_pattern_param);
    memcpy(g_pattern_param.create_conn_param.Peer_Address, adv_addr, ADDR_LENGTH );
    g_pattern_param.create_conn_param.Supervision_Timeout[0] 	=  0x03E8 & 0x00ff;
    g_pattern_param.create_conn_param.Supervision_Timeout[1]    = (0x03E8 & 0xff00)  >> 8;
    verdict = COMM_INI_Initiating(dut1_fd, g_pattern_param);
    VERDICT_RESULT_WITH_LINE();

    event_query_timer_config(5, 0, 0, 0, &timer);
    event_query_timer_start(timer, read_le_event_enable);

    //waiting adv report event , timer or counter
    while(1) {
        if(1 == read_le_event_get()) {
            read_le_event_disable();

            if(SUCCESS != QUERY_LE_Event(dut2_fd, buf, _BT_HCI_LE_EVENT_SUB_OP_CONNECTION_COMPLETE_, 0)) {
                line = __LINE__;
                goto FUN_FAIL;
            }

            if(SUCCESS != hci_le_event_connection_complete_parsing(0, buf, g_pattern_param)) {
                line = __LINE__;
                goto FUN_FAIL;
            }

            if(SUCCESS != QUERY_LE_Event(dut1_fd, buf, _BT_HCI_LE_EVENT_SUB_OP_CONNECTION_COMPLETE_, 0)) {
                line = __LINE__;
                goto FUN_FAIL;
            }

            if(SUCCESS != hci_le_event_connection_complete_parsing(0, buf, g_pattern_param)) {
                line = __LINE__;
                goto FUN_FAIL;
            }

            conn_handles_mas[0] = buf[_BT_HCI_EVT_CON_COMP_CONN_HANDLE+0];
            conn_handles_mas[1] = buf[_BT_HCI_EVT_CON_COMP_CONN_HANDLE+1];


            //######################################

            sleep(1);

			// # Slave Connection Terminated
			// use connect handle to disconnect
			buf[_BT_HCI_EVT_COMP_HANDLE+0] = conn_handles_mas[0];
			buf[_BT_HCI_EVT_COMP_HANDLE+1] = conn_handles_mas[1];
			
			COMM_Disconnect_Config(dut1,&g_pattern_param,buf);
			verdict=COMM_Disconnect(dut1_fd,g_pattern_param);
			VERDICT_RESULT_WITH_LINE();
                         
            FUNC_END();

            LOG_INFO("[Pattern][%s]SUCCESS\n", __FUNCTION__);
            return PASS;
        }
    }

FUN_FAIL:
    FUNC_END();
    LOG_INFO("[Pattern][%s]:%d FAIL\n", __FUNCTION__, line);
    return FAIL;
}

// 5.5.2.3
verdict TIM_SLA_Latest_Transmission_Start_to_Slave(u8 dut1_fd ,u8 dut2_fd)
{
    u8 buf[SOCKET_BUF_SIZE];
    int verdict = FAIL;
    int dut1 = 0;
    int dut2 = 0;
    u16 line = 0;
    struct itimerval timer;
    u8 conn_handles_mas[2];
    int adv_Channel = 37;

    COMM_Dut_clean_buffer(dut1_fd);
    COMM_Dut_clean_buffer(dut2_fd);

    Calculate_Execution_Time_Start();

    // Uptest(white list) config
    COMM_INI_Connection_Setup_White_Listed_Config(dut2, &g_pattern_param);
    memcpy(g_pattern_param.white_list_param.Address, scan_addr, ADDR_LENGTH);
    g_pattern_param.white_list_param.Address_Type[0] = HCI_CMD_PARAM_PUBLIC_DEVICE_ADDRESS;
    verdict = COMM_INI_Connection_Setup_White_Listed(dut2_fd, g_pattern_param);
    VERDICT_RESULT_WITH_LINE();

    COMM_ADV_Undirected_Advertising_Config(HCI_CMD_PARAM_ADV_DATA_LEN_MAX, &g_pattern_param);
    g_pattern_param.adv_param.Advertising_Filter_Policy[0] = HCI_CMD_PARAM_ALLOW_SCAN_REQ_FROM_WHITELIST_ONLY_AND_CONN_REQ_FROM_WHITELIST_ONLY;
    g_pattern_param.adv_param.Advertising_Interval_Max[0] = 0x00a0 & 0x00ff;
    g_pattern_param.adv_param.Advertising_Interval_Max[1] = (0x00a0 & 0xff00) >> 8;
    g_pattern_param.adv_param.Advertising_Interval_Min[0] = 0x00a0 & 0x00ff;
    g_pattern_param.adv_param.Advertising_Interval_Min[1] = (0x00a0 & 0xff00) >> 8;
    if(37 == adv_Channel) {
        g_pattern_param.adv_param.Advertising_Channel_Map[0] = HCI_CMD_PARAM_ENABLE_CHANNEL_37;
    }

    verdict = COMM_ADV_Undirected_Advertising(dut2_fd, g_pattern_param);
    VERDICT_RESULT_WITH_LINE();

    COMM_INI_Initiating_Config(dut1, &g_pattern_param);
    memcpy(g_pattern_param.create_conn_param.Peer_Address, adv_addr, ADDR_LENGTH );
    g_pattern_param.create_conn_param.Supervision_Timeout[0] 	=  69 & 0x00ff;
    g_pattern_param.create_conn_param.Supervision_Timeout[1]    = (69 & 0xff00)  >> 8;
    verdict = COMM_INI_Initiating(dut1_fd, g_pattern_param);
    VERDICT_RESULT_WITH_LINE();

    event_query_timer_config(5, 0, 0, 0, &timer);
    event_query_timer_start(timer, read_le_event_enable);

    //waiting adv report event , timer or counter
    while(1) {
        if(1 == read_le_event_get()) {
            read_le_event_disable();

            if(SUCCESS != QUERY_LE_Event(dut2_fd, buf, _BT_HCI_LE_EVENT_SUB_OP_CONNECTION_COMPLETE_, 0)) {
                line = __LINE__;
                goto FUN_FAIL;
            }

            if(SUCCESS != hci_le_event_connection_complete_parsing(0, buf, g_pattern_param)) {
                line = __LINE__;
                goto FUN_FAIL;
            }

            if(SUCCESS != QUERY_LE_Event(dut1_fd, buf, _BT_HCI_LE_EVENT_SUB_OP_CONNECTION_COMPLETE_, 0)) {
                line = __LINE__;
                goto FUN_FAIL;
            }

            if(SUCCESS != hci_le_event_connection_complete_parsing(0, buf, g_pattern_param)) {
                line = __LINE__;
                goto FUN_FAIL;
            }

            conn_handles_mas[0] = buf[_BT_HCI_EVT_CON_COMP_CONN_HANDLE+0];
            conn_handles_mas[1] = buf[_BT_HCI_EVT_CON_COMP_CONN_HANDLE+1];


            //######################################

            sleep(1);

			// # Slave Connection Terminated
			// use connect handle to disconnect
			buf[_BT_HCI_EVT_COMP_HANDLE+0] = conn_handles_mas[0];
			buf[_BT_HCI_EVT_COMP_HANDLE+1] = conn_handles_mas[1];
			
			COMM_Disconnect_Config(dut1,&g_pattern_param,buf);
			verdict=COMM_Disconnect(dut1_fd,g_pattern_param);
			VERDICT_RESULT_WITH_LINE();
                         
            FUNC_END();

            LOG_INFO("[Pattern][%s]SUCCESS\n", __FUNCTION__);
            return PASS;
        }
    }

FUN_FAIL:
    FUNC_END();

    LOG_INFO("[Pattern][%s]:%d FAIL\n", __FUNCTION__, line);
    return FAIL;
}

// 5.5.2.4
verdict TIM_SLA_Shortest_Connection_Interval(u8 dut1_fd ,u8 dut2_fd)
{
    u8 buf[SOCKET_BUF_SIZE];
    int verdict = FAIL;
    int dut1 = 0;
    int dut2 = 0;
    u16 line = 0;
    struct itimerval timer;

    int adv_Channel = 37;

    COMM_Dut_clean_buffer(dut1_fd);
    COMM_Dut_clean_buffer(dut2_fd);

    Calculate_Execution_Time_Start();

    // Uptest(white list) config
    COMM_INI_Connection_Setup_White_Listed_Config(dut2, &g_pattern_param);
    memcpy(g_pattern_param.white_list_param.Address, scan_addr, ADDR_LENGTH);
    g_pattern_param.white_list_param.Address_Type[0] = HCI_CMD_PARAM_PUBLIC_DEVICE_ADDRESS;
    verdict = COMM_INI_Connection_Setup_White_Listed(dut2_fd, g_pattern_param);
    VERDICT_RESULT_WITH_LINE();

    COMM_ADV_Undirected_Advertising_Config(HCI_CMD_PARAM_ADV_DATA_LEN_MAX, &g_pattern_param);
    g_pattern_param.adv_param.Advertising_Filter_Policy[0] = HCI_CMD_PARAM_ALLOW_SCAN_REQ_FROM_WHITELIST_ONLY_AND_CONN_REQ_FROM_WHITELIST_ONLY;
    g_pattern_param.adv_param.Advertising_Interval_Max[0] = 0x00a0 & 0x00ff;
    g_pattern_param.adv_param.Advertising_Interval_Max[1] = (0x00a0 & 0xff00) >> 8;
    g_pattern_param.adv_param.Advertising_Interval_Min[0] = 0x00a0 & 0x00ff;
    g_pattern_param.adv_param.Advertising_Interval_Min[1] = (0x00a0 & 0xff00) >> 8;
    if(37 == adv_Channel) {
        g_pattern_param.adv_param.Advertising_Channel_Map[0] = HCI_CMD_PARAM_ENABLE_CHANNEL_37;
    }

    verdict = COMM_ADV_Undirected_Advertising(dut2_fd, g_pattern_param);
    VERDICT_RESULT_WITH_LINE();

    COMM_INI_Initiating_Config(dut1, &g_pattern_param);
    memcpy(g_pattern_param.create_conn_param.Peer_Address, adv_addr, ADDR_LENGTH );
    g_pattern_param.create_conn_param.Conn_Interval_Min[0] 	    =  8 & 0x00ff;
    g_pattern_param.create_conn_param.Conn_Interval_Min[1]      = (8 & 0xff00)  >> 8;
    g_pattern_param.create_conn_param.Conn_Interval_Max[0] 	    =  8 & 0x00ff;
    g_pattern_param.create_conn_param.Conn_Interval_Max[1]      = (8 & 0xff00)  >> 8;
    g_pattern_param.create_conn_param.Supervision_Timeout[0] 	=  3200 & 0x00ff;
    g_pattern_param.create_conn_param.Supervision_Timeout[1]    = (3200 & 0xff00)  >> 8;
    verdict = COMM_INI_Initiating(dut1_fd, g_pattern_param);
    VERDICT_RESULT_WITH_LINE();

    event_query_timer_config(5, 0, 0, 0, &timer);
    event_query_timer_start(timer, read_le_event_enable);

    //waiting adv report event , timer or counter
    while(1) {
        if(1 == read_le_event_get()) {
            read_le_event_disable();

            if(SUCCESS != QUERY_LE_Event(dut2_fd, buf, _BT_HCI_LE_EVENT_SUB_OP_CONNECTION_COMPLETE_, 0)) {
                line = __LINE__;
                goto FUN_FAIL;
            }

            if(SUCCESS != hci_le_event_connection_complete_parsing(0, buf, g_pattern_param)) {
                line = __LINE__;
                goto FUN_FAIL;
            }


            //# add for conn success then reset . reconn will fail
			COMM_Disconnect_Config(dut1,&g_pattern_param,buf);
			verdict=COMM_Disconnect(dut1_fd,g_pattern_param);
			VERDICT_RESULT_WITH_LINE();


            //######################################
                        
            FUNC_END();


            LOG_INFO("[Pattern][%s]SUCCESS\n", __FUNCTION__);
            return PASS;
        }
    }

FUN_FAIL:
    FUNC_END();

    LOG_INFO("[Pattern][%s]:%d FAIL\n", __FUNCTION__, line);
    return FAIL;
}

// 5.7.1.1
verdict FRH_ADV_Accepting_Connections_with_Hop_Lengths (u8 dut1_fd ,u8 dut2_fd)
{
    u8 buf[SOCKET_BUF_SIZE];
    int verdict=FAIL;
    int dut1 =0;
    u16 line =0 ;
    struct itimerval timer;
    u8 conn_handles_mas[2];
    u32 sleep_s = 30;

    COMM_Dut_clean_buffer(dut1_fd);
    COMM_Dut_clean_buffer(dut2_fd);

    Calculate_Execution_Time_Start();

    //# p2 : enables advertising in the IUT using one advertising channel 
    COMM_ADV_Undirected_Advertising_Config(HCI_CMD_PARAM_ADV_DATA_LEN_MAX,&g_pattern_param);
    //here use lowest ch to testing
    g_pattern_param.adv_param.Advertising_Channel_Map[0] =HCI_CMD_PARAM_ENABLE_CHANNEL_37 ;
    verdict=COMM_ADV_Undirected_Advertising(dut2_fd,g_pattern_param);
    VERDICT_RESULT_WITH_LINE();


    COMM_INI_Connection_Setup_White_Listed_Config(dut1, &g_pattern_param);
	memcpy(g_pattern_param.white_list_param.Address, adv_addr, ADDR_LENGTH);
	verdict=COMM_INI_Connection_Setup_White_Listed(dut1_fd, g_pattern_param);
	VERDICT_RESULT_WITH_LINE();

    //# p1 : Configure Lower Tester to initiate a connection.
    COMM_INI_Initiating_Config(dut1,&g_pattern_param);
	g_pattern_param.create_conn_param.Initiator_Filter_Policy[0] =HCI_CMD_PARAM_FILTER_POLICY_WHITE_LIST_USED;
    
    verdict=COMM_INI_Initiating(dut1_fd,g_pattern_param);
    VERDICT_RESULT_WITH_LINE();

    event_query_timer_config(5 , 0 , 0 , 0, &timer);
    event_query_timer_start(timer ,read_le_event_enable );

    while(1)//waiting adv report event , timer or counter
    {
        if ( 1 == read_le_event_get() )
        {            
            read_le_event_disable();
        
            if (SUCCESS != QUERY_LE_Event(dut1_fd,buf ,
                                        _BT_HCI_LE_EVENT_SUB_OP_CONNECTION_COMPLETE_,
                                        0))
            {
                line=__LINE__;
                goto FUN_FAIL;
            }

            // #p4 : Upper Tester expects an HCI_LE_Connection_Complete event from the IUT
            if(SUCCESS != hci_le_event_connection_complete_parsing(0,
                                        buf,g_pattern_param))
            {
                line=__LINE__;
                goto FUN_FAIL;
            }

			conn_handles_mas[0]=buf[_BT_HCI_EVT_COMP_HANDLE+0];
			conn_handles_mas[1]=buf[_BT_HCI_EVT_COMP_HANDLE+1];

            if (SUCCESS != QUERY_LE_Event(dut2_fd,buf ,
                                        _BT_HCI_LE_EVENT_SUB_OP_CONNECTION_COMPLETE_,
                                        0))
            {
                line=__LINE__;
                goto FUN_FAIL;
            }


			if(SUCCESS != hci_le_event_connection_complete_parsing(0,
										buf,g_pattern_param))
			{
				line=__LINE__;
				goto FUN_FAIL;
			}

            // #p7 check per channel use;

            sleep(sleep_s);

			// #p8 Slave Connection Terminated
			// use connect handle to disconnect

            buf[_BT_HCI_EVT_COMP_HANDLE+0] = conn_handles_mas[0];
            buf[_BT_HCI_EVT_COMP_HANDLE+1] = conn_handles_mas[1];

			COMM_Disconnect_Config(dut1,&g_pattern_param,buf);
			verdict=COMM_Disconnect(dut1_fd,g_pattern_param);
			VERDICT_RESULT_WITH_LINE();

            FUNC_END();


            LOG_INFO("[Pattern][%s]SUCCESS\n" ,__FUNCTION__);
            return PASS;
        }
    }

FUN_FAIL:

    FUNC_END();

    
    LOG_INFO("[Pattern][%s]:%d FAIL\n" ,__FUNCTION__,line);   
    return FAIL;

}

 
// 5.7.2.1
verdict FRH_SLA_Accepting_Channel_Map_Update (u8 dut1_fd ,u8 dut2_fd)
{
    u8 buf[SOCKET_BUF_SIZE];
    int verdict=FAIL;
    int dut1 =0;
    u16 line =0 ;
    struct itimerval timer;
    u8 conn_handles_mas[2];
    //u32 sleep_s = 30;

    COMM_Dut_clean_buffer(dut1_fd);
    COMM_Dut_clean_buffer(dut2_fd);

    Calculate_Execution_Time_Start();

    //# p2 : enables advertising in the IUT using one advertising channel 
    COMM_ADV_Undirected_Advertising_Config(HCI_CMD_PARAM_ADV_DATA_LEN_MAX,&g_pattern_param);
    //here use lowest ch to testing
    g_pattern_param.adv_param.Advertising_Channel_Map[0] =HCI_CMD_PARAM_ENABLE_CHANNEL_37 ;
    verdict=COMM_ADV_Undirected_Advertising(dut2_fd,g_pattern_param);
    VERDICT_RESULT_WITH_LINE();

    //# p1 : Configure Lower Tester to initiate a connection.
    COMM_INI_Initiating_Config(dut1,&g_pattern_param);
    verdict=COMM_INI_Initiating(dut1_fd,g_pattern_param);
    VERDICT_RESULT_WITH_LINE();

    event_query_timer_config(5 , 0 , 0 , 0, &timer);
    event_query_timer_start(timer ,read_le_event_enable );

    while(1)//waiting adv report event , timer or counter
    {
        if ( 1 == read_le_event_get() )
        {            
            read_le_event_disable();
        
            if (SUCCESS != QUERY_LE_Event(dut1_fd,buf ,
                                        _BT_HCI_LE_EVENT_SUB_OP_CONNECTION_COMPLETE_,
                                        0))
            {
                line=__LINE__;
                goto FUN_FAIL;
            }

            // #p4 : Upper Tester expects an HCI_LE_Connection_Complete event from the IUT
            if(SUCCESS != hci_le_event_connection_complete_parsing(0,
                                        buf,g_pattern_param))
            {
                line=__LINE__;
                goto FUN_FAIL;
            }

			conn_handles_mas[0]=buf[_BT_HCI_EVT_COMP_HANDLE+0];
			conn_handles_mas[1]=buf[_BT_HCI_EVT_COMP_HANDLE+1];

			buf[_BT_HCI_EVT_COMP_HANDLE+0] = conn_handles_mas[0];
			buf[_BT_HCI_EVT_COMP_HANDLE+1] = conn_handles_mas[1];

            // #p7 check per channel use;

            COMM_Ch_Map_Set_Config(dut1 , &g_pattern_param , CH_MAP_EVEN);
            verdict=COMM_Ch_Map_Set(dut1_fd , g_pattern_param);
			VERDICT_RESULT_WITH_LINE();

            sleep(3);
            
            COMM_Ch_Map_Set_Config(dut1 , &g_pattern_param , CH_MAP_FULL);
            verdict=COMM_Ch_Map_Set(dut1_fd , g_pattern_param);
			VERDICT_RESULT_WITH_LINE();

            sleep(3);

			// #p8 Slave Connection Terminated
			// use connect handle to disconnect

			COMM_Disconnect_Config(dut1,&g_pattern_param,buf);
			verdict=COMM_Disconnect(dut1_fd,g_pattern_param);
			VERDICT_RESULT_WITH_LINE();

            FUNC_END();

            LOG_INFO("[Pattern][%s]SUCCESS\n" ,__FUNCTION__);
            return PASS;
        }
    }

FUN_FAIL:
    FUNC_END();  
    LOG_INFO("[Pattern][%s]:%d FAIL\n" ,__FUNCTION__,line);
    return FAIL;

}


// 5.9.1.1
verdict SEC_ADV_Advertising_With_Random_Address (u8 dut1_fd ,u8 dut2_fd)
{
	u8 buf[SOCKET_BUF_SIZE];
	int verdict=FAIL;
	int dut1 =0;
	u16 line =0 ;
	struct itimerval timer;
    u16 adv_chk_error = 0;
    u16 scn_chk_error = 0;

    COMM_Dut_clean_buffer(dut1_fd);
    COMM_Dut_clean_buffer(dut2_fd);

    Calculate_Execution_Time_Start();
    // #p1 Upper Tester sends an HCI_LE_Set_Random_Address command to set the IUT random address. 
	// just add all random address for all dut
	//COMM_Add_Device_To_White_List_Config(HCI_CMD_PARAM_RANDOM_DEVICE_ADDRESS,scan_random_addr,&g_pattern_param);
	//COMM_Add_Device_To_White_List(dut1_fd,g_pattern_param);
	COMM_Add_Device_To_White_List_Config(HCI_CMD_PARAM_RANDOM_DEVICE_ADDRESS,adv_random_addr,&g_pattern_param);
	COMM_Add_Device_To_White_List(dut1_fd,g_pattern_param);

	COMM_Add_Device_To_White_List_Config(HCI_CMD_PARAM_RANDOM_DEVICE_ADDRESS,scan_random_addr,&g_pattern_param);
	COMM_Add_Device_To_White_List(dut2_fd,g_pattern_param);
	//COMM_Add_Device_To_White_List_Config(HCI_CMD_PARAM_RANDOM_DEVICE_ADDRESS,adv_random_addr,&g_pattern_param);
	//COMM_Add_Device_To_White_List(dut2_fd,g_pattern_param);

	COMM_Static_Random_Device_Address_Set_Config(scan_random_addr);
	COMM_Device_Address_Set(dut1_fd,g_pattern_param);

	COMM_Static_Random_Device_Address_Set_Config(adv_random_addr);
	COMM_Device_Address_Set(dut2_fd,g_pattern_param);

	COMM_SCN_Active_Scanning_Config(dut1,&g_pattern_param);
	g_pattern_param.scn_param.Own_Address_Type[0]	=	HCI_CMD_PARAM_RANDOM_DEVICE_ADDRESS;
	g_pattern_param.scn_param.LE_Scan_Interval[0]	=	    HCI_CMD_PARAM_SCAN_INT_MAX/3  & 0x00ff ;
	g_pattern_param.scn_param.LE_Scan_Interval[1]	=	   ((HCI_CMD_PARAM_SCAN_INT_MAX/3)  & 0xff00) >> 8;
	g_pattern_param.scn_param.LE_Scan_Window[0]	=	        HCI_CMD_PARAM_SCAN_INT_MAX/3  & 0x00ff ;
	g_pattern_param.scn_param.LE_Scan_Window[1]	=	       ((HCI_CMD_PARAM_SCAN_INT_MAX/3)  & 0xff00) >> 8;
    
	g_pattern_param.scn_param.Scanning_Filter_Policy[0] =	HCI_CMD_PARAM_IGNORE_ADV_PKTS_FROM_DEV_NOT_IN_WHITE_LIST_ONLY;
	verdict = COMM_SCN_Active_Scanning(dut1_fd,g_pattern_param);
	VERDICT_RESULT_WITH_LINE();
    
    // #p2 : Upper Tester enables undirected advertising and sets scan response data in the IUT. 
	COMM_ADV_Undirected_Advertising_Config(HCI_CMD_PARAM_ADV_DATA_LEN_MAX,&g_pattern_param);
    // #p3 : Configure the Lower Tester active scanning with random device address. 
	g_pattern_param.adv_param.Own_Address_Type[0]	    =	HCI_CMD_PARAM_RANDOM_DEVICE_ADDRESS;
	g_pattern_param.adv_param.Direct_Address_Type[0]	=	HCI_CMD_PARAM_RANDOM_DEVICE_ADDRESS;

	g_pattern_param.adv_param.Advertising_Interval_Min[0]=0xa0 & 0x00ff;
	g_pattern_param.adv_param.Advertising_Interval_Min[1]=(0xa0 & 0xff00) >> 8;
	g_pattern_param.adv_param.Advertising_Interval_Max[0]=0xa0 & 0x00ff;
	g_pattern_param.adv_param.Advertising_Interval_Max[1]=(0xa0 & 0xff00)	>> 8;
    
	g_pattern_param.adv_param.Advertising_Channel_Map[0] =  HCI_CMD_PARAM_ENABLE_CHANNEL_37 ;
	g_pattern_param.adv_param.Advertising_Filter_Policy[0] =
		HCI_CMD_PARAM_ALLOW_SCAN_REQ_FROM_WHITELIST_ONLY_AND_CONN_REQ_FROM_WHITELIST_ONLY;

    memcpy (g_pattern_param.adv_param.Direct_Address , adv_random_addr , ADDR_LENGTH);    
	verdict=COMM_ADV_Undirected_Advertising(dut2_fd,g_pattern_param);
	VERDICT_RESULT_WITH_LINE();

	event_query_timer_config(1 , 0 , 0 , 0, &timer);
	event_query_timer_start(timer ,read_le_event_enable );

	while(1)//waiting adv report event , timer or counter
	{
		if ( 1== read_le_event_get() )
		{
			//reset event flag
			//read_le_event_disable();
			//event add
            MSLEEP(10);

			//query adv_ind
			if (SUCCESS != QUERY_LE_Event(dut1_fd,buf ,
										_BT_HCI_LE_EVENT_SUB_OP_ADVERTISING_REPORT_,
										HCI_SUBEVENT_ADV_RPT_EVENT_ADV_IND))
			{
				line=__LINE__;
				goto FUN_FAIL;
			}

            // # p4 : Lower Tester expects an ADV_IND packet from the IUT using the advertising 
            // random address  

			if(EQUAL != hci_le_event_advertising_report_parsing(HCI_SUBEVENT_ADV_RPT_EVENT_ADV_IND,
															buf,g_pattern_param))
			{
			    if(adv_chk_error < 300){
                    printf("adv check err with %d \n" , adv_chk_error);
                    adv_chk_error ++ ;
                    continue;
			    }
                else{
    				line=__LINE__;
    				goto FUN_FAIL;
                }
			}

            adv_chk_error = 0;
            
			//query scan_rsp
			if (SUCCESS != QUERY_LE_Event(dut1_fd,buf ,
										_BT_HCI_LE_EVENT_SUB_OP_ADVERTISING_REPORT_,
										HCI_SUBEVENT_ADV_RPT_EVENT_SCAN_RSP))
			{
				line=__LINE__;
				goto FUN_FAIL;
			}

            // # p6 :Lower Tester expects an SCAN_RSP packet from the IUT addressed to the 
            // tester after T_IFS from the end of the request packet. 

			if(EQUAL != hci_le_event_advertising_report_parsing(HCI_SUBEVENT_ADV_RPT_EVENT_SCAN_RSP,
															buf,g_pattern_param))
			{
			    if(scn_chk_error < 300){
                    printf("scn check err with %d \n" , scn_chk_error);
                    scn_chk_error ++;
                    continue;
			    }
                else{
    				line=__LINE__;
    				goto FUN_FAIL;
                }

			}

            // #p7 : Upper Tester sends an HCI_LE_Set_Advertise_Enable command to disable 
            // advertising in the IUT and expects an HCI_Command_Complete event from 
            // the IUT. 
            
			//COMM_ADV_Disable_Config(dut2_fd,&g_pattern_param);
			//verdict=COMM_ADV_Disable(dut2_fd,g_pattern_param);
			//VERDICT_RESULT_WITH_LINE();

            FUNC_END();

			LOG_INFO("[Pattern][%s]SUCCESS\n" ,__FUNCTION__);
			return PASS;
		}
	}

FUN_FAIL:
    FUNC_END();

	LOG_INFO("[Pattern][%s]:%d FAIL\n" ,__FUNCTION__,line);
    return FAIL;

}


// 5.9.2.1
verdict SEC_SCN_Random_Address_Scanning (u8 dut1_fd ,u8 dut2_fd)
{

	u8 buf[SOCKET_BUF_SIZE];
	int verdict=FAIL;
	int dut2 = 0;
	u16 line =0 ;
	struct itimerval timer;
	u32 adv_cnt=0;

    COMM_Dut_clean_buffer(dut1_fd);
    COMM_Dut_clean_buffer(dut2_fd);
    Calculate_Execution_Time_Start();

	//#2 = scanner ; #1 =advertiser
	//just add all random address for all dut
	COMM_Add_Device_To_White_List_Config(HCI_CMD_PARAM_RANDOM_DEVICE_ADDRESS,scan_random_addr,&g_pattern_param);
	COMM_Add_Device_To_White_List(dut1_fd,g_pattern_param);
	COMM_Add_Device_To_White_List_Config(HCI_CMD_PARAM_RANDOM_DEVICE_ADDRESS,adv_random_addr,&g_pattern_param);
	COMM_Add_Device_To_White_List(dut1_fd,g_pattern_param);

	COMM_Add_Device_To_White_List_Config(HCI_CMD_PARAM_RANDOM_DEVICE_ADDRESS,scan_random_addr,&g_pattern_param);
	COMM_Add_Device_To_White_List(dut2_fd,g_pattern_param);
	COMM_Add_Device_To_White_List_Config(HCI_CMD_PARAM_RANDOM_DEVICE_ADDRESS,adv_random_addr,&g_pattern_param);
	COMM_Add_Device_To_White_List(dut2_fd,g_pattern_param);

	COMM_Static_Random_Device_Address_Set_Config(scan_random_addr);
	COMM_Device_Address_Set(dut2_fd,g_pattern_param);

	COMM_Static_Random_Device_Address_Set_Config(adv_random_addr);
	COMM_Device_Address_Set(dut1_fd,g_pattern_param);

	COMM_SCN_Active_Scanning_Config(dut2,&g_pattern_param);
	g_pattern_param.scn_param.Scanning_Filter_Policy[0] =	HCI_CMD_PARAM_IGNORE_ADV_PKTS_FROM_DEV_NOT_IN_WHITE_LIST_ONLY;
	g_pattern_param.scn_param.Own_Address_Type[0]	=	    HCI_CMD_PARAM_RANDOM_DEVICE_ADDRESS;
	g_pattern_param.scn_param.LE_Scan_Interval[0]	=	    HCI_CMD_PARAM_SCAN_INT_MAX & 0x00ff ;
	g_pattern_param.scn_param.LE_Scan_Interval[1]	=	   (HCI_CMD_PARAM_SCAN_INT_MAX  & 0xff00) >> 8;
	g_pattern_param.scn_param.LE_Scan_Window[0]	=	        HCI_CMD_PARAM_SCAN_INT_MAX  & 0x00ff ;
	g_pattern_param.scn_param.LE_Scan_Window[1]	=	       (HCI_CMD_PARAM_SCAN_INT_MAX  & 0xff00) >> 8;

	verdict = COMM_SCN_Active_Scanning(dut2_fd,g_pattern_param);
	VERDICT_RESULT_WITH_LINE();

	COMM_ADV_Undirected_Advertising_Config(HCI_CMD_PARAM_ADV_DATA_LEN_MAX,&g_pattern_param);
	g_pattern_param.adv_param.Own_Address_Type[0]	=	HCI_CMD_PARAM_RANDOM_DEVICE_ADDRESS;
    g_pattern_param.adv_param.Advertising_Interval_Min[0]=0xa0 & 0x00ff;
	g_pattern_param.adv_param.Advertising_Interval_Min[1]=(0xa0 & 0xff00) >> 8;
	g_pattern_param.adv_param.Advertising_Interval_Max[0]=0xa0 & 0x00ff;
	g_pattern_param.adv_param.Advertising_Interval_Max[1]=(0xa0 & 0xff00)	>> 8;

	g_pattern_param.adv_param.Advertising_Channel_Map[0] =HCI_CMD_PARAM_ENABLE_CHANNEL_37 ;
	g_pattern_param.adv_param.Advertising_Filter_Policy[0] =
		HCI_CMD_PARAM_ALLOW_SCAN_REQ_FROM_WHITELIST_ONLY_AND_CONN_REQ_FROM_WHITELIST_ONLY;

    memcpy(g_pattern_param.adv_param.Direct_Address , adv_random_addr, ADDR_LENGTH);

	verdict=COMM_ADV_Undirected_Advertising(dut1_fd,g_pattern_param);
	VERDICT_RESULT_WITH_LINE();

	event_query_timer_config(1 , 0, 0 , 0, &timer);
	event_query_timer_start(timer ,read_le_event_enable );

	while(1)//waiting adv report event , timer or counter
	{
		if ( 1== read_le_event_get() )
		{
			//reset event flag
			//read_le_event_disable();
            MSLEEP(10);
			//event add
			adv_cnt++;
			//query adv_ind
			if (SUCCESS != QUERY_LE_Event(dut2_fd,buf ,
										_BT_HCI_LE_EVENT_SUB_OP_ADVERTISING_REPORT_,
										HCI_SUBEVENT_ADV_RPT_EVENT_ADV_IND))
			{
				line=__LINE__;
				goto FUN_FAIL;
			}

			if(EQUAL != hci_le_event_advertising_report_parsing(HCI_SUBEVENT_ADV_RPT_EVENT_ADV_IND,
															buf,g_pattern_param))
			{
                if (adv_cnt < 50){
                    adv_cnt ++;
                    continue;
                }
                else{
    				line=__LINE__;
    				goto FUN_FAIL;
                }
			}

			//query scan_rsp
			if (SUCCESS != QUERY_LE_Event(dut2_fd,buf ,
										_BT_HCI_LE_EVENT_SUB_OP_ADVERTISING_REPORT_,
										HCI_SUBEVENT_ADV_RPT_EVENT_SCAN_RSP))
			{
				line=__LINE__;
				goto FUN_FAIL;
			}

			if(EQUAL != hci_le_event_advertising_report_parsing(HCI_SUBEVENT_ADV_RPT_EVENT_SCAN_RSP,
															buf,g_pattern_param))
			{
				line=__LINE__;
				goto FUN_FAIL;
			}
//add address	check here ; adv_addr is right ?
			if( 0 != memcmp ( buf + _BT_HCI_EVT_ADV_RPT_ADDR0 , adv_random_addr , ADDR_LENGTH))
			{
				line=__LINE__;
				goto FUN_FAIL;
			}
			//COMM_ADV_Disable_Config(dut1_fd,&g_pattern_param);
			//verdict=COMM_ADV_Disable(dut1_fd,g_pattern_param);
			//VERDICT_RESULT_WITH_LINE();

//sholud add item10 here

            FUNC_END();

			LOG_INFO("[Pattern][%s]SUCCESS\n" ,__FUNCTION__);
			return PASS;
		}
	}

FUN_FAIL:
    FUNC_END();
    
	LOG_INFO("[Pattern][%s]:%d FAIL\n" ,__FUNCTION__,line);
    return FAIL;

}


// 5.9.4.1
verdict SEC_SLA_Slave_Encryption_Mode_Setup (u8 dut1_fd ,u8 dut2_fd)
{
	u8 buf[SOCKET_BUF_SIZE];
	u16 len;
	int verdict=FAIL;
	int dut1 = 0;
	u16 line =0 ;
	struct itimerval timer;
	u8 conn_handles_mas[2];
	u8 conn_handles_sla[2];
	u8 acl_data[10]={0};
	u16 test_cnt1=1000;
	u16 test_cnt2=1000;
    u8 addr_type = HCI_CMD_PARAM_PUBLIC_DEVICE_ADDRESS ; 
    //u8 addr_type = HCI_CMD_PARAM_RANDOM_DEVICE_ADDRESS ; 

    int sla_pkt_chk ;

    COMM_Dut_clean_buffer(dut1_fd);
    COMM_Dut_clean_buffer(dut2_fd);

    Calculate_Execution_Time_Start();

REPEAT:    

    if(addr_type == HCI_CMD_PARAM_PUBLIC_DEVICE_ADDRESS){

    	COMM_ADV_Directed_Advertising_Config(HCI_CMD_PARAM_ADV_DATA_LEN_MAX,&g_pattern_param);
    	//here use lowest ch to testing
    	g_pattern_param.adv_param.Advertising_Channel_Map[0] =HCI_CMD_PARAM_ENABLE_CHANNEL_37 ;
    	verdict=COMM_ADV_Directed_Advertising(dut2_fd,g_pattern_param);
    	VERDICT_RESULT_WITH_LINE();

    	COMM_INI_Initiating_Config(dut1,&g_pattern_param);
    	verdict=COMM_INI_Initiating(dut1_fd,g_pattern_param);
    	VERDICT_RESULT_WITH_LINE();
    }else{

        // ###########################################################
        COMM_Static_Random_Device_Address_Set_Config(scan_random_addr);
        COMM_Device_Address_Set(dut1_fd,g_pattern_param);
        
        COMM_Static_Random_Device_Address_Set_Config(adv_random_addr);
        COMM_Device_Address_Set(dut2_fd,g_pattern_param);

        COMM_ADV_Undirected_Advertising_Config(HCI_CMD_PARAM_ADV_DATA_LEN_MAX,&g_pattern_param);

        memcpy(g_pattern_param.adv_param.Direct_Address, adv_random_addr, ADDR_LENGTH);
        g_pattern_param.adv_param.Own_Address_Type[0] = HCI_CMD_PARAM_RANDOM_DEVICE_ADDRESS;
        g_pattern_param.adv_param.Direct_Address[0]   = HCI_CMD_PARAM_RANDOM_DEVICE_ADDRESS;

        g_pattern_param.adv_param.Advertising_Interval_Min[0]=0xa0 & 0x00ff;
        g_pattern_param.adv_param.Advertising_Interval_Min[1]=(0xa0 & 0xff00) >> 8;
        g_pattern_param.adv_param.Advertising_Interval_Max[0]=0xa0 & 0x00ff;
        g_pattern_param.adv_param.Advertising_Interval_Max[1]=(0xa0 & 0xff00)   >> 8;


        //here use lowest ch to testing
        g_pattern_param.adv_param.Advertising_Channel_Map[0] =HCI_CMD_PARAM_ENABLE_CHANNEL_37 ;
        verdict=COMM_ADV_Undirected_Advertising(dut2_fd,g_pattern_param);
        VERDICT_RESULT_WITH_LINE();
        
        COMM_INI_Initiating_Config(dut1,&g_pattern_param);
        g_pattern_param.create_conn_param.Peer_Address_Type[0] = HCI_CMD_PARAM_RANDOM_DEVICE_ADDRESS;
        memcpy(g_pattern_param.create_conn_param.Peer_Address ,adv_random_addr,ADDR_LENGTH );
        g_pattern_param.create_conn_param.Own_Address_Type[0]  =HCI_CMD_PARAM_RANDOM_DEVICE_ADDRESS;

        verdict=COMM_INI_Initiating(dut1_fd,g_pattern_param);
        VERDICT_RESULT_WITH_LINE();
    }
    

	event_query_timer_config(5 , 0 , 0 , 0, &timer);
	event_query_timer_start(timer ,read_le_event_enable );

	while(1)//waiting adv report event , timer or counter
	{
		if ( 1 == read_le_event_get() )
		{

            read_le_event_disable();
            
			if (SUCCESS != QUERY_LE_Event(dut1_fd,buf ,
										_BT_HCI_LE_EVENT_SUB_OP_CONNECTION_COMPLETE_,
										0))
			{
				line=__LINE__;
				goto FUN_FAIL;
			}

			if(SUCCESS != hci_le_event_connection_complete_parsing(0,
										buf,g_pattern_param))
			{
				line=__LINE__;
				goto FUN_FAIL;
			}

			conn_handles_mas[0]=buf[_BT_HCI_EVT_COMP_HANDLE+0];
			conn_handles_mas[1]=buf[_BT_HCI_EVT_COMP_HANDLE+1];


			if (SUCCESS != QUERY_LE_Event(dut2_fd,buf ,
										_BT_HCI_LE_EVENT_SUB_OP_CONNECTION_COMPLETE_,
										0))
			{
				line=__LINE__;
				goto FUN_FAIL;
			}

			if(SUCCESS != hci_le_event_connection_complete_parsing(0,
										buf,g_pattern_param))
			{
				line=__LINE__;
				goto FUN_FAIL;
			}


			conn_handles_sla[0]=buf[_BT_HCI_EVT_COMP_HANDLE+0];
			conn_handles_sla[1]=buf[_BT_HCI_EVT_COMP_HANDLE+1];

			for ( ;test_cnt1 > 0 ; test_cnt1 --)
			{
                printf("send cnt %d\n" , test_cnt1);
            
				COMM_Send_ACL_Data_Without_event(dut2_fd,conn_handles_sla,0b00,0,10,acl_data);
PKT_CHK1:
                // # check disconnection             
                CHECK_NON_DISCONNECT();

                if(SUCCESS != QUERY_Event(dut2_fd, buf, _BT_HCI_EVENT_OP_NUMBER_OF_COMPLETED_PACKETS_)) {
                    line = __LINE__;
                    goto FUN_FAIL;
                }
                else if(1 != hci_event_num_of_completed_packets_parsing(buf)) {

                    MSLEEP(10);
                    sla_pkt_chk ++ ;
                    if (sla_pkt_chk == 100){
                        printf("sla no number of completed pkts\n");
                        line = __LINE__;
                        goto FUN_FAIL;                  
                    }
                    goto PKT_CHK1;
                
                }                 
                
                sla_pkt_chk = 0;
			
                usleep(SLEEP_MS);

    			if (SUCCESS != QUERY_Acl_Data(dut1_fd,buf))
    			{
    				line=__LINE__;
    				goto FUN_FAIL;
    			}

    			if (0b10 != (buf [_BT_HCI_IDX_ACL_DATA_CONN_HANDLE_ + 1] & 0xF0 ) >> 4)
    			{
    				line=__LINE__;
    				goto FUN_FAIL;
    			}

                if (0 != memcmp(buf+_BT_HCI_IDX_ACL_DATA_PAYLOAD_ , acl_data ,buf[_BT_HCI_IDX_ACL_DATA_LENGTH_]))
                {
                    line=__LINE__;
                    goto FUN_FAIL;
                }


            }

			//######################################

            sleep(1);

			COMM_Start_Encryption_Config(dut1_fd,&g_pattern_param, conn_handles_mas);
			verdict=COMM_Start_Encryption(dut1_fd,g_pattern_param);
			VERDICT_RESULT_WITH_LINE();

            do{
                socket_msg_get(dut2_fd,&len,buf);
            }while(len <=0);
			printf("Get Event(%d):\n",dut2_fd);
			print_charray(len,buf);
			if(SUCCESS != hci_le_event_ltk_request_parsing(0,buf,g_pattern_param))
			{
				line=__LINE__;
				goto FUN_FAIL;
			}

			COMM_Ltk_Req_Rep_Config(dut2_fd,&g_pattern_param, conn_handles_sla);//peer conn_handle?
			verdict=COMM_Ltk_Req_Rep(dut2_fd,g_pattern_param);
			VERDICT_RESULT_WITH_LINE();

			sleep(1); //waiting encryption change
			
			if (SUCCESS != QUERY_Event(dut1_fd,buf ,_BT_HCI_EVENT_OP_ENCRYPTION_CHANGE_))
			{
				line=__LINE__;
				goto FUN_FAIL;
			}

			if(SUCCESS != hci_event_encryption_change_parsing(0,buf,g_pattern_param))
			{
				line=__LINE__;
				goto FUN_FAIL;
			}

				//######################################
			for ( ;test_cnt2 > 0 ; test_cnt2 --)
			{

                printf("send cnt %d\n" , test_cnt2);
            
				COMM_Send_ACL_Data_Without_event(dut2_fd,conn_handles_sla,0b00,0,10,acl_data);
PKT_CHK2:
                // # check disconnection             
                CHECK_NON_DISCONNECT();
    
                if(SUCCESS != QUERY_Event(dut2_fd, buf, _BT_HCI_EVENT_OP_NUMBER_OF_COMPLETED_PACKETS_)) {
                    line = __LINE__;
                    goto FUN_FAIL;
                }
                else if(1 != hci_event_num_of_completed_packets_parsing(buf)) {

                    MSLEEP(100);
                    sla_pkt_chk ++ ;
                    if (sla_pkt_chk == 100){
                        printf("sla no number of completed pkts\n");
                        line = __LINE__;
                        goto FUN_FAIL;                  
                    }
                    goto PKT_CHK2;
                
                }                 
                
                sla_pkt_chk = 0;


                usleep(SLEEP_MS);
    			if (SUCCESS != QUERY_Acl_Data(dut1_fd,buf))
    			{
    				line=__LINE__;
    				goto FUN_FAIL;
    			}

    			if (0b10 != (buf [_BT_HCI_IDX_ACL_DATA_CONN_HANDLE_ + 1] & 0xF0 ) >> 4)
    			{
    				line=__LINE__;
    				goto FUN_FAIL;
    			}
                
            }
			//######################################


            if (addr_type == HCI_CMD_PARAM_PUBLIC_DEVICE_ADDRESS ){
                addr_type = HCI_CMD_PARAM_RANDOM_DEVICE_ADDRESS ; 

                buf[_BT_HCI_EVT_CON_COMP_CONN_HANDLE+0] = conn_handles_mas[0];
                buf[_BT_HCI_EVT_CON_COMP_CONN_HANDLE+1] = conn_handles_mas[1];
                
                COMM_Disconnect_Config(dut1, &g_pattern_param,buf);
                verdict = COMM_Disconnect(dut1_fd, g_pattern_param);
                VERDICT_RESULT_WITH_LINE();


                sleep(10);
                goto REPEAT ;
            }

            COMM_Disconnect_Config(dut1, &g_pattern_param,buf);
            verdict = COMM_Disconnect(dut1_fd, g_pattern_param);

            FUNC_END();

			LOG_INFO("[Pattern][%s]SUCCESS\n" ,__FUNCTION__);
			return PASS;
		}
	}

FUN_FAIL:

    FUNC_END();
    
	LOG_INFO("[Pattern][%s]:%d FAIL\n" ,__FUNCTION__,line);
    return FAIL;

}


// 5.9.4.2
verdict SEC_SLA_Slave_Pause_Encryption (u8 dut1_fd ,u8 dut2_fd)
{
	u8 buf[SOCKET_BUF_SIZE];
	u16 len;
	int verdict=FAIL;
	int dut1 = 0;
	u16 line =0 ;
	struct itimerval timer;
	u8 conn_handles_mas[2];
	u8 conn_handles_sla[2];

    COMM_Dut_clean_buffer(dut1_fd);
    COMM_Dut_clean_buffer(dut2_fd);

    Calculate_Execution_Time_Start();

	COMM_ADV_Directed_Advertising_Config(HCI_CMD_PARAM_ADV_DATA_LEN_MAX,&g_pattern_param);
	//here use lowest ch to testing
	g_pattern_param.adv_param.Advertising_Channel_Map[0] =HCI_CMD_PARAM_ENABLE_CHANNEL_37 ;
	verdict=COMM_ADV_Directed_Advertising(dut2_fd,g_pattern_param);
	VERDICT_RESULT_WITH_LINE();

	COMM_INI_Initiating_Config(dut1,&g_pattern_param);
	verdict=COMM_INI_Initiating(dut1_fd,g_pattern_param);
	VERDICT_RESULT_WITH_LINE();

	event_query_timer_config(5 , 0 , 0 , 0, &timer);
	event_query_timer_start(timer ,read_le_event_enable );

	while(1)//waiting adv report event , timer or counter
	{
		if ( 1 == read_le_event_get() )
		{            
            read_le_event_disable();
        
			if (SUCCESS != QUERY_LE_Event(dut1_fd,buf ,
										_BT_HCI_LE_EVENT_SUB_OP_CONNECTION_COMPLETE_,
										0))
			{
				line=__LINE__;
				goto FUN_FAIL;
			}

			if(SUCCESS != hci_le_event_connection_complete_parsing(0,
										buf,g_pattern_param))
			{
				line=__LINE__;
				goto FUN_FAIL;
			}

			conn_handles_mas[0]=buf[_BT_HCI_EVT_COMP_HANDLE+0];
			conn_handles_mas[1]=buf[_BT_HCI_EVT_COMP_HANDLE+1];


			if (SUCCESS != QUERY_LE_Event(dut2_fd,buf ,
										_BT_HCI_LE_EVENT_SUB_OP_CONNECTION_COMPLETE_,
										0))
			{
				line=__LINE__;
				goto FUN_FAIL;
			}

			if(SUCCESS != hci_le_event_connection_complete_parsing(0,
										buf,g_pattern_param))
			{
				line=__LINE__;
				goto FUN_FAIL;
			}

			conn_handles_sla[0]=buf[_BT_HCI_EVT_COMP_HANDLE+0];
			conn_handles_sla[1]=buf[_BT_HCI_EVT_COMP_HANDLE+1];

			COMM_Start_Encryption_Config(dut1_fd,&g_pattern_param, conn_handles_mas);
			verdict=COMM_Start_Encryption(dut1_fd,g_pattern_param);
			VERDICT_RESULT_WITH_LINE();

            do{
                socket_msg_get(dut2_fd,&len,buf);
            }while(len <=0);
			printf("Get Event(%d):\n",dut2_fd);
			print_charray(len,buf);
			if(SUCCESS != hci_le_event_ltk_request_parsing(0,buf,g_pattern_param))
			{
				line=__LINE__;
				goto FUN_FAIL;
			}

			COMM_Ltk_Req_Rep_Config(dut2_fd,&g_pattern_param, conn_handles_sla);//peer conn_handle?
			verdict=COMM_Ltk_Req_Rep(dut2_fd,g_pattern_param);
			VERDICT_RESULT_WITH_LINE();

			sleep(1); //waiting encryption change
			if (SUCCESS != QUERY_Event(dut2_fd,buf ,_BT_HCI_EVENT_OP_ENCRYPTION_CHANGE_))
			{
				line=__LINE__;
				goto FUN_FAIL;
			}

			if(SUCCESS != hci_event_encryption_change_parsing(0,buf,g_pattern_param))
			{
				line=__LINE__;
				goto FUN_FAIL;
			}

			//##########################################

			COMM_Start_Encryption_Config(dut1_fd,&g_pattern_param, conn_handles_mas);
			verdict=COMM_Start_Encryption(dut1_fd,g_pattern_param);
			VERDICT_RESULT_WITH_LINE();

            do{
                socket_msg_get(dut2_fd,&len,buf);
            }while(len <=0);
			printf("Get Event(%d):\n",dut2_fd);
			print_charray(len,buf);
			if(SUCCESS != hci_le_event_ltk_request_parsing(0,buf,g_pattern_param))
			{
				line=__LINE__;
				goto FUN_FAIL;
			}

			COMM_Ltk_Req_Rep_Config(dut2_fd,&g_pattern_param, conn_handles_sla);//peer conn_handle?
			verdict=COMM_Ltk_Req_Rep(dut2_fd,g_pattern_param);
			VERDICT_RESULT_WITH_LINE();

			sleep(1); //waiting encryption change
			if (SUCCESS != QUERY_Event(dut2_fd,buf ,_BT_HCI_EVENT_OP_ENCRYPTION_KEY_REFRESH_COMPLETE_))
			{
				line=__LINE__;
				goto FUN_FAIL;
			}

			if(SUCCESS != hci_event_encryption_key_refresh_complte_parsing(0,buf,g_pattern_param))
			{
				line=__LINE__;
				goto FUN_FAIL;
			}

            buf[_BT_HCI_EVT_CON_COMP_CONN_HANDLE+0] = conn_handles_mas[0];
            buf[_BT_HCI_EVT_CON_COMP_CONN_HANDLE+1] = conn_handles_mas[1];

            COMM_Disconnect_Config(dut1, &g_pattern_param,buf);
            verdict = COMM_Disconnect(dut1_fd, g_pattern_param);

            FUNC_END();

			LOG_INFO("[Pattern][%s]SUCCESS\n" ,__FUNCTION__);
			return PASS;
		}
	}

FUN_FAIL:
    FUNC_END();
    
	LOG_INFO("[Pattern][%s]:%d FAIL\n" ,__FUNCTION__,line);
    return FAIL;

}


// 5.9.4.3
verdict SEC_SLA_Slave_Pause_Encryption_Sending_Data (u8 dut1_fd ,u8 dut2_fd)
{
	u8 buf[SOCKET_BUF_SIZE];
	u16 len;
	int verdict=FAIL;
	int dut1 = 0;
	u16 line =0 ;
	struct itimerval timer;
	u8 conn_handles_mas[2];
	u8 conn_handles_sla[2];
	u8 acl_data[10]={0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF};

    int sla_pkt_chk = 0;

    COMM_Dut_clean_buffer(dut1_fd);
    COMM_Dut_clean_buffer(dut2_fd);

    Calculate_Execution_Time_Start();

	COMM_ADV_Directed_Advertising_Config(HCI_CMD_PARAM_ADV_DATA_LEN_MAX,&g_pattern_param);
	//here use lowest ch to testing
	g_pattern_param.adv_param.Advertising_Channel_Map[0] =HCI_CMD_PARAM_ENABLE_CHANNEL_37 ;
	verdict=COMM_ADV_Directed_Advertising(dut2_fd,g_pattern_param);
	VERDICT_RESULT_WITH_LINE();

	COMM_INI_Initiating_Config(dut1,&g_pattern_param);
	verdict=COMM_INI_Initiating(dut1_fd,g_pattern_param);
	VERDICT_RESULT_WITH_LINE();

	event_query_timer_config(5 , 0 , 0 , 0, &timer);
	event_query_timer_start(timer ,read_le_event_enable );

	while(1)//waiting adv report event , timer or counter
	{
		if ( 1 == read_le_event_get() )
		{
            read_le_event_disable();
        
			if (SUCCESS != QUERY_LE_Event(dut1_fd,buf ,
										_BT_HCI_LE_EVENT_SUB_OP_CONNECTION_COMPLETE_,
										0))
			{
				line=__LINE__;
				goto FUN_FAIL;
			}

			if(SUCCESS != hci_le_event_connection_complete_parsing(0,
										buf,g_pattern_param))
			{
				line=__LINE__;
				goto FUN_FAIL;
			}

			conn_handles_mas[0]=buf[_BT_HCI_EVT_COMP_HANDLE+0];
			conn_handles_mas[1]=buf[_BT_HCI_EVT_COMP_HANDLE+1];


			if (SUCCESS != QUERY_LE_Event(dut2_fd,buf ,
										_BT_HCI_LE_EVENT_SUB_OP_CONNECTION_COMPLETE_,
										0))
			{
				line=__LINE__;
				goto FUN_FAIL;
			}

			if(SUCCESS != hci_le_event_connection_complete_parsing(0,
										buf,g_pattern_param))
			{
				line=__LINE__;
				goto FUN_FAIL;
			}

			conn_handles_sla[0]=buf[_BT_HCI_EVT_COMP_HANDLE+0];
			conn_handles_sla[1]=buf[_BT_HCI_EVT_COMP_HANDLE+1];

			COMM_Start_Encryption_Config(dut1_fd,&g_pattern_param, conn_handles_mas);
			verdict=COMM_Start_Encryption(dut1_fd,g_pattern_param);
			VERDICT_RESULT_WITH_LINE();

            do{
                socket_msg_get(dut2_fd,&len,buf);
            }while(len <=0);
			printf("Get Event(%d):\n",dut2_fd);
			print_charray(len,buf);
			if(SUCCESS != hci_le_event_ltk_request_parsing(0,buf,g_pattern_param))
			{
				line=__LINE__;
				goto FUN_FAIL;
			}

			COMM_Ltk_Req_Rep_Config(dut2_fd,&g_pattern_param, conn_handles_sla);//peer conn_handle?
			verdict=COMM_Ltk_Req_Rep(dut2_fd,g_pattern_param);
			VERDICT_RESULT_WITH_LINE();

			sleep(1); //waiting encryption change
			if (SUCCESS != QUERY_Event(dut2_fd,buf ,_BT_HCI_EVENT_OP_ENCRYPTION_CHANGE_))
			{
				line=__LINE__;
				goto FUN_FAIL;
			}

			if(SUCCESS != hci_event_encryption_change_parsing(0,buf,g_pattern_param))
			{
				line=__LINE__;
				goto FUN_FAIL;
			}

			//##########################################

			COMM_Start_Encryption_Config(dut1_fd,&g_pattern_param, conn_handles_mas);
			verdict=COMM_Start_Encryption(dut1_fd,g_pattern_param);
			VERDICT_RESULT_WITH_LINE();
			//should check timing

    		//sending data after start encryption
			//and in that state , the write cmd will not rsp the number of packets completed
			COMM_Send_ACL_Data_Without_event(dut1_fd,conn_handles_mas,0b00,0,10,acl_data);

			//should be nothing here !
			if (SUCCESS != QUERY_Acl_Data(dut2_fd,buf))//step2 ~ 4
			{
				line=__LINE__;
				goto FUN_FAIL;
			}

			if (0x00 != (buf [_BT_HCI_IDX_ACL_DATA_PAYLOAD_]))
			{
				line=__LINE__;
				goto FUN_FAIL;
			}

            do{ 
                socket_msg_get(dut2_fd,&len,buf);
            }while(len <=0);
			printf("Get Event(%d):\n",dut2_fd);
			if(SUCCESS != hci_le_event_ltk_request_parsing(0,buf,g_pattern_param))
			{
				line=__LINE__;
				goto FUN_FAIL;
			}

			COMM_Ltk_Req_Rep_Config(dut2_fd,&g_pattern_param, conn_handles_sla);//peer conn_handle?
			verdict=COMM_Ltk_Req_Rep(dut2_fd,g_pattern_param);
			VERDICT_RESULT_WITH_LINE();

			sleep(1); //waiting encryption change

			if (SUCCESS != QUERY_Acl_Data(dut2_fd,buf))//step2 ~ 4
			{
				line=__LINE__;
				goto FUN_FAIL;
			}
			//should be something here!!
			if (0xFF != (buf [_BT_HCI_IDX_ACL_DATA_PAYLOAD_]))
			{
				line=__LINE__;
				goto FUN_FAIL;
			}


			if (SUCCESS != QUERY_Event(dut2_fd,buf ,_BT_HCI_EVENT_OP_ENCRYPTION_KEY_REFRESH_COMPLETE_))
			{
				line=__LINE__;
				goto FUN_FAIL;
			}

			if(SUCCESS != hci_event_encryption_key_refresh_complte_parsing(0,buf,g_pattern_param))
			{
				line=__LINE__;
				goto FUN_FAIL;
			}
#if 1
PKT_CHK:
            // # check disconnection             
            CHECK_NON_DISCONNECT();

            if(SUCCESS != QUERY_Event(dut1_fd, buf, _BT_HCI_EVENT_OP_NUMBER_OF_COMPLETED_PACKETS_)) {
                line = __LINE__;
                goto FUN_FAIL;
            }
            else if(1 != hci_event_num_of_completed_packets_parsing(buf)) {

                MSLEEP(100);
                sla_pkt_chk ++ ;
                if (sla_pkt_chk == 100){
                    printf("sla no number of completed pkts\n");
                    line = __LINE__;
                    goto FUN_FAIL;                  
                }
                goto PKT_CHK;
            
            }                 
            
            sla_pkt_chk = 0;

#else
			//finally: the number of packets completed.
            do{
                ret=socket_msg_get(dut1_fd,&len,buf);
            }while(len <=0);
			printf("Get Event(%d):\n",dut1_fd);
			print_charray(len,buf);
			if(SOCKET_SUCCESS != ret)
				goto FUN_FAIL;
#endif

            buf[_BT_HCI_EVT_CON_COMP_CONN_HANDLE+0] = conn_handles_mas[0];
            buf[_BT_HCI_EVT_CON_COMP_CONN_HANDLE+1] = conn_handles_mas[1];

            COMM_Disconnect_Config(dut1, &g_pattern_param,buf);
            verdict = COMM_Disconnect(dut1_fd, g_pattern_param);

            FUNC_END();
            
			LOG_INFO("[Pattern][%s]SUCCESS\n" ,__FUNCTION__);
			return PASS;
		}
	}

FUN_FAIL:
    FUNC_END();
    
	LOG_INFO("[Pattern][%s]:%d FAIL\n" ,__FUNCTION__,line);
    return FAIL;

}


// 5.9.4.4
verdict SEC_SLA_Slave_Sending_Reject_Ind (u8 dut1_fd ,u8 dut2_fd)
{
	u8 buf[SOCKET_BUF_SIZE];
	u16 len;
	int verdict=FAIL;
	int dut1 =0;
	u16 line =0 ;
	struct itimerval timer;
	u8 conn_handles_mas[2];
	u8 conn_handles_sla[2];

    COMM_Dut_clean_buffer(dut1_fd);
    COMM_Dut_clean_buffer(dut2_fd);

    Calculate_Execution_Time_Start();

	COMM_ADV_Directed_Advertising_Config(HCI_CMD_PARAM_ADV_DATA_LEN_MAX,&g_pattern_param);
	//here use lowest ch to testing
	g_pattern_param.adv_param.Advertising_Channel_Map[0] =HCI_CMD_PARAM_ENABLE_CHANNEL_37 ;
	verdict=COMM_ADV_Directed_Advertising(dut2_fd,g_pattern_param);
	VERDICT_RESULT_WITH_LINE();

	COMM_INI_Initiating_Config(dut1,&g_pattern_param);
	verdict=COMM_INI_Initiating(dut1_fd,g_pattern_param);
	VERDICT_RESULT_WITH_LINE();

	event_query_timer_config(5 , 0 , 0 , 0, &timer);
	event_query_timer_start(timer ,read_le_event_enable );

	while(1)//waiting adv report event , timer or counter
	{
		if ( 1 == read_le_event_get() )
		{            
            read_le_event_disable();
        
			if (SUCCESS != QUERY_LE_Event(dut1_fd,buf ,
										_BT_HCI_LE_EVENT_SUB_OP_CONNECTION_COMPLETE_,
										0))
			{
				line=__LINE__;
				goto FUN_FAIL;
			}

			if(SUCCESS != hci_le_event_connection_complete_parsing(0,
										buf,g_pattern_param))
			{
				line=__LINE__;
				goto FUN_FAIL;
			}

			conn_handles_mas[0]=buf[_BT_HCI_EVT_COMP_HANDLE+0];
			conn_handles_mas[1]=buf[_BT_HCI_EVT_COMP_HANDLE+1];


			if (SUCCESS != QUERY_LE_Event(dut2_fd,buf ,
										_BT_HCI_LE_EVENT_SUB_OP_CONNECTION_COMPLETE_,
										0))
			{
				line=__LINE__;
				goto FUN_FAIL;
			}

			if(SUCCESS != hci_le_event_connection_complete_parsing(0,
										buf,g_pattern_param))
			{
				line=__LINE__;
				goto FUN_FAIL;
			}

			conn_handles_sla[0]=buf[_BT_HCI_EVT_COMP_HANDLE+0];
			conn_handles_sla[1]=buf[_BT_HCI_EVT_COMP_HANDLE+1];

			COMM_Start_Encryption_Config(dut1_fd,&g_pattern_param, conn_handles_mas);
			verdict=COMM_Start_Encryption(dut1_fd,g_pattern_param);
			VERDICT_RESULT_WITH_LINE();

            do{
                socket_msg_get(dut2_fd,&len,buf);
            }while(len <=0);
			printf("Get Event(%d):\n",dut2_fd);
			print_charray(len,buf);
			if(SUCCESS != hci_le_event_ltk_request_parsing(0,buf,g_pattern_param))
			{
				line=__LINE__;
				goto FUN_FAIL;
			}

			COMM_Ltk_Req_Negative_Rep_Config(dut2_fd,&g_pattern_param, conn_handles_sla);//peer conn_handle?
			verdict=COMM_Ltk_Req_Negative_Rep(dut2_fd,g_pattern_param);
			VERDICT_RESULT_WITH_LINE();

			sleep(1); //waiting encryption change
			if (SUCCESS != QUERY_Event(dut1_fd,buf ,_BT_HCI_EVENT_OP_ENCRYPTION_CHANGE_))
			{
				line=__LINE__;
				goto FUN_FAIL;
			}

			if(_BT_HCI_EVT_CMD_COMP_STATUS_PIN_OR_KEY_MISSING != hci_event_encryption_change_parsing(0,buf,g_pattern_param))
			{
				line=__LINE__;
				goto FUN_FAIL;
			}


            buf[_BT_HCI_EVT_CON_COMP_CONN_HANDLE+0] = conn_handles_mas[0];
            buf[_BT_HCI_EVT_CON_COMP_CONN_HANDLE+1] = conn_handles_mas[1];

            COMM_Disconnect_Config(dut1, &g_pattern_param,buf);
            verdict = COMM_Disconnect(dut1_fd, g_pattern_param);

            FUNC_END();


			LOG_INFO("[Pattern][%s]SUCCESS\n" ,__FUNCTION__);
			return PASS;
		}
	}

FUN_FAIL:
    FUNC_END();

    
	LOG_INFO("[Pattern][%s]:%d FAIL\n" ,__FUNCTION__,line);
    return FAIL;

}


// 5.9.4.5
verdict SEC_SLA_Slave_Receiving_Encrypted_Data (u8 dut1_fd ,u8 dut2_fd)
{
	u8 buf[SOCKET_BUF_SIZE];
	u16 len;
	int verdict=FAIL;
	int dut1 = 0;
	u16 line =0 ;
	struct itimerval timer;
	u8 conn_handles_mas[2];
	u8 conn_handles_sla[2];
	u8 acl_data[10]={0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF};
	u8 test_cnt1=100;//100;

    int sla_pkt_chk = 0;

    COMM_Dut_clean_buffer(dut1_fd);
    COMM_Dut_clean_buffer(dut2_fd);

    Calculate_Execution_Time_Start();

	COMM_ADV_Directed_Advertising_Config(HCI_CMD_PARAM_ADV_DATA_LEN_MAX,&g_pattern_param);
	//here use lowest ch to testing
	g_pattern_param.adv_param.Advertising_Channel_Map[0] =HCI_CMD_PARAM_ENABLE_CHANNEL_37 ;
	verdict=COMM_ADV_Directed_Advertising(dut2_fd,g_pattern_param);
	VERDICT_RESULT_WITH_LINE();

	COMM_INI_Initiating_Config(dut1,&g_pattern_param);
	verdict=COMM_INI_Initiating(dut1_fd,g_pattern_param);
	VERDICT_RESULT_WITH_LINE();

	event_query_timer_config(5 , 0 , 0 , 0, &timer);
	event_query_timer_start(timer ,read_le_event_enable );

	while(1)//waiting adv report event , timer or counter
	{
		if ( 1 == read_le_event_get() )
		{            
            read_le_event_disable();
        
			if (SUCCESS != QUERY_LE_Event(dut1_fd,buf ,
										_BT_HCI_LE_EVENT_SUB_OP_CONNECTION_COMPLETE_,
										0))
			{
				line=__LINE__;
				goto FUN_FAIL;
			}

			if(SUCCESS != hci_le_event_connection_complete_parsing(0,
										buf,g_pattern_param))
			{
				line=__LINE__;
				goto FUN_FAIL;
			}

			conn_handles_mas[0]=buf[_BT_HCI_EVT_COMP_HANDLE+0];
			conn_handles_mas[1]=buf[_BT_HCI_EVT_COMP_HANDLE+1];


			if (SUCCESS != QUERY_LE_Event(dut2_fd,buf ,
										_BT_HCI_LE_EVENT_SUB_OP_CONNECTION_COMPLETE_,
										0))
			{
				line=__LINE__;
				goto FUN_FAIL;
			}

			if(SUCCESS != hci_le_event_connection_complete_parsing(0,
										buf,g_pattern_param))
			{
				line=__LINE__;
				goto FUN_FAIL;
			}

			conn_handles_sla[0]=buf[_BT_HCI_EVT_COMP_HANDLE+0];
			conn_handles_sla[1]=buf[_BT_HCI_EVT_COMP_HANDLE+1];

			COMM_Start_Encryption_Config(dut1_fd,&g_pattern_param, conn_handles_mas);
			verdict=COMM_Start_Encryption(dut1_fd,g_pattern_param);
			VERDICT_RESULT_WITH_LINE();

            do{
                socket_msg_get(dut2_fd,&len,buf);
            }while(len <=0);
			printf("Get Event(%d):\n",dut2_fd);
			print_charray(len,buf);
			if(SUCCESS != hci_le_event_ltk_request_parsing(0,buf,g_pattern_param))
			{
				line=__LINE__;
				goto FUN_FAIL;
			}

			COMM_Ltk_Req_Rep_Config(dut2_fd,&g_pattern_param, conn_handles_sla);//peer conn_handle?
			verdict=COMM_Ltk_Req_Rep(dut2_fd,g_pattern_param);
			VERDICT_RESULT_WITH_LINE();

			sleep(1); //waiting encryption change
			if (SUCCESS != QUERY_Event(dut2_fd,buf ,_BT_HCI_EVENT_OP_ENCRYPTION_CHANGE_))
			{
				line=__LINE__;
				goto FUN_FAIL;
			}

			if(SUCCESS != hci_event_encryption_change_parsing(0,buf,g_pattern_param))
			{
				line=__LINE__;
				goto FUN_FAIL;
			}


			for ( ;test_cnt1 > 0 ; test_cnt1 --)
			{
				COMM_Send_ACL_Data_Without_event(dut1_fd,conn_handles_mas,0b00,0,10,acl_data);

PKT_CHK:
                // # check disconnection             
                CHECK_NON_DISCONNECT();
    
                if(SUCCESS != QUERY_Event(dut1_fd, buf, _BT_HCI_EVENT_OP_NUMBER_OF_COMPLETED_PACKETS_)) {
                    line = __LINE__;
                    goto FUN_FAIL;
                }
                else if(1 != hci_event_num_of_completed_packets_parsing(buf)) {

                    MSLEEP(100);
                    sla_pkt_chk ++ ;
                    if (sla_pkt_chk == 100){
                        printf("sla no number of completed pkts\n");
                        line = __LINE__;
                        goto FUN_FAIL;                  
                    }
                    goto PKT_CHK;
                
                }                 
                
                sla_pkt_chk = 0;



                usleep(100000);

    			if (SUCCESS != QUERY_Acl_Data(dut2_fd,buf))
    			{
    				line=__LINE__;
    				goto FUN_FAIL;
    			}

    			if (0b10 != (buf [_BT_HCI_IDX_ACL_DATA_CONN_HANDLE_ + 1] & 0xF0 ) >> 4)
    			{
    				line=__LINE__;
    				goto FUN_FAIL;
    			}

                if (0 != memcmp(buf+_BT_HCI_IDX_ACL_DATA_PAYLOAD_ , acl_data ,buf[_BT_HCI_IDX_ACL_DATA_LENGTH_]))
                {
                    line=__LINE__;
                    goto FUN_FAIL;
                }


            }

            buf[_BT_HCI_EVT_CON_COMP_CONN_HANDLE+0] = conn_handles_mas[0];
            buf[_BT_HCI_EVT_CON_COMP_CONN_HANDLE+1] = conn_handles_mas[1];

            COMM_Disconnect_Config(dut1, &g_pattern_param,buf);
            verdict = COMM_Disconnect(dut1_fd, g_pattern_param);

            FUNC_END();


			LOG_INFO("[Pattern][%s]SUCCESS\n" ,__FUNCTION__);
			return PASS;
		}
	}

FUN_FAIL:
    FUNC_END();

	LOG_INFO("[Pattern][%s]:%d FAIL\n" ,__FUNCTION__,line);
    return FAIL;

}


// 5.10.1.1
verdict SEC_MAS_Master_Encryption_Mode_Setup (u8 dut1_fd ,u8 dut2_fd)
{
	u8 buf[SOCKET_BUF_SIZE];
	u16 len;
	int verdict=FAIL;
	int dut2 = 0;
	u16 line =0 ;
	struct itimerval timer;
	u8 conn_handles_mas[2];
	u8 conn_handles_sla[2];
	u8 acl_data[10]={0};
	u8 test_cnt1=100;//100;
	u8 test_cnt2=100;//100;

    int mas_pkt_chk = 0;

    COMM_Dut_clean_buffer(dut1_fd);
    COMM_Dut_clean_buffer(dut2_fd);

	COMM_ADV_Directed_Advertising_Config(HCI_CMD_PARAM_ADV_DATA_LEN_MAX,&g_pattern_param);
	memcpy (g_pattern_param.adv_param.Direct_Address , adv_addr , ADDR_LENGTH);//should be peer addr!!!
	//here use lowest ch to testing
	g_pattern_param.adv_param.Advertising_Channel_Map[0] =HCI_CMD_PARAM_ENABLE_CHANNEL_37 ;
	verdict=COMM_ADV_Directed_Advertising(dut1_fd,g_pattern_param);
	VERDICT_RESULT_WITH_LINE();

	COMM_INI_Initiating_Config(dut2,&g_pattern_param);	//dut 2 is master
	memcpy(g_pattern_param.create_conn_param.Peer_Address ,scan_addr,ADDR_LENGTH );
	verdict=COMM_INI_Initiating(dut2_fd,g_pattern_param);
	VERDICT_RESULT_WITH_LINE();

	event_query_timer_config(5 , 0 , 0 , 0, &timer);
	event_query_timer_start(timer ,read_le_event_enable );

	while(1)//waiting adv report event , timer or counter
	{
		if ( 1 == read_le_event_get() )
		{            
            read_le_event_disable();

			if (SUCCESS != QUERY_LE_Event(dut2_fd,buf ,
										_BT_HCI_LE_EVENT_SUB_OP_CONNECTION_COMPLETE_,
										0))
			{
				line=__LINE__;
				goto FUN_FAIL;
			}

			if(SUCCESS != hci_le_event_connection_complete_parsing(0,
										buf,g_pattern_param))
			{
				line=__LINE__;
				goto FUN_FAIL;
			}

			conn_handles_mas[0]=buf[_BT_HCI_EVT_COMP_HANDLE+0];
			conn_handles_mas[1]=buf[_BT_HCI_EVT_COMP_HANDLE+1];


			if (SUCCESS != QUERY_LE_Event(dut1_fd,buf ,
										_BT_HCI_LE_EVENT_SUB_OP_CONNECTION_COMPLETE_,
										0))
			{
				line=__LINE__;
				goto FUN_FAIL;
			}

			if(SUCCESS != hci_le_event_connection_complete_parsing(0,
										buf,g_pattern_param))
			{
				line=__LINE__;
				goto FUN_FAIL;
			}

			conn_handles_sla[0]=buf[_BT_HCI_EVT_COMP_HANDLE+0];
			conn_handles_sla[1]=buf[_BT_HCI_EVT_COMP_HANDLE+1];


			//######################################

			for ( ;test_cnt1 > 0 ; test_cnt1 --)
			{
				COMM_Send_ACL_Data_Without_event(dut2_fd,conn_handles_sla,0b01,0,10,acl_data);

PKT_CHK1:
                // # check disconnection             
                CHECK_NON_DISCONNECT();
    
                if(SUCCESS != QUERY_Event(dut2_fd, buf, _BT_HCI_EVENT_OP_NUMBER_OF_COMPLETED_PACKETS_)) {
                    line = __LINE__;
                    goto FUN_FAIL;
                }
                else if(1 != hci_event_num_of_completed_packets_parsing(buf)) {

                    MSLEEP(100);
                    mas_pkt_chk ++ ;
                    if (mas_pkt_chk == 100){
                        printf("mas no number of completed pkts\n");
                        line = __LINE__;
                        goto FUN_FAIL;                  
                    }
                    goto PKT_CHK1;
                
                }                 
                
                mas_pkt_chk = 0;


			}

			if (SUCCESS != QUERY_Acl_Data(dut1_fd,buf))
			{
				line=__LINE__;
				goto FUN_FAIL;
			}

			if (0x01 != (buf [_BT_HCI_IDX_ACL_DATA_CONN_HANDLE_ + 1] & 0xF0 ) >> 4)
			{
				line=__LINE__;
				goto FUN_FAIL;
			}


			COMM_Start_Encryption_Config(dut2_fd,&g_pattern_param, conn_handles_mas);
			verdict=COMM_Start_Encryption(dut2_fd,g_pattern_param);
			VERDICT_RESULT_WITH_LINE();
#if 1
            do{
                socket_msg_get(dut1_fd,&len,buf);
            }while(len <=0);
			printf("Get Event(%d):\n",dut1_fd);
			print_charray(len,buf);
			if(SUCCESS != hci_le_event_ltk_request_parsing(0,buf,g_pattern_param))
			{
				line=__LINE__;
				goto FUN_FAIL;
			}
#else

			usleep(200000);

			if (SUCCESS != QUERY_LE_Event(dut2_fd,buf ,
										_BT_HCI_LE_EVENT_SUB_OP_LONG_TERM_KEY_REQUEST_,
										0))
			{
				line=__LINE__;
				goto FUN_FAIL;
			}

			if(SUCCESS != hci_le_event_ltk_request_parsing(0,
										buf,g_pattern_param))
			{
				line=__LINE__;
				goto FUN_FAIL;
			}
#endif
			COMM_Ltk_Req_Rep_Config(dut1_fd,&g_pattern_param, conn_handles_sla);//peer conn_handle?
			verdict=COMM_Ltk_Req_Rep(dut1_fd,g_pattern_param);
			VERDICT_RESULT_WITH_LINE();

			sleep(1); //waiting encryption change
			if (SUCCESS != QUERY_Event(dut2_fd,buf ,_BT_HCI_EVENT_OP_ENCRYPTION_CHANGE_))
			{
				line=__LINE__;
				goto FUN_FAIL;
			}

			if(SUCCESS != hci_event_encryption_change_parsing(0,buf,g_pattern_param))
			{
				line=__LINE__;
				goto FUN_FAIL;
			}

			for ( ;test_cnt2 > 0 ; test_cnt2 --)
			{

                COMM_Send_ACL_Data_Without_event(dut2_fd,conn_handles_sla,0b01,0,10,acl_data);

PKT_CHK2:
                // # check disconnection             
                CHECK_NON_DISCONNECT();
    
                if(SUCCESS != QUERY_Event(dut2_fd, buf, _BT_HCI_EVENT_OP_NUMBER_OF_COMPLETED_PACKETS_)) {
                    line = __LINE__;
                    goto FUN_FAIL;
                }
                else if(1 != hci_event_num_of_completed_packets_parsing(buf)) {

                    MSLEEP(100);
                    mas_pkt_chk ++ ;
                    if (mas_pkt_chk == 100){
                        printf("mas no number of completed pkts\n");
                        line = __LINE__;
                        goto FUN_FAIL;                  
                    }
                    goto PKT_CHK2;
                
                }                 
                
                mas_pkt_chk = 0;


			}

			if (SUCCESS != QUERY_Acl_Data(dut1_fd,buf))
			{
				line=__LINE__;
				goto FUN_FAIL;
			}

			if (0x01 != (buf [_BT_HCI_IDX_ACL_DATA_CONN_HANDLE_ + 1] & 0xF0 ) >> 4)
			{
				line=__LINE__;
				goto FUN_FAIL;
			}
			//######################################


			LOG_INFO("[Pattern][%s]SUCCESS\n" ,__FUNCTION__);
			return PASS;
		}
	}

FUN_FAIL:
	LOG_INFO("[Pattern][%s]:%d FAIL\n" ,__FUNCTION__,line);
    return FAIL;

}

// 5.10.1.2
verdict SEC_MAS_Master_Pause_Encryption (u8 dut1_fd ,u8 dut2_fd)
{
	u8 buf[SOCKET_BUF_SIZE];
	u16 len;
	int verdict=FAIL;
	int dut2 = 0;
	u16 line =0 ;
	struct itimerval timer;
	u8 conn_handles_mas[2];
	u8 conn_handles_sla[2];

    COMM_Dut_clean_buffer(dut1_fd);
    COMM_Dut_clean_buffer(dut2_fd);

	COMM_ADV_Directed_Advertising_Config(HCI_CMD_PARAM_ADV_DATA_LEN_MAX,&g_pattern_param);
	memcpy (g_pattern_param.adv_param.Direct_Address , adv_addr , ADDR_LENGTH);//should be peer addr!!!
	//here use lowest ch to testing
	g_pattern_param.adv_param.Advertising_Channel_Map[0] =HCI_CMD_PARAM_ENABLE_CHANNEL_37 ;
	verdict=COMM_ADV_Directed_Advertising(dut1_fd,g_pattern_param);
	VERDICT_RESULT_WITH_LINE();

	COMM_INI_Initiating_Config(dut2,&g_pattern_param);	//dut 2 is master
	memcpy(g_pattern_param.create_conn_param.Peer_Address ,scan_addr,ADDR_LENGTH );
	verdict=COMM_INI_Initiating(dut2_fd,g_pattern_param);
	VERDICT_RESULT_WITH_LINE();

	event_query_timer_config(5 , 0 , 0 , 0, &timer);
	event_query_timer_start(timer ,read_le_event_enable );

	while(1)//waiting adv report event , timer or counter
	{
		if ( 1 == read_le_event_get() )
		{            
            read_le_event_disable();
        
			if (SUCCESS != QUERY_LE_Event(dut2_fd,buf ,
										_BT_HCI_LE_EVENT_SUB_OP_CONNECTION_COMPLETE_,
										0))
			{
				line=__LINE__;
				goto FUN_FAIL;
			}

			if(SUCCESS != hci_le_event_connection_complete_parsing(0,
										buf,g_pattern_param))
			{
				line=__LINE__;
				goto FUN_FAIL;
			}

			conn_handles_mas[0]=buf[_BT_HCI_EVT_COMP_HANDLE+0];
			conn_handles_mas[1]=buf[_BT_HCI_EVT_COMP_HANDLE+1];


			if (SUCCESS != QUERY_LE_Event(dut1_fd,buf ,
										_BT_HCI_LE_EVENT_SUB_OP_CONNECTION_COMPLETE_,
										0))
			{
				line=__LINE__;
				goto FUN_FAIL;
			}

			if(SUCCESS != hci_le_event_connection_complete_parsing(0,
										buf,g_pattern_param))
			{
				line=__LINE__;
				goto FUN_FAIL;
			}

			conn_handles_sla[0]=buf[_BT_HCI_EVT_COMP_HANDLE+0];
			conn_handles_sla[1]=buf[_BT_HCI_EVT_COMP_HANDLE+1];

			COMM_Start_Encryption_Config(dut2_fd,&g_pattern_param, conn_handles_mas);
			verdict=COMM_Start_Encryption(dut2_fd,g_pattern_param);
			VERDICT_RESULT_WITH_LINE();
#if 1
            do{
                socket_msg_get(dut1_fd,&len,buf);
            }while(len <=0);
			printf("Get Event(%d):\n",dut1_fd);
			print_charray(len,buf);
			if(SUCCESS != hci_le_event_ltk_request_parsing(0,buf,g_pattern_param))
			{
				line=__LINE__;
				goto FUN_FAIL;
			}
#else
			usleep(200000);

			if (SUCCESS != QUERY_LE_Event(dut2_fd,buf ,
										_BT_HCI_LE_EVENT_SUB_OP_LONG_TERM_KEY_REQUEST_,
										0))
			{
				line=__LINE__;
				goto FUN_FAIL;
			}

			if(SUCCESS != hci_le_event_ltk_request_parsing(0,
										buf,g_pattern_param))
			{
				line=__LINE__;
				goto FUN_FAIL;
			}
#endif
			COMM_Ltk_Req_Rep_Config(dut1_fd,&g_pattern_param, conn_handles_sla);//peer conn_handle?
			verdict=COMM_Ltk_Req_Rep(dut1_fd,g_pattern_param);
			VERDICT_RESULT_WITH_LINE();

			sleep(1); //waiting encryption change
			if (SUCCESS != QUERY_Event(dut1_fd,buf ,_BT_HCI_EVENT_OP_ENCRYPTION_CHANGE_))
			{
				line=__LINE__;
				goto FUN_FAIL;
			}

			if(SUCCESS != hci_event_encryption_change_parsing(0,buf,g_pattern_param))
			{
				line=__LINE__;
				goto FUN_FAIL;
			}

			//##########################################

			COMM_Start_Encryption_Config(dut2_fd,&g_pattern_param, conn_handles_mas);
			verdict=COMM_Start_Encryption(dut2_fd,g_pattern_param);
			VERDICT_RESULT_WITH_LINE();
#if 1
            do{
                socket_msg_get(dut1_fd,&len,buf);
            }while(len <=0);
			printf("Get Event(%d):\n",dut1_fd);
			print_charray(len,buf);
			if(SUCCESS != hci_le_event_ltk_request_parsing(0,buf,g_pattern_param))
			{
				line=__LINE__;
				goto FUN_FAIL;
			}
#else
			usleep(200000);

			if (SUCCESS != QUERY_LE_Event(dut2_fd,buf ,
										_BT_HCI_LE_EVENT_SUB_OP_LONG_TERM_KEY_REQUEST_,
										0))
			{
				line=__LINE__;
				goto FUN_FAIL;
			}

			if(SUCCESS != hci_le_event_ltk_request_parsing(0,
										buf,g_pattern_param))
			{
				line=__LINE__;
				goto FUN_FAIL;
			}

			sleep(1); //!!!! must waiting for dut timeout and send second LTK req
#endif
			COMM_Ltk_Req_Rep_Config(dut1_fd,&g_pattern_param, conn_handles_sla);//peer conn_handle?
			verdict=COMM_Ltk_Req_Rep(dut1_fd,g_pattern_param);
			VERDICT_RESULT_WITH_LINE();

			sleep(1); //waiting encryption change
			if (SUCCESS != QUERY_Event(dut1_fd,buf ,_BT_HCI_EVENT_OP_ENCRYPTION_KEY_REFRESH_COMPLETE_))
			{
				line=__LINE__;
				goto FUN_FAIL;
			}

			if(SUCCESS != hci_event_encryption_key_refresh_complte_parsing(0,buf,g_pattern_param))
			{
				line=__LINE__;
				goto FUN_FAIL;
			}

			LOG_INFO("[Pattern][%s]SUCCESS\n" ,__FUNCTION__);
			return PASS;
		}
	}

FUN_FAIL:
	LOG_INFO("[Pattern][%s]:%d FAIL\n" ,__FUNCTION__,line);
    return FAIL;

}


// 5.10.1.3
verdict SEC_MAS_Master_Receiving_Reject_Ind (u8 dut1_fd ,u8 dut2_fd)
{
	u8 buf[SOCKET_BUF_SIZE];
	u16 len;
	int verdict=FAIL;
	int dut2 =0;
	u16 line =0 ;
	struct itimerval timer;
	u8 conn_handles_mas[2];
	u8 conn_handles_sla[2];

    COMM_Dut_clean_buffer(dut1_fd);
    COMM_Dut_clean_buffer(dut2_fd);

	COMM_ADV_Directed_Advertising_Config(HCI_CMD_PARAM_ADV_DATA_LEN_MAX,&g_pattern_param);
	memcpy (g_pattern_param.adv_param.Direct_Address , adv_addr , ADDR_LENGTH);//should be peer addr!!!
	//here use lowest ch to testing
	g_pattern_param.adv_param.Advertising_Channel_Map[0] =HCI_CMD_PARAM_ENABLE_CHANNEL_37 ;
	verdict=COMM_ADV_Directed_Advertising(dut1_fd,g_pattern_param);
	VERDICT_RESULT_WITH_LINE();

	COMM_INI_Initiating_Config(dut2,&g_pattern_param);	//dut 2 is master
	memcpy(g_pattern_param.create_conn_param.Peer_Address ,scan_addr,ADDR_LENGTH );
	verdict=COMM_INI_Initiating(dut2_fd,g_pattern_param);
	VERDICT_RESULT_WITH_LINE();


	event_query_timer_config(5 , 0 , 0 , 0, &timer);
	event_query_timer_start(timer ,read_le_event_enable );

	while(1)//waiting adv report event , timer or counter
	{
		if ( 1 == read_le_event_get() )
		{            
            read_le_event_disable();
        
			if (SUCCESS != QUERY_LE_Event(dut2_fd,buf ,
										_BT_HCI_LE_EVENT_SUB_OP_CONNECTION_COMPLETE_,
										0))
			{
				line=__LINE__;
				goto FUN_FAIL;
			}

			if(SUCCESS != hci_le_event_connection_complete_parsing(0,
										buf,g_pattern_param))
			{
				line=__LINE__;
				goto FUN_FAIL;
			}

			conn_handles_mas[0]=buf[_BT_HCI_EVT_COMP_HANDLE+0];
			conn_handles_mas[1]=buf[_BT_HCI_EVT_COMP_HANDLE+1];


			if (SUCCESS != QUERY_LE_Event(dut1_fd,buf ,
										_BT_HCI_LE_EVENT_SUB_OP_CONNECTION_COMPLETE_,
										0))
			{
				line=__LINE__;
				goto FUN_FAIL;
			}

			if(SUCCESS != hci_le_event_connection_complete_parsing(0,
										buf,g_pattern_param))
			{
				line=__LINE__;
				goto FUN_FAIL;
			}

			conn_handles_sla[0]=buf[_BT_HCI_EVT_COMP_HANDLE+0];
			conn_handles_sla[1]=buf[_BT_HCI_EVT_COMP_HANDLE+1];

			COMM_Start_Encryption_Config(dut2_fd,&g_pattern_param, conn_handles_mas);
			verdict=COMM_Start_Encryption(dut2_fd,g_pattern_param);
			VERDICT_RESULT_WITH_LINE();

            do{
                socket_msg_get(dut1_fd,&len,buf);
            }while(len <=0);
			printf("Get Event(%d):\n",dut1_fd);
			print_charray(len,buf);
			if(SUCCESS != hci_le_event_ltk_request_parsing(0,buf,g_pattern_param))
			{
				line=__LINE__;
				goto FUN_FAIL;
			}

			COMM_Ltk_Req_Negative_Rep_Config(dut1_fd,&g_pattern_param, conn_handles_sla);//peer conn_handle?
			verdict=COMM_Ltk_Req_Negative_Rep(dut1_fd,g_pattern_param);
			VERDICT_RESULT_WITH_LINE();

			sleep(1); //waiting encryption change
			if (SUCCESS != QUERY_Event(dut2_fd,buf ,_BT_HCI_EVENT_OP_ENCRYPTION_CHANGE_))
			{
				line=__LINE__;
				goto FUN_FAIL;
			}

			if(_BT_HCI_EVT_CMD_COMP_STATUS_UNSUPPROTED_REMOTE_FEATURE_LMP != hci_event_encryption_change_parsing(0,buf,g_pattern_param))
			{
				line=__LINE__;
				goto FUN_FAIL;
			}

			LOG_INFO("[Pattern][%s]SUCCESS\n" ,__FUNCTION__);
			return PASS;
		}
	}

FUN_FAIL:
	LOG_INFO("[Pattern][%s]:%d FAIL\n" ,__FUNCTION__,line);
    return FAIL;

}

// 5.10.1.4
verdict SEC_MAS_Master_Encryption_Sending_Data_Before_LL_ENC_RSP (u8 dut1_fd ,u8 dut2_fd)
{
	u8 buf[SOCKET_BUF_SIZE];
	u16 len;
	int verdict=FAIL;
	int dut2 = 0;
	u16 line =0 ;
	struct itimerval timer;
	u8 conn_handles_mas[2];
	u8 conn_handles_sla[2];
	u8 acl_data[10]={0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF};
	u8 test_cnt1=1;//100;

    int mas_pkt_chk = 0;

    COMM_Dut_clean_buffer(dut1_fd);
    COMM_Dut_clean_buffer(dut2_fd);

	COMM_ADV_Directed_Advertising_Config(HCI_CMD_PARAM_ADV_DATA_LEN_MAX,&g_pattern_param);
	memcpy (g_pattern_param.adv_param.Direct_Address , adv_addr , ADDR_LENGTH);//should be peer addr!!!
	//here use lowest ch to testing
	g_pattern_param.adv_param.Advertising_Channel_Map[0] =HCI_CMD_PARAM_ENABLE_CHANNEL_37 ;
	verdict=COMM_ADV_Directed_Advertising(dut1_fd,g_pattern_param);
	VERDICT_RESULT_WITH_LINE();

	COMM_INI_Initiating_Config(dut2,&g_pattern_param);	//dut 2 is master
	memcpy(g_pattern_param.create_conn_param.Peer_Address ,scan_addr,ADDR_LENGTH );
	verdict=COMM_INI_Initiating(dut2_fd,g_pattern_param);
	VERDICT_RESULT_WITH_LINE();


	event_query_timer_config(5 , 0 , 0 , 0, &timer);
	event_query_timer_start(timer ,read_le_event_enable );

	while(1)//waiting adv report event , timer or counter
	{
		if ( 1 == read_le_event_get() )
		{            
            read_le_event_disable();
        
			if (SUCCESS != QUERY_LE_Event(dut2_fd,buf ,
										_BT_HCI_LE_EVENT_SUB_OP_CONNECTION_COMPLETE_,
										0))
			{
				line=__LINE__;
				goto FUN_FAIL;
			}

			if(SUCCESS != hci_le_event_connection_complete_parsing(0,
										buf,g_pattern_param))
			{
				line=__LINE__;
				goto FUN_FAIL;
			}

			conn_handles_mas[0]=buf[_BT_HCI_EVT_COMP_HANDLE+0];
			conn_handles_mas[1]=buf[_BT_HCI_EVT_COMP_HANDLE+1];


			if (SUCCESS != QUERY_LE_Event(dut1_fd,buf ,
										_BT_HCI_LE_EVENT_SUB_OP_CONNECTION_COMPLETE_,
										0))
			{
				line=__LINE__;
				goto FUN_FAIL;
			}

			if(SUCCESS != hci_le_event_connection_complete_parsing(0,
										buf,g_pattern_param))
			{
				line=__LINE__;
				goto FUN_FAIL;
			}

			conn_handles_sla[0]=buf[_BT_HCI_EVT_COMP_HANDLE+0];
			conn_handles_sla[1]=buf[_BT_HCI_EVT_COMP_HANDLE+1];

			COMM_Start_Encryption_Config(dut2_fd,&g_pattern_param, conn_handles_mas);
			verdict=COMM_Start_Encryption(dut2_fd,g_pattern_param);
			VERDICT_RESULT_WITH_LINE();

            do{
                socket_msg_get(dut1_fd,&len,buf);
            }while(len <=0);
            printf("Get Event(%d):\n",dut1_fd);
            print_charray(len,buf);
            if(SUCCESS != hci_le_event_ltk_request_parsing(0,buf,g_pattern_param))
            {
                line=__LINE__;
                goto FUN_FAIL;
            }

#if 1
			for ( ;test_cnt1 > 0 ; test_cnt1 --)
			{
				COMM_Send_ACL_Data_Without_event(dut1_fd,conn_handles_mas,0b00,0,10,acl_data);
                
PKT_CHK1:
                // # check disconnection             
                CHECK_NON_DISCONNECT();
    
                if(SUCCESS != QUERY_Event(dut1_fd, buf, _BT_HCI_EVENT_OP_NUMBER_OF_COMPLETED_PACKETS_)) {
                    line = __LINE__;
                    goto FUN_FAIL;
                }
                else if(1 != hci_event_num_of_completed_packets_parsing(buf)) {

                    MSLEEP(100);
                    mas_pkt_chk ++ ;
                    if (mas_pkt_chk == 100){
                        printf("mas no number of completed pkts\n");
                        line = __LINE__;
                        goto FUN_FAIL;                  
                    }
                    goto PKT_CHK1;
                
                }                 
                
                mas_pkt_chk = 0;


			}

			if (SUCCESS != QUERY_Acl_Data(dut2_fd,buf))
			{
				line=__LINE__;
				goto FUN_FAIL;
			}

			if (0b10 != (buf [_BT_HCI_IDX_ACL_DATA_CONN_HANDLE_ + 1] & 0xF0 ) >> 4)
			{
				line=__LINE__;
				goto FUN_FAIL;
			}
#endif
            do{
                socket_msg_get(dut1_fd,&len,buf);
            }while(len <=0);
			printf("Get Event(%d):\n",dut1_fd);
			print_charray(len,buf);
			if(SUCCESS != hci_le_event_ltk_request_parsing(0,buf,g_pattern_param))
			{
				line=__LINE__;
				goto FUN_FAIL;
			}
#if 1
			COMM_Ltk_Req_Rep_Config(dut1_fd,&g_pattern_param, conn_handles_sla);//peer conn_handle?
			verdict=COMM_Ltk_Req_Rep(dut1_fd,g_pattern_param);
			VERDICT_RESULT_WITH_LINE();

			sleep(1); //waiting encryption change
			if (SUCCESS != QUERY_Event(dut1_fd,buf ,_BT_HCI_EVENT_OP_ENCRYPTION_CHANGE_))
			{
				line=__LINE__;
				goto FUN_FAIL;
			}

			if(SUCCESS != hci_event_encryption_change_parsing(0,buf,g_pattern_param))
			{
				line=__LINE__;
				goto FUN_FAIL;
			}

			//##########################################

			COMM_Start_Encryption_Config(dut2_fd,&g_pattern_param, conn_handles_mas);
			verdict=COMM_Start_Encryption(dut2_fd,g_pattern_param);
			VERDICT_RESULT_WITH_LINE();
			//should check timing

            do{
                socket_msg_get(dut1_fd,&len,buf);
            }while(len <=0);
			printf("Get Event(%d):\n",dut1_fd);
			print_charray(len,buf);
			if(SUCCESS != hci_le_event_ltk_request_parsing(0,buf,g_pattern_param))
			{
				line=__LINE__;
				goto FUN_FAIL;
			}


			for ( ;test_cnt1 > 0 ; test_cnt1 --)
			{
				COMM_Send_ACL_Data_Without_event(dut1_fd,conn_handles_mas,0b01,0,10,acl_data);

PKT_CHK2:
                // # check disconnection             
                CHECK_NON_DISCONNECT();
    
                if(SUCCESS != QUERY_Event(dut1_fd, buf, _BT_HCI_EVENT_OP_NUMBER_OF_COMPLETED_PACKETS_)) {
                    line = __LINE__;
                    goto FUN_FAIL;
                }
                else if(1 != hci_event_num_of_completed_packets_parsing(buf)) {

                    MSLEEP(100);
                    mas_pkt_chk ++ ;
                    if (mas_pkt_chk == 100){
                        printf("mas no number of completed pkts\n");
                        line = __LINE__;
                        goto FUN_FAIL;                  
                    }
                    goto PKT_CHK2;
                
                }                 
                
                mas_pkt_chk = 0;


			}

			if (SUCCESS != QUERY_Acl_Data(dut2_fd,buf))
			{
				line=__LINE__;
				goto FUN_FAIL;
			}

			if (0b01 != (buf [_BT_HCI_IDX_ACL_DATA_CONN_HANDLE_ + 1] & 0xF0 ) >> 4)
			{
				line=__LINE__;
				goto FUN_FAIL;
			}

			COMM_Ltk_Req_Rep_Config(dut1_fd,&g_pattern_param, conn_handles_sla);//peer conn_handle?
			verdict=COMM_Ltk_Req_Rep(dut1_fd,g_pattern_param);
			VERDICT_RESULT_WITH_LINE();

			sleep(1); //waiting encryption change

			if (SUCCESS != QUERY_Acl_Data(dut1_fd,buf))//step2 ~ 4
			{
				line=__LINE__;
				goto FUN_FAIL;
			}
			//should be something here!!
			if (0xFF != (buf [_BT_HCI_IDX_ACL_DATA_PAYLOAD_]))
			{
				line=__LINE__;
				goto FUN_FAIL;
			}


			if (SUCCESS != QUERY_Event(dut1_fd,buf ,_BT_HCI_EVENT_OP_ENCRYPTION_KEY_REFRESH_COMPLETE_))
			{
				line=__LINE__;
				goto FUN_FAIL;
			}

			if(SUCCESS != hci_event_encryption_key_refresh_complte_parsing(0,buf,g_pattern_param))
			{
				line=__LINE__;
				goto FUN_FAIL;
			}
#endif
			LOG_INFO("[Pattern][%s]SUCCESS\n" ,__FUNCTION__);
			return PASS;
		}
	}

FUN_FAIL:
	LOG_INFO("[Pattern][%s]:%d FAIL\n" ,__FUNCTION__,line);
    return FAIL;

}

// 5.10.1.6
verdict SEC_MAS_Master_Encryption_Setup_Missing_Response (u8 dut1_fd ,u8 dut2_fd)
{
	u8 buf[SOCKET_BUF_SIZE];
	int verdict=FAIL;
	int dut2 = 0;
	u16 line =0 ;
	struct itimerval timer;
	u8 conn_handles_mas[2];

    COMM_Dut_clean_buffer(dut1_fd);
    COMM_Dut_clean_buffer(dut2_fd);

	COMM_ADV_Directed_Advertising_Config(HCI_CMD_PARAM_ADV_DATA_LEN_MAX,&g_pattern_param);
	memcpy (g_pattern_param.adv_param.Direct_Address , adv_addr , ADDR_LENGTH);//should be peer addr!!!
	//here use lowest ch to testing
	g_pattern_param.adv_param.Advertising_Channel_Map[0] =HCI_CMD_PARAM_ENABLE_CHANNEL_37 ;
	verdict=COMM_ADV_Directed_Advertising(dut1_fd,g_pattern_param);
	VERDICT_RESULT_WITH_LINE();

	COMM_INI_Initiating_Config(dut2,&g_pattern_param);	//dut 2 is master
	memcpy(g_pattern_param.create_conn_param.Peer_Address ,scan_addr,ADDR_LENGTH );
	verdict=COMM_INI_Initiating(dut2_fd,g_pattern_param);
	VERDICT_RESULT_WITH_LINE();


	event_query_timer_config(5 , 0 , 0 , 0, &timer);
	event_query_timer_start(timer ,read_le_event_enable );

	while(1)//waiting adv report event , timer or counter
	{
		if ( 1 == read_le_event_get() )
		{            
            read_le_event_disable();
        
			if (SUCCESS != QUERY_LE_Event(dut2_fd,buf ,
										_BT_HCI_LE_EVENT_SUB_OP_CONNECTION_COMPLETE_,
										0))
			{
				line=__LINE__;
				goto FUN_FAIL;
			}

			if(SUCCESS != hci_le_event_connection_complete_parsing(0,
										buf,g_pattern_param))
			{
				line=__LINE__;
				goto FUN_FAIL;
			}

			conn_handles_mas[0]=buf[_BT_HCI_EVT_COMP_HANDLE+0];
			conn_handles_mas[1]=buf[_BT_HCI_EVT_COMP_HANDLE+1];


			if (SUCCESS != QUERY_LE_Event(dut1_fd,buf ,
										_BT_HCI_LE_EVENT_SUB_OP_CONNECTION_COMPLETE_,
										0))
			{
				line=__LINE__;
				goto FUN_FAIL;
			}

			if(SUCCESS != hci_le_event_connection_complete_parsing(0,
										buf,g_pattern_param))
			{
				line=__LINE__;
				goto FUN_FAIL;
			}

			//conn_handles_sla[0]=buf[_BT_HCI_EVT_COMP_HANDLE+0];
			//conn_handles_sla[1]=buf[_BT_HCI_EVT_COMP_HANDLE+1];

			COMM_Reset(dut1_fd);

			COMM_Start_Encryption_Config(dut2_fd,&g_pattern_param, conn_handles_mas);
			verdict=COMM_Start_Encryption(dut2_fd,g_pattern_param);
			VERDICT_RESULT_WITH_LINE();
#if 0
            do{
                ret=socket_msg_get(dut_fd,&len,buf);
            }while(len <=0);
			printf("Get Event(%d):\n",dut1_fd);
			print_charray(len,buf);
			if(SUCCESS != hci_le_event_ltk_request_parsing(0,buf,g_pattern_param))
			{
				line=__LINE__;
				goto FUN_FAIL;
			}
#endif
			sleep(40) ; //more time to wait supervistion TO

			if (SUCCESS != QUERY_Event(dut2_fd,buf ,
										_BT_HCI_EVENT_OP_DISCONNECTION_COMPLETE_))
			{
				line=__LINE__;
				goto FUN_FAIL;
			}

			hci_event_disconnection_complete_parsing(0,buf,g_pattern_param);
			if(_BT_HCI_EVT_CMD_COMP_STATUS_RESPONSE_TIMEOUT
				!= buf[_BT_HCI_EVT_DISCONN_COMP_REASON])
			{
				line=__LINE__;
				goto FUN_FAIL;
			}
#if 0
			if( !=
				hci_event_disconnection_complete_parsing(0,buf,g_pattern_param))
			{
				line=__LINE__;
				goto FUN_FAIL;
			}
#endif
#if 0
			COMM_Ltk_Req_Rep_Config(dut1_fd,&g_pattern_param, conn_handles_sla);//peer conn_handle?
			verdict=COMM_Ltk_Req_Rep(dut1_fd,g_pattern_param);
			VERDICT_RESULT_WITH_LINE();

			sleep(1); //waiting encryption change
			if (SUCCESS != QUERY_Event(dut1_fd,buf ,_BT_HCI_EVENT_OP_ENCRYPTION_CHANGE_))
			{
				line=__LINE__;
				goto FUN_FAIL;
			}

			if(SUCCESS != hci_event_encryption_change_parsing(0,buf,g_pattern_param))
			{
				line=__LINE__;
				goto FUN_FAIL;
			}

			//##########################################

			COMM_Start_Encryption_Config(dut2_fd,&g_pattern_param, conn_handles_mas);
			verdict=COMM_Start_Encryption(dut2_fd,g_pattern_param);
			VERDICT_RESULT_WITH_LINE();
			//should check timing

            do{
                ret=socket_msg_get(dut_fd,&len,buf);
            }while(len <=0);
			printf("Get Event(%d):\n",dut1_fd);
			if(SUCCESS != hci_le_event_ltk_request_parsing(0,buf,g_pattern_param))
			{
				line=__LINE__;
				goto FUN_FAIL;
			}

			for ( ;test_cnt1 > 0 ; test_cnt1 --)
			{
				verdict=COMM_Send_ACL_Data(dut1_fd,conn_handles_sla,0b01,0,10,acl_data);
				VERDICT_RESULT_WITH_LINE();
			}

			if (SUCCESS != QUERY_Acl_Data(dut2_fd,buf))
			{
				line=__LINE__;
				goto FUN_FAIL;
			}

			if (0b01 != (buf [_BT_HCI_IDX_ACL_DATA_CONN_HANDLE_ + 1] & 0xF0 ) >> 4)
			{
				line=__LINE__;
				goto FUN_FAIL;
			}

			COMM_Ltk_Req_Rep_Config(dut1_fd,&g_pattern_param, conn_handles_sla);//peer conn_handle?
			verdict=COMM_Ltk_Req_Rep(dut1_fd,g_pattern_param);
			VERDICT_RESULT_WITH_LINE();

			sleep(1); //waiting encryption change

			if (SUCCESS != QUERY_Acl_Data(dut1_fd,buf))//step2 ~ 4
			{
				line=__LINE__;
				goto FUN_FAIL;
			}
			//should be something here!!
			if (0xFF != (buf [_BT_HCI_IDX_ACL_DATA_PAYLOAD_]))
			{
				line=__LINE__;
				goto FUN_FAIL;
			}


			if (SUCCESS != QUERY_Event(dut1_fd,buf ,_BT_HCI_EVENT_OP_ENCRYPTION_KEY_REFRESH_COMPLETE_))
			{
				line=__LINE__;
				goto FUN_FAIL;
			}

			if(SUCCESS != hci_event_encryption_key_refresh_complte_parsing(0,buf,g_pattern_param))
			{
				line=__LINE__;
				goto FUN_FAIL;
			}
#endif
			LOG_INFO("[Pattern][%s]SUCCESS\n" ,__FUNCTION__);
			return PASS;
		}
	}

FUN_FAIL:
	LOG_INFO("[Pattern][%s]:%d FAIL\n" ,__FUNCTION__,line);
    return FAIL;

}


// 5.10.1.7
verdict SEC_MAS_Master_Encryption_Setup_Missing_Request (u8 dut1_fd ,u8 dut2_fd)
{
	u8 buf[SOCKET_BUF_SIZE];
	int verdict=FAIL;
	int dut2 = 0;
	u16 line =0 ;
	struct itimerval timer;
	u8 conn_handles_mas[2];

    COMM_Dut_clean_buffer(dut1_fd);
    COMM_Dut_clean_buffer(dut2_fd);

	COMM_ADV_Directed_Advertising_Config(HCI_CMD_PARAM_ADV_DATA_LEN_MAX,&g_pattern_param);
	memcpy (g_pattern_param.adv_param.Direct_Address , adv_addr , ADDR_LENGTH);//should be peer addr!!!
	//here use lowest ch to testing
	g_pattern_param.adv_param.Advertising_Channel_Map[0] =HCI_CMD_PARAM_ENABLE_CHANNEL_37 ;
	verdict=COMM_ADV_Directed_Advertising(dut1_fd,g_pattern_param);
	VERDICT_RESULT_WITH_LINE();

	COMM_INI_Initiating_Config(dut2,&g_pattern_param);	//dut 2 is master
	memcpy(g_pattern_param.create_conn_param.Peer_Address ,scan_addr,ADDR_LENGTH );
	verdict=COMM_INI_Initiating(dut2_fd,g_pattern_param);
	VERDICT_RESULT_WITH_LINE();


	event_query_timer_config(5 , 0 , 0 , 0, &timer);
	event_query_timer_start(timer ,read_le_event_enable );

	while(1)//waiting adv report event , timer or counter
	{
		if ( 1 == read_le_event_get() )
		{            
            read_le_event_disable();
        
			if (SUCCESS != QUERY_LE_Event(dut2_fd,buf ,
										_BT_HCI_LE_EVENT_SUB_OP_CONNECTION_COMPLETE_,
										0))
			{
				line=__LINE__;
				goto FUN_FAIL;
			}

			if(SUCCESS != hci_le_event_connection_complete_parsing(0,
										buf,g_pattern_param))
			{
				line=__LINE__;
				goto FUN_FAIL;
			}

			conn_handles_mas[0]=buf[_BT_HCI_EVT_COMP_HANDLE+0];
			conn_handles_mas[1]=buf[_BT_HCI_EVT_COMP_HANDLE+1];


			if (SUCCESS != QUERY_LE_Event(dut1_fd,buf ,
										_BT_HCI_LE_EVENT_SUB_OP_CONNECTION_COMPLETE_,
										0))
			{
				line=__LINE__;
				goto FUN_FAIL;
			}

			if(SUCCESS != hci_le_event_connection_complete_parsing(0,
										buf,g_pattern_param))
			{
				line=__LINE__;
				goto FUN_FAIL;
			}

			//conn_handles_sla[0]=buf[_BT_HCI_EVT_COMP_HANDLE+0];
			//conn_handles_sla[1]=buf[_BT_HCI_EVT_COMP_HANDLE+1];

			COMM_Start_Encryption_Config(dut2_fd,&g_pattern_param, conn_handles_mas);
			verdict=COMM_Start_Encryption(dut2_fd,g_pattern_param);
			VERDICT_RESULT_WITH_LINE();
#if 0
            do{
                ret=socket_msg_get(dut_fd,&len,buf);
            }while(len <=0);
			printf("Get Event(%d):\n",dut1_fd);
			print_charray(len,buf);
			if(SUCCESS != hci_le_event_ltk_request_parsing(0,buf,g_pattern_param))
			{
				line=__LINE__;
				goto FUN_FAIL;
			}
#endif
			sleep(40) ; //more time to wait supervistion TO

			sleep(1); //waiting encryption change
			if (SUCCESS != QUERY_Event(dut2_fd,buf ,_BT_HCI_EVENT_OP_ENCRYPTION_CHANGE_))
			{
				line=__LINE__;
				goto FUN_FAIL;
			}

			if(SUCCESS != hci_event_encryption_change_parsing(0,buf,g_pattern_param))
			{
				line=__LINE__;
				goto FUN_FAIL;
			}

#if 0
			if (SUCCESS != QUERY_Event(dut2_fd,buf ,
										_BT_HCI_EVENT_OP_DISCONNECTION_COMPLETE_))
			{
				line=__LINE__;
				goto FUN_FAIL;
			}

			hci_event_disconnection_complete_parsing(0,buf,g_pattern_param);
			if(_BT_HCI_EVT_CMD_COMP_STATUS_RESPONSE_TIMEOUT
				!= buf[_BT_HCI_EVT_DISCONN_COMP_REASON])
			{
				line=__LINE__;
				goto FUN_FAIL;
			}
#endif
#if 0
			if( !=
				hci_event_disconnection_complete_parsing(0,buf,g_pattern_param))
			{
				line=__LINE__;
				goto FUN_FAIL;
			}
#endif
#if 0
			COMM_Ltk_Req_Rep_Config(dut1_fd,&g_pattern_param, conn_handles_sla);//peer conn_handle?
			verdict=COMM_Ltk_Req_Rep(dut1_fd,g_pattern_param);
			VERDICT_RESULT_WITH_LINE();

			sleep(1); //waiting encryption change
			if (SUCCESS != QUERY_Event(dut1_fd,buf ,_BT_HCI_EVENT_OP_ENCRYPTION_CHANGE_))
			{
				line=__LINE__;
				goto FUN_FAIL;
			}

			if(SUCCESS != hci_event_encryption_change_parsing(0,buf,g_pattern_param))
			{
				line=__LINE__;
				goto FUN_FAIL;
			}

			//##########################################

			COMM_Start_Encryption_Config(dut2_fd,&g_pattern_param, conn_handles_mas);
			verdict=COMM_Start_Encryption(dut2_fd,g_pattern_param);
			VERDICT_RESULT_WITH_LINE();
			//should check timing

            do{
                ret=socket_msg_get(dut_fd,&len,buf);
            }while(len <=0);
			printf("Get Event(%d):\n",dut1_fd);
			if(SUCCESS != hci_le_event_ltk_request_parsing(0,buf,g_pattern_param))
			{
				line=__LINE__;
				goto FUN_FAIL;
			}

			for ( ;test_cnt1 > 0 ; test_cnt1 --)
			{
				verdict=COMM_Send_ACL_Data(dut1_fd,conn_handles_sla,0b01,0,10,acl_data);
				VERDICT_RESULT_WITH_LINE();
			}

			if (SUCCESS != QUERY_Acl_Data(dut2_fd,buf))
			{
				line=__LINE__;
				goto FUN_FAIL;
			}

			if (0b01 != (buf [_BT_HCI_IDX_ACL_DATA_CONN_HANDLE_ + 1] & 0xF0 ) >> 4)
			{
				line=__LINE__;
				goto FUN_FAIL;
			}

			COMM_Ltk_Req_Rep_Config(dut1_fd,&g_pattern_param, conn_handles_sla);//peer conn_handle?
			verdict=COMM_Ltk_Req_Rep(dut1_fd,g_pattern_param);
			VERDICT_RESULT_WITH_LINE();

			sleep(1); //waiting encryption change

			if (SUCCESS != QUERY_Acl_Data(dut1_fd,buf))//step2 ~ 4
			{
				line=__LINE__;
				goto FUN_FAIL;
			}
			//should be something here!!
			if (0xFF != (buf [_BT_HCI_IDX_ACL_DATA_PAYLOAD_]))
			{
				line=__LINE__;
				goto FUN_FAIL;
			}


			if (SUCCESS != QUERY_Event(dut1_fd,buf ,_BT_HCI_EVENT_OP_ENCRYPTION_KEY_REFRESH_COMPLETE_))
			{
				line=__LINE__;
				goto FUN_FAIL;
			}

			if(SUCCESS != hci_event_encryption_key_refresh_complte_parsing(0,buf,g_pattern_param))
			{
				line=__LINE__;
				goto FUN_FAIL;
			}
#endif
			LOG_INFO("[Pattern][%s]SUCCESS\n" ,__FUNCTION__);
			return PASS;
		}
	}

FUN_FAIL:
	LOG_INFO("[Pattern][%s]:%d FAIL\n" ,__FUNCTION__,line);
    return FAIL;

}


// 5.10.1.11
verdict SEC_MAS_Master_Pause_Encryption_Sending_Data (u8 dut1_fd ,u8 dut2_fd)
{
	u8 buf[SOCKET_BUF_SIZE];
	u16 len;
	int verdict=FAIL;
	int dut2 =0;
	u16 line =0 ;
	struct itimerval timer;
	u8 conn_handles_mas[2];
	u8 acl_data[10]={0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF};

    int mas_pkt_chk = 0;

    COMM_Dut_clean_buffer(dut1_fd);
    COMM_Dut_clean_buffer(dut2_fd);

	COMM_ADV_Directed_Advertising_Config(HCI_CMD_PARAM_ADV_DATA_LEN_MAX,&g_pattern_param);
	memcpy (g_pattern_param.adv_param.Direct_Address , adv_addr , ADDR_LENGTH);//should be peer addr!!!
	//here use lowest ch to testing
	g_pattern_param.adv_param.Advertising_Channel_Map[0] =HCI_CMD_PARAM_ENABLE_CHANNEL_37 ;
	verdict=COMM_ADV_Directed_Advertising(dut1_fd,g_pattern_param);
	VERDICT_RESULT_WITH_LINE();

	COMM_INI_Initiating_Config(dut2,&g_pattern_param);	//dut 2 is master
	memcpy(g_pattern_param.create_conn_param.Peer_Address ,scan_addr,ADDR_LENGTH );
	verdict=COMM_INI_Initiating(dut2_fd,g_pattern_param);
	VERDICT_RESULT_WITH_LINE();


	event_query_timer_config(5 , 0 , 0 , 0, &timer);
	event_query_timer_start(timer ,read_le_event_enable );

	while(1)//waiting adv report event , timer or counter
	{
		if ( 1 == read_le_event_get() )
		{            
            read_le_event_disable();
        
			if (SUCCESS != QUERY_LE_Event(dut2_fd,buf ,
										_BT_HCI_LE_EVENT_SUB_OP_CONNECTION_COMPLETE_,
										0))
			{
				line=__LINE__;
				goto FUN_FAIL;
			}

			if(SUCCESS != hci_le_event_connection_complete_parsing(0,
										buf,g_pattern_param))
			{
				line=__LINE__;
				goto FUN_FAIL;
			}

			conn_handles_mas[0]=buf[_BT_HCI_EVT_COMP_HANDLE+0];
			conn_handles_mas[1]=buf[_BT_HCI_EVT_COMP_HANDLE+1];


			if (SUCCESS != QUERY_LE_Event(dut1_fd,buf ,
										_BT_HCI_LE_EVENT_SUB_OP_CONNECTION_COMPLETE_,
										0))
			{
				line=__LINE__;
				goto FUN_FAIL;
			}

			if(SUCCESS != hci_le_event_connection_complete_parsing(0,
										buf,g_pattern_param))
			{
				line=__LINE__;
				goto FUN_FAIL;
			}

			COMM_Start_Encryption_Config(dut2_fd,&g_pattern_param, conn_handles_mas);
			verdict=COMM_Start_Encryption(dut2_fd,g_pattern_param);
			VERDICT_RESULT_WITH_LINE();
#if 1
            do{
                socket_msg_get(dut1_fd,&len,buf);
            }while(len <=0);
			printf("Get Event(%d):\n",dut1_fd);
			print_charray(len,buf);
			if(SUCCESS != hci_le_event_ltk_request_parsing(0,buf,g_pattern_param))
			{
				line=__LINE__;
				goto FUN_FAIL;
			}
#endif
			COMM_Send_ACL_Data_Without_event(dut1_fd,conn_handles_mas,0b01,0,10,acl_data);
PKT_CHK:
            // # check disconnection             
            CHECK_NON_DISCONNECT();
    
            if(SUCCESS != QUERY_Event(dut1_fd, buf, _BT_HCI_EVENT_OP_NUMBER_OF_COMPLETED_PACKETS_)) {
                line = __LINE__;
                goto FUN_FAIL;
            }
            else if(1 != hci_event_num_of_completed_packets_parsing(buf)) {

                MSLEEP(100);
                mas_pkt_chk ++ ;
                if (mas_pkt_chk == 100){
                    printf("mas no number of completed pkts\n");
                    line = __LINE__;
                    goto FUN_FAIL;                  
                }
                goto PKT_CHK;
            
            }                 
            
            mas_pkt_chk = 0;


			sleep(40) ; //more time to wait supervistion TO

			sleep(1); //waiting encryption change
			if (SUCCESS != QUERY_Event(dut2_fd,buf ,_BT_HCI_EVENT_OP_ENCRYPTION_CHANGE_))
			{
				line=__LINE__;
				goto FUN_FAIL;
			}

			if(SUCCESS != hci_event_encryption_change_parsing(0,buf,g_pattern_param))
			{
				line=__LINE__;
				goto FUN_FAIL;
			}

#if 0
			if (SUCCESS != QUERY_Event(dut2_fd,buf ,
										_BT_HCI_EVENT_OP_DISCONNECTION_COMPLETE_))
			{
				line=__LINE__;
				goto FUN_FAIL;
			}

			hci_event_disconnection_complete_parsing(0,buf,g_pattern_param);
			if(_BT_HCI_EVT_CMD_COMP_STATUS_RESPONSE_TIMEOUT
				!= buf[_BT_HCI_EVT_DISCONN_COMP_REASON])
			{
				line=__LINE__;
				goto FUN_FAIL;
			}
#endif
#if 0
			if( !=
				hci_event_disconnection_complete_parsing(0,buf,g_pattern_param))
			{
				line=__LINE__;
				goto FUN_FAIL;
			}
#endif
#if 0
			COMM_Ltk_Req_Rep_Config(dut1_fd,&g_pattern_param, conn_handles_sla);//peer conn_handle?
			verdict=COMM_Ltk_Req_Rep(dut1_fd,g_pattern_param);
			VERDICT_RESULT_WITH_LINE();

			sleep(1); //waiting encryption change
			if (SUCCESS != QUERY_Event(dut1_fd,buf ,_BT_HCI_EVENT_OP_ENCRYPTION_CHANGE_))
			{
				line=__LINE__;
				goto FUN_FAIL;
			}

			if(SUCCESS != hci_event_encryption_change_parsing(0,buf,g_pattern_param))
			{
				line=__LINE__;
				goto FUN_FAIL;
			}

			//##########################################

			COMM_Start_Encryption_Config(dut2_fd,&g_pattern_param, conn_handles_mas);
			verdict=COMM_Start_Encryption(dut2_fd,g_pattern_param);
			VERDICT_RESULT_WITH_LINE();
			//should check timing

            do{
                ret=socket_msg_get(dut_fd,&len,buf);
            }while(len <=0);
			printf("Get Event(%d):\n",dut1_fd);
			if(SUCCESS != hci_le_event_ltk_request_parsing(0,buf,g_pattern_param))
			{
				line=__LINE__;
				goto FUN_FAIL;
			}

			for ( ;test_cnt1 > 0 ; test_cnt1 --)
			{
				verdict=COMM_Send_ACL_Data(dut1_fd,conn_handles_sla,0b01,0,10,acl_data);
				VERDICT_RESULT_WITH_LINE();
			}

			if (SUCCESS != QUERY_Acl_Data(dut2_fd,buf))
			{
				line=__LINE__;
				goto FUN_FAIL;
			}

			if (0b01 != (buf [_BT_HCI_IDX_ACL_DATA_CONN_HANDLE_ + 1] & 0xF0 ) >> 4)
			{
				line=__LINE__;
				goto FUN_FAIL;
			}

			COMM_Ltk_Req_Rep_Config(dut1_fd,&g_pattern_param, conn_handles_sla);//peer conn_handle?
			verdict=COMM_Ltk_Req_Rep(dut1_fd,g_pattern_param);
			VERDICT_RESULT_WITH_LINE();

			sleep(1); //waiting encryption change

			if (SUCCESS != QUERY_Acl_Data(dut1_fd,buf))//step2 ~ 4
			{
				line=__LINE__;
				goto FUN_FAIL;
			}
			//should be something here!!
			if (0xFF != (buf [_BT_HCI_IDX_ACL_DATA_PAYLOAD_]))
			{
				line=__LINE__;
				goto FUN_FAIL;
			}


			if (SUCCESS != QUERY_Event(dut1_fd,buf ,_BT_HCI_EVENT_OP_ENCRYPTION_KEY_REFRESH_COMPLETE_))
			{
				line=__LINE__;
				goto FUN_FAIL;
			}

			if(SUCCESS != hci_event_encryption_key_refresh_complte_parsing(0,buf,g_pattern_param))
			{
				line=__LINE__;
				goto FUN_FAIL;
			}
#endif
			LOG_INFO("[Pattern][%s]SUCCESS\n" ,__FUNCTION__);
			return PASS;
		}
	}

FUN_FAIL:
	LOG_INFO("[Pattern][%s]:%d FAIL\n" ,__FUNCTION__,line);
    return FAIL;

}

verdict PROF_Heart_Rate_1(u8 dut1_fd, u8 dut2_fd)
{
	u8 buf[SOCKET_BUF_SIZE];	
	int verdict = FAIL;
	int dut1 = 0;
	u16 line = 0;
	struct itimerval timer;	
	u32 adv_cnt = 0;	  
    u16 time_reduce = 1;
    
    Calculate_Execution_Time_Start();

    //first 30 sec , adv 20ms , scan 30ms
    
	COMM_INI_Connection_Setup_White_Listed_Config(dut1, &g_pattern_param);
	memcpy(g_pattern_param.white_list_param.Address, adv_addr, ADDR_LENGTH);
	verdict = COMM_INI_Connection_Setup_White_Listed(dut1_fd, g_pattern_param);
	VERDICT_RESULT_WITH_LINE();

	COMM_SCN_Passive_Scanning_Config(dut1, &g_pattern_param);
	g_pattern_param.scn_param.LE_Scan_Interval[0] =  48/time_reduce & 0x00ff;
	g_pattern_param.scn_param.LE_Scan_Interval[1] = (48/time_reduce & 0xff00) >> 8;
	g_pattern_param.scn_param.LE_Scan_Window[0] =	 48/time_reduce & 0x00ff;
	g_pattern_param.scn_param.LE_Scan_Window[1] =   (48/time_reduce & 0xff00) >> 8;
	g_pattern_param.scn_param.Scanning_Filter_Policy[0] = HCI_CMD_PARAM_IGNORE_ADV_PKTS_FROM_DEV_NOT_IN_WHITE_LIST_ONLY;
	verdict = COMM_SCN_Passive_Scanning(dut1_fd, g_pattern_param);
	VERDICT_RESULT_WITH_LINE();

	COMM_ADV_Undirected_Advertising_Config(HCI_CMD_PARAM_ADV_DATA_LEN_MAX, &g_pattern_param);
	g_pattern_param.adv_param.Advertising_Filter_Policy[0] = HCI_CMD_PARAM_ALLOW_SCAN_REQ_FROM_WHITELIST_ONLY_AND_CONN_REQ_FROM_WHITELIST_ONLY;
	g_pattern_param.adv_data_param.Advertising_Data_Length[0] = 0x00;
	//The timing range detected for advertising events(ADV_IND) is from 20.0 ms to 30.0 ms
	//interval : 32(0x0020) * 0.625ms = 20ms
	g_pattern_param.adv_param.Advertising_Interval_Max[0] =  HCI_CMD_PARAM_ADVERTISING_INTERVAL_MIN & 0x00ff;
	g_pattern_param.adv_param.Advertising_Interval_Max[1] = (HCI_CMD_PARAM_ADVERTISING_INTERVAL_MIN & 0xff00) >> 8;
	g_pattern_param.adv_param.Advertising_Interval_Min[0] =  HCI_CMD_PARAM_ADVERTISING_INTERVAL_MIN & 0x00ff;
	g_pattern_param.adv_param.Advertising_Interval_Min[1] = (HCI_CMD_PARAM_ADVERTISING_INTERVAL_MIN & 0xff00) >> 8;
	verdict = COMM_ADV_Undirected_Advertising(dut2_fd, g_pattern_param);
	VERDICT_RESULT_WITH_LINE();

	read_le_event_enable();
	printf("****wait for 30 sec****\n" );
	while(1) {//waiting adv report event , timer or counter  
		if(1 == read_le_event_get()) {
		    // start the scanning time :30 sec
		    event_query_timer_config(30/time_reduce, 0, 0, 0, &timer);
		    event_query_timer_start(timer, read_le_event_disable);
		    while(read_le_event_get()) {
                MSLEEP(10);
			    if(SUCCESS != QUERY_LE_Event(dut1_fd, buf, _BT_HCI_LE_EVENT_SUB_OP_ADVERTISING_REPORT_, HCI_SUBEVENT_ADV_RPT_EVENT_ADV_IND)) {				
				    
				    
				    continue;
			    }
    			else if(EQUAL != hci_le_event_advertising_report_parsing(HCI_SUBEVENT_ADV_RPT_EVENT_ADV_IND, buf,g_pattern_param)) {
    				
    				continue;
    			}
    			else {
    				adv_cnt++; 
                    printf("adv coming, chk %d\n" , adv_cnt);
    			}    					
    		}

            // the ideal value : 30(s) / 30(ms) = 1000
            if (((float)((adv_cnt * 100) / (1000/time_reduce))) <= 50) {
                line=__LINE__;
    			goto FUN_FAIL;
            }
            else {

                FUNC_END();
                LOG_INFO("[Pattern][%s]SUCCESS, Counter : %d\n", __FUNCTION__, adv_cnt);
    		    LOG_INFO("[Pattern][%s]Ideal value : %d\n", __FUNCTION__, 1000/time_reduce);
    		    LOG_INFO("[Pattern][%s] Exp. value : %d\n", __FUNCTION__, adv_cnt);
    		    LOG_INFO("[Pattern][%s]Ratio value : %.2f %%\n", __FUNCTION__, (float)((adv_cnt * 100) / 1000/time_reduce));
            }    		

    		return PASS;
		}
    }	
FUN_FAIL:
    FUNC_END();

	LOG_INFO("[Pattern][%s]:%d FAIL\n" ,__FUNCTION__,line);
    LOG_INFO("[Pattern][%s]FAIL, Counter : %d\n", __FUNCTION__, adv_cnt);
    LOG_INFO("[Pattern][%s]Ideal value : %d\n", __FUNCTION__, 1000/time_reduce);
    LOG_INFO("[Pattern][%s] Exp. value : %d\n", __FUNCTION__, adv_cnt);
    LOG_INFO("[Pattern][%s]Ratio value : %.2f %%\n", __FUNCTION__, (float)((adv_cnt * 100) / 1000/time_reduce));
    
    return FAIL;

}

verdict PROF_Heart_Rate_2(u8 dut1_fd, u8 dut2_fd)
{
	u8 buf[SOCKET_BUF_SIZE];	
	int verdict = FAIL;
	int dut1 = 0;
	u16 line = 0;
	struct itimerval timer;	
	u32 adv_cnt = 0;	  
    u16 time_reduce = 1;
    
    Calculate_Execution_Time_Start();

    //sec 30 sec , adv 20ms , scan win 11.25ms , scan int 2.56s
    
	COMM_INI_Connection_Setup_White_Listed_Config(dut1, &g_pattern_param);
	memcpy(g_pattern_param.white_list_param.Address, adv_addr, ADDR_LENGTH);
	verdict = COMM_INI_Connection_Setup_White_Listed(dut1_fd, g_pattern_param);
	VERDICT_RESULT_WITH_LINE();

	COMM_SCN_Passive_Scanning_Config(dut1, &g_pattern_param);
	g_pattern_param.scn_param.LE_Scan_Interval[0] =  4096/time_reduce & 0x00ff;
	g_pattern_param.scn_param.LE_Scan_Interval[1] = (4096/time_reduce & 0xff00) >> 8;
	g_pattern_param.scn_param.LE_Scan_Window[0] =	 18/time_reduce & 0x00ff;
	g_pattern_param.scn_param.LE_Scan_Window[1] =   (18/time_reduce & 0xff00) >> 8;
	g_pattern_param.scn_param.Scanning_Filter_Policy[0] = HCI_CMD_PARAM_IGNORE_ADV_PKTS_FROM_DEV_NOT_IN_WHITE_LIST_ONLY;
	verdict = COMM_SCN_Passive_Scanning(dut1_fd, g_pattern_param);
	VERDICT_RESULT_WITH_LINE();

	COMM_ADV_Undirected_Advertising_Config(HCI_CMD_PARAM_ADV_DATA_LEN_MAX, &g_pattern_param);
	g_pattern_param.adv_param.Advertising_Filter_Policy[0] = HCI_CMD_PARAM_ALLOW_SCAN_REQ_FROM_WHITELIST_ONLY_AND_CONN_REQ_FROM_WHITELIST_ONLY;
	g_pattern_param.adv_data_param.Advertising_Data_Length[0] = 0x00;
	//The timing range detected for advertising events(ADV_IND) is from 20.0 ms to 30.0 ms
	//interval : 32(0x0020) * 0.625ms = 20ms
	g_pattern_param.adv_param.Advertising_Interval_Max[0] =  HCI_CMD_PARAM_ADVERTISING_INTERVAL_MIN & 0x00ff;
	g_pattern_param.adv_param.Advertising_Interval_Max[1] = (HCI_CMD_PARAM_ADVERTISING_INTERVAL_MIN & 0xff00) >> 8;
	g_pattern_param.adv_param.Advertising_Interval_Min[0] =  HCI_CMD_PARAM_ADVERTISING_INTERVAL_MIN & 0x00ff;
	g_pattern_param.adv_param.Advertising_Interval_Min[1] = (HCI_CMD_PARAM_ADVERTISING_INTERVAL_MIN & 0xff00) >> 8;
	verdict = COMM_ADV_Undirected_Advertising(dut2_fd, g_pattern_param);
	VERDICT_RESULT_WITH_LINE();

	read_le_event_enable();
	printf("****timer for 30sec****\n" );
	while(1) {//waiting adv report event , timer or counter  
		if(1 == read_le_event_get()) {
		    // start the scanning time :30 sec
		    event_query_timer_config(30/time_reduce, 0, 0, 0, &timer);
		    event_query_timer_start(timer, read_le_event_disable);
		    while(read_le_event_get()) {
                MSLEEP(10);
			    if(SUCCESS != QUERY_LE_Event(dut1_fd, buf, _BT_HCI_LE_EVENT_SUB_OP_ADVERTISING_REPORT_, HCI_SUBEVENT_ADV_RPT_EVENT_ADV_IND)) {				
				    
				    
				    continue;
			    }
    			else if(EQUAL != hci_le_event_advertising_report_parsing(HCI_SUBEVENT_ADV_RPT_EVENT_ADV_IND, buf,g_pattern_param)) {
    				
    				continue;
    			}
    			else {
    				adv_cnt++; 
                    printf("adv coming, chk %d\n" , adv_cnt);
    			}    					
    		}

            // the ideal value : 30(s) / 30(ms) = 1000
            if (adv_cnt <= 4) {
                line=__LINE__;
    			goto FUN_FAIL;
            }
            else {

                FUNC_END();
                LOG_INFO("[Pattern][%s]SUCCESS, Counter : %d\n", __FUNCTION__, adv_cnt);
    		    LOG_INFO("[Pattern][%s]Ideal value : %d\n", __FUNCTION__, 4);
    		    LOG_INFO("[Pattern][%s] Exp. value : %d\n", __FUNCTION__, adv_cnt);
            }    		

    		return PASS;
		}
    }	
FUN_FAIL:
    FUNC_END();

	LOG_INFO("[Pattern][%s]:%d FAIL\n" ,__FUNCTION__,line);
    LOG_INFO("[Pattern][%s]Ideal value : %d\n", __FUNCTION__, 4);
    LOG_INFO("[Pattern][%s] Exp. value : %d\n", __FUNCTION__, adv_cnt);
    
    return FAIL;

}

verdict PROF_Heart_Rate_3(u8 dut1_fd, u8 dut2_fd)
{
	u8 buf[SOCKET_BUF_SIZE];	
	int verdict = FAIL;
	int dut1 = 0;
	u16 line = 0;
	struct itimerval timer;	
	u32 adv_cnt = 0;	  
    u16 time_reduce = 1;
    
    Calculate_Execution_Time_Start();

    //3nd , adv 1s , scan 30ms
    
	COMM_INI_Connection_Setup_White_Listed_Config(dut1, &g_pattern_param);
	memcpy(g_pattern_param.white_list_param.Address, adv_addr, ADDR_LENGTH);
	verdict = COMM_INI_Connection_Setup_White_Listed(dut1_fd, g_pattern_param);
	VERDICT_RESULT_WITH_LINE();

	COMM_SCN_Passive_Scanning_Config(dut1, &g_pattern_param);
	g_pattern_param.scn_param.LE_Scan_Interval[0] =  48/time_reduce & 0x00ff;
	g_pattern_param.scn_param.LE_Scan_Interval[1] = (48/time_reduce & 0xff00) >> 8;
	g_pattern_param.scn_param.LE_Scan_Window[0] =	 48/time_reduce & 0x00ff;
	g_pattern_param.scn_param.LE_Scan_Window[1] =   (48/time_reduce & 0xff00) >> 8;
	g_pattern_param.scn_param.Scanning_Filter_Policy[0] = HCI_CMD_PARAM_IGNORE_ADV_PKTS_FROM_DEV_NOT_IN_WHITE_LIST_ONLY;
	verdict = COMM_SCN_Passive_Scanning(dut1_fd, g_pattern_param);
	VERDICT_RESULT_WITH_LINE();

	COMM_ADV_Undirected_Advertising_Config(HCI_CMD_PARAM_ADV_DATA_LEN_MAX, &g_pattern_param);
	g_pattern_param.adv_param.Advertising_Filter_Policy[0] = HCI_CMD_PARAM_ALLOW_SCAN_REQ_FROM_WHITELIST_ONLY_AND_CONN_REQ_FROM_WHITELIST_ONLY;
	g_pattern_param.adv_data_param.Advertising_Data_Length[0] = 0x00;
	//The timing range detected for advertising events(ADV_IND) is from 20.0 ms to 30.0 ms
	//interval : 32(0x0020) * 0.625ms = 20ms
	g_pattern_param.adv_param.Advertising_Interval_Max[0] =  1600 & 0x00ff;
	g_pattern_param.adv_param.Advertising_Interval_Max[1] = (1600 & 0xff00) >> 8;
	g_pattern_param.adv_param.Advertising_Interval_Min[0] =  1600 & 0x00ff;
	g_pattern_param.adv_param.Advertising_Interval_Min[1] = (1600 & 0xff00) >> 8;
	verdict = COMM_ADV_Undirected_Advertising(dut2_fd, g_pattern_param);
	VERDICT_RESULT_WITH_LINE();

	read_le_event_enable();
	printf("****wait for 30 sec****\n" );
	while(1) {//waiting adv report event , timer or counter  
		if(1 == read_le_event_get()) {
		    // start the scanning time :30 sec
		    event_query_timer_config(30/time_reduce, 0, 0, 0, &timer);
		    event_query_timer_start(timer, read_le_event_disable);
		    while(read_le_event_get()) {
                MSLEEP(10);
			    if(SUCCESS != QUERY_LE_Event(dut1_fd, buf, _BT_HCI_LE_EVENT_SUB_OP_ADVERTISING_REPORT_, HCI_SUBEVENT_ADV_RPT_EVENT_ADV_IND)) {				
				    
				    
				    continue;
			    }
    			else if(EQUAL != hci_le_event_advertising_report_parsing(HCI_SUBEVENT_ADV_RPT_EVENT_ADV_IND, buf,g_pattern_param)) {
    				
    				continue;
    			}
    			else {
    				adv_cnt++; 
                    printf("adv coming, chk %d\n" , adv_cnt);
    			}    					
    		}

            // the ideal value : 30(s)/1(s)30
            if (adv_cnt <= 24) {
                line=__LINE__;
    			goto FUN_FAIL;
            }
            else {

                FUNC_END();
                LOG_INFO("[Pattern][%s]SUCCESS, Counter : %d\n", __FUNCTION__, adv_cnt);
    		    LOG_INFO("[Pattern][%s]Ideal value : %d\n", __FUNCTION__, 24);
    		    LOG_INFO("[Pattern][%s] Exp. value : %d\n", __FUNCTION__, adv_cnt);
            }    		

    		return PASS;
		}
    }	
FUN_FAIL:
    FUNC_END();

	LOG_INFO("[Pattern][%s]:%d FAIL\n" ,__FUNCTION__,line);
    LOG_INFO("[Pattern][%s]Ideal value : %d\n", __FUNCTION__, 24);
    LOG_INFO("[Pattern][%s] Exp. value : %d\n", __FUNCTION__, adv_cnt);
    
    return FAIL;

}


verdict PROF_Heart_Rate_4(u8 dut1_fd, u8 dut2_fd)
{
	u8 buf[SOCKET_BUF_SIZE];	
	int verdict = FAIL;
	int dut1 = 0;
	u16 line = 0;
	struct itimerval timer;	
	u32 adv_cnt = 0;	  
    u16 time_reduce = 1;
    
    Calculate_Execution_Time_Start();

    //4th , adv 1s , scan win 11.25ms , scan int 2.56s
    
	COMM_INI_Connection_Setup_White_Listed_Config(dut1, &g_pattern_param);
	memcpy(g_pattern_param.white_list_param.Address, adv_addr, ADDR_LENGTH);
	verdict = COMM_INI_Connection_Setup_White_Listed(dut1_fd, g_pattern_param);
	VERDICT_RESULT_WITH_LINE();

	COMM_SCN_Passive_Scanning_Config(dut1, &g_pattern_param);
	g_pattern_param.scn_param.LE_Scan_Interval[0] =  4096/time_reduce & 0x00ff;
	g_pattern_param.scn_param.LE_Scan_Interval[1] = (4096/time_reduce & 0xff00) >> 8;
	g_pattern_param.scn_param.LE_Scan_Window[0] =	 18/time_reduce & 0x00ff;
	g_pattern_param.scn_param.LE_Scan_Window[1] =   (18/time_reduce & 0xff00) >> 8;

	g_pattern_param.scn_param.Scanning_Filter_Policy[0] = HCI_CMD_PARAM_IGNORE_ADV_PKTS_FROM_DEV_NOT_IN_WHITE_LIST_ONLY;
	verdict = COMM_SCN_Passive_Scanning(dut1_fd, g_pattern_param);
	VERDICT_RESULT_WITH_LINE();

	COMM_ADV_Undirected_Advertising_Config(HCI_CMD_PARAM_ADV_DATA_LEN_MAX, &g_pattern_param);
	g_pattern_param.adv_param.Advertising_Filter_Policy[0] = HCI_CMD_PARAM_ALLOW_SCAN_REQ_FROM_WHITELIST_ONLY_AND_CONN_REQ_FROM_WHITELIST_ONLY;
	g_pattern_param.adv_data_param.Advertising_Data_Length[0] = 0x00;
	//The timing range detected for advertising events(ADV_IND) is from 20.0 ms to 30.0 ms
	//interval : 32(0x0020) * 0.625ms = 20ms
	g_pattern_param.adv_param.Advertising_Interval_Max[0] =  1600 & 0x00ff;
	g_pattern_param.adv_param.Advertising_Interval_Max[1] = (1600 & 0xff00) >> 8;
	g_pattern_param.adv_param.Advertising_Interval_Min[0] =  1600 & 0x00ff;
	g_pattern_param.adv_param.Advertising_Interval_Min[1] = (1600 & 0xff00) >> 8;
	verdict = COMM_ADV_Undirected_Advertising(dut2_fd, g_pattern_param);
	VERDICT_RESULT_WITH_LINE();

	read_le_event_enable();
	printf("****wait for 30 sec****\n" );
	while(1) {//waiting adv report event , timer or counter  
		if(1 == read_le_event_get()) {
		    // start the scanning time :30 sec
		    event_query_timer_config(600/time_reduce, 0, 0, 0, &timer);
		    event_query_timer_start(timer, read_le_event_disable);
		    while(read_le_event_get()) {
                MSLEEP(10);
			    if(SUCCESS != QUERY_LE_Event(dut1_fd, buf, _BT_HCI_LE_EVENT_SUB_OP_ADVERTISING_REPORT_, HCI_SUBEVENT_ADV_RPT_EVENT_ADV_IND)) {				
				    
				    
				    continue;
			    }
    			else if(EQUAL != hci_le_event_advertising_report_parsing(HCI_SUBEVENT_ADV_RPT_EVENT_ADV_IND, buf,g_pattern_param)) {
    				
    				continue;
    			}
    			else {
    				adv_cnt++; 
                    printf("adv coming, chk %d\n" , adv_cnt);
    			}    					
    		}

            // the ideal value : 
            if (adv_cnt <= 1) {
                line=__LINE__;
    			goto FUN_FAIL;
            }
            else {

                FUNC_END();
                LOG_INFO("[Pattern][%s]SUCCESS, Counter : %d\n", __FUNCTION__, adv_cnt);
    		    LOG_INFO("[Pattern][%s]Ideal value : %d\n", __FUNCTION__, 1);
    		    LOG_INFO("[Pattern][%s] Exp. value : %d\n", __FUNCTION__, adv_cnt);
            }    		

    		return PASS;
		}
    }	
FUN_FAIL:
    FUNC_END();

	LOG_INFO("[Pattern][%s]:%d FAIL\n" ,__FUNCTION__,line);
    LOG_INFO("[Pattern][%s]Ideal value : %d\n", __FUNCTION__, 1);
    LOG_INFO("[Pattern][%s] Exp. value : %d\n", __FUNCTION__, adv_cnt);
    
    return FAIL;

}

verdict PROF_HID_1(u8 dut1_fd, u8 dut2_fd)
{
	u8 buf[SOCKET_BUF_SIZE];	
	int verdict = FAIL;
	int dut1 = 0;
	u16 line = 0;
	struct itimerval timer;	
	u32 adv_cnt = 0;	  
    u16 time_reduce = 1;
    
    Calculate_Execution_Time_Start();

    //1st fast-180, adv 30ms , scan win 11.25ms , scan int 22.5ms
    
	COMM_INI_Connection_Setup_White_Listed_Config(dut1, &g_pattern_param);
	memcpy(g_pattern_param.white_list_param.Address, adv_addr, ADDR_LENGTH);
	verdict = COMM_INI_Connection_Setup_White_Listed(dut1_fd, g_pattern_param);
	VERDICT_RESULT_WITH_LINE();

	COMM_SCN_Passive_Scanning_Config(dut1, &g_pattern_param);
	g_pattern_param.scn_param.LE_Scan_Interval[0] =  36/time_reduce & 0x00ff;
	g_pattern_param.scn_param.LE_Scan_Interval[1] = (36/time_reduce & 0xff00) >> 8;
	g_pattern_param.scn_param.LE_Scan_Window[0] =	 18/time_reduce & 0x00ff;
	g_pattern_param.scn_param.LE_Scan_Window[1] =   (18/time_reduce & 0xff00) >> 8;

	g_pattern_param.scn_param.Scanning_Filter_Policy[0] = HCI_CMD_PARAM_IGNORE_ADV_PKTS_FROM_DEV_NOT_IN_WHITE_LIST_ONLY;
	verdict = COMM_SCN_Passive_Scanning(dut1_fd, g_pattern_param);
	VERDICT_RESULT_WITH_LINE();

	COMM_ADV_Undirected_Advertising_Config(HCI_CMD_PARAM_ADV_DATA_LEN_MAX, &g_pattern_param);
	g_pattern_param.adv_param.Advertising_Filter_Policy[0] = HCI_CMD_PARAM_ALLOW_SCAN_REQ_FROM_WHITELIST_ONLY_AND_CONN_REQ_FROM_WHITELIST_ONLY;
	g_pattern_param.adv_data_param.Advertising_Data_Length[0] = 0x00;

	g_pattern_param.adv_param.Advertising_Interval_Max[0] =  48 & 0x00ff;
	g_pattern_param.adv_param.Advertising_Interval_Max[1] = (48 & 0xff00) >> 8;
	g_pattern_param.adv_param.Advertising_Interval_Min[0] =  48 & 0x00ff;
	g_pattern_param.adv_param.Advertising_Interval_Min[1] = (48 & 0xff00) >> 8;
	verdict = COMM_ADV_Undirected_Advertising(dut2_fd, g_pattern_param);
	VERDICT_RESULT_WITH_LINE();

	read_le_event_enable();
	printf("****timer for 180sec****\n" );
	while(1) {//waiting adv report event , timer or counter  
		if(1 == read_le_event_get()) {
		    // start the scanning time :30 sec
		    event_query_timer_config(180/time_reduce, 0, 0, 0, &timer);
		    event_query_timer_start(timer, read_le_event_disable);
		    while(read_le_event_get()) {
                MSLEEP(10);
			    if(SUCCESS != QUERY_LE_Event(dut1_fd, buf, _BT_HCI_LE_EVENT_SUB_OP_ADVERTISING_REPORT_, HCI_SUBEVENT_ADV_RPT_EVENT_ADV_IND)) {				
				    
				    
				    continue;
			    }
    			else if(EQUAL != hci_le_event_advertising_report_parsing(HCI_SUBEVENT_ADV_RPT_EVENT_ADV_IND, buf,g_pattern_param)) {
    				
    				continue;
    			}
    			else {
    				adv_cnt++; 
                    printf("adv coming, chk %d\n" , adv_cnt);
    			}    					
    		}
            
            // # per 22.5ms * 3 can get 1 adv , run 180s
            if (adv_cnt <= (180000/67.5)*(2)*(11.25/22.5)*0.8) {
                line=__LINE__;
    			goto FUN_FAIL;
            }
            else {

                FUNC_END();
                LOG_INFO("[Pattern][%s]SUCCESS, Counter : %d\n", __FUNCTION__, adv_cnt);
    		    LOG_INFO("[Pattern][%s]Ideal value : %f\n", __FUNCTION__, (180000/67.5)*(2)*(11.25/22.5)*0.8);
    		    LOG_INFO("[Pattern][%s] Exp. value : %d\n", __FUNCTION__, adv_cnt);
            }    		

    		return PASS;
		}
    }	
FUN_FAIL:
    FUNC_END();

	LOG_INFO("[Pattern][%s]:%d FAIL\n" ,__FUNCTION__,line);
    LOG_INFO("[Pattern][%s]Ideal value : %f\n", __FUNCTION__, (180000/67.5)*(2)*(11.25/22.5)*0.8);
    LOG_INFO("[Pattern][%s] Exp. value : %d\n", __FUNCTION__, adv_cnt);
    
    return FAIL;

}

verdict PROF_HID_2(u8 dut1_fd, u8 dut2_fd)
{
	u8 buf[SOCKET_BUF_SIZE];	
	int verdict = FAIL;
	int dut1 = 0;
	u16 line = 0;
	struct itimerval timer;	
	u32 adv_cnt = 0;	  
    u16 time_reduce = 1;
    
    Calculate_Execution_Time_Start();

    //2nd adv int 30ms ; scan int 1.28 s ,win 11.25ms"
    
	COMM_INI_Connection_Setup_White_Listed_Config(dut1, &g_pattern_param);
	memcpy(g_pattern_param.white_list_param.Address, adv_addr, ADDR_LENGTH);
	verdict = COMM_INI_Connection_Setup_White_Listed(dut1_fd, g_pattern_param);
	VERDICT_RESULT_WITH_LINE();

	COMM_SCN_Passive_Scanning_Config(dut1, &g_pattern_param);
	g_pattern_param.scn_param.LE_Scan_Interval[0] =  2048/time_reduce & 0x00ff;
	g_pattern_param.scn_param.LE_Scan_Interval[1] = (2048/time_reduce & 0xff00) >> 8;
	g_pattern_param.scn_param.LE_Scan_Window[0] =	 18/time_reduce & 0x00ff;
	g_pattern_param.scn_param.LE_Scan_Window[1] =   (18/time_reduce & 0xff00) >> 8;

	g_pattern_param.scn_param.Scanning_Filter_Policy[0] = HCI_CMD_PARAM_IGNORE_ADV_PKTS_FROM_DEV_NOT_IN_WHITE_LIST_ONLY;
	verdict = COMM_SCN_Passive_Scanning(dut1_fd, g_pattern_param);
	VERDICT_RESULT_WITH_LINE();

	COMM_ADV_Undirected_Advertising_Config(HCI_CMD_PARAM_ADV_DATA_LEN_MAX, &g_pattern_param);
	g_pattern_param.adv_param.Advertising_Filter_Policy[0] = HCI_CMD_PARAM_ALLOW_SCAN_REQ_FROM_WHITELIST_ONLY_AND_CONN_REQ_FROM_WHITELIST_ONLY;
	g_pattern_param.adv_data_param.Advertising_Data_Length[0] = 0x00;

	g_pattern_param.adv_param.Advertising_Interval_Max[0] =  48 & 0x00ff;
	g_pattern_param.adv_param.Advertising_Interval_Max[1] = (48 & 0xff00) >> 8;
	g_pattern_param.adv_param.Advertising_Interval_Min[0] =  48 & 0x00ff;
	g_pattern_param.adv_param.Advertising_Interval_Min[1] = (48 & 0xff00) >> 8;
	verdict = COMM_ADV_Undirected_Advertising(dut2_fd, g_pattern_param);
	VERDICT_RESULT_WITH_LINE();

	read_le_event_enable();
	printf("****timer for 30sec****\n" );
	while(1) {//waiting adv report event , timer or counter  
		if(1 == read_le_event_get()) {
		    // start the scanning time :30 sec
		    event_query_timer_config(30/time_reduce, 0, 0, 0, &timer);
		    event_query_timer_start(timer, read_le_event_disable);
		    while(read_le_event_get()) {
                MSLEEP(10);
			    if(SUCCESS != QUERY_LE_Event(dut1_fd, buf, _BT_HCI_LE_EVENT_SUB_OP_ADVERTISING_REPORT_, HCI_SUBEVENT_ADV_RPT_EVENT_ADV_IND)) {				
				    
				    
				    continue;
			    }
    			else if(EQUAL != hci_le_event_advertising_report_parsing(HCI_SUBEVENT_ADV_RPT_EVENT_ADV_IND, buf,g_pattern_param)) {
    				
    				continue;
    			}
    			else {
    				adv_cnt++; 
                    printf("adv coming, chk %d\n" , adv_cnt);
    			}    					
    		}

            if (adv_cnt <= 5) {
                line=__LINE__;
    			goto FUN_FAIL;
            }
            else {

                FUNC_END();
                LOG_INFO("[Pattern][%s]SUCCESS, Counter : %d\n", __FUNCTION__, adv_cnt);
    		    LOG_INFO("[Pattern][%s]Ideal value : %d\n", __FUNCTION__, 5);
    		    LOG_INFO("[Pattern][%s] Exp. value : %d\n", __FUNCTION__, adv_cnt);
            }    		

    		return PASS;
		}
    }	
FUN_FAIL:
    FUNC_END();

	LOG_INFO("[Pattern][%s]:%d FAIL\n" ,__FUNCTION__,line);
    LOG_INFO("[Pattern][%s]Ideal value : %d\n", __FUNCTION__, 5);
    LOG_INFO("[Pattern][%s] Exp. value : %d\n", __FUNCTION__, adv_cnt);
    
    return FAIL;

}

verdict PROF_HID_3(u8 dut1_fd, u8 dut2_fd)
{
	u8 buf[SOCKET_BUF_SIZE];	
	int verdict = FAIL;
	int dut1 = 0;
	u16 line = 0;
	struct itimerval timer;	
	u32 adv_cnt = 0;	  
    u16 time_reduce = 1;
    
    Calculate_Execution_Time_Start();

    //3rd adv int 30ms ; scan int 30ms ,win 30mms"
    
	COMM_INI_Connection_Setup_White_Listed_Config(dut1, &g_pattern_param);
	memcpy(g_pattern_param.white_list_param.Address, adv_addr, ADDR_LENGTH);
	verdict = COMM_INI_Connection_Setup_White_Listed(dut1_fd, g_pattern_param);
	VERDICT_RESULT_WITH_LINE();

	COMM_SCN_Passive_Scanning_Config(dut1, &g_pattern_param);
	g_pattern_param.scn_param.LE_Scan_Interval[0] =  48/time_reduce & 0x00ff;
	g_pattern_param.scn_param.LE_Scan_Interval[1] = (48/time_reduce & 0xff00) >> 8;
	g_pattern_param.scn_param.LE_Scan_Window[0] =	 48/time_reduce & 0x00ff;
	g_pattern_param.scn_param.LE_Scan_Window[1] =   (48/time_reduce & 0xff00) >> 8;

	g_pattern_param.scn_param.Scanning_Filter_Policy[0] = HCI_CMD_PARAM_IGNORE_ADV_PKTS_FROM_DEV_NOT_IN_WHITE_LIST_ONLY;
	verdict = COMM_SCN_Passive_Scanning(dut1_fd, g_pattern_param);
	VERDICT_RESULT_WITH_LINE();

	COMM_ADV_Undirected_Advertising_Config(HCI_CMD_PARAM_ADV_DATA_LEN_MAX, &g_pattern_param);
	g_pattern_param.adv_param.Advertising_Filter_Policy[0] = HCI_CMD_PARAM_ALLOW_SCAN_REQ_FROM_WHITELIST_ONLY_AND_CONN_REQ_FROM_WHITELIST_ONLY;
	g_pattern_param.adv_data_param.Advertising_Data_Length[0] = 0x00;

	g_pattern_param.adv_param.Advertising_Interval_Max[0] =  48 & 0x00ff;
	g_pattern_param.adv_param.Advertising_Interval_Max[1] = (48 & 0xff00) >> 8;
	g_pattern_param.adv_param.Advertising_Interval_Min[0] =  48 & 0x00ff;
	g_pattern_param.adv_param.Advertising_Interval_Min[1] = (48 & 0xff00) >> 8;
	verdict = COMM_ADV_Undirected_Advertising(dut2_fd, g_pattern_param);
	VERDICT_RESULT_WITH_LINE();

	read_le_event_enable();
	printf("****timer for 30sec****\n" );
	while(1) {//waiting adv report event , timer or counter  
		if(1 == read_le_event_get()) {
		    // start the scanning time :30 sec
		    event_query_timer_config(30/time_reduce, 0, 0, 0, &timer);
		    event_query_timer_start(timer, read_le_event_disable);
		    while(read_le_event_get()) {
                MSLEEP(10);
			    if(SUCCESS != QUERY_LE_Event(dut1_fd, buf, _BT_HCI_LE_EVENT_SUB_OP_ADVERTISING_REPORT_, HCI_SUBEVENT_ADV_RPT_EVENT_ADV_IND)) {				
				    
				    
				    continue;
			    }
    			else if(EQUAL != hci_le_event_advertising_report_parsing(HCI_SUBEVENT_ADV_RPT_EVENT_ADV_IND, buf,g_pattern_param)) {
    				
    				continue;
    			}
    			else {
    				adv_cnt++; 
                    printf("adv coming, chk %d\n" , adv_cnt);
    			}    					
    		}

            if (adv_cnt <= (30*30)*0.8) {
                line=__LINE__;
    			goto FUN_FAIL;
            }
            else {

                FUNC_END();
                LOG_INFO("[Pattern][%s]SUCCESS, Counter : %d\n", __FUNCTION__, adv_cnt);
    		    LOG_INFO("[Pattern][%s]Ideal value : %f\n", __FUNCTION__, (30*30)*0.8);
    		    LOG_INFO("[Pattern][%s] Exp. value : %d\n", __FUNCTION__, adv_cnt);
            }    		

    		return PASS;
		}
    }	
FUN_FAIL:
    FUNC_END();

	LOG_INFO("[Pattern][%s]:%d FAIL\n" ,__FUNCTION__,line);
    LOG_INFO("[Pattern][%s]Ideal value : %f\n", __FUNCTION__, (30*30)*0.8);
    LOG_INFO("[Pattern][%s] Exp. value : %d\n", __FUNCTION__, adv_cnt);
    
    return FAIL;

}

verdict PROF_HID_4(u8 dut1_fd, u8 dut2_fd)
{
	u8 buf[SOCKET_BUF_SIZE];	
	int verdict = FAIL;
	int dut1 = 0;
	u16 line = 0;
	struct itimerval timer;	
	u32 dir_adv_cnt = 0;
    u32 adv_cnt     = 0;
    u16 time_reduce = 1;
    
    Calculate_Execution_Time_Start();

    //4nd dir-adv+undir-adv int 20ms ; scan int 22.5ms ,win 11.25ms"

	COMM_INI_Connection_Setup_White_Listed_Config(dut1, &g_pattern_param);
	memcpy(g_pattern_param.white_list_param.Address, adv_addr, ADDR_LENGTH);
	verdict = COMM_INI_Connection_Setup_White_Listed(dut1_fd, g_pattern_param);
	VERDICT_RESULT_WITH_LINE();

	COMM_SCN_Passive_Scanning_Config(dut1, &g_pattern_param);
	g_pattern_param.scn_param.LE_Scan_Interval[0] =  36/time_reduce & 0x00ff;
	g_pattern_param.scn_param.LE_Scan_Interval[1] = (36/time_reduce & 0xff00) >> 8;
	g_pattern_param.scn_param.LE_Scan_Window[0] =	 18/time_reduce & 0x00ff;
	g_pattern_param.scn_param.LE_Scan_Window[1] =   (18/time_reduce & 0xff00) >> 8;

	g_pattern_param.scn_param.Scanning_Filter_Policy[0] = HCI_CMD_PARAM_IGNORE_ADV_PKTS_FROM_DEV_NOT_IN_WHITE_LIST_ONLY;
	verdict = COMM_SCN_Passive_Scanning(dut1_fd, g_pattern_param);
	VERDICT_RESULT_WITH_LINE();

    COMM_ADV_Directed_Advertising_Config(HCI_CMD_PARAM_ADV_DATA_LEN_MAX, &g_pattern_param);
    g_pattern_param.adv_param.Advertising_Filter_Policy[0] = HCI_CMD_PARAM_ALLOW_SCAN_REQ_FROM_WHITELIST_ONLY_AND_CONN_REQ_FROM_WHITELIST_ONLY;

    g_pattern_param.adv_param.Advertising_Interval_Max[0] =  6 & 0x00ff;
    g_pattern_param.adv_param.Advertising_Interval_Max[1] = (6 & 0xff00) >> 8;
    g_pattern_param.adv_param.Advertising_Interval_Min[0] =  6 & 0x00ff;
    g_pattern_param.adv_param.Advertising_Interval_Min[1] = (6 & 0xff00) >> 8;
    verdict = COMM_ADV_Directed_Advertising(dut2_fd, g_pattern_param);
    VERDICT_RESULT_WITH_LINE();     

	read_le_event_enable();
	printf("****timer for 1.3sec****\n" );
    
	while(1) {//waiting adv report event , timer or counter  
		if(1 == read_le_event_get()) {
		    // start the scanning time :1.3 sec
		    event_query_timer_config(1, 300000, 0, 0, &timer);
		    event_query_timer_start(timer, read_le_event_disable);

		    while(read_le_event_get()) {
                //usleep(1*1000);
			    if(SUCCESS != QUERY_LE_Event(dut1_fd, buf, _BT_HCI_LE_EVENT_SUB_OP_ADVERTISING_REPORT_, HCI_SUBEVENT_ADV_RPT_EVENT_DIRECT_IND)) {								    
				    continue;
			    }
    			else if(EQUAL != hci_le_event_advertising_report_parsing(HCI_SUBEVENT_ADV_RPT_EVENT_DIRECT_IND, buf,g_pattern_param)) {    				
    				continue;
    			}
    			else {
    				dir_adv_cnt++; 
                    printf("adv coming, chk %d\n" , dir_adv_cnt);
    			}    					
    		}

            // the ideal value :
            // # per 3.75ms get (1*11.25/22.5) adv ,run 1.28s 
            if (dir_adv_cnt <= (11.25/3.75)*(1280/22.5)*0.8) {
                line=__LINE__;
    			goto FUN_FAIL;
            }
            else {

                //FUNC_END();
                LOG_INFO("[Pattern][%s]SUCCESS, Counter : %d\n", __FUNCTION__, dir_adv_cnt);
    		    LOG_INFO("[Pattern][%s]Ideal value : %f\n", __FUNCTION__, (11.25/3.75)*(1280/22.5)*0.8);
    		    LOG_INFO("[Pattern][%s] Exp. value : %d\n", __FUNCTION__, dir_adv_cnt);
            }    		
            break;
    		//return PASS;
		}
    }	


	COMM_ADV_Undirected_Advertising_Config(HCI_CMD_PARAM_ADV_DATA_LEN_MAX, &g_pattern_param);
	g_pattern_param.adv_param.Advertising_Filter_Policy[0] = HCI_CMD_PARAM_ALLOW_SCAN_REQ_FROM_WHITELIST_ONLY_AND_CONN_REQ_FROM_WHITELIST_ONLY;
	g_pattern_param.adv_data_param.Advertising_Data_Length[0] = 0x00;

	g_pattern_param.adv_param.Advertising_Interval_Max[0] =  32& 0x00ff;
	g_pattern_param.adv_param.Advertising_Interval_Max[1] = (32 & 0xff00) >> 8;
	g_pattern_param.adv_param.Advertising_Interval_Min[0] =  32 & 0x00ff;
	g_pattern_param.adv_param.Advertising_Interval_Min[1] = (32 & 0xff00) >> 8;
	verdict = COMM_ADV_Undirected_Advertising(dut2_fd, g_pattern_param);
	VERDICT_RESULT_WITH_LINE();

	read_le_event_enable();
	printf("****timer for 30sec****\n" );
    
	while(1) {//waiting adv report event , timer or counter  
		if(1 == read_le_event_get()) {

		    event_query_timer_config(30, 0, 0, 0, &timer);
		    event_query_timer_start(timer, read_le_event_disable);

		    while(read_le_event_get()) {
                MSLEEP(10);
			    if(SUCCESS != QUERY_LE_Event(dut1_fd, buf, _BT_HCI_LE_EVENT_SUB_OP_ADVERTISING_REPORT_, HCI_SUBEVENT_ADV_RPT_EVENT_ADV_IND)) {								    
				    continue;
			    }
    			else if(EQUAL != hci_le_event_advertising_report_parsing(HCI_SUBEVENT_ADV_RPT_EVENT_ADV_IND, buf,g_pattern_param)) {    				
    				continue;
    			}
    			else {
    				adv_cnt++; 
                    printf("adv coming, chk %d\n" , adv_cnt);
    			}    					
    		}

            // # per 22.5ms can get (1*11.25/22.5) adv , run 30s
            if (adv_cnt <= (30000/22.5)*(11.25/22.5)*0.8) {
                line=__LINE__;
    			goto FUN_FAIL;
            }
            else {

                FUNC_END();
                LOG_INFO("[Pattern][%s]SUCCESS, Counter : %d\n", __FUNCTION__, adv_cnt);
    		    LOG_INFO("[Pattern][%s]Ideal value : %f\n", __FUNCTION__, (30000/22.5)*(11.25/22.5)*0.8);
    		    LOG_INFO("[Pattern][%s] Exp. value : %d\n", __FUNCTION__, adv_cnt);
            }    		

    		return PASS;
		}
    }	



FUN_FAIL:
    FUNC_END();

	LOG_INFO("[Pattern][%s]:%d FAIL\n" ,__FUNCTION__,line);
    LOG_INFO("[Pattern][%s]Ideal value : %f\n", __FUNCTION__, (30000/22.5)*(11.25/22.5)*0.8);
    LOG_INFO("[Pattern][%s] Exp. value : %d %d\n", __FUNCTION__, adv_cnt , dir_adv_cnt);
    
    return FAIL;

}

verdict PROF_HID_5(u8 dut1_fd, u8 dut2_fd)
{
	u8 buf[SOCKET_BUF_SIZE];	
	int verdict = FAIL;
	int dut1 = 0;
	u16 line = 0;
	struct itimerval timer;	
	u32 dir_adv_cnt = 0;
    u32 adv_cnt     = 0;
    u16 time_reduce = 1;
    
    Calculate_Execution_Time_Start();

    //5nd dir-adv+undir-adv int 20ms ; scan int 1.28s ,win 11.25ms"

	COMM_INI_Connection_Setup_White_Listed_Config(dut1, &g_pattern_param);
	memcpy(g_pattern_param.white_list_param.Address, adv_addr, ADDR_LENGTH);
	verdict = COMM_INI_Connection_Setup_White_Listed(dut1_fd, g_pattern_param);
	VERDICT_RESULT_WITH_LINE();

	COMM_SCN_Passive_Scanning_Config(dut1, &g_pattern_param);
	g_pattern_param.scn_param.LE_Scan_Interval[0] =  2048/time_reduce & 0x00ff;
	g_pattern_param.scn_param.LE_Scan_Interval[1] = (2048/time_reduce & 0xff00) >> 8;
	g_pattern_param.scn_param.LE_Scan_Window[0] =	 18/time_reduce & 0x00ff;
	g_pattern_param.scn_param.LE_Scan_Window[1] =   (18/time_reduce & 0xff00) >> 8;

	g_pattern_param.scn_param.Scanning_Filter_Policy[0] = HCI_CMD_PARAM_IGNORE_ADV_PKTS_FROM_DEV_NOT_IN_WHITE_LIST_ONLY;
	verdict = COMM_SCN_Passive_Scanning(dut1_fd, g_pattern_param);
	VERDICT_RESULT_WITH_LINE();

    COMM_ADV_Directed_Advertising_Config(HCI_CMD_PARAM_ADV_DATA_LEN_MAX, &g_pattern_param);
    g_pattern_param.adv_param.Advertising_Filter_Policy[0] = HCI_CMD_PARAM_ALLOW_SCAN_REQ_FROM_WHITELIST_ONLY_AND_CONN_REQ_FROM_WHITELIST_ONLY;

    g_pattern_param.adv_param.Advertising_Interval_Max[0] =  6 & 0x00ff;
    g_pattern_param.adv_param.Advertising_Interval_Max[1] = (6 & 0xff00) >> 8;
    g_pattern_param.adv_param.Advertising_Interval_Min[0] =  6 & 0x00ff;
    g_pattern_param.adv_param.Advertising_Interval_Min[1] = (6 & 0xff00) >> 8;
    verdict = COMM_ADV_Directed_Advertising(dut2_fd, g_pattern_param);
    VERDICT_RESULT_WITH_LINE();     

	read_le_event_enable();
	printf("****timer for 1.3sec****\n" );
    
	while(1) {//waiting adv report event , timer or counter  
		if(1 == read_le_event_get()) {
		    // start the scanning time :1.3 sec
		    event_query_timer_config(1, 300000, 0, 0, &timer);
		    event_query_timer_start(timer, read_le_event_disable);

		    while(read_le_event_get()) {
                //usleep(1*1000);
			    if(SUCCESS != QUERY_LE_Event(dut1_fd, buf, _BT_HCI_LE_EVENT_SUB_OP_ADVERTISING_REPORT_, HCI_SUBEVENT_ADV_RPT_EVENT_DIRECT_IND)) {								    
				    continue;
			    }
    			else if(EQUAL != hci_le_event_advertising_report_parsing(HCI_SUBEVENT_ADV_RPT_EVENT_DIRECT_IND, buf,g_pattern_param)) {    				
    				continue;
    			}
    			else {
    				dir_adv_cnt++; 
                    printf("adv coming, chk %d\n" , dir_adv_cnt);
    			}    					
    		}

            // the ideal value :
            // # only 
            if (dir_adv_cnt <= (11.25/3.75)*0.8) {
                line=__LINE__;
    			goto FUN_FAIL;
            }
            else {

                //FUNC_END();
                LOG_INFO("[Pattern][%s]SUCCESS, Counter : %d\n", __FUNCTION__, dir_adv_cnt);
    		    LOG_INFO("[Pattern][%s]Ideal value : %f\n", __FUNCTION__, (11.25/3.75)*0.8);
    		    LOG_INFO("[Pattern][%s] Exp. value : %d\n", __FUNCTION__, dir_adv_cnt);

            }    		
            break;
    		//return PASS;
		}
    }	


	COMM_ADV_Undirected_Advertising_Config(HCI_CMD_PARAM_ADV_DATA_LEN_MAX, &g_pattern_param);
	g_pattern_param.adv_param.Advertising_Filter_Policy[0] = HCI_CMD_PARAM_ALLOW_SCAN_REQ_FROM_WHITELIST_ONLY_AND_CONN_REQ_FROM_WHITELIST_ONLY;
	g_pattern_param.adv_data_param.Advertising_Data_Length[0] = 0x00;

	g_pattern_param.adv_param.Advertising_Interval_Max[0] =  32& 0x00ff;
	g_pattern_param.adv_param.Advertising_Interval_Max[1] = (32 & 0xff00) >> 8;
	g_pattern_param.adv_param.Advertising_Interval_Min[0] =  32 & 0x00ff;
	g_pattern_param.adv_param.Advertising_Interval_Min[1] = (32 & 0xff00) >> 8;
	verdict = COMM_ADV_Undirected_Advertising(dut2_fd, g_pattern_param);
	VERDICT_RESULT_WITH_LINE();

	read_le_event_enable();
	printf("****timer for 30sec****\n" );
    
	while(1) {//waiting adv report event , timer or counter  
		if(1 == read_le_event_get()) {

		    event_query_timer_config(30, 0, 0, 0, &timer);
		    event_query_timer_start(timer, read_le_event_disable);

		    while(read_le_event_get()) {
                MSLEEP(10);
			    if(SUCCESS != QUERY_LE_Event(dut1_fd, buf, _BT_HCI_LE_EVENT_SUB_OP_ADVERTISING_REPORT_, HCI_SUBEVENT_ADV_RPT_EVENT_ADV_IND)) {								    
				    continue;
			    }
    			else if(EQUAL != hci_le_event_advertising_report_parsing(HCI_SUBEVENT_ADV_RPT_EVENT_ADV_IND, buf,g_pattern_param)) {    				
    				continue;
    			}
    			else {
    				adv_cnt++; 
                    printf("adv coming, chk %d\n" , adv_cnt);
    			}    					
    		}

            // # per 22.5ms can get (1*11.25/22.5) adv , run 30s
            if (adv_cnt <= 7) {
                line=__LINE__;
    			goto FUN_FAIL;
            }
            else {

                FUNC_END();
                LOG_INFO("[Pattern][%s]SUCCESS, Counter : %d\n", __FUNCTION__, adv_cnt);
    		    LOG_INFO("[Pattern][%s]Ideal value : %d\n", __FUNCTION__, 7);
    		    LOG_INFO("[Pattern][%s] Exp. value : %d\n", __FUNCTION__, adv_cnt);
            }    		

    		return PASS;
		}
    }	



FUN_FAIL:
    FUNC_END();

	LOG_INFO("[Pattern][%s]:%d FAIL\n" ,__FUNCTION__,line);
    LOG_INFO("[Pattern][%s]Ideal value : %d\n", __FUNCTION__, 7);
    LOG_INFO("[Pattern][%s] Exp. value : %d %d\n", __FUNCTION__, adv_cnt , dir_adv_cnt);
    
    return FAIL;

}


verdict PROF_HID_6(u8 dut1_fd, u8 dut2_fd)
{
	u8 buf[SOCKET_BUF_SIZE];	
	int verdict = FAIL;
	int dut1 = 0;
	u16 line = 0;
	struct itimerval timer;	
	u32 dir_adv_cnt = 0;
    u32 adv_cnt     = 0;
    u16 time_reduce = 1;
    
    Calculate_Execution_Time_Start();

    //6nd dir-adv+undir-adv int 20ms ; scan int 30ms ,win 30ms"

	COMM_INI_Connection_Setup_White_Listed_Config(dut1, &g_pattern_param);
	memcpy(g_pattern_param.white_list_param.Address, adv_addr, ADDR_LENGTH);
	verdict = COMM_INI_Connection_Setup_White_Listed(dut1_fd, g_pattern_param);
	VERDICT_RESULT_WITH_LINE();

	COMM_SCN_Passive_Scanning_Config(dut1, &g_pattern_param);
	g_pattern_param.scn_param.LE_Scan_Interval[0] =  48/time_reduce & 0x00ff;
	g_pattern_param.scn_param.LE_Scan_Interval[1] = (48/time_reduce & 0xff00) >> 8;
	g_pattern_param.scn_param.LE_Scan_Window[0] =	 48/time_reduce & 0x00ff;
	g_pattern_param.scn_param.LE_Scan_Window[1] =   (48/time_reduce & 0xff00) >> 8;

	g_pattern_param.scn_param.Scanning_Filter_Policy[0] = HCI_CMD_PARAM_IGNORE_ADV_PKTS_FROM_DEV_NOT_IN_WHITE_LIST_ONLY;
	verdict = COMM_SCN_Passive_Scanning(dut1_fd, g_pattern_param);
	VERDICT_RESULT_WITH_LINE();

    COMM_ADV_Directed_Advertising_Config(HCI_CMD_PARAM_ADV_DATA_LEN_MAX, &g_pattern_param);
    g_pattern_param.adv_param.Advertising_Filter_Policy[0] = HCI_CMD_PARAM_ALLOW_SCAN_REQ_FROM_WHITELIST_ONLY_AND_CONN_REQ_FROM_WHITELIST_ONLY;

    g_pattern_param.adv_param.Advertising_Interval_Max[0] =  6 & 0x00ff;
    g_pattern_param.adv_param.Advertising_Interval_Max[1] = (6 & 0xff00) >> 8;
    g_pattern_param.adv_param.Advertising_Interval_Min[0] =  6 & 0x00ff;
    g_pattern_param.adv_param.Advertising_Interval_Min[1] = (6 & 0xff00) >> 8;
    verdict = COMM_ADV_Directed_Advertising(dut2_fd, g_pattern_param);
    VERDICT_RESULT_WITH_LINE();     

	read_le_event_enable();
	printf("****timer for 1.3sec****\n" );
    
	while(1) {//waiting adv report event , timer or counter  
		if(1 == read_le_event_get()) {
		    // start the scanning time :1.3 sec
		    event_query_timer_config(1, 300000, 0, 0, &timer);
		    event_query_timer_start(timer, read_le_event_disable);

		    while(read_le_event_get()) {
                //usleep(1*1000);
			    if(SUCCESS != QUERY_LE_Event(dut1_fd, buf, _BT_HCI_LE_EVENT_SUB_OP_ADVERTISING_REPORT_, HCI_SUBEVENT_ADV_RPT_EVENT_DIRECT_IND)) {								    
				    continue;
			    }
    			else if(EQUAL != hci_le_event_advertising_report_parsing(HCI_SUBEVENT_ADV_RPT_EVENT_DIRECT_IND, buf,g_pattern_param)) {    				
    				continue;
    			}
    			else {
    				dir_adv_cnt++; 
                    printf("adv coming, chk %d\n" , dir_adv_cnt);
    			}    					
    		}
            // # per 30ms get 1 adv ,run 1.28s 

            if (dir_adv_cnt <= (1280/30)*0.8) {
                line=__LINE__;
    			goto FUN_FAIL;
            }
            else {

                //FUNC_END();
                LOG_INFO("[Pattern][%s]SUCCESS, Counter : %d\n", __FUNCTION__, dir_adv_cnt);
    		    LOG_INFO("[Pattern][%s]Ideal value : %f\n", __FUNCTION__, (1280/30)*0.8);
    		    LOG_INFO("[Pattern][%s] Exp. value : %d\n", __FUNCTION__, dir_adv_cnt);
                sleep(1);
            }    		
            break;
    		//return PASS;
		}
    }	


	COMM_ADV_Undirected_Advertising_Config(HCI_CMD_PARAM_ADV_DATA_LEN_MAX, &g_pattern_param);
	g_pattern_param.adv_param.Advertising_Filter_Policy[0] = HCI_CMD_PARAM_ALLOW_SCAN_REQ_FROM_WHITELIST_ONLY_AND_CONN_REQ_FROM_WHITELIST_ONLY;
	g_pattern_param.adv_data_param.Advertising_Data_Length[0] = 0x00;
	g_pattern_param.adv_param.Advertising_Interval_Max[0] =  32& 0x00ff;
	g_pattern_param.adv_param.Advertising_Interval_Max[1] = (32 & 0xff00) >> 8;
	g_pattern_param.adv_param.Advertising_Interval_Min[0] =  32 & 0x00ff;
	g_pattern_param.adv_param.Advertising_Interval_Min[1] = (32 & 0xff00) >> 8;
	verdict = COMM_ADV_Undirected_Advertising(dut2_fd, g_pattern_param);
	VERDICT_RESULT_WITH_LINE();

	read_le_event_enable();
	printf("****timer for 30sec****\n" );
    
	while(1) {//waiting adv report event , timer or counter  
		if(1 == read_le_event_get()) {
		    // start the scanning time :1.3 sec
		    event_query_timer_config(30, 0, 0, 0, &timer);
		    event_query_timer_start(timer, read_le_event_disable);

		    while(read_le_event_get()) {
                MSLEEP(10);
			    if(SUCCESS != QUERY_LE_Event(dut1_fd, buf, _BT_HCI_LE_EVENT_SUB_OP_ADVERTISING_REPORT_, HCI_SUBEVENT_ADV_RPT_EVENT_ADV_IND)) {								    
				    continue;
			    }
    			else if(EQUAL != hci_le_event_advertising_report_parsing(HCI_SUBEVENT_ADV_RPT_EVENT_ADV_IND, buf,g_pattern_param)) {    				
    				continue;
    			}
    			else {
    				adv_cnt++; 
                    printf("adv coming, chk %d\n" , adv_cnt);
    			}    					
    		}

            // the ideal value :
            // # per 30ms get 1 adv
            if (adv_cnt <= (30000/30)*0.8) {
                line=__LINE__;
    			goto FUN_FAIL;
            }
            else {

                FUNC_END();
                LOG_INFO("[Pattern][%s]SUCCESS, Counter : %d\n", __FUNCTION__, adv_cnt);
    		    LOG_INFO("[Pattern][%s]Ideal value : %f\n", __FUNCTION__, (30000/30)*0.8);
    		    LOG_INFO("[Pattern][%s] Exp. value : %d\n", __FUNCTION__, adv_cnt);
            }    		

    		return PASS;
		}
    }	



FUN_FAIL:
    FUNC_END();

	LOG_INFO("[Pattern][%s]:%d FAIL\n" ,__FUNCTION__,line);
    LOG_INFO("[Pattern][%s]Ideal value : %f\n", __FUNCTION__, (30000/30)*0.8);
    LOG_INFO("[Pattern][%s] Exp. value : %d %d\n", __FUNCTION__, adv_cnt , dir_adv_cnt);
    
    return FAIL;

}


verdict PROF_HID_7(u8 dut1_fd, u8 dut2_fd)
{
	u8 buf[SOCKET_BUF_SIZE];	
	int verdict = FAIL;
	int dut1 = 0;
	u16 line = 0;
	struct itimerval timer;	
	u32 adv_cnt = 0;	  
    u16 time_reduce = 1;
    
    Calculate_Execution_Time_Start();

    //7nd adv int 1s ; scan int 22.5ms ,win 11.25ms"
    
	COMM_INI_Connection_Setup_White_Listed_Config(dut1, &g_pattern_param);
	memcpy(g_pattern_param.white_list_param.Address, adv_addr, ADDR_LENGTH);
	verdict = COMM_INI_Connection_Setup_White_Listed(dut1_fd, g_pattern_param);
	VERDICT_RESULT_WITH_LINE();

	COMM_SCN_Passive_Scanning_Config(dut1, &g_pattern_param);
	g_pattern_param.scn_param.LE_Scan_Interval[0] =  36/time_reduce & 0x00ff;
	g_pattern_param.scn_param.LE_Scan_Interval[1] = (36/time_reduce & 0xff00) >> 8;
	g_pattern_param.scn_param.LE_Scan_Window[0] =	 18/time_reduce & 0x00ff;
	g_pattern_param.scn_param.LE_Scan_Window[1] =   (18/time_reduce & 0xff00) >> 8;

	g_pattern_param.scn_param.Scanning_Filter_Policy[0] = HCI_CMD_PARAM_IGNORE_ADV_PKTS_FROM_DEV_NOT_IN_WHITE_LIST_ONLY;
	verdict = COMM_SCN_Passive_Scanning(dut1_fd, g_pattern_param);
	VERDICT_RESULT_WITH_LINE();

	COMM_ADV_Undirected_Advertising_Config(HCI_CMD_PARAM_ADV_DATA_LEN_MAX, &g_pattern_param);
	g_pattern_param.adv_param.Advertising_Filter_Policy[0] = HCI_CMD_PARAM_ALLOW_SCAN_REQ_FROM_WHITELIST_ONLY_AND_CONN_REQ_FROM_WHITELIST_ONLY;
	g_pattern_param.adv_data_param.Advertising_Data_Length[0] = 0x00;

	g_pattern_param.adv_param.Advertising_Interval_Max[0] =  1600 & 0x00ff;
	g_pattern_param.adv_param.Advertising_Interval_Max[1] = (1600 & 0xff00) >> 8;
	g_pattern_param.adv_param.Advertising_Interval_Min[0] =  1600 & 0x00ff;
	g_pattern_param.adv_param.Advertising_Interval_Min[1] = (1600 & 0xff00) >> 8;
	verdict = COMM_ADV_Undirected_Advertising(dut2_fd, g_pattern_param);
	VERDICT_RESULT_WITH_LINE();

	read_le_event_enable();
	printf("****timer for 30sec****\n" );
	while(1) {//waiting adv report event , timer or counter  
		if(1 == read_le_event_get()) {
		    // start the scanning time :30 sec
		    event_query_timer_config(30/time_reduce, 0, 0, 0, &timer);
		    event_query_timer_start(timer, read_le_event_disable);
		    while(read_le_event_get()) {
                MSLEEP(10);
			    if(SUCCESS != QUERY_LE_Event(dut1_fd, buf, _BT_HCI_LE_EVENT_SUB_OP_ADVERTISING_REPORT_, HCI_SUBEVENT_ADV_RPT_EVENT_ADV_IND)) {				
				    
				    
				    continue;
			    }
    			else if(EQUAL != hci_le_event_advertising_report_parsing(HCI_SUBEVENT_ADV_RPT_EVENT_ADV_IND, buf,g_pattern_param)) {
    				
    				continue;
    			}
    			else {
    				adv_cnt++; 
                    printf("adv coming, chk %d\n" , adv_cnt);
    			}    					
    		}

            //# per 1s get 1 adv * 11.25/22.5
            if (adv_cnt <= (30)*(11.25/22.5)*0.8) {
                line=__LINE__;
    			goto FUN_FAIL;
            }
            else {

                FUNC_END();
                LOG_INFO("[Pattern][%s]SUCCESS, Counter : %d\n", __FUNCTION__, adv_cnt);
    		    LOG_INFO("[Pattern][%s]Ideal value : %f\n", __FUNCTION__, (30)*(11.25/22.5)*0.8);
    		    LOG_INFO("[Pattern][%s] Exp. value : %d\n", __FUNCTION__, adv_cnt);
            }    		

    		return PASS;
		}
    }	
FUN_FAIL:
    FUNC_END();

	LOG_INFO("[Pattern][%s]:%d FAIL\n" ,__FUNCTION__,line);
    LOG_INFO("[Pattern][%s]Ideal value : %f\n", __FUNCTION__, (30)*(11.25/22.5)*0.8);
    LOG_INFO("[Pattern][%s] Exp. value : %d\n", __FUNCTION__, adv_cnt);
    
    return FAIL;

}

verdict PROF_HID_8(u8 dut1_fd, u8 dut2_fd)
{
	u8 buf[SOCKET_BUF_SIZE];	
	int verdict = FAIL;
	int dut1 = 0;
	u16 line = 0;
	struct itimerval timer;	
	u32 adv_cnt = 0;	  
    u16 time_reduce = 1;
    
    Calculate_Execution_Time_Start();

    //8nd adv int 1s ; scan int 1.28s ,win 11.25 ms"
    
	COMM_INI_Connection_Setup_White_Listed_Config(dut1, &g_pattern_param);
	memcpy(g_pattern_param.white_list_param.Address, adv_addr, ADDR_LENGTH);
	verdict = COMM_INI_Connection_Setup_White_Listed(dut1_fd, g_pattern_param);
	VERDICT_RESULT_WITH_LINE();

	COMM_SCN_Passive_Scanning_Config(dut1, &g_pattern_param);
	g_pattern_param.scn_param.LE_Scan_Interval[0] =  2048/time_reduce & 0x00ff;
	g_pattern_param.scn_param.LE_Scan_Interval[1] = (2048/time_reduce & 0xff00) >> 8;
	g_pattern_param.scn_param.LE_Scan_Window[0] =	 18/time_reduce & 0x00ff;
	g_pattern_param.scn_param.LE_Scan_Window[1] =   (18/time_reduce & 0xff00) >> 8;

	g_pattern_param.scn_param.Scanning_Filter_Policy[0] = HCI_CMD_PARAM_IGNORE_ADV_PKTS_FROM_DEV_NOT_IN_WHITE_LIST_ONLY;
	verdict = COMM_SCN_Passive_Scanning(dut1_fd, g_pattern_param);
	VERDICT_RESULT_WITH_LINE();

	COMM_ADV_Undirected_Advertising_Config(HCI_CMD_PARAM_ADV_DATA_LEN_MAX, &g_pattern_param);
	g_pattern_param.adv_param.Advertising_Filter_Policy[0] = HCI_CMD_PARAM_ALLOW_SCAN_REQ_FROM_WHITELIST_ONLY_AND_CONN_REQ_FROM_WHITELIST_ONLY;
	g_pattern_param.adv_data_param.Advertising_Data_Length[0] = 0x00;
	g_pattern_param.adv_param.Advertising_Interval_Max[0] =  1600 & 0x00ff;
	g_pattern_param.adv_param.Advertising_Interval_Max[1] = (1600 & 0xff00) >> 8;
	g_pattern_param.adv_param.Advertising_Interval_Min[0] =  1600 & 0x00ff;
	g_pattern_param.adv_param.Advertising_Interval_Min[1] = (1600 & 0xff00) >> 8;
	verdict = COMM_ADV_Undirected_Advertising(dut2_fd, g_pattern_param);
	VERDICT_RESULT_WITH_LINE();

	read_le_event_enable();
	printf("****timer for 300sec****\n" );
	while(1) {//waiting adv report event , timer or counter  
		if(1 == read_le_event_get()) {
		    // start the scanning time :30 sec
		    event_query_timer_config(300/time_reduce, 0, 0, 0, &timer);
		    event_query_timer_start(timer, read_le_event_disable);
		    while(read_le_event_get()) {
                MSLEEP(10);
			    if(SUCCESS != QUERY_LE_Event(dut1_fd, buf, _BT_HCI_LE_EVENT_SUB_OP_ADVERTISING_REPORT_, HCI_SUBEVENT_ADV_RPT_EVENT_ADV_IND)) {				
				    
				    
				    continue;
			    }
    			else if(EQUAL != hci_le_event_advertising_report_parsing(HCI_SUBEVENT_ADV_RPT_EVENT_ADV_IND, buf,g_pattern_param)) {
    				
    				continue;
    			}
    			else {
    				adv_cnt++; 
                    printf("adv coming, chk %d\n" , adv_cnt);
    			}    					
    		}

            if (adv_cnt < 1) {
                line=__LINE__;
    			goto FUN_FAIL;
            }
            else {

                FUNC_END();
                LOG_INFO("[Pattern][%s]SUCCESS, Counter : %d\n", __FUNCTION__, adv_cnt);
    		    LOG_INFO("[Pattern][%s]Ideal value : %d\n", __FUNCTION__, 1);
    		    LOG_INFO("[Pattern][%s] Exp. value : %d\n", __FUNCTION__, adv_cnt);
            }    		

    		return PASS;
		}
    }	
FUN_FAIL:
    FUNC_END();

	LOG_INFO("[Pattern][%s]:%d FAIL\n" ,__FUNCTION__,line);
    LOG_INFO("[Pattern][%s]Ideal value : %d\n", __FUNCTION__, 1);
    LOG_INFO("[Pattern][%s] Exp. value : %d\n", __FUNCTION__, adv_cnt);
    
    return FAIL;

}


verdict PROF_HID_9(u8 dut1_fd, u8 dut2_fd)
{
	u8 buf[SOCKET_BUF_SIZE];	
	int verdict = FAIL;
	int dut1 = 0;
	u16 line = 0;
	struct itimerval timer;	
	u32 adv_cnt = 0;	  
    u16 time_reduce = 1;
    
    Calculate_Execution_Time_Start();

    //9nd adv int 1s ; scan int 30ms ,win 30mms"
    
	COMM_INI_Connection_Setup_White_Listed_Config(dut1, &g_pattern_param);
	memcpy(g_pattern_param.white_list_param.Address, adv_addr, ADDR_LENGTH);
	verdict = COMM_INI_Connection_Setup_White_Listed(dut1_fd, g_pattern_param);
	VERDICT_RESULT_WITH_LINE();

	COMM_SCN_Passive_Scanning_Config(dut1, &g_pattern_param);
	g_pattern_param.scn_param.LE_Scan_Interval[0] =  48/time_reduce & 0x00ff;
	g_pattern_param.scn_param.LE_Scan_Interval[1] = (48/time_reduce & 0xff00) >> 8;
	g_pattern_param.scn_param.LE_Scan_Window[0] =	 48/time_reduce & 0x00ff;
	g_pattern_param.scn_param.LE_Scan_Window[1] =   (48/time_reduce & 0xff00) >> 8;

	g_pattern_param.scn_param.Scanning_Filter_Policy[0] = HCI_CMD_PARAM_IGNORE_ADV_PKTS_FROM_DEV_NOT_IN_WHITE_LIST_ONLY;
	verdict = COMM_SCN_Passive_Scanning(dut1_fd, g_pattern_param);
	VERDICT_RESULT_WITH_LINE();

	COMM_ADV_Undirected_Advertising_Config(HCI_CMD_PARAM_ADV_DATA_LEN_MAX, &g_pattern_param);
	g_pattern_param.adv_param.Advertising_Filter_Policy[0] = HCI_CMD_PARAM_ALLOW_SCAN_REQ_FROM_WHITELIST_ONLY_AND_CONN_REQ_FROM_WHITELIST_ONLY;
	g_pattern_param.adv_data_param.Advertising_Data_Length[0] = 0x00;
	g_pattern_param.adv_param.Advertising_Interval_Max[0] =  1600 & 0x00ff;
	g_pattern_param.adv_param.Advertising_Interval_Max[1] = (1600& 0xff00) >> 8;
	g_pattern_param.adv_param.Advertising_Interval_Min[0] =  1600 & 0x00ff;
	g_pattern_param.adv_param.Advertising_Interval_Min[1] = (1600 & 0xff00) >> 8;
	verdict = COMM_ADV_Undirected_Advertising(dut2_fd, g_pattern_param);
	VERDICT_RESULT_WITH_LINE();

	read_le_event_enable();
	printf("****timer for 30sec****\n" );
	while(1) {//waiting adv report event , timer or counter  
		if(1 == read_le_event_get()) {
		    // start the scanning time :30 sec
		    event_query_timer_config(30/time_reduce, 0, 0, 0, &timer);
		    event_query_timer_start(timer, read_le_event_disable);
		    while(read_le_event_get()) {
                MSLEEP(10);
			    if(SUCCESS != QUERY_LE_Event(dut1_fd, buf, _BT_HCI_LE_EVENT_SUB_OP_ADVERTISING_REPORT_, HCI_SUBEVENT_ADV_RPT_EVENT_ADV_IND)) {				
				    
				    
				    continue;
			    }
    			else if(EQUAL != hci_le_event_advertising_report_parsing(HCI_SUBEVENT_ADV_RPT_EVENT_ADV_IND, buf,g_pattern_param)) {
    				
    				continue;
    			}
    			else {
    				adv_cnt++; 
                    printf("adv coming, chk %d\n" , adv_cnt);
    			}    					
    		}

            if (adv_cnt <= (30)*0.8) {
                line=__LINE__;
    			goto FUN_FAIL;
            }
            else {

                FUNC_END();
                LOG_INFO("[Pattern][%s]SUCCESS, Counter : %d\n", __FUNCTION__, adv_cnt);
    		    LOG_INFO("[Pattern][%s]Ideal value : %f\n", __FUNCTION__, (30)*0.8);
    		    LOG_INFO("[Pattern][%s] Exp. value : %d\n", __FUNCTION__, adv_cnt);
            }    		

    		return PASS;
		}
    }	
FUN_FAIL:
    FUNC_END();

	LOG_INFO("[Pattern][%s]:%d FAIL\n" ,__FUNCTION__,line);
    LOG_INFO("[Pattern][%s]Ideal value : %f\n", __FUNCTION__, (30)*0.8);
    LOG_INFO("[Pattern][%s] Exp. value : %d\n", __FUNCTION__, adv_cnt);
    
    return FAIL;

}

verdict Adv_time_indep_all_param_check_with_adv_ind(u8 dut1_fd ,u8 dut2_fd)
{
    u8 buf[SOCKET_BUF_SIZE];
    int verdict = FAIL;

    u16 line = 0;
    u16 cnt  = 0;

    COMM_Dut_clean_buffer(dut1_fd);
    COMM_Dut_clean_buffer(dut2_fd);

    ADV_TIME_IND_PATTERN_CONFIG_READ();

    struct itimerval timer;

    int adv_intval_cnt    = 0 ;
    int adv_intval_step   = HCI_CMD_PARAM_ADVERTISING_INTERVAL_MAX ; // # 0.625ms

    int adv_type_cnt      = 0 ;
    int adv_type_step     = g_adv_param_adv_type_step;      // #param
    
    int adv_ch_map_cnt    = 0 ;
    int adv_ch_map_step   = ADV_CH_MAP_TBL_ROW ;
    
    int adv_data_len_cnt  = 0 ;
    int adv_data_len_step = g_adv_param_adv_data_len_step ; // # param

    int own_addr_type_cnt = HCI_CMD_PARAM_PUBLIC_DEVICE_ADDRESS ;
    int dir_addr_type_cnt = HCI_CMD_PARAM_PUBLIC_DEVICE_ADDRESS ;

    int addr_filter_policy_cnt  = HCI_CMD_PARAM_ALLOW_SCAN_REQ_AND_CONN_REQ_FROM_ANY;
    int addr_filter_policy_step = HCI_CMD_PARAM_ALLOW_SCAN_REQ_FROM_WHITELIST_ONLY_AND_CONN_REQ_FROM_WHITELIST_ONLY;

    u8 * adv_enable             = g_pattern_param.Advertising_Enable ;
    u8 * scn_enable             = g_pattern_param.Scan_Enable;
    u8 * scan_filter_duplicates = g_pattern_param.Filter_Duplicates;
    
    Adv_param * adv_param_set =     &(g_pattern_param.adv_param);
    Scn_param * scn_param_set =     &(g_pattern_param.scn_param);
    Adv_data_param * adv_data_set = &(g_pattern_param.adv_data_param);
    Scn_rsp_param  * scn_data_set = &(g_pattern_param.scn_rsp_param);

    int adv_collect_cnt = g_adv_param_adv_collect_cnt ;    // #param
    int adv_error_cnt   = 0 ;

    Calculate_Execution_Time_Start();
 
    // # conbine adv params
    for ( adv_type_cnt    = HCI_CMD_PARAM_ADV_IND ; 
          adv_type_cnt < (sizeof(adv_test_params) / sizeof(adv_test_params[0])); 
          adv_type_cnt += adv_type_step){          

    for ( adv_intval_cnt  = adv_test_params[adv_type_cnt].adv_intval_min; 
          adv_intval_cnt  < HCI_CMD_PARAM_ADVERTISING_INTERVAL_MAX;
          adv_intval_cnt += adv_intval_step ){              

    for ( ; adv_ch_map_cnt < ADV_CH_MAP_TBL_ROW
          ; adv_ch_map_cnt += adv_ch_map_step){

    for ( ; adv_data_len_cnt <= HCI_CMD_PARAM_ADV_DATA_LEN_MAX
          ; adv_data_len_cnt += adv_data_len_step){

    for ( ; own_addr_type_cnt <= HCI_CMD_PARAM_RANDOM_DEVICE_ADDRESS
          ; own_addr_type_cnt ++){

    for ( ; addr_filter_policy_cnt < HCI_CMD_PARAM_ALLOW_SCAN_REQ_FROM_WHITELIST_ONLY_AND_CONN_REQ_FROM_WHITELIST_ONLY
          ; addr_filter_policy_cnt += addr_filter_policy_step){
          
        int direct_adv_check = 0 ;

        do{
            // # config whether use random address  
            COMM_Static_Random_Device_Address_Set_Config(scan_random_addr);
            COMM_Device_Address_Set(dut1_fd, g_pattern_param);

            COMM_Static_Random_Device_Address_Set_Config(adv_random_addr);
            COMM_Device_Address_Set(dut2_fd, g_pattern_param);    
            
            direct_adv_check = (adv_test_params[adv_type_cnt].adv_type  ==  HCI_CMD_PARAM_ADV_DIRECT_IND)
                             &&(dir_addr_type_cnt < HCI_CMD_PARAM_RANDOM_DEVICE_ADDRESS) ;

            // # config adv param
            adv_param_set->Advertising_Interval_Min[0] =  adv_intval_cnt & 0x00ff;
            adv_param_set->Advertising_Interval_Min[1] = (adv_intval_cnt & 0xff00) >> 8;
            adv_param_set->Advertising_Interval_Max[0] =  adv_intval_cnt & 0x00ff;
            adv_param_set->Advertising_Interval_Max[1] = (adv_intval_cnt & 0xff00) >> 8;
            adv_param_set->Advertising_Type[0]         =  adv_test_params[adv_type_cnt].adv_type      ;
            adv_param_set->Own_Address_Type[0]         =  own_addr_type_cnt ;
            adv_param_set->Advertising_Channel_Map[0]  =  adv_ch_map_tbl[adv_ch_map_cnt][0]    ;
            adv_param_set->Advertising_Filter_Policy[0] = addr_filter_policy_cnt ;

            LOG_INFO("adv_type_cnt %d \n" , adv_test_params[adv_type_cnt].adv_type);
            LOG_INFO("adv_intval_cnt %d \n", adv_intval_cnt );
            LOG_INFO("adv_ch_map %d |cnt %d \n",adv_ch_map_tbl[adv_ch_map_cnt][0] ,adv_ch_map_tbl[adv_ch_map_cnt][1] );
            LOG_INFO("adv_data_len_cnt %d \n", adv_data_len_cnt );
            LOG_INFO("own_addr_type_cnt %d \n", own_addr_type_cnt );
            LOG_INFO("addr_filter_policy_cnt %d \n", addr_filter_policy_cnt );

            if(adv_test_params[adv_type_cnt].adv_type ==  HCI_CMD_PARAM_ADV_DIRECT_IND){
                LOG_INFO("dir_addr_type_cnt %d \n", dir_addr_type_cnt );
                
                adv_param_set->Direct_Address_Type[0]     =  dir_addr_type_cnt;            

                if (dir_addr_type_cnt == HCI_CMD_PARAM_PUBLIC_DEVICE_ADDRESS){

                    LOG_INFO("dir public addr \n");
                    memcpy (adv_param_set->Direct_Address , scan_addr , ADDR_LENGTH);

                }else{

                    LOG_INFO("dir random type \n");
                    memcpy (adv_param_set->Direct_Address , scan_random_addr , ADDR_LENGTH);

                }
                
                dir_addr_type_cnt ++ ;                        
            }
            else{
                LOG_INFO("config non-dir addr type \n");
                
                if (own_addr_type_cnt == HCI_CMD_PARAM_PUBLIC_DEVICE_ADDRESS){
                    memcpy (adv_param_set->Direct_Address , adv_addr , ADDR_LENGTH);
                }
                else{
                    memcpy (adv_param_set->Direct_Address , adv_random_addr , ADDR_LENGTH);
                }
            }

            // # config adv data
            adv_data_set->Advertising_Data_Length[0]  =  adv_data_len_cnt;

            int data_len_idx = 0;
            
            for ( ; data_len_idx < adv_data_len_cnt  ; data_len_idx ++){
    	        adv_data_set->Advertising_Data [data_len_idx] = data_len_idx ;            
            }

            adv_enable[0] = HCI_CMD_PARAM_ADV_ENABLE;

            // # prepare to send adv param / data 

            bt_hci_cmd_le_set_advertising_parameters.parameter_tbl[0].value = adv_param_set->Advertising_Interval_Min;
            bt_hci_cmd_le_set_advertising_parameters.parameter_tbl[1].value = adv_param_set->Advertising_Interval_Max;
            bt_hci_cmd_le_set_advertising_parameters.parameter_tbl[2].value = adv_param_set->Advertising_Type;
            bt_hci_cmd_le_set_advertising_parameters.parameter_tbl[3].value = adv_param_set->Own_Address_Type;
            bt_hci_cmd_le_set_advertising_parameters.parameter_tbl[4].value = adv_param_set->Direct_Address_Type;
            bt_hci_cmd_le_set_advertising_parameters.parameter_tbl[5].value = adv_param_set->Direct_Address;
            bt_hci_cmd_le_set_advertising_parameters.parameter_tbl[6].value = adv_param_set->Advertising_Channel_Map;
            bt_hci_cmd_le_set_advertising_parameters.parameter_tbl[7].value = adv_param_set->Advertising_Filter_Policy;
            
            bt_hci_cmd_le_set_advertising_data.parameter_tbl[0].value = adv_data_set->Advertising_Data_Length;            
            bt_hci_cmd_le_set_advertising_data.parameter_tbl[1].value = adv_data_set->Advertising_Data;

            bt_hci_cmd_le_set_scan_response_data.parameter_tbl[0].value = scn_data_set->Scan_Response_Data_Length;            
            bt_hci_cmd_le_set_scan_response_data.parameter_tbl[1].value = scn_data_set->Scan_Response_Data;
                        
            bt_hci_cmd_le_set_advertise_enable.parameter_tbl[0].value = adv_enable ;

            verdict=COMM_ADV_Advertising(dut2_fd);
            VERDICT_RESULT_WITH_LINE();

            printf("run\n");

            // # config scan verify param

            COMM_Add_Device_To_White_List_Config(HCI_CMD_PARAM_RANDOM_DEVICE_ADDRESS,adv_random_addr,&g_pattern_param);
            COMM_Add_Device_To_White_List(dut1_fd,g_pattern_param);

            COMM_Add_Device_To_White_List_Config(HCI_CMD_PARAM_PUBLIC_DEVICE_ADDRESS,adv_addr,&g_pattern_param);
            COMM_Add_Device_To_White_List(dut1_fd,g_pattern_param);

            // # scan_intval large than 2 * adv_intval
            u64 scan_intval = 0;
            scan_intval =   ((adv_intval_cnt * 3) >= HCI_CMD_PARAM_SCAN_INT_MAX)
                            ?(HCI_CMD_PARAM_SCAN_INT_MAX)
                            :(adv_intval_cnt * 3);
            scn_param_set->LE_Scan_Type[0]        =   HCI_CMD_PARAM_PASSIVE_SCAN;
            // # if scan_interval = scan_windows , ll should scan continuously P.65
            scn_param_set->LE_Scan_Interval[0]    =   scan_intval & 0x00ff ;
            scn_param_set->LE_Scan_Interval[1]    =  (scan_intval & 0xff00) >> 8;
            scn_param_set->LE_Scan_Window[0]      =   scan_intval & 0x00ff ;
            scn_param_set->LE_Scan_Window[1]      =  (scan_intval & 0xff00) >> 8;

            //# should depend on the direct_ind : initA type
            u8 own_addr_cond = 0;
            own_addr_cond = (adv_param_set->Advertising_Type[0] == HCI_CMD_PARAM_ADV_DIRECT_IND ) &&
                            (adv_param_set->Direct_Address_Type[0] == HCI_CMD_PARAM_RANDOM_DEVICE_ADDRESS);
            
            if (own_addr_cond){
                scn_param_set->Own_Address_Type[0]    =   HCI_CMD_PARAM_RANDOM_DEVICE_ADDRESS;
            }
            else{
                scn_param_set->Own_Address_Type[0]    =   HCI_CMD_PARAM_PUBLIC_DEVICE_ADDRESS;
            }

            LOG_INFO(" scan_own_addr_type %d \n" , scn_param_set->Own_Address_Type[0]);
            scn_param_set->Scanning_Filter_Policy[0] =    HCI_CMD_PARAM_IGNORE_ADV_PKTS_FROM_DEV_NOT_IN_WHITE_LIST_ONLY;

            *scn_enable = HCI_CMD_PARAM_SCAN_ENABLE;
            *scan_filter_duplicates = HCI_CMD_PARAM_FILTER_DUPLICATES_DISABLE;

            
            bt_hci_cmd_le_set_scan_parameters.parameter_tbl[0].value =scn_param_set->LE_Scan_Type;
            bt_hci_cmd_le_set_scan_parameters.parameter_tbl[1].value =scn_param_set->LE_Scan_Interval;
            bt_hci_cmd_le_set_scan_parameters.parameter_tbl[2].value =scn_param_set->LE_Scan_Window;
            bt_hci_cmd_le_set_scan_parameters.parameter_tbl[3].value =scn_param_set->Own_Address_Type;
            bt_hci_cmd_le_set_scan_parameters.parameter_tbl[4].value =scn_param_set->Scanning_Filter_Policy;                        
            bt_hci_cmd_le_set_scan_enable.parameter_tbl[0].value = scn_enable;
            bt_hci_cmd_le_set_scan_enable.parameter_tbl[1].value = scan_filter_duplicates;

            verdict = COMM_SCN_Active_Scanning(dut1_fd, g_pattern_param);
            VERDICT_RESULT_WITH_LINE();

            // # to collect the result
            read_le_event_enable();

            int adv_cnt   = 0 ;

            while(read_le_event_get()) {

                MSLEEP(1);

                if(adv_test_params[adv_type_cnt].adv_type ==  HCI_CMD_PARAM_ADV_DIRECT_IND){
                    // # force continue start direct_ind adv without check return value
                    COMM_ADV_Advertising(dut2_fd);                    
                    MSLEEP(10);
                }

                // # query adv_rp