/*********************************************************************
 Copyright 2014 by  ZTE Corporation.
*
* FileName::    spi_nand.h
* File Mark:
* Description:  
* Others:
* Version:  
* Author:  
* Date:   

* History 1:
*     Date: 2014.1.15
*     Version:
*     Author: zhouqi
*     Modification:
* History 2:
**********************************************************************/

#ifndef __SPI_NAND_H__
#define __SPI_NAND_H__

#include <linux/mtd/nand.h>

/* SPI NAND CMD */
#define CMD_WRITE_ENABLE            0x06
#define CMD_WRITE_DISABLE           0x04
#define CMD_GET_FEATURE		        0x0F
#define CMD_SET_FEATURE		        0x1F

#define CMD_READ_PAGE_TO_CACHE	     0x13
#define CMD_READ_FROM_CACHE          0x03
//#define CMD_READ_FROM_CACHE_X2       0x3B
#define CMD_READ_FROM_CACHE_X4       0x6B
#define CMD_READ_FROM_CACHE_QIO      0xEB

#define CMD_READ_ID		            0x9F
#define ID_ADDR0                     0x00  /*manufacture id address*/
#define ID_ADDR1                     0x01  /*device id address*/

#define CMD_PROGRAM_LOAD		    0x02
#define CMD_PROGRAM_LOAD_X4		    0x32

#define CMD_PROGRAM_EXECUTE		    0x10
//#define CMD_PROGRAM_LOAD_RANDOM      0x84
//#define CMD_PROGRAM_LOAD_RANDOM_X4   0xC4
//#define CMD_PROGRAM_LOAD_RANDOM_QIO  0x72

#define CMD_BLOCK_ERASE             0xD8

#define CMD_RESET                   0xFF

#define CMD_WINBOND_DIE_SWITCH		0xC2

#define SINGLE_MODE 0
//#define DUAL_MODE   1
#define RDX4_MODE    2
#define RDQIO_MODE   3
#define PLX4_MODE    4

/*read and write mode configuration*/
//#define RD_MODE  RDX4_MODE
//#define RD_MODE  RDQIO_MODE
#define RD_MODE  RDQIO_MODE
#define WR_MODE  PLX4_MODE

#define	READ_TRANSFER_MODE		0
#define	WRITE_TRANSFER_MODE		1

#define ADDR_TX_EN      1   /* ַ뷢ʹ */
#define ADDR_TX_DIS     0
#define DATA_TX_EN      1
#define DATA_TX_DIS     0
#define DATA_RX_EN      1
#define DATA_RX_DIS     0
#define DUMY_TX_EN      1
#define DUMY_TX_DIS     0

#define ADDR_WIDTH_8    0
#define ADDR_WIDTH_16   1
#define ADDR_WIDTH_24   2
#define ADDR_WIDTH_32   3

struct spiflash_cmd_t
{
    uint32_t cmd;
    uint32_t addr_tx_en;      /* ַ뷢ʹ */
    uint32_t addr_width;        /* ַ */
    uint32_t data_tx_en;      /* ʹ---д */
    uint32_t data_rx_en;      /* ʹ--- */
    uint32_t dumy_tx_en;      /* еȴʹ */
    uint32_t dumy_bytes;      /* еȴ x8 */
    uint32_t dumy_bits;       /* еȴ x1 */
};


/* SPI NAND REGISTER */
#define REG_PROTECTION              0xA0
#define REG_FEATURE                 0xB0
#define ECC_EN                      (0x1<<4)
#define REG_BUF_WINBOND             (0x1<<3)
#define HSE_EN                      (0x1<<1)
#define QE                          (0x1<<0)
#define REG_STATUS                  0xC0
#define ECC_ERR_BIT                 (0x4)        /* ECC ERR */
#define ECC_ERR_MASK                (0x3<<4)     /* ECC ERR */
#define P_FAIL                      (0x1<<3)     /* program fail*/
#define E_FAIL                      (0x1<<2)     /* erase fail */
#define WEL                         (0x1<<1)     /* Write Enable Latch */
#define OIP                         (0x1<<0)     /* Operation In Progress */

#define WRAP_SIZE_MAIN_OOB         (0x0<<12)      /* 2048 +64 = 2112 */
#define WRAP_SIZE_MAIN             (0x4<<12)      /* 2048 */
#define WRAP_SIZE_OOB			   (0x8<<12)      /* 64 */
#define WRAP_SIZE_MINI			   (0xC<<12)      /* 16 */

#define SPI_NAND_BUF_SIZE		(NAND_MAX_PAGESIZE + NAND_MAX_OOBSIZE)

struct spi_nand_buf {
	uint32_t head;
	uint32_t tail;
	uint8_t *buf;
/*	uint8_t buf[SPI_NAND_BUF_SIZE];*/
	dma_addr_t dma_buf;
};

struct spi_nand_ctrl_info {
	int 	(*reset)(void);
	int 	(*switch_die)(unsigned char die);
	int 	(*read_id)(uint32_t reg_addr, uint8_t *value, uint8_t len);
	int 	(*get_feature)(uint32_t reg_addr, uint8_t *value);
	int 	(*set_feature)(uint32_t reg_addr, uint8_t *value);
	int 	(*read_page_to_cache)(uint32_t page_addr);
	int 	(*read_from_cache)(uint32_t column_addr, uint32_t len, uint8_t *buf);
	int 	(*page_load)(uint32_t column_addr, uint8_t* buf, uint32_t page_len, 
						uint8_t *oob, uint32_t oob_len);
	int 	(*program_exec)(uint32_t page_addr);
	int 	(*write_enable)(void);
	int 	(*write_disable)(void);
	int 	(*erase)(uint32_t page_addr);
};


struct spi_nand_info {
	struct mtd_info *mtd;       
	struct nand_chip *nand;
	struct spi_nand_ctrl_info *ctrl;
	struct nand_flash_device_para *para; 	
    struct spi_nand_buf buf;
	int status;
	uint32_t page;
	uint32_t devnum;	/* represent how many nands connected */
    uint32_t total_used_banks;
    uint32_t pages_per_die;	
	uint32_t totalblks;
	uint32_t blksperchip;
	uint32_t bbtskipbytes;
};

int spi_nand_register(struct spi_nand_info *spi_nand, struct spi_nand_ctrl_info *ctrl);
void spi_nand_special_init(struct spi_nand_info *spi_nand);
void spi_nand_debug_init(void);
int spi_nand_common_init(struct spi_nand_info *spi_nand);
inline unsigned int spi_nand_get_trans_mode(int rw_mode);

#endif	/* __SPI_NAND_H__ */

