/*******************************************************************************
 * Copyright (C) 2009, ZTE Corporation.
 *
 * File Name:    drvs_ramlog.h
 * File Mark:
 * Description:
 * Others:
 * Version:       V1.0
 * Author:        yuxiang
 * Date:          2009-11-06
 * History 1:
 *     Date:
 *     Version:
 *     Author:
 *     Modification:
  ********************************************************************************/
#ifndef DRVS_RAMLOG_H
#define DRVS_RAMLOG_H

#ifdef __cplusplus
   extern "C"
   {
#endif

/****************************************************************************
* 	                        Include files
****************************************************************************/

/****************************************************************************
* 	                         Macros
****************************************************************************/
/*LOGС,ֽΪλ,ģҪӡLOG*/
#define RAMLOG_BUF_SIZE_8K      (8*1024)
#define RAMLOG_BUF_SIZE_16K     (16*1024)
#define RAMLOG_BUF_SIZE_32K     (32*1024)
#define RAMLOG_BUF_SIZE_64K     (64*1024)
#define RAMLOG_BUF_SIZE_128K    (128*1024)
#define RAMLOG_BUF_SIZE_256K    (256*1024)


/*ӡģ*/
#define RAMLOG_MOD_CHIP_BASE    1

#define RAMLOG_MOD_AUDIO        (RAMLOG_MOD_CHIP_BASE + 0)
#define RAMLOG_MOD_BACKLIGHT    (RAMLOG_MOD_CHIP_BASE + 1)
#define RAMLOG_MOD_BSP          (RAMLOG_MOD_CHIP_BASE + 2)
#define RAMLOG_MOD_CAM          (RAMLOG_MOD_CHIP_BASE + 3)
#define RAMLOG_MOD_CIPHER       (RAMLOG_MOD_CHIP_BASE + 4)
#define RAMLOG_MOD_DMA          (RAMLOG_MOD_CHIP_BASE + 5)
#define RAMLOG_MOD_DPRAM        (RAMLOG_MOD_CHIP_BASE + 6)
#define RAMLOG_MOD_DSP          (RAMLOG_MOD_CHIP_BASE + 7)
#define RAMLOG_MOD_EARPIECE     (RAMLOG_MOD_CHIP_BASE + 8)
#define RAMLOG_MOD_GPIO         (RAMLOG_MOD_CHIP_BASE + 9)
#define RAMLOG_MOD_I2C          (RAMLOG_MOD_CHIP_BASE + 10)
#define RAMLOG_MOD_I2S          (RAMLOG_MOD_CHIP_BASE + 11)
#define RAMLOG_MOD_INT          (RAMLOG_MOD_CHIP_BASE + 12)
#define RAMLOG_MOD_ICP          (RAMLOG_MOD_CHIP_BASE + 13)
#define RAMLOG_MOD_KPDBL        (RAMLOG_MOD_CHIP_BASE + 14)
#define RAMLOG_MOD_MIDI         (RAMLOG_MOD_CHIP_BASE + 15)
#define RAMLOG_MOD_POW          (RAMLOG_MOD_CHIP_BASE + 16)
#define RAMLOG_MOD_RF           (RAMLOG_MOD_CHIP_BASE + 17)
#define RAMLOG_MOD_RTC          (RAMLOG_MOD_CHIP_BASE + 18)
#define RAMLOG_MOD_RTT          (RAMLOG_MOD_CHIP_BASE + 19)
#define RAMLOG_MOD_SD           (RAMLOG_MOD_CHIP_BASE + 20)
#define RAMLOG_MOD_SPI          (RAMLOG_MOD_CHIP_BASE + 21)
#define RAMLOG_MOD_TIMER        (RAMLOG_MOD_CHIP_BASE + 22)
#define RAMLOG_MOD_TONE         (RAMLOG_MOD_CHIP_BASE + 23)
#define RAMLOG_MOD_UART         (RAMLOG_MOD_CHIP_BASE + 24)
#define RAMLOG_MOD_UICC         (RAMLOG_MOD_CHIP_BASE + 25)
#define RAMLOG_MOD_USB          (RAMLOG_MOD_CHIP_BASE + 26)
#define RAMLOG_MOD_VIDEO        (RAMLOG_MOD_CHIP_BASE + 27)
#define RAMLOG_MOD_VOICE        (RAMLOG_MOD_CHIP_BASE + 28)
#define RAMLOG_MOD_VOU          (RAMLOG_MOD_CHIP_BASE + 29)
#define RAMLOG_MOD_SPIFC        (RAMLOG_MOD_CHIP_BASE + 30)

#define RAMLOG_MOD_ASSERT       (RAMLOG_MOD_CHIP_BASE + 126)

#define RAMLOG_MOD_PERI_BASE    128

#define RAMLOG_MOD_BATTERY      (RAMLOG_MOD_PERI_BASE + 0)
#define RAMLOG_MOD_CHARGER      (RAMLOG_MOD_PERI_BASE + 1)
#define RAMLOG_MOD_FLASH        (RAMLOG_MOD_PERI_BASE + 2)
#define RAMLOG_MOD_FM           (RAMLOG_MOD_PERI_BASE + 3)
#define RAMLOG_MOD_LCD          (RAMLOG_MOD_PERI_BASE + 4)
#define RAMLOG_MOD_NAND         (RAMLOG_MOD_PERI_BASE + 5)
#define RAMLOG_MOD_PMIC         (RAMLOG_MOD_PERI_BASE + 6)
#define RAMLOG_MOD_PMMANAGER    (RAMLOG_MOD_PERI_BASE + 7)
#define RAMLOG_MOD_RTCPERI      (RAMLOG_MOD_PERI_BASE + 8)
#define RAMLOG_MOD_SENSOR       (RAMLOG_MOD_PERI_BASE + 9)
#define RAMLOG_MOD_TOUCH        (RAMLOG_MOD_PERI_BASE + 10)
#define RAMLOG_MOD_VIBRATOR     (RAMLOG_MOD_PERI_BASE + 11)
#define RAMLOG_MOD_LED          (RAMLOG_MOD_PERI_BASE + 12)

#define RAMLOG_MOD_MAX          255


#define RAMLOG_MOD_NO1          RAMLOG_MOD_AUDIO        /*ģ*/
#define RAMLOG_MOD_NO1_SHELL    "audio"                 /*shell,޿ո,32Byte*/
#define RAMLOG_MOD_NO1_BUF_SIZE RAMLOG_BUF_SIZE_32K     /*LOGС*/
#define RAMLOG_MOD_NO1_LOOP_ON  TRUE                    /*Ƿѭӡ*/
#define RAMLOG_MOD_NO1_REG      TRUE                   /*Ƿע,FALSEʱģ鲻ᱻע*/

#define RAMLOG_MOD_NO2          RAMLOG_MOD_KPDBL
#define RAMLOG_MOD_NO2_SHELL    "kpd"
#define RAMLOG_MOD_NO2_BUF_SIZE RAMLOG_BUF_SIZE_32K
#define RAMLOG_MOD_NO2_LOOP_ON  TRUE
#define RAMLOG_MOD_NO2_REG      FALSE

#define RAMLOG_MOD_NO3          RAMLOG_MOD_LCD /* YinWenguan 2015-2-4 */
#define RAMLOG_MOD_NO3_SHELL    "lcd"
#define RAMLOG_MOD_NO3_BUF_SIZE RAMLOG_BUF_SIZE_32K
#define RAMLOG_MOD_NO3_LOOP_ON  TRUE
#define RAMLOG_MOD_NO3_REG      FALSE

#define RAMLOG_MOD_NO4          RAMLOG_MOD_POW//RAMLOG_MOD_TOUCH
#define RAMLOG_MOD_NO4_SHELL    "pow"//"touch"
#define RAMLOG_MOD_NO4_BUF_SIZE RAMLOG_BUF_SIZE_32K
#define RAMLOG_MOD_NO4_LOOP_ON  TRUE
#define RAMLOG_MOD_NO4_REG      FALSE

#define RAMLOG_MOD_NO5          RAMLOG_MOD_CHARGER
#define RAMLOG_MOD_NO5_SHELL    "charger"
#define RAMLOG_MOD_NO5_BUF_SIZE RAMLOG_BUF_SIZE_32K
#define RAMLOG_MOD_NO5_LOOP_ON  TRUE
#define RAMLOG_MOD_NO5_REG      FALSE

#define RAMLOG_MOD_NO6          RAMLOG_MOD_DMA
#define RAMLOG_MOD_NO6_SHELL    "dma"
#define RAMLOG_MOD_NO6_BUF_SIZE RAMLOG_BUF_SIZE_32K
#define RAMLOG_MOD_NO6_LOOP_ON  TRUE
#define RAMLOG_MOD_NO6_REG      FALSE

#define RAMLOG_MOD_NO7          RAMLOG_MOD_ICP
#define RAMLOG_MOD_NO7_SHELL    "icp"
#define RAMLOG_MOD_NO7_BUF_SIZE RAMLOG_BUF_SIZE_8K
#define RAMLOG_MOD_NO7_LOOP_ON  TRUE
#define RAMLOG_MOD_NO7_REG      TRUE

#define RAMLOG_MOD_NO8 			RAMLOG_MOD_UICC
#define RAMLOG_MOD_NO8_SHELL    "UICC"
#define RAMLOG_MOD_NO8_BUF_SIZE RAMLOG_BUF_SIZE_8K
#define RAMLOG_MOD_NO8_LOOP_ON  TRUE
#define RAMLOG_MOD_NO8_REG      TRUE

#define RAMLOG_MOD_NO9          RAMLOG_MOD_LED
#define RAMLOG_MOD_NO9_SHELL    "led"
#define RAMLOG_MOD_NO9_BUF_SIZE RAMLOG_BUF_SIZE_32K
#define RAMLOG_MOD_NO9_LOOP_ON  TRUE
#define RAMLOG_MOD_NO9_REG      FALSE

#define RAMLOG_MOD_NO10          RAMLOG_MOD_ASSERT
#define RAMLOG_MOD_NO10_SHELL    "assert"
#define RAMLOG_MOD_NO10_BUF_SIZE RAMLOG_BUF_SIZE_32K
#define RAMLOG_MOD_NO10_LOOP_ON  TRUE
#define RAMLOG_MOD_NO10_REG      FALSE

#define RAMLOG_MOD_NO11          RAMLOG_MOD_SD
#define RAMLOG_MOD_NO11_SHELL    "sd"
#define RAMLOG_MOD_NO11_BUF_SIZE RAMLOG_BUF_SIZE_256K
#define RAMLOG_MOD_NO11_LOOP_ON  TRUE
#define RAMLOG_MOD_NO11_REG      FALSE

#define RAMLOG_MOD_NO12          RAMLOG_MOD_CAM
#define RAMLOG_MOD_NO12_SHELL    "camera"
#define RAMLOG_MOD_NO12_BUF_SIZE RAMLOG_BUF_SIZE_32K
#define RAMLOG_MOD_NO12_LOOP_ON  TRUE
#define RAMLOG_MOD_NO12_REG      FALSE

#define RAMLOG_MOD_NO13          RAMLOG_MOD_VOU
#define RAMLOG_MOD_NO13_SHELL    "vou"
#define RAMLOG_MOD_NO13_BUF_SIZE RAMLOG_BUF_SIZE_32K
#define RAMLOG_MOD_NO13_LOOP_ON  TRUE
#define RAMLOG_MOD_NO13_REG      FALSE

#define RAMLOG_MOD_NO14          RAMLOG_MOD_PMIC
#define RAMLOG_MOD_NO14_SHELL    "pmic"
#define RAMLOG_MOD_NO14_BUF_SIZE RAMLOG_BUF_SIZE_32K
#define RAMLOG_MOD_NO14_LOOP_ON  TRUE
#define RAMLOG_MOD_NO14_REG      FALSE


#define RAMLOG_MOD_NO15          RAMLOG_MOD_I2C
#define RAMLOG_MOD_NO15_SHELL    "i2c"
#define RAMLOG_MOD_NO15_BUF_SIZE RAMLOG_BUF_SIZE_32K
#define RAMLOG_MOD_NO15_LOOP_ON  TRUE
#define RAMLOG_MOD_NO15_REG      FALSE

#define RAMLOG_MOD_NO16          RAMLOG_MOD_SPI
#define RAMLOG_MOD_NO16_SHELL    "spi"
#define RAMLOG_MOD_NO16_BUF_SIZE RAMLOG_BUF_SIZE_32K
#define RAMLOG_MOD_NO16_LOOP_ON  TRUE
#define RAMLOG_MOD_NO16_REG      FALSE

#define RAMLOG_MOD_NO17          RAMLOG_MOD_SPIFC
#define RAMLOG_MOD_NO17_SHELL    "spifc"
#define RAMLOG_MOD_NO17_BUF_SIZE RAMLOG_BUF_SIZE_32K
#define RAMLOG_MOD_NO17_LOOP_ON  TRUE
#define RAMLOG_MOD_NO17_REG      FALSE
/****************************************************************************
* 	                         Types
****************************************************************************/


/****************************************************************************
* 	                         Constants
****************************************************************************/

/****************************************************************************
* 	                         Global  Variables
****************************************************************************/

/****************************************************************************
* 	                         Function Prototypes
****************************************************************************/

SINT32 zDrvRamLog_Initiate(VOID);
SINT32 ramlog_Printf(UINT16 nModNo, const VOID *pFormat, ...);

#ifdef _OS_WIN
#define zDrvRamlog_PRINTF(nModNo, s)
#else

#ifdef _USE_RAMLOG
#define zDrvRamlog_PRINTF(nModNo, s...) ramlog_Printf(nModNo, s)
#else
#define zDrvRamlog_PRINTF(nModNo, s...)
#endif

#endif

#ifdef __cplusplus
}
#endif

#endif

