/*******************************************************************************
* Ȩ (C)2016, ͨѶɷ޹˾
* 
* ļ:     usb_dev.c
* ļʶ:     usb_dev.c
* ժҪ:     usb豸ʹ
* 
* ޸        汾      ޸ı        ޸          ޸
* ------------------------------------------------------------------------------
* 2016/3/10      V1.0        Create                             
* 
*******************************************************************************/

/*******************************************************************************
*                                   ͷļ                                     *
*******************************************************************************/
#include<stdlib.h>
#include<stdio.h>
#include<string.h>
#include<sys/types.h>
#include<sys/stat.h>
#include<fcntl.h>
#include<errno.h>
#include<getopt.h>
#include<stdarg.h>
#include<termios.h>
#include<stddef.h>
#include<dirent.h>
#include <unistd.h>

/*******************************************************************************
*                                   궨                                     *
*******************************************************************************/
#define USB_DIR_FILE_NAME_SIZE 1024
#define USB_DIR_BASE "/sys/bus/usb/devices"
#define USB_PID 0x0197
#define SUCCESS 0
#define FAIL    -1

/*******************************************************************************
*                                                                      *
*******************************************************************************/
char sys_filename[USB_DIR_FILE_NAME_SIZE] = {0};
int g_usb_dev = -1;

/*******************************************************************************
*                                Ͷ                                  *
*******************************************************************************/

/*******************************************************************************
*                                                                  *
*******************************************************************************/

/*******************************************************************************
*                              ֲ̬                                *
*******************************************************************************/

/*******************************************************************************
*                                ȫֱ                                  *
*******************************************************************************/

/*******************************************************************************
*                                ֲʵ                                  *
*******************************************************************************/
int dev_get_usbsys_val(const char *sys_filename, int base)
{
	char buff[64] = {0};
	int ret_val = -1;
	int fd = -1;

	fd = open(sys_filename, O_RDONLY);
	if (fd < 0) {
		printf("failed to open usbsys, error is %s\n", strerror(errno));
		return FAIL;
	}

	if (read(fd, buff, sizeof(buff)) <= 0) {
		printf("[%s] read:%s failed\n", __func__, sys_filename);
	}
	else {
		ret_val = strtoul(buff, NULL, base);
	}
	close(fd);

	return ret_val;
}

int dev_strStartsWith(const char *line, const char *src)
{
	int ret = -1;

	for ( ; *line != '\0' && *src != '\0'; line++, src++) {
		if (*line != *src) {
			return FAIL;
		}
	}
	ret = atoi(line);
	return ret;
}

int dev_get_ttyport_by_syspath(char *syspath)
{
	DIR *usbdir = NULL;
	struct dirent *dent = NULL;
	int usb_port = -1;

	usbdir = opendir(syspath);
	if (usbdir == NULL) {
		printf("%s: open [%s] busdir failed\n", __func__, syspath);
		return -1;
	}

	while ((dent = readdir(usbdir)) != NULL)
	{
		usb_port = dev_strStartsWith(dent->d_name, "ttyUSB");
		if ( usb_port >= 0) {
			closedir(usbdir);
			usbdir = NULL;
			return usb_port;
		}
	}

	if (usbdir) {
		closedir(usbdir);
		usbdir = NULL;
	}
	return FAIL;
}

int dev_get_device(void)
{
	DIR *usbdir = NULL;
	struct dirent *dent = NULL;
	int idProduct = 0;
	int bConfigurationValue = 0;
	int num = 0;
	usbdir = opendir(USB_DIR_BASE);
	if (usbdir == NULL)
		return FAIL;

	while ((dent = readdir(usbdir)) != NULL){
		if (strcmp(dent->d_name, ".") == 0 || strcmp(dent->d_name, "..") == 0) {
			continue;
		}

		snprintf(sys_filename, sizeof(sys_filename), "%s/%s/idProduct", USB_DIR_BASE, dent->d_name);
		if ((idProduct = dev_get_usbsys_val(sys_filename, 16)) <= 0) {
			continue;
		}

		snprintf(sys_filename, sizeof(sys_filename), "%s/%s/bConfigurationValue", USB_DIR_BASE, dent->d_name);
		if ((bConfigurationValue = dev_get_usbsys_val(sys_filename, 10)) <= 0) {
			continue;
		}

		if (idProduct == USB_PID){
			snprintf(sys_filename, sizeof(sys_filename), "%s/%s/%s:%d.%d", USB_DIR_BASE, dent->d_name, dent->d_name, bConfigurationValue, 0);
			g_usb_dev = dev_get_ttyport_by_syspath(sys_filename);
			closedir(usbdir);
			usbdir = NULL;
			return SUCCESS;
		}
	}
	if (usbdir) {
		closedir(usbdir);
		usbdir = NULL;
	}
	return FAIL;
}

