#ifndef OS_THREAD_H
#define OS_THREAD_H

/**************************************************************************
 *                        ͷļ                                      *
 **************************************************************************/


/**************************************************************************
 *                                                             *
 **************************************************************************/

#define OS_THREAD_INVALID_ID    0xFFFFFFFF
//add by chenxin
#ifndef OS_MAX_NAME_LEN
#define OS_MAX_NAME_LEN 32
#endif
/**************************************************************************
 *                                                             *
 **************************************************************************/

typedef struct _OS_THREAD_INFO_ 
{ 
    OS_THREAD_ID    id; 
    char            name[OS_MAX_NAME_LEN];
    UINT32          stack_size;
    UINT32          priority;
} OS_THREAD_INFO;

#ifndef _TYPE_OS_TIMER_ID
#define _TYPE_OS_TIMER_ID
typedef UINT32 OS_TIMER_ID;
#endif

#ifndef TYPE_OS_THREAD_ENTRY
#define TYPE_OS_THREAD_ENTRY
typedef ZVOID (*OS_THREAD_ENTRY)(ZVOID* param);
#endif
/**************************************************************************
 *                        ԭ                                    *
 **************************************************************************/
OS_THREAD_ID tp_os_thread_create(char *name, OS_THREAD_ENTRY entry, UINT8 pri, UINT32 size, VOID* param);

OS_STATUS       tp_os_thread_delete( OS_THREAD_ID tid );

OS_STATUS       tp_os_thread_suspend( OS_THREAD_ID tid );

OS_STATUS       tp_os_thread_resume( OS_THREAD_ID tid );

OS_THREAD_ID    tp_os_thread_self( VOID );

OS_STATUS       tp_os_thread_sleep( UINT32 timeout );

BOOL            tp_os_thread_is_created( OS_THREAD_ID tid );

OS_STATUS       tp_os_thread_info_get( OS_THREAD_ID tid, OS_THREAD_INFO *info_ptr );

OS_STATUS       tp_os_thread_pri_set( OS_THREAD_ID tid, UINT8 pri );

OS_STATUS       tp_os_thread_pri_get( OS_THREAD_ID tid, UINT8 *pri_ptr );

#endif
