#ifndef _ZCORE_GUI_TOOL__MEM_H_
#define _ZCORE_GUI_TOOL__MEM_H_

#include "zcore_type.h"
ZSINT32 guiTool_mem_init();


#define __FUNCTION__ "__FILE__ # __LINE__"

ZVOID  guiTool_free( const ZCHAR *file, ZSINT32 line,const ZCHAR *func,
	                   ZVOID *mem );
ZVOID *guiTool_malloc ( const ZCHAR *file, ZSINT32 line,const ZCHAR *func, ZUINT32 bytes);

ZVOID *guiTool_calloc(const ZCHAR* file, ZSINT32 line, const ZCHAR *func, 
	                 ZUINT32 count, ZUINT32 bytes);
ZVOID *guiTool_realloc(const ZCHAR *file, ZSINT32 line, const ZCHAR *func, 
	                  const ZCHAR *what, ZVOID *mem, ZUINT32 bytes);

ZVOID *guiTool_calloc ( const ZCHAR *file, ZSINT32 line,
                      const ZCHAR *func, ZUINT32 count, ZUINT32 bytes);

ZVOID *guiTool_realloc( const ZCHAR *file, ZSINT32 line,
                      const ZCHAR *func, const ZCHAR *what, ZVOID *mem,
                      ZUINT32 bytes );

ZCHAR *guiTool_strdup ( const ZCHAR *file, ZSINT32 line,
                      const ZCHAR *func, const ZCHAR *string );


#define __GUI_DEBUG__  0

#if __GUI_DEBUG__
#define GUI_FREE(mem)           guiTool_free((__FILE__), (__LINE__), (__FUNCTION__),mem )
#define GUI_MALLOC(bytes)       guiTool_malloc((__FILE__),(__LINE__),(__FUNCTION__), bytes )
#define GUI_CALLOC(count,bytes) guiTool_calloc((__FILE__),(__LINE__),(__FUNCTION__), count, bytes )
#define GUI_REALLOC(mem,bytes)  guiTool_realloc((__FILE__),(__LINE__),(__FUNCTION__), mem, bytes )
#define GUI_STRDUP(string)      guiTool_strdup((__FILE__),(__LINE__),(__FUNCTION__), string )
#define GUI_START_OVERSEE()     guiTool_mem_StartOversee()
#define GUI_END_OVERSEE()       guiTool_mem_TerminOversee()
#define GUI_PRINT()             guiTool_print_memleaks()
#define GUI_GETCOUNT()          guiTool_mem_check()
#define GUI_RETURN()            guiTool_mem_return()
#define GUI_MEM_CPY(dest_ptr,src_ptr,copy_len)  tp_os_mem_cpy(dest_ptr,src_ptr,copy_len)
#define GUI_MEM_SET(dest_ptr,value,len)         tp_os_mem_set(dest_ptr,value,len)
#endif


#endif
