#ifndef _ZCORE_CTRL_TOUCHICON_H_
#define _ZCORE_CTRL_TOUCHICON_H_
 #include "zcore_type.h"
#include "list.h"
#ifdef __cplusplus
extern "C" {
#endif  /* __cplusplus */

/***************************************************************************
* Macros                           궨

***************************************************************************/

#define CTRL_TOUCHICON           ("touchicon")

/* ͼͼ*/
typedef GHANDLE HTIITEMDATA;

/* ͼ*/
#define HIM_ADDITEM             0xF300

/* ɾͼ*/
#define HIM_DELITEM             0xF301

/* ͼƲ*/
#define HIM_SETITEMDRAW         0xF302

/* ȡǰ۽ͼϢ*/
#define HIM_GETITEMHILIGHT      0xF303

/* ϶ͼͼĻ*/
#define HIM_ITEMPAINTX          0xF304

/* ıб*/
#define HIM_NOTIFY_CHANGEITEMINDEX     0xF305

/* ʹͼ*/
#define HIM_NOTIFY_DISABLEITEM         0xF306

/* ʹͼʹ*/
#define HIM_NOTIFY_ENABLEITEM          0xF307

/* ͼƳؼ*/
#define HIM_NOTIFY_STARTAPPWND         0xF308

/* ȡͼ*/
#define HIM_GETITEMIDBYCOOR     0xF309

/* ϽͼǴڲϳȥûͷţֱ˽ʼͼ*/
#define HIM_MOVEINITEMBLIGHTED  0xF30A

/* ϽͼǴⲿϽģʼӦ*/
#define HIM_MOVEINITEMNEW       0xF30B

/* ϳͼ*/
#define HIM_MOVEOUTITEMBLIGHTED  0xF30C

/* Ƴؼ*/
#define HIM_MOVEOUT             0xF30D

/* ֹͣ*/
#define HIM_STOPMOVEIMMEDIATELY 0xF30E

/* ʼͼ*/
#define HIM_SETITEMDATA         0xF30F

/* ͼ϶Ϊͼܹϳؼ*/
#define HIM_MOUSEMOVE			0xF310

/* ӦôԶջ*/
#define HIM_NOTIFY_APPWINBACK			0xF311

/**/
#define HIM_NOTIFY_SETCAPTURE			0xF312

#define HIM_SETCAPTUREAGAIN			0xF313

#define HIM_NOTIFY_STARTITEMWND			0xF314

#define HIM_NOTIFY_APPHIDE			0xF315

#define HIM_NOTIFY_HIDEITEMWND			0xF316

/* ֪ͨͼ궯ƽ*/
#define HIM_NOTIFY_ENDITEMDRAW      0xF317

/* ͼ־*/
/*ͼʾбʾ*/
#define ITEM_SHOW_BYSTEP        0x0001

/* ͼϳؼԵķλ־*/
#define 	TI_NONE    0x00000000L
#define 	TI_LEFT    0x00000001L
#define 	TI_TOP     0x00000002L
#define 	TI_RIGHT   0x00000004L
#define 	TI_BOTTOM  0x00000008L

/***************************************************************************
* struct                           ݽṹ

***************************************************************************/
typedef ZSINT32 (*TIITEM_DRAWFUNC) (HWND hwnd,HTIITEMDATA htiitemdata,HDC hdc,RECT *rcDraw);

/** ͼϢ */
typedef struct
{
    ZSINT32        nItem;           /** ͼµ */
	ZSINT32        nOldItem;        /** ͼɵ */		
	POINT      pos;             /** ͼʼλ */	
	POINT      mousepos;        /** 2009/07/17*/
    ZDWORD      addData;         /**  */
} TIItemInfo;

typedef struct
{	
	ZSINT32 nLineCount;      /* */
	ZSINT32 nRowCount;       /* */
	ZSINT32 nItemWidth;     /* ÿͼĿ*/
	ZSINT32 nItemHeight;    /* ÿͼĸ߶*/
	ZSINT32 nMargin;        /* ÿͼͼı߿ľ*/
	/* ͼͼұ߿ľ*/
	ZUINT8				 nMarginW;
	/* ͼͼ±߿ľ*/
	ZUINT8				 nMarginH;
	
	/* ΪߵTouchWiz*/
	/* ͼϿհ*/
	RECT                 toprect;
	/* ͼ¿հ*/
	RECT				 bottomrect;
	
	ZDWORD fDirectionExpected; /* ͼϳؼķ־*/
	ZDWORD      addData;         /**  */
}TIItemData;

/* ݽṹ*/
typedef struct
{
	TIITEM_DRAWFUNC        drawItem;     /* ͼ*/ 
} TIItemOps;

/* ͼ*/
typedef struct
{
    ZSINT32       nItem;        /* */
    RECT       rect;       /* бռľ*/
    RECT      oldrect;      /* бռľɵľ*/
    list_t    list;         /* ָ*/
    ZBOOL      flags;        /* ͼ־*/
    BITMAP    bgbmpbuffer;  /* ͼͼƬ*/
    ZDWORD     addData;      /* */
}TIMyItem;

/* ͼݽṹ */
typedef struct
{
    TIMyItem myitem;
} TIItem;

/* ͼ*/
typedef struct
{
	/* ǰͼ*/
    ZSINT32 nItemNr;

	/* ָ򼤻ͼ*/
    TIMyItem* pItemHilighted;

	/* ͼԽ־*/
	ZBOOL     deyondrangeflag; 

	/* ͼ*/
    list_t queue;

	/* ˢ±־*/
	ZSINT32  flag;  

	/* ǰˢ֡*/
	ZUINT8 framecount; 

	/* Ҫˢµʼͼ*/
	ZSINT32 nfrom;  

	/* Ҫˢµյͼ*/
	ZSINT32 nto;    

	/* ͼ*/
	TIItemOps iop;

	/* 浱ǰλ*/
	ZSINT32      dMouseXSaved;
	ZSINT32      dMouseYSaved;
}TIMyList;

/* ڲݽṹ*/
typedef struct
{
	ZDWORD fDirectionExpected; /* ͼϳؼķ־*/
	ZSINT32 nTotal;         /* ͼ*/
	ZSINT32 nItemWidth;     /* ÿͼĿ*/
	ZSINT32 nItemHeight;    /* ÿͼĸ߶*/
	ZSINT32 nMargin;        /* ÿͼͼı߿ľ*/
	/* ͼͼұ߿ľ*/
	ZUINT8				 nMarginW;
	/* ͼͼ±߿ľ*/
	ZUINT8				 nMarginH;
	ZSINT32 nTiconWidth;    /* ÿͼ*/
	ZSINT32 nTiconHeight;   /* ÿͼ߶*/
	
	/* ΪߵTouchWiz*/
	/* ͼϿհ*/
	RECT                 toprect;
	/* ͼ¿հ*/
	RECT				 bottomrect;
	
	RECT     *nItemRectTable;     /* ͼ*/	
	
}TIData;

/* ͼϢ*/
typedef struct
{
    TIMyList mylist;
} TIList;

/* ͼڲ*/
typedef struct
{
	TIData tidata;
    TIList tilist;
} pTouchIconData;

/***************************************************************************
* Local Functions                    غ
***************************************************************************/

/***************************************************************************
* Global Functions                    ȫֺ
***************************************************************************/
/* עؼ*/
ZBOOL RegisterTouchIconControl (ZVOID);

/* ؼ*/
ZSINT32 TouchIconCtrlProc (HWND hWnd, ZSINT32 message, WPARAM wParam, LPARAM lParam);

#ifdef __cplusplus
}
#endif  /* __cplusplus */

#endif /* _ZCORE_CTRL_TOUCHICON_H_ */

