#ifndef _ZCORE_GUI_CURSOR_H
#define _ZCORE_GUI_CURSOR_H
#include "zcore_type.h"
/* Struct definitions */
typedef struct _CURSORDIRENTRY {
    ZUINT8 bWidth;
    ZUINT8 bHeight;
    ZUINT8 bColorCount;
    ZUINT8 bReserved;
    ZUINT16 wXhotspot;
    ZUINT16 wYhotspot;
    DWORD lBytesInRes;
    DWORD dwImageOffset;
}CURSORDIRENTRY;

typedef struct _CURSORDIR {
    ZUINT16 cdReserved;
    ZUINT16 cdType;	// must be 2.
    ZUINT16 cdCount;
}CURSORDIR;

typedef struct _CURSOR {
    ZSINT32 xhotspot;
    ZSINT32 yhotspot;
    ZSINT32 width;
    ZSINT32 height;
    ZVOID* AndBits;
    ZVOID* XorBits;
}CURSOR;
typedef CURSOR* PCURSOR;

#define CURSORWIDTH	    32
#define CURSORHEIGHT	32
#define MONOSIZE	    (CURSORWIDTH*CURSORHEIGHT/8)
#define MONOPITCH       4

/* Function definitions */
#ifdef __cplusplus
extern "C" {
#endif  /* __cplusplus */

#ifdef _CURSOR_SUPPORT

/* Initialization and termination. */
ZBOOL InitCursor (ZVOID);
ZVOID TerminateCursor(ZVOID);

#ifdef _LITE_VERSION
/* show cursor hidden by client GDI function */
ZVOID ReShowCursor (ZVOID);
#else
ZUINT8* GetPixelUnderCursor (ZSINT32 x, ZSINT32 y, gal_pixel* pixel);
#endif

#endif /* _CURSOR_SUPPORT */

ZVOID ShowCursorForGDI (ZBOOL fShow, const RECT* prc);

/* Mouse event helper. */
ZBOOL RefreshCursor (ZSINT32* x, ZSINT32* y, ZSINT32* button);

#ifdef __cplusplus
}
#endif  /* __cplusplus */

#endif /* _ZCORE_GUI_CURSOR_H */

