#ifndef _ZCORE_GDI_E_H_
#define _ZCORE_GDI_E_H_

#include "zcore_type.h"
#define		GDCAP_COLORNUM      0
#define		GDCAP_HPIXEL        1
#define		GDCAP_VPIXEL        2
#define		GDCAP_MAXX          3
#define		GDCAP_MAXY          4
#define		GDCAP_DEPTH         5
#define		GDCAP_BPP           6
#define GDCAP_BITSPP        7
#define GDCAP_RMASK         8
#define GDCAP_GMASK         9
#define GDCAP_BMASK         10

#define SetPenCapStyle(hdc, style)          \
            (PTCapStyle) SetDCAttr (hdc, DC_ATTR_PEN_CAP_STYLE, (ZDWORD) style)

#define GetPenJoinStyle(hdc)           (PTJoinStyle) GetDCAttr (hdc, DC_ATTR_PEN_JOIN_STYLE)

#define SetPenJoinStyle(hdc, style)         \
            (PTJoinStyle) SetDCAttr (hdc, DC_ATTR_PEN_JOIN_STYLE, (ZDWORD) style)
            
#define MM_TEXT               0
#define MM_ANISOTROPIC        1

#define BM_TRANSPARENT          1
#define BM_OPAQUE               0

#define SetTextAboveLineExtra(hdc, extra)       \
                (ZSINT32)SetDCAttr (hdc, DC_ATTR_ALINE_EXTRA, (ZDWORD) extra)

#define SetTextBellowLineExtra(hdc, extra)      \
                (ZSINT32)SetDCAttr (hdc, DC_ATTR_BLINE_EXTRA, (ZDWORD) extra)
                
#define		dc_HDC2PDC(hdc)		HDCTOPDC((HDC) hdc)

#define STATE_SUCCESS		1
#define STATE_FAIL			0
/*****************************************ṹ嶨***************************************/

#ifndef _HAVE_TYPE_ZUINT32
#define _HAVE_TYPE_ZUINT32
typedef unsigned	int 	ZUINT32;
#endif

typedef ZUINT32   		Pixel;

#ifndef _TYPE_GAL_UINT8
#define _TYPE_GAL_UINT8
typedef ZUINT8       gal_uint8;
#endif

typedef ZUINT32		STATE;


/******************************************궨************************************/

#define 	PIXTP_PALETTE   		1    /* ص */
#define 	PIXTP_TRUECOLOR332   	2    /* ص */
#define 	PIXTP_TRUECOLOR565   	3    /* ص */
#define 	PIXTP_TRUECOLOR888   	4    /* ص */
#define 	PIXTP_TRUECOLOR0888   	5    /* ص */

#define 	CLIP_VISIBLE        	1
#define 	CLIP_INVISIBLE      	2
#define 	CLIP_PARTIAL        	3




#define RGB565MASK_R                0xf800
#define RGB565MASK_G                0x07e0
#define RGB565MASK_B                0x001f

#define 	RGBTOPIXEL565_M(r,g,b)    \
		(((unsigned short)(r) << 8) & RGB565MASK_R)		\
		| (((unsigned short)(g) << 3) & RGB565MASK_G)	\
		|( ((unsigned short)(b) >> 3) & RGB565MASK_B)
                                  

/****************************************************************************/
/********************************************************************************/


extern 	Pixel 			  SysPixelIndex[17];	
#define PIXEL_invalid       0
#define Pix_Invalid       0

#define Pix_Transparent   SysPixelIndex[0]
#define Pix_DarkBlue      SysPixelIndex[1]
#define Pix_DarkGreen     SysPixelIndex[2]
#define Pix_DarkCyan      SysPixelIndex[3]
#define Pix_DarkRed       SysPixelIndex[4] 
#define Pix_DarkMagenta   SysPixelIndex[5]
#define Pix_DarkYellow    SysPixelIndex[6] 
#define Pix_DarkGray      SysPixelIndex[7] 
#define Pix_LightGray     SysPixelIndex[8]
#define Pix_Blue          SysPixelIndex[9]
#define Pix_Green         SysPixelIndex[10]
#define Pix_Cyan          SysPixelIndex[11]
#define Pix_Red           SysPixelIndex[12]
#define Pix_Magenta       SysPixelIndex[13]
#define Pix_Yellow        SysPixelIndex[14]
#define Pix_LightWhite    SysPixelIndex[15]
#define Pix_Black         SysPixelIndex[16]

#define PIXEL_lightgray		Pix_LightGray
#define PIXEL_black			Pix_Black
#define PIXEL_lightwhite		Pix_LightWhite
#define PIXEL_transparent Pix_Transparent   
#define PIXEL_darkblue   Pix_DarkBlue      
#define PIXEL_darkgreen Pix_DarkGreen     
#define PIXEL_darkcyan Pix_DarkCyan      
#define PIXEL_darkred Pix_DarkRed       
#define PIXEL_darkmagenta Pix_DarkMagenta   
#define PIXEL_darkyellow Pix_DarkYellow   
#define PIXEL_darkgray Pix_DarkGray      
#define PIXEL_lightgray Pix_LightGray    
#define PIXEL_blue Pix_Blue          
#define PIXEL_green Pix_Green       
#define PIXEL_cyan Pix_Cyan          
#define PIXEL_red Pix_Red           
#define PIXEL_magenta Pix_Magenta     
#define PIXEL_yellow Pix_Yellow       
#define PIXEL_lightwhite Pix_LightWhite    
#define PIXEL_balck Pix_Black    

#endif//#ifndef _ZCORE_GDI_E_H_
