#ifndef _ZCORE_CONTROL_H
#define _ZCORE_CONTROL_H
/**
     * \defgroup class_fns Window class operations
     * @{
     */
#include "zcore_type.h"
#define MAINWINCLASSNAME ("MAINWINDOW")
#define COP_STYLE           0x0001
#define COP_HCURSOR         0x0002
#define COP_BKCOLOR         0x0004
#define COP_WINPROC         0x0008
#define COP_ADDDATA         0x0010

typedef struct _WNDCLASS
{
    /** the class name */
    ZCHAR*   spClassName;
    /*internal field, operation type*/
    ZDWORD   opMask;
    /*window style for all instances of this window class*/
    ZDWORD   dwStyle;
    /*extended window style for all instances of this window class*/
    ZDWORD   dwExStyle;
    /*cursor handle to all instances of this window class*/
    HCURSOR hCursor;
    /*background color pixel value of all instances of this window class*/
    ZSINT32     iBkColor;
    /*window callback procedure of all instances of this window class*/
    ZSINT32     (*WinProc) (HWND, ZSINT32, WPARAM, LPARAM);
    /*the private additional data associated with this window class*/
    ZDWORD dwAddData;
} WNDCLASS;
typedef WNDCLASS* PWNDCLASS;

/*Registers a window class.*/
ZBOOL RegisterWindowClass (PWNDCLASS pWndClass);

/*Undoes the effect of \a RegisterWindowClass.*/
ZBOOL UnregisterWindowClass (const ZCHAR* szClassName);

/*Retrieves the name of the class to which the specified window belongs.*/
const ZCHAR* GetClassName (HWND hWnd);

/*Retrieves the information of the specified window class.*/
ZBOOL GetWindowClassInfo (PWNDCLASS pWndClass);

/*Sets the information of the specified window class.*/
ZBOOL SetWindowClassInfo (const WNDCLASS* pWndClass);

/*Creates a child window with extended style.*/
HWND CreateWindowEx (const ZCHAR* spClassName,
                     const ZCHAR* spCaption,
                     ZDWORD dwStyle,
                     ZDWORD dwExStyle,
                     ZSINT32 id,
                     ZSINT32 x,
                     ZSINT32 y,
                     ZSINT32 w,
                     ZSINT32 h,
                     HWND hParentWnd,
                     ZDWORD dwAddData);

#define CreateWindow(class_name, caption, style,        \
                id, x, y, w, h, parent, add_data)       \
        CreateWindowEx(class_name, caption, style, 0,   \
                        id, x, y, w, h, parent, add_data)

/*Destroys a specified control.*/
ZBOOL DestroyWindow (HWND hWnd);

/*Type of the notification callback procedure.*/
#ifndef _TYPE_NOTIFPROC
#define _TYPE_NOTIFPROC
typedef ZVOID (* NOTIFPROC) (HWND hwnd, ZSINT32 id, ZSINT32 nc, ZDWORD add_data);
#endif

/*Sets a new notification callback procedure for a control.*/
NOTIFPROC SetNotificationCallback (HWND hwnd, NOTIFPROC notif_proc);

/*Gets the notification callback procedure of a control.*/
NOTIFPROC GetNotificationCallback (HWND hwnd);

#endif//_ZCORE_CONTROL_H
