#ifndef _ZCORE_GAL_H
#define _ZCORE_GAL_H
#include "zcore_type.h"
/*******************************ṹ嶨*******************************/
typedef struct _T_GAL_GFX
{  
    PGC  	ptGALphygc;
    ZSINT32     iBytes_per_phypixel;
    ZSINT32     iBits_per_phypixel;
    ZSINT32     iWidth_phygc;
    ZSINT32     iHeight_phygc;
    ZSINT32     iColors_phygc;
    ZBOOL    HorizonScreenMode;
    ZSINT32     (*GAL_GetBytesPerPixel) (PGC tDCMgtGc);
    ZSINT32     (*GAL_GetBitsPerPixel) (PGC tDCMgtGc);
    ZSINT32     (*GAL_ScreenWidth) (PGC tDCMgtGc);
    ZSINT32     (*GAL_ScreenHeight) (PGC tDCMgtGc);
    ZSINT32     (*GAL_ScreenColors) (PGC tDCMgtGc);

    ZBOOL 	(*GAL_AllocateGc)(PGC gc, ZSINT32 iWidth, ZSINT32 iHeight, ZSINT32 iDepth, PGC* newgc);
    ZBOOL    (*GAL_FreeGc)(PGC gc);

    ZBOOL    (*GAL_LineTo)(PGC gc, ZSINT32 x1, ZSINT32 y1, ZSINT32 x2, ZSINT32 y2, gal_pixel pixel);
    ZBOOL	(*GAL_SetClipping) (PGC tDCMgtGc, ZSINT32 iMinX, ZSINT32 iMinY, ZSINT32 iMaxX, ZSINT32 iMaxY);
    ZBOOL	(*GAL_GetClipping) (PGC tDCMgtGc, ZSINT32 *ipMinX, ZSINT32 *ipMinY, ZSINT32 *ipMaxX, ZSINT32 *ipMaxY);
    ZBOOL	(*GAL_EnableClipping) (PGC tDCMgtGc);
    ZBOOL	(*GAL_DisableClipping) (PGC tDCMgtGc);
    
    ZBOOL	(*GAL_GetBgColor) (PGC tDCMgtGc, Pixel *pixColor);
    ZBOOL	(*GAL_SetBgColor) (PGC tDCMgtGc, Pixel pixColor);
    ZBOOL	(*GAL_GetFgColor) (PGC tDCMgtGc, Pixel *pixColor);
    ZBOOL	(*GAL_SetFgColor) (PGC tDCMgtGc, Pixel pixColor);

    Pixel 	(*GAL_RGBToPixel) (PGC tDCMgtGc, RGB *cColor);
    ZBOOL	(*GAL_PixelToRGB) (PGC tDCMgtGc, Pixel pixColor, RGB *cColor);

    size_t  (*GAL_GetBoxSize) (PGC tDCMgtGc, ZSINT32 iWidth, ZSINT32 iHeight);
    ZBOOL	(*GAL_FillBox) (PGC tDCMgtGc, ZSINT32 iStartX, ZSINT32 iStartY, ZSINT32 iWidth, ZSINT32 iHeight, Pixel pixColor);
    ZBOOL	(*GAL_PutBox) (PGC tDCMgtGc, ZSINT32 iStartX, ZSINT32 iStartY, ZSINT32 iWidth, ZSINT32 iHeight, ZVOID *vpBuf, ZSINT32 vpBufPitch);
    ZBOOL    (*GAL_PutBoxPart) (PGC tDCMgtGc, ZSINT32 iStartX, ZSINT32 iStartY, ZSINT32 iWidth, ZSINT32 iHeight, ZVOID *vpBuf, ZSINT32 vpBufPitch,ZSINT32 iX,ZSINT32 iY);
    ZBOOL	(*GAL_GetBox) (PGC tDCMgtGc, ZSINT32 iStartX, ZSINT32 iStartY, ZSINT32 iWidth, ZSINT32 iHeight, ZVOID *vpBuf, ZSINT32 vpBufPitch);
    ZBOOL	(*GAL_PutBoxMask) (PGC tDCMgtGc, ZSINT32 iStartX, ZSINT32 iStartY, ZSINT32 iWidth, ZSINT32 iHeight, ZVOID *vpBuf, ZSINT32 vpBufPitch, Pixel pixColor);
    ZBOOL    (*GAL_PutBoxPartMask) (PGC tDCMgtGc, ZSINT32 iStartX, ZSINT32 iStartY, ZSINT32 iWidth, ZSINT32 iHeight, ZVOID *vpBuf, ZSINT32 vpBufPitch, Pixel pixColor,ZSINT32 iX,ZSINT32 iY);
    ZBOOL	(*GAL_CopyBox) (PGC tDCMgtGc, ZSINT32 iSrcX, ZSINT32 iSrcY, ZSINT32 iWidth, ZSINT32 iHeight, ZSINT32 iDstX, ZSINT32 iDstY); 
    ZBOOL	(*GAL_DrawHLine) (PGC tDCMgtGc, ZSINT32 iStartX, ZSINT32 iStartY, ZSINT32 iWidth, Pixel pixColor);
    ZBOOL	(*GAL_DrawVLine) (PGC tDCMgtGc, ZSINT32 iStartX, ZSINT32 iStartY, ZSINT32 iHeight, Pixel pixColor);
    ZBOOL	(*GAL_DrawPixel) (PGC tDCMgtGc, ZSINT32 iStartX, ZSINT32 iStartY, Pixel pixColor);
    ZBOOL	(*GAL_GetPixel) (PGC tDCMgtGc, ZSINT32 iStartX, ZSINT32 iStartY, Pixel *pixColor);  
    ZBOOL	(*GAL_Rectangle) (PGC tDCMgtGc, ZSINT32 iLeft, ZSINT32 iTop, ZSINT32 iRight, ZSINT32 iBottom, Pixel pixColor);
} T_GAL_GFX;
extern 	T_GAL_GFX			*g_tGALgfx;	
/***********************************ԭ*******************************/

extern 	ZBOOL  	GAL_InitGfx (ZVOID);
extern 	Pixel 	GAL_RGBToPixel (PGC tDCMgtGc, RGB *cColor);
extern	ZBOOL 	GAL_PixelToRGB(PGC tDCMgtGc, Pixel pixColor, RGB *cColor);
extern	ZSINT32 	GAL_GetBytesPerPixel (PGC tDCMgtGc); 
extern	ZSINT32 	GAL_GetBitsPerPixel (PGC tDCMgtGc);
extern	ZSINT32 	GAL_ScreenWidth (PGC tDCMgtGc);
extern	ZSINT32 	GAL_ScreenHeight (PGC tDCMgtGc);
extern	ZSINT32 	GAL_ScreenColors (PGC tDCMgtGc);
extern	ZBOOL 	GAL_AllocateGc(PGC gc, ZSINT32 iWidth, ZSINT32 iHeight, ZSINT32 iDepth, PGC* newgc);
extern	ZBOOL 	GAL_FreeGc(PGC gc);
extern	ZBOOL    GAL_LineTo(PGC gc, ZSINT32 x1, ZSINT32 y1, ZSINT32 x2, ZSINT32 y2, gal_pixel pixel);
extern	ZBOOL 	GAL_SetClipping (PGC tDCMgtGc, ZSINT32 iMinX, ZSINT32 iMinY, ZSINT32 iMaxX, ZSINT32 iMaxY);   
extern	ZBOOL 	GAL_GetClipping(PGC tDCMgtGc, ZSINT32 *ipMinX, ZSINT32 *ipMinY, ZSINT32 *ipMaxX, ZSINT32 *ipMaxY);
extern	ZBOOL 	GAL_EnableClipping(PGC tDCMgtGc);
extern	ZBOOL 	GAL_DisableClipping(PGC tDCMgtGc);
extern	ZBOOL 	GAL_GetBgColor(PGC tDCMgtGc, Pixel *pixColor);
extern	ZBOOL 	GAL_SetBgColor(PGC tDCMgtGc, Pixel pixColor);
extern	ZBOOL 	GAL_GetFgColor(PGC tDCMgtGc, Pixel *pixColor);
extern	ZBOOL 	GAL_SetFgColor(PGC tDCMgtGc, Pixel pixColor);
extern	size_t 	GAL_GetBoxSize (PGC tDCMgtGc, ZSINT32 iWidth, ZSINT32 iHeight);
extern	ZBOOL 	GAL_FillBox(PGC tDCMgtGc, ZSINT32 iStartX, ZSINT32 iStartY, ZSINT32 iWidth, ZSINT32 iHeight, Pixel pixColor);
extern	ZBOOL 	GAL_PutBox (PGC tDCMgtGc, ZSINT32 iStartX, ZSINT32 iStartY, ZSINT32 iWidth, ZSINT32 iHeight, ZVOID *vpBuf, ZSINT32 vpBufPitch);
extern	ZBOOL 	GAL_GetBox (PGC tDCMgtGc, ZSINT32 iStartX, ZSINT32 iStartY, ZSINT32 iWidth, ZSINT32 iHeight, ZVOID *vpBuf, ZSINT32 vpBufPitch);
extern	ZBOOL 	GAL_PutBoxMask (PGC tDCMgtGc, ZSINT32 iStartX, ZSINT32 iStartY, ZSINT32 iWidth, ZSINT32 iHeight, ZVOID *vpBuf, ZSINT32 vpBufPitch, Pixel pixColor);
extern	ZBOOL 	GAL_CopyBox (PGC tDCMgtGc, ZSINT32 iSrcX, ZSINT32 iSrcY, ZSINT32 iWidth, ZSINT32 iHeight, ZSINT32 iDstX, ZSINT32 iDstY);
extern	ZBOOL 	GAL_DrawHLine (PGC tDCMgtGc, ZSINT32 iStartX, ZSINT32 iStartY, ZSINT32 iWidth, Pixel pixColor);
extern	ZBOOL 	GAL_DrawVLine (PGC tDCMgtGc, ZSINT32 iStartX, ZSINT32 iStartY, ZSINT32 iHeight, Pixel pixColor);
extern	ZBOOL 	GAL_DrawPixel (PGC tDCMgtGc, ZSINT32 iStartX, ZSINT32 iStartY, Pixel pixColor);
extern	ZBOOL 	GAL_GetPixel (PGC tDCMgtGc, ZSINT32 iStartX, ZSINT32 iStartY, Pixel *pixColor);
extern	ZBOOL    GAL_Rectangle (PGC tDCMgtGc, ZSINT32 iLeft, ZSINT32 iTop, ZSINT32 iRight, ZSINT32 iBottom, Pixel pixColor);
extern	ZBOOL 	GAL_UpdateScreen (HDC	hdc);
extern	ZBOOL  	GAL_PutBoxPart(PGC tDCMgtGc, ZSINT32 iStartX, ZSINT32 iStartY, ZSINT32 iWidth, ZSINT32 iHeight, ZVOID *vpBuf, ZSINT32 vpBufPitch,ZSINT32 iX,ZSINT32 iY);
extern	ZBOOL  	GAL_PutBoxPartMask(PGC tDCMgtGc, ZSINT32 iStartX, ZSINT32 iStartY, ZSINT32 iWidth, ZSINT32 iHeight, ZVOID *vpBuf, ZSINT32 vpBufPitch, Pixel pixColor,ZSINT32 iX,ZSINT32 iY);
extern	gal_pixel GetSysPixelIndex (ZSINT32 index);
extern ZBOOL GAL_BitBiltColorKey(PGC src, ZSINT32 sx, ZSINT32 sy, ZSINT32 w, ZSINT32 h, PGC dst, ZSINT32 dx, ZSINT32 dy,ZDWORD dwColorKey,RGB* ptPal);
extern ZBOOL GAL_BitBiltAlpha (PGC src, ZSINT32 sx, ZSINT32 sy, ZSINT32 w, ZSINT32 h, PGC dst, ZSINT32 dx, ZSINT32 dy,ZBYTE bAlpha);
extern ZBOOL GAL_BitBilt (PGC src, ZSINT32 sx, ZSINT32 sy, ZSINT32 w, ZSINT32 h, PGC dst, ZSINT32 dx, ZSINT32 dy);

/*********************************************************궨***************************************************/
#define PHYSICALGC              (g_tGALgfx->ptGALphygc)
#define BYTESPERPHYPIXEL        (g_tGALgfx->iBytes_per_phypixel)
#define BITSPERPHYPIXEL         (g_tGALgfx->iBits_per_phypixel)
#define WIDTHOFPHYGC            (g_tGALgfx->iWidth_phygc)
#define HEIGHTOFPHYGC           (g_tGALgfx->iHeight_phygc)
#define COLORSOFPHYGC           (g_tGALgfx->iColors_phygc)
#define PHYSICALVPDATA          (g_tGALgfx->ptGALphygc->tSDevInfo->vpData)
#define LENGHTPHYGCBUFF         ((g_tGALgfx->iHeight_phygc)*(g_tGALgfx->iWidth_phygc)*(g_tGALgfx->iBytes_per_phypixel))

#endif
